       SUBROUTINE W3FB00(ALAT,ALONG,XMESHL,XI,XJ)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FB00         LATITUDE, LONGITUDE TO I,J
C   AUTHOR: HEERMANN,A.      ORG: W345       DATE: 69-08-01
C
C ABSTRACT: CONVERTS THE COORDINATES OF A LOCATION ON EARTH FROM THE
C   NATURAL COORDINATE SYSTEM OF LATITUDE/LONGITUDE TO THE GRID (I,J)
C   COORDINATE SYSTEM OVERLAID ON THE POLAR STEREOGRAPHIC MAP PRO-
C   JECTION TRUE AT 60 N. A PREFERABLE, MORE FLEXIBLE SUBROUTINE TO
C   USE IS W3FB04. W3FB00 IS THE REVERSE OF W3FB01.
C
C PROGRAM HISTORY LOG:
C   69-08-01  A. HEERMANN
C   90-08-31  R.E.JONES     CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FB00 (ALAT, ALONG, XMESHL, XI, XJ)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     ALAT   ARG LIST  LATITUDE IN DEG.  (-20.0(S. HEMIS) ) ALAT ) 90.0)
C     ALONG            WEST LONGITUDE IN DEGREES
C     XMESHL ARG LIST  MESH LENGTH OF GRID IN KILOMETERS AT 60N
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     XI     ARG LIST  I OF THE POINT RELATIVE TO NORTH POLE
C     XJ     ARG LIST  J OF THE POINT RELATIVE TO NORTH POLE
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     COS SIN                                                 SYSLIB
C
C   REMARKS: THE GRID USED IN THIS SUBROUTINE HAS ITS ORIGIN (I=0,J=0)
C     AT THE NORTH POLE, SO IF THE USER'S GRID HAS ITS ORIGIN AT A
C     POINT OTHER THAN THE NORTH POLE, A TRANSLATION IS REQUIRED TO
C     GET I AND J. THE SUBROUTINE GRID IS ORIENTED SO THAT LONGITUDE
C     80W IS PARALLEL TO THE GRIDLINES OF I=CONSTANT. THE RADIUS OF
C     THE EARTH IS TAKEN TO BE 6371.2 KM.
C     ALL PARAMETERS IN THE CALL STATEMENT MUST BE REAL
C     THIS CODE WILL NOT VECTORIZE ON A CRAY. YOU WILL HAVE PUT
C     IT LINE TO VECTORIZE IT.
C
C ATTRIBUTES:
C   LANGUAGE: IBM370 VS FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
      DATA  RADPD /.01745329/
      DATA  EARTHR/6371.2/
C
      RE    = (EARTHR * 1.86603) / XMESHL
      XLAT  = ALAT * RADPD
      SINL  = SIN(XLAT)
      WLONG = (ALONG + 100.0) * RADPD
      R     = (RE * COS(XLAT)) / (1. + SINL)
      XI    = R * SIN(WLONG)
      XJ    = R * COS(WLONG)
      RETURN
      END
