       SUBROUTINE W3FB02(ALAT, ALONG, XMESHL, XI, XJ)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FB02         CONVERT S. HEMISPHERE LAT/LON TO I AND J
C   AUTHOR: JONES,R.E.       ORG: W342       DATE: 85-09-13
C
C ABSTRACT: COMPUTES I AND J COORDINATES FOR A LATITUDE/LONGITUDE
C   POINT ON THE SOUTHERN HEMISPHERE POLAR STEREOGRAPHIC MAP
C   PROJECTION.
C
C PROGRAM HISTORY LOG:
C   85-09-13  R.E.JONES   CONVERT TO FORTRAN 77
C   90-08-31  R.E.JONES   CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FB02 (ALAT, ALONG, XMESHL, XI, XJ)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     ALAT   ARG LIST  REAL*4 LATITUDE (S.H. LATITUDES ARE NEGATIVE)
C     ALONG  ARG LIST  REAL*4 WEST LONGITUDE
C     XMESHL ARG LIST  REAL*4 GRID INTERVAL IN KM.
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     XI     ARG LIST  REAL*4 I COORDINATE
C     XJ     ARG LIST  REAL*4 J COORDINATE
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     COS  SIN                                                SYSLIB
C
C
C   EXIT STATES: *
C
C   EXTERNAL REFERENCES: NONE
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
C     ...GIVEN ... ALAT   SRN HEMI LATS ARE NEGATIVE VALUED
C                  ALONG   IN DEGREES  WEST LONGITUDE
C                  XMESHL= GRID INTERVAL IN KM,  E.G., 381.0 KM
C     ...TO COMPUTE XI,XJ FOR A PT ON THE SRN HEMI POLAR STEREOGRAPHIC
C     ...   PROJECTION, WITH 80W LONGITUDE VERTICAL AT THE TOP OF  MAP,
C     ...   AND 100E LONGITUDE VERTICAL AT THE BOTTOM OF THE MAP.
C     ...THE RESULTING XI AND XJ ARE RELATIVE TO  (0,0) AT SOUTH POLE.
C
       DATA  ADDLNG/80.0/
C
C     ...WHICH IS DIFFERENCE BETWEEN 180 DEGREES AND VERTICAL MERIDIAN.
C     ...   THE VERTICAL BEING 100 WEST AFTER CHANGING THE SENSE
C
       DATA  TINY  /0.00001/
       DATA  EARTHR/6371.2/
       DATA  CONVT /0.017453293/
C
C     ...WHICH CONVERTS DEGREES TO RADIANS
C
      RE   = (EARTHR * 1.86603) / XMESHL
C
C     ...WHICH IS DISTANCE IN GRID INTERVALS FROM POLE TO  EQUATOR
C
      XLAT = -ALAT * CONVT
C
C     ...WHERE NEGATIVE ALATS WERE GIVEN FOR SRN HEMI
C
      WLONG = 360.0 - ALONG
      WLONG = (WLONG + ADDLNG) * CONVT
      R     = (RE * COS(XLAT))/(1.0 + SIN(XLAT))
      XI    = R * SIN(WLONG)
      IF (ABS(XI) .LT. TINY) XI = 0.0
      XJ    = R * COS (WLONG)
      IF (ABS(XJ) .LT. TINY) XJ = 0.0
      RETURN
      END
