       SUBROUTINE W3FB03(XI, XJ, XMESHL, TLAT, TLONG)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FB03         CONVERT I,J GRID COORDINATES TO LAT/LON
C   AUTHOR: JONES,R.E.       ORG: W342       DATE: 86-07-17
C
C ABSTRACT: CONVERTS I,J GRID COORDINATES TO THE CORRESPONDING
C   LATITUDE/LONGITUDE ON A SOUTHERN HEMISPHERE POLAR STEREOGRAPHIC
C   MAP PROJECTION.
C
C PROGRAM HISTORY LOG.
C   86-07-17  R.E.JONES   CONVERT TO FORTRAN 77
C   90-08-31  R.E.JONES   CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FBO3 (XI, XJ, XMESHL, TLAT, TLONG)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     XI     ARG LIST  REAL I COORDINATE
C     XJ     ARG LIST  REAL J COORDINATE
C     XMESHL ARG LIST  REAL GRID INTERVAL IN KM.
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     TLAT   ARG LIST  REAL  S.H. LATITUDE
C     TLONG  ARG LIST  REAL  LONGITUDE
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     ASIN  ATAN2                                             SYSLIB
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
C     ...GIVEN ... XI/XJ GRID COORDINATES OF A POINT RELATIVE
C     ...        TO (0,0) AT SOUTH POLE
C     ...TO COMPUTE TLAT,TLONG ON THE SRN HEMI POLAR STEREO PROJECTION
C     ...WITH 80W VERTICAL AT TOP OF THE MAP
C
       DATA  DEGPRD/57.2957795/
       DATA  EARTHR/6371.2/
C
      RE  = (EARTHR * 1.86603) / XMESHL
      GI2 = RE * RE
C
C     ...WHERE GI2 IS THE SQUARE OF DISTANCE IN GRID INTERVALS
C     ...   FROM POLE TO EQUATOR...
C
      R2 = XI * XI + XJ * XJ
      IF (R2 .NE. 0.0) THEN
C
      XLONG = DEGPRD * ATAN2(XJ,XI)
      TLONG = XLONG - 10.0
      IF (TLONG .LT. 0.0) TLONG = TLONG + 360.0
      TLAT  = ASIN((GI2 - R2)/(GI2 + R2)) * DEGPRD
      TLAT  = -TLAT
C
      ELSE
      TLAT = -90.0
C
C     ...FOR SOUTH POLE...
C
      TLONG = 0.0
      ENDIF
C
      RETURN
      END
