      SUBROUTINE W3FI03(IN,IDEST,NUM,IER)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    W3FI03      TRANSFERS DEFAULT INTEGERS TO 16 BIT INTS
C   PRGMMR: KEYSER           ORG: W/NMC22    DATE: 06-29-92
C
C ABSTRACT: TRANSFERS AN ARRAY OF NUMBERS FROM DEFAULT INTEGER 
C   WORDS TO 16 BIT (IBM INTEGER*2) IBM HALF-WORDS.
C
C PROGRAM HISTORY LOG:
C   92-06-29  D. A. KEYSER (W/NMC22)
C   98-11-17  Gilbert       Removed Cray references
C
C USAGE:    CALL W3FI03(IN,IDEST,NUM,IER)
C   INPUT ARGUMENT LIST:
C     IN       - STARTING ADDRESS FOR ARRAY OF DEFAULT INTEGERS
C     NUM      - NUMBER OF NUMBERS IN 'IN' TO TRANSFER.
C
C   OUTPUT ARGUMENT LIST:      (INCLUDING WORK ARRAYS)
C     IDEST    - STARTING ADDRESS FOR ARRAY OF 16 BIT IBM HALF-WORDS
C     IER      - ERROR RETURN CODE AS FOLLOWS:
C                  IER = 0 - TRANSFER SUCCESSFUL, ALL NUMBERS
C                          - TRANSFERRED WITHOUT OVERFLOW
C                  IER = 1 - THE TRANSFER OF ONE OR MORE NUMBERS
C                          - RESULTED IN AN OVERFLOW
C
C   SUBPROGRAMS CALLED:
C     LIBRARY:
C       NONE
C
C REMARKS: THIS IS THE INVERSE OF LIBRARY ROUTINE W3FI02.
C
C ATTRIBUTES:
C   LANGUAGE: IBM XL FORTRAN
C   MACHINE:  IBM SP
C
C$$$
C
      INTEGER(2)  IDEST(*)
      INTEGER  IN(*)
C
      SAVE
C
C      CALL USICTI(IN,IDEST,1,NUM,2,IER)
      IDEST(1:NUM)=IN(1:NUM)
C
      RETURN
      END
