      SUBROUTINE W3FI18(I,J,NW)
C$$$  SUBROUTINE DOCUMENTATION BLOCK ***
C
C SUBR: W3FI18   - NMC OCTAGON BOUNDARY FINDING SUBROUTINE
C   AUTHOR: HOWCROFT, J.       ORG: W342          DATE:    OCT 73
C   UPDATE: JONES, R.E.        ORG: W342          DATE: 02 JUL 84
C
C ABSTRACT: RELATES THE I,J COORDINATE POINT IN A 65X65 GRID-POINT
C   ARRAY AS BEING EITHER INSIDE, OUTSIDE, OR ON THE BOUNDARY OF THE
C   NMC OCTAGON CENTERED IN THE 65X65 ARRAY.
C
C PROGRAM HISTORY LOG:
C   73-10-15  HOWCROFT,J.
C   84-07-02  R.E.JONES    CONVERT TO FORTRAN 77
C   89-02-02  R.E.JONES    CONVERT TO MICROSOFT FORTRAN 4.10
C   90-06-12  R.E.JONES    CONVERT TO SUN FORTRAN 1.3
C   91-03-16  R.E.JONES    CONVERT TO SiliconGraphics 3.3 FORTRAN 77
C   93-03-29  R.E.JONES    ADD SAVE STATEMENT
C
C USAGE: CALL W3FI18 (I, J, NW)
C
C   INPUT:
C     ' I' - COORDINATE IDENTIFICATION OF A POINT IN THE 65X65 ARRAY
C     ' J' - COORDINATE IDENTIFICATION OF A POINT IN THE 65X65 ARRAY
C   OUTPUT:
C     'NW' - INTEGER RETURN CODE
C
C   EXIT STATES:
C     NW = -1 POINT IS OUTSIDE THE OCTAGON
C     NW =  0 POINT IS ON THE OCTAGON BOUNDARY
C     NW = +1 POINT IS INSIDE THE OCTAGON
C
C   EXTERNAL REFERENCES: NONE
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/256, J916/2048.
C
C$$$
C
      SAVE
C
      K = I + J
      M = I - J
      IF (I.LT.10.OR.I.GT.56.OR.J.LT.8.OR.J.GT.58)    GO TO 10
      IF (K.LT.32.OR.K.GT.100.OR.M.LT.-34.OR.M.GT.34) GO TO 10
      IF (I.EQ.10.OR.I.EQ.56.OR.J.EQ.8.OR.J.EQ.58)    GO TO 20
      IF (K.EQ.32.OR.K.EQ.100.OR.M.EQ.-34.OR.M.EQ.34) GO TO 20
      NW = 1
      RETURN
C
   10 CONTINUE
      NW = -1
      RETURN
C
   20 CONTINUE
      NW = 0
      RETURN
      END
