      SUBROUTINE W3FI19(I,J,NW)
C$$$  SUBROUTINE DOCUMENTATION BLOCK ***
C
C SUBR: W3FI19   - NMC RECTANGLE BOUNDARY FINDING SUBROUTINE
C   AUTHOR: HOWCROFT, J.       ORG: W342          DATE:    OCT 83
C   UPDATE: JONES, R.E.        ORG: W342          DATE: 02 JUL 84
C
C ABSTRACT: RELATES THE I,J COORDINATE POINT IN A 65X65 GRID-POINT
C   ARRAY AS BEING EITHER INSIDE, OUTSIDE, OR ON THE BOUNDARY OF THE
C   53X57 NMC RECTANGLE CENTERED IN THE 65X65 ARRAY.
C
C PROGRAM HISTORY LOG:
C   73-10-15  HOWCROFT,J.
C   84-07-02  R.E.JONES   CONVERT TO FORTRAN 77
C   89-02-02  R.E.JONES   CONVERT TO MICROSOFT FORTRAN 4.10
C   90-06-12  R.E.JONES   CONVERT TO SUN FORTRAN 1.3
C   91-03-16  R.E.JONES   CONVERT to SiliconGraphics 3.3 FORTRAN 77
C   93-03-29  R.E.JONES   ADD SAVE STATEMENT
C
C USAGE: CALL W3FI19 (I, J, NW)
C
C   INPUT:
C     ' I' - COORDINATE IDENTIFICATION OF A POINT IN THE 65X65 ARRAY
C     ' J' - COORDINATE IDENTIFICATION OF A POINT IN THE 65X65 ARRAY
C   OUTPUT:
C     'NW' - INTEGER RETURN CODE
C
C   EXIT STATES:
C     NW = -1 POINT IS OUTSIDE THE RECTANGLE
C     NW =  0 POINT IS ON THE RECTANGLE BOUNDARY
C     NW = +1 POINT IS INSIDE THE RECTANGLE
C
C   EXTERNAL REFERENCES: NONE
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/256, J916/2048.
C
C$$$
C
      SAVE
C
      IF (I.LT.7.OR.I.GT.59.OR.J.LT.5.OR.J.GT.61)  GO TO 10
      IF (I.EQ.7.OR.I.EQ.59.OR.J.EQ.5.OR.J.EQ.61)  GO TO 20
      NW = 1
      RETURN
C
   10 CONTINUE
      NW = -1
      RETURN
C
   20 CONTINUE
      NW = 0
      RETURN
      END
