       SUBROUTINE W3FI48(ILABEL,NLABEL)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FI48         CONVERT OFFICE NOTE 85 LABEL TO IBM
C   AUTHOR: JONES, R.E.      ORG: W342       DATE: 85-07-31
C
C ABSTRACT: CONVERTS OFFICE NOTE 85 LABEL FROM THE CRAY
C   FORMAT INTO A NAS-9050  LABEL. ALL ASCII CHARACTERS ARE
C   CONVERTED INTO EBCDIC CHARACTERS. BINARY OR CODED LABELS
C   CAN BE CONVERTED.
C
C PROGRAM HISTORY LOG:
C   85-07-31  R.E.JONES
C   89-10-24  R.E.JONES  CONVERT TO CRAY CFT77 FORTRAN
C   02-10-15  VUONG      REPLACED FUNCTION ICHAR WITH MOVA2I
C
C USAGE:  CALL W3FI48 (ILABEL, NLABEL)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     ILABEL ARG LIST  4 64 BIT WORDS OR 32 CHARACTERS
C                      CHARACTERS ARE IN ASCII OR BINARY.
C
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     NLABEL ARG LIST  4 64 BIT WORDS OR 32 CHARACTERS,
C                      CHARACTERS ARE IN EBCDIC OR BINARY.
C
C   REMARKS: SEE OFFICE NOTE 85.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
       CHARACTER*1    ILABEL(32)
       CHARACTER*1    NLABEL(32)
C
C          TEST FOR CODED LABEL, IF SO, CONVERT ALL CHARACTERS
C          TEST FOR ASCII C, 67 IN DECIMAL
C
           IF (MOVA2I(ILABEL(7)).EQ.67) THEN
C
             CALL AEA(ILABEL(1),NLABEL(1),-32)
C
           ELSE
C
C          BINARY LABEL, CONVERT BYTES 1-8, 21-30 TO EBCDIC
C
             CALL AEA (ILABEL(1),NLABEL(1),-8)
C
C          MOVE BYTES 9 TO 20
C
             DO 10 I = 9,20
               NLABEL(I) = ILABEL(I)
 10          CONTINUE
C
C          CONVERT WASHINGTON TO EBCDIC
C
             CALL AEA (ILABEL(21),NLABEL(21),-10)
C
C          TEST BYTES 31 AND 32 FOR BINARY ZERO, IF NOT ZERO
C          CONVERT TO ASCII
C
             IF (MOVA2I(ILABEL(31)).EQ.0) THEN
               NLABEL(31) = CHAR(0)
             ELSE
               CALL AEA(ILABEL(31),NLABEL(31),-1)
             ENDIF
C
             IF (MOVA2I(ILABEL(32)).EQ.0) THEN
               NLABEL(32) = CHAR(0)
             ELSE
               CALL AEA(ILABEL(32),NLABEL(32),-1)
             ENDIF
C
           ENDIF
C
         RETURN
       END
