! 10/11/2016  Hongli Jiang modified from the FIM driver for GFDRV.
!
MODULE module_cu_gf_driver
use physcons, g => con_g, cp => con_cp, xlv => con_hvap   &
     &,             r_v => con_rv
      use module_cu_gf_deep, only: cup_gf,neg_check,autoconv,aeroevap
      use module_cu_gf_sh,   only: cup_gf_sh

CONTAINS
!
! t2di is temp after advection, but before physics
! t = current temp (t2di + physics up to now)
!===================
!HJ: 10/11/16: tropics passed in, but not used.
!HJ: 10/11/16: ishal_cnv can be imfshacnv = 3
!HJ: 10/11/16: ipn is unique to FIM, defined locally
!HJ: dx is the dlength in gbphys, check with Georg!!
!HJ: 10/11/16: cactiv was defined locally, continue to define locally.
      SUBROUTINE gfdrv(tottracer,ntrac,garea,im,ix,km,DT, &
               forcet,forceq,phil,RAINCV,q,t,cld1d,       &
               us,vs,t2di,w,q2di,p2di,psuri,              &
               hbot,htop,kcnv,xland,hfx2,qfx2,clw,          &
               pbl,ud_mf,dd_mf,dt_mf,cnvw,cnvc,ishal_cnv)
!-------------------------------------------------------------
   IMPLICIT NONE
      integer, parameter :: maxiens=1
      integer, parameter :: maxens=1
      integer, parameter :: maxens2=1
      integer, parameter :: maxens3=16
      integer, parameter :: ensdim=16
      integer            :: ishallow_g3=1 ! depend on ishal_cnv
      integer, parameter :: imid_gf=0
      integer, parameter :: ideep=1
      integer, parameter :: ichoice=0 ! 0 2 5 13 8
      integer, parameter :: ichoicem=0	! 0 2 5 13
      integer, parameter :: ichoice_s=2	! 0 2 5 13
      real, parameter :: aodccn=0.1
      real :: dts,fpi,fp
      integer, parameter :: dicycle=0 ! diurnal cycle flag
      integer, parameter :: dicycle_m=0 !- diurnal cycle flag
!-------------------------------------------------------------
   INTEGER      :: its,ite, jts,jte, kts,kte
   INTEGER, INTENT(IN   ) :: im,IX,KM,ntrac,tottracer

   REAL,  DIMENSION( ix , km ),     INTENT(IN ) :: forcet,forceq,w,phil
   REAL,  DIMENSION( ix , km ),     INTENT(INOUT ) :: t,us,vs
! These arrays should be coming in, for now declare them local
!   REAL,  DIMENSION( ix ),     INTENT(IN ) :: rand_mom,rand_vmas
!   REAL,  DIMENSION( ix,4 ),     INTENT(IN ) :: rand_clos
   REAL,  DIMENSION( ix )   :: rand_mom,rand_vmas
   REAL,  DIMENSION( ix,4 ) :: rand_clos
!HJ   REAL,  DIMENSION( ix , km, 11 ), INTENT(INOUT ) :: gdc,gdc2
   REAL,  DIMENSION( ix , km, 11 ) :: gdc,gdc2
   REAL,  DIMENSION( ix , km ),     INTENT(INOUT ) :: cnvw,cnvc
   REAL,  DIMENSION( ix , km,tottracer+2 ), INTENT(INOUT ) :: clw

!HJ change from ix to im
   INTEGER, DIMENSION (im), INTENT(INOUT) :: hbot,htop,kcnv
   REAL,    DIMENSION (im), INTENT(IN) :: pbl,XLAND
! ruc variable
   REAL, dimension (im)  :: hfx2,qfx2,psuri
   REAL, dimension (im,km) :: ud_mf,dd_mf,dt_mf
   REAL, DIMENSION (im), INTENT(INOUT) :: RAINCV,cld1d
!HJ end change ix to im
   REAL, dimension (ix,km) :: t2di,p2di
   REAL, dimension (ix,km,ntrac) :: q2di,q
   REAL, DIMENSION( im ),INTENT(IN) :: garea
   REAL, INTENT(IN   ) :: DT
   integer, INTENT(IN   ) :: ishal_cnv
!HJ define locally for now.
!HJ   integer, INTENT(INOUT) :: cactiv(ix)
   integer :: cactiv(im)
!HJ change from ix to im
   INTEGER, DIMENSION(im) :: k22_shallow,kbcon_shallow,ktop_shallow
   REAL,    DIMENSION(im) :: ht
!HJ change
!
!+lxz
!HJ  REAL :: DX
   REAL,    DIMENSION(im) :: dx
! LOCAL VARS
!HJ change ix to im
     real, dimension (im,km) :: OUTT,OUTQ,OUTQC,phh,subm,cupclw,cupclws
     real, dimension (im,km) :: dhdt,zu,zus,zd,phf,zum,zdm,outum,outvm
     real, dimension (im,km) :: outts,outqs,outqcs,outu,outv,outus,outvs
     real, dimension (im,km) :: OUTTm,OUTQm,OUTQCm,submm,cupclwm
     real, dimension (im,km) :: cnvwt,cnvwts,cnvwtm
     real, dimension (im,km) :: hco,hcdo,zdo,hcom,hcdom,zdom
     real, dimension    (km) :: zh
     real, dimension (im)    :: tau_ecmwf,edt,edtm,ter11,aa0,xlandi
     real, dimension (im)    :: pret,prets,pretm,hexec
     real, dimension (im,10) :: forcing,forcing2
!+lxz
     integer, dimension (im) :: kbcon, ktop,ierr,ierrs,ierrm,kpbli
     integer, dimension (im) :: k22s,kbcons,ktops,k22,jmin,jminm
     integer, dimension (im) :: kbconm,ktopm,k22m
!HJ end change ix to im
!.lxz
     integer :: iens,ibeg,iend,jbeg,jend,n
     integer :: ibegh,iendh,jbegh,jendh
     integer :: ibegc,iendc,jbegc,jendc,kstop
     real :: rho_dryar,temp
     real :: PTEN,PQEN,PAPH,ZRHO,PAHFS,PQHFL,ZKHVFL,PGEOH
!HJ 10/11/2016: ipn is an input in FIM. set it to zero here.
     integer, parameter :: ipn = 0

!
! basic environmental input includes moisture convergence (mconv)
! omega (omeg), windspeed (us,vs), and a flag (ierr) to turn off
! convection for this call only and at that particular gridpoint
!
!HJ 10/11/2016: change ix to im.
     real, dimension (im,km) :: qcheck,zo,t2d,q2d,PO,P2d,rhoi
     real, dimension (im,km) :: tn,qo,tshall,qshall,dz8w,omeg
     real, dimension (im)    :: ccn,Z1,PSUR,cuten,cutens,cutenm
     real, dimension (im)    :: umean,vmean,pmean
     real, dimension (im)    :: xmbs,xmbs2,xmb,xmbm,xmb_dumm,mconv
!HJ end change ix to im

     INTEGER :: i,j,k,ICLDCK,ipr,jpr,jpr_deep,ipr_deep
     INTEGER :: itf,jtf,ktf,iss,jss,nbegin,nend
     INTEGER :: high_resolution
     REAL    :: clwtot,clwtot1,excess,tcrit,tscl_KF,dp,dq,sub_spread,subcenter
     REAL    :: dsubclw,dsubclws,dsubclwm,ztm,ztq,hfm,qfm,rkbcon,rktop        !-lxz
!HJ change ix to im
     REAL, dimension (im)  :: flux_tun,tun_rad_mid,tun_rad_shall,tun_rad_deep
     character*50 :: ierrc(im),ierrcm(im)
     character*50 :: ierrcs(im)
!HJ end change ix to im
! ruc variable
!HJ hfx2 -- sensible heat flux (K m/s), positive upward from sfc
!HJ qfx2 -- latent heat flux (kg/kg m/s), positive upward from sfc
!HJ gf needs them in W/m2. Define hfx and qfx after simple unit conversion
     REAL, dimension (im)  :: hfx,qfx
     real tem,tem1,tf,tcr,tcrf

     parameter (tf=233.16, tcr=263.16, tcrf=1.0/(tcr-tf))
!
! these should be coming in from outside
!
     cactiv(:)      = 0
     rand_mom(:)    = 0.
     rand_vmas(:)   = 0.
     rand_clos(:,:) = 0.
     its=1
     ite=im
     jts=1
     jte=1
     kts=1
     kte=km
     ktf=kte-1
!
!> tuning constants for radiation coupling
!
   tun_rad_shall(:)=.02
   tun_rad_mid(:)=.15
   tun_rad_deep(:)=.13
   flux_tun(:)=5.
!HJ 10/11/2016 dx and tscl_kf are replaced with input dx(i), is dlength.
  ! dx for scale awareness
!HJ   dx=40075000./float(lonf)
!HJ   tscl_kf=dx/25000.
   ccn(its:ite)=150.
  !
   if (ishal_cnv == 2 .or. ishal_cnv == 3) ishallow_g3 = 1
   high_resolution=0
   subcenter=0.
   iens=1
!
! these can be set for debugging
!
   ipr=0
   jpr=0
   ipr_deep=0
   jpr_deep= 0 !53322 ! 528196 !0 ! 1136 !0 !421755 !3536
!
!
   ibeg=its
   iend=ite
   tcrit=258.

   itf=ite
   ktf=kte-1
   jtf=jte
   ztm=0.
   ztq=0.
   hfm=0.
   qfm=0.
   ud_mf =0.
   dd_mf =0.
   dt_mf =0.
   tau_ecmwf(:)=0.
!
       j=1
       ht(:)=phil(:,1)/g
       do i=its,ite
        cld1d(i)=0.
        zo(i,:)=phil(i,:)/g
        dz8w(i,1)=zo(i,2)-zo(i,1)
        zh(1)=0.
        kpbli(i)=2
        do k=kts+1,ktf
          dz8w(i,k)=zo(i,k+1)-zo(i,k)
        enddo
        do k=kts+1,ktf
          zh(k)=zh(k-1)+dz8w(i,k-1)
          if(zh(k).gt.pbl(i))then
           kpbli(i)=max(2,k)
           exit
          endif
        enddo
       enddo
     DO I= its,itf
        forcing(i,:)=0.
        forcing2(i,:)=0.
        ccn(i)=100.
        HBOT(I)  =KTE
        HTOP(I)  =KTS
        raincv(i)=0.
        xlandi(i)=xland(i)
!       if(abs(xlandi(i)-1.).le.1.e-3) tun_rad_shall(i)=.15
!       if(abs(xlandi(i)-1.).le.1.e-3) flux_tun(i)=1.5
     ENDDO
     DO I= its,itf
        mconv(i)=0.
     ENDDO
     do k=kts,kte
     DO I= its,itf
         omeg(i,k)=0.
         zu(i,k)=0.
         zum(i,k)=0.
         zus(i,k)=0.
         zd(i,k)=0.
         zdm(i,k)=0.
     ENDDO
     ENDDO

     psur(:)=0.01*psuri(:)
     DO I=ITS,ITF
         ter11(I)=max(0.,ht(I))
     ENDDO
     DO K=kts,kte
     DO I=ITS,ITe
         cnvw(i,k)=0.
         cnvc(i,k)=0.
         gdc(i,k,1)=0.
         gdc(i,k,2)=0.
         gdc(i,k,3)=0.
         gdc(i,k,4)=0.
         gdc(i,k,7)=0.
         gdc(i,k,8)=0.
         gdc(i,k,9)=0.
         gdc(i,k,10)=0.
         gdc2(i,k,1)=0.
     ENDDO
     ENDDO
     ierr(:)=0
     ierrm(:)=0
     ierrs(:)=0
     cuten(:)=0.
     cutenm(:)=0.
     cutens(:)=1.
     if(ishallow_g3.eq.0)cutens(:)=0.
     ierrc(:)=" "

     kbcon(:)=0
     kbcons(:)=0
     kbconm(:)=0

     ktop(:)=0
     ktops(:)=0
     ktopm(:)=0

     xmb(:)=0.
     xmb_dumm(:)=0.
     xmbm(:)=0.
     xmbs(:)=0.
     xmbs2(:)=0.

     k22s(:)=0
     k22m(:)=0
     k22(:)=0

     jmin(:)=0
     jminm(:)=0

     pret(:)=0.
     prets(:)=0.
     pretm(:)=0.

     umean(:)=0.
     vmean(:)=0.
     pmean(:)=0.

     cupclw(:,:)=0.
     cupclwm(:,:)=0.
     cupclws(:,:)=0.

     cnvwt(:,:)=0.
     cnvwts(:,:)=0.

     hco(:,:)=0.
     hcom(:,:)=0.
     hcdo(:,:)=0.
     hcdom(:,:)=0.

     OUTT(:,:)=0.
     OUTTS(:,:)=0.
     OUTTm(:,:)=0.

     OUTU(:,:)=0.
     OUTUS(:,:)=0.
     OUTUM(:,:)=0.

     OUTV(:,:)=0.
     OUTVS(:,:)=0.
     OUTVM(:,:)=0.

     OUTQ(:,:)=0.
     OUTQS(:,:)=0.
     outqm(:,:)=0.

     OUTQC(:,:)=0.
     OUTQCS(:,:)=0.
     OUTQCm(:,:)=0.

     subm(:,:)=0.
     dhdt(:,:)=0.
     DO K=kts,ktf
     DO I=ITS,ITF
         p2d(i,k)=0.01*p2di(i,k)
         po(i,k)=p2d(i,k) !*.01
         rhoi(i,k) = 100.*p2d(i,k)/(287.04*(t2di(i,k)*(1.+0.608*q2di(i,k,1))))
         qcheck(I,K)=q(i,k,1)
         tshall(I,K)=t(i,k)
         qshall(I,K)=q(i,k,1)
         tn(i,k)=t(i,k)!+forcet(i,k)*dt
         qo(i,k)=max(1.e-16,q(i,k,1))!+forceq(i,k)*dt
         t2d(i,k)=t2di(i,k)-forcet(i,k)*dt
         q2d(i,k)=max(1.e-16,q2di(i,k,1)-forceq(i,k)*dt)
         IF(Qo(I,K).LT.1.E-16)Qo(I,K)=1.E-16
!HJ         if(ipn.eq.jpr_deep)then
!HJ          write(12,123)k,dt,p2d(i,k),t2d(i,k),tn(i,k),q2d(i,k),QO(i,k),forcet(i,k)
!HJ         endif
     ENDDO
     ENDDO
123  format(1x,i2,1x,2(1x,f8.0),1x,2(1x,f8.3),3(1x,e13.5))
!
!HJ Converting hfx2 and qfx2 to W/m2
!HJ hfx=cp*rho*hfx2
!HJ qfx=xlv*qfx2
     DO I=ITS,ITF
         hfx(i)=hfx2(i)*cp*rhoi(i,1)
         qfx(i)=qfx2(i)*xlv
         dx(i) = sqrt(garea(i))
     ENDDO
!HJ     write(0,*),'hfx',hfx(3),qfx(3),rhoi(3,1)
!HJ
     DO I=ITS,ITF
     DO K=kts,kpbli(i)
         tn(i,k)=t(i,k)
         qo(i,k)=max(1.e-16,q(i,k,1))
     ENDDO
     ENDDO
     nbegin=0
     nend=0
         DO I=ITS,ITF
         DO K=kts,kpbli(i)
         DHDT(I,K)=cp*(forcet(i,k)+(t(i,k)-t2di(i,k))/dt) +  &
                   XLV*(forceq(i,k)+(q(i,k,1)-q2di(i,k,1))/dt)
         TSHALL(I,K)=t(i,k)
         QSHALL(I,K)=q(i,k,1)
        enddo
        enddo
      do k=  kts+1,ktf-1
      DO I = its,itf
         if((p2d(i,1)-p2d(i,k)).gt.150.and.p2d(i,k).gt.300)then
            dp=-.5*(p2d(i,k+1)-p2d(i,k-1))
            umean(i)=umean(i)+us(i,k)*dp
            vmean(i)=vmean(i)+vs(i,k)*dp
            pmean(i)=pmean(i)+dp
         endif
      enddo
      enddo
      DO K=kts,ktf-1
      DO I = its,itf
        omeg(I,K)= w(i,k) !-g*rhoi(i,k)*w(i,k)
!        dq=(q2d(i,k+1)-q2d(i,k))
!        mconv(i)=mconv(i)+omeg(i,k)*dq/g
      ENDDO
      ENDDO
      DO I = its,itf
        if(mconv(i).lt.0.)mconv(i)=0.
      ENDDO
!
!---- CALL CUMULUS PARAMETERIZATION
!
       if(ishallow_g3.eq.1)then
!
          do i=its,ite
           ierrs(i)=0
           ierrm(i)=0
          enddo
!
!> If ishallow_g3=1, call shallow: cup_gf_sh()
!
          call CUP_gf_sh (                                              &
! input variables, must be supplied
                         zo,t2d,q2d,ter11,tshall,qshall,p2d,psur,dhdt,kpbli,     &
                         rhoi,hfx,qfx,xlandi,ichoice_s,tcrit,dt, &
! input variables. Ierr should be initialized to zero or larger than zero for
! turning off shallow convection for grid points
                         zus,xmbs,kbcons,ktops,k22s,ierrs,ierrcs,    &
! output tendencies
                         outts,outqs,outqcs,cnvwt,prets,cupclws,             &
! dimesnional variables
                         itf,ktf,its,ite, kts,kte,ipr)


          do i=its,itf
           if(xmbs(i).le.0.)cutens(i)=0.
          enddo
          CALL neg_check('shallow',ipn,dt,qcheck,outqs,outts,outus,outvs,   &
                                 outqcs,prets,its,ite,kts,kte,itf,ktf)
       endif

       ipr=0
       jpr_deep=0 !340765
!> If imid_gf=1, call cup_gf()
   if(imid_gf == 1)then
      call cup_gf(        &
               itf,ktf,its,ite, kts,kte  &
              ,dicycle_m       &
              ,ichoicem       &
              ,ipr           &
              ,ccn           &
              ,dt            &
              ,imid_gf       &
              ,kpbli         &
              ,dhdt          &
              ,xlandi        &

              ,zo            &
              ,forcing2      &
              ,t2d           &
              ,q2d           &
              ,ter11         &
              ,tshall        &
              ,qshall        &
              ,p2d          &
              ,psur          &
              ,us            &
              ,vs            &
              ,rhoi          &
              ,hfx           &
              ,qfx           &
              ,dx            & !HJ dx(im)
              ,mconv         &
              ,omeg          &

              ,cactiv        &
              ,cnvwtm        &
              ,zum           &
              ,zdm           &
              ,edtm          &
              ,xmbm          &
              ,xmb_dumm      &
              ,xmbs          &
              ,pretm         &
              ,outum         &
              ,outvm         &
              ,outtm         &
              ,outqm         &
              ,outqcm        &
              ,kbconm        &
              ,ktopm         &
              ,cupclwm       &
              ,ierrm         &
              ,ierrcm        &
!    the following should be set to zero if not available
              ,rand_mom      & ! for stochastics mom, if temporal and spatial patterns exist
              ,rand_vmas     & ! for stochastics vertmass, if temporal and spatial patterns exist
              ,rand_clos     & ! for stochastics closures, if temporal and spatial patterns exist
              ,0             & ! flag to what you want perturbed
                               ! 1 = momentum transport
                               ! 2 = normalized vertical mass flux profile
                               ! 3 = closures
                               ! more is possible, talk to developer or
                               ! implement yourself. pattern is expected to be
                               ! betwee -1 and +1
#if ( WRF_DFI_RADAR == 1 )
              ,do_capsuppress,cap_suppress_j &
#endif
              ,k22m          &
              ,jminm)

            DO I=its,itf
            DO K=kts,ktf
              qcheck(i,k)=q(i,k,1) +outqs(i,k)*dt
            enddo
            enddo
      CALL neg_check('mid',ipn,dt,qcheck,outqm,outtm,outum,outvm,   &
                     outqcm,pretm,its,ite,kts,kte,itf,ktf)
    endif
!> If ideep=1, call cup_gf()
   if(ideep.eq.1)then
      call cup_gf(        &
               itf,ktf,its,ite, kts,kte  &

              ,dicycle       &
              ,ichoice       &
              ,ipr           &
              ,ccn           &
              ,dt            &
              ,0             &

              ,kpbli         &
              ,dhdt          &
              ,xlandi        &

              ,zo            &
              ,forcing       &
              ,t2d           &
              ,q2d           &
              ,ter11         &
              ,tn            &
              ,qo            &
              ,p2d           &
              ,psur          &
              ,us            &
              ,vs            &
              ,rhoi          &
              ,hfx           &
              ,qfx           &
              ,dx            & !HJ replace dx(im)
              ,mconv         &
              ,omeg          &

              ,cactiv       &
              ,cnvwt        &
              ,zu           &
              ,zd           &
              ,edt          &
              ,xmb          &
              ,xmbm         &
              ,xmbs         &
              ,pret         &
              ,outu         &
              ,outv         &
              ,outt         &
              ,outq         &
              ,outqc        &
              ,kbcon        &
              ,ktop         &
              ,cupclw       &
              ,ierr         &
              ,ierrc        &
!    the following should be set to zero if not available
              ,rand_mom      & ! for stochastics mom, if temporal and spatial patterns exist
              ,rand_vmas     & ! for stochastics vertmass, if temporal and spatial patterns exist
              ,rand_clos     & ! for stochastics closures, if temporal and spatial patterns exist
              ,0             & ! flag to what you want perturbed
                               ! 1 = momentum transport
                               ! 2 = normalized vertical mass flux profile
                               ! 3 = closures
                               ! more is possible, talk to developer or
                               ! implement yourself. pattern is expected to be
                               ! betwee -1 and +1
#if ( WRF_DFI_RADAR == 1 )
              ,do_capsuppress,cap_suppress_j &
#endif
              ,k22          &
              ,jmin)
        jpr=0
        ipr=0
            DO I=its,itf
            DO K=kts,ktf
              qcheck(i,k)=q(i,k,1) +(outqs(i,k)+outqm(i,k))*dt
            enddo
            enddo
      CALL neg_check('deep',ipn,dt,qcheck,outq,outt,outu,outv,   &
                                         outqc,pret,its,ite,kts,kte,itf,ktf)
!
      endif
            DO I=its,itf
              if(pret(i).gt.0.)then
                 cuten(i)=1.
              else
                 kbcon(i)=0
                 ktop(i)=0
                 cuten(i)=0.
              endif   ! pret > 0
              if(pretm(i).gt.0.)then
                 cutenm(i)=1.
              else
                 kbconm(i)=0
                 ktopm(i)=0
                 cutenm(i)=0.
              endif   ! pret > 0
            ENDDO
!
            DO I=its,itf
            kstop=kts
            if(ktopm(i).gt.kts .or. ktop(i).gt.kts)kstop=max(ktopm(i),ktop(i))
            if(ktops(i).gt.kts)kstop=max(kstop,ktops(i))
            if(kstop.gt.2)then
            htop(i)=kstop
            kcnv(i)=1
            if(kbcon(i).gt.2)hbot(i)=jmin(i) !kbcon(i)
            DO K=kts,kstop
               cnvc(i,k) = 0.04 * log(1. + 675. * zu(i,k) * xmb(i)) +   &
                           0.04 * log(1. + 675. * zum(i,k) * xmbm(i)) + &
                           0.04 * log(1. + 675. * zus(i,k) * xmbs(i))
               cnvc(i,k) = min(cnvc(i,k), 0.6)
               cnvc(i,k) = max(cnvc(i,k), 0.0)
               cnvw(i,k)=cnvwt(i,k)*xmb(i)*dt+cnvwts(i,k)*xmbs(i)*dt+cnvwtm(i,k)*xmbm(i)*dt
               ud_mf(i,k)=cuten(i)*zu(i,k)*xmb(i)*dt
               dd_mf(i,k)=cuten(i)*zd(i,k)*edt(i)*xmb(i)*dt
               T(I,K)=t(i,k)+dt*(cutens(i)*outts(i,k)+cutenm(i)*outtm(i,k)+outt(i,k)*cuten(i))
               Q(I,K,1)=max(1.e-16,q(i,k,1)+dt*(cutens(i)*outqs(i,k)+cutenm(i)*outqm(i,k)+outq(i,k)*cuten(i)))
               gdc(i,k,7)=sqrt(us(i,k)**2 +vs(i,k)**2)
               us(i,k)=us(i,k)+outu(i,k)*cuten(i)*dt +outum(i,k)*cutenm(i)*dt
               vs(i,k)=vs(i,k)+outv(i,k)*cuten(i)*dt +outvm(i,k)*cutenm(i)*dt

!HJ 10/11/2016: don't need gdc and gdc2 yet for GSM.
!HJ                gdc(i,k,1)= max(0.,tun_rad_shall(i)*cupclws(i,k)*cutens(i))	! my mod
!HJ               gdc2(i,k,1)=max(0.,tun_rad_deep(i)*(cupclwm(i,k)*cutenm(i)+cupclw(i,k)*cuten(i)))
!HJ                gdc(i,k,2)=(outt(i,k))*86400.
!HJ                gdc(i,k,3)=(outtm(i,k))*86400.
!HJ                gdc(i,k,4)=(outts(i,k))*86400.
!HJ                gdc(i,k,7)=-(gdc(i,k,7)-sqrt(us(i,k)**2 +vs(i,k)**2))/dt
!HJ                gdc(i,k,8)=(outq(i,k))*86400.*xlv/cp
!HJ                gdc(i,k,9)=gdc(i,k,2)+gdc(i,k,3)+gdc(i,k,4)

!
!> Calculate subsidence effect on clw
!
               dsubclw=0.
               dsubclwm=0.
               dsubclws=0.
               dp=100.*(p2d(i,k)-p2d(i,k+1))
               if (clw(i,k,2) .gt. -999.0 .and. clw(i,k+1,2) .gt. -999.0 )then
                  clwtot = clw(i,k,1) + clw(i,k,2)
                  clwtot1= clw(i,k+1,1) + clw(i,k+1,2)
                  dsubclw=((-edt(i)*zd(i,k+1)+zu(i,k+1))*clwtot1   &
                       -(-edt(i)*zd(i,k)  +zu(i,k))  *clwtot  )*g/dp
                  dsubclwm=((-edtm(i)*zdm(i,k+1)+zum(i,k+1))*clwtot1   &
                       -(-edtm(i)*zdm(i,k)  +zum(i,k))  *clwtot  )*g/dp
                  dsubclws=(zus(i,k+1)*clwtot1-zus(i,k)*clwtot)*g/dp
                  dsubclw=dsubclw+(zu(i,k+1)*clwtot1-zu(i,k)*clwtot)*g/dp
                  dsubclwm=dsubclwm+(zum(i,k+1)*clwtot1-zum(i,k)*clwtot)*g/dp
                  dsubclws=dsubclws+(zus(i,k+1)*clwtot1-zus(i,k)*clwtot)*g/dp
               endif
               tem  = dt*(outqcs(i,k)*cutens(i)+outqc(i,k)*cuten(i)       &
                      +outqcm(i,k)*cutenm(i)                           &
                       +dsubclw*xmb(i)+dsubclws*xmbs(i)+dsubclwm*xmbm(i) &
                      )
               tem1 = max(0.0, min(1.0, (tcr-t(i,k))*tcrf))
               if (clw(i,k,2) .gt. -999.0) then
                clw(i,k,1) = max(0.,clw(i,k,1) + tem * tem1)            ! ice
                clw(i,k,2) = max(0.,clw(i,k,2) + tem *(1.0-tem1))       ! water
              else
                clw(i,k,1) = max(0.,clw(i,k,1) + tem)
              endif

            ENDDO
!HJ               gdc(i,1,10)=forcing(i,1)
!HJ               gdc(i,2,10)=forcing(i,2)
!HJ               gdc(i,3,10)=forcing(i,3)
!HJ               gdc(i,4,10)=forcing(i,4)
!HJ               gdc(i,5,10)=forcing(i,5)
!HJ               gdc(i,6,10)=forcing(i,6)
!HJ               gdc(i,7,10)=forcing(i,7)
!HJ               gdc(i,8,10)=forcing(i,8)
!HJ               gdc(i,10,10)=xmb(i)
!HJ               gdc(i,11,10)=xmbm(i)
!HJ               gdc(i,12,10)=xmbs(i)
!HJ               gdc(i,13,10)=hfx(i)
!HJ               gdc(i,15,10)=qfx(i)
!HJ               gdc(i,16,10)=pret(i)*3600.
            if(ktop(i).gt.2 .and.pret(i).gt.0.)dt_mf(i,ktop(i)-1)=ud_mf(i,ktop(i))
            endif
            ENDDO
            DO I=its,itf
              if(pret(i).gt.0.)then
                 cactiv(i)=1
                 raincv(i)=.001*(cutenm(i)*pretm(i)+cutens(i)*prets(i)+cuten(i)*pret(i))*dt
              else
                 cactiv(i)=0
                 if(pretm(i).gt.0)raincv(i)=.001*cutenm(i)*pretm(i)*dt
              endif   ! pret > 0
            ENDDO
 100    continue


   END SUBROUTINE GFDRV
END MODULE module_cu_gf_driver
