!!!!!  ==========================================================  !!!!!
!!!!!              rrtm1 radiation package description             !!!!!
!!!!!  ==========================================================  !!!!!
!                                                                      !
!    the rrtm1 package includes these parts:                           !
!                                                                      !
!       'radlw_rrtm1_param.f'                                          !
!       'radlw_rrtm1_datatb.f'                                         !
!       'radlw_rrtm1_main.f'                                           !
!                                                                      !
!    the 'radlw_rrtm1_param.f' contains:                               !
!                                                                      !
!       'module_radlw_cntr_para'   -- control parameters set up        !
!       'module_radlw_parameters'  -- band parameters set up           !
!                                                                      !
!    the 'radlw_rrtm1_datatb.f' contains:                              !
!                                                                      !
!       'module_radlw_avplank'     -- plank flux data                  !
!       'module_radlw_cldprlw'     -- cloud property coefficients      !
!       'module_radlw_kgbnn'       -- absorption coeffients for 16     !
!                                     bands, where nn = 01-16          !
!                                                                      !
!    the 'radlw_rrtm1_main.f' contains:                                !
!                                                                      !
!       'module_radlw_main'        -- main lw radiation transfer       !
!                                                                      !
!    in the main module 'module_radlw_main' there are only two         !
!    externally callable subroutines:                                  !
!                                                                      !
!                                                                      !
!       'lwrad     -- main rrtm1 lw radiation routine                  !
!       'rlwinit'   -- to initialize rrtm1 lw radiation                !
!                                                                      !
!    all the lw radiation subprograms become contained subprograms     !
!    in module 'module_radlw_main' and many of them are not directly   !
!    accessable from places outside the module.                        !
!                                                                      !
!    compilation sequence is:                                          !
!                                                                      !
!       'radlw_rrtm1_param,f'                                          !
!       'radlw_rrtm1_datatb,f'                                         !
!       'radlw_rrtm1_main.f'                                           !
!                                                                      !
!    and all should be put in front of routines that use lw modules    !
!                                                                      !
!    ncep modifications history log:                                   !
!                                                                      !
!       see list in program "radlw_rrtm1_main.f"                       !
!                                                                      !
!!!!!  ==========================================================  !!!!!
!!!!!                       end descriptions                       !!!!!
!!!!!  ==========================================================  !!!!!
 


!========================================!
      module module_radlw_avplank_nmmb   !
!........................................!
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NPLNK, NBANDS
!
      implicit none
!
      private

      real (kind=kind_phys), public :: totplnk(NPLNK,NBANDS)

      data totplnk(  1: 50, 1) /                                        &
     &1.13735E-06,1.15150E-06,1.16569E-06,1.17992E-06,1.19419E-06,      &
     &1.20850E-06,1.22285E-06,1.23723E-06,1.25164E-06,1.26610E-06,      &
     &1.28059E-06,1.29511E-06,1.30967E-06,1.32426E-06,1.33889E-06,      &
     &1.35355E-06,1.36824E-06,1.38296E-06,1.39772E-06,1.41250E-06,      &
     &1.42732E-06,1.44217E-06,1.45704E-06,1.47195E-06,1.48689E-06,      &
     &1.50185E-06,1.51684E-06,1.53186E-06,1.54691E-06,1.56198E-06,      &
     &1.57709E-06,1.59222E-06,1.60737E-06,1.62255E-06,1.63776E-06,      &
     &1.65299E-06,1.66825E-06,1.68352E-06,1.69883E-06,1.71416E-06,      &
     &1.72951E-06,1.74488E-06,1.76028E-06,1.77570E-06,1.79114E-06,      &
     &1.80661E-06,1.82210E-06,1.83760E-06,1.85313E-06,1.86868E-06/
      data totplnk( 51:100, 1) /                                        &
     &1.88425E-06,1.89985E-06,1.91546E-06,1.93109E-06,1.94674E-06,      &
     &1.96241E-06,1.97811E-06,1.99381E-06,2.00954E-06,2.02529E-06,      &
     &2.04105E-06,2.05684E-06,2.07264E-06,2.08846E-06,2.10429E-06,      &
     &2.12015E-06,2.13602E-06,2.15190E-06,2.16781E-06,2.18373E-06,      &
     &2.19966E-06,2.21562E-06,2.23159E-06,2.24758E-06,2.26358E-06,      &
     &2.27959E-06,2.29562E-06,2.31167E-06,2.32773E-06,2.34381E-06,      &
     &2.35990E-06,2.37601E-06,2.39212E-06,2.40825E-06,2.42440E-06,      &
     &2.44056E-06,2.45673E-06,2.47292E-06,2.48912E-06,2.50533E-06,      &
     &2.52157E-06,2.53781E-06,2.55406E-06,2.57032E-06,2.58660E-06,      &
     &2.60289E-06,2.61919E-06,2.63550E-06,2.65183E-06,2.66817E-06/
      data totplnk(101:150, 1) /                                        &
     &2.68452E-06,2.70088E-06,2.71726E-06,2.73364E-06,2.75003E-06,      &
     &2.76644E-06,2.78286E-06,2.79929E-06,2.81572E-06,2.83218E-06,      &
     &2.84864E-06,2.86510E-06,2.88159E-06,2.89807E-06,2.91458E-06,      &
     &2.93109E-06,2.94762E-06,2.96415E-06,2.98068E-06,2.99724E-06,      &
     &3.01379E-06,3.03036E-06,3.04693E-06,3.06353E-06,3.08013E-06,      &
     &3.09674E-06,3.11335E-06,3.12998E-06,3.14661E-06,3.16324E-06,      &
     &3.17989E-06,3.19656E-06,3.21323E-06,3.22991E-06,3.24658E-06,      &
     &3.26328E-06,3.27998E-06,3.29669E-06,3.31341E-06,3.33013E-06,      &
     &3.34686E-06,3.36360E-06,3.38034E-06,3.39709E-06,3.41387E-06,      &
     &3.43063E-06,3.44742E-06,3.46420E-06,3.48099E-06,3.49779E-06/
      data totplnk(151:181, 1) /                                        &
     &3.51461E-06,3.53141E-06,3.54824E-06,3.56506E-06,3.58191E-06,      &
     &3.59875E-06,3.61559E-06,3.63244E-06,3.64931E-06,3.66617E-06,      &
     &3.68305E-06,3.69992E-06,3.71682E-06,3.73372E-06,3.75061E-06,      &
     &3.76753E-06,3.78443E-06,3.80136E-06,3.81829E-06,3.83522E-06,      &
     &3.85215E-06,3.86910E-06,3.88605E-06,3.90301E-06,3.91997E-06,      &
     &3.93694E-06,3.95390E-06,3.97087E-06,3.98788E-06,4.00485E-06,      &
     &4.02187E-06/
      data totplnk(  1: 50, 2) /                                        &
     &2.13441E-06,2.18076E-06,2.22758E-06,2.27489E-06,2.32268E-06,      &
     &2.37093E-06,2.41966E-06,2.46886E-06,2.51852E-06,2.56864E-06,      &
     &2.61922E-06,2.67026E-06,2.72175E-06,2.77370E-06,2.82609E-06,      &
     &2.87893E-06,2.93221E-06,2.98593E-06,3.04008E-06,3.09468E-06,      &
     &3.14970E-06,3.20515E-06,3.26103E-06,3.31732E-06,3.37404E-06,      &
     &3.43118E-06,3.48873E-06,3.54669E-06,3.60506E-06,3.66383E-06,      &
     &3.72301E-06,3.78259E-06,3.84256E-06,3.90293E-06,3.96368E-06,      &
     &4.02483E-06,4.08636E-06,4.14828E-06,4.21057E-06,4.27324E-06,      &
     &4.33629E-06,4.39971E-06,4.46350E-06,4.52765E-06,4.59217E-06,      &
     &4.65705E-06,4.72228E-06,4.78787E-06,4.85382E-06,4.92011E-06/
      data totplnk( 51:100, 2) /                                        &
     &4.98675E-06,5.05374E-06,5.12106E-06,5.18873E-06,5.25674E-06,      &
     &5.32507E-06,5.39374E-06,5.46274E-06,5.53207E-06,5.60172E-06,      &
     &5.67169E-06,5.74198E-06,5.81259E-06,5.88352E-06,5.95475E-06,      &
     &6.02629E-06,6.09815E-06,6.17030E-06,6.24276E-06,6.31552E-06,      &
     &6.38858E-06,6.46192E-06,6.53557E-06,6.60950E-06,6.68373E-06,      &
     &6.75824E-06,6.83303E-06,6.90810E-06,6.98346E-06,7.05909E-06,      &
     &7.13500E-06,7.21117E-06,7.28763E-06,7.36435E-06,7.44134E-06,      &
     &7.51859E-06,7.59611E-06,7.67388E-06,7.75192E-06,7.83021E-06,      &
     &7.90875E-06,7.98755E-06,8.06660E-06,8.14589E-06,8.22544E-06,      &
     &8.30522E-06,8.38526E-06,8.46553E-06,8.54604E-06,8.62679E-06/
      data totplnk(101:150, 2) /                                        &
     &8.70777E-06,8.78899E-06,8.87043E-06,8.95211E-06,9.03402E-06,      &
     &9.11616E-06,9.19852E-06,9.28109E-06,9.36390E-06,9.44692E-06,      &
     &9.53015E-06,9.61361E-06,9.69729E-06,9.78117E-06,9.86526E-06,      &
     &9.94957E-06,1.00341E-05,1.01188E-05,1.02037E-05,1.02888E-05,      &
     &1.03742E-05,1.04597E-05,1.05454E-05,1.06313E-05,1.07175E-05,      &
     &1.08038E-05,1.08903E-05,1.09770E-05,1.10639E-05,1.11509E-05,      &
     &1.12382E-05,1.13257E-05,1.14133E-05,1.15011E-05,1.15891E-05,      &
     &1.16773E-05,1.17656E-05,1.18542E-05,1.19429E-05,1.20317E-05,      &
     &1.21208E-05,1.22100E-05,1.22994E-05,1.23890E-05,1.24787E-05,      &
     &1.25686E-05,1.26587E-05,1.27489E-05,1.28393E-05,1.29299E-05/
      data totplnk(151:181, 2) /                                        &
     &1.30206E-05,1.31115E-05,1.32025E-05,1.32937E-05,1.33850E-05,      &
     &1.34765E-05,1.35682E-05,1.36600E-05,1.37520E-05,1.38441E-05,      &
     &1.39364E-05,1.40288E-05,1.41213E-05,1.42140E-05,1.43069E-05,      &
     &1.43999E-05,1.44930E-05,1.45863E-05,1.46797E-05,1.47733E-05,      &
     &1.48670E-05,1.49608E-05,1.50548E-05,1.51489E-05,1.52431E-05,      &
     &1.53375E-05,1.54320E-05,1.55267E-05,1.56214E-05,1.57164E-05,      &
     &1.58114E-05/
      data totplnk(  1: 50, 3) /                                        &
     &1.34822E-06,1.39134E-06,1.43530E-06,1.48010E-06,1.52574E-06,      &
     &1.57222E-06,1.61956E-06,1.66774E-06,1.71678E-06,1.76666E-06,      &
     &1.81741E-06,1.86901E-06,1.92147E-06,1.97479E-06,2.02898E-06,      &
     &2.08402E-06,2.13993E-06,2.19671E-06,2.25435E-06,2.31285E-06,      &
     &2.37222E-06,2.43246E-06,2.49356E-06,2.55553E-06,2.61837E-06,      &
     &2.68207E-06,2.74664E-06,2.81207E-06,2.87837E-06,2.94554E-06,      &
     &3.01356E-06,3.08245E-06,3.15221E-06,3.22282E-06,3.29429E-06,      &
     &3.36662E-06,3.43982E-06,3.51386E-06,3.58876E-06,3.66451E-06,      &
     &3.74112E-06,3.81857E-06,3.89688E-06,3.97602E-06,4.05601E-06,      &
     &4.13685E-06,4.21852E-06,4.30104E-06,4.38438E-06,4.46857E-06/
      data totplnk( 51:100, 3) /                                        &
     &4.55358E-06,4.63943E-06,4.72610E-06,4.81359E-06,4.90191E-06,      &
     &4.99105E-06,5.08100E-06,5.17176E-06,5.26335E-06,5.35573E-06,      &
     &5.44892E-06,5.54292E-06,5.63772E-06,5.73331E-06,5.82970E-06,      &
     &5.92688E-06,6.02485E-06,6.12360E-06,6.22314E-06,6.32346E-06,      &
     &6.42455E-06,6.52641E-06,6.62906E-06,6.73247E-06,6.83664E-06,      &
     &6.94156E-06,7.04725E-06,7.15370E-06,7.26089E-06,7.36883E-06,      &
     &7.47752E-06,7.58695E-06,7.69712E-06,7.80801E-06,7.91965E-06,      &
     &8.03201E-06,8.14510E-06,8.25891E-06,8.37343E-06,8.48867E-06,      &
     &8.60463E-06,8.72128E-06,8.83865E-06,8.95672E-06,9.07548E-06,      &
     &9.19495E-06,9.31510E-06,9.43594E-06,9.55745E-06,9.67966E-06/
      data totplnk(101:150, 3) /                                        &
     &9.80254E-06,9.92609E-06,1.00503E-05,1.01752E-05,1.03008E-05,      &
     &1.04270E-05,1.05539E-05,1.06814E-05,1.08096E-05,1.09384E-05,      &
     &1.10679E-05,1.11980E-05,1.13288E-05,1.14601E-05,1.15922E-05,      &
     &1.17248E-05,1.18581E-05,1.19920E-05,1.21265E-05,1.22616E-05,      &
     &1.23973E-05,1.25337E-05,1.26706E-05,1.28081E-05,1.29463E-05,      &
     &1.30850E-05,1.32243E-05,1.33642E-05,1.35047E-05,1.36458E-05,      &
     &1.37875E-05,1.39297E-05,1.40725E-05,1.42159E-05,1.43598E-05,      &
     &1.45044E-05,1.46494E-05,1.47950E-05,1.49412E-05,1.50879E-05,      &
     &1.52352E-05,1.53830E-05,1.55314E-05,1.56803E-05,1.58297E-05,      &
     &1.59797E-05,1.61302E-05,1.62812E-05,1.64327E-05,1.65848E-05/
      data totplnk(151:181, 3) /                                        &
     &1.67374E-05,1.68904E-05,1.70441E-05,1.71982E-05,1.73528E-05,      &
     &1.75079E-05,1.76635E-05,1.78197E-05,1.79763E-05,1.81334E-05,      &
     &1.82910E-05,1.84491E-05,1.86076E-05,1.87667E-05,1.89262E-05,      &
     &1.90862E-05,1.92467E-05,1.94076E-05,1.95690E-05,1.97309E-05,      &
     &1.98932E-05,2.00560E-05,2.02193E-05,2.03830E-05,2.05472E-05,      &
     &2.07118E-05,2.08768E-05,2.10423E-05,2.12083E-05,2.13747E-05,      &
     &2.15414E-05/
      data totplnk(  1: 50, 4) /                                        &
     &8.90528E-07,9.24222E-07,9.58757E-07,9.94141E-07,1.03038E-06,      &
     &1.06748E-06,1.10545E-06,1.14430E-06,1.18403E-06,1.22465E-06,      &
     &1.26618E-06,1.30860E-06,1.35193E-06,1.39619E-06,1.44136E-06,      &
     &1.48746E-06,1.53449E-06,1.58246E-06,1.63138E-06,1.68124E-06,      &
     &1.73206E-06,1.78383E-06,1.83657E-06,1.89028E-06,1.94495E-06,      &
     &2.00060E-06,2.05724E-06,2.11485E-06,2.17344E-06,2.23303E-06,      &
     &2.29361E-06,2.35519E-06,2.41777E-06,2.48134E-06,2.54592E-06,      &
     &2.61151E-06,2.67810E-06,2.74571E-06,2.81433E-06,2.88396E-06,      &
     &2.95461E-06,3.02628E-06,3.09896E-06,3.17267E-06,3.24741E-06,      &
     &3.32316E-06,3.39994E-06,3.47774E-06,3.55657E-06,3.63642E-06/
      data totplnk( 51:100, 4) /                                        &
     &3.71731E-06,3.79922E-06,3.88216E-06,3.96612E-06,4.05112E-06,      &
     &4.13714E-06,4.22419E-06,4.31227E-06,4.40137E-06,4.49151E-06,      &
     &4.58266E-06,4.67485E-06,4.76806E-06,4.86229E-06,4.95754E-06,      &
     &5.05383E-06,5.15113E-06,5.24946E-06,5.34879E-06,5.44916E-06,      &
     &5.55053E-06,5.65292E-06,5.75632E-06,5.86073E-06,5.96616E-06,      &
     &6.07260E-06,6.18003E-06,6.28848E-06,6.39794E-06,6.50838E-06,      &
     &6.61983E-06,6.73229E-06,6.84573E-06,6.96016E-06,7.07559E-06,      &
     &7.19200E-06,7.30940E-06,7.42779E-06,7.54715E-06,7.66749E-06,      &
     &7.78882E-06,7.91110E-06,8.03436E-06,8.15859E-06,8.28379E-06,      &
     &8.40994E-06,8.53706E-06,8.66515E-06,8.79418E-06,8.92416E-06/
      data totplnk(101:150, 4) /                                        &
     &9.05510E-06,9.18697E-06,9.31979E-06,9.45356E-06,9.58826E-06,      &
     &9.72389E-06,9.86046E-06,9.99793E-06,1.01364E-05,1.02757E-05,      &
     &1.04159E-05,1.05571E-05,1.06992E-05,1.08422E-05,1.09861E-05,      &
     &1.11309E-05,1.12766E-05,1.14232E-05,1.15707E-05,1.17190E-05,      &
     &1.18683E-05,1.20184E-05,1.21695E-05,1.23214E-05,1.24741E-05,      &
     &1.26277E-05,1.27822E-05,1.29376E-05,1.30939E-05,1.32509E-05,      &
     &1.34088E-05,1.35676E-05,1.37273E-05,1.38877E-05,1.40490E-05,      &
     &1.42112E-05,1.43742E-05,1.45380E-05,1.47026E-05,1.48680E-05,      &
     &1.50343E-05,1.52014E-05,1.53692E-05,1.55379E-05,1.57074E-05,      &
     &1.58778E-05,1.60488E-05,1.62207E-05,1.63934E-05,1.65669E-05/
      data totplnk(151:181, 4) /                                        &
     &1.67411E-05,1.69162E-05,1.70920E-05,1.72685E-05,1.74459E-05,      &
     &1.76240E-05,1.78029E-05,1.79825E-05,1.81629E-05,1.83440E-05,      &
     &1.85259E-05,1.87086E-05,1.88919E-05,1.90760E-05,1.92609E-05,      &
     &1.94465E-05,1.96327E-05,1.98199E-05,2.00076E-05,2.01961E-05,      &
     &2.03853E-05,2.05752E-05,2.07658E-05,2.09571E-05,2.11491E-05,      &
     &2.13418E-05,2.15352E-05,2.17294E-05,2.19241E-05,2.21196E-05,      &
     &2.23158E-05/
      data totplnk(  1:50, 5) /                                         &
     &5.70230E-07,5.94788E-07,6.20085E-07,6.46130E-07,6.72936E-07,      &
     &7.00512E-07,7.28869E-07,7.58019E-07,7.87971E-07,8.18734E-07,      &
     &8.50320E-07,8.82738E-07,9.15999E-07,9.50110E-07,9.85084E-07,      &
     &1.02093E-06,1.05765E-06,1.09527E-06,1.13378E-06,1.17320E-06,      &
     &1.21353E-06,1.25479E-06,1.29698E-06,1.34011E-06,1.38419E-06,      &
     &1.42923E-06,1.47523E-06,1.52221E-06,1.57016E-06,1.61910E-06,      &
     &1.66904E-06,1.71997E-06,1.77192E-06,1.82488E-06,1.87886E-06,      &
     &1.93387E-06,1.98991E-06,2.04699E-06,2.10512E-06,2.16430E-06,      &
     &2.22454E-06,2.28584E-06,2.34821E-06,2.41166E-06,2.47618E-06,      &
     &2.54178E-06,2.60847E-06,2.67626E-06,2.74514E-06,2.81512E-06/
      data totplnk( 51:100, 5) /                                        &
     &2.88621E-06,2.95841E-06,3.03172E-06,3.10615E-06,3.18170E-06,      &
     &3.25838E-06,3.33618E-06,3.41511E-06,3.49518E-06,3.57639E-06,      &
     &3.65873E-06,3.74221E-06,3.82684E-06,3.91262E-06,3.99955E-06,      &
     &4.08763E-06,4.17686E-06,4.26725E-06,4.35880E-06,4.45150E-06,      &
     &4.54537E-06,4.64039E-06,4.73659E-06,4.83394E-06,4.93246E-06,      &
     &5.03215E-06,5.13301E-06,5.23504E-06,5.33823E-06,5.44260E-06,      &
     &5.54814E-06,5.65484E-06,5.76272E-06,5.87177E-06,5.98199E-06,      &
     &6.09339E-06,6.20596E-06,6.31969E-06,6.43460E-06,6.55068E-06,      &
     &6.66793E-06,6.78636E-06,6.90595E-06,7.02670E-06,7.14863E-06,      &
     &7.27173E-06,7.39599E-06,7.52142E-06,7.64802E-06,7.77577E-06/
      data totplnk(101:150, 5) /                                        &
     &7.90469E-06,8.03477E-06,8.16601E-06,8.29841E-06,8.43198E-06,      &
     &8.56669E-06,8.70256E-06,8.83957E-06,8.97775E-06,9.11706E-06,      &
     &9.25753E-06,9.39915E-06,9.54190E-06,9.68580E-06,9.83085E-06,      &
     &9.97704E-06,1.01243E-05,1.02728E-05,1.04224E-05,1.05731E-05,      &
     &1.07249E-05,1.08779E-05,1.10320E-05,1.11872E-05,1.13435E-05,      &
     &1.15009E-05,1.16595E-05,1.18191E-05,1.19799E-05,1.21418E-05,      &
     &1.23048E-05,1.24688E-05,1.26340E-05,1.28003E-05,1.29676E-05,      &
     &1.31361E-05,1.33056E-05,1.34762E-05,1.36479E-05,1.38207E-05,      &
     &1.39945E-05,1.41694E-05,1.43454E-05,1.45225E-05,1.47006E-05,      &
     &1.48797E-05,1.50600E-05,1.52413E-05,1.54236E-05,1.56070E-05/
      data totplnk(151:181, 5) /                                        &
     &1.57914E-05,1.59768E-05,1.61633E-05,1.63509E-05,1.65394E-05,      &
     &1.67290E-05,1.69197E-05,1.71113E-05,1.73040E-05,1.74976E-05,      &
     &1.76923E-05,1.78880E-05,1.80847E-05,1.82824E-05,1.84811E-05,      &
     &1.86808E-05,1.88814E-05,1.90831E-05,1.92857E-05,1.94894E-05,      &
     &1.96940E-05,1.98996E-05,2.01061E-05,2.03136E-05,2.05221E-05,      &
     &2.07316E-05,2.09420E-05,2.11533E-05,2.13657E-05,2.15789E-05,      &
     &2.17931E-05/
      data totplnk(  1: 50, 6) /                                        &
     &2.73493E-07,2.87408E-07,3.01848E-07,3.16825E-07,3.32352E-07,      &
     &3.48439E-07,3.65100E-07,3.82346E-07,4.00189E-07,4.18641E-07,      &
     &4.37715E-07,4.57422E-07,4.77774E-07,4.98784E-07,5.20464E-07,      &
     &5.42824E-07,5.65879E-07,5.89638E-07,6.14115E-07,6.39320E-07,      &
     &6.65266E-07,6.91965E-07,7.19427E-07,7.47666E-07,7.76691E-07,      &
     &8.06516E-07,8.37151E-07,8.68607E-07,9.00896E-07,9.34029E-07,      &
     &9.68018E-07,1.00287E-06,1.03860E-06,1.07522E-06,1.11274E-06,      &
     &1.15117E-06,1.19052E-06,1.23079E-06,1.27201E-06,1.31418E-06,      &
     &1.35731E-06,1.40141E-06,1.44650E-06,1.49257E-06,1.53965E-06,      &
     &1.58773E-06,1.63684E-06,1.68697E-06,1.73815E-06,1.79037E-06/
      data totplnk( 51:100, 6) /                                        &
     &1.84365E-06,1.89799E-06,1.95341E-06,2.00991E-06,2.06750E-06,      &
     &2.12619E-06,2.18599E-06,2.24691E-06,2.30895E-06,2.37212E-06,      &
     &2.43643E-06,2.50189E-06,2.56851E-06,2.63628E-06,2.70523E-06,      &
     &2.77536E-06,2.84666E-06,2.91916E-06,2.99286E-06,3.06776E-06,      &
     &3.14387E-06,3.22120E-06,3.29975E-06,3.37953E-06,3.46054E-06,      &
     &3.54280E-06,3.62630E-06,3.71105E-06,3.79707E-06,3.88434E-06,      &
     &3.97288E-06,4.06270E-06,4.15380E-06,4.24617E-06,4.33984E-06,      &
     &4.43479E-06,4.53104E-06,4.62860E-06,4.72746E-06,4.82763E-06,      &
     &4.92911E-06,5.03191E-06,5.13603E-06,5.24147E-06,5.34824E-06,      &
     &5.45634E-06,5.56578E-06,5.67656E-06,5.78867E-06,5.90213E-06/
      data totplnk(101:150, 6) /                                        &
     &6.01694E-06,6.13309E-06,6.25060E-06,6.36947E-06,6.48968E-06,      &
     &6.61126E-06,6.73420E-06,6.85850E-06,6.98417E-06,7.11120E-06,      &
     &7.23961E-06,7.36938E-06,7.50053E-06,7.63305E-06,7.76694E-06,      &
     &7.90221E-06,8.03887E-06,8.17690E-06,8.31632E-06,8.45710E-06,      &
     &8.59928E-06,8.74282E-06,8.88776E-06,9.03409E-06,9.18179E-06,      &
     &9.33088E-06,9.48136E-06,9.63323E-06,9.78648E-06,9.94111E-06,      &
     &1.00971E-05,1.02545E-05,1.04133E-05,1.05735E-05,1.07351E-05,      &
     &1.08980E-05,1.10624E-05,1.12281E-05,1.13952E-05,1.15637E-05,      &
     &1.17335E-05,1.19048E-05,1.20774E-05,1.22514E-05,1.24268E-05,      &
     &1.26036E-05,1.27817E-05,1.29612E-05,1.31421E-05,1.33244E-05/
      data totplnk(151:181, 6) /                                        &
     &1.35080E-05,1.36930E-05,1.38794E-05,1.40672E-05,1.42563E-05,      &
     &1.44468E-05,1.46386E-05,1.48318E-05,1.50264E-05,1.52223E-05,      &
     &1.54196E-05,1.56182E-05,1.58182E-05,1.60196E-05,1.62223E-05,      &
     &1.64263E-05,1.66317E-05,1.68384E-05,1.70465E-05,1.72559E-05,      &
     &1.74666E-05,1.76787E-05,1.78921E-05,1.81069E-05,1.83230E-05,      &
     &1.85404E-05,1.87591E-05,1.89791E-05,1.92005E-05,1.94232E-05,      &
     &1.96471E-05/
      data totplnk(  1: 50, 7) /                                        &
     &1.25349E-07,1.32735E-07,1.40458E-07,1.48527E-07,1.56954E-07,      &
     &1.65748E-07,1.74920E-07,1.84481E-07,1.94443E-07,2.04814E-07,      &
     &2.15608E-07,2.26835E-07,2.38507E-07,2.50634E-07,2.63229E-07,      &
     &2.76301E-07,2.89864E-07,3.03930E-07,3.18508E-07,3.33612E-07,      &
     &3.49253E-07,3.65443E-07,3.82195E-07,3.99519E-07,4.17428E-07,      &
     &4.35934E-07,4.55050E-07,4.74785E-07,4.95155E-07,5.16170E-07,      &
     &5.37844E-07,5.60186E-07,5.83211E-07,6.06929E-07,6.31355E-07,      &
     &6.56498E-07,6.82373E-07,7.08990E-07,7.36362E-07,7.64501E-07,      &
     &7.93420E-07,8.23130E-07,8.53643E-07,8.84971E-07,9.17128E-07,      &
     &9.50123E-07,9.83969E-07,1.01868E-06,1.05426E-06,1.09073E-06/
      data totplnk( 51:100, 7) /                                        &
     &1.12810E-06,1.16638E-06,1.20558E-06,1.24572E-06,1.28680E-06,      &
     &1.32883E-06,1.37183E-06,1.41581E-06,1.46078E-06,1.50675E-06,      &
     &1.55374E-06,1.60174E-06,1.65078E-06,1.70087E-06,1.75200E-06,      &
     &1.80421E-06,1.85749E-06,1.91186E-06,1.96732E-06,2.02389E-06,      &
     &2.08159E-06,2.14040E-06,2.20035E-06,2.26146E-06,2.32372E-06,      &
     &2.38714E-06,2.45174E-06,2.51753E-06,2.58451E-06,2.65270E-06,      &
     &2.72210E-06,2.79272E-06,2.86457E-06,2.93767E-06,3.01201E-06,      &
     &3.08761E-06,3.16448E-06,3.24261E-06,3.32204E-06,3.40275E-06,      &
     &3.48476E-06,3.56808E-06,3.65271E-06,3.73866E-06,3.82595E-06,      &
     &3.91456E-06,4.00453E-06,4.09584E-06,4.18851E-06,4.28254E-06/
      data totplnk(101:150, 7) /                                        &
     &4.37796E-06,4.47475E-06,4.57293E-06,4.67249E-06,4.77346E-06,      &
     &4.87583E-06,4.97961E-06,5.08481E-06,5.19143E-06,5.29948E-06,      &
     &5.40896E-06,5.51989E-06,5.63226E-06,5.74608E-06,5.86136E-06,      &
     &5.97810E-06,6.09631E-06,6.21597E-06,6.33713E-06,6.45976E-06,      &
     &6.58388E-06,6.70950E-06,6.83661E-06,6.96521E-06,7.09531E-06,      &
     &7.22692E-06,7.36005E-06,7.49468E-06,7.63084E-06,7.76851E-06,      &
     &7.90773E-06,8.04846E-06,8.19072E-06,8.33452E-06,8.47985E-06,      &
     &8.62674E-06,8.77517E-06,8.92514E-06,9.07666E-06,9.22975E-06,      &
     &9.38437E-06,9.54057E-06,9.69832E-06,9.85762E-06,1.00185E-05,      &
     &1.01810E-05,1.03450E-05,1.05106E-05,1.06777E-05,1.08465E-05/
      data totplnk(151:181, 7) /                                        &
     &1.10168E-05,1.11887E-05,1.13621E-05,1.15372E-05,1.17138E-05,      &
     &1.18920E-05,1.20718E-05,1.22532E-05,1.24362E-05,1.26207E-05,      &
     &1.28069E-05,1.29946E-05,1.31839E-05,1.33749E-05,1.35674E-05,      &
     &1.37615E-05,1.39572E-05,1.41544E-05,1.43533E-05,1.45538E-05,      &
     &1.47558E-05,1.49595E-05,1.51647E-05,1.53716E-05,1.55800E-05,      &
     &1.57900E-05,1.60017E-05,1.62149E-05,1.64296E-05,1.66460E-05,      &
     &1.68640E-05/
      data totplnk(  1: 50, 8) /                                        &
     &6.74445E-08,7.18176E-08,7.64153E-08,8.12456E-08,8.63170E-08,      &
     &9.16378E-08,9.72168E-08,1.03063E-07,1.09184E-07,1.15591E-07,      &
     &1.22292E-07,1.29296E-07,1.36613E-07,1.44253E-07,1.52226E-07,      &
     &1.60540E-07,1.69207E-07,1.78236E-07,1.87637E-07,1.97421E-07,      &
     &2.07599E-07,2.18181E-07,2.29177E-07,2.40598E-07,2.52456E-07,      &
     &2.64761E-07,2.77523E-07,2.90755E-07,3.04468E-07,3.18673E-07,      &
     &3.33381E-07,3.48603E-07,3.64352E-07,3.80638E-07,3.97474E-07,      &
     &4.14871E-07,4.32841E-07,4.51395E-07,4.70547E-07,4.90306E-07,      &
     &5.10687E-07,5.31699E-07,5.53357E-07,5.75670E-07,5.98652E-07,      &
     &6.22315E-07,6.46672E-07,6.71731E-07,6.97511E-07,7.24018E-07/
      data totplnk( 51:100, 8) /                                        &
     &7.51266E-07,7.79269E-07,8.08038E-07,8.37584E-07,8.67922E-07,      &
     &8.99061E-07,9.31016E-07,9.63797E-07,9.97417E-07,1.03189E-06,      &
     &1.06722E-06,1.10343E-06,1.14053E-06,1.17853E-06,1.21743E-06,      &
     &1.25726E-06,1.29803E-06,1.33974E-06,1.38241E-06,1.42606E-06,      &
     &1.47068E-06,1.51630E-06,1.56293E-06,1.61056E-06,1.65924E-06,      &
     &1.70894E-06,1.75971E-06,1.81153E-06,1.86443E-06,1.91841E-06,      &
     &1.97350E-06,2.02968E-06,2.08699E-06,2.14543E-06,2.20500E-06,      &
     &2.26573E-06,2.32762E-06,2.39068E-06,2.45492E-06,2.52036E-06,      &
     &2.58700E-06,2.65485E-06,2.72393E-06,2.79424E-06,2.86580E-06,      &
     &2.93861E-06,3.01269E-06,3.08803E-06,3.16467E-06,3.24259E-06/
      data totplnk(101:150, 8) /                                        &
     &3.32181E-06,3.40235E-06,3.48420E-06,3.56739E-06,3.65192E-06,      &
     &3.73779E-06,3.82502E-06,3.91362E-06,4.00359E-06,4.09494E-06,      &
     &4.18768E-06,4.28182E-06,4.37737E-06,4.47434E-06,4.57273E-06,      &
     &4.67254E-06,4.77380E-06,4.87651E-06,4.98067E-06,5.08630E-06,      &
     &5.19339E-06,5.30196E-06,5.41201E-06,5.52356E-06,5.63660E-06,      &
     &5.75116E-06,5.86722E-06,5.98479E-06,6.10390E-06,6.22453E-06,      &
     &6.34669E-06,6.47042E-06,6.59569E-06,6.72252E-06,6.85090E-06,      &
     &6.98085E-06,7.11238E-06,7.24549E-06,7.38019E-06,7.51646E-06,      &
     &7.65434E-06,7.79382E-06,7.93490E-06,8.07760E-06,8.22192E-06,      &
     &8.36784E-06,8.51540E-06,8.66459E-06,8.81542E-06,8.96786E-06/
      data totplnk(151:181, 8) /                                        &
     &9.12197E-06,9.27772E-06,9.43513E-06,9.59419E-06,9.75490E-06,      &
     &9.91728E-06,1.00813E-05,1.02471E-05,1.04144E-05,1.05835E-05,      &
     &1.07543E-05,1.09267E-05,1.11008E-05,1.12766E-05,1.14541E-05,      &
     &1.16333E-05,1.18142E-05,1.19969E-05,1.21812E-05,1.23672E-05,      &
     &1.25549E-05,1.27443E-05,1.29355E-05,1.31284E-05,1.33229E-05,      &
     &1.35193E-05,1.37173E-05,1.39170E-05,1.41185E-05,1.43217E-05,      &
     &1.45267E-05/
      data totplnk(  1: 50, 9) /                                        &
     &2.61522E-08,2.80613E-08,3.00838E-08,3.22250E-08,3.44899E-08,      &
     &3.68841E-08,3.94129E-08,4.20820E-08,4.48973E-08,4.78646E-08,      &
     &5.09901E-08,5.42799E-08,5.77405E-08,6.13784E-08,6.52001E-08,      &
     &6.92126E-08,7.34227E-08,7.78375E-08,8.24643E-08,8.73103E-08,      &
     &9.23832E-08,9.76905E-08,1.03240E-07,1.09039E-07,1.15097E-07,      &
     &1.21421E-07,1.28020E-07,1.34902E-07,1.42075E-07,1.49548E-07,      &
     &1.57331E-07,1.65432E-07,1.73860E-07,1.82624E-07,1.91734E-07,      &
     &2.01198E-07,2.11028E-07,2.21231E-07,2.31818E-07,2.42799E-07,      &
     &2.54184E-07,2.65983E-07,2.78205E-07,2.90862E-07,3.03963E-07,      &
     &3.17519E-07,3.31541E-07,3.46039E-07,3.61024E-07,3.76507E-07/
      data totplnk( 51:100, 9) /                                        &
     &3.92498E-07,4.09008E-07,4.26050E-07,4.43633E-07,4.61769E-07,      &
     &4.80469E-07,4.99744E-07,5.19606E-07,5.40067E-07,5.61136E-07,      &
     &5.82828E-07,6.05152E-07,6.28120E-07,6.51745E-07,6.76038E-07,      &
     &7.01010E-07,7.26674E-07,7.53041E-07,7.80124E-07,8.07933E-07,      &
     &8.36482E-07,8.65781E-07,8.95845E-07,9.26683E-07,9.58308E-07,      &
     &9.90732E-07,1.02397E-06,1.05803E-06,1.09292E-06,1.12866E-06,      &
     &1.16526E-06,1.20274E-06,1.24109E-06,1.28034E-06,1.32050E-06,      &
     &1.36158E-06,1.40359E-06,1.44655E-06,1.49046E-06,1.53534E-06,      &
     &1.58120E-06,1.62805E-06,1.67591E-06,1.72478E-06,1.77468E-06,      &
     &1.82561E-06,1.87760E-06,1.93066E-06,1.98479E-06,2.04000E-06/
      data totplnk(101:150, 9) /                                        &
     &2.09631E-06,2.15373E-06,2.21228E-06,2.27196E-06,2.33278E-06,      &
     &2.39475E-06,2.45790E-06,2.52222E-06,2.58773E-06,2.65445E-06,      &
     &2.72238E-06,2.79152E-06,2.86191E-06,2.93354E-06,3.00643E-06,      &
     &3.08058E-06,3.15601E-06,3.23273E-06,3.31075E-06,3.39009E-06,      &
     &3.47074E-06,3.55272E-06,3.63605E-06,3.72072E-06,3.80676E-06,      &
     &3.89417E-06,3.98297E-06,4.07315E-06,4.16474E-06,4.25774E-06,      &
     &4.35217E-06,4.44802E-06,4.54532E-06,4.64406E-06,4.74428E-06,      &
     &4.84595E-06,4.94911E-06,5.05376E-06,5.15990E-06,5.26755E-06,      &
     &5.37671E-06,5.48741E-06,5.59963E-06,5.71340E-06,5.82871E-06,      &
     &5.94559E-06,6.06403E-06,6.18404E-06,6.30565E-06,6.42885E-06/
      data totplnk(151:181, 9) /                                        &
     &6.55364E-06,6.68004E-06,6.80806E-06,6.93771E-06,7.06898E-06,      &
     &7.20190E-06,7.33646E-06,7.47267E-06,7.61056E-06,7.75010E-06,      &
     &7.89133E-06,8.03423E-06,8.17884E-06,8.32514E-06,8.47314E-06,      &
     &8.62284E-06,8.77427E-06,8.92743E-06,9.08231E-06,9.23893E-06,      &
     &9.39729E-06,9.55741E-06,9.71927E-06,9.88291E-06,1.00483E-05,      &
     &1.02155E-05,1.03844E-05,1.05552E-05,1.07277E-05,1.09020E-05,      &
     &1.10781E-05/
      data totplnk(  1: 50,10) /                                        &
     &8.89300E-09,9.63263E-09,1.04235E-08,1.12685E-08,1.21703E-08,      &
     &1.31321E-08,1.41570E-08,1.52482E-08,1.64090E-08,1.76428E-08,      &
     &1.89533E-08,2.03441E-08,2.18190E-08,2.33820E-08,2.50370E-08,      &
     &2.67884E-08,2.86402E-08,3.05969E-08,3.26632E-08,3.48436E-08,      &
     &3.71429E-08,3.95660E-08,4.21179E-08,4.48040E-08,4.76294E-08,      &
     &5.05996E-08,5.37201E-08,5.69966E-08,6.04349E-08,6.40411E-08,      &
     &6.78211E-08,7.17812E-08,7.59276E-08,8.02670E-08,8.48059E-08,      &
     &8.95508E-08,9.45090E-08,9.96873E-08,1.05093E-07,1.10733E-07,      &
     &1.16614E-07,1.22745E-07,1.29133E-07,1.35786E-07,1.42711E-07,      &
     &1.49916E-07,1.57410E-07,1.65202E-07,1.73298E-07,1.81709E-07/
      data totplnk( 51:100,10) /                                        &
     &1.90441E-07,1.99505E-07,2.08908E-07,2.18660E-07,2.28770E-07,      &
     &2.39247E-07,2.50101E-07,2.61340E-07,2.72974E-07,2.85013E-07,      &
     &2.97467E-07,3.10345E-07,3.23657E-07,3.37413E-07,3.51623E-07,      &
     &3.66298E-07,3.81448E-07,3.97082E-07,4.13212E-07,4.29848E-07,      &
     &4.47000E-07,4.64680E-07,4.82898E-07,5.01664E-07,5.20991E-07,      &
     &5.40888E-07,5.61369E-07,5.82440E-07,6.04118E-07,6.26410E-07,      &
     &6.49329E-07,6.72887E-07,6.97095E-07,7.21964E-07,7.47506E-07,      &
     &7.73732E-07,8.00655E-07,8.28287E-07,8.56635E-07,8.85717E-07,      &
     &9.15542E-07,9.46122E-07,9.77469E-07,1.00960E-06,1.04251E-06,      &
     &1.07623E-06,1.11077E-06,1.14613E-06,1.18233E-06,1.21939E-06/
      data totplnk(101:150,10) /                                        &
     &1.25730E-06,1.29610E-06,1.33578E-06,1.37636E-06,1.41785E-06,      &
     &1.46027E-06,1.50362E-06,1.54792E-06,1.59319E-06,1.63942E-06,      &
     &1.68665E-06,1.73487E-06,1.78410E-06,1.83435E-06,1.88564E-06,      &
     &1.93797E-06,1.99136E-06,2.04582E-06,2.10137E-06,2.15801E-06,      &
     &2.21576E-06,2.27463E-06,2.33462E-06,2.39577E-06,2.45806E-06,      &
     &2.52153E-06,2.58617E-06,2.65201E-06,2.71905E-06,2.78730E-06,      &
     &2.85678E-06,2.92749E-06,2.99946E-06,3.07269E-06,3.14720E-06,      &
     &3.22299E-06,3.30007E-06,3.37847E-06,3.45818E-06,3.53923E-06,      &
     &3.62161E-06,3.70535E-06,3.79046E-06,3.87695E-06,3.96481E-06,      &
     &4.05409E-06,4.14477E-06,4.23687E-06,4.33040E-06,4.42538E-06/
      data totplnk(151:181,10) /                                        &
     &4.52180E-06,4.61969E-06,4.71905E-06,4.81991E-06,4.92226E-06,      &
     &5.02611E-06,5.13148E-06,5.23839E-06,5.34681E-06,5.45681E-06,      &
     &5.56835E-06,5.68146E-06,5.79614E-06,5.91242E-06,6.03030E-06,      &
     &6.14978E-06,6.27088E-06,6.39360E-06,6.51798E-06,6.64398E-06,      &
     &6.77165E-06,6.90099E-06,7.03198E-06,7.16468E-06,7.29906E-06,      &
     &7.43514E-06,7.57294E-06,7.71244E-06,7.85369E-06,7.99666E-06,      &
     &8.14138E-06/
      data totplnk(  1: 50,11) /                                        &
     &2.53767E-09,2.77242E-09,3.02564E-09,3.29851E-09,3.59228E-09,      &
     &3.90825E-09,4.24777E-09,4.61227E-09,5.00322E-09,5.42219E-09,      &
     &5.87080E-09,6.35072E-09,6.86370E-09,7.41159E-09,7.99628E-09,      &
     &8.61974E-09,9.28404E-09,9.99130E-09,1.07437E-08,1.15436E-08,      &
     &1.23933E-08,1.32953E-08,1.42522E-08,1.52665E-08,1.63410E-08,      &
     &1.74786E-08,1.86820E-08,1.99542E-08,2.12985E-08,2.27179E-08,      &
     &2.42158E-08,2.57954E-08,2.74604E-08,2.92141E-08,3.10604E-08,      &
     &3.30029E-08,3.50457E-08,3.71925E-08,3.94476E-08,4.18149E-08,      &
     &4.42991E-08,4.69043E-08,4.96352E-08,5.24961E-08,5.54921E-08,      &
     &5.86277E-08,6.19081E-08,6.53381E-08,6.89231E-08,7.26681E-08/
      data totplnk( 51:100,11) /                                        &
     &7.65788E-08,8.06604E-08,8.49187E-08,8.93591E-08,9.39879E-08,      &
     &9.88106E-08,1.03834E-07,1.09063E-07,1.14504E-07,1.20165E-07,      &
     &1.26051E-07,1.32169E-07,1.38525E-07,1.45128E-07,1.51982E-07,      &
     &1.59096E-07,1.66477E-07,1.74132E-07,1.82068E-07,1.90292E-07,      &
     &1.98813E-07,2.07638E-07,2.16775E-07,2.26231E-07,2.36015E-07,      &
     &2.46135E-07,2.56599E-07,2.67415E-07,2.78592E-07,2.90137E-07,      &
     &3.02061E-07,3.14371E-07,3.27077E-07,3.40186E-07,3.53710E-07,      &
     &3.67655E-07,3.82031E-07,3.96848E-07,4.12116E-07,4.27842E-07,      &
     &4.44039E-07,4.60713E-07,4.77876E-07,4.95537E-07,5.13706E-07,      &
     &5.32392E-07,5.51608E-07,5.71360E-07,5.91662E-07,6.12521E-07/
      data totplnk(101:150,11) /                                        &
     &6.33950E-07,6.55958E-07,6.78556E-07,7.01753E-07,7.25562E-07,      &
     &7.49992E-07,7.75055E-07,8.00760E-07,8.27120E-07,8.54145E-07,      &
     &8.81845E-07,9.10233E-07,9.39318E-07,9.69113E-07,9.99627E-07,      &
     &1.03087E-06,1.06286E-06,1.09561E-06,1.12912E-06,1.16340E-06,      &
     &1.19848E-06,1.23435E-06,1.27104E-06,1.30855E-06,1.34690E-06,      &
     &1.38609E-06,1.42614E-06,1.46706E-06,1.50886E-06,1.55155E-06,      &
     &1.59515E-06,1.63967E-06,1.68512E-06,1.73150E-06,1.77884E-06,      &
     &1.82715E-06,1.87643E-06,1.92670E-06,1.97797E-06,2.03026E-06,      &
     &2.08356E-06,2.13791E-06,2.19330E-06,2.24975E-06,2.30728E-06,      &
     &2.36589E-06,2.42560E-06,2.48641E-06,2.54835E-06,2.61142E-06/
      data totplnk(151:181,11) /                                        &
     &2.67563E-06,2.74100E-06,2.80754E-06,2.87526E-06,2.94417E-06,      &
     &3.01429E-06,3.08562E-06,3.15819E-06,3.23199E-06,3.30704E-06,      &
     &3.38336E-06,3.46096E-06,3.53984E-06,3.62002E-06,3.70151E-06,      &
     &3.78433E-06,3.86848E-06,3.95399E-06,4.04084E-06,4.12907E-06,      &
     &4.21868E-06,4.30968E-06,4.40209E-06,4.49592E-06,4.59117E-06,      &
     &4.68786E-06,4.78600E-06,4.88561E-06,4.98669E-06,5.08926E-06,      &
     &5.19332E-06/
      data totplnk(  1: 50,12) /                                        &
     &2.73921E-10,3.04500E-10,3.38056E-10,3.74835E-10,4.15099E-10,      &
     &4.59126E-10,5.07214E-10,5.59679E-10,6.16857E-10,6.79103E-10,      &
     &7.46796E-10,8.20335E-10,9.00144E-10,9.86671E-10,1.08039E-09,      &
     &1.18180E-09,1.29142E-09,1.40982E-09,1.53757E-09,1.67529E-09,      &
     &1.82363E-09,1.98327E-09,2.15492E-09,2.33932E-09,2.53726E-09,      &
     &2.74957E-09,2.97710E-09,3.22075E-09,3.48145E-09,3.76020E-09,      &
     &4.05801E-09,4.37595E-09,4.71513E-09,5.07672E-09,5.46193E-09,      &
     &5.87201E-09,6.30827E-09,6.77205E-09,7.26480E-09,7.78794E-09,      &
     &8.34304E-09,8.93163E-09,9.55537E-09,1.02159E-08,1.09151E-08,      &
     &1.16547E-08,1.24365E-08,1.32625E-08,1.41348E-08,1.50554E-08/
      data totplnk( 51:100,12) /                                        &
     &1.60264E-08,1.70500E-08,1.81285E-08,1.92642E-08,2.04596E-08,      &
     &2.17171E-08,2.30394E-08,2.44289E-08,2.58885E-08,2.74209E-08,      &
     &2.90290E-08,3.07157E-08,3.24841E-08,3.43371E-08,3.62782E-08,      &
     &3.83103E-08,4.04371E-08,4.26617E-08,4.49878E-08,4.74190E-08,      &
     &4.99589E-08,5.26113E-08,5.53801E-08,5.82692E-08,6.12826E-08,      &
     &6.44245E-08,6.76991E-08,7.11105E-08,7.46634E-08,7.83621E-08,      &
     &8.22112E-08,8.62154E-08,9.03795E-08,9.47081E-08,9.92066E-08,      &
     &1.03879E-07,1.08732E-07,1.13770E-07,1.18998E-07,1.24422E-07,      &
     &1.30048E-07,1.35880E-07,1.41924E-07,1.48187E-07,1.54675E-07,      &
     &1.61392E-07,1.68346E-07,1.75543E-07,1.82988E-07,1.90688E-07/
      data totplnk(101:150,12) /                                        &
     &1.98650E-07,2.06880E-07,2.15385E-07,2.24172E-07,2.33247E-07,      &
     &2.42617E-07,2.52289E-07,2.62272E-07,2.72571E-07,2.83193E-07,      &
     &2.94147E-07,3.05440E-07,3.17080E-07,3.29074E-07,3.41430E-07,      &
     &3.54155E-07,3.67259E-07,3.80747E-07,3.94631E-07,4.08916E-07,      &
     &4.23611E-07,4.38725E-07,4.54267E-07,4.70245E-07,4.86666E-07,      &
     &5.03541E-07,5.20879E-07,5.38687E-07,5.56975E-07,5.75751E-07,      &
     &5.95026E-07,6.14808E-07,6.35107E-07,6.55932E-07,6.77293E-07,      &
     &6.99197E-07,7.21656E-07,7.44681E-07,7.68278E-07,7.92460E-07,      &
     &8.17235E-07,8.42614E-07,8.68606E-07,8.95223E-07,9.22473E-07,      &
     &9.50366E-07,9.78915E-07,1.00813E-06,1.03802E-06,1.06859E-06/
      data totplnk(151:181,12) /                                        &
     &1.09986E-06,1.13184E-06,1.16453E-06,1.19796E-06,1.23212E-06,      &
     &1.26703E-06,1.30270E-06,1.33915E-06,1.37637E-06,1.41440E-06,      &
     &1.45322E-06,1.49286E-06,1.53333E-06,1.57464E-06,1.61679E-06,      &
     &1.65981E-06,1.70370E-06,1.74847E-06,1.79414E-06,1.84071E-06,      &
     &1.88821E-06,1.93663E-06,1.98599E-06,2.03631E-06,2.08759E-06,      &
     &2.13985E-06,2.19310E-06,2.24734E-06,2.30260E-06,2.35888E-06,      &
     &2.41619E-06/
      data totplnk(  1: 50,13) /                                        &
     &4.53634E-11,5.11435E-11,5.75754E-11,6.47222E-11,7.26531E-11,      &
     &8.14420E-11,9.11690E-11,1.01921E-10,1.13790E-10,1.26877E-10,      &
     &1.41288E-10,1.57140E-10,1.74555E-10,1.93665E-10,2.14613E-10,      &
     &2.37548E-10,2.62633E-10,2.90039E-10,3.19948E-10,3.52558E-10,      &
     &3.88073E-10,4.26716E-10,4.68719E-10,5.14331E-10,5.63815E-10,      &
     &6.17448E-10,6.75526E-10,7.38358E-10,8.06277E-10,8.79625E-10,      &
     &9.58770E-10,1.04410E-09,1.13602E-09,1.23495E-09,1.34135E-09,      &
     &1.45568E-09,1.57845E-09,1.71017E-09,1.85139E-09,2.00268E-09,      &
     &2.16464E-09,2.33789E-09,2.52309E-09,2.72093E-09,2.93212E-09,      &
     &3.15740E-09,3.39757E-09,3.65341E-09,3.92579E-09,4.21559E-09/
      data totplnk( 51:100,13) /                                        &
     &4.52372E-09,4.85115E-09,5.19886E-09,5.56788E-09,5.95928E-09,      &
     &6.37419E-09,6.81375E-09,7.27917E-09,7.77168E-09,8.29256E-09,      &
     &8.84317E-09,9.42487E-09,1.00391E-08,1.06873E-08,1.13710E-08,      &
     &1.20919E-08,1.28515E-08,1.36514E-08,1.44935E-08,1.53796E-08,      &
     &1.63114E-08,1.72909E-08,1.83201E-08,1.94008E-08,2.05354E-08,      &
     &2.17258E-08,2.29742E-08,2.42830E-08,2.56545E-08,2.70910E-08,      &
     &2.85950E-08,3.01689E-08,3.18155E-08,3.35373E-08,3.53372E-08,      &
     &3.72177E-08,3.91818E-08,4.12325E-08,4.33727E-08,4.56056E-08,      &
     &4.79342E-08,5.03617E-08,5.28915E-08,5.55270E-08,5.82715E-08,      &
     &6.11286E-08,6.41019E-08,6.71951E-08,7.04119E-08,7.37560E-08/
      data totplnk(101:150,13) /                                        &
     &7.72315E-08,8.08424E-08,8.45927E-08,8.84866E-08,9.25281E-08,      &
     &9.67218E-08,1.01072E-07,1.05583E-07,1.10260E-07,1.15107E-07,      &
     &1.20128E-07,1.25330E-07,1.30716E-07,1.36291E-07,1.42061E-07,      &
     &1.48031E-07,1.54206E-07,1.60592E-07,1.67192E-07,1.74015E-07,      &
     &1.81064E-07,1.88345E-07,1.95865E-07,2.03628E-07,2.11643E-07,      &
     &2.19912E-07,2.28443E-07,2.37244E-07,2.46318E-07,2.55673E-07,      &
     &2.65316E-07,2.75252E-07,2.85489E-07,2.96033E-07,3.06891E-07,      &
     &3.18070E-07,3.29576E-07,3.41417E-07,3.53600E-07,3.66133E-07,      &
     &3.79021E-07,3.92274E-07,4.05897E-07,4.19899E-07,4.34288E-07,      &
     &4.49071E-07,4.64255E-07,4.79850E-07,4.95863E-07,5.12300E-07/
      data totplnk(151:181,13) /                                        &
     &5.29172E-07,5.46486E-07,5.64250E-07,5.82473E-07,6.01164E-07,      &
     &6.20329E-07,6.39979E-07,6.60122E-07,6.80767E-07,7.01922E-07,      &
     &7.23596E-07,7.45800E-07,7.68539E-07,7.91826E-07,8.15669E-07,      &
     &8.40076E-07,8.65058E-07,8.90623E-07,9.16783E-07,9.43544E-07,      &
     &9.70917E-07,9.98912E-07,1.02754E-06,1.05681E-06,1.08673E-06,      &
     &1.11731E-06,1.14856E-06,1.18050E-06,1.21312E-06,1.24645E-06,      &
     &1.28049E-06/
      data totplnk(  1: 50,14) /                                        &
     &1.40113E-11,1.59358E-11,1.80960E-11,2.05171E-11,2.32266E-11,      &
     &2.62546E-11,2.96335E-11,3.33990E-11,3.75896E-11,4.22469E-11,      &
     &4.74164E-11,5.31466E-11,5.94905E-11,6.65054E-11,7.42522E-11,      &
     &8.27975E-11,9.22122E-11,1.02573E-10,1.13961E-10,1.26466E-10,      &
     &1.40181E-10,1.55206E-10,1.71651E-10,1.89630E-10,2.09265E-10,      &
     &2.30689E-10,2.54040E-10,2.79467E-10,3.07128E-10,3.37190E-10,      &
     &3.69833E-10,4.05243E-10,4.43623E-10,4.85183E-10,5.30149E-10,      &
     &5.78755E-10,6.31255E-10,6.87910E-10,7.49002E-10,8.14824E-10,      &
     &8.85687E-10,9.61914E-10,1.04385E-09,1.13186E-09,1.22631E-09,      &
     &1.32761E-09,1.43617E-09,1.55243E-09,1.67686E-09,1.80992E-09/
      data totplnk( 51:100,14) /                                        &
     &1.95212E-09,2.10399E-09,2.26607E-09,2.43895E-09,2.62321E-09,      &
     &2.81949E-09,3.02844E-09,3.25073E-09,3.48707E-09,3.73820E-09,      &
     &4.00490E-09,4.28794E-09,4.58819E-09,4.90647E-09,5.24371E-09,      &
     &5.60081E-09,5.97875E-09,6.37854E-09,6.80120E-09,7.24782E-09,      &
     &7.71950E-09,8.21740E-09,8.74271E-09,9.29666E-09,9.88054E-09,      &
     &1.04956E-08,1.11434E-08,1.18251E-08,1.25422E-08,1.32964E-08,      &
     &1.40890E-08,1.49217E-08,1.57961E-08,1.67140E-08,1.76771E-08,      &
     &1.86870E-08,1.97458E-08,2.08553E-08,2.20175E-08,2.32342E-08,      &
     &2.45077E-08,2.58401E-08,2.72334E-08,2.86900E-08,3.02122E-08,      &
     &3.18021E-08,3.34624E-08,3.51954E-08,3.70037E-08,3.88899E-08/
      data totplnk(101:150,14) /                                        &
     &4.08568E-08,4.29068E-08,4.50429E-08,4.72678E-08,4.95847E-08,      &
     &5.19963E-08,5.45058E-08,5.71161E-08,5.98309E-08,6.26529E-08,      &
     &6.55857E-08,6.86327E-08,7.17971E-08,7.50829E-08,7.84933E-08,      &
     &8.20323E-08,8.57035E-08,8.95105E-08,9.34579E-08,9.75488E-08,      &
     &1.01788E-07,1.06179E-07,1.10727E-07,1.15434E-07,1.20307E-07,      &
     &1.25350E-07,1.30566E-07,1.35961E-07,1.41539E-07,1.47304E-07,      &
     &1.53263E-07,1.59419E-07,1.65778E-07,1.72345E-07,1.79124E-07,      &
     &1.86122E-07,1.93343E-07,2.00792E-07,2.08476E-07,2.16400E-07,      &
     &2.24568E-07,2.32988E-07,2.41666E-07,2.50605E-07,2.59813E-07,      &
     &2.69297E-07,2.79060E-07,2.89111E-07,2.99455E-07,3.10099E-07/
      data totplnk(151:181,14) /                                        &
     &3.21049E-07,3.32311E-07,3.43893E-07,3.55801E-07,3.68041E-07,      &
     &3.80621E-07,3.93547E-07,4.06826E-07,4.20465E-07,4.34473E-07,      &
     &4.48856E-07,4.63620E-07,4.78774E-07,4.94325E-07,5.10280E-07,      &
     &5.26648E-07,5.43436E-07,5.60652E-07,5.78302E-07,5.96397E-07,      &
     &6.14943E-07,6.33949E-07,6.53421E-07,6.73370E-07,6.93803E-07,      &
     &7.14731E-07,7.36157E-07,7.58095E-07,7.80549E-07,8.03533E-07,      &
     &8.27050E-07/
      data totplnk(  1: 50,15) /                                        &
     &3.90483E-12,4.47999E-12,5.13122E-12,5.86739E-12,6.69829E-12,      &
     &7.63467E-12,8.68833E-12,9.87221E-12,1.12005E-11,1.26885E-11,      &
     &1.43534E-11,1.62134E-11,1.82888E-11,2.06012E-11,2.31745E-11,      &
     &2.60343E-11,2.92087E-11,3.27277E-11,3.66242E-11,4.09334E-11,      &
     &4.56935E-11,5.09455E-11,5.67338E-11,6.31057E-11,7.01127E-11,      &
     &7.78096E-11,8.62554E-11,9.55130E-11,1.05651E-10,1.16740E-10,      &
     &1.28858E-10,1.42089E-10,1.56519E-10,1.72243E-10,1.89361E-10,      &
     &2.07978E-10,2.28209E-10,2.50173E-10,2.73999E-10,2.99820E-10,      &
     &3.27782E-10,3.58034E-10,3.90739E-10,4.26067E-10,4.64196E-10,      &
     &5.05317E-10,5.49631E-10,5.97347E-10,6.48689E-10,7.03891E-10/
      data totplnk( 51:100,15) /                                        &
     &7.63201E-10,8.26876E-10,8.95192E-10,9.68430E-10,1.04690E-09,      &
     &1.13091E-09,1.22079E-09,1.31689E-09,1.41957E-09,1.52922E-09,      &
     &1.64623E-09,1.77101E-09,1.90401E-09,2.04567E-09,2.19647E-09,      &
     &2.35690E-09,2.52749E-09,2.70875E-09,2.90127E-09,3.10560E-09,      &
     &3.32238E-09,3.55222E-09,3.79578E-09,4.05375E-09,4.32682E-09,      &
     &4.61574E-09,4.92128E-09,5.24420E-09,5.58536E-09,5.94558E-09,      &
     &6.32575E-09,6.72678E-09,7.14964E-09,7.59526E-09,8.06470E-09,      &
     &8.55897E-09,9.07916E-09,9.62638E-09,1.02018E-08,1.08066E-08,      &
     &1.14420E-08,1.21092E-08,1.28097E-08,1.35446E-08,1.43155E-08,      &
     &1.51237E-08,1.59708E-08,1.68581E-08,1.77873E-08,1.87599E-08/
      data totplnk(101:150,15) /                                        &
     &1.97777E-08,2.08423E-08,2.19555E-08,2.31190E-08,2.43348E-08,      &
     &2.56045E-08,2.69302E-08,2.83140E-08,2.97578E-08,3.12636E-08,      &
     &3.28337E-08,3.44702E-08,3.61755E-08,3.79516E-08,3.98012E-08,      &
     &4.17265E-08,4.37300E-08,4.58143E-08,4.79819E-08,5.02355E-08,      &
     &5.25777E-08,5.50114E-08,5.75393E-08,6.01644E-08,6.28896E-08,      &
     &6.57177E-08,6.86521E-08,7.16959E-08,7.48520E-08,7.81239E-08,      &
     &8.15148E-08,8.50282E-08,8.86675E-08,9.24362E-08,9.63380E-08,      &
     &1.00376E-07,1.04555E-07,1.08878E-07,1.13349E-07,1.17972E-07,      &
     &1.22751E-07,1.27690E-07,1.32793E-07,1.38064E-07,1.43508E-07,      &
     &1.49129E-07,1.54931E-07,1.60920E-07,1.67099E-07,1.73473E-07/
      data totplnk(151:181,15) /                                        &
     &1.80046E-07,1.86825E-07,1.93812E-07,2.01014E-07,2.08436E-07,      &
     &2.16082E-07,2.23957E-07,2.32067E-07,2.40418E-07,2.49013E-07,      &
     &2.57860E-07,2.66963E-07,2.76328E-07,2.85961E-07,2.95868E-07,      &
     &3.06053E-07,3.16524E-07,3.27286E-07,3.38345E-07,3.49707E-07,      &
     &3.61379E-07,3.73367E-07,3.85676E-07,3.98315E-07,4.11287E-07,      &
     &4.24602E-07,4.38265E-07,4.52283E-07,4.66662E-07,4.81410E-07,      &
     &4.96535E-07/
      data totplnk(  1: 50,16) /                                        &
     &4.65378E-13,5.41927E-13,6.29913E-13,7.30869E-13,8.46510E-13,      &
     &9.78750E-13,1.12972E-12,1.30181E-12,1.49764E-12,1.72016E-12,      &
     &1.97260E-12,2.25858E-12,2.58206E-12,2.94744E-12,3.35955E-12,      &
     &3.82372E-12,4.34581E-12,4.93225E-12,5.59010E-12,6.32711E-12,      &
     &7.15171E-12,8.07317E-12,9.10159E-12,1.02480E-11,1.15244E-11,      &
     &1.29438E-11,1.45204E-11,1.62697E-11,1.82084E-11,2.03545E-11,      &
     &2.27278E-11,2.53494E-11,2.82424E-11,3.14313E-11,3.49431E-11,      &
     &3.88064E-11,4.30522E-11,4.77139E-11,5.28273E-11,5.84308E-11,      &
     &6.45658E-11,7.12764E-11,7.86103E-11,8.66176E-11,9.53534E-11,      &
     &1.04875E-10,1.15245E-10,1.26528E-10,1.38796E-10,1.52123E-10/
      data totplnk( 51:100,16) /                                        &
     &1.66590E-10,1.82281E-10,1.99287E-10,2.17704E-10,2.37632E-10,      &
     &2.59182E-10,2.82468E-10,3.07610E-10,3.34738E-10,3.63988E-10,      &
     &3.95504E-10,4.29438E-10,4.65951E-10,5.05212E-10,5.47402E-10,      &
     &5.92707E-10,6.41329E-10,6.93477E-10,7.49371E-10,8.09242E-10,      &
     &8.73338E-10,9.41911E-10,1.01524E-09,1.09359E-09,1.17728E-09,      &
     &1.26660E-09,1.36190E-09,1.46350E-09,1.57177E-09,1.68709E-09,      &
     &1.80984E-09,1.94044E-09,2.07932E-09,2.22693E-09,2.38373E-09,      &
     &2.55021E-09,2.72689E-09,2.91429E-09,3.11298E-09,3.32353E-09,      &
     &3.54655E-09,3.78265E-09,4.03251E-09,4.29679E-09,4.57620E-09,      &
     &4.87148E-09,5.18341E-09,5.51276E-09,5.86037E-09,6.22708E-09/
      data totplnk(101:150,16) /                                        &
     &6.61381E-09,7.02145E-09,7.45097E-09,7.90336E-09,8.37967E-09,      &
     &8.88092E-09,9.40827E-09,9.96280E-09,1.05457E-08,1.11583E-08,      &
     &1.18017E-08,1.24773E-08,1.31865E-08,1.39306E-08,1.47111E-08,      &
     &1.55295E-08,1.63872E-08,1.72860E-08,1.82274E-08,1.92132E-08,      &
     &2.02450E-08,2.13247E-08,2.24541E-08,2.36352E-08,2.48699E-08,      &
     &2.61602E-08,2.75082E-08,2.89161E-08,3.03860E-08,3.19203E-08,      &
     &3.35213E-08,3.51913E-08,3.69330E-08,3.87486E-08,4.06411E-08,      &
     &4.26129E-08,4.46668E-08,4.68058E-08,4.90325E-08,5.13502E-08,      &
     &5.37617E-08,5.62703E-08,5.88791E-08,6.15915E-08,6.44107E-08,      &
     &6.73404E-08,7.03841E-08,7.35453E-08,7.68278E-08,8.02355E-08/
      data totplnk(151:181,16) /                                        &
     &8.37721E-08,8.74419E-08,9.12486E-08,9.51968E-08,9.92905E-08,      &
     &1.03534E-07,1.07932E-07,1.12490E-07,1.17211E-07,1.22100E-07,      &
     &1.27163E-07,1.32404E-07,1.37829E-07,1.43443E-07,1.49250E-07,      &
     &1.55257E-07,1.61470E-07,1.67893E-07,1.74532E-07,1.81394E-07,      &
     &1.88485E-07,1.95810E-07,2.03375E-07,2.11189E-07,2.19256E-07,      &
     &2.27583E-07,2.36177E-07,2.45046E-07,2.54196E-07,2.63634E-07,      &
     &2.73367E-07/

!........................................!
      end module module_radlw_avplank_nmmb!
!========================================!



!========================================!
      module module_radlw_cldprlw_nmmb   !
!........................................!
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NBANDS
!
      implicit none
!
      private

      real (kind=kind_phys), public ::                                  &
     &       absice0(2), absice1(2,5), absice2(40,16),                  &
     &       absliq1, absliq2, absliq3(58,16),                          &
     &       absrain, abssnow0, abssnow1

      integer, public :: ipat(NBANDS)

! --- ipat is bands index for ebert & curry ice cloud (for iflagice=1)
      data ipat / 1, 2, 3,3,3, 4,4,4, 5,5,5,5,5,5,5,5 /

! --- absrain is the rain drop absorption coefficient (m2/g)
!     data absrain / 3.07e-3 /          ! chou coeff
      data absrain / 0.33e-3 /          ! ncar coeff

! --- abssnow is the snow flake absorption coefficient (micron)
      data abssnow0 / 1.5 /             ! fu   coeff
! --- abssnow is the snow flake absorption coefficient (m2/g)
      data abssnow1 / 2.34e-3 /         ! ncar coeff

!     absliqn is the liquid water absorption coefficient (m2/g).
! === for iflagliq = 1,
      data absliq1 / 0.0602410 /

! === everything below is for iflagliq >= 2.

!     absice#(j,ib) are the parameters needed to compute the ice water
!     absorption coefficient in spectral region ib for iceflag=#.  the
!     units of absice#(1,ib) are m2/g and absicen(2,ib) has units
!     (microns (m2/g)).
! --- for iflagice = 0.
      data absice0 / 0.005,  1.0 /
!!    data absice0 / 0.0029,  1.0 /       ! moorthi's coeff

! --- for iflagice = 1.
      data absice1 / 0.0036, 1.136, 0.0068, 0.600, 0.0003, 1.338,       &
     &               0.0016, 1.166, 0.0020, 1.118 /

! --- for iflagice = 2.
!     each band, the absorption coef's are listed for a range of effective
!     radii from 13.0 to 130.0 microns in increments of 3.0 microns.
      data  absice2(:,1) /                                              &
     & 5.308137e-02,4.610615e-02,4.128355e-02,3.767141e-02,3.481773e-02,&
     & 3.247569e-02,3.049760e-02,2.878894e-02,2.728603e-02,2.594420e-02,&
     & 2.473109e-02,2.362260e-02,2.260035e-02,2.165006e-02,2.076046e-02,&
     & 1.992250e-02,1.912880e-02,1.837331e-02,1.765101e-02,1.695766e-02,&
     & 1.628969e-02,1.564405e-02,1.501811e-02,1.440959e-02,1.381653e-02,&
     & 1.323720e-02,1.267006e-02,1.211378e-02,1.156715e-02,1.102911e-02,&
     & 1.049869e-02,9.975041e-03,9.457376e-03,8.944992e-03,8.437249e-03,&
     & 7.933561e-03,7.433394e-03,6.936257e-03,6.441701e-03,5.949308e-03/
      data  absice2(:,2) /                                              &
     & 3.808872e-02,3.502664e-02,3.231765e-02,2.998940e-02,2.798500e-02,&
     & 2.624287e-02,2.471175e-02,2.335146e-02,2.213092e-02,2.102607e-02,&
     & 2.001804e-02,1.909193e-02,1.823581e-02,1.744003e-02,1.669669e-02,&
     & 1.599927e-02,1.534234e-02,1.472132e-02,1.413234e-02,1.357209e-02,&
     & 1.303774e-02,1.252681e-02,1.203718e-02,1.156698e-02,1.111455e-02,&
     & 1.067846e-02,1.025741e-02,9.850260e-03,9.455976e-03,9.073645e-03,&
     & 8.702438e-03,8.341606e-03,7.990473e-03,7.648424e-03,7.314896e-03,&
     & 6.989379e-03,6.671402e-03,6.360537e-03,6.056387e-03,5.758587e-03/
      data  absice2(:,3) /                                              &
     & 7.402665e-02,6.209102e-02,5.216790e-02,4.453142e-02,3.864415e-02,&
     & 3.402727e-02,3.033647e-02,2.733239e-02,2.484767e-02,2.276330e-02,&
     & 2.099304e-02,1.947312e-02,1.815559e-02,1.700375e-02,1.598911e-02,&
     & 1.508925e-02,1.428628e-02,1.356580e-02,1.291609e-02,1.232749e-02,&
     & 1.179201e-02,1.130298e-02,1.085478e-02,1.044263e-02,1.006249e-02,&
     & 9.710860e-03,9.384746e-03,9.081546e-03,8.798995e-03,8.535113e-03,&
     & 8.288163e-03,8.056611e-03,7.839102e-03,7.634433e-03,7.441532e-03,&
     & 7.259442e-03,7.087304e-03,6.924348e-03,6.769881e-03,6.623274e-03/
      data  absice2(:,4) /                                              &
     & 8.094820e-02,6.403291e-02,5.250755e-02,4.428943e-02,3.818391e-02,&
     & 3.349259e-02,2.978790e-02,2.679591e-02,2.433399e-02,2.227614e-02,&
     & 2.053280e-02,1.903874e-02,1.774534e-02,1.661571e-02,1.562134e-02,&
     & 1.473990e-02,1.395366e-02,1.324836e-02,1.261241e-02,1.203630e-02,&
     & 1.151218e-02,1.103347e-02,1.059465e-02,1.019105e-02,9.818699e-03,&
     & 9.474168e-03,9.154525e-03,8.857223e-03,8.580047e-03,8.321061e-03,&
     & 8.078565e-03,7.851061e-03,7.637226e-03,7.435882e-03,7.245985e-03,&
     & 7.066598e-03,6.896884e-03,6.736091e-03,6.583542e-03,6.438624e-03/
      data  absice2(:,5) /                                              &
     & 8.107771e-02,6.356966e-02,5.202664e-02,4.388361e-02,3.785256e-02,&
     & 3.321862e-02,2.955444e-02,2.658946e-02,2.414439e-02,2.209589e-02,&
     & 2.035644e-02,1.886226e-02,1.756586e-02,1.643112e-02,1.543016e-02,&
     & 1.454108e-02,1.374647e-02,1.303233e-02,1.238726e-02,1.180189e-02,&
     & 1.126846e-02,1.078049e-02,1.033252e-02,9.919924e-03,9.538748e-03,&
     & 9.185608e-03,8.857581e-03,8.552134e-03,8.267059e-03,8.000423e-03,&
     & 7.750529e-03,7.515880e-03,7.295149e-03,7.087158e-03,6.890857e-03,&
     & 6.705306e-03,6.529664e-03,6.363173e-03,6.205150e-03,6.054977e-03/
      data  absice2(:,6) /                                              &
     & 6.617399e-02,5.382356e-02,4.548024e-02,3.943650e-02,3.483962e-02,&
     & 3.121482e-02,2.827613e-02,2.584066e-02,2.378586e-02,2.202637e-02,&
     & 2.050087e-02,1.916411e-02,1.798196e-02,1.692814e-02,1.598211e-02,&
     & 1.512754e-02,1.435129e-02,1.364266e-02,1.299284e-02,1.239453e-02,&
     & 1.184158e-02,1.132883e-02,1.085186e-02,1.040690e-02,9.990698e-03,&
     & 9.600436e-03,9.233660e-03,8.888220e-03,8.562226e-03,8.254011e-03,&
     & 7.962094e-03,7.685159e-03,7.422029e-03,7.171651e-03,6.933078e-03,&
     & 6.705456e-03,6.488015e-03,6.280053e-03,6.080937e-03,5.890087e-03/
      data  absice2(:,7) /                                              &
     & 5.525622e-02,4.882834e-02,4.307237e-02,3.828016e-02,3.432924e-02,&
     & 3.105137e-02,2.830273e-02,2.597146e-02,2.397252e-02,2.224126e-02,&
     & 2.072819e-02,1.939498e-02,1.821160e-02,1.715425e-02,1.620385e-02,&
     & 1.534496e-02,1.456495e-02,1.385341e-02,1.320165e-02,1.260242e-02,&
     & 1.204956e-02,1.153786e-02,1.106285e-02,1.062069e-02,1.020806e-02,&
     & 9.822069e-03,9.460187e-03,9.120204e-03,8.800168e-03,8.498356e-03,&
     & 8.213235e-03,7.943442e-03,7.687759e-03,7.445092e-03,7.214460e-03,&
     & 6.994979e-03,6.785846e-03,6.586339e-03,6.395797e-03,6.213622e-03/
      data  absice2(:,8) /                                              &
     & 6.204709e-02,5.447577e-02,4.693652e-02,4.068410e-02,3.566129e-02,&
     & 3.162111e-02,2.833719e-02,2.563384e-02,2.338009e-02,2.147883e-02,&
     & 1.985755e-02,1.846151e-02,1.724884e-02,1.618712e-02,1.525092e-02,&
     & 1.442006e-02,1.367838e-02,1.301277e-02,1.241252e-02,1.186877e-02,&
     & 1.137421e-02,1.092266e-02,1.050894e-02,1.012866e-02,9.778052e-03,&
     & 9.453889e-03,9.153392e-03,8.874146e-03,8.614049e-03,8.371264e-03,&
     & 8.144174e-03,7.931357e-03,7.731552e-03,7.543641e-03,7.366629e-03,&
     & 7.199625e-03,7.041832e-03,6.892534e-03,6.751085e-03,6.616904e-03/
      data  absice2(:,9) /                                              &
     & 6.886530e-02,5.796039e-02,4.871664e-02,4.157422e-02,3.606747e-02,&
     & 3.175486e-02,2.831396e-02,2.551931e-02,2.321294e-02,2.128248e-02,&
     & 1.964647e-02,1.824476e-02,1.703216e-02,1.597411e-02,1.504384e-02,&
     & 1.422028e-02,1.348667e-02,1.282952e-02,1.223786e-02,1.170268e-02,&
     & 1.121653e-02,1.077318e-02,1.036740e-02,9.994772e-03,9.651518e-03,&
     & 9.334412e-03,9.040674e-03,8.767897e-03,8.513989e-03,8.277122e-03,&
     & 8.055693e-03,7.848290e-03,7.653665e-03,7.470712e-03,7.298447e-03,&
     & 7.135991e-03,6.982557e-03,6.837440e-03,6.700003e-03,6.569673e-03/
      data  absice2(:,10) /                                             &
     & 7.124487e-02,5.846725e-02,4.869304e-02,4.140966e-02,3.588534e-02,&
     & 3.159352e-02,2.818254e-02,2.541683e-02,2.313524e-02,2.122481e-02,&
     & 1.960443e-02,1.821456e-02,1.701063e-02,1.595869e-02,1.503244e-02,&
     & 1.421124e-02,1.347864e-02,1.282143e-02,1.222886e-02,1.169209e-02,&
     & 1.120381e-02,1.075791e-02,1.034925e-02,9.973491e-03,9.626911e-03,&
     & 9.306335e-03,9.009024e-03,8.732604e-03,8.475009e-03,8.234434e-03,&
     & 8.009292e-03,7.798186e-03,7.599882e-03,7.413280e-03,7.237405e-03,&
     & 7.071384e-03,6.914434e-03,6.765853e-03,6.625009e-03,6.491330e-03/
      data  absice2(:,11) /                                             &
     & 6.946157e-02,5.694109e-02,4.754750e-02,4.056198e-02,3.525241e-02,&
     & 3.111421e-02,2.781424e-02,2.512985e-02,2.290863e-02,2.104354e-02,&
     & 1.945751e-02,1.809386e-02,1.691003e-02,1.587352e-02,1.495910e-02,&
     & 1.414692e-02,1.342116e-02,1.276904e-02,1.218016e-02,1.164598e-02,&
     & 1.115939e-02,1.071445e-02,1.030618e-02,9.930324e-03,9.583261e-03,&
     & 9.261888e-03,8.963524e-03,8.685843e-03,8.426821e-03,8.184683e-03,&
     & 7.957872e-03,7.745014e-03,7.544891e-03,7.356422e-03,7.178643e-03,&
     & 7.010693e-03,6.851799e-03,6.701265e-03,6.558467e-03,6.422836e-03/
      data  absice2(:,12) /                                             &
     & 4.162544e-02,3.774206e-02,3.387559e-02,3.048216e-02,2.759398e-02,&
     & 2.514770e-02,2.306767e-02,2.128679e-02,1.975015e-02,1.841389e-02,&
     & 1.724326e-02,1.621062e-02,1.529388e-02,1.447525e-02,1.374029e-02,&
     & 1.307717e-02,1.247616e-02,1.192916e-02,1.142938e-02,1.097111e-02,&
     & 1.054952e-02,1.016048e-02,9.800441e-03,9.466351e-03,9.155566e-03,&
     & 8.865782e-03,8.594987e-03,8.341414e-03,8.103506e-03,7.879884e-03,&
     & 7.669326e-03,7.470744e-03,7.283166e-03,7.105719e-03,6.937623e-03,&
     & 6.778171e-03,6.626727e-03,6.482715e-03,6.345612e-03,6.214942e-03/
      data  absice2(:,13) /                                             &
     & 5.989806e-02,5.056817e-02,4.311112e-02,3.735098e-02,3.285293e-02,&
     & 2.927343e-02,2.637042e-02,2.397535e-02,2.196938e-02,2.026708e-02,&
     & 1.880583e-02,1.753882e-02,1.643044e-02,1.545319e-02,1.458549e-02,&
     & 1.381020e-02,1.311354e-02,1.248431e-02,1.191334e-02,1.139300e-02,&
     & 1.091697e-02,1.047989e-02,1.007724e-02,9.705182e-03,9.360395e-03,&
     & 9.040037e-03,8.741639e-03,8.463052e-03,8.202396e-03,7.958020e-03,&
     & 7.728467e-03,7.512449e-03,7.308820e-03,7.116561e-03,6.934759e-03,&
     & 6.762596e-03,6.599337e-03,6.444320e-03,6.296944e-03,6.156667e-03/
      data  absice2(:,14) /                                             &
     & 5.427438e-02,4.682405e-02,4.056412e-02,3.555101e-02,3.153408e-02,&
     & 2.827650e-02,2.559668e-02,2.336126e-02,2.147261e-02,1.985856e-02,&
     & 1.846503e-02,1.725091e-02,1.618448e-02,1.524093e-02,1.440064e-02,&
     & 1.364787e-02,1.296990e-02,1.235630e-02,1.179850e-02,1.128934e-02,&
     & 1.082285e-02,1.039396e-02,9.998390e-03,9.632453e-03,9.292999e-03,&
     & 8.977300e-03,8.682986e-03,8.407991e-03,8.150503e-03,7.908927e-03,&
     & 7.681856e-03,7.468042e-03,7.266375e-03,7.075864e-03,6.895622e-03,&
     & 6.724854e-03,6.562843e-03,6.408943e-03,6.262568e-03,6.123188e-03/
      data  absice2(:,15) /                                             &
     & 3.734649e-02,3.412194e-02,3.079772e-02,2.783212e-02,2.528118e-02,&
     & 2.310335e-02,2.123972e-02,1.963551e-02,1.824481e-02,1.703044e-02,&
     & 1.596258e-02,1.501737e-02,1.417560e-02,1.342171e-02,1.274301e-02,&
     & 1.212909e-02,1.157132e-02,1.106249e-02,1.059658e-02,1.016849e-02,&
     & 9.773873e-03,9.409024e-03,9.070757e-03,8.756320e-03,8.463322e-03,&
     & 8.189678e-03,7.933561e-03,7.693367e-03,7.467678e-03,7.255238e-03,&
     & 7.054931e-03,6.865762e-03,6.686840e-03,6.517366e-03,6.356622e-03,&
     & 6.203960e-03,6.058793e-03,5.920590e-03,5.788869e-03,5.663191e-03/
      data  absice2(:,16) /                                             &
     & 4.226924e-02,3.719702e-02,3.276247e-02,2.909934e-02,2.609178e-02,&
     & 2.360471e-02,2.152589e-02,1.976868e-02,1.826735e-02,1.697197e-02,&
     & 1.584428e-02,1.485463e-02,1.397979e-02,1.320136e-02,1.250459e-02,&
     & 1.187752e-02,1.131042e-02,1.079523e-02,1.032526e-02,9.894930e-03,&
     & 9.499496e-03,9.134956e-03,8.797885e-03,8.485341e-03,8.194783e-03,&
     & 7.924007e-03,7.671090e-03,7.434349e-03,7.212302e-03,7.003645e-03,&
     & 6.807219e-03,6.621995e-03,6.447055e-03,6.281580e-03,6.124830e-03,&
     & 5.976146e-03,5.834927e-03,5.700635e-03,5.572778e-03,5.450912e-03/

! === for iflagliq = 2.
      data absliq2 /0.0903614/

! === for iflagliq = 3.
!     each band, the absorption coeff's are listed for a range of effective
!     radii from 2.5 to 59.5 microns in increments of 1.0 micron.
      data  absliq3(:,1) /                                              &
     & 2.317311e-02,6.109513e-02,6.850127e-02,7.025095e-02,7.045720e-02,&
     & 7.014763e-02,6.964456e-02,6.906029e-02,6.843251e-02,6.776883e-02,&
     & 6.740428e-02,6.471351e-02,6.215508e-02,5.977013e-02,5.755809e-02,&
     & 5.550328e-02,5.358573e-02,5.178553e-02,5.008436e-02,4.846591e-02,&
     & 4.691585e-02,4.542158e-02,4.397195e-02,4.255702e-02,4.116779e-02,&
     & 3.979603e-02,3.843408e-02,3.707472e-02,3.593146e-02,3.477353e-02,&
     & 3.368067e-02,3.264653e-02,3.166568e-02,3.073339e-02,2.984557e-02,&
     & 2.899858e-02,2.818924e-02,2.741469e-02,2.667239e-02,2.596005e-02,&
     & 2.527561e-02,2.461722e-02,2.398318e-02,2.337194e-02,2.278211e-02,&
     & 2.221240e-02,2.166162e-02,2.112870e-02,2.061262e-02,2.011246e-02,&
     & 1.962737e-02,1.915655e-02,1.869927e-02,1.825485e-02,1.782263e-02,&
     & 1.740204e-02,1.699251e-02,1.659352e-02/
      data  absliq3(:,2) /                                              &
     & 9.103496e-02,1.480995e-01,1.402309e-01,1.300658e-01,1.214233e-01,&
     & 1.140277e-01,1.073661e-01,1.010236e-01,9.466848e-02,8.801306e-02,&
     & 8.222715e-02,7.610165e-02,7.087689e-02,6.633009e-02,6.231412e-02,&
     & 5.872623e-02,5.549144e-02,5.255308e-02,4.986711e-02,4.739856e-02,&
     & 4.511911e-02,4.300551e-02,4.103841e-02,3.920156e-02,3.748114e-02,&
     & 3.586532e-02,3.434392e-02,3.290809e-02,3.176277e-02,3.060455e-02,&
     & 2.951870e-02,2.849868e-02,2.753870e-02,2.663363e-02,2.577891e-02,&
     & 2.497048e-02,2.420469e-02,2.347828e-02,2.278828e-02,2.213206e-02,&
     & 2.150719e-02,2.091151e-02,2.034301e-02,1.979989e-02,1.928050e-02,&
     & 1.878332e-02,1.830698e-02,1.785018e-02,1.741177e-02,1.699066e-02,&
     & 1.658586e-02,1.619643e-02,1.582154e-02,1.546038e-02,1.511222e-02,&
     & 1.477637e-02,1.445221e-02,1.413913e-02/
      data  absliq3(:,3) /                                              &
     & 2.951735e-01,2.347648e-01,1.980376e-01,1.721142e-01,1.520826e-01,&
     & 1.356541e-01,1.216134e-01,1.092517e-01,9.812634e-02,8.794481e-02,&
     & 8.125663e-02,7.445630e-02,6.863743e-02,6.360421e-02,5.920939e-02,&
     & 5.534017e-02,5.190868e-02,4.884551e-02,4.609508e-02,4.361243e-02,&
     & 4.136074e-02,3.930963e-02,3.743377e-02,3.571191e-02,3.412609e-02,&
     & 3.266100e-02,3.130355e-02,3.004245e-02,2.884966e-02,2.780765e-02,&
     & 2.683173e-02,2.591580e-02,2.505449e-02,2.424303e-02,2.347722e-02,&
     & 2.275331e-02,2.206794e-02,2.141810e-02,2.080110e-02,2.021450e-02,&
     & 1.965609e-02,1.912390e-02,1.861611e-02,1.813107e-02,1.766729e-02,&
     & 1.722339e-02,1.679811e-02,1.639031e-02,1.599892e-02,1.562296e-02,&
     & 1.526155e-02,1.491384e-02,1.457907e-02,1.425652e-02,1.394554e-02,&
     & 1.364551e-02,1.335586e-02,1.307606e-02/
      data  absliq3(:,4) /                                              &
     & 3.009248e-01,2.369488e-01,1.969469e-01,1.686924e-01,1.471901e-01,&
     & 1.299859e-01,1.157190e-01,1.035677e-01,9.300276e-02,8.366584e-02,&
     & 7.710747e-02,7.070016e-02,6.522841e-02,6.050237e-02,5.638011e-02,&
     & 5.275342e-02,4.953838e-02,4.666896e-02,4.409246e-02,4.176635e-02,&
     & 3.965594e-02,3.773263e-02,3.597266e-02,3.435610e-02,3.286616e-02,&
     & 3.148853e-02,3.021100e-02,2.902305e-02,2.789483e-02,2.691087e-02,&
     & 2.598836e-02,2.512166e-02,2.430581e-02,2.353642e-02,2.280958e-02,&
     & 2.212182e-02,2.147004e-02,2.085146e-02,2.026356e-02,1.970411e-02,&
     & 1.917105e-02,1.866254e-02,1.817690e-02,1.771260e-02,1.726825e-02,&
     & 1.684257e-02,1.643440e-02,1.604265e-02,1.566636e-02,1.530459e-02,&
     & 1.495653e-02,1.462140e-02,1.429847e-02,1.398708e-02,1.368662e-02,&
     & 1.339651e-02,1.311622e-02,1.284525e-02/
      data  absliq3(:,5) /                                              &
     & 2.646912e-01,2.120182e-01,1.780086e-01,1.535393e-01,1.347209e-01,&
     & 1.195802e-01,1.069960e-01,9.627716e-02,8.697099e-02,7.876703e-02,&
     & 7.292724e-02,6.709201e-02,6.209771e-02,5.777322e-02,5.399095e-02,&
     & 5.065378e-02,4.768655e-02,4.503014e-02,4.263744e-02,4.047042e-02,&
     & 3.849806e-02,3.669482e-02,3.503944e-02,3.351411e-02,3.210378e-02,&
     & 3.079567e-02,2.957880e-02,2.844375e-02,2.737899e-02,2.643902e-02,&
     & 2.555652e-02,2.472627e-02,2.394368e-02,2.320467e-02,2.250563e-02,&
     & 2.184333e-02,2.121488e-02,2.061771e-02,2.004948e-02,1.950810e-02,&
     & 1.899165e-02,1.849842e-02,1.802685e-02,1.757549e-02,1.714305e-02,&
     & 1.672834e-02,1.633026e-02,1.594781e-02,1.558006e-02,1.522615e-02,&
     & 1.488531e-02,1.455681e-02,1.423996e-02,1.393415e-02,1.363879e-02,&
     & 1.335334e-02,1.307730e-02,1.281020e-02/
      data  absliq3(:,6) /                                              &
     & 8.811824e-02,1.067453e-01,9.797529e-02,8.996253e-02,8.352002e-02,&
     & 7.818990e-02,7.359390e-02,6.946955e-02,6.562659e-02,6.191484e-02,&
     & 5.833548e-02,5.493056e-02,5.196417e-02,4.933254e-02,4.696588e-02,&
     & 4.481484e-02,4.284310e-02,4.102307e-02,3.933320e-02,3.775632e-02,&
     & 3.627847e-02,3.488817e-02,3.357580e-02,3.233326e-02,3.115363e-02,&
     & 3.003095e-02,2.896007e-02,2.793646e-02,2.705024e-02,2.626182e-02,&
     & 2.550246e-02,2.477275e-02,2.407256e-02,2.340134e-02,2.275825e-02,&
     & 2.214224e-02,2.155220e-02,2.098694e-02,2.044526e-02,1.992599e-02,&
     & 1.942798e-02,1.895011e-02,1.849132e-02,1.805060e-02,1.762699e-02,&
     & 1.721959e-02,1.682755e-02,1.645004e-02,1.608633e-02,1.573569e-02,&
     & 1.539746e-02,1.507101e-02,1.475575e-02,1.445112e-02,1.415662e-02,&
     & 1.387173e-02,1.359601e-02,1.332903e-02/
      data  absliq3(:,7) /                                              &
     & 4.321742e-02,7.360776e-02,6.983400e-02,6.652314e-02,6.419483e-02,&
     & 6.235512e-02,6.066381e-02,5.886798e-02,5.671241e-02,5.386294e-02,&
     & 4.995791e-02,4.862892e-02,4.701198e-02,4.528539e-02,4.354655e-02,&
     & 4.184799e-02,4.021685e-02,3.866581e-02,3.719923e-02,3.581678e-02,&
     & 3.451553e-02,3.329122e-02,3.213899e-02,3.105381e-02,3.003074e-02,&
     & 2.906507e-02,2.815236e-02,2.728853e-02,2.628212e-02,2.557439e-02,&
     & 2.487989e-02,2.420288e-02,2.354602e-02,2.291084e-02,2.229808e-02,&
     & 2.170793e-02,2.114022e-02,2.059448e-02,2.007010e-02,1.956633e-02,&
     & 1.908238e-02,1.861742e-02,1.817060e-02,1.774108e-02,1.732806e-02,&
     & 1.693073e-02,1.654832e-02,1.618011e-02,1.582540e-02,1.548352e-02,&
     & 1.515384e-02,1.483577e-02,1.452875e-02,1.423223e-02,1.394571e-02,&
     & 1.366873e-02,1.340083e-02,1.314159e-02/
      data  absliq3(:,8) /                                              &
     & 1.418807e-01,7.154191e-02,6.303346e-02,6.111324e-02,6.019305e-02,&
     & 5.924194e-02,5.789680e-02,5.588757e-02,5.289232e-02,4.844620e-02,&
     & 4.608385e-02,4.560133e-02,4.454102e-02,4.318657e-02,4.170261e-02,&
     & 4.018504e-02,3.868917e-02,3.724607e-02,3.587214e-02,3.457487e-02,&
     & 3.335635e-02,3.221551e-02,3.114941e-02,3.015414e-02,2.922530e-02,&
     & 2.835836e-02,2.754884e-02,2.679246e-02,2.576920e-02,2.507042e-02,&
     & 2.439184e-02,2.373495e-02,2.310052e-02,2.248877e-02,2.189956e-02,&
     & 2.133248e-02,2.078695e-02,2.026227e-02,1.975769e-02,1.927241e-02,&
     & 1.880560e-02,1.835644e-02,1.792414e-02,1.750791e-02,1.710699e-02,&
     & 1.672066e-02,1.634822e-02,1.598900e-02,1.564237e-02,1.530773e-02,&
     & 1.498452e-02,1.467219e-02,1.437023e-02,1.407816e-02,1.379552e-02,&
     & 1.352189e-02,1.325685e-02,1.300002e-02/
      data  absliq3(:,9) /                                              &
     & 6.727262e-02,6.610126e-02,6.478659e-02,6.337803e-02,6.189851e-02,&
     & 6.033352e-02,5.861357e-02,5.658760e-02,5.398387e-02,5.035361e-02,&
     & 4.716084e-02,4.636301e-02,4.503130e-02,4.345260e-02,4.178762e-02,&
     & 4.012609e-02,3.851708e-02,3.698595e-02,3.554424e-02,3.419543e-02,&
     & 3.293837e-02,3.176932e-02,3.068324e-02,2.967450e-02,2.873737e-02,&
     & 2.786621e-02,2.705567e-02,2.630077e-02,2.524495e-02,2.454240e-02,&
     & 2.386557e-02,2.321441e-02,2.258852e-02,2.198727e-02,2.140986e-02,&
     & 2.085540e-02,2.032297e-02,1.981160e-02,1.932034e-02,1.884823e-02,&
     & 1.839436e-02,1.795783e-02,1.753780e-02,1.713345e-02,1.674400e-02,&
     & 1.636871e-02,1.600688e-02,1.565786e-02,1.532101e-02,1.499576e-02,&
     & 1.468153e-02,1.437781e-02,1.408409e-02,1.379992e-02,1.352485e-02,&
     & 1.325846e-02,1.300036e-02,1.275018e-02/
      data  absliq3(:,10) /                                             &
     & 7.970399e-02,7.638436e-02,7.364989e-02,7.135247e-02,6.930427e-02,&
     & 6.728066e-02,6.502274e-02,6.223945e-02,5.860926e-02,5.378152e-02,&
     & 5.146821e-02,4.972139e-02,4.773920e-02,4.569609e-02,4.368575e-02,&
     & 4.175686e-02,3.993275e-02,3.822235e-02,3.662650e-02,3.514157e-02,&
     & 3.376166e-02,3.247981e-02,3.128873e-02,3.018124e-02,2.915047e-02,&
     & 2.819001e-02,2.729394e-02,2.645681e-02,2.541650e-02,2.468318e-02,&
     & 2.397828e-02,2.330174e-02,2.265305e-02,2.203141e-02,2.143587e-02,&
     & 2.086533e-02,2.031867e-02,1.979474e-02,1.929243e-02,1.881062e-02,&
     & 1.834825e-02,1.790431e-02,1.747781e-02,1.706784e-02,1.667353e-02,&
     & 1.629405e-02,1.592863e-02,1.557655e-02,1.523712e-02,1.490969e-02,&
     & 1.459367e-02,1.428848e-02,1.399359e-02,1.370850e-02,1.343274e-02,&
     & 1.316586e-02,1.290746e-02,1.265714e-02/
      data  absliq3(:,11) /                                             &
     & 1.494379e-01,1.335347e-01,1.215419e-01,1.117433e-01,1.032629e-01,&
     & 9.557744e-02,8.833824e-02,8.129427e-02,7.425327e-02,6.706086e-02,&
     & 6.387608e-02,5.977878e-02,5.598406e-02,5.253178e-02,4.941317e-02,&
     & 4.660136e-02,4.406436e-02,4.177059e-02,3.969101e-02,3.779976e-02,&
     & 3.607421e-02,3.449469e-02,3.304416e-02,3.170785e-02,3.047295e-02,&
     & 2.932829e-02,2.826416e-02,2.727201e-02,2.617887e-02,2.532765e-02,&
     & 2.452371e-02,2.376351e-02,2.304378e-02,2.236152e-02,2.171398e-02,&
     & 2.109866e-02,2.051327e-02,1.995571e-02,1.942406e-02,1.891659e-02,&
     & 1.843168e-02,1.796787e-02,1.752382e-02,1.709828e-02,1.669013e-02,&
     & 1.629830e-02,1.592185e-02,1.555986e-02,1.521153e-02,1.487608e-02,&
     & 1.455281e-02,1.424106e-02,1.394021e-02,1.364970e-02,1.336900e-02,&
     & 1.309761e-02,1.283507e-02,1.258095e-02/
      data  absliq3(:,12) /                                             &
     & 3.719852e-02,3.885858e-02,3.990704e-02,4.043514e-02,4.046101e-02,&
     & 3.998338e-02,3.899533e-02,3.748863e-02,3.545507e-02,3.288698e-02,&
     & 3.325759e-02,3.224436e-02,3.123840e-02,3.025843e-02,2.931462e-02,&
     & 2.841198e-02,2.755245e-02,2.673607e-02,2.596181e-02,2.522801e-02,&
     & 2.453266e-02,2.387362e-02,2.324871e-02,2.265581e-02,2.209286e-02,&
     & 2.155791e-02,2.104914e-02,2.056482e-02,1.997489e-02,1.957035e-02,&
     & 1.917308e-02,1.878385e-02,1.840320e-02,1.803148e-02,1.766887e-02,&
     & 1.731546e-02,1.697124e-02,1.663615e-02,1.631005e-02,1.599278e-02,&
     & 1.568416e-02,1.538398e-02,1.509202e-02,1.480804e-02,1.453181e-02,&
     & 1.426309e-02,1.400164e-02,1.374723e-02,1.349962e-02,1.325858e-02,&
     & 1.302390e-02,1.279536e-02,1.257275e-02,1.235586e-02,1.214450e-02,&
     & 1.193848e-02,1.173761e-02,1.154172e-02/
      data  absliq3(:,13) /                                             &
     & 3.118678e-02,4.483573e-02,4.902244e-02,4.964059e-02,4.868059e-02,&
     & 4.696101e-02,4.486300e-02,4.257948e-02,4.021383e-02,3.782356e-02,&
     & 3.742657e-02,3.603843e-02,3.470737e-02,3.344343e-02,3.224992e-02,&
     & 3.112640e-02,3.007038e-02,2.907835e-02,2.814632e-02,2.727021e-02,&
     & 2.644598e-02,2.566981e-02,2.493808e-02,2.424745e-02,2.359483e-02,&
     & 2.297739e-02,2.239252e-02,2.183785e-02,2.117925e-02,2.070756e-02,&
     & 2.024699e-02,1.979812e-02,1.936131e-02,1.893669e-02,1.852428e-02,&
     & 1.812396e-02,1.773555e-02,1.735881e-02,1.699345e-02,1.663916e-02,&
     & 1.629560e-02,1.596244e-02,1.563933e-02,1.532591e-02,1.502185e-02,&
     & 1.472680e-02,1.444043e-02,1.416242e-02,1.389246e-02,1.363023e-02,&
     & 1.337545e-02,1.312783e-02,1.288711e-02,1.265302e-02,1.242532e-02,&
     & 1.220376e-02,1.198811e-02,1.177816e-02/
      data  absliq3(:,14) /                                             &
     & 1.589879e-02,3.506523e-02,4.008515e-02,4.072696e-02,3.981012e-02,&
     & 3.833056e-02,3.668287e-02,3.503265e-02,3.344965e-02,3.196089e-02,&
     & 3.137121e-02,3.033481e-02,2.934152e-02,2.839725e-02,2.750374e-02,&
     & 2.666039e-02,2.586536e-02,2.511614e-02,2.440996e-02,2.374397e-02,&
     & 2.311538e-02,2.252152e-02,2.195989e-02,2.142815e-02,2.092415e-02,&
     & 2.044588e-02,1.999154e-02,1.955943e-02,1.902540e-02,1.865979e-02,&
     & 1.829955e-02,1.794554e-02,1.759834e-02,1.725841e-02,1.692600e-02,&
     & 1.660128e-02,1.628433e-02,1.597515e-02,1.567370e-02,1.537987e-02,&
     & 1.509356e-02,1.481461e-02,1.454286e-02,1.427815e-02,1.402027e-02,&
     & 1.376906e-02,1.352431e-02,1.328583e-02,1.305344e-02,1.282695e-02,&
     & 1.260616e-02,1.239091e-02,1.218100e-02,1.197627e-02,1.177655e-02,&
     & 1.158167e-02,1.139148e-02,1.120583e-02/
      data  absliq3(:,15) /                                             &
     & 5.020792e-03,2.176149e-02,2.554494e-02,2.594839e-02,2.536500e-02,&
     & 2.452808e-02,2.368427e-02,2.291585e-02,2.224506e-02,2.167161e-02,&
     & 2.114512e-02,2.058169e-02,2.004540e-02,1.953718e-02,1.905667e-02,&
     & 1.860280e-02,1.817419e-02,1.776930e-02,1.738656e-02,1.702444e-02,&
     & 1.668148e-02,1.635633e-02,1.604770e-02,1.575444e-02,1.547545e-02,&
     & 1.520974e-02,1.495642e-02,1.471463e-02,1.436841e-02,1.417275e-02,&
     & 1.397622e-02,1.377965e-02,1.358376e-02,1.338908e-02,1.319607e-02,&
     & 1.300508e-02,1.281637e-02,1.263017e-02,1.244664e-02,1.226591e-02,&
     & 1.208805e-02,1.191314e-02,1.174120e-02,1.157227e-02,1.140633e-02,&
     & 1.124338e-02,1.108341e-02,1.092637e-02,1.077224e-02,1.062098e-02,&
     & 1.047253e-02,1.032685e-02,1.018389e-02,1.004360e-02,9.905925e-03,&
     & 9.770801e-03,9.638176e-03,9.507998e-03/
      data  absliq3(:,16) /                                             &
     & 1.398301e-02,3.704987e-02,3.928249e-02,3.759325e-02,3.534122e-02,&
     & 3.328979e-02,3.158282e-02,3.020512e-02,2.910579e-02,2.823262e-02,&
     & 2.653908e-02,2.559978e-02,2.471139e-02,2.387688e-02,2.309574e-02,&
     & 2.236567e-02,2.168353e-02,2.104590e-02,2.044933e-02,1.989053e-02,&
     & 1.936639e-02,1.887404e-02,1.841087e-02,1.797450e-02,1.756277e-02,&
     & 1.717372e-02,1.680557e-02,1.645673e-02,1.600733e-02,1.571652e-02,&
     & 1.543078e-02,1.515061e-02,1.487636e-02,1.460824e-02,1.434636e-02,&
     & 1.409077e-02,1.384144e-02,1.359831e-02,1.336129e-02,1.313026e-02,&
     & 1.290509e-02,1.268563e-02,1.247173e-02,1.226323e-02,1.205997e-02,&
     & 1.186180e-02,1.166854e-02,1.148005e-02,1.129616e-02,1.111674e-02,&
     & 1.094163e-02,1.077068e-02,1.060377e-02,1.044075e-02,1.028151e-02,&
     & 1.012590e-02,9.973826e-03,9.825151e-03/

!........................................!
      end module module_radlw_cldprlw_nmmb!
!========================================!

 
 
!========================================!
      module module_radlw_kgb01_nmmb     !
!........................................!
!
! *********        the original program descriptions        ********* !
!                                                                     !
!  rrtm longwave radiative transfer model                             !
!  atmospheric and environmental research, inc., cambridge, ma        !
!                                                                     !
!  original version:       e. j. mlawer, et al.                       !
!  revision for ncar ccm:  michael j. iacono; september, 1998         !
!                                                                     !
!  this module contains 16 block data statements that include the     !
!  absorption coefficients and other data for each of the 16 longwave !
!  spectral bands used in rrtm.  here, the data are defined for 16    !
!  g-points, or sub-intervals, per band.  these data are combined and !
!  weighted using a mapping procedure in routine rrtminit to reduce   !
!  the total number of g-points from 256 to 140 for use in the ccm.   !
!                                                                     !
! *********    *********    end description    *********    ********* !
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NG01
!
      implicit none
!
      private
!
      integer, public :: MSA01, MSB01, MSF01
      parameter (MSA01=65, MSB01=235, MSF01=10)
 
      real (kind=kind_phys), public ::                                  &
     &       absa(MSA01,NG01), absb(MSB01,NG01), selfref(MSF01,NG01),   &
     &       forref(NG01), fracrefa(NG01), fracrefb(NG01)
 
!     the array absa(65,NG01) = ka(5,13,NG01) contains absorption coefs
!     at the NG01=8 chosen g-values for a range of pressure levels>~100mb
!     and temperatures.  the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 1 to 13 and refers to the corresponding
!     pressure level in pref (e.g. jp = 1 is for a pressure of 1053.63 mb).
!     the third index, ig, goes from 1 to NG01=8, and tells us which
!     g-interval the absorption coefficients are for.
 
      data   absa(:,1)  /                                               &
     & 6.873586e-01,6.401567e-01,5.980173e-01,5.601714e-01,5.264165e-01,&
     & 5.794078e-01,5.389091e-01,5.031812e-01,4.709597e-01,4.422472e-01,&
     & 4.955921e-01,4.600878e-01,4.287860e-01,4.008121e-01,3.756918e-01,&
     & 4.276590e-01,3.963226e-01,3.685490e-01,3.439527e-01,3.219174e-01,&
     & 3.698981e-01,3.421539e-01,3.176002e-01,2.958416e-01,2.764741e-01,&
     & 3.210326e-01,2.963644e-01,2.745485e-01,2.552552e-01,2.381442e-01,&
     & 2.788130e-01,2.568133e-01,2.374974e-01,2.203761e-01,2.052149e-01,&
     & 2.420256e-01,2.226887e-01,2.055443e-01,1.904433e-01,1.771123e-01,&
     & 2.106855e-01,1.937484e-01,1.788137e-01,1.656663e-01,1.541195e-01,&
     & 1.884727e-01,1.737195e-01,1.608784e-01,1.495804e-01,1.396524e-01,&
     & 1.632693e-01,1.511410e-01,1.406816e-01,1.315247e-01,1.234346e-01,&
     & 1.396468e-01,1.298071e-01,1.213466e-01,1.139821e-01,1.074976e-01,&
     & 1.188569e-01,1.107280e-01,1.037045e-01,9.766051e-02,9.237845e-02/
      data   absa(:,2)  /                                               &
     & 2.534396e+00,2.420995e+00,2.316199e+00,2.217834e+00,2.125741e+00,&
     & 2.111483e+00,2.016120e+00,1.926807e+00,1.844104e+00,1.767793e+00,&
     & 1.770676e+00,1.689079e+00,1.612676e+00,1.542267e+00,1.477886e+00,&
     & 1.497715e+00,1.427517e+00,1.362479e+00,1.302366e+00,1.247278e+00,&
     & 1.270588e+00,1.210779e+00,1.155154e+00,1.103667e+00,1.056748e+00,&
     & 1.080571e+00,1.029491e+00,9.818693e-01,9.381396e-01,8.979784e-01,&
     & 9.194461e-01,8.756366e-01,8.350725e-01,7.973601e-01,7.630087e-01,&
     & 7.832860e-01,7.455835e-01,7.105813e-01,6.784916e-01,6.490078e-01,&
     & 6.720241e-01,6.395442e-01,6.091599e-01,5.815412e-01,5.560232e-01,&
     & 5.856827e-01,5.578492e-01,5.317601e-01,5.081156e-01,4.864335e-01,&
     & 5.017570e-01,4.784925e-01,4.573379e-01,4.380174e-01,4.204626e-01,&
     & 4.279394e-01,4.085994e-01,3.912864e-01,3.757387e-01,3.615201e-01,&
     & 3.605024e-01,3.446525e-01,3.307569e-01,3.181926e-01,3.068010e-01/
      data   absa(:,3)  /                                               &
     & 7.257267e+00,7.015020e+00,6.776414e+00,6.549252e+00,6.338234e+00,&
     & 6.198131e+00,5.981201e+00,5.775218e+00,5.581760e+00,5.402037e+00,&
     & 5.273253e+00,5.086056e+00,4.910910e+00,4.747458e+00,4.596699e+00,&
     & 4.509401e+00,4.348021e+00,4.197742e+00,4.058893e+00,3.928698e+00,&
     & 3.856719e+00,3.716576e+00,3.588240e+00,3.468781e+00,3.357496e+00,&
     & 3.296517e+00,3.176113e+00,3.064881e+00,2.963395e+00,2.865736e+00,&
     & 2.813844e+00,2.709672e+00,2.614155e+00,2.525940e+00,2.440753e+00,&
     & 2.398993e+00,2.309538e+00,2.227655e+00,2.150681e+00,2.076591e+00,&
     & 2.065007e+00,1.987271e+00,1.915863e+00,1.847999e+00,1.783026e+00,&
     & 1.805832e+00,1.738620e+00,1.675822e+00,1.615692e+00,1.558027e+00,&
     & 1.540431e+00,1.484556e+00,1.432123e+00,1.380812e+00,1.331620e+00,&
     & 1.314274e+00,1.268615e+00,1.223956e+00,1.181097e+00,1.140353e+00,&
     & 1.117756e+00,1.080141e+00,1.043286e+00,1.007542e+00,9.741095e-01/
      data   absa(:,4)  /                                               &
     & 2.982228e+01,2.893748e+01,2.807294e+01,2.725772e+01,2.646121e+01,&
     & 2.747046e+01,2.667256e+01,2.589011e+01,2.511276e+01,2.437019e+01,&
     & 2.513356e+01,2.438309e+01,2.364621e+01,2.292277e+01,2.222352e+01,&
     & 2.283748e+01,2.214159e+01,2.146459e+01,2.079804e+01,2.014479e+01,&
     & 2.058768e+01,1.995365e+01,1.934213e+01,1.872688e+01,1.812404e+01,&
     & 1.839697e+01,1.783936e+01,1.728998e+01,1.673880e+01,1.619743e+01,&
     & 1.624751e+01,1.577008e+01,1.528565e+01,1.480817e+01,1.432883e+01,&
     & 1.420090e+01,1.380227e+01,1.339335e+01,1.297853e+01,1.255252e+01,&
     & 1.234566e+01,1.201055e+01,1.166492e+01,1.130291e+01,1.092780e+01,&
     & 1.094146e+01,1.064262e+01,1.033313e+01,1.000401e+01,9.665918e+00,&
     & 9.472126e+00,9.210186e+00,8.932034e+00,8.638601e+00,8.342547e+00,&
     & 8.094214e+00,7.864939e+00,7.620881e+00,7.366361e+00,7.116755e+00,&
     & 6.834321e+00,6.638517e+00,6.429566e+00,6.217516e+00,6.008021e+00/
      data   absa(:,5)  /                                               &
     & 1.312221e+02,1.278083e+02,1.243354e+02,1.211648e+02,1.181091e+02,&
     & 1.350714e+02,1.313366e+02,1.279551e+02,1.246081e+02,1.215434e+02,&
     & 1.381675e+02,1.343636e+02,1.307987e+02,1.273763e+02,1.241864e+02,&
     & 1.402241e+02,1.363618e+02,1.325349e+02,1.288720e+02,1.254054e+02,&
     & 1.403162e+02,1.364805e+02,1.325499e+02,1.288244e+02,1.251884e+02,&
     & 1.383684e+02,1.344907e+02,1.305668e+02,1.268925e+02,1.233479e+02,&
     & 1.346453e+02,1.307925e+02,1.269947e+02,1.234014e+02,1.199129e+02,&
     & 1.290807e+02,1.254006e+02,1.218308e+02,1.183842e+02,1.151219e+02,&
     & 1.219639e+02,1.186237e+02,1.153176e+02,1.121279e+02,1.091048e+02,&
     & 1.136653e+02,1.107059e+02,1.076520e+02,1.047395e+02,1.019546e+02,&
     & 1.041992e+02,1.013854e+02,9.864704e+01,9.597822e+01,9.335551e+01,&
     & 9.484422e+01,9.230293e+01,8.975732e+01,8.721164e+01,8.468875e+01,&
     & 8.513441e+01,8.282690e+01,8.046509e+01,7.807935e+01,7.574896e+01/
      data   absa(:,6)  /                                               &
     & 3.611321e+02,3.556058e+02,3.498716e+02,3.440949e+02,3.383258e+02,&
     & 4.036973e+02,3.951307e+02,3.863165e+02,3.776259e+02,3.683357e+02,&
     & 4.423904e+02,4.329120e+02,4.220833e+02,4.110757e+02,4.002402e+02,&
     & 4.728720e+02,4.629555e+02,4.521835e+02,4.409662e+02,4.298692e+02,&
     & 4.995770e+02,4.894672e+02,4.784123e+02,4.673280e+02,4.565170e+02,&
     & 5.268584e+02,5.163435e+02,5.042932e+02,4.921029e+02,4.797731e+02,&
     & 5.537910e+02,5.417844e+02,5.284191e+02,5.152966e+02,5.013795e+02,&
     & 5.804063e+02,5.666516e+02,5.515188e+02,5.356923e+02,5.196859e+02,&
     & 6.022189e+02,5.883998e+02,5.719105e+02,5.545273e+02,5.375103e+02,&
     & 6.154617e+02,6.006043e+02,5.839323e+02,5.669452e+02,5.493094e+02,&
     & 6.127319e+02,5.972150e+02,5.792353e+02,5.616503e+02,5.441388e+02,&
     & 5.989746e+02,5.823901e+02,5.649701e+02,5.478488e+02,5.312379e+02,&
     & 5.752825e+02,5.586685e+02,5.421561e+02,5.260994e+02,5.109337e+02/
      data   absa(:,7)  /                                               &
     & 5.885042e+02,5.769384e+02,5.707579e+02,5.626011e+02,5.535640e+02,&
     & 6.655113e+02,6.567831e+02,6.504269e+02,6.422605e+02,6.363201e+02,&
     & 7.567693e+02,7.511298e+02,7.424994e+02,7.344772e+02,7.289640e+02,&
     & 8.680281e+02,8.562017e+02,8.465945e+02,8.334892e+02,8.264376e+02,&
     & 9.882567e+02,9.730189e+02,9.596136e+02,9.438705e+02,9.315972e+02,&
     & 1.115747e+03,1.098869e+03,1.077767e+03,1.062948e+03,1.047237e+03,&
     & 1.250526e+03,1.229082e+03,1.207014e+03,1.188007e+03,1.168853e+03,&
     & 1.392960e+03,1.364986e+03,1.342222e+03,1.320097e+03,1.295147e+03,&
     & 1.538669e+03,1.506223e+03,1.478062e+03,1.449829e+03,1.423487e+03,&
     & 1.680943e+03,1.647770e+03,1.617210e+03,1.581259e+03,1.549281e+03,&
     & 1.802059e+03,1.766738e+03,1.734451e+03,1.696284e+03,1.658330e+03,&
     & 1.911848e+03,1.875069e+03,1.838838e+03,1.798507e+03,1.757837e+03,&
     & 2.009601e+03,1.972060e+03,1.930678e+03,1.889381e+03,1.842748e+03/
      data   absa(:,8) /                                                &
     & 1.034629e+03,1.012707e+03,1.001210e+03,9.870197e+02,9.647308e+02,&
     & 1.235543e+03,1.207923e+03,1.193199e+03,1.165659e+03,1.151179e+03,&
     & 1.474944e+03,1.452464e+03,1.427360e+03,1.385910e+03,1.367873e+03,&
     & 1.743649e+03,1.720775e+03,1.695371e+03,1.648131e+03,1.643273e+03,&
     & 2.052356e+03,2.019895e+03,1.999409e+03,1.962155e+03,1.929635e+03,&
     & 2.411012e+03,2.375323e+03,2.334918e+03,2.314008e+03,2.300733e+03,&
     & 2.806959e+03,2.795763e+03,2.730702e+03,2.706215e+03,2.682043e+03,&
     & 3.250125e+03,3.240390e+03,3.188175e+03,3.142353e+03,3.124931e+03,&
     & 3.739170e+03,3.706126e+03,3.670094e+03,3.636326e+03,3.610234e+03,&
     & 4.281714e+03,4.262730e+03,4.230813e+03,4.174891e+03,4.155855e+03,&
     & 4.928066e+03,4.893458e+03,4.853595e+03,4.794102e+03,4.767411e+03,&
     & 5.694021e+03,5.633797e+03,5.565809e+03,5.500612e+03,5.456980e+03,&
     & 6.556204e+03,6.483163e+03,6.394545e+03,6.324864e+03,6.236535e+03/
 
!     the array absb(235,NG01) = kb(5,13:59,NG01) contains absorption coefs
!     at the NG01=8 chosen g-values for a range of pressure levels < ~100mb
!     and temperatures. the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 13 to 59 and refers to the jpth reference
!     pressure level (see taumol.f for the value of these pressure levels
!     in mb).  the third index, ig, goes from 1 to NG01=8, and tells us
!     which g-interval the absorption coefficients are for.
 
      data   absb(:,1) /                                                &
     & 1.188584e-01,1.107305e-01,1.037105e-01,9.766051e-02,9.238188e-02,&
     & 1.036070e-01,9.688587e-02,9.120730e-02,8.634354e-02,8.216419e-02,&
     & 9.010155e-02,8.472244e-02,8.017501e-02,7.631794e-02,7.305743e-02,&
     & 7.648179e-02,7.215746e-02,6.852433e-02,6.545512e-02,6.284106e-02,&
     & 6.447221e-02,6.099641e-02,5.810039e-02,5.565650e-02,5.352912e-02,&
     & 5.400080e-02,5.121300e-02,4.890102e-02,4.693351e-02,4.521545e-02,&
     & 4.542776e-02,4.319926e-02,4.134876e-02,3.976658e-02,3.839206e-02,&
     & 3.781988e-02,3.604408e-02,3.456457e-02,3.330315e-02,3.220864e-02,&
     & 3.135820e-02,2.994580e-02,2.876145e-02,2.775883e-02,2.687872e-02,&
     & 2.581924e-02,2.470498e-02,2.376822e-02,2.297958e-02,2.226667e-02,&
     & 2.123406e-02,2.035402e-02,1.961335e-02,1.898695e-02,1.840735e-02,&
     & 1.748810e-02,1.679086e-02,1.620285e-02,1.570215e-02,1.523807e-02,&
     & 1.436060e-02,1.380883e-02,1.334747e-02,1.294098e-02,1.257088e-02,&
     & 1.175465e-02,1.132074e-02,1.095502e-02,1.062921e-02,1.033264e-02,&
     & 9.563612e-03,9.223051e-03,8.934014e-03,8.669021e-03,8.430844e-03,&
     & 7.749971e-03,7.481732e-03,7.250077e-03,7.035521e-03,6.844088e-03,&
     & 6.214530e-03,6.001678e-03,5.814696e-03,5.643096e-03,5.488414e-03,&
     & 4.960398e-03,4.790792e-03,4.639392e-03,4.501353e-03,4.376270e-03,&
     & 3.920287e-03,3.785376e-03,3.662577e-03,3.551204e-03,3.449820e-03,&
     & 3.092492e-03,2.984976e-03,2.885389e-03,2.795821e-03,2.713936e-03,&
     & 2.433119e-03,2.346259e-03,2.266677e-03,2.194460e-03,2.127861e-03,&
     & 1.927424e-03,1.857059e-03,1.793121e-03,1.735061e-03,1.680785e-03,&
     & 1.532498e-03,1.475127e-03,1.423296e-03,1.376226e-03,1.332009e-03,&
     & 1.225313e-03,1.178321e-03,1.135859e-03,1.097381e-03,1.061099e-03,&
     & 9.908422e-04,9.521286e-04,9.168505e-04,8.849446e-04,8.550764e-04,&
     & 8.003018e-04,7.682560e-04,7.389205e-04,7.124494e-04,6.879327e-04,&
     & 6.446306e-04,6.181921e-04,5.937916e-04,5.718350e-04,5.516887e-04,&
     & 5.272378e-04,5.052942e-04,4.847778e-04,4.668093e-04,4.502631e-04,&
     & 4.323103e-04,4.136385e-04,3.966537e-04,3.820798e-04,3.682234e-04,&
     & 3.539504e-04,3.385929e-04,3.245215e-04,3.114446e-04,3.008142e-04,&
     & 2.913011e-04,2.781936e-04,2.664020e-04,2.553088e-04,2.464106e-04,&
     & 2.401432e-04,2.288166e-04,2.188161e-04,2.094179e-04,2.010604e-04,&
     & 1.978038e-04,1.879940e-04,1.793354e-04,1.714942e-04,1.643685e-04,&
     & 1.632372e-04,1.547008e-04,1.471876e-04,1.405816e-04,1.345046e-04,&
     & 1.354597e-04,1.279606e-04,1.214294e-04,1.157400e-04,1.106055e-04,&
     & 1.123297e-04,1.055342e-04,1.000624e-04,9.510752e-05,9.076246e-05,&
     & 9.304149e-05,8.710412e-05,8.230814e-05,7.799569e-05,7.428400e-05,&
     & 7.744272e-05,7.228909e-05,6.795731e-05,6.437853e-05,6.115927e-05,&
     & 6.463576e-05,6.018045e-05,5.642352e-05,5.331694e-05,5.053712e-05,&
     & 5.386399e-05,5.007815e-05,4.682627e-05,4.412007e-05,4.172388e-05,&
     & 4.492046e-05,4.163750e-05,3.882739e-05,3.647523e-05,3.439931e-05,&
     & 3.778490e-05,3.494245e-05,3.251780e-05,3.048926e-05,2.870313e-05,&
     & 3.195692e-05,2.948929e-05,2.740031e-05,2.559504e-05,2.412029e-05,&
     & 2.705405e-05,2.490101e-05,2.310197e-05,2.155015e-05,2.028047e-05,&
     & 2.292727e-05,2.104342e-05,1.949108e-05,1.815590e-05,1.703116e-05,&
     & 1.945640e-05,1.781082e-05,1.646905e-05,1.532495e-05,1.436078e-05,&
     & 1.651526e-05,1.512788e-05,1.400328e-05,1.304437e-05,1.224340e-05/
      data   absb(:,2) /                                                &
     & 3.605168e-01,3.446729e-01,3.307613e-01,3.181930e-01,3.068206e-01,&
     & 3.106979e-01,2.980315e-01,2.868973e-01,2.769289e-01,2.679642e-01,&
     & 2.692210e-01,2.592085e-01,2.503679e-01,2.425067e-01,2.354710e-01,&
     & 2.290957e-01,2.212295e-01,2.143123e-01,2.082163e-01,2.028275e-01,&
     & 1.943168e-01,1.881820e-01,1.828186e-01,1.781326e-01,1.740759e-01,&
     & 1.638339e-01,1.590996e-01,1.549740e-01,1.514337e-01,1.483488e-01,&
     & 1.390994e-01,1.354779e-01,1.323701e-01,1.297430e-01,1.274470e-01,&
     & 1.169263e-01,1.141864e-01,1.118341e-01,1.098810e-01,1.081735e-01,&
     & 9.788549e-02,9.579619e-02,9.404559e-02,9.258549e-02,9.134133e-02,&
     & 8.144505e-02,7.986496e-02,7.856666e-02,7.750292e-02,7.658602e-02,&
     & 6.770016e-02,6.651535e-02,6.556165e-02,6.478476e-02,6.409879e-02,&
     & 5.645282e-02,5.558899e-02,5.489336e-02,5.433090e-02,5.380187e-02,&
     & 4.696176e-02,4.633534e-02,4.583018e-02,4.539146e-02,4.496490e-02,&
     & 3.894916e-02,3.848467e-02,3.809532e-02,3.774612e-02,3.740000e-02,&
     & 3.201342e-02,3.165418e-02,3.134882e-02,3.105146e-02,3.076431e-02,&
     & 2.613763e-02,2.584822e-02,2.559462e-02,2.534416e-02,2.510416e-02,&
     & 2.098921e-02,2.074392e-02,2.052438e-02,2.031312e-02,2.010239e-02,&
     & 1.673832e-02,1.652799e-02,1.633709e-02,1.614961e-02,1.596643e-02,&
     & 1.317026e-02,1.298803e-02,1.281625e-02,1.265058e-02,1.249225e-02,&
     & 1.035633e-02,1.019808e-02,1.004780e-02,9.903418e-03,9.766774e-03,&
     & 8.128671e-03,7.992982e-03,7.864123e-03,7.739102e-03,7.621329e-03,&
     & 6.438532e-03,6.323892e-03,6.215053e-03,6.109816e-03,6.009887e-03,&
     & 5.116032e-03,5.019410e-03,4.927611e-03,4.838737e-03,4.754145e-03,&
     & 4.085361e-03,4.003710e-03,3.926693e-03,3.851905e-03,3.780686e-03,&
     & 3.294793e-03,3.225983e-03,3.161350e-03,3.098795e-03,3.038790e-03,&
     & 2.654824e-03,2.596751e-03,2.542422e-03,2.490165e-03,2.439570e-03,&
     & 2.135421e-03,2.086011e-03,2.039997e-03,1.996502e-03,1.954154e-03,&
     & 1.741515e-03,1.699372e-03,1.660606e-03,1.625229e-03,1.590232e-03,&
     & 1.422944e-03,1.386764e-03,1.354250e-03,1.325714e-03,1.296758e-03,&
     & 1.161311e-03,1.131528e-03,1.104103e-03,1.078366e-03,1.056575e-03,&
     & 9.510751e-04,9.259328e-04,9.025109e-04,8.807753e-04,8.627728e-04,&
     & 7.796901e-04,7.582461e-04,7.382069e-04,7.197135e-04,7.026640e-04,&
     & 6.386579e-04,6.202528e-04,6.031701e-04,5.873169e-04,5.729906e-04,&
     & 5.238403e-04,5.079577e-04,4.933548e-04,4.797553e-04,4.675951e-04,&
     & 4.313947e-04,4.176277e-04,4.050594e-04,3.934249e-04,3.829754e-04,&
     & 3.549467e-04,3.424789e-04,3.322156e-04,3.222176e-04,3.132544e-04,&
     & 2.917001e-04,2.809828e-04,2.720832e-04,2.634467e-04,2.557729e-04,&
     & 2.408104e-04,2.316017e-04,2.234803e-04,2.165479e-04,2.099627e-04,&
     & 1.992853e-04,1.913645e-04,1.844206e-04,1.784771e-04,1.728420e-04,&
     & 1.646597e-04,1.580460e-04,1.520893e-04,1.469987e-04,1.421772e-04,&
     & 1.361048e-04,1.304423e-04,1.253118e-04,1.209676e-04,1.168289e-04,&
     & 1.132954e-04,1.084974e-04,1.041173e-04,1.004307e-04,9.691007e-05,&
     & 9.471162e-05,9.067809e-05,8.696270e-05,8.362699e-05,8.084690e-05,&
     & 7.922920e-05,7.582534e-05,7.267746e-05,6.985226e-05,6.749704e-05,&
     & 6.632919e-05,6.344568e-05,6.078590e-05,5.839160e-05,5.627600e-05,&
     & 5.562205e-05,5.317000e-05,5.093525e-05,4.890964e-05,4.712934e-05,&
     & 4.696079e-05,4.493571e-05,4.309428e-05,4.143710e-05,3.998691e-05/
      data   absb(:,3) /                                                &
     & 1.117735e+00,1.080184e+00,1.043270e+00,1.007591e+00,9.742075e-01,&
     & 9.789529e-01,9.478280e-01,9.173596e-01,8.880541e-01,8.606540e-01,&
     & 8.665203e-01,8.405564e-01,8.150066e-01,7.907292e-01,7.680385e-01,&
     & 7.528144e-01,7.310444e-01,7.099363e-01,6.899365e-01,6.711492e-01,&
     & 6.497549e-01,6.319656e-01,6.148742e-01,5.984917e-01,5.832503e-01,&
     & 5.562434e-01,5.419053e-01,5.281320e-01,5.150724e-01,5.031397e-01,&
     & 4.799351e-01,4.685626e-01,4.576734e-01,4.475964e-01,4.384044e-01,&
     & 4.092397e-01,4.002831e-01,3.919350e-01,3.843158e-01,3.773650e-01,&
     & 3.469867e-01,3.401335e-01,3.338834e-01,3.281490e-01,3.229115e-01,&
     & 2.920308e-01,2.869414e-01,2.822447e-01,2.779669e-01,2.741207e-01,&
     & 2.455328e-01,2.417119e-01,2.382267e-01,2.350559e-01,2.323134e-01,&
     & 2.072847e-01,2.044343e-01,2.018713e-01,1.996664e-01,1.978283e-01,&
     & 1.744516e-01,1.723576e-01,1.705750e-01,1.690697e-01,1.678974e-01,&
     & 1.462535e-01,1.447794e-01,1.435404e-01,1.425768e-01,1.417883e-01,&
     & 1.212998e-01,1.202610e-01,1.194272e-01,1.187237e-01,1.180982e-01,&
     & 9.980898e-02,9.905759e-02,9.842935e-02,9.785915e-02,9.729150e-02,&
     & 8.048081e-02,7.987364e-02,7.932137e-02,7.879581e-02,7.824715e-02,&
     & 6.432927e-02,6.378559e-02,6.327049e-02,6.276873e-02,6.224728e-02,&
     & 5.053836e-02,5.003417e-02,4.954504e-02,4.906871e-02,4.858913e-02,&
     & 3.965301e-02,3.919128e-02,3.874116e-02,3.830937e-02,3.788280e-02,&
     & 3.102984e-02,3.061751e-02,3.021681e-02,2.983636e-02,2.946761e-02,&
     & 2.453367e-02,2.417416e-02,2.382999e-02,2.350620e-02,2.319466e-02,&
     & 1.944696e-02,1.913844e-02,1.884555e-02,1.857251e-02,1.831163e-02,&
     & 1.548875e-02,1.522716e-02,1.497895e-02,1.474909e-02,1.453075e-02,&
     & 1.246599e-02,1.224514e-02,1.203566e-02,1.184048e-02,1.165849e-02,&
     & 1.001892e-02,9.831572e-03,9.656160e-03,9.490883e-03,9.339558e-03,&
     & 8.031171e-03,7.873503e-03,7.723956e-03,7.587383e-03,7.460943e-03,&
     & 6.536561e-03,6.404470e-03,6.279203e-03,6.170236e-03,6.065862e-03,&
     & 5.329766e-03,5.218385e-03,5.114746e-03,5.030483e-03,4.942761e-03,&
     & 4.335118e-03,4.250624e-03,4.165045e-03,4.080638e-03,4.023345e-03,&
     & 3.539198e-03,3.471119e-03,3.400120e-03,3.328524e-03,3.281959e-03,&
     & 2.890614e-03,2.835406e-03,2.776260e-03,2.715755e-03,2.661208e-03,&
     & 2.357360e-03,2.312203e-03,2.262839e-03,2.212077e-03,2.165843e-03,&
     & 1.923542e-03,1.886625e-03,1.845448e-03,1.802975e-03,1.763796e-03,&
     & 1.574914e-03,1.544842e-03,1.510381e-03,1.475005e-03,1.442030e-03,&
     & 1.287106e-03,1.256459e-03,1.233732e-03,1.204323e-03,1.176708e-03,&
     & 1.049409e-03,1.023785e-03,1.005219e-03,9.806497e-04,9.576227e-04,&
     & 8.602653e-04,8.390343e-04,8.196353e-04,8.033423e-04,7.842166e-04,&
     & 7.069383e-04,6.895249e-04,6.734499e-04,6.600623e-04,6.441337e-04,&
     & 5.778267e-04,5.658893e-04,5.525933e-04,5.415255e-04,5.282749e-04,&
     & 4.733282e-04,4.635497e-04,4.526321e-04,4.433938e-04,4.323965e-04,&
     & 3.916769e-04,3.837609e-04,3.748737e-04,3.672298e-04,3.581675e-04,&
     & 3.260897e-04,3.197170e-04,3.125560e-04,3.047231e-04,2.988326e-04,&
     & 2.715190e-04,2.664575e-04,2.607270e-04,2.543079e-04,2.494784e-04,&
     & 2.261227e-04,2.222121e-04,2.176140e-04,2.123909e-04,2.073056e-04,&
     & 1.887195e-04,1.857905e-04,1.821065e-04,1.778970e-04,1.737202e-04,&
     & 1.603824e-04,1.582205e-04,1.553478e-04,1.519685e-04,1.486144e-04/
      data   absb(:,4) /                                                &
     & 6.834865e+00,6.638031e+00,6.429193e+00,6.217201e+00,6.008780e+00,&
     & 5.800502e+00,5.633283e+00,5.458002e+00,5.280728e+00,5.109059e+00,&
     & 5.003790e+00,4.863288e+00,4.717391e+00,4.571090e+00,4.426601e+00,&
     & 4.337969e+00,4.221774e+00,4.101226e+00,3.978502e+00,3.857516e+00,&
     & 3.805014e+00,3.707134e+00,3.606205e+00,3.503096e+00,3.401713e+00,&
     & 3.336208e+00,3.253296e+00,3.167364e+00,3.080482e+00,2.995784e+00,&
     & 2.947355e+00,2.877153e+00,2.804773e+00,2.732389e+00,2.662218e+00,&
     & 2.571854e+00,2.512429e+00,2.452243e+00,2.392527e+00,2.335367e+00,&
     & 2.225939e+00,2.176822e+00,2.127372e+00,2.078907e+00,2.033172e+00,&
     & 1.906920e+00,1.866715e+00,1.826913e+00,1.788754e+00,1.752546e+00,&
     & 1.627512e+00,1.595168e+00,1.564148e+00,1.534235e+00,1.506170e+00,&
     & 1.391770e+00,1.366858e+00,1.342869e+00,1.320421e+00,1.299387e+00,&
     & 1.185175e+00,1.166395e+00,1.148586e+00,1.131988e+00,1.116912e+00,&
     & 1.004264e+00,9.905181e-01,9.776359e-01,9.662641e-01,9.559160e-01,&
     & 8.417388e-01,8.319919e-01,8.232006e-01,8.151468e-01,8.080107e-01,&
     & 7.001649e-01,6.931987e-01,6.869845e-01,6.813820e-01,6.766031e-01,&
     & 5.704507e-01,5.653525e-01,5.607917e-01,5.568628e-01,5.534749e-01,&
     & 4.605337e-01,4.566398e-01,4.532191e-01,4.502833e-01,4.478645e-01,&
     & 3.651890e-01,3.620804e-01,3.593766e-01,3.570508e-01,3.550960e-01,&
     & 2.891126e-01,2.866236e-01,2.844338e-01,2.825432e-01,2.808490e-01,&
     & 2.281853e-01,2.261499e-01,2.243537e-01,2.227480e-01,2.212713e-01,&
     & 1.820698e-01,1.804306e-01,1.789695e-01,1.776194e-01,1.763338e-01,&
     & 1.455436e-01,1.442125e-01,1.429981e-01,1.418451e-01,1.406898e-01,&
     & 1.167984e-01,1.156968e-01,1.146835e-01,1.136931e-01,1.126722e-01,&
     & 9.462337e-02,9.372146e-02,9.287631e-02,9.203406e-02,9.115519e-02,&
     & 7.645253e-02,7.569449e-02,7.499489e-02,7.427844e-02,7.352450e-02,&
     & 6.153430e-02,6.089410e-02,6.028741e-02,5.969877e-02,5.906061e-02,&
     & 5.030346e-02,4.977709e-02,4.927878e-02,4.883124e-02,4.830974e-02,&
     & 4.117412e-02,4.072611e-02,4.032875e-02,4.003948e-02,3.960791e-02,&
     & 3.358777e-02,3.330233e-02,3.298160e-02,3.261824e-02,3.243189e-02,&
     & 2.749334e-02,2.728740e-02,2.702385e-02,2.671281e-02,2.659752e-02,&
     & 2.250304e-02,2.235071e-02,2.213204e-02,2.186803e-02,2.162107e-02,&
     & 1.837816e-02,1.825979e-02,1.807732e-02,1.785590e-02,1.765257e-02,&
     & 1.500714e-02,1.491533e-02,1.476275e-02,1.457716e-02,1.441015e-02,&
     & 1.229251e-02,1.221784e-02,1.209262e-02,1.193957e-02,1.180315e-02,&
     & 1.004099e-02,9.893852e-03,9.874218e-03,9.748040e-03,9.638648e-03,&
     & 8.171397e-03,8.047651e-03,8.030863e-03,7.926210e-03,7.838407e-03,&
     & 6.692593e-03,6.591492e-03,6.517800e-03,6.491883e-03,6.421433e-03,&
     & 5.497945e-03,5.414627e-03,5.354571e-03,5.334608e-03,5.278523e-03,&
     & 4.469719e-03,4.438056e-03,4.388776e-03,4.373082e-03,4.328045e-03,&
     & 3.653522e-03,3.627345e-03,3.586526e-03,3.573242e-03,3.536993e-03,&
     & 3.024925e-03,3.005623e-03,2.973408e-03,2.965011e-03,2.936709e-03,&
     & 2.523262e-03,2.511022e-03,2.486512e-03,2.459230e-03,2.461818e-03,&
     & 2.104940e-03,2.098455e-03,2.080108e-03,2.059082e-03,2.064523e-03,&
     & 1.756698e-03,1.754548e-03,1.741129e-03,1.724954e-03,1.712547e-03,&
     & 1.470473e-03,1.471788e-03,1.462606e-03,1.450532e-03,1.441609e-03,&
     & 1.261271e-03,1.266930e-03,1.262911e-03,1.255459e-03,1.249582e-03/
      data   absb(:,5) /                                                &
     & 8.512491e+01,8.281789e+01,8.045453e+01,7.807747e+01,7.575748e+01,&
     & 7.527586e+01,7.319452e+01,7.104618e+01,6.894920e+01,6.687898e+01,&
     & 6.574123e+01,6.384006e+01,6.194865e+01,6.009889e+01,5.830196e+01,&
     & 5.676452e+01,5.513466e+01,5.351162e+01,5.196349e+01,5.045125e+01,&
     & 4.868854e+01,4.730744e+01,4.596922e+01,4.465121e+01,4.331755e+01,&
     & 4.164537e+01,4.052060e+01,3.938392e+01,3.821696e+01,3.704723e+01,&
     & 3.581955e+01,3.485774e+01,3.385868e+01,3.285578e+01,3.185656e+01,&
     & 3.087423e+01,3.003561e+01,2.918254e+01,2.833009e+01,2.748358e+01,&
     & 2.674838e+01,2.603623e+01,2.531031e+01,2.458874e+01,2.387883e+01,&
     & 2.325291e+01,2.264394e+01,2.202625e+01,2.141668e+01,2.081767e+01,&
     & 2.037032e+01,1.984862e+01,1.932860e+01,1.881130e+01,1.830020e+01,&
     & 1.799206e+01,1.755058e+01,1.710670e+01,1.666381e+01,1.623132e+01,&
     & 1.584843e+01,1.547436e+01,1.509239e+01,1.471539e+01,1.435165e+01,&
     & 1.388650e+01,1.356357e+01,1.323969e+01,1.292521e+01,1.262307e+01,&
     & 1.199693e+01,1.172589e+01,1.145851e+01,1.119949e+01,1.095746e+01,&
     & 1.023584e+01,1.001291e+01,9.794489e+00,9.589520e+00,9.400820e+00,&
     & 8.532244e+00,8.351509e+00,8.179837e+00,8.022518e+00,7.876143e+00,&
     & 7.029361e+00,6.887036e+00,6.754492e+00,6.634188e+00,6.521676e+00,&
     & 5.685501e+00,5.576110e+00,5.474649e+00,5.383094e+00,5.298611e+00,&
     & 4.587155e+00,4.503349e+00,4.426229e+00,4.357221e+00,4.295379e+00,&
     & 3.687765e+00,3.624432e+00,3.566819e+00,3.515520e+00,3.469867e+00,&
     & 2.991966e+00,2.944257e+00,2.902101e+00,2.864655e+00,2.831590e+00,&
     & 2.431976e+00,2.397002e+00,2.365777e+00,2.337979e+00,2.314688e+00,&
     & 1.984670e+00,1.958656e+00,1.935385e+00,1.915332e+00,1.898912e+00,&
     & 1.633896e+00,1.614415e+00,1.597441e+00,1.583157e+00,1.571785e+00,&
     & 1.341002e+00,1.326168e+00,1.314542e+00,1.304562e+00,1.296937e+00,&
     & 1.095988e+00,1.084830e+00,1.076138e+00,1.070043e+00,1.065093e+00,&
     & 9.081362e-01,9.002150e-01,8.943365e-01,8.912659e-01,8.887799e-01,&
     & 7.528582e-01,7.471623e-01,7.435455e-01,7.433726e-01,7.425094e-01,&
     & 6.216230e-01,6.193471e-01,6.173088e-01,6.160044e-01,6.191547e-01,&
     & 5.147423e-01,5.140072e-01,5.129511e-01,5.124184e-01,5.164068e-01,&
     & 4.259526e-01,4.261768e-01,4.257458e-01,4.256694e-01,4.270394e-01,&
     & 3.515497e-01,3.522294e-01,3.521867e-01,3.524054e-01,3.539326e-01,&
     & 2.898826e-01,2.908672e-01,2.910261e-01,2.913808e-01,2.929261e-01,&
     & 2.395717e-01,2.406798e-01,2.409791e-01,2.414377e-01,2.429683e-01,&
     & 1.972602e-01,1.967066e-01,1.987234e-01,1.992277e-01,2.006390e-01,&
     & 1.616156e-01,1.611992e-01,1.630014e-01,1.634608e-01,1.646967e-01,&
     & 1.333012e-01,1.330779e-01,1.336616e-01,1.352413e-01,1.364007e-01,&
     & 1.102540e-01,1.101901e-01,1.108204e-01,1.122956e-01,1.134089e-01,&
     & 9.013788e-02,9.093119e-02,9.156268e-02,9.290376e-02,9.393475e-02,&
     & 7.398692e-02,7.470780e-02,7.530101e-02,7.647781e-02,7.740043e-02,&
     & 6.168555e-02,6.242483e-02,6.305700e-02,6.421687e-02,6.513125e-02,&
     & 5.194243e-02,5.273049e-02,5.342356e-02,5.408332e-02,5.557184e-02,&
     & 4.376803e-02,4.457709e-02,4.529952e-02,4.600050e-02,4.748291e-02,&
     & 3.690363e-02,3.771451e-02,3.845073e-02,3.916861e-02,4.014536e-02,&
     & 3.125863e-02,3.207418e-02,3.281862e-02,3.355084e-02,3.454136e-02,&
     & 2.752628e-02,2.846420e-02,2.932109e-02,3.019102e-02,3.138385e-02/
      data   absb(:,6) /                                                &
     & 5.752820e+02,5.585467e+02,5.422423e+02,5.261497e+02,5.109261e+02,&
     & 5.432524e+02,5.276696e+02,5.128634e+02,4.984170e+02,4.840356e+02,&
     & 5.064568e+02,4.928218e+02,4.790230e+02,4.657940e+02,4.527250e+02,&
     & 4.680705e+02,4.554667e+02,4.431096e+02,4.301650e+02,4.173226e+02,&
     & 4.286588e+02,4.168360e+02,4.044579e+02,3.921067e+02,3.801392e+02,&
     & 3.874100e+02,3.761657e+02,3.645517e+02,3.533527e+02,3.428555e+02,&
     & 3.452293e+02,3.347962e+02,3.247882e+02,3.150153e+02,3.057524e+02,&
     & 3.034647e+02,2.943677e+02,2.855370e+02,2.771994e+02,2.692792e+02,&
     & 2.636385e+02,2.559841e+02,2.486938e+02,2.417738e+02,2.347303e+02,&
     & 2.267534e+02,2.205230e+02,2.144790e+02,2.082461e+02,2.018953e+02,&
     & 1.940593e+02,1.887912e+02,1.833422e+02,1.778004e+02,1.723591e+02,&
     & 1.658857e+02,1.612162e+02,1.564392e+02,1.517948e+02,1.471830e+02,&
     & 1.423116e+02,1.383053e+02,1.343560e+02,1.304361e+02,1.266022e+02,&
     & 1.232626e+02,1.199309e+02,1.166241e+02,1.133724e+02,1.101838e+02,&
     & 1.076445e+02,1.048397e+02,1.020490e+02,9.927101e+01,9.652357e+01,&
     & 9.449147e+01,9.207990e+01,8.968916e+01,8.729149e+01,8.492214e+01,&
     & 8.161966e+01,7.960194e+01,7.754677e+01,7.551328e+01,7.356425e+01,&
     & 6.981713e+01,6.807863e+01,6.634332e+01,6.467345e+01,6.308249e+01,&
     & 5.858538e+01,5.713023e+01,5.571190e+01,5.436420e+01,5.313156e+01,&
     & 4.887215e+01,4.768349e+01,4.654055e+01,4.550173e+01,4.455772e+01,&
     & 4.049019e+01,3.954064e+01,3.866334e+01,3.787635e+01,3.716129e+01,&
     & 3.376083e+01,3.302460e+01,3.236770e+01,3.177297e+01,3.124051e+01,&
     & 2.815010e+01,2.759829e+01,2.711080e+01,2.667061e+01,2.627433e+01,&
     & 2.353315e+01,2.312224e+01,2.275807e+01,2.243072e+01,2.215094e+01,&
     & 1.982604e+01,1.951965e+01,1.924550e+01,1.901307e+01,1.882081e+01,&
     & 1.663153e+01,1.640988e+01,1.621653e+01,1.605897e+01,1.593329e+01,&
     & 1.388824e+01,1.373057e+01,1.359700e+01,1.350142e+01,1.342639e+01,&
     & 1.173533e+01,1.162921e+01,1.154792e+01,1.149659e+01,1.146322e+01,&
     & 9.910382e+00,9.840882e+00,9.800180e+00,9.791236e+00,9.792204e+00,&
     & 8.338884e+00,8.310818e+00,8.300467e+00,8.305890e+00,8.350007e+00,&
     & 7.024660e+00,7.026067e+00,7.036098e+00,7.056825e+00,7.122995e+00,&
     & 5.910802e+00,5.932872e+00,5.957102e+00,5.989125e+00,6.044279e+00,&
     & 4.957048e+00,4.992718e+00,5.026054e+00,5.066524e+00,5.128477e+00,&
     & 4.149113e+00,4.193687e+00,4.232631e+00,4.278156e+00,4.343098e+00,&
     & 3.475117e+00,3.524479e+00,3.566903e+00,3.616189e+00,3.681214e+00,&
     & 2.898047e+00,2.920758e+00,2.991100e+00,3.041221e+00,3.104844e+00,&
     & 2.403824e+00,2.426443e+00,2.492814e+00,2.541150e+00,2.601269e+00,&
     & 2.005563e+00,2.028669e+00,2.070384e+00,2.138256e+00,2.195571e+00,&
     & 1.677313e+00,1.699833e+00,1.739744e+00,1.803638e+00,1.858281e+00,&
     & 1.380964e+00,1.419212e+00,1.456544e+00,1.515550e+00,1.566027e+00,&
     & 1.144811e+00,1.179689e+00,1.213717e+00,1.266730e+00,1.312698e+00,&
     & 9.633002e-01,9.966121e-01,1.029009e+00,1.079266e+00,1.123765e+00,&
     & 8.179431e-01,8.505309e-01,8.821859e-01,9.175041e-01,9.752531e-01,&
     & 6.947530e-01,7.264339e-01,7.569261e-01,7.909790e-01,8.474302e-01,&
     & 5.905893e-01,6.212258e-01,6.503137e-01,6.828478e-01,7.251909e-01,&
     & 5.048534e-01,5.345532e-01,5.625916e-01,5.940099e-01,6.352787e-01,&
     & 4.534170e-01,4.845147e-01,5.148627e-01,5.491796e-01,5.942442e-01/
      data   absb(:,7) /                                                &
     & 2.009850e+03,1.972721e+03,1.931973e+03,1.888786e+03,1.842337e+03,&
     & 2.089658e+03,2.047897e+03,1.999985e+03,1.952047e+03,1.905455e+03,&
     & 2.148088e+03,2.097314e+03,2.048909e+03,1.997604e+03,1.947339e+03,&
     & 2.178053e+03,2.126502e+03,2.075408e+03,2.021413e+03,1.967883e+03,&
     & 2.184361e+03,2.133521e+03,2.078562e+03,2.023480e+03,1.967446e+03,&
     & 2.171974e+03,2.117225e+03,2.061841e+03,2.003477e+03,1.946557e+03,&
     & 2.135019e+03,2.080328e+03,2.022958e+03,1.965176e+03,1.908644e+03,&
     & 2.072149e+03,2.016896e+03,1.961269e+03,1.904727e+03,1.847614e+03,&
     & 1.986068e+03,1.931850e+03,1.875804e+03,1.820674e+03,1.766343e+03,&
     & 1.873668e+03,1.820913e+03,1.766946e+03,1.715598e+03,1.666217e+03,&
     & 1.742213e+03,1.692948e+03,1.644634e+03,1.598475e+03,1.553929e+03,&
     & 1.600555e+03,1.556418e+03,1.513790e+03,1.472252e+03,1.432352e+03,&
     & 1.453515e+03,1.414712e+03,1.377497e+03,1.340076e+03,1.304437e+03,&
     & 1.309077e+03,1.274411e+03,1.240345e+03,1.207182e+03,1.175063e+03,&
     & 1.168232e+03,1.137241e+03,1.107248e+03,1.077854e+03,1.050763e+03,&
     & 1.033976e+03,1.006921e+03,9.808276e+02,9.562390e+02,9.335413e+02,&
     & 9.078413e+02,8.850084e+02,8.634978e+02,8.436024e+02,8.245219e+02,&
     & 7.908981e+02,7.721570e+02,7.554744e+02,7.396845e+02,7.244805e+02,&
     & 6.844369e+02,6.705252e+02,6.574840e+02,6.449036e+02,6.326284e+02,&
     & 5.907426e+02,5.800388e+02,5.697898e+02,5.597642e+02,5.502255e+02,&
     & 5.080865e+02,4.999726e+02,4.918342e+02,4.840416e+02,4.770977e+02,&
     & 4.372921e+02,4.307798e+02,4.246055e+02,4.192538e+02,4.143678e+02,&
     & 3.762074e+02,3.714803e+02,3.674506e+02,3.640296e+02,3.607530e+02,&
     & 3.242892e+02,3.212032e+02,3.188615e+02,3.168326e+02,3.148941e+02,&
     & 2.804244e+02,2.787489e+02,2.776849e+02,2.766591e+02,2.758353e+02,&
     & 2.423718e+02,2.418043e+02,2.418276e+02,2.416205e+02,2.416267e+02,&
     & 2.093882e+02,2.096561e+02,2.102318e+02,2.108345e+02,2.116110e+02,&
     & 1.818268e+02,1.827248e+02,1.837024e+02,1.848664e+02,1.862412e+02,&
     & 1.581482e+02,1.594821e+02,1.608207e+02,1.623492e+02,1.641757e+02,&
     & 1.375556e+02,1.392762e+02,1.408899e+02,1.426376e+02,1.449162e+02,&
     & 1.196668e+02,1.216621e+02,1.235565e+02,1.255629e+02,1.280685e+02,&
     & 1.040396e+02,1.062051e+02,1.083071e+02,1.105537e+02,1.131854e+02,&
     & 9.031610e+01,9.257200e+01,9.482417e+01,9.720372e+01,9.998387e+01,&
     & 7.833343e+01,8.062012e+01,8.294762e+01,8.539137e+01,8.825188e+01,&
     & 6.795313e+01,7.021011e+01,7.255161e+01,7.503931e+01,7.793264e+01,&
     & 5.875565e+01,6.086892e+01,6.333797e+01,6.578509e+01,6.867079e+01,&
     & 5.056430e+01,5.261937e+01,5.506362e+01,5.748823e+01,6.033465e+01,&
     & 4.376241e+01,4.576299e+01,4.805226e+01,5.057137e+01,5.334385e+01,&
     & 3.799456e+01,3.990847e+01,4.213092e+01,4.463730e+01,4.733752e+01,&
     & 3.280882e+01,3.470782e+01,3.685211e+01,3.930196e+01,4.194882e+01,&
     & 2.824924e+01,3.007021e+01,3.210226e+01,3.449769e+01,3.706214e+01,&
     & 2.477498e+01,2.656128e+01,2.851645e+01,3.082565e+01,3.331701e+01,&
     & 2.203423e+01,2.381118e+01,2.573445e+01,2.786912e+01,3.039691e+01,&
     & 1.965611e+01,2.143227e+01,2.332817e+01,2.543610e+01,2.789405e+01,&
     & 1.756676e+01,1.937588e+01,2.123435e+01,2.334023e+01,2.566745e+01,&
     & 1.583740e+01,1.771984e+01,1.958441e+01,2.169535e+01,2.406093e+01,&
     & 1.537303e+01,1.754936e+01,1.968587e+01,2.202946e+01,2.466408e+01/
      data   absb(:,8) /                                                &
     & 6.542090e+03,6.440177e+03,6.392552e+03,6.293362e+03,6.245077e+03,&
     & 7.468852e+03,7.410027e+03,7.301736e+03,7.193966e+03,7.088459e+03,&
     & 8.541426e+03,8.423472e+03,8.307703e+03,8.168462e+03,8.050069e+03,&
     & 9.633780e+03,9.506928e+03,9.364065e+03,9.222383e+03,9.080635e+03,&
     & 1.076247e+04,1.061623e+04,1.046919e+04,1.031817e+04,1.013586e+04,&
     & 1.198302e+04,1.177749e+04,1.162609e+04,1.143318e+04,1.123989e+04,&
     & 1.320427e+04,1.301731e+04,1.281292e+04,1.260604e+04,1.236448e+04,&
     & 1.452981e+04,1.429495e+04,1.402913e+04,1.380807e+04,1.355120e+04,&
     & 1.584224e+04,1.556770e+04,1.532103e+04,1.504238e+04,1.474457e+04,&
     & 1.718721e+04,1.689819e+04,1.655896e+04,1.627729e+04,1.594517e+04,&
     & 1.852949e+04,1.820030e+04,1.784171e+04,1.748214e+04,1.710514e+04,&
     & 1.986401e+04,1.946302e+04,1.904791e+04,1.862863e+04,1.821645e+04,&
     & 2.111005e+04,2.065980e+04,2.019218e+04,1.973758e+04,1.928954e+04,&
     & 2.221966e+04,2.174246e+04,2.125483e+04,2.077691e+04,2.029629e+04,&
     & 2.325571e+04,2.274679e+04,2.222159e+04,2.171657e+04,2.120127e+04,&
     & 2.420950e+04,2.366581e+04,2.309433e+04,2.255776e+04,2.201281e+04,&
     & 2.504584e+04,2.446775e+04,2.386068e+04,2.328822e+04,2.271622e+04,&
     & 2.579779e+04,2.517121e+04,2.455160e+04,2.393193e+04,2.333593e+04,&
     & 2.642329e+04,2.576206e+04,2.511855e+04,2.447767e+04,2.385147e+04,&
     & 2.693667e+04,2.625372e+04,2.559207e+04,2.493458e+04,2.429219e+04,&
     & 2.735499e+04,2.666845e+04,2.597857e+04,2.530995e+04,2.465237e+04,&
     & 2.771205e+04,2.701309e+04,2.631130e+04,2.563293e+04,2.496250e+04,&
     & 2.806467e+04,2.735257e+04,2.663557e+04,2.594727e+04,2.529821e+04,&
     & 2.842849e+04,2.770413e+04,2.697665e+04,2.627738e+04,2.561983e+04,&
     & 2.884921e+04,2.811312e+04,2.737321e+04,2.666315e+04,2.599622e+04,&
     & 2.923150e+04,2.846169e+04,2.773543e+04,2.701629e+04,2.633911e+04,&
     & 2.957196e+04,2.879413e+04,2.805493e+04,2.733466e+04,2.665006e+04,&
     & 2.995818e+04,2.917114e+04,2.842589e+04,2.769624e+04,2.700298e+04,&
     & 3.032373e+04,2.953293e+04,2.877954e+04,2.804263e+04,2.734178e+04,&
     & 3.063296e+04,2.987218e+04,2.911303e+04,2.836782e+04,2.765941e+04,&
     & 3.100125e+04,3.023628e+04,2.947446e+04,2.872034e+04,2.800490e+04,&
     & 3.137182e+04,3.060751e+04,2.983624e+04,2.907825e+04,2.834668e+04,&
     & 3.172667e+04,3.096232e+04,3.019102e+04,2.942557e+04,2.868740e+04,&
     & 3.208750e+04,3.132314e+04,3.055100e+04,2.978127e+04,2.903625e+04,&
     & 3.246549e+04,3.171009e+04,3.093546e+04,3.016302e+04,2.941115e+04,&
     & 3.283491e+04,3.211129e+04,3.131158e+04,3.053744e+04,2.977971e+04,&
     & 3.319409e+04,3.247780e+04,3.168400e+04,3.090703e+04,3.014686e+04,&
     & 3.352492e+04,3.282000e+04,3.203236e+04,3.125340e+04,3.048929e+04,&
     & 3.383799e+04,3.314552e+04,3.236284e+04,3.158513e+04,3.082218e+04,&
     & 3.415991e+04,3.346496e+04,3.268875e+04,3.191527e+04,3.115218e+04,&
     & 3.446079e+04,3.378139e+04,3.301314e+04,3.224437e+04,3.148195e+04,&
     & 3.473362e+04,3.406627e+04,3.331190e+04,3.254800e+04,3.178705e+04,&
     & 3.499148e+04,3.434121e+04,3.359344e+04,3.283934e+04,3.208253e+04,&
     & 3.524898e+04,3.461754e+04,3.388306e+04,3.313195e+04,3.237755e+04,&
     & 3.550487e+04,3.489245e+04,3.417037e+04,3.342630e+04,3.265778e+04,&
     & 3.575597e+04,3.515803e+04,3.444871e+04,3.371371e+04,3.294819e+04,&
     & 3.589743e+04,3.530421e+04,3.459686e+04,3.385961e+04,3.309168e+04/
 
!     the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG01=8).
 
      data  selfref(:, 1) /                                             &
     & 3.85782e+00,3.48866e+00,3.15499e+00,2.85339e+00,2.58075e+00,     &
     & 2.33428e+00,2.11145e+00,1.91000e+00,1.72785e+00,1.56315e+00/
      data  selfref(:, 2) /                                             &
     & 6.31101e+00,5.72251e+00,5.18891e+00,4.70509e+00,4.26639e+00,     &
     & 3.86862e+00,3.50795e+00,3.18091e+00,2.88437e+00,2.61549e+00/
      data  selfref(:, 3) /                                             &
     & 6.22671e+00,5.64924e+00,5.12532e+00,4.64999e+00,4.21875e+00,     &
     & 3.82750e+00,3.47254e+00,3.15049e+00,2.85832e+00,2.59323e+00/
      data  selfref(:, 4) /                                             &
     & 6.18196e+00,5.62148e+00,5.11189e+00,4.64856e+00,4.22728e+00,     &
     & 3.84424e+00,3.49594e+00,3.17925e+00,2.89129e+00,2.62944e+00/
      data  selfref(:, 5) /                                             &
     & 6.26761e+00,5.75212e+00,5.27904e+00,4.84487e+00,4.44640e+00,     &
     & 4.08072e+00,3.74510e+00,3.43710e+00,3.15443e+00,2.89501e+00/
      data  selfref(:, 6) /                                             &
     & 7.14853e+00,6.48281e+00,5.87910e+00,5.33162e+00,4.83513e+00,     &
     & 4.38489e+00,3.97659e+00,3.60630e+00,3.27051e+00,2.96598e+00/
      data  selfref(:, 7) /                                             &
     & 6.99620e+00,6.42504e+00,5.90065e+00,5.41920e+00,4.97716e+00,     &
     & 4.57128e+00,4.19861e+00,3.85641e+00,3.54219e+00,3.25365e+00/
      data  selfref(:, 8) /                                             &
     & 7.45019e+00,6.77368e+00,6.15864e+00,5.59946e+00,5.09108e+00,     &
     & 4.62888e+00,4.20866e+00,3.82661e+00,3.47925e+00,3.16345e+00/
 
      data  forref /                                                    &
     & -8.15395564e-02,-5.11118397e-02,-2.34778970e-02,-1.43142389e-02, &
     & -1.17182080e-02, 4.67175525e-03, 1.97165832e-02, 8.48740190e-02 /
 
      data  fracrefa /                                                  &
     & 0.2640497088, 0.2981655002, 0.2306305170, 0.1473007500,          &
     & 0.0469404794, 0.0075516403, 0.0044305800, 0.0009305400 /
      data  fracrefb /                                                  &
     & 0.3287672997, 0.2784040570, 0.1999233812, 0.1357454211,          &
     & 0.0455209911, 0.0068867803, 0.0040154802, 0.0007363300 /
 
!........................................!
      end module module_radlw_kgb01_nmmb !
!========================================!
 
 
 
!========================================!
      module module_radlw_kgb02_nmmb     !
!........................................!
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NG02
!
      implicit none
!
      private
!
      integer, public :: MSA02, MSB02, MSF02, MAF02
      parameter (MSA02=65, MSB02=235, MSF02=10, MAF02=13)

      real (kind=kind_phys), public ::                                  &
     &       absa(MSA02,NG02), absb(MSB02,NG02), selfref(MSF02,NG02),   &
     &       forref(NG02), fracrefa(NG02,MAF02), fracrefb(NG02),        &
     &       refparam(MAF02)
 
!     the array absa(65,NG02) = ka(5,13,NG02) contains absorption coefs
!     at the NG02=14 chosen g-values for a range of pressure levels>~100mb
!     and temperatures.  the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 1 to 13 and refers to the corresponding
!     pressure level in pref (e.g. jp = 1 is for a pressure of 1053.63 mb).
!     the third index, ig, goes from 1 to NG02=14, and tells us which
!     g-interval the absorption coefficients are for.
 
      data   absa(:, 1) /                                               &
     & 1.440000e-02,1.555400e-02,1.673900e-02,1.796100e-02,1.937900e-02,&
     & 1.145200e-02,1.228800e-02,1.323200e-02,1.419000e-02,1.527700e-02,&
     & 8.998900e-03,9.596000e-03,1.032700e-02,1.106800e-02,1.188900e-02,&
     & 7.107800e-03,7.542400e-03,8.071000e-03,8.663900e-03,9.292000e-03,&
     & 5.663200e-03,5.961600e-03,6.342100e-03,6.807600e-03,7.294900e-03,&
     & 4.534800e-03,4.726700e-03,5.001500e-03,5.339100e-03,5.731700e-03,&
     & 3.648400e-03,3.773700e-03,3.958300e-03,4.205000e-03,4.506900e-03,&
     & 2.948500e-03,3.030500e-03,3.150900e-03,3.327000e-03,3.547000e-03,&
     & 2.402800e-03,2.447600e-03,2.527200e-03,2.645600e-03,2.808900e-03,&
     & 1.989900e-03,2.004700e-03,2.058300e-03,2.140300e-03,2.264300e-03,&
     & 1.647800e-03,1.659300e-03,1.703600e-03,1.773700e-03,1.882300e-03,&
     & 1.359900e-03,1.369400e-03,1.406700e-03,1.467200e-03,1.561700e-03,&
     & 1.115700e-03,1.124100e-03,1.155500e-03,1.207300e-03,1.286400e-03/
      data   absa(:, 2) /                                               &
     & 3.890500e-02,4.242900e-02,4.651300e-02,5.058800e-02,5.502100e-02,&
     & 3.080300e-02,3.346100e-02,3.654600e-02,3.992200e-02,4.344000e-02,&
     & 2.414400e-02,2.601900e-02,2.828700e-02,3.095300e-02,3.373900e-02,&
     & 1.908200e-02,2.037100e-02,2.203400e-02,2.401400e-02,2.625000e-02,&
     & 1.520300e-02,1.609200e-02,1.727100e-02,1.872100e-02,2.047100e-02,&
     & 1.216400e-02,1.276900e-02,1.357800e-02,1.464300e-02,1.592800e-02,&
     & 9.781500e-03,1.018600e-02,1.074000e-02,1.148700e-02,1.243500e-02,&
     & 7.924500e-03,8.168700e-03,8.549700e-03,9.064400e-03,9.761800e-03,&
     & 6.472700e-03,6.583600e-03,6.839100e-03,7.194700e-03,7.682600e-03,&
     & 5.324000e-03,5.357500e-03,5.519300e-03,5.770600e-03,6.116600e-03,&
     & 4.378300e-03,4.406500e-03,4.539100e-03,4.745300e-03,5.031300e-03,&
     & 3.596800e-03,3.620300e-03,3.729800e-03,3.899800e-03,4.137800e-03,&
     & 2.950700e-03,2.970400e-03,3.061100e-03,3.201500e-03,3.401200e-03/
      data   absa(:, 3) /                                               &
     & 1.063600e-01,1.168000e-01,1.282400e-01,1.401700e-01,1.526600e-01,&
     & 8.444300e-02,9.248000e-02,1.014800e-01,1.109200e-01,1.210000e-01,&
     & 6.595900e-02,7.186900e-02,7.877000e-02,8.625000e-02,9.405800e-02,&
     & 5.168100e-02,5.602900e-02,6.120700e-02,6.708800e-02,7.319500e-02,&
     & 4.073400e-02,4.393800e-02,4.777700e-02,5.228800e-02,5.724300e-02,&
     & 3.224800e-02,3.453400e-02,3.734400e-02,4.073800e-02,4.467300e-02,&
     & 2.573100e-02,2.724400e-02,2.933300e-02,3.184900e-02,3.486100e-02,&
     & 2.069300e-02,2.165700e-02,2.315400e-02,2.501200e-02,2.726800e-02,&
     & 1.673000e-02,1.734600e-02,1.832700e-02,1.971600e-02,2.138100e-02,&
     & 1.358800e-02,1.401500e-02,1.465800e-02,1.568000e-02,1.693600e-02,&
     & 1.118000e-02,1.152800e-02,1.206300e-02,1.291700e-02,1.395900e-02,&
     & 9.192000e-03,9.476600e-03,9.924400e-03,1.063600e-02,1.150200e-02,&
     & 7.551700e-03,7.786100e-03,8.160200e-03,8.750400e-03,9.468200e-03/
      data   absa(:, 4) /                                               &
     & 2.655900e-01,2.777800e-01,2.898300e-01,3.011200e-01,3.115100e-01,&
     & 2.141500e-01,2.237600e-01,2.337200e-01,2.429100e-01,2.514800e-01,&
     & 1.711300e-01,1.786400e-01,1.867900e-01,1.941800e-01,2.015800e-01,&
     & 1.368900e-01,1.430500e-01,1.493300e-01,1.557700e-01,1.621200e-01,&
     & 1.095100e-01,1.148400e-01,1.199300e-01,1.252700e-01,1.304800e-01,&
     & 8.767800e-02,9.201300e-02,9.629200e-02,1.005200e-01,1.049200e-01,&
     & 7.027100e-02,7.364600e-02,7.725200e-02,8.067900e-02,8.429500e-02,&
     & 5.629200e-02,5.902700e-02,6.191500e-02,6.478400e-02,6.766200e-02,&
     & 4.504500e-02,4.730800e-02,4.959300e-02,5.199200e-02,5.435000e-02,&
     & 3.608300e-02,3.803700e-02,3.992800e-02,4.186800e-02,4.382700e-02,&
     & 2.968400e-02,3.130500e-02,3.286900e-02,3.445800e-02,3.606900e-02,&
     & 2.442800e-02,2.576000e-02,2.703900e-02,2.834500e-02,2.967100e-02,&
     & 2.009400e-02,2.117900e-02,2.222400e-02,2.330400e-02,2.439400e-02/
      data  absa(:, 5) /                                                &
     & 4.729000e-01,4.892800e-01,5.088700e-01,5.332800e-01,5.621600e-01,&
     & 3.847500e-01,3.976200e-01,4.128000e-01,4.321900e-01,4.547300e-01,&
     & 3.097900e-01,3.199600e-01,3.310500e-01,3.453000e-01,3.621600e-01,&
     & 2.500200e-01,2.580000e-01,2.667400e-01,2.770900e-01,2.894600e-01,&
     & 2.021800e-01,2.084700e-01,2.154600e-01,2.231100e-01,2.323900e-01,&
     & 1.628600e-01,1.684000e-01,1.739700e-01,1.799600e-01,1.868300e-01,&
     & 1.305500e-01,1.360200e-01,1.405000e-01,1.452400e-01,1.504700e-01,&
     & 1.044200e-01,1.095400e-01,1.135300e-01,1.173700e-01,1.214300e-01,&
     & 8.338800e-02,8.784100e-02,9.168200e-02,9.481600e-02,9.805000e-02,&
     & 6.701000e-02,7.059800e-02,7.401500e-02,7.676900e-02,7.937200e-02,&
     & 5.511800e-02,5.805100e-02,6.086900e-02,6.311400e-02,6.529400e-02,&
     & 4.530000e-02,4.772100e-02,5.004900e-02,5.189000e-02,5.368200e-02,&
     & 3.722500e-02,3.923600e-02,4.113300e-02,4.263100e-02,4.412600e-02/
      data  absa(:, 6) /                                                &
     & 8.422400e-01,9.226400e-01,1.007300e+00,1.093000e+00,1.179300e+00,&
     & 6.759500e-01,7.423200e-01,8.124800e-01,8.830200e-01,9.561600e-01,&
     & 5.290400e-01,5.804800e-01,6.375100e-01,6.964200e-01,7.572100e-01,&
     & 4.131500e-01,4.540700e-01,4.997100e-01,5.488600e-01,5.996400e-01,&
     & 3.246700e-01,3.553100e-01,3.915900e-01,4.316100e-01,4.742300e-01,&
     & 2.557400e-01,2.778400e-01,3.057900e-01,3.381700e-01,3.727800e-01,&
     & 2.031300e-01,2.179200e-01,2.387600e-01,2.638600e-01,2.920500e-01,&
     & 1.628500e-01,1.720100e-01,1.867500e-01,2.059800e-01,2.284300e-01,&
     & 1.317800e-01,1.368700e-01,1.467000e-01,1.608700e-01,1.782700e-01,&
     & 1.076000e-01,1.102200e-01,1.166100e-01,1.269000e-01,1.403300e-01,&
     & 8.847100e-02,9.074200e-02,9.608800e-02,1.047700e-01,1.160100e-01,&
     & 7.272400e-02,7.464500e-02,7.916500e-02,8.646400e-02,9.584400e-02,&
     & 5.971900e-02,6.135000e-02,6.517700e-02,7.130100e-02,7.908800e-02/
      data  absa(:, 7) /                                                &
     & 1.841600e+00,2.037700e+00,2.235100e+00,2.435100e+00,2.635700e+00,&
     & 1.505700e+00,1.669100e+00,1.834200e+00,2.003100e+00,2.170500e+00,&
     & 1.198000e+00,1.332900e+00,1.470400e+00,1.609900e+00,1.748800e+00,&
     & 9.440800e-01,1.056600e+00,1.170800e+00,1.287400e+00,1.401400e+00,&
     & 7.405200e-01,8.333200e-01,9.300700e-01,1.026300e+00,1.122100e+00,&
     & 5.750200e-01,6.514500e-01,7.310200e-01,8.122800e-01,8.928300e-01,&
     & 4.441300e-01,5.056500e-01,5.711300e-01,6.383200e-01,7.063600e-01,&
     & 3.421500e-01,3.912500e-01,4.441400e-01,4.996300e-01,5.560000e-01,&
     & 2.627800e-01,3.015500e-01,3.440900e-01,3.894000e-01,4.363400e-01,&
     & 2.039900e-01,2.345000e-01,2.686300e-01,3.055900e-01,3.441000e-01,&
     & 1.689900e-01,1.945200e-01,2.230600e-01,2.536700e-01,2.860000e-01,&
     & 1.400000e-01,1.613200e-01,1.850400e-01,2.104900e-01,2.373600e-01,&
     & 1.158700e-01,1.336400e-01,1.533200e-01,1.744800e-01,1.969500e-01/
      data  absa(:, 8) /                                                &
     & 4.775100e+00,5.279100e+00,5.793300e+00,6.308300e+00,6.832600e+00,&
     & 4.004800e+00,4.444300e+00,4.894000e+00,5.358000e+00,5.826700e+00,&
     & 3.240000e+00,3.625300e+00,4.020700e+00,4.423000e+00,4.821000e+00,&
     & 2.588300e+00,2.921000e+00,3.265600e+00,3.615400e+00,3.964100e+00,&
     & 2.055000e+00,2.339000e+00,2.635100e+00,2.933600e+00,3.237000e+00,&
     & 1.613000e+00,1.853800e+00,2.102700e+00,2.358200e+00,2.618400e+00,&
     & 1.254800e+00,1.456700e+00,1.666400e+00,1.882000e+00,2.103600e+00,&
     & 9.668700e-01,1.134800e+00,1.311000e+00,1.493000e+00,1.680500e+00,&
     & 7.384700e-01,8.759300e-01,1.022100e+00,1.174100e+00,1.331900e+00,&
     & 5.677600e-01,6.801700e-01,8.005900e-01,9.275000e-01,1.059300e+00,&
     & 4.751100e-01,5.697200e-01,6.711800e-01,7.784000e-01,8.894900e-01,&
     & 3.965800e-01,4.759300e-01,5.612800e-01,6.512400e-01,7.441700e-01,&
     & 3.300500e-01,3.965000e-01,4.680700e-01,5.435700e-01,6.215500e-01/
      data  absa(:, 9) /                                                &
     & 1.783100e+01,1.982300e+01,2.188400e+01,2.393700e+01,2.590400e+01,&
     & 1.598300e+01,1.790800e+01,1.984400e+01,2.175000e+01,2.363900e+01,&
     & 1.383800e+01,1.565200e+01,1.742800e+01,1.919500e+01,2.094600e+01,&
     & 1.170700e+01,1.337200e+01,1.501800e+01,1.667500e+01,1.833000e+01,&
     & 9.761900e+00,1.124400e+01,1.275200e+01,1.427900e+01,1.583700e+01,&
     & 7.981700e+00,9.298800e+00,1.065000e+01,1.202900e+01,1.344900e+01,&
     & 6.447800e+00,7.586400e+00,8.771700e+00,1.000800e+01,1.128900e+01,&
     & 5.155000e+00,6.138100e+00,7.166700e+00,8.256700e+00,9.375900e+00,&
     & 4.046200e+00,4.892400e+00,5.794400e+00,6.746600e+00,7.710000e+00,&
     & 3.192000e+00,3.913300e+00,4.691200e+00,5.509100e+00,6.343200e+00,&
     & 2.771700e+00,3.403900e+00,4.080000e+00,4.781800e+00,5.508100e+00,&
     & 2.397800e+00,2.943600e+00,3.523500e+00,4.129300e+00,4.760000e+00,&
     & 2.057500e+00,2.526300e+00,3.024400e+00,3.547700e+00,4.089600e+00/
      data  absa(:, 10) /                                               &
     & 4.974800e+01,5.511200e+01,5.993800e+01,6.502300e+01,7.045800e+01,&
     & 4.658800e+01,5.166100e+01,5.690100e+01,6.246300e+01,6.848700e+01,&
     & 4.162800e+01,4.669900e+01,5.231400e+01,5.835300e+01,6.445800e+01,&
     & 3.745600e+01,4.246900e+01,4.786700e+01,5.338400e+01,5.911100e+01,&
     & 3.343600e+01,3.879300e+01,4.399200e+01,4.907700e+01,5.404600e+01,&
     & 2.894800e+01,3.406600e+01,3.909300e+01,4.394300e+01,4.857700e+01,&
     & 2.441100e+01,2.916900e+01,3.377200e+01,3.832800e+01,4.267400e+01,&
     & 2.021300e+01,2.437900e+01,2.854700e+01,3.263200e+01,3.671700e+01,&
     & 1.677000e+01,2.027500e+01,2.372600e+01,2.728900e+01,3.114900e+01,&
     & 1.374000e+01,1.681400e+01,1.987400e+01,2.303900e+01,2.652900e+01,&
     & 1.216100e+01,1.482000e+01,1.766700e+01,2.076700e+01,2.394800e+01,&
     & 1.066600e+01,1.309300e+01,1.572700e+01,1.847300e+01,2.119500e+01,&
     & 9.391500e+00,1.155700e+01,1.384700e+01,1.617200e+01,1.855800e+01/
      data  absa(:, 11) /                                               &
     & 7.284200e+01,8.212700e+01,9.175100e+01,1.008100e+02,1.086800e+02,&
     & 7.091200e+01,8.021100e+01,8.913300e+01,9.776700e+01,1.053700e+02,&
     & 6.716900e+01,7.589500e+01,8.395700e+01,9.146700e+01,9.874000e+01,&
     & 6.104600e+01,6.908600e+01,7.707100e+01,8.462500e+01,9.232500e+01,&
     & 5.429100e+01,6.162400e+01,6.914600e+01,7.691600e+01,8.505000e+01,&
     & 4.794000e+01,5.475400e+01,6.194300e+01,6.973900e+01,7.776500e+01,&
     & 4.142400e+01,4.832300e+01,5.588400e+01,6.343400e+01,7.106400e+01,&
     & 3.480800e+01,4.171800e+01,4.924000e+01,5.672800e+01,6.403200e+01,&
     & 2.872400e+01,3.533300e+01,4.239500e+01,4.937200e+01,5.618600e+01,&
     & 2.406000e+01,2.988600e+01,3.617100e+01,4.251100e+01,4.885500e+01,&
     & 2.246600e+01,2.784200e+01,3.327600e+01,3.870700e+01,4.441100e+01,&
     & 2.063500e+01,2.540200e+01,3.013000e+01,3.506500e+01,4.045600e+01,&
     & 1.837500e+01,2.252800e+01,2.694400e+01,3.172100e+01,3.664200e+01/
      data  absa(:, 12) /                                               &
     & 1.281400e+02,1.393800e+02,1.499400e+02,1.615000e+02,1.727300e+02,&
     & 1.202800e+02,1.317100e+02,1.438100e+02,1.562800e+02,1.693600e+02,&
     & 1.090800e+02,1.222100e+02,1.366200e+02,1.510800e+02,1.659100e+02,&
     & 9.968900e+01,1.139300e+02,1.289900e+02,1.444600e+02,1.593200e+02,&
     & 9.157400e+01,1.064700e+02,1.217900e+02,1.368100e+02,1.509000e+02,&
     & 8.315900e+01,9.837200e+01,1.137000e+02,1.278700e+02,1.418400e+02,&
     & 7.513000e+01,8.927900e+01,1.033500e+02,1.169600e+02,1.308800e+02,&
     & 6.694200e+01,7.971900e+01,9.254700e+01,1.053000e+02,1.188700e+02,&
     & 5.772200e+01,6.983700e+01,8.208200e+01,9.459300e+01,1.077000e+02,&
     & 4.904000e+01,6.062000e+01,7.257700e+01,8.518700e+01,9.784400e+01,&
     & 4.543300e+01,5.635200e+01,6.822300e+01,8.049900e+01,9.251200e+01,&
     & 4.197100e+01,5.246700e+01,6.353300e+01,7.454300e+01,8.508400e+01,&
     & 3.901300e+01,4.856800e+01,5.827200e+01,6.774100e+01,7.719400e+01/
      data  absa(:, 13) /                                               &
     & 3.000418e+02,3.295884e+02,3.559647e+02,3.815349e+02,4.050856e+02,&
     & 3.019791e+02,3.360053e+02,3.647513e+02,3.919344e+02,4.139147e+02,&
     & 2.952656e+02,3.290951e+02,3.602482e+02,3.879871e+02,4.183900e+02,&
     & 2.800250e+02,3.161535e+02,3.488284e+02,3.786839e+02,4.121769e+02,&
     & 2.613678e+02,2.973359e+02,3.330985e+02,3.680068e+02,4.009861e+02,&
     & 2.395188e+02,2.761093e+02,3.137507e+02,3.510789e+02,3.880699e+02,&
     & 2.170940e+02,2.549912e+02,2.938101e+02,3.321606e+02,3.713830e+02,&
     & 1.954783e+02,2.347621e+02,2.753640e+02,3.151168e+02,3.562516e+02,&
     & 1.758713e+02,2.149611e+02,2.562928e+02,2.974233e+02,3.385016e+02,&
     & 1.601232e+02,1.987001e+02,2.384238e+02,2.798183e+02,3.207363e+02,&
     & 1.612582e+02,1.997352e+02,2.390504e+02,2.799799e+02,3.208008e+02,&
     & 1.608018e+02,1.982578e+02,2.377596e+02,2.780894e+02,3.192241e+02,&
     & 1.588756e+02,1.956866e+02,2.345322e+02,2.743441e+02,3.149050e+02/
      data  absa(:, 14) /                                               &
     & 8.980436e+02,9.642712e+02,1.013968e+03,1.073470e+03,1.124377e+03,&
     & 1.007697e+03,1.091230e+03,1.153224e+03,1.225741e+03,1.266873e+03,&
     & 1.096855e+03,1.165183e+03,1.247149e+03,1.316440e+03,1.394898e+03,&
     & 1.133012e+03,1.235148e+03,1.361004e+03,1.423211e+03,1.545942e+03,&
     & 1.175383e+03,1.297036e+03,1.447036e+03,1.552931e+03,1.641856e+03,&
     & 1.213479e+03,1.338415e+03,1.489119e+03,1.637367e+03,1.739211e+03,&
     & 1.216874e+03,1.365263e+03,1.531539e+03,1.687845e+03,1.812837e+03,&
     & 1.175938e+03,1.366162e+03,1.567938e+03,1.730082e+03,1.885912e+03,&
     & 1.137682e+03,1.344249e+03,1.568606e+03,1.760931e+03,1.951304e+03,&
     & 1.107107e+03,1.325739e+03,1.557866e+03,1.791714e+03,2.015841e+03,&
     & 1.180441e+03,1.426279e+03,1.670059e+03,1.943857e+03,2.175329e+03,&
     & 1.252501e+03,1.544450e+03,1.804912e+03,2.095031e+03,2.347725e+03,&
     & 1.343284e+03,1.634048e+03,1.934659e+03,2.239545e+03,2.526366e+03/
 
!     the array absb(235,NG02) = kb(5,13:59,NG02) contains absorption coefs
!     at the NG02=14 chosen g-values for a range of pressure levels< ~100mb
!     and temperatures. the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 13 to 59 and refers to the jpth reference
!     pressure level (see taumol.f for the value of these pressure levels
!     in mb).  the third index, ig, goes from 1 to NG02=14, and tells us
!     which g-interval the absorption coefficients are for.
 
      data  absb(:,1) /                                                 &
     & 1.116500e-03,1.124700e-03,1.156000e-03,1.207600e-03,1.286900e-03,&
     & 9.149900e-04,9.241700e-04,9.521400e-04,9.979300e-04,1.064700e-03,&
     & 7.489500e-04,7.588500e-04,7.839800e-04,8.236400e-04,8.793400e-04,&
     & 6.128500e-04,6.230100e-04,6.452800e-04,6.791900e-04,7.256100e-04,&
     & 5.016100e-04,5.116200e-04,5.308800e-04,5.595600e-04,5.982700e-04,&
     & 4.105900e-04,4.200700e-04,4.363500e-04,4.606900e-04,4.928500e-04,&
     & 3.364100e-04,3.450000e-04,3.587900e-04,3.792900e-04,4.061600e-04,&
     & 2.760300e-04,2.836300e-04,2.953700e-04,3.127600e-04,3.353100e-04,&
     & 2.265900e-04,2.331700e-04,2.432400e-04,2.579600e-04,2.769500e-04,&
     & 1.863100e-04,1.921700e-04,2.010300e-04,2.137400e-04,2.299400e-04,&
     & 1.532700e-04,1.584600e-04,1.663100e-04,1.772300e-04,1.909600e-04,&
     & 1.262000e-04,1.308000e-04,1.377800e-04,1.471400e-04,1.586700e-04,&
     & 1.040000e-04,1.081000e-04,1.142600e-04,1.223100e-04,1.319200e-04,&
     & 8.581200e-05,8.950700e-05,9.492700e-05,1.019000e-04,1.098200e-04,&
     & 7.085900e-05,7.420500e-05,7.893900e-05,8.495700e-05,9.144900e-05,&
     & 5.856900e-05,6.159400e-05,6.570000e-05,7.082000e-05,7.619100e-05,&
     & 4.846500e-05,5.117700e-05,5.474500e-05,5.904000e-05,6.353200e-05,&
     & 4.014700e-05,4.255300e-05,4.565300e-05,4.920700e-05,5.298100e-05,&
     & 3.330000e-05,3.541400e-05,3.810200e-05,4.101400e-05,4.419500e-05,&
     & 2.766200e-05,2.950400e-05,3.179800e-05,3.420800e-05,3.689200e-05,&
     & 2.300000e-05,2.460500e-05,2.653100e-05,2.854900e-05,3.081400e-05,&
     & 1.910100e-05,2.048800e-05,2.208100e-05,2.377300e-05,2.568300e-05,&
     & 1.577200e-05,1.694500e-05,1.824800e-05,1.965400e-05,2.124800e-05,&
     & 1.293200e-05,1.389700e-05,1.496400e-05,1.611800e-05,1.742700e-05,&
     & 1.050000e-05,1.126600e-05,1.214000e-05,1.307000e-05,1.412200e-05,&
     & 8.523200e-06,9.129300e-06,9.842400e-06,1.059300e-05,1.143800e-05,&
     & 6.919900e-06,7.400100e-06,7.979300e-06,8.585100e-06,9.265100e-06,&
     & 5.586900e-06,5.957900e-06,6.420800e-06,6.906700e-06,7.449000e-06,&
     & 4.510200e-06,4.795900e-06,5.159800e-06,5.553500e-06,5.984500e-06,&
     & 3.645500e-06,3.863400e-06,4.144500e-06,4.466600e-06,4.809300e-06,&
     & 2.943400e-06,3.104500e-06,3.318100e-06,3.577900e-06,3.850000e-06,&
     & 2.378400e-06,2.494000e-06,2.655400e-06,2.859600e-06,3.077300e-06,&
     & 1.925400e-06,2.007300e-06,2.128000e-06,2.284000e-06,2.461500e-06,&
     & 1.559900e-06,1.617600e-06,1.705500e-06,1.822600e-06,1.965600e-06,&
     & 1.264700e-06,1.304500e-06,1.365700e-06,1.452700e-06,1.563600e-06,&
     & 1.028000e-06,1.054600e-06,1.096700e-06,1.160200e-06,1.243000e-06,&
     & 8.389900e-07,8.543500e-07,8.834800e-07,9.284100e-07,9.898999e-07,&
     & 6.875800e-07,6.941700e-07,7.142400e-07,7.455100e-07,7.912500e-07,&
     & 5.652500e-07,5.656400e-07,5.787900e-07,6.006700e-07,6.340600e-07,&
     & 4.661400e-07,4.626200e-07,4.699100e-07,4.852100e-07,5.089500e-07,&
     & 3.858300e-07,3.797100e-07,3.823700e-07,3.928500e-07,4.094000e-07,&
     & 3.199800e-07,3.124900e-07,3.121400e-07,3.189600e-07,3.306900e-07,&
     & 2.658500e-07,2.578400e-07,2.556800e-07,2.595300e-07,2.678500e-07,&
     & 2.213700e-07,2.134100e-07,2.100500e-07,2.115900e-07,2.173900e-07,&
     & 1.847700e-07,1.771200e-07,1.730400e-07,1.729200e-07,1.767600e-07,&
     & 1.544800e-07,1.472800e-07,1.429100e-07,1.418100e-07,1.440600e-07,&
     & 1.279500e-07,1.216900e-07,1.177700e-07,1.165100e-07,1.180200e-07/
      data  absb(:,2) /                                                 &
     & 2.951600e-03,2.971300e-03,3.061600e-03,3.201900e-03,3.401700e-03,&
     & 2.419700e-03,2.441400e-03,2.520700e-03,2.640700e-03,2.816700e-03,&
     & 1.983100e-03,2.006300e-03,2.075500e-03,2.180000e-03,2.334200e-03,&
     & 1.625200e-03,1.649200e-03,1.709700e-03,1.801400e-03,1.934100e-03,&
     & 1.332100e-03,1.355600e-03,1.408600e-03,1.488200e-03,1.601700e-03,&
     & 1.092000e-03,1.114800e-03,1.161000e-03,1.229200e-03,1.324800e-03,&
     & 8.953400e-04,9.169000e-04,9.570900e-04,1.014800e-03,1.095100e-03,&
     & 7.344500e-04,7.550300e-04,7.895800e-04,8.386300e-04,9.060000e-04,&
     & 6.029000e-04,6.218000e-04,6.514800e-04,6.930800e-04,7.496600e-04,&
     & 4.959500e-04,5.135300e-04,5.393700e-04,5.756100e-04,6.234800e-04,&
     & 4.085500e-04,4.243400e-04,4.467700e-04,4.784600e-04,5.189700e-04,&
     & 3.370400e-04,3.508700e-04,3.704100e-04,3.982500e-04,4.325400e-04,&
     & 2.782300e-04,2.903400e-04,3.075600e-04,3.317600e-04,3.610800e-04,&
     & 2.298800e-04,2.406500e-04,2.559900e-04,2.768900e-04,3.021800e-04,&
     & 1.900800e-04,1.996600e-04,2.133500e-04,2.311800e-04,2.528700e-04,&
     & 1.572900e-04,1.658200e-04,1.780400e-04,1.932100e-04,2.115800e-04,&
     & 1.303000e-04,1.379400e-04,1.487000e-04,1.617200e-04,1.771200e-04,&
     & 1.080700e-04,1.149100e-04,1.242300e-04,1.355200e-04,1.483000e-04,&
     & 8.973700e-05,9.587300e-05,1.038500e-04,1.135700e-04,1.242200e-04,&
     & 7.460700e-05,8.011400e-05,8.692500e-05,9.516000e-05,1.040900e-04,&
     & 6.211500e-05,6.697600e-05,7.284200e-05,7.974900e-05,8.726100e-05,&
     & 5.166700e-05,5.585400e-05,6.091100e-05,6.664100e-05,7.294500e-05,&
     & 4.271400e-05,4.622400e-05,5.047600e-05,5.520700e-05,6.044600e-05,&
     & 3.503300e-05,3.791600e-05,4.141300e-05,4.529000e-05,4.959000e-05,&
     & 2.841700e-05,3.072400e-05,3.351100e-05,3.665600e-05,4.012300e-05,&
     & 2.304400e-05,2.487900e-05,2.709100e-05,2.964600e-05,3.244000e-05,&
     & 1.869600e-05,2.015000e-05,2.190500e-05,2.397700e-05,2.623100e-05,&
     & 1.507900e-05,1.619000e-05,1.756100e-05,1.921900e-05,2.101900e-05,&
     & 1.216600e-05,1.299800e-05,1.407600e-05,1.538700e-05,1.682600e-05,&
     & 9.824500e-06,1.044700e-05,1.129200e-05,1.231400e-05,1.347000e-05,&
     & 7.920700e-06,8.376600e-06,9.021200e-06,9.801500e-06,1.073000e-05,&
     & 6.389100e-06,6.720400e-06,7.195000e-06,7.796800e-06,8.529500e-06,&
     & 5.161400e-06,5.401800e-06,5.746300e-06,6.212600e-06,6.777900e-06,&
     & 4.173500e-06,4.345100e-06,4.593100e-06,4.945000e-06,5.372400e-06,&
     & 3.375000e-06,3.495900e-06,3.672200e-06,3.924700e-06,4.251300e-06,&
     & 2.741800e-06,2.819200e-06,2.943400e-06,3.122500e-06,3.371100e-06,&
     & 2.237100e-06,2.277500e-06,2.365600e-06,2.492500e-06,2.675000e-06,&
     & 1.831700e-06,1.846500e-06,1.907300e-06,1.998400e-06,2.129000e-06,&
     & 1.503600e-06,1.503900e-06,1.541600e-06,1.606500e-06,1.700200e-06,&
     & 1.236500e-06,1.228900e-06,1.247600e-06,1.294400e-06,1.361700e-06,&
     & 1.018000e-06,1.007000e-06,1.013000e-06,1.044700e-06,1.093100e-06,&
     & 8.388100e-07,8.269400e-07,8.260700e-07,8.457400e-07,8.805900e-07,&
     & 6.919500e-07,6.798700e-07,6.754800e-07,6.856200e-07,7.111400e-07,&
     & 5.717300e-07,5.594800e-07,5.535600e-07,5.573300e-07,5.750800e-07,&
     & 4.731600e-07,4.609600e-07,4.545200e-07,4.544800e-07,4.658100e-07,&
     & 3.918900e-07,3.801300e-07,3.736600e-07,3.716000e-07,3.778500e-07,&
     & 3.226200e-07,3.124100e-07,3.066300e-07,3.043800e-07,3.085000e-07/
      data  absb(:,3) /                                                 &
     & 7.552700e-03,7.787500e-03,8.161300e-03,8.750000e-03,9.469300e-03,&
     & 6.216200e-03,6.417900e-03,6.744300e-03,7.243600e-03,7.848800e-03,&
     & 5.115400e-03,5.289900e-03,5.575800e-03,5.997700e-03,6.509700e-03,&
     & 4.209100e-03,4.359800e-03,4.610800e-03,4.966200e-03,5.404100e-03,&
     & 3.462400e-03,3.593100e-03,3.812500e-03,4.111800e-03,4.486700e-03,&
     & 2.847800e-03,2.961100e-03,3.151300e-03,3.405600e-03,3.722700e-03,&
     & 2.342400e-03,2.440300e-03,2.605000e-03,2.820500e-03,3.087500e-03,&
     & 1.927900e-03,2.013600e-03,2.156800e-03,2.339400e-03,2.563300e-03,&
     & 1.586800e-03,1.662500e-03,1.786600e-03,1.940300e-03,2.127900e-03,&
     & 1.309500e-03,1.379800e-03,1.487300e-03,1.618500e-03,1.776200e-03,&
     & 1.082000e-03,1.147000e-03,1.238800e-03,1.350600e-03,1.482800e-03,&
     & 8.953300e-04,9.548000e-04,1.032500e-03,1.127300e-03,1.239100e-03,&
     & 7.422900e-04,7.953400e-04,8.615100e-04,9.418600e-04,1.036100e-03,&
     & 6.170500e-04,6.634900e-04,7.201800e-04,7.887000e-04,8.674100e-04,&
     & 5.137300e-04,5.537700e-04,6.025900e-04,6.608500e-04,7.264000e-04,&
     & 4.282600e-04,4.624500e-04,5.043400e-04,5.540500e-04,6.085000e-04,&
     & 3.573000e-04,3.866700e-04,4.225500e-04,4.647500e-04,5.100800e-04,&
     & 2.982300e-04,3.235600e-04,3.542700e-04,3.896300e-04,4.276200e-04,&
     & 2.491500e-04,2.711100e-04,2.973000e-04,3.267600e-04,3.585300e-04,&
     & 2.083500e-04,2.272600e-04,2.496900e-04,2.741500e-04,3.005200e-04,&
     & 1.744000e-04,1.906300e-04,2.096600e-04,2.300400e-04,2.518000e-04,&
     & 1.456600e-04,1.594900e-04,1.753700e-04,1.924200e-04,2.102800e-04,&
     & 1.206900e-04,1.322700e-04,1.453800e-04,1.594900e-04,1.741200e-04,&
     & 9.904300e-05,1.085600e-04,1.193100e-04,1.308800e-04,1.428500e-04,&
     & 8.019200e-05,8.782800e-05,9.655200e-05,1.059200e-04,1.157100e-04,&
     & 6.489500e-05,7.100600e-05,7.807800e-05,8.564100e-05,9.364900e-05,&
     & 5.252900e-05,5.741700e-05,6.313700e-05,6.924800e-05,7.578600e-05,&
     & 4.217200e-05,4.601100e-05,5.055000e-05,5.546900e-05,6.078200e-05,&
     & 3.384500e-05,3.684300e-05,4.040500e-05,4.437800e-05,4.866900e-05,&
     & 2.717800e-05,2.949900e-05,3.230500e-05,3.550700e-05,3.894800e-05,&
     & 2.174800e-05,2.352600e-05,2.570700e-05,2.826200e-05,3.099900e-05,&
     & 1.738600e-05,1.874500e-05,2.043000e-05,2.242000e-05,2.461500e-05,&
     & 1.391900e-05,1.495500e-05,1.623900e-05,1.778600e-05,1.954800e-05,&
     & 1.116400e-05,1.192500e-05,1.289800e-05,1.409200e-05,1.549300e-05,&
     & 8.972400e-06,9.490600e-06,1.022500e-05,1.113600e-05,1.221400e-05,&
     & 7.229400e-06,7.573700e-06,8.119900e-06,8.803300e-06,9.633500e-06,&
     & 5.838100e-06,6.072600e-06,6.458200e-06,6.971800e-06,7.607600e-06,&
     & 4.729600e-06,4.893000e-06,5.153200e-06,5.542800e-06,6.026100e-06,&
     & 3.839900e-06,3.951400e-06,4.128400e-06,4.416800e-06,4.782200e-06,&
     & 3.124500e-06,3.197300e-06,3.321100e-06,3.523900e-06,3.801200e-06,&
     & 2.547100e-06,2.592500e-06,2.678500e-06,2.815800e-06,3.025800e-06,&
     & 2.081400e-06,2.107300e-06,2.166400e-06,2.261700e-06,2.417300e-06,&
     & 1.702800e-06,1.716500e-06,1.755800e-06,1.823900e-06,1.935000e-06,&
     & 1.393600e-06,1.400100e-06,1.425500e-06,1.473700e-06,1.550800e-06,&
     & 1.140900e-06,1.144200e-06,1.158900e-06,1.192400e-06,1.246100e-06,&
     & 9.353200e-07,9.361700e-07,9.441500e-07,9.667700e-07,1.005300e-06,&
     & 7.671600e-07,7.665500e-07,7.719300e-07,7.890000e-07,8.189900e-07/
      data  absb(:,4) /                                                 &
     & 2.009500e-02,2.118200e-02,2.222500e-02,2.330400e-02,2.439400e-02,&
     & 1.660100e-02,1.748000e-02,1.833800e-02,1.923100e-02,2.012800e-02,&
     & 1.371100e-02,1.442500e-02,1.513400e-02,1.586800e-02,1.661100e-02,&
     & 1.131900e-02,1.190300e-02,1.249000e-02,1.309400e-02,1.370000e-02,&
     & 9.337700e-03,9.816600e-03,1.030100e-02,1.079700e-02,1.129600e-02,&
     & 7.699400e-03,8.093100e-03,8.495100e-03,8.898600e-03,9.314000e-03,&
     & 6.345400e-03,6.669000e-03,7.001900e-03,7.331300e-03,7.682900e-03,&
     & 5.232800e-03,5.500100e-03,5.772400e-03,6.046900e-03,6.341300e-03,&
     & 4.315000e-03,4.534400e-03,4.759300e-03,4.988100e-03,5.233600e-03,&
     & 3.570300e-03,3.749900e-03,3.936600e-03,4.126800e-03,4.331800e-03,&
     & 2.954700e-03,3.102400e-03,3.257600e-03,3.414000e-03,3.584900e-03,&
     & 2.445200e-03,2.569700e-03,2.696100e-03,2.825900e-03,2.964200e-03,&
     & 2.024500e-03,2.128800e-03,2.232000e-03,2.339700e-03,2.451100e-03,&
     & 1.678500e-03,1.764300e-03,1.848800e-03,1.938700e-03,2.028300e-03,&
     & 1.392000e-03,1.461900e-03,1.531300e-03,1.606700e-03,1.678900e-03,&
     & 1.154800e-03,1.211200e-03,1.268600e-03,1.330500e-03,1.389900e-03,&
     & 9.577900e-04,1.003600e-03,1.051500e-03,1.101600e-03,1.150100e-03,&
     & 7.939800e-04,8.315900e-04,8.717600e-04,9.122200e-04,9.511900e-04,&
     & 6.581300e-04,6.891300e-04,7.230500e-04,7.555900e-04,7.868000e-04,&
     & 5.455700e-04,5.713300e-04,5.992000e-04,6.259100e-04,6.509400e-04,&
     & 4.522500e-04,4.738400e-04,4.963500e-04,5.181000e-04,5.385000e-04,&
     & 3.742900e-04,3.924000e-04,4.105700e-04,4.281100e-04,4.448300e-04,&
     & 3.084100e-04,3.235000e-04,3.382100e-04,3.524000e-04,3.660800e-04,&
     & 2.528500e-04,2.652500e-04,2.772900e-04,2.888500e-04,3.000600e-04,&
     & 2.058600e-04,2.158500e-04,2.258200e-04,2.354000e-04,2.445700e-04,&
     & 1.675300e-04,1.755900e-04,1.838400e-04,1.917700e-04,1.992700e-04,&
     & 1.363500e-04,1.428600e-04,1.496800e-04,1.562200e-04,1.623500e-04,&
     & 1.104500e-04,1.156700e-04,1.213200e-04,1.267200e-04,1.317600e-04,&
     & 8.941000e-05,9.361000e-05,9.824100e-05,1.026600e-04,1.068600e-04,&
     & 7.237800e-05,7.578100e-05,7.946500e-05,8.314500e-05,8.667200e-05,&
     & 5.842400e-05,6.118800e-05,6.410700e-05,6.718800e-05,7.014000e-05,&
     & 4.705800e-05,4.934600e-05,5.167100e-05,5.423000e-05,5.665700e-05,&
     & 3.789900e-05,3.979800e-05,4.166900e-05,4.370600e-05,4.572400e-05,&
     & 3.049700e-05,3.205500e-05,3.357200e-05,3.517600e-05,3.687300e-05,&
     & 2.447900e-05,2.573200e-05,2.699500e-05,2.826700e-05,2.967100e-05,&
     & 1.963500e-05,2.065900e-05,2.170600e-05,2.272900e-05,2.383000e-05,&
     & 1.575000e-05,1.658800e-05,1.743800e-05,1.827600e-05,1.914400e-05,&
     & 1.263800e-05,1.332700e-05,1.401400e-05,1.471300e-05,1.540800e-05,&
     & 1.013400e-05,1.071000e-05,1.127300e-05,1.184900e-05,1.241000e-05,&
     & 8.135000e-06,8.607000e-06,9.066600e-06,9.531400e-06,9.996100e-06,&
     & 6.526800e-06,6.907700e-06,7.287400e-06,7.664700e-06,8.051400e-06,&
     & 5.240000e-06,5.550400e-06,5.866200e-06,6.175400e-06,6.492200e-06,&
     & 4.224400e-06,4.466500e-06,4.725000e-06,4.977500e-06,5.233100e-06,&
     & 3.416300e-06,3.593000e-06,3.802300e-06,4.010400e-06,4.217500e-06,&
     & 2.769300e-06,2.886700e-06,3.057500e-06,3.230700e-06,3.400300e-06,&
     & 2.250000e-06,2.327900e-06,2.462700e-06,2.604800e-06,2.743300e-06,&
     & 1.838600e-06,1.896600e-06,2.004000e-06,2.119900e-06,2.233200e-06/
      data  absb(:,5) /                                                 &
     & 3.722700e-02,3.923600e-02,4.113600e-02,4.263500e-02,4.412500e-02,&
     & 3.073100e-02,3.238600e-02,3.390800e-02,3.512600e-02,3.638300e-02,&
     & 2.537800e-02,2.672700e-02,2.794100e-02,2.894700e-02,3.000200e-02,&
     & 2.095900e-02,2.204600e-02,2.301400e-02,2.385100e-02,2.473400e-02,&
     & 1.729400e-02,1.817600e-02,1.895200e-02,1.964300e-02,2.038000e-02,&
     & 1.426100e-02,1.498300e-02,1.559700e-02,1.617400e-02,1.678400e-02,&
     & 1.175400e-02,1.234200e-02,1.283700e-02,1.331200e-02,1.382000e-02,&
     & 9.694000e-03,1.017200e-02,1.056900e-02,1.096200e-02,1.138900e-02,&
     & 7.993500e-03,8.380400e-03,8.701900e-03,9.025600e-03,9.391700e-03,&
     & 6.609800e-03,6.921300e-03,7.180200e-03,7.455200e-03,7.762600e-03,&
     & 5.467500e-03,5.712200e-03,5.927600e-03,6.159000e-03,6.417700e-03,&
     & 4.524800e-03,4.714500e-03,4.895600e-03,5.090500e-03,5.310300e-03,&
     & 3.743600e-03,3.893800e-03,4.045100e-03,4.208300e-03,4.397700e-03,&
     & 3.098000e-03,3.219300e-03,3.344600e-03,3.482000e-03,3.646100e-03,&
     & 2.562900e-03,2.662100e-03,2.766000e-03,2.881000e-03,3.024200e-03,&
     & 2.118500e-03,2.201200e-03,2.288100e-03,2.385400e-03,2.510000e-03,&
     & 1.752000e-03,1.820100e-03,1.893300e-03,1.977400e-03,2.086100e-03,&
     & 1.449000e-03,1.505300e-03,1.566800e-03,1.640500e-03,1.735300e-03,&
     & 1.198700e-03,1.245400e-03,1.297000e-03,1.362000e-03,1.444600e-03,&
     & 9.916200e-04,1.030700e-03,1.074900e-03,1.131700e-03,1.203600e-03,&
     & 8.202400e-04,8.533600e-04,8.917600e-04,9.413700e-04,1.003400e-03,&
     & 6.777300e-04,7.055400e-04,7.389800e-04,7.820100e-04,8.349000e-04,&
     & 5.579700e-04,5.810300e-04,6.095000e-04,6.459500e-04,6.902400e-04,&
     & 4.574100e-04,4.763600e-04,4.998700e-04,5.299400e-04,5.663400e-04,&
     & 3.727500e-04,3.881200e-04,4.067100e-04,4.306300e-04,4.598300e-04,&
     & 3.036800e-04,3.161200e-04,3.307900e-04,3.497700e-04,3.731600e-04,&
     & 2.474300e-04,2.574600e-04,2.690900e-04,2.841400e-04,3.028700e-04,&
     & 2.008300e-04,2.088100e-04,2.178600e-04,2.295000e-04,2.442200e-04,&
     & 1.629000e-04,1.693000e-04,1.764000e-04,1.853900e-04,1.968100e-04,&
     & 1.321200e-04,1.372900e-04,1.429700e-04,1.498300e-04,1.586500e-04,&
     & 1.069200e-04,1.111100e-04,1.156100e-04,1.208100e-04,1.275200e-04,&
     & 8.648400e-05,8.985100e-05,9.340100e-05,9.738400e-05,1.024600e-04,&
     & 6.990200e-05,7.264100e-05,7.549100e-05,7.863200e-05,8.243800e-05,&
     & 5.635700e-05,5.867800e-05,6.098700e-05,6.345600e-05,6.630900e-05,&
     & 4.524600e-05,4.735100e-05,4.918800e-05,5.113200e-05,5.330200e-05,&
     & 3.633100e-05,3.814900e-05,3.966700e-05,4.122600e-05,4.293200e-05,&
     & 2.915000e-05,3.066200e-05,3.199700e-05,3.325400e-05,3.458300e-05,&
     & 2.339300e-05,2.464500e-05,2.583500e-05,2.684200e-05,2.790300e-05,&
     & 1.885000e-05,1.982200e-05,2.083000e-05,2.167500e-05,2.253300e-05,&
     & 1.525900e-05,1.593200e-05,1.676000e-05,1.751400e-05,1.819900e-05,&
     & 1.241800e-05,1.279600e-05,1.348200e-05,1.414100e-05,1.469600e-05,&
     & 1.015300e-05,1.033400e-05,1.085900e-05,1.141400e-05,1.188200e-05,&
     & 8.313400e-06,8.380500e-06,8.747600e-06,9.201600e-06,9.616800e-06,&
     & 6.812800e-06,6.825000e-06,7.042200e-06,7.418400e-06,7.778600e-06,&
     & 5.587100e-06,5.579400e-06,5.687900e-06,5.980500e-06,6.283600e-06,&
     & 4.583300e-06,4.567700e-06,4.612300e-06,4.822800e-06,5.071500e-06,&
     & 3.755400e-06,3.741300e-06,3.766400e-06,3.925000e-06,4.128600e-06/
      data  absb(:,6) /                                                 &
     & 5.972100e-02,6.135400e-02,6.518400e-02,7.129600e-02,7.907600e-02,&
     & 4.909000e-02,5.065700e-02,5.405500e-02,5.926800e-02,6.578400e-02,&
     & 4.037300e-02,4.185700e-02,4.483900e-02,4.926500e-02,5.474900e-02,&
     & 3.320500e-02,3.458900e-02,3.720000e-02,4.096300e-02,4.558800e-02,&
     & 2.732100e-02,2.857200e-02,3.084400e-02,3.404400e-02,3.794300e-02,&
     & 2.247900e-02,2.359500e-02,2.557000e-02,2.829300e-02,3.154500e-02,&
     & 1.850000e-02,1.949100e-02,2.119600e-02,2.349600e-02,2.620300e-02,&
     & 1.523800e-02,1.612500e-02,1.759800e-02,1.954300e-02,2.179200e-02,&
     & 1.255700e-02,1.334300e-02,1.461400e-02,1.625200e-02,1.812400e-02,&
     & 1.038400e-02,1.110700e-02,1.221700e-02,1.361200e-02,1.518700e-02,&
     & 8.601400e-03,9.260200e-03,1.022300e-02,1.141000e-02,1.273700e-02,&
     & 7.134400e-03,7.734900e-03,8.567000e-03,9.577300e-03,1.068800e-02,&
     & 5.931800e-03,6.472000e-03,7.195600e-03,8.046300e-03,8.974400e-03,&
     & 4.948400e-03,5.432100e-03,6.059500e-03,6.773200e-03,7.546500e-03,&
     & 4.135900e-03,4.566000e-03,5.104600e-03,5.701100e-03,6.344700e-03,&
     & 3.465100e-03,3.842700e-03,4.298600e-03,4.797600e-03,5.332400e-03,&
     & 2.910200e-03,3.238600e-03,3.621800e-03,4.039300e-03,4.483000e-03,&
     & 2.447000e-03,2.730700e-03,3.052000e-03,3.400700e-03,3.768200e-03,&
     & 2.060600e-03,2.303700e-03,2.572800e-03,2.863600e-03,3.168400e-03,&
     & 1.737200e-03,1.943400e-03,2.169000e-03,2.411200e-03,2.664300e-03,&
     & 1.466000e-03,1.639500e-03,1.828700e-03,2.030100e-03,2.240000e-03,&
     & 1.232800e-03,1.378000e-03,1.535900e-03,1.702700e-03,1.876100e-03,&
     & 1.025500e-03,1.145900e-03,1.276600e-03,1.414200e-03,1.556800e-03,&
     & 8.424600e-04,9.414400e-04,1.048900e-03,1.161800e-03,1.278800e-03,&
     & 6.803200e-04,7.605900e-04,8.480000e-04,9.401100e-04,1.035800e-03,&
     & 5.487700e-04,6.138000e-04,6.848100e-04,7.599600e-04,8.382000e-04,&
     & 4.427000e-04,4.953900e-04,5.530200e-04,6.142900e-04,6.781800e-04,&
     & 3.530800e-04,3.952800e-04,4.415900e-04,4.912700e-04,5.432200e-04,&
     & 2.813600e-04,3.148900e-04,3.520100e-04,3.921900e-04,4.343400e-04,&
     & 2.243500e-04,2.507400e-04,2.804900e-04,3.129200e-04,3.471000e-04,&
     & 1.780200e-04,1.983100e-04,2.220400e-04,2.480000e-04,2.756800e-04,&
     & 1.411100e-04,1.565000e-04,1.752600e-04,1.959200e-04,2.182400e-04,&
     & 1.121900e-04,1.236500e-04,1.382800e-04,1.547100e-04,1.726300e-04,&
     & 8.935300e-05,9.762600e-05,1.087600e-04,1.218200e-04,1.361100e-04,&
     & 7.133100e-05,7.692300e-05,8.522300e-05,9.544300e-05,1.067500e-04,&
     & 5.721900e-05,6.088500e-05,6.689700e-05,7.472600e-05,8.366400e-05,&
     & 4.615700e-05,4.845000e-05,5.263400e-05,5.849900e-05,6.555200e-05,&
     & 3.749700e-05,3.882200e-05,4.164300e-05,4.599700e-05,5.149000e-05,&
     & 3.054800e-05,3.125800e-05,3.311600e-05,3.627200e-05,4.046800e-05,&
     & 2.490400e-05,2.529000e-05,2.646700e-05,2.866200e-05,3.182400e-05,&
     & 2.031800e-05,2.057300e-05,2.123900e-05,2.272100e-05,2.505900e-05,&
     & 1.659700e-05,1.677100e-05,1.713900e-05,1.812700e-05,1.983000e-05,&
     & 1.356100e-05,1.368100e-05,1.389200e-05,1.453600e-05,1.573900e-05,&
     & 1.108600e-05,1.116700e-05,1.131000e-05,1.169300e-05,1.252600e-05,&
     & 9.062800e-06,9.122500e-06,9.220300e-06,9.436700e-06,9.999300e-06,&
     & 7.430300e-06,7.454800e-06,7.522300e-06,7.648100e-06,8.021500e-06,&
     & 6.093500e-06,6.100900e-06,6.152500e-06,6.244800e-06,6.522600e-06/
      data  absb(:,7) /                                                 &
     & 1.158800e-01,1.336500e-01,1.533200e-01,1.745100e-01,1.969000e-01,&
     & 9.705500e-02,1.119600e-01,1.283900e-01,1.461200e-01,1.648800e-01,&
     & 8.129400e-02,9.377200e-02,1.075600e-01,1.224000e-01,1.380900e-01,&
     & 6.806100e-02,7.854500e-02,9.010100e-02,1.025000e-01,1.155000e-01,&
     & 5.695200e-02,6.573900e-02,7.539300e-02,8.566500e-02,9.643600e-02,&
     & 4.761700e-02,5.496600e-02,6.297900e-02,7.148000e-02,8.040900e-02,&
     & 3.977300e-02,4.589400e-02,5.254400e-02,5.958500e-02,6.700300e-02,&
     & 3.326600e-02,3.838100e-02,4.389100e-02,4.974200e-02,5.589900e-02,&
     & 2.782100e-02,3.207700e-02,3.664700e-02,4.150500e-02,4.660800e-02,&
     & 2.347800e-02,2.703900e-02,3.083900e-02,3.487900e-02,3.910300e-02,&
     & 1.982200e-02,2.279000e-02,2.596000e-02,2.930500e-02,3.280400e-02,&
     & 1.674500e-02,1.922500e-02,2.185600e-02,2.463600e-02,2.754500e-02,&
     & 1.416100e-02,1.622500e-02,1.841500e-02,2.073200e-02,2.315700e-02,&
     & 1.200300e-02,1.371900e-02,1.554700e-02,1.748900e-02,1.949800e-02,&
     & 1.017100e-02,1.160200e-02,1.313300e-02,1.475300e-02,1.641300e-02,&
     & 8.615100e-03,9.813800e-03,1.109700e-02,1.244000e-02,1.380800e-02,&
     & 7.303100e-03,8.310000e-03,9.380600e-03,1.048900e-02,1.161400e-02,&
     & 6.192400e-03,7.035000e-03,7.924300e-03,8.837900e-03,9.761500e-03,&
     & 5.253300e-03,5.956200e-03,6.692900e-03,7.444200e-03,8.204000e-03,&
     & 4.457100e-03,5.042200e-03,5.650400e-03,6.268800e-03,6.894600e-03,&
     & 3.780000e-03,4.266000e-03,4.767800e-03,5.277200e-03,5.793100e-03,&
     & 3.189900e-03,3.592300e-03,4.005800e-03,4.425900e-03,4.852000e-03,&
     & 2.658800e-03,2.991100e-03,3.331100e-03,3.677300e-03,4.028900e-03,&
     & 2.186700e-03,2.459800e-03,2.739200e-03,3.023900e-03,3.313500e-03,&
     & 1.765400e-03,1.988400e-03,2.217500e-03,2.451200e-03,2.688600e-03,&
     & 1.423500e-03,1.605500e-03,1.793200e-03,1.984900e-03,2.179600e-03,&
     & 1.147700e-03,1.296100e-03,1.449900e-03,1.607100e-03,1.766800e-03,&
     & 9.130200e-04,1.033500e-03,1.159100e-03,1.287700e-03,1.418500e-03,&
     & 7.246700e-04,8.222100e-04,9.246400e-04,1.029800e-03,1.137000e-03,&
     & 5.747400e-04,6.536900e-04,7.370100e-04,8.229300e-04,9.107000e-04,&
     & 4.520400e-04,5.157100e-04,5.831200e-04,6.532200e-04,7.249200e-04,&
     & 3.539700e-04,4.050900e-04,4.594400e-04,5.165100e-04,5.750200e-04,&
     & 2.767700e-04,3.178300e-04,3.616200e-04,4.079300e-04,4.556200e-04,&
     & 2.154000e-04,2.483500e-04,2.835800e-04,3.209300e-04,3.597900e-04,&
     & 1.663300e-04,1.926600e-04,2.208100e-04,2.508000e-04,2.823600e-04,&
     & 1.283000e-04,1.491400e-04,1.716700e-04,1.957300e-04,2.212100e-04,&
     & 9.890000e-05,1.152400e-04,1.332500e-04,1.525200e-04,1.730000e-04,&
     & 7.652300e-05,8.926400e-05,1.036300e-04,1.190600e-04,1.355000e-04,&
     & 5.935000e-05,6.920400e-05,8.057100e-05,9.295200e-05,1.061700e-04,&
     & 4.611000e-05,5.363800e-05,6.256500e-05,7.248000e-05,8.308100e-05,&
     & 3.590700e-05,4.157200e-05,4.852300e-05,5.642100e-05,6.491900e-05,&
     & 2.816900e-05,3.239400e-05,3.778600e-05,4.404700e-05,5.087400e-05,&
     & 2.224400e-05,2.533200e-05,2.948000e-05,3.442000e-05,3.990300e-05,&
     & 1.766100e-05,1.984800e-05,2.300400e-05,2.687500e-05,3.126100e-05,&
     & 1.411600e-05,1.559000e-05,1.796200e-05,2.097200e-05,2.445700e-05,&
     & 1.134200e-05,1.232300e-05,1.407600e-05,1.640300e-05,1.916100e-05,&
     & 9.228200e-06,9.966900e-06,1.133800e-05,1.319900e-05,1.542700e-05/
      data  absb(:,8) /                                                 &
     & 3.300700e-01,3.965100e-01,4.680900e-01,5.435700e-01,6.215700e-01,&
     & 2.789900e-01,3.350700e-01,3.953400e-01,4.585100e-01,5.238300e-01,&
     & 2.360300e-01,2.832000e-01,3.337700e-01,3.866900e-01,4.413700e-01,&
     & 1.995900e-01,2.392600e-01,2.815500e-01,3.256700e-01,3.716100e-01,&
     & 1.685400e-01,2.017100e-01,2.369600e-01,2.739100e-01,3.123600e-01,&
     & 1.420900e-01,1.697700e-01,1.991800e-01,2.300900e-01,2.622900e-01,&
     & 1.195400e-01,1.426200e-01,1.671900e-01,1.930100e-01,2.198400e-01,&
     & 1.007700e-01,1.200500e-01,1.405400e-01,1.620800e-01,1.842900e-01,&
     & 8.491400e-02,1.010000e-01,1.180600e-01,1.358800e-01,1.543700e-01,&
     & 7.235500e-02,8.579100e-02,9.998200e-02,1.148100e-01,1.302000e-01,&
     & 6.163700e-02,7.283300e-02,8.465800e-02,9.698400e-02,1.098100e-01,&
     & 5.251400e-02,6.186000e-02,7.170100e-02,8.196700e-02,9.259600e-02,&
     & 4.476900e-02,5.256800e-02,6.076300e-02,6.929600e-02,7.812000e-02,&
     & 3.825300e-02,4.475600e-02,5.157800e-02,5.867000e-02,6.601300e-02,&
     & 3.266700e-02,3.808800e-02,4.375700e-02,4.965600e-02,5.579300e-02,&
     & 2.787700e-02,3.239300e-02,3.710900e-02,4.203000e-02,4.717900e-02,&
     & 2.379700e-02,2.755500e-02,3.149100e-02,3.561700e-02,3.992300e-02,&
     & 2.029800e-02,2.343200e-02,2.672700e-02,3.018900e-02,3.377300e-02,&
     & 1.731400e-02,1.993600e-02,2.270100e-02,2.558700e-02,2.857100e-02,&
     & 1.477000e-02,1.697200e-02,1.928100e-02,2.168800e-02,2.416200e-02,&
     & 1.260000e-02,1.444600e-02,1.637300e-02,1.837400e-02,2.042400e-02,&
     & 1.069600e-02,1.223600e-02,1.383900e-02,1.549700e-02,1.719400e-02,&
     & 8.955500e-03,1.023200e-02,1.155900e-02,1.293100e-02,1.433500e-02,&
     & 7.384600e-03,8.437300e-03,9.532500e-03,1.066200e-02,1.182200e-02,&
     & 5.960600e-03,6.823300e-03,7.720900e-03,8.648700e-03,9.604100e-03,&
     & 4.803700e-03,5.510500e-03,6.245900e-03,7.007900e-03,7.794300e-03,&
     & 3.870600e-03,4.449100e-03,5.051900e-03,5.677900e-03,6.325100e-03,&
     & 3.070500e-03,3.541700e-03,4.033600e-03,4.546100e-03,5.077300e-03,&
     & 2.428500e-03,2.811800e-03,3.212900e-03,3.631800e-03,4.067300e-03,&
     & 1.918400e-03,2.230000e-03,2.557000e-03,2.899100e-03,3.256100e-03,&
     & 1.499900e-03,1.752200e-03,2.018000e-03,2.296600e-03,2.588100e-03,&
     & 1.165500e-03,1.369400e-03,1.584900e-03,1.811300e-03,2.048800e-03,&
     & 9.037600e-04,1.068200e-03,1.242700e-03,1.426600e-03,1.619900e-03,&
     & 6.965000e-04,8.285800e-04,9.695000e-04,1.118600e-03,1.275500e-03,&
     & 5.310800e-04,6.364300e-04,7.498400e-04,8.701800e-04,9.972100e-04,&
     & 4.036100e-04,4.874200e-04,5.783300e-04,6.753400e-04,7.780700e-04,&
     & 3.056600e-04,3.721500e-04,4.447500e-04,5.227900e-04,6.057900e-04,&
     & 2.319300e-04,2.845900e-04,3.425100e-04,4.052600e-04,4.723000e-04,&
     & 1.759000e-04,2.174800e-04,2.636100e-04,3.139500e-04,3.680400e-04,&
     & 1.330400e-04,1.657300e-04,2.024000e-04,2.426500e-04,2.862100e-04,&
     & 1.003300e-04,1.259000e-04,1.549600e-04,1.870400e-04,2.220100e-04,&
     & 7.604300e-05,9.603300e-05,1.190300e-04,1.446400e-04,1.727100e-04,&
     & 5.772500e-05,7.330900e-05,9.148200e-05,1.119000e-04,1.343900e-04,&
     & 4.377300e-05,5.584500e-05,7.015500e-05,8.640100e-05,1.043900e-04,&
     & 3.317800e-05,4.246600e-05,5.367700e-05,6.656200e-05,8.093200e-05,&
     & 2.527600e-05,3.236500e-05,4.113300e-05,5.134300e-05,6.281500e-05,&
     & 2.013800e-05,2.577900e-05,3.283600e-05,4.110500e-05,5.043300e-05/
      data  absb(:,9) /                                                 &
     & 2.057500e+00,2.525900e+00,3.023400e+00,3.547100e+00,4.089200e+00,&
     & 1.789600e+00,2.193600e+00,2.624300e+00,3.075400e+00,3.535700e+00,&
     & 1.553200e+00,1.900500e+00,2.269800e+00,2.653400e+00,3.046000e+00,&
     & 1.343100e+00,1.639900e+00,1.954200e+00,2.280100e+00,2.615400e+00,&
     & 1.156400e+00,1.409100e+00,1.675000e+00,1.951700e+00,2.235300e+00,&
     & 9.926100e-01,1.205900e+00,1.430300e+00,1.663500e+00,1.902900e+00,&
     & 8.482900e-01,1.028300e+00,1.217100e+00,1.413100e+00,1.614200e+00,&
     & 7.255100e-01,8.768900e-01,1.036000e+00,1.201200e+00,1.370300e+00,&
     & 6.193200e-01,7.464500e-01,8.801900e-01,1.018900e+00,1.161600e+00,&
     & 5.343600e-01,6.417100e-01,7.544100e-01,8.710400e-01,9.910700e-01,&
     & 4.606400e-01,5.511200e-01,6.457000e-01,7.436500e-01,8.443600e-01,&
     & 3.969600e-01,4.729200e-01,5.522000e-01,6.345200e-01,7.190500e-01,&
     & 3.420600e-01,4.057600e-01,4.724000e-01,5.414400e-01,6.125300e-01,&
     & 2.950900e-01,3.486600e-01,4.046200e-01,4.625500e-01,5.221200e-01,&
     & 2.543200e-01,2.993800e-01,3.463600e-01,3.948700e-01,4.447300e-01,&
     & 2.189700e-01,2.568600e-01,2.962100e-01,3.369000e-01,3.787100e-01,&
     & 1.886300e-01,2.203500e-01,2.533800e-01,2.874600e-01,3.227600e-01,&
     & 1.622700e-01,1.889100e-01,2.165900e-01,2.453200e-01,2.750800e-01,&
     & 1.396100e-01,1.619700e-01,1.852200e-01,2.094600e-01,2.345100e-01,&
     & 1.200900e-01,1.388600e-01,1.584800e-01,1.788800e-01,2.000100e-01,&
     & 1.032400e-01,1.190400e-01,1.355900e-01,1.528100e-01,1.707100e-01,&
     & 8.824500e-02,1.015600e-01,1.155000e-01,1.300600e-01,1.452800e-01,&
     & 7.437300e-02,8.555100e-02,9.729700e-02,1.095700e-01,1.225100e-01,&
     & 6.170400e-02,7.104900e-02,8.090000e-02,9.125100e-02,1.022100e-01,&
     & 5.006000e-02,5.782000e-02,6.602400e-02,7.470100e-02,8.392300e-02,&
     & 4.055000e-02,4.699100e-02,5.382600e-02,6.110500e-02,6.886400e-02,&
     & 3.284500e-02,3.818500e-02,4.388300e-02,4.999000e-02,5.651200e-02,&
     & 2.615900e-02,3.055900e-02,3.527900e-02,4.036400e-02,4.580300e-02,&
     & 2.076200e-02,2.438000e-02,2.828500e-02,3.251400e-02,3.704100e-02,&
     & 1.645400e-02,1.942600e-02,2.265200e-02,2.616300e-02,2.992900e-02,&
     & 1.288900e-02,1.531600e-02,1.796900e-02,2.086500e-02,2.398600e-02,&
     & 1.002500e-02,1.200000e-02,1.417200e-02,1.655300e-02,1.913100e-02,&
     & 7.774600e-03,9.378400e-03,1.115300e-02,1.310700e-02,1.523200e-02,&
     & 5.983900e-03,7.280300e-03,8.723600e-03,1.032000e-02,1.206600e-02,&
     & 4.546900e-03,5.587200e-03,6.752700e-03,8.049000e-03,9.473700e-03,&
     & 3.438700e-03,4.270700e-03,5.208100e-03,6.257800e-03,7.417000e-03,&
     & 2.587200e-03,3.250200e-03,4.001400e-03,4.848700e-03,5.789600e-03,&
     & 1.948400e-03,2.476300e-03,3.078200e-03,3.761900e-03,4.525500e-03,&
     & 1.464100e-03,1.883300e-03,2.364200e-03,2.915600e-03,3.534300e-03,&
     & 1.094700e-03,1.426000e-03,1.809200e-03,2.252500e-03,2.752300e-03,&
     & 8.138500e-04,1.074400e-03,1.378800e-03,1.733500e-03,2.136300e-03,&
     & 6.072700e-04,8.122700e-04,1.054300e-03,1.338300e-03,1.663400e-03,&
     & 4.527200e-04,6.137400e-04,8.058900e-04,1.033100e-03,1.295200e-03,&
     & 3.358300e-04,4.618100e-04,6.137700e-04,7.950800e-04,1.005700e-03,&
     & 2.477600e-04,3.459000e-04,4.655900e-04,6.097800e-04,7.786100e-04,&
     & 1.828300e-04,2.592400e-04,3.533800e-04,4.680800e-04,6.034000e-04,&
     & 1.439400e-04,2.056500e-04,2.823100e-04,3.764100e-04,4.876600e-04/
      data  absb(:,10) /                                                &
     & 9.390400e+00,1.155800e+01,1.384500e+01,1.616300e+01,1.855500e+01,&
     & 8.397300e+00,1.027000e+01,1.220900e+01,1.423100e+01,1.640300e+01,&
     & 7.422700e+00,9.032800e+00,1.072500e+01,1.253900e+01,1.442400e+01,&
     & 6.520500e+00,7.925700e+00,9.431000e+00,1.101200e+01,1.260200e+01,&
     & 5.696800e+00,6.923600e+00,8.231300e+00,9.579200e+00,1.095600e+01,&
     & 4.947100e+00,6.016100e+00,7.133900e+00,8.294800e+00,9.485700e+00,&
     & 4.289500e+00,5.202900e+00,6.164200e+00,7.152700e+00,8.173000e+00,&
     & 3.714700e+00,4.492900e+00,5.306800e+00,6.147400e+00,7.007800e+00,&
     & 3.202400e+00,3.863100e+00,4.549900e+00,5.259600e+00,5.986700e+00,&
     & 2.788100e+00,3.346200e+00,3.929100e+00,4.533200e+00,5.151600e+00,&
     & 2.422100e+00,2.893400e+00,3.388800e+00,3.900700e+00,4.429600e+00,&
     & 2.101200e+00,2.504200e+00,2.925700e+00,3.360500e+00,3.809900e+00,&
     & 1.823400e+00,2.168300e+00,2.523400e+00,2.894000e+00,3.274000e+00,&
     & 1.588000e+00,1.877300e+00,2.178100e+00,2.492100e+00,2.818200e+00,&
     & 1.379500e+00,1.623300e+00,1.879000e+00,2.146300e+00,2.424600e+00,&
     & 1.195200e+00,1.402000e+00,1.620400e+00,1.847300e+00,2.081800e+00,&
     & 1.035300e+00,1.212600e+00,1.397400e+00,1.589500e+00,1.785400e+00,&
     & 8.971000e-01,1.047900e+00,1.204600e+00,1.366500e+00,1.532100e+00,&
     & 7.781700e-01,9.051900e-01,1.038600e+00,1.175400e+00,1.318200e+00,&
     & 6.739900e-01,7.825100e-01,8.951500e-01,1.012700e+00,1.136900e+00,&
     & 5.840500e-01,6.762200e-01,7.723600e-01,8.740300e-01,9.795600e-01,&
     & 5.035700e-01,5.818200e-01,6.645200e-01,7.515100e-01,8.403500e-01,&
     & 4.277900e-01,4.944000e-01,5.649100e-01,6.389200e-01,7.133300e-01,&
     & 3.577700e-01,4.142100e-01,4.738700e-01,5.361700e-01,5.990000e-01,&
     & 2.923400e-01,3.396300e-01,3.897300e-01,4.419400e-01,4.950800e-01,&
     & 2.384500e-01,2.780400e-01,3.201400e-01,3.639300e-01,4.088700e-01,&
     & 1.944900e-01,2.276200e-01,2.630300e-01,2.998700e-01,3.380800e-01,&
     & 1.558100e-01,1.833800e-01,2.129800e-01,2.438800e-01,2.764000e-01,&
     & 1.243700e-01,1.472800e-01,1.719800e-01,1.979000e-01,2.256100e-01,&
     & 9.911400e-02,1.181400e-01,1.387100e-01,1.604900e-01,1.840900e-01,&
     & 7.801400e-02,9.369900e-02,1.107200e-01,1.289700e-01,1.489300e-01,&
     & 6.093000e-02,7.381300e-02,8.782900e-02,1.030600e-01,1.199000e-01,&
     & 4.743900e-02,5.796300e-02,6.952400e-02,8.217900e-02,9.637700e-02,&
     & 3.662800e-02,4.518900e-02,5.466300e-02,6.513900e-02,7.703100e-02,&
     & 2.789000e-02,3.478700e-02,4.249300e-02,5.109600e-02,6.096500e-02,&
     & 2.111900e-02,2.664500e-02,3.289600e-02,3.992100e-02,4.808900e-02,&
     & 1.590000e-02,2.030700e-02,2.535100e-02,3.106400e-02,3.779200e-02,&
     & 1.198200e-02,1.548600e-02,1.955300e-02,2.419600e-02,2.972700e-02,&
     & 9.005600e-03,1.178800e-02,1.505100e-02,1.881500e-02,2.334800e-02,&
     & 6.728700e-03,8.932300e-03,1.154300e-02,1.458100e-02,1.827700e-02,&
     & 4.991700e-03,6.731800e-03,8.809500e-03,1.125500e-02,1.425000e-02,&
     & 3.716600e-03,5.089700e-03,6.743800e-03,8.715500e-03,1.114700e-02,&
     & 2.763100e-03,3.845600e-03,5.159300e-03,6.747600e-03,8.719500e-03,&
     & 2.041100e-03,2.890500e-03,3.930800e-03,5.203100e-03,6.794900e-03,&
     & 1.497800e-03,2.159800e-03,2.980700e-03,3.994800e-03,5.275200e-03,&
     & 1.098500e-03,1.614200e-03,2.261300e-03,3.068700e-03,4.098600e-03,&
     & 8.650000e-04,1.283300e-03,1.812700e-03,2.481700e-03,3.344300e-03/
      data  absb(:,11) /                                                &
     & 1.837200e+01,2.253100e+01,2.694200e+01,3.172100e+01,3.666600e+01,&
     & 1.647600e+01,2.026600e+01,2.437500e+01,2.867300e+01,3.296000e+01,&
     & 1.483800e+01,1.825800e+01,2.187400e+01,2.554000e+01,2.929900e+01,&
     & 1.332200e+01,1.628200e+01,1.936100e+01,2.255300e+01,2.593800e+01,&
     & 1.179700e+01,1.434000e+01,1.702200e+01,1.986500e+01,2.280500e+01,&
     & 1.035400e+01,1.257600e+01,1.494500e+01,1.740900e+01,1.988000e+01,&
     & 9.036500e+00,1.098000e+01,1.303900e+01,1.515200e+01,1.725800e+01,&
     & 7.883400e+00,9.569500e+00,1.132700e+01,1.313200e+01,1.493200e+01,&
     & 6.855000e+00,8.297000e+00,9.811900e+00,1.133500e+01,1.285600e+01,&
     & 6.019900e+00,7.256200e+00,8.532600e+00,9.810400e+00,1.108600e+01,&
     & 5.265500e+00,6.315500e+00,7.381300e+00,8.454600e+00,9.520500e+00,&
     & 4.596800e+00,5.476500e+00,6.371700e+00,7.277200e+00,8.175200e+00,&
     & 4.004600e+00,4.743700e+00,5.501200e+00,6.258200e+00,7.024300e+00,&
     & 3.489900e+00,4.115600e+00,4.754400e+00,5.397800e+00,6.047800e+00,&
     & 3.037000e+00,3.570400e+00,4.108300e+00,4.655900e+00,5.202600e+00,&
     & 2.644100e+00,3.090800e+00,3.545200e+00,4.009200e+00,4.477400e+00,&
     & 2.299100e+00,2.674400e+00,3.060900e+00,3.454500e+00,3.857100e+00,&
     & 1.995200e+00,2.313000e+00,2.643600e+00,2.978500e+00,3.322400e+00,&
     & 1.730300e+00,2.003500e+00,2.282800e+00,2.569800e+00,2.859700e+00,&
     & 1.502100e+00,1.734900e+00,1.972300e+00,2.216200e+00,2.460700e+00,&
     & 1.304800e+00,1.502200e+00,1.705400e+00,1.911200e+00,2.125500e+00,&
     & 1.126700e+00,1.295200e+00,1.468200e+00,1.645700e+00,1.835200e+00,&
     & 9.595800e-01,1.103300e+00,1.251400e+00,1.406300e+00,1.573000e+00,&
     & 8.054300e-01,9.272800e-01,1.054600e+00,1.189500e+00,1.334600e+00,&
     & 6.611700e-01,7.642900e-01,8.731100e-01,9.895600e-01,1.113800e+00,&
     & 5.421900e-01,6.291500e-01,7.222000e-01,8.218900e-01,9.283200e-01,&
     & 4.447400e-01,5.185100e-01,5.975800e-01,6.826900e-01,7.737900e-01,&
     & 3.587400e-01,4.207700e-01,4.873800e-01,5.593000e-01,6.366600e-01,&
     & 2.880900e-01,3.401800e-01,3.962300e-01,4.570200e-01,5.226500e-01,&
     & 2.309300e-01,2.745300e-01,3.217500e-01,3.730400e-01,4.286600e-01,&
     & 1.828600e-01,2.190800e-01,2.586000e-01,3.016900e-01,3.486600e-01,&
     & 1.437100e-01,1.736400e-01,2.065500e-01,2.425800e-01,2.821800e-01,&
     & 1.125400e-01,1.372400e-01,1.645800e-01,1.946600e-01,2.280000e-01,&
     & 8.741900e-02,1.076900e-01,1.302900e-01,1.553400e-01,1.832500e-01,&
     & 6.694600e-02,8.345500e-02,1.019800e-01,1.226600e-01,1.458800e-01,&
     & 5.094100e-02,6.433800e-02,7.948500e-02,9.652300e-02,1.157300e-01,&
     & 3.850600e-02,4.932600e-02,6.166200e-02,7.568200e-02,9.153600e-02,&
     & 2.910300e-02,3.784000e-02,4.786800e-02,5.937600e-02,7.248200e-02,&
     & 2.191600e-02,2.895100e-02,3.706700e-02,4.649900e-02,5.731700e-02,&
     & 1.639200e-02,2.202000e-02,2.857500e-02,3.626800e-02,4.516900e-02,&
     & 1.217200e-02,1.664200e-02,2.190800e-02,2.815500e-02,3.545700e-02,&
     & 9.065800e-03,1.261300e-02,1.684700e-02,2.191500e-02,2.790600e-02,&
     & 6.744400e-03,9.548300e-03,1.294700e-02,1.704100e-02,2.195400e-02,&
     & 4.983700e-03,7.189300e-03,9.903100e-03,1.320100e-02,1.721500e-02,&
     & 3.655500e-03,5.379700e-03,7.534500e-03,1.018500e-02,1.344800e-02,&
     & 2.679800e-03,4.023400e-03,5.732200e-03,7.859100e-03,1.050900e-02,&
     & 2.117400e-03,3.212600e-03,4.617800e-03,6.389000e-03,8.630700e-03/
      data  absb(:,12) /                                                &
     & 3.903700e+01,4.859500e+01,5.829000e+01,6.774300e+01,7.717500e+01,&
     & 3.673100e+01,4.514300e+01,5.336700e+01,6.173500e+01,7.026600e+01,&
     & 3.378200e+01,4.105300e+01,4.846500e+01,5.610100e+01,6.404600e+01,&
     & 3.036100e+01,3.683700e+01,4.369200e+01,5.074900e+01,5.777000e+01,&
     & 2.718100e+01,3.303700e+01,3.912200e+01,4.523600e+01,5.130200e+01,&
     & 2.428900e+01,2.937300e+01,3.457300e+01,3.982000e+01,4.525400e+01,&
     & 2.148900e+01,2.583200e+01,3.028600e+01,3.489500e+01,3.972800e+01,&
     & 1.888900e+01,2.262600e+01,2.651600e+01,3.057300e+01,3.472900e+01,&
     & 1.649900e+01,1.977200e+01,2.316900e+01,2.666800e+01,3.024700e+01,&
     & 1.456400e+01,1.739700e+01,2.033200e+01,2.337500e+01,2.648200e+01,&
     & 1.281100e+01,1.525400e+01,1.780300e+01,2.043600e+01,2.311000e+01,&
     & 1.125000e+01,1.335400e+01,1.554900e+01,1.779700e+01,2.009400e+01,&
     & 9.859700e+00,1.167000e+01,1.353700e+01,1.546600e+01,1.742300e+01,&
     & 8.644700e+00,1.018100e+01,1.177900e+01,1.341700e+01,1.508100e+01,&
     & 7.559400e+00,8.864200e+00,1.022600e+01,1.163000e+01,1.305800e+01,&
     & 6.592500e+00,7.716100e+00,8.889700e+00,1.008700e+01,1.132700e+01,&
     & 5.756500e+00,6.724000e+00,7.726800e+00,8.763200e+00,9.840900e+00,&
     & 5.029000e+00,5.863600e+00,6.724700e+00,7.629000e+00,8.559900e+00,&
     & 4.403500e+00,5.118200e+00,5.868000e+00,6.655500e+00,7.466500e+00,&
     & 3.857800e+00,4.475200e+00,5.130800e+00,5.815100e+00,6.527800e+00,&
     & 3.379400e+00,3.916700e+00,4.490400e+00,5.088000e+00,5.714800e+00,&
     & 2.948600e+00,3.419300e+00,3.916700e+00,4.441000e+00,4.989800e+00,&
     & 2.538400e+00,2.948500e+00,3.380600e+00,3.838200e+00,4.313800e+00,&
     & 2.152400e+00,2.506200e+00,2.880200e+00,3.277600e+00,3.693300e+00,&
     & 1.783300e+00,2.084700e+00,2.407200e+00,2.750500e+00,3.112400e+00,&
     & 1.474900e+00,1.732600e+00,2.010800e+00,2.306700e+00,2.624400e+00,&
     & 1.219400e+00,1.440300e+00,1.680700e+00,1.937300e+00,2.216400e+00,&
     & 9.901000e-01,1.177600e+00,1.383800e+00,1.605500e+00,1.848900e+00,&
     & 8.015000e-01,9.600200e-01,1.136000e+00,1.328100e+00,1.539600e+00,&
     & 6.477800e-01,7.819400e-01,9.322300e-01,1.098000e+00,1.282400e+00,&
     & 5.167600e-01,6.295500e-01,7.571000e-01,8.990800e-01,1.058300e+00,&
     & 4.090100e-01,5.032000e-01,6.107100e-01,7.318100e-01,8.684800e-01,&
     & 3.226500e-01,4.013100e-01,4.914700e-01,5.941200e-01,7.112400e-01,&
     & 2.521000e-01,3.174700e-01,3.928400e-01,4.793700e-01,5.788600e-01,&
     & 1.938700e-01,2.475000e-01,3.101400e-01,3.826200e-01,4.663400e-01,&
     & 1.482800e-01,1.919200e-01,2.435100e-01,3.040300e-01,3.744200e-01,&
     & 1.126800e-01,1.479600e-01,1.902100e-01,2.402600e-01,2.993400e-01,&
     & 8.569200e-02,1.141900e-01,1.487600e-01,1.900700e-01,2.394800e-01,&
     & 6.496800e-02,8.789800e-02,1.160400e-01,1.501600e-01,1.913700e-01,&
     & 4.891300e-02,6.728000e-02,9.011700e-02,1.181400e-01,1.523800e-01,&
     & 3.653700e-02,5.112500e-02,6.960900e-02,9.247200e-02,1.207600e-01,&
     & 2.738900e-02,3.899900e-02,5.393200e-02,7.267600e-02,9.604900e-02,&
     & 2.048700e-02,2.970100e-02,4.172500e-02,5.707500e-02,7.639000e-02,&
     & 1.521100e-02,2.247300e-02,3.209600e-02,4.455200e-02,6.053400e-02,&
     & 1.120600e-02,1.689200e-02,2.454300e-02,3.459600e-02,4.768900e-02,&
     & 8.252000e-03,1.268600e-02,1.875800e-02,2.687300e-02,3.758800e-02,&
     & 6.570000e-03,1.022100e-02,1.529700e-02,2.216100e-02,3.134300e-02/
      data  absb(:,13) /                                                &
     & 1.587560e+02,1.956894e+02,2.344366e+02,2.741451e+02,3.146894e+02,&
     & 1.584699e+02,1.945459e+02,2.325356e+02,2.718256e+02,3.119739e+02,&
     & 1.568853e+02,1.922278e+02,2.294186e+02,2.679401e+02,3.070967e+02,&
     & 1.546355e+02,1.888959e+02,2.252044e+02,2.621186e+02,2.996274e+02,&
     & 1.511648e+02,1.840900e+02,2.184906e+02,2.529899e+02,2.877136e+02,&
     & 1.460501e+02,1.767647e+02,2.085047e+02,2.407362e+02,2.731294e+02,&
     & 1.387901e+02,1.672346e+02,1.967639e+02,2.268136e+02,2.570526e+02,&
     & 1.302884e+02,1.569042e+02,1.844685e+02,2.126037e+02,2.409272e+02,&
     & 1.212129e+02,1.457147e+02,1.713138e+02,1.972801e+02,2.233675e+02,&
     & 1.134700e+02,1.359567e+02,1.591590e+02,1.826278e+02,2.062439e+02,&
     & 1.054524e+02,1.257394e+02,1.464561e+02,1.677636e+02,1.893723e+02,&
     & 9.746170e+01,1.154812e+02,1.340355e+02,1.532282e+02,1.729868e+02,&
     & 8.955136e+01,1.055880e+02,1.223036e+02,1.397430e+02,1.577728e+02,&
     & 8.192205e+01,9.641877e+01,1.115719e+02,1.273384e+02,1.434050e+02,&
     & 7.463981e+01,8.775568e+01,1.014753e+02,1.155671e+02,1.301648e+02,&
     & 6.786403e+01,7.966084e+01,9.200494e+01,1.049184e+02,1.183407e+02,&
     & 6.175622e+01,7.234334e+01,8.355562e+01,9.547509e+01,1.078980e+02,&
     & 5.614631e+01,6.574425e+01,7.610429e+01,8.704662e+01,9.866976e+01,&
     & 5.108380e+01,5.991574e+01,6.951126e+01,7.969583e+01,9.054421e+01,&
     & 4.665028e+01,5.482854e+01,6.373904e+01,7.324370e+01,8.342273e+01,&
     & 4.281424e+01,5.042607e+01,5.868592e+01,6.761449e+01,7.729850e+01,&
     & 3.926323e+01,4.631783e+01,5.406316e+01,6.247689e+01,7.178176e+01,&
     & 3.556804e+01,4.212207e+01,4.935979e+01,5.734601e+01,6.627663e+01,&
     & 3.174377e+01,3.781481e+01,4.455603e+01,5.210807e+01,6.058125e+01,&
     & 2.764215e+01,3.319909e+01,3.941208e+01,4.644625e+01,5.439787e+01,&
     & 2.408289e+01,2.917569e+01,3.492513e+01,4.150417e+01,4.895561e+01,&
     & 2.102390e+01,2.570737e+01,3.105033e+01,3.722067e+01,4.424658e+01,&
     & 1.800085e+01,2.224292e+01,2.716201e+01,3.287592e+01,3.943936e+01,&
     & 1.537058e+01,1.921305e+01,2.372433e+01,2.901448e+01,3.515550e+01,&
     & 1.312131e+01,1.661223e+01,2.074626e+01,2.564821e+01,3.138797e+01,&
     & 1.103085e+01,1.416746e+01,1.792229e+01,2.242997e+01,2.776056e+01,&
     & 9.185308e+00,1.198959e+01,1.538826e+01,1.950457e+01,2.443733e+01,&
     & 7.630261e+00,1.012576e+01,1.319379e+01,1.694300e+01,2.150403e+01,&
     & 6.273570e+00,8.472290e+00,1.122515e+01,1.462858e+01,1.880637e+01,&
     & 5.058706e+00,6.970900e+00,9.404226e+00,1.245690e+01,1.625529e+01,&
     & 4.049263e+00,5.703601e+00,7.844185e+00,1.057218e+01,1.399979e+01,&
     & 3.218148e+00,4.636550e+00,6.510106e+00,8.935145e+00,1.200905e+01,&
     & 2.562171e+00,3.776063e+00,5.413494e+00,7.573512e+00,1.034613e+01,&
     & 2.037835e+00,3.070493e+00,4.500036e+00,6.417964e+00,8.918818e+00,&
     & 1.607017e+00,2.480545e+00,3.718399e+00,5.410818e+00,7.665372e+00,&
     & 1.255503e+00,1.991711e+00,3.053522e+00,4.540524e+00,6.558228e+00,&
     & 9.866362e-01,1.608368e+00,2.525617e+00,3.836711e+00,5.647538e+00,&
     & 7.751155e-01,1.297594e+00,2.091827e+00,3.244951e+00,4.870890e+00,&
     & 6.041880e-01,1.039632e+00,1.724195e+00,2.733113e+00,4.182720e+00,&
     & 4.678159e-01,8.277239e-01,1.410400e+00,2.291425e+00,3.579805e+00,&
     & 3.623452e-01,6.600511e-01,1.155504e+00,1.925607e+00,3.070923e+00,&
     & 3.132836e-01,5.836613e-01,1.041533e+00,1.765627e+00,2.852406e+00/
      data  absb(:,14) /                                                &
     & 1.338855e+03,1.646507e+03,1.930478e+03,2.241308e+03,2.519244e+03,&
     & 1.457082e+03,1.788126e+03,2.100791e+03,2.412002e+03,2.715987e+03,&
     & 1.603113e+03,1.938967e+03,2.279399e+03,2.604526e+03,2.941018e+03,&
     & 1.733218e+03,2.100743e+03,2.462136e+03,2.802548e+03,3.176417e+03,&
     & 1.871846e+03,2.261044e+03,2.634156e+03,3.012718e+03,3.402035e+03,&
     & 2.014241e+03,2.429442e+03,2.829721e+03,3.245403e+03,3.645161e+03,&
     & 2.156679e+03,2.605740e+03,3.046750e+03,3.466961e+03,3.898417e+03,&
     & 2.320469e+03,2.785729e+03,3.254240e+03,3.702219e+03,4.144417e+03,&
     & 2.488573e+03,2.972482e+03,3.445563e+03,3.929447e+03,4.393128e+03,&
     & 2.683356e+03,3.188935e+03,3.682325e+03,4.176066e+03,4.671022e+03,&
     & 2.887790e+03,3.408745e+03,3.921849e+03,4.432684e+03,4.945644e+03,&
     & 3.090730e+03,3.626160e+03,4.161363e+03,4.705675e+03,5.215653e+03,&
     & 3.299207e+03,3.850656e+03,4.409190e+03,4.959009e+03,5.480826e+03,&
     & 3.513449e+03,4.081664e+03,4.653172e+03,5.212444e+03,5.747674e+03,&
     & 3.730094e+03,4.310521e+03,4.891567e+03,5.461811e+03,6.005514e+03,&
     & 3.944772e+03,4.535149e+03,5.122501e+03,5.702649e+03,6.240449e+03,&
     & 4.159961e+03,4.758796e+03,5.353102e+03,5.938319e+03,6.478959e+03,&
     & 4.371963e+03,4.976804e+03,5.575981e+03,6.149735e+03,6.707861e+03,&
     & 4.583632e+03,5.193309e+03,5.795106e+03,6.370711e+03,6.930116e+03,&
     & 4.792820e+03,5.405149e+03,6.009564e+03,6.585958e+03,7.145733e+03,&
     & 4.998936e+03,5.613278e+03,6.218784e+03,6.795056e+03,7.353708e+03,&
     & 5.178912e+03,5.794807e+03,6.401222e+03,6.976731e+03,7.534370e+03,&
     & 5.290979e+03,5.912911e+03,6.520002e+03,7.096690e+03,7.654713e+03,&
     & 5.332396e+03,5.958027e+03,6.564108e+03,7.147621e+03,7.709240e+03,&
     & 5.273303e+03,5.904244e+03,6.515789e+03,7.105888e+03,7.673302e+03,&
     & 5.204465e+03,5.839766e+03,6.457092e+03,7.053011e+03,7.627379e+03,&
     & 5.131957e+03,5.771825e+03,6.393442e+03,6.994649e+03,7.574458e+03,&
     & 4.989625e+03,5.634336e+03,6.262756e+03,6.871303e+03,7.474878e+03,&
     & 4.835391e+03,5.484615e+03,6.118467e+03,6.734657e+03,7.345818e+03,&
     & 4.676446e+03,5.330176e+03,5.970193e+03,6.592234e+03,7.210701e+03,&
     & 4.479468e+03,5.136208e+03,5.781734e+03,6.410970e+03,7.037455e+03,&
     & 4.263350e+03,4.922498e+03,5.573239e+03,6.209388e+03,6.843825e+03,&
     & 4.045447e+03,4.706158e+03,5.360919e+03,6.013004e+03,6.645618e+03,&
     & 3.812084e+03,4.473259e+03,5.131285e+03,5.789078e+03,6.429350e+03,&
     & 3.551828e+03,4.210880e+03,4.871495e+03,5.534020e+03,6.181513e+03,&
     & 3.297320e+03,3.947402e+03,4.609080e+03,5.275434e+03,5.929748e+03,&
     & 3.040482e+03,3.689879e+03,4.345161e+03,5.013934e+03,5.674054e+03,&
     & 2.803042e+03,3.444522e+03,4.097473e+03,4.767169e+03,5.431631e+03,&
     & 2.576829e+03,3.208526e+03,3.859946e+03,4.526477e+03,5.194223e+03,&
     & 2.355595e+03,2.975749e+03,3.620905e+03,4.285483e+03,4.954889e+03,&
     & 2.139916e+03,2.745636e+03,3.382804e+03,4.044234e+03,4.713869e+03,&
     & 1.948216e+03,2.538810e+03,3.166659e+03,3.823324e+03,4.492112e+03,&
     & 1.770317e+03,2.344669e+03,2.961445e+03,3.612572e+03,4.279743e+03,&
     & 1.599268e+03,2.155410e+03,2.760089e+03,3.403371e+03,4.064961e+03,&
     & 1.435394e+03,1.971253e+03,2.561684e+03,3.196040e+03,3.853260e+03,&
     & 1.287123e+03,1.802069e+03,2.377375e+03,3.001500e+03,3.652940e+03,&
     & 1.229712e+03,1.735993e+03,2.304938e+03,2.924730e+03,3.573704e+03/
 
!     the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG02=14).
 
      data  selfref(:, 1) /                                             &
     & 7.542320e-01,6.872310e-01,6.261810e-01,5.705550e-01,5.198700e-01,&
     & 4.736880e-01,4.316080e-01,3.932660e-01,3.583310e-01,3.264990e-01/
      data  selfref(:, 2) /                                             &
     & 1.013770e+00,9.302660e-01,8.536370e-01,7.833200e-01,7.187960e-01,&
     & 6.595870e-01,6.052540e-01,5.553980e-01,5.096480e-01,4.676670e-01/
      data  selfref(:, 3) /                                             &
     & 1.319540e+00,1.225230e+00,1.137660e+00,1.056350e+00,9.808530e-01,&
     & 9.107490e-01,8.456560e-01,7.852150e-01,7.290950e-01,6.769850e-01/
      data  selfref(:, 4) /                                             &
     & 2.187260e+00,2.059600e+00,1.939400e+00,1.826210e+00,1.719620e+00,&
     & 1.619260e+00,1.524760e+00,1.435770e+00,1.351970e+00,1.273060e+00/
      data  selfref(:, 5) /                                             &
     & 3.174400e+00,2.927940e+00,2.700610e+00,2.490940e+00,2.297540e+00,&
     & 2.119160e+00,1.954630e+00,1.802870e+00,1.662900e+00,1.533790e+00/
      data  selfref(:, 6) /                                             &
     & 2.697050e+00,2.486840e+00,2.293020e+00,2.114310e+00,1.949520e+00,&
     & 1.797580e+00,1.657480e+00,1.528300e+00,1.409190e+00,1.299360e+00/
      data  selfref(:, 7) /                                             &
     & 2.918930e+00,2.683710e+00,2.467450e+00,2.268620e+00,2.085810e+00,&
     & 1.917730e+00,1.763190e+00,1.621110e+00,1.490480e+00,1.370370e+00/
      data  selfref(:, 8) /                                             &
     & 2.918470e+00,2.691380e+00,2.481950e+00,2.288830e+00,2.110730e+00,&
     & 1.946480e+00,1.795020e+00,1.655350e+00,1.526540e+00,1.407760e+00/
      data  selfref(:, 9) /                                             &
     & 2.739940e+00,2.548340e+00,2.370140e+00,2.204400e+00,2.050260e+00,&
     & 1.906890e+00,1.773540e+00,1.649520e+00,1.534180e+00,1.426900e+00/
      data  selfref(:,10) /                                             &
     & 2.819020e+00,2.660100e+00,2.510140e+00,2.368630e+00,2.235100e+00,&
     & 2.109090e+00,1.990200e+00,1.878000e+00,1.772130e+00,1.672220e+00/
      data  selfref(:,11) /                                             &
     & 3.194300e+00,2.976710e+00,2.773950e+00,2.585000e+00,2.408910e+00,&
     & 2.244830e+00,2.091920e+00,1.949420e+00,1.816630e+00,1.692890e+00/
      data  selfref(:,12) /                                             &
     & 3.247780e+00,3.045350e+00,2.855530e+00,2.677550e+00,2.510660e+00,&
     & 2.354170e+00,2.207440e+00,2.069850e+00,1.940840e+00,1.819870e+00/
      data  selfref(:,13) /                                             &
     & 3.696856e+00,3.434696e+00,3.191196e+00,2.965013e+00,2.754920e+00,&
     & 2.559764e+00,2.378481e+00,2.210088e+00,2.053649e+00,1.908322e+00/
      data  selfref(:,14) /                                             &
     & 4.344872e+00,4.037020e+00,3.750993e+00,3.485247e+00,3.238350e+00,&
     & 3.008960e+00,2.795829e+00,2.597805e+00,2.413821e+00,2.242877e+00/
 
      data  forref /                                                    &
     & -2.345500e-03,-8.426980e-03,-2.018160e-02,-5.667010e-02,         &
     & -8.931890e-02,-6.374870e-02,-4.564550e-02,-4.414170e-02,         &
     & -4.486050e-02,-4.746960e-02,-5.166480e-02,-5.630990e-02,         &
     & -4.397315e-02,-2.165847e-02 /
 
      data   fracrefa(:,:) /                                            &
     & 0.1806806028,0.1680317521,0.1514015794,0.1222148016,0.1024084985,&
     & 0.0933029726,0.0751895979,0.0561129414,0.0378148705,0.0038719201,&
     & 0.0032128501,0.0024444000,0.0028725001,0.0004385800,0.1792762130,&
     & 0.1673116833,0.1512953788,0.1232808530,0.1024348363,0.0935479626,&
     & 0.0753841773,0.0563307106,0.0381083190,0.0039834701,0.0032026200,&
     & 0.0025002901,0.0028979301,0.0004460700,0.1776288599,0.1663855463,&
     & 0.1511544585,0.1247062311,0.1025321335,0.0938345864,0.0756023973,&
     & 0.0564656816,0.0384407714,0.0040914202,0.0032252099,0.0025491801,&
     & 0.0029294798,0.0004542800,0.1756604314,0.1653977334,0.1509219855,&
     & 0.1257197112,0.1034060866,0.0942618921,0.0755905136,0.0567818806,&
     & 0.0388149917,0.0041410201,0.0032855100,0.0025879501,0.0029679299,&
     & 0.0004632600,0.1733582467,0.1644254774,0.1507070065,0.1266746372,&
     & 0.1045230329,0.0945083275,0.0759940967,0.0570639297,0.0391037017,&
     & 0.0041788002,0.0033525601,0.0026170800,0.0030211802,0.0004722300,&
     & 0.1708254367,0.1632151604,0.1504424661,0.1279761195,0.1057464629,&
     & 0.0947005674,0.0764742270,0.0573875606,0.0393562093,0.0042378898,&
     & 0.0034265099,0.0026454900,0.0030846901,0.0004817500,0.1680927724,&
     & 0.1619333625,0.1501318365,0.1293740869,0.1072078422,0.0948536769,&
     & 0.0769263580,0.0577177405,0.0396698788,0.0042775399,0.0034969600,&
     & 0.0026894601,0.0031375801,0.0004917400,0.1651799679,0.1605924815,&
     & 0.1498485208,0.1307926923,0.1086502969,0.0949294716,0.0775973573,&
     & 0.0581220090,0.0399716906,0.0043235598,0.0035530799,0.0027403100,&
     & 0.0031964399,0.0005020800,0.1620917916,0.1591202319,0.1493822336,&
     & 0.1319824457,0.1107723266,0.0948794782,0.0783163607,0.0586344004,&
     & 0.0402823910,0.0043680398,0.0036040701,0.0027988499,0.0032522499,&
     & 0.0005151700,0.1596242487,0.1578934342,0.1489810348,0.1327522993,&
     & 0.1125394031,0.0950350165,0.0788438171,0.0590800904,0.0405352414,&
     & 0.0043997099,0.0036426899,0.0028496501,0.0032983399,0.0005252200,&
     & 0.1592620015,0.1577093154,0.1489172876,0.1328388155,0.1127600968,&
     & 0.0950731114,0.0789222196,0.0591922998,0.0405482389,0.0044083302,&
     & 0.0036557501,0.0028645899,0.0033219100,0.0005265000,0.1592635065,&
     & 0.1577048302,0.1489117742,0.1327996552,0.1126817092,0.0951521620,&
     & 0.0789034069,0.0592480712,0.0405285098,0.0044086999,0.0036542499,&
     & 0.0028687799,0.0033466299,0.0005281000,0.1593776494,0.1577578038,&
     & 0.1489260346,0.1327324808,0.1125273108,0.0952165723,0.0788585767,&
     & 0.0592767894,0.0405018404,0.0044028498,0.0036574800,0.0028679101,&
     & 0.0033670000,0.0005298700 /
      data  fracrefb /                                                  &
     & 0.1744428873,0.1646726876,0.1502148956,0.1246090233,0.1040064320,&
     & 0.0948192775,0.0759070367,0.0575285591,0.0393171497,0.0042857202,&
     & 0.0034935200,0.0027893800,0.0033348501,0.0005781500 /
 
!    these are the mixing ratios for h2o for a mls atmosphere at the
!    13 rrtm reference pressure levels: 1.8759999e-02, 1.2223309e-02,
!    5.8908667e-03, 2.7675382e-03, 1.4065107e-03, 7.5969833e-04,
!    3.8875898e-04, 1.6542293e-04, 3.7189537e-05, 7.4764857e-06,
!    4.3081886e-06, 3.3319423e-06, 3.2039343e-06/
!
!    the following are parameters related to the reference water vapor
!    mixing ratios by refparam(i) = refh2o(i) / (.002+refh2o(i)).
!    these parameters are used for the planck function interpolation.
 
      data refparam /                                                   &
     &  0.903661, 0.859386, 0.746542, 0.580496, 0.412889, 0.275283,     &
     &  0.162745, 7.63929e-02, 1.82553e-02, 3.72432e-03,                &
     &  2.14946e-03, 1.66320e-03, 1.59940e-03 /
 
!........................................!
      end module module_radlw_kgb02_nmmb !
!========================================!
 
 
 
!========================================!
      module module_radlw_kgb03_nmmb     !
!........................................!
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NG03
!
      implicit none
!
      private
!
      integer, public :: MSA03, MSB03, MSF03, MAF03, MBF03, MEF03, MOF03
      parameter (MSA03=650, MSB03=1175, MSF03=10)
      parameter (MAF03=10, MBF03=5, MEF03=10, MOF03=59)
 
      real (kind=kind_phys), public ::                                  &
     &       absa(MSA03,NG03), absb(MSB03,NG03), selfref(MSF03,NG03),   &
     &       forref(NG03),  fracrefa(NG03,MAF03), fracrefb(NG03,MBF03), &
     &       absn2oa(NG03), absn2ob(NG03), h2oref(MOF03), n2oref(MOF03),&
     &       co2ref(MOF03), etaref(MEF03)
 
!     the array absa(650,NG03) = ka(10,5,13,NG03) contains absorption coefs
!     at the NG03=16 g-intervals for a range of pressure levels > ~100mb,
!     temperatures, and ratios of water vapor to co2.  the first index in
!     the array, js, runs from 1 to 10, and corresponds to different water
!     vapor to co2 ratios, as expressed through the binary species
!     parameter eta, defined as eta = h2o/(h20+(rat)*co2), where rat is
!     the ratio of the integrated line strength in the band of co2 to that
!     of h2o.  for instance, js=1 refers to dry air (eta = 0), js = 10
!     corresponds to eta = 1.0. the 2nd index in the array, jt, which runs
!     from 1 to 5, corresponds to different temperatures. more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively. the
!     third index, jp, runs from 1 to 13 and refers to the reference
!     pressure level (e.g. jp = 1 is for a pressure of 1053.63 mb).  the
!     fourth index, ig, goes from 1 to NG03=16, and tells us which
!     g-interval the absorption coefficients are for.
 
      data  absa(1:300,1) /                                             &
     & 1.390500e-05,5.549100e-04,9.406900e-04,1.268300e-03,1.575800e-03,&
     & 1.865700e-03,2.127100e-03,2.331000e-03,2.223800e-03,1.209800e-03,&
     & 1.871800e-05,6.225400e-04,1.041900e-03,1.394400e-03,1.709600e-03,&
     & 2.007000e-03,2.278300e-03,2.492100e-03,2.489300e-03,1.332900e-03,&
     & 2.527700e-05,7.079100e-04,1.167900e-03,1.554000e-03,1.882600e-03,&
     & 2.185500e-03,2.463700e-03,2.683600e-03,2.487000e-03,1.468300e-03,&
     & 3.397400e-05,8.147900e-04,1.327700e-03,1.749500e-03,2.101900e-03,&
     & 2.411500e-03,2.695500e-03,2.914400e-03,2.678600e-03,1.583500e-03,&
     & 4.501800e-05,9.462100e-04,1.522500e-03,1.988800e-03,2.373500e-03,&
     & 2.692400e-03,2.976700e-03,3.190400e-03,2.919900e-03,1.719600e-03,&
     & 1.059200e-05,4.449900e-04,7.648000e-04,1.036100e-03,1.285100e-03,&
     & 1.518300e-03,1.726000e-03,1.886100e-03,1.786900e-03,9.518900e-04,&
     & 1.423300e-05,4.975400e-04,8.438600e-04,1.136400e-03,1.393000e-03,&
     & 1.630800e-03,1.845000e-03,2.008800e-03,1.984300e-03,1.040600e-03,&
     & 1.930600e-05,5.643600e-04,9.428500e-04,1.261100e-03,1.531800e-03,&
     & 1.775300e-03,1.993100e-03,2.158800e-03,2.012800e-03,1.149800e-03,&
     & 2.611900e-05,6.484200e-04,1.068000e-03,1.414700e-03,1.707100e-03,&
     & 1.956700e-03,2.178900e-03,2.340100e-03,2.153800e-03,1.235800e-03,&
     & 3.487100e-05,7.525600e-04,1.222100e-03,1.604500e-03,1.920400e-03,&
     & 2.182400e-03,2.404700e-03,2.559900e-03,2.355800e-03,1.345800e-03,&
     & 7.665000e-06,3.494700e-04,6.086700e-04,8.311900e-04,1.032300e-03,&
     & 1.218500e-03,1.383000e-03,1.508700e-03,1.418700e-03,7.532500e-04,&
     & 1.020800e-05,3.879900e-04,6.672700e-04,9.056900e-04,1.114000e-03,&
     & 1.303900e-03,1.472800e-03,1.599400e-03,1.554100e-03,8.182600e-04,&
     & 1.385200e-05,4.374500e-04,7.413200e-04,9.980100e-04,1.219200e-03,&
     & 1.413700e-03,1.584900e-03,1.712300e-03,1.659300e-03,8.952800e-04,&
     & 1.887300e-05,5.008400e-04,8.348800e-04,1.113600e-03,1.350500e-03,&
     & 1.552900e-03,1.724900e-03,1.848700e-03,1.714100e-03,9.647200e-04,&
     & 2.541200e-05,5.798900e-04,9.508300e-04,1.257700e-03,1.511000e-03,&
     & 1.726500e-03,1.900100e-03,2.015400e-03,1.859200e-03,1.051400e-03,&
     & 5.532700e-06,2.737000e-04,4.820200e-04,6.629300e-04,8.270500e-04,&
     & 9.762100e-04,1.107100e-03,1.214900e-03,1.136500e-03,6.223500e-04,&
     & 7.238100e-06,3.013800e-04,5.241600e-04,7.169700e-04,8.862000e-04,&
     & 1.039100e-03,1.173000e-03,1.272600e-03,1.211300e-03,6.732000e-04,&
     & 9.769800e-06,3.372100e-04,5.785600e-04,7.851200e-04,9.645900e-04,&
     & 1.121000e-03,1.256500e-03,1.354900e-03,1.345200e-03,7.241600e-04,&
     & 1.334400e-05,3.838100e-04,6.473900e-04,8.703800e-04,1.061500e-03,&
     & 1.225200e-03,1.361200e-03,1.457600e-03,1.365500e-03,7.832500e-04,&
     & 1.809000e-05,4.425800e-04,7.328800e-04,9.775400e-04,1.181300e-03,&
     & 1.354900e-03,1.492600e-03,1.582200e-03,1.460700e-03,8.522100e-04,&
     & 4.081000e-06,2.155100e-04,3.828300e-04,5.294000e-04,6.636800e-04,&
     & 7.850300e-04,8.889700e-04,9.787000e-04,9.288500e-04,5.311200e-04,&
     & 5.191600e-06,2.350700e-04,4.127100e-04,5.682600e-04,7.056800e-04,&
     & 8.297100e-04,9.369500e-04,1.016800e-03,9.522000e-04,5.684000e-04,&
     & 6.915900e-06,2.608800e-04,4.520800e-04,6.179700e-04,7.630100e-04,&
     & 8.897900e-04,9.985300e-04,1.075900e-03,1.038900e-03,6.077700e-04,&
     & 9.419600e-06,2.948000e-04,5.027400e-04,6.808800e-04,8.355000e-04,&
     & 9.674600e-04,1.076400e-03,1.152200e-03,1.131300e-03,6.557700e-04,&
     & 1.282300e-05,3.383400e-04,5.655500e-04,7.600000e-04,9.245900e-04,&
     & 1.064000e-03,1.174500e-03,1.245600e-03,1.159900e-03,7.120500e-04,&
     & 3.074500e-06,1.702800e-04,3.046700e-04,4.235100e-04,5.332400e-04,&
     & 6.316600e-04,7.136200e-04,7.759500e-04,7.255500e-04,4.676600e-04,&
     & 3.746700e-06,1.836400e-04,3.253300e-04,4.499200e-04,5.617400e-04,&
     & 6.628900e-04,7.491800e-04,8.199200e-04,7.721700e-04,4.954000e-04,&
     & 4.884400e-06,2.018900e-04,3.531800e-04,4.861100e-04,6.024800e-04,&
     & 7.054800e-04,7.934300e-04,8.555600e-04,8.171900e-04,5.287100e-04,&
     & 6.587500e-06,2.262300e-04,3.898700e-04,5.317400e-04,6.561500e-04,&
     & 7.625500e-04,8.510500e-04,9.116400e-04,9.077600e-04,5.673800e-04,&
     & 8.978200e-06,2.579700e-04,4.357400e-04,5.894500e-04,7.218000e-04,&
     & 8.340100e-04,9.228800e-04,9.805900e-04,9.271500e-04,6.134000e-04/
      data  absa(301:650,1) /                                           &
     & 2.385200e-06,1.353700e-04,2.437600e-04,3.404600e-04,4.295300e-04,&
     & 5.087700e-04,5.735300e-04,6.119200e-04,5.727000e-04,4.331900e-04,&
     & 2.762000e-06,1.442900e-04,2.576100e-04,3.575200e-04,4.486100e-04,&
     & 5.310200e-04,5.996600e-04,6.581700e-04,6.254100e-04,4.575000e-04,&
     & 3.488000e-06,1.570100e-04,2.770100e-04,3.834400e-04,4.769100e-04,&
     & 5.609200e-04,6.322000e-04,6.839100e-04,6.433300e-04,4.866400e-04,&
     & 4.619200e-06,1.742800e-04,3.033000e-04,4.164000e-04,5.160800e-04,&
     & 6.019200e-04,6.738700e-04,7.230200e-04,7.002900e-04,5.211500e-04,&
     & 6.265900e-06,1.972300e-04,3.366800e-04,4.582800e-04,5.644200e-04,&
     & 6.546500e-04,7.269900e-04,7.740500e-04,7.741300e-04,5.600200e-04,&
     & 1.901500e-06,1.082000e-04,1.959200e-04,2.748400e-04,3.468800e-04,&
     & 4.098800e-04,4.603700e-04,4.874700e-04,4.572300e-04,4.307400e-04,&
     & 2.089700e-06,1.141000e-04,2.048900e-04,2.854300e-04,3.595400e-04,&
     & 4.259900e-04,4.807500e-04,5.210200e-04,4.894000e-04,4.609100e-04,&
     & 2.532000e-06,1.227700e-04,2.183400e-04,3.032100e-04,3.787400e-04,&
     & 4.471700e-04,5.048900e-04,5.518000e-04,5.233800e-04,4.908000e-04,&
     & 3.272700e-06,1.349800e-04,2.369000e-04,3.272000e-04,4.067200e-04,&
     & 4.763600e-04,5.349100e-04,5.756100e-04,5.505100e-04,5.197800e-04,&
     & 4.385600e-06,1.514700e-04,2.611100e-04,3.576500e-04,4.426400e-04,&
     & 5.150200e-04,5.738200e-04,6.130200e-04,6.143800e-04,5.497600e-04,&
     & 1.548200e-06,8.705200e-05,1.583900e-04,2.230000e-04,2.810500e-04,&
     & 3.309000e-04,3.693600e-04,3.899200e-04,3.656100e-04,5.030700e-04,&
     & 1.623300e-06,9.080000e-05,1.638600e-04,2.291600e-04,2.893300e-04,&
     & 3.427000e-04,3.860300e-04,4.113700e-04,3.867900e-04,5.303400e-04,&
     & 1.872700e-06,9.660500e-05,1.729900e-04,2.406800e-04,3.021600e-04,&
     & 3.576800e-04,4.038600e-04,4.430600e-04,4.252300e-04,5.582300e-04,&
     & 2.346000e-06,1.051400e-04,1.859400e-04,2.579800e-04,3.215800e-04,&
     & 3.783000e-04,4.260400e-04,4.606100e-04,4.383000e-04,5.890400e-04,&
     & 3.083500e-06,1.169100e-04,2.033600e-04,2.801500e-04,3.481400e-04,&
     & 4.063800e-04,4.542100e-04,4.865800e-04,4.761500e-04,6.243500e-04,&
     & 1.279900e-06,7.064600e-05,1.289800e-04,1.818000e-04,2.287000e-04,&
     & 2.672800e-04,2.967800e-04,3.156500e-04,2.987700e-04,5.651900e-04,&
     & 1.298700e-06,7.290600e-05,1.321500e-04,1.853500e-04,2.342100e-04,&
     & 2.769500e-04,3.113000e-04,3.288600e-04,3.102100e-04,5.870600e-04,&
     & 1.435300e-06,7.691500e-05,1.383500e-04,1.929000e-04,2.429500e-04,&
     & 2.880300e-04,3.251400e-04,3.535400e-04,3.357800e-04,6.141200e-04,&
     & 1.738700e-06,8.289400e-05,1.475900e-04,2.052800e-04,2.566300e-04,&
     & 3.029300e-04,3.417500e-04,3.721600e-04,3.575100e-04,6.498500e-04,&
     & 2.234300e-06,9.146900e-05,1.602200e-04,2.216800e-04,2.763000e-04,&
     & 3.234600e-04,3.626800e-04,3.893800e-04,3.749200e-04,6.958300e-04,&
     & 1.054300e-06,5.798300e-05,1.058200e-04,1.491900e-04,1.879100e-04,&
     & 2.200000e-04,2.443300e-04,2.599500e-04,2.459200e-04,5.030700e-04,&
     & 1.072600e-06,5.990700e-05,1.085800e-04,1.522300e-04,1.924400e-04,&
     & 2.277500e-04,2.561000e-04,2.704600e-04,2.561500e-04,5.158800e-04,&
     & 1.189400e-06,6.321200e-05,1.138300e-04,1.587000e-04,1.997900e-04,&
     & 2.369300e-04,2.674700e-04,2.915400e-04,2.791900e-04,5.385500e-04,&
     & 1.439000e-06,6.825800e-05,1.214500e-04,1.690600e-04,2.113800e-04,&
     & 2.494800e-04,2.813600e-04,3.058100e-04,2.955300e-04,5.729600e-04,&
     & 1.847000e-06,7.548900e-05,1.320200e-04,1.825700e-04,2.278200e-04,&
     & 2.668100e-04,2.989200e-04,3.205800e-04,3.105200e-04,6.181800e-04,&
     & 8.679800e-07,4.755300e-05,8.673000e-05,1.222600e-04,1.541300e-04,&
     & 1.808500e-04,2.008800e-04,2.136800e-04,2.025200e-04,4.192500e-04,&
     & 8.849500e-07,4.918300e-05,8.911800e-05,1.249000e-04,1.579000e-04,&
     & 1.869900e-04,2.104900e-04,2.223100e-04,2.117000e-04,4.291100e-04,&
     & 9.832499e-07,5.192500e-05,9.354700e-05,1.304400e-04,1.641300e-04,&
     & 1.947100e-04,2.198600e-04,2.400100e-04,2.320900e-04,4.487100e-04,&
     & 1.188900e-06,5.618300e-05,9.986300e-05,1.390500e-04,1.739100e-04,&
     & 2.052200e-04,2.314200e-04,2.513500e-04,2.426700e-04,4.781800e-04,&
     & 1.523500e-06,6.228100e-05,1.087400e-04,1.502300e-04,1.875500e-04,&
     & 2.198000e-04,2.461700e-04,2.637900e-04,2.578400e-04,5.170800e-04,&
     & 7.141800e-07,3.892100e-05,7.089100e-05,9.988900e-05,1.259700e-04,&
     & 1.479900e-04,1.645300e-04,1.751300e-04,1.666700e-04,3.430900e-04,&
     & 7.289500e-07,4.028400e-05,7.294500e-05,1.022100e-04,1.292300e-04,&
     & 1.530900e-04,1.725800e-04,1.822900e-04,1.738600e-04,3.510900e-04,&
     & 8.107900e-07,4.257600e-05,7.665900e-05,1.069200e-04,1.344900e-04,&
     & 1.596100e-04,1.802600e-04,1.970400e-04,1.924000e-04,3.670000e-04,&
     & 9.800100e-07,4.614900e-05,8.193200e-05,1.140600e-04,1.427100e-04,&
     & 1.684100e-04,1.899200e-04,2.061700e-04,1.992800e-04,3.909200e-04,&
     & 1.252800e-06,5.128000e-05,8.935900e-05,1.233800e-04,1.540100e-04,&
     & 1.805600e-04,2.022500e-04,2.167200e-04,2.136000e-04,4.225200e-04/
      data  absa(1:300,2) /                                             &
     & 6.120700e-05,1.097800e-03,1.761100e-03,2.363800e-03,2.905700e-03,&
     & 3.365100e-03,3.713700e-03,3.838300e-03,3.229700e-03,2.426400e-03,&
     & 8.505800e-05,1.329200e-03,2.075000e-03,2.733800e-03,3.340300e-03,&
     & 3.862900e-03,4.257900e-03,4.333700e-03,3.410100e-03,2.673600e-03,&
     & 1.168200e-04,1.616200e-03,2.468900e-03,3.194600e-03,3.871900e-03,&
     & 4.455200e-03,4.907600e-03,4.933500e-03,3.902200e-03,2.924700e-03,&
     & 1.578900e-04,1.966800e-03,2.948000e-03,3.766900e-03,4.517100e-03,&
     & 5.168200e-03,5.665300e-03,5.649900e-03,4.065200e-03,3.151500e-03,&
     & 2.099000e-04,2.388700e-03,3.529900e-03,4.456500e-03,5.284400e-03,&
     & 6.007600e-03,6.555100e-03,6.476400e-03,4.438500e-03,3.453800e-03,&
     & 4.654100e-05,8.867400e-04,1.409900e-03,1.886400e-03,2.318000e-03,&
     & 2.679800e-03,2.961300e-03,3.061500e-03,2.659700e-03,1.887200e-03,&
     & 6.533900e-05,1.074700e-03,1.667000e-03,2.185500e-03,2.662200e-03,&
     & 3.071000e-03,3.386200e-03,3.458400e-03,2.785200e-03,2.078200e-03,&
     & 9.058900e-05,1.308200e-03,1.994700e-03,2.563400e-03,3.086000e-03,&
     & 3.537900e-03,3.897500e-03,3.936600e-03,3.166800e-03,2.259000e-03,&
     & 1.238500e-04,1.596800e-03,2.394100e-03,3.035000e-03,3.606700e-03,&
     & 4.105700e-03,4.494200e-03,4.510700e-03,3.278200e-03,2.450400e-03,&
     & 1.666700e-04,1.948000e-03,2.878600e-03,3.606400e-03,4.237000e-03,&
     & 4.780500e-03,5.202400e-03,5.167700e-03,3.542500e-03,2.697500e-03,&
     & 3.292200e-05,6.865400e-04,1.097000e-03,1.465400e-03,1.805100e-03,&
     & 2.084700e-03,2.308800e-03,2.383700e-03,2.126500e-03,1.454000e-03,&
     & 4.658300e-05,8.301500e-04,1.294800e-03,1.695800e-03,2.066300e-03,&
     & 2.379200e-03,2.622900e-03,2.695100e-03,2.251800e-03,1.596900e-03,&
     & 6.541000e-05,1.011400e-03,1.551800e-03,1.991900e-03,2.394400e-03,&
     & 2.736600e-03,3.009800e-03,3.059500e-03,2.453000e-03,1.729900e-03,&
     & 9.073400e-05,1.236600e-03,1.868800e-03,2.365200e-03,2.800500e-03,&
     & 3.172500e-03,3.470600e-03,3.500000e-03,2.664100e-03,1.891200e-03,&
     & 1.240700e-04,1.512600e-03,2.251000e-03,2.821100e-03,3.298900e-03,&
     & 3.700100e-03,4.016100e-03,4.007500e-03,2.779800e-03,2.079600e-03,&
     & 2.277800e-05,5.251000e-04,8.488800e-04,1.135200e-03,1.397900e-03,&
     & 1.616800e-03,1.796400e-03,1.833100e-03,1.783700e-03,1.172300e-03,&
     & 3.236300e-05,6.308600e-04,9.970900e-04,1.307300e-03,1.594300e-03,&
     & 1.836600e-03,2.024400e-03,2.087500e-03,1.812400e-03,1.273200e-03,&
     & 4.596200e-05,7.678800e-04,1.191200e-03,1.534700e-03,1.843300e-03,&
     & 2.107700e-03,2.313500e-03,2.358600e-03,1.896600e-03,1.380600e-03,&
     & 6.473900e-05,9.399200e-04,1.435200e-03,1.824800e-03,2.158000e-03,&
     & 2.440300e-03,2.663900e-03,2.689300e-03,2.141300e-03,1.499900e-03,&
     & 9.000900e-05,1.153500e-03,1.733000e-03,2.181100e-03,2.548700e-03,&
     & 2.846400e-03,3.081300e-03,3.081100e-03,2.201300e-03,1.637000e-03,&
     & 1.579200e-05,4.014800e-04,6.583100e-04,8.843400e-04,1.086900e-03,&
     & 1.256800e-03,1.403000e-03,1.415700e-03,1.379000e-03,9.947100e-04,&
     & 2.239700e-05,4.788700e-04,7.670500e-04,1.011300e-03,1.232900e-03,&
     & 1.420200e-03,1.568700e-03,1.618400e-03,1.458200e-03,1.069800e-03,&
     & 3.209600e-05,5.807800e-04,9.118300e-04,1.182300e-03,1.422100e-03,&
     & 1.626000e-03,1.782300e-03,1.820800e-03,1.549300e-03,1.148600e-03,&
     & 4.584000e-05,7.116000e-04,1.096900e-03,1.403400e-03,1.662800e-03,&
     & 1.880400e-03,2.047000e-03,2.068600e-03,1.654000e-03,1.236500e-03,&
     & 6.482200e-05,8.749600e-04,1.326900e-03,1.679300e-03,1.965800e-03,&
     & 2.194600e-03,2.367100e-03,2.367700e-03,1.781200e-03,1.337600e-03,&
     & 1.090200e-05,3.060500e-04,5.102800e-04,6.885300e-04,8.448800e-04,&
     & 9.784000e-04,1.097400e-03,1.110100e-03,1.064500e-03,8.664800e-04,&
     & 1.530100e-05,3.613000e-04,5.871900e-04,7.807900e-04,9.525200e-04,&
     & 1.095900e-03,1.215200e-03,1.239700e-03,1.204600e-03,9.188500e-04,&
     & 2.201600e-05,4.354800e-04,6.926700e-04,9.051100e-04,1.092400e-03,&
     & 1.249800e-03,1.372000e-03,1.405300e-03,1.231900e-03,9.739600e-04,&
     & 3.183000e-05,5.331700e-04,8.306300e-04,1.069800e-03,1.273400e-03,&
     & 1.441800e-03,1.568700e-03,1.588100e-03,1.277500e-03,1.039900e-03,&
     & 4.573800e-05,6.569600e-04,1.003900e-03,1.279000e-03,1.502100e-03,&
     & 1.681200e-03,1.811900e-03,1.811700e-03,1.427400e-03,1.115600e-03/
      data  absa(301:650,2) /                                           &
     & 7.636900e-06,2.340900e-04,3.966200e-04,5.373600e-04,6.595400e-04,&
     & 7.662800e-04,8.632400e-04,8.811900e-04,8.619400e-04,7.907900e-04,&
     & 1.049400e-05,2.729300e-04,4.503300e-04,6.041900e-04,7.377100e-04,&
     & 8.484600e-04,9.451200e-04,9.549700e-04,9.299900e-04,8.238700e-04,&
     & 1.505900e-05,3.261200e-04,5.257000e-04,6.928500e-04,8.405600e-04,&
     & 9.621400e-04,1.057900e-03,1.086800e-03,9.860001e-04,8.642100e-04,&
     & 2.197300e-05,3.976600e-04,6.271600e-04,8.130700e-04,9.731400e-04,&
     & 1.106200e-03,1.205200e-03,1.222400e-03,1.047300e-03,9.138600e-04,&
     & 3.202400e-05,4.902300e-04,7.569300e-04,9.694200e-04,1.144100e-03,&
     & 1.286100e-03,1.387300e-03,1.390400e-03,1.099500e-03,9.740900e-04,&
     & 5.481900e-06,1.802200e-04,3.095100e-04,4.210900e-04,5.176500e-04,&
     & 6.043400e-04,6.796600e-04,7.041400e-04,7.072900e-04,7.654300e-04,&
     & 7.294600e-06,2.068900e-04,3.467300e-04,4.684100e-04,5.726300e-04,&
     & 6.604600e-04,7.394900e-04,7.488700e-04,7.213700e-04,7.851200e-04,&
     & 1.035100e-05,2.445700e-04,3.998800e-04,5.318800e-04,6.479100e-04,&
     & 7.424700e-04,8.194100e-04,8.349500e-04,8.154500e-04,8.210700e-04,&
     & 1.515600e-05,2.962900e-04,4.736500e-04,6.187300e-04,7.445400e-04,&
     & 8.495800e-04,9.285400e-04,9.439300e-04,8.394000e-04,8.728100e-04,&
     & 2.236100e-05,3.648200e-04,5.698300e-04,7.340700e-04,8.704500e-04,&
     & 9.836600e-04,1.065100e-03,1.069800e-03,8.669800e-04,9.361300e-04,&
     & 4.045200e-06,1.401700e-04,2.432900e-04,3.321800e-04,4.092500e-04,&
     & 4.810300e-04,5.391800e-04,5.610000e-04,5.650100e-04,8.097000e-04,&
     & 5.156700e-06,1.579500e-04,2.686300e-04,3.650000e-04,4.468800e-04,&
     & 5.175600e-04,5.830600e-04,5.942300e-04,5.889400e-04,8.664600e-04,&
     & 7.165700e-06,1.842700e-04,3.056300e-04,4.102600e-04,5.007600e-04,&
     & 5.751000e-04,6.379600e-04,6.441600e-04,6.281400e-04,9.458900e-04,&
     & 1.045400e-05,2.211700e-04,3.585500e-04,4.722200e-04,5.713700e-04,&
     & 6.535000e-04,7.167600e-04,7.318200e-04,6.718000e-04,1.044500e-03,&
     & 1.555400e-05,2.712900e-04,4.290200e-04,5.562200e-04,6.629600e-04,&
     & 7.522000e-04,8.192600e-04,8.253400e-04,7.131700e-04,1.156700e-03,&
     & 3.105700e-06,1.108300e-04,1.937900e-04,2.651100e-04,3.279300e-04,&
     & 3.862200e-04,4.307100e-04,4.444100e-04,4.595200e-04,8.817400e-04,&
     & 3.799100e-06,1.228300e-04,2.111300e-04,2.882100e-04,3.534800e-04,&
     & 4.111200e-04,4.617400e-04,4.771700e-04,4.865700e-04,9.868500e-04,&
     & 5.149900e-06,1.414300e-04,2.373400e-04,3.210000e-04,3.923600e-04,&
     & 4.514500e-04,5.031500e-04,5.079200e-04,4.940600e-04,1.124200e-03,&
     & 7.452800e-06,1.682700e-04,2.757400e-04,3.661300e-04,4.444200e-04,&
     & 5.091200e-04,5.602600e-04,5.714000e-04,5.568100e-04,1.293500e-03,&
     & 1.113400e-05,2.053200e-04,3.283200e-04,4.282500e-04,5.127500e-04,&
     & 5.833100e-04,6.370900e-04,6.444700e-04,5.755400e-04,1.489200e-03,&
     & 2.579300e-06,9.138600e-05,1.599100e-04,2.191400e-04,2.707600e-04,&
     & 3.182100e-04,3.550000e-04,3.687100e-04,3.789900e-04,8.333900e-04,&
     & 3.193200e-06,1.015200e-04,1.743900e-04,2.384000e-04,2.925300e-04,&
     & 3.397500e-04,3.812200e-04,3.938400e-04,4.056700e-04,9.507400e-04,&
     & 4.370900e-06,1.172800e-04,1.965600e-04,2.659500e-04,3.249500e-04,&
     & 3.736600e-04,4.157000e-04,4.196500e-04,4.112200e-04,1.099200e-03,&
     & 6.395400e-06,1.400000e-04,2.292200e-04,3.041900e-04,3.687900e-04,&
     & 4.216800e-04,4.634500e-04,4.731900e-04,4.595400e-04,1.280400e-03,&
     & 9.617400e-06,1.712000e-04,2.735700e-04,3.571100e-04,4.265400e-04,&
     & 4.841500e-04,5.277500e-04,5.332100e-04,4.753700e-04,1.494600e-03,&
     & 2.144900e-06,7.518500e-05,1.315900e-04,1.806800e-04,2.233500e-04,&
     & 2.619800e-04,2.923500e-04,3.035000e-04,3.125600e-04,7.298600e-04,&
     & 2.684900e-06,8.373900e-05,1.437000e-04,1.966600e-04,2.415300e-04,&
     & 2.804600e-04,3.144500e-04,3.244000e-04,3.381400e-04,8.389600e-04,&
     & 3.712000e-06,9.707200e-05,1.624200e-04,2.197400e-04,2.686600e-04,&
     & 3.088000e-04,3.429600e-04,3.465500e-04,3.418300e-04,9.791401e-04,&
     & 5.475000e-06,1.162100e-04,1.901200e-04,2.521000e-04,3.054700e-04,&
     & 3.490100e-04,3.829900e-04,3.909800e-04,3.804500e-04,1.149900e-03,&
     & 8.270300e-06,1.424100e-04,2.273100e-04,2.970100e-04,3.544200e-04,&
     & 4.014700e-04,4.367900e-04,4.403900e-04,3.915400e-04,1.349600e-03,&
     & 1.783000e-06,6.154500e-05,1.077600e-04,1.481600e-04,1.834600e-04,&
     & 2.151800e-04,2.400300e-04,2.492000e-04,2.585500e-04,6.048300e-04,&
     & 2.252300e-06,6.870800e-05,1.178700e-04,1.613900e-04,1.984600e-04,&
     & 2.306500e-04,2.583100e-04,2.666300e-04,2.811500e-04,6.953300e-04,&
     & 3.139400e-06,7.989400e-05,1.335700e-04,1.807100e-04,2.210600e-04,&
     & 2.542300e-04,2.821100e-04,2.854100e-04,2.843700e-04,8.118100e-04,&
     & 4.643100e-06,9.587200e-05,1.567700e-04,2.079100e-04,2.519000e-04,&
     & 2.878500e-04,3.156700e-04,3.221400e-04,3.107700e-04,9.537400e-04,&
     & 7.029300e-06,1.178200e-04,1.878200e-04,2.455600e-04,2.931000e-04,&
     & 3.317200e-04,3.606900e-04,3.627600e-04,3.232100e-04,1.119000e-03/
      data  absa(1:300,3) /                                             &
     & 3.139500e-04,2.335800e-03,3.669500e-03,4.758300e-03,5.630000e-03,&
     & 6.308400e-03,6.445900e-03,5.647600e-03,4.311400e-03,3.535900e-03,&
     & 4.404100e-04,2.855000e-03,4.428800e-03,5.733700e-03,6.770300e-03,&
     & 7.487400e-03,7.585200e-03,6.604800e-03,4.460900e-03,3.730700e-03,&
     & 6.088900e-04,3.499000e-03,5.331800e-03,6.878300e-03,8.089900e-03,&
     & 8.856200e-03,8.865900e-03,7.699800e-03,5.083400e-03,4.160600e-03,&
     & 8.294500e-04,4.296700e-03,6.410600e-03,8.201300e-03,9.603800e-03,&
     & 1.038200e-02,1.029800e-02,8.941900e-03,6.150600e-03,4.803000e-03,&
     & 1.111100e-03,5.264000e-03,7.678500e-03,9.724300e-03,1.131300e-02,&
     & 1.207300e-02,1.191800e-02,1.034000e-02,7.223100e-03,5.555900e-03,&
     & 2.578600e-04,1.868900e-03,2.917100e-03,3.765500e-03,4.455700e-03,&
     & 4.985100e-03,5.087700e-03,4.498700e-03,3.562400e-03,2.782300e-03,&
     & 3.651800e-04,2.298200e-03,3.522900e-03,4.534800e-03,5.362700e-03,&
     & 5.941300e-03,6.013100e-03,5.279600e-03,3.652800e-03,2.986200e-03,&
     & 5.096300e-04,2.832600e-03,4.249000e-03,5.447800e-03,6.429100e-03,&
     & 7.052200e-03,7.063700e-03,6.179400e-03,4.083200e-03,3.332600e-03,&
     & 7.004100e-04,3.494600e-03,5.131500e-03,6.518100e-03,7.657400e-03,&
     & 8.303900e-03,8.250100e-03,7.201300e-03,4.957900e-03,3.818200e-03,&
     & 9.450900e-04,4.304200e-03,6.178000e-03,7.764500e-03,9.055200e-03,&
     & 9.697000e-03,9.593700e-03,8.364400e-03,5.847500e-03,4.374400e-03,&
     & 1.937900e-04,1.431600e-03,2.232400e-03,2.873500e-03,3.397000e-03,&
     & 3.804100e-03,3.880200e-03,3.466900e-03,2.911900e-03,2.174400e-03,&
     & 2.777000e-04,1.767400e-03,2.700100e-03,3.457700e-03,4.088200e-03,&
     & 4.545100e-03,4.613000e-03,4.069200e-03,2.937900e-03,2.358800e-03,&
     & 3.925100e-04,2.193800e-03,3.264500e-03,4.160400e-03,4.909900e-03,&
     & 5.412500e-03,5.449200e-03,4.784600e-03,3.200300e-03,2.634600e-03,&
     & 5.460500e-04,2.727800e-03,3.960900e-03,4.997700e-03,5.874000e-03,&
     & 6.406700e-03,6.400300e-03,5.605400e-03,3.773200e-03,2.986000e-03,&
     & 7.446600e-04,3.384800e-03,4.804500e-03,5.982300e-03,6.978700e-03,&
     & 7.520900e-03,7.470800e-03,6.543300e-03,4.562000e-03,3.396600e-03,&
     & 1.401500e-04,1.081300e-03,1.685400e-03,2.172900e-03,2.570900e-03,&
     & 2.877200e-03,2.931700e-03,2.645100e-03,2.265700e-03,1.738300e-03,&
     & 2.031100e-04,1.340700e-03,2.041700e-03,2.616200e-03,3.090000e-03,&
     & 3.437100e-03,3.497000e-03,3.103000e-03,2.433100e-03,1.880700e-03,&
     & 2.908600e-04,1.674000e-03,2.481000e-03,3.147800e-03,3.709100e-03,&
     & 4.101200e-03,4.150300e-03,3.666900e-03,2.519300e-03,2.085300e-03,&
     & 4.101900e-04,2.097500e-03,3.027600e-03,3.793200e-03,4.450300e-03,&
     & 4.873600e-03,4.894800e-03,4.312900e-03,2.842200e-03,2.348100e-03,&
     & 5.665800e-04,2.621300e-03,3.697200e-03,4.566300e-03,5.312400e-03,&
     & 5.756400e-03,5.744900e-03,5.060200e-03,3.483100e-03,2.660700e-03,&
     & 1.000500e-04,8.175100e-04,1.272800e-03,1.640900e-03,1.949200e-03,&
     & 2.182800e-03,2.221000e-03,2.023600e-03,1.772800e-03,1.447700e-03,&
     & 1.462800e-04,1.015400e-03,1.543900e-03,1.977800e-03,2.340400e-03,&
     & 2.606500e-03,2.649900e-03,2.364800e-03,1.985300e-03,1.559800e-03,&
     & 2.121300e-04,1.273700e-03,1.883000e-03,2.387800e-03,2.808900e-03,&
     & 3.111600e-03,3.158400e-03,2.805500e-03,1.997900e-03,1.716500e-03,&
     & 3.031600e-04,1.603700e-03,2.310200e-03,2.889000e-03,3.373200e-03,&
     & 3.705200e-03,3.738600e-03,3.312800e-03,2.188900e-03,1.913500e-03,&
     & 4.243700e-04,2.017000e-03,2.841500e-03,3.497000e-03,4.044800e-03,&
     & 4.394600e-03,4.405400e-03,3.895600e-03,2.608900e-03,2.145600e-03,&
     & 6.984800e-05,6.134400e-04,9.542700e-04,1.233300e-03,1.469600e-03,&
     & 1.645900e-03,1.677800e-03,1.549100e-03,1.434000e-03,1.215500e-03,&
     & 1.028700e-04,7.623100e-04,1.159600e-03,1.487500e-03,1.760200e-03,&
     & 1.964400e-03,1.998700e-03,1.801500e-03,1.547500e-03,1.310600e-03,&
     & 1.506400e-04,9.589700e-04,1.418400e-03,1.799700e-03,2.117400e-03,&
     & 2.348100e-03,2.385500e-03,2.123900e-03,1.666400e-03,1.439700e-03,&
     & 2.181200e-04,1.210200e-03,1.748500e-03,2.187500e-03,2.548600e-03,&
     & 2.802800e-03,2.835600e-03,2.520600e-03,1.719500e-03,1.593400e-03,&
     & 3.096900e-04,1.527300e-03,2.163400e-03,2.662000e-03,3.069500e-03,&
     & 3.338000e-03,3.351500e-03,2.974600e-03,1.951500e-03,1.777800e-03/
      data  absa(301:650,3) /                                           &
     & 4.822100e-05,4.601000e-04,7.148100e-04,9.285900e-04,1.110000e-03,&
     & 1.240800e-03,1.268300e-03,1.194100e-03,1.165400e-03,1.061800e-03,&
     & 7.131600e-05,5.699300e-04,8.699400e-04,1.116500e-03,1.322000e-03,&
     & 1.478100e-03,1.505000e-03,1.375700e-03,1.214000e-03,1.142700e-03,&
     & 1.054000e-04,7.174000e-04,1.067100e-03,1.354600e-03,1.592100e-03,&
     & 1.767500e-03,1.799300e-03,1.608500e-03,1.340900e-03,1.246000e-03,&
     & 1.542100e-04,9.067500e-04,1.319400e-03,1.653100e-03,1.923900e-03,&
     & 2.116300e-03,2.144600e-03,1.911800e-03,1.354900e-03,1.370200e-03,&
     & 2.220700e-04,1.148500e-03,1.637900e-03,2.023600e-03,2.329200e-03,&
     & 2.531900e-03,2.545200e-03,2.261800e-03,1.488400e-03,1.520200e-03,&
     & 3.302400e-05,3.453000e-04,5.368800e-04,7.011500e-04,8.422900e-04,&
     & 9.388900e-04,9.672500e-04,9.169400e-04,9.167000e-04,1.013500e-03,&
     & 4.886700e-05,4.256000e-04,6.514500e-04,8.377800e-04,9.954399e-04,&
     & 1.113400e-03,1.134500e-03,1.053800e-03,9.711300e-04,1.085700e-03,&
     & 7.282500e-05,5.347100e-04,8.002200e-04,1.018100e-03,1.196700e-03,&
     & 1.330200e-03,1.354700e-03,1.226600e-03,1.044600e-03,1.177400e-03,&
     & 1.077400e-04,6.765200e-04,9.908100e-04,1.245800e-03,1.450800e-03,&
     & 1.597600e-03,1.619900e-03,1.451000e-03,1.138900e-03,1.291300e-03,&
     & 1.571200e-04,8.589300e-04,1.233000e-03,1.531800e-03,1.764800e-03,&
     & 1.918800e-03,1.929800e-03,1.719700e-03,1.158500e-03,1.430100e-03,&
     & 2.269400e-05,2.596400e-04,4.058700e-04,5.324400e-04,6.430700e-04,&
     & 7.148600e-04,7.424000e-04,7.116400e-04,7.227300e-04,1.249300e-03,&
     & 3.340300e-05,3.185100e-04,4.882600e-04,6.298200e-04,7.528200e-04,&
     & 8.406700e-04,8.577700e-04,8.105500e-04,7.804800e-04,1.381200e-03,&
     & 5.002800e-05,3.982600e-04,5.993100e-04,7.642400e-04,9.003100e-04,&
     & 1.001800e-03,1.020100e-03,9.377100e-04,8.289700e-04,1.524800e-03,&
     & 7.476700e-05,5.039200e-04,7.414100e-04,9.367600e-04,1.093000e-03,&
     & 1.205000e-03,1.222800e-03,1.098300e-03,9.013400e-04,1.687100e-03,&
     & 1.103500e-04,6.409700e-04,9.243400e-04,1.153200e-03,1.333400e-03,&
     & 1.452600e-03,1.461400e-03,1.305400e-03,9.181000e-04,1.872700e-03,&
     & 1.613100e-05,1.988900e-04,3.127500e-04,4.122800e-04,4.983900e-04,&
     & 5.562300e-04,5.825300e-04,5.634300e-04,5.605000e-04,1.588900e-03,&
     & 2.354800e-05,2.427900e-04,3.728900e-04,4.822200e-04,5.791200e-04,&
     & 6.448600e-04,6.626500e-04,6.339100e-04,6.228700e-04,1.897000e-03,&
     & 3.534500e-05,3.021300e-04,4.566200e-04,5.830200e-04,6.887200e-04,&
     & 7.665200e-04,7.803700e-04,7.253100e-04,6.602000e-04,2.261100e-03,&
     & 5.320700e-05,3.818100e-04,5.640300e-04,7.142800e-04,8.359600e-04,&
     & 9.216500e-04,9.356200e-04,8.450200e-04,7.124900e-04,2.667600e-03,&
     & 7.934900e-05,4.866800e-04,7.036500e-04,8.795400e-04,1.020400e-03,&
     & 1.114500e-03,1.123200e-03,1.004500e-03,7.747600e-04,3.111000e-03,&
     & 1.360100e-05,1.664400e-04,2.605900e-04,3.419000e-04,4.132300e-04,&
     & 4.609800e-04,4.823600e-04,4.660200e-04,4.640800e-04,1.706000e-03,&
     & 2.001500e-05,2.039000e-04,3.127400e-04,4.024800e-04,4.815700e-04,&
     & 5.355300e-04,5.500000e-04,5.259200e-04,5.132700e-04,2.093000e-03,&
     & 3.022900e-05,2.549300e-04,3.832500e-04,4.883800e-04,5.759000e-04,&
     & 6.386800e-04,6.495200e-04,6.032900e-04,5.435400e-04,2.534100e-03,&
     & 4.572800e-05,3.235700e-04,4.751300e-04,5.990000e-04,7.003200e-04,&
     & 7.705200e-04,7.816000e-04,7.036400e-04,5.886700e-04,3.011000e-03,&
     & 6.847100e-05,4.145300e-04,5.951800e-04,7.394300e-04,8.558600e-04,&
     & 9.324300e-04,9.398500e-04,8.388800e-04,6.400400e-04,3.514400e-03,&
     & 1.139000e-05,1.385500e-04,2.170500e-04,2.835600e-04,3.419800e-04,&
     & 3.812500e-04,3.989700e-04,3.870100e-04,3.842800e-04,1.620200e-03,&
     & 1.689500e-05,1.703300e-04,2.613200e-04,3.357400e-04,4.003300e-04,&
     & 4.444000e-04,4.554700e-04,4.345300e-04,4.179500e-04,2.005600e-03,&
     & 2.569700e-05,2.139900e-04,3.207900e-04,4.079400e-04,4.808000e-04,&
     & 5.317200e-04,5.401500e-04,5.013100e-04,4.506200e-04,2.435600e-03,&
     & 3.909800e-05,2.730100e-04,3.992300e-04,5.013700e-04,5.848700e-04,&
     & 6.418500e-04,6.519000e-04,5.859800e-04,4.910000e-04,2.899200e-03,&
     & 5.888000e-05,3.513500e-04,5.023300e-04,6.205400e-04,7.159600e-04,&
     & 7.774200e-04,7.840600e-04,7.008900e-04,5.297500e-04,3.385300e-03,&
     & 9.358900e-06,1.140400e-04,1.792900e-04,2.342400e-04,2.817700e-04,&
     & 3.138200e-04,3.288700e-04,3.193900e-04,3.178200e-04,1.371200e-03,&
     & 1.399700e-05,1.407000e-04,2.163800e-04,2.782200e-04,3.313100e-04,&
     & 3.674000e-04,3.761800e-04,3.587500e-04,3.425700e-04,1.694800e-03,&
     & 2.146700e-05,1.776000e-04,2.665700e-04,3.386000e-04,3.986300e-04,&
     & 4.402000e-04,4.477400e-04,4.150300e-04,3.738700e-04,2.055500e-03,&
     & 3.293900e-05,2.279100e-04,3.332000e-04,4.172800e-04,4.857600e-04,&
     & 5.316900e-04,5.407200e-04,4.871800e-04,4.135800e-04,2.441800e-03,&
     & 5.003800e-05,2.944300e-04,4.208000e-04,5.180700e-04,5.961900e-04,&
     & 6.453200e-04,6.503500e-04,5.836000e-04,4.322800e-04,2.842600e-03/
      data  absa(1:300,4) /                                             &
     & 1.395900e-03,5.992200e-03,8.231600e-03,9.805900e-03,1.061300e-02,&
     & 1.062000e-02,1.000700e-02,8.725400e-03,5.946500e-03,5.343800e-03,&
     & 1.849700e-03,7.546000e-03,1.020300e-02,1.195500e-02,1.278600e-02,&
     & 1.271200e-02,1.185600e-02,1.029100e-02,7.144700e-03,6.171300e-03,&
     & 2.445500e-03,9.397700e-03,1.254800e-02,1.443400e-02,1.525200e-02,&
     & 1.509500e-02,1.398900e-02,1.206600e-02,8.351000e-03,7.116700e-03,&
     & 3.209300e-03,1.152300e-02,1.523200e-02,1.723500e-02,1.805100e-02,&
     & 1.781800e-02,1.640700e-02,1.400800e-02,9.705900e-03,8.263700e-03,&
     & 4.164000e-03,1.394700e-02,1.813800e-02,2.035300e-02,2.113300e-02,&
     & 2.084700e-02,1.906400e-02,1.618200e-02,1.121800e-02,9.521900e-03,&
     & 1.178400e-03,4.825900e-03,6.582400e-03,7.807600e-03,8.399700e-03,&
     & 8.401300e-03,7.958900e-03,6.903500e-03,4.797200e-03,4.153600e-03,&
     & 1.566000e-03,6.086700e-03,8.214600e-03,9.589200e-03,1.019700e-02,&
     & 1.011800e-02,9.481600e-03,8.171000e-03,5.731100e-03,4.785600e-03,&
     & 2.077100e-03,7.615600e-03,1.015100e-02,1.165500e-02,1.224400e-02,&
     & 1.210300e-02,1.124900e-02,9.621700e-03,6.705300e-03,5.526800e-03,&
     & 2.737100e-03,9.398600e-03,1.236200e-02,1.399600e-02,1.457300e-02,&
     & 1.439400e-02,1.327300e-02,1.124900e-02,7.808200e-03,6.414500e-03,&
     & 3.570700e-03,1.144100e-02,1.478200e-02,1.656900e-02,1.718500e-02,&
     & 1.695300e-02,1.551700e-02,1.307800e-02,9.055500e-03,7.409400e-03,&
     & 9.361200e-04,3.718100e-03,5.039000e-03,5.950200e-03,6.367900e-03,&
     & 6.378600e-03,6.069800e-03,5.272700e-03,3.712000e-03,3.220100e-03,&
     & 1.249000e-03,4.695700e-03,6.317600e-03,7.374500e-03,7.796600e-03,&
     & 7.736100e-03,7.275100e-03,6.274600e-03,4.449000e-03,3.684400e-03,&
     & 1.667200e-03,5.901700e-03,7.848700e-03,9.022300e-03,9.457300e-03,&
     & 9.328300e-03,8.699500e-03,7.430100e-03,5.189500e-03,4.240500e-03,&
     & 2.213400e-03,7.337100e-03,9.628100e-03,1.091100e-02,1.134600e-02,&
     & 1.118700e-02,1.034300e-02,8.752000e-03,6.106100e-03,4.888300e-03,&
     & 2.908000e-03,9.007800e-03,1.159600e-02,1.299000e-02,1.347400e-02,&
     & 1.330600e-02,1.220000e-02,1.025000e-02,7.074600e-03,5.639400e-03,&
     & 7.289900e-04,2.835800e-03,3.816600e-03,4.464900e-03,4.760500e-03,&
     & 4.777600e-03,4.564500e-03,3.990500e-03,2.817200e-03,2.525900e-03,&
     & 9.756200e-04,3.585800e-03,4.800000e-03,5.564300e-03,5.872900e-03,&
     & 5.834500e-03,5.510600e-03,4.766000e-03,3.336900e-03,2.874700e-03,&
     & 1.311000e-03,4.525200e-03,5.986100e-03,6.865400e-03,7.191200e-03,&
     & 7.089800e-03,6.625700e-03,5.678800e-03,3.946700e-03,3.301700e-03,&
     & 1.753500e-03,5.659200e-03,7.389500e-03,8.360000e-03,8.702800e-03,&
     & 8.572600e-03,7.954400e-03,6.741300e-03,4.702300e-03,3.792000e-03,&
     & 2.323400e-03,7.000100e-03,8.979500e-03,1.003300e-02,1.040700e-02,&
     & 1.026900e-02,9.469000e-03,7.945500e-03,5.445000e-03,4.372900e-03,&
     & 5.665000e-04,2.154900e-03,2.896400e-03,3.361900e-03,3.566400e-03,&
     & 3.584100e-03,3.432300e-03,3.020100e-03,2.257500e-03,2.054700e-03,&
     & 7.592300e-04,2.744900e-03,3.649400e-03,4.201000e-03,4.418000e-03,&
     & 4.395300e-03,4.167500e-03,3.621900e-03,2.547300e-03,2.304600e-03,&
     & 1.025300e-03,3.483400e-03,4.568600e-03,5.206900e-03,5.448100e-03,&
     & 5.375800e-03,5.040800e-03,4.335900e-03,3.016200e-03,2.619500e-03,&
     & 1.380100e-03,4.380400e-03,5.672500e-03,6.384100e-03,6.648500e-03,&
     & 6.545700e-03,6.091400e-03,5.182800e-03,3.563600e-03,2.997100e-03,&
     & 1.843400e-03,5.439100e-03,6.943400e-03,7.730700e-03,8.014300e-03,&
     & 7.890100e-03,7.307200e-03,6.154800e-03,4.178400e-03,3.450800e-03,&
     & 4.347900e-04,1.610500e-03,2.162400e-03,2.504800e-03,2.662900e-03,&
     & 2.683300e-03,2.573800e-03,2.273700e-03,1.860600e-03,1.723400e-03,&
     & 5.823300e-04,2.065000e-03,2.744400e-03,3.146400e-03,3.311200e-03,&
     & 3.296700e-03,3.129200e-03,2.733000e-03,1.914200e-03,1.918300e-03,&
     & 7.884300e-04,2.645700e-03,3.464600e-03,3.922100e-03,4.095400e-03,&
     & 4.044300e-03,3.806500e-03,3.287200e-03,2.247200e-03,2.160300e-03,&
     & 1.067600e-03,3.359900e-03,4.329400e-03,4.840600e-03,5.030600e-03,&
     & 4.952500e-03,4.623500e-03,3.953000e-03,2.677800e-03,2.463600e-03,&
     & 1.436000e-03,4.202800e-03,5.335500e-03,5.907500e-03,6.114800e-03,&
     & 6.007000e-03,5.577900e-03,4.730500e-03,3.193800e-03,2.820100e-03/
      data  absa(301:650,4) /                                           &
     & 3.306600e-04,1.192100e-03,1.599700e-03,1.850800e-03,1.975000e-03,&
     & 2.006500e-03,1.936200e-03,1.712100e-03,1.510200e-03,1.475500e-03,&
     & 4.425100e-04,1.539900e-03,2.043100e-03,2.338600e-03,2.469300e-03,&
     & 2.473100e-03,2.355900e-03,2.061900e-03,1.516700e-03,1.627800e-03,&
     & 5.995400e-04,1.989500e-03,2.599600e-03,2.938900e-03,3.076900e-03,&
     & 3.044900e-03,2.869600e-03,2.485400e-03,1.710000e-03,1.826100e-03,&
     & 8.153900e-04,2.554800e-03,3.283100e-03,3.660400e-03,3.800400e-03,&
     & 3.740600e-03,3.500400e-03,3.000900e-03,2.018500e-03,2.072300e-03,&
     & 1.103500e-03,3.229900e-03,4.085100e-03,4.505400e-03,4.650600e-03,&
     & 4.563600e-03,4.245800e-03,3.617000e-03,2.415000e-03,2.368900e-03,&
     & 2.482400e-04,8.757600e-04,1.175000e-03,1.362000e-03,1.459100e-03,&
     & 1.494400e-03,1.453000e-03,1.301600e-03,1.236200e-03,1.381500e-03,&
     & 3.323000e-04,1.139000e-03,1.510300e-03,1.730600e-03,1.832300e-03,&
     & 1.845400e-03,1.771500e-03,1.558800e-03,1.256700e-03,1.524100e-03,&
     & 4.503600e-04,1.483300e-03,1.939700e-03,2.191100e-03,2.298400e-03,&
     & 2.284300e-03,2.164400e-03,1.878600e-03,1.301000e-03,1.704700e-03,&
     & 6.142500e-04,1.925800e-03,2.473600e-03,2.752600e-03,2.861800e-03,&
     & 2.820800e-03,2.647400e-03,2.273800e-03,1.497700e-03,1.923100e-03,&
     & 8.357900e-04,2.467700e-03,3.110000e-03,3.420900e-03,3.532100e-03,&
     & 3.466400e-03,3.230200e-03,2.752900e-03,1.821100e-03,2.180200e-03,&
     & 1.864800e-04,6.421300e-04,8.624800e-04,1.001800e-03,1.075900e-03,&
     & 1.111400e-03,1.089300e-03,9.906400e-04,9.875300e-04,1.877500e-03,&
     & 2.493100e-04,8.384300e-04,1.113500e-03,1.277700e-03,1.354900e-03,&
     & 1.373500e-03,1.326700e-03,1.178400e-03,1.022500e-03,2.072500e-03,&
     & 3.373900e-04,1.099700e-03,1.438800e-03,1.627500e-03,1.709500e-03,&
     & 1.706400e-03,1.627600e-03,1.424400e-03,1.019600e-03,2.319600e-03,&
     & 4.600000e-04,1.441400e-03,1.853100e-03,2.063400e-03,2.145300e-03,&
     & 2.116200e-03,1.997000e-03,1.724800e-03,1.167700e-03,2.607800e-03,&
     & 6.281900e-04,1.870200e-03,2.357400e-03,2.590300e-03,2.670400e-03,&
     & 2.621400e-03,2.447700e-03,2.091400e-03,1.360800e-03,2.929400e-03,&
     & 1.430700e-04,4.798900e-04,6.452700e-04,7.515400e-04,8.096000e-04,&
     & 8.409000e-04,8.308600e-04,7.687400e-04,8.286300e-04,3.634700e-03,&
     & 1.910500e-04,6.285800e-04,8.350000e-04,9.599100e-04,1.018500e-03,&
     & 1.039300e-03,1.009500e-03,9.011800e-04,8.311400e-04,4.229400e-03,&
     & 2.581900e-04,8.297500e-04,1.084800e-03,1.229000e-03,1.290800e-03,&
     & 1.294300e-03,1.240700e-03,1.094700e-03,8.450700e-04,4.794200e-03,&
     & 3.517500e-04,1.096600e-03,1.409000e-03,1.569500e-03,1.630100e-03,&
     & 1.612500e-03,1.527100e-03,1.324400e-03,8.957400e-04,5.332600e-03,&
     & 4.814000e-04,1.435500e-03,1.809600e-03,1.989400e-03,2.047500e-03,&
     & 2.008000e-03,1.876800e-03,1.611800e-03,1.032300e-03,5.871200e-03,&
     & 1.248000e-04,4.065100e-04,5.431700e-04,6.305700e-04,6.771100e-04,&
     & 7.012400e-04,6.923000e-04,6.363700e-04,6.748000e-04,4.474800e-03,&
     & 1.678900e-04,5.365700e-04,7.067500e-04,8.079800e-04,8.557500e-04,&
     & 8.711600e-04,8.442200e-04,7.530600e-04,6.821900e-04,5.248400e-03,&
     & 2.274800e-04,7.132400e-04,9.243000e-04,1.039100e-03,1.088000e-03,&
     & 1.088500e-03,1.041400e-03,9.176100e-04,6.931000e-04,5.999700e-03,&
     & 3.110000e-04,9.466200e-04,1.206200e-03,1.334500e-03,1.380600e-03,&
     & 1.361600e-03,1.284200e-03,1.113200e-03,7.518300e-04,6.727500e-03,&
     & 4.263200e-04,1.237500e-03,1.550700e-03,1.699600e-03,1.742800e-03,&
     & 1.704600e-03,1.583500e-03,1.358000e-03,8.685200e-04,7.457200e-03,&
     & 1.073800e-04,3.437000e-04,4.556100e-04,5.271200e-04,5.651200e-04,&
     & 5.841800e-04,5.760800e-04,5.282400e-04,5.558400e-04,4.522900e-03,&
     & 1.450900e-04,4.571900e-04,5.962800e-04,6.780900e-04,7.169700e-04,&
     & 7.284800e-04,7.056500e-04,6.299700e-04,5.643600e-04,5.315600e-03,&
     & 1.978300e-04,6.116700e-04,7.848100e-04,8.776400e-04,9.147600e-04,&
     & 9.129800e-04,8.725200e-04,7.665200e-04,5.701100e-04,6.075700e-03,&
     & 2.719200e-04,8.117300e-04,1.026500e-03,1.133300e-03,1.168000e-03,&
     & 1.149000e-03,1.078400e-03,9.336100e-04,6.271800e-04,6.811300e-03,&
     & 3.739700e-04,1.059800e-03,1.319700e-03,1.444900e-03,1.479900e-03,&
     & 1.446500e-03,1.336200e-03,1.140700e-03,7.241500e-04,7.542500e-03,&
     & 8.929200e-05,2.871900e-04,3.786400e-04,4.369400e-04,4.687800e-04,&
     & 4.846100e-04,4.778800e-04,4.384200e-04,4.571900e-04,3.841600e-03,&
     & 1.214900e-04,3.853700e-04,4.991800e-04,5.655700e-04,5.969800e-04,&
     & 6.054900e-04,5.870800e-04,5.247200e-04,4.678700e-04,4.493100e-03,&
     & 1.671900e-04,5.175600e-04,6.604400e-04,7.366600e-04,7.659100e-04,&
     & 7.626000e-04,7.275300e-04,6.386700e-04,4.695400e-04,5.096100e-03,&
     & 2.316100e-04,6.875900e-04,8.643500e-04,9.538800e-04,9.829500e-04,&
     & 9.656800e-04,9.030000e-04,7.797900e-04,5.222700e-04,5.685500e-03,&
     & 3.205700e-04,8.992300e-04,1.113000e-03,1.217100e-03,1.246500e-03,&
     & 1.219300e-03,1.124500e-03,9.552100e-04,6.064600e-04,6.287500e-03/
      data  absa(1:300,5) /                                             &
     & 7.858100e-03,1.635900e-02,1.874700e-02,1.910400e-02,1.849300e-02,&
     & 1.745300e-02,1.612400e-02,1.443600e-02,9.963400e-03,9.026600e-03,&
     & 1.024800e-02,1.993000e-02,2.254300e-02,2.290100e-02,2.218700e-02,&
     & 2.095400e-02,1.937900e-02,1.719400e-02,1.196100e-02,1.070600e-02,&
     & 1.309600e-02,2.388800e-02,2.673900e-02,2.719500e-02,2.643300e-02,&
     & 2.493600e-02,2.304600e-02,2.029500e-02,1.410600e-02,1.254400e-02,&
     & 1.633800e-02,2.832900e-02,3.150000e-02,3.204700e-02,3.115100e-02,&
     & 2.939500e-02,2.725800e-02,2.390900e-02,1.647900e-02,1.454100e-02,&
     & 1.990500e-02,3.326700e-02,3.692500e-02,3.752300e-02,3.646000e-02,&
     & 3.448000e-02,3.193900e-02,2.792400e-02,1.909600e-02,1.682000e-02,&
     & 6.500000e-03,1.321000e-02,1.501700e-02,1.533800e-02,1.489400e-02,&
     & 1.404600e-02,1.288600e-02,1.148500e-02,7.839600e-03,6.983500e-03,&
     & 8.506000e-03,1.624600e-02,1.819600e-02,1.854600e-02,1.799900e-02,&
     & 1.696200e-02,1.557000e-02,1.375900e-02,9.500400e-03,8.252400e-03,&
     & 1.089500e-02,1.962900e-02,2.180100e-02,2.220200e-02,2.157100e-02,&
     & 2.028700e-02,1.861900e-02,1.633600e-02,1.131100e-02,9.676300e-03,&
     & 1.363400e-02,2.346700e-02,2.593800e-02,2.638500e-02,2.562600e-02,&
     & 2.403900e-02,2.210800e-02,1.932000e-02,1.327700e-02,1.125400e-02,&
     & 1.664300e-02,2.778900e-02,3.066600e-02,3.114900e-02,3.017800e-02,&
     & 2.831700e-02,2.602300e-02,2.264400e-02,1.543800e-02,1.305800e-02,&
     & 5.106800e-03,1.015500e-02,1.148500e-02,1.177000e-02,1.148400e-02,&
     & 1.082300e-02,9.862300e-03,8.759400e-03,5.995800e-03,5.261100e-03,&
     & 6.683500e-03,1.264000e-02,1.408400e-02,1.438200e-02,1.402300e-02,&
     & 1.319200e-02,1.201200e-02,1.056000e-02,7.291700e-03,6.186400e-03,&
     & 8.603300e-03,1.544400e-02,1.706900e-02,1.743700e-02,1.694000e-02,&
     & 1.590000e-02,1.446400e-02,1.261900e-02,8.811600e-03,7.253100e-03,&
     & 1.083200e-02,1.866500e-02,2.052100e-02,2.093900e-02,2.031400e-02,&
     & 1.900000e-02,1.728900e-02,1.501500e-02,1.035500e-02,8.472500e-03,&
     & 1.332800e-02,2.230700e-02,2.450800e-02,2.496700e-02,2.413500e-02,&
     & 2.249400e-02,2.048200e-02,1.771400e-02,1.216100e-02,9.854300e-03,&
     & 3.969500e-03,7.681800e-03,8.633100e-03,8.872800e-03,8.684700e-03,&
     & 8.174300e-03,7.417100e-03,6.573300e-03,4.675600e-03,4.039500e-03,&
     & 5.187100e-03,9.666900e-03,1.073000e-02,1.098400e-02,1.072700e-02,&
     & 1.007900e-02,9.113000e-03,7.964000e-03,5.523000e-03,4.745700e-03,&
     & 6.687200e-03,1.193600e-02,1.315000e-02,1.344700e-02,1.309000e-02,&
     & 1.226600e-02,1.108200e-02,9.581900e-03,6.723900e-03,5.558200e-03,&
     & 8.468600e-03,1.455800e-02,1.598200e-02,1.634600e-02,1.584100e-02,&
     & 1.478300e-02,1.333100e-02,1.147300e-02,7.945500e-03,6.500900e-03,&
     & 1.053000e-02,1.753200e-02,1.924500e-02,1.969700e-02,1.902100e-02,&
     & 1.766300e-02,1.591000e-02,1.364200e-02,9.417300e-03,7.563800e-03,&
     & 3.118000e-03,5.820900e-03,6.485400e-03,6.664400e-03,6.538000e-03,&
     & 6.141000e-03,5.560900e-03,4.918200e-03,3.596900e-03,3.158200e-03,&
     & 4.054900e-03,7.375700e-03,8.152000e-03,8.349700e-03,8.155000e-03,&
     & 7.643400e-03,6.893400e-03,5.984000e-03,4.129000e-03,3.694000e-03,&
     & 5.218000e-03,9.178700e-03,1.011600e-02,1.033500e-02,1.004800e-02,&
     & 9.405800e-03,8.459200e-03,7.244700e-03,5.047800e-03,4.330800e-03,&
     & 6.634700e-03,1.128500e-02,1.239200e-02,1.268000e-02,1.227400e-02,&
     & 1.144700e-02,1.027100e-02,8.731000e-03,6.084900e-03,5.069100e-03,&
     & 8.313100e-03,1.370600e-02,1.502300e-02,1.539400e-02,1.488000e-02,&
     & 1.381000e-02,1.235900e-02,1.045900e-02,7.253800e-03,5.908300e-03,&
     & 2.411300e-03,4.403500e-03,4.858400e-03,4.970200e-03,4.865200e-03,&
     & 4.563100e-03,4.128200e-03,3.647500e-03,2.649500e-03,2.638000e-03,&
     & 3.141700e-03,5.604100e-03,6.155200e-03,6.278800e-03,6.120900e-03,&
     & 5.727900e-03,5.162100e-03,4.464700e-03,3.133300e-03,3.049000e-03,&
     & 4.052300e-03,7.010700e-03,7.697400e-03,7.855600e-03,7.624900e-03,&
     & 7.122800e-03,6.398200e-03,5.441200e-03,3.735400e-03,3.535100e-03,&
     & 5.173500e-03,8.671400e-03,9.504600e-03,9.706200e-03,9.393700e-03,&
     & 8.751400e-03,7.842700e-03,6.599800e-03,4.623100e-03,4.093100e-03,&
     & 6.526600e-03,1.061500e-02,1.160300e-02,1.186200e-02,1.147000e-02,&
     & 1.066500e-02,9.530700e-03,7.958900e-03,5.490800e-03,4.735400e-03/
      data  absa(301:650,5) /                                           &
     & 1.831300e-03,3.298100e-03,3.633400e-03,3.706700e-03,3.620100e-03,&
     & 3.391200e-03,3.067900e-03,2.706600e-03,2.024100e-03,2.255400e-03,&
     & 2.397600e-03,4.244400e-03,4.644200e-03,4.721700e-03,4.591500e-03,&
     & 4.284700e-03,3.854600e-03,3.332800e-03,2.408100e-03,2.595400e-03,&
     & 3.118400e-03,5.355900e-03,5.846000e-03,5.945100e-03,5.758300e-03,&
     & 5.371700e-03,4.818000e-03,4.088800e-03,2.787900e-03,3.003200e-03,&
     & 4.021600e-03,6.660500e-03,7.270000e-03,7.400700e-03,7.154900e-03,&
     & 6.656100e-03,5.959900e-03,4.992900e-03,3.438400e-03,3.486000e-03,&
     & 5.120600e-03,8.212700e-03,8.936400e-03,9.094400e-03,8.796000e-03,&
     & 8.171700e-03,7.305900e-03,6.065100e-03,4.136200e-03,4.038300e-03,&
     & 1.367800e-03,2.434400e-03,2.677100e-03,2.731400e-03,2.676400e-03,&
     & 2.519900e-03,2.289200e-03,2.014600e-03,1.515800e-03,2.071700e-03,&
     & 1.798600e-03,3.172100e-03,3.469800e-03,3.532500e-03,3.438300e-03,&
     & 3.212500e-03,2.885300e-03,2.494000e-03,1.779000e-03,2.365300e-03,&
     & 2.364400e-03,4.058700e-03,4.419400e-03,4.491200e-03,4.350500e-03,&
     & 4.057400e-03,3.629400e-03,3.075300e-03,2.090800e-03,2.707500e-03,&
     & 3.088500e-03,5.105200e-03,5.551100e-03,5.635900e-03,5.446000e-03,&
     & 5.061700e-03,4.520200e-03,3.783400e-03,2.529300e-03,3.117800e-03,&
     & 3.984300e-03,6.352100e-03,6.878000e-03,6.972900e-03,6.737400e-03,&
     & 6.248400e-03,5.574600e-03,4.630400e-03,3.121600e-03,3.594400e-03,&
     & 1.018000e-03,1.780800e-03,1.951300e-03,1.991700e-03,1.957100e-03,&
     & 1.856800e-03,1.703400e-03,1.514300e-03,1.232400e-03,2.956600e-03,&
     & 1.340900e-03,2.349100e-03,2.564400e-03,2.610300e-03,2.551500e-03,&
     & 2.396900e-03,2.159600e-03,1.867900e-03,1.363200e-03,3.331700e-03,&
     & 1.777000e-03,3.045000e-03,3.309400e-03,3.364100e-03,3.269300e-03,&
     & 3.059000e-03,2.735800e-03,2.308300e-03,1.620400e-03,3.746400e-03,&
     & 2.352000e-03,3.880500e-03,4.209000e-03,4.272200e-03,4.136200e-03,&
     & 3.852100e-03,3.425600e-03,2.856800e-03,1.873200e-03,4.206100e-03,&
     & 3.072900e-03,4.885500e-03,5.277000e-03,5.337900e-03,5.158900e-03,&
     & 4.779000e-03,4.247800e-03,3.524100e-03,2.340000e-03,4.737400e-03,&
     & 7.725300e-04,1.321900e-03,1.442100e-03,1.474000e-03,1.453900e-03,&
     & 1.387600e-03,1.285300e-03,1.156700e-03,1.002200e-03,6.884700e-03,&
     & 1.017300e-03,1.762500e-03,1.920000e-03,1.955900e-03,1.917500e-03,&
     & 1.808700e-03,1.636700e-03,1.424200e-03,1.039400e-03,7.532800e-03,&
     & 1.356400e-03,2.312200e-03,2.509300e-03,2.549700e-03,2.484800e-03,&
     & 2.331200e-03,2.090200e-03,1.766800e-03,1.223000e-03,8.312600e-03,&
     & 1.813400e-03,2.983200e-03,3.226400e-03,3.275500e-03,3.178800e-03,&
     & 2.967200e-03,2.637300e-03,2.195600e-03,1.420600e-03,9.194900e-03,&
     & 2.398200e-03,3.802400e-03,4.092100e-03,4.137000e-03,4.002500e-03,&
     & 3.713200e-03,3.291300e-03,2.718700e-03,1.743700e-03,1.017400e-02,&
     & 6.631100e-04,1.123300e-03,1.221900e-03,1.248500e-03,1.229800e-03,&
     & 1.173100e-03,1.081800e-03,9.681200e-04,8.227700e-04,9.115100e-03,&
     & 8.796100e-04,1.504400e-03,1.632900e-03,1.663100e-03,1.627900e-03,&
     & 1.534600e-03,1.387800e-03,1.199000e-03,8.684400e-04,9.963600e-03,&
     & 1.183600e-03,1.981100e-03,2.144400e-03,2.178300e-03,2.121100e-03,&
     & 1.985900e-03,1.778000e-03,1.495200e-03,1.019000e-03,1.094100e-02,&
     & 1.590500e-03,2.571300e-03,2.769400e-03,2.808700e-03,2.723500e-03,&
     & 2.535700e-03,2.251200e-03,1.867600e-03,1.171800e-03,1.206000e-02,&
     & 2.111800e-03,3.300900e-03,3.529800e-03,3.554800e-03,3.436900e-03,&
     & 3.182100e-03,2.819400e-03,2.314100e-03,1.444200e-03,1.328500e-02,&
     & 5.647700e-04,9.505400e-04,1.032700e-03,1.054600e-03,1.037400e-03,&
     & 9.887000e-04,9.099200e-04,8.070100e-04,6.707600e-04,9.460700e-03,&
     & 7.572800e-04,1.278500e-03,1.387500e-03,1.411300e-03,1.378200e-03,&
     & 1.298600e-03,1.173100e-03,1.007400e-03,7.258900e-04,1.033100e-02,&
     & 1.026100e-03,1.692100e-03,1.829500e-03,1.857000e-03,1.805100e-03,&
     & 1.688800e-03,1.508600e-03,1.262600e-03,8.433900e-04,1.136800e-02,&
     & 1.386900e-03,2.209500e-03,2.373600e-03,2.400800e-03,2.324700e-03,&
     & 2.161500e-03,1.916700e-03,1.582100e-03,9.680900e-04,1.254500e-02,&
     & 1.843400e-03,2.858800e-03,3.042400e-03,3.052400e-03,2.944200e-03,&
     & 2.719400e-03,2.406800e-03,1.965600e-03,1.205700e-03,1.384600e-02,&
     & 4.727800e-04,7.955200e-04,8.650200e-04,8.833700e-04,8.688100e-04,&
     & 8.280200e-04,7.616400e-04,6.714600e-04,5.470600e-04,7.891200e-03,&
     & 6.417800e-04,1.075900e-03,1.168600e-03,1.188300e-03,1.160100e-03,&
     & 1.093500e-03,9.872500e-04,8.429400e-04,6.029400e-04,8.680500e-03,&
     & 8.775700e-04,1.432500e-03,1.548600e-03,1.569800e-03,1.526700e-03,&
     & 1.428300e-03,1.274400e-03,1.060400e-03,6.949700e-04,9.633700e-03,&
     & 1.191200e-03,1.885700e-03,2.022500e-03,2.038800e-03,1.972500e-03,&
     & 1.833400e-03,1.624700e-03,1.332600e-03,8.002600e-04,1.069400e-02,&
     & 1.584600e-03,2.454500e-03,2.607000e-03,2.609300e-03,2.511100e-03,&
     & 2.315100e-03,2.044100e-03,1.660600e-03,1.009100e-03,1.182800e-02/
      data  absa(1:300,6) /                                             &
     & 2.777800e-02,3.340500e-02,3.526700e-02,3.600600e-02,3.589800e-02,&
     & 3.455300e-02,3.110000e-02,2.501400e-02,1.809400e-02,1.679400e-02,&
     & 3.336600e-02,4.023500e-02,4.260800e-02,4.337000e-02,4.291400e-02,&
     & 4.124700e-02,3.706400e-02,2.994600e-02,2.194000e-02,2.009100e-02,&
     & 3.947600e-02,4.791900e-02,5.067000e-02,5.132100e-02,5.066400e-02,&
     & 4.861000e-02,4.379300e-02,3.548600e-02,2.622800e-02,2.381600e-02,&
     & 4.616500e-02,5.640600e-02,5.935300e-02,6.011700e-02,5.946800e-02,&
     & 5.691800e-02,5.132900e-02,4.164300e-02,3.115500e-02,2.822400e-02,&
     & 5.359000e-02,6.567600e-02,6.895600e-02,6.988200e-02,6.929900e-02,&
     & 6.613900e-02,5.973300e-02,4.863800e-02,3.670100e-02,3.321900e-02,&
     & 2.255900e-02,2.765400e-02,2.901500e-02,2.933700e-02,2.907800e-02,&
     & 2.793700e-02,2.518900e-02,2.040400e-02,1.414400e-02,1.290900e-02,&
     & 2.736100e-02,3.352300e-02,3.534000e-02,3.554000e-02,3.503700e-02,&
     & 3.357500e-02,3.023400e-02,2.455800e-02,1.735800e-02,1.545800e-02,&
     & 3.270200e-02,4.022200e-02,4.226600e-02,4.237000e-02,4.169000e-02,&
     & 3.988700e-02,3.594500e-02,2.924200e-02,2.087200e-02,1.838900e-02,&
     & 3.869800e-02,4.770300e-02,4.987400e-02,5.003700e-02,4.923400e-02,&
     & 4.700000e-02,4.235500e-02,3.446200e-02,2.493600e-02,2.187400e-02,&
     & 4.540600e-02,5.586400e-02,5.825000e-02,5.861100e-02,5.770100e-02,&
     & 5.494000e-02,4.954100e-02,4.042500e-02,2.949800e-02,2.582400e-02,&
     & 1.749200e-02,2.178700e-02,2.265200e-02,2.275000e-02,2.245300e-02,&
     & 2.153400e-02,1.949500e-02,1.581900e-02,1.060200e-02,9.536500e-03,&
     & 2.151900e-02,2.673100e-02,2.790200e-02,2.786400e-02,2.735500e-02,&
     & 2.615100e-02,2.362400e-02,1.918400e-02,1.314400e-02,1.142700e-02,&
     & 2.610400e-02,3.239100e-02,3.373600e-02,3.354500e-02,3.284600e-02,&
     & 3.137400e-02,2.829700e-02,2.299600e-02,1.596400e-02,1.363200e-02,&
     & 3.132700e-02,3.876700e-02,4.022700e-02,3.999300e-02,3.911400e-02,&
     & 3.726300e-02,3.356200e-02,2.729300e-02,1.923400e-02,1.628300e-02,&
     & 3.718200e-02,4.579100e-02,4.745200e-02,4.727000e-02,4.621100e-02,&
     & 4.390000e-02,3.950200e-02,3.218800e-02,2.290000e-02,1.932600e-02,&
     & 1.329100e-02,1.667800e-02,1.727500e-02,1.727800e-02,1.699300e-02,&
     & 1.628600e-02,1.482200e-02,1.199000e-02,7.757900e-03,7.148800e-03,&
     & 1.663000e-02,2.081500e-02,2.156800e-02,2.144000e-02,2.097300e-02,&
     & 2.000600e-02,1.812600e-02,1.465400e-02,9.832900e-03,8.520500e-03,&
     & 2.044400e-02,2.555300e-02,2.639700e-02,2.613200e-02,2.547100e-02,&
     & 2.422300e-02,2.191000e-02,1.772200e-02,1.215500e-02,1.014800e-02,&
     & 2.488700e-02,3.095900e-02,3.184700e-02,3.146900e-02,3.064100e-02,&
     & 2.905100e-02,2.619000e-02,2.121200e-02,1.476700e-02,1.211000e-02,&
     & 2.991200e-02,3.701000e-02,3.803100e-02,3.754600e-02,3.650900e-02,&
     & 3.452300e-02,3.100900e-02,2.516400e-02,1.770500e-02,1.442700e-02,&
     & 1.006600e-02,1.266800e-02,1.307100e-02,1.302900e-02,1.276500e-02,&
     & 1.221700e-02,1.114800e-02,9.002100e-03,5.758700e-03,5.420900e-03,&
     & 1.275700e-02,1.601500e-02,1.654400e-02,1.639700e-02,1.599000e-02,&
     & 1.523400e-02,1.378900e-02,1.110500e-02,7.396700e-03,6.504600e-03,&
     & 1.590100e-02,1.996300e-02,2.050800e-02,2.025400e-02,1.968200e-02,&
     & 1.864400e-02,1.682100e-02,1.355200e-02,9.235600e-03,7.781100e-03,&
     & 1.959600e-02,2.449900e-02,2.508200e-02,2.469600e-02,2.393600e-02,&
     & 2.258000e-02,2.026900e-02,1.634400e-02,1.132100e-02,9.316300e-03,&
     & 2.383000e-02,2.965000e-02,3.033400e-02,2.981100e-02,2.879200e-02,&
     & 2.707000e-02,2.416600e-02,1.953600e-02,1.366500e-02,1.111100e-02,&
     & 7.608700e-03,9.495100e-03,9.764900e-03,9.694300e-03,9.469100e-03,&
     & 9.031100e-03,8.224900e-03,6.652800e-03,4.337800e-03,4.262700e-03,&
     & 9.702900e-03,1.214600e-02,1.249500e-02,1.239400e-02,1.204700e-02,&
     & 1.143800e-02,1.032900e-02,8.294600e-03,5.426700e-03,5.054900e-03,&
     & 1.224100e-02,1.535300e-02,1.572900e-02,1.553400e-02,1.503900e-02,&
     & 1.418800e-02,1.272700e-02,1.021800e-02,6.880300e-03,6.022300e-03,&
     & 1.522200e-02,1.908800e-02,1.950400e-02,1.921300e-02,1.855000e-02,&
     & 1.737900e-02,1.548300e-02,1.243400e-02,8.517000e-03,7.208400e-03,&
     & 1.867700e-02,2.338400e-02,2.389200e-02,2.351000e-02,2.258100e-02,&
     & 2.103400e-02,1.863000e-02,1.498000e-02,1.041500e-02,8.605900e-03/
      data  absa(301:650,6) /                                           &
     & 5.782700e-03,7.131300e-03,7.280200e-03,7.204500e-03,6.995400e-03,&
     & 6.626900e-03,6.009700e-03,4.873100e-03,3.126400e-03,3.713700e-03,&
     & 7.408400e-03,9.188700e-03,9.400000e-03,9.309600e-03,9.030400e-03,&
     & 8.519000e-03,7.673300e-03,6.152500e-03,3.926300e-03,4.394400e-03,&
     & 9.404000e-03,1.171700e-02,1.197600e-02,1.183500e-02,1.143400e-02,&
     & 1.072600e-02,9.580400e-03,7.662700e-03,5.065600e-03,5.196100e-03,&
     & 1.177200e-02,1.473000e-02,1.504800e-02,1.485400e-02,1.430200e-02,&
     & 1.332000e-02,1.177900e-02,9.407400e-03,6.372500e-03,6.124900e-03,&
     & 1.453300e-02,1.823400e-02,1.865200e-02,1.841700e-02,1.765400e-02,&
     & 1.631900e-02,1.431700e-02,1.142200e-02,7.888100e-03,7.193100e-03,&
     & 4.347300e-03,5.353000e-03,5.445300e-03,5.377200e-03,5.186600e-03,&
     & 4.864700e-03,4.380800e-03,3.555900e-03,2.417300e-03,3.510800e-03,&
     & 5.653400e-03,6.960800e-03,7.094200e-03,6.993300e-03,6.748900e-03,&
     & 6.333000e-03,5.674500e-03,4.552000e-03,2.908100e-03,4.118000e-03,&
     & 7.223100e-03,8.949200e-03,9.115500e-03,8.977200e-03,8.651900e-03,&
     & 8.086500e-03,7.184200e-03,5.729800e-03,3.712600e-03,4.851000e-03,&
     & 9.098000e-03,1.132500e-02,1.155400e-02,1.140200e-02,1.096000e-02,&
     & 1.018200e-02,8.952100e-03,7.110300e-03,4.739900e-03,5.688000e-03,&
     & 1.130200e-02,1.412100e-02,1.445700e-02,1.430200e-02,1.370900e-02,&
     & 1.264400e-02,1.100700e-02,8.699300e-03,5.928100e-03,6.643600e-03,&
     & 3.216600e-03,3.963500e-03,4.042100e-03,3.993600e-03,3.844100e-03,&
     & 3.592300e-03,3.209700e-03,2.588600e-03,1.769300e-03,5.061500e-03,&
     & 4.255100e-03,5.249600e-03,5.343100e-03,5.263300e-03,5.054300e-03,&
     & 4.709000e-03,4.197900e-03,3.355600e-03,2.081100e-03,5.751700e-03,&
     & 5.517800e-03,6.831000e-03,6.948100e-03,6.818100e-03,6.534000e-03,&
     & 6.073300e-03,5.377500e-03,4.277900e-03,2.674400e-03,6.543600e-03,&
     & 7.023300e-03,8.712000e-03,8.869300e-03,8.720900e-03,8.351400e-03,&
     & 7.737600e-03,6.799200e-03,5.365300e-03,3.483600e-03,7.445800e-03,&
     & 8.790800e-03,1.093500e-02,1.115600e-02,1.101100e-02,1.055100e-02,&
     & 9.737700e-03,8.464300e-03,6.615700e-03,4.410500e-03,8.413100e-03,&
     & 2.403600e-03,2.962600e-03,3.027000e-03,2.989100e-03,2.878300e-03,&
     & 2.696600e-03,2.416700e-03,1.938400e-03,1.295000e-03,1.258000e-02,&
     & 3.230400e-03,3.993600e-03,4.069600e-03,4.006300e-03,3.844100e-03,&
     & 3.581700e-03,3.184100e-03,2.525800e-03,1.631800e-03,1.386700e-02,&
     & 4.245000e-03,5.271300e-03,5.371700e-03,5.268300e-03,5.033900e-03,&
     & 4.662500e-03,4.109100e-03,3.250900e-03,2.006500e-03,1.520400e-02,&
     & 5.474400e-03,6.806400e-03,6.923800e-03,6.791200e-03,6.490500e-03,&
     & 5.983800e-03,5.243900e-03,4.118800e-03,2.600200e-03,1.665200e-02,&
     & 6.935300e-03,8.607900e-03,8.763500e-03,8.618100e-03,8.234900e-03,&
     & 7.588600e-03,6.599400e-03,5.119200e-03,3.323900e-03,1.825100e-02,&
     & 2.064800e-03,2.548100e-03,2.600000e-03,2.560700e-03,2.463000e-03,&
     & 2.306900e-03,2.069200e-03,1.656200e-03,1.086000e-03,1.704900e-02,&
     & 2.785900e-03,3.454700e-03,3.523700e-03,3.459400e-03,3.314200e-03,&
     & 3.084100e-03,2.734500e-03,2.158400e-03,1.334100e-03,1.874700e-02,&
     & 3.677300e-03,4.576400e-03,4.663300e-03,4.575100e-03,4.372100e-03,&
     & 4.040500e-03,3.541900e-03,2.777100e-03,1.673000e-03,2.046000e-02,&
     & 4.764500e-03,5.926200e-03,6.030100e-03,5.910400e-03,5.646200e-03,&
     & 5.201700e-03,4.530600e-03,3.516300e-03,2.177500e-03,2.222500e-02,&
     & 6.067300e-03,7.519400e-03,7.659200e-03,7.514600e-03,7.160800e-03,&
     & 6.575000e-03,5.695400e-03,4.387700e-03,2.787800e-03,2.411200e-02,&
     & 1.764900e-03,2.184000e-03,2.227300e-03,2.189400e-03,2.102900e-03,&
     & 1.964700e-03,1.757000e-03,1.409200e-03,9.061200e-04,1.811600e-02,&
     & 2.391100e-03,2.972100e-03,3.030600e-03,2.977600e-03,2.851400e-03,&
     & 2.645000e-03,2.335100e-03,1.842400e-03,1.096800e-03,1.992900e-02,&
     & 3.173200e-03,3.950300e-03,4.021500e-03,3.944000e-03,3.772100e-03,&
     & 3.486300e-03,3.046500e-03,2.373800e-03,1.393100e-03,2.170700e-02,&
     & 4.132900e-03,5.137400e-03,5.222600e-03,5.116100e-03,4.882700e-03,&
     & 4.495000e-03,3.901900e-03,3.010600e-03,1.819900e-03,2.354200e-02,&
     & 5.297200e-03,6.540600e-03,6.663600e-03,6.531900e-03,6.206000e-03,&
     & 5.677900e-03,4.900600e-03,3.765300e-03,2.334000e-03,2.547800e-02,&
     & 1.491700e-03,1.853100e-03,1.892000e-03,1.862000e-03,1.786100e-03,&
     & 1.661700e-03,1.478800e-03,1.187300e-03,7.555000e-04,1.544400e-02,&
     & 2.033300e-03,2.534800e-03,2.583800e-03,2.540800e-03,2.432800e-03,&
     & 2.251400e-03,1.978300e-03,1.561100e-03,9.018700e-04,1.701500e-02,&
     & 2.715300e-03,3.387300e-03,3.443900e-03,3.376300e-03,3.226400e-03,&
     & 2.975000e-03,2.593200e-03,2.023900e-03,1.159700e-03,1.856400e-02,&
     & 3.562500e-03,4.424400e-03,4.497100e-03,4.402500e-03,4.190900e-03,&
     & 3.843600e-03,3.327700e-03,2.571900e-03,1.515900e-03,2.017600e-02,&
     & 4.591500e-03,5.659900e-03,5.762900e-03,5.640600e-03,5.342300e-03,&
     & 4.870000e-03,4.190700e-03,3.217100e-03,1.949700e-03,2.191300e-02/
      data  absa(1:300,7) /                                             &
     & 6.401300e-02,7.355900e-02,7.801600e-02,7.811000e-02,7.496300e-02,&
     & 6.893300e-02,6.075000e-02,4.887500e-02,3.930800e-02,3.656000e-02,&
     & 7.636300e-02,8.796000e-02,9.355900e-02,9.397900e-02,9.073400e-02,&
     & 8.334900e-02,7.319200e-02,5.877400e-02,4.744100e-02,4.403600e-02,&
     & 8.975800e-02,1.033100e-01,1.105100e-01,1.116900e-01,1.076900e-01,&
     & 9.867900e-02,8.672600e-02,6.981900e-02,5.665500e-02,5.267500e-02,&
     & 1.043300e-01,1.200800e-01,1.292800e-01,1.310500e-01,1.257600e-01,&
     & 1.154400e-01,1.016600e-01,8.224100e-02,6.714200e-02,6.252000e-02,&
     & 1.200100e-01,1.382400e-01,1.493200e-01,1.515800e-01,1.452600e-01,&
     & 1.337400e-01,1.180400e-01,9.595100e-02,7.901600e-02,7.373400e-02,&
     & 5.296800e-02,6.211600e-02,6.583500e-02,6.604400e-02,6.329400e-02,&
     & 5.816100e-02,5.117600e-02,4.139300e-02,3.113300e-02,2.825500e-02,&
     & 6.372800e-02,7.489900e-02,7.953600e-02,8.005700e-02,7.710100e-02,&
     & 7.083900e-02,6.217500e-02,5.010800e-02,3.779800e-02,3.418200e-02,&
     & 7.553200e-02,8.857200e-02,9.464800e-02,9.570000e-02,9.197300e-02,&
     & 8.444300e-02,7.408500e-02,5.991800e-02,4.542900e-02,4.106900e-02,&
     & 8.840400e-02,1.035600e-01,1.112400e-01,1.125900e-01,1.079800e-01,&
     & 9.924600e-02,8.737300e-02,7.099300e-02,5.411000e-02,4.892600e-02,&
     & 1.023500e-01,1.201000e-01,1.292600e-01,1.306400e-01,1.253700e-01,&
     & 1.155600e-01,1.020800e-01,8.320600e-02,6.403000e-02,5.794700e-02,&
     & 4.173500e-02,4.980300e-02,5.274100e-02,5.265700e-02,5.024900e-02,&
     & 4.611300e-02,4.058800e-02,3.298600e-02,2.352200e-02,2.088600e-02,&
     & 5.084100e-02,6.075700e-02,6.438900e-02,6.456400e-02,6.184400e-02,&
     & 5.679500e-02,4.985400e-02,4.040700e-02,2.885500e-02,2.544200e-02,&
     & 6.088900e-02,7.260300e-02,7.733400e-02,7.787600e-02,7.457400e-02,&
     & 6.838800e-02,6.003700e-02,4.882700e-02,3.500400e-02,3.075100e-02,&
     & 7.199200e-02,8.567500e-02,9.163400e-02,9.223300e-02,8.835600e-02,&
     & 8.106300e-02,7.139700e-02,5.837100e-02,4.197200e-02,3.682100e-02,&
     & 8.414400e-02,1.001900e-01,1.071300e-01,1.077400e-01,1.034500e-01,&
     & 9.514000e-02,8.407600e-02,6.889600e-02,4.994400e-02,4.383200e-02,&
     & 3.215400e-02,3.897000e-02,4.115000e-02,4.080200e-02,3.873400e-02,&
     & 3.546300e-02,3.118900e-02,2.544100e-02,1.742600e-02,1.534800e-02,&
     & 3.973900e-02,4.811500e-02,5.084600e-02,5.056700e-02,4.818800e-02,&
     & 4.414600e-02,3.876500e-02,3.162900e-02,2.172200e-02,1.882400e-02,&
     & 4.823200e-02,5.820200e-02,6.178600e-02,6.169100e-02,5.876900e-02,&
     & 5.380000e-02,4.723700e-02,3.862700e-02,2.659600e-02,2.290600e-02,&
     & 5.769300e-02,6.940300e-02,7.391200e-02,7.380100e-02,7.037000e-02,&
     & 6.448700e-02,5.673300e-02,4.660400e-02,3.215700e-02,2.758200e-02,&
     & 6.816200e-02,8.191000e-02,8.694300e-02,8.694700e-02,8.311600e-02,&
     & 7.635500e-02,6.738900e-02,5.547400e-02,3.850600e-02,3.298400e-02,&
     & 2.454300e-02,3.011400e-02,3.156400e-02,3.111400e-02,2.945300e-02,&
     & 2.688700e-02,2.357500e-02,1.932300e-02,1.279500e-02,1.169100e-02,&
     & 3.084300e-02,3.771900e-02,3.954000e-02,3.906500e-02,3.707900e-02,&
     & 3.384500e-02,2.967900e-02,2.436700e-02,1.628200e-02,1.428300e-02,&
     & 3.798900e-02,4.614100e-02,4.860100e-02,4.816400e-02,4.569100e-02,&
     & 4.169700e-02,3.659900e-02,3.011000e-02,2.023000e-02,1.731600e-02,&
     & 4.599700e-02,5.563900e-02,5.873800e-02,5.821700e-02,5.529300e-02,&
     & 5.055100e-02,4.447400e-02,3.667500e-02,2.467900e-02,2.082400e-02,&
     & 5.498000e-02,6.633500e-02,6.968900e-02,6.922000e-02,6.593400e-02,&
     & 6.047700e-02,5.335600e-02,4.402300e-02,2.973500e-02,2.492500e-02,&
     & 1.842600e-02,2.276100e-02,2.364100e-02,2.322600e-02,2.192900e-02,&
     & 1.996800e-02,1.746700e-02,1.434700e-02,9.180700e-03,8.844100e-03,&
     & 2.357800e-02,2.903200e-02,3.013300e-02,2.960600e-02,2.799600e-02,&
     & 2.549500e-02,2.229800e-02,1.836300e-02,1.212900e-02,1.095000e-02,&
     & 2.950700e-02,3.604700e-02,3.750800e-02,3.691300e-02,3.488600e-02,&
     & 3.178600e-02,2.784400e-02,2.296500e-02,1.529200e-02,1.340900e-02,&
     & 3.626600e-02,4.401500e-02,4.586500e-02,4.510300e-02,4.267500e-02,&
     & 3.898200e-02,3.426100e-02,2.827900e-02,1.885300e-02,1.621400e-02,&
     & 4.398400e-02,5.304100e-02,5.501700e-02,5.412900e-02,5.142900e-02,&
     & 4.716100e-02,4.156400e-02,3.427000e-02,2.288200e-02,1.944600e-02/
      data  absa(301:650,7) /                                           &
     & 1.376400e-02,1.698000e-02,1.748800e-02,1.710800e-02,1.610600e-02,&
     & 1.466000e-02,1.281100e-02,1.050800e-02,6.585800e-03,7.397900e-03,&
     & 1.790500e-02,2.204900e-02,2.270800e-02,2.221300e-02,2.091200e-02,&
     & 1.901500e-02,1.659400e-02,1.361600e-02,8.992500e-03,8.912700e-03,&
     & 2.278100e-02,2.783400e-02,2.870700e-02,2.808900e-02,2.643600e-02,&
     & 2.403600e-02,2.100100e-02,1.724300e-02,1.155000e-02,1.072700e-02,&
     & 2.846600e-02,3.447300e-02,3.549900e-02,3.468100e-02,3.269500e-02,&
     & 2.980300e-02,2.613800e-02,2.150400e-02,1.443200e-02,1.288800e-02,&
     & 3.508700e-02,4.209100e-02,4.309600e-02,4.205700e-02,3.978100e-02,&
     & 3.645600e-02,3.208900e-02,2.635600e-02,1.766500e-02,1.541900e-02,&
     & 1.035300e-02,1.261400e-02,1.288200e-02,1.250700e-02,1.173700e-02,&
     & 1.067500e-02,9.309300e-03,7.625700e-03,4.611600e-03,7.361500e-03,&
     & 1.358700e-02,1.662500e-02,1.698800e-02,1.653900e-02,1.552100e-02,&
     & 1.407500e-02,1.225200e-02,1.000800e-02,6.574200e-03,8.818300e-03,&
     & 1.755100e-02,2.131000e-02,2.182100e-02,2.126200e-02,1.993700e-02,&
     & 1.806600e-02,1.572100e-02,1.283900e-02,8.665300e-03,1.045800e-02,&
     & 2.226500e-02,2.681400e-02,2.735700e-02,2.660000e-02,2.497600e-02,&
     & 2.267000e-02,1.979600e-02,1.619300e-02,1.097900e-02,1.233200e-02,&
     & 2.786200e-02,3.321800e-02,3.366200e-02,3.263400e-02,3.070300e-02,&
     & 2.802100e-02,2.458100e-02,2.010200e-02,1.358900e-02,1.441300e-02,&
     & 7.878100e-03,9.435700e-03,9.508200e-03,9.156700e-03,8.545500e-03,&
     & 7.711500e-03,6.698700e-03,5.466800e-03,3.237500e-03,1.069000e-02,&
     & 1.037800e-02,1.253200e-02,1.269200e-02,1.226000e-02,1.145000e-02,&
     & 1.034200e-02,8.958200e-03,7.295600e-03,4.723600e-03,1.233000e-02,&
     & 1.349500e-02,1.627000e-02,1.651600e-02,1.600000e-02,1.495500e-02,&
     & 1.348500e-02,1.167500e-02,9.474400e-03,6.392900e-03,1.416000e-02,&
     & 1.731500e-02,2.076100e-02,2.102600e-02,2.032600e-02,1.900900e-02,&
     & 1.716400e-02,1.488400e-02,1.209100e-02,8.253200e-03,1.622900e-02,&
     & 2.195000e-02,2.607900e-02,2.624200e-02,2.530100e-02,2.364500e-02,&
     & 2.144300e-02,1.868400e-02,1.520300e-02,1.036100e-02,1.862300e-02,&
     & 6.091200e-03,7.261800e-03,7.249700e-03,6.936800e-03,6.425100e-03,&
     & 5.738100e-03,4.922400e-03,3.987000e-03,2.327900e-03,2.440600e-02,&
     & 8.123700e-03,9.706100e-03,9.737500e-03,9.338800e-03,8.659100e-03,&
     & 7.750500e-03,6.664200e-03,5.399700e-03,3.351300e-03,2.655900e-02,&
     & 1.064300e-02,1.268000e-02,1.276700e-02,1.229200e-02,1.141600e-02,&
     & 1.023500e-02,8.804200e-03,7.107700e-03,4.742300e-03,2.916600e-02,&
     & 1.374500e-02,1.632700e-02,1.643200e-02,1.580300e-02,1.468000e-02,&
     & 1.319600e-02,1.136800e-02,9.159100e-03,6.257600e-03,3.214000e-02,&
     & 1.751500e-02,2.072600e-02,2.077800e-02,1.993600e-02,1.850300e-02,&
     & 1.667900e-02,1.441900e-02,1.164200e-02,7.965600e-03,3.544500e-02,&
     & 5.354900e-03,6.381600e-03,6.366000e-03,6.084000e-03,5.615600e-03,&
     & 4.982500e-03,4.230300e-03,3.379500e-03,1.974900e-03,3.236700e-02,&
     & 7.201300e-03,8.560400e-03,8.553200e-03,8.176300e-03,7.542100e-03,&
     & 6.699700e-03,5.706500e-03,4.572900e-03,2.863200e-03,3.519600e-02,&
     & 9.502200e-03,1.120200e-02,1.120400e-02,1.071600e-02,9.900000e-03,&
     & 8.823000e-03,7.539400e-03,6.033100e-03,4.023600e-03,3.863800e-02,&
     & 1.228800e-02,1.443200e-02,1.442400e-02,1.379100e-02,1.273500e-02,&
     & 1.138700e-02,9.760800e-03,7.810300e-03,5.323400e-03,4.250700e-02,&
     & 1.556700e-02,1.829500e-02,1.826100e-02,1.746000e-02,1.614500e-02,&
     & 1.446900e-02,1.244800e-02,9.947700e-03,6.780000e-03,4.670300e-02,&
     & 4.661000e-03,5.545400e-03,5.531500e-03,5.283800e-03,4.875900e-03,&
     & 4.325400e-03,3.658300e-03,2.882100e-03,1.668100e-03,3.434700e-02,&
     & 6.328500e-03,7.486400e-03,7.468200e-03,7.126600e-03,6.559000e-03,&
     & 5.811100e-03,4.923200e-03,3.890100e-03,2.426300e-03,3.772300e-02,&
     & 8.411400e-03,9.872500e-03,9.830300e-03,9.356200e-03,8.604400e-03,&
     & 7.637000e-03,6.494600e-03,5.144700e-03,3.414400e-03,4.164500e-02,&
     & 1.087700e-02,1.273000e-02,1.266200e-02,1.205600e-02,1.109300e-02,&
     & 9.874100e-03,8.435200e-03,6.686500e-03,4.514600e-03,4.583600e-02,&
     & 1.374700e-02,1.607400e-02,1.598300e-02,1.525700e-02,1.409800e-02,&
     & 1.261200e-02,1.079900e-02,8.534700e-03,5.746100e-03,5.029500e-02,&
     & 4.007900e-03,4.756000e-03,4.741700e-03,4.525100e-03,4.176300e-03,&
     & 3.716200e-03,3.148800e-03,2.461000e-03,1.398300e-03,2.979700e-02,&
     & 5.497500e-03,6.479100e-03,6.446700e-03,6.139900e-03,5.650200e-03,&
     & 5.014000e-03,4.245100e-03,3.317500e-03,2.046500e-03,3.307400e-02,&
     & 7.317300e-03,8.591300e-03,8.537700e-03,8.119200e-03,7.453900e-03,&
     & 6.607500e-03,5.606300e-03,4.394000e-03,2.877200e-03,3.670900e-02,&
     & 9.474300e-03,1.109000e-02,1.100200e-02,1.046800e-02,9.635600e-03,&
     & 8.579200e-03,7.299300e-03,5.731400e-03,3.802500e-03,4.054700e-02,&
     & 1.201300e-02,1.399400e-02,1.387900e-02,1.322800e-02,1.223400e-02,&
     & 1.096400e-02,9.366200e-03,7.336300e-03,4.841200e-03,4.459300e-02/
      data  absa(1:300,8) /                                             &
     & 1.604300e-01,1.595500e-01,1.574400e-01,1.520300e-01,1.439100e-01,&
     & 1.326600e-01,1.182600e-01,1.064700e-01,1.037100e-01,1.014400e-01,&
     & 1.921900e-01,1.920000e-01,1.894400e-01,1.830900e-01,1.732400e-01,&
     & 1.605400e-01,1.444300e-01,1.309500e-01,1.267200e-01,1.241000e-01,&
     & 2.262900e-01,2.270000e-01,2.242400e-01,2.171900e-01,2.062500e-01,&
     & 1.928000e-01,1.741000e-01,1.585100e-01,1.523800e-01,1.492400e-01,&
     & 2.630200e-01,2.648700e-01,2.621400e-01,2.547000e-01,2.437100e-01,&
     & 2.288200e-01,2.069200e-01,1.891400e-01,1.809800e-01,1.774800e-01,&
     & 3.019500e-01,3.053800e-01,3.029900e-01,2.958400e-01,2.847100e-01,&
     & 2.679300e-01,2.428500e-01,2.230100e-01,2.133600e-01,2.095200e-01,&
     & 1.384600e-01,1.402200e-01,1.400300e-01,1.358200e-01,1.290000e-01,&
     & 1.196500e-01,1.066800e-01,9.105900e-02,8.558500e-02,8.163600e-02,&
     & 1.671500e-01,1.698500e-01,1.697100e-01,1.648400e-01,1.566800e-01,&
     & 1.456400e-01,1.309300e-01,1.128500e-01,1.055500e-01,1.007900e-01,&
     & 1.980300e-01,2.024400e-01,2.021100e-01,1.969000e-01,1.880100e-01,&
     & 1.755800e-01,1.585100e-01,1.371900e-01,1.276100e-01,1.219300e-01,&
     & 2.313300e-01,2.377700e-01,2.378200e-01,2.325400e-01,2.235100e-01,&
     & 2.094600e-01,1.889000e-01,1.639700e-01,1.519600e-01,1.455700e-01,&
     & 2.671100e-01,2.754200e-01,2.766800e-01,2.718500e-01,2.623200e-01,&
     & 2.462100e-01,2.219700e-01,1.937100e-01,1.795300e-01,1.723100e-01,&
     & 1.127200e-01,1.164800e-01,1.174200e-01,1.145200e-01,1.092900e-01,&
     & 1.015800e-01,9.037600e-02,7.463700e-02,6.642900e-02,6.150600e-02,&
     & 1.374900e-01,1.427300e-01,1.438600e-01,1.405200e-01,1.341700e-01,&
     & 1.251000e-01,1.119300e-01,9.336100e-02,8.289300e-02,7.681900e-02,&
     & 1.646900e-01,1.717900e-01,1.731400e-01,1.694400e-01,1.626100e-01,&
     & 1.521600e-01,1.367400e-01,1.143100e-01,1.011000e-01,9.370200e-02,&
     & 1.942200e-01,2.035600e-01,2.055500e-01,2.020300e-01,1.949100e-01,&
     & 1.828500e-01,1.641400e-01,1.375400e-01,1.215100e-01,1.128600e-01,&
     & 2.262300e-01,2.378100e-01,2.411600e-01,2.382900e-01,2.304900e-01,&
     & 2.161000e-01,1.939700e-01,1.634700e-01,1.444200e-01,1.344900e-01,&
     & 8.905100e-02,9.414800e-02,9.537600e-02,9.349000e-02,8.956400e-02,&
     & 8.312300e-02,7.382500e-02,6.044000e-02,5.001800e-02,4.524100e-02,&
     & 1.098400e-01,1.166700e-01,1.183700e-01,1.162400e-01,1.114200e-01,&
     & 1.038300e-01,9.268600e-02,7.638400e-02,6.330700e-02,5.715800e-02,&
     & 1.332100e-01,1.418800e-01,1.440300e-01,1.417300e-01,1.364100e-01,&
     & 1.277900e-01,1.143900e-01,9.437500e-02,7.806600e-02,7.049700e-02,&
     & 1.589100e-01,1.698400e-01,1.726500e-01,1.706900e-01,1.649700e-01,&
     & 1.550500e-01,1.386200e-01,1.143900e-01,9.469000e-02,8.563500e-02,&
     & 1.869000e-01,2.003100e-01,2.045900e-01,2.030600e-01,1.967300e-01,&
     & 1.846300e-01,1.652400e-01,1.366900e-01,1.133000e-01,1.028900e-01,&
     & 6.920300e-02,7.477900e-02,7.598300e-02,7.484000e-02,7.156700e-02,&
     & 6.639800e-02,5.886500e-02,4.819300e-02,3.718800e-02,3.316900e-02,&
     & 8.643000e-02,9.381700e-02,9.558700e-02,9.432200e-02,9.045600e-02,&
     & 8.412400e-02,7.501600e-02,6.161500e-02,4.774400e-02,4.231700e-02,&
     & 1.060800e-01,1.154200e-01,1.177200e-01,1.163600e-01,1.121800e-01,&
     & 1.047900e-01,9.378400e-02,7.699600e-02,5.954500e-02,5.265600e-02,&
     & 1.280800e-01,1.397400e-01,1.426200e-01,1.414800e-01,1.370300e-01,&
     & 1.284500e-01,1.148500e-01,9.418400e-02,7.283800e-02,6.451600e-02,&
     & 1.522400e-01,1.664800e-01,1.708100e-01,1.699000e-01,1.647100e-01,&
     & 1.544200e-01,1.382100e-01,1.134700e-01,8.795600e-02,7.819500e-02,&
     & 5.271100e-02,5.799400e-02,5.909600e-02,5.809000e-02,5.543000e-02,&
     & 5.135400e-02,4.551500e-02,3.727100e-02,2.703000e-02,2.504000e-02,&
     & 6.671900e-02,7.370000e-02,7.536700e-02,7.431100e-02,7.115600e-02,&
     & 6.606800e-02,5.885300e-02,4.836900e-02,3.530100e-02,3.174400e-02,&
     & 8.286300e-02,9.175800e-02,9.394700e-02,9.297900e-02,8.950000e-02,&
     & 8.346800e-02,7.460900e-02,6.132800e-02,4.468300e-02,3.944000e-02,&
     & 1.013200e-01,1.123400e-01,1.152000e-01,1.144300e-01,1.105900e-01,&
     & 1.035300e-01,9.248900e-02,7.583300e-02,5.531800e-02,4.840600e-02,&
     & 1.218500e-01,1.353800e-01,1.394500e-01,1.389500e-01,1.343300e-01,&
     & 1.257200e-01,1.124300e-01,9.211200e-02,6.749200e-02,5.887000e-02/
      data  absa(301:650,8) /                                           &
     & 3.956200e-02,4.427600e-02,4.510900e-02,4.418700e-02,4.208200e-02,&
     & 3.885900e-02,3.445400e-02,2.822400e-02,1.938400e-02,1.932100e-02,&
     & 5.087900e-02,5.705500e-02,5.839900e-02,5.736700e-02,5.480200e-02,&
     & 5.078900e-02,4.523200e-02,3.727300e-02,2.580600e-02,2.486900e-02,&
     & 6.400300e-02,7.199600e-02,7.376400e-02,7.277400e-02,6.984700e-02,&
     & 6.507800e-02,5.812500e-02,4.794700e-02,3.320500e-02,3.117300e-02,&
     & 7.917300e-02,8.923900e-02,9.161700e-02,9.075000e-02,8.739600e-02,&
     & 8.172000e-02,7.303100e-02,6.001300e-02,4.167400e-02,3.829700e-02,&
     & 9.635000e-02,1.087700e-01,1.121400e-01,1.114800e-01,1.074000e-01,&
     & 1.003000e-01,8.964500e-02,7.370300e-02,5.141300e-02,4.621700e-02,&
     & 2.937400e-02,3.335800e-02,3.391000e-02,3.317600e-02,3.148800e-02,&
     & 2.900200e-02,2.565100e-02,2.099800e-02,1.379000e-02,1.793100e-02,&
     & 3.845300e-02,4.373200e-02,4.461900e-02,4.367600e-02,4.158600e-02,&
     & 3.849100e-02,3.423400e-02,2.823600e-02,1.882600e-02,2.188200e-02,&
     & 4.907500e-02,5.593600e-02,5.713900e-02,5.613800e-02,5.370800e-02,&
     & 4.995300e-02,4.464600e-02,3.688700e-02,2.466200e-02,2.659100e-02,&
     & 6.143700e-02,7.014000e-02,7.190200e-02,7.091900e-02,6.802700e-02,&
     & 6.350800e-02,5.679300e-02,4.682200e-02,3.140500e-02,3.212000e-02,&
     & 7.564800e-02,8.645500e-02,8.905900e-02,8.813800e-02,8.461200e-02,&
     & 7.882600e-02,7.047400e-02,5.812100e-02,3.920300e-02,3.869300e-02,&
     & 2.163100e-02,2.476200e-02,2.509100e-02,2.451900e-02,2.324500e-02,&
     & 2.134300e-02,1.881000e-02,1.537300e-02,9.764100e-03,2.927300e-02,&
     & 2.881300e-02,3.308400e-02,3.362100e-02,3.284200e-02,3.120100e-02,&
     & 2.876900e-02,2.551600e-02,2.101800e-02,1.370700e-02,3.381300e-02,&
     & 3.740800e-02,4.298400e-02,4.369600e-02,4.273700e-02,4.078700e-02,&
     & 3.784700e-02,3.377700e-02,2.790500e-02,1.831100e-02,3.901000e-02,&
     & 4.750200e-02,5.459800e-02,5.565000e-02,5.465400e-02,5.229200e-02,&
     & 4.870100e-02,4.352800e-02,3.595600e-02,2.366000e-02,4.468400e-02,&
     & 5.918400e-02,6.807500e-02,6.973700e-02,6.871600e-02,6.578800e-02,&
     & 6.114800e-02,5.466400e-02,4.521600e-02,2.987800e-02,5.082900e-02,&
     & 1.642000e-02,1.869300e-02,1.885600e-02,1.833400e-02,1.734100e-02,&
     & 1.593000e-02,1.401300e-02,1.140300e-02,7.064000e-03,7.053200e-02,&
     & 2.204000e-02,2.531700e-02,2.563200e-02,2.500900e-02,2.370200e-02,&
     & 2.179700e-02,1.927300e-02,1.581000e-02,1.020400e-02,7.682700e-02,&
     & 2.896800e-02,3.341800e-02,3.380500e-02,3.296300e-02,3.135800e-02,&
     & 2.900700e-02,2.581000e-02,2.126600e-02,1.388600e-02,8.369100e-02,&
     & 3.728500e-02,4.300000e-02,4.352900e-02,4.256200e-02,4.063500e-02,&
     & 3.770400e-02,3.361700e-02,2.778100e-02,1.817700e-02,9.145700e-02,&
     & 4.708500e-02,5.424800e-02,5.508900e-02,5.402700e-02,5.157300e-02,&
     & 4.782800e-02,4.267100e-02,3.532600e-02,2.319800e-02,9.989800e-02,&
     & 1.456300e-02,1.648000e-02,1.652000e-02,1.597200e-02,1.505400e-02,&
     & 1.380000e-02,1.215100e-02,9.849800e-03,6.152900e-03,9.302500e-02,&
     & 1.942200e-02,2.223000e-02,2.236500e-02,2.174200e-02,2.057500e-02,&
     & 1.892000e-02,1.670200e-02,1.364900e-02,8.859300e-03,9.975300e-02,&
     & 2.547100e-02,2.935100e-02,2.954500e-02,2.876600e-02,2.727600e-02,&
     & 2.515000e-02,2.231900e-02,1.833000e-02,1.204400e-02,1.070800e-01,&
     & 3.287700e-02,3.791300e-02,3.817200e-02,3.720000e-02,3.534500e-02,&
     & 3.264000e-02,2.901000e-02,2.391200e-02,1.575000e-02,1.155100e-01,&
     & 4.178300e-02,4.807000e-02,4.847800e-02,4.721100e-02,4.484200e-02,&
     & 4.143100e-02,3.682200e-02,3.042600e-02,2.011700e-02,1.249300e-01,&
     & 1.296800e-02,1.461300e-02,1.451800e-02,1.396500e-02,1.310800e-02,&
     & 1.196500e-02,1.048000e-02,8.466100e-03,5.328100e-03,9.622400e-02,&
     & 1.722600e-02,1.960700e-02,1.958900e-02,1.895500e-02,1.787700e-02,&
     & 1.639000e-02,1.440100e-02,1.171400e-02,7.642300e-03,1.028100e-01,&
     & 2.256100e-02,2.583200e-02,2.588700e-02,2.513000e-02,2.374600e-02,&
     & 2.176000e-02,1.918400e-02,1.570100e-02,1.035900e-02,1.104200e-01,&
     & 2.920800e-02,3.351700e-02,3.359200e-02,3.256100e-02,3.075100e-02,&
     & 2.822100e-02,2.490600e-02,2.046500e-02,1.356400e-02,1.194300e-01,&
     & 3.731500e-02,4.278200e-02,4.286300e-02,4.141400e-02,3.908300e-02,&
     & 3.586300e-02,3.166100e-02,2.608700e-02,1.734800e-02,1.294100e-01,&
     & 1.143100e-02,1.289600e-02,1.273600e-02,1.219900e-02,1.140200e-02,&
     & 1.034500e-02,9.000300e-03,7.228700e-03,4.582400e-03,8.051900e-02,&
     & 1.520600e-02,1.725800e-02,1.715800e-02,1.653900e-02,1.553100e-02,&
     & 1.414000e-02,1.233800e-02,9.983000e-03,6.546400e-03,8.686300e-02,&
     & 1.997200e-02,2.277700e-02,2.271300e-02,2.194000e-02,2.063100e-02,&
     & 1.877000e-02,1.641500e-02,1.336400e-02,8.869300e-03,9.442000e-02,&
     & 2.594700e-02,2.969800e-02,2.963400e-02,2.854200e-02,2.676200e-02,&
     & 2.436100e-02,2.133800e-02,1.742400e-02,1.163300e-02,1.032900e-01,&
     & 3.334200e-02,3.808200e-02,3.794200e-02,3.648200e-02,3.416800e-02,&
     & 3.108000e-02,2.722400e-02,2.226600e-02,1.489600e-02,1.129900e-01/
      data  absa(1:300,9) /                                             &
     & 3.539900e-01,3.312100e-01,3.248600e-01,3.188000e-01,3.182200e-01,&
     & 3.244200e-01,3.358600e-01,3.426900e-01,3.350100e-01,3.368500e-01,&
     & 4.265100e-01,4.005500e-01,3.946100e-01,3.889000e-01,3.892000e-01,&
     & 3.961300e-01,4.080200e-01,4.144500e-01,4.064000e-01,4.086700e-01,&
     & 5.053900e-01,4.763900e-01,4.709000e-01,4.653800e-01,4.672400e-01,&
     & 4.747200e-01,4.883000e-01,4.947900e-01,4.877000e-01,4.908300e-01,&
     & 5.905800e-01,5.585000e-01,5.537300e-01,5.489900e-01,5.526400e-01,&
     & 5.623300e-01,5.791100e-01,5.848600e-01,5.802000e-01,5.841700e-01,&
     & 6.814400e-01,6.461800e-01,6.428000e-01,6.402800e-01,6.469300e-01,&
     & 6.602600e-01,6.799300e-01,6.860800e-01,6.851900e-01,6.903700e-01,&
     & 3.419000e-01,3.232700e-01,3.181900e-01,3.093600e-01,3.038400e-01,&
     & 3.026300e-01,3.047200e-01,3.075400e-01,2.990100e-01,2.984400e-01,&
     & 4.149300e-01,3.938900e-01,3.889500e-01,3.791300e-01,3.729200e-01,&
     & 3.713200e-01,3.729200e-01,3.743600e-01,3.646200e-01,3.637400e-01,&
     & 4.952400e-01,4.714400e-01,4.668100e-01,4.555600e-01,4.490100e-01,&
     & 4.473000e-01,4.494100e-01,4.498000e-01,4.397500e-01,4.388800e-01,&
     & 5.825800e-01,5.562000e-01,5.513000e-01,5.397400e-01,5.328600e-01,&
     & 5.322100e-01,5.356100e-01,5.353000e-01,5.264100e-01,5.253200e-01,&
     & 6.754900e-01,6.470000e-01,6.419100e-01,6.313400e-01,6.256200e-01,&
     & 6.264400e-01,6.314100e-01,6.314800e-01,6.252000e-01,6.242300e-01,&
     & 3.132200e-01,2.990500e-01,2.947500e-01,2.871400e-01,2.777700e-01,&
     & 2.705600e-01,2.647100e-01,2.616900e-01,2.525100e-01,2.487400e-01,&
     & 3.843300e-01,3.685200e-01,3.647800e-01,3.551700e-01,3.441000e-01,&
     & 3.355200e-01,3.276300e-01,3.219800e-01,3.106500e-01,3.061900e-01,&
     & 4.627900e-01,4.453800e-01,4.424300e-01,4.303600e-01,4.173100e-01,&
     & 4.079500e-01,3.981300e-01,3.900800e-01,3.772100e-01,3.726000e-01,&
     & 5.492600e-01,5.299600e-01,5.272400e-01,5.132000e-01,4.984000e-01,&
     & 4.889400e-01,4.783700e-01,4.678000e-01,4.540100e-01,4.483500e-01,&
     & 6.419400e-01,6.215200e-01,6.186200e-01,6.032700e-01,5.876700e-01,&
     & 5.786400e-01,5.681800e-01,5.548700e-01,5.417600e-01,5.353300e-01,&
     & 2.776800e-01,2.676000e-01,2.657200e-01,2.598000e-01,2.489600e-01,&
     & 2.379500e-01,2.258400e-01,2.155300e-01,2.056700e-01,1.999400e-01,&
     & 3.462800e-01,3.351800e-01,3.331200e-01,3.257300e-01,3.123800e-01,&
     & 2.984800e-01,2.833200e-01,2.693400e-01,2.564100e-01,2.496900e-01,&
     & 4.216600e-01,4.101800e-01,4.084600e-01,3.989600e-01,3.828800e-01,&
     & 3.661700e-01,3.480400e-01,3.304900e-01,3.148500e-01,3.068800e-01,&
     & 5.048000e-01,4.929400e-01,4.918400e-01,4.799500e-01,4.612600e-01,&
     & 4.420700e-01,4.216500e-01,4.000000e-01,3.820800e-01,3.726400e-01,&
     & 5.951600e-01,5.832600e-01,5.824400e-01,5.685200e-01,5.477400e-01,&
     & 5.276000e-01,5.041000e-01,4.779200e-01,4.586000e-01,4.478200e-01,&
     & 2.413100e-01,2.350100e-01,2.352000e-01,2.308900e-01,2.218300e-01,&
     & 2.072100e-01,1.908700e-01,1.754400e-01,1.640900e-01,1.581700e-01,&
     & 3.055300e-01,2.993600e-01,2.995600e-01,2.936800e-01,2.814800e-01,&
     & 2.637400e-01,2.431800e-01,2.228100e-01,2.074300e-01,2.001400e-01,&
     & 3.770300e-01,3.715700e-01,3.716700e-01,3.641900e-01,3.485900e-01,&
     & 3.273900e-01,3.026400e-01,2.768800e-01,2.575500e-01,2.482800e-01,&
     & 4.561000e-01,4.513100e-01,4.521300e-01,4.424700e-01,4.238700e-01,&
     & 3.988200e-01,3.700800e-01,3.384900e-01,3.153600e-01,3.042600e-01,&
     & 5.424700e-01,5.388600e-01,5.402100e-01,5.284000e-01,5.075300e-01,&
     & 4.790100e-01,4.456700e-01,4.080900e-01,3.816300e-01,3.688100e-01,&
     & 2.029800e-01,2.002500e-01,2.021300e-01,1.998200e-01,1.921200e-01,&
     & 1.769100e-01,1.588600e-01,1.406900e-01,1.276300e-01,1.214700e-01,&
     & 2.615700e-01,2.597600e-01,2.620900e-01,2.583200e-01,2.479800e-01,&
     & 2.287100e-01,2.057700e-01,1.819700e-01,1.641600e-01,1.563400e-01,&
     & 3.280100e-01,3.276100e-01,3.302300e-01,3.248400e-01,3.111400e-01,&
     & 2.880300e-01,2.596600e-01,2.288500e-01,2.058700e-01,1.964400e-01,&
     & 4.020700e-01,4.035100e-01,4.062200e-01,3.990300e-01,3.823400e-01,&
     & 3.546500e-01,3.206200e-01,2.828900e-01,2.544000e-01,2.431200e-01,&
     & 4.833600e-01,4.869700e-01,4.900300e-01,4.811400e-01,4.618500e-01,&
     & 4.292800e-01,3.896600e-01,3.446300e-01,3.104300e-01,2.970600e-01/
      data  absa(301:650,9) /                                           &
     & 1.668800e-01,1.670200e-01,1.703100e-01,1.692100e-01,1.619900e-01,&
     & 1.489700e-01,1.309200e-01,1.113300e-01,9.676000e-02,9.371800e-02,&
     & 2.188200e-01,2.208700e-01,2.248600e-01,2.228600e-01,2.133500e-01,&
     & 1.961500e-01,1.728500e-01,1.469500e-01,1.269000e-01,1.209600e-01,&
     & 2.788800e-01,2.830600e-01,2.877700e-01,2.846900e-01,2.720400e-01,&
     & 2.503300e-01,2.212200e-01,1.878600e-01,1.616100e-01,1.529600e-01,&
     & 3.468000e-01,3.538500e-01,3.588100e-01,3.542000e-01,3.385400e-01,&
     & 3.118800e-01,2.761200e-01,2.352800e-01,2.021500e-01,1.909500e-01,&
     & 4.220500e-01,4.321500e-01,4.375900e-01,4.312700e-01,4.127300e-01,&
     & 3.811600e-01,3.387900e-01,2.894800e-01,2.488600e-01,2.356000e-01,&
     & 1.345900e-01,1.369200e-01,1.408000e-01,1.397100e-01,1.334700e-01,&
     & 1.226200e-01,1.066600e-01,8.730500e-02,7.191500e-02,8.003800e-02,&
     & 1.796300e-01,1.844200e-01,1.895400e-01,1.880600e-01,1.795100e-01,&
     & 1.649700e-01,1.437700e-01,1.175800e-01,9.620600e-02,1.009400e-01,&
     & 2.326600e-01,2.403300e-01,2.467200e-01,2.445400e-01,2.329000e-01,&
     & 2.142400e-01,1.869500e-01,1.530300e-01,1.245600e-01,1.256800e-01,&
     & 2.935500e-01,3.049500e-01,3.121300e-01,3.085200e-01,2.940700e-01,&
     & 2.702000e-01,2.365400e-01,1.945100e-01,1.579600e-01,1.551600e-01,&
     & 3.618600e-01,3.772500e-01,3.852200e-01,3.799600e-01,3.624200e-01,&
     & 3.335500e-01,2.931800e-01,2.422900e-01,1.967700e-01,1.899200e-01,&
     & 1.063100e-01,1.099300e-01,1.135500e-01,1.123700e-01,1.070100e-01,&
     & 9.820700e-02,8.518200e-02,6.775500e-02,5.233100e-02,1.049200e-01,&
     & 1.445400e-01,1.509000e-01,1.559000e-01,1.544400e-01,1.472700e-01,&
     & 1.352600e-01,1.175000e-01,9.325900e-02,7.162200e-02,1.246700e-01,&
     & 1.901900e-01,2.001100e-01,2.065300e-01,2.046600e-01,1.948600e-01,&
     & 1.790400e-01,1.556300e-01,1.236400e-01,9.441500e-02,1.474000e-01,&
     & 2.434700e-01,2.577500e-01,2.654900e-01,2.624100e-01,2.498700e-01,&
     & 2.294900e-01,1.996900e-01,1.593900e-01,1.213600e-01,1.736900e-01,&
     & 3.042200e-01,3.231700e-01,3.320300e-01,3.277700e-01,3.119700e-01,&
     & 2.866400e-01,2.505100e-01,2.008400e-01,1.529600e-01,2.039800e-01,&
     & 8.435000e-02,8.881500e-02,9.200700e-02,9.071200e-02,8.623500e-02,&
     & 7.883400e-02,6.825100e-02,5.349400e-02,3.856900e-02,2.844800e-01,&
     & 1.165500e-01,1.239600e-01,1.286400e-01,1.270000e-01,1.209100e-01,&
     & 1.107600e-01,9.617500e-02,7.520600e-02,5.374100e-02,3.118300e-01,&
     & 1.557500e-01,1.668800e-01,1.730200e-01,1.709600e-01,1.628000e-01,&
     & 1.492700e-01,1.296400e-01,1.012800e-01,7.199800e-02,3.403500e-01,&
     & 2.019900e-01,2.177100e-01,2.253900e-01,2.223900e-01,2.118200e-01,&
     & 1.942600e-01,1.687000e-01,1.322000e-01,9.382000e-02,3.702200e-01,&
     & 2.554300e-01,2.760200e-01,2.851200e-01,2.812500e-01,2.677600e-01,&
     & 2.455800e-01,2.137900e-01,1.684300e-01,1.196700e-01,4.013300e-01,&
     & 7.730500e-02,8.351200e-02,8.655800e-02,8.511500e-02,8.075900e-02,&
     & 7.366800e-02,6.372900e-02,4.979800e-02,3.327900e-02,4.233100e-01,&
     & 1.067400e-01,1.163100e-01,1.207400e-01,1.189700e-01,1.130600e-01,&
     & 1.033800e-01,8.969300e-02,6.994700e-02,4.639200e-02,4.575900e-01,&
     & 1.425200e-01,1.563000e-01,1.623000e-01,1.598900e-01,1.521500e-01,&
     & 1.393100e-01,1.208200e-01,9.422900e-02,6.220700e-02,4.930100e-01,&
     & 1.849500e-01,2.034400e-01,2.111300e-01,2.080100e-01,1.980700e-01,&
     & 1.812500e-01,1.573400e-01,1.230300e-01,8.130700e-02,5.301200e-01,&
     & 2.341100e-01,2.578300e-01,2.669000e-01,2.630300e-01,2.503500e-01,&
     & 2.294400e-01,1.994300e-01,1.565800e-01,1.039700e-01,5.678900e-01,&
     & 7.010800e-02,7.742700e-02,8.006300e-02,7.869500e-02,7.441200e-02,&
     & 6.779800e-02,5.871000e-02,4.582600e-02,2.870100e-02,4.879300e-01,&
     & 9.657200e-02,1.076500e-01,1.115400e-01,1.097600e-01,1.040300e-01,&
     & 9.505300e-02,8.241400e-02,6.435500e-02,4.008500e-02,5.248000e-01,&
     & 1.289000e-01,1.443600e-01,1.496000e-01,1.473900e-01,1.399200e-01,&
     & 1.280100e-01,1.109600e-01,8.664400e-02,5.397500e-02,5.625100e-01,&
     & 1.673700e-01,1.877800e-01,1.943000e-01,1.916500e-01,1.820800e-01,&
     & 1.665900e-01,1.445000e-01,1.130700e-01,7.069600e-02,6.018300e-01,&
     & 2.118600e-01,2.379200e-01,2.458700e-01,2.423300e-01,2.302100e-01,&
     & 2.108600e-01,1.832700e-01,1.438600e-01,9.029200e-02,6.416300e-01,&
     & 6.275000e-02,7.067800e-02,7.285000e-02,7.135800e-02,6.744100e-02,&
     & 6.143300e-02,5.318500e-02,4.150500e-02,2.480600e-02,4.470000e-01,&
     & 8.631600e-02,9.814300e-02,1.013400e-01,9.944700e-02,9.421000e-02,&
     & 8.601400e-02,7.452600e-02,5.827300e-02,3.474300e-02,4.810300e-01,&
     & 1.152900e-01,1.315600e-01,1.357900e-01,1.334600e-01,1.266600e-01,&
     & 1.157300e-01,1.003100e-01,7.851100e-02,4.692800e-02,5.160600e-01,&
     & 1.497600e-01,1.710400e-01,1.764300e-01,1.735800e-01,1.647300e-01,&
     & 1.505800e-01,1.306700e-01,1.024900e-01,6.155100e-02,5.522400e-01,&
     & 1.896400e-01,2.165600e-01,2.233900e-01,2.197000e-01,2.085600e-01,&
     & 1.907400e-01,1.657500e-01,1.303100e-01,7.838200e-02,5.891300e-01/
      data  absa(1:300,10) /                                            &
     & 6.186700e-01,5.763000e-01,6.030500e-01,6.945600e-01,7.726100e-01,&
     & 8.100500e-01,8.242400e-01,7.848700e-01,7.971600e-01,8.109700e-01,&
     & 7.553800e-01,7.070600e-01,7.482500e-01,8.657300e-01,9.513300e-01,&
     & 9.949600e-01,1.014400e+00,9.434900e-01,9.751000e-01,9.855700e-01,&
     & 9.075300e-01,8.543100e-01,9.095400e-01,1.050400e+00,1.143900e+00,&
     & 1.196100e+00,1.213800e+00,1.103800e+00,1.163500e+00,1.172900e+00,&
     & 1.071700e+00,1.013400e+00,1.087600e+00,1.247100e+00,1.350500e+00,&
     & 1.404900e+00,1.421900e+00,1.291500e+00,1.387800e+00,1.399100e+00,&
     & 1.242700e+00,1.182700e+00,1.283300e+00,1.450400e+00,1.563500e+00,&
     & 1.629800e+00,1.659700e+00,1.485700e+00,1.641400e+00,1.646000e+00,&
     & 6.432100e-01,5.869600e-01,5.823000e-01,6.561900e-01,7.155600e-01,&
     & 7.417000e-01,7.607100e-01,7.391200e-01,7.453200e-01,7.585000e-01,&
     & 7.898400e-01,7.245300e-01,7.331600e-01,8.257400e-01,8.933900e-01,&
     & 9.257800e-01,9.366600e-01,8.917200e-01,9.062700e-01,9.241200e-01,&
     & 9.486900e-01,8.731200e-01,8.999200e-01,1.010800e+00,1.090600e+00,&
     & 1.122800e+00,1.118400e+00,1.053200e+00,1.081600e+00,1.105000e+00,&
     & 1.118200e+00,1.033300e+00,1.081600e+00,1.209900e+00,1.299100e+00,&
     & 1.329500e+00,1.318300e+00,1.230500e+00,1.286500e+00,1.310900e+00,&
     & 1.295300e+00,1.204600e+00,1.274300e+00,1.419700e+00,1.517900e+00,&
     & 1.556500e+00,1.546300e+00,1.406100e+00,1.505000e+00,1.528200e+00,&
     & 6.275700e-01,5.747300e-01,5.591400e-01,5.817200e-01,6.288700e-01,&
     & 6.501400e-01,6.780200e-01,6.590400e-01,6.593400e-01,6.729500e-01,&
     & 7.841800e-01,7.158800e-01,7.060700e-01,7.423800e-01,8.001400e-01,&
     & 8.182200e-01,8.401600e-01,8.093600e-01,8.148400e-01,8.280500e-01,&
     & 9.601400e-01,8.761200e-01,8.684500e-01,9.223200e-01,9.921400e-01,&
     & 9.981000e-01,1.010400e+00,9.730600e-01,9.886900e-01,1.003000e+00,&
     & 1.143600e+00,1.050000e+00,1.047300e+00,1.121600e+00,1.199200e+00,&
     & 1.190900e+00,1.197900e+00,1.149300e+00,1.184300e+00,1.202800e+00,&
     & 1.336300e+00,1.228800e+00,1.240000e+00,1.332800e+00,1.418900e+00,&
     & 1.408500e+00,1.405400e+00,1.332600e+00,1.395200e+00,1.419000e+00,&
     & 6.090200e-01,5.586500e-01,5.287500e-01,5.179200e-01,5.451800e-01,&
     & 5.632500e-01,5.887700e-01,5.838700e-01,5.820600e-01,5.930800e-01,&
     & 7.614000e-01,6.991200e-01,6.775700e-01,6.669000e-01,7.032700e-01,&
     & 7.230500e-01,7.417200e-01,7.203000e-01,7.206800e-01,7.316100e-01,&
     & 9.400200e-01,8.636500e-01,8.436600e-01,8.379500e-01,8.810900e-01,&
     & 8.927900e-01,9.065200e-01,8.701800e-01,8.759500e-01,8.877300e-01,&
     & 1.136100e+00,1.047100e+00,1.023900e+00,1.029100e+00,1.072900e+00,&
     & 1.076900e+00,1.089800e+00,1.037000e+00,1.055400e+00,1.068000e+00,&
     & 1.345900e+00,1.241500e+00,1.220000e+00,1.234300e+00,1.281100e+00,&
     & 1.281200e+00,1.294100e+00,1.222500e+00,1.259800e+00,1.270200e+00,&
     & 5.751500e-01,5.323200e-01,5.039100e-01,4.797800e-01,4.698400e-01,&
     & 4.883900e-01,5.158700e-01,5.059000e-01,5.004900e-01,4.951800e-01,&
     & 7.312800e-01,6.740600e-01,6.481100e-01,6.204900e-01,6.186800e-01,&
     & 6.340100e-01,6.543900e-01,6.348800e-01,6.301500e-01,6.241000e-01,&
     & 9.092000e-01,8.375900e-01,8.183500e-01,7.843500e-01,7.848700e-01,&
     & 7.969500e-01,8.051600e-01,7.772700e-01,7.750400e-01,7.763600e-01,&
     & 1.109900e+00,1.024500e+00,1.007000e+00,9.705200e-01,9.634800e-01,&
     & 9.778000e-01,9.764900e-01,9.366000e-01,9.397300e-01,9.445100e-01,&
     & 1.330500e+00,1.227200e+00,1.211200e+00,1.173200e+00,1.159400e+00,&
     & 1.178400e+00,1.170400e+00,1.111200e+00,1.126300e+00,1.127200e+00,&
     & 5.362400e-01,4.996600e-01,4.712400e-01,4.439600e-01,4.130900e-01,&
     & 4.179900e-01,4.320400e-01,4.168900e-01,4.079600e-01,4.029600e-01,&
     & 6.908600e-01,6.421400e-01,6.147100e-01,5.816800e-01,5.457600e-01,&
     & 5.533100e-01,5.610600e-01,5.320700e-01,5.198300e-01,5.138100e-01,&
     & 8.678500e-01,8.070000e-01,7.815600e-01,7.416900e-01,7.028100e-01,&
     & 7.009000e-01,7.031700e-01,6.688000e-01,6.568500e-01,6.488400e-01,&
     & 1.062500e+00,9.915000e-01,9.728400e-01,9.258300e-01,8.759200e-01,&
     & 8.686400e-01,8.673300e-01,8.223800e-01,8.124500e-01,8.001100e-01,&
     & 1.282300e+00,1.197500e+00,1.185600e+00,1.125500e+00,1.065900e+00,&
     & 1.061200e+00,1.049800e+00,9.854600e-01,9.837100e-01,9.675100e-01/
      data  absa(301:650,10) /                                          &
     & 4.882200e-01,4.543100e-01,4.234600e-01,3.968000e-01,3.741500e-01,&
     & 3.507100e-01,3.511800e-01,3.415200e-01,3.311900e-01,3.255800e-01,&
     & 6.434100e-01,5.983600e-01,5.656500e-01,5.316700e-01,5.002700e-01,&
     & 4.711600e-01,4.635000e-01,4.435300e-01,4.288400e-01,4.249300e-01,&
     & 8.215800e-01,7.660600e-01,7.309800e-01,6.863200e-01,6.473200e-01,&
     & 6.116700e-01,5.953500e-01,5.654800e-01,5.473900e-01,5.428800e-01,&
     & 1.017900e+00,9.515600e-01,9.178500e-01,8.656700e-01,8.140400e-01,&
     & 7.726100e-01,7.533200e-01,7.027700e-01,6.816400e-01,6.683400e-01,&
     & 1.233200e+00,1.156800e+00,1.127000e+00,1.064300e+00,1.001900e+00,&
     & 9.549000e-01,9.276000e-01,8.529300e-01,8.323400e-01,8.126900e-01,&
     & 4.269800e-01,3.959100e-01,3.690500e-01,3.524700e-01,3.324700e-01,&
     & 3.023300e-01,2.853900e-01,2.761300e-01,2.638000e-01,2.556600e-01,&
     & 5.779200e-01,5.359900e-01,5.050400e-01,4.796500e-01,4.545400e-01,&
     & 4.104700e-01,3.840100e-01,3.679500e-01,3.502200e-01,3.408500e-01,&
     & 7.531200e-01,7.020800e-01,6.643300e-01,6.280700e-01,5.980000e-01,&
     & 5.375000e-01,5.023700e-01,4.791600e-01,4.562900e-01,4.435500e-01,&
     & 9.492700e-01,8.866900e-01,8.454700e-01,8.019400e-01,7.572500e-01,&
     & 6.920500e-01,6.451100e-01,6.002600e-01,5.712700e-01,5.553000e-01,&
     & 1.163900e+00,1.091100e+00,1.045400e+00,9.955200e-01,9.408300e-01,&
     & 8.680000e-01,8.025800e-01,7.330900e-01,6.998700e-01,6.825100e-01,&
     & 3.590000e-01,3.344500e-01,3.173000e-01,3.060900e-01,2.891600e-01,&
     & 2.612000e-01,2.336100e-01,2.157600e-01,2.024000e-01,3.162500e-01,&
     & 4.987500e-01,4.653000e-01,4.440100e-01,4.278600e-01,4.033600e-01,&
     & 3.632600e-01,3.206300e-01,2.958300e-01,2.754900e-01,3.959600e-01,&
     & 6.648900e-01,6.219900e-01,5.955800e-01,5.702100e-01,5.387500e-01,&
     & 4.835500e-01,4.269200e-01,3.941500e-01,3.663700e-01,4.855300e-01,&
     & 8.534000e-01,8.005900e-01,7.683000e-01,7.371000e-01,6.930600e-01,&
     & 6.245400e-01,5.569700e-01,5.041900e-01,4.674200e-01,5.773200e-01,&
     & 1.064600e+00,1.002800e+00,9.621800e-01,9.218000e-01,8.701200e-01,&
     & 7.920200e-01,6.979600e-01,6.271000e-01,5.817400e-01,6.558200e-01,&
     & 3.030400e-01,2.839700e-01,2.744000e-01,2.681400e-01,2.511900e-01,&
     & 2.286400e-01,1.971200e-01,1.706700e-01,1.543900e-01,6.761600e-01,&
     & 4.303900e-01,4.046300e-01,3.913500e-01,3.811600e-01,3.587300e-01,&
     & 3.250900e-01,2.775800e-01,2.388100e-01,2.170800e-01,7.404000e-01,&
     & 5.830800e-01,5.508900e-01,5.339200e-01,5.188100e-01,4.858800e-01,&
     & 4.396900e-01,3.765900e-01,3.247100e-01,2.935700e-01,8.110300e-01,&
     & 7.607200e-01,7.209800e-01,6.999000e-01,6.804700e-01,6.330900e-01,&
     & 5.738300e-01,4.958900e-01,4.233600e-01,3.800100e-01,8.932800e-01,&
     & 9.602700e-01,9.177500e-01,8.892400e-01,8.589300e-01,8.037200e-01,&
     & 7.291100e-01,6.305800e-01,5.361000e-01,4.785800e-01,1.002400e+00,&
     & 2.995300e-01,2.833100e-01,2.792600e-01,2.732100e-01,2.569800e-01,&
     & 2.331800e-01,1.987200e-01,1.586800e-01,1.377900e-01,1.110700e+00,&
     & 4.247400e-01,4.040400e-01,3.978100e-01,3.878000e-01,3.643800e-01,&
     & 3.308700e-01,2.810300e-01,2.238600e-01,1.943400e-01,1.202900e+00,&
     & 5.744200e-01,5.492400e-01,5.396100e-01,5.266700e-01,4.925900e-01,&
     & 4.465300e-01,3.824500e-01,3.034100e-01,2.614200e-01,1.291500e+00,&
     & 7.481300e-01,7.215900e-01,7.060200e-01,6.875900e-01,6.402900e-01,&
     & 5.846200e-01,4.998300e-01,3.964200e-01,3.379500e-01,1.370400e+00,&
     & 9.425600e-01,9.158100e-01,8.968400e-01,8.691500e-01,8.127800e-01,&
     & 7.380500e-01,6.335300e-01,5.031000e-01,4.264400e-01,1.463800e+00,&
     & 2.900200e-01,2.789000e-01,2.804500e-01,2.724400e-01,2.576900e-01,&
     & 2.330300e-01,1.972900e-01,1.511900e-01,1.225100e-01,1.412900e+00,&
     & 4.102600e-01,3.967900e-01,3.983000e-01,3.865200e-01,3.642000e-01,&
     & 3.284700e-01,2.803600e-01,2.137600e-01,1.705800e-01,1.519700e+00,&
     & 5.545500e-01,5.403800e-01,5.401100e-01,5.220800e-01,4.910700e-01,&
     & 4.444700e-01,3.809000e-01,2.886800e-01,2.275100e-01,1.622500e+00,&
     & 7.201400e-01,7.069500e-01,7.063300e-01,6.790300e-01,6.397300e-01,&
     & 5.800700e-01,4.957600e-01,3.765600e-01,2.946000e-01,1.713400e+00,&
     & 9.094400e-01,8.942300e-01,8.907500e-01,8.594100e-01,8.094600e-01,&
     & 7.316100e-01,6.265200e-01,4.788000e-01,3.753200e-01,1.822400e+00,&
     & 2.734000e-01,2.707600e-01,2.752600e-01,2.677000e-01,2.517900e-01,&
     & 2.267500e-01,1.924500e-01,1.468200e-01,1.061900e-01,1.421000e+00,&
     & 3.864100e-01,3.842500e-01,3.893000e-01,3.781600e-01,3.550100e-01,&
     & 3.199400e-01,2.735000e-01,2.067100e-01,1.476100e-01,1.525100e+00,&
     & 5.208900e-01,5.211300e-01,5.273800e-01,5.097300e-01,4.782700e-01,&
     & 4.334600e-01,3.699100e-01,2.784900e-01,1.960800e-01,1.623800e+00,&
     & 6.778600e-01,6.793800e-01,6.860800e-01,6.623300e-01,6.242100e-01,&
     & 5.641000e-01,4.814000e-01,3.625900e-01,2.547300e-01,1.723000e+00,&
     & 8.571100e-01,8.606800e-01,8.647200e-01,8.361700e-01,7.860200e-01,&
     & 7.121700e-01,6.076000e-01,4.596600e-01,3.290500e-01,1.834500e+00/
      data  absa(1:300,11) /                                            &
     & 9.415900e-01,8.691000e-01,9.493900e-01,1.030900e+00,1.097100e+00,&
     & 1.159700e+00,1.157300e+00,1.019800e+00,1.125900e+00,1.144400e+00,&
     & 1.181600e+00,1.090300e+00,1.168100e+00,1.249100e+00,1.352400e+00,&
     & 1.425200e+00,1.401700e+00,1.254800e+00,1.388500e+00,1.416100e+00,&
     & 1.445700e+00,1.333800e+00,1.409800e+00,1.494300e+00,1.625700e+00,&
     & 1.696600e+00,1.661500e+00,1.514500e+00,1.682300e+00,1.716000e+00,&
     & 1.726100e+00,1.593600e+00,1.667600e+00,1.764000e+00,1.903400e+00,&
     & 1.981600e+00,1.937500e+00,1.790400e+00,1.991500e+00,2.029000e+00,&
     & 2.022200e+00,1.866400e+00,1.940200e+00,2.058800e+00,2.188600e+00,&
     & 2.271900e+00,2.217100e+00,2.113000e+00,2.332000e+00,2.386100e+00,&
     & 8.841400e-01,8.347000e-01,9.012200e-01,9.819800e-01,1.045000e+00,&
     & 1.090200e+00,1.077000e+00,9.485500e-01,1.038600e+00,1.058100e+00,&
     & 1.114300e+00,1.055000e+00,1.115100e+00,1.217600e+00,1.303000e+00,&
     & 1.343700e+00,1.320700e+00,1.174600e+00,1.302200e+00,1.322900e+00,&
     & 1.370500e+00,1.300100e+00,1.355700e+00,1.479700e+00,1.577400e+00,&
     & 1.613300e+00,1.589200e+00,1.416700e+00,1.591200e+00,1.609600e+00,&
     & 1.652900e+00,1.566700e+00,1.625200e+00,1.760200e+00,1.863800e+00,&
     & 1.899500e+00,1.868700e+00,1.678200e+00,1.896700e+00,1.918900e+00,&
     & 1.954300e+00,1.849200e+00,1.919800e+00,2.057400e+00,2.158300e+00,&
     & 2.194400e+00,2.159400e+00,1.993900e+00,2.247200e+00,2.279100e+00,&
     & 8.186900e-01,7.702300e-01,8.210900e-01,8.833600e-01,9.280500e-01,&
     & 9.612800e-01,9.485600e-01,8.584300e-01,9.198300e-01,9.474300e-01,&
     & 1.038900e+00,9.861500e-01,1.034500e+00,1.125600e+00,1.175200e+00,&
     & 1.202000e+00,1.185700e+00,1.060800e+00,1.159900e+00,1.185400e+00,&
     & 1.282600e+00,1.225000e+00,1.274700e+00,1.396800e+00,1.438300e+00,&
     & 1.467100e+00,1.448700e+00,1.272100e+00,1.417500e+00,1.435000e+00,&
     & 1.556400e+00,1.486500e+00,1.544700e+00,1.688100e+00,1.720100e+00,&
     & 1.755700e+00,1.722500e+00,1.503500e+00,1.692900e+00,1.710000e+00,&
     & 1.853900e+00,1.770400e+00,1.837000e+00,1.988900e+00,2.018300e+00,&
     & 2.051100e+00,2.007500e+00,1.781600e+00,2.012600e+00,2.033100e+00,&
     & 7.649700e-01,7.107600e-01,7.329500e-01,7.700600e-01,7.964200e-01,&
     & 8.248100e-01,8.260800e-01,7.599300e-01,8.077700e-01,8.284800e-01,&
     & 9.835200e-01,9.185700e-01,9.461100e-01,1.007300e+00,1.028200e+00,&
     & 1.049700e+00,1.046700e+00,9.538900e-01,1.031600e+00,1.051700e+00,&
     & 1.229200e+00,1.151200e+00,1.184600e+00,1.270900e+00,1.282400e+00,&
     & 1.306500e+00,1.289900e+00,1.157400e+00,1.265000e+00,1.290400e+00,&
     & 1.501200e+00,1.409300e+00,1.451000e+00,1.556500e+00,1.563700e+00,&
     & 1.587000e+00,1.539900e+00,1.377400e+00,1.518300e+00,1.551800e+00,&
     & 1.793400e+00,1.688600e+00,1.743400e+00,1.862000e+00,1.866700e+00,&
     & 1.877900e+00,1.805800e+00,1.624300e+00,1.806100e+00,1.847600e+00,&
     & 7.454800e-01,6.781400e-01,6.547600e-01,6.594800e-01,6.793400e-01,&
     & 7.078800e-01,7.174500e-01,6.735300e-01,7.046100e-01,7.309900e-01,&
     & 9.596900e-01,8.782500e-01,8.601700e-01,8.815500e-01,8.923900e-01,&
     & 9.167000e-01,9.270800e-01,8.500000e-01,9.072800e-01,9.303200e-01,&
     & 1.205800e+00,1.109900e+00,1.096000e+00,1.133000e+00,1.137700e+00,&
     & 1.155800e+00,1.156500e+00,1.041600e+00,1.127800e+00,1.147600e+00,&
     & 1.481000e+00,1.367100e+00,1.363900e+00,1.409500e+00,1.416200e+00,&
     & 1.415900e+00,1.396000e+00,1.253100e+00,1.372600e+00,1.394000e+00,&
     & 1.779800e+00,1.647100e+00,1.658400e+00,1.710000e+00,1.717300e+00,&
     & 1.689000e+00,1.652500e+00,1.487900e+00,1.647100e+00,1.674800e+00,&
     & 7.056500e-01,6.419100e-01,5.917400e-01,5.634400e-01,5.741300e-01,&
     & 6.021600e-01,6.173500e-01,5.888200e-01,6.139100e-01,6.253200e-01,&
     & 9.237600e-01,8.406400e-01,7.835300e-01,7.620300e-01,7.699500e-01,&
     & 7.947000e-01,8.077400e-01,7.571000e-01,7.983600e-01,8.121100e-01,&
     & 1.173500e+00,1.069300e+00,1.016300e+00,9.946000e-01,1.000500e+00,&
     & 1.022200e+00,1.022100e+00,9.324700e-01,9.963300e-01,1.009600e+00,&
     & 1.461100e+00,1.329400e+00,1.278000e+00,1.255800e+00,1.263200e+00,&
     & 1.267400e+00,1.252800e+00,1.124400e+00,1.217500e+00,1.233900e+00,&
     & 1.776200e+00,1.617100e+00,1.564500e+00,1.546200e+00,1.548300e+00,&
     & 1.529900e+00,1.504500e+00,1.338900e+00,1.470200e+00,1.486000e+00/
      data  absa(301:650,11) /                                          &
     & 6.439700e-01,5.884800e-01,5.416400e-01,5.043800e-01,4.890400e-01,&
     & 5.120500e-01,5.288800e-01,4.954700e-01,5.121900e-01,5.135700e-01,&
     & 8.601400e-01,7.854100e-01,7.273800e-01,6.810900e-01,6.644700e-01,&
     & 6.873500e-01,7.061000e-01,6.488000e-01,6.804400e-01,6.745700e-01,&
     & 1.105200e+00,1.008900e+00,9.505300e-01,8.943300e-01,8.783400e-01,&
     & 8.963700e-01,9.030700e-01,8.151900e-01,8.648900e-01,8.549500e-01,&
     & 1.389400e+00,1.266100e+00,1.211700e+00,1.143600e+00,1.123900e+00,&
     & 1.130200e+00,1.115900e+00,1.000900e+00,1.070500e+00,1.068600e+00,&
     & 1.711200e+00,1.559800e+00,1.499900e+00,1.425100e+00,1.391500e+00,&
     & 1.387400e+00,1.351700e+00,1.205800e+00,1.304900e+00,1.305900e+00,&
     & 5.787900e-01,5.327400e-01,4.897300e-01,4.563000e-01,4.326900e-01,&
     & 4.328400e-01,4.393000e-01,4.094600e-01,4.186000e-01,4.165500e-01,&
     & 7.891300e-01,7.261400e-01,6.715500e-01,6.292700e-01,5.891900e-01,&
     & 5.937700e-01,5.984900e-01,5.462900e-01,5.611600e-01,5.552400e-01,&
     & 1.031500e+00,9.484800e-01,8.892300e-01,8.318400e-01,7.831200e-01,&
     & 7.892200e-01,7.821700e-01,6.952800e-01,7.202700e-01,7.112600e-01,&
     & 1.308900e+00,1.203000e+00,1.142100e+00,1.071000e+00,1.018400e+00,&
     & 1.007800e+00,9.849400e-01,8.698100e-01,9.105500e-01,9.011700e-01,&
     & 1.623300e+00,1.493000e+00,1.433400e+00,1.345900e+00,1.279700e+00,&
     & 1.251200e+00,1.215500e+00,1.064700e+00,1.130300e+00,1.114300e+00,&
     & 5.087200e-01,4.700000e-01,4.318900e-01,4.070300e-01,3.834700e-01,&
     & 3.663700e-01,3.572200e-01,3.332200e-01,3.351900e-01,4.962900e-01,&
     & 7.103200e-01,6.567000e-01,6.079600e-01,5.726400e-01,5.366100e-01,&
     & 5.068900e-01,4.959900e-01,4.558100e-01,4.590100e-01,6.150400e-01,&
     & 9.472500e-01,8.749200e-01,8.205200e-01,7.721900e-01,7.222000e-01,&
     & 6.837900e-01,6.583900e-01,5.935200e-01,5.985300e-01,7.136300e-01,&
     & 1.221200e+00,1.128500e+00,1.068000e+00,1.002900e+00,9.420800e-01,&
     & 8.907200e-01,8.457700e-01,7.555700e-01,7.652700e-01,8.052200e-01,&
     & 1.526300e+00,1.412600e+00,1.349900e+00,1.271800e+00,1.192100e+00,&
     & 1.122000e+00,1.068500e+00,9.321300e-01,9.577500e-01,9.430300e-01,&
     & 4.483400e-01,4.159600e-01,3.851900e-01,3.673800e-01,3.470700e-01,&
     & 3.166700e-01,2.993500e-01,2.730800e-01,2.699300e-01,8.620200e-01,&
     & 6.401800e-01,5.947600e-01,5.545200e-01,5.274200e-01,4.944400e-01,&
     & 4.503900e-01,4.188500e-01,3.823500e-01,3.760600e-01,1.005000e+00,&
     & 8.694100e-01,8.071900e-01,7.612800e-01,7.208300e-01,6.777800e-01,&
     & 6.113200e-01,5.648500e-01,5.097700e-01,5.005200e-01,1.187900e+00,&
     & 1.137400e+00,1.057800e+00,1.004800e+00,9.466900e-01,8.948500e-01,&
     & 8.026200e-01,7.373000e-01,6.623100e-01,6.521000e-01,1.392600e+00,&
     & 1.437900e+00,1.339800e+00,1.280000e+00,1.209900e+00,1.136900e+00,&
     & 1.029000e+00,9.423900e-01,8.262100e-01,8.203300e-01,1.598700e+00,&
     & 4.643700e-01,4.319500e-01,4.064000e-01,3.908300e-01,3.675900e-01,&
     & 3.309500e-01,2.962100e-01,2.605900e-01,2.489800e-01,1.442400e+00,&
     & 6.599500e-01,6.150400e-01,5.835400e-01,5.610900e-01,5.244800e-01,&
     & 4.707600e-01,4.151000e-01,3.634500e-01,3.457100e-01,1.567900e+00,&
     & 8.962700e-01,8.372600e-01,7.981000e-01,7.631300e-01,7.156100e-01,&
     & 6.392600e-01,5.580400e-01,4.895900e-01,4.656500e-01,1.709300e+00,&
     & 1.169500e+00,1.094900e+00,1.049400e+00,9.997900e-01,9.379200e-01,&
     & 8.338400e-01,7.330400e-01,6.361100e-01,6.064800e-01,1.868700e+00,&
     & 1.475600e+00,1.386500e+00,1.330600e+00,1.270000e+00,1.186000e+00,&
     & 1.064800e+00,9.331000e-01,7.979600e-01,7.611400e-01,2.043300e+00,&
     & 4.688300e-01,4.399200e-01,4.236300e-01,4.099100e-01,3.826700e-01,&
     & 3.454800e-01,2.954900e-01,2.460600e-01,2.240600e-01,1.916100e+00,&
     & 6.661900e-01,6.264300e-01,6.039400e-01,5.841600e-01,5.462100e-01,&
     & 4.902000e-01,4.156800e-01,3.441600e-01,3.149900e-01,2.054100e+00,&
     & 9.024700e-01,8.518200e-01,8.232800e-01,7.936200e-01,7.405700e-01,&
     & 6.624900e-01,5.616700e-01,4.662100e-01,4.257600e-01,2.200500e+00,&
     & 1.175400e+00,1.114100e+00,1.076300e+00,1.039300e+00,9.631400e-01,&
     & 8.634900e-01,7.373300e-01,6.055500e-01,5.510800e-01,2.350600e+00,&
     & 1.481600e+00,1.411800e+00,1.363000e+00,1.310900e+00,1.217400e+00,&
     & 1.094500e+00,9.347000e-01,7.632700e-01,6.945800e-01,2.481700e+00,&
     & 4.658100e-01,4.390700e-01,4.312500e-01,4.201200e-01,3.914200e-01,&
     & 3.528800e-01,2.976400e-01,2.316500e-01,2.002200e-01,2.003800e+00,&
     & 6.601400e-01,6.252500e-01,6.136300e-01,5.955600e-01,5.556500e-01,&
     & 4.995800e-01,4.198900e-01,3.260300e-01,2.820400e-01,2.150600e+00,&
     & 8.916200e-01,8.486600e-01,8.323100e-01,8.074700e-01,7.501000e-01,&
     & 6.728700e-01,5.695200e-01,4.403200e-01,3.794400e-01,2.296300e+00,&
     & 1.158200e+00,1.110500e+00,1.086500e+00,1.052600e+00,9.732000e-01,&
     & 8.768800e-01,7.416900e-01,5.725400e-01,4.909000e-01,2.426400e+00,&
     & 1.455700e+00,1.405400e+00,1.375600e+00,1.324100e+00,1.228300e+00,&
     & 1.103700e+00,9.358000e-01,7.234200e-01,6.192400e-01,2.552600e+00/
      data  absa(1:300,12) /                                            &
     & 1.989900e+00,1.741600e+00,1.655700e+00,1.662600e+00,1.629200e+00,&
     & 1.618600e+00,1.551600e+00,1.511100e+00,1.651500e+00,1.699900e+00,&
     & 2.416700e+00,2.115000e+00,2.028500e+00,2.015400e+00,1.944600e+00,&
     & 1.937800e+00,1.891200e+00,1.872700e+00,2.057200e+00,2.113700e+00,&
     & 2.867800e+00,2.509800e+00,2.425100e+00,2.384000e+00,2.289800e+00,&
     & 2.292500e+00,2.226200e+00,2.252800e+00,2.474800e+00,2.540200e+00,&
     & 3.333400e+00,2.917200e+00,2.834000e+00,2.763300e+00,2.674700e+00,&
     & 2.679900e+00,2.551100e+00,2.657500e+00,2.917100e+00,2.995100e+00,&
     & 3.807000e+00,3.331700e+00,3.243100e+00,3.143400e+00,3.084400e+00,&
     & 3.076700e+00,2.887100e+00,3.085100e+00,3.376800e+00,3.470000e+00,&
     & 1.802000e+00,1.577100e+00,1.565800e+00,1.552900e+00,1.567800e+00,&
     & 1.560900e+00,1.506800e+00,1.432200e+00,1.579400e+00,1.626500e+00,&
     & 2.224400e+00,1.946700e+00,1.937600e+00,1.887800e+00,1.890700e+00,&
     & 1.915600e+00,1.845100e+00,1.780600e+00,1.977500e+00,2.024800e+00,&
     & 2.677700e+00,2.343300e+00,2.327900e+00,2.246600e+00,2.243400e+00,&
     & 2.306100e+00,2.173100e+00,2.160100e+00,2.397100e+00,2.454400e+00,&
     & 3.154400e+00,2.760500e+00,2.732600e+00,2.632000e+00,2.634200e+00,&
     & 2.705900e+00,2.508200e+00,2.577000e+00,2.849800e+00,2.923300e+00,&
     & 3.640800e+00,3.186400e+00,3.139200e+00,3.032100e+00,3.054000e+00,&
     & 3.095000e+00,2.850900e+00,3.020200e+00,3.335000e+00,3.427300e+00,&
     & 1.564900e+00,1.373200e+00,1.382600e+00,1.402000e+00,1.431800e+00,&
     & 1.426600e+00,1.367600e+00,1.262100e+00,1.411300e+00,1.441100e+00,&
     & 1.975000e+00,1.732300e+00,1.734800e+00,1.721200e+00,1.770400e+00,&
     & 1.792500e+00,1.694900e+00,1.596000e+00,1.783200e+00,1.820900e+00,&
     & 2.422200e+00,2.125600e+00,2.115700e+00,2.068800e+00,2.146400e+00,&
     & 2.185200e+00,2.023900e+00,1.972600e+00,2.195800e+00,2.249800e+00,&
     & 2.900000e+00,2.548100e+00,2.520600e+00,2.450000e+00,2.554800e+00,&
     & 2.585300e+00,2.367500e+00,2.389100e+00,2.653600e+00,2.723800e+00,&
     & 3.393100e+00,2.986500e+00,2.939600e+00,2.862400e+00,2.974100e+00,&
     & 2.994900e+00,2.716600e+00,2.825200e+00,3.147700e+00,3.222500e+00,&
     & 1.328000e+00,1.178600e+00,1.200300e+00,1.238400e+00,1.262100e+00,&
     & 1.262300e+00,1.207400e+00,1.095400e+00,1.217800e+00,1.251900e+00,&
     & 1.721400e+00,1.530300e+00,1.529600e+00,1.558100e+00,1.604500e+00,&
     & 1.616000e+00,1.519100e+00,1.400400e+00,1.559900e+00,1.599500e+00,&
     & 2.153100e+00,1.918400e+00,1.896000e+00,1.907300e+00,1.990900e+00,&
     & 1.995600e+00,1.846600e+00,1.752900e+00,1.959700e+00,2.002000e+00,&
     & 2.625900e+00,2.342100e+00,2.300600e+00,2.291100e+00,2.409800e+00,&
     & 2.386200e+00,2.205900e+00,2.147700e+00,2.408300e+00,2.453300e+00,&
     & 3.131200e+00,2.795100e+00,2.728900e+00,2.709800e+00,2.844000e+00,&
     & 2.795500e+00,2.567400e+00,2.571800e+00,2.886200e+00,2.937500e+00,&
     & 1.116100e+00,1.007300e+00,1.047500e+00,1.070400e+00,1.092400e+00,&
     & 1.096500e+00,1.051600e+00,9.488100e-01,1.056800e+00,1.085100e+00,&
     & 1.485200e+00,1.343900e+00,1.360700e+00,1.389200e+00,1.428800e+00,&
     & 1.430800e+00,1.342100e+00,1.229700e+00,1.369600e+00,1.406100e+00,&
     & 1.907200e+00,1.726600e+00,1.713600e+00,1.749500e+00,1.811300e+00,&
     & 1.790300e+00,1.662500e+00,1.556100e+00,1.735400e+00,1.778600e+00,&
     & 2.375400e+00,2.154300e+00,2.102400e+00,2.151200e+00,2.223700e+00,&
     & 2.173500e+00,2.017500e+00,1.917600e+00,2.150400e+00,2.191300e+00,&
     & 2.876600e+00,2.615400e+00,2.526400e+00,2.589600e+00,2.649300e+00,&
     & 2.588600e+00,2.377600e+00,2.303700e+00,2.596900e+00,2.631600e+00,&
     & 9.498500e-01,8.593300e-01,8.889800e-01,9.023200e-01,9.235400e-01,&
     & 9.306600e-01,9.048600e-01,8.173900e-01,9.070600e-01,9.353200e-01,&
     & 1.283400e+00,1.169000e+00,1.190800e+00,1.208600e+00,1.241500e+00,&
     & 1.236800e+00,1.175600e+00,1.074200e+00,1.192800e+00,1.228800e+00,&
     & 1.679900e+00,1.537800e+00,1.535800e+00,1.567300e+00,1.603500e+00,&
     & 1.572600e+00,1.479500e+00,1.379800e+00,1.531500e+00,1.577600e+00,&
     & 2.123800e+00,1.952900e+00,1.923500e+00,1.975800e+00,1.997000e+00,&
     & 1.949600e+00,1.819000e+00,1.709200e+00,1.913700e+00,1.953600e+00,&
     & 2.609500e+00,2.408400e+00,2.350900e+00,2.422800e+00,2.418000e+00,&
     & 2.361800e+00,2.159700e+00,2.067500e+00,2.321400e+00,2.361800e+00/
      data  absa(301:650,12) /                                          &
     & 8.481200e-01,7.684100e-01,7.532600e-01,7.503500e-01,7.711800e-01,&
     & 7.887200e-01,7.718300e-01,7.058500e-01,7.794600e-01,8.079500e-01,&
     & 1.146500e+00,1.044500e+00,1.029000e+00,1.037000e+00,1.059800e+00,&
     & 1.068300e+00,1.024200e+00,9.396300e-01,1.038600e+00,1.075400e+00,&
     & 1.519300e+00,1.389400e+00,1.364900e+00,1.385300e+00,1.398200e+00,&
     & 1.381300e+00,1.317800e+00,1.217300e+00,1.350900e+00,1.391400e+00,&
     & 1.951800e+00,1.788400e+00,1.751300e+00,1.786500e+00,1.777100e+00,&
     & 1.737000e+00,1.644600e+00,1.522200e+00,1.706300e+00,1.739100e+00,&
     & 2.425900e+00,2.227900e+00,2.179400e+00,2.229000e+00,2.196200e+00,&
     & 2.129900e+00,1.978800e+00,1.858500e+00,2.085700e+00,2.122500e+00,&
     & 7.784100e-01,7.071100e-01,6.652200e-01,6.360600e-01,6.476000e-01,&
     & 6.671300e-01,6.614800e-01,6.039000e-01,6.697300e-01,6.884300e-01,&
     & 1.065800e+00,9.663600e-01,9.158300e-01,8.869900e-01,9.084800e-01,&
     & 9.196500e-01,8.937200e-01,8.195500e-01,9.114100e-01,9.349700e-01,&
     & 1.413700e+00,1.283600e+00,1.230700e+00,1.211500e+00,1.223200e+00,&
     & 1.211600e+00,1.165900e+00,1.073200e+00,1.196900e+00,1.225900e+00,&
     & 1.833000e+00,1.667000e+00,1.604700e+00,1.595600e+00,1.581100e+00,&
     & 1.551500e+00,1.475200e+00,1.350700e+00,1.518600e+00,1.542500e+00,&
     & 2.304900e+00,2.103600e+00,2.027800e+00,2.022000e+00,1.985500e+00,&
     & 1.930800e+00,1.801900e+00,1.660500e+00,1.870500e+00,1.896300e+00,&
     & 7.091200e-01,6.446900e-01,5.936300e-01,5.562700e-01,5.538400e-01,&
     & 5.618600e-01,5.592700e-01,5.035400e-01,5.612500e-01,7.496900e-01,&
     & 9.952700e-01,9.055000e-01,8.344200e-01,7.826400e-01,7.775200e-01,&
     & 7.896900e-01,7.769200e-01,6.935400e-01,7.779300e-01,8.704300e-01,&
     & 1.341200e+00,1.219000e+00,1.126800e+00,1.074300e+00,1.060600e+00,&
     & 1.061400e+00,1.035000e+00,9.223700e-01,1.040900e+00,1.057300e+00,&
     & 1.749300e+00,1.587400e+00,1.486300e+00,1.431000e+00,1.398600e+00,&
     & 1.384300e+00,1.325400e+00,1.177100e+00,1.337400e+00,1.337100e+00,&
     & 2.217600e+00,2.012700e+00,1.912600e+00,1.837100e+00,1.790300e+00,&
     & 1.750400e+00,1.635800e+00,1.463000e+00,1.660000e+00,1.667900e+00,&
     & 6.537600e-01,5.964900e-01,5.438200e-01,5.039200e-01,4.922200e-01,&
     & 4.909400e-01,4.767200e-01,4.196600e-01,4.692100e-01,1.376900e+00,&
     & 9.380000e-01,8.567000e-01,7.836700e-01,7.259500e-01,6.980500e-01,&
     & 6.953300e-01,6.761900e-01,5.913200e-01,6.616000e-01,1.670600e+00,&
     & 1.285400e+00,1.174100e+00,1.077400e+00,1.000800e+00,9.566800e-01,&
     & 9.516500e-01,9.165600e-01,7.922400e-01,8.951000e-01,1.978500e+00,&
     & 1.692100e+00,1.544800e+00,1.430100e+00,1.336100e+00,1.273500e+00,&
     & 1.258700e+00,1.195700e+00,1.018100e+00,1.160900e+00,2.289400e+00,&
     & 2.157600e+00,1.966400e+00,1.849400e+00,1.730000e+00,1.650900e+00,&
     & 1.607000e+00,1.497300e+00,1.281600e+00,1.464800e+00,2.606700e+00,&
     & 7.095200e-01,6.505300e-01,5.931600e-01,5.514600e-01,5.218000e-01,&
     & 5.065200e-01,4.771800e-01,4.124600e-01,4.578300e-01,2.024100e+00,&
     & 1.016700e+00,9.326200e-01,8.533300e-01,7.923200e-01,7.449900e-01,&
     & 7.114000e-01,6.746500e-01,5.785900e-01,6.461300e-01,2.291200e+00,&
     & 1.388600e+00,1.273200e+00,1.173600e+00,1.090600e+00,1.013900e+00,&
     & 9.703400e-01,9.124000e-01,7.704900e-01,8.637600e-01,2.646300e+00,&
     & 1.818100e+00,1.668000e+00,1.554900e+00,1.441700e+00,1.342500e+00,&
     & 1.283000e+00,1.183600e+00,9.885700e-01,1.112900e+00,3.026300e+00,&
     & 2.305700e+00,2.114600e+00,1.995000e+00,1.850800e+00,1.728900e+00,&
     & 1.630700e+00,1.491900e+00,1.245500e+00,1.408500e+00,3.418600e+00,&
     & 7.588600e-01,6.979600e-01,6.385200e-01,5.992900e-01,5.599000e-01,&
     & 5.192400e-01,4.784000e-01,4.034100e-01,4.415400e-01,2.608700e+00,&
     & 1.085100e+00,9.977000e-01,9.167300e-01,8.589900e-01,7.980900e-01,&
     & 7.328700e-01,6.714800e-01,5.635000e-01,6.161200e-01,2.831000e+00,&
     & 1.475500e+00,1.357300e+00,1.257900e+00,1.177400e+00,1.088600e+00,&
     & 9.948400e-01,9.035400e-01,7.500700e-01,8.221400e-01,3.138800e+00,&
     & 1.925300e+00,1.771100e+00,1.660400e+00,1.547100e+00,1.433600e+00,&
     & 1.305100e+00,1.169800e+00,9.714000e-01,1.065100e+00,3.485000e+00,&
     & 2.430800e+00,2.239600e+00,2.116700e+00,1.972900e+00,1.827200e+00,&
     & 1.658500e+00,1.480900e+00,1.217700e+00,1.344800e+00,3.882500e+00,&
     & 7.922900e-01,7.322100e-01,6.773700e-01,6.413000e-01,5.984700e-01,&
     & 5.358000e-01,4.772800e-01,3.900300e-01,4.140000e-01,2.763800e+00,&
     & 1.129700e+00,1.045000e+00,9.714000e-01,9.161800e-01,8.513800e-01,&
     & 7.600600e-01,6.661900e-01,5.438300e-01,5.763800e-01,2.970300e+00,&
     & 1.531000e+00,1.416900e+00,1.328000e+00,1.247000e+00,1.158400e+00,&
     & 1.027200e+00,8.929500e-01,7.300700e-01,7.720800e-01,3.218000e+00,&
     & 1.993900e+00,1.845700e+00,1.741600e+00,1.631500e+00,1.516900e+00,&
     & 1.336000e+00,1.163400e+00,9.490000e-01,1.005800e+00,3.528800e+00,&
     & 2.507900e+00,2.328700e+00,2.204300e+00,2.069100e+00,1.916200e+00,&
     & 1.696700e+00,1.473200e+00,1.190300e+00,1.264100e+00,3.860300e+00/
      data  absa(1:300,13) /                                            &
     & 3.964900e+00,3.469600e+00,2.974200e+00,2.689300e+00,2.581400e+00,&
     & 2.253900e+00,1.959100e+00,2.195300e+00,2.358500e+00,2.443500e+00,&
     & 4.693400e+00,4.107000e+00,3.520600e+00,3.242500e+00,3.076200e+00,&
     & 2.667000e+00,2.321300e+00,2.657700e+00,2.828100e+00,2.939100e+00,&
     & 5.430900e+00,4.752400e+00,4.073800e+00,3.821100e+00,3.569900e+00,&
     & 3.101300e+00,2.744600e+00,3.184800e+00,3.384100e+00,3.520500e+00,&
     & 6.170800e+00,5.399700e+00,4.633100e+00,4.411000e+00,4.065000e+00,&
     & 3.550600e+00,3.265300e+00,3.793900e+00,4.034900e+00,4.194600e+00,&
     & 6.887900e+00,6.027300e+00,5.187300e+00,4.982100e+00,4.555900e+00,&
     & 4.007800e+00,3.843300e+00,4.468800e+00,4.772400e+00,4.954400e+00,&
     & 3.669800e+00,3.211300e+00,2.763400e+00,2.622000e+00,2.449800e+00,&
     & 2.217700e+00,1.931700e+00,2.175900e+00,2.356600e+00,2.453900e+00,&
     & 4.392200e+00,3.843300e+00,3.317400e+00,3.196200e+00,2.940200e+00,&
     & 2.630300e+00,2.349600e+00,2.706400e+00,2.899500e+00,3.042100e+00,&
     & 5.131500e+00,4.490300e+00,3.896000e+00,3.780400e+00,3.447500e+00,&
     & 3.057500e+00,2.847800e+00,3.307500e+00,3.515400e+00,3.710100e+00,&
     & 5.880000e+00,5.145300e+00,4.492400e+00,4.364600e+00,3.964200e+00,&
     & 3.520800e+00,3.389100e+00,3.939900e+00,4.195400e+00,4.421400e+00,&
     & 6.610100e+00,5.784100e+00,5.087200e+00,4.934800e+00,4.477700e+00,&
     & 4.045800e+00,3.971300e+00,4.616000e+00,4.939300e+00,5.187000e+00,&
     & 3.241100e+00,2.836100e+00,2.483100e+00,2.407000e+00,2.248000e+00,&
     & 2.087000e+00,1.805100e+00,2.020200e+00,2.199400e+00,2.300200e+00,&
     & 3.947000e+00,3.453800e+00,3.048300e+00,2.966700e+00,2.718100e+00,&
     & 2.514800e+00,2.250100e+00,2.576500e+00,2.783700e+00,2.931300e+00,&
     & 4.680400e+00,4.095500e+00,3.645900e+00,3.539900e+00,3.216300e+00,&
     & 2.963900e+00,2.771500e+00,3.208800e+00,3.455700e+00,3.650700e+00,&
     & 5.431200e+00,4.752500e+00,4.267500e+00,4.120600e+00,3.736400e+00,&
     & 3.456200e+00,3.339900e+00,3.884400e+00,4.192000e+00,4.420200e+00,&
     & 6.179600e+00,5.407400e+00,4.899000e+00,4.701300e+00,4.291500e+00,&
     & 3.975700e+00,3.940700e+00,4.582800e+00,4.941000e+00,5.212300e+00,&
     & 2.792900e+00,2.443900e+00,2.193900e+00,2.145400e+00,2.051500e+00,&
     & 1.887700e+00,1.638300e+00,1.804500e+00,1.974000e+00,2.062800e+00,&
     & 3.479300e+00,3.044500e+00,2.759800e+00,2.670500e+00,2.512100e+00,&
     & 2.326600e+00,2.090100e+00,2.362000e+00,2.568900e+00,2.699800e+00,&
     & 4.201000e+00,3.676100e+00,3.366000e+00,3.227800e+00,3.002700e+00,&
     & 2.808600e+00,2.602800e+00,2.985500e+00,3.257400e+00,3.412400e+00,&
     & 4.951900e+00,4.333100e+00,4.006600e+00,3.813700e+00,3.526900e+00,&
     & 3.345300e+00,3.163500e+00,3.667000e+00,4.007000e+00,4.190300e+00,&
     & 5.712800e+00,4.998900e+00,4.667200e+00,4.409200e+00,4.081700e+00,&
     & 3.879100e+00,3.769800e+00,4.388200e+00,4.806500e+00,5.015000e+00,&
     & 2.383200e+00,2.085400e+00,1.920600e+00,1.910200e+00,1.837700e+00,&
     & 1.680400e+00,1.458100e+00,1.582000e+00,1.738500e+00,1.810400e+00,&
     & 3.040800e+00,2.660800e+00,2.478500e+00,2.405400e+00,2.302500e+00,&
     & 2.123400e+00,1.894700e+00,2.114200e+00,2.321300e+00,2.419200e+00,&
     & 3.747200e+00,3.278900e+00,3.088800e+00,2.939500e+00,2.803600e+00,&
     & 2.628200e+00,2.390600e+00,2.715300e+00,2.992600e+00,3.105900e+00,&
     & 4.491500e+00,3.930200e+00,3.739300e+00,3.509000e+00,3.337500e+00,&
     & 3.175900e+00,2.935400e+00,3.382700e+00,3.735200e+00,3.869000e+00,&
     & 5.266300e+00,4.608100e+00,4.407700e+00,4.100600e+00,3.918000e+00,&
     & 3.709000e+00,3.530700e+00,4.107600e+00,4.533800e+00,4.698600e+00,&
     & 1.993200e+00,1.745000e+00,1.666300e+00,1.674700e+00,1.587500e+00,&
     & 1.457700e+00,1.265300e+00,1.349900e+00,1.481700e+00,1.546500e+00,&
     & 2.612600e+00,2.287700e+00,2.190600e+00,2.146500e+00,2.044000e+00,&
     & 1.894800e+00,1.675100e+00,1.829500e+00,2.025300e+00,2.093900e+00,&
     & 3.303500e+00,2.892200e+00,2.779600e+00,2.667100e+00,2.556400e+00,&
     & 2.398200e+00,2.143300e+00,2.387600e+00,2.656300e+00,2.731100e+00,&
     & 4.048000e+00,3.544100e+00,3.409400e+00,3.225300e+00,3.119600e+00,&
     & 2.934600e+00,2.653600e+00,3.026600e+00,3.371000e+00,3.461600e+00,&
     & 4.834200e+00,4.233800e+00,4.069600e+00,3.823000e+00,3.739600e+00,&
     & 3.459400e+00,3.230900e+00,3.733900e+00,4.160000e+00,4.269600e+00/
      data  absa(301:650,13) /                                          &
     & 1.646800e+00,1.446900e+00,1.437500e+00,1.432100e+00,1.347400e+00,&
     & 1.242400e+00,1.089200e+00,1.151000e+00,1.262600e+00,1.318300e+00,&
     & 2.229100e+00,1.958200e+00,1.927000e+00,1.894600e+00,1.789900e+00,&
     & 1.661300e+00,1.463800e+00,1.584400e+00,1.748600e+00,1.814300e+00,&
     & 2.893700e+00,2.545200e+00,2.476000e+00,2.409500e+00,2.297700e+00,&
     & 2.147500e+00,1.892100e+00,2.092000e+00,2.324000e+00,2.394100e+00,&
     & 3.631900e+00,3.201800e+00,3.080700e+00,2.973600e+00,2.872100e+00,&
     & 2.669900e+00,2.368900e+00,2.676700e+00,2.981800e+00,3.062100e+00,&
     & 4.429400e+00,3.912400e+00,3.736300e+00,3.582600e+00,3.503100e+00,&
     & 3.193600e+00,2.916200e+00,3.334600e+00,3.729500e+00,3.813900e+00,&
     & 1.364500e+00,1.203000e+00,1.225100e+00,1.198000e+00,1.126700e+00,&
     & 1.049600e+00,9.400700e-01,9.873800e-01,1.079500e+00,1.132100e+00,&
     & 1.887500e+00,1.671600e+00,1.678700e+00,1.635700e+00,1.549100e+00,&
     & 1.442000e+00,1.284400e+00,1.370900e+00,1.511200e+00,1.570800e+00,&
     & 2.523500e+00,2.240500e+00,2.201800e+00,2.138300e+00,2.041800e+00,&
     & 1.903400e+00,1.679700e+00,1.830900e+00,2.036900e+00,2.095600e+00,&
     & 3.246000e+00,2.889000e+00,2.798900e+00,2.708900e+00,2.611300e+00,&
     & 2.407000e+00,2.124300e+00,2.372700e+00,2.644300e+00,2.714100e+00,&
     & 4.041500e+00,3.601500e+00,3.454900e+00,3.342700e+00,3.230000e+00,&
     & 2.932100e+00,2.635400e+00,2.988800e+00,3.339000e+00,3.418600e+00,&
     & 1.154300e+00,1.025100e+00,1.034900e+00,9.879400e-01,9.320500e-01,&
     & 8.844000e-01,8.032000e-01,8.451900e-01,9.271100e-01,1.020600e+00,&
     & 1.610800e+00,1.431000e+00,1.447600e+00,1.388500e+00,1.323500e+00,&
     & 1.249200e+00,1.116900e+00,1.195800e+00,1.314100e+00,1.370500e+00,&
     & 2.188500e+00,1.953200e+00,1.955000e+00,1.874100e+00,1.793200e+00,&
     & 1.681900e+00,1.484300e+00,1.610600e+00,1.780100e+00,1.844700e+00,&
     & 2.881100e+00,2.583000e+00,2.535700e+00,2.443600e+00,2.344700e+00,&
     & 2.161300e+00,1.904300e+00,2.100500e+00,2.333900e+00,2.405700e+00,&
     & 3.676400e+00,3.307900e+00,3.179600e+00,3.091100e+00,2.953900e+00,&
     & 2.675700e+00,2.387400e+00,2.674100e+00,2.982000e+00,3.061100e+00,&
     & 1.030200e+00,9.217600e-01,9.057400e-01,8.461500e-01,7.997000e-01,&
     & 7.697600e-01,7.027400e-01,7.428300e-01,8.156500e-01,2.701700e+00,&
     & 1.445800e+00,1.291800e+00,1.272600e+00,1.204100e+00,1.154600e+00,&
     & 1.105200e+00,9.953500e-01,1.058400e+00,1.169100e+00,2.933600e+00,&
     & 1.985600e+00,1.778700e+00,1.742700e+00,1.669100e+00,1.601600e+00,&
     & 1.513700e+00,1.340700e+00,1.447100e+00,1.606000e+00,3.215400e+00,&
     & 2.649300e+00,2.382000e+00,2.310300e+00,2.228400e+00,2.131600e+00,&
     & 1.976900e+00,1.743500e+00,1.914300e+00,2.124800e+00,3.463300e+00,&
     & 3.428100e+00,3.094600e+00,2.964500e+00,2.874800e+00,2.724500e+00,&
     & 2.487900e+00,2.210300e+00,2.455100e+00,2.730700e+00,3.600000e+00,&
     & 1.098700e+00,9.888300e-01,9.445700e-01,8.759900e-01,8.357000e-01,&
     & 8.017400e-01,7.290800e-01,7.640000e-01,8.504000e-01,4.164400e+00,&
     & 1.551900e+00,1.396000e+00,1.327200e+00,1.241900e+00,1.193600e+00,&
     & 1.147500e+00,1.032300e+00,1.090400e+00,1.211800e+00,4.437700e+00,&
     & 2.116800e+00,1.906200e+00,1.815600e+00,1.715100e+00,1.655400e+00,&
     & 1.561200e+00,1.390000e+00,1.482300e+00,1.650400e+00,4.764800e+00,&
     & 2.810900e+00,2.537200e+00,2.406500e+00,2.297700e+00,2.198400e+00,&
     & 2.033800e+00,1.805700e+00,1.949100e+00,2.179200e+00,5.136700e+00,&
     & 3.620000e+00,3.275700e+00,3.097300e+00,2.972500e+00,2.804900e+00,&
     & 2.572600e+00,2.273100e+00,2.475900e+00,2.785700e+00,5.393100e+00,&
     & 1.183400e+00,1.071800e+00,9.983200e-01,9.195100e-01,8.806600e-01,&
     & 8.398400e-01,7.551600e-01,7.762900e-01,8.692400e-01,5.019600e+00,&
     & 1.681700e+00,1.521000e+00,1.412500e+00,1.304100e+00,1.246800e+00,&
     & 1.191000e+00,1.064400e+00,1.099100e+00,1.238400e+00,5.325300e+00,&
     & 2.288400e+00,2.069700e+00,1.923700e+00,1.792600e+00,1.710500e+00,&
     & 1.614100e+00,1.435600e+00,1.490300e+00,1.682700e+00,5.693400e+00,&
     & 3.015300e+00,2.727500e+00,2.544900e+00,2.391100e+00,2.257800e+00,&
     & 2.105800e+00,1.868600e+00,1.945300e+00,2.202600e+00,6.112300e+00,&
     & 3.852100e+00,3.485200e+00,3.264600e+00,3.081400e+00,2.880000e+00,&
     & 2.661300e+00,2.337700e+00,2.457600e+00,2.786600e+00,6.428200e+00,&
     & 1.285200e+00,1.164600e+00,1.064200e+00,9.755600e-01,9.242000e-01,&
     & 8.762000e-01,7.719600e-01,7.714600e-01,8.763000e-01,4.855600e+00,&
     & 1.830100e+00,1.658900e+00,1.515200e+00,1.389300e+00,1.305500e+00,&
     & 1.232300e+00,1.089500e+00,1.087500e+00,1.237200e+00,5.176200e+00,&
     & 2.488900e+00,2.255800e+00,2.061300e+00,1.903400e+00,1.777400e+00,&
     & 1.669200e+00,1.471700e+00,1.465700e+00,1.674300e+00,5.598400e+00,&
     & 3.257000e+00,2.949300e+00,2.712700e+00,2.517500e+00,2.337100e+00,&
     & 2.180000e+00,1.909900e+00,1.904100e+00,2.179500e+00,5.998900e+00,&
     & 4.132600e+00,3.738200e+00,3.472600e+00,3.217200e+00,2.981100e+00,&
     & 2.743300e+00,2.397700e+00,2.406000e+00,2.751900e+00,6.321800e+00/
      data  absa(1:300,14) /                                            &
     & 6.346700e+00,5.553600e+00,4.760500e+00,3.967300e+00,3.438600e+00,&
     & 3.008900e+00,3.229500e+00,3.756700e+00,4.053100e+00,4.192300e+00,&
     & 7.396400e+00,6.472100e+00,5.547800e+00,4.623400e+00,4.080800e+00,&
     & 3.613700e+00,3.978200e+00,4.629800e+00,5.026800e+00,5.184500e+00,&
     & 8.425000e+00,7.372100e+00,6.319200e+00,5.266300e+00,4.683600e+00,&
     & 4.237600e+00,4.803500e+00,5.591900e+00,6.074000e+00,6.264800e+00,&
     & 9.449900e+00,8.268900e+00,7.087900e+00,5.923900e+00,5.278600e+00,&
     & 4.899900e+00,5.676000e+00,6.605200e+00,7.180200e+00,7.402200e+00,&
     & 1.042300e+01,9.120000e+00,7.817400e+00,6.588200e+00,5.855800e+00,&
     & 5.601400e+00,6.588400e+00,7.667500e+00,8.325500e+00,8.580300e+00,&
     & 6.096000e+00,5.334100e+00,4.572300e+00,3.812600e+00,3.406900e+00,&
     & 2.939600e+00,3.219700e+00,3.745500e+00,4.028600e+00,4.215500e+00,&
     & 7.167600e+00,6.271900e+00,5.376100e+00,4.496600e+00,4.041200e+00,&
     & 3.549300e+00,3.947200e+00,4.592000e+00,4.969900e+00,5.177500e+00,&
     & 8.227500e+00,7.199300e+00,6.171000e+00,5.208900e+00,4.656800e+00,&
     & 4.198500e+00,4.744000e+00,5.521100e+00,6.014900e+00,6.237000e+00,&
     & 9.279900e+00,8.120200e+00,6.960400e+00,5.958600e+00,5.271600e+00,&
     & 4.896000e+00,5.659900e+00,6.587200e+00,7.173500e+00,7.441400e+00,&
     & 1.029000e+01,9.004400e+00,7.718100e+00,6.721100e+00,5.875700e+00,&
     & 5.624500e+00,6.655800e+00,7.745200e+00,8.406900e+00,8.737300e+00,&
     & 5.603900e+00,4.903600e+00,4.203200e+00,3.544500e+00,3.190200e+00,&
     & 2.753700e+00,3.081300e+00,3.584000e+00,3.857600e+00,4.076400e+00,&
     & 6.686300e+00,5.850600e+00,5.015000e+00,4.281500e+00,3.827000e+00,&
     & 3.335200e+00,3.785700e+00,4.404800e+00,4.763700e+00,5.013100e+00,&
     & 7.773700e+00,6.802100e+00,5.830500e+00,5.066500e+00,4.459400e+00,&
     & 3.982700e+00,4.565900e+00,5.312400e+00,5.765900e+00,6.047700e+00,&
     & 8.850800e+00,7.744600e+00,6.638400e+00,5.881300e+00,5.085900e+00,&
     & 4.684000e+00,5.459100e+00,6.352700e+00,6.891400e+00,7.229100e+00,&
     & 9.907900e+00,8.669600e+00,7.431400e+00,6.653900e+00,5.710700e+00,&
     & 5.461800e+00,6.493300e+00,7.555600e+00,8.191600e+00,8.596700e+00,&
     & 5.042900e+00,4.412700e+00,3.782400e+00,3.256500e+00,2.911700e+00,&
     & 2.589800e+00,2.895800e+00,3.370200e+00,3.640800e+00,3.852600e+00,&
     & 6.116500e+00,5.352000e+00,4.587600e+00,4.030000e+00,3.541600e+00,&
     & 3.153200e+00,3.578000e+00,4.163300e+00,4.515500e+00,4.759500e+00,&
     & 7.220200e+00,6.317800e+00,5.415300e+00,4.849200e+00,4.182900e+00,&
     & 3.779000e+00,4.363100e+00,5.076600e+00,5.492800e+00,5.802900e+00,&
     & 8.327600e+00,7.286800e+00,6.246000e+00,5.653400e+00,4.822500e+00,&
     & 4.464000e+00,5.262500e+00,6.122100e+00,6.615600e+00,6.998400e+00,&
     & 9.414800e+00,8.238100e+00,7.061800e+00,6.422100e+00,5.476000e+00,&
     & 5.266800e+00,6.301200e+00,7.327900e+00,7.896200e+00,8.377400e+00,&
     & 4.480200e+00,3.920200e+00,3.360300e+00,2.966200e+00,2.661100e+00,&
     & 2.428800e+00,2.702600e+00,3.145500e+00,3.411400e+00,3.602400e+00,&
     & 5.540100e+00,4.847700e+00,4.155200e+00,3.738400e+00,3.263300e+00,&
     & 2.992800e+00,3.390000e+00,3.944300e+00,4.263600e+00,4.518800e+00,&
     & 6.643800e+00,5.813400e+00,4.983100e+00,4.544600e+00,3.888400e+00,&
     & 3.605300e+00,4.183500e+00,4.865800e+00,5.243500e+00,5.575400e+00,&
     & 7.770900e+00,6.799600e+00,5.833800e+00,5.346000e+00,4.546100e+00,&
     & 4.305500e+00,5.105100e+00,5.935900e+00,6.376300e+00,6.803100e+00,&
     & 8.889800e+00,7.778700e+00,6.698300e+00,6.126000e+00,5.226700e+00,&
     & 5.151700e+00,6.171200e+00,7.174800e+00,7.688800e+00,8.224200e+00,&
     & 3.895600e+00,3.408700e+00,2.922100e+00,2.628100e+00,2.405000e+00,&
     & 2.191600e+00,2.417400e+00,2.816100e+00,3.092700e+00,3.224400e+00,&
     & 4.930300e+00,4.314100e+00,3.704600e+00,3.384400e+00,3.010500e+00,&
     & 2.777000e+00,3.141200e+00,3.657500e+00,3.981400e+00,4.191000e+00,&
     & 6.021800e+00,5.269100e+00,4.538700e+00,4.165700e+00,3.635000e+00,&
     & 3.417200e+00,3.972600e+00,4.621400e+00,4.989700e+00,5.299100e+00,&
     & 7.156800e+00,6.262300e+00,5.434500e+00,4.965800e+00,4.296600e+00,&
     & 4.156300e+00,4.935100e+00,5.738300e+00,6.143400e+00,6.585700e+00,&
     & 8.300300e+00,7.262800e+00,6.367100e+00,5.759000e+00,4.964400e+00,&
     & 5.029800e+00,6.022900e+00,7.004600e+00,7.495700e+00,8.037500e+00/
      data  absa(301:650,14) /                                          &
     & 3.338800e+00,2.921500e+00,2.518700e+00,2.325300e+00,2.111900e+00,&
     & 1.916400e+00,2.085900e+00,2.431500e+00,2.698200e+00,2.783600e+00,&
     & 4.335900e+00,3.794000e+00,3.286900e+00,3.029300e+00,2.710200e+00,&
     & 2.502600e+00,2.803200e+00,3.266100e+00,3.595300e+00,3.740000e+00,&
     & 5.412000e+00,4.735600e+00,4.139500e+00,3.777800e+00,3.351300e+00,&
     & 3.168800e+00,3.657200e+00,4.257400e+00,4.645900e+00,4.880500e+00,&
     & 6.542800e+00,5.725000e+00,5.063900e+00,4.562000e+00,4.036200e+00,&
     & 3.952100e+00,4.670100e+00,5.435000e+00,5.881400e+00,6.234400e+00,&
     & 7.701100e+00,6.738500e+00,6.035900e+00,5.368900e+00,4.739800e+00,&
     & 4.867100e+00,5.810400e+00,6.760900e+00,7.285500e+00,7.756400e+00,&
     & 2.833200e+00,2.479000e+00,2.158800e+00,2.051700e+00,1.821200e+00,&
     & 1.642700e+00,1.755500e+00,2.046300e+00,2.280800e+00,2.341700e+00,&
     & 3.784500e+00,3.311500e+00,2.906200e+00,2.730700e+00,2.400200e+00,&
     & 2.207600e+00,2.439400e+00,2.842400e+00,3.148900e+00,3.255000e+00,&
     & 4.834100e+00,4.229900e+00,3.758400e+00,3.458200e+00,3.043700e+00,&
     & 2.874800e+00,3.283400e+00,3.824200e+00,4.198300e+00,4.382300e+00,&
     & 5.961100e+00,5.216000e+00,4.684100e+00,4.225700e+00,3.738100e+00,&
     & 3.669500e+00,4.300800e+00,5.008000e+00,5.465300e+00,5.741300e+00,&
     & 7.138800e+00,6.246500e+00,5.651600e+00,5.031700e+00,4.485100e+00,&
     & 4.596600e+00,5.460600e+00,6.357100e+00,6.930300e+00,7.290100e+00,&
     & 2.371200e+00,2.074800e+00,1.851400e+00,1.761000e+00,1.541000e+00,&
     & 1.377600e+00,1.460200e+00,1.701900e+00,1.891700e+00,1.949100e+00,&
     & 3.270600e+00,2.861800e+00,2.553500e+00,2.412100e+00,2.095300e+00,&
     & 1.909100e+00,2.086700e+00,2.431500e+00,2.696100e+00,2.785500e+00,&
     & 4.292800e+00,3.756200e+00,3.370700e+00,3.132500e+00,2.732300e+00,&
     & 2.556800e+00,2.889700e+00,3.365800e+00,3.711200e+00,3.856600e+00,&
     & 5.408400e+00,4.732400e+00,4.287200e+00,3.907400e+00,3.433300e+00,&
     & 3.340300e+00,3.875900e+00,4.514800e+00,4.965700e+00,5.173000e+00,&
     & 6.594500e+00,5.770200e+00,5.261200e+00,4.734100e+00,4.202700e+00,&
     & 4.261900e+00,5.020300e+00,5.847500e+00,6.424700e+00,6.700700e+00,&
     & 2.023800e+00,1.770900e+00,1.627100e+00,1.521300e+00,1.321100e+00,&
     & 1.170800e+00,1.247000e+00,1.452900e+00,1.610000e+00,4.367500e+00,&
     & 2.873900e+00,2.514700e+00,2.302000e+00,2.139300e+00,1.857500e+00,&
     & 1.673500e+00,1.830500e+00,2.132400e+00,2.356500e+00,4.322700e+00,&
     & 3.865000e+00,3.381900e+00,3.100900e+00,2.843800e+00,2.483200e+00,&
     & 2.302100e+00,2.592400e+00,3.019400e+00,3.320200e+00,4.393800e+00,&
     & 4.977700e+00,4.355500e+00,3.996400e+00,3.630900e+00,3.187100e+00,&
     & 3.070000e+00,3.525800e+00,4.107300e+00,4.524900e+00,4.961200e+00,&
     & 6.182500e+00,5.411400e+00,4.952800e+00,4.482500e+00,3.986900e+00,&
     & 3.980600e+00,4.638200e+00,5.402700e+00,5.952100e+00,6.194000e+00,&
     & 2.080400e+00,1.820400e+00,1.700500e+00,1.553600e+00,1.350000e+00,&
     & 1.204400e+00,1.305300e+00,1.520100e+00,1.668300e+00,7.099500e+00,&
     & 2.937200e+00,2.571000e+00,2.412300e+00,2.187600e+00,1.910300e+00,&
     & 1.735600e+00,1.913100e+00,2.228400e+00,2.449300e+00,7.095000e+00,&
     & 3.962800e+00,3.473100e+00,3.241100e+00,2.926500e+00,2.561400e+00,&
     & 2.394700e+00,2.697600e+00,3.143400e+00,3.470000e+00,6.963700e+00,&
     & 5.124800e+00,4.493700e+00,4.160300e+00,3.759700e+00,3.317700e+00,&
     & 3.201500e+00,3.668700e+00,4.274600e+00,4.722000e+00,6.906900e+00,&
     & 6.404800e+00,5.623800e+00,5.159600e+00,4.665300e+00,4.186900e+00,&
     & 4.150300e+00,4.829100e+00,5.627800e+00,6.213100e+00,7.373500e+00,&
     & 2.160600e+00,1.891900e+00,1.777600e+00,1.598800e+00,1.393100e+00,&
     & 1.260700e+00,1.376500e+00,1.603000e+00,1.758400e+00,8.853900e+00,&
     & 3.024100e+00,2.653800e+00,2.510800e+00,2.255800e+00,1.976000e+00,&
     & 1.813500e+00,2.004800e+00,2.335400e+00,2.568200e+00,8.829900e+00,&
     & 4.085400e+00,3.591700e+00,3.375800e+00,3.034700e+00,2.673200e+00,&
     & 2.511700e+00,2.810600e+00,3.274300e+00,3.609500e+00,8.667000e+00,&
     & 5.304400e+00,4.678600e+00,4.344300e+00,3.921300e+00,3.496900e+00,&
     & 3.358500e+00,3.804000e+00,4.433000e+00,4.907500e+00,8.570000e+00,&
     & 6.644000e+00,5.881200e+00,5.412000e+00,4.912500e+00,4.428200e+00,&
     & 4.342900e+00,4.985500e+00,5.810200e+00,6.449200e+00,8.683000e+00,&
     & 2.252500e+00,1.986400e+00,1.864300e+00,1.660200e+00,1.461400e+00,&
     & 1.335000e+00,1.456900e+00,1.696000e+00,1.853900e+00,8.760100e+00,&
     & 3.133200e+00,2.763200e+00,2.601800e+00,2.336700e+00,2.076500e+00,&
     & 1.917100e+00,2.110500e+00,2.457800e+00,2.694500e+00,8.683700e+00,&
     & 4.214600e+00,3.726900e+00,3.496300e+00,3.160900e+00,2.832600e+00,&
     & 2.652200e+00,2.939000e+00,3.423400e+00,3.771500e+00,8.595200e+00,&
     & 5.471800e+00,4.864500e+00,4.531300e+00,4.122100e+00,3.716300e+00,&
     & 3.538700e+00,3.944200e+00,4.594500e+00,5.079600e+00,8.549400e+00,&
     & 6.876100e+00,6.137200e+00,5.671800e+00,5.222900e+00,4.715500e+00,&
     & 4.563700e+00,5.116300e+00,5.964500e+00,6.638800e+00,8.727500e+00/
      data  absa(1:300,15) /                                            &
     & 7.403800e+00,6.478500e+00,5.553200e+00,4.628000e+00,3.738900e+00,&
     & 4.385300e+00,5.251400e+00,6.090200e+00,6.234600e+00,6.598100e+00,&
     & 8.577000e+00,7.505100e+00,6.433200e+00,5.361300e+00,4.492200e+00,&
     & 5.533200e+00,6.624800e+00,7.685600e+00,7.878800e+00,8.335800e+00,&
     & 9.719600e+00,8.492400e+00,7.290100e+00,6.075400e+00,5.428700e+00,&
     & 6.775800e+00,8.117400e+00,9.429500e+00,9.645400e+00,1.023100e+01,&
     & 1.082300e+01,9.470100e+00,8.117500e+00,6.765000e+00,6.484500e+00,&
     & 8.096800e+00,9.697100e+00,1.124700e+01,1.153500e+01,1.223200e+01,&
     & 1.186200e+01,1.038000e+01,8.897500e+00,7.414900e+00,7.598700e+00,&
     & 9.485400e+00,1.136700e+01,1.318300e+01,1.353500e+01,1.432200e+01,&
     & 7.248700e+00,6.342800e+00,5.436900e+00,4.530900e+00,3.830500e+00,&
     & 4.686600e+00,5.612200e+00,6.510900e+00,6.694400e+00,7.223700e+00,&
     & 8.463200e+00,7.405400e+00,6.347700e+00,5.290000e+00,4.797200e+00,&
     & 5.977400e+00,7.161200e+00,8.309100e+00,8.544800e+00,9.220300e+00,&
     & 9.637600e+00,8.433100e+00,7.228600e+00,6.024100e+00,5.927700e+00,&
     & 7.403200e+00,8.867000e+00,1.028800e+01,1.059100e+01,1.142000e+01,&
     & 1.078700e+01,9.438600e+00,8.090500e+00,6.742300e+00,7.136500e+00,&
     & 8.912000e+00,1.067500e+01,1.238700e+01,1.276600e+01,1.375100e+01,&
     & 1.187600e+01,1.039200e+01,8.907600e+00,7.426300e+00,8.409300e+00,&
     & 1.050200e+01,1.257700e+01,1.460000e+01,1.506100e+01,1.621600e+01,&
     & 6.806000e+00,5.955400e+00,5.104800e+00,4.254100e+00,3.794500e+00,&
     & 4.679300e+00,5.606600e+00,6.506900e+00,6.726200e+00,7.370500e+00,&
     & 8.051200e+00,7.044900e+00,6.038700e+00,5.032400e+00,4.872300e+00,&
     & 6.080700e+00,7.284500e+00,8.453400e+00,8.747100e+00,9.578500e+00,&
     & 9.277100e+00,8.117600e+00,6.958100e+00,5.798600e+00,6.122700e+00,&
     & 7.649000e+00,9.162000e+00,1.063400e+01,1.101300e+01,1.204900e+01,&
     & 1.046100e+01,9.153500e+00,7.846000e+00,6.554800e+00,7.481000e+00,&
     & 9.344500e+00,1.119300e+01,1.299500e+01,1.347400e+01,1.472600e+01,&
     & 1.161200e+01,1.016100e+01,8.709400e+00,7.396300e+00,8.901400e+00,&
     & 1.111900e+01,1.332300e+01,1.546200e+01,1.605500e+01,1.752500e+01,&
     & 6.272700e+00,5.488700e+00,4.704700e+00,3.920700e+00,3.652500e+00,&
     & 4.500000e+00,5.389800e+00,6.258800e+00,6.514900e+00,7.156700e+00,&
     & 7.516900e+00,6.577400e+00,5.637900e+00,4.698500e+00,4.791100e+00,&
     & 5.975100e+00,7.159600e+00,8.314100e+00,8.662000e+00,9.504400e+00,&
     & 8.786100e+00,7.688000e+00,6.589800e+00,5.530500e+00,6.124700e+00,&
     & 7.648800e+00,9.166900e+00,1.064500e+01,1.110600e+01,1.217300e+01,&
     & 1.002600e+01,8.772800e+00,7.519700e+00,6.447300e+00,7.608100e+00,&
     & 9.502200e+00,1.138600e+01,1.322500e+01,1.381900e+01,1.512100e+01,&
     & 1.121500e+01,9.813200e+00,8.411700e+00,7.463400e+00,9.176300e+00,&
     & 1.146500e+01,1.373400e+01,1.595600e+01,1.669700e+01,1.824300e+01,&
     & 5.709400e+00,4.995800e+00,4.282200e+00,3.575100e+00,3.445600e+00,&
     & 4.240800e+00,5.080800e+00,5.900100e+00,6.164000e+00,6.772400e+00,&
     & 6.961000e+00,6.090900e+00,5.220900e+00,4.395000e+00,4.616000e+00,&
     & 5.737800e+00,6.874600e+00,7.987700e+00,8.393300e+00,9.164100e+00,&
     & 8.245200e+00,7.214600e+00,6.184000e+00,5.297800e+00,5.997300e+00,&
     & 7.490000e+00,8.975700e+00,1.042900e+01,1.097400e+01,1.196700e+01,&
     & 9.531700e+00,8.340300e+00,7.148900e+00,6.359400e+00,7.569000e+00,&
     & 9.457000e+00,1.133000e+01,1.316600e+01,1.387900e+01,1.510200e+01,&
     & 1.077400e+01,9.427100e+00,8.080800e+00,7.516500e+00,9.260000e+00,&
     & 1.157000e+01,1.386400e+01,1.611600e+01,1.702100e+01,1.848100e+01,&
     & 5.089200e+00,4.453100e+00,3.817000e+00,3.219900e+00,3.211300e+00,&
     & 4.011300e+00,4.805200e+00,5.578400e+00,5.794600e+00,6.416800e+00,&
     & 6.341500e+00,5.548900e+00,4.756300e+00,4.048200e+00,4.340700e+00,&
     & 5.421200e+00,6.494300e+00,7.543400e+00,7.903100e+00,8.673400e+00,&
     & 7.623000e+00,6.670100e+00,5.717300e+00,5.037200e+00,5.704900e+00,&
     & 7.126800e+00,8.542700e+00,9.927700e+00,1.050300e+01,1.140100e+01,&
     & 8.942700e+00,7.825000e+00,6.707200e+00,6.186400e+00,7.305400e+00,&
     & 9.126200e+00,1.093600e+01,1.271700e+01,1.353000e+01,1.459600e+01,&
     & 1.023400e+01,8.955200e+00,7.675700e+00,7.440800e+00,9.097500e+00,&
     & 1.136400e+01,1.361900e+01,1.583700e+01,1.685700e+01,1.818200e+01/
      data  absa(301:650,15) /                                          &
     & 4.470100e+00,3.911400e+00,3.352700e+00,2.849100e+00,3.052500e+00,&
     & 3.812000e+00,4.567100e+00,5.302900e+00,5.517000e+00,6.105400e+00,&
     & 5.702500e+00,4.989700e+00,4.276900e+00,3.707600e+00,4.144100e+00,&
     & 5.176800e+00,6.202200e+00,7.204500e+00,7.535300e+00,8.288800e+00,&
     & 6.990300e+00,6.116600e+00,5.242900e+00,4.742100e+00,5.471100e+00,&
     & 6.834500e+00,8.190800e+00,9.515800e+00,1.002100e+01,1.094400e+01,&
     & 8.311600e+00,7.272700e+00,6.233900e+00,5.934700e+00,7.027700e+00,&
     & 8.778800e+00,1.052300e+01,1.222900e+01,1.297000e+01,1.405600e+01,&
     & 9.643300e+00,8.437900e+00,7.240400e+00,7.253900e+00,8.819100e+00,&
     & 1.101500e+01,1.320200e+01,1.535100e+01,1.638100e+01,1.763600e+01,&
     & 3.881500e+00,3.396300e+00,2.911200e+00,2.514400e+00,2.890100e+00,&
     & 3.610700e+00,4.326700e+00,5.023700e+00,5.256200e+00,5.784300e+00,&
     & 5.080300e+00,4.445300e+00,3.810300e+00,3.358800e+00,3.958100e+00,&
     & 4.943300e+00,5.924500e+00,6.883100e+00,7.224600e+00,7.920500e+00,&
     & 6.364200e+00,5.568700e+00,4.773200e+00,4.406100e+00,5.263500e+00,&
     & 6.574600e+00,7.879300e+00,9.159100e+00,9.661200e+00,1.053300e+01,&
     & 7.696200e+00,6.734200e+00,5.801600e+00,5.621800e+00,6.807300e+00,&
     & 8.503500e+00,1.019100e+01,1.184200e+01,1.256400e+01,1.361800e+01,&
     & 9.060000e+00,7.927600e+00,6.888700e+00,6.978200e+00,8.596500e+00,&
     & 1.073800e+01,1.287200e+01,1.495900e+01,1.591600e+01,1.720100e+01,&
     & 3.324800e+00,2.909300e+00,2.493700e+00,2.272400e+00,2.696100e+00,&
     & 3.368400e+00,4.035900e+00,4.690000e+00,4.949900e+00,5.397300e+00,&
     & 4.480800e+00,3.920700e+00,3.361500e+00,3.092000e+00,3.739500e+00,&
     & 4.670600e+00,5.597100e+00,6.504400e+00,6.872700e+00,7.483600e+00,&
     & 5.750500e+00,5.031700e+00,4.343500e+00,4.101600e+00,5.020500e+00,&
     & 6.271400e+00,7.516000e+00,8.739700e+00,9.270900e+00,1.004700e+01,&
     & 7.090800e+00,6.204400e+00,5.378200e+00,5.288200e+00,6.559700e+00,&
     & 8.194400e+00,9.821700e+00,1.141600e+01,1.214200e+01,1.313000e+01,&
     & 8.473200e+00,7.414100e+00,6.491300e+00,6.628700e+00,8.356500e+00,&
     & 1.043800e+01,1.251200e+01,1.455100e+01,1.551400e+01,1.672300e+01,&
     & 2.892000e+00,2.530600e+00,2.169300e+00,2.098600e+00,2.512400e+00,&
     & 3.138800e+00,3.762500e+00,4.375200e+00,4.667200e+00,5.615700e+00,&
     & 4.004000e+00,3.503500e+00,3.023800e+00,2.937600e+00,3.566700e+00,&
     & 4.455900e+00,5.341600e+00,6.211500e+00,6.621000e+00,7.169100e+00,&
     & 5.252900e+00,4.596300e+00,3.980400e+00,3.943600e+00,4.839700e+00,&
     & 6.046500e+00,7.247400e+00,8.428200e+00,9.002300e+00,9.688500e+00,&
     & 6.600900e+00,5.775800e+00,5.045100e+00,5.123600e+00,6.390100e+00,&
     & 7.983100e+00,9.569000e+00,1.112800e+01,1.189800e+01,1.279000e+01,&
     & 8.035800e+00,7.031400e+00,6.214600e+00,6.465000e+00,8.196400e+00,&
     & 1.024000e+01,1.227400e+01,1.428300e+01,1.531700e+01,1.640500e+01,&
     & 2.959700e+00,2.589700e+00,2.265500e+00,2.276900e+00,2.735900e+00,&
     & 3.413100e+00,4.092400e+00,4.762200e+00,5.136900e+00,8.766400e+00,&
     & 4.109000e+00,3.595400e+00,3.127400e+00,3.208600e+00,3.889100e+00,&
     & 4.858900e+00,5.825500e+00,6.776100e+00,7.297400e+00,9.142900e+00,&
     & 5.425700e+00,4.747500e+00,4.143200e+00,4.307100e+00,5.296000e+00,&
     & 6.617800e+00,7.932700e+00,9.230000e+00,9.913900e+00,1.087700e+01,&
     & 6.863500e+00,6.005600e+00,5.303100e+00,5.572600e+00,6.972800e+00,&
     & 8.711700e+00,1.044400e+01,1.215200e+01,1.306800e+01,1.395600e+01,&
     & 8.400700e+00,7.350600e+00,6.601000e+00,7.037600e+00,8.924900e+00,&
     & 1.115000e+01,1.336700e+01,1.554700e+01,1.673600e+01,1.786100e+01,&
     & 3.070600e+00,2.686800e+00,2.378600e+00,2.465000e+00,2.937600e+00,&
     & 3.660600e+00,4.390000e+00,5.109700e+00,5.552300e+00,1.112200e+01,&
     & 4.289400e+00,3.753200e+00,3.313500e+00,3.494200e+00,4.213900e+00,&
     & 5.264600e+00,6.312100e+00,7.346600e+00,7.937600e+00,1.113600e+01,&
     & 5.688400e+00,4.977300e+00,4.426000e+00,4.703900e+00,5.751900e+00,&
     & 7.186600e+00,8.616500e+00,1.002900e+01,1.082700e+01,1.249900e+01,&
     & 7.250500e+00,6.344800e+00,5.706600e+00,6.094100e+00,7.559200e+00,&
     & 9.444300e+00,1.132300e+01,1.317200e+01,1.423000e+01,1.515700e+01,&
     & 8.972900e+00,7.851300e+00,7.167700e+00,7.701800e+00,9.694500e+00,&
     & 1.211200e+01,1.451900e+01,1.689600e+01,1.823500e+01,1.940200e+01,&
     & 3.224600e+00,2.821600e+00,2.541000e+00,2.667200e+00,3.133500e+00,&
     & 3.895300e+00,4.671800e+00,5.439800e+00,5.939800e+00,1.104800e+01,&
     & 4.539600e+00,3.972200e+00,3.605700e+00,3.812400e+00,4.523500e+00,&
     & 5.633400e+00,6.755100e+00,7.865400e+00,8.565500e+00,1.152300e+01,&
     & 6.082200e+00,5.321900e+00,4.871600e+00,5.151400e+00,6.186100e+00,&
     & 7.721400e+00,9.258100e+00,1.077600e+01,1.169900e+01,1.315000e+01,&
     & 7.860000e+00,6.877700e+00,6.319300e+00,6.690300e+00,8.136700e+00,&
     & 1.016400e+01,1.218700e+01,1.418800e+01,1.539200e+01,1.628900e+01,&
     & 9.848300e+00,8.618200e+00,7.961900e+00,8.455500e+00,1.046700e+01,&
     & 1.307700e+01,1.568000e+01,1.824600e+01,1.974900e+01,2.094600e+01/
      data  absa(1:300,16) /                                            &
     & 7.512700e+00,6.573700e+00,5.634900e+00,4.695800e+00,3.877900e+00,&
     & 4.841600e+00,5.798100e+00,6.718900e+00,6.800200e+00,7.240800e+00,&
     & 8.697900e+00,7.610900e+00,6.523900e+00,5.436800e+00,4.790300e+00,&
     & 5.980700e+00,7.160900e+00,8.299400e+00,8.310900e+00,8.945500e+00,&
     & 9.731700e+00,8.604200e+00,7.299300e+00,6.083000e+00,5.852600e+00,&
     & 7.307600e+00,8.749000e+00,1.003400e+01,1.026300e+01,1.081600e+01,&
     & 1.096100e+01,9.591300e+00,8.221400e+00,6.851400e+00,7.153200e+00,&
     & 8.933600e+00,1.069600e+01,1.239500e+01,1.254100e+01,1.321800e+01,&
     & 1.200700e+01,1.050600e+01,9.006300e+00,7.505500e+00,8.553300e+00,&
     & 1.068200e+01,1.278900e+01,1.482300e+01,1.500300e+01,1.597500e+01,&
     & 7.373100e+00,6.451600e+00,5.530100e+00,4.608600e+00,4.293700e+00,&
     & 5.360900e+00,6.419800e+00,7.440800e+00,7.532900e+00,8.212400e+00,&
     & 8.602100e+00,7.527100e+00,6.452000e+00,5.376800e+00,5.367500e+00,&
     & 6.701800e+00,8.023700e+00,9.299700e+00,9.414000e+00,1.026400e+01,&
     & 9.788800e+00,8.565400e+00,7.342000e+00,6.118600e+00,6.549600e+00,&
     & 8.178200e+00,9.790400e+00,1.134400e+01,1.147400e+01,1.251900e+01,&
     & 1.094500e+01,9.576900e+00,8.209000e+00,6.841200e+00,8.047400e+00,&
     & 1.004800e+01,1.203000e+01,1.394400e+01,1.411400e+01,1.538800e+01,&
     & 1.204200e+01,1.053700e+01,9.033300e+00,7.528000e+00,9.706200e+00,&
     & 1.211700e+01,1.451100e+01,1.681900e+01,1.702400e+01,1.855800e+01,&
     & 6.943700e+00,6.075900e+00,5.208000e+00,4.340200e+00,4.502300e+00,&
     & 5.621400e+00,6.729700e+00,7.802600e+00,7.901200e+00,8.815500e+00,&
     & 8.207000e+00,7.181300e+00,6.155400e+00,5.129800e+00,5.732900e+00,&
     & 7.157800e+00,8.569900e+00,9.933600e+00,1.006000e+01,1.122800e+01,&
     & 9.449100e+00,8.268100e+00,7.087200e+00,5.906200e+00,7.070700e+00,&
     & 8.829700e+00,1.058100e+01,1.226200e+01,1.242200e+01,1.386000e+01,&
     & 1.064200e+01,9.311500e+00,7.981500e+00,6.651500e+00,8.665400e+00,&
     & 1.081900e+01,1.295400e+01,1.501300e+01,1.519400e+01,1.696600e+01,&
     & 1.180700e+01,1.033100e+01,8.855400e+00,7.941600e+00,1.058200e+01,&
     & 1.321200e+01,1.582000e+01,1.832200e+01,1.857100e+01,2.072100e+01,&
     & 6.425800e+00,5.622600e+00,4.819600e+00,4.016400e+00,4.598300e+00,&
     & 5.733900e+00,6.874000e+00,7.966100e+00,8.072800e+00,9.113200e+00,&
     & 7.691700e+00,6.730300e+00,5.769000e+00,4.807600e+00,5.986600e+00,&
     & 7.474900e+00,8.951800e+00,1.037700e+01,1.051500e+01,1.185700e+01,&
     & 8.981300e+00,7.858600e+00,6.736100e+00,5.667800e+00,7.531600e+00,&
     & 9.403800e+00,1.124700e+01,1.304900e+01,1.322800e+01,1.492500e+01,&
     & 1.023900e+01,8.959300e+00,7.679600e+00,6.950900e+00,9.261500e+00,&
     & 1.156400e+01,1.384500e+01,1.602800e+01,1.622000e+01,1.833300e+01,&
     & 1.144000e+01,1.001000e+01,8.583800e+00,8.509800e+00,1.133900e+01,&
     & 1.415900e+01,1.695300e+01,1.965600e+01,1.990600e+01,2.247600e+01,&
     & 5.877000e+00,5.142400e+00,4.407900e+00,3.673300e+00,4.629700e+00,&
     & 5.786600e+00,6.927700e+00,8.030800e+00,8.136900e+00,9.227200e+00,&
     & 7.152300e+00,6.258200e+00,5.364400e+00,4.641300e+00,6.184100e+00,&
     & 7.721300e+00,9.246100e+00,1.071800e+01,1.087300e+01,1.232500e+01,&
     & 8.461300e+00,7.403800e+00,6.346200e+00,5.957200e+00,7.933700e+00,&
     & 9.905700e+00,1.187200e+01,1.375800e+01,1.396500e+01,1.580000e+01,&
     & 9.767600e+00,8.546800e+00,7.325900e+00,7.423800e+00,9.891600e+00,&
     & 1.235200e+01,1.479100e+01,1.714700e+01,1.738400e+01,1.971900e+01,&
     & 1.102500e+01,9.647200e+00,8.271600e+00,9.140600e+00,1.217900e+01,&
     & 1.520800e+01,1.821100e+01,2.109700e+01,2.136400e+01,2.426700e+01,&
     & 5.265000e+00,4.606900e+00,3.948800e+00,3.418400e+00,4.553800e+00,&
     & 5.683400e+00,6.805900e+00,7.891400e+00,8.014500e+00,9.094000e+00,&
     & 6.547000e+00,5.728700e+00,4.910400e+00,4.691200e+00,6.250500e+00,&
     & 7.804300e+00,9.346300e+00,1.082500e+01,1.101000e+01,1.247900e+01,&
     & 7.853400e+00,6.871800e+00,5.890200e+00,6.164000e+00,8.213900e+00,&
     & 1.025700e+01,1.227400e+01,1.424500e+01,1.446800e+01,1.640600e+01,&
     & 9.200700e+00,8.050700e+00,6.900700e+00,7.821600e+00,1.042100e+01,&
     & 1.301400e+01,1.558100e+01,1.805500e+01,1.834400e+01,2.080900e+01,&
     & 1.051200e+01,9.198400e+00,7.884200e+00,9.742900e+00,1.298200e+01,&
     & 1.620600e+01,1.940700e+01,2.250200e+01,2.278900e+01,2.592800e+01/
      data  absa(301:650,16) /                                          &
     & 4.656500e+00,4.074500e+00,3.492500e+00,3.295600e+00,4.391100e+00,&
     & 5.486400e+00,6.569500e+00,7.611500e+00,7.743900e+00,8.783700e+00,&
     & 5.929200e+00,5.188100e+00,4.447000e+00,4.669700e+00,6.221900e+00,&
     & 7.768600e+00,9.304300e+00,1.079000e+01,1.098200e+01,1.245100e+01,&
     & 7.257600e+00,6.350500e+00,5.443300e+00,6.292200e+00,8.382300e+00,&
     & 1.046800e+01,1.254300e+01,1.453600e+01,1.480500e+01,1.676500e+01,&
     & 8.617900e+00,7.540600e+00,6.463300e+00,8.155000e+00,1.086600e+01,&
     & 1.356700e+01,1.624400e+01,1.884200e+01,1.918600e+01,2.174200e+01,&
     & 9.985100e+00,8.737000e+00,7.489800e+00,1.032100e+01,1.375200e+01,&
     & 1.717100e+01,2.056100e+01,2.382500e+01,2.417700e+01,2.750800e+01,&
     & 4.075400e+00,3.566000e+00,3.056600e+00,3.133300e+00,4.174900e+00,&
     & 5.210900e+00,6.237900e+00,7.239100e+00,7.382200e+00,8.358300e+00,&
     & 5.327300e+00,4.661400e+00,3.995600e+00,4.588000e+00,6.113200e+00,&
     & 7.632900e+00,9.137200e+00,1.060000e+01,1.081900e+01,1.223800e+01,&
     & 6.660700e+00,5.828100e+00,4.995600e+00,6.348900e+00,8.469200e+00,&
     & 1.057500e+01,1.265800e+01,1.467800e+01,1.499100e+01,1.695100e+01,&
     & 8.039400e+00,7.034400e+00,6.029600e+00,8.423700e+00,1.122400e+01,&
     & 1.401400e+01,1.678900e+01,1.946000e+01,1.985400e+01,2.247000e+01,&
     & 9.443700e+00,8.263300e+00,7.289500e+00,1.086800e+01,1.448000e+01,&
     & 1.808100e+01,2.165300e+01,2.511100e+01,2.551400e+01,2.899000e+01,&
     & 3.512100e+00,3.073100e+00,2.634100e+00,2.927900e+00,3.901300e+00,&
     & 4.875400e+00,5.836800e+00,6.764400e+00,6.892000e+00,7.815000e+00,&
     & 4.722300e+00,4.132100e+00,3.541600e+00,4.424000e+00,5.894700e+00,&
     & 7.360200e+00,8.823700e+00,1.023400e+01,1.047300e+01,1.181800e+01,&
     & 6.047800e+00,5.291800e+00,4.535900e+00,6.311800e+00,8.410500e+00,&
     & 1.050400e+01,1.258500e+01,1.459400e+01,1.494800e+01,1.683700e+01,&
     & 7.440400e+00,6.510400e+00,5.828200e+00,8.590800e+00,1.144700e+01,&
     & 1.429400e+01,1.711900e+01,1.985600e+01,2.029900e+01,2.293500e+01,&
     & 8.873200e+00,7.764100e+00,7.553900e+00,1.132700e+01,1.509300e+01,&
     & 1.884900e+01,2.257300e+01,2.616500e+01,2.665200e+01,3.023000e+01,&
     & 3.061800e+00,2.679100e+00,2.296400e+00,2.936400e+00,3.912600e+00,&
     & 4.884700e+00,5.847500e+00,6.780800e+00,6.875600e+00,7.835800e+00,&
     & 4.231600e+00,3.702700e+00,3.174300e+00,4.335000e+00,5.776200e+00,&
     & 7.213800e+00,8.636700e+00,1.001900e+01,1.028400e+01,1.157000e+01,&
     & 5.545700e+00,4.852500e+00,4.361500e+00,6.337300e+00,8.449200e+00,&
     & 1.055000e+01,1.263800e+01,1.465600e+01,1.508200e+01,1.692300e+01,&
     & 6.959300e+00,6.089400e+00,5.913400e+00,8.866100e+00,1.181400e+01,&
     & 1.475100e+01,1.766900e+01,2.049100e+01,2.097800e+01,2.366400e+01,&
     & 8.439600e+00,7.384700e+00,7.965100e+00,1.194200e+01,1.591500e+01,&
     & 1.987200e+01,2.379300e+01,2.759300e+01,2.816100e+01,3.187200e+01,&
     & 3.157900e+00,2.763200e+00,2.389600e+00,3.554500e+00,4.736200e+00,&
     & 5.913600e+00,7.082300e+00,8.206900e+00,8.332300e+00,9.487300e+00,&
     & 4.374400e+00,3.827600e+00,3.510000e+00,5.153800e+00,6.867100e+00,&
     & 8.574300e+00,1.027400e+01,1.191400e+01,1.220900e+01,1.375700e+01,&
     & 5.747100e+00,5.028800e+00,5.003400e+00,7.497000e+00,9.988800e+00,&
     & 1.247200e+01,1.494200e+01,1.733300e+01,1.782100e+01,2.000700e+01,&
     & 7.262900e+00,6.355000e+00,7.047400e+00,1.056600e+01,1.407900e+01,&
     & 1.758400e+01,2.105700e+01,2.441900e+01,2.501900e+01,2.821100e+01,&
     & 8.906900e+00,7.793600e+00,9.528400e+00,1.428600e+01,1.903700e+01,&
     & 2.377100e+01,2.846800e+01,3.301000e+01,3.375100e+01,3.813000e+01,&
     & 3.300600e+00,2.888100e+00,2.866600e+00,4.298500e+00,5.727400e+00,&
     & 7.150600e+00,8.560700e+00,9.929900e+00,1.009700e+01,1.157000e+01,&
     & 4.595200e+00,4.020800e+00,4.102400e+00,6.151100e+00,8.195900e+00,&
     & 1.023500e+01,1.225400e+01,1.421500e+01,1.455800e+01,1.641500e+01,&
     & 6.117200e+00,5.352600e+00,5.920500e+00,8.878300e+00,1.183500e+01,&
     & 1.478100e+01,1.770600e+01,2.053100e+01,2.111400e+01,2.370500e+01,&
     & 7.906300e+00,6.918000e+00,8.381200e+00,1.256600e+01,1.674700e+01,&
     & 2.091500e+01,2.504900e+01,2.906400e+01,2.982000e+01,3.355200e+01,&
     & 9.940500e+00,8.698000e+00,1.136100e+01,1.703400e+01,2.269700e+01,&
     & 2.834700e+01,3.393600e+01,3.935700e+01,4.037700e+01,4.547100e+01,&
     & 3.524000e+00,3.083500e+00,3.450200e+00,5.173400e+00,6.894700e+00,&
     & 8.609100e+00,1.031000e+01,1.195400e+01,1.218700e+01,1.380600e+01,&
     & 5.019100e+00,4.391700e+00,4.887300e+00,7.327600e+00,9.765400e+00,&
     & 1.219400e+01,1.460800e+01,1.694300e+01,1.736600e+01,1.955900e+01,&
     & 6.861200e+00,6.003500e+00,6.994100e+00,1.048600e+01,1.397100e+01,&
     & 1.744600e+01,2.089600e+01,2.425600e+01,2.499300e+01,2.797900e+01,&
     & 8.993700e+00,7.871300e+00,9.917200e+00,1.487400e+01,1.981800e+01,&
     & 2.475400e+01,2.964200e+01,3.437400e+01,3.540700e+01,3.968900e+01,&
     & 1.138600e+01,9.963200e+00,1.344100e+01,2.015700e+01,2.686100e+01,&
     & 3.354500e+01,4.016500e+01,4.661600e+01,4.798100e+01,5.379300e+01/
 
!     the array absb(1175,NG03) = kb(5,5,13:59,NG03) contains absorption
!     coefs at the NG03=16 g-intervals for a range of pressure levels <
!     ~100mb, temperatures, and ratios of h2o to co2. the first index in
!     the array, js, runs from 1 to 5, and corresponds to different h2o
!     to co2 ratios, as expressed through the binary species parameter
!     eta, defined as eta = h2o/(h2o+rat*co2), where rat is the ratio
!     of the integrated line strength in the band of co2 to that of h2o.
!     for instance, js=1 refers to no h2o, js = 2 corresponds to eta =
!     0.25, etc.  the second index, jt, which runs from 1 to 5,
!     corresponds to different temperatures.  more specifically, jt = 1-5
!     means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     third index, jp, runs from 13 to 59 and refers to the corresponding
!     pressure level in pref (e.g. jp = 13 is for a pressure of 95.5835 mb).
!     the fourth index, ig, goes from 1 to NG03=16, and tells us which
!     g-interval the absorption coefficients are for.
 
      data  absb(1:300,1) /                                             &
     & 7.141800e-07,7.768300e-05,1.653000e-04,3.322100e-04,3.437500e-04,&
     & 7.289500e-07,7.789100e-05,1.581300e-04,2.961100e-04,3.515600e-04,&
     & 8.110400e-07,8.031300e-05,1.557300e-04,2.720500e-04,3.674400e-04,&
     & 9.803000e-07,8.464500e-05,1.582900e-04,2.578800e-04,3.912400e-04,&
     & 1.253200e-06,9.136700e-05,1.655600e-04,2.524300e-04,4.227800e-04,&
     & 5.866200e-07,6.321700e-05,1.339400e-04,2.681500e-04,2.802400e-04,&
     & 6.032200e-07,6.364400e-05,1.287100e-04,2.398900e-04,2.869700e-04,&
     & 6.770700e-07,6.585700e-05,1.272600e-04,2.211300e-04,3.001400e-04,&
     & 8.225100e-07,6.966300e-05,1.298400e-04,2.103800e-04,3.197600e-04,&
     & 1.053700e-06,7.547700e-05,1.362500e-04,2.066900e-04,3.455300e-04,&
     & 4.815900e-07,5.132700e-05,1.082800e-04,2.158000e-04,2.271600e-04,&
     & 4.995300e-07,5.189800e-05,1.045600e-04,1.938400e-04,2.328200e-04,&
     & 5.659200e-07,5.393700e-05,1.038300e-04,1.793800e-04,2.434200e-04,&
     & 6.906000e-07,5.727600e-05,1.063700e-04,1.713600e-04,2.592500e-04,&
     & 8.876400e-07,6.230000e-05,1.120600e-04,1.690100e-04,2.797800e-04,&
     & 3.953400e-07,4.165800e-05,8.750900e-05,1.734900e-04,1.832700e-04,&
     & 4.139500e-07,4.230500e-05,8.493400e-05,1.565300e-04,1.879400e-04,&
     & 4.729800e-07,4.417600e-05,8.471400e-05,1.454600e-04,1.962700e-04,&
     & 5.801700e-07,4.709400e-05,8.716200e-05,1.395300e-04,2.086200e-04,&
     & 7.484700e-07,5.141000e-05,9.216400e-05,1.382200e-04,2.249200e-04,&
     & 3.246100e-07,3.390000e-05,7.092800e-05,1.398200e-04,1.479000e-04,&
     & 3.431000e-07,3.457000e-05,6.914200e-05,1.266600e-04,1.517500e-04,&
     & 3.950200e-07,3.624300e-05,6.925800e-05,1.181700e-04,1.584000e-04,&
     & 4.870600e-07,3.877000e-05,7.155800e-05,1.138000e-04,1.681100e-04,&
     & 6.305200e-07,4.246200e-05,7.592400e-05,1.132200e-04,1.809700e-04,&
     & 2.666500e-07,2.769000e-05,5.771400e-05,1.130600e-04,1.197400e-04,&
     & 2.843300e-07,2.835200e-05,5.646700e-05,1.027800e-04,1.229500e-04,&
     & 3.299100e-07,2.982000e-05,5.678200e-05,9.622300e-05,1.283300e-04,&
     & 4.088500e-07,3.199000e-05,5.891600e-05,9.303300e-05,1.360100e-04,&
     & 5.311300e-07,3.514700e-05,6.266700e-05,9.295500e-05,1.460400e-04,&
     & 2.191500e-07,2.265000e-05,4.703200e-05,9.154500e-05,9.717400e-05,&
     & 2.356300e-07,2.328200e-05,4.617200e-05,8.348600e-05,9.986900e-05,&
     & 2.754800e-07,2.455300e-05,4.660300e-05,7.844100e-05,1.042200e-04,&
     & 3.431000e-07,2.641400e-05,4.854700e-05,7.613400e-05,1.103600e-04,&
     & 4.472400e-07,2.909600e-05,5.173700e-05,7.638100e-05,1.183900e-04,&
     & 1.803000e-07,1.855800e-05,3.835600e-05,7.407100e-05,7.916900e-05,&
     & 1.957900e-07,1.915500e-05,3.779100e-05,6.778800e-05,8.144600e-05,&
     & 2.308500e-07,2.025400e-05,3.830900e-05,6.395600e-05,8.504700e-05,&
     & 2.892400e-07,2.185900e-05,4.006200e-05,6.234600e-05,9.008200e-05,&
     & 3.784600e-07,2.413700e-05,4.278800e-05,6.282000e-05,9.665000e-05,&
     & 1.484700e-07,1.521500e-05,3.129000e-05,5.994900e-05,6.455200e-05,&
     & 1.628700e-07,1.576600e-05,3.094300e-05,5.505400e-05,6.647800e-05,&
     & 1.936600e-07,1.671300e-05,3.150300e-05,5.216100e-05,6.947500e-05,&
     & 2.440800e-07,1.809200e-05,3.305900e-05,5.106400e-05,7.363200e-05,&
     & 3.204800e-07,2.002200e-05,3.538300e-05,5.167500e-05,7.902500e-05,&
     & 1.228900e-07,1.248400e-05,2.547200e-05,4.819200e-05,5.260300e-05,&
     & 1.369700e-07,1.300900e-05,2.533400e-05,4.450400e-05,5.426700e-05,&
     & 1.648800e-07,1.384300e-05,2.595000e-05,4.243200e-05,5.680300e-05,&
     & 2.096800e-07,1.505200e-05,2.736300e-05,4.180300e-05,6.027400e-05,&
     & 2.766900e-07,1.671500e-05,2.938400e-05,4.257500e-05,6.471500e-05,&
     & 1.020600e-07,1.025200e-05,2.074700e-05,3.873400e-05,4.284000e-05,&
     & 1.155900e-07,1.074200e-05,2.075500e-05,3.599000e-05,4.427400e-05,&
     & 1.408200e-07,1.147300e-05,2.139100e-05,3.453500e-05,4.640900e-05,&
     & 1.806400e-07,1.252800e-05,2.265000e-05,3.424500e-05,4.928900e-05,&
     & 2.394400e-07,1.396100e-05,2.440800e-05,3.509400e-05,5.290800e-05,&
     & 8.510300e-08,8.414700e-06,1.689100e-05,3.109900e-05,3.478000e-05,&
     & 9.800600e-08,8.865500e-06,1.699900e-05,2.909100e-05,3.599600e-05,&
     & 1.207300e-07,9.508600e-06,1.763100e-05,2.810500e-05,3.777300e-05,&
     & 1.561600e-07,1.042700e-05,1.874200e-05,2.805600e-05,4.011400e-05,&
     & 2.078400e-07,1.166300e-05,2.027400e-05,2.892700e-05,4.302800e-05/
      data  absb(301:600,1) /                                           &
     & 7.131000e-08,6.918500e-06,1.376700e-05,2.497600e-05,2.824100e-05,&
     & 8.349900e-08,7.324600e-06,1.394300e-05,2.353300e-05,2.927300e-05,&
     & 1.040100e-07,7.893500e-06,1.455500e-05,2.289600e-05,3.073500e-05,&
     & 1.355500e-07,8.694100e-06,1.552900e-05,2.301500e-05,3.263900e-05,&
     & 1.810800e-07,9.760900e-06,1.686700e-05,2.387300e-05,3.499300e-05,&
     & 6.014200e-08,5.704700e-06,1.124300e-05,2.006900e-05,2.297800e-05,&
     & 7.160300e-08,6.068100e-06,1.146500e-05,1.905700e-05,2.385400e-05,&
     & 9.025100e-08,6.573800e-06,1.204500e-05,1.868100e-05,2.507600e-05,&
     & 1.184700e-07,7.274500e-06,1.290300e-05,1.892100e-05,2.662600e-05,&
     & 1.587500e-07,8.199600e-06,1.407700e-05,1.975100e-05,2.855500e-05,&
     & 5.098300e-08,4.708800e-06,9.191200e-06,1.614700e-05,1.866800e-05,&
     & 6.163000e-08,5.031500e-06,9.440200e-06,1.545200e-05,1.940500e-05,&
     & 7.856300e-08,5.480600e-06,9.974200e-06,1.526200e-05,2.040300e-05,&
     & 1.037700e-07,6.093100e-06,1.073100e-05,1.557500e-05,2.167200e-05,&
     & 1.393400e-07,6.894200e-06,1.176000e-05,1.636100e-05,2.319600e-05,&
     & 4.342300e-08,3.890600e-06,7.522600e-06,1.300900e-05,1.512700e-05,&
     & 5.322800e-08,4.175500e-06,7.781800e-06,1.254600e-05,1.573600e-05,&
     & 6.856400e-08,4.573100e-06,8.263900e-06,1.248700e-05,1.653600e-05,&
     & 9.103900e-08,5.107400e-06,8.932600e-06,1.283700e-05,1.750500e-05,&
     & 1.223900e-07,5.801600e-06,9.831800e-06,1.356500e-05,1.867000e-05,&
     & 3.720400e-08,3.223800e-06,6.173600e-06,1.050200e-05,1.227900e-05,&
     & 4.620600e-08,3.475900e-06,6.433000e-06,1.020900e-05,1.276400e-05,&
     & 6.007600e-08,3.827300e-06,6.863500e-06,1.024100e-05,1.336800e-05,&
     & 8.014400e-08,4.293600e-06,7.453800e-06,1.060600e-05,1.412100e-05,&
     & 1.077700e-07,4.896600e-06,8.241200e-06,1.127500e-05,1.504600e-05,&
     & 3.199600e-08,2.673700e-06,5.075400e-06,8.494800e-06,9.882200e-06,&
     & 4.024500e-08,2.898400e-06,5.326400e-06,8.322300e-06,1.025600e-05,&
     & 5.274700e-08,3.207900e-06,5.708000e-06,8.416000e-06,1.072700e-05,&
     & 7.060900e-08,3.613800e-06,6.228300e-06,8.777700e-06,1.132000e-05,&
     & 9.498400e-08,4.139800e-06,6.919300e-06,9.387200e-06,1.206200e-05,&
     & 2.764100e-08,2.222100e-06,4.182000e-06,6.885400e-06,7.885700e-06,&
     & 3.520100e-08,2.422500e-06,4.418200e-06,6.798600e-06,8.187500e-06,&
     & 4.645100e-08,2.694300e-06,4.756600e-06,6.933000e-06,8.570400e-06,&
     & 6.233600e-08,3.048100e-06,5.215000e-06,7.281000e-06,9.047300e-06,&
     & 8.377400e-08,3.504800e-06,5.818800e-06,7.829000e-06,9.636500e-06,&
     & 2.398100e-08,1.850000e-06,3.453800e-06,5.592500e-06,6.270800e-06,&
     & 3.088800e-08,2.028800e-06,3.670100e-06,5.566800e-06,6.514800e-06,&
     & 4.100400e-08,2.267200e-06,3.970900e-06,5.724100e-06,6.823200e-06,&
     & 5.509200e-08,2.575400e-06,4.374300e-06,6.051400e-06,7.215300e-06,&
     & 7.392800e-08,2.972200e-06,4.901300e-06,6.540600e-06,7.688400e-06,&
     & 2.089100e-08,1.543200e-06,2.858700e-06,4.551800e-06,4.964800e-06,&
     & 2.717000e-08,1.701800e-06,3.053500e-06,4.568900e-06,5.162800e-06,&
     & 3.624200e-08,1.910500e-06,3.320200e-06,4.734600e-06,5.422600e-06,&
     & 4.874100e-08,2.180000e-06,3.676000e-06,5.038800e-06,5.737900e-06,&
     & 6.522700e-08,2.523400e-06,4.134100e-06,5.473000e-06,6.118900e-06,&
     & 1.809500e-08,1.286600e-06,2.367500e-06,3.715400e-06,3.966900e-06,&
     & 2.370900e-08,1.425300e-06,2.539400e-06,3.756900e-06,4.135900e-06,&
     & 3.172100e-08,1.606000e-06,2.772900e-06,3.918500e-06,4.349800e-06,&
     & 4.265400e-08,1.839400e-06,3.082200e-06,4.191800e-06,4.608300e-06,&
     & 5.694500e-08,2.134800e-06,3.477300e-06,4.573300e-06,4.922900e-06,&
     & 1.531800e-08,1.063700e-06,1.950300e-06,3.036900e-06,3.142500e-06,&
     & 2.014200e-08,1.181400e-06,2.096900e-06,3.084000e-06,3.280400e-06,&
     & 2.698500e-08,1.333900e-06,2.295400e-06,3.228100e-06,3.450600e-06,&
     & 3.627100e-08,1.531200e-06,2.557200e-06,3.463200e-06,3.660000e-06,&
     & 4.834800e-08,1.779600e-06,2.890000e-06,3.787700e-06,3.911900e-06,&
     & 1.260900e-08,8.701900e-07,1.595200e-06,2.482900e-06,2.454900e-06,&
     & 1.658700e-08,9.671101e-07,1.716000e-06,2.522900e-06,2.565600e-06,&
     & 2.222400e-08,1.092400e-06,1.879500e-06,2.642400e-06,2.698600e-06,&
     & 2.986900e-08,1.254400e-06,2.094800e-06,2.836100e-06,2.862000e-06,&
     & 3.980200e-08,1.458400e-06,2.368200e-06,3.103400e-06,3.059300e-06/
      data  absb(601:900,1) /                                           &
     & 9.982500e-09,7.029800e-07,1.294200e-06,2.032800e-06,1.958000e-06,&
     & 1.308200e-08,7.794900e-07,1.389200e-06,2.056700e-06,2.045500e-06,&
     & 1.750400e-08,8.787300e-07,1.518100e-06,2.146400e-06,2.150500e-06,&
     & 2.353000e-08,1.006900e-06,1.688400e-06,2.297400e-06,2.278300e-06,&
     & 3.140800e-08,1.169100e-06,1.905800e-06,2.507600e-06,2.432500e-06,&
     & 7.891400e-09,5.677000e-07,1.050000e-06,1.665300e-06,1.559100e-06,&
     & 1.029800e-08,6.278500e-07,1.124300e-06,1.677300e-06,1.628400e-06,&
     & 1.375200e-08,7.063000e-07,1.225600e-06,1.743500e-06,1.711300e-06,&
     & 1.849100e-08,8.074800e-07,1.360000e-06,1.860400e-06,1.811900e-06,&
     & 2.471300e-08,9.362300e-07,1.532300e-06,2.025200e-06,1.932500e-06,&
     & 6.244900e-09,4.586200e-07,8.522700e-07,1.365000e-06,1.236200e-06,&
     & 8.110700e-09,5.058800e-07,9.102400e-07,1.368700e-06,1.291300e-06,&
     & 1.080700e-08,5.679000e-07,9.897900e-07,1.417100e-06,1.356700e-06,&
     & 1.452800e-08,6.478000e-07,1.095800e-06,1.507200e-06,1.436100e-06,&
     & 1.944600e-08,7.498800e-07,1.232300e-06,1.636300e-06,1.530600e-06,&
     & 4.830200e-09,3.676400e-07,6.889000e-07,1.121800e-06,9.869600e-07,&
     & 6.215700e-09,4.035400e-07,7.320700e-07,1.116400e-06,1.030400e-06,&
     & 8.244100e-09,4.513100e-07,7.926100e-07,1.147400e-06,1.081700e-06,&
     & 1.107400e-08,5.128200e-07,8.738600e-07,1.213200e-06,1.143400e-06,&
     & 1.485100e-08,5.918000e-07,9.792100e-07,1.311000e-06,1.217100e-06,&
     & 3.736800e-09,2.947600e-07,5.575500e-07,9.237600e-07,7.872000e-07,&
     & 4.754500e-09,3.218200e-07,5.888600e-07,9.123800e-07,8.219100e-07,&
     & 6.269000e-09,3.584200e-07,6.346200e-07,9.300300e-07,8.623700e-07,&
     & 8.408600e-09,4.056700e-07,6.966300e-07,9.768800e-07,9.102600e-07,&
     & 1.129100e-08,4.664000e-07,7.774800e-07,1.050300e-06,9.675200e-07,&
     & 2.900700e-09,2.365000e-07,4.521300e-07,7.620900e-07,6.257500e-07,&
     & 3.644500e-09,2.569800e-07,4.740800e-07,7.471400e-07,6.539700e-07,&
     & 4.771400e-09,2.848800e-07,5.086700e-07,7.552700e-07,6.860100e-07,&
     & 6.383800e-09,3.212000e-07,5.558400e-07,7.877800e-07,7.235000e-07,&
     & 8.577300e-09,3.677700e-07,6.178200e-07,8.424900e-07,7.679400e-07,&
     & 2.235100e-09,1.891100e-07,3.668700e-07,6.316200e-07,4.980500e-07,&
     & 2.763400e-09,2.045100e-07,3.811500e-07,6.136000e-07,5.210700e-07,&
     & 3.580700e-09,2.253400e-07,4.065800e-07,6.140900e-07,5.463500e-07,&
     & 4.767200e-09,2.528400e-07,4.417700e-07,6.347300e-07,5.755300e-07,&
     & 6.405200e-09,2.880500e-07,4.884600e-07,6.739700e-07,6.097700e-07,&
     & 1.724800e-09,1.512100e-07,2.982600e-07,5.258000e-07,3.962400e-07,&
     & 2.093900e-09,1.627700e-07,3.069800e-07,5.056300e-07,4.151500e-07,&
     & 2.675900e-09,1.780800e-07,3.250200e-07,5.008500e-07,4.350700e-07,&
     & 3.537500e-09,1.987500e-07,3.509800e-07,5.122700e-07,4.577900e-07,&
     & 4.745700e-09,2.252300e-07,3.858200e-07,5.393300e-07,4.842100e-07,&
     & 1.342600e-09,1.213100e-07,2.431500e-07,4.391900e-07,3.142900e-07,&
     & 1.596300e-09,1.297800e-07,2.481100e-07,4.179900e-07,3.298200e-07,&
     & 2.006800e-09,1.410700e-07,2.602700e-07,4.099900e-07,3.458500e-07,&
     & 2.629100e-09,1.564900e-07,2.793900e-07,4.147300e-07,3.636000e-07,&
     & 3.516500e-09,1.764300e-07,3.053100e-07,4.326800e-07,3.840700e-07,&
     & 1.052500e-09,9.760700e-08,1.987100e-07,3.686400e-07,2.495400e-07,&
     & 1.219000e-09,1.034200e-07,2.010800e-07,3.471300e-07,2.615000e-07,&
     & 1.504400e-09,1.118100e-07,2.087100e-07,3.369100e-07,2.747400e-07,&
     & 1.947400e-09,1.231500e-07,2.225400e-07,3.369000e-07,2.886900e-07,&
     & 2.590000e-09,1.380900e-07,2.416000e-07,3.478400e-07,3.044600e-07,&
     & 8.318400e-10,7.873000e-08,1.628800e-07,3.114200e-07,1.992600e-07,&
     & 9.318900e-10,8.240000e-08,1.633800e-07,2.901400e-07,2.078100e-07,&
     & 1.124600e-09,8.856600e-08,1.677300e-07,2.782000e-07,2.185000e-07,&
     & 1.431000e-09,9.672600e-08,1.771800e-07,2.748200e-07,2.296000e-07,&
     & 1.886600e-09,1.077700e-07,1.909600e-07,2.801600e-07,2.417400e-07,&
     & 6.666700e-10,6.374300e-08,1.338300e-07,2.644400e-07,1.591900e-07,&
     & 7.215200e-10,6.598000e-08,1.332600e-07,2.437000e-07,1.650000e-07,&
     & 8.480300e-10,7.030500e-08,1.354600e-07,2.307900e-07,1.732500e-07,&
     & 1.057600e-09,7.623900e-08,1.414500e-07,2.253300e-07,1.822900e-07,&
     & 1.378100e-09,8.429200e-08,1.513600e-07,2.267200e-07,1.917900e-07/
      data  absb(901:1175,1) /                                          &
     & 5.414400e-10,5.180100e-08,1.101300e-07,2.261800e-07,1.271100e-07,&
     & 5.662900e-10,5.310700e-08,1.090700e-07,2.055300e-07,1.308900e-07,&
     & 6.448600e-10,5.591800e-08,1.098600e-07,1.924400e-07,1.367600e-07,&
     & 7.873500e-10,6.029100e-08,1.133900e-07,1.856500e-07,1.442200e-07,&
     & 1.010600e-09,6.611000e-08,1.203400e-07,1.844600e-07,1.518500e-07,&
     & 4.443700e-10,4.223200e-08,9.086200e-08,1.944400e-07,1.022000e-07,&
     & 4.514200e-10,4.295400e-08,8.949500e-08,1.736700e-07,1.047800e-07,&
     & 4.979200e-10,4.472400e-08,8.947000e-08,1.610000e-07,1.088600e-07,&
     & 5.943600e-10,4.791900e-08,9.144200e-08,1.535200e-07,1.146400e-07,&
     & 7.494000e-10,5.214500e-08,9.609200e-08,1.508600e-07,1.208800e-07,&
     & 3.671300e-10,3.447400e-08,7.530800e-08,1.680300e-07,8.241500e-08,&
     & 3.643000e-10,3.486200e-08,7.357100e-08,1.473200e-07,8.428300e-08,&
     & 3.893800e-10,3.595800e-08,7.309500e-08,1.351500e-07,8.712900e-08,&
     & 4.528700e-10,3.816900e-08,7.406800e-08,1.274600e-07,9.135900e-08,&
     & 5.604200e-10,4.129700e-08,7.700500e-08,1.239000e-07,9.646700e-08,&
     & 3.050700e-10,2.813500e-08,6.290300e-08,1.459600e-07,6.632600e-08,&
     & 2.970900e-10,2.838500e-08,6.055400e-08,1.258000e-07,6.771700e-08,&
     & 3.080500e-10,2.902900e-08,5.988600e-08,1.138000e-07,6.970900e-08,&
     & 3.477600e-10,3.047000e-08,6.019000e-08,1.062500e-07,7.272500e-08,&
     & 4.219500e-10,3.280000e-08,6.194400e-08,1.021600e-07,7.674500e-08,&
     & 2.547100e-10,2.299800e-08,5.295900e-08,1.273800e-07,5.313100e-08,&
     & 2.443200e-10,2.315200e-08,5.000700e-08,1.081900e-07,5.417900e-08,&
     & 2.465400e-10,2.350800e-08,4.916500e-08,9.619500e-08,5.565800e-08,&
     & 2.697700e-10,2.441700e-08,4.907100e-08,8.893900e-08,5.779000e-08,&
     & 3.199200e-10,2.610400e-08,5.003100e-08,8.455000e-08,6.080300e-08,&
     & 2.131400e-10,1.885200e-08,4.474800e-08,1.111500e-07,4.330200e-08,&
     & 2.019300e-10,1.890400e-08,4.144900e-08,9.313500e-08,4.406700e-08,&
     & 1.996500e-10,1.910500e-08,4.040900e-08,8.142000e-08,4.517700e-08,&
     & 2.122400e-10,1.967800e-08,4.011400e-08,7.454100e-08,4.670400e-08,&
     & 2.455700e-10,2.084700e-08,4.058600e-08,7.015400e-08,4.893200e-08,&
     & 1.786700e-10,1.555500e-08,3.797200e-08,9.710800e-08,3.572800e-08,&
     & 1.676000e-10,1.543300e-08,3.455500e-08,8.030600e-08,3.627100e-08,&
     & 1.630600e-10,1.557000e-08,3.323700e-08,6.917900e-08,3.707500e-08,&
     & 1.688100e-10,1.591800e-08,3.286500e-08,6.254300e-08,3.818100e-08,&
     & 1.902200e-10,1.669700e-08,3.301800e-08,5.835700e-08,3.982900e-08,&
     & 1.501400e-10,1.291500e-08,3.238000e-08,8.505500e-08,2.952600e-08,&
     & 1.395800e-10,1.261600e-08,2.897800e-08,6.947300e-08,2.990400e-08,&
     & 1.340200e-10,1.270400e-08,2.741100e-08,5.908800e-08,3.048500e-08,&
     & 1.354800e-10,1.290800e-08,2.696600e-08,5.263100e-08,3.128100e-08,&
     & 1.485400e-10,1.341600e-08,2.692800e-08,4.869400e-08,3.248700e-08,&
     & 1.264800e-10,1.077800e-08,2.770800e-08,7.494200e-08,2.444300e-08,&
     & 1.166600e-10,1.033400e-08,2.443000e-08,6.040400e-08,2.470700e-08,&
     & 1.106700e-10,1.037400e-08,2.269100e-08,5.071400e-08,2.511100e-08,&
     & 1.096700e-10,1.049000e-08,2.215500e-08,4.444600e-08,2.568600e-08,&
     & 1.169700e-10,1.081500e-08,2.200700e-08,4.075200e-08,2.656000e-08,&
     & 1.065900e-10,9.029300e-09,2.375900e-08,6.608900e-08,2.034700e-08,&
     & 9.763600e-11,8.513500e-09,2.066800e-08,5.254300e-08,2.052500e-08,&
     & 9.173200e-11,8.468900e-09,1.887600e-08,4.357000e-08,2.078500e-08,&
     & 8.948700e-11,8.548300e-09,1.821300e-08,3.764500e-08,2.119500e-08,&
     & 9.305900e-11,8.750500e-09,1.802200e-08,3.413100e-08,2.182700e-08,&
     & 8.833100e-11,7.463000e-09,1.979300e-08,5.559300e-08,1.748200e-08,&
     & 8.069400e-11,6.993200e-09,1.713300e-08,4.395700e-08,1.748600e-08,&
     & 7.554900e-11,6.923300e-09,1.555300e-08,3.628800e-08,1.762000e-08,&
     & 7.329300e-11,6.986300e-09,1.492500e-08,3.120600e-08,1.787000e-08,&
     & 7.549200e-11,7.132800e-09,1.475000e-08,2.815900e-08,1.836900e-08/
      data  absb(1:300,2) /                                             &
     & 1.783100e-06,1.148500e-04,2.249200e-04,4.168800e-04,6.054700e-04,&
     & 2.252300e-06,1.230600e-04,2.285500e-04,3.887300e-04,6.958000e-04,&
     & 3.140100e-06,1.373800e-04,2.431500e-04,3.787300e-04,8.121800e-04,&
     & 4.644400e-06,1.595600e-04,2.682200e-04,3.862900e-04,9.539900e-04,&
     & 7.031300e-06,1.898700e-04,3.050700e-04,4.126100e-04,1.119200e-03,&
     & 1.507800e-06,9.395500e-05,1.837600e-04,3.384500e-04,5.037200e-04,&
     & 1.933400e-06,1.012100e-04,1.874300e-04,3.171300e-04,5.791000e-04,&
     & 2.716000e-06,1.136800e-04,2.004800e-04,3.103200e-04,6.765800e-04,&
     & 4.031400e-06,1.326600e-04,2.223300e-04,3.184500e-04,7.942300e-04,&
     & 6.114400e-06,1.584800e-04,2.540800e-04,3.419700e-04,9.292200e-04,&
     & 1.277400e-06,7.665900e-05,1.496600e-04,2.742800e-04,4.080600e-04,&
     & 1.653900e-06,8.307500e-05,1.534100e-04,2.581800e-04,4.682400e-04,&
     & 2.332700e-06,9.382300e-05,1.650400e-04,2.540000e-04,5.455400e-04,&
     & 3.469400e-06,1.100700e-04,1.839800e-04,2.623100e-04,6.378000e-04,&
     & 5.270500e-06,1.320700e-04,2.111900e-04,2.832300e-04,7.450900e-04,&
     & 1.080700e-06,6.253000e-05,1.218000e-04,2.221500e-04,3.280800e-04,&
     & 1.408400e-06,6.819600e-05,1.255800e-04,2.101400e-04,3.744500e-04,&
     & 1.992100e-06,7.740900e-05,1.358900e-04,2.079200e-04,4.332200e-04,&
     & 2.970900e-06,9.131700e-05,1.522300e-04,2.161000e-04,5.032900e-04,&
     & 4.517500e-06,1.101300e-04,1.755200e-04,2.345600e-04,5.839400e-04,&
     & 9.118000e-07,5.117900e-05,9.938600e-05,1.802500e-04,2.643700e-04,&
     & 1.194600e-06,5.614300e-05,1.031000e-04,1.713400e-04,2.999600e-04,&
     & 1.697200e-06,6.407700e-05,1.121600e-04,1.704900e-04,3.449400e-04,&
     & 2.540200e-06,7.603400e-05,1.262000e-04,1.783400e-04,3.985000e-04,&
     & 3.860200e-06,9.213700e-05,1.462000e-04,1.944600e-04,4.605300e-04,&
     & 7.684700e-07,4.212800e-05,8.142700e-05,1.466300e-04,2.142800e-04,&
     & 1.014000e-06,4.646700e-05,8.501800e-05,1.400500e-04,2.422100e-04,&
     & 1.449200e-06,5.335800e-05,9.293900e-05,1.401900e-04,2.773900e-04,&
     & 2.175600e-06,6.367100e-05,1.050400e-04,1.475300e-04,3.193700e-04,&
     & 3.297300e-06,7.746900e-05,1.223300e-04,1.615900e-04,3.680500e-04,&
     & 6.466500e-07,3.475600e-05,6.683000e-05,1.194000e-04,1.745500e-04,&
     & 8.602600e-07,3.852800e-05,7.021200e-05,1.146000e-04,1.969400e-04,&
     & 1.236800e-06,4.452800e-05,7.712000e-05,1.154000e-04,2.249800e-04,&
     & 1.858000e-06,5.340400e-05,8.755700e-05,1.221500e-04,2.585000e-04,&
     & 2.810300e-06,6.516200e-05,1.024900e-04,1.343800e-04,2.967900e-04,&
     & 5.465600e-07,2.877000e-05,5.497500e-05,9.719600e-05,1.432600e-04,&
     & 7.343600e-07,3.208500e-05,5.815700e-05,9.386500e-05,1.615500e-04,&
     & 1.062200e-06,3.735800e-05,6.422100e-05,9.515900e-05,1.843600e-04,&
     & 1.596500e-06,4.497400e-05,7.328700e-05,1.013900e-04,2.114900e-04,&
     & 2.411900e-06,5.503300e-05,8.624400e-05,1.120700e-04,2.417200e-04,&
     & 4.623300e-07,2.383400e-05,4.526400e-05,7.914900e-05,1.177400e-04,&
     & 6.270700e-07,2.675100e-05,4.820200e-05,7.692800e-05,1.327300e-04,&
     & 9.112300e-07,3.135800e-05,5.351500e-05,7.855000e-05,1.513300e-04,&
     & 1.371100e-06,3.785600e-05,6.140500e-05,8.420600e-05,1.732100e-04,&
     & 2.069800e-06,4.646600e-05,7.255500e-05,9.352400e-05,1.969800e-04,&
     & 3.980900e-07,1.986100e-05,3.736200e-05,6.425500e-05,9.713000e-05,&
     & 5.466600e-07,2.248700e-05,4.015900e-05,6.305800e-05,1.094600e-04,&
     & 8.005700e-07,2.657700e-05,4.493500e-05,6.507000e-05,1.245600e-04,&
     & 1.207100e-06,3.221100e-05,5.192400e-05,7.034400e-05,1.418200e-04,&
     & 1.819500e-06,3.967400e-05,6.164500e-05,7.862300e-05,1.604000e-04,&
     & 3.436700e-07,1.656800e-05,3.088000e-05,5.223800e-05,8.002100e-05,&
     & 4.775800e-07,1.892800e-05,3.350400e-05,5.176200e-05,9.005400e-05,&
     & 7.044700e-07,2.252900e-05,3.777400e-05,5.399000e-05,1.021100e-04,&
     & 1.063800e-06,2.741400e-05,4.392800e-05,5.884500e-05,1.154200e-04,&
     & 1.600700e-06,3.384900e-05,5.235300e-05,6.613400e-05,1.300200e-04,&
     & 2.973100e-07,1.381700e-05,2.553100e-05,4.247700e-05,6.548300e-05,&
     & 4.180000e-07,1.592500e-05,2.796300e-05,4.252500e-05,7.345000e-05,&
     & 6.203900e-07,1.908300e-05,3.174800e-05,4.484100e-05,8.260300e-05,&
     & 9.379900e-07,2.330300e-05,3.715500e-05,4.923600e-05,9.277100e-05,&
     & 1.408400e-06,2.882400e-05,4.440400e-05,5.562100e-05,1.040100e-04/
      data  absb(301:600,2) /                                           &
     & 2.584600e-07,1.155700e-05,2.116800e-05,3.459100e-05,5.340200e-05,&
     & 3.677900e-07,1.344600e-05,2.339700e-05,3.501900e-05,5.950400e-05,&
     & 5.491400e-07,1.620300e-05,2.674700e-05,3.731600e-05,6.645300e-05,&
     & 8.308100e-07,1.984800e-05,3.148900e-05,4.127100e-05,7.420400e-05,&
     & 1.243400e-06,2.458600e-05,3.770600e-05,4.684300e-05,8.296400e-05,&
     & 2.268800e-07,9.718200e-06,1.762600e-05,2.823800e-05,4.345800e-05,&
     & 3.269800e-07,1.142100e-05,1.966000e-05,2.894600e-05,4.810400e-05,&
     & 4.909500e-07,1.382700e-05,2.264200e-05,3.116200e-05,5.345800e-05,&
     & 7.425400e-07,1.699100e-05,2.680400e-05,3.471000e-05,5.961600e-05,&
     & 1.106400e-06,2.107300e-05,3.213100e-05,3.958100e-05,6.656400e-05,&
     & 1.999300e-07,8.189000e-06,1.470600e-05,2.310400e-05,3.488500e-05,&
     & 2.914700e-07,9.712000e-06,1.654400e-05,2.398400e-05,3.844400e-05,&
     & 4.395500e-07,1.180300e-05,1.919200e-05,2.606300e-05,4.265800e-05,&
     & 6.636500e-07,1.454900e-05,2.281700e-05,2.921400e-05,4.754800e-05,&
     & 9.839900e-07,1.806000e-05,2.738100e-05,3.345400e-05,5.303400e-05,&
     & 1.766600e-07,6.910600e-06,1.229100e-05,1.895000e-05,2.761400e-05,&
     & 2.602700e-07,8.261300e-06,1.393900e-05,1.991200e-05,3.034700e-05,&
     & 3.936000e-07,1.007600e-05,1.627700e-05,2.182200e-05,3.366500e-05,&
     & 5.925500e-07,1.245500e-05,1.941900e-05,2.459900e-05,3.752100e-05,&
     & 8.739700e-07,1.547400e-05,2.333200e-05,2.828100e-05,4.180900e-05,&
     & 1.573100e-07,5.860600e-06,1.031600e-05,1.560000e-05,2.190200e-05,&
     & 2.340000e-07,7.054300e-06,1.179000e-05,1.659000e-05,2.408900e-05,&
     & 3.541800e-07,8.634300e-06,1.385300e-05,1.832400e-05,2.673700e-05,&
     & 5.311900e-07,1.070000e-05,1.657600e-05,2.076600e-05,2.975800e-05,&
     & 7.791600e-07,1.329900e-05,1.993900e-05,2.397100e-05,3.311700e-05,&
     & 1.406300e-07,4.982400e-06,8.676400e-06,1.288000e-05,1.731000e-05,&
     & 2.106700e-07,6.030300e-06,9.987500e-06,1.384800e-05,1.904700e-05,&
     & 3.187300e-07,7.409300e-06,1.180400e-05,1.540800e-05,2.111200e-05,&
     & 4.760200e-07,9.199000e-06,1.415600e-05,1.755000e-05,2.346700e-05,&
     & 6.943100e-07,1.144200e-05,1.705300e-05,2.034000e-05,2.609100e-05,&
     & 1.264400e-07,4.251600e-06,7.319500e-06,1.067300e-05,1.368200e-05,&
     & 1.903100e-07,5.169300e-06,8.485700e-06,1.159300e-05,1.503400e-05,&
     & 2.875100e-07,6.374500e-06,1.008400e-05,1.298500e-05,1.663500e-05,&
     & 4.272400e-07,7.926000e-06,1.210900e-05,1.486000e-05,1.844600e-05,&
     & 6.191600e-07,9.857000e-06,1.460200e-05,1.728000e-05,2.048100e-05,&
     & 1.140900e-07,3.637900e-06,6.191500e-06,8.874700e-06,1.078300e-05,&
     & 1.722800e-07,4.441200e-06,7.228700e-06,9.727300e-06,1.184200e-05,&
     & 2.596200e-07,5.494900e-06,8.626800e-06,1.096300e-05,1.307800e-05,&
     & 3.836500e-07,6.837700e-06,1.037100e-05,1.260500e-05,1.447700e-05,&
     & 5.523300e-07,8.503200e-06,1.251500e-05,1.469800e-05,1.606800e-05,&
     & 1.031900e-07,3.118000e-06,5.248100e-06,7.400400e-06,8.450000e-06,&
     & 1.561200e-07,3.821500e-06,6.168600e-06,8.177100e-06,9.283300e-06,&
     & 2.344100e-07,4.741800e-06,7.386100e-06,9.270000e-06,1.023500e-05,&
     & 3.444600e-07,5.906000e-06,8.892500e-06,1.071000e-05,1.133500e-05,&
     & 4.924100e-07,7.337100e-06,1.073100e-05,1.250700e-05,1.257600e-05,&
     & 9.230700e-08,2.661900e-06,4.438500e-06,6.171000e-06,6.708600e-06,&
     & 1.397000e-07,3.273100e-06,5.244800e-06,6.865200e-06,7.366600e-06,&
     & 2.089500e-07,4.069000e-06,6.293000e-06,7.818600e-06,8.127400e-06,&
     & 3.053200e-07,5.068100e-06,7.583600e-06,9.063400e-06,9.007100e-06,&
     & 4.339200e-07,6.291200e-06,9.151600e-06,1.059800e-05,1.000100e-05,&
     & 7.933400e-08,2.229400e-06,3.699800e-06,5.104900e-06,5.246600e-06,&
     & 1.200200e-07,2.746700e-06,4.384600e-06,5.699300e-06,5.755400e-06,&
     & 1.791200e-07,3.417600e-06,5.265400e-06,6.507300e-06,6.353800e-06,&
     & 2.609600e-07,4.257200e-06,6.349900e-06,7.556600e-06,7.048400e-06,&
     & 3.697100e-07,5.282000e-06,7.661600e-06,8.841500e-06,7.840300e-06,&
     & 6.513300e-08,1.825800e-06,3.030500e-06,4.178100e-06,4.039100e-06,&
     & 9.852100e-08,2.250400e-06,3.592700e-06,4.667000e-06,4.425700e-06,&
     & 1.470400e-07,2.801400e-06,4.315900e-06,5.330700e-06,4.885100e-06,&
     & 2.142300e-07,3.490500e-06,5.205600e-06,6.191900e-06,5.422100e-06,&
     & 3.034700e-07,4.331100e-06,6.281000e-06,7.246400e-06,6.040000e-06/
      data  absb(601:900,2) /                                           &
     & 5.040900e-08,1.454600e-06,2.429700e-06,3.377700e-06,3.188800e-06,&
     & 7.627800e-08,1.789700e-06,2.872200e-06,3.759500e-06,3.488300e-06,&
     & 1.141600e-07,2.226500e-06,3.448000e-06,4.283400e-06,3.845400e-06,&
     & 1.669500e-07,2.775200e-06,4.156600e-06,4.967000e-06,4.265300e-06,&
     & 2.374100e-07,3.446400e-06,5.017500e-06,5.809800e-06,4.750900e-06,&
     & 3.889000e-08,1.157200e-06,1.946200e-06,2.730300e-06,2.517300e-06,&
     & 5.883900e-08,1.421100e-06,2.293500e-06,3.026500e-06,2.749000e-06,&
     & 8.830600e-08,1.766400e-06,2.750300e-06,3.438800e-06,3.025900e-06,&
     & 1.296300e-07,2.202300e-06,3.313800e-06,3.979800e-06,3.353300e-06,&
     & 1.850900e-07,2.737200e-06,4.000700e-06,4.652000e-06,3.734200e-06,&
     & 3.001500e-08,9.208400e-07,1.559600e-06,2.208300e-06,1.982800e-06,&
     & 4.538500e-08,1.128800e-06,1.831900e-06,2.437600e-06,2.160800e-06,&
     & 6.827800e-08,1.401400e-06,2.193700e-06,2.761600e-06,2.375100e-06,&
     & 1.006100e-07,1.747700e-06,2.642200e-06,3.189100e-06,2.629000e-06,&
     & 1.442300e-07,2.173400e-06,3.190100e-06,3.724800e-06,2.925600e-06,&
     & 2.225600e-08,7.191200e-07,1.232900e-06,1.774500e-06,1.569700e-06,&
     & 3.356900e-08,8.785100e-07,1.439600e-06,1.943600e-06,1.705500e-06,&
     & 5.066400e-08,1.087900e-06,1.718200e-06,2.190000e-06,1.870500e-06,&
     & 7.511800e-08,1.356400e-06,2.068000e-06,2.519200e-06,2.066800e-06,&
     & 1.084300e-07,1.688600e-06,2.496000e-06,2.936900e-06,2.297300e-06,&
     & 1.644700e-08,5.608000e-07,9.744400e-07,1.428600e-06,1.243500e-06,&
     & 2.469500e-08,6.824200e-07,1.130200e-06,1.550000e-06,1.346900e-06,&
     & 3.734900e-08,8.422900e-07,1.342800e-06,1.736000e-06,1.473200e-06,&
     & 5.570500e-08,1.049700e-06,1.614800e-06,1.987500e-06,1.624600e-06,&
     & 8.098800e-08,1.307500e-06,1.947900e-06,2.310900e-06,1.803000e-06,&
     & 1.218600e-08,4.381900e-07,7.712400e-07,1.153800e-06,9.846000e-07,&
     & 1.816700e-08,5.304000e-07,8.886700e-07,1.238600e-06,1.063100e-06,&
     & 2.749600e-08,6.524000e-07,1.050100e-06,1.377600e-06,1.159200e-06,&
     & 4.122600e-08,8.120500e-07,1.261100e-06,1.569500e-06,1.275500e-06,&
     & 6.035800e-08,1.012200e-06,1.519800e-06,1.818900e-06,1.412900e-06,&
     & 8.882500e-09,3.402500e-07,6.077000e-07,9.333100e-07,7.808500e-07,&
     & 1.307700e-08,4.082100e-07,6.942500e-07,9.875901e-07,8.397700e-07,&
     & 1.976300e-08,4.999600e-07,8.143700e-07,1.088100e-06,9.125200e-07,&
     & 2.978500e-08,6.206200e-07,9.749500e-07,1.231600e-06,1.001000e-06,&
     & 4.396800e-08,7.737100e-07,1.173700e-06,1.420600e-06,1.105900e-06,&
     & 6.465200e-09,2.643200e-07,4.793000e-07,7.585400e-07,6.201800e-07,&
     & 9.343100e-09,3.132100e-07,5.418900e-07,7.891700e-07,6.634200e-07,&
     & 1.405400e-08,3.817000e-07,6.302100e-07,8.594800e-07,7.186600e-07,&
     & 2.125700e-08,4.719200e-07,7.505300e-07,9.653201e-07,7.854200e-07,&
     & 3.163600e-08,5.881400e-07,9.025500e-07,1.106900e-06,8.650800e-07,&
     & 4.749300e-09,2.061800e-07,3.795500e-07,6.201000e-07,4.932000e-07,&
     & 6.704600e-09,2.410300e-07,4.242100e-07,6.340900e-07,5.237200e-07,&
     & 9.997900e-09,2.918300e-07,4.890300e-07,6.812100e-07,5.653400e-07,&
     & 1.514200e-08,3.591500e-07,5.783300e-07,7.582500e-07,6.157500e-07,&
     & 2.269200e-08,4.469500e-07,6.943500e-07,8.639400e-07,6.758400e-07,&
     & 3.502600e-09,1.609500e-07,3.016400e-07,5.098800e-07,3.926600e-07,&
     & 4.805600e-09,1.857100e-07,3.323800e-07,5.121100e-07,4.141100e-07,&
     & 7.061100e-09,2.225600e-07,3.793600e-07,5.410800e-07,4.442200e-07,&
     & 1.067400e-08,2.725400e-07,4.448400e-07,5.957300e-07,4.821300e-07,&
     & 1.609100e-08,3.380700e-07,5.322000e-07,6.736800e-07,5.273900e-07,&
     & 2.586000e-09,1.255800e-07,2.407900e-07,4.223700e-07,3.132600e-07,&
     & 3.429000e-09,1.430000e-07,2.605600e-07,4.162300e-07,3.285700e-07,&
     & 4.922000e-09,1.687800e-07,2.936500e-07,4.309200e-07,3.496000e-07,&
     & 7.390800e-09,2.054100e-07,3.407400e-07,4.677100e-07,3.779000e-07,&
     & 1.118200e-08,2.535400e-07,4.049800e-07,5.239400e-07,4.118700e-07,&
     & 1.936200e-09,9.854800e-08,1.941100e-07,3.527200e-07,2.493700e-07,&
     & 2.479800e-09,1.107200e-07,2.055000e-07,3.410500e-07,2.609000e-07,&
     & 3.455500e-09,1.286500e-07,2.282800e-07,3.459400e-07,2.756000e-07,&
     & 5.123400e-09,1.551500e-07,2.620700e-07,3.690900e-07,2.959500e-07,&
     & 7.753800e-09,1.904500e-07,3.087200e-07,4.087800e-07,3.212800e-07/
      data  absb(901:1175,2) /                                          &
     & 1.469300e-09,7.779000e-08,1.579600e-07,2.963800e-07,1.977000e-07,&
     & 1.818900e-09,8.613400e-08,1.633400e-07,2.813900e-07,2.067400e-07,&
     & 2.451400e-09,9.873700e-08,1.784200e-07,2.800100e-07,2.174000e-07,&
     & 3.562500e-09,1.174900e-07,2.024000e-07,2.929200e-07,2.315000e-07,&
     & 5.368200e-09,1.433900e-07,2.360600e-07,3.202400e-07,2.500000e-07,&
     & 1.133900e-09,6.194500e-08,1.293300e-07,2.504100e-07,1.574800e-07,&
     & 1.360500e-09,6.760300e-08,1.311800e-07,2.338300e-07,1.648000e-07,&
     & 1.775100e-09,7.652700e-08,1.406300e-07,2.285300e-07,1.728800e-07,&
     & 2.515700e-09,8.969700e-08,1.575300e-07,2.345100e-07,1.829500e-07,&
     & 3.757900e-09,1.087500e-07,1.819000e-07,2.526600e-07,1.963300e-07,&
     & 8.871400e-10,4.974500e-08,1.065900e-07,2.126000e-07,1.256100e-07,&
     & 1.032300e-09,5.336900e-08,1.063000e-07,1.954200e-07,1.317100e-07,&
     & 1.305400e-09,5.966800e-08,1.116100e-07,1.877700e-07,1.380100e-07,&
     & 1.797800e-09,6.899900e-08,1.232800e-07,1.891900e-07,1.454800e-07,&
     & 2.647800e-09,8.283700e-08,1.409300e-07,2.005100e-07,1.551000e-07,&
     & 7.018400e-10,4.019000e-08,8.821800e-08,1.813600e-07,9.973100e-08,&
     & 7.919700e-10,4.234900e-08,8.675500e-08,1.641700e-07,1.049600e-07,&
     & 9.713200e-10,4.671700e-08,8.917900e-08,1.551500e-07,1.100000e-07,&
     & 1.297200e-09,5.338000e-08,9.695400e-08,1.536600e-07,1.156300e-07,&
     & 1.872100e-09,6.324800e-08,1.095900e-07,1.599000e-07,1.225400e-07,&
     & 5.609200e-10,3.264800e-08,7.311700e-08,1.551900e-07,7.897900e-08,&
     & 6.142300e-10,3.382100e-08,7.113800e-08,1.388000e-07,8.327500e-08,&
     & 7.309500e-10,3.676300e-08,7.182400e-08,1.290900e-07,8.740800e-08,&
     & 9.459100e-10,4.149200e-08,7.660900e-08,1.256500e-07,9.172500e-08,&
     & 1.330500e-09,4.845200e-08,8.551900e-08,1.283300e-07,9.678000e-08,&
     & 4.534000e-10,2.671500e-08,6.084400e-08,1.327300e-07,6.376800e-08,&
     & 4.835700e-10,2.724100e-08,5.866400e-08,1.175800e-07,6.702800e-08,&
     & 5.595500e-10,2.913700e-08,5.834100e-08,1.077900e-07,7.046100e-08,&
     & 7.036400e-10,3.250800e-08,6.104100e-08,1.033000e-07,7.390500e-08,&
     & 9.634800e-10,3.751000e-08,6.723600e-08,1.037800e-07,7.779300e-08,&
     & 3.701800e-10,2.187700e-08,5.074800e-08,1.138300e-07,5.214300e-08,&
     & 3.846100e-10,2.205900e-08,4.849100e-08,9.981000e-08,5.453100e-08,&
     & 4.331900e-10,2.321900e-08,4.765600e-08,9.029100e-08,5.735700e-08,&
     & 5.303300e-10,2.560300e-08,4.894500e-08,8.528200e-08,6.011400e-08,&
     & 7.066800e-10,2.923600e-08,5.316200e-08,8.441300e-08,6.315100e-08,&
     & 3.044500e-10,1.793100e-08,4.237800e-08,9.853300e-08,4.276800e-08,&
     & 3.083100e-10,1.793400e-08,4.011600e-08,8.490800e-08,4.444500e-08,&
     & 3.382400e-10,1.860000e-08,3.906300e-08,7.599800e-08,4.673800e-08,&
     & 4.033000e-10,2.024600e-08,3.949200e-08,7.078300e-08,4.895700e-08,&
     & 5.228000e-10,2.287200e-08,4.219000e-08,6.900800e-08,5.133100e-08,&
     & 2.518800e-10,1.475400e-08,3.543800e-08,8.575600e-08,3.519300e-08,&
     & 2.491200e-10,1.467000e-08,3.333700e-08,7.243000e-08,3.627600e-08,&
     & 2.665300e-10,1.498300e-08,3.218400e-08,6.424100e-08,3.812800e-08,&
     & 3.093900e-10,1.606200e-08,3.206400e-08,5.902500e-08,3.992000e-08,&
     & 3.902100e-10,1.794800e-08,3.363500e-08,5.668000e-08,4.178700e-08,&
     & 2.092500e-10,1.217000e-08,2.971500e-08,7.467100e-08,2.910900e-08,&
     & 2.031800e-10,1.201500e-08,2.776300e-08,6.186900e-08,2.978900e-08,&
     & 2.120700e-10,1.213500e-08,2.658100e-08,5.438800e-08,3.125400e-08,&
     & 2.399800e-10,1.281000e-08,2.617600e-08,4.933000e-08,3.270300e-08,&
     & 2.950800e-10,1.415600e-08,2.697500e-08,4.672400e-08,3.416900e-08,&
     & 1.725300e-10,9.990600e-09,2.454600e-08,6.252600e-08,2.455900e-08,&
     & 1.664400e-10,9.831300e-09,2.286800e-08,5.148400e-08,2.530000e-08,&
     & 1.720200e-10,9.896600e-09,2.182300e-08,4.506700e-08,2.645300e-08,&
     & 1.927000e-10,1.038800e-08,2.141400e-08,4.070200e-08,2.751800e-08,&
     & 2.345400e-10,1.143100e-08,2.192800e-08,3.836400e-08,2.865700e-08/
      data  absb(1:300,3) /                                             &
     & 9.359200e-06,1.863500e-04,3.236000e-04,5.101300e-04,1.371900e-03,&
     & 1.399700e-05,2.215000e-04,3.618600e-04,5.076600e-04,1.695200e-03,&
     & 2.147200e-05,2.702900e-04,4.208600e-04,5.416000e-04,2.055900e-03,&
     & 3.294900e-05,3.359500e-04,5.019000e-04,6.090900e-04,2.442200e-03,&
     & 5.005500e-05,4.228300e-04,6.079400e-04,7.005700e-04,2.843100e-03,&
     & 7.781100e-06,1.544300e-04,2.673100e-04,4.173700e-04,1.193700e-03,&
     & 1.179000e-05,1.845400e-04,3.010400e-04,4.186100e-04,1.466100e-03,&
     & 1.828100e-05,2.265100e-04,3.517700e-04,4.504900e-04,1.765900e-03,&
     & 2.836100e-05,2.831900e-04,4.213600e-04,5.081400e-04,2.075900e-03,&
     & 4.349600e-05,3.580600e-04,5.124000e-04,5.862600e-04,2.395500e-03,&
     & 6.408500e-06,1.273200e-04,2.202100e-04,3.409300e-04,1.010400e-03,&
     & 9.862000e-06,1.530300e-04,2.498200e-04,3.448700e-04,1.232700e-03,&
     & 1.548300e-05,1.891300e-04,2.933100e-04,3.738500e-04,1.466000e-03,&
     & 2.432900e-05,2.377200e-04,3.531300e-04,4.233000e-04,1.702100e-03,&
     & 3.762000e-05,3.018100e-04,4.308100e-04,4.903700e-04,1.930900e-03,&
     & 5.294400e-06,1.048900e-04,1.813900e-04,2.783600e-04,8.155300e-04,&
     & 8.263900e-06,1.268500e-04,2.070800e-04,2.840900e-04,9.807800e-04,&
     & 1.317100e-05,1.577500e-04,2.444300e-04,3.098800e-04,1.150300e-03,&
     & 2.091200e-05,1.992900e-04,2.955400e-04,3.525200e-04,1.313100e-03,&
     & 3.249600e-05,2.540900e-04,3.617900e-04,4.096300e-04,1.476000e-03,&
     & 4.449300e-06,8.677000e-05,1.499100e-04,2.277100e-04,6.524500e-04,&
     & 7.039500e-06,1.055900e-04,1.720300e-04,2.343000e-04,7.726200e-04,&
     & 1.133500e-05,1.320800e-04,2.040700e-04,2.572200e-04,8.902800e-04,&
     & 1.806900e-05,1.676500e-04,2.477900e-04,2.936800e-04,1.006300e-03,&
     & 2.809000e-05,2.145500e-04,3.041200e-04,3.424900e-04,1.124800e-03,&
     & 3.831600e-06,7.234700e-05,1.245800e-04,1.867300e-04,5.212200e-04,&
     & 6.118400e-06,8.858000e-05,1.436100e-04,1.937700e-04,6.076700e-04,&
     & 9.894700e-06,1.113500e-04,1.712000e-04,2.141000e-04,6.919400e-04,&
     & 1.575600e-05,1.419000e-04,2.085500e-04,2.453100e-04,7.786800e-04,&
     & 2.447200e-05,1.822700e-04,2.566700e-04,2.870800e-04,8.697500e-04,&
     & 3.316700e-06,6.047200e-05,1.036100e-04,1.534400e-04,4.191200e-04,&
     & 5.327500e-06,7.448500e-05,1.200200e-04,1.604900e-04,4.816700e-04,&
     & 8.618200e-06,9.404800e-05,1.437500e-04,1.783900e-04,5.449800e-04,&
     & 1.369700e-05,1.203400e-04,1.757000e-04,2.050800e-04,6.124400e-04,&
     & 2.126100e-05,1.551600e-04,2.168000e-04,2.408900e-04,6.850900e-04,&
     & 2.904900e-06,5.086300e-05,8.649700e-05,1.263100e-04,3.389800e-04,&
     & 4.678200e-06,6.303700e-05,1.007700e-04,1.332800e-04,3.865800e-04,&
     & 7.555100e-06,7.994900e-05,1.212700e-04,1.491200e-04,4.360800e-04,&
     & 1.198500e-05,1.027200e-04,1.488000e-04,1.720900e-04,4.896800e-04,&
     & 1.856400e-05,1.328900e-04,1.839500e-04,2.029000e-04,5.486200e-04,&
     & 2.534800e-06,4.282700e-05,7.223900e-05,1.040500e-04,2.734700e-04,&
     & 4.089600e-06,5.339200e-05,8.468200e-05,1.107800e-04,3.103300e-04,&
     & 6.591100e-06,6.800200e-05,1.024000e-04,1.246800e-04,3.494500e-04,&
     & 1.044300e-05,8.777700e-05,1.260400e-04,1.444800e-04,3.927000e-04,&
     & 1.612600e-05,1.138400e-04,1.561900e-04,1.710000e-04,4.403200e-04,&
     & 2.253500e-06,3.648400e-05,6.084400e-05,8.591500e-05,2.186100e-04,&
     & 3.642100e-06,4.583800e-05,7.193000e-05,9.268800e-05,2.469500e-04,&
     & 5.864900e-06,5.871600e-05,8.751600e-05,1.051200e-04,2.780500e-04,&
     & 9.272400e-06,7.615800e-05,1.080900e-04,1.225600e-04,3.128300e-04,&
     & 1.423700e-05,9.883400e-05,1.343200e-04,1.457100e-04,3.509500e-04,&
     & 1.994000e-06,3.113300e-05,5.132800e-05,7.109000e-05,1.732700e-04,&
     & 3.231200e-06,3.939900e-05,6.117900e-05,7.770800e-05,1.953100e-04,&
     & 5.201100e-06,5.076800e-05,7.484700e-05,8.876000e-05,2.201700e-04,&
     & 8.191900e-06,6.602300e-05,9.281500e-05,1.041300e-04,2.480900e-04,&
     & 1.249800e-05,8.567600e-05,1.155000e-04,1.243000e-04,2.786100e-04,&
     & 1.745900e-06,2.655800e-05,4.330200e-05,5.893100e-05,1.345600e-04,&
     & 2.837800e-06,3.384000e-05,5.203400e-05,6.522100e-05,1.518400e-04,&
     & 4.566800e-06,4.381200e-05,6.402700e-05,7.501500e-05,1.715600e-04,&
     & 7.165500e-06,5.705600e-05,7.959700e-05,8.854500e-05,1.936800e-04,&
     & 1.089100e-05,7.404100e-05,9.915600e-05,1.060200e-04,2.175900e-04/
      data  absb(301:600,3) /                                           &
     & 1.535100e-06,2.273900e-05,3.666100e-05,4.903300e-05,1.046400e-04,&
     & 2.501300e-06,2.915600e-05,4.440300e-05,5.490600e-05,1.183900e-04,&
     & 4.019300e-06,3.786700e-05,5.490000e-05,6.359600e-05,1.340500e-04,&
     & 6.281600e-06,4.936900e-05,6.836200e-05,7.547800e-05,1.514200e-04,&
     & 9.514700e-06,6.400600e-05,8.521200e-05,9.053200e-05,1.699800e-04,&
     & 1.368300e-06,1.960900e-05,3.123900e-05,4.102500e-05,8.252900e-05,&
     & 2.231300e-06,2.526900e-05,3.812600e-05,4.643600e-05,9.360000e-05,&
     & 3.575400e-06,3.291300e-05,4.729500e-05,5.419000e-05,1.061100e-04,&
     & 5.566400e-06,4.291500e-05,5.895200e-05,6.458100e-05,1.196600e-04,&
     & 8.392800e-06,5.554000e-05,7.347800e-05,7.757800e-05,1.340700e-04,&
     & 1.217100e-06,1.692300e-05,2.666600e-05,3.442800e-05,6.483600e-05,&
     & 1.986200e-06,2.189600e-05,3.275200e-05,3.933200e-05,7.365000e-05,&
     & 3.175000e-06,2.859300e-05,4.072700e-05,4.621000e-05,8.336600e-05,&
     & 4.925700e-06,3.724500e-05,5.078800e-05,5.524200e-05,9.374400e-05,&
     & 7.393400e-06,4.809000e-05,6.324900e-05,6.641400e-05,1.049000e-04,&
     & 1.079200e-06,1.460000e-05,2.278400e-05,2.895200e-05,5.048500e-05,&
     & 1.762900e-06,1.897200e-05,2.812300e-05,3.334600e-05,5.727700e-05,&
     & 2.813100e-06,2.480500e-05,3.504200e-05,3.940900e-05,6.462200e-05,&
     & 4.351200e-06,3.225100e-05,4.369400e-05,4.721100e-05,7.260200e-05,&
     & 6.498900e-06,4.155900e-05,5.433700e-05,5.676300e-05,8.133300e-05,&
     & 9.685700e-07,1.266600e-05,1.955600e-05,2.444700e-05,3.952900e-05,&
     & 1.581800e-06,1.651500e-05,2.423600e-05,2.836200e-05,4.469700e-05,&
     & 2.516800e-06,2.158600e-05,3.022700e-05,3.368800e-05,5.041300e-05,&
     & 3.872300e-06,2.801000e-05,3.766600e-05,4.041100e-05,5.668800e-05,&
     & 5.746200e-06,3.601600e-05,4.676800e-05,4.856500e-05,6.355300e-05,&
     & 8.705600e-07,1.100100e-05,1.680600e-05,2.067900e-05,3.064200e-05,&
     & 1.420400e-06,1.437300e-05,2.089100e-05,2.415800e-05,3.464400e-05,&
     & 2.251100e-06,1.876900e-05,2.605800e-05,2.879600e-05,3.911400e-05,&
     & 3.445600e-06,2.431200e-05,3.244900e-05,3.457000e-05,4.402500e-05,&
     & 5.079600e-06,3.120300e-05,4.024700e-05,4.152800e-05,4.943000e-05,&
     & 7.880000e-07,9.584100e-06,1.448000e-05,1.753700e-05,2.370300e-05,&
     & 1.282700e-06,1.253200e-05,1.803500e-05,2.061900e-05,2.682900e-05,&
     & 2.022400e-06,1.634300e-05,2.248800e-05,2.463900e-05,3.030000e-05,&
     & 3.073500e-06,2.113700e-05,2.798800e-05,2.959000e-05,3.417400e-05,&
     & 4.501000e-06,2.705100e-05,3.464900e-05,3.551900e-05,3.844900e-05,&
     & 7.164500e-07,8.362100e-06,1.249900e-05,1.490800e-05,1.844300e-05,&
     & 1.161900e-06,1.094200e-05,1.558400e-05,1.762600e-05,2.088600e-05,&
     & 1.820200e-06,1.424600e-05,1.942200e-05,2.109900e-05,2.364800e-05,&
     & 2.746800e-06,1.838900e-05,2.415400e-05,2.534400e-05,2.672200e-05,&
     & 3.993900e-06,2.345900e-05,2.984500e-05,3.039100e-05,3.012800e-05,&
     & 6.527900e-07,7.302100e-06,1.079700e-05,1.269500e-05,1.440200e-05,&
     & 1.053300e-06,9.555000e-06,1.346600e-05,1.507800e-05,1.632200e-05,&
     & 1.638600e-06,1.242000e-05,1.677700e-05,1.807100e-05,1.850900e-05,&
     & 2.455500e-06,1.600200e-05,2.085000e-05,2.171300e-05,2.096700e-05,&
     & 3.543800e-06,2.033100e-05,2.569500e-05,2.600100e-05,2.364400e-05,&
     & 5.886300e-07,6.333900e-06,9.273400e-06,1.077800e-05,1.146900e-05,&
     & 9.444500e-07,8.284500e-06,1.156700e-05,1.283900e-05,1.301700e-05,&
     & 1.459600e-06,1.075000e-05,1.440600e-05,1.539900e-05,1.477400e-05,&
     & 2.172400e-06,1.381800e-05,1.787900e-05,1.849300e-05,1.672900e-05,&
     & 3.114800e-06,1.749800e-05,2.198700e-05,2.213100e-05,1.882400e-05,&
     & 5.053700e-07,5.349300e-06,7.791900e-06,9.003900e-06,8.978100e-06,&
     & 8.091800e-07,6.993700e-06,9.719200e-06,1.073900e-05,1.021300e-05,&
     & 1.247000e-06,9.068000e-06,1.210200e-05,1.288600e-05,1.159600e-05,&
     & 1.850100e-06,1.164100e-05,1.500600e-05,1.547000e-05,1.311800e-05,&
     & 2.644900e-06,1.471300e-05,1.843300e-05,1.850500e-05,1.474000e-05,&
     & 4.105700e-07,4.381400e-06,6.385100e-06,7.378700e-06,6.870400e-06,&
     & 6.588200e-07,5.729500e-06,7.964900e-06,8.801400e-06,7.831000e-06,&
     & 1.016800e-06,7.430500e-06,9.917900e-06,1.056200e-05,8.907900e-06,&
     & 1.510800e-06,9.539000e-06,1.229800e-05,1.267900e-05,1.008300e-05,&
     & 2.161600e-06,1.205600e-05,1.510400e-05,1.516900e-05,1.134500e-05/
      data  absb(601:900,3) /                                           &
     & 3.131500e-07,3.461000e-06,5.078000e-06,5.909900e-06,5.369200e-06,&
     & 5.055300e-07,4.530000e-06,6.335600e-06,7.038100e-06,6.116000e-06,&
     & 7.850200e-07,5.882200e-06,7.891000e-06,8.442000e-06,6.958700e-06,&
     & 1.173100e-06,7.565400e-06,9.793600e-06,1.013700e-05,7.886000e-06,&
     & 1.687400e-06,9.581000e-06,1.204500e-05,1.213200e-05,8.881000e-06,&
     & 2.377100e-07,2.727400e-06,4.031100e-06,4.728100e-06,4.187700e-06,&
     & 3.861200e-07,3.572700e-06,5.029600e-06,5.620000e-06,4.763000e-06,&
     & 6.034800e-07,4.645700e-06,6.266100e-06,6.737000e-06,5.419600e-06,&
     & 9.073500e-07,5.985600e-06,7.784000e-06,8.091300e-06,6.148400e-06,&
     & 1.312700e-06,7.597500e-06,9.585900e-06,9.688000e-06,6.928800e-06,&
     & 1.802300e-07,2.149100e-06,3.200000e-06,3.783700e-06,3.250200e-06,&
     & 2.945600e-07,2.816400e-06,3.992100e-06,4.487700e-06,3.691400e-06,&
     & 4.634400e-07,3.667600e-06,4.975100e-06,5.376000e-06,4.198300e-06,&
     & 7.011900e-07,4.733500e-06,6.185200e-06,6.457900e-06,4.764800e-06,&
     & 1.020200e-06,6.022000e-06,7.626700e-06,7.735500e-06,5.371200e-06,&
     & 1.298800e-07,1.649000e-06,2.486200e-06,2.983700e-06,2.533100e-06,&
     & 2.142100e-07,2.161500e-06,3.100300e-06,3.522900e-06,2.872300e-06,&
     & 3.404600e-07,2.821300e-06,3.865500e-06,4.214400e-06,3.264600e-06,&
     & 5.203100e-07,3.650600e-06,4.811200e-06,5.062600e-06,3.707500e-06,&
     & 7.645000e-07,4.662100e-06,5.944800e-06,6.068500e-06,4.183900e-06,&
     & 9.278800e-08,1.261100e-06,1.927100e-06,2.351400e-06,1.974800e-06,&
     & 1.543800e-07,1.652700e-06,2.400400e-06,2.761400e-06,2.233700e-06,&
     & 2.480200e-07,2.161700e-06,2.994500e-06,3.296700e-06,2.536400e-06,&
     & 3.830600e-07,2.804000e-06,3.729800e-06,3.958400e-06,2.881300e-06,&
     & 5.686600e-07,3.594300e-06,4.618300e-06,4.748400e-06,3.255500e-06,&
     & 6.612300e-08,9.644200e-07,1.494300e-06,1.855700e-06,1.537900e-06,&
     & 1.109000e-07,1.262900e-06,1.858100e-06,2.166400e-06,1.733600e-06,&
     & 1.800600e-07,1.654600e-06,2.318600e-06,2.579000e-06,1.966000e-06,&
     & 2.811200e-07,2.151300e-06,2.889700e-06,3.094300e-06,2.233100e-06,&
     & 4.217600e-07,2.767600e-06,3.585400e-06,3.713900e-06,2.524700e-06,&
     & 4.572300e-08,7.272100e-07,1.146800e-06,1.456100e-06,1.197000e-06,&
     & 7.727900e-08,9.508600e-07,1.421400e-06,1.686900e-06,1.343600e-06,&
     & 1.269800e-07,1.246900e-06,1.773400e-06,1.998800e-06,1.520100e-06,&
     & 2.008700e-07,1.626100e-06,2.211700e-06,2.394800e-06,1.725700e-06,&
     & 3.051700e-07,2.099700e-06,2.749200e-06,2.875600e-06,1.952600e-06,&
     & 3.119500e-08,5.452900e-07,8.774000e-07,1.142800e-06,9.321200e-07,&
     & 5.300200e-08,7.113200e-07,1.082100e-06,1.311700e-06,1.041100e-06,&
     & 8.811600e-08,9.328100e-07,1.348800e-06,1.543900e-06,1.173300e-06,&
     & 1.413500e-07,1.220100e-06,1.683300e-06,1.845700e-06,1.330500e-06,&
     & 2.177200e-07,1.580900e-06,2.095600e-06,2.215900e-06,1.506300e-06,&
     & 2.131000e-08,4.094400e-07,6.732700e-07,9.015300e-07,7.249700e-07,&
     & 3.623100e-08,5.323500e-07,8.246200e-07,1.022700e-06,8.060600e-07,&
     & 6.086000e-08,6.975200e-07,1.025700e-06,1.194600e-06,9.042100e-07,&
     & 9.896600e-08,9.144200e-07,1.280800e-06,1.423200e-06,1.022800e-06,&
     & 1.545800e-07,1.188500e-06,1.595700e-06,1.707100e-06,1.158100e-06,&
     & 1.445500e-08,3.064700e-07,5.165700e-07,7.151700e-07,5.630900e-07,&
     & 2.443800e-08,3.964400e-07,6.266800e-07,7.974000e-07,6.235700e-07,&
     & 4.140000e-08,5.185000e-07,7.766700e-07,9.231200e-07,6.961900e-07,&
     & 6.824100e-08,6.804500e-07,9.695100e-07,1.093900e-06,7.845500e-07,&
     & 1.082100e-07,8.873900e-07,1.208900e-06,1.310100e-06,8.879400e-07,&
     & 9.692900e-09,2.279700e-07,3.954200e-07,5.718200e-07,4.384700e-07,&
     & 1.612300e-08,2.924200e-07,4.735900e-07,6.214100e-07,4.827100e-07,&
     & 2.744700e-08,3.812900e-07,5.832800e-07,7.112000e-07,5.369200e-07,&
     & 4.585500e-08,5.003000e-07,7.271000e-07,8.359200e-07,6.020600e-07,&
     & 7.392300e-08,6.546700e-07,9.073300e-07,9.982900e-07,6.803100e-07,&
     & 6.605800e-09,1.706300e-07,3.044700e-07,4.622400e-07,3.421700e-07,&
     & 1.067000e-08,2.161800e-07,3.595800e-07,4.882400e-07,3.732500e-07,&
     & 1.812800e-08,2.806000e-07,4.388100e-07,5.500700e-07,4.134800e-07,&
     & 3.062400e-08,3.676600e-07,5.453500e-07,6.403600e-07,4.613700e-07,&
     & 5.015100e-08,4.821700e-07,6.807100e-07,7.612300e-07,5.195500e-07/
      data  absb(901:1175,3) /                                          &
     & 4.601400e-09,1.287200e-07,2.363300e-07,3.781400e-07,2.674800e-07,&
     & 7.112700e-09,1.604000e-07,2.744500e-07,3.880400e-07,2.884100e-07,&
     & 1.195100e-08,2.067500e-07,3.309800e-07,4.273800e-07,3.173400e-07,&
     & 2.034100e-08,2.701900e-07,4.092900e-07,4.923000e-07,3.528400e-07,&
     & 3.378900e-08,3.545700e-07,5.105100e-07,5.810400e-07,3.954300e-07,&
     & 3.312300e-09,9.838900e-08,1.858300e-07,3.120000e-07,2.115100e-07,&
     & 4.863500e-09,1.203400e-07,2.115600e-07,3.122300e-07,2.260600e-07,&
     & 8.001700e-09,1.536600e-07,2.519000e-07,3.352100e-07,2.467600e-07,&
     & 1.363800e-08,2.001200e-07,3.092800e-07,3.814100e-07,2.733600e-07,&
     & 2.292200e-08,2.624100e-07,3.850200e-07,4.464800e-07,3.052800e-07,&
     & 2.441800e-09,7.593300e-08,1.474200e-07,2.596800e-07,1.689100e-07,&
     & 3.398900e-09,9.109500e-08,1.642800e-07,2.538500e-07,1.788900e-07,&
     & 5.413900e-09,1.148200e-07,1.929900e-07,2.654200e-07,1.934400e-07,&
     & 9.180300e-09,1.488100e-07,2.347700e-07,2.970900e-07,2.131800e-07,&
     & 1.556700e-08,1.948100e-07,2.913100e-07,3.446400e-07,2.373400e-07,&
     & 1.835600e-09,5.913800e-08,1.178800e-07,2.179200e-07,1.355100e-07,&
     & 2.422600e-09,6.942700e-08,1.285300e-07,2.082700e-07,1.416700e-07,&
     & 3.692100e-09,8.611700e-08,1.485500e-07,2.123000e-07,1.519500e-07,&
     & 6.179300e-09,1.108000e-07,1.786500e-07,2.323800e-07,1.662300e-07,&
     & 1.053300e-08,1.446800e-07,2.205500e-07,2.668900e-07,1.844000e-07,&
     & 1.405700e-09,4.646000e-08,9.533500e-08,1.847600e-07,1.085900e-07,&
     & 1.760700e-09,5.328500e-08,1.013900e-07,1.721500e-07,1.124200e-07,&
     & 2.548800e-09,6.487100e-08,1.148800e-07,1.713200e-07,1.195100e-07,&
     & 4.165700e-09,8.262900e-08,1.364100e-07,1.828300e-07,1.296500e-07,&
     & 7.099700e-09,1.075000e-07,1.671500e-07,2.073200e-07,1.429600e-07,&
     & 1.099900e-09,3.684600e-08,7.769700e-08,1.575400e-07,8.820600e-08,&
     & 1.315600e-09,4.139900e-08,8.074900e-08,1.433100e-07,9.085400e-08,&
     & 1.812400e-09,4.949300e-08,8.971000e-08,1.396200e-07,9.571200e-08,&
     & 2.867700e-09,6.226400e-08,1.051800e-07,1.454200e-07,1.031200e-07,&
     & 4.857100e-09,8.060200e-08,1.277400e-07,1.622900e-07,1.131500e-07,&
     & 8.725400e-10,2.951100e-08,6.377300e-08,1.347200e-07,7.222400e-08,&
     & 1.001900e-09,3.247000e-08,6.479500e-08,1.199600e-07,7.413100e-08,&
     & 1.317100e-09,3.808100e-08,7.064200e-08,1.145800e-07,7.743800e-08,&
     & 2.002100e-09,4.722100e-08,8.161400e-08,1.167400e-07,8.299800e-08,&
     & 3.348200e-09,6.072700e-08,9.811300e-08,1.277400e-07,9.067200e-08,&
     & 6.995000e-10,2.383800e-08,5.268000e-08,1.156200e-07,5.923400e-08,&
     & 7.741300e-10,2.564400e-08,5.247200e-08,1.011700e-07,6.057200e-08,&
     & 9.720800e-10,2.946500e-08,5.597200e-08,9.454800e-08,6.283400e-08,&
     & 1.412100e-09,3.594000e-08,6.356200e-08,9.435300e-08,6.697000e-08,&
     & 2.312800e-09,4.582200e-08,7.556800e-08,1.009800e-07,7.280800e-08,&
     & 5.658100e-10,1.934600e-08,4.379000e-08,9.956500e-08,4.860200e-08,&
     & 6.063800e-10,2.035200e-08,4.273700e-08,8.602000e-08,4.959800e-08,&
     & 7.283500e-10,2.292800e-08,4.458800e-08,7.855400e-08,5.115600e-08,&
     & 1.008900e-09,2.748700e-08,4.970400e-08,7.681200e-08,5.418800e-08,&
     & 1.603400e-09,3.464100e-08,5.839200e-08,8.033100e-08,5.857400e-08,&
     & 4.610300e-10,1.579300e-08,3.662700e-08,8.572600e-08,3.997800e-08,&
     & 4.813000e-10,1.628600e-08,3.501500e-08,7.330700e-08,4.078900e-08,&
     & 5.558500e-10,1.800400e-08,3.576400e-08,6.561000e-08,4.188400e-08,&
     & 7.363000e-10,2.119800e-08,3.917100e-08,6.295900e-08,4.410000e-08,&
     & 1.127600e-09,2.636600e-08,4.540300e-08,6.445800e-08,4.743100e-08,&
     & 3.775500e-10,1.293200e-08,3.023200e-08,7.148000e-08,3.364700e-08,&
     & 3.902800e-10,1.325200e-08,2.871600e-08,6.091900e-08,3.420900e-08,&
     & 4.441500e-10,1.453100e-08,2.909900e-08,5.412900e-08,3.519700e-08,&
     & 5.780400e-10,1.697900e-08,3.164500e-08,5.158800e-08,3.720300e-08,&
     & 8.707300e-10,2.099700e-08,3.646900e-08,5.242800e-08,4.011500e-08/
      data  absb(1:300,4) /                                             &
     & 8.929100e-05,3.852400e-04,5.083800e-04,6.586500e-04,3.842200e-03,&
     & 1.215000e-04,5.039500e-04,6.250200e-04,7.159100e-04,4.493400e-03,&
     & 1.672200e-04,6.639100e-04,7.860500e-04,8.200100e-04,5.096700e-03,&
     & 2.316700e-04,8.669000e-04,9.973800e-04,9.696000e-04,5.686200e-03,&
     & 3.206600e-04,1.114900e-03,1.257200e-03,1.172300e-03,6.288600e-03,&
     & 7.306900e-05,3.244300e-04,4.257200e-04,5.456500e-04,3.232400e-03,&
     & 1.007800e-04,4.278800e-04,5.277300e-04,5.981200e-04,3.708300e-03,&
     & 1.406600e-04,5.656400e-04,6.684600e-04,6.898200e-04,4.160100e-03,&
     & 1.970800e-04,7.397400e-04,8.502100e-04,8.216500e-04,4.625600e-03,&
     & 2.752300e-04,9.528100e-04,1.071300e-03,9.974500e-04,5.117700e-03,&
     & 5.826800e-05,2.720300e-04,3.560400e-04,4.520600e-04,2.535500e-03,&
     & 8.180500e-05,3.609800e-04,4.446700e-04,4.995600e-04,2.858100e-03,&
     & 1.162000e-04,4.791000e-04,5.664100e-04,5.804400e-04,3.190300e-03,&
     & 1.650100e-04,6.281000e-04,7.214800e-04,6.957700e-04,3.550100e-03,&
     & 2.330100e-04,8.114400e-04,9.102700e-04,8.472600e-04,3.946300e-03,&
     & 4.611500e-05,2.274200e-04,2.976000e-04,3.744100e-04,1.863500e-03,&
     & 6.604400e-05,3.038800e-04,3.743200e-04,4.170900e-04,2.089600e-03,&
     & 9.551300e-05,4.049400e-04,4.788100e-04,4.883300e-04,2.337300e-03,&
     & 1.376800e-04,5.322900e-04,6.107300e-04,5.883600e-04,2.620100e-03,&
     & 1.967600e-04,6.891600e-04,7.722300e-04,7.181100e-04,2.912800e-03,&
     & 3.723600e-05,1.911700e-04,2.492800e-04,3.103600e-04,1.378100e-03,&
     & 5.429100e-05,2.569300e-04,3.156500e-04,3.486700e-04,1.550500e-03,&
     & 7.974900e-05,3.433200e-04,4.049800e-04,4.112700e-04,1.750200e-03,&
     & 1.165300e-04,4.521000e-04,5.174400e-04,4.971500e-04,1.965400e-03,&
     & 1.684800e-04,5.856700e-04,6.548700e-04,6.082800e-04,2.186700e-03,&
     & 3.121400e-05,1.626500e-04,2.100100e-04,2.578900e-04,1.050800e-03,&
     & 4.611500e-05,2.192800e-04,2.676400e-04,2.923500e-04,1.192500e-03,&
     & 6.852600e-05,2.931100e-04,3.439500e-04,3.466200e-04,1.352200e-03,&
     & 1.010800e-04,3.859500e-04,4.397200e-04,4.205000e-04,1.520000e-03,&
     & 1.472400e-04,4.997900e-04,5.562000e-04,5.150800e-04,1.688400e-03,&
     & 2.649400e-05,1.387700e-04,1.775200e-04,2.145600e-04,8.326700e-04,&
     & 3.964500e-05,1.873500e-04,2.271700e-04,2.453100e-04,9.516800e-04,&
     & 5.944100e-05,2.503100e-04,2.922300e-04,2.920300e-04,1.081400e-03,&
     & 8.834100e-05,3.295400e-04,3.734600e-04,3.551600e-04,1.214300e-03,&
     & 1.295200e-04,4.267400e-04,4.723200e-04,4.356500e-04,1.345300e-03,&
     & 2.295300e-05,1.192300e-04,1.510600e-04,1.790600e-04,6.753100e-04,&
     & 3.468400e-05,1.609600e-04,1.938700e-04,2.064500e-04,7.736000e-04,&
     & 5.238700e-05,2.149300e-04,2.493900e-04,2.467400e-04,8.792700e-04,&
     & 7.833900e-05,2.828700e-04,3.186700e-04,3.009400e-04,9.845700e-04,&
     & 1.153200e-04,3.665500e-04,4.033200e-04,3.695500e-04,1.089000e-03,&
     & 1.993900e-05,1.023000e-04,1.285800e-04,1.496800e-04,5.486900e-04,&
     & 3.042700e-05,1.381600e-04,1.653100e-04,1.737500e-04,6.293200e-04,&
     & 4.630100e-05,1.845300e-04,2.126900e-04,2.084800e-04,7.142400e-04,&
     & 6.961200e-05,2.428800e-04,2.718900e-04,2.549700e-04,7.979900e-04,&
     & 1.025500e-04,3.149600e-04,3.445200e-04,3.135600e-04,8.817800e-04,&
     & 1.765000e-05,8.909900e-05,1.108600e-04,1.261700e-04,4.413600e-04,&
     & 2.725600e-05,1.204000e-04,1.428800e-04,1.477000e-04,5.062500e-04,&
     & 4.178400e-05,1.608200e-04,1.839100e-04,1.782500e-04,5.725900e-04,&
     & 6.296300e-05,2.116800e-04,2.352800e-04,2.186900e-04,6.383100e-04,&
     & 9.247900e-05,2.747300e-04,2.983400e-04,2.693600e-04,7.051100e-04,&
     & 1.566100e-05,7.757000e-05,9.560600e-05,1.064900e-04,3.528200e-04,&
     & 2.441900e-05,1.049200e-04,1.235000e-04,1.256900e-04,4.038900e-04,&
     & 3.761700e-05,1.402100e-04,1.591400e-04,1.525300e-04,4.553500e-04,&
     & 5.662300e-05,1.845900e-04,2.037800e-04,1.877200e-04,5.073400e-04,&
     & 8.285000e-05,2.395500e-04,2.586800e-04,2.316800e-04,5.607300e-04,&
     & 1.376100e-05,6.731300e-05,8.238700e-05,8.998500e-05,2.765700e-04,&
     & 2.166000e-05,9.121400e-05,1.066300e-04,1.070300e-04,3.156400e-04,&
     & 3.347100e-05,1.219800e-04,1.376700e-04,1.306200e-04,3.553600e-04,&
     & 5.031300e-05,1.606600e-04,1.764600e-04,1.612700e-04,3.963300e-04,&
     & 7.336000e-05,2.082900e-04,2.241400e-04,1.993900e-04,4.396400e-04/
      data  absb(301:600,4) /                                           &
     & 1.216300e-05,5.863200e-05,7.121000e-05,7.628900e-05,2.155700e-04,&
     & 1.926200e-05,7.956300e-05,9.238400e-05,9.143100e-05,2.454800e-04,&
     & 2.976800e-05,1.064500e-04,1.194200e-04,1.122200e-04,2.763600e-04,&
     & 4.463500e-05,1.400600e-04,1.531600e-04,1.389200e-04,3.091300e-04,&
     & 6.472300e-05,1.812200e-04,1.944600e-04,1.720300e-04,3.445900e-04,&
     & 1.090500e-05,5.150900e-05,6.198200e-05,6.504800e-05,1.691200e-04,&
     & 1.730100e-05,6.993800e-05,8.056400e-05,7.859400e-05,1.923500e-04,&
     & 2.667400e-05,9.347800e-05,1.042000e-04,9.693300e-05,2.169200e-04,&
     & 3.981000e-05,1.226000e-04,1.335800e-04,1.203100e-04,2.437200e-04,&
     & 5.726900e-05,1.581900e-04,1.692900e-04,1.490400e-04,2.728300e-04,&
     & 9.744300e-06,4.525600e-05,5.397700e-05,5.556400e-05,1.307900e-04,&
     & 1.546800e-05,6.143400e-05,7.024000e-05,6.766100e-05,1.488500e-04,&
     & 2.378500e-05,8.187600e-05,9.086800e-05,8.380100e-05,1.685700e-04,&
     & 3.528900e-05,1.070500e-04,1.162800e-04,1.041800e-04,1.903800e-04,&
     & 5.035200e-05,1.376300e-04,1.470500e-04,1.289100e-04,2.139900e-04,&
     & 8.666200e-06,3.971000e-05,4.697300e-05,4.754500e-05,9.957300e-05,&
     & 1.376200e-05,5.380800e-05,6.119100e-05,5.831200e-05,1.137800e-04,&
     & 2.108700e-05,7.145800e-05,7.907100e-05,7.242800e-05,1.296900e-04,&
     & 3.107300e-05,9.312700e-05,1.009700e-04,9.007900e-05,1.471300e-04,&
     & 4.403200e-05,1.191900e-04,1.272600e-04,1.112800e-04,1.660300e-04,&
     & 7.799800e-06,3.499600e-05,4.103600e-05,4.086500e-05,7.646200e-05,&
     & 1.235100e-05,4.725300e-05,5.343600e-05,5.040900e-05,8.783600e-05,&
     & 1.879900e-05,6.249800e-05,6.890900e-05,6.272700e-05,1.004700e-04,&
     & 2.748500e-05,8.109500e-05,8.773100e-05,7.797300e-05,1.143400e-04,&
     & 3.868100e-05,1.032400e-04,1.100900e-04,9.609200e-05,1.293700e-04,&
     & 7.018400e-06,3.079300e-05,3.583500e-05,3.518100e-05,5.853900e-05,&
     & 1.105900e-05,4.141900e-05,4.660500e-05,4.358500e-05,6.750400e-05,&
     & 1.670700e-05,5.455000e-05,5.993700e-05,5.429500e-05,7.747100e-05,&
     & 2.426100e-05,7.041600e-05,7.604300e-05,6.739400e-05,8.846800e-05,&
     & 3.392000e-05,8.925900e-05,9.502000e-05,8.283400e-05,1.002600e-04,&
     & 6.344600e-06,2.713000e-05,3.132600e-05,3.036400e-05,4.477800e-05,&
     & 9.924000e-06,3.633000e-05,4.066700e-05,3.773200e-05,5.177600e-05,&
     & 1.488300e-05,4.759300e-05,5.213400e-05,4.701500e-05,5.960300e-05,&
     & 2.145400e-05,6.112000e-05,6.584700e-05,5.820700e-05,6.810400e-05,&
     & 2.977000e-05,7.711400e-05,8.193500e-05,7.130900e-05,7.716300e-05,&
     & 5.744700e-06,2.390900e-05,2.740200e-05,2.625600e-05,3.447500e-05,&
     & 8.914600e-06,3.184900e-05,3.548700e-05,3.269500e-05,3.993400e-05,&
     & 1.327100e-05,4.148100e-05,4.530500e-05,4.070300e-05,4.600200e-05,&
     & 1.898200e-05,5.301500e-05,5.696900e-05,5.023000e-05,5.254600e-05,&
     & 2.612900e-05,6.663400e-05,7.062500e-05,6.135900e-05,5.950700e-05,&
     & 5.198100e-06,2.104800e-05,2.395900e-05,2.272700e-05,2.659100e-05,&
     & 8.004500e-06,2.786300e-05,3.092800e-05,2.832900e-05,3.079500e-05,&
     & 1.182600e-05,3.610700e-05,3.931100e-05,3.520000e-05,3.543700e-05,&
     & 1.678000e-05,4.595500e-05,4.924900e-05,4.332100e-05,4.042200e-05,&
     & 2.290300e-05,5.751900e-05,6.083500e-05,5.276500e-05,4.573900e-05,&
     & 4.658000e-06,1.836500e-05,2.079200e-05,1.956200e-05,2.097300e-05,&
     & 7.119500e-06,2.417800e-05,2.674100e-05,2.438500e-05,2.425300e-05,&
     & 1.044200e-05,3.119600e-05,3.386300e-05,3.022700e-05,2.782700e-05,&
     & 1.470300e-05,3.955600e-05,4.228100e-05,3.710500e-05,3.169400e-05,&
     & 1.992200e-05,4.935100e-05,5.208200e-05,4.510200e-05,3.582400e-05,&
     & 3.987100e-06,1.555100e-05,1.757100e-05,1.647500e-05,1.623600e-05,&
     & 6.075700e-06,2.041400e-05,2.254200e-05,2.052700e-05,1.874100e-05,&
     & 8.879400e-06,2.628100e-05,2.849000e-05,2.540500e-05,2.147300e-05,&
     & 1.245500e-05,3.325300e-05,3.551100e-05,3.114700e-05,2.445800e-05,&
     & 1.681700e-05,4.141700e-05,4.368000e-05,3.781200e-05,2.766800e-05,&
     & 3.242100e-06,1.274100e-05,1.441500e-05,1.353200e-05,1.230500e-05,&
     & 4.948900e-06,1.672100e-05,1.848200e-05,1.685600e-05,1.419700e-05,&
     & 7.242000e-06,2.152500e-05,2.335400e-05,2.085700e-05,1.627900e-05,&
     & 1.016500e-05,2.723500e-05,2.910600e-05,2.556400e-05,1.856800e-05,&
     & 1.373100e-05,3.392400e-05,3.579800e-05,3.103500e-05,2.102800e-05/
      data  absb(601:900,4) /                                           &
     & 2.496000e-06,1.006000e-05,1.142400e-05,1.078200e-05,9.508600e-06,&
     & 3.836300e-06,1.323600e-05,1.467300e-05,1.343100e-05,1.097700e-05,&
     & 5.648800e-06,1.707600e-05,1.857200e-05,1.663500e-05,1.259400e-05,&
     & 7.974700e-06,2.165200e-05,2.318800e-05,2.041500e-05,1.437400e-05,&
     & 1.082500e-05,2.702100e-05,2.856600e-05,2.481100e-05,1.629100e-05,&
     & 1.912400e-06,7.918300e-06,9.031600e-06,8.574300e-06,7.323600e-06,&
     & 2.961000e-06,1.045000e-05,1.162100e-05,1.068000e-05,8.461400e-06,&
     & 4.388400e-06,1.351500e-05,1.473500e-05,1.324100e-05,9.713600e-06,&
     & 6.234400e-06,1.717700e-05,1.843500e-05,1.627200e-05,1.109400e-05,&
     & 8.507400e-06,2.148000e-05,2.274900e-05,1.980100e-05,1.258700e-05,&
     & 1.462700e-06,6.228000e-06,7.135800e-06,6.816400e-06,5.609100e-06,&
     & 2.281900e-06,8.243700e-06,9.199100e-06,8.490000e-06,6.483700e-06,&
     & 3.404000e-06,1.068900e-05,1.168700e-05,1.053500e-05,7.450700e-06,&
     & 4.866700e-06,1.361900e-05,1.464900e-05,1.296500e-05,8.514400e-06,&
     & 6.678900e-06,1.706500e-05,1.810900e-05,1.579600e-05,9.672400e-06,&
     & 1.067500e-06,4.758000e-06,5.494800e-06,5.305900e-06,4.323500e-06,&
     & 1.685400e-06,6.331600e-06,7.106500e-06,6.605900e-06,5.003700e-06,&
     & 2.541600e-06,8.247500e-06,9.058400e-06,8.207800e-06,5.759800e-06,&
     & 3.673200e-06,1.055200e-05,1.139200e-05,1.012500e-05,6.592100e-06,&
     & 5.089500e-06,1.327000e-05,1.412500e-05,1.236200e-05,7.498300e-06,&
     & 7.716100e-07,3.615300e-06,4.213500e-06,4.120800e-06,3.329100e-06,&
     & 1.234100e-06,4.839800e-06,5.466700e-06,5.124500e-06,3.857200e-06,&
     & 1.883000e-06,6.335800e-06,6.993700e-06,6.374200e-06,4.447500e-06,&
     & 2.752400e-06,8.142200e-06,8.825300e-06,7.880600e-06,5.100100e-06,&
     & 3.853300e-06,1.028000e-05,1.098000e-05,9.644500e-06,5.808800e-06,&
     & 5.552500e-07,2.741600e-06,3.227300e-06,3.201900e-06,2.556100e-06,&
     & 8.999300e-07,3.692400e-06,4.199800e-06,3.974000e-06,2.963800e-06,&
     & 1.390000e-06,4.859700e-06,5.393300e-06,4.946500e-06,3.423000e-06,&
     & 2.055200e-06,6.273500e-06,6.829500e-06,6.128400e-06,3.932600e-06,&
     & 2.908400e-06,7.954100e-06,8.526400e-06,7.519000e-06,4.487100e-06,&
     & 3.870000e-07,2.040300e-06,2.434300e-06,2.462900e-06,1.955900e-06,&
     & 6.376800e-07,2.768300e-06,3.178000e-06,3.045500e-06,2.267700e-06,&
     & 9.999200e-07,3.668800e-06,4.099600e-06,3.791500e-06,2.624100e-06,&
     & 1.498700e-06,4.763700e-06,5.214000e-06,4.707600e-06,3.020700e-06,&
     & 2.150100e-06,6.071400e-06,6.536100e-06,5.793400e-06,3.454100e-06,&
     & 2.647300e-07,1.502600e-06,1.822100e-06,1.889700e-06,1.493000e-06,&
     & 4.443100e-07,2.056100e-06,2.386600e-06,2.322900e-06,1.730000e-06,&
     & 7.083600e-07,2.745700e-06,3.092700e-06,2.889400e-06,2.004600e-06,&
     & 1.077800e-06,3.588800e-06,3.952900e-06,3.594100e-06,2.312200e-06,&
     & 1.569600e-06,4.601500e-06,4.978600e-06,4.437300e-06,2.649900e-06,&
     & 1.798800e-07,1.103800e-06,1.362500e-06,1.454000e-06,1.137100e-06,&
     & 3.076100e-07,1.522500e-06,1.789800e-06,1.773800e-06,1.316000e-06,&
     & 4.989300e-07,2.049400e-06,2.328700e-06,2.201700e-06,1.525800e-06,&
     & 7.711700e-07,2.697400e-06,2.991300e-06,2.741600e-06,1.763200e-06,&
     & 1.139900e-06,3.479700e-06,3.785100e-06,3.394300e-06,2.025200e-06,&
     & 1.199500e-07,8.029200e-07,1.012100e-06,1.118400e-06,8.648800e-07,&
     & 2.092300e-07,1.116600e-06,1.333100e-06,1.351100e-06,9.984900e-07,&
     & 3.458200e-07,1.516100e-06,1.740900e-06,1.670000e-06,1.157900e-06,&
     & 5.438400e-07,2.011400e-06,2.248100e-06,2.080300e-06,1.340100e-06,&
     & 8.166900e-07,2.612300e-06,2.859600e-06,2.582200e-06,1.542400e-06,&
     & 7.755200e-08,5.743000e-07,7.435200e-07,8.591300e-07,6.583400e-07,&
     & 1.381500e-07,8.054700e-07,9.805500e-07,1.024100e-06,7.578500e-07,&
     & 2.333800e-07,1.104600e-06,1.285500e-06,1.256700e-06,8.775300e-07,&
     & 3.743900e-07,1.479300e-06,1.669000e-06,1.563600e-06,1.016800e-06,&
     & 5.723800e-07,1.936400e-06,2.135700e-06,1.945100e-06,1.172600e-06,&
     & 4.975900e-08,4.098200e-07,5.473400e-07,6.659700e-07,5.005500e-07,&
     & 9.039900e-08,5.789900e-07,7.204100e-07,7.795200e-07,5.740700e-07,&
     & 1.561300e-07,8.015500e-07,9.475400e-07,9.474200e-07,6.628800e-07,&
     & 2.556300e-07,1.083700e-06,1.235900e-06,1.175000e-06,7.686000e-07,&
     & 3.982400e-07,1.431000e-06,1.591300e-06,1.463400e-06,8.875600e-07/
      data  absb(901:1175,4) /                                          &
     & 3.174700e-08,2.920200e-07,4.045800e-07,5.218500e-07,3.807400e-07,&
     & 5.862000e-08,4.147600e-07,5.288900e-07,5.964300e-07,4.332200e-07,&
     & 1.034900e-07,5.792500e-07,6.973100e-07,7.164700e-07,4.988900e-07,&
     & 1.731100e-07,7.908300e-07,9.131200e-07,8.833500e-07,5.776000e-07,&
     & 2.750200e-07,1.053900e-06,1.182600e-06,1.100000e-06,6.679900e-07,&
     & 2.058400e-08,2.100800e-07,3.030100e-07,4.149500e-07,2.949700e-07,&
     & 3.834800e-08,2.990500e-07,3.914900e-07,4.617100e-07,3.320000e-07,&
     & 6.900100e-08,4.207300e-07,5.162600e-07,5.467700e-07,3.806300e-07,&
     & 1.178300e-07,5.796500e-07,6.782900e-07,6.688700e-07,4.399100e-07,&
     & 1.907600e-07,7.794700e-07,8.826900e-07,8.315400e-07,5.091300e-07,&
     & 1.349300e-08,1.521100e-07,2.292900e-07,3.338500e-07,2.307700e-07,&
     & 2.512200e-08,2.161100e-07,2.914500e-07,3.610600e-07,2.567600e-07,&
     & 4.597800e-08,3.059600e-07,3.831600e-07,4.198400e-07,2.925700e-07,&
     & 8.011000e-08,4.251100e-07,5.048300e-07,5.087700e-07,3.373700e-07,&
     & 1.321500e-07,5.766800e-07,6.596500e-07,6.302900e-07,3.904300e-07,&
     & 8.923000e-09,1.107100e-07,1.752300e-07,2.719000e-07,1.811800e-07,&
     & 1.641100e-08,1.560600e-07,2.178500e-07,2.850500e-07,1.992300e-07,&
     & 3.043900e-08,2.219500e-07,2.843800e-07,3.239400e-07,2.248500e-07,&
     & 5.407300e-08,3.108000e-07,3.753500e-07,3.881300e-07,2.582700e-07,&
     & 9.096100e-08,4.253400e-07,4.921500e-07,4.780000e-07,2.986400e-07,&
     & 5.987600e-09,8.120100e-08,1.353600e-07,2.243400e-07,1.430600e-07,&
     & 1.071700e-08,1.127200e-07,1.638300e-07,2.274800e-07,1.549500e-07,&
     & 2.001500e-08,1.606000e-07,2.112500e-07,2.516200e-07,1.728400e-07,&
     & 3.620900e-08,2.264300e-07,2.786900e-07,2.970600e-07,1.972300e-07,&
     & 6.216100e-08,3.126300e-07,3.665500e-07,3.629200e-07,2.277000e-07,&
     & 4.165500e-09,6.069900e-08,1.063100e-07,1.869500e-07,1.150400e-07,&
     & 7.166200e-09,8.250600e-08,1.249800e-07,1.836000e-07,1.231100e-07,&
     & 1.335300e-08,1.173200e-07,1.586300e-07,1.978100e-07,1.360900e-07,&
     & 2.452700e-08,1.663200e-07,2.086000e-07,2.295400e-07,1.543100e-07,&
     & 4.288300e-08,2.313900e-07,2.750700e-07,2.778900e-07,1.776600e-07,&
     & 2.981500e-09,4.599400e-08,8.452500e-08,1.573500e-07,9.346200e-08,&
     & 4.872300e-09,6.094000e-08,9.639100e-08,1.497400e-07,9.900600e-08,&
     & 8.968300e-09,8.606100e-08,1.199600e-07,1.569800e-07,1.086900e-07,&
     & 1.666100e-08,1.224900e-07,1.567700e-07,1.785200e-07,1.225000e-07,&
     & 2.962900e-08,1.716100e-07,2.070500e-07,2.139400e-07,1.406000e-07,&
     & 2.186100e-09,3.524300e-08,6.784200e-08,1.333800e-07,7.607100e-08,&
     & 3.351800e-09,4.529200e-08,7.496200e-08,1.233500e-07,7.996500e-08,&
     & 6.027200e-09,6.316500e-08,9.116800e-08,1.256200e-07,8.702100e-08,&
     & 1.126900e-08,9.006800e-08,1.179200e-07,1.395600e-07,9.747900e-08,&
     & 2.036200e-08,1.269800e-07,1.557100e-07,1.651500e-07,1.114800e-07,&
     & 1.640900e-09,2.738600e-08,5.484800e-08,1.138800e-07,6.203300e-08,&
     & 2.342800e-09,3.393000e-08,5.887500e-08,1.025100e-07,6.487000e-08,&
     & 4.062500e-09,4.642300e-08,6.967400e-08,1.013300e-07,6.986600e-08,&
     & 7.588000e-09,6.613800e-08,8.886200e-08,1.097700e-07,7.774600e-08,&
     & 1.391500e-08,9.373800e-08,1.170200e-07,1.278600e-07,8.858600e-08,&
     & 1.263500e-09,2.160400e-08,4.473100e-08,9.755200e-08,5.082800e-08,&
     & 1.681400e-09,2.576200e-08,4.678600e-08,8.597600e-08,5.291100e-08,&
     & 2.783500e-09,3.442700e-08,5.381500e-08,8.246900e-08,5.651500e-08,&
     & 5.149700e-09,4.880600e-08,6.742500e-08,8.708500e-08,6.250400e-08,&
     & 9.553300e-09,6.944600e-08,8.833600e-08,9.962500e-08,7.098800e-08,&
     & 1.015800e-09,1.749000e-08,3.665100e-08,8.133000e-08,4.275000e-08,&
     & 1.316100e-09,2.054300e-08,3.794200e-08,7.109800e-08,4.450600e-08,&
     & 2.132500e-09,2.719100e-08,4.318000e-08,6.750600e-08,4.766400e-08,&
     & 3.920600e-09,3.843500e-08,5.371100e-08,7.058700e-08,5.296100e-08,&
     & 7.299100e-09,5.476000e-08,7.019900e-08,8.015800e-08,6.035600e-08/
      data  absb(1:300,5) /                                             &
     & 4.727900e-04,8.709800e-04,9.054300e-04,9.382300e-04,7.891900e-03,&
     & 6.417700e-04,1.172800e-03,1.186500e-03,1.110800e-03,8.680900e-03,&
     & 8.777100e-04,1.552000e-03,1.545700e-03,1.362400e-03,9.635800e-03,&
     & 1.191300e-03,2.024700e-03,1.986400e-03,1.688300e-03,1.069700e-02,&
     & 1.584900e-03,2.608700e-03,2.521400e-03,2.090200e-03,1.183200e-02,&
     & 3.979700e-04,7.426400e-04,7.713100e-04,7.891700e-04,6.387500e-03,&
     & 5.488300e-04,1.004100e-03,1.016400e-03,9.446200e-04,7.122800e-03,&
     & 7.576400e-04,1.336000e-03,1.328100e-03,1.166000e-03,7.945100e-03,&
     & 1.031800e-03,1.752500e-03,1.714500e-03,1.450600e-03,8.833700e-03,&
     & 1.376400e-03,2.265800e-03,2.186000e-03,1.801400e-03,9.739100e-03,&
     & 3.316400e-04,6.308500e-04,6.575300e-04,6.637700e-04,4.873600e-03,&
     & 4.643100e-04,8.579100e-04,8.704100e-04,8.024600e-04,5.486400e-03,&
     & 6.463500e-04,1.147700e-03,1.141300e-03,9.966400e-04,6.151900e-03,&
     & 8.854200e-04,1.511800e-03,1.479700e-03,1.245000e-03,6.838400e-03,&
     & 1.186000e-03,1.960700e-03,1.891700e-03,1.551400e-03,7.533000e-03,&
     & 2.754700e-04,5.354000e-04,5.598600e-04,5.585000e-04,3.557100e-03,&
     & 3.907600e-04,7.321000e-04,7.444900e-04,6.818200e-04,4.037600e-03,&
     & 5.491400e-04,9.838800e-04,9.797500e-04,8.514800e-04,4.540000e-03,&
     & 7.564700e-04,1.301300e-03,1.275000e-03,1.067300e-03,5.049100e-03,&
     & 1.016800e-03,1.689400e-03,1.632700e-03,1.334700e-03,5.586400e-03,&
     & 2.315200e-04,4.564000e-04,4.775300e-04,4.715200e-04,2.647900e-03,&
     & 3.321500e-04,6.260000e-04,6.369000e-04,5.806900e-04,3.016300e-03,&
     & 4.696000e-04,8.446600e-04,8.411300e-04,7.279500e-04,3.392400e-03,&
     & 6.489000e-04,1.119000e-03,1.098100e-03,9.156000e-04,3.787600e-03,&
     & 8.735700e-04,1.454200e-03,1.406700e-03,1.149000e-03,4.201500e-03,&
     & 1.993200e-04,3.915300e-04,4.089400e-04,3.998300e-04,2.039200e-03,&
     & 2.874000e-04,5.380200e-04,5.467000e-04,4.954800e-04,2.321800e-03,&
     & 4.068800e-04,7.276900e-04,7.247300e-04,6.236700e-04,2.617100e-03,&
     & 5.621200e-04,9.644200e-04,9.462200e-04,7.876700e-04,2.928600e-03,&
     & 7.565700e-04,1.252300e-03,1.212600e-03,9.898701e-04,3.258400e-03,&
     & 1.730000e-04,3.361500e-04,3.501000e-04,3.392000e-04,1.624900e-03,&
     & 2.499000e-04,4.631400e-04,4.693000e-04,4.225300e-04,1.850900e-03,&
     & 3.537400e-04,6.268100e-04,6.235400e-04,5.346200e-04,2.090300e-03,&
     & 4.880800e-04,8.300000e-04,8.136800e-04,6.769300e-04,2.344200e-03,&
     & 6.562200e-04,1.076300e-03,1.041500e-03,8.510000e-04,2.614900e-03,&
     & 1.520200e-04,2.908900e-04,3.011800e-04,2.884700e-04,1.319500e-03,&
     & 2.194700e-04,4.013700e-04,4.048800e-04,3.616000e-04,1.505100e-03,&
     & 3.100500e-04,5.422900e-04,5.377300e-04,4.593400e-04,1.701100e-03,&
     & 4.268700e-04,7.164100e-04,7.006200e-04,5.821300e-04,1.912600e-03,&
     & 5.724300e-04,9.282500e-04,8.956500e-04,7.313500e-04,2.135200e-03,&
     & 1.334200e-04,2.520700e-04,2.592700e-04,2.452900e-04,1.074100e-03,&
     & 1.923300e-04,3.475300e-04,3.490600e-04,3.093400e-04,1.226200e-03,&
     & 2.710800e-04,4.683600e-04,4.629500e-04,3.938700e-04,1.388500e-03,&
     & 3.722800e-04,6.177700e-04,6.020000e-04,4.988700e-04,1.562600e-03,&
     & 4.991100e-04,7.995100e-04,7.686400e-04,6.263700e-04,1.744300e-03,&
     & 1.187600e-04,2.223200e-04,2.272300e-04,2.114400e-04,8.647500e-04,&
     & 1.709800e-04,3.054700e-04,3.055600e-04,2.682700e-04,9.881700e-04,&
     & 2.402400e-04,4.104300e-04,4.041200e-04,3.417100e-04,1.121300e-03,&
     & 3.295400e-04,5.402800e-04,5.241400e-04,4.323800e-04,1.261900e-03,&
     & 4.418700e-04,6.976100e-04,6.680900e-04,5.424900e-04,1.408000e-03,&
     & 1.053300e-04,1.957300e-04,1.991000e-04,1.826900e-04,6.925700e-04,&
     & 1.515500e-04,2.681600e-04,2.672000e-04,2.326200e-04,7.930800e-04,&
     & 2.127400e-04,3.592100e-04,3.524400e-04,2.961600e-04,9.006800e-04,&
     & 2.919000e-04,4.719100e-04,4.559300e-04,3.744500e-04,1.013600e-03,&
     & 3.913800e-04,6.087800e-04,5.805900e-04,4.696800e-04,1.130600e-03,&
     & 9.258200e-05,1.716700e-04,1.739800e-04,1.578100e-04,5.467700e-04,&
     & 1.334400e-04,2.345600e-04,2.331500e-04,2.013900e-04,6.278200e-04,&
     & 1.876900e-04,3.136500e-04,3.067000e-04,2.563700e-04,7.142000e-04,&
     & 2.577300e-04,4.117400e-04,3.963000e-04,3.240200e-04,8.043100e-04,&
     & 3.454900e-04,5.312400e-04,5.044900e-04,4.065300e-04,8.975900e-04/
      data  absb(301:600,5) /                                           &
     & 8.172000e-05,1.508000e-04,1.523500e-04,1.366200e-04,4.324000e-04,&
     & 1.180500e-04,2.055800e-04,2.036700e-04,1.746000e-04,4.974800e-04,&
     & 1.663200e-04,2.745900e-04,2.674600e-04,2.222700e-04,5.666200e-04,&
     & 2.282000e-04,3.603200e-04,3.453900e-04,2.810700e-04,6.385300e-04,&
     & 3.050900e-04,4.649700e-04,4.399300e-04,3.528900e-04,7.132800e-04,&
     & 7.302300e-05,1.333700e-04,1.341300e-04,1.189200e-04,3.458400e-04,&
     & 1.056000e-04,1.814100e-04,1.789400e-04,1.521300e-04,3.983900e-04,&
     & 1.486100e-04,2.420800e-04,2.346200e-04,1.937100e-04,4.538400e-04,&
     & 2.031300e-04,3.174100e-04,3.029100e-04,2.451600e-04,5.115000e-04,&
     & 2.702500e-04,4.089100e-04,3.858500e-04,3.081000e-04,5.715800e-04,&
     & 6.524400e-05,1.177900e-04,1.179600e-04,1.034700e-04,2.727400e-04,&
     & 9.431700e-05,1.600300e-04,1.571100e-04,1.325100e-04,3.146200e-04,&
     & 1.323500e-04,2.133800e-04,2.057800e-04,1.688800e-04,3.587400e-04,&
     & 1.799400e-04,2.792300e-04,2.656700e-04,2.139700e-04,4.042300e-04,&
     & 2.381500e-04,3.587800e-04,3.380800e-04,2.690800e-04,4.519400e-04,&
     & 5.813500e-05,1.039300e-04,1.035800e-04,8.997400e-05,2.118600e-04,&
     & 8.392200e-05,1.410600e-04,1.378300e-04,1.153900e-04,2.448600e-04,&
     & 1.171900e-04,1.877100e-04,1.804200e-04,1.472500e-04,2.792100e-04,&
     & 1.584600e-04,2.449800e-04,2.326900e-04,1.868200e-04,3.149300e-04,&
     & 2.083400e-04,3.138300e-04,2.956800e-04,2.348800e-04,3.523500e-04,&
     & 5.215600e-05,9.211000e-05,9.128800e-05,7.848700e-05,1.637900e-04,&
     & 7.490700e-05,1.247400e-04,1.213400e-04,1.008100e-04,1.892400e-04,&
     & 1.038900e-04,1.654300e-04,1.586200e-04,1.288400e-04,2.156400e-04,&
     & 1.394900e-04,2.150700e-04,2.041600e-04,1.634900e-04,2.433600e-04,&
     & 1.819300e-04,2.745700e-04,2.588000e-04,2.052900e-04,2.723000e-04,&
     & 4.666500e-05,8.157800e-05,8.047500e-05,6.854500e-05,1.252300e-04,&
     & 6.659000e-05,1.101100e-04,1.067700e-04,8.817500e-05,1.444800e-04,&
     & 9.166600e-05,1.454400e-04,1.393200e-04,1.128000e-04,1.646700e-04,&
     & 1.221400e-04,1.883000e-04,1.788200e-04,1.430100e-04,1.858400e-04,&
     & 1.580800e-04,2.393700e-04,2.260100e-04,1.792700e-04,2.080400e-04,&
     & 4.177400e-05,7.229300e-05,7.104400e-05,6.001400e-05,9.440400e-05,&
     & 5.915300e-05,9.714200e-05,9.403400e-05,7.730300e-05,1.087600e-04,&
     & 8.074900e-05,1.277300e-04,1.223100e-04,9.886100e-05,1.238300e-04,&
     & 1.066500e-04,1.645900e-04,1.564600e-04,1.251100e-04,1.396900e-04,&
     & 1.370800e-04,2.081500e-04,1.968700e-04,1.563400e-04,1.567000e-04,&
     & 3.736000e-05,6.404200e-05,6.276300e-05,5.267400e-05,7.129500e-05,&
     & 5.245800e-05,8.562700e-05,8.278600e-05,6.784600e-05,8.199000e-05,&
     & 7.094800e-05,1.120500e-04,1.073200e-04,8.665900e-05,9.332900e-05,&
     & 9.291200e-05,1.436100e-04,1.366700e-04,1.093700e-04,1.055000e-04,&
     & 1.187200e-04,1.805800e-04,1.710800e-04,1.360700e-04,1.186100e-04,&
     & 3.333000e-05,5.665100e-05,5.540400e-05,4.625700e-05,5.360300e-05,&
     & 4.636600e-05,7.536500e-05,7.281500e-05,5.954100e-05,6.170900e-05,&
     & 6.211700e-05,9.806400e-05,9.400200e-05,7.588000e-05,7.040400e-05,&
     & 8.078500e-05,1.250300e-04,1.191100e-04,9.544000e-05,7.984200e-05,&
     & 1.026600e-04,1.564200e-04,1.483100e-04,1.181300e-04,8.995600e-05,&
     & 2.945300e-05,4.967400e-05,4.849400e-05,4.033000e-05,4.144900e-05,&
     & 4.058700e-05,6.576300e-05,6.351900e-05,5.185200e-05,4.777200e-05,&
     & 5.394100e-05,8.510900e-05,8.161300e-05,6.590800e-05,5.464500e-05,&
     & 6.974200e-05,1.080000e-04,1.029200e-04,8.254000e-05,6.211000e-05,&
     & 8.824800e-05,1.346100e-04,1.276400e-04,1.017300e-04,7.011500e-05,&
     & 2.508700e-05,4.225900e-05,4.125500e-05,3.427500e-05,3.153300e-05,&
     & 3.437700e-05,5.577900e-05,5.392800e-05,4.403700e-05,3.646700e-05,&
     & 4.550900e-05,7.196200e-05,6.907300e-05,5.585500e-05,4.185800e-05,&
     & 5.867200e-05,9.108500e-05,8.686700e-05,6.973600e-05,4.771800e-05,&
     & 7.408600e-05,1.133100e-04,1.075000e-04,8.575300e-05,5.396400e-05,&
     & 2.052500e-05,3.476700e-05,3.400100e-05,2.829700e-05,2.354800e-05,&
     & 2.810400e-05,4.587200e-05,4.444100e-05,3.635700e-05,2.735500e-05,&
     & 3.719900e-05,5.914200e-05,5.686400e-05,4.607400e-05,3.151600e-05,&
     & 4.797300e-05,7.484200e-05,7.148000e-05,5.747300e-05,3.605600e-05,&
     & 6.058900e-05,9.307800e-05,8.841600e-05,7.064500e-05,4.090500e-05/
      data  absb(601:900,5) /                                           &
     & 1.611800e-05,2.752300e-05,2.697900e-05,2.254300e-05,1.801000e-05,&
     & 2.216500e-05,3.640700e-05,3.534800e-05,2.900800e-05,2.098300e-05,&
     & 2.944400e-05,4.705500e-05,4.532600e-05,3.680800e-05,2.424900e-05,&
     & 3.808100e-05,5.968100e-05,5.708100e-05,4.598200e-05,2.781300e-05,&
     & 4.821200e-05,7.437400e-05,7.074000e-05,5.660200e-05,3.163500e-05,&
     & 1.261000e-05,2.171800e-05,2.134300e-05,1.790800e-05,1.372000e-05,&
     & 1.742400e-05,2.881200e-05,2.803400e-05,2.307900e-05,1.603400e-05,&
     & 2.324000e-05,3.733900e-05,3.603300e-05,2.933100e-05,1.858900e-05,&
     & 3.014900e-05,4.747600e-05,4.547900e-05,3.670000e-05,2.138200e-05,&
     & 3.827600e-05,5.929400e-05,5.647600e-05,4.525600e-05,2.438700e-05,&
     & 9.849400e-06,1.711900e-05,1.686500e-05,1.421500e-05,1.037400e-05,&
     & 1.368000e-05,2.278100e-05,2.221500e-05,1.835000e-05,1.216700e-05,&
     & 1.832400e-05,2.960300e-05,2.862300e-05,2.335600e-05,1.415300e-05,&
     & 2.384900e-05,3.773900e-05,3.620800e-05,2.927800e-05,1.633600e-05,&
     & 3.036200e-05,4.724000e-05,4.505700e-05,3.616400e-05,1.869000e-05,&
     & 7.433900e-06,1.309600e-05,1.294900e-05,1.099400e-05,7.922200e-06,&
     & 1.042300e-05,1.752900e-05,1.714300e-05,1.423000e-05,9.321500e-06,&
     & 1.406400e-05,2.289700e-05,2.219400e-05,1.816900e-05,1.087800e-05,&
     & 1.842100e-05,2.931900e-05,2.819100e-05,2.285000e-05,1.259500e-05,&
     & 2.356000e-05,3.684900e-05,3.520900e-05,2.831100e-05,1.445600e-05,&
     & 5.570400e-06,9.961900e-06,9.889100e-06,8.465400e-06,6.039400e-06,&
     & 7.889900e-06,1.342400e-05,1.316600e-05,1.099000e-05,7.131700e-06,&
     & 1.073900e-05,1.763200e-05,1.713300e-05,1.407700e-05,8.348700e-06,&
     & 1.416200e-05,2.268300e-05,2.186000e-05,1.776700e-05,9.698600e-06,&
     & 1.820600e-05,2.863500e-05,2.741400e-05,2.209100e-05,1.117000e-05,&
     & 4.158100e-06,7.559100e-06,7.536100e-06,6.510800e-06,4.585200e-06,&
     & 5.953800e-06,1.025900e-05,1.009400e-05,8.478400e-06,5.432400e-06,&
     & 8.180100e-06,1.355200e-05,1.320200e-05,1.089200e-05,6.381600e-06,&
     & 1.086500e-05,1.752000e-05,1.692500e-05,1.379600e-05,7.438200e-06,&
     & 1.404400e-05,2.222200e-05,2.131200e-05,1.721500e-05,8.597400e-06,&
     & 3.029500e-06,5.622700e-06,5.637000e-06,4.929100e-06,3.464400e-06,&
     & 4.399200e-06,7.700600e-06,7.607100e-06,6.440600e-06,4.117700e-06,&
     & 6.116800e-06,1.024800e-05,1.001400e-05,8.306500e-06,4.854100e-06,&
     & 8.202200e-06,1.333200e-05,1.291600e-05,1.056700e-05,5.678300e-06,&
     & 1.067900e-05,1.700600e-05,1.634800e-05,1.324200e-05,6.587100e-06,&
     & 2.175200e-06,4.135400e-06,4.174500e-06,3.702800e-06,2.607200e-06,&
     & 3.210500e-06,5.721900e-06,5.677800e-06,4.854600e-06,3.106600e-06,&
     & 4.524200e-06,7.679700e-06,7.530700e-06,6.287400e-06,3.674200e-06,&
     & 6.134200e-06,1.006500e-05,9.779500e-06,8.035300e-06,4.314600e-06,&
     & 8.057200e-06,1.291900e-05,1.245000e-05,1.011800e-05,5.024600e-06,&
     & 1.552000e-06,3.030400e-06,3.082100e-06,2.779700e-06,1.953900e-06,&
     & 2.330400e-06,4.236400e-06,4.225000e-06,3.653100e-06,2.332600e-06,&
     & 3.330300e-06,5.739400e-06,5.650200e-06,4.752300e-06,2.766400e-06,&
     & 4.571100e-06,7.578900e-06,7.386200e-06,6.099100e-06,3.260600e-06,&
     & 6.061200e-06,9.791400e-06,9.463500e-06,7.717400e-06,3.812900e-06,&
     & 1.089600e-06,2.195700e-06,2.253100e-06,2.074900e-06,1.459500e-06,&
     & 1.668200e-06,3.103500e-06,3.114400e-06,2.729600e-06,1.744100e-06,&
     & 2.422700e-06,4.250000e-06,4.202000e-06,3.567100e-06,2.072900e-06,&
     & 3.371800e-06,5.659800e-06,5.535300e-06,4.597700e-06,2.451800e-06,&
     & 4.521500e-06,7.366200e-06,7.141700e-06,5.847000e-06,2.878200e-06,&
     & 7.446900e-07,1.560500e-06,1.620000e-06,1.533500e-06,1.089300e-06,&
     & 1.167200e-06,2.232700e-06,2.258500e-06,2.014300e-06,1.301900e-06,&
     & 1.728400e-06,3.096600e-06,3.078200e-06,2.644200e-06,1.550600e-06,&
     & 2.444700e-06,4.167100e-06,4.091600e-06,3.425300e-06,1.838900e-06,&
     & 3.323400e-06,5.471000e-06,5.322700e-06,4.379300e-06,2.166600e-06,&
     & 5.035600e-07,1.103100e-06,1.161200e-06,1.136600e-06,8.111100e-07,&
     & 8.096700e-07,1.598200e-06,1.631600e-06,1.485500e-06,9.680300e-07,&
     & 1.224000e-06,2.244900e-06,2.245800e-06,1.955400e-06,1.154500e-06,&
     & 1.760900e-06,3.056100e-06,3.014400e-06,2.547100e-06,1.371600e-06,&
     & 2.430200e-06,4.050000e-06,3.953700e-06,3.272900e-06,1.621400e-06/
      data  absb(901:1175,5) /                                          &
     & 3.366900e-07,7.756200e-07,8.301300e-07,8.466100e-07,6.023900e-07,&
     & 5.561800e-07,1.137800e-06,1.173700e-06,1.096000e-06,7.170100e-07,&
     & 8.596600e-07,1.618900e-06,1.631500e-06,1.443200e-06,8.548900e-07,&
     & 1.260000e-06,2.231000e-06,2.212200e-06,1.890400e-06,1.016900e-06,&
     & 1.766800e-06,2.986400e-06,2.926500e-06,2.440300e-06,1.205300e-06,&
     & 2.259700e-07,5.486500e-07,5.983400e-07,6.397200e-07,4.557800e-07,&
     & 3.833600e-07,8.142100e-07,8.496500e-07,8.159200e-07,5.400000e-07,&
     & 6.062000e-07,1.172500e-06,1.190900e-06,1.072000e-06,6.434800e-07,&
     & 9.049400e-07,1.635400e-06,1.630400e-06,1.410000e-06,7.659700e-07,&
     & 1.288600e-06,2.211900e-06,2.176300e-06,1.829200e-06,9.091200e-07,&
     & 1.510200e-07,3.883900e-07,4.331500e-07,4.896900e-07,3.486600e-07,&
     & 2.634100e-07,5.827700e-07,6.161400e-07,6.111200e-07,4.101800e-07,&
     & 4.266600e-07,8.491400e-07,8.697800e-07,7.986800e-07,4.880700e-07,&
     & 6.490800e-07,1.198400e-06,1.201900e-06,1.053000e-06,5.812300e-07,&
     & 9.390400e-07,1.638500e-06,1.619000e-06,1.373400e-06,6.902800e-07,&
     & 9.987500e-08,2.739200e-07,3.141100e-07,3.799200e-07,2.673200e-07,&
     & 1.793600e-07,4.153700e-07,4.460100e-07,4.600200e-07,3.116000e-07,&
     & 2.980000e-07,6.123000e-07,6.332300e-07,5.955800e-07,3.693700e-07,&
     & 4.626200e-07,8.745700e-07,8.831600e-07,7.854400e-07,4.398700e-07,&
     & 6.807200e-07,1.209400e-06,1.200600e-06,1.029600e-06,5.226400e-07,&
     & 6.534300e-08,1.925100e-07,2.285100e-07,2.994700e-07,2.055600e-07,&
     & 1.209100e-07,2.946900e-07,3.224800e-07,3.487700e-07,2.368600e-07,&
     & 2.062700e-07,4.394600e-07,4.596300e-07,4.447100e-07,2.788900e-07,&
     & 3.274300e-07,6.352200e-07,6.465300e-07,5.850800e-07,3.316800e-07,&
     & 4.906000e-07,8.888100e-07,8.870800e-07,7.700300e-07,3.940900e-07,&
     & 4.330600e-08,1.369900e-07,1.689700e-07,2.403500e-07,1.617100e-07,&
     & 8.218200e-08,2.110900e-07,2.358900e-07,2.688700e-07,1.846500e-07,&
     & 1.439200e-07,3.180300e-07,3.366400e-07,3.357300e-07,2.160500e-07,&
     & 2.335600e-07,4.648900e-07,4.768800e-07,4.396100e-07,2.564900e-07,&
     & 3.560100e-07,6.575600e-07,6.599000e-07,5.798100e-07,3.049500e-07,&
     & 2.885400e-08,9.807200e-08,1.265100e-07,1.957700e-07,1.289300e-07,&
     & 5.587300e-08,1.516800e-07,1.736400e-07,2.100100e-07,1.460000e-07,&
     & 1.004100e-07,2.306800e-07,2.475000e-07,2.554200e-07,1.699200e-07,&
     & 1.666500e-07,3.408700e-07,3.525000e-07,3.317800e-07,2.012900e-07,&
     & 2.585900e-07,4.871800e-07,4.918300e-07,4.378300e-07,2.395100e-07,&
     & 1.918300e-08,7.029600e-08,9.595800e-08,1.616600e-07,1.032400e-07,&
     & 3.769000e-08,1.087300e-07,1.281600e-07,1.660600e-07,1.157300e-07,&
     & 6.956400e-08,1.668100e-07,1.818400e-07,1.953800e-07,1.339500e-07,&
     & 1.181700e-07,2.491200e-07,2.599800e-07,2.506800e-07,1.582000e-07,&
     & 1.868500e-07,3.597900e-07,3.656600e-07,3.304400e-07,1.882800e-07,&
     & 1.274900e-08,5.051400e-08,7.414700e-08,1.351100e-07,8.304500e-08,&
     & 2.523700e-08,7.778500e-08,9.501200e-08,1.330000e-07,9.199200e-08,&
     & 4.779000e-08,1.202400e-07,1.335800e-07,1.506000e-07,1.058600e-07,&
     & 8.323300e-08,1.813900e-07,1.913600e-07,1.897300e-07,1.245600e-07,&
     & 1.343000e-07,2.648000e-07,2.711300e-07,2.492600e-07,1.481700e-07,&
     & 8.607100e-09,3.674800e-08,5.834800e-08,1.138900e-07,6.728000e-08,&
     & 1.700300e-08,5.601200e-08,7.127000e-08,1.079700e-07,7.380100e-08,&
     & 3.288400e-08,8.701700e-08,9.879700e-08,1.175200e-07,8.432900e-08,&
     & 5.872200e-08,1.325000e-07,1.414700e-07,1.446800e-07,9.892300e-08,&
     & 9.671800e-08,1.954900e-07,2.016700e-07,1.888900e-07,1.176100e-07,&
     & 6.576200e-09,2.883900e-08,4.724000e-08,9.428100e-08,5.634700e-08,&
     & 1.296900e-08,4.374700e-08,5.662000e-08,8.836100e-08,6.207100e-08,&
     & 2.527500e-08,6.811200e-08,7.801400e-08,9.481400e-08,7.129300e-08,&
     & 4.556500e-08,1.041500e-07,1.117200e-07,1.156600e-07,8.415200e-08,&
     & 7.565500e-08,1.543500e-07,1.596500e-07,1.506500e-07,1.004200e-07/
      data  absb(1:300,6) /                                             &
     & 1.491700e-03,1.897500e-03,1.821700e-03,1.646200e-03,1.544500e-02,&
     & 2.033200e-03,2.587800e-03,2.458100e-03,2.097500e-03,1.701600e-02,&
     & 2.715700e-03,3.447900e-03,3.244200e-03,2.678700e-03,1.856600e-02,&
     & 3.563000e-03,4.499200e-03,4.203700e-03,3.389700e-03,2.018300e-02,&
     & 4.592500e-03,5.765100e-03,5.354300e-03,4.235900e-03,2.191900e-02,&
     & 1.282900e-03,1.645000e-03,1.579100e-03,1.404900e-03,1.266900e-02,&
     & 1.759400e-03,2.251900e-03,2.133700e-03,1.802800e-03,1.398300e-02,&
     & 2.366000e-03,3.012500e-03,2.824800e-03,2.308800e-03,1.534000e-02,&
     & 3.120600e-03,3.949200e-03,3.668500e-03,2.929200e-03,1.675800e-02,&
     & 4.042400e-03,5.071400e-03,4.679700e-03,3.671100e-03,1.831800e-02,&
     & 1.101000e-03,1.425500e-03,1.365000e-03,1.201700e-03,9.718400e-03,&
     & 1.521900e-03,1.959300e-03,1.849500e-03,1.548700e-03,1.078200e-02,&
     & 2.058600e-03,2.632400e-03,2.457400e-03,1.989200e-03,1.188500e-02,&
     & 2.727900e-03,3.458700e-03,3.199000e-03,2.531700e-03,1.307600e-02,&
     & 3.547600e-03,4.451100e-03,4.087300e-03,3.182500e-03,1.438100e-02,&
     & 9.443900e-04,1.234200e-03,1.179100e-03,1.029000e-03,7.097400e-03,&
     & 1.315200e-03,1.703800e-03,1.603800e-03,1.332000e-03,7.921900e-03,&
     & 1.787300e-03,2.295700e-03,2.136000e-03,1.716500e-03,8.813000e-03,&
     & 2.377600e-03,3.022700e-03,2.785600e-03,2.191700e-03,9.777300e-03,&
     & 3.104200e-03,3.900700e-03,3.564500e-03,2.760900e-03,1.082300e-02,&
     & 8.141800e-04,1.072700e-03,1.021500e-03,8.828200e-04,5.283600e-03,&
     & 1.138900e-03,1.485100e-03,1.393600e-03,1.146700e-03,5.945900e-03,&
     & 1.553000e-03,2.004700e-03,1.858600e-03,1.483000e-03,6.672200e-03,&
     & 2.075000e-03,2.642500e-03,2.424700e-03,1.898600e-03,7.458900e-03,&
     & 2.714400e-03,3.419100e-03,3.109300e-03,2.394700e-03,8.305500e-03,&
     & 7.074300e-04,9.375300e-04,8.900000e-04,7.595900e-04,4.071800e-03,&
     & 9.918200e-04,1.300500e-03,1.215400e-03,9.906200e-04,4.624500e-03,&
     & 1.356400e-03,1.755100e-03,1.620700e-03,1.285600e-03,5.228700e-03,&
     & 1.815900e-03,2.317400e-03,2.115100e-03,1.646900e-03,5.879700e-03,&
     & 2.377300e-03,3.005200e-03,2.718900e-03,2.080000e-03,6.574600e-03,&
     & 6.152500e-04,8.197000e-04,7.755300e-04,6.542300e-04,3.267600e-03,&
     & 8.639100e-04,1.136800e-03,1.059200e-03,8.568300e-04,3.740200e-03,&
     & 1.184200e-03,1.534900e-03,1.411300e-03,1.113300e-03,4.253100e-03,&
     & 1.585000e-03,2.031400e-03,1.845300e-03,1.427100e-03,4.802200e-03,&
     & 2.073800e-03,2.634700e-03,2.375600e-03,1.807300e-03,5.389400e-03,&
     & 5.381300e-04,7.185200e-04,6.774200e-04,5.661000e-04,2.683700e-03,&
     & 7.560900e-04,9.953900e-04,9.239600e-04,7.431900e-04,3.086400e-03,&
     & 1.036000e-03,1.346000e-03,1.231700e-03,9.660000e-04,3.522000e-03,&
     & 1.384100e-03,1.781100e-03,1.612400e-03,1.241100e-03,3.988200e-03,&
     & 1.808300e-03,2.304700e-03,2.075300e-03,1.574900e-03,4.486300e-03,&
     & 4.704700e-04,6.277400e-04,5.894500e-04,4.888800e-04,2.209400e-03,&
     & 6.610200e-04,8.692400e-04,8.037700e-04,6.424400e-04,2.549400e-03,&
     & 9.036300e-04,1.175700e-03,1.072500e-03,8.368100e-04,2.916600e-03,&
     & 1.204800e-03,1.552600e-03,1.403100e-03,1.077500e-03,3.310300e-03,&
     & 1.571800e-03,2.002800e-03,1.802400e-03,1.367700e-03,3.730800e-03,&
     & 4.190700e-04,5.577100e-04,5.211900e-04,4.279200e-04,1.800300e-03,&
     & 5.867100e-04,7.713300e-04,7.099800e-04,5.632500e-04,2.082800e-03,&
     & 7.991600e-04,1.039600e-03,9.456000e-04,7.349700e-04,2.387500e-03,&
     & 1.062400e-03,1.366300e-03,1.233800e-03,9.459100e-04,2.714700e-03,&
     & 1.382800e-03,1.756900e-03,1.579100e-03,1.198600e-03,3.062500e-03,&
     & 3.726800e-04,4.954000e-04,4.604900e-04,3.744100e-04,1.459900e-03,&
     & 5.196300e-04,6.829500e-04,6.261600e-04,4.937800e-04,1.692800e-03,&
     & 7.055200e-04,9.162700e-04,8.311800e-04,6.443400e-04,1.943900e-03,&
     & 9.356600e-04,1.198700e-03,1.080800e-03,8.274700e-04,2.212900e-03,&
     & 1.216500e-03,1.538600e-03,1.379300e-03,1.046000e-03,2.495800e-03,&
     & 3.296600e-04,4.387600e-04,4.064100e-04,3.276700e-04,1.168200e-03,&
     & 4.583300e-04,6.022600e-04,5.505900e-04,4.324800e-04,1.358100e-03,&
     & 6.209900e-04,8.046100e-04,7.285100e-04,5.635100e-04,1.562100e-03,&
     & 8.219300e-04,1.049700e-03,9.442800e-04,7.219900e-04,1.779300e-03,&
     & 1.068500e-03,1.344900e-03,1.202800e-03,9.104600e-04,2.005200e-03/
      data  absb(301:600,6) /                                           &
     & 2.921500e-04,3.888500e-04,3.590600e-04,2.875200e-04,9.349800e-04,&
     & 4.049800e-04,5.312100e-04,4.843600e-04,3.792500e-04,1.088800e-03,&
     & 5.472400e-04,7.070700e-04,6.387000e-04,4.928100e-04,1.253900e-03,&
     & 7.240300e-04,9.206100e-04,8.259400e-04,6.299100e-04,1.427500e-03,&
     & 9.420700e-04,1.177900e-03,1.050300e-03,7.927700e-04,1.605800e-03,&
     & 2.606000e-04,3.462500e-04,3.186500e-04,2.536000e-04,7.559500e-04,&
     & 3.599000e-04,4.709600e-04,4.279200e-04,3.338000e-04,8.808300e-04,&
     & 4.854000e-04,6.245700e-04,5.625700e-04,4.326000e-04,1.013700e-03,&
     & 6.423600e-04,8.117700e-04,7.259600e-04,5.515300e-04,1.151900e-03,&
     & 8.367300e-04,1.037800e-03,9.217700e-04,6.931100e-04,1.293800e-03,&
     & 2.316700e-04,3.075000e-04,2.820600e-04,2.233500e-04,6.015700e-04,&
     & 3.190800e-04,4.165000e-04,3.775000e-04,2.932700e-04,7.008300e-04,&
     & 4.302100e-04,5.509700e-04,4.948800e-04,3.791800e-04,8.053200e-04,&
     & 5.699900e-04,7.155100e-04,6.377000e-04,4.825500e-04,9.142400e-04,&
     & 7.425100e-04,9.148100e-04,8.091300e-04,6.058500e-04,1.026400e-03,&
     & 2.052400e-04,2.722100e-04,2.490600e-04,1.963400e-04,4.706300e-04,&
     & 2.825500e-04,3.675500e-04,3.324400e-04,2.573300e-04,5.478400e-04,&
     & 3.811900e-04,4.854600e-04,4.350700e-04,3.319200e-04,6.292900e-04,&
     & 5.053100e-04,6.305200e-04,5.601500e-04,4.220800e-04,7.142600e-04,&
     & 6.576800e-04,8.058900e-04,7.109200e-04,5.300700e-04,8.018200e-04,&
     & 1.826800e-04,2.415500e-04,2.204400e-04,1.729000e-04,3.647300e-04,&
     & 2.514700e-04,3.253100e-04,2.934700e-04,2.261800e-04,4.243100e-04,&
     & 3.393000e-04,4.294000e-04,3.835100e-04,2.913600e-04,4.872900e-04,&
     & 4.490900e-04,5.575400e-04,4.936200e-04,3.703100e-04,5.527700e-04,&
     & 5.828800e-04,7.116500e-04,6.262500e-04,4.653900e-04,6.209400e-04,&
     & 1.627500e-04,2.142700e-04,1.949200e-04,1.522100e-04,2.788200e-04,&
     & 2.239700e-04,2.880700e-04,2.590500e-04,1.988400e-04,3.246400e-04,&
     & 3.017300e-04,3.802000e-04,3.383800e-04,2.559100e-04,3.727900e-04,&
     & 3.983500e-04,4.929000e-04,4.352300e-04,3.253900e-04,4.231800e-04,&
     & 5.151200e-04,6.281400e-04,5.523600e-04,4.092800e-04,4.764400e-04,&
     & 1.454100e-04,1.905000e-04,1.726900e-04,1.341500e-04,2.098800e-04,&
     & 1.996800e-04,2.557900e-04,2.291700e-04,1.750400e-04,2.445400e-04,&
     & 2.683100e-04,3.371300e-04,2.992400e-04,2.253400e-04,2.811600e-04,&
     & 3.529600e-04,4.360300e-04,3.846000e-04,2.865700e-04,3.197100e-04,&
     & 4.538500e-04,5.542200e-04,4.874700e-04,3.605100e-04,3.603300e-04,&
     & 1.301200e-04,1.697900e-04,1.533200e-04,1.184600e-04,1.585800e-04,&
     & 1.781100e-04,2.275800e-04,2.032800e-04,1.544700e-04,1.850000e-04,&
     & 2.384600e-04,2.992000e-04,2.650800e-04,1.989000e-04,2.128900e-04,&
     & 3.119500e-04,3.857900e-04,3.402900e-04,2.530500e-04,2.422600e-04,&
     & 3.983100e-04,4.884600e-04,4.304000e-04,3.181500e-04,2.735100e-04,&
     & 1.163400e-04,1.514700e-04,1.363600e-04,1.047500e-04,1.197800e-04,&
     & 1.586300e-04,2.024800e-04,1.805000e-04,1.366500e-04,1.397300e-04,&
     & 2.113700e-04,2.653000e-04,2.349600e-04,1.759200e-04,1.608700e-04,&
     & 2.746700e-04,3.407900e-04,3.010900e-04,2.237200e-04,1.834400e-04,&
     & 3.478200e-04,4.291900e-04,3.795000e-04,2.808000e-04,2.075700e-04,&
     & 1.031200e-04,1.340800e-04,1.204100e-04,9.211000e-05,9.290300e-05,&
     & 1.400800e-04,1.787100e-04,1.591400e-04,1.201600e-04,1.083100e-04,&
     & 1.855600e-04,2.332900e-04,2.067800e-04,1.546400e-04,1.247600e-04,&
     & 2.393900e-04,2.983300e-04,2.642900e-04,1.964900e-04,1.424800e-04,&
     & 3.011700e-04,3.737300e-04,3.316200e-04,2.460500e-04,1.615200e-04,&
     & 8.844300e-05,1.151200e-04,1.033600e-04,7.895000e-05,7.068400e-05,&
     & 1.198500e-04,1.532700e-04,1.365800e-04,1.031100e-04,8.250400e-05,&
     & 1.581300e-04,1.996200e-04,1.773400e-04,1.327600e-04,9.524400e-05,&
     & 2.030300e-04,2.544500e-04,2.261700e-04,1.685900e-04,1.090700e-04,&
     & 2.545700e-04,3.176400e-04,2.827500e-04,2.106700e-04,1.240100e-04,&
     & 7.310500e-05,9.555300e-05,8.589400e-05,6.566500e-05,5.258600e-05,&
     & 9.908800e-05,1.273100e-04,1.136600e-04,8.595000e-05,6.160300e-05,&
     & 1.305200e-04,1.657500e-04,1.476600e-04,1.108500e-04,7.139500e-05,&
     & 1.673700e-04,2.110000e-04,1.881700e-04,1.408200e-04,8.206000e-05,&
     & 2.097100e-04,2.632800e-04,2.348200e-04,1.758300e-04,9.361600e-05/
      data  absb(601:900,6) /                                           &
     & 5.796400e-05,7.616000e-05,6.857600e-05,5.254100e-05,4.007300e-05,&
     & 7.883400e-05,1.018300e-04,9.106300e-05,6.904500e-05,4.711100e-05,&
     & 1.041200e-04,1.329400e-04,1.186400e-04,8.932200e-05,5.477000e-05,&
     & 1.338200e-04,1.695200e-04,1.514300e-04,1.137400e-04,6.313400e-05,&
     & 1.680800e-04,2.119600e-04,1.892800e-04,1.422000e-04,7.222500e-05,&
     & 4.577500e-05,6.047900e-05,5.455500e-05,4.190200e-05,3.039700e-05,&
     & 6.249600e-05,8.116400e-05,7.270800e-05,5.527400e-05,3.587800e-05,&
     & 8.278200e-05,1.062600e-04,9.500200e-05,7.174000e-05,4.184100e-05,&
     & 1.067000e-04,1.358300e-04,1.214900e-04,9.155800e-05,4.837700e-05,&
     & 1.343800e-04,1.702100e-04,1.521300e-04,1.146300e-04,5.551200e-05,&
     & 3.609500e-05,4.796000e-05,4.334000e-05,3.337900e-05,2.288200e-05,&
     & 4.946800e-05,6.461400e-05,5.797900e-05,4.419900e-05,2.711000e-05,&
     & 6.572800e-05,8.483000e-05,7.596600e-05,5.754100e-05,3.172900e-05,&
     & 8.498900e-05,1.087100e-04,9.733800e-05,7.359500e-05,3.681600e-05,&
     & 1.073300e-04,1.365500e-04,1.221600e-04,9.228900e-05,4.238000e-05,&
     & 2.754800e-05,3.686600e-05,3.339800e-05,2.581600e-05,1.740600e-05,&
     & 3.801700e-05,4.997800e-05,4.493900e-05,3.436300e-05,2.071700e-05,&
     & 5.084300e-05,6.599800e-05,5.917300e-05,4.496000e-05,2.434000e-05,&
     & 6.610300e-05,8.498200e-05,7.616500e-05,5.773400e-05,2.833400e-05,&
     & 8.388900e-05,1.071800e-04,9.597100e-05,7.265100e-05,3.271600e-05,&
     & 2.089100e-05,2.816000e-05,2.558100e-05,1.985300e-05,1.321900e-05,&
     & 2.905600e-05,3.844800e-05,3.464300e-05,2.657800e-05,1.580300e-05,&
     & 3.911900e-05,5.108600e-05,4.587000e-05,3.494900e-05,1.864300e-05,&
     & 5.116700e-05,6.614400e-05,5.932100e-05,4.507800e-05,2.178100e-05,&
     & 6.531300e-05,8.380700e-05,7.510000e-05,5.696500e-05,2.522800e-05,&
     & 1.579700e-05,2.145200e-05,1.954100e-05,1.523400e-05,9.986400e-06,&
     & 2.214800e-05,2.950600e-05,2.664400e-05,2.050700e-05,1.199500e-05,&
     & 3.002800e-05,3.945600e-05,3.547800e-05,2.711300e-05,1.421500e-05,&
     & 3.952600e-05,5.138000e-05,4.612200e-05,3.513900e-05,1.667000e-05,&
     & 5.074700e-05,6.540900e-05,5.866100e-05,4.458800e-05,1.936900e-05,&
     & 1.168500e-05,1.600100e-05,1.462800e-05,1.147100e-05,7.493600e-06,&
     & 1.654800e-05,2.221300e-05,2.011300e-05,1.553700e-05,9.053600e-06,&
     & 2.263800e-05,2.995400e-05,2.697900e-05,2.068500e-05,1.077900e-05,&
     & 3.004800e-05,3.929300e-05,3.531100e-05,2.696800e-05,1.269700e-05,&
     & 3.886000e-05,5.033800e-05,4.518300e-05,3.441000e-05,1.480600e-05,&
     & 8.534800e-06,1.179200e-05,1.082500e-05,8.551500e-06,5.587100e-06,&
     & 1.222400e-05,1.654200e-05,1.502300e-05,1.165900e-05,6.794700e-06,&
     & 1.689900e-05,2.252100e-05,2.032100e-05,1.563300e-05,8.132000e-06,&
     & 2.263700e-05,2.978300e-05,2.680100e-05,2.052500e-05,9.622700e-06,&
     & 2.951100e-05,3.843700e-05,3.453100e-05,2.635600e-05,1.126500e-05,&
     & 6.205300e-06,8.649800e-06,7.982800e-06,6.358700e-06,4.135500e-06,&
     & 8.992400e-06,1.227400e-05,1.118400e-05,8.722800e-06,5.064600e-06,&
     & 1.257700e-05,1.687800e-05,1.526300e-05,1.178100e-05,6.098000e-06,&
     & 1.700400e-05,2.251000e-05,2.028700e-05,1.557900e-05,7.249500e-06,&
     & 2.234500e-05,2.927300e-05,2.632700e-05,2.013900e-05,8.524100e-06,&
     & 4.453500e-06,6.266300e-06,5.821500e-06,4.684700e-06,3.040300e-06,&
     & 6.538600e-06,9.008700e-06,8.238300e-06,6.465000e-06,3.749500e-06,&
     & 9.262600e-06,1.252300e-05,1.135300e-05,8.795800e-06,4.545500e-06,&
     & 1.265200e-05,1.686600e-05,1.522400e-05,1.172600e-05,5.432400e-06,&
     & 1.678200e-05,2.211500e-05,1.991000e-05,1.527100e-05,6.415400e-06,&
     & 3.125500e-06,4.444500e-06,4.162500e-06,3.397300e-06,2.224800e-06,&
     & 4.660700e-06,6.487100e-06,5.960900e-06,4.714900e-06,2.763300e-06,&
     & 6.699600e-06,9.134900e-06,8.307200e-06,6.465100e-06,3.375100e-06,&
     & 9.270500e-06,1.244900e-05,1.125600e-05,8.699900e-06,4.058200e-06,&
     & 1.242900e-05,1.648000e-05,1.485400e-05,1.142800e-05,4.816600e-06,&
     & 2.177600e-06,3.128700e-06,2.959300e-06,2.458800e-06,1.616200e-06,&
     & 3.300400e-06,4.642400e-06,4.291500e-06,3.427900e-06,2.021600e-06,&
     & 4.817800e-06,6.631700e-06,6.051200e-06,4.734700e-06,2.486900e-06,&
     & 6.763200e-06,9.150700e-06,8.291400e-06,6.428400e-06,3.009900e-06,&
     & 9.169700e-06,1.223400e-05,1.104200e-05,8.522400e-06,3.591900e-06/
      data  absb(901:1175,6) /                                          &
     & 1.505300e-06,2.185800e-06,2.090900e-06,1.777400e-06,1.163800e-06,&
     & 2.320800e-06,3.300100e-06,3.074100e-06,2.484900e-06,1.465500e-06,&
     & 3.442600e-06,4.787400e-06,4.385800e-06,3.454200e-06,1.814500e-06,&
     & 4.907300e-06,6.693700e-06,6.079800e-06,4.729900e-06,2.211600e-06,&
     & 6.734900e-06,9.045300e-06,8.176900e-06,6.330900e-06,2.654500e-06,&
     & 1.046200e-06,1.534000e-06,1.484800e-06,1.296400e-06,8.527300e-07,&
     & 1.640200e-06,2.355700e-06,2.212400e-06,1.813700e-06,1.079900e-06,&
     & 2.470900e-06,3.471200e-06,3.194100e-06,2.534200e-06,1.344800e-06,&
     & 3.575800e-06,4.916800e-06,4.477600e-06,3.496400e-06,1.649600e-06,&
     & 4.970200e-06,6.720200e-06,6.083500e-06,4.722200e-06,1.991200e-06,&
     & 7.266300e-07,1.075000e-06,1.054200e-06,9.505900e-07,6.298700e-07,&
     & 1.158200e-06,1.678900e-06,1.591000e-06,1.327600e-06,8.010600e-07,&
     & 1.771900e-06,2.514400e-06,2.326700e-06,1.862200e-06,1.003300e-06,&
     & 2.604600e-06,3.611500e-06,3.298300e-06,2.587200e-06,1.238100e-06,&
     & 3.669700e-06,4.994500e-06,4.528800e-06,3.523600e-06,1.503100e-06,&
     & 5.012800e-07,7.482900e-07,7.450300e-07,6.990200e-07,4.641700e-07,&
     & 8.129000e-07,1.188900e-06,1.138300e-06,9.707500e-07,5.912400e-07,&
     & 1.263700e-06,1.811100e-06,1.687400e-06,1.365400e-06,7.448500e-07,&
     & 1.887000e-06,2.641400e-06,2.420800e-06,1.908800e-06,9.239800e-07,&
     & 2.698200e-06,3.698100e-06,3.360500e-06,2.620900e-06,1.128400e-06,&
     & 3.431600e-07,5.173000e-07,5.242800e-07,5.165000e-07,3.416300e-07,&
     & 5.663600e-07,8.360000e-07,8.098800e-07,7.095900e-07,4.340200e-07,&
     & 8.953900e-07,1.295700e-06,1.217000e-06,9.988100e-07,5.491700e-07,&
     & 1.358500e-06,1.921300e-06,1.768100e-06,1.403900e-06,6.848700e-07,&
     & 1.972800e-06,2.726700e-06,2.484000e-06,1.943100e-06,8.412700e-07,&
     & 2.372900e-07,3.614100e-07,3.734600e-07,3.881400e-07,2.596500e-07,&
     & 3.984700e-07,5.928100e-07,5.814500e-07,5.249700e-07,3.286500e-07,&
     & 6.401200e-07,9.341800e-07,8.845100e-07,7.376000e-07,4.172600e-07,&
     & 9.854800e-07,1.407200e-06,1.300900e-06,1.041400e-06,5.230400e-07,&
     & 1.452400e-06,2.024300e-06,1.849000e-06,1.451400e-06,6.458200e-07,&
     & 1.642200e-07,2.531300e-07,2.674100e-07,2.955500e-07,2.008300e-07,&
     & 2.808500e-07,4.208900e-07,4.184700e-07,3.911200e-07,2.533100e-07,&
     & 4.584000e-07,6.740500e-07,6.438000e-07,5.469600e-07,3.224500e-07,&
     & 7.159100e-07,1.031400e-06,9.587900e-07,7.746200e-07,4.063600e-07,&
     & 1.070700e-06,1.505000e-06,1.378500e-06,1.086800e-06,5.040700e-07,&
     & 1.129700e-07,1.765400e-07,1.916000e-07,2.278500e-07,1.560000e-07,&
     & 1.968700e-07,2.973600e-07,3.002400e-07,2.925000e-07,1.955700e-07,&
     & 3.265500e-07,4.837900e-07,4.667300e-07,4.054500e-07,2.492600e-07,&
     & 5.177600e-07,7.523900e-07,7.039700e-07,5.751500e-07,3.157000e-07,&
     & 7.858300e-07,1.114600e-06,1.024200e-06,8.118000e-07,3.935500e-07,&
     & 7.720000e-08,1.226400e-07,1.376600e-07,1.785600e-07,1.218700e-07,&
     & 1.371500e-07,2.090500e-07,2.148800e-07,2.199800e-07,1.512700e-07,&
     & 2.313600e-07,3.452600e-07,3.368700e-07,3.006700e-07,1.927600e-07,&
     & 3.726500e-07,5.459800e-07,5.145300e-07,4.263200e-07,2.452900e-07,&
     & 5.739600e-07,8.217200e-07,7.579400e-07,6.047700e-07,3.074700e-07,&
     & 5.295500e-08,8.576400e-08,1.001700e-07,1.431000e-07,9.643300e-08,&
     & 9.583100e-08,1.475700e-07,1.547900e-07,1.674500e-07,1.181900e-07,&
     & 1.644400e-07,2.470700e-07,2.439700e-07,2.246300e-07,1.505900e-07,&
     & 2.689600e-07,3.969800e-07,3.770600e-07,3.174400e-07,1.923600e-07,&
     & 4.202700e-07,6.068600e-07,5.621700e-07,4.521600e-07,2.424300e-07,&
     & 4.061300e-08,6.633000e-08,7.875600e-08,1.168200e-07,8.076300e-08,&
     & 7.411000e-08,1.146400e-07,1.211900e-07,1.339400e-07,1.002400e-07,&
     & 1.282500e-07,1.932700e-07,1.916100e-07,1.784700e-07,1.288700e-07,&
     & 2.112500e-07,3.127900e-07,2.977900e-07,2.521700e-07,1.653900e-07,&
     & 3.322100e-07,4.812800e-07,4.464800e-07,3.601400e-07,2.091600e-07/
      data  absb(1:300,7) /                                             &
     & 4.008200e-03,4.747100e-03,4.210600e-03,3.309700e-03,2.979700e-02,&
     & 5.495600e-03,6.450300e-03,5.674100e-03,4.360600e-03,3.307600e-02,&
     & 7.320100e-03,8.543400e-03,7.472400e-03,5.689900e-03,3.671800e-02,&
     & 9.476800e-03,1.100600e-02,9.649000e-03,7.360700e-03,4.056200e-02,&
     & 1.201600e-02,1.388300e-02,1.224800e-02,9.412600e-03,4.460700e-02,&
     & 3.518200e-03,4.144000e-03,3.671200e-03,2.886500e-03,2.510600e-02,&
     & 4.836800e-03,5.658500e-03,4.976300e-03,3.824100e-03,2.817800e-02,&
     & 6.439100e-03,7.492600e-03,6.579700e-03,5.012700e-03,3.149900e-02,&
     & 8.355600e-03,9.659000e-03,8.495900e-03,6.495600e-03,3.498300e-02,&
     & 1.063600e-02,1.219700e-02,1.077800e-02,8.292700e-03,3.867700e-02,&
     & 3.080800e-03,3.618000e-03,3.202400e-03,2.507700e-03,2.013300e-02,&
     & 4.234200e-03,4.940800e-03,4.357300e-03,3.344700e-03,2.281100e-02,&
     & 5.648400e-03,6.542500e-03,5.759800e-03,4.405000e-03,2.564800e-02,&
     & 7.356900e-03,8.445900e-03,7.447800e-03,5.699700e-03,2.863300e-02,&
     & 9.407900e-03,1.069500e-02,9.452500e-03,7.267100e-03,3.175000e-02,&
     & 2.693700e-03,3.158100e-03,2.798000e-03,2.177500e-03,1.539400e-02,&
     & 3.708500e-03,4.310900e-03,3.804800e-03,2.921900e-03,1.750700e-02,&
     & 4.960900e-03,5.716400e-03,5.035500e-03,3.848300e-03,1.973000e-02,&
     & 6.489500e-03,7.400200e-03,6.521900e-03,4.980600e-03,2.208400e-02,&
     & 8.316300e-03,9.405100e-03,8.291400e-03,6.352500e-03,2.455100e-02,&
     & 2.364200e-03,2.766800e-03,2.448900e-03,1.898800e-03,1.186800e-02,&
     & 3.259800e-03,3.781100e-03,3.329000e-03,2.551000e-03,1.355900e-02,&
     & 4.374700e-03,5.020200e-03,4.415500e-03,3.361300e-03,1.534000e-02,&
     & 5.734000e-03,6.518900e-03,5.728600e-03,4.353800e-03,1.722000e-02,&
     & 7.360000e-03,8.299000e-03,7.299200e-03,5.554800e-03,1.920500e-02,&
     & 2.089800e-03,2.440500e-03,2.154200e-03,1.662600e-03,9.441700e-03,&
     & 2.886300e-03,3.335300e-03,2.931800e-03,2.235200e-03,1.081300e-02,&
     & 3.877100e-03,4.435800e-03,3.893500e-03,2.947200e-03,1.226000e-02,&
     & 5.083900e-03,5.766300e-03,5.061000e-03,3.822900e-03,1.379700e-02,&
     & 6.536200e-03,7.347200e-03,6.454900e-03,4.878100e-03,1.542700e-02,&
     & 1.851700e-03,2.154800e-03,1.896500e-03,1.458000e-03,7.777300e-03,&
     & 2.557600e-03,2.947100e-03,2.584600e-03,1.961200e-03,8.917600e-03,&
     & 3.434500e-03,3.924400e-03,3.436200e-03,2.590600e-03,1.013200e-02,&
     & 4.506400e-03,5.099400e-03,4.470000e-03,3.364200e-03,1.143100e-02,&
     & 5.809700e-03,6.508300e-03,5.704600e-03,4.290500e-03,1.280800e-02,&
     & 1.645800e-03,1.910300e-03,1.678100e-03,1.283100e-03,6.514100e-03,&
     & 2.269800e-03,2.613000e-03,2.287700e-03,1.727800e-03,7.484900e-03,&
     & 3.046400e-03,3.477200e-03,3.042700e-03,2.284500e-03,8.519800e-03,&
     & 4.005300e-03,4.520500e-03,3.956300e-03,2.967100e-03,9.623000e-03,&
     & 5.170400e-03,5.787500e-03,5.054200e-03,3.780600e-03,1.080000e-02,&
     & 1.454800e-03,1.690300e-03,1.483000e-03,1.127600e-03,5.446100e-03,&
     & 2.003100e-03,2.310200e-03,2.021400e-03,1.520200e-03,6.276300e-03,&
     & 2.691900e-03,3.072300e-03,2.685400e-03,2.011400e-03,7.163600e-03,&
     & 3.543600e-03,4.004000e-03,3.493500e-03,2.608800e-03,8.109800e-03,&
     & 4.574200e-03,5.141600e-03,4.472300e-03,3.326100e-03,9.111200e-03,&
     & 1.302500e-03,1.517600e-03,1.331900e-03,1.007800e-03,4.497000e-03,&
     & 1.791100e-03,2.067600e-03,1.810400e-03,1.358300e-03,5.195300e-03,&
     & 2.407000e-03,2.751100e-03,2.402100e-03,1.793300e-03,5.945500e-03,&
     & 3.163500e-03,3.591600e-03,3.128500e-03,2.322800e-03,6.743500e-03,&
     & 4.074500e-03,4.610700e-03,4.004800e-03,2.965000e-03,7.590400e-03,&
     & 1.162800e-03,1.356400e-03,1.191100e-03,9.003500e-04,3.686500e-03,&
     & 1.598100e-03,1.845800e-03,1.615700e-03,1.211100e-03,4.271800e-03,&
     & 2.143400e-03,2.457800e-03,2.145100e-03,1.596100e-03,4.900400e-03,&
     & 2.807000e-03,3.208900e-03,2.793100e-03,2.069300e-03,5.569000e-03,&
     & 3.606000e-03,4.111400e-03,3.571800e-03,2.640800e-03,6.276700e-03,&
     & 1.034900e-03,1.207900e-03,1.060800e-03,8.014500e-04,2.977200e-03,&
     & 1.420000e-03,1.644200e-03,1.438400e-03,1.076200e-03,3.461900e-03,&
     & 1.897400e-03,2.188100e-03,1.908900e-03,1.419200e-03,3.981500e-03,&
     & 2.477900e-03,2.849900e-03,2.481800e-03,1.840000e-03,4.532200e-03,&
     & 3.175400e-03,3.638500e-03,3.166600e-03,2.345700e-03,5.115100e-03/
      data  absb(301:600,7) /                                           &
     & 9.223200e-04,1.077200e-03,9.452400e-04,7.125300e-04,2.403200e-03,&
     & 1.260500e-03,1.464800e-03,1.281000e-03,9.567300e-04,2.802300e-03,&
     & 1.678200e-03,1.943400e-03,1.696100e-03,1.261100e-03,3.228300e-03,&
     & 2.185800e-03,2.522000e-03,2.197800e-03,1.632900e-03,3.680300e-03,&
     & 2.795300e-03,3.212500e-03,2.797300e-03,2.077600e-03,4.158600e-03,&
     & 8.257700e-04,9.660200e-04,8.469800e-04,6.365100e-04,1.958900e-03,&
     & 1.123100e-03,1.308200e-03,1.144200e-03,8.538000e-04,2.287400e-03,&
     & 1.489400e-03,1.728300e-03,1.508600e-03,1.123100e-03,2.638100e-03,&
     & 1.934700e-03,2.235800e-03,1.948600e-03,1.450200e-03,3.010000e-03,&
     & 2.471800e-03,2.843100e-03,2.475300e-03,1.839900e-03,3.401800e-03,&
     & 7.364300e-04,8.631900e-04,7.564400e-04,5.675700e-04,1.569800e-03,&
     & 9.972100e-04,1.163400e-03,1.017500e-03,7.594900e-04,1.834800e-03,&
     & 1.318900e-03,1.531400e-03,1.336400e-03,9.961900e-04,2.118300e-03,&
     & 1.710900e-03,1.977100e-03,1.722200e-03,1.282700e-03,2.418700e-03,&
     & 2.186100e-03,2.513100e-03,2.185100e-03,1.624300e-03,2.733900e-03,&
     & 6.543400e-04,7.683700e-04,6.729100e-04,5.048000e-04,1.234900e-03,&
     & 8.833500e-04,1.031200e-03,9.013600e-04,6.734800e-04,1.445400e-03,&
     & 1.165400e-03,1.354400e-03,1.180600e-03,8.806500e-04,1.670100e-03,&
     & 1.513000e-03,1.746800e-03,1.519700e-03,1.131700e-03,1.908400e-03,&
     & 1.934600e-03,2.221400e-03,1.927500e-03,1.431100e-03,2.159000e-03,&
     & 5.825000e-04,6.841500e-04,5.990000e-04,4.492300e-04,9.613800e-04,&
     & 7.837900e-04,9.155900e-04,7.993500e-04,5.972400e-04,1.126400e-03,&
     & 1.033700e-03,1.200600e-03,1.045200e-03,7.791800e-04,1.302700e-03,&
     & 1.343000e-03,1.548500e-03,1.344500e-03,9.994300e-04,1.490300e-03,&
     & 1.720700e-03,1.971200e-03,1.705800e-03,1.262800e-03,1.687400e-03,&
     & 5.178800e-04,6.085100e-04,5.324400e-04,3.992200e-04,7.380700e-04,&
     & 6.956000e-04,8.128000e-04,7.089600e-04,5.292600e-04,8.655500e-04,&
     & 9.185400e-04,1.065300e-03,9.260800e-04,6.894400e-04,1.002900e-03,&
     & 1.194800e-03,1.375200e-03,1.191700e-03,8.834100e-04,1.149100e-03,&
     & 1.533500e-03,1.754700e-03,1.512500e-03,1.116200e-03,1.302400e-03,&
     & 4.609200e-04,5.421100e-04,4.740800e-04,3.550900e-04,5.568200e-04,&
     & 6.191800e-04,7.232100e-04,6.300500e-04,4.699700e-04,6.545400e-04,&
     & 8.188100e-04,9.482200e-04,8.229000e-04,6.114100e-04,7.599700e-04,&
     & 1.066800e-03,1.226700e-03,1.059300e-03,7.829200e-04,8.719500e-04,&
     & 1.370400e-03,1.568100e-03,1.346500e-03,9.892000e-04,9.897300e-04,&
     & 4.115200e-04,4.840900e-04,4.230800e-04,3.164500e-04,4.216800e-04,&
     & 5.533400e-04,6.457500e-04,5.616700e-04,4.183300e-04,4.967700e-04,&
     & 7.329900e-04,8.476600e-04,7.338300e-04,5.437000e-04,5.777400e-04,&
     & 9.558800e-04,1.098700e-03,9.458600e-04,6.961300e-04,6.638400e-04,&
     & 1.228800e-03,1.406500e-03,1.204000e-03,8.801300e-04,7.548600e-04,&
     & 3.685400e-04,4.331600e-04,3.781700e-04,2.826000e-04,3.189900e-04,&
     & 4.964600e-04,5.781600e-04,5.022100e-04,3.731500e-04,3.765600e-04,&
     & 6.580800e-04,7.606300e-04,6.566700e-04,4.848000e-04,4.387600e-04,&
     & 8.586700e-04,9.878200e-04,8.474800e-04,6.213300e-04,5.051700e-04,&
     & 1.103700e-03,1.265800e-03,1.080100e-03,7.861100e-04,5.753200e-04,&
     & 3.286700e-04,3.857200e-04,3.362200e-04,2.507100e-04,2.485500e-04,&
     & 4.434300e-04,5.156900e-04,4.468600e-04,3.310100e-04,2.938100e-04,&
     & 5.881000e-04,6.799000e-04,5.852800e-04,4.303100e-04,3.425500e-04,&
     & 7.673700e-04,8.842800e-04,7.564000e-04,5.521700e-04,3.947800e-04,&
     & 9.851700e-04,1.134200e-03,9.655400e-04,6.995100e-04,4.500200e-04,&
     & 2.851300e-04,3.343800e-04,2.910800e-04,2.167200e-04,1.897400e-04,&
     & 3.854200e-04,4.485700e-04,3.880200e-04,2.866100e-04,2.249200e-04,&
     & 5.120800e-04,5.932900e-04,5.096700e-04,3.735600e-04,2.628400e-04,&
     & 6.688200e-04,7.736600e-04,6.605900e-04,4.804600e-04,3.035200e-04,&
     & 8.577500e-04,9.935800e-04,8.454800e-04,6.101000e-04,3.469100e-04,&
     & 2.390800e-04,2.808600e-04,2.443200e-04,1.817200e-04,1.413100e-04,&
     & 3.244700e-04,3.786600e-04,3.272900e-04,2.412300e-04,1.682800e-04,&
     & 4.324400e-04,5.030600e-04,4.317900e-04,3.157300e-04,1.975200e-04,&
     & 5.658700e-04,6.584300e-04,5.620600e-04,4.077800e-04,2.289900e-04,&
     & 7.260000e-04,8.474600e-04,7.217700e-04,5.196700e-04,2.626200e-04/
      data  absb(601:900,7) /                                           &
     & 1.922300e-04,2.263500e-04,1.968700e-04,1.463000e-04,1.079400e-04,&
     & 2.624200e-04,3.072400e-04,2.655300e-04,1.954700e-04,1.291000e-04,&
     & 3.515000e-04,4.107100e-04,3.526200e-04,2.574000e-04,1.521300e-04,&
     & 4.618500e-04,5.405100e-04,4.616700e-04,3.345000e-04,1.770000e-04,&
     & 5.941600e-04,6.986500e-04,5.957300e-04,4.285900e-04,2.036600e-04,&
     & 1.539600e-04,1.818600e-04,1.582000e-04,1.174500e-04,8.202600e-05,&
     & 2.113900e-04,2.485300e-04,2.148600e-04,1.580200e-04,9.855500e-05,&
     & 2.845400e-04,3.343300e-04,2.872100e-04,2.094300e-04,1.166100e-04,&
     & 3.753800e-04,4.423300e-04,3.783500e-04,2.738400e-04,1.362200e-04,&
     & 4.843200e-04,5.742500e-04,4.905400e-04,3.527600e-04,1.573000e-04,&
     & 1.231000e-04,1.459600e-04,1.270300e-04,9.429100e-05,6.178300e-05,&
     & 1.699400e-04,2.008500e-04,1.737500e-04,1.277200e-04,7.460700e-05,&
     & 2.298800e-04,2.719000e-04,2.338500e-04,1.703900e-04,8.868900e-05,&
     & 3.044700e-04,3.615700e-04,3.099600e-04,2.241600e-04,1.040400e-04,&
     & 3.938300e-04,4.714300e-04,4.036400e-04,2.902200e-04,1.206200e-04,&
     & 9.515500e-05,1.133200e-04,9.873400e-05,7.334400e-05,4.698500e-05,&
     & 1.323600e-04,1.572600e-04,1.362100e-04,1.002000e-04,5.705400e-05,&
     & 1.803100e-04,2.145400e-04,1.848400e-04,1.347400e-04,6.816200e-05,&
     & 2.401700e-04,2.872500e-04,2.468400e-04,1.786100e-04,8.032100e-05,&
     & 3.122300e-04,3.770000e-04,3.235800e-04,2.327900e-04,9.349900e-05,&
     & 7.304000e-05,8.736500e-05,7.621900e-05,5.669600e-05,3.562800e-05,&
     & 1.024200e-04,1.223100e-04,1.060800e-04,7.814900e-05,4.352800e-05,&
     & 1.405100e-04,1.681900e-04,1.452100e-04,1.059800e-04,5.227700e-05,&
     & 1.883800e-04,2.268800e-04,1.954200e-04,1.415600e-04,6.189400e-05,&
     & 2.462200e-04,2.997600e-04,2.579800e-04,1.858600e-04,7.235700e-05,&
     & 5.586400e-05,6.711900e-05,5.865200e-05,4.371900e-05,2.685300e-05,&
     & 7.900900e-05,9.483100e-05,8.236800e-05,6.079800e-05,3.301700e-05,&
     & 1.091900e-04,1.314300e-04,1.137100e-04,8.313300e-05,3.988100e-05,&
     & 1.473600e-04,1.786600e-04,1.542400e-04,1.119500e-04,4.744900e-05,&
     & 1.937200e-04,2.376600e-04,2.051100e-04,1.480300e-04,5.573000e-05,&
     & 4.176100e-05,5.039800e-05,4.413000e-05,3.298500e-05,2.007300e-05,&
     & 5.964500e-05,7.191600e-05,6.259900e-05,4.633000e-05,2.486400e-05,&
     & 8.319400e-05,1.006400e-04,8.723200e-05,6.394200e-05,3.023500e-05,&
     & 1.132000e-04,1.380300e-04,1.194000e-04,8.687000e-05,3.617800e-05,&
     & 1.499200e-04,1.851100e-04,1.601100e-04,1.158700e-04,4.270700e-05,&
     & 3.080100e-05,3.734900e-05,3.275300e-05,2.457700e-05,1.489100e-05,&
     & 4.448700e-05,5.387100e-05,4.699000e-05,3.488800e-05,1.859200e-05,&
     & 6.265800e-05,7.615600e-05,6.612900e-05,4.862300e-05,2.277300e-05,&
     & 8.606100e-05,1.054700e-04,9.138800e-05,6.667900e-05,2.743100e-05,&
     & 1.150100e-04,1.427400e-04,1.236900e-04,8.974700e-05,3.256500e-05,&
     & 2.260800e-05,2.754100e-05,2.418500e-05,1.823200e-05,1.095800e-05,&
     & 3.302500e-05,4.015900e-05,3.510900e-05,2.615600e-05,1.379900e-05,&
     & 4.701100e-05,5.737900e-05,4.991900e-05,3.682000e-05,1.703100e-05,&
     & 6.519800e-05,8.026500e-05,6.966900e-05,5.097500e-05,2.066000e-05,&
     & 8.791500e-05,1.096500e-04,9.515900e-05,6.923600e-05,2.467500e-05,&
     & 1.637300e-05,2.004300e-05,1.762400e-05,1.336000e-05,7.992600e-06,&
     & 2.421600e-05,2.956700e-05,2.590300e-05,1.937300e-05,1.016000e-05,&
     & 3.486800e-05,4.272200e-05,3.724100e-05,2.756400e-05,1.264300e-05,&
     & 4.888200e-05,6.041000e-05,5.252200e-05,3.853900e-05,1.545500e-05,&
     & 6.657900e-05,8.339200e-05,7.247200e-05,5.286400e-05,1.858600e-05,&
     & 1.159900e-05,1.426800e-05,1.256700e-05,9.584600e-06,5.786500e-06,&
     & 1.739400e-05,2.132100e-05,1.871900e-05,1.406300e-05,7.432000e-06,&
     & 2.537500e-05,3.118900e-05,2.724400e-05,2.024200e-05,9.334500e-06,&
     & 3.602000e-05,4.462400e-05,3.886800e-05,2.861200e-05,1.150600e-05,&
     & 4.965000e-05,6.235800e-05,5.424700e-05,3.967400e-05,1.394500e-05,&
     & 8.159200e-06,1.008800e-05,8.902900e-06,6.835200e-06,4.148600e-06,&
     & 1.241400e-05,1.528100e-05,1.344200e-05,1.014700e-05,5.386500e-06,&
     & 1.835500e-05,2.263600e-05,1.981500e-05,1.478400e-05,6.832000e-06,&
     & 2.639900e-05,3.278700e-05,2.860600e-05,2.113000e-05,8.497200e-06,&
     & 3.683400e-05,4.637400e-05,4.039800e-05,2.962300e-05,1.038300e-05/
      data  absb(901:1175,7) /                                          &
     & 5.695000e-06,7.085400e-06,6.265800e-06,4.846000e-06,2.941100e-06,&
     & 8.804000e-06,1.088000e-05,9.588400e-06,7.277600e-06,3.860700e-06,&
     & 1.319400e-05,1.632100e-05,1.432300e-05,1.073100e-05,4.947100e-06,&
     & 1.923100e-05,2.394500e-05,2.092700e-05,1.551500e-05,6.211200e-06,&
     & 2.718300e-05,3.429100e-05,2.991700e-05,2.199900e-05,7.656600e-06,&
     & 3.995800e-06,5.001500e-06,4.436600e-06,3.458500e-06,2.122700e-06,&
     & 6.278400e-06,7.790100e-06,6.875900e-06,5.249000e-06,2.812300e-06,&
     & 9.536700e-06,1.182800e-05,1.040600e-05,7.827300e-06,3.638400e-06,&
     & 1.407600e-05,1.757400e-05,1.538400e-05,1.144500e-05,4.606900e-06,&
     & 2.015800e-05,2.547000e-05,2.225100e-05,1.640600e-05,5.724500e-06,&
     & 2.798800e-06,3.526600e-06,3.140300e-06,2.472900e-06,1.542800e-06,&
     & 4.475800e-06,5.578100e-06,4.931300e-06,3.786800e-06,2.061500e-06,&
     & 6.895100e-06,8.572200e-06,7.556000e-06,5.708400e-06,2.691500e-06,&
     & 1.030400e-05,1.289400e-05,1.130800e-05,8.439300e-06,3.436300e-06,&
     & 1.494500e-05,1.892000e-05,1.654600e-05,1.223200e-05,4.303100e-06,&
     & 1.943500e-06,2.468500e-06,2.209800e-06,1.763400e-06,1.114300e-06,&
     & 3.169500e-06,3.971300e-06,3.518300e-06,2.719900e-06,1.501100e-06,&
     & 4.959200e-06,6.182800e-06,5.458100e-06,4.143400e-06,1.977500e-06,&
     & 7.508200e-06,9.411900e-06,8.272200e-06,6.194900e-06,2.546700e-06,&
     & 1.102600e-05,1.398400e-05,1.224600e-05,9.078000e-06,3.214500e-06,&
     & 1.335900e-06,1.712800e-06,1.543900e-06,1.255100e-06,7.987400e-07,&
     & 2.227400e-06,2.808600e-06,2.495100e-06,1.944600e-06,1.084300e-06,&
     & 3.544500e-06,4.434200e-06,3.920600e-06,2.991600e-06,1.440700e-06,&
     & 5.442300e-06,6.830700e-06,6.017300e-06,4.523100e-06,1.872100e-06,&
     & 8.093100e-06,1.028100e-05,9.016800e-06,6.703100e-06,2.382100e-06,&
     & 9.265200e-07,1.198800e-06,1.089200e-06,9.047200e-07,5.918500e-07,&
     & 1.579100e-06,2.004200e-06,1.786400e-06,1.405300e-06,8.090300e-07,&
     & 2.556400e-06,3.210600e-06,2.843300e-06,2.181200e-06,1.082900e-06,&
     & 3.981000e-06,5.004200e-06,4.415800e-06,3.331100e-06,1.417900e-06,&
     & 5.994000e-06,7.621300e-06,6.694100e-06,4.990800e-06,1.816200e-06,&
     & 6.427100e-07,8.398600e-07,7.696900e-07,6.562200e-07,4.468000e-07,&
     & 1.120200e-06,1.431500e-06,1.281200e-06,1.019800e-06,6.146900e-07,&
     & 1.846300e-06,2.330300e-06,2.067200e-06,1.595000e-06,8.284800e-07,&
     & 2.918700e-06,3.675200e-06,3.248400e-06,2.459300e-06,1.092300e-06,&
     & 4.449000e-06,5.662300e-06,4.979900e-06,3.723200e-06,1.407900e-06,&
     & 4.422200e-07,5.844300e-07,5.413200e-07,4.767500e-07,3.373800e-07,&
     & 7.890700e-07,1.015700e-06,9.137700e-07,7.381000e-07,4.667100e-07,&
     & 1.324800e-06,1.681900e-06,1.495600e-06,1.162200e-06,6.335400e-07,&
     & 2.129600e-06,2.688500e-06,2.379300e-06,1.809100e-06,8.412500e-07,&
     & 3.290500e-06,4.190600e-06,3.690500e-06,2.766700e-06,1.091700e-06,&
     & 3.016600e-07,4.036600e-07,3.789000e-07,3.475900e-07,2.549500e-07,&
     & 5.516100e-07,7.154200e-07,6.479200e-07,5.333400e-07,3.543300e-07,&
     & 9.447000e-07,1.206900e-06,1.076100e-06,8.439400e-07,4.844600e-07,&
     & 1.544800e-06,1.957100e-06,1.734900e-06,1.325700e-06,6.479100e-07,&
     & 2.423100e-06,3.088500e-06,2.724600e-06,2.047600e-06,8.465000e-07,&
     & 2.061500e-07,2.796600e-07,2.665900e-07,2.567200e-07,1.949000e-07,&
     & 3.863400e-07,5.050600e-07,4.608200e-07,3.879200e-07,2.719300e-07,&
     & 6.754500e-07,8.679400e-07,7.767200e-07,6.153400e-07,3.743900e-07,&
     & 1.122900e-06,1.428900e-06,1.269000e-06,9.753900e-07,5.041700e-07,&
     & 1.788800e-06,2.284100e-06,2.018200e-06,1.520900e-06,6.629900e-07,&
     & 1.586400e-07,2.161800e-07,2.073200e-07,2.035000e-07,1.656500e-07,&
     & 3.007200e-07,3.945100e-07,3.608600e-07,3.063200e-07,2.329700e-07,&
     & 5.310300e-07,6.846300e-07,6.135500e-07,4.879200e-07,3.225800e-07,&
     & 8.909600e-07,1.137700e-06,1.011300e-06,7.787400e-07,4.360800e-07,&
     & 1.431100e-06,1.834400e-06,1.621400e-06,1.222300e-06,5.745600e-07/
      data  absb(1:300,8) /                                             &
     & 1.143100e-02,1.274100e-02,1.143600e-02,9.162100e-03,8.051900e-02,&
     & 1.520600e-02,1.716000e-02,1.555500e-02,1.245400e-02,8.686400e-02,&
     & 1.997600e-02,2.272200e-02,2.065400e-02,1.650200e-02,9.444600e-02,&
     & 2.595400e-02,2.964300e-02,2.678100e-02,2.140600e-02,1.033300e-01,&
     & 3.335200e-02,3.795300e-02,3.418900e-02,2.727700e-02,1.130400e-01,&
     & 1.017900e-02,1.138900e-02,1.017600e-02,8.052200e-03,6.550400e-02,&
     & 1.364100e-02,1.535500e-02,1.381700e-02,1.090600e-02,7.223000e-02,&
     & 1.802300e-02,2.041800e-02,1.835200e-02,1.443700e-02,8.015000e-02,&
     & 2.353200e-02,2.670500e-02,2.387600e-02,1.875800e-02,8.903800e-02,&
     & 3.023900e-02,3.428200e-02,3.061400e-02,2.401700e-02,9.857700e-02,&
     & 9.009000e-03,1.012000e-02,9.016700e-03,7.076400e-03,5.259100e-02,&
     & 1.218600e-02,1.373400e-02,1.225800e-02,9.569600e-03,5.940200e-02,&
     & 1.622500e-02,1.833300e-02,1.634000e-02,1.268800e-02,6.712700e-02,&
     & 2.118500e-02,2.404200e-02,2.133200e-02,1.657800e-02,7.551200e-02,&
     & 2.714100e-02,3.092800e-02,2.748000e-02,2.133300e-02,8.452100e-02,&
     & 7.966600e-03,8.986200e-03,7.967100e-03,6.224200e-03,4.129400e-02,&
     & 1.088500e-02,1.227000e-02,1.088500e-02,8.430300e-03,4.751900e-02,&
     & 1.451100e-02,1.644200e-02,1.454400e-02,1.123400e-02,5.441500e-02,&
     & 1.892600e-02,2.155400e-02,1.907600e-02,1.475000e-02,6.180100e-02,&
     & 2.423600e-02,2.768700e-02,2.463300e-02,1.902400e-02,6.962400e-02,&
     & 7.108000e-03,8.014700e-03,7.075800e-03,5.487300e-03,3.329700e-02,&
     & 9.738800e-03,1.099100e-02,9.694000e-03,7.458700e-03,3.875400e-02,&
     & 1.297100e-02,1.471200e-02,1.298000e-02,9.980600e-03,4.467300e-02,&
     & 1.692000e-02,1.922100e-02,1.703700e-02,1.313100e-02,5.087800e-02,&
     & 2.167500e-02,2.468800e-02,2.195800e-02,1.694400e-02,5.739200e-02,&
     & 6.404800e-03,7.214900e-03,6.342300e-03,4.870500e-03,2.761000e-02,&
     & 8.757900e-03,9.892900e-03,8.696000e-03,6.639900e-03,3.224100e-02,&
     & 1.167400e-02,1.317800e-02,1.161400e-02,8.893700e-03,3.715100e-02,&
     & 1.522600e-02,1.718300e-02,1.519000e-02,1.167800e-02,4.232100e-02,&
     & 1.952100e-02,2.206500e-02,1.953600e-02,1.502200e-02,4.775900e-02,&
     & 5.778000e-03,6.509700e-03,5.707300e-03,4.336200e-03,2.351700e-02,&
     & 7.898000e-03,8.894300e-03,7.801900e-03,5.918200e-03,2.746400e-02,&
     & 1.054700e-02,1.181300e-02,1.037800e-02,7.908200e-03,3.165300e-02,&
     & 1.378000e-02,1.539500e-02,1.354400e-02,1.033400e-02,3.606800e-02,&
     & 1.766100e-02,1.976900e-02,1.738700e-02,1.326300e-02,4.067200e-02,&
     & 5.235800e-03,5.894300e-03,5.160900e-03,3.893000e-03,2.026500e-02,&
     & 7.165000e-03,8.033700e-03,7.030300e-03,5.300900e-03,2.364200e-02,&
     & 9.576800e-03,1.067300e-02,9.327000e-03,7.046700e-03,2.721000e-02,&
     & 1.252000e-02,1.391000e-02,1.214800e-02,9.177200e-03,3.095500e-02,&
     & 1.605400e-02,1.783000e-02,1.557100e-02,1.176000e-02,3.485600e-02,&
     & 4.730600e-03,5.322800e-03,4.648000e-03,3.493400e-03,1.741500e-02,&
     & 6.483700e-03,7.250500e-03,6.321400e-03,4.741000e-03,2.024800e-02,&
     & 8.667200e-03,9.647900e-03,8.392000e-03,6.277600e-03,2.324600e-02,&
     & 1.134000e-02,1.258100e-02,1.091800e-02,8.162000e-03,2.639700e-02,&
     & 1.456000e-02,1.610200e-02,1.396700e-02,1.044000e-02,2.969700e-02,&
     & 4.341800e-03,4.876500e-03,4.250500e-03,3.183100e-03,1.472500e-02,&
     & 5.944900e-03,6.638000e-03,5.774400e-03,4.303800e-03,1.707300e-02,&
     & 7.938900e-03,8.832100e-03,7.661500e-03,5.688300e-03,1.956000e-02,&
     & 1.038200e-02,1.150700e-02,9.958300e-03,7.380800e-03,2.218000e-02,&
     & 1.334800e-02,1.471800e-02,1.272400e-02,9.415800e-03,2.494200e-02,&
     & 3.975500e-03,4.460100e-03,3.879100e-03,2.894000e-03,1.231700e-02,&
     & 5.432600e-03,6.067500e-03,5.264900e-03,3.907900e-03,1.426100e-02,&
     & 7.247100e-03,8.065200e-03,6.977500e-03,5.160900e-03,1.631900e-02,&
     & 9.485300e-03,1.049900e-02,9.066900e-03,6.681700e-03,1.849400e-02,&
     & 1.222400e-02,1.343300e-02,1.157500e-02,8.501600e-03,2.080300e-02,&
     & 3.623700e-03,4.066400e-03,3.532700e-03,2.624900e-03,1.011100e-02,&
     & 4.940500e-03,5.528400e-03,4.786700e-03,3.542200e-03,1.171200e-02,&
     & 6.594100e-03,7.336700e-03,6.341200e-03,4.674000e-03,1.340700e-02,&
     & 8.650000e-03,9.558200e-03,8.238700e-03,6.041300e-03,1.520300e-02,&
     & 1.116000e-02,1.225800e-02,1.051800e-02,7.674500e-03,1.712000e-02/
      data  absb(301:600,8) /                                           &
     & 3.292300e-03,3.709700e-03,3.217400e-03,2.385200e-03,8.274300e-03,&
     & 4.486800e-03,5.033300e-03,4.354700e-03,3.214000e-03,9.586400e-03,&
     & 6.002200e-03,6.681700e-03,5.765200e-03,4.234800e-03,1.098200e-02,&
     & 7.885500e-03,8.718700e-03,7.491300e-03,5.465500e-03,1.246900e-02,&
     & 1.016900e-02,1.119600e-02,9.576800e-03,6.938500e-03,1.405700e-02,&
     & 2.996600e-03,3.393600e-03,2.943500e-03,2.177300e-03,6.822600e-03,&
     & 4.088700e-03,4.600300e-03,3.976800e-03,2.928100e-03,7.905600e-03,&
     & 5.474500e-03,6.114900e-03,5.264000e-03,3.849100e-03,9.060700e-03,&
     & 7.188600e-03,7.985600e-03,6.845600e-03,4.964300e-03,1.030000e-02,&
     & 9.259600e-03,1.024800e-02,8.748900e-03,6.301400e-03,1.162400e-02,&
     & 2.715600e-03,3.087600e-03,2.680500e-03,1.982200e-03,5.515800e-03,&
     & 3.710400e-03,4.190000e-03,3.621500e-03,2.659300e-03,6.400100e-03,&
     & 4.966700e-03,5.577100e-03,4.800400e-03,3.492800e-03,7.346600e-03,&
     & 6.512000e-03,7.281300e-03,6.239600e-03,4.503800e-03,8.362600e-03,&
     & 8.374800e-03,9.331200e-03,7.964900e-03,5.710100e-03,9.454000e-03,&
     & 2.454000e-03,2.801500e-03,2.433200e-03,1.798600e-03,4.371700e-03,&
     & 3.353300e-03,3.806500e-03,3.290700e-03,2.410400e-03,5.084400e-03,&
     & 4.481600e-03,5.064800e-03,4.361100e-03,3.164100e-03,5.849100e-03,&
     & 5.865600e-03,6.605900e-03,5.664900e-03,4.078300e-03,6.671900e-03,&
     & 7.537500e-03,8.452400e-03,7.218100e-03,5.163400e-03,7.553400e-03,&
     & 2.219900e-03,2.546800e-03,2.211600e-03,1.632000e-03,3.431300e-03,&
     & 3.028400e-03,3.457600e-03,2.990800e-03,2.186800e-03,4.000700e-03,&
     & 4.039400e-03,4.595900e-03,3.958400e-03,2.869300e-03,4.614100e-03,&
     & 5.280400e-03,5.985100e-03,5.133300e-03,3.690100e-03,5.272300e-03,&
     & 6.781500e-03,7.648200e-03,6.527300e-03,4.667000e-03,5.978400e-03,&
     & 2.004600e-03,2.313000e-03,2.009000e-03,1.479400e-03,2.654300e-03,&
     & 2.729500e-03,3.136900e-03,2.713800e-03,1.981200e-03,3.104300e-03,&
     & 3.635600e-03,4.160700e-03,3.584100e-03,2.595100e-03,3.589200e-03,&
     & 4.749100e-03,5.410300e-03,4.636300e-03,3.332300e-03,4.108800e-03,&
     & 6.103000e-03,6.906300e-03,5.895000e-03,4.207400e-03,4.667300e-03,&
     & 1.811600e-03,2.102100e-03,1.826400e-03,1.342600e-03,2.019200e-03,&
     & 2.462600e-03,2.844500e-03,2.461500e-03,1.794700e-03,2.368200e-03,&
     & 3.277000e-03,3.768000e-03,3.243500e-03,2.345400e-03,2.745400e-03,&
     & 4.282500e-03,4.893300e-03,4.190700e-03,3.005700e-03,3.151600e-03,&
     & 5.510700e-03,6.249600e-03,5.325700e-03,3.788900e-03,3.587300e-03,&
     & 1.640900e-03,1.912800e-03,1.661500e-03,1.220000e-03,1.539900e-03,&
     & 2.227600e-03,2.583400e-03,2.233500e-03,1.625700e-03,1.810800e-03,&
     & 2.964200e-03,3.416400e-03,2.936600e-03,2.119200e-03,2.104900e-03,&
     & 3.878300e-03,4.438200e-03,3.792900e-03,2.712000e-03,2.421600e-03,&
     & 5.000800e-03,5.672700e-03,4.821200e-03,3.416800e-03,2.763000e-03,&
     & 1.489600e-03,1.742500e-03,1.512100e-03,1.108500e-03,1.170800e-03,&
     & 2.021900e-03,2.349900e-03,2.027400e-03,1.471700e-03,1.379800e-03,&
     & 2.693300e-03,3.105900e-03,2.664100e-03,1.914500e-03,1.607800e-03,&
     & 3.531200e-03,4.036000e-03,3.438300e-03,2.448500e-03,1.854900e-03,&
     & 4.557600e-03,5.170200e-03,4.376900e-03,3.087300e-03,2.122100e-03,&
     & 1.346100e-03,1.577300e-03,1.365400e-03,9.984800e-04,9.182800e-04,&
     & 1.829300e-03,2.126400e-03,1.829400e-03,1.322400e-03,1.085000e-03,&
     & 2.442100e-03,2.812900e-03,2.403800e-03,1.718600e-03,1.267000e-03,&
     & 3.207700e-03,3.663100e-03,3.107600e-03,2.199700e-03,1.465400e-03,&
     & 4.152100e-03,4.702700e-03,3.961400e-03,2.777300e-03,1.680100e-03,&
     & 1.183200e-03,1.388200e-03,1.199100e-03,8.740200e-04,7.039300e-04,&
     & 1.613600e-03,1.876500e-03,1.608900e-03,1.158500e-03,8.344500e-04,&
     & 2.163100e-03,2.489900e-03,2.118600e-03,1.508900e-03,9.777000e-04,&
     & 2.853500e-03,3.254200e-03,2.748500e-03,1.936400e-03,1.134300e-03,&
     & 3.709200e-03,4.196500e-03,3.516400e-03,2.452200e-03,1.303900e-03,&
     & 1.006600e-03,1.183300e-03,1.019500e-03,7.406400e-04,5.236600e-04,&
     & 1.381500e-03,1.607100e-03,1.373900e-03,9.857300e-04,6.234400e-04,&
     & 1.862600e-03,2.144900e-03,1.819100e-03,1.289800e-03,7.336000e-04,&
     & 2.474100e-03,2.818200e-03,2.372900e-03,1.663500e-03,8.543600e-04,&
     & 3.233600e-03,3.656800e-03,3.050400e-03,2.118100e-03,9.862500e-04/
      data  absb(601:900,8) /                                           &
     & 8.208400e-04,9.670900e-04,8.322900e-04,6.037400e-04,4.042000e-04,&
     & 1.137200e-03,1.325400e-03,1.130000e-03,8.087200e-04,4.841700e-04,&
     & 1.546800e-03,1.782600e-03,1.508300e-03,1.064300e-03,5.728300e-04,&
     & 2.072400e-03,2.360300e-03,1.980700e-03,1.382900e-03,6.703100e-04,&
     & 2.730100e-03,3.085200e-03,2.565600e-03,1.772500e-03,7.769300e-04,&
     & 6.676500e-04,7.885600e-04,6.779600e-04,4.908700e-04,3.103400e-04,&
     & 9.339900e-04,1.090800e-03,9.283100e-04,6.621000e-04,3.742000e-04,&
     & 1.282900e-03,1.480100e-03,1.248000e-03,8.778800e-04,4.452900e-04,&
     & 1.733400e-03,1.976500e-03,1.652100e-03,1.148400e-03,5.238900e-04,&
     & 2.304200e-03,2.602800e-03,2.156500e-03,1.482300e-03,6.100800e-04,&
     & 5.431500e-04,6.431000e-04,5.521100e-04,3.989000e-04,2.358300e-04,&
     & 7.674300e-04,8.979700e-04,7.631400e-04,5.426900e-04,2.863200e-04,&
     & 1.064900e-03,1.229900e-03,1.034200e-03,7.246200e-04,3.429300e-04,&
     & 1.451900e-03,1.657500e-03,1.379100e-03,9.549600e-04,4.057500e-04,&
     & 1.946200e-03,2.198700e-03,1.814900e-03,1.241100e-03,4.748700e-04,&
     & 4.266000e-04,5.072200e-04,4.353700e-04,3.143800e-04,1.812800e-04,&
     & 6.103900e-04,7.164700e-04,6.081700e-04,4.318900e-04,2.218700e-04,&
     & 8.570300e-04,9.924000e-04,8.337400e-04,5.827600e-04,2.676000e-04,&
     & 1.182300e-03,1.351000e-03,1.122500e-03,7.745900e-04,3.185700e-04,&
     & 1.601800e-03,1.812300e-03,1.491600e-03,1.015800e-03,3.747900e-04,&
     & 3.327100e-04,3.973600e-04,3.410800e-04,2.462400e-04,1.388500e-04,&
     & 4.822500e-04,5.684600e-04,4.823700e-04,3.421600e-04,1.713700e-04,&
     & 6.857600e-04,7.968800e-04,6.683700e-04,4.662200e-04,2.082100e-04,&
     & 9.573200e-04,1.097600e-03,9.099600e-04,6.257100e-04,2.495500e-04,&
     & 1.312000e-03,1.487000e-03,1.221400e-03,8.282900e-04,2.951600e-04,&
     & 2.586700e-04,3.104200e-04,2.664500e-04,1.924400e-04,1.055400e-04,&
     & 3.800500e-04,4.498100e-04,3.816000e-04,2.703300e-04,1.313800e-04,&
     & 5.475000e-04,6.385200e-04,5.351100e-04,3.726200e-04,1.608900e-04,&
     & 7.737000e-04,8.898900e-04,7.367500e-04,5.053000e-04,1.941400e-04,&
     & 1.073200e-03,1.219200e-03,9.994400e-04,6.754200e-04,2.310000e-04,&
     & 1.960800e-04,2.365400e-04,2.033000e-04,1.469200e-04,7.964000e-05,&
     & 2.924400e-04,3.478600e-04,2.953600e-04,2.092900e-04,1.001300e-04,&
     & 4.274600e-04,5.010900e-04,4.196800e-04,2.922700e-04,1.237000e-04,&
     & 6.125800e-04,7.073700e-04,5.853100e-04,4.007700e-04,1.504700e-04,&
     & 8.608900e-04,9.813200e-04,8.032500e-04,5.416500e-04,1.803000e-04,&
     & 1.464100e-04,1.775900e-04,1.528900e-04,1.107600e-04,5.962700e-05,&
     & 2.218400e-04,2.653400e-04,2.256000e-04,1.600500e-04,7.577700e-05,&
     & 3.292400e-04,3.878000e-04,3.252400e-04,2.265700e-04,9.451700e-05,&
     & 4.789300e-04,5.557100e-04,4.599300e-04,3.146500e-04,1.159900e-04,&
     & 6.824300e-04,7.813000e-04,6.391600e-04,4.304000e-04,1.400600e-04,&
     & 1.086500e-04,1.325100e-04,1.143500e-04,8.296000e-05,4.421200e-05,&
     & 1.672900e-04,2.012800e-04,1.713400e-04,1.218300e-04,5.683000e-05,&
     & 2.522900e-04,2.990800e-04,2.508300e-04,1.748600e-04,7.160400e-05,&
     & 3.726200e-04,4.345200e-04,3.598600e-04,2.461900e-04,8.863200e-05,&
     & 5.388200e-04,6.200400e-04,5.071700e-04,3.409000e-04,1.079300e-04,&
     & 7.935800e-05,9.732700e-05,8.420900e-05,6.125000e-05,3.245900e-05,&
     & 1.242900e-04,1.504500e-04,1.283000e-04,9.146600e-05,4.224100e-05,&
     & 1.905300e-04,2.273600e-04,1.910000e-04,1.332500e-04,5.378300e-05,&
     & 2.861400e-04,3.357000e-04,2.782800e-04,1.905000e-04,6.721800e-05,&
     & 4.203900e-04,4.863500e-04,3.977400e-04,2.672400e-04,8.258200e-05,&
     & 5.645300e-05,6.962800e-05,6.041000e-05,4.415000e-05,2.363400e-05,&
     & 9.003900e-05,1.097100e-04,9.380900e-05,6.708200e-05,3.117400e-05,&
     & 1.405300e-04,1.688200e-04,1.420700e-04,9.946200e-05,4.017700e-05,&
     & 2.147700e-04,2.537400e-04,2.106800e-04,1.445100e-04,5.074200e-05,&
     & 3.208800e-04,3.735700e-04,3.061500e-04,2.058500e-04,6.290100e-05,&
     & 3.979800e-05,4.934000e-05,4.293600e-05,3.153300e-05,1.700300e-05,&
     & 6.465900e-05,7.927500e-05,6.797400e-05,4.884400e-05,2.275400e-05,&
     & 1.027700e-04,1.243300e-04,1.049300e-04,7.371500e-05,2.970600e-05,&
     & 1.599200e-04,1.903400e-04,1.583800e-04,1.088600e-04,3.793600e-05,&
     & 2.432500e-04,2.851300e-04,2.340800e-04,1.575500e-04,4.749200e-05/
      data  absb(901:1175,8) /                                          &
     & 2.780200e-05,3.461600e-05,3.021800e-05,2.230800e-05,1.206100e-05,&
     & 4.601400e-05,5.676100e-05,4.882000e-05,3.523900e-05,1.638600e-05,&
     & 7.449100e-05,9.074100e-05,7.679500e-05,5.414300e-05,2.168700e-05,&
     & 1.180200e-04,1.415300e-04,1.180600e-04,8.135600e-05,2.802200e-05,&
     & 1.827900e-04,2.158300e-04,1.775400e-04,1.197000e-04,3.545600e-05,&
     & 1.954000e-05,2.440000e-05,2.136100e-05,1.583700e-05,8.699700e-06,&
     & 3.291800e-05,4.082200e-05,3.520500e-05,2.551200e-05,1.199000e-05,&
     & 5.425500e-05,6.652600e-05,5.643800e-05,3.995000e-05,1.607300e-05,&
     & 8.752600e-05,1.057100e-04,8.838300e-05,6.106600e-05,2.100600e-05,&
     & 1.379900e-04,1.641500e-04,1.352400e-04,9.133400e-05,2.684700e-05,&
     & 1.371500e-05,1.717000e-05,1.506100e-05,1.122000e-05,6.306600e-06,&
     & 2.352500e-05,2.929000e-05,2.532900e-05,1.843200e-05,8.817600e-06,&
     & 3.946000e-05,4.867200e-05,4.137700e-05,2.939700e-05,1.197100e-05,&
     & 6.479400e-05,7.883700e-05,6.604000e-05,4.575900e-05,1.583000e-05,&
     & 1.040200e-04,1.247000e-04,1.029000e-04,6.964000e-05,2.043300e-05,&
     & 9.557800e-06,1.198600e-05,1.052900e-05,7.883100e-06,4.527800e-06,&
     & 1.667900e-05,2.085600e-05,1.807600e-05,1.321100e-05,6.424400e-06,&
     & 2.847700e-05,3.532000e-05,3.010300e-05,2.146800e-05,8.839100e-06,&
     & 4.759400e-05,5.835700e-05,4.898700e-05,3.402600e-05,1.183300e-05,&
     & 7.779800e-05,9.398200e-05,7.769200e-05,5.272300e-05,1.543700e-05,&
     & 6.607200e-06,8.293000e-06,7.296100e-06,5.489300e-06,3.214500e-06,&
     & 1.172600e-05,1.471600e-05,1.278100e-05,9.382200e-06,4.628400e-06,&
     & 2.038000e-05,2.540700e-05,2.171500e-05,1.554300e-05,6.458200e-06,&
     & 3.465800e-05,4.278100e-05,3.598800e-05,2.511100e-05,8.758600e-06,&
     & 5.769400e-05,7.024000e-05,5.820400e-05,3.960600e-05,1.155800e-05,&
     & 4.623100e-06,5.809400e-06,5.115900e-06,3.868100e-06,2.361700e-06,&
     & 8.348700e-06,1.050700e-05,9.140900e-06,6.732400e-06,3.445700e-06,&
     & 1.474900e-05,1.847300e-05,1.581800e-05,1.136600e-05,4.867800e-06,&
     & 2.552400e-05,3.169300e-05,2.671200e-05,1.869800e-05,6.675400e-06,&
     & 4.324400e-05,5.305800e-05,4.405000e-05,3.004200e-05,8.895700e-06,&
     & 3.243500e-06,4.080900e-06,3.596800e-06,2.733300e-06,1.766600e-06,&
     & 5.964400e-06,7.517200e-06,6.550600e-06,4.840900e-06,2.611600e-06,&
     & 1.070400e-05,1.346200e-05,1.154700e-05,8.323800e-06,3.732800e-06,&
     & 1.884600e-05,2.352200e-05,1.985400e-05,1.394300e-05,5.172000e-06,&
     & 3.247700e-05,4.011300e-05,3.337000e-05,2.281100e-05,6.956900e-06,&
     & 2.257400e-06,2.846000e-06,2.512500e-06,1.922700e-06,1.317900e-06,&
     & 4.236900e-06,5.347400e-06,4.664800e-06,3.458700e-06,1.975600e-06,&
     & 7.725800e-06,9.749600e-06,8.376600e-06,6.054900e-06,2.857100e-06,&
     & 1.382900e-05,1.734700e-05,1.466800e-05,1.033200e-05,4.001400e-06,&
     & 2.424200e-05,3.014000e-05,2.511900e-05,1.721900e-05,5.434900e-06,&
     & 1.556200e-06,1.966500e-06,1.741300e-06,1.345800e-06,9.809301e-07,&
     & 2.989100e-06,3.779500e-06,3.299500e-06,2.457200e-06,1.491300e-06,&
     & 5.541500e-06,7.011700e-06,6.035600e-06,4.374100e-06,2.182700e-06,&
     & 1.008300e-05,1.270200e-05,1.076300e-05,7.604700e-06,3.091600e-06,&
     & 1.798700e-05,2.249700e-05,1.878300e-05,1.291200e-05,4.241300e-06,&
     & 1.075000e-06,1.360700e-06,1.209700e-06,9.478800e-07,7.383800e-07,&
     & 2.115000e-06,2.681100e-06,2.342700e-06,1.752900e-06,1.136900e-06,&
     & 3.992700e-06,5.063600e-06,4.365200e-06,3.173100e-06,1.685300e-06,&
     & 7.382000e-06,9.332000e-06,7.921500e-06,5.610400e-06,2.412600e-06,&
     & 1.339000e-05,1.684300e-05,1.408100e-05,9.705100e-06,3.341500e-06,&
     & 8.414500e-07,1.067900e-06,9.497900e-07,7.470900e-07,6.349900e-07,&
     & 1.682800e-06,2.140600e-06,1.868100e-06,1.396700e-06,9.849900e-07,&
     & 3.223900e-06,4.095400e-06,3.526400e-06,2.558000e-06,1.469300e-06,&
     & 6.039200e-06,7.656900e-06,6.491100e-06,4.582100e-06,2.112100e-06,&
     & 1.109700e-05,1.400900e-05,1.169100e-05,8.042000e-06,2.931400e-06/
      data  absb(1:300,9) /                                             &
     & 6.274900e-02,7.285500e-02,6.747800e-02,5.334500e-02,4.469900e-01,&
     & 8.631900e-02,1.013500e-01,9.423000e-02,7.464000e-02,4.810200e-01,&
     & 1.153100e-01,1.358300e-01,1.267100e-01,1.004200e-01,5.162100e-01,&
     & 1.498100e-01,1.765000e-01,1.648000e-01,1.307800e-01,5.524300e-01,&
     & 1.897000e-01,2.234700e-01,2.086500e-01,1.658700e-01,5.893700e-01,&
     & 5.718700e-02,6.730100e-02,6.212900e-02,4.911000e-02,3.776900e-01,&
     & 7.846600e-02,9.327000e-02,8.644500e-02,6.845900e-02,4.075300e-01,&
     & 1.046700e-01,1.247600e-01,1.157400e-01,9.181900e-02,4.386800e-01,&
     & 1.358100e-01,1.619200e-01,1.503400e-01,1.193000e-01,4.706400e-01,&
     & 1.722400e-01,2.046400e-01,1.902100e-01,1.511000e-01,5.040800e-01,&
     & 5.172100e-02,6.156600e-02,5.668000e-02,4.475100e-02,2.956800e-01,&
     & 7.093600e-02,8.511500e-02,7.849200e-02,6.218200e-02,3.221300e-01,&
     & 9.451500e-02,1.137000e-01,1.048600e-01,8.318200e-02,3.498600e-01,&
     & 1.228900e-01,1.472800e-01,1.360700e-01,1.079000e-01,3.785300e-01,&
     & 1.563700e-01,1.862700e-01,1.719500e-01,1.362600e-01,4.089400e-01,&
     & 4.657800e-02,5.591100e-02,5.127400e-02,4.041600e-02,2.267300e-01,&
     & 6.386600e-02,7.715800e-02,7.081000e-02,5.594400e-02,2.507100e-01,&
     & 8.529400e-02,1.028500e-01,9.446300e-02,7.473100e-02,2.755900e-01,&
     & 1.112600e-01,1.333100e-01,1.223700e-01,9.672500e-02,3.020700e-01,&
     & 1.420700e-01,1.688900e-01,1.546700e-01,1.218200e-01,3.301500e-01,&
     & 4.190000e-02,5.046400e-02,4.605300e-02,3.617900e-02,1.822600e-01,&
     & 5.752200e-02,6.944400e-02,6.347200e-02,4.997300e-02,2.044700e-01,&
     & 7.702600e-02,9.253800e-02,8.455100e-02,6.660500e-02,2.281000e-01,&
     & 1.007900e-01,1.201700e-01,1.095500e-01,8.598500e-02,2.534200e-01,&
     & 1.292700e-01,1.525800e-01,1.384600e-01,1.081600e-01,2.794600e-01,&
     & 3.789100e-02,4.545400e-02,4.119700e-02,3.226000e-02,1.540300e-01,&
     & 5.205700e-02,6.235800e-02,5.664400e-02,4.444900e-02,1.750200e-01,&
     & 6.981500e-02,8.316000e-02,7.548800e-02,5.905100e-02,1.974800e-01,&
     & 9.166800e-02,1.081900e-01,9.782400e-02,7.613000e-02,2.210500e-01,&
     & 1.179900e-01,1.377000e-01,1.237100e-01,9.578000e-02,2.452500e-01,&
     & 3.444100e-02,4.085400e-02,3.678500e-02,2.864800e-02,1.359200e-01,&
     & 4.731000e-02,5.601400e-02,5.050500e-02,3.933300e-02,1.559900e-01,&
     & 6.355900e-02,7.476300e-02,6.729100e-02,5.214900e-02,1.773800e-01,&
     & 8.369900e-02,9.746600e-02,8.722500e-02,6.725000e-02,1.996000e-01,&
     & 1.080900e-01,1.243600e-01,1.105100e-01,8.470400e-02,2.224000e-01,&
     & 3.166200e-02,3.701100e-02,3.306400e-02,2.553500e-02,1.216600e-01,&
     & 4.346200e-02,5.068300e-02,4.531200e-02,3.491800e-02,1.405000e-01,&
     & 5.846800e-02,6.769300e-02,6.029100e-02,4.625100e-02,1.604100e-01,&
     & 7.708200e-02,8.836800e-02,7.821800e-02,5.963200e-02,1.809200e-01,&
     & 9.959000e-02,1.129600e-01,9.928200e-02,7.523600e-02,2.018000e-01,&
     & 2.919700e-02,3.364400e-02,2.980000e-02,2.275100e-02,1.084000e-01,&
     & 4.006100e-02,4.602200e-02,4.072000e-02,3.102500e-02,1.257500e-01,&
     & 5.387900e-02,6.151300e-02,5.414500e-02,4.107100e-02,1.437700e-01,&
     & 7.103500e-02,8.036800e-02,7.034400e-02,5.299300e-02,1.622800e-01,&
     & 9.171700e-02,1.027500e-01,8.949500e-02,6.697800e-02,1.810900e-01,&
     & 2.749900e-02,3.125100e-02,2.744900e-02,2.071700e-02,9.512300e-02,&
     & 3.765700e-02,4.271500e-02,3.738100e-02,2.814500e-02,1.104300e-01,&
     & 5.056200e-02,5.697700e-02,4.966400e-02,3.718400e-02,1.261500e-01,&
     & 6.639700e-02,7.432100e-02,6.448600e-02,4.798600e-02,1.421000e-01,&
     & 8.526600e-02,9.495800e-02,8.204500e-02,6.071200e-02,1.582700e-01,&
     & 2.595100e-02,2.912500e-02,2.533000e-02,1.893400e-02,8.235300e-02,&
     & 3.545500e-02,3.969400e-02,3.444100e-02,2.564100e-02,9.531700e-02,&
     & 4.733100e-02,5.283800e-02,4.568800e-02,3.383600e-02,1.085700e-01,&
     & 6.176300e-02,6.875800e-02,5.928400e-02,4.365200e-02,1.220900e-01,&
     & 7.893300e-02,8.753700e-02,7.536400e-02,5.517300e-02,1.359000e-01,&
     & 2.447300e-02,2.716900e-02,2.344400e-02,1.736300e-02,6.943000e-02,&
     & 3.325000e-02,3.693600e-02,3.181000e-02,2.346200e-02,8.015700e-02,&
     & 4.411700e-02,4.897500e-02,4.212300e-02,3.092100e-02,9.122300e-02,&
     & 5.728500e-02,6.343900e-02,5.452400e-02,3.985400e-02,1.026600e-01,&
     & 7.299800e-02,8.052400e-02,6.910900e-02,5.033200e-02,1.144100e-01/
      data  absb(301:600,9) /                                           &
     & 2.308800e-02,2.543800e-02,2.180100e-02,1.600200e-02,5.783700e-02,&
     & 3.117400e-02,3.439600e-02,2.949300e-02,2.156900e-02,6.678400e-02,&
     & 4.114700e-02,4.536000e-02,3.889100e-02,2.837500e-02,7.610100e-02,&
     & 5.324400e-02,5.852100e-02,5.011800e-02,3.647300e-02,8.575800e-02,&
     & 6.765900e-02,7.412100e-02,6.331700e-02,4.595300e-02,9.569300e-02,&
     & 2.185300e-02,2.392800e-02,2.042600e-02,1.485300e-02,4.839200e-02,&
     & 2.936000e-02,3.213800e-02,2.744900e-02,1.995800e-02,5.591600e-02,&
     & 3.859000e-02,4.217000e-02,3.599300e-02,2.613800e-02,6.379200e-02,&
     & 4.977500e-02,5.424200e-02,4.620600e-02,3.346300e-02,7.197500e-02,&
     & 6.307900e-02,6.854900e-02,5.824500e-02,4.204400e-02,8.044800e-02,&
     & 2.058900e-02,2.243200e-02,1.909100e-02,1.379800e-02,3.971100e-02,&
     & 2.757700e-02,2.999200e-02,2.549900e-02,1.844100e-02,4.594600e-02,&
     & 3.616300e-02,3.922200e-02,3.329200e-02,2.402700e-02,5.251400e-02,&
     & 4.652500e-02,5.033100e-02,4.263000e-02,3.066900e-02,5.935400e-02,&
     & 5.882200e-02,6.350200e-02,5.365000e-02,3.850500e-02,6.646800e-02,&
     & 1.932000e-02,2.097500e-02,1.779500e-02,1.279100e-02,3.191200e-02,&
     & 2.585500e-02,2.795900e-02,2.367800e-02,1.700000e-02,3.701100e-02,&
     & 3.386400e-02,3.650000e-02,3.083900e-02,2.208200e-02,4.238200e-02,&
     & 4.347800e-02,4.676400e-02,3.941000e-02,2.814300e-02,4.800900e-02,&
     & 5.487400e-02,5.890700e-02,4.953700e-02,3.532000e-02,5.394700e-02,&
     & 1.812300e-02,1.962800e-02,1.659700e-02,1.186100e-02,2.542300e-02,&
     & 2.422500e-02,2.612100e-02,2.203200e-02,1.569900e-02,2.954200e-02,&
     & 3.170000e-02,3.403100e-02,2.863900e-02,2.034500e-02,3.391100e-02,&
     & 4.066300e-02,4.352900e-02,3.654400e-02,2.591700e-02,3.854500e-02,&
     & 5.126800e-02,5.476900e-02,4.589500e-02,3.252200e-02,4.348800e-02,&
     & 1.695800e-02,1.836400e-02,1.547900e-02,1.099800e-02,1.995100e-02,&
     & 2.267100e-02,2.440900e-02,2.051800e-02,1.452100e-02,2.324100e-02,&
     & 2.964100e-02,3.177200e-02,2.662800e-02,1.879500e-02,2.676600e-02,&
     & 3.801200e-02,4.058100e-02,3.394300e-02,2.393500e-02,3.056100e-02,&
     & 4.790800e-02,5.103100e-02,4.262700e-02,3.003300e-02,3.465300e-02,&
     & 1.587500e-02,1.718100e-02,1.445900e-02,1.021100e-02,1.540000e-02,&
     & 2.120100e-02,2.282600e-02,1.913900e-02,1.346300e-02,1.800900e-02,&
     & 2.770300e-02,2.969400e-02,2.481600e-02,1.742100e-02,2.083700e-02,&
     & 3.553800e-02,3.792600e-02,3.162300e-02,2.217900e-02,2.391400e-02,&
     & 4.482400e-02,4.769200e-02,3.973800e-02,2.784400e-02,2.727700e-02,&
     & 1.488100e-02,1.611600e-02,1.353200e-02,9.512700e-03,1.192500e-02,&
     & 1.986500e-02,2.139500e-02,1.790500e-02,1.252900e-02,1.400400e-02,&
     & 2.595900e-02,2.782300e-02,2.320800e-02,1.620600e-02,1.628500e-02,&
     & 3.331300e-02,3.556400e-02,2.960000e-02,2.063900e-02,1.880700e-02,&
     & 4.206000e-02,4.478200e-02,3.722300e-02,2.592600e-02,2.157800e-02,&
     & 1.396700e-02,1.514400e-02,1.269000e-02,8.884400e-03,9.207400e-03,&
     & 1.864000e-02,2.009700e-02,1.678500e-02,1.170500e-02,1.087300e-02,&
     & 2.438700e-02,2.615300e-02,2.177800e-02,1.513600e-02,1.272600e-02,&
     & 3.132700e-02,3.347100e-02,2.781400e-02,1.929200e-02,1.478700e-02,&
     & 3.957200e-02,4.222100e-02,3.504400e-02,2.426400e-02,1.708000e-02,&
     & 1.303800e-02,1.415400e-02,1.183200e-02,8.249200e-03,7.364700e-03,&
     & 1.742000e-02,1.879800e-02,1.565900e-02,1.087600e-02,8.741200e-03,&
     & 2.282500e-02,2.450000e-02,2.036000e-02,1.408900e-02,1.028900e-02,&
     & 2.936000e-02,3.141800e-02,2.606500e-02,1.797800e-02,1.202700e-02,&
     & 3.713700e-02,3.971300e-02,3.291900e-02,2.266100e-02,1.397600e-02,&
     & 1.185100e-02,1.289000e-02,1.076100e-02,7.471800e-03,5.755000e-03,&
     & 1.590000e-02,1.718200e-02,1.428600e-02,9.883400e-03,6.879100e-03,&
     & 2.089700e-02,2.248600e-02,1.864800e-02,1.284800e-02,8.152200e-03,&
     & 2.696500e-02,2.894000e-02,2.397100e-02,1.645700e-02,9.592200e-03,&
     & 3.423800e-02,3.672200e-02,3.038500e-02,2.081900e-02,1.121600e-02,&
     & 1.045500e-02,1.139700e-02,9.503300e-03,6.575500e-03,4.357100e-03,&
     & 1.411700e-02,1.529000e-02,1.269900e-02,8.748400e-03,5.250800e-03,&
     & 1.865800e-02,2.013800e-02,1.667300e-02,1.143900e-02,6.273400e-03,&
     & 2.420400e-02,2.607100e-02,2.155100e-02,1.473800e-02,7.433600e-03,&
     & 3.089800e-02,3.326300e-02,2.747100e-02,1.874500e-02,8.750800e-03/
      data  absb(601:900,9) /                                           &
     & 8.849800e-03,9.665700e-03,8.048200e-03,5.550700e-03,3.439400e-03,&
     & 1.205300e-02,1.308800e-02,1.085000e-02,7.446300e-03,4.175600e-03,&
     & 1.605300e-02,1.738000e-02,1.437300e-02,9.819700e-03,5.025500e-03,&
     & 2.099200e-02,2.269700e-02,1.872300e-02,1.275400e-02,5.997700e-03,&
     & 2.699900e-02,2.918200e-02,2.404800e-02,1.634100e-02,7.108100e-03,&
     & 7.468000e-03,8.179300e-03,6.800100e-03,4.674100e-03,2.703600e-03,&
     & 1.026800e-02,1.118400e-02,9.254600e-03,6.328800e-03,3.309400e-03,&
     & 1.379900e-02,1.498700e-02,1.237000e-02,8.420400e-03,4.013600e-03,&
     & 1.818900e-02,1.974100e-02,1.626000e-02,1.103100e-02,4.826700e-03,&
     & 2.357900e-02,2.560500e-02,2.105200e-02,1.424400e-02,5.762600e-03,&
     & 6.294200e-03,6.924900e-03,5.746000e-03,3.936000e-03,2.104400e-03,&
     & 8.743200e-03,9.566300e-03,7.900000e-03,5.382300e-03,2.599400e-03,&
     & 1.186400e-02,1.293700e-02,1.066000e-02,7.230400e-03,3.179200e-03,&
     & 1.578100e-02,1.719700e-02,1.414500e-02,9.555400e-03,3.855600e-03,&
     & 2.062400e-02,2.251200e-02,1.847000e-02,1.244300e-02,4.638100e-03,&
     & 5.137500e-03,5.680300e-03,4.706900e-03,3.211500e-03,1.657800e-03,&
     & 7.229100e-03,7.945900e-03,6.549500e-03,4.444100e-03,2.066600e-03,&
     & 9.929600e-03,1.087100e-02,8.938400e-03,6.039200e-03,2.549800e-03,&
     & 1.335400e-02,1.460300e-02,1.198900e-02,8.066400e-03,3.117200e-03,&
     & 1.763000e-02,1.932000e-02,1.581900e-02,1.061000e-02,3.778300e-03,&
     & 4.166900e-03,4.630700e-03,3.831100e-03,2.605500e-03,1.302200e-03,&
     & 5.945000e-03,6.565400e-03,5.403100e-03,3.649700e-03,1.638700e-03,&
     & 8.270200e-03,9.093900e-03,7.462700e-03,5.020400e-03,2.040600e-03,&
     & 1.125400e-02,1.235800e-02,1.012400e-02,6.783600e-03,2.516000e-03,&
     & 1.502100e-02,1.652600e-02,1.350500e-02,9.017000e-03,3.074500e-03,&
     & 3.367300e-03,3.761800e-03,3.108400e-03,2.109300e-03,1.015900e-03,&
     & 4.875800e-03,5.411600e-03,4.446900e-03,2.993000e-03,1.291000e-03,&
     & 6.876500e-03,7.595700e-03,6.224000e-03,4.167500e-03,1.623100e-03,&
     & 9.470300e-03,1.044900e-02,8.542600e-03,5.698800e-03,2.019500e-03,&
     & 1.278900e-02,1.413300e-02,1.152700e-02,7.661000e-03,2.489100e-03,&
     & 2.654500e-03,2.981700e-03,2.461100e-03,1.667200e-03,7.891400e-04,&
     & 3.907200e-03,4.360100e-03,3.578500e-03,2.402600e-03,1.013000e-03,&
     & 5.597000e-03,6.214600e-03,5.083300e-03,3.391400e-03,1.287100e-03,&
     & 7.817000e-03,8.668000e-03,7.072800e-03,4.698400e-03,1.617500e-03,&
     & 1.069500e-02,1.187600e-02,9.667000e-03,6.396400e-03,2.013600e-03,&
     & 2.059900e-03,2.326400e-03,1.918900e-03,1.298200e-03,6.104300e-04,&
     & 3.086500e-03,3.463200e-03,2.839800e-03,1.902900e-03,7.916000e-04,&
     & 4.494500e-03,5.020000e-03,4.100900e-03,2.728200e-03,1.016600e-03,&
     & 6.377100e-03,7.109200e-03,5.791800e-03,3.832400e-03,1.291600e-03,&
     & 8.850700e-03,9.881600e-03,8.027100e-03,5.288500e-03,1.625400e-03,&
     & 1.588300e-03,1.802900e-03,1.486200e-03,1.004100e-03,4.691500e-04,&
     & 2.423700e-03,2.734800e-03,2.240200e-03,1.498300e-03,6.146300e-04,&
     & 3.591500e-03,4.035300e-03,3.292000e-03,2.184700e-03,7.981300e-04,&
     & 5.178700e-03,5.807400e-03,4.724200e-03,3.115800e-03,1.025500e-03,&
     & 7.297700e-03,8.194900e-03,6.645500e-03,4.359700e-03,1.305200e-03,&
     & 1.205000e-03,1.375200e-03,1.132700e-03,7.641500e-04,3.582500e-04,&
     & 1.874500e-03,2.127100e-03,1.740600e-03,1.162300e-03,4.745500e-04,&
     & 2.829200e-03,3.199000e-03,2.605800e-03,1.726100e-03,6.228000e-04,&
     & 4.152300e-03,4.686700e-03,3.806800e-03,2.504300e-03,8.099700e-04,&
     & 5.948400e-03,6.721100e-03,5.441200e-03,3.556600e-03,1.042500e-03,&
     & 8.905900e-04,1.022100e-03,8.407600e-04,5.665200e-04,2.727000e-04,&
     & 1.415400e-03,1.614200e-03,1.319100e-03,8.800300e-04,3.657800e-04,&
     & 2.179000e-03,2.478500e-03,2.016200e-03,1.333100e-03,4.848700e-04,&
     & 3.260300e-03,3.703500e-03,3.003300e-03,1.971100e-03,6.379000e-04,&
     & 4.754300e-03,5.406500e-03,4.369800e-03,2.847800e-03,8.307900e-04,&
     & 6.513700e-04,7.516000e-04,6.176800e-04,4.155900e-04,2.060500e-04,&
     & 1.058400e-03,1.212800e-03,9.899600e-04,6.600900e-04,2.801400e-04,&
     & 1.663100e-03,1.902600e-03,1.546100e-03,1.020500e-03,3.758100e-04,&
     & 2.538400e-03,2.902500e-03,2.350400e-03,1.539400e-03,4.996700e-04,&
     & 3.771600e-03,4.319100e-03,3.485300e-03,2.265900e-03,6.582600e-04/
      data  absb(901:1175,9) /                                          &
     & 4.707400e-04,5.461400e-04,4.484200e-04,3.014900e-04,1.538700e-04,&
     & 7.831200e-04,9.014700e-04,7.352200e-04,4.897100e-04,2.129300e-04,&
     & 1.256600e-03,1.445700e-03,1.173800e-03,7.734100e-04,2.894900e-04,&
     & 1.957700e-03,2.253200e-03,1.822800e-03,1.191700e-03,3.892900e-04,&
     & 2.966500e-03,3.422900e-03,2.758600e-03,1.790200e-03,5.184600e-04,&
     & 3.421300e-04,3.993500e-04,3.274600e-04,2.198800e-04,1.167400e-04,&
     & 5.834300e-04,6.743700e-04,5.493600e-04,3.651100e-04,1.648000e-04,&
     & 9.565000e-04,1.104600e-03,8.953900e-04,5.887300e-04,2.273300e-04,&
     & 1.519600e-03,1.758200e-03,1.420700e-03,9.262200e-04,3.091600e-04,&
     & 2.347200e-03,2.726100e-03,2.193300e-03,1.420300e-03,4.159200e-04,&
     & 2.477500e-04,2.912100e-04,2.387000e-04,1.599600e-04,8.887700e-05,&
     & 4.343300e-04,5.039500e-04,4.099600e-04,2.718300e-04,1.282700e-04,&
     & 7.280900e-04,8.431400e-04,6.822200e-04,4.475700e-04,1.801700e-04,&
     & 1.179700e-03,1.370800e-03,1.105700e-03,7.187100e-04,2.478500e-04,&
     & 1.856900e-03,2.169300e-03,1.742000e-03,1.125000e-03,3.367900e-04,&
     & 1.772200e-04,2.097700e-04,1.718800e-04,1.151700e-04,6.693400e-05,&
     & 3.198800e-04,3.732900e-04,3.031400e-04,2.006100e-04,9.902100e-05,&
     & 5.497700e-04,6.385300e-04,5.153900e-04,3.376200e-04,1.420800e-04,&
     & 9.090800e-04,1.060200e-03,8.537000e-04,5.534200e-04,1.983400e-04,&
     & 1.458400e-03,1.713000e-03,1.374000e-03,8.846900e-04,2.725700e-04,&
     & 1.248600e-04,1.487600e-04,1.219200e-04,8.175600e-05,4.981000e-05,&
     & 2.323600e-04,2.732600e-04,2.217500e-04,1.464700e-04,7.554900e-05,&
     & 4.109200e-04,4.787800e-04,3.856600e-04,2.521900e-04,1.110800e-04,&
     & 6.944900e-04,8.123300e-04,6.528800e-04,4.223500e-04,1.581800e-04,&
     & 1.136200e-03,1.341500e-03,1.074600e-03,6.901600e-04,2.199300e-04,&
     & 8.922500e-05,1.069800e-04,8.765100e-05,5.881300e-05,3.803000e-05,&
     & 1.713700e-04,2.029300e-04,1.645600e-04,1.085000e-04,5.900100e-05,&
     & 3.118900e-04,3.646000e-04,2.930300e-04,1.910100e-04,8.883300e-05,&
     & 5.393200e-04,6.318000e-04,5.059700e-04,3.263100e-04,1.291300e-04,&
     & 8.991100e-04,1.063700e-03,8.501700e-04,5.440300e-04,1.820400e-04,&
     & 6.390900e-05,7.705800e-05,6.310300e-05,4.236500e-05,2.940800e-05,&
     & 1.269400e-04,1.511800e-04,1.224700e-04,8.064000e-05,4.654600e-05,&
     & 2.377900e-04,2.792200e-04,2.239200e-04,1.453300e-04,7.175500e-05,&
     & 4.215200e-04,4.941700e-04,3.942000e-04,2.531700e-04,1.066400e-04,&
     & 7.163300e-04,8.475400e-04,6.752200e-04,4.302500e-04,1.528700e-04,&
     & 4.523800e-05,5.487300e-05,4.491900e-05,3.017900e-05,2.262000e-05,&
     & 9.304600e-05,1.115200e-04,9.025100e-05,5.937500e-05,3.652300e-05,&
     & 1.797300e-04,2.122400e-04,1.699300e-04,1.099800e-04,5.767800e-05,&
     & 3.275300e-04,3.844900e-04,3.057100e-04,1.955000e-04,8.777600e-05,&
     & 5.686000e-04,6.725200e-04,5.337300e-04,3.386400e-04,1.283300e-04,&
     & 3.156500e-05,3.856100e-05,3.157200e-05,2.123600e-05,1.731900e-05,&
     & 6.743700e-05,8.136800e-05,6.578500e-05,4.327800e-05,2.851300e-05,&
     & 1.345300e-04,1.598300e-04,1.278800e-04,8.263400e-05,4.610500e-05,&
     & 2.526500e-04,2.973100e-04,2.357300e-04,1.502000e-04,7.194600e-05,&
     & 4.489400e-04,5.311900e-04,4.197900e-04,2.651700e-04,1.076600e-04,&
     & 2.207500e-05,2.713400e-05,2.222600e-05,1.497100e-05,1.336400e-05,&
     & 4.897800e-05,5.945400e-05,4.805100e-05,3.159300e-05,2.240600e-05,&
     & 1.010100e-04,1.208300e-04,9.654300e-05,6.230100e-05,3.707800e-05,&
     & 1.955900e-04,2.311000e-04,1.827400e-04,1.160100e-04,5.935700e-05,&
     & 3.563900e-04,4.221000e-04,3.321500e-04,2.087900e-04,9.099900e-05,&
     & 1.816200e-05,2.236200e-05,1.826000e-05,1.225300e-05,1.170800e-05,&
     & 4.132300e-05,5.028500e-05,4.048300e-05,2.649400e-05,1.989700e-05,&
     & 8.712300e-05,1.045500e-04,8.321300e-05,5.339000e-05,3.340000e-05,&
     & 1.721400e-04,2.039100e-04,1.604700e-04,1.012300e-04,5.426300e-05,&
     & 3.189700e-04,3.782500e-04,2.960600e-04,1.848000e-04,8.439300e-05/
      data  absb(1:300,10) /                                            &
     & 2.734100e-01,2.752600e-01,2.518300e-01,1.926100e-01,1.421000e+00,&
     & 3.864100e-01,3.893100e-01,3.550000e-01,2.736300e-01,1.525000e+00,&
     & 5.210100e-01,5.275100e-01,4.784100e-01,3.701200e-01,1.624200e+00,&
     & 6.780700e-01,6.863100e-01,6.244700e-01,4.816200e-01,1.723600e+00,&
     & 8.573200e-01,8.650200e-01,7.863200e-01,6.078800e-01,1.835300e+00,&
     & 2.610000e-01,2.721700e-01,2.485700e-01,1.909900e-01,1.309600e+00,&
     & 3.666200e-01,3.832100e-01,3.483800e-01,2.681700e-01,1.404800e+00,&
     & 4.930200e-01,5.142100e-01,4.696200e-01,3.602100e-01,1.498600e+00,&
     & 6.406800e-01,6.650300e-01,6.080600e-01,4.665500e-01,1.600800e+00,&
     & 8.059400e-01,8.387000e-01,7.628600e-01,5.873900e-01,1.699600e+00,&
     & 2.453800e-01,2.645000e-01,2.406500e-01,1.854400e-01,1.099100e+00,&
     & 3.429000e-01,3.688000e-01,3.371400e-01,2.576800e-01,1.180700e+00,&
     & 4.600800e-01,4.921200e-01,4.511100e-01,3.435100e-01,1.265500e+00,&
     & 5.951000e-01,6.359100e-01,5.804200e-01,4.434700e-01,1.353800e+00,&
     & 7.443100e-01,7.981800e-01,7.281000e-01,5.587000e-01,1.441500e+00,&
     & 2.281400e-01,2.511200e-01,2.289400e-01,1.760400e-01,8.691800e-01,&
     & 3.174000e-01,3.481500e-01,3.181300e-01,2.432100e-01,9.379400e-01,&
     & 4.240600e-01,4.641000e-01,4.226000e-01,3.221100e-01,1.012200e+00,&
     & 5.452000e-01,5.987000e-01,5.432800e-01,4.142400e-01,1.084900e+00,&
     & 6.805300e-01,7.460800e-01,6.807400e-01,5.220500e-01,1.161600e+00,&
     & 2.094200e-01,2.342800e-01,2.130000e-01,1.635700e-01,6.885600e-01,&
     & 2.902800e-01,3.240200e-01,2.933400e-01,2.245900e-01,7.531600e-01,&
     & 3.852100e-01,4.315400e-01,3.884800e-01,2.966000e-01,8.171200e-01,&
     & 4.938600e-01,5.528000e-01,4.990800e-01,3.819700e-01,8.833100e-01,&
     & 6.148800e-01,6.882100e-01,6.245200e-01,4.787900e-01,9.585700e-01,&
     & 1.906300e-01,2.156100e-01,1.950300e-01,1.489700e-01,5.826200e-01,&
     & 2.623400e-01,2.981500e-01,2.672700e-01,2.034000e-01,6.443700e-01,&
     & 3.466600e-01,3.944800e-01,3.527800e-01,2.694500e-01,7.077300e-01,&
     & 4.431000e-01,5.037000e-01,4.519700e-01,3.462400e-01,7.761000e-01,&
     & 5.497900e-01,6.264000e-01,5.660700e-01,4.326900e-01,8.449800e-01,&
     & 1.716100e-01,1.965900e-01,1.759200e-01,1.340000e-01,5.231500e-01,&
     & 2.348900e-01,2.700300e-01,2.406800e-01,1.832000e-01,5.848800e-01,&
     & 3.094200e-01,3.557600e-01,3.171200e-01,2.421000e-01,6.478900e-01,&
     & 3.938900e-01,4.537400e-01,4.062900e-01,3.099900e-01,7.135100e-01,&
     & 4.889100e-01,5.640200e-01,5.067900e-01,3.861300e-01,7.767000e-01,&
     & 1.543600e-01,1.784900e-01,1.583500e-01,1.205400e-01,4.812200e-01,&
     & 2.103700e-01,2.432900e-01,2.159400e-01,1.647500e-01,5.408300e-01,&
     & 2.758800e-01,3.192300e-01,2.847500e-01,2.168300e-01,6.022900e-01,&
     & 3.517900e-01,4.067300e-01,3.635600e-01,2.764700e-01,6.638900e-01,&
     & 4.394400e-01,5.059100e-01,4.516100e-01,3.430900e-01,7.258800e-01,&
     & 1.393100e-01,1.606100e-01,1.421000e-01,1.080000e-01,4.408200e-01,&
     & 1.890300e-01,2.179200e-01,1.936100e-01,1.469100e-01,4.968500e-01,&
     & 2.483600e-01,2.849400e-01,2.542300e-01,1.923200e-01,5.560400e-01,&
     & 3.185500e-01,3.631300e-01,3.232500e-01,2.446300e-01,6.154300e-01,&
     & 4.003400e-01,4.534600e-01,4.007100e-01,3.034600e-01,6.756200e-01,&
     & 1.285300e-01,1.473000e-01,1.301200e-01,9.841900e-02,3.950600e-01,&
     & 1.743200e-01,1.985700e-01,1.762100e-01,1.327400e-01,4.491000e-01,&
     & 2.301200e-01,2.598400e-01,2.296000e-01,1.729500e-01,5.050500e-01,&
     & 2.971600e-01,3.316300e-01,2.912600e-01,2.189100e-01,5.630400e-01,&
     & 3.773300e-01,4.149700e-01,3.613700e-01,2.709300e-01,6.224100e-01,&
     & 1.188100e-01,1.354500e-01,1.194400e-01,8.924400e-02,3.522300e-01,&
     & 1.617300e-01,1.825000e-01,1.601900e-01,1.196000e-01,4.038000e-01,&
     & 2.153100e-01,2.391800e-01,2.082800e-01,1.550800e-01,4.568500e-01,&
     & 2.811100e-01,3.063400e-01,2.643300e-01,1.961600e-01,5.105000e-01,&
     & 3.586200e-01,3.853800e-01,3.291300e-01,2.433600e-01,5.651200e-01,&
     & 1.105100e-01,1.249600e-01,1.095700e-01,8.103200e-02,3.106200e-01,&
     & 1.517200e-01,1.688000e-01,1.466000e-01,1.080200e-01,3.560100e-01,&
     & 2.037600e-01,2.221200e-01,1.909300e-01,1.396900e-01,4.015100e-01,&
     & 2.659500e-01,2.867000e-01,2.429000e-01,1.769300e-01,4.465500e-01,&
     & 3.371100e-01,3.615400e-01,3.042100e-01,2.201600e-01,4.930700e-01/
      data  absb(301:600,10) /                                          &
     & 1.042000e-01,1.161200e-01,1.007100e-01,7.399400e-02,2.676900e-01,&
     & 1.437900e-01,1.574000e-01,1.350100e-01,9.835300e-02,3.048600e-01,&
     & 1.921700e-01,2.086800e-01,1.765000e-01,1.273500e-01,3.423600e-01,&
     & 2.487000e-01,2.691900e-01,2.263400e-01,1.617100e-01,3.814800e-01,&
     & 3.137700e-01,3.380300e-01,2.844200e-01,2.014600e-01,4.227200e-01,&
     & 9.967500e-02,1.091300e-01,9.338900e-02,6.820400e-02,2.270200e-01,&
     & 1.360800e-01,1.486600e-01,1.258700e-01,9.054800e-02,2.583100e-01,&
     & 1.798700e-01,1.962900e-01,1.653100e-01,1.176100e-01,2.907700e-01,&
     & 2.314100e-01,2.513300e-01,2.118400e-01,1.500200e-01,3.252100e-01,&
     & 2.916800e-01,3.149800e-01,2.656800e-01,1.875400e-01,3.616400e-01,&
     & 9.496100e-02,1.033400e-01,8.737400e-02,6.312600e-02,1.868300e-01,&
     & 1.278300e-01,1.396900e-01,1.179000e-01,8.411200e-02,2.133200e-01,&
     & 1.676200e-01,1.827800e-01,1.544200e-01,1.098400e-01,2.414200e-01,&
     & 2.151800e-01,2.332900e-01,1.971900e-01,1.399600e-01,2.715900e-01,&
     & 2.708800e-01,2.922800e-01,2.466600e-01,1.744200e-01,3.035200e-01,&
     & 8.989400e-02,9.746800e-02,8.217700e-02,5.888900e-02,1.506000e-01,&
     & 1.198800e-01,1.303500e-01,1.100000e-01,7.873800e-02,1.728700e-01,&
     & 1.564900e-01,1.695700e-01,1.432900e-01,1.025600e-01,1.970700e-01,&
     & 2.004600e-01,2.164000e-01,1.826600e-01,1.302100e-01,2.230500e-01,&
     & 2.520900e-01,2.714700e-01,2.285600e-01,1.618200e-01,2.504800e-01,&
     & 8.497500e-02,9.156400e-02,7.711900e-02,5.532000e-02,1.203100e-01,&
     & 1.127900e-01,1.215400e-01,1.024800e-01,7.369900e-02,1.392100e-01,&
     & 1.467300e-01,1.579200e-01,1.330900e-01,9.544900e-02,1.598400e-01,&
     & 1.874100e-01,2.015800e-01,1.695100e-01,1.208200e-01,1.820300e-01,&
     & 2.350600e-01,2.533700e-01,2.122400e-01,1.505300e-01,2.054900e-01,&
     & 8.054000e-02,8.597900e-02,7.224800e-02,5.183800e-02,9.525700e-02,&
     & 1.065900e-01,1.136300e-01,9.554200e-02,6.863000e-02,1.111600e-01,&
     & 1.381100e-01,1.476900e-01,1.239800e-01,8.865100e-02,1.285100e-01,&
     & 1.757600e-01,1.888500e-01,1.579500e-01,1.123000e-01,1.470400e-01,&
     & 2.196800e-01,2.375000e-01,1.977800e-01,1.403400e-01,1.674600e-01,&
     & 7.656800e-02,8.101300e-02,6.787700e-02,4.853100e-02,7.456600e-02,&
     & 1.010900e-01,1.069900e-01,8.962800e-02,6.397300e-02,8.764200e-02,&
     & 1.306200e-01,1.389600e-01,1.161800e-01,8.266500e-02,1.020900e-01,&
     & 1.655000e-01,1.777400e-01,1.481400e-01,1.050300e-01,1.180200e-01,&
     & 2.067500e-01,2.232700e-01,1.855500e-01,1.315100e-01,1.354400e-01,&
     & 7.288800e-02,7.683800e-02,6.412600e-02,4.549500e-02,5.881700e-02,&
     & 9.626700e-02,1.014000e-01,8.457900e-02,5.994500e-02,6.977300e-02,&
     & 1.239800e-01,1.317000e-01,1.096000e-01,7.755500e-02,8.199700e-02,&
     & 1.568200e-01,1.681000e-01,1.396000e-01,9.881200e-02,9.552800e-02,&
     & 1.959400e-01,2.110700e-01,1.750500e-01,1.241600e-01,1.109000e-01,&
     & 6.963500e-02,7.331700e-02,6.101000e-02,4.286500e-02,4.666000e-02,&
     & 9.170100e-02,9.675900e-02,8.032600e-02,5.650100e-02,5.583300e-02,&
     & 1.180100e-01,1.254000e-01,1.040600e-01,7.331600e-02,6.613800e-02,&
     & 1.495300e-01,1.598500e-01,1.323800e-01,9.360100e-02,7.780800e-02,&
     & 1.872700e-01,2.010800e-01,1.662100e-01,1.178900e-01,9.102900e-02,&
     & 6.605100e-02,6.960600e-02,5.779300e-02,4.030000e-02,3.839000e-02,&
     & 8.685000e-02,9.201000e-02,7.610400e-02,5.312900e-02,4.630000e-02,&
     & 1.119000e-01,1.190200e-01,9.837600e-02,6.905900e-02,5.524300e-02,&
     & 1.422700e-01,1.519300e-01,1.253400e-01,8.842400e-02,6.550300e-02,&
     & 1.789300e-01,1.916400e-01,1.578000e-01,1.115900e-01,7.710800e-02,&
     & 6.106100e-02,6.458900e-02,5.347200e-02,3.707600e-02,3.093600e-02,&
     & 8.041300e-02,8.551800e-02,7.063100e-02,4.903300e-02,3.763000e-02,&
     & 1.041800e-01,1.109800e-01,9.137600e-02,6.389200e-02,4.534800e-02,&
     & 1.332600e-01,1.421800e-01,1.168400e-01,8.200400e-02,5.417700e-02,&
     & 1.681800e-01,1.801400e-01,1.479100e-01,1.038300e-01,6.435200e-02,&
     & 5.485900e-02,5.826900e-02,4.818200e-02,3.325300e-02,2.420400e-02,&
     & 7.262600e-02,7.749100e-02,6.394900e-02,4.418600e-02,2.974700e-02,&
     & 9.486700e-02,1.012100e-01,8.312600e-02,5.776100e-02,3.618300e-02,&
     & 1.221500e-01,1.304500e-01,1.069300e-01,7.444500e-02,4.369300e-02,&
     & 1.551400e-01,1.664600e-01,1.361300e-01,9.476000e-02,5.244400e-02/
      data  absb(601:900,10) /                                          &
     & 4.723000e-02,5.037600e-02,4.160600e-02,2.865000e-02,1.957600e-02,&
     & 6.316200e-02,6.755900e-02,5.573700e-02,3.836600e-02,2.430700e-02,&
     & 8.338200e-02,8.910000e-02,7.309600e-02,5.040400e-02,2.984500e-02,&
     & 1.083100e-01,1.157800e-01,9.474700e-02,6.539900e-02,3.633400e-02,&
     & 1.387200e-01,1.491200e-01,1.215300e-01,8.389000e-02,4.397000e-02,&
     & 4.059400e-02,4.348200e-02,3.588200e-02,2.465200e-02,1.579600e-02,&
     & 5.489300e-02,5.885900e-02,4.853500e-02,3.334200e-02,1.983800e-02,&
     & 7.327000e-02,7.844200e-02,6.429900e-02,4.405700e-02,2.458700e-02,&
     & 9.613100e-02,1.029700e-01,8.406200e-02,5.754200e-02,3.019400e-02,&
     & 1.242500e-01,1.337100e-01,1.087100e-01,7.437600e-02,3.682600e-02,&
     & 3.496000e-02,3.758400e-02,3.100100e-02,2.125300e-02,1.265900e-02,&
     & 4.779600e-02,5.141200e-02,4.233300e-02,2.900600e-02,1.607300e-02,&
     & 6.451000e-02,6.924400e-02,5.669000e-02,3.867100e-02,2.013000e-02,&
     & 8.556100e-02,9.190400e-02,7.480000e-02,5.087300e-02,2.494100e-02,&
     & 1.116300e-01,1.202200e-01,9.762800e-02,6.623500e-02,3.066800e-02,&
     & 2.926800e-02,3.148200e-02,2.593500e-02,1.772100e-02,1.021700e-02,&
     & 4.045900e-02,4.358600e-02,3.585200e-02,2.448600e-02,1.311000e-02,&
     & 5.522900e-02,5.944900e-02,4.858800e-02,3.303800e-02,1.658600e-02,&
     & 7.411700e-02,7.987200e-02,6.488500e-02,4.390700e-02,2.072500e-02,&
     & 9.786500e-02,1.055000e-01,8.556800e-02,5.764300e-02,2.566200e-02,&
     & 2.439700e-02,2.623100e-02,2.158600e-02,1.468200e-02,8.235300e-03,&
     & 3.413900e-02,3.678600e-02,3.023000e-02,2.056800e-02,1.067400e-02,&
     & 4.710600e-02,5.085800e-02,4.145900e-02,2.811500e-02,1.363500e-02,&
     & 6.400000e-02,6.918000e-02,5.606200e-02,3.779900e-02,1.720400e-02,&
     & 8.551700e-02,9.240000e-02,7.478200e-02,5.009900e-02,2.145000e-02,&
     & 2.026800e-02,2.184500e-02,1.795600e-02,1.214000e-02,6.599100e-03,&
     & 2.878900e-02,3.102100e-02,2.546700e-02,1.724600e-02,8.647700e-03,&
     & 4.019400e-02,4.347400e-02,3.536300e-02,2.390200e-02,1.115400e-02,&
     & 5.525800e-02,5.991900e-02,4.842900e-02,3.253600e-02,1.421000e-02,&
     & 7.469600e-02,8.096200e-02,6.539300e-02,4.361800e-02,1.784900e-02,&
     & 1.642600e-02,1.780400e-02,1.461300e-02,9.805000e-03,5.261700e-03,&
     & 2.374700e-02,2.563000e-02,2.101100e-02,1.416000e-02,6.984700e-03,&
     & 3.365300e-02,3.641200e-02,2.959200e-02,1.992500e-02,9.104000e-03,&
     & 4.686800e-02,5.093800e-02,4.110800e-02,2.752600e-02,1.171000e-02,&
     & 6.412900e-02,6.976000e-02,5.623800e-02,3.738300e-02,1.482300e-02,&
     & 1.310000e-02,1.431600e-02,1.174200e-02,7.818500e-03,4.173100e-03,&
     & 1.930600e-02,2.094600e-02,1.713000e-02,1.148800e-02,5.625300e-03,&
     & 2.783900e-02,3.015900e-02,2.449700e-02,1.642000e-02,7.417700e-03,&
     & 3.935100e-02,4.284500e-02,3.454200e-02,2.303600e-02,9.632300e-03,&
     & 5.454500e-02,5.956500e-02,4.791600e-02,3.176600e-02,1.229700e-02,&
     & 1.036500e-02,1.143200e-02,9.376700e-03,6.211700e-03,3.283900e-03,&
     & 1.558900e-02,1.706300e-02,1.393000e-02,9.285900e-03,4.500500e-03,&
     & 2.291000e-02,2.492400e-02,2.022700e-02,1.349400e-02,6.016500e-03,&
     & 3.293800e-02,3.593300e-02,2.894400e-02,1.921500e-02,7.890100e-03,&
     & 4.628800e-02,5.073900e-02,4.075500e-02,2.693000e-02,1.016300e-02,&
     & 8.061100e-03,8.968700e-03,7.361600e-03,4.864900e-03,2.563000e-03,&
     & 1.238400e-02,1.370000e-02,1.118700e-02,7.414100e-03,3.573600e-03,&
     & 1.858900e-02,2.037600e-02,1.651400e-02,1.094900e-02,4.854600e-03,&
     & 2.722800e-02,2.979800e-02,2.398600e-02,1.586700e-02,6.439500e-03,&
     & 3.890700e-02,4.277200e-02,3.432800e-02,2.259800e-02,8.379300e-03,&
     & 6.094200e-03,6.837300e-03,5.615100e-03,3.710800e-03,1.987400e-03,&
     & 9.583000e-03,1.072000e-02,8.768700e-03,5.783000e-03,2.814900e-03,&
     & 1.471900e-02,1.628600e-02,1.320600e-02,8.708200e-03,3.898900e-03,&
     & 2.203400e-02,2.424800e-02,1.949600e-02,1.283900e-02,5.246400e-03,&
     & 3.206800e-02,3.538500e-02,2.836600e-02,1.861100e-02,6.908700e-03,&
     & 4.551000e-03,5.151500e-03,4.228600e-03,2.793800e-03,1.532400e-03,&
     & 7.329300e-03,8.302200e-03,6.795800e-03,4.470800e-03,2.201800e-03,&
     & 1.153200e-02,1.290900e-02,1.048500e-02,6.889600e-03,3.103200e-03,&
     & 1.766900e-02,1.961900e-02,1.576800e-02,1.033400e-02,4.252600e-03,&
     & 2.626300e-02,2.913400e-02,2.332500e-02,1.524400e-02,5.676800e-03/
      data  absb(901:1175,10) /                                         &
     & 3.356000e-03,3.832700e-03,3.139100e-03,2.074300e-03,1.180200e-03,&
     & 5.534200e-03,6.354200e-03,5.198100e-03,3.421100e-03,1.709600e-03,&
     & 8.929400e-03,1.014300e-02,8.246800e-03,5.419600e-03,2.447000e-03,&
     & 1.402400e-02,1.576500e-02,1.268400e-02,8.273400e-03,3.412900e-03,&
     & 2.135200e-02,2.386600e-02,1.907500e-02,1.241100e-02,4.627900e-03,&
     & 2.492900e-03,2.863200e-03,2.337900e-03,1.544000e-03,9.322500e-04,&
     & 4.202900e-03,4.875200e-03,3.980500e-03,2.619800e-03,1.357600e-03,&
     & 6.932500e-03,7.992500e-03,6.497400e-03,4.267400e-03,1.961300e-03,&
     & 1.115800e-02,1.270900e-02,1.022900e-02,6.664400e-03,2.783200e-03,&
     & 1.740300e-02,1.964200e-02,1.569100e-02,1.015500e-02,3.833300e-03,&
     & 1.853200e-03,2.136400e-03,1.737600e-03,1.145400e-03,7.487800e-04,&
     & 3.188800e-03,3.729100e-03,3.035700e-03,1.994500e-03,1.092200e-03,&
     & 5.363800e-03,6.278000e-03,5.096800e-03,3.341900e-03,1.585800e-03,&
     & 8.850100e-03,1.021900e-02,8.227700e-03,5.363900e-03,2.283200e-03,&
     & 1.414900e-02,1.614600e-02,1.291200e-02,8.317100e-03,3.200000e-03,&
     & 1.362800e-03,1.578300e-03,1.280800e-03,8.405500e-04,6.001200e-04,&
     & 2.401700e-03,2.823600e-03,2.290500e-03,1.501100e-03,8.812600e-04,&
     & 4.116900e-03,4.881500e-03,3.960700e-03,2.590600e-03,1.284700e-03,&
     & 6.953600e-03,8.155900e-03,6.566400e-03,4.281500e-03,1.863800e-03,&
     & 1.140900e-02,1.319400e-02,1.055300e-02,6.787500e-03,2.653400e-03,&
     & 9.860600e-04,1.154000e-03,9.338400e-04,6.104000e-04,4.770900e-04,&
     & 1.792000e-03,2.114500e-03,1.706300e-03,1.116900e-03,7.131200e-04,&
     & 3.129400e-03,3.754600e-03,3.042100e-03,1.986100e-03,1.041900e-03,&
     & 5.405900e-03,6.452200e-03,5.192100e-03,3.381600e-03,1.513000e-03,&
     & 9.111800e-03,1.069600e-02,8.553400e-03,5.506600e-03,2.184300e-03,&
     & 7.251300e-04,8.573200e-04,6.918300e-04,4.503900e-04,3.876900e-04,&
     & 1.363900e-03,1.606700e-03,1.290200e-03,8.397200e-04,5.934100e-04,&
     & 2.421400e-03,2.917600e-03,2.354500e-03,1.532800e-03,8.721400e-04,&
     & 4.249000e-03,5.141400e-03,4.136200e-03,2.685100e-03,1.271000e-03,&
     & 7.327700e-03,8.735200e-03,6.986600e-03,4.497400e-03,1.846300e-03,&
     & 5.353600e-04,6.381900e-04,5.142900e-04,3.338400e-04,3.178700e-04,&
     & 1.043400e-03,1.228600e-03,9.819700e-04,6.346400e-04,5.005100e-04,&
     & 1.889600e-03,2.275900e-03,1.825500e-03,1.182000e-03,7.468900e-04,&
     & 3.354300e-03,4.100000e-03,3.292200e-03,2.128900e-03,1.091000e-03,&
     & 5.895700e-03,7.136000e-03,5.707200e-03,3.672100e-03,1.588300e-03,&
     & 3.904100e-04,4.698300e-04,3.782700e-04,2.449500e-04,2.582200e-04,&
     & 7.904100e-04,9.355400e-04,7.444400e-04,4.774300e-04,4.209800e-04,&
     & 1.471100e-03,1.770600e-03,1.408500e-03,9.046200e-04,6.413500e-04,&
     & 2.641000e-03,3.248700e-03,2.599400e-03,1.675300e-03,9.418900e-04,&
     & 4.718000e-03,5.794200e-03,4.633900e-03,2.975300e-03,1.374400e-03,&
     & 2.811200e-04,3.413400e-04,2.746000e-04,1.773900e-04,2.081000e-04,&
     & 5.923300e-04,7.061200e-04,5.603600e-04,3.572400e-04,3.521800e-04,&
     & 1.140400e-03,1.369800e-03,1.081800e-03,6.886700e-04,5.509500e-04,&
     & 2.075600e-03,2.559800e-03,2.038900e-03,1.307100e-03,8.194700e-04,&
     & 3.756500e-03,4.671500e-03,3.737200e-03,2.389700e-03,1.197000e-03,&
     & 2.028700e-04,2.484100e-04,1.995000e-04,1.287000e-04,1.687300e-04,&
     & 4.447200e-04,5.347000e-04,4.229200e-04,2.689900e-04,2.955600e-04,&
     & 8.890900e-04,1.066800e-03,8.366900e-04,5.291700e-04,4.769800e-04,&
     & 1.647200e-03,2.031900e-03,1.607900e-03,1.023500e-03,7.222200e-04,&
     & 3.014200e-03,3.780800e-03,3.020000e-03,1.923000e-03,1.057800e-03,&
     & 1.726400e-04,2.125200e-04,1.697900e-04,1.087700e-04,1.553500e-04,&
     & 3.884400e-04,4.689200e-04,3.689200e-04,2.328500e-04,2.777000e-04,&
     & 7.931300e-04,9.535800e-04,7.424200e-04,4.649000e-04,4.561100e-04,&
     & 1.488800e-03,1.836200e-03,1.443700e-03,9.090700e-04,6.987800e-04,&
     & 2.741200e-03,3.444400e-03,2.740300e-03,1.729300e-03,1.028000e-03/
      data  absb(1:300,11) /                                            &
     & 4.658200e-01,4.312600e-01,3.914800e-01,2.978200e-01,2.003800e+00,&
     & 6.601500e-01,6.136200e-01,5.556400e-01,4.199700e-01,2.150600e+00,&
     & 8.918600e-01,8.325500e-01,7.503200e-01,5.697500e-01,2.297000e+00,&
     & 1.158600e+00,1.086900e+00,9.735900e-01,7.419600e-01,2.427100e+00,&
     & 1.456300e+00,1.376100e+00,1.228700e+00,9.362400e-01,2.553700e+00,&
     & 4.662200e-01,4.469400e-01,4.062100e-01,3.051700e-01,1.923900e+00,&
     & 6.562600e-01,6.309700e-01,5.702900e-01,4.301700e-01,2.065900e+00,&
     & 8.815300e-01,8.502900e-01,7.639100e-01,5.801500e-01,2.196800e+00,&
     & 1.139600e+00,1.104300e+00,9.883600e-01,7.500600e-01,2.318000e+00,&
     & 1.429000e+00,1.387000e+00,1.240700e+00,9.405100e-01,2.454800e+00,&
     & 4.581400e-01,4.539800e-01,4.105400e-01,3.083900e-01,1.683500e+00,&
     & 6.400500e-01,6.356300e-01,5.720200e-01,4.326500e-01,1.804400e+00,&
     & 8.548100e-01,8.518800e-01,7.632500e-01,5.777600e-01,1.921600e+00,&
     & 1.101100e+00,1.098400e+00,9.847000e-01,7.424200e-01,2.048000e+00,&
     & 1.378900e+00,1.370700e+00,1.226300e+00,9.269200e-01,2.166200e+00,&
     & 4.393600e-01,4.505500e-01,4.061000e-01,3.060700e-01,1.389100e+00,&
     & 6.098000e-01,6.258000e-01,5.620500e-01,4.241100e-01,1.493700e+00,&
     & 8.105100e-01,8.304100e-01,7.476200e-01,5.621900e-01,1.602400e+00,&
     & 1.042300e+00,1.062900e+00,9.563600e-01,7.192600e-01,1.707400e+00,&
     & 1.301200e+00,1.327000e+00,1.186700e+00,8.966200e-01,1.806500e+00,&
     & 4.122600e-01,4.360600e-01,3.920300e-01,2.961400e-01,1.147600e+00,&
     & 5.688900e-01,6.007800e-01,5.410000e-01,4.060700e-01,1.237800e+00,&
     & 7.547500e-01,7.922300e-01,7.142100e-01,5.342900e-01,1.329400e+00,&
     & 9.674700e-01,1.012400e+00,9.080700e-01,6.819400e-01,1.412400e+00,&
     & 1.199400e+00,1.259300e+00,1.126100e+00,8.518500e-01,1.495500e+00,&
     & 3.806400e-01,4.127900e-01,3.708900e-01,2.798100e-01,9.715000e-01,&
     & 5.235800e-01,5.646200e-01,5.082900e-01,3.810500e-01,1.054900e+00,&
     & 6.926300e-01,7.431200e-01,6.662100e-01,4.987100e-01,1.133900e+00,&
     & 8.822900e-01,9.487200e-01,8.460700e-01,6.357600e-01,1.210900e+00,&
     & 1.091800e+00,1.171500e+00,1.048500e+00,7.932100e-01,1.296600e+00,&
     & 3.470700e-01,3.825400e-01,3.436200e-01,2.585800e-01,8.652400e-01,&
     & 4.762400e-01,5.217700e-01,4.666000e-01,3.504100e-01,9.456700e-01,&
     & 6.267100e-01,6.865100e-01,6.096500e-01,4.583100e-01,1.024400e+00,&
     & 7.965300e-01,8.709800e-01,7.744200e-01,5.840100e-01,1.107300e+00,&
     & 9.842700e-01,1.072600e+00,9.599700e-01,7.254000e-01,1.196600e+00,&
     & 3.156700e-01,3.518100e-01,3.144400e-01,2.362200e-01,8.015800e-01,&
     & 4.313100e-01,4.792300e-01,4.243600e-01,3.188000e-01,8.808100e-01,&
     & 5.651200e-01,6.270000e-01,5.531200e-01,4.174100e-01,9.611300e-01,&
     & 7.166100e-01,7.915900e-01,7.017800e-01,5.303200e-01,1.048900e+00,&
     & 8.823600e-01,9.746800e-01,8.695200e-01,6.574300e-01,1.137200e+00,&
     & 2.859200e-01,3.207400e-01,2.839400e-01,2.133300e-01,7.429000e-01,&
     & 3.882600e-01,4.350200e-01,3.822300e-01,2.879700e-01,8.217800e-01,&
     & 5.074100e-01,5.657200e-01,4.979200e-01,3.759000e-01,9.051900e-01,&
     & 6.405800e-01,7.134000e-01,6.308000e-01,4.766300e-01,9.922500e-01,&
     & 7.881100e-01,8.794400e-01,7.795300e-01,5.891700e-01,1.081200e+00,&
     & 2.634900e-01,2.966000e-01,2.596400e-01,1.955700e-01,6.757000e-01,&
     & 3.552700e-01,3.983500e-01,3.485000e-01,2.630500e-01,7.522400e-01,&
     & 4.605000e-01,5.153800e-01,4.531500e-01,3.416100e-01,8.362000e-01,&
     & 5.803400e-01,6.497100e-01,5.712400e-01,4.314800e-01,9.219100e-01,&
     & 7.159800e-01,7.999200e-01,7.038700e-01,5.309800e-01,1.010800e+00,&
     & 2.429400e-01,2.730600e-01,2.373200e-01,1.787200e-01,6.070500e-01,&
     & 3.249700e-01,3.637200e-01,3.178800e-01,2.386900e-01,6.842100e-01,&
     & 4.206700e-01,4.694100e-01,4.107200e-01,3.087400e-01,7.660000e-01,&
     & 5.316400e-01,5.909700e-01,5.161400e-01,3.879200e-01,8.530000e-01,&
     & 6.586100e-01,7.284400e-01,6.339200e-01,4.775700e-01,9.424100e-01,&
     & 2.248200e-01,2.510800e-01,2.180200e-01,1.628600e-01,5.385400e-01,&
     & 2.999700e-01,3.329100e-01,2.898500e-01,2.164000e-01,6.167800e-01,&
     & 3.894900e-01,4.294500e-01,3.725900e-01,2.784100e-01,6.994700e-01,&
     & 4.947500e-01,5.404000e-01,4.678100e-01,3.487400e-01,7.867800e-01,&
     & 6.168800e-01,6.684500e-01,5.752600e-01,4.294600e-01,8.763800e-01/
      data  absb(301:600,11) /                                          &
     & 2.086700e-01,2.317500e-01,2.008500e-01,1.484900e-01,4.833600e-01,&
     & 2.794400e-01,3.072900e-01,2.648700e-01,1.960900e-01,5.582300e-01,&
     & 3.650600e-01,3.963200e-01,3.402000e-01,2.511500e-01,6.366100e-01,&
     & 4.672700e-01,5.007000e-01,4.273100e-01,3.151200e-01,7.158200e-01,&
     & 5.863600e-01,6.220900e-01,5.279600e-01,3.892500e-01,7.983400e-01,&
     & 1.958700e-01,2.159400e-01,1.857600e-01,1.360200e-01,4.342600e-01,&
     & 2.638200e-01,2.867600e-01,2.445900e-01,1.787300e-01,5.008500e-01,&
     & 3.469200e-01,3.712000e-01,3.146500e-01,2.287400e-01,5.693400e-01,&
     & 4.452000e-01,4.718100e-01,3.963700e-01,2.876600e-01,6.396900e-01,&
     & 5.560500e-01,5.885500e-01,4.919500e-01,3.567500e-01,7.147600e-01,&
     & 1.853900e-01,2.023200e-01,1.724200e-01,1.249100e-01,3.746800e-01,&
     & 2.509600e-01,2.693600e-01,2.276600e-01,1.637200e-01,4.313400e-01,&
     & 3.298500e-01,3.511800e-01,2.938000e-01,2.101800e-01,4.902400e-01,&
     & 4.205000e-01,4.477900e-01,3.724500e-01,2.655200e-01,5.537300e-01,&
     & 5.235300e-01,5.579900e-01,4.645100e-01,3.297900e-01,6.224400e-01,&
     & 1.767000e-01,1.907900e-01,1.608100e-01,1.155000e-01,3.117300e-01,&
     & 2.381600e-01,2.554500e-01,2.134900e-01,1.516500e-01,3.601500e-01,&
     & 3.104600e-01,3.332900e-01,2.769200e-01,1.953500e-01,4.120300e-01,&
     & 3.942100e-01,4.235500e-01,3.522600e-01,2.475300e-01,4.688100e-01,&
     & 4.911300e-01,5.275700e-01,4.398800e-01,3.081700e-01,5.298900e-01,&
     & 1.684300e-01,1.815400e-01,1.515400e-01,1.076700e-01,2.544100e-01,&
     & 2.246600e-01,2.427000e-01,2.019000e-01,1.420100e-01,2.955600e-01,&
     & 2.912600e-01,3.153700e-01,2.623200e-01,1.838700e-01,3.411300e-01,&
     & 3.698300e-01,4.001100e-01,3.334000e-01,2.333800e-01,3.910000e-01,&
     & 4.610100e-01,4.986700e-01,4.166300e-01,2.905300e-01,4.446400e-01,&
     & 1.595900e-01,1.726200e-01,1.437400e-01,1.013000e-01,2.047100e-01,&
     & 2.111500e-01,2.296300e-01,1.911600e-01,1.342100e-01,2.402000e-01,&
     & 2.736000e-01,2.974000e-01,2.479500e-01,1.740300e-01,2.796800e-01,&
     & 3.476400e-01,3.775600e-01,3.154900e-01,2.207000e-01,3.228100e-01,&
     & 4.344000e-01,4.721900e-01,3.946500e-01,2.746500e-01,3.689600e-01,&
     & 1.509100e-01,1.639100e-01,1.364500e-01,9.627800e-02,1.628900e-01,&
     & 1.993100e-01,2.172100e-01,1.807900e-01,1.277100e-01,1.930900e-01,&
     & 2.582100e-01,2.810900e-01,2.344900e-01,1.650200e-01,2.267600e-01,&
     & 3.287500e-01,3.582900e-01,2.989800e-01,2.091900e-01,2.637000e-01,&
     & 4.115700e-01,4.500200e-01,3.749900e-01,2.606400e-01,3.036500e-01,&
     & 1.435000e-01,1.557700e-01,1.294800e-01,9.191100e-02,1.312600e-01,&
     & 1.892700e-01,2.059100e-01,1.713700e-01,1.214800e-01,1.571200e-01,&
     & 2.454200e-01,2.674500e-01,2.226500e-01,1.568600e-01,1.860600e-01,&
     & 3.129900e-01,3.421100e-01,2.846400e-01,1.987900e-01,2.177600e-01,&
     & 3.918900e-01,4.315400e-01,3.578400e-01,2.486900e-01,2.526100e-01,&
     & 1.372700e-01,1.483800e-01,1.232500e-01,8.772300e-02,1.065600e-01,&
     & 1.811000e-01,1.964700e-01,1.632200e-01,1.156200e-01,1.286700e-01,&
     & 2.349300e-01,2.563300e-01,2.126000e-01,1.494500e-01,1.534400e-01,&
     & 2.993000e-01,3.291100e-01,2.724100e-01,1.899100e-01,1.811200e-01,&
     & 3.749100e-01,4.165800e-01,3.434000e-01,2.386700e-01,2.118800e-01,&
     & 1.309200e-01,1.409400e-01,1.166700e-01,8.291100e-02,8.947100e-02,&
     & 1.728300e-01,1.872000e-01,1.549800e-01,1.094500e-01,1.087900e-01,&
     & 2.242300e-01,2.450800e-01,2.024700e-01,1.417500e-01,1.306700e-01,&
     & 2.856800e-01,3.161300e-01,2.602200e-01,1.811900e-01,1.555100e-01,&
     & 3.583600e-01,4.015700e-01,3.294200e-01,2.288600e-01,1.833500e-01,&
     & 1.222800e-01,1.311800e-01,1.081500e-01,7.648000e-02,7.377000e-02,&
     & 1.617200e-01,1.751600e-01,1.441900e-01,1.013800e-01,9.053200e-02,&
     & 2.100500e-01,2.302400e-01,1.893600e-01,1.321200e-01,1.097700e-01,&
     & 2.682300e-01,2.983700e-01,2.445000e-01,1.701000e-01,1.315200e-01,&
     & 3.380300e-01,3.806900e-01,3.115100e-01,2.162300e-01,1.563900e-01,&
     & 1.112700e-01,1.190200e-01,9.779000e-02,6.865200e-02,5.929400e-02,&
     & 1.477900e-01,1.599100e-01,1.310000e-01,9.167800e-02,7.342800e-02,&
     & 1.924800e-01,2.115200e-01,1.731000e-01,1.204400e-01,8.993100e-02,&
     & 2.469800e-01,2.754600e-01,2.251300e-01,1.563500e-01,1.086500e-01,&
     & 3.131200e-01,3.535700e-01,2.890000e-01,2.002800e-01,1.300700e-01/
      data  absb(601:900,11) /                                          &
     & 9.717100e-02,1.037000e-01,8.493000e-02,5.913200e-02,4.880000e-02,&
     & 1.302200e-01,1.404200e-01,1.146700e-01,7.978800e-02,6.110100e-02,&
     & 1.705300e-01,1.873200e-01,1.526700e-01,1.059200e-01,7.554900e-02,&
     & 2.202100e-01,2.458400e-01,2.002500e-01,1.388700e-01,9.212300e-02,&
     & 2.814200e-01,3.180600e-01,2.595400e-01,1.797000e-01,1.111400e-01,&
     & 8.475000e-02,9.044700e-02,7.386200e-02,5.102400e-02,4.012000e-02,&
     & 1.147200e-01,1.234700e-01,1.005300e-01,6.943700e-02,5.077600e-02,&
     & 1.513600e-01,1.660700e-01,1.349900e-01,9.321900e-02,6.338500e-02,&
     & 1.968000e-01,2.197800e-01,1.784700e-01,1.234700e-01,7.800600e-02,&
     & 2.534100e-01,2.867500e-01,2.333800e-01,1.614500e-01,9.484000e-02,&
     & 7.401100e-02,7.919100e-02,6.447800e-02,4.420700e-02,3.280500e-02,&
     & 1.012200e-01,1.090700e-01,8.854100e-02,6.075900e-02,4.197100e-02,&
     & 1.347800e-01,1.477900e-01,1.199200e-01,8.232500e-02,5.290100e-02,&
     & 1.766000e-01,1.972700e-01,1.598600e-01,1.101700e-01,6.573000e-02,&
     & 2.290900e-01,2.598600e-01,2.107400e-01,1.455700e-01,8.050500e-02,&
     & 6.247300e-02,6.707300e-02,5.456600e-02,3.718700e-02,2.688500e-02,&
     & 8.660600e-02,9.364400e-02,7.580100e-02,5.166100e-02,3.483600e-02,&
     & 1.168000e-01,1.279900e-01,1.037200e-01,7.069300e-02,4.436800e-02,&
     & 1.547000e-01,1.724700e-01,1.396000e-01,9.567900e-02,5.568700e-02,&
     & 2.023700e-01,2.297700e-01,1.857300e-01,1.279300e-01,6.885000e-02,&
     & 5.244600e-02,5.650700e-02,4.595900e-02,3.119500e-02,2.194800e-02,&
     & 7.370100e-02,8.011100e-02,6.471400e-02,4.381900e-02,2.883400e-02,&
     & 1.007600e-01,1.107000e-01,8.951200e-02,6.057600e-02,3.715800e-02,&
     & 1.350800e-01,1.505700e-01,1.217500e-01,8.289200e-02,4.710000e-02,&
     & 1.785400e-01,2.026900e-01,1.635600e-01,1.121400e-01,5.882300e-02,&
     & 4.399300e-02,4.754300e-02,3.862800e-02,2.617500e-02,1.782200e-02,&
     & 6.261800e-02,6.846100e-02,5.530100e-02,3.721700e-02,2.372800e-02,&
     & 8.681400e-02,9.594800e-02,7.732800e-02,5.200900e-02,3.095300e-02,&
     & 1.179300e-01,1.316500e-01,1.063500e-01,7.196700e-02,3.967900e-02,&
     & 1.576700e-01,1.790900e-01,1.443000e-01,9.841400e-02,5.003100e-02,&
     & 3.605100e-02,3.906800e-02,3.170000e-02,2.150000e-02,1.433600e-02,&
     & 5.213100e-02,5.726200e-02,4.624000e-02,3.100300e-02,1.936700e-02,&
     & 7.334100e-02,8.159000e-02,6.570600e-02,4.388000e-02,2.560400e-02,&
     & 1.011300e-01,1.133600e-01,9.135500e-02,6.139100e-02,3.321000e-02,&
     & 1.370400e-01,1.556600e-01,1.253000e-01,8.498400e-02,4.235700e-02,&
     & 2.915300e-02,3.168900e-02,2.565100e-02,1.739800e-02,1.145200e-02,&
     & 4.289400e-02,4.727100e-02,3.816100e-02,2.555900e-02,1.570200e-02,&
     & 6.131600e-02,6.860600e-02,5.524100e-02,3.670600e-02,2.105100e-02,&
     & 8.580900e-02,9.681100e-02,7.786700e-02,5.197200e-02,2.764300e-02,&
     & 1.180400e-01,1.342700e-01,1.080500e-01,7.283200e-02,3.569800e-02,&
     & 2.347400e-02,2.562000e-02,2.068300e-02,1.399200e-02,9.087200e-03,&
     & 3.516800e-02,3.888400e-02,3.135700e-02,2.099800e-02,1.265000e-02,&
     & 5.112500e-02,5.747900e-02,4.626800e-02,3.068500e-02,1.718800e-02,&
     & 7.264200e-02,8.254000e-02,6.638500e-02,4.398200e-02,2.287800e-02,&
     & 1.014100e-01,1.159300e-01,9.312900e-02,6.238400e-02,2.991200e-02,&
     & 1.862200e-02,2.041900e-02,1.644600e-02,1.108900e-02,7.150800e-03,&
     & 2.846500e-02,3.159100e-02,2.542500e-02,1.700300e-02,1.010000e-02,&
     & 4.211500e-02,4.755800e-02,3.829600e-02,2.538100e-02,1.392800e-02,&
     & 6.088400e-02,6.960600e-02,5.600000e-02,3.688800e-02,1.879800e-02,&
     & 8.627100e-02,9.929500e-02,7.964500e-02,5.299400e-02,2.487300e-02,&
     & 1.437600e-02,1.584900e-02,1.275600e-02,8.563700e-03,5.584600e-03,&
     & 2.252300e-02,2.509100e-02,2.013300e-02,1.343300e-02,8.013500e-03,&
     & 3.398700e-02,3.852100e-02,3.097100e-02,2.049800e-02,1.121700e-02,&
     & 4.999500e-02,5.747500e-02,4.627100e-02,3.042700e-02,1.535400e-02,&
     & 7.209500e-02,8.355300e-02,6.709900e-02,4.424900e-02,2.056700e-02,&
     & 1.094800e-02,1.218700e-02,9.819700e-03,6.568600e-03,4.330900e-03,&
     & 1.767800e-02,1.977300e-02,1.584700e-02,1.052300e-02,6.319600e-03,&
     & 2.727200e-02,3.103500e-02,2.488600e-02,1.642700e-02,8.975300e-03,&
     & 4.084700e-02,4.723100e-02,3.798900e-02,2.496800e-02,1.243500e-02,&
     & 5.994300e-02,6.992800e-02,5.626100e-02,3.686300e-02,1.688400e-02/
      data  absb(901:1175,11) /                                         &
     & 8.222700e-03,9.275100e-03,7.491800e-03,4.985700e-03,3.317900e-03,&
     & 1.371000e-02,1.546100e-02,1.238200e-02,8.183700e-03,4.941600e-03,&
     & 2.175200e-02,2.482400e-02,1.987000e-02,1.306400e-02,7.119900e-03,&
     & 3.320200e-02,3.859200e-02,3.099200e-02,2.032600e-02,9.989500e-03,&
     & 4.956400e-02,5.820600e-02,4.689800e-02,3.066100e-02,1.373400e-02,&
     & 6.191500e-03,7.080800e-03,5.734100e-03,3.793300e-03,2.601400e-03,&
     & 1.063400e-02,1.214000e-02,9.718500e-03,6.396500e-03,3.937400e-03,&
     & 1.739100e-02,1.994500e-02,1.595500e-02,1.044500e-02,5.767800e-03,&
     & 2.712500e-02,3.170100e-02,2.541300e-02,1.659900e-02,8.197500e-03,&
     & 4.119300e-02,4.872600e-02,3.923400e-02,2.563600e-02,1.139200e-02,&
     & 4.641500e-03,5.377900e-03,4.364500e-03,2.876200e-03,2.067000e-03,&
     & 8.198200e-03,9.496400e-03,7.612800e-03,4.989900e-03,3.163800e-03,&
     & 1.383900e-02,1.601400e-02,1.280800e-02,8.336200e-03,4.717300e-03,&
     & 2.215500e-02,2.601500e-02,2.083300e-02,1.353700e-02,6.807100e-03,&
     & 3.426600e-02,4.081900e-02,3.280900e-02,2.139900e-02,9.549400e-03,&
     & 3.445000e-03,4.041900e-03,3.282200e-03,2.159300e-03,1.647500e-03,&
     & 6.250800e-03,7.353700e-03,5.918100e-03,3.860300e-03,2.537100e-03,&
     & 1.090000e-02,1.277300e-02,1.021600e-02,6.612600e-03,3.834800e-03,&
     & 1.797500e-02,2.123300e-02,1.700100e-02,1.099400e-02,5.630300e-03,&
     & 2.837500e-02,3.403800e-02,2.733200e-02,1.774400e-02,7.984300e-03,&
     & 2.533100e-03,3.001700e-03,2.436800e-03,1.599800e-03,1.319300e-03,&
     & 4.708800e-03,5.627400e-03,4.548300e-03,2.954900e-03,2.029400e-03,&
     & 8.477400e-03,1.009700e-02,8.077500e-03,5.209200e-03,3.095900e-03,&
     & 1.444100e-02,1.720900e-02,1.378000e-02,8.874500e-03,4.617200e-03,&
     & 2.338500e-02,2.821200e-02,2.265000e-02,1.461500e-02,6.651100e-03,&
     & 1.895400e-03,2.260700e-03,1.827800e-03,1.194600e-03,1.098500e-03,&
     & 3.586200e-03,4.347100e-03,3.518900e-03,2.282200e-03,1.689500e-03,&
     & 6.631200e-03,8.042400e-03,6.452300e-03,4.140600e-03,2.594000e-03,&
     & 1.167100e-02,1.408900e-02,1.128100e-02,7.227900e-03,3.912200e-03,&
     & 1.943200e-02,2.359800e-02,1.894000e-02,1.215400e-02,5.733700e-03,&
     & 1.429000e-03,1.712500e-03,1.377600e-03,8.934700e-04,9.378400e-04,&
     & 2.745700e-03,3.362300e-03,2.718200e-03,1.759700e-03,1.445300e-03,&
     & 5.187400e-03,6.397900e-03,5.151100e-03,3.293000e-03,2.222100e-03,&
     & 9.422600e-03,1.155000e-02,9.255700e-03,5.899000e-03,3.385100e-03,&
     & 1.615000e-02,1.977700e-02,1.587700e-02,1.013800e-02,5.039600e-03,&
     & 1.068000e-03,1.289000e-03,1.031600e-03,6.644600e-04,8.043000e-04,&
     & 2.097800e-03,2.585800e-03,2.082300e-03,1.344200e-03,1.245600e-03,&
     & 4.030100e-03,5.043500e-03,4.077000e-03,2.599600e-03,1.914200e-03,&
     & 7.540200e-03,9.403500e-03,7.547900e-03,4.789800e-03,2.939300e-03,&
     & 1.333000e-02,1.649800e-02,1.324800e-02,8.428100e-03,4.430500e-03,&
     & 7.880100e-04,9.628900e-04,7.669100e-04,4.909700e-04,6.885900e-04,&
     & 1.596600e-03,1.977700e-03,1.584000e-03,1.016400e-03,1.080300e-03,&
     & 3.111800e-03,3.947300e-03,3.193800e-03,2.034300e-03,1.662200e-03,&
     & 5.975200e-03,7.590700e-03,6.111900e-03,3.862500e-03,2.558300e-03,&
     & 1.090900e-02,1.369400e-02,1.099000e-02,6.963000e-03,3.898700e-03,&
     & 5.817300e-04,7.204100e-04,5.727900e-04,3.647400e-04,5.935500e-04,&
     & 1.225800e-03,1.524900e-03,1.214500e-03,7.724500e-04,9.545600e-04,&
     & 2.424100e-03,3.104400e-03,2.508700e-03,1.593400e-03,1.469700e-03,&
     & 4.751200e-03,6.135100e-03,4.958700e-03,3.124500e-03,2.263600e-03,&
     & 8.945100e-03,1.140400e-02,9.157000e-03,5.775200e-03,3.484400e-03,&
     & 5.052200e-04,6.304100e-04,4.992300e-04,3.152900e-04,5.758100e-04,&
     & 1.088500e-03,1.359500e-03,1.077500e-03,6.774200e-04,9.392900e-04,&
     & 2.175800e-03,2.792800e-03,2.248700e-03,1.418100e-03,1.451800e-03,&
     & 4.293300e-03,5.581300e-03,4.516600e-03,2.832000e-03,2.245600e-03,&
     & 8.180200e-03,1.052600e-02,8.459700e-03,5.317000e-03,3.484000e-03/
      data  absb(1:300,12) /                                            &
     & 7.922800e-01,6.773900e-01,5.985100e-01,4.775300e-01,2.763700e+00,&
     & 1.129800e+00,9.714600e-01,8.514800e-01,6.664200e-01,2.970100e+00,&
     & 1.531500e+00,1.328300e+00,1.158600e+00,8.931200e-01,3.218800e+00,&
     & 1.994400e+00,1.742200e+00,1.517400e+00,1.164100e+00,3.530200e+00,&
     & 2.508900e+00,2.205200e+00,1.917000e+00,1.474100e+00,3.862200e+00,&
     & 8.394900e-01,7.309300e-01,6.474600e-01,4.921500e-01,2.728900e+00,&
     & 1.183800e+00,1.039200e+00,9.153000e-01,6.859300e-01,2.937400e+00,&
     & 1.593600e+00,1.408000e+00,1.236200e+00,9.179200e-01,3.166100e+00,&
     & 2.061800e+00,1.831800e+00,1.600600e+00,1.195100e+00,3.413300e+00,&
     & 2.578200e+00,2.301600e+00,2.006700e+00,1.503200e+00,3.633000e+00,&
     & 8.685000e-01,7.781600e-01,6.898800e-01,5.114200e-01,2.483900e+00,&
     & 1.215200e+00,1.093800e+00,9.672700e-01,7.114500e-01,2.679400e+00,&
     & 1.623100e+00,1.468200e+00,1.291200e+00,9.540500e-01,2.863600e+00,&
     & 2.083300e+00,1.893300e+00,1.656200e+00,1.231500e+00,3.020300e+00,&
     & 2.590700e+00,2.366000e+00,2.069200e+00,1.540700e+00,3.195500e+00,&
     & 8.790300e-01,8.115400e-01,7.201700e-01,5.296600e-01,2.148700e+00,&
     & 1.219600e+00,1.129000e+00,9.986700e-01,7.358900e-01,2.297900e+00,&
     & 1.615800e+00,1.502000e+00,1.321500e+00,9.802800e-01,2.433200e+00,&
     & 2.060800e+00,1.925800e+00,1.688400e+00,1.254700e+00,2.577700e+00,&
     & 2.544400e+00,2.392200e+00,2.097900e+00,1.561300e+00,2.707300e+00,&
     & 8.679700e-01,8.265700e-01,7.333800e-01,5.382300e-01,1.845000e+00,&
     & 1.192900e+00,1.140700e+00,1.007400e+00,7.452500e-01,1.969100e+00,&
     & 1.569400e+00,1.505100e+00,1.327000e+00,9.853500e-01,2.090300e+00,&
     & 1.988600e+00,1.916500e+00,1.689600e+00,1.253300e+00,2.207100e+00,&
     & 2.452500e+00,2.361900e+00,2.084900e+00,1.552400e+00,2.322900e+00,&
     & 8.338500e-01,8.216800e-01,7.274900e-01,5.364900e-01,1.623400e+00,&
     & 1.138900e+00,1.123100e+00,9.930600e-01,7.363400e-01,1.730700e+00,&
     & 1.488700e+00,1.473900e+00,1.303400e+00,9.663500e-01,1.843500e+00,&
     & 1.881500e+00,1.863400e+00,1.652200e+00,1.225400e+00,1.948400e+00,&
     & 2.310600e+00,2.292000e+00,2.028500e+00,1.516200e+00,2.055100e+00,&
     & 7.853000e-01,7.967900e-01,7.052800e-01,5.226500e-01,1.453300e+00,&
     & 1.064400e+00,1.083000e+00,9.592000e-01,7.104500e-01,1.565100e+00,&
     & 1.385600e+00,1.408700e+00,1.254200e+00,9.267700e-01,1.674800e+00,&
     & 1.745200e+00,1.774500e+00,1.578200e+00,1.173700e+00,1.783900e+00,&
     & 2.139800e+00,2.179400e+00,1.937300e+00,1.455300e+00,1.902300e+00,&
     & 7.277800e-01,7.619400e-01,6.739000e-01,5.007700e-01,1.361700e+00,&
     & 9.806800e-01,1.026200e+00,9.124500e-01,6.749100e-01,1.480700e+00,&
     & 1.272200e+00,1.329300e+00,1.183100e+00,8.757400e-01,1.596600e+00,&
     & 1.599100e+00,1.671400e+00,1.485300e+00,1.109000e+00,1.716300e+00,&
     & 1.953500e+00,2.050000e+00,1.823100e+00,1.375400e+00,1.849400e+00,&
     & 6.650400e-01,7.137800e-01,6.330500e-01,4.700200e-01,1.294600e+00,&
     & 8.927800e-01,9.569300e-01,8.496700e-01,6.296000e-01,1.417000e+00,&
     & 1.155300e+00,1.238200e+00,1.096800e+00,8.159900e-01,1.540000e+00,&
     & 1.448200e+00,1.555100e+00,1.376100e+00,1.033000e+00,1.673700e+00,&
     & 1.763500e+00,1.898400e+00,1.692000e+00,1.278200e+00,1.814800e+00,&
     & 6.140900e-01,6.721000e-01,5.951700e-01,4.420500e-01,1.214000e+00,&
     & 8.200900e-01,8.969000e-01,7.913400e-01,5.890000e-01,1.338800e+00,&
     & 1.057300e+00,1.156200e+00,1.017000e+00,7.623900e-01,1.467400e+00,&
     & 1.317300e+00,1.444100e+00,1.277300e+00,9.611100e-01,1.610300e+00,&
     & 1.600800e+00,1.759300e+00,1.571400e+00,1.185900e+00,1.755400e+00,&
     & 5.648900e-01,6.264300e-01,5.518100e-01,4.105500e-01,1.129600e+00,&
     & 7.513600e-01,8.320500e-01,7.288200e-01,5.458700e-01,1.255600e+00,&
     & 9.614700e-01,1.067300e+00,9.362200e-01,7.047400e-01,1.393900e+00,&
     & 1.194500e+00,1.329200e+00,1.175800e+00,8.854000e-01,1.538000e+00,&
     & 1.449800e+00,1.620300e+00,1.444300e+00,1.089700e+00,1.687900e+00,&
     & 5.201900e-01,5.810800e-01,5.071400e-01,3.789400e-01,1.033500e+00,&
     & 6.867800e-01,7.675300e-01,6.683600e-01,5.026100e-01,1.162300e+00,&
     & 8.749000e-01,9.800000e-01,8.588800e-01,6.455900e-01,1.304700e+00,&
     & 1.085500e+00,1.219400e+00,1.075700e+00,8.102900e-01,1.451300e+00,&
     & 1.319500e+00,1.487500e+00,1.317600e+00,9.961700e-01,1.604200e+00/
      data  absb(301:600,12) /                                          &
     & 4.812500e-01,5.377600e-01,4.654300e-01,3.492000e-01,9.429600e-01,&
     & 6.306200e-01,7.067100e-01,6.137400e-01,4.602500e-01,1.078600e+00,&
     & 8.013800e-01,8.996100e-01,7.869000e-01,5.899900e-01,1.221900e+00,&
     & 9.950100e-01,1.120000e+00,9.813100e-01,7.397900e-01,1.374600e+00,&
     & 1.213300e+00,1.369000e+00,1.200200e+00,9.084800e-01,1.531000e+00,&
     & 4.471800e-01,5.004500e-01,4.302600e-01,3.219000e-01,8.740100e-01,&
     & 5.837700e-01,6.532900e-01,5.666900e-01,4.222200e-01,1.013200e+00,&
     & 7.422500e-01,8.312200e-01,7.214200e-01,5.409300e-01,1.159900e+00,&
     & 9.257600e-01,1.036300e+00,8.987500e-01,6.765100e-01,1.315000e+00,&
     & 1.135900e+00,1.268900e+00,1.100300e+00,8.312800e-01,1.472500e+00,&
     & 4.174200e-01,4.658900e-01,4.001400e-01,2.960700e-01,8.031100e-01,&
     & 5.453400e-01,6.069400e-01,5.225400e-01,3.881400e-01,9.374800e-01,&
     & 6.970500e-01,7.731700e-01,6.643200e-01,4.956600e-01,1.080800e+00,&
     & 8.742100e-01,9.658800e-01,8.281600e-01,6.191500e-01,1.227000e+00,&
     & 1.078300e+00,1.190000e+00,1.015100e+00,7.635600e-01,1.378100e+00,&
     & 3.923700e-01,4.351500e-01,3.724800e-01,2.730500e-01,7.228000e-01,&
     & 5.156300e-01,5.675700e-01,4.840300e-01,3.570000e-01,8.467700e-01,&
     & 6.630800e-01,7.251900e-01,6.159000e-01,4.547200e-01,9.771000e-01,&
     & 8.364600e-01,9.115200e-01,7.699700e-01,5.698800e-01,1.109600e+00,&
     & 1.035900e+00,1.127600e+00,9.496200e-01,7.052600e-01,1.248500e+00,&
     & 3.727900e-01,4.101400e-01,3.477400e-01,2.534100e-01,6.326900e-01,&
     & 4.928300e-01,5.376900e-01,4.523300e-01,3.302100e-01,7.429400e-01,&
     & 6.373100e-01,6.899400e-01,5.778000e-01,4.207000e-01,8.567800e-01,&
     & 8.063700e-01,8.702500e-01,7.264400e-01,5.290800e-01,9.759500e-01,&
     & 9.994300e-01,1.081300e+00,9.012800e-01,6.586600e-01,1.101900e+00,&
     & 3.572200e-01,3.908000e-01,3.271000e-01,2.360100e-01,5.403700e-01,&
     & 4.744800e-01,5.142900e-01,4.278300e-01,3.071600e-01,6.350300e-01,&
     & 6.143900e-01,6.630800e-01,5.492000e-01,3.934500e-01,7.338100e-01,&
     & 7.764400e-01,8.406200e-01,6.935000e-01,4.978200e-01,8.401000e-01,&
     & 9.622600e-01,1.047800e+00,8.646800e-01,6.225600e-01,9.539800e-01,&
     & 3.449800e-01,3.754500e-01,3.115000e-01,2.212200e-01,4.490500e-01,&
     & 4.582000e-01,4.965300e-01,4.098300e-01,2.888800e-01,5.291700e-01,&
     & 5.917000e-01,6.437800e-01,5.281000e-01,3.728400e-01,6.159000e-01,&
     & 7.478700e-01,8.183500e-01,6.706400e-01,4.744800e-01,7.095300e-01,&
     & 9.277600e-01,1.023800e+00,8.402000e-01,5.954000e-01,8.085000e-01,&
     & 3.338700e-01,3.639700e-01,2.997900e-01,2.096200e-01,3.730700e-01,&
     & 4.416300e-01,4.836300e-01,3.960700e-01,2.759400e-01,4.421600e-01,&
     & 5.701500e-01,6.287600e-01,5.136300e-01,3.576500e-01,5.178800e-01,&
     & 7.214100e-01,8.015100e-01,6.551700e-01,4.571700e-01,6.001600e-01,&
     & 8.992200e-01,1.006200e+00,8.240700e-01,5.745900e-01,6.853600e-01,&
     & 3.229300e-01,3.554700e-01,2.909300e-01,2.014900e-01,3.091700e-01,&
     & 4.262700e-01,4.735500e-01,3.861900e-01,2.664000e-01,3.692000e-01,&
     & 5.505800e-01,6.166500e-01,5.034600e-01,3.467900e-01,4.350500e-01,&
     & 6.998000e-01,7.885200e-01,6.447500e-01,4.444200e-01,5.048800e-01,&
     & 8.759200e-01,9.939000e-01,8.149600e-01,5.602900e-01,5.774600e-01,&
     & 3.094000e-01,3.452800e-01,2.815600e-01,1.936300e-01,2.661100e-01,&
     & 4.089400e-01,4.607400e-01,3.756500e-01,2.576300e-01,3.193800e-01,&
     & 5.304100e-01,6.025100e-01,4.918500e-01,3.367900e-01,3.776200e-01,&
     & 6.778600e-01,7.735000e-01,6.339900e-01,4.327600e-01,4.388000e-01,&
     & 8.521600e-01,9.805000e-01,8.044300e-01,5.475800e-01,5.038400e-01,&
     & 2.893900e-01,3.270200e-01,2.662200e-01,1.824900e-01,2.242600e-01,&
     & 3.843200e-01,4.386000e-01,3.576800e-01,2.446100e-01,2.704400e-01,&
     & 5.022700e-01,5.768700e-01,4.713300e-01,3.215600e-01,3.204700e-01,&
     & 6.452200e-01,7.463000e-01,6.120200e-01,4.151600e-01,3.735600e-01,&
     & 8.162300e-01,9.532500e-01,7.816300e-01,5.282100e-01,4.327200e-01,&
     & 2.633000e-01,3.007000e-01,2.444200e-01,1.675700e-01,1.831000e-01,&
     & 3.525500e-01,4.066700e-01,3.314400e-01,2.264400e-01,2.220000e-01,&
     & 4.646800e-01,5.394800e-01,4.411000e-01,3.001200e-01,2.641200e-01,&
     & 6.015500e-01,7.048600e-01,5.778300e-01,3.905800e-01,3.100200e-01,&
     & 7.670300e-01,9.087300e-01,7.445700e-01,5.006000e-01,3.639500e-01/
      data  absb(601:900,12) /                                          &
     & 2.300100e-01,2.644200e-01,2.145900e-01,1.472700e-01,1.553600e-01,&
     & 3.109600e-01,3.619700e-01,2.946100e-01,2.012900e-01,1.900400e-01,&
     & 4.143100e-01,4.858900e-01,3.970000e-01,2.700000e-01,2.280000e-01,&
     & 5.422600e-01,6.426600e-01,5.266500e-01,3.552400e-01,2.691000e-01,&
     & 6.984100e-01,8.379700e-01,6.866300e-01,4.596300e-01,3.177400e-01,&
     & 2.013400e-01,2.322700e-01,1.881400e-01,1.293500e-01,1.313700e-01,&
     & 2.746800e-01,3.220800e-01,2.617400e-01,1.789100e-01,1.621700e-01,&
     & 3.695600e-01,4.377600e-01,3.573300e-01,2.428900e-01,1.962300e-01,&
     & 4.889600e-01,5.864000e-01,4.800200e-01,3.234900e-01,2.330000e-01,&
     & 6.366600e-01,7.734600e-01,6.338000e-01,4.228600e-01,2.766300e-01,&
     & 1.769700e-01,2.046700e-01,1.654000e-01,1.138600e-01,1.100700e-01,&
     & 2.436800e-01,2.873500e-01,2.331900e-01,1.594700e-01,1.371900e-01,&
     & 3.309200e-01,3.958000e-01,3.226800e-01,2.191800e-01,1.672000e-01,&
     & 4.424900e-01,5.369900e-01,4.391400e-01,2.955200e-01,1.998700e-01,&
     & 5.822600e-01,7.160000e-01,5.870900e-01,3.905800e-01,2.387900e-01,&
     & 1.508400e-01,1.744900e-01,1.404500e-01,9.679400e-02,9.339200e-02,&
     & 2.101000e-01,2.482200e-01,2.009700e-01,1.376600e-01,1.176700e-01,&
     & 2.883500e-01,3.471600e-01,2.824800e-01,1.919700e-01,1.449500e-01,&
     & 3.898800e-01,4.778900e-01,3.903700e-01,2.626100e-01,1.746800e-01,&
     & 5.194500e-01,6.458600e-01,5.290300e-01,3.516200e-01,2.097500e-01,&
     & 1.281700e-01,1.482900e-01,1.188700e-01,8.184000e-02,7.905700e-02,&
     & 1.806000e-01,2.136200e-01,1.724700e-01,1.183000e-01,1.008100e-01,&
     & 2.508000e-01,3.033400e-01,2.463400e-01,1.675300e-01,1.254800e-01,&
     & 3.428000e-01,4.237600e-01,3.458600e-01,2.325100e-01,1.525600e-01,&
     & 4.623000e-01,5.807000e-01,4.751800e-01,3.157200e-01,1.843100e-01,&
     & 1.089300e-01,1.261300e-01,1.008300e-01,6.915700e-02,6.639400e-02,&
     & 1.554700e-01,1.841500e-01,1.480300e-01,1.016100e-01,8.577700e-02,&
     & 2.184600e-01,2.650200e-01,2.148600e-01,1.462700e-01,1.079400e-01,&
     & 3.019800e-01,3.758700e-01,3.063800e-01,2.058300e-01,1.324700e-01,&
     & 4.119900e-01,5.222500e-01,4.270900e-01,2.835100e-01,1.611100e-01,&
     & 9.063800e-02,1.050300e-01,8.379500e-02,5.707100e-02,5.535400e-02,&
     & 1.313100e-01,1.554800e-01,1.245800e-01,8.536400e-02,7.257600e-02,&
     & 1.868100e-01,2.270700e-01,1.834700e-01,1.250100e-01,9.253800e-02,&
     & 2.616000e-01,3.267200e-01,2.659500e-01,1.787600e-01,1.150000e-01,&
     & 3.612000e-01,4.609700e-01,3.766900e-01,2.499900e-01,1.407500e-01,&
     & 7.451800e-02,8.640900e-02,6.895200e-02,4.657700e-02,4.578700e-02,&
     & 1.097500e-01,1.299400e-01,1.038500e-01,7.083500e-02,6.097600e-02,&
     & 1.582800e-01,1.925000e-01,1.550600e-01,1.055800e-01,7.893600e-02,&
     & 2.247100e-01,2.809800e-01,2.282100e-01,1.536500e-01,9.946000e-02,&
     & 3.140600e-01,4.026900e-01,3.287100e-01,2.181300e-01,1.227600e-01,&
     & 6.092700e-02,7.088800e-02,5.660400e-02,3.800700e-02,3.745100e-02,&
     & 9.156200e-02,1.084800e-01,8.656300e-02,5.863800e-02,5.073900e-02,&
     & 1.340100e-01,1.630500e-01,1.309300e-01,8.890900e-02,6.664500e-02,&
     & 1.927800e-01,2.413200e-01,1.953800e-01,1.317100e-01,8.519500e-02,&
     & 2.730100e-01,3.508700e-01,2.859900e-01,1.899400e-01,1.062700e-01,&
     & 4.904900e-02,5.739000e-02,4.584100e-02,3.065200e-02,3.024400e-02,&
     & 7.539500e-02,8.954400e-02,7.147900e-02,4.801600e-02,4.181200e-02,&
     & 1.124300e-01,1.367300e-01,1.094000e-01,7.399200e-02,5.580200e-02,&
     & 1.638500e-01,2.051500e-01,1.655400e-01,1.116300e-01,7.238400e-02,&
     & 2.353500e-01,3.022800e-01,2.459600e-01,1.635900e-01,9.135000e-02,&
     & 3.845500e-02,4.531100e-02,3.619100e-02,2.409900e-02,2.418000e-02,&
     & 6.054300e-02,7.221900e-02,5.775200e-02,3.850100e-02,3.415300e-02,&
     & 9.246900e-02,1.122900e-01,8.964900e-02,6.032600e-02,4.644800e-02,&
     & 1.368900e-01,1.710200e-01,1.375000e-01,9.254700e-02,6.121400e-02,&
     & 1.992700e-01,2.553500e-01,2.070400e-01,1.381800e-01,7.842500e-02,&
     & 2.990700e-02,3.553800e-02,2.834900e-02,1.878100e-02,1.905400e-02,&
     & 4.822800e-02,5.790400e-02,4.634500e-02,3.076400e-02,2.746600e-02,&
     & 7.547000e-02,9.180600e-02,7.331700e-02,4.899500e-02,3.815100e-02,&
     & 1.140600e-01,1.420400e-01,1.138300e-01,7.634300e-02,5.117200e-02,&
     & 1.682200e-01,2.149700e-01,1.737200e-01,1.160700e-01,6.662900e-02/
      data  absb(901:1175,12) /                                         &
     & 2.308400e-02,2.760200e-02,2.204300e-02,1.451500e-02,1.470000e-02,&
     & 3.813400e-02,4.613800e-02,3.693200e-02,2.442200e-02,2.169600e-02,&
     & 6.105300e-02,7.469100e-02,5.974300e-02,3.961800e-02,3.078400e-02,&
     & 9.462400e-02,1.174700e-01,9.390600e-02,6.271700e-02,4.205700e-02,&
     & 1.416200e-01,1.803100e-01,1.452000e-01,9.695100e-02,5.566500e-02,&
     & 1.788000e-02,2.152200e-02,1.719300e-02,1.128100e-02,1.156300e-02,&
     & 3.030400e-02,3.698800e-02,2.959400e-02,1.948900e-02,1.751100e-02,&
     & 4.962000e-02,6.113000e-02,4.899000e-02,3.231300e-02,2.534500e-02,&
     & 7.879400e-02,9.781300e-02,7.819800e-02,5.194300e-02,3.529800e-02,&
     & 1.201000e-01,1.522700e-01,1.222900e-01,8.143800e-02,4.746200e-02,&
     & 1.377800e-02,1.675300e-02,1.336600e-02,8.758700e-03,9.169100e-03,&
     & 2.406800e-02,2.959800e-02,2.372000e-02,1.553100e-02,1.424100e-02,&
     & 4.031900e-02,5.002300e-02,4.014600e-02,2.637900e-02,2.104100e-02,&
     & 6.544400e-02,8.155900e-02,6.527400e-02,4.310700e-02,2.980800e-02,&
     & 1.019300e-01,1.287800e-01,1.031600e-01,6.848500e-02,4.076400e-02,&
     & 1.050300e-02,1.290800e-02,1.029600e-02,6.739100e-03,7.163200e-03,&
     & 1.896300e-02,2.351400e-02,1.886300e-02,1.229200e-02,1.141600e-02,&
     & 3.257400e-02,4.076300e-02,3.269200e-02,2.141300e-02,1.723200e-02,&
     & 5.401500e-02,6.772500e-02,5.429700e-02,3.564800e-02,2.488000e-02,&
     & 8.614200e-02,1.085000e-01,8.678300e-02,5.741200e-02,3.460400e-02,&
     & 7.903400e-03,9.823900e-03,7.836900e-03,5.124800e-03,5.484300e-03,&
     & 1.479200e-02,1.852600e-02,1.484700e-02,9.658500e-03,8.979800e-03,&
     & 2.614500e-02,3.297600e-02,2.645400e-02,1.726000e-02,1.388000e-02,&
     & 4.432400e-02,5.590000e-02,4.489400e-02,2.934500e-02,2.045000e-02,&
     & 7.225900e-02,9.103100e-02,7.283600e-02,4.796400e-02,2.889900e-02,&
     & 6.003000e-03,7.534300e-03,6.020600e-03,3.926900e-03,4.437400e-03,&
     & 1.162600e-02,1.474600e-02,1.180100e-02,7.673300e-03,7.464400e-03,&
     & 2.120400e-02,2.693200e-02,2.163900e-02,1.405800e-02,1.182000e-02,&
     & 3.673400e-02,4.663000e-02,3.747300e-02,2.439900e-02,1.774600e-02,&
     & 6.104800e-02,7.717600e-02,6.183900e-02,4.051700e-02,2.547400e-02,&
     & 4.563000e-03,5.768100e-03,4.620500e-03,3.000200e-03,3.704500e-03,&
     & 9.127300e-03,1.172800e-02,9.395600e-03,6.094500e-03,6.407700e-03,&
     & 1.719100e-02,2.203900e-02,1.771100e-02,1.146900e-02,1.039000e-02,&
     & 3.051700e-02,3.900900e-02,3.132100e-02,2.035000e-02,1.590900e-02,&
     & 5.168000e-02,6.561800e-02,5.264900e-02,3.434500e-02,2.323100e-02,&
     & 3.442900e-03,4.369300e-03,3.510200e-03,2.266400e-03,3.097200e-03,&
     & 7.106700e-03,9.241200e-03,7.410600e-03,4.801000e-03,5.493800e-03,&
     & 1.383800e-02,1.792600e-02,1.439300e-02,9.310200e-03,9.116700e-03,&
     & 2.522600e-02,3.247000e-02,2.606700e-02,1.689000e-02,1.425300e-02,&
     & 4.355500e-02,5.555900e-02,4.463900e-02,2.900800e-02,2.119400e-02,&
     & 2.583500e-03,3.279200e-03,2.634000e-03,1.692800e-03,2.597900e-03,&
     & 5.481800e-03,7.201800e-03,5.786000e-03,3.739900e-03,4.693800e-03,&
     & 1.104500e-02,1.447700e-02,1.161500e-02,7.507100e-03,7.988000e-03,&
     & 2.073400e-02,2.685500e-02,2.158400e-02,1.393900e-02,1.277100e-02,&
     & 3.653100e-02,4.683400e-02,3.764100e-02,2.439100e-02,1.932800e-02,&
     & 1.955400e-03,2.480500e-03,1.981500e-03,1.267500e-03,2.231100e-03,&
     & 4.240600e-03,5.619400e-03,4.525100e-03,2.914200e-03,4.075100e-03,&
     & 8.825300e-03,1.171500e-02,9.404900e-03,6.068700e-03,7.108200e-03,&
     & 1.708100e-02,2.229400e-02,1.792100e-02,1.154200e-02,1.160100e-02,&
     & 3.076800e-02,3.966100e-02,3.185300e-02,2.059900e-02,1.786000e-02,&
     & 1.731100e-03,2.195000e-03,1.746400e-03,1.109500e-03,2.281000e-03,&
     & 3.786700e-03,5.037500e-03,4.062200e-03,2.605000e-03,4.222900e-03,&
     & 7.992700e-03,1.069100e-02,8.587200e-03,5.533000e-03,7.463700e-03,&
     & 1.570600e-02,2.060300e-02,1.655900e-02,1.065300e-02,1.233800e-02,&
     & 2.861400e-02,3.699500e-02,2.970300e-02,1.919100e-02,1.917800e-02/
      data  absb(1:300,13) /                                            &
     & 1.285200e+00,1.064300e+00,9.242300e-01,7.721000e-01,4.856000e+00,&
     & 1.830000e+00,1.515300e+00,1.305600e+00,1.089600e+00,5.176200e+00,&
     & 2.489800e+00,2.061900e+00,1.778100e+00,1.472000e+00,5.599500e+00,&
     & 3.258000e+00,2.713600e+00,2.337900e+00,1.910300e+00,6.000600e+00,&
     & 4.134400e+00,3.474100e+00,2.982600e+00,2.398600e+00,6.325400e+00,&
     & 1.435300e+00,1.181300e+00,1.009700e+00,8.176600e-01,4.436400e+00,&
     & 2.032000e+00,1.676600e+00,1.421700e+00,1.147600e+00,4.777700e+00,&
     & 2.739700e+00,2.276600e+00,1.916400e+00,1.540400e+00,5.195600e+00,&
     & 3.552500e+00,2.977400e+00,2.503800e+00,1.989800e+00,5.557900e+00,&
     & 4.458300e+00,3.778400e+00,3.176700e+00,2.509800e+00,5.895400e+00,&
     & 1.578500e+00,1.306700e+00,1.109700e+00,8.667400e-01,3.849200e+00,&
     & 2.212500e+00,1.843400e+00,1.556300e+00,1.205000e+00,4.196800e+00,&
     & 2.959500e+00,2.484400e+00,2.088900e+00,1.606800e+00,4.545300e+00,&
     & 3.804500e+00,3.225900e+00,2.708800e+00,2.075700e+00,4.894500e+00,&
     & 4.732400e+00,4.053000e+00,3.402400e+00,2.620100e+00,5.130800e+00,&
     & 1.699000e+00,1.427000e+00,1.219700e+00,9.154000e-01,3.296700e+00,&
     & 2.363200e+00,1.996500e+00,1.699100e+00,1.263500e+00,3.599200e+00,&
     & 3.133200e+00,2.673700e+00,2.266200e+00,1.679700e+00,3.882500e+00,&
     & 3.995400e+00,3.441300e+00,2.915000e+00,2.173200e+00,4.095500e+00,&
     & 4.944100e+00,4.281300e+00,3.629600e+00,2.734700e+00,4.335600e+00,&
     & 1.786700e+00,1.529100e+00,1.317200e+00,9.644200e-01,2.894600e+00,&
     & 2.463000e+00,2.124000e+00,1.819700e+00,1.327100e+00,3.120900e+00,&
     & 3.241200e+00,2.820500e+00,2.412000e+00,1.762100e+00,3.323100e+00,&
     & 4.112900e+00,3.602600e+00,3.078500e+00,2.275200e+00,3.546700e+00,&
     & 5.051800e+00,4.457500e+00,3.817400e+00,2.844400e+00,3.786900e+00,&
     & 1.839500e+00,1.613200e+00,1.396100e+00,1.012100e+00,2.625500e+00,&
     & 2.510600e+00,2.221100e+00,1.917900e+00,1.391800e+00,2.807400e+00,&
     & 3.284000e+00,2.923000e+00,2.521600e+00,1.845500e+00,2.988600e+00,&
     & 4.139800e+00,3.707600e+00,3.199500e+00,2.365500e+00,3.203300e+00,&
     & 5.065200e+00,4.568100e+00,3.958600e+00,2.947000e+00,3.443100e+00,&
     & 1.842900e+00,1.670000e+00,1.453600e+00,1.056400e+00,2.457700e+00,&
     & 2.502200e+00,2.278400e+00,1.983300e+00,1.449200e+00,2.609300e+00,&
     & 3.252000e+00,2.980500e+00,2.589400e+00,1.914000e+00,2.786000e+00,&
     & 4.080700e+00,3.764800e+00,3.279200e+00,2.435400e+00,2.980400e+00,&
     & 4.968000e+00,4.622400e+00,4.039500e+00,3.022400e+00,3.217500e+00,&
     & 1.822800e+00,1.702500e+00,1.492800e+00,1.089800e+00,2.365400e+00,&
     & 2.453800e+00,2.305100e+00,2.020400e+00,1.489700e+00,2.521700e+00,&
     & 3.169900e+00,2.997100e+00,2.632000e+00,1.952400e+00,2.699900e+00,&
     & 3.955400e+00,3.771000e+00,3.317500e+00,2.472500e+00,2.891100e+00,&
     & 4.806300e+00,4.609400e+00,4.074100e+00,3.059000e+00,3.123200e+00,&
     & 1.762300e+00,1.706100e+00,1.500600e+00,1.105100e+00,2.298700e+00,&
     & 2.356800e+00,2.293800e+00,2.024100e+00,1.500500e+00,2.481000e+00,&
     & 3.026400e+00,2.966300e+00,2.625200e+00,1.954000e+00,2.670900e+00,&
     & 3.766100e+00,3.711400e+00,3.301700e+00,2.466000e+00,2.873900e+00,&
     & 4.570900e+00,4.529200e+00,4.035300e+00,3.045800e+00,3.112200e+00,&
     & 1.705100e+00,1.710500e+00,1.513700e+00,1.122000e+00,2.221500e+00,&
     & 2.259400e+00,2.281200e+00,2.026500e+00,1.507800e+00,2.427300e+00,&
     & 2.884300e+00,2.929800e+00,2.615900e+00,1.949700e+00,2.634400e+00,&
     & 3.578400e+00,3.653000e+00,3.269900e+00,2.453200e+00,2.857100e+00,&
     & 4.328200e+00,4.441300e+00,3.981700e+00,3.026300e+00,3.113800e+00,&
     & 1.622700e+00,1.686500e+00,1.498700e+00,1.116400e+00,2.151600e+00,&
     & 2.133400e+00,2.231100e+00,1.994700e+00,1.486500e+00,2.371400e+00,&
     & 2.713000e+00,2.850500e+00,2.560100e+00,1.913100e+00,2.595700e+00,&
     & 3.354500e+00,3.541700e+00,3.184500e+00,2.407000e+00,2.842300e+00,&
     & 4.051100e+00,4.298000e+00,3.882400e+00,2.966300e+00,3.109700e+00,&
     & 1.522100e+00,1.639900e+00,1.463100e+00,1.092200e+00,2.055700e+00,&
     & 1.990900e+00,2.155100e+00,1.933300e+00,1.443800e+00,2.289300e+00,&
     & 2.522700e+00,2.742400e+00,2.467000e+00,1.856000e+00,2.530800e+00,&
     & 3.113200e+00,3.399800e+00,3.069000e+00,2.331500e+00,2.795900e+00,&
     & 3.762500e+00,4.127500e+00,3.750200e+00,2.872600e+00,3.071100e+00/
      data  absb(301:600,13) /                                          &
     & 1.416400e+00,1.576400e+00,1.412000e+00,1.053900e+00,1.971000e+00,&
     & 1.845100e+00,2.062300e+00,1.852300e+00,1.388900e+00,2.211700e+00,&
     & 2.332300e+00,2.617000e+00,2.356000e+00,1.781300e+00,2.470200e+00,&
     & 2.878500e+00,3.242300e+00,2.935300e+00,2.237900e+00,2.741500e+00,&
     & 3.474800e+00,3.938600e+00,3.595800e+00,2.756600e+00,3.024600e+00,&
     & 1.317400e+00,1.506500e+00,1.350500e+00,1.010800e+00,1.909200e+00,&
     & 1.710000e+00,1.965600e+00,1.761400e+00,1.327300e+00,2.156800e+00,&
     & 2.159900e+00,2.491800e+00,2.242400e+00,1.702200e+00,2.425100e+00,&
     & 2.661900e+00,3.086300e+00,2.800700e+00,2.136800e+00,2.697400e+00,&
     & 3.216400e+00,3.756200e+00,3.438200e+00,2.632300e+00,2.989700e+00,&
     & 1.222700e+00,1.431800e+00,1.277600e+00,9.623400e-01,1.808400e+00,&
     & 1.584500e+00,1.865000e+00,1.666900e+00,1.261600e+00,2.060600e+00,&
     & 1.998600e+00,2.363700e+00,2.125500e+00,1.618000e+00,2.323500e+00,&
     & 2.467000e+00,2.933500e+00,2.660600e+00,2.030600e+00,2.597900e+00,&
     & 2.983600e+00,3.581200e+00,3.279900e+00,2.504700e+00,2.894000e+00,&
     & 1.138200e+00,1.356900e+00,1.204700e+00,9.105000e-01,1.675600e+00,&
     & 1.473100e+00,1.765800e+00,1.574700e+00,1.195900e+00,1.925900e+00,&
     & 1.859500e+00,2.241700e+00,2.013600e+00,1.532300e+00,2.179700e+00,&
     & 2.293300e+00,2.793000e+00,2.530400e+00,1.926600e+00,2.458100e+00,&
     & 2.779200e+00,3.430300e+00,3.128800e+00,2.384600e+00,2.756900e+00,&
     & 1.069000e+00,1.288100e+00,1.139400e+00,8.619600e-01,1.531600e+00,&
     & 1.383300e+00,1.676700e+00,1.490900e+00,1.133000e+00,1.763600e+00,&
     & 1.741800e+00,2.137300e+00,1.915200e+00,1.452900e+00,2.007900e+00,&
     & 2.152000e+00,2.679600e+00,2.415800e+00,1.832700e+00,2.275200e+00,&
     & 2.619800e+00,3.304500e+00,3.000000e+00,2.277100e+00,2.561600e+00,&
     & 1.012700e+00,1.226600e+00,1.079700e+00,8.186300e-01,1.372400e+00,&
     & 1.306900e+00,1.601500e+00,1.418500e+00,1.074500e+00,1.582900e+00,&
     & 1.648700e+00,2.052200e+00,1.830200e+00,1.382000e+00,1.815300e+00,&
     & 2.047300e+00,2.584300e+00,2.320900e+00,1.751500e+00,2.065900e+00,&
     & 2.509200e+00,3.202300e+00,2.896900e+00,2.188800e+00,2.337400e+00,&
     & 9.651000e-01,1.179400e+00,1.030800e+00,7.785600e-01,1.191800e+00,&
     & 1.247700e+00,1.545700e+00,1.361900e+00,1.025200e+00,1.381700e+00,&
     & 1.583700e+00,1.988500e+00,1.765200e+00,1.324800e+00,1.591400e+00,&
     & 1.979700e+00,2.515900e+00,2.249600e+00,1.688000e+00,1.816900e+00,&
     & 2.439700e+00,3.133300e+00,2.824300e+00,2.125300e+00,2.069100e+00,&
     & 9.280900e-01,1.146200e+00,9.962800e-01,7.453600e-01,1.032000e+00,&
     & 1.207100e+00,1.506900e+00,1.320500e+00,9.859700e-01,1.203300e+00,&
     & 1.543200e+00,1.947600e+00,1.719100e+00,1.283500e+00,1.389700e+00,&
     & 1.940600e+00,2.476600e+00,2.203800e+00,1.645800e+00,1.597100e+00,&
     & 2.399400e+00,3.098400e+00,2.784400e+00,2.089200e+00,1.836400e+00,&
     & 9.045200e-01,1.125800e+00,9.732100e-01,7.200200e-01,8.856200e-01,&
     & 1.184600e+00,1.486400e+00,1.294100e+00,9.587600e-01,1.037100e+00,&
     & 1.521400e+00,1.931100e+00,1.693700e+00,1.257200e+00,1.204600e+00,&
     & 1.919600e+00,2.465700e+00,2.185800e+00,1.623900e+00,1.397700e+00,&
     & 2.383600e+00,3.100700e+00,2.776800e+00,2.078100e+00,1.627300e+00,&
     & 8.846700e-01,1.106800e+00,9.505400e-01,6.962900e-01,7.849400e-01,&
     & 1.164200e+00,1.470600e+00,1.271700e+00,9.347000e-01,9.213800e-01,&
     & 1.501500e+00,1.918100e+00,1.675800e+00,1.234500e+00,1.077300e+00,&
     & 1.901800e+00,2.463200e+00,2.175900e+00,1.608000e+00,1.261400e+00,&
     & 2.374000e+00,3.114500e+00,2.782100e+00,2.071200e+00,1.479200e+00,&
     & 8.495500e-01,1.068800e+00,9.123100e-01,6.620200e-01,6.782400e-01,&
     & 1.125000e+00,1.431300e+00,1.230300e+00,8.969800e-01,8.019300e-01,&
     & 1.459900e+00,1.879100e+00,1.634700e+00,1.194500e+00,9.477100e-01,&
     & 1.861700e+00,2.428900e+00,2.138200e+00,1.570300e+00,1.123900e+00,&
     & 2.337100e+00,3.088600e+00,2.750300e+00,2.037000e+00,1.325800e+00,&
     & 7.955400e-01,1.008600e+00,8.557300e-01,6.148500e-01,5.702700e-01,&
     & 1.064200e+00,1.363400e+00,1.165200e+00,8.419700e-01,6.837800e-01,&
     & 1.392400e+00,1.804900e+00,1.563400e+00,1.132600e+00,8.221800e-01,&
     & 1.790000e+00,2.351200e+00,2.060700e+00,1.502600e+00,9.885900e-01,&
     & 2.263000e+00,3.006500e+00,2.668700e+00,1.964000e+00,1.176200e+00/
      data  absb(601:900,13) /                                          &
     & 7.141700e-01,9.130900e-01,7.708900e-01,5.480300e-01,4.962200e-01,&
     & 9.691300e-01,1.251200e+00,1.063000e+00,7.604300e-01,5.979700e-01,&
     & 1.284000e+00,1.674600e+00,1.441600e+00,1.035300e+00,7.223300e-01,&
     & 1.667800e+00,2.200800e+00,1.918700e+00,1.387500e+00,8.730400e-01,&
     & 2.127100e+00,2.838000e+00,2.506200e+00,1.831400e+00,1.044400e+00,&
     & 6.409400e-01,8.276800e-01,6.964500e-01,4.897200e-01,4.278200e-01,&
     & 8.826800e-01,1.149900e+00,9.725200e-01,6.890100e-01,5.181700e-01,&
     & 1.185400e+00,1.556700e+00,1.332600e+00,9.487500e-01,6.291100e-01,&
     & 1.554800e+00,2.063300e+00,1.790300e+00,1.284600e+00,7.640400e-01,&
     & 2.000500e+00,2.681900e+00,2.357700e+00,1.710800e+00,9.191000e-01,&
     & 5.770000e-01,7.534800e-01,6.323400e-01,4.403900e-01,3.631600e-01,&
     & 8.061700e-01,1.060700e+00,8.946400e-01,6.278700e-01,4.425600e-01,&
     & 1.097100e+00,1.452800e+00,1.237100e+00,8.738100e-01,5.406300e-01,&
     & 1.453900e+00,1.940900e+00,1.676800e+00,1.194600e+00,6.603400e-01,&
     & 1.888000e+00,2.541900e+00,2.224400e+00,1.603900e+00,7.989000e-01,&
     & 5.018600e-01,6.629400e-01,5.550000e-01,3.828900e-01,3.176900e-01,&
     & 7.132300e-01,9.479800e-01,7.975200e-01,5.538400e-01,3.887700e-01,&
     & 9.858600e-01,1.316400e+00,1.115700e+00,7.813600e-01,4.761800e-01,&
     & 1.325800e+00,1.778100e+00,1.526900e+00,1.079500e+00,5.846200e-01,&
     & 1.739700e+00,2.349600e+00,2.044700e+00,1.464000e+00,7.118300e-01,&
     & 4.338000e-01,5.809700e-01,4.847600e-01,3.318600e-01,2.776200e-01,&
     & 6.281900e-01,8.437500e-01,7.079800e-01,4.871800e-01,3.415100e-01,&
     & 8.823100e-01,1.188500e+00,1.003000e+00,6.967600e-01,4.194400e-01,&
     & 1.204400e+00,1.623900e+00,1.386200e+00,9.729200e-01,5.173700e-01,&
     & 1.597600e+00,2.164400e+00,1.873300e+00,1.332400e+00,6.338200e-01,&
     & 3.744900e-01,5.089800e-01,4.233700e-01,2.878800e-01,2.407000e-01,&
     & 5.527000e-01,7.503800e-01,6.283600e-01,4.289200e-01,2.975300e-01,&
     & 7.890600e-01,1.072200e+00,9.020300e-01,6.217200e-01,3.669900e-01,&
     & 1.092800e+00,1.482400e+00,1.259100e+00,8.775000e-01,4.548600e-01,&
     & 1.467000e+00,1.993100e+00,1.716500e+00,1.213000e+00,5.605100e-01,&
     & 3.153500e-01,4.348100e-01,3.605700e-01,2.436700e-01,2.082500e-01,&
     & 4.750300e-01,6.526200e-01,5.449400e-01,3.694300e-01,2.584100e-01,&
     & 6.911900e-01,9.473300e-01,7.947500e-01,5.432400e-01,3.195200e-01,&
     & 9.728300e-01,1.327900e+00,1.122300e+00,7.767400e-01,3.965200e-01,&
     & 1.324300e+00,1.805000e+00,1.545000e+00,1.084900e+00,4.908700e-01,&
     & 2.617400e-01,3.659000e-01,3.026300e-01,2.034400e-01,1.793800e-01,&
     & 4.027700e-01,5.605600e-01,4.666200e-01,3.144200e-01,2.233800e-01,&
     & 5.977700e-01,8.270400e-01,6.919000e-01,4.696100e-01,2.769700e-01,&
     & 8.558400e-01,1.177000e+00,9.905900e-01,6.804100e-01,3.432300e-01,&
     & 1.183900e+00,1.618900e+00,1.377900e+00,9.603700e-01,4.259700e-01,&
     & 2.165100e-01,3.062300e-01,2.530300e-01,1.690900e-01,1.528600e-01,&
     & 3.399800e-01,4.794400e-01,3.979900e-01,2.666500e-01,1.913800e-01,&
     & 5.150500e-01,7.191500e-01,6.004700e-01,4.050100e-01,2.380400e-01,&
     & 7.506900e-01,1.039200e+00,8.723300e-01,5.947700e-01,2.947200e-01,&
     & 1.054600e+00,1.448200e+00,1.226500e+00,8.485300e-01,3.658900e-01,&
     & 1.766300e-01,2.519800e-01,2.082100e-01,1.385200e-01,1.292000e-01,&
     & 2.831200e-01,4.039200e-01,3.345400e-01,2.229700e-01,1.631500e-01,&
     & 4.378700e-01,6.174600e-01,5.142100e-01,3.450600e-01,2.032900e-01,&
     & 6.504000e-01,9.065800e-01,7.588900e-01,5.140800e-01,2.518800e-01,&
     & 9.287800e-01,1.282100e+00,1.080800e+00,7.427400e-01,3.124000e-01,&
     & 1.404400e-01,2.012800e-01,1.662100e-01,1.105100e-01,1.089700e-01,&
     & 2.300400e-01,3.315400e-01,2.741900e-01,1.818000e-01,1.396200e-01,&
     & 3.632500e-01,5.182100e-01,4.303400e-01,2.872800e-01,1.743100e-01,&
     & 5.511700e-01,7.748300e-01,6.467300e-01,4.355400e-01,2.165400e-01,&
     & 8.020000e-01,1.113900e+00,9.356100e-01,6.379900e-01,2.678200e-01,&
     & 1.110100e-01,1.592700e-01,1.313900e-01,8.752700e-02,9.020100e-02,&
     & 1.856700e-01,2.696800e-01,2.227000e-01,1.471000e-01,1.176400e-01,&
     & 2.993300e-01,4.315900e-01,3.575300e-01,2.373000e-01,1.481100e-01,&
     & 4.636900e-01,6.579700e-01,5.478900e-01,3.670600e-01,1.840200e-01,&
     & 6.880700e-01,9.621400e-01,8.057700e-01,5.457000e-01,2.276100e-01/
      data  absb(901:1175,13) /                                         &
     & 8.695200e-02,1.248100e-01,1.027000e-01,6.873500e-02,7.291600e-02,&
     & 1.488600e-01,2.171800e-01,1.793400e-01,1.182900e-01,9.683000e-02,&
     & 2.450700e-01,3.565700e-01,2.949600e-01,1.948100e-01,1.238400e-01,&
     & 3.872200e-01,5.551800e-01,4.610900e-01,3.074400e-01,1.541300e-01,&
     & 5.863100e-01,8.260200e-01,6.896800e-01,4.644000e-01,1.905800e-01,&
     & 6.842300e-02,9.836200e-02,8.081300e-02,5.431800e-02,6.064000e-02,&
     & 1.202400e-01,1.756000e-01,1.448700e-01,9.571300e-02,8.209400e-02,&
     & 2.018800e-01,2.956100e-01,2.441800e-01,1.607200e-01,1.066200e-01,&
     & 3.248500e-01,4.702000e-01,3.894500e-01,2.584300e-01,1.337700e-01,&
     & 5.011600e-01,7.118500e-01,5.928400e-01,3.973400e-01,1.654700e-01,&
     & 5.372800e-02,7.747500e-02,6.357500e-02,4.281200e-02,5.093300e-02,&
     & 9.703500e-02,1.417600e-01,1.167000e-01,7.731300e-02,7.036100e-02,&
     & 1.661800e-01,2.444700e-01,2.018000e-01,1.325500e-01,9.283000e-02,&
     & 2.724100e-01,3.973300e-01,3.286100e-01,2.170200e-01,1.179900e-01,&
     & 4.278400e-01,6.127700e-01,5.090800e-01,3.398400e-01,1.464100e-01,&
     & 4.180200e-02,6.050200e-02,4.969700e-02,3.350400e-02,4.202300e-02,&
     & 7.772200e-02,1.135400e-01,9.325100e-02,6.206100e-02,5.935100e-02,&
     & 1.360800e-01,2.005700e-01,1.655700e-01,1.087300e-01,7.964500e-02,&
     & 2.273000e-01,3.335300e-01,2.757100e-01,1.813100e-01,1.028000e-01,&
     & 3.629900e-01,5.246200e-01,4.348700e-01,2.890500e-01,1.285900e-01,&
     & 3.218300e-02,4.668000e-02,3.848100e-02,2.604200e-02,3.375600e-02,&
     & 6.172800e-02,9.013300e-02,7.397300e-02,4.938100e-02,4.899300e-02,&
     & 1.107700e-01,1.631900e-01,1.345400e-01,8.855500e-02,6.705600e-02,&
     & 1.884400e-01,2.778500e-01,2.293600e-01,1.504200e-01,8.793400e-02,&
     & 3.061900e-01,4.460500e-01,3.689700e-01,2.441000e-01,1.112000e-01,&
     & 2.504700e-02,3.640000e-02,3.015300e-02,2.050200e-02,2.903800e-02,&
     & 4.950900e-02,7.246300e-02,5.942800e-02,3.971300e-02,4.329600e-02,&
     & 9.104700e-02,1.340800e-01,1.103200e-01,7.281100e-02,6.035200e-02,&
     & 1.577300e-01,2.332200e-01,1.925600e-01,1.261000e-01,8.024700e-02,&
     & 2.606400e-01,3.819500e-01,3.156700e-01,2.079800e-01,1.026800e-01,&
     & 1.953100e-02,2.840900e-02,2.365400e-02,1.616900e-02,2.601600e-02,&
     & 3.973100e-02,5.830000e-02,4.786400e-02,3.204600e-02,3.989100e-02,&
     & 7.501100e-02,1.103500e-01,9.060900e-02,6.002500e-02,5.669100e-02,&
     & 1.323900e-01,1.959900e-01,1.617800e-01,1.059700e-01,7.643000e-02,&
     & 2.223200e-01,3.273700e-01,2.705300e-01,1.775600e-01,9.905200e-02,&
     & 1.508500e-02,2.199100e-02,1.838500e-02,1.262900e-02,2.321000e-02,&
     & 3.164000e-02,4.651900e-02,3.829300e-02,2.574100e-02,3.655400e-02,&
     & 6.140100e-02,9.025200e-02,7.404400e-02,4.917500e-02,5.316800e-02,&
     & 1.106900e-01,1.637100e-01,1.350200e-01,8.864700e-02,7.286300e-02,&
     & 1.888200e-01,2.790500e-01,2.304200e-01,1.508800e-01,9.553200e-02,&
     & 1.149700e-02,1.686100e-02,1.416700e-02,9.743300e-03,2.053500e-02,&
     & 2.498200e-02,3.676700e-02,3.040500e-02,2.053900e-02,3.338100e-02,&
     & 4.986300e-02,7.340800e-02,6.017200e-02,4.001800e-02,4.985300e-02,&
     & 9.197300e-02,1.359200e-01,1.118800e-01,7.364400e-02,6.936800e-02,&
     & 1.595600e-01,2.363300e-01,1.952000e-01,1.276500e-01,9.214300e-02,&
     & 8.755700e-03,1.298700e-02,1.095700e-02,7.530000e-03,1.843700e-02,&
     & 1.982200e-02,2.915300e-02,2.423500e-02,1.646000e-02,3.105200e-02,&
     & 4.061500e-02,5.990400e-02,4.913400e-02,3.275200e-02,4.755300e-02,&
     & 7.674900e-02,1.132600e-01,9.303300e-02,6.144600e-02,6.732700e-02,&
     & 1.353800e-01,2.008100e-01,1.658300e-01,1.084600e-01,9.054000e-02,&
     & 7.783400e-03,1.163500e-02,9.823700e-03,6.734600e-03,2.056700e-02,&
     & 1.796800e-02,2.645600e-02,2.202800e-02,1.498800e-02,3.530000e-02,&
     & 3.727500e-02,5.502600e-02,4.516300e-02,3.013200e-02,5.458700e-02,&
     & 7.118700e-02,1.050200e-01,8.620100e-02,5.699800e-02,7.796500e-02,&
     & 1.265200e-01,1.876900e-01,1.549600e-01,1.014200e-01,1.051600e-01/
      data  absb(1:300,14) /                                            &
     & 2.252400e+00,1.864200e+00,1.461300e+00,1.456900e+00,8.760100e+00,&
     & 3.133100e+00,2.601700e+00,2.076500e+00,2.110800e+00,8.683700e+00,&
     & 4.216100e+00,3.497500e+00,2.833200e+00,2.940000e+00,8.596700e+00,&
     & 5.474200e+00,4.532600e+00,3.717600e+00,3.946100e+00,8.550900e+00,&
     & 6.879400e+00,5.674200e+00,4.718000e+00,5.120100e+00,8.733200e+00,&
     & 2.430000e+00,2.009900e+00,1.603900e+00,1.595100e+00,7.999800e+00,&
     & 3.367100e+00,2.780900e+00,2.272200e+00,2.286100e+00,7.939900e+00,&
     & 4.509800e+00,3.724900e+00,3.105800e+00,3.147900e+00,7.939600e+00,&
     & 5.847900e+00,4.832700e+00,4.084800e+00,4.174800e+00,8.020400e+00,&
     & 7.348500e+00,6.086700e+00,5.184500e+00,5.350500e+00,8.476500e+00,&
     & 2.656800e+00,2.179600e+00,1.785400e+00,1.735200e+00,6.706000e+00,&
     & 3.682200e+00,3.019200e+00,2.511800e+00,2.466000e+00,6.763200e+00,&
     & 4.914500e+00,4.041900e+00,3.419700e+00,3.362500e+00,6.934400e+00,&
     & 6.353600e+00,5.254000e+00,4.491000e+00,4.410700e+00,7.273400e+00,&
     & 7.975100e+00,6.637600e+00,5.712700e+00,5.603600e+00,8.165300e+00,&
     & 2.942700e+00,2.401900e+00,1.991800e+00,1.880700e+00,5.489000e+00,&
     & 4.075500e+00,3.333400e+00,2.794100e+00,2.649700e+00,5.726700e+00,&
     & 5.418300e+00,4.458700e+00,3.784800e+00,3.578600e+00,6.075100e+00,&
     & 6.984900e+00,5.789500e+00,4.953300e+00,4.668800e+00,6.871200e+00,&
     & 8.745300e+00,7.319200e+00,6.303100e+00,5.918500e+00,8.045100e+00,&
     & 3.275000e+00,2.672600e+00,2.237800e+00,2.030100e+00,4.764000e+00,&
     & 4.533000e+00,3.708900e+00,3.128300e+00,2.837400e+00,5.128100e+00,&
     & 6.012600e+00,4.950700e+00,4.210900e+00,3.804600e+00,5.751300e+00,&
     & 7.713500e+00,6.416900e+00,5.492100e+00,4.933700e+00,6.713500e+00,&
     & 9.633800e+00,8.104700e+00,6.959900e+00,6.236600e+00,8.005800e+00,&
     & 3.647200e+00,2.980700e+00,2.518900e+00,2.179600e+00,4.433400e+00,&
     & 5.032300e+00,4.136700e+00,3.497900e+00,3.024700e+00,4.909600e+00,&
     & 6.645400e+00,5.514400e+00,4.685800e+00,4.038100e+00,5.660800e+00,&
     & 8.489000e+00,7.126400e+00,6.080300e+00,5.219900e+00,6.692500e+00,&
     & 1.054200e+01,8.958600e+00,7.660100e+00,6.557500e+00,7.998800e+00,&
     & 4.027400e+00,3.323300e+00,2.822700e+00,2.326100e+00,4.297500e+00,&
     & 5.520400e+00,4.599200e+00,3.896100e+00,3.208900e+00,4.840800e+00,&
     & 7.264100e+00,6.109000e+00,5.184700e+00,4.271000e+00,5.634800e+00,&
     & 9.224100e+00,7.854300e+00,6.683700e+00,5.515500e+00,6.691200e+00,&
     & 1.140300e+01,9.803400e+00,8.382000e+00,6.904800e+00,7.967000e+00,&
     & 4.404200e+00,3.692300e+00,3.156400e+00,2.500900e+00,4.338600e+00,&
     & 6.005600e+00,5.081500e+00,4.330500e+00,3.432800e+00,4.892000e+00,&
     & 7.855100e+00,6.716400e+00,5.713600e+00,4.551200e+00,5.665800e+00,&
     & 9.923900e+00,8.570300e+00,7.321500e+00,5.850400e+00,6.681800e+00,&
     & 1.219700e+01,1.063900e+01,9.129900e+00,7.313400e+00,7.925500e+00,&
     & 4.747900e+00,4.050800e+00,3.498300e+00,2.695500e+00,4.401000e+00,&
     & 6.435500e+00,5.539900e+00,4.767800e+00,3.682000e+00,4.944600e+00,&
     & 8.366300e+00,7.275100e+00,6.251800e+00,4.857200e+00,5.675700e+00,&
     & 1.051200e+01,9.231400e+00,7.952600e+00,6.214100e+00,6.628800e+00,&
     & 1.285600e+01,1.139600e+01,9.865900e+00,7.756100e+00,7.827700e+00,&
     & 5.142000e+00,4.482300e+00,3.909600e+00,2.952700e+00,4.401300e+00,&
     & 6.900600e+00,6.070500e+00,5.280600e+00,4.002500e+00,4.952800e+00,&
     & 8.898300e+00,7.901300e+00,6.867800e+00,5.240200e+00,5.674800e+00,&
     & 1.111600e+01,9.947000e+00,8.669800e+00,6.667400e+00,6.599400e+00,&
     & 1.350200e+01,1.220200e+01,1.068600e+01,8.285300e+00,7.751700e+00,&
     & 5.471300e+00,4.891100e+00,4.307200e+00,3.213900e+00,4.381300e+00,&
     & 7.275100e+00,6.563800e+00,5.766400e+00,4.325000e+00,4.955500e+00,&
     & 9.323000e+00,8.473500e+00,7.445500e+00,5.621200e+00,5.678300e+00,&
     & 1.156400e+01,1.059900e+01,9.342800e+00,7.104900e+00,6.582500e+00,&
     & 1.397400e+01,1.291000e+01,1.143900e+01,8.785700e+00,7.686500e+00,&
     & 5.735000e+00,5.271200e+00,4.680100e+00,3.477400e+00,4.307800e+00,&
     & 7.569500e+00,7.006700e+00,6.218900e+00,4.644400e+00,4.909700e+00,&
     & 9.627900e+00,8.984500e+00,7.982200e+00,5.995400e+00,5.651400e+00,&
     & 1.187800e+01,1.116000e+01,9.953300e+00,7.536600e+00,6.553200e+00,&
     & 1.428500e+01,1.351400e+01,1.212600e+01,9.266500e+00,7.671500e+00/
      data  absb(301:600,14) /                                          &
     & 5.926700e+00,5.618700e+00,5.028000e+00,3.738700e+00,4.297200e+00,&
     & 7.764200e+00,7.407700e+00,6.634700e+00,4.955500e+00,4.930900e+00,&
     & 9.818700e+00,9.427700e+00,8.472000e+00,6.364800e+00,5.693400e+00,&
     & 1.205900e+01,1.164400e+01,1.051500e+01,7.952500e+00,6.618600e+00,&
     & 1.446300e+01,1.404000e+01,1.275200e+01,9.743200e+00,7.771400e+00,&
     & 6.067300e+00,5.944900e+00,5.365500e+00,4.005800e+00,4.368400e+00,&
     & 7.888400e+00,7.777600e+00,7.035900e+00,5.275100e+00,5.044600e+00,&
     & 9.923800e+00,9.829300e+00,8.938100e+00,6.735200e+00,5.834900e+00,&
     & 1.215000e+01,1.208600e+01,1.104700e+01,8.379200e+00,6.801100e+00,&
     & 1.453500e+01,1.452700e+01,1.335300e+01,1.023600e+01,7.978900e+00,&
     & 6.134300e+00,6.230200e+00,5.676300e+00,4.252500e+00,4.379900e+00,&
     & 7.933100e+00,8.086900e+00,7.403200e+00,5.568900e+00,5.101200e+00,&
     & 9.949200e+00,1.017200e+01,9.362200e+00,7.077900e+00,5.941100e+00,&
     & 1.215100e+01,1.246700e+01,1.152900e+01,8.786100e+00,6.949500e+00,&
     & 1.452900e+01,1.494400e+01,1.391400e+01,1.072700e+01,8.141700e+00,&
     & 6.145300e+00,6.476300e+00,5.963700e+00,4.484100e+00,4.335700e+00,&
     & 7.921700e+00,8.359900e+00,7.743000e+00,5.838100e+00,5.095700e+00,&
     & 9.908900e+00,1.047400e+01,9.752100e+00,7.403100e+00,5.993900e+00,&
     & 1.210300e+01,1.280200e+01,1.198300e+01,9.176500e+00,7.038000e+00,&
     & 1.448400e+01,1.531500e+01,1.445000e+01,1.120500e+01,8.256000e+00,&
     & 6.134400e+00,6.710300e+00,6.246800e+00,4.709400e+00,4.206000e+00,&
     & 7.887300e+00,8.621700e+00,8.078100e+00,6.110800e+00,4.977100e+00,&
     & 9.865800e+00,1.077100e+01,1.014600e+01,7.733800e+00,5.885100e+00,&
     & 1.205900e+01,1.313300e+01,1.244500e+01,9.578700e+00,6.930800e+00,&
     & 1.444000e+01,1.570000e+01,1.500200e+01,1.170200e+01,8.165800e+00,&
     & 6.107400e+00,6.934000e+00,6.526600e+00,4.932700e+00,4.009600e+00,&
     & 7.850100e+00,8.883100e+00,8.408800e+00,6.389400e+00,4.786800e+00,&
     & 9.832100e+00,1.106800e+01,1.054100e+01,8.066300e+00,5.684500e+00,&
     & 1.202900e+01,1.347600e+01,1.291700e+01,9.990300e+00,6.731200e+00,&
     & 1.441900e+01,1.610900e+01,1.557300e+01,1.220900e+01,7.975400e+00,&
     & 6.098600e+00,7.172200e+00,6.820000e+00,5.175500e+00,3.716300e+00,&
     & 7.845000e+00,9.161900e+00,8.762000e+00,6.685800e+00,4.461900e+00,&
     & 9.834000e+00,1.139300e+01,1.096900e+01,8.427900e+00,5.331600e+00,&
     & 1.204300e+01,1.386400e+01,1.342900e+01,1.044000e+01,6.368600e+00,&
     & 1.446100e+01,1.657100e+01,1.618500e+01,1.275100e+01,7.631500e+00,&
     & 6.126600e+00,7.438400e+00,7.135000e+00,5.438400e+00,3.436400e+00,&
     & 7.884300e+00,9.473300e+00,9.148100e+00,7.006500e+00,4.150800e+00,&
     & 9.890800e+00,1.176500e+01,1.143600e+01,8.818900e+00,5.005700e+00,&
     & 1.213200e+01,1.430600e+01,1.398900e+01,1.092600e+01,6.048000e+00,&
     & 1.459100e+01,1.709500e+01,1.684500e+01,1.333200e+01,7.337300e+00,&
     & 6.192800e+00,7.731000e+00,7.480400e+00,5.725100e+00,3.157100e+00,&
     & 7.974700e+00,9.826900e+00,9.573100e+00,7.356300e+00,3.854700e+00,&
     & 1.001600e+01,1.218700e+01,1.194000e+01,9.248100e+00,4.704900e+00,&
     & 1.229600e+01,1.480400e+01,1.459000e+01,1.145300e+01,5.773600e+00,&
     & 1.481300e+01,1.767000e+01,1.755200e+01,1.395100e+01,7.099500e+00,&
     & 6.242400e+00,7.989700e+00,7.791000e+00,5.983600e+00,2.961100e+00,&
     & 8.055000e+00,1.014300e+01,9.952800e+00,7.672400e+00,3.656800e+00,&
     & 1.012900e+01,1.256900e+01,1.239900e+01,9.637500e+00,4.513700e+00,&
     & 1.245500e+01,1.525100e+01,1.513500e+01,1.192800e+01,5.606700e+00,&
     & 1.502400e+01,1.819000e+01,1.819300e+01,1.450900e+01,6.972600e+00,&
     & 6.178300e+00,8.086800e+00,7.935400e+00,6.109700e+00,2.738600e+00,&
     & 8.002100e+00,1.027400e+01,1.014300e+01,7.834200e+00,3.423100e+00,&
     & 1.009300e+01,1.274100e+01,1.263800e+01,9.846400e+00,4.281700e+00,&
     & 1.244800e+01,1.546600e+01,1.543000e+01,1.219000e+01,5.383800e+00,&
     & 1.505000e+01,1.845300e+01,1.855300e+01,1.483000e+01,6.779500e+00,&
     & 5.973900e+00,7.987900e+00,7.876200e+00,6.073600e+00,2.496600e+00,&
     & 7.783700e+00,1.018000e+01,1.009700e+01,7.807200e+00,3.160600e+00,&
     & 9.872300e+00,1.265800e+01,1.260700e+01,9.833000e+00,4.002900e+00,&
     & 1.222900e+01,1.539600e+01,1.541800e+01,1.219400e+01,5.091700e+00,&
     & 1.483400e+01,1.840300e+01,1.857000e+01,1.485700e+01,6.486300e+00/
      data  absb(601:900,14) /                                          &
     & 5.561200e+00,7.603700e+00,7.521700e+00,5.804900e+00,2.243300e+00,&
     & 7.317900e+00,9.757100e+00,9.706300e+00,7.507400e+00,2.864600e+00,&
     & 9.360200e+00,1.220300e+01,1.218800e+01,9.500100e+00,3.660800e+00,&
     & 1.168100e+01,1.491600e+01,1.496700e+01,1.182500e+01,4.700500e+00,&
     & 1.425900e+01,1.789700e+01,1.808900e+01,1.446100e+01,6.047500e+00,&
     & 5.179600e+00,7.227500e+00,7.168100e+00,5.536200e+00,1.998500e+00,&
     & 6.882500e+00,9.340100e+00,9.311600e+00,7.205000e+00,2.578600e+00,&
     & 8.877000e+00,1.174800e+01,1.175900e+01,9.158300e+00,3.330400e+00,&
     & 1.116100e+01,1.443000e+01,1.450800e+01,1.144300e+01,4.322500e+00,&
     & 1.370600e+01,1.738200e+01,1.759100e+01,1.404900e+01,5.618300e+00,&
     & 4.836300e+00,6.876200e+00,6.834400e+00,5.280100e+00,1.762300e+00,&
     & 6.487400e+00,8.947900e+00,8.933900e+00,6.917600e+00,2.303500e+00,&
     & 8.436700e+00,1.131500e+01,1.134600e+01,8.833100e+00,3.015700e+00,&
     & 1.068000e+01,1.396500e+01,1.406200e+01,1.107700e+01,3.961900e+00,&
     & 1.319000e+01,1.688700e+01,1.710500e+01,1.364600e+01,5.210300e+00,&
     & 4.379300e+00,6.355700e+00,6.325800e+00,4.886400e+00,1.565800e+00,&
     & 5.949800e+00,8.353500e+00,8.346400e+00,6.465800e+00,2.060400e+00,&
     & 7.823200e+00,1.064800e+01,1.068900e+01,8.311100e+00,2.719200e+00,&
     & 9.994100e+00,1.323600e+01,1.333800e+01,1.047700e+01,3.593600e+00,&
     & 1.244100e+01,1.609800e+01,1.630400e+01,1.297600e+01,4.760800e+00,&
     & 3.945600e+00,5.842000e+00,5.823100e+00,4.496000e+00,1.388900e+00,&
     & 5.432200e+00,7.760100e+00,7.759700e+00,6.012400e+00,1.837700e+00,&
     & 7.222900e+00,9.980400e+00,1.002400e+01,7.785100e+00,2.443200e+00,&
     & 9.315100e+00,1.249600e+01,1.259800e+01,9.869400e+00,3.250300e+00,&
     & 1.169600e+01,1.529400e+01,1.548900e+01,1.229000e+01,4.331500e+00,&
     & 3.549600e+00,5.359800e+00,5.349700e+00,4.126300e+00,1.223000e+00,&
     & 4.955200e+00,7.195700e+00,7.198100e+00,5.577100e+00,1.630800e+00,&
     & 6.662400e+00,9.337400e+00,9.381900e+00,7.283000e+00,2.185000e+00,&
     & 8.675500e+00,1.178100e+01,1.188200e+01,9.283300e+00,2.929500e+00,&
     & 1.098400e+01,1.451200e+01,1.469400e+01,1.162400e+01,3.928700e+00,&
     & 3.123700e+00,4.816400e+00,4.812900e+00,3.705500e+00,1.059700e+00,&
     & 4.431000e+00,6.552400e+00,6.555500e+00,5.076900e+00,1.422000e+00,&
     & 6.036300e+00,8.599300e+00,8.636900e+00,6.704000e+00,1.919000e+00,&
     & 7.951500e+00,1.094900e+01,1.104100e+01,8.608200e+00,2.593700e+00,&
     & 1.017000e+01,1.359400e+01,1.376100e+01,1.084600e+01,3.502400e+00,&
     & 2.709400e+00,4.273800e+00,4.271500e+00,3.285100e+00,9.064200e-01,&
     & 3.914800e+00,5.901900e+00,5.908300e+00,4.570800e+00,1.223800e+00,&
     & 5.414600e+00,7.844100e+00,7.876200e+00,6.112400e+00,1.663200e+00,&
     & 7.221200e+00,1.009300e+01,1.017200e+01,7.916200e+00,2.268500e+00,&
     & 9.338300e+00,1.264000e+01,1.279000e+01,1.003900e+01,3.087700e+00,&
     & 2.338100e+00,3.770800e+00,3.768700e+00,2.896800e+00,7.666100e-01,&
     & 3.443900e+00,5.295600e+00,5.303900e+00,4.095800e+00,1.040500e+00,&
     & 4.837500e+00,7.129600e+00,7.154700e+00,5.551000e+00,1.428900e+00,&
     & 6.536600e+00,9.274200e+00,9.340900e+00,7.262000e+00,1.968400e+00,&
     & 8.549200e+00,1.172300e+01,1.185500e+01,9.271500e+00,2.707600e+00,&
     & 1.986800e+00,3.281200e+00,3.280000e+00,2.519000e+00,6.418000e-01,&
     & 2.989600e+00,4.695900e+00,4.702800e+00,3.624400e+00,8.733800e-01,&
     & 4.274300e+00,6.414500e+00,6.435100e+00,4.986600e+00,1.211500e+00,&
     & 5.859200e+00,8.447500e+00,8.503700e+00,6.605900e+00,1.686900e+00,&
     & 7.756500e+00,1.078900e+01,1.090000e+01,8.503900e+00,2.346600e+00,&
     & 1.643900e+00,2.787200e+00,2.785300e+00,2.136100e+00,5.360800e-01,&
     & 2.533200e+00,4.076100e+00,4.080800e+00,3.141700e+00,7.268900e-01,&
     & 3.700400e+00,5.668200e+00,5.687200e+00,4.400200e+00,1.014200e+00,&
     & 5.160300e+00,7.576300e+00,7.619400e+00,5.917200e+00,1.423600e+00,&
     & 6.929400e+00,9.795100e+00,9.884600e+00,7.695400e+00,2.000600e+00,&
     & 1.345400e+00,2.344100e+00,2.343500e+00,1.793400e+00,4.433200e-01,&
     & 2.128900e+00,3.509000e+00,3.513000e+00,2.701700e+00,5.990600e-01,&
     & 3.181000e+00,4.980800e+00,4.995500e+00,3.856200e+00,8.368100e-01,&
     & 4.516800e+00,6.758300e+00,6.789700e+00,5.267900e+00,1.189800e+00,&
     & 6.158900e+00,8.851900e+00,8.924000e+00,6.939200e+00,1.689400e+00/
      data  absb(901:1175,14) /                                         &
     & 1.088000e+00,1.952000e+00,1.949200e+00,1.489200e+00,3.620500e-01,&
     & 1.773000e+00,2.996500e+00,2.999300e+00,2.302600e+00,4.869600e-01,&
     & 2.710800e+00,4.343100e+00,4.355000e+00,3.355500e+00,6.799300e-01,&
     & 3.929700e+00,5.993900e+00,6.020500e+00,4.663800e+00,9.789200e-01,&
     & 5.445600e+00,7.962300e+00,8.019700e+00,6.231600e+00,1.409700e+00,&
     & 8.811700e-01,1.625000e+00,1.622100e+00,1.238300e+00,3.085100e-01,&
     & 1.479200e+00,2.561400e+00,2.564000e+00,1.964900e+00,4.103300e-01,&
     & 2.315300e+00,3.791100e+00,3.799800e+00,2.925300e+00,5.691100e-01,&
     & 3.425500e+00,5.327000e+00,5.349800e+00,4.136900e+00,8.202800e-01,&
     & 4.824900e+00,7.174800e+00,7.218900e+00,5.606800e+00,1.194600e+00,&
     & 7.105600e-01,1.344200e+00,1.343300e+00,1.024100e+00,2.696900e-01,&
     & 1.228500e+00,2.182500e+00,2.183600e+00,1.670100e+00,3.535200e-01,&
     & 1.971900e+00,3.300900e+00,3.307500e+00,2.543100e+00,4.846300e-01,&
     & 2.978700e+00,4.725400e+00,4.742900e+00,3.659800e+00,6.943000e-01,&
     & 4.268800e+00,6.456000e+00,6.490500e+00,5.034500e+00,1.018600e+00,&
     & 5.667300e-01,1.099300e+00,1.100200e+00,8.363900e-01,2.358700e-01,&
     & 1.010900e+00,1.843100e+00,1.842000e+00,1.407300e+00,3.043500e-01,&
     & 1.667200e+00,2.853200e+00,2.858900e+00,2.194500e+00,4.117200e-01,&
     & 2.571800e+00,4.165300e+00,4.178500e+00,3.220100e+00,5.848400e-01,&
     & 3.756000e+00,5.781400e+00,5.811100e+00,4.500500e+00,8.610300e-01,&
     & 4.469500e-01,8.884600e-01,8.900100e-01,6.729000e-01,2.045600e-01,&
     & 8.229300e-01,1.538700e+00,1.537700e+00,1.173700e+00,2.621400e-01,&
     & 1.396100e+00,2.446700e+00,2.451200e+00,1.877800e+00,3.483200e-01,&
     & 2.204200e+00,3.645900e+00,3.655600e+00,2.814100e+00,4.901400e-01,&
     & 3.285000e+00,5.151100e+00,5.174900e+00,4.000600e+00,7.213900e-01,&
     & 3.554200e-01,7.224300e-01,7.240200e-01,5.444200e-01,1.882200e-01,&
     & 6.747600e-01,1.290600e+00,1.291400e+00,9.842900e-01,2.421100e-01,&
     & 1.176700e+00,2.110500e+00,2.112000e+00,1.615900e+00,3.143600e-01,&
     & 1.901400e+00,3.207400e+00,3.216000e+00,2.472500e+00,4.338400e-01,&
     & 2.887100e+00,4.610900e+00,4.630200e+00,3.572400e+00,6.297800e-01,&
     & 2.820600e-01,5.856100e-01,5.863100e-01,4.388100e-01,1.795600e-01,&
     & 5.528500e-01,1.080500e+00,1.082400e+00,8.227900e-01,2.317000e-01,&
     & 9.908000e-01,1.817100e+00,1.817400e+00,1.388800e+00,2.965100e-01,&
     & 1.639700e+00,2.820700e+00,2.826900e+00,2.170000e+00,3.992700e-01,&
     & 2.536400e+00,4.124600e+00,4.139000e+00,3.190100e+00,5.667600e-01,&
     & 2.214900e-01,4.688800e-01,4.679300e-01,3.493100e-01,1.715300e-01,&
     & 4.494100e-01,8.970200e-01,8.991700e-01,6.803000e-01,2.221600e-01,&
     & 8.276400e-01,1.552000e+00,1.551700e+00,1.184800e+00,2.840300e-01,&
     & 1.404400e+00,2.465600e+00,2.471300e+00,1.893700e+00,3.724900e-01,&
     & 2.216800e+00,3.670800e+00,3.682700e+00,2.835600e+00,5.165400e-01,&
     & 1.721400e-01,3.707900e-01,3.682400e-01,2.742000e-01,1.633800e-01,&
     & 3.617200e-01,7.371300e-01,7.392400e-01,5.563900e-01,2.137300e-01,&
     & 6.857000e-01,1.313400e+00,1.314800e+00,1.002500e+00,2.745600e-01,&
     & 1.194200e+00,2.142400e+00,2.145400e+00,1.641800e+00,3.531000e-01,&
     & 1.926400e+00,3.250500e+00,3.260200e+00,2.507000e+00,4.775200e-01,&
     & 1.344500e-01,2.928400e-01,2.890300e-01,2.148200e-01,1.577400e-01,&
     & 2.913700e-01,6.056300e-01,6.066800e-01,4.544700e-01,2.092900e-01,&
     & 5.690400e-01,1.112100e+00,1.114300e+00,8.476200e-01,2.700400e-01,&
     & 1.016400e+00,1.862500e+00,1.863400e+00,1.424200e+00,3.451400e-01,&
     & 1.677200e+00,2.881500e+00,2.888500e+00,2.218200e+00,4.556400e-01,&
     & 1.213100e-01,2.651800e-01,2.608900e-01,1.939300e-01,1.744100e-01,&
     & 2.662600e-01,5.578200e-01,5.585200e-01,4.178700e-01,2.346100e-01,&
     & 5.265900e-01,1.037700e+00,1.040300e+00,7.902800e-01,3.063300e-01,&
     & 9.506400e-01,1.756600e+00,1.757300e+00,1.342900e+00,3.967400e-01,&
     & 1.583000e+00,2.740400e+00,2.747400e+00,2.108700e+00,5.202100e-01/
      data  absb(1:300,15) /                                            &
     & 3.224400e+00,2.540900e+00,3.132800e+00,4.671200e+00,1.104800e+01,&
     & 4.539800e+00,3.605700e+00,4.523700e+00,6.755400e+00,1.152300e+01,&
     & 6.083700e+00,4.873200e+00,6.188700e+00,9.262200e+00,1.315400e+01,&
     & 7.862800e+00,6.321700e+00,8.142200e+00,1.219600e+01,1.629600e+01,&
     & 9.852500e+00,7.965300e+00,1.047200e+01,1.568600e+01,2.095900e+01,&
     & 3.575500e+00,2.877900e+00,3.451900e+00,5.102800e+00,1.037300e+01,&
     & 5.052400e+00,4.125000e+00,4.988300e+00,7.387800e+00,1.151300e+01,&
     & 6.834600e+00,5.598400e+00,6.821200e+00,1.015100e+01,1.385500e+01,&
     & 8.900000e+00,7.272300e+00,8.953700e+00,1.337900e+01,1.787100e+01,&
     & 1.126500e+01,9.170100e+00,1.149700e+01,1.720600e+01,2.298100e+01,&
     & 4.082400e+00,3.343500e+00,3.816400e+00,5.587000e+00,9.563700e+00,&
     & 5.757700e+00,4.785000e+00,5.507600e+00,8.084200e+00,1.146100e+01,&
     & 7.821300e+00,6.500700e+00,7.536200e+00,1.109700e+01,1.482600e+01,&
     & 1.025600e+01,8.459300e+00,9.911400e+00,1.465500e+01,1.957200e+01,&
     & 1.303200e+01,1.068700e+01,1.268400e+01,1.879300e+01,2.509900e+01,&
     & 4.737200e+00,3.927000e+00,4.246300e+00,6.122100e+00,9.097600e+00,&
     & 6.643600e+00,5.578700e+00,6.104500e+00,8.812600e+00,1.184300e+01,&
     & 9.051700e+00,7.579700e+00,8.354200e+00,1.209200e+01,1.614700e+01,&
     & 1.187900e+01,9.900800e+00,1.102300e+01,1.596000e+01,2.130900e+01,&
     & 1.509300e+01,1.251900e+01,1.407800e+01,2.038700e+01,2.722100e+01,&
     & 5.519700e+00,4.616000e+00,4.741800e+00,6.677300e+00,9.220500e+00,&
     & 7.711900e+00,6.501900e+00,6.777400e+00,9.535800e+00,1.272700e+01,&
     & 1.046700e+01,8.838800e+00,9.274200e+00,1.305800e+01,1.743000e+01,&
     & 1.372000e+01,1.155300e+01,1.224400e+01,1.722700e+01,2.299800e+01,&
     & 1.741300e+01,1.459400e+01,1.567300e+01,2.204700e+01,2.943300e+01,&
     & 6.427400e+00,5.411100e+00,5.303400e+00,7.235000e+00,9.762200e+00,&
     & 8.957300e+00,7.580700e+00,7.547900e+00,1.027300e+01,1.371000e+01,&
     & 1.211100e+01,1.025800e+01,1.032100e+01,1.400600e+01,1.869600e+01,&
     & 1.584500e+01,1.338600e+01,1.362200e+01,1.847000e+01,2.465000e+01,&
     & 2.008400e+01,1.689000e+01,1.743400e+01,2.367300e+01,3.159900e+01,&
     & 7.516400e+00,6.313400e+00,5.939500e+00,7.809300e+00,1.047500e+01,&
     & 1.044100e+01,8.801400e+00,8.427800e+00,1.103500e+01,1.472900e+01,&
     & 1.404300e+01,1.186100e+01,1.151300e+01,1.498800e+01,2.000400e+01,&
     & 1.832200e+01,1.543300e+01,1.517700e+01,1.971500e+01,2.631800e+01,&
     & 2.314600e+01,1.946600e+01,1.938400e+01,2.525500e+01,3.370900e+01,&
     & 8.845500e+00,7.406600e+00,6.718600e+00,8.455800e+00,1.134300e+01,&
     & 1.221900e+01,1.027500e+01,9.487100e+00,1.188200e+01,1.585800e+01,&
     & 1.634600e+01,1.376300e+01,1.293100e+01,1.609500e+01,2.147900e+01,&
     & 2.120600e+01,1.785500e+01,1.699000e+01,2.112700e+01,2.819800e+01,&
     & 2.666100e+01,2.243500e+01,2.164000e+01,2.696900e+01,3.599500e+01,&
     & 1.037800e+01,8.673100e+00,7.634000e+00,9.134900e+00,1.228100e+01,&
     & 1.424600e+01,1.195900e+01,1.071200e+01,1.278000e+01,1.704000e+01,&
     & 1.894000e+01,1.592900e+01,1.452800e+01,1.726500e+01,2.301800e+01,&
     & 2.441600e+01,2.056300e+01,1.901900e+01,2.260200e+01,3.012400e+01,&
     & 3.052300e+01,2.574700e+01,2.413500e+01,2.871200e+01,3.824800e+01,&
     & 1.235500e+01,1.032400e+01,8.910300e+00,1.013200e+01,1.353200e+01,&
     & 1.682700e+01,1.411000e+01,1.239700e+01,1.408500e+01,1.863500e+01,&
     & 2.218000e+01,1.865300e+01,1.665900e+01,1.892100e+01,2.500300e+01,&
     & 2.831100e+01,2.390500e+01,2.164100e+01,2.458400e+01,3.247200e+01,&
     & 3.514900e+01,2.973800e+01,2.725000e+01,3.100400e+01,4.098700e+01,&
     & 1.460500e+01,1.220500e+01,1.044500e+01,1.129100e+01,1.487100e+01,&
     & 1.971600e+01,1.653900e+01,1.437600e+01,1.556600e+01,2.031000e+01,&
     & 2.572600e+01,2.168300e+01,1.911500e+01,2.073600e+01,2.699500e+01,&
     & 3.257200e+01,2.756600e+01,2.458100e+01,2.671600e+01,3.478600e+01,&
     & 4.012300e+01,3.408000e+01,3.068600e+01,3.345700e+01,4.368600e+01,&
     & 1.713400e+01,1.433000e+01,1.223700e+01,1.259200e+01,1.624100e+01,&
     & 2.288200e+01,1.925200e+01,1.664200e+01,1.719300e+01,2.203500e+01,&
     & 2.958400e+01,2.500500e+01,2.186600e+01,2.268200e+01,2.902300e+01,&
     & 3.713000e+01,3.155600e+01,2.783600e+01,2.899000e+01,3.715400e+01,&
     & 4.538800e+01,3.871300e+01,3.444600e+01,3.610400e+01,4.637700e+01/
      data  absb(301:600,15) /                                          &
     & 1.992700e+01,1.670700e+01,1.428800e+01,1.405100e+01,1.769900e+01,&
     & 2.634300e+01,2.221700e+01,1.918800e+01,1.897300e+01,2.381400e+01,&
     & 3.372400e+01,2.862000e+01,2.489700e+01,2.476400e+01,3.110600e+01,&
     & 4.195200e+01,3.579400e+01,3.137800e+01,3.144000e+01,3.957200e+01,&
     & 5.089100e+01,4.358700e+01,3.847900e+01,3.887800e+01,4.903000e+01,&
     & 2.302600e+01,1.936500e+01,1.661600e+01,1.569200e+01,1.932000e+01,&
     & 3.012900e+01,2.549100e+01,2.203200e+01,2.094400e+01,2.572600e+01,&
     & 3.818800e+01,3.253600e+01,2.826600e+01,2.708900e+01,3.335400e+01,&
     & 4.707600e+01,4.031600e+01,3.523800e+01,3.411300e+01,4.210600e+01,&
     & 5.669100e+01,4.870200e+01,4.282800e+01,4.189000e+01,5.186500e+01,&
     & 2.631900e+01,2.220900e+01,1.910300e+01,1.747500e+01,2.104700e+01,&
     & 3.407700e+01,2.896100e+01,2.504700e+01,2.306600e+01,2.774000e+01,&
     & 4.276600e+01,3.659900e+01,3.179900e+01,2.954500e+01,3.562400e+01,&
     & 5.231100e+01,4.494900e+01,3.925400e+01,3.688100e+01,4.462500e+01,&
     & 6.253500e+01,5.390300e+01,4.727600e+01,4.495900e+01,5.474400e+01,&
     & 2.973900e+01,2.521200e+01,2.172500e+01,1.937000e+01,2.282300e+01,&
     & 3.811100e+01,3.255600e+01,2.817800e+01,2.531200e+01,2.980500e+01,&
     & 4.744200e+01,4.075800e+01,3.544700e+01,3.213000e+01,3.795200e+01,&
     & 5.758100e+01,4.963700e+01,4.335900e+01,3.978000e+01,4.724100e+01,&
     & 6.835000e+01,5.911000e+01,5.179000e+01,4.813500e+01,5.771100e+01,&
     & 3.328900e+01,2.837700e+01,2.448500e+01,2.142500e+01,2.462500e+01,&
     & 4.227000e+01,3.627700e+01,3.144500e+01,2.769500e+01,3.189800e+01,&
     & 5.220000e+01,4.500100e+01,3.916500e+01,3.483300e+01,4.033600e+01,&
     & 6.288400e+01,5.437700e+01,4.752600e+01,4.279200e+01,4.997600e+01,&
     & 7.415700e+01,6.431200e+01,5.634300e+01,5.143600e+01,6.084200e+01,&
     & 3.692200e+01,3.163700e+01,2.733600e+01,2.356600e+01,2.643600e+01,&
     & 4.648400e+01,4.004600e+01,3.476400e+01,3.014800e+01,3.400000e+01,&
     & 5.694100e+01,4.923500e+01,4.290700e+01,3.760400e+01,4.276700e+01,&
     & 6.811900e+01,5.907400e+01,5.166000e+01,4.584000e+01,5.277800e+01,&
     & 7.981600e+01,6.939100e+01,6.079700e+01,5.474600e+01,6.407000e+01,&
     & 4.064800e+01,3.498900e+01,3.027600e+01,2.579000e+01,2.825300e+01,&
     & 5.073900e+01,4.386900e+01,3.813600e+01,3.269300e+01,3.617600e+01,&
     & 6.169800e+01,5.349300e+01,4.666900e+01,4.045300e+01,4.532700e+01,&
     & 7.330700e+01,6.372500e+01,5.576500e+01,4.894400e+01,5.574500e+01,&
     & 8.537900e+01,7.438400e+01,6.518900e+01,5.811600e+01,6.743900e+01,&
     & 4.443000e+01,3.838400e+01,3.327900e+01,2.809300e+01,3.019800e+01,&
     & 5.501000e+01,4.771300e+01,4.152100e+01,3.530400e+01,3.848600e+01,&
     & 6.640600e+01,5.771400e+01,5.040300e+01,4.334000e+01,4.801900e+01,&
     & 7.839400e+01,6.829400e+01,5.980200e+01,5.209300e+01,5.886100e+01,&
     & 9.078900e+01,7.924800e+01,6.949600e+01,6.152000e+01,7.097100e+01,&
     & 4.824200e+01,4.181400e+01,3.631100e+01,3.044500e+01,3.226100e+01,&
     & 5.925900e+01,5.153400e+01,4.489800e+01,3.795300e+01,4.093300e+01,&
     & 7.104400e+01,6.187700e+01,5.409900e+01,4.624300e+01,5.086100e+01,&
     & 8.338500e+01,7.275400e+01,6.373800e+01,5.522500e+01,6.207200e+01,&
     & 9.601400e+01,8.396500e+01,7.366500e+01,6.493200e+01,7.466000e+01,&
     & 5.167200e+01,4.490700e+01,3.905200e+01,3.255900e+01,3.415000e+01,&
     & 6.306600e+01,5.494200e+01,4.793200e+01,4.032000e+01,4.313700e+01,&
     & 7.518100e+01,6.558600e+01,5.737600e+01,4.884800e+01,5.341600e+01,&
     & 8.778600e+01,7.671800e+01,6.723700e+01,5.802200e+01,6.498600e+01,&
     & 1.006200e+02,8.812200e+01,7.732200e+01,6.797200e+01,7.796800e+01,&
     & 5.397400e+01,4.701000e+01,4.091400e+01,3.395300e+01,3.528400e+01,&
     & 6.563200e+01,5.726100e+01,4.998600e+01,4.188000e+01,4.447700e+01,&
     & 7.798300e+01,6.810800e+01,5.960700e+01,5.055400e+01,5.496600e+01,&
     & 9.077400e+01,7.942300e+01,6.961500e+01,5.985600e+01,6.674700e+01,&
     & 1.037600e+02,9.095800e+01,7.982700e+01,6.995300e+01,7.997500e+01,&
     & 5.495200e+01,4.792800e+01,4.172800e+01,3.448200e+01,3.549700e+01,&
     & 6.674800e+01,5.830400e+01,5.090000e+01,4.246900e+01,4.474300e+01,&
     & 7.923700e+01,6.926800e+01,6.063000e+01,5.120300e+01,5.529900e+01,&
     & 9.216000e+01,8.069000e+01,7.074000e+01,6.056000e+01,6.715000e+01,&
     & 1.052700e+02,9.234700e+01,8.103300e+01,7.069100e+01,8.044500e+01/
      data  absb(601:900,15) /                                          &
     & 5.407700e+01,4.720300e+01,4.109000e+01,3.381600e+01,3.440200e+01,&
     & 6.587100e+01,5.758100e+01,5.025600e+01,4.173000e+01,4.350400e+01,&
     & 7.839400e+01,6.856400e+01,6.000300e+01,5.040600e+01,5.391900e+01,&
     & 9.137300e+01,8.002400e+01,7.015500e+01,5.971100e+01,6.563000e+01,&
     & 1.045700e+02,9.174300e+01,8.050200e+01,6.976900e+01,7.876400e+01,&
     & 5.299800e+01,4.629200e+01,4.028400e+01,3.304700e+01,3.325600e+01,&
     & 6.475800e+01,5.664600e+01,4.943000e+01,4.086700e+01,4.219300e+01,&
     & 7.728600e+01,6.762800e+01,5.917000e+01,4.948100e+01,5.244700e+01,&
     & 9.029500e+01,7.910100e+01,6.933900e+01,5.872700e+01,6.400200e+01,&
     & 1.035500e+02,9.087800e+01,7.973300e+01,6.869500e+01,7.696400e+01,&
     & 5.183800e+01,4.530900e+01,3.941400e+01,3.225300e+01,3.213300e+01,&
     & 6.355000e+01,5.562200e+01,4.852700e+01,3.997200e+01,4.090500e+01,&
     & 7.605600e+01,6.659100e+01,5.824300e+01,4.850400e+01,5.098700e+01,&
     & 8.907500e+01,7.805500e+01,6.842200e+01,5.768400e+01,6.238600e+01,&
     & 1.023900e+02,8.986700e+01,7.883700e+01,6.757600e+01,7.517200e+01,&
     & 4.947100e+01,4.324600e+01,3.759100e+01,3.069800e+01,3.021800e+01,&
     & 6.103200e+01,5.343100e+01,4.659400e+01,3.822900e+01,3.870200e+01,&
     & 7.341700e+01,6.430900e+01,5.622300e+01,4.659100e+01,4.845500e+01,&
     & 8.639800e+01,7.572100e+01,6.634000e+01,5.565500e+01,5.956700e+01,&
     & 9.972500e+01,8.749300e+01,7.675400e+01,6.536600e+01,7.201000e+01,&
     & 4.694000e+01,4.102900e+01,3.564600e+01,2.905400e+01,2.825200e+01,&
     & 5.830300e+01,5.106100e+01,4.448800e+01,3.638200e+01,3.642900e+01,&
     & 7.054500e+01,6.180900e+01,5.401400e+01,4.456900e+01,4.586600e+01,&
     & 8.344600e+01,7.314000e+01,6.405300e+01,5.348900e+01,5.665300e+01,&
     & 9.676200e+01,8.489000e+01,7.445300e+01,6.302800e+01,6.876200e+01,&
     & 4.440000e+01,3.880800e+01,3.369500e+01,2.743300e+01,2.636700e+01,&
     & 5.554800e+01,4.865300e+01,4.237000e+01,3.455800e+01,3.423100e+01,&
     & 6.763900e+01,5.926400e+01,5.176500e+01,4.254800e+01,4.334500e+01,&
     & 8.042200e+01,7.050500e+01,6.170800e+01,5.130900e+01,5.380200e+01,&
     & 9.369000e+01,8.218700e+01,7.207100e+01,6.069200e+01,6.558200e+01,&
     & 4.129900e+01,3.608600e+01,3.130300e+01,2.548100e+01,2.416800e+01,&
     & 5.214600e+01,4.566800e+01,3.973300e+01,3.234900e+01,3.165700e+01,&
     & 6.399700e+01,5.610400e+01,4.894800e+01,4.007800e+01,4.038200e+01,&
     & 7.662100e+01,6.718800e+01,5.877300e+01,4.861700e+01,5.040700e+01,&
     & 8.981000e+01,7.877100e+01,6.904300e+01,5.782500e+01,6.179800e+01,&
     & 3.801300e+01,3.320500e+01,2.879400e+01,2.342500e+01,2.191100e+01,&
     & 4.850600e+01,4.246600e+01,3.691600e+01,3.001700e+01,2.899900e+01,&
     & 6.007000e+01,5.266400e+01,4.590800e+01,3.746400e+01,3.730900e+01,&
     & 7.247900e+01,6.356000e+01,5.556400e+01,4.574900e+01,4.687700e+01,&
     & 8.553900e+01,7.502800e+01,6.572600e+01,5.477000e+01,5.783800e+01,&
     & 3.480800e+01,3.042900e+01,2.637200e+01,2.143800e+01,1.976400e+01,&
     & 4.494900e+01,3.932900e+01,3.416400e+01,2.775900e+01,2.647700e+01,&
     & 5.619800e+01,4.927100e+01,4.291600e+01,3.492900e+01,3.436500e+01,&
     & 6.837200e+01,5.996600e+01,5.237100e+01,4.294800e+01,4.351500e+01,&
     & 8.125800e+01,7.128000e+01,6.240200e+01,5.175200e+01,5.399900e+01,&
     & 3.150500e+01,2.757800e+01,2.388700e+01,1.940100e+01,1.761200e+01,&
     & 4.125400e+01,3.608000e+01,3.131200e+01,2.544900e+01,2.394100e+01,&
     & 5.213700e+01,4.569100e+01,3.976200e+01,3.231500e+01,3.139200e+01,&
     & 6.402300e+01,5.616700e+01,4.899600e+01,4.003400e+01,4.008900e+01,&
     & 7.670200e+01,6.728400e+01,5.886300e+01,4.856900e+01,5.008300e+01,&
     & 2.796100e+01,2.450300e+01,2.124800e+01,1.723300e+01,1.536700e+01,&
     & 3.726500e+01,3.258600e+01,2.826300e+01,2.296300e+01,2.126900e+01,&
     & 4.770600e+01,4.178300e+01,3.632700e+01,2.949000e+01,2.824600e+01,&
     & 5.923200e+01,5.196000e+01,4.528400e+01,3.687300e+01,3.644500e+01,&
     & 7.162400e+01,6.283600e+01,5.493000e+01,4.510400e+01,4.590200e+01,&
     & 2.458300e+01,2.158900e+01,1.876200e+01,1.519100e+01,1.329200e+01,&
     & 3.342600e+01,2.926800e+01,2.535700e+01,2.059000e+01,1.876900e+01,&
     & 4.342500e+01,3.801600e+01,3.300900e+01,2.680000e+01,2.530700e+01,&
     & 5.454900e+01,4.783800e+01,4.165200e+01,3.384200e+01,3.300100e+01,&
     & 6.663600e+01,5.847200e+01,5.104200e+01,4.174000e+01,4.194800e+01/
      data  absb(901:1175,15) /                                         &
     & 2.142100e+01,1.884300e+01,1.644000e+01,1.326600e+01,1.136600e+01,&
     & 2.976500e+01,2.608500e+01,2.260800e+01,1.834000e+01,1.643600e+01,&
     & 3.931200e+01,3.439800e+01,2.984800e+01,2.423900e+01,2.255300e+01,&
     & 5.000600e+01,4.382800e+01,3.812300e+01,3.094100e+01,2.976400e+01,&
     & 6.174100e+01,5.418200e+01,4.724400e+01,3.850200e+01,3.820700e+01,&
     & 1.864700e+01,1.645700e+01,1.441800e+01,1.159100e+01,9.726800e+00,&
     & 2.649200e+01,2.325400e+01,2.018400e+01,1.635400e+01,1.441100e+01,&
     & 3.561500e+01,3.117600e+01,2.703300e+01,2.194000e+01,2.012200e+01,&
     & 4.588700e+01,4.019400e+01,3.492500e+01,2.833500e+01,2.690400e+01,&
     & 5.726200e+01,5.023500e+01,4.377300e+01,3.557600e+01,3.487900e+01,&
     & 1.614300e+01,1.430600e+01,1.258600e+01,1.009300e+01,8.287000e+00,&
     & 2.347500e+01,2.064600e+01,1.796500e+01,1.452700e+01,1.258000e+01,&
     & 3.217300e+01,2.819100e+01,2.442700e+01,1.981800e+01,1.791200e+01,&
     & 4.202900e+01,3.679900e+01,3.194600e+01,2.593100e+01,2.430200e+01,&
     & 5.302100e+01,4.650500e+01,4.047700e+01,3.285800e+01,3.182500e+01,&
     & 1.384900e+01,1.232300e+01,1.090100e+01,8.725700e+00,7.003000e+00,&
     & 2.065600e+01,1.819400e+01,1.589700e+01,1.281000e+01,1.087900e+01,&
     & 2.888100e+01,2.532800e+01,2.196500e+01,1.780600e+01,1.584600e+01,&
     & 3.832800e+01,3.354600e+01,2.910600e+01,2.362200e+01,2.185000e+01,&
     & 4.891800e+01,4.288000e+01,3.728900e+01,3.024600e+01,2.893600e+01,&
     & 1.174000e+01,1.050600e+01,9.342000e+00,7.473000e+00,5.852400e+00,&
     & 1.800200e+01,1.591400e+01,1.395600e+01,1.121000e+01,9.327800e+00,&
     & 2.573100e+01,2.260700e+01,1.963400e+01,1.589700e+01,1.391800e+01,&
     & 3.475800e+01,3.044400e+01,2.639300e+01,2.141200e+01,1.953200e+01,&
     & 4.494000e+01,3.936700e+01,3.420100e+01,2.774200e+01,2.621300e+01,&
     & 9.982300e+00,8.983500e+00,8.043300e+00,6.421700e+00,4.923300e+00,&
     & 1.574300e+01,1.396800e+01,1.230000e+01,9.858900e+00,8.042500e+00,&
     & 2.299900e+01,2.023100e+01,1.762200e+01,1.423700e+01,1.226500e+01,&
     & 3.161900e+01,2.772100e+01,2.402100e+01,1.948100e+01,1.753300e+01,&
     & 4.142200e+01,3.626900e+01,3.148600e+01,2.554800e+01,2.386000e+01,&
     & 8.460000e+00,7.658700e+00,6.910500e+00,5.506400e+00,4.139300e+00,&
     & 1.374100e+01,1.223500e+01,1.082800e+01,8.664100e+00,6.931000e+00,&
     & 2.052500e+01,1.808900e+01,1.580900e+01,1.273300e+01,1.078500e+01,&
     & 2.873300e+01,2.521100e+01,2.186200e+01,1.771800e+01,1.573300e+01,&
     & 3.816700e+01,3.341400e+01,2.899400e+01,2.352300e+01,2.171700e+01,&
     & 7.094200e+00,6.470500e+00,5.884300e+00,4.682000e+00,3.460000e+00,&
     & 1.188800e+01,1.063800e+01,9.456300e+00,7.563600e+00,5.930600e+00,&
     & 1.819500e+01,1.608400e+01,1.410400e+01,1.132800e+01,9.425800e+00,&
     & 2.596500e+01,2.281600e+01,1.981300e+01,1.604200e+01,1.404400e+01,&
     & 3.503100e+01,3.068600e+01,2.660700e+01,2.158200e+01,1.968200e+01,&
     & 5.880900e+00,5.407300e+00,4.952000e+00,3.935800e+00,2.876500e+00,&
     & 1.018800e+01,9.164400e+00,8.199700e+00,6.547600e+00,5.035600e+00,&
     & 1.601100e+01,1.420400e+01,1.250400e+01,1.002200e+01,8.188700e+00,&
     & 2.333100e+01,2.052600e+01,1.787100e+01,1.444300e+01,1.245200e+01,&
     & 3.201300e+01,2.806600e+01,2.432100e+01,1.972200e+01,1.776300e+01,&
     & 4.859200e+00,4.512000e+00,4.153300e+00,3.305000e+00,2.406900e+00,&
     & 8.723500e+00,7.889800e+00,7.109800e+00,5.665900e+00,4.288000e+00,&
     & 1.409300e+01,1.254300e+01,1.109100e+01,8.878800e+00,7.131200e+00,&
     & 2.096900e+01,1.847300e+01,1.613700e+01,1.300400e+01,1.103700e+01,&
     & 2.925600e+01,2.566900e+01,2.225400e+01,1.803900e+01,1.604100e+01,&
     & 4.486000e+00,4.183200e+00,3.858900e+00,3.073200e+00,2.258800e+00,&
     & 8.176400e+00,7.415700e+00,6.701900e+00,5.337500e+00,4.038100e+00,&
     & 1.336300e+01,1.191300e+01,1.055300e+01,8.443700e+00,6.758300e+00,&
     & 2.005900e+01,1.769000e+01,1.547400e+01,1.245300e+01,1.051700e+01,&
     & 2.818800e+01,2.474000e+01,2.146000e+01,1.738800e+01,1.538200e+01/
      data  absb(1:300,16) /                                            &
     & 3.524000e+00,3.450800e+00,6.895700e+00,1.031000e+01,1.381000e+01,&
     & 5.018800e+00,4.888400e+00,9.766800e+00,1.460600e+01,1.956300e+01,&
     & 6.863600e+00,6.996300e+00,1.398300e+01,2.091700e+01,2.799600e+01,&
     & 8.998300e+00,9.923100e+00,1.982100e+01,2.965700e+01,3.970200e+01,&
     & 1.139100e+01,1.344800e+01,2.687300e+01,4.019700e+01,5.382100e+01,&
     & 4.086500e+00,4.262700e+00,8.515700e+00,1.273700e+01,1.706100e+01,&
     & 5.915200e+00,5.977000e+00,1.194100e+01,1.786100e+01,2.391900e+01,&
     & 8.111600e+00,8.494600e+00,1.697400e+01,2.539300e+01,3.399400e+01,&
     & 1.066700e+01,1.198200e+01,2.394100e+01,3.582000e+01,4.794700e+01,&
     & 1.357000e+01,1.616600e+01,3.229300e+01,4.832800e+01,6.467900e+01,&
     & 4.920500e+00,5.238100e+00,1.046700e+01,1.565700e+01,2.096200e+01,&
     & 7.110700e+00,7.325100e+00,1.463600e+01,2.189200e+01,2.931400e+01,&
     & 9.765700e+00,1.031900e+01,2.062500e+01,3.085700e+01,4.130700e+01,&
     & 1.286300e+01,1.434800e+01,2.866700e+01,4.290200e+01,5.741500e+01,&
     & 1.637700e+01,1.924500e+01,3.844000e+01,5.753000e+01,7.701400e+01,&
     & 6.001900e+00,6.375500e+00,1.274200e+01,1.906000e+01,2.551100e+01,&
     & 8.671900e+00,8.960100e+00,1.790500e+01,2.678200e+01,3.585800e+01,&
     & 1.189700e+01,1.249400e+01,2.496500e+01,3.735100e+01,5.000500e+01,&
     & 1.566400e+01,1.703300e+01,3.403900e+01,5.094300e+01,6.816000e+01,&
     & 1.993100e+01,2.260900e+01,4.514400e+01,6.760400e+01,9.038400e+01,&
     & 7.385900e+00,7.700400e+00,1.538900e+01,2.302300e+01,3.081600e+01,&
     & 1.064000e+01,1.086300e+01,2.170600e+01,3.247000e+01,4.346700e+01,&
     & 1.456300e+01,1.499200e+01,2.995800e+01,4.482400e+01,5.999100e+01,&
     & 1.913800e+01,2.015200e+01,4.021900e+01,6.018900e+01,8.051700e+01,&
     & 2.428600e+01,2.645900e+01,5.244800e+01,7.850400e+01,1.050100e+02,&
     & 9.122600e+00,9.259700e+00,1.849100e+01,2.766800e+01,3.703400e+01,&
     & 1.309000e+01,1.303800e+01,2.600800e+01,3.892300e+01,5.208300e+01,&
     & 1.787000e+01,1.786200e+01,3.554500e+01,5.319900e+01,7.116700e+01,&
     & 2.338400e+01,2.380200e+01,4.710500e+01,7.049400e+01,9.431600e+01,&
     & 2.960300e+01,3.095900e+01,6.061700e+01,9.076100e+01,1.213700e+02,&
     & 1.126700e+01,1.110300e+01,2.197500e+01,3.289100e+01,4.400000e+01,&
     & 1.610800e+01,1.558800e+01,3.073700e+01,4.599800e+01,6.153800e+01,&
     & 2.188000e+01,2.122600e+01,4.160300e+01,6.228600e+01,8.328400e+01,&
     & 2.854600e+01,2.806300e+01,5.455500e+01,8.165300e+01,1.092000e+02,&
     & 3.601500e+01,3.620900e+01,6.941800e+01,1.039800e+02,1.389700e+02,&
     & 1.399300e+01,1.337900e+01,2.592000e+01,3.880400e+01,5.189600e+01,&
     & 1.985700e+01,1.871100e+01,3.597000e+01,5.385800e+01,7.202000e+01,&
     & 2.684900e+01,2.530900e+01,4.823600e+01,7.222100e+01,9.656400e+01,&
     & 3.485400e+01,3.320400e+01,6.260500e+01,9.375400e+01,1.253200e+02,&
     & 4.382800e+01,4.246400e+01,7.893200e+01,1.182200e+02,1.580100e+02,&
     & 1.731500e+01,1.611400e+01,3.012900e+01,4.511500e+01,6.031400e+01,&
     & 2.439300e+01,2.239500e+01,4.148300e+01,6.211600e+01,8.304000e+01,&
     & 3.277600e+01,3.009100e+01,5.511900e+01,8.255900e+01,1.103300e+02,&
     & 4.229400e+01,3.917600e+01,7.092400e+01,1.062200e+02,1.419500e+02,&
     & 5.303800e+01,4.969200e+01,8.890800e+01,1.331700e+02,1.779400e+02,&
     & 2.182500e+01,1.977900e+01,3.524800e+01,5.279600e+01,7.055000e+01,&
     & 3.039600e+01,2.725300e+01,4.803300e+01,7.194800e+01,9.612500e+01,&
     & 4.038000e+01,3.623000e+01,6.317300e+01,9.466000e+01,1.264800e+02,&
     & 5.179700e+01,4.670700e+01,8.076600e+01,1.209900e+02,1.616500e+02,&
     & 6.454000e+01,5.872400e+01,1.007100e+02,1.508400e+02,2.015600e+02,&
     & 2.732000e+01,2.418800e+01,4.069300e+01,6.096000e+01,8.145300e+01,&
     & 3.755800e+01,3.297600e+01,5.497000e+01,8.233600e+01,1.100300e+02,&
     & 4.940800e+01,4.337500e+01,7.181600e+01,1.075900e+02,1.437300e+02,&
     & 6.287400e+01,5.535300e+01,9.130900e+01,1.368000e+02,1.827600e+02,&
     & 7.769800e+01,6.896100e+01,1.133300e+02,1.697800e+02,2.267900e+02,&
     & 3.386900e+01,2.938700e+01,4.664800e+01,6.990400e+01,9.336700e+01,&
     & 4.600600e+01,3.962200e+01,6.251500e+01,9.367900e+01,1.251100e+02,&
     & 5.994600e+01,5.157100e+01,8.120900e+01,1.216700e+02,1.625000e+02,&
     & 7.553900e+01,6.511000e+01,1.026500e+02,1.538000e+02,2.054200e+02,&
     & 9.247700e+01,8.044800e+01,1.266000e+02,1.896900e+02,2.533300e+02/
      data  absb(301:600,16) /                                          &
     & 4.159900e+01,3.545400e+01,5.314600e+01,7.964200e+01,1.063500e+02,&
     & 5.578200e+01,4.722800e+01,7.074000e+01,1.059700e+02,1.415500e+02,&
     & 7.194300e+01,6.074400e+01,9.133800e+01,1.368800e+02,1.827600e+02,&
     & 8.973500e+01,7.604300e+01,1.146000e+02,1.717500e+02,2.293200e+02,&
     & 1.088100e+02,9.302200e+01,1.406200e+02,2.107900e+02,2.813300e+02,&
     & 5.063300e+01,4.254000e+01,6.052100e+01,9.053300e+01,1.208900e+02,&
     & 6.703100e+01,5.588100e+01,7.983700e+01,1.196400e+02,1.597400e+02,&
     & 8.544900e+01,7.104600e+01,1.021900e+02,1.531400e+02,2.044800e+02,&
     & 1.055000e+02,8.810400e+01,1.274100e+02,1.909200e+02,2.549000e+02,&
     & 1.266200e+02,1.066500e+02,1.553500e+02,2.328400e+02,3.108500e+02,&
     & 6.076000e+01,5.036200e+01,6.862700e+01,1.021400e+02,1.363500e+02,&
     & 7.937200e+01,6.535100e+01,8.949600e+01,1.338100e+02,1.786200e+02,&
     & 1.000700e+02,8.217100e+01,1.135000e+02,1.701400e+02,2.270900e+02,&
     & 1.221900e+02,1.008600e+02,1.406000e+02,2.107700e+02,2.813500e+02,&
     & 1.451700e+02,1.207800e+02,1.703100e+02,2.552700e+02,3.407800e+02,&
     & 7.185000e+01,5.886500e+01,7.724900e+01,1.143500e+02,1.526300e+02,&
     & 9.265300e+01,7.539300e+01,9.967100e+01,1.485100e+02,1.982200e+02,&
     & 1.154100e+02,9.382100e+01,1.251500e+02,1.873800e+02,2.500900e+02,&
     & 1.394000e+02,1.140300e+02,1.538100e+02,2.305300e+02,3.077000e+02,&
     & 1.640600e+02,1.351700e+02,1.851000e+02,2.774800e+02,3.703000e+02,&
     & 8.387600e+01,6.795500e+01,8.653600e+01,1.271600e+02,1.697100e+02,&
     & 1.067100e+02,8.605000e+01,1.103500e+02,1.638600e+02,2.186900e+02,&
     & 1.312800e+02,1.059600e+02,1.373600e+02,2.052200e+02,2.738700e+02,&
     & 1.569100e+02,1.275000e+02,1.673700e+02,2.507100e+02,3.345400e+02,&
     & 1.830700e+02,1.496800e+02,1.998600e+02,2.996300e+02,3.998100e+02,&
     & 9.640200e+01,7.740300e+01,9.610000e+01,1.404200e+02,1.873300e+02,&
     & 1.211100e+02,9.691700e+01,1.212900e+02,1.795300e+02,2.395700e+02,&
     & 1.472500e+02,1.183000e+02,1.496700e+02,2.231900e+02,2.977800e+02,&
     & 1.743500e+02,1.408900e+02,1.809000e+02,2.707600e+02,3.612600e+02,&
     & 2.017400e+02,1.639100e+02,2.144700e+02,3.214000e+02,4.288100e+02,&
     & 1.093800e+02,8.712900e+01,1.060500e+02,1.542500e+02,2.057600e+02,&
     & 1.357100e+02,1.080000e+02,1.324700e+02,1.955000e+02,2.608600e+02,&
     & 1.632400e+02,1.306300e+02,1.621200e+02,2.412200e+02,3.218200e+02,&
     & 1.916200e+02,1.541200e+02,1.944700e+02,2.906900e+02,3.878300e+02,&
     & 2.198900e+02,1.778100e+02,2.290000e+02,3.430100e+02,4.576100e+02,&
     & 1.225600e+02,9.706700e+01,1.161700e+02,1.683600e+02,2.246100e+02,&
     & 1.503000e+02,1.191300e+02,1.439300e+02,2.117000e+02,2.824100e+02,&
     & 1.790500e+02,1.427900e+02,1.746300e+02,2.593600e+02,3.460100e+02,&
     & 2.083500e+02,1.670000e+02,2.079100e+02,3.104700e+02,4.140400e+02,&
     & 2.373400e+02,1.911800e+02,2.432700e+02,3.642000e+02,4.858400e+02,&
     & 1.357000e+02,1.070500e+02,1.263800e+02,1.827700e+02,2.437900e+02,&
     & 1.646900e+02,1.301500e+02,1.553000e+02,2.279700e+02,3.040800e+02,&
     & 1.944800e+02,1.546700e+02,1.870700e+02,2.773300e+02,3.699400e+02,&
     & 2.243600e+02,1.793600e+02,2.212200e+02,3.297600e+02,4.399100e+02,&
     & 2.539300e+02,2.039000e+02,2.572800e+02,3.848700e+02,5.133000e+02,&
     & 1.476900e+02,1.161500e+02,1.356100e+02,1.958000e+02,2.611500e+02,&
     & 1.776500e+02,1.401300e+02,1.654600e+02,2.425500e+02,3.235200e+02,&
     & 2.081900e+02,1.652200e+02,1.980800e+02,2.932700e+02,3.911400e+02,&
     & 2.385500e+02,1.902500e+02,2.329300e+02,3.469200e+02,4.627000e+02,&
     & 2.685000e+02,2.150300e+02,2.695500e+02,4.029200e+02,5.374200e+02,&
     & 1.564300e+02,1.227000e+02,1.419000e+02,2.043600e+02,2.725400e+02,&
     & 1.871300e+02,1.473000e+02,1.724300e+02,2.521400e+02,3.362900e+02,&
     & 2.181900e+02,1.728200e+02,2.056200e+02,3.037200e+02,4.050600e+02,&
     & 2.489500e+02,1.981400e+02,2.408100e+02,3.582500e+02,4.777500e+02,&
     & 2.791700e+02,2.231300e+02,2.778000e+02,4.149500e+02,5.533600e+02,&
     & 1.612800e+02,1.262300e+02,1.447000e+02,2.076000e+02,2.768200e+02,&
     & 1.925000e+02,1.511800e+02,1.755300e+02,2.558700e+02,3.412400e+02,&
     & 2.240000e+02,1.770600e+02,2.089400e+02,3.078700e+02,4.105000e+02,&
     & 2.551100e+02,2.026500e+02,2.443500e+02,3.628100e+02,4.838300e+02,&
     & 2.856600e+02,2.278100e+02,2.814400e+02,4.199400e+02,5.600500e+02/
      data  absb(601:900,16) /                                          &
     & 1.607400e+02,1.256200e+02,1.427000e+02,2.034200e+02,2.713100e+02,&
     & 1.923500e+02,1.506900e+02,1.733700e+02,2.515000e+02,3.354400e+02,&
     & 2.242200e+02,1.767600e+02,2.066100e+02,3.033700e+02,4.045600e+02,&
     & 2.556800e+02,2.026600e+02,2.419300e+02,3.583000e+02,4.778200e+02,&
     & 2.866100e+02,2.280700e+02,2.789400e+02,4.154800e+02,5.541100e+02,&
     & 1.593100e+02,1.243400e+02,1.402100e+02,1.985500e+02,2.648000e+02,&
     & 1.912000e+02,1.494700e+02,1.706400e+02,2.463400e+02,3.284900e+02,&
     & 2.233600e+02,1.756800e+02,2.036800e+02,2.979700e+02,3.973400e+02,&
     & 2.552000e+02,2.018400e+02,2.387900e+02,3.528200e+02,4.704500e+02,&
     & 2.864600e+02,2.274900e+02,2.757000e+02,4.098800e+02,5.466400e+02,&
     & 1.573700e+02,1.227200e+02,1.375200e+02,1.934700e+02,2.580000e+02,&
     & 1.894700e+02,1.478500e+02,1.676600e+02,2.408600e+02,3.211800e+02,&
     & 2.219000e+02,1.741400e+02,2.004800e+02,2.922700e+02,3.897600e+02,&
     & 2.540100e+02,2.005400e+02,2.354000e+02,3.468500e+02,4.625700e+02,&
     & 2.855700e+02,2.264000e+02,2.722000e+02,4.038700e+02,5.385300e+02,&
     & 1.517300e+02,1.183400e+02,1.317000e+02,1.836900e+02,2.449600e+02,&
     & 1.838700e+02,1.432600e+02,1.612600e+02,2.301400e+02,3.069000e+02,&
     & 2.165400e+02,1.695100e+02,1.935500e+02,2.809200e+02,3.746000e+02,&
     & 2.489600e+02,1.961100e+02,2.280600e+02,3.349000e+02,4.465800e+02,&
     & 2.808100e+02,2.222500e+02,2.645900e+02,3.916200e+02,5.222500e+02,&
     & 1.453100e+02,1.134400e+02,1.253900e+02,1.734200e+02,2.312600e+02,&
     & 1.773900e+02,1.380400e+02,1.543900e+02,2.188000e+02,2.917600e+02,&
     & 2.102200e+02,1.641800e+02,1.861200e+02,2.687300e+02,3.583200e+02,&
     & 2.429200e+02,1.908600e+02,2.201500e+02,3.219600e+02,4.293400e+02,&
     & 2.750700e+02,2.173000e+02,2.563000e+02,3.783900e+02,5.044900e+02,&
     & 1.385900e+02,1.083200e+02,1.190200e+02,1.632500e+02,2.176900e+02,&
     & 1.705200e+02,1.326600e+02,1.474500e+02,2.074900e+02,2.766500e+02,&
     & 2.034200e+02,1.585900e+02,1.786300e+02,2.564400e+02,3.419900e+02,&
     & 2.363500e+02,1.852800e+02,2.121500e+02,3.091300e+02,4.121300e+02,&
     & 2.688000e+02,2.119700e+02,2.477800e+02,3.648100e+02,4.864400e+02,&
     & 1.300100e+02,1.017800e+02,1.112300e+02,1.510000e+02,2.013200e+02,&
     & 1.615600e+02,1.257300e+02,1.389400e+02,1.937100e+02,2.582800e+02,&
     & 1.944300e+02,1.512800e+02,1.693000e+02,2.413400e+02,3.218200e+02,&
     & 2.275000e+02,1.779200e+02,2.021300e+02,2.930800e+02,3.907800e+02,&
     & 2.602500e+02,2.048000e+02,2.372400e+02,3.479800e+02,4.640300e+02,&
     & 1.206400e+02,9.469600e+01,1.029100e+02,1.382200e+02,1.843200e+02,&
     & 1.516400e+02,1.181700e+02,1.298000e+02,1.791300e+02,2.389300e+02,&
     & 1.842800e+02,1.432200e+02,1.593000e+02,2.252600e+02,3.003600e+02,&
     & 2.175300e+02,1.697200e+02,1.913900e+02,2.758300e+02,3.678200e+02,&
     & 2.504900e+02,1.966600e+02,2.257900e+02,3.297500e+02,4.396800e+02,&
     & 1.115100e+02,8.761300e+01,9.479000e+01,1.260800e+02,1.681200e+02,&
     & 1.416400e+02,1.105700e+02,1.207700e+02,1.650700e+02,2.200600e+02,&
     & 1.739600e+02,1.352000e+02,1.494500e+02,2.095800e+02,2.794600e+02,&
     & 2.072200e+02,1.613400e+02,1.807700e+02,2.588500e+02,3.450900e+02,&
     & 2.404100e+02,1.882300e+02,2.144100e+02,3.117900e+02,4.156900e+02,&
     & 1.020200e+02,8.026300e+01,8.645600e+01,1.138500e+02,1.518300e+02,&
     & 1.310200e+02,1.025100e+02,1.114300e+02,1.505800e+02,2.007700e+02,&
     & 1.628400e+02,1.266400e+02,1.392200e+02,1.932600e+02,2.576900e+02,&
     & 1.959300e+02,1.522800e+02,1.696100e+02,2.410100e+02,3.212700e+02,&
     & 2.293200e+02,1.791100e+02,2.024900e+02,2.928300e+02,3.903800e+02,&
     & 9.183300e+01,7.252100e+01,7.749200e+01,1.010700e+02,1.347800e+02,&
     & 1.193500e+02,9.363900e+01,1.012400e+02,1.352200e+02,1.803400e+02,&
     & 1.503100e+02,1.171400e+02,1.280000e+02,1.756800e+02,2.343000e+02,&
     & 1.831000e+02,1.421600e+02,1.573600e+02,2.214800e+02,2.953500e+02,&
     & 2.165500e+02,1.687500e+02,1.893100e+02,2.718700e+02,3.626100e+02,&
     & 8.243400e+01,6.527100e+01,6.908200e+01,8.931000e+01,1.190800e+02,&
     & 1.081500e+02,8.494000e+01,9.149700e+01,1.208500e+02,1.611700e+02,&
     & 1.379600e+02,1.077500e+02,1.171500e+02,1.589300e+02,2.119100e+02,&
     & 1.702400e+02,1.322700e+02,1.455000e+02,2.027500e+02,2.703300e+02,&
     & 2.036100e+02,1.582900e+02,1.764600e+02,2.514200e+02,3.352600e+02/
      data  absb(901:1175,16) /                                         &
     & 7.359100e+01,5.855500e+01,6.121700e+01,7.858500e+01,1.047800e+02,&
     & 9.746800e+01,7.678700e+01,8.219900e+01,1.075300e+02,1.433700e+02,&
     & 1.258900e+02,9.859500e+01,1.066400e+02,1.429900e+02,1.906300e+02,&
     & 1.574300e+02,1.225000e+02,1.339700e+02,1.846400e+02,2.461800e+02,&
     & 1.905200e+02,1.479400e+02,1.639100e+02,2.314900e+02,3.086800e+02,&
     & 6.596100e+01,5.263800e+01,5.439300e+01,6.939900e+01,9.253400e+01,&
     & 8.811600e+01,6.961600e+01,7.394800e+01,9.588300e+01,1.278400e+02,&
     & 1.149500e+02,9.022200e+01,9.718500e+01,1.289800e+02,1.719700e+02,&
     & 1.455600e+02,1.135000e+02,1.235000e+02,1.684600e+02,2.245300e+02,&
     & 1.782300e+02,1.383900e+02,1.524500e+02,2.134300e+02,2.845800e+02,&
     & 5.911900e+01,4.735400e+01,4.834400e+01,6.120400e+01,8.160400e+01,&
     & 7.968000e+01,6.316800e+01,6.645200e+01,8.553000e+01,1.141000e+02,&
     & 1.048200e+02,8.235600e+01,8.843000e+01,1.162300e+02,1.549700e+02,&
     & 1.342700e+02,1.049400e+02,1.136800e+02,1.533900e+02,2.045400e+02,&
     & 1.663900e+02,1.293200e+02,1.417300e+02,1.965200e+02,2.620200e+02,&
     & 5.274500e+01,4.246700e+01,4.275400e+01,5.368000e+01,7.157600e+01,&
     & 7.174700e+01,5.712900e+01,5.942400e+01,7.607300e+01,1.014200e+02,&
     & 9.520000e+01,7.504700e+01,8.007100e+01,1.043400e+02,1.391100e+02,&
     & 1.232800e+02,9.660800e+01,1.042000e+02,1.391800e+02,1.855600e+02,&
     & 1.546500e+02,1.203900e+02,1.312800e+02,1.802600e+02,2.403700e+02,&
     & 4.693100e+01,3.794200e+01,3.771700e+01,4.687300e+01,6.247900e+01,&
     & 6.442600e+01,5.143400e+01,5.293400e+01,6.732300e+01,8.976600e+01,&
     & 8.624200e+01,6.815400e+01,7.214700e+01,9.326600e+01,1.243600e+02,&
     & 1.127000e+02,8.842500e+01,9.507200e+01,1.257500e+02,1.676700e+02,&
     & 1.430600e+02,1.116100e+02,1.211600e+02,1.646500e+02,2.195700e+02,&
     & 4.207700e+01,3.416900e+01,3.348800e+01,4.126200e+01,5.490200e+01,&
     & 5.819000e+01,4.663400e+01,4.744100e+01,5.991500e+01,7.987800e+01,&
     & 7.851400e+01,6.228200e+01,6.532800e+01,8.392400e+01,1.119000e+02,&
     & 1.034200e+02,8.127600e+01,8.708600e+01,1.142000e+02,1.522700e+02,&
     & 1.326900e+02,1.037200e+02,1.121900e+02,1.509700e+02,2.013000e+02,&
     & 3.779700e+01,3.083600e+01,2.980500e+01,3.638300e+01,4.827100e+01,&
     & 5.258300e+01,4.233700e+01,4.255800e+01,5.336400e+01,7.112900e+01,&
     & 7.153800e+01,5.697100e+01,5.916200e+01,7.565300e+01,1.008800e+02,&
     & 9.494300e+01,7.484500e+01,7.976500e+01,1.038000e+02,1.384000e+02,&
     & 1.230000e+02,9.636700e+01,1.038400e+02,1.385400e+02,1.847200e+02,&
     & 3.387300e+01,2.774000e+01,2.648000e+01,3.194200e+01,4.220800e+01,&
     & 4.745300e+01,3.834300e+01,3.812500e+01,4.737900e+01,6.314800e+01,&
     & 6.509100e+01,5.194000e+01,5.345200e+01,6.796600e+01,9.062700e+01,&
     & 8.704600e+01,6.876400e+01,7.278400e+01,9.407200e+01,1.254300e+02,&
     & 1.136500e+02,8.917300e+01,9.582300e+01,1.267600e+02,1.690100e+02,&
     & 3.026900e+01,2.488700e+01,2.352200e+01,2.796600e+01,3.667200e+01,&
     & 4.274200e+01,3.468000e+01,3.402900e+01,4.194000e+01,5.582600e+01,&
     & 5.904900e+01,4.729100e+01,4.814600e+01,6.081300e+01,8.107900e+01,&
     & 7.958800e+01,6.309200e+01,6.621300e+01,8.506800e+01,1.134100e+02,&
     & 1.046700e+02,8.224100e+01,8.812700e+01,1.156100e+02,1.541700e+02,&
     & 2.718100e+01,2.240700e+01,2.104300e+01,2.457000e+01,3.190300e+01,&
     & 3.860700e+01,3.147300e+01,3.047000e+01,3.725500e+01,4.946200e+01,&
     & 5.366100e+01,4.316600e+01,4.345400e+01,5.450700e+01,7.268800e+01,&
     & 7.288100e+01,5.799600e+01,6.031000e+01,7.712500e+01,1.028400e+02,&
     & 9.658600e+01,7.608900e+01,8.113500e+01,1.056600e+02,1.409100e+02,&
     & 2.603100e+01,2.148200e+01,2.012600e+01,2.330300e+01,3.012900e+01,&
     & 3.706300e+01,3.025900e+01,2.915000e+01,3.548600e+01,4.706400e+01,&
     & 5.163000e+01,4.159600e+01,4.169000e+01,5.214400e+01,6.953900e+01,&
     & 7.035000e+01,5.603200e+01,5.804300e+01,7.411500e+01,9.884200e+01,&
     & 9.347400e+01,7.371600e+01,7.841600e+01,1.018600e+02,1.358100e+02/
 
!     the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG03=16).
 
      data  selfref(:, 1) /                                             &
     & 5.102860e-01,4.304240e-01,3.630610e-01,3.062410e-01,2.583130e-01,&
     & 2.178860e-01,1.837860e-01,1.550230e-01,1.307610e-01,1.102970e-01/
      data  selfref(:, 2) /                                             &
     & 4.967770e-01,4.307580e-01,3.735120e-01,3.238740e-01,2.808330e-01,&
     & 2.435120e-01,2.111500e-01,1.830890e-01,1.587580e-01,1.376590e-01/
      data  selfref(:, 3) /                                             &
     & 4.655950e-01,4.047780e-01,3.519050e-01,3.059390e-01,2.659760e-01,&
     & 2.312340e-01,2.010300e-01,1.747710e-01,1.519420e-01,1.320950e-01/
      data  selfref(:, 4) /                                             &
     & 4.346290e-01,3.867090e-01,3.440730e-01,3.061370e-01,2.723840e-01,&
     & 2.423530e-01,2.156330e-01,1.918580e-01,1.707050e-01,1.518840e-01/
      data  selfref(:, 5) /                                             &
     & 4.176250e-01,3.754420e-01,3.375190e-01,3.034270e-01,2.727780e-01,&
     & 2.452250e-01,2.204560e-01,1.981880e-01,1.781690e-01,1.601730e-01/
      data  selfref(:, 6) /                                             &
     & 3.974120e-01,3.612490e-01,3.283760e-01,2.984940e-01,2.713320e-01,&
     & 2.466410e-01,2.241980e-01,2.037960e-01,1.852510e-01,1.683940e-01/
      data  selfref(:, 7) /                                             &
     & 3.897950e-01,3.561780e-01,3.254600e-01,2.973910e-01,2.717430e-01,&
     & 2.483070e-01,2.268920e-01,2.073240e-01,1.894440e-01,1.731050e-01/
      data  selfref(:, 8) /                                             &
     & 3.790950e-01,3.468280e-01,3.173080e-01,2.903010e-01,2.655920e-01,&
     & 2.429860e-01,2.223050e-01,2.033840e-01,1.860730e-01,1.702350e-01/
      data  selfref(:, 9) /                                             &
     & 3.870860e-01,3.539880e-01,3.237200e-01,2.960400e-01,2.707270e-01,&
     & 2.475780e-01,2.264090e-01,2.070500e-01,1.893460e-01,1.731560e-01/
      data  selfref(:,10) /                                             &
     & 4.075290e-01,3.712840e-01,3.382630e-01,3.081790e-01,2.807700e-01,&
     & 2.557990e-01,2.330490e-01,2.123220e-01,1.934380e-01,1.762340e-01/
      data  selfref(:,11) /                                             &
     & 4.093150e-01,3.744200e-01,3.425000e-01,3.133020e-01,2.865920e-01,&
     & 2.621600e-01,2.398110e-01,2.193670e-01,2.006650e-01,1.835580e-01/
      data  selfref(:,12) /                                             &
     & 3.739960e-01,3.514620e-01,3.302860e-01,3.103850e-01,2.916840e-01,&
     & 2.741090e-01,2.575930e-01,2.420720e-01,2.274870e-01,2.137800e-01/
      data  selfref(:,13) /                                             &
     & 4.879650e-01,4.445250e-01,4.049520e-01,3.689020e-01,3.360610e-01,&
     & 3.061440e-01,2.788910e-01,2.540630e-01,2.314460e-01,2.108420e-01/
      data  selfref(:,14) /                                             &
     & 5.679990e-01,5.033360e-01,4.460340e-01,3.952560e-01,3.502590e-01,&
     & 3.103840e-01,2.750480e-01,2.437360e-01,2.159880e-01,1.913990e-01/
      data  selfref(:,15) /                                             &
     & 5.924920e-01,5.270720e-01,4.688740e-01,4.171030e-01,3.710480e-01,&
     & 3.300790e-01,2.936330e-01,2.612110e-01,2.323690e-01,2.067120e-01/
      data  selfref(:,16) /                                             &
     & 5.041760e-01,4.648450e-01,4.285820e-01,3.951480e-01,3.643220e-01,&
     & 3.359010e-01,3.096970e-01,2.855380e-01,2.632630e-01,2.427250e-01/
 
      data  forref /                                                    &
     &  1.768420e-04, 1.779130e-04, 1.251860e-04, 1.079120e-04,         &
     &  1.052170e-04, 7.487260e-05, 1.117010e-04, 7.689210e-05,         &
     &  9.872420e-05, 9.857110e-05, 6.165570e-05,-1.612910e-05,         &
     & -1.267940e-04,-1.190110e-04,-2.678140e-04, 6.950050e-05 /
 
      data  absn2oa /                                                   &
     & 1.503870e-01,2.914070e-01,6.288030e-01,9.656190e-01,1.150540e+00,&
     & 2.234240e+00,1.833920e+00,1.390330e+00,4.284570e-01,2.735020e-01,&
     & 1.843070e-01,1.613250e-01,7.663140e-02,1.338620e-01,6.711960e-07,&
     & 1.592930e-06 /
 
      data  absn2ob /                                                   &
     & 9.370440e-05,1.233180e-03,7.917200e-03,5.330050e-02,1.723430e-01,&
     & 4.295710e-01,1.012880e+00,3.838630e+00,1.153120e+01,1.083830e+00,&
     & 2.248470e+00,1.512680e+00,3.331770e-01,7.821020e-01,3.446310e-01,&
     & 1.610390e-03 /
 
      data   fracrefa(:,:) /                                            &
     & 0.1511639953,0.1487569958,0.1423230022,0.1323450059,0.1188160032,&
     & 0.1022410020,0.0834558010,0.0626749024,0.0425065011,0.0046265000,&
     & 0.0038225900,0.0030260000,0.0022200400,0.0014139700,0.0005337900,&
     & 0.0000742100,0.1526599973,0.1488839984,0.1419589967,0.1317950040,&
     & 0.1184270009,0.1020900011,0.0833612978,0.0626436993,0.0424765982,&
     & 0.0046194601,0.0038153599,0.0030260100,0.0022200400,0.0014139700,&
     & 0.0005330200,0.0000749800,0.1528279930,0.1490300000,0.1419239938,&
     & 0.1317429990,0.1183530018,0.1020269990,0.0832983032,0.0626482964,&
     & 0.0424690992,0.0046024201,0.0038190400,0.0030157301,0.0022200400,&
     & 0.0014139700,0.0005337900,0.0000742100,0.1529839933,0.1490280032,&
     & 0.1419340074,0.1317349970,0.1183329970,0.1019579992,0.0832472965,&
     & 0.0626477003,0.0424649008,0.0046048900,0.0038112300,0.0030189301,&
     & 0.0022109300,0.0014139700,0.0005337900,0.0000742100,0.1530759931,&
     & 0.1490720063,0.1419889927,0.1316979975,0.1182729974,0.1019229963,&
     & 0.0832159966,0.0626349002,0.0424560010,0.0046084598,0.0038083601,&
     & 0.0030166300,0.0022140199,0.0014116700,0.0005280700,0.0000737600,&
     & 0.1531140059,0.1491540074,0.1420730054,0.1316729933,0.1181930006,&
     & 0.1018889993,0.0831876025,0.0626195967,0.0424388982,0.0046158400,&
     & 0.0038092900,0.0030081500,0.0022173601,0.0014058800,0.0005277600,&
     & 0.0000737600,0.1531600058,0.1492549926,0.1421300024,0.1317099929,&
     & 0.1180770025,0.1018140018,0.0831739977,0.0626029968,0.0424272008,&
     & 0.0046152002,0.0038138099,0.0030128499,0.0022027500,0.0014037100,&
     & 0.0005277600,0.0000737600,0.1532119960,0.1494099945,0.1422249973,&
     & 0.1316419989,0.1179820001,0.1017450020,0.0831750035,0.0625364035,&
     & 0.0424312986,0.0046172398,0.0038153401,0.0030032001,0.0022009099,&
     & 0.0014036400,0.0005285200,0.0000730000,0.1531279981,0.1497309953,&
     & 0.1423439980,0.1316889971,0.1179519966,0.1015610024,0.0830299035,&
     & 0.0625223964,0.0424098000,0.0046103499,0.0038138099,0.0030017600,&
     & 0.0022016000,0.0014028400,0.0005277400,0.0000737600,0.1529249996,&
     & 0.1497800052,0.1424240023,0.1317259967,0.1179879978,0.1015639976,&
     & 0.0830304995,0.0625166968,0.0424096994,0.0046130200,0.0038145201,&
     & 0.0030024999,0.0022012601,0.0014032400,0.0005285000,0.0000730000/
      data   fracrefb(:,:) /                                            &
     & 0.1634020060,0.1560769975,0.1460140049,0.1318269968,0.1152469963,&
     & 0.0966657028,0.0782535970,0.0584978014,0.0394965000,0.0042798002,&
     & 0.0035371899,0.0027930301,0.0020478801,0.0013013900,0.0004905500,&
     & 0.0000690400,0.1576289982,0.1549469978,0.1465979964,0.1326780021,&
     & 0.1156269982,0.0983835980,0.0793042034,0.0596270002,0.0403635986,&
     & 0.0043805302,0.0036146301,0.0028572299,0.0020834501,0.0013213500,&
     & 0.0005052800,0.0000800300,0.1564150006,0.1539449990,0.1463360041,&
     & 0.1318040043,0.1161710024,0.0992416963,0.0800051019,0.0602141991,&
     & 0.0408273004,0.0044169398,0.0036536399,0.0028772301,0.0021091399,&
     & 0.0013578400,0.0005465100,0.0000800300,0.1548269987,0.1528629959,&
     & 0.1439249963,0.1324409992,0.1171199977,0.0999492034,0.0811920017,&
     & 0.0610436015,0.0413560010,0.0044668498,0.0036837701,0.0029076701,&
     & 0.0021544499,0.0014286500,0.0005614200,0.0000800300,0.1597509980,&
     & 0.1565349996,0.1421439946,0.1289220005,0.1150839999,0.0990602002,&
     & 0.0808793977,0.0607818998,0.0414053015,0.0045272401,0.0037455801,&
     & 0.0029532800,0.0021850900,0.0013864400,0.0005601800,0.0000800300/
 
      data etaref /                                                     &
     &   0.000,0.125,0.250,0.375,0.500,0.625,0.750,0.875,0.9875,1.0 /
 
      data h2oref /                                                     &
     &     1.87599e-02,1.22233e-02,5.89086e-03,2.76753e-03,1.40651e-03, &
     &     7.59698e-04,3.88758e-04,1.65422e-04,3.71895e-05,7.47648e-06, &
     &     4.30818e-06,3.33194e-06,3.20393e-06,3.16186e-06,3.25235e-06, &
     &     3.42258e-06,3.62884e-06,3.91482e-06,4.14875e-06,4.30810e-06, &
     &     4.44204e-06,4.57783e-06,4.70865e-06,4.79432e-06,4.86971e-06, &
     &     4.92603e-06,4.96688e-06,4.99628e-06,5.05266e-06,5.12658e-06, &
     &     5.25028e-06,5.35708e-06,5.45085e-06,5.48304e-06,5.50000e-06, &
     &     5.50000e-06,5.45359e-06,5.40468e-06,5.35576e-06,5.25327e-06, &
     &     5.14362e-06,5.03396e-06,4.87662e-06,4.69787e-06,4.51911e-06, &
     &     4.33600e-06,4.14416e-06,3.95232e-06,3.76048e-06,3.57217e-06, &
     &     3.38549e-06,3.19881e-06,3.01212e-06,2.82621e-06,2.64068e-06, &
     &     2.45515e-06,2.26962e-06,2.08659e-06,1.93029e-06 /
 
      data n2oref /                                                     &
     &     3.20000e-07,3.20000e-07,3.20000e-07,3.20000e-07,3.20000e-07, &
     &     3.19652e-07,3.15324e-07,3.03830e-07,2.94221e-07,2.84953e-07, &
     &     2.76714e-07,2.64709e-07,2.42847e-07,2.09547e-07,1.71945e-07, &
     &     1.37491e-07,1.13319e-07,1.00354e-07,9.12812e-08,8.54633e-08, &
     &     8.03631e-08,7.33718e-08,6.59754e-08,5.60386e-08,4.70901e-08, &
     &     3.99774e-08,3.29786e-08,2.60642e-08,2.10663e-08,1.65918e-08, &
     &     1.30167e-08,1.00900e-08,7.62490e-09,6.11592e-09,4.66725e-09, &
     &     3.28574e-09,2.84838e-09,2.46198e-09,2.07557e-09,1.85507e-09, &
     &     1.65675e-09,1.45843e-09,1.31948e-09,1.20716e-09,1.09485e-09, &
     &     9.97803e-10,9.31260e-10,8.64721e-10,7.98181e-10,7.51380e-10, &
     &     7.13670e-10,6.75960e-10,6.38250e-10,6.09811e-10,5.85998e-10, &
     &     5.62185e-10,5.38371e-10,5.15183e-10,4.98660e-10 /
 
      data co2ref /                                                     &
     &     53*3.55e-04, 3.5470873e-04, 3.5427220e-04, 3.5383567e-04,    &
     &                  3.5339911e-04, 3.5282588e-04, 3.5079606e-04 /
 
!........................................!
      end module module_radlw_kgb03_nmmb !
!========================================!
 
 
 
!========================================!
      module module_radlw_kgb04_nmmb     !
!........................................!
!
      use machine,                      only : kind_phys
      use module_radlw_parameters_nmmb, only : NG04
!
      implicit none
!
      private
!
      integer, public :: MSA04, MSB04, MSF04, MAF04, MBF04
      parameter (MSA04=585, MSB04=1410, MSF04=10, MAF04=9, MBF04=6)
 
      real (kind=kind_phys), public ::                                  &
     &       absa(MSA04,NG04), absb(MSB04,NG04), selfref(MSF04,NG04),   &
     &       fracrefa(NG04,MAF04), fracrefb(NG04,MBF04)
 
!     the array absa(585,NG04) = ka(9,5,13,NG04) contains absorption coefs
!     at the NG04=14 g-intervals for a range of pressure levels > ~100mb,
!     temperatures, and ratios of water vapor to co2.  the first index in
!     the array, js, runs from 1 to 9 and corresponds to different water
!     vapor to co2 ratios, as expressed through the binary species parameter
!     eta, defined as eta = h2o/(h20+rat*co2), where rat is the ratio of
!     the integrated line strength in the band of co2 to that of h2o.  for
!     instance, js=1 refers to dry air (eta = 0), js = 9 corresponds to
!     eta = 1.0. the 2nd index in the array, jt, which runs from 1 to 5,
!     corresponds to different temperatures. more specifically, jt = 1-5
!     means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively. the
!     third index, jp, runs from 1 to 13 and refers to the reference
!     pressure level (e.g. jp = 1 is for a pressure of 1053.63 mb).  the
!     fourth index, ig, goes from 1 to NG04=14, and tells us which
!     g-interval the absorption coefficients are for.
 
      data  absa(1:270,1) /                                             &
     &6.652000e-04,9.365100e-04,1.419500e-03,1.725500e-03,1.763600e-03, &
     &1.917900e-03,2.220400e-03,6.652100e-04,2.956000e-04,7.262400e-04, &
     &1.046600e-03,1.388800e-03,1.709600e-03,1.789700e-03,1.856100e-03, &
     &2.130000e-03,7.262400e-04,3.110300e-04,7.838300e-04,1.158400e-03, &
     &1.407100e-03,1.642000e-03,1.716000e-03,1.851800e-03,1.880200e-03, &
     &7.838200e-04,3.391400e-04,8.382800e-04,1.257000e-03,1.427700e-03, &
     &1.540600e-03,1.660100e-03,1.766100e-03,1.913500e-03,8.382800e-04, &
     &3.497600e-04,8.904200e-04,1.336300e-03,1.462300e-03,1.494900e-03, &
     &1.594800e-03,1.720900e-03,1.880000e-03,8.904200e-04,3.633900e-04, &
     &5.606200e-04,7.712700e-04,1.208400e-03,1.430700e-03,1.461000e-03, &
     &1.605200e-03,1.846500e-03,5.606400e-04,2.262200e-04,6.137500e-04, &
     &8.638000e-04,1.170100e-03,1.433600e-03,1.489500e-03,1.575600e-03, &
     &1.778900e-03,6.137500e-04,2.413700e-04,6.644300e-04,9.595300e-04, &
     &1.178100e-03,1.415800e-03,1.469300e-03,1.560600e-03,1.569400e-03, &
     &6.644300e-04,2.632000e-04,7.131500e-04,1.047800e-03,1.197500e-03, &
     &1.312800e-03,1.420700e-03,1.529900e-03,1.620400e-03,7.131500e-04, &
     &2.669700e-04,7.611000e-04,1.119600e-03,1.229400e-03,1.263600e-03, &
     &1.341600e-03,1.429200e-03,1.610300e-03,7.611000e-04,2.817600e-04, &
     &4.561000e-04,6.153200e-04,1.063400e-03,1.182800e-03,1.232100e-03, &
     &1.340700e-03,1.558500e-03,4.561000e-04,1.718800e-04,5.023800e-04, &
     &6.902100e-04,9.817900e-04,1.212400e-03,1.237500e-03,1.335900e-03, &
     &1.539600e-03,5.023800e-04,1.849200e-04,5.473500e-04,7.724900e-04, &
     &9.840199e-04,1.206800e-03,1.254600e-03,1.297500e-03,1.428300e-03, &
     &5.473500e-04,1.993900e-04,5.911200e-04,8.527500e-04,9.983300e-04, &
     &1.143200e-03,1.214300e-03,1.305300e-03,1.331600e-03,5.911100e-04, &
     &2.033400e-04,6.342200e-04,9.193300e-04,1.019900e-03,1.085200e-03, &
     &1.154000e-03,1.214500e-03,1.376000e-03,6.342200e-04,2.158300e-04, &
     &3.642300e-04,4.871400e-04,9.413900e-04,9.650700e-04,9.910400e-04, &
     &1.074000e-03,1.279700e-03,3.642300e-04,1.390500e-04,4.044800e-04, &
     &5.435300e-04,8.404100e-04,9.990000e-04,1.027000e-03,1.112900e-03, &
     &1.259400e-03,4.044800e-04,1.487500e-04,4.440100e-04,6.120100e-04, &
     &8.174800e-04,1.020500e-03,1.040600e-03,1.094300e-03,1.224900e-03, &
     &4.440100e-04,1.555900e-04,4.829100e-04,6.810700e-04,8.221800e-04, &
     &9.957600e-04,1.051500e-03,1.100600e-03,1.125200e-03,4.829100e-04, &
     &1.619000e-04,5.212300e-04,7.434300e-04,8.415100e-04,9.301900e-04, &
     &1.013000e-03,1.078500e-03,1.143900e-03,5.212300e-04,1.716500e-04, &
     &2.876300e-04,3.865400e-04,7.783800e-04,7.846700e-04,8.081700e-04, &
     &8.993800e-04,1.067600e-03,2.876300e-04,1.248500e-04,3.226900e-04, &
     &4.283000e-04,7.459000e-04,8.188700e-04,8.567400e-04,9.174400e-04, &
     &1.059800e-03,3.226900e-04,1.288800e-04,3.571000e-04,4.815000e-04, &
     &6.830100e-04,8.401400e-04,8.544700e-04,9.408200e-04,1.059500e-03, &
     &3.571000e-04,1.328700e-04,3.911400e-04,5.404400e-04,6.791300e-04, &
     &8.559800e-04,8.645100e-04,8.976800e-04,1.016000e-03,3.911400e-04, &
     &1.380100e-04,4.249300e-04,5.961600e-04,6.908100e-04,8.143200e-04, &
     &8.708600e-04,9.023000e-04,9.275100e-04,4.249300e-04,1.452400e-04, &
     &2.239700e-04,3.035200e-04,6.289300e-04,6.263300e-04,6.579300e-04, &
     &7.340300e-04,8.435000e-04,2.239700e-04,1.210700e-04,2.542000e-04, &
     &3.355700e-04,6.579700e-04,6.689100e-04,6.849100e-04,7.402300e-04, &
     &8.568700e-04,2.542000e-04,1.228000e-04,2.839600e-04,3.765500e-04, &
     &5.910200e-04,6.903300e-04,7.178300e-04,7.666700e-04,8.637600e-04, &
     &2.839600e-04,1.257700e-04,3.135000e-04,4.240400e-04,5.610900e-04, &
     &7.163200e-04,7.216900e-04,7.590200e-04,8.506300e-04,3.135000e-04, &
     &1.303800e-04,3.428300e-04,4.725900e-04,5.631500e-04,6.966900e-04, &
     &7.376700e-04,7.626600e-04,8.117900e-04,3.428300e-04,1.359400e-04/
      data  absa(271:585,1) /                                           &
     &1.726900e-04,2.397100e-04,5.029700e-04,4.986000e-04,5.247100e-04, &
     &5.793200e-04,6.843900e-04,1.726900e-04,1.238600e-04,1.984300e-04, &
     &2.625900e-04,5.353200e-04,5.372900e-04,5.560600e-04,6.093900e-04, &
     &7.123000e-04,1.984300e-04,1.261500e-04,2.239300e-04,2.936200e-04, &
     &5.335000e-04,5.638400e-04,5.875000e-04,6.258000e-04,7.225500e-04, &
     &2.239300e-04,1.302100e-04,2.492500e-04,3.315600e-04,4.693400e-04, &
     &5.825000e-04,5.935900e-04,6.545300e-04,7.230500e-04,2.492500e-04, &
     &1.352300e-04,2.747200e-04,3.718400e-04,4.628300e-04,5.997700e-04, &
     &6.030300e-04,6.209400e-04,7.062900e-04,2.747200e-04,1.412600e-04, &
     &1.322100e-04,1.919900e-04,3.977000e-04,3.993900e-04,4.180700e-04, &
     &4.573100e-04,5.298800e-04,1.322100e-04,1.450900e-04,1.539300e-04, &
     &2.055900e-04,4.325000e-04,4.290800e-04,4.496800e-04,4.958100e-04, &
     &5.688500e-04,1.539300e-04,1.503800e-04,1.755800e-04,2.291200e-04, &
     &4.552500e-04,4.599600e-04,4.714000e-04,5.138500e-04,5.903300e-04, &
     &1.755800e-04,1.576400e-04,1.971100e-04,2.582400e-04,4.099000e-04, &
     &4.760000e-04,4.938300e-04,5.272700e-04,5.917300e-04,1.971100e-04, &
     &1.667400e-04,2.189200e-04,2.915700e-04,3.826800e-04,4.945100e-04, &
     &4.988300e-04,5.270000e-04,5.943800e-04,2.189200e-04,1.774600e-04, &
     &1.003500e-04,1.595200e-04,3.129300e-04,3.134800e-04,3.266600e-04, &
     &3.702800e-04,4.142500e-04,1.003500e-04,2.666900e-04,1.185800e-04, &
     &1.634600e-04,3.452900e-04,3.416500e-04,3.565700e-04,3.928900e-04, &
     &4.594900e-04,1.185800e-04,2.907600e-04,1.369300e-04,1.786600e-04, &
     &3.670000e-04,3.708300e-04,3.833600e-04,4.166800e-04,4.818000e-04, &
     &1.369300e-04,3.156700e-04,1.551800e-04,2.011100e-04,3.663500e-04, &
     &3.885500e-04,4.047100e-04,4.304300e-04,4.928500e-04,1.551800e-04, &
     &3.420900e-04,1.736200e-04,2.275400e-04,3.220100e-04,4.029100e-04, &
     &4.125800e-04,4.491300e-04,4.961300e-04,1.736200e-04,3.692100e-04, &
     &7.675600e-05,1.396200e-04,2.476700e-04,2.491200e-04,2.596800e-04, &
     &2.865300e-04,3.299200e-04,7.675600e-05,9.233200e-04,9.197200e-05, &
     &1.317700e-04,2.749800e-04,2.746000e-04,2.876800e-04,3.148600e-04, &
     &3.611700e-04,9.197200e-05,1.029000e-03,1.074700e-04,1.412900e-04, &
     &2.976200e-04,2.972800e-04,3.108000e-04,3.392700e-04,3.854200e-04, &
     &1.074700e-04,1.125800e-03,1.229500e-04,1.584300e-04,3.085000e-04, &
     &3.153500e-04,3.252900e-04,3.538700e-04,4.042200e-04,1.229500e-04, &
     &1.211900e-03,1.385000e-04,1.791900e-04,2.796900e-04,3.291800e-04, &
     &3.414100e-04,3.638300e-04,4.059200e-04,1.385000e-04,1.288500e-03, &
     &6.426200e-05,1.148800e-04,2.065200e-04,2.069300e-04,2.151500e-04, &
     &2.375900e-04,2.707400e-04,6.426200e-05,1.743600e-03,7.706300e-05, &
     &1.091000e-04,2.289300e-04,2.283700e-04,2.388000e-04,2.598700e-04, &
     &3.006500e-04,7.706200e-05,1.935200e-03,9.012600e-05,1.175900e-04, &
     &2.467700e-04,2.475200e-04,2.593200e-04,2.816800e-04,3.206400e-04, &
     &9.012600e-05,2.101500e-03,1.031800e-04,1.320400e-04,2.534900e-04, &
     &2.611700e-04,2.704700e-04,2.944500e-04,3.335400e-04,1.031800e-04, &
     &2.237500e-03,1.162500e-04,1.497900e-04,2.304700e-04,2.728800e-04, &
     &2.831600e-04,3.022200e-04,3.371700e-04,1.162500e-04,2.349900e-03, &
     &5.383800e-05,9.447200e-05,1.722100e-04,1.722900e-04,1.791200e-04, &
     &1.981100e-04,2.229800e-04,5.383800e-05,2.219000e-03,6.458300e-05, &
     &9.041600e-05,1.907000e-04,1.899700e-04,1.985100e-04,2.162100e-04, &
     &2.488300e-04,6.458300e-05,2.450800e-03,7.557900e-05,9.814600e-05, &
     &2.047900e-04,2.055600e-04,2.150800e-04,2.347500e-04,2.656400e-04, &
     &7.557900e-05,2.646000e-03,8.653100e-05,1.100800e-04,2.088700e-04, &
     &2.163000e-04,2.243000e-04,2.441600e-04,2.768800e-04,8.653100e-05, &
     &2.801300e-03,9.742700e-05,1.249000e-04,1.885900e-04,2.259600e-04, &
     &2.333600e-04,2.505700e-04,2.788800e-04,9.742700e-05,2.923600e-03, &
     &4.509900e-05,7.751300e-05,1.432500e-04,1.438700e-04,1.490000e-04, &
     &1.640400e-04,1.847000e-04,4.510000e-05,2.313600e-03,5.413700e-05, &
     &7.516300e-05,1.587000e-04,1.579700e-04,1.650500e-04,1.793400e-04, &
     &2.068700e-04,5.413700e-05,2.540300e-03,6.332900e-05,8.172700e-05, &
     &1.696500e-04,1.706300e-04,1.787100e-04,1.951200e-04,2.203500e-04, &
     &6.332900e-05,2.728200e-03,7.245000e-05,9.177800e-05,1.721900e-04, &
     &1.791400e-04,1.863500e-04,2.020300e-04,2.294300e-04,7.245000e-05, &
     &2.878800e-03,8.153000e-05,1.039700e-04,1.547600e-04,1.873900e-04, &
     &1.932200e-04,2.081900e-04,2.307100e-04,8.153000e-05,2.995000e-03/
      data  absa(1:270,2) /                                             &
     &1.526000e-03,1.759500e-03,1.648000e-03,2.225800e-03,2.834400e-03, &
     &3.146900e-03,3.691800e-03,1.526000e-03,4.991400e-04,1.582600e-03, &
     &1.821200e-03,1.756100e-03,1.998000e-03,2.468100e-03,2.968400e-03, &
     &3.287200e-03,1.582600e-03,4.641500e-04,1.622700e-03,1.857100e-03, &
     &1.835000e-03,1.903200e-03,2.304600e-03,2.722000e-03,3.303000e-03, &
     &1.622700e-03,4.623100e-04,1.662700e-03,1.901600e-03,1.945000e-03, &
     &1.994500e-03,2.241400e-03,2.532700e-03,2.836300e-03,1.662700e-03, &
     &4.951600e-04,1.694200e-03,1.956700e-03,2.028200e-03,2.117800e-03, &
     &2.183700e-03,2.328900e-03,2.695100e-03,1.694200e-03,5.560400e-04, &
     &1.295700e-03,1.473600e-03,1.369600e-03,1.921900e-03,2.444800e-03, &
     &2.718500e-03,3.097300e-03,1.295700e-03,3.577700e-04,1.352000e-03, &
     &1.535200e-03,1.459400e-03,1.736300e-03,2.160800e-03,2.593100e-03, &
     &2.947700e-03,1.352000e-03,3.533400e-04,1.395500e-03,1.572800e-03, &
     &1.538800e-03,1.591000e-03,1.965200e-03,2.396500e-03,2.821400e-03, &
     &1.395500e-03,3.520800e-04,1.430600e-03,1.611900e-03,1.628900e-03, &
     &1.666800e-03,1.874900e-03,2.151500e-03,2.579800e-03,1.430600e-03, &
     &3.890300e-04,1.461800e-03,1.664800e-03,1.711200e-03,1.769600e-03, &
     &1.865800e-03,2.039000e-03,2.263000e-03,1.461800e-03,4.350100e-04, &
     &1.094100e-03,1.224900e-03,1.111000e-03,1.697800e-03,2.075700e-03, &
     &2.397700e-03,2.538500e-03,1.094100e-03,2.543500e-04,1.149600e-03, &
     &1.289300e-03,1.209400e-03,1.540000e-03,1.903700e-03,2.228200e-03, &
     &2.610800e-03,1.149600e-03,2.584400e-04,1.192600e-03,1.327800e-03, &
     &1.271700e-03,1.359000e-03,1.708800e-03,2.181200e-03,2.339200e-03, &
     &1.192600e-03,2.680400e-04,1.226700e-03,1.358900e-03,1.347300e-03, &
     &1.369000e-03,1.604200e-03,1.929000e-03,2.350700e-03,1.226700e-03, &
     &3.006500e-04,1.255400e-03,1.403400e-03,1.426900e-03,1.446200e-03, &
     &1.580300e-03,1.789100e-03,1.993400e-03,1.255400e-03,3.352900e-04, &
     &9.222800e-04,1.014400e-03,8.915500e-04,1.552300e-03,1.818200e-03, &
     &2.079000e-03,2.101900e-03,9.222900e-04,1.973900e-04,9.717300e-04, &
     &1.076400e-03,9.909400e-04,1.356300e-03,1.713000e-03,1.918200e-03, &
     &2.166600e-03,9.717300e-04,1.990000e-04,1.013800e-03,1.115100e-03, &
     &1.044500e-03,1.225100e-03,1.536900e-03,1.852100e-03,2.101300e-03, &
     &1.013800e-03,2.127600e-04,1.047300e-03,1.146000e-03,1.116100e-03, &
     &1.128400e-03,1.357800e-03,1.675400e-03,2.007700e-03,1.047300e-03, &
     &2.359500e-04,1.072600e-03,1.180500e-03,1.181400e-03,1.184800e-03, &
     &1.347900e-03,1.561500e-03,1.899400e-03,1.072600e-03,2.616500e-04, &
     &7.669000e-04,8.276500e-04,7.806200e-04,1.386700e-03,1.586700e-03, &
     &1.693600e-03,1.752100e-03,7.669000e-04,1.628000e-04,8.128500e-04, &
     &8.877400e-04,7.834100e-04,1.198800e-03,1.477000e-03,1.671900e-03, &
     &1.769300e-03,8.128500e-04,1.676800e-04,8.518300e-04,9.293000e-04, &
     &8.609800e-04,1.103500e-03,1.351700e-03,1.587100e-03,1.846800e-03, &
     &8.518200e-04,1.791800e-04,8.838100e-04,9.600500e-04,9.154700e-04, &
     &9.461000e-04,1.239600e-03,1.575700e-03,1.671900e-03,8.838100e-04, &
     &1.952800e-04,9.078000e-04,9.903800e-04,9.786700e-04,9.638500e-04, &
     &1.136300e-03,1.375000e-03,1.675900e-03,9.078000e-04,2.143000e-04, &
     &6.279500e-04,6.683800e-04,7.356100e-04,1.226300e-03,1.368300e-03, &
     &1.404600e-03,1.509400e-03,6.279500e-04,1.521600e-04,6.718300e-04, &
     &7.228800e-04,6.180100e-04,1.091900e-03,1.271200e-03,1.475700e-03, &
     &1.481400e-03,6.718300e-04,1.589400e-04,7.077300e-04,7.651300e-04, &
     &6.891200e-04,9.697400e-04,1.194500e-03,1.367100e-03,1.517000e-03, &
     &7.077300e-04,1.689700e-04,7.381600e-04,7.978200e-04,7.447300e-04, &
     &8.706500e-04,1.102800e-03,1.331000e-03,1.498200e-03,7.381600e-04, &
     &1.808300e-04,7.617300e-04,8.255700e-04,8.069600e-04,7.965300e-04, &
     &9.717100e-04,1.200100e-03,1.435000e-03,7.617300e-04,1.954400e-04/
      data  absa(271:585,2) /                                           &
     &5.089100e-04,5.328000e-04,7.282000e-04,1.060000e-03,1.189700e-03, &
     &1.202800e-03,1.264500e-03,5.089100e-04,1.681900e-04,5.501900e-04, &
     &5.855900e-04,5.505000e-04,9.818900e-04,1.113300e-03,1.199400e-03, &
     &1.217700e-03,5.501900e-04,1.774000e-04,5.843800e-04,6.258800e-04, &
     &5.219200e-04,8.687500e-04,1.039900e-03,1.176100e-03,1.221400e-03, &
     &5.843800e-04,1.889700e-04,6.123900e-04,6.568200e-04,6.071300e-04, &
     &7.780800e-04,9.733100e-04,1.114000e-03,1.301400e-03,6.123900e-04, &
     &2.029000e-04,6.346700e-04,6.841900e-04,6.529500e-04,6.755400e-04, &
     &8.811900e-04,1.113300e-03,1.205300e-03,6.346700e-04,2.187200e-04, &
     &4.093500e-04,4.188500e-04,6.710100e-04,9.125600e-04,1.019400e-03, &
     &1.013500e-03,1.081900e-03,4.093500e-04,2.182400e-04,4.469200e-04, &
     &4.711800e-04,5.165900e-04,8.591300e-04,9.635700e-04,9.884600e-04, &
     &1.042900e-03,4.469200e-04,2.369000e-04,4.790300e-04,5.092100e-04, &
     &4.251300e-04,7.786600e-04,8.942300e-04,1.020500e-03,1.021300e-03, &
     &4.790300e-04,2.581900e-04,5.051900e-04,5.387300e-04,4.747000e-04, &
     &6.824200e-04,8.492500e-04,9.608200e-04,1.056500e-03,5.051900e-04, &
     &2.816900e-04,5.264600e-04,5.635500e-04,5.317300e-04,6.213400e-04, &
     &7.850300e-04,9.370600e-04,1.032200e-03,5.264700e-04,3.057400e-04, &
     &3.263900e-04,3.206200e-04,6.170700e-04,7.954000e-04,8.456400e-04, &
     &8.581700e-04,9.072300e-04,3.263900e-04,5.554500e-04,3.601200e-04, &
     &3.731900e-04,5.022600e-04,7.425400e-04,8.402300e-04,8.330100e-04, &
     &8.572800e-04,3.601200e-04,6.116500e-04,3.898700e-04,4.122500e-04, &
     &3.790700e-04,6.853000e-04,7.788100e-04,8.377800e-04,8.481700e-04, &
     &3.898700e-04,6.665300e-04,4.142400e-04,4.391000e-04,3.605100e-04, &
     &6.100000e-04,7.290200e-04,8.199900e-04,8.439600e-04,4.142400e-04, &
     &7.181900e-04,4.343100e-04,4.623900e-04,4.228800e-04,5.488000e-04, &
     &6.886700e-04,7.786600e-04,8.909700e-04,4.343100e-04,7.720200e-04, &
     &2.606200e-04,2.409700e-04,5.676000e-04,6.783800e-04,7.083900e-04, &
     &7.458200e-04,7.558300e-04,2.606200e-04,2.527700e-03,2.902300e-04, &
     &2.954500e-04,4.517300e-04,6.299400e-04,7.172700e-04,7.000100e-04, &
     &7.342000e-04,2.902200e-04,2.778400e-03,3.170200e-04,3.329400e-04, &
     &3.452700e-04,5.979300e-04,6.677400e-04,6.935200e-04,7.131200e-04, &
     &3.170200e-04,3.014500e-03,3.391900e-04,3.581500e-04,2.945900e-04, &
     &5.360900e-04,6.295200e-04,7.002900e-04,6.997200e-04,3.391900e-04, &
     &3.222200e-03,3.576800e-04,3.792300e-04,3.287400e-04,4.754900e-04, &
     &5.948300e-04,6.731100e-04,7.361300e-04,3.576800e-04,3.403500e-03, &
     &2.190700e-04,2.032800e-04,4.641900e-04,5.629700e-04,5.890700e-04, &
     &6.115500e-04,6.101300e-04,2.190700e-04,5.124200e-03,2.441000e-04, &
     &2.484300e-04,3.713000e-04,5.228400e-04,5.976200e-04,5.858500e-04, &
     &6.013500e-04,2.441100e-04,5.586400e-03,2.662500e-04,2.793000e-04, &
     &2.818900e-04,4.940500e-04,5.540200e-04,5.772000e-04,5.857100e-04, &
     &2.662500e-04,6.006600e-03,2.848700e-04,3.001800e-04,2.447200e-04, &
     &4.420000e-04,5.265200e-04,5.824800e-04,5.796100e-04,2.848700e-04, &
     &6.376300e-03,3.001000e-04,3.171900e-04,2.731100e-04,3.920100e-04, &
     &4.942700e-04,5.630600e-04,6.163100e-04,3.001000e-04,6.680400e-03, &
     &1.839400e-04,1.711800e-04,3.773000e-04,4.679200e-04,4.897500e-04, &
     &4.991700e-04,5.039700e-04,1.839400e-04,6.795300e-03,2.048800e-04, &
     &2.089100e-04,3.035500e-04,4.353600e-04,4.919500e-04,4.836900e-04, &
     &4.961500e-04,2.048800e-04,7.372200e-03,2.233800e-04,2.337000e-04, &
     &2.285300e-04,4.084800e-04,4.605700e-04,4.813900e-04,4.829300e-04, &
     &2.233800e-04,7.888800e-03,2.390500e-04,2.512600e-04,2.015600e-04, &
     &3.655700e-04,4.399200e-04,4.819500e-04,4.852600e-04,2.390500e-04, &
     &8.318100e-03,2.512900e-04,2.646700e-04,2.290500e-04,3.227300e-04, &
     &4.123000e-04,4.663000e-04,5.124800e-04,2.512900e-04,8.638600e-03, &
     &1.543000e-04,1.444200e-04,3.080500e-04,3.895000e-04,4.076700e-04, &
     &4.117900e-04,4.133000e-04,1.543000e-04,7.305300e-03,1.717900e-04, &
     &1.751000e-04,2.481800e-04,3.619800e-04,4.062500e-04,3.997400e-04, &
     &4.116600e-04,1.717900e-04,7.902200e-03,1.874100e-04,1.957500e-04, &
     &1.860400e-04,3.367000e-04,3.827200e-04,4.014500e-04,4.006000e-04, &
     &1.874100e-04,8.414500e-03,2.003100e-04,2.097500e-04,1.665600e-04, &
     &3.037900e-04,3.676900e-04,4.007800e-04,4.018700e-04,2.003200e-04, &
     &8.801800e-03,2.101800e-04,2.207600e-04,1.915900e-04,2.644800e-04, &
     &3.443200e-04,3.851200e-04,4.242000e-04,2.101800e-04,9.068000e-03/
      data  absa(1:270,3) /                                             &
     &2.346500e-03,2.403100e-03,2.259700e-03,2.152400e-03,2.827600e-03, &
     &3.576100e-03,4.307900e-03,2.346500e-03,5.147100e-04,2.304200e-03, &
     &2.448500e-03,2.419900e-03,2.293800e-03,2.984700e-03,3.195200e-03, &
     &4.166700e-03,2.304200e-03,6.231900e-04,2.270000e-03,2.496600e-03, &
     &2.586200e-03,2.651100e-03,2.873800e-03,2.916400e-03,3.611800e-03, &
     &2.270000e-03,7.422900e-04,2.250900e-03,2.557300e-03,2.758100e-03, &
     &2.971800e-03,3.065700e-03,3.337600e-03,3.160000e-03,2.250900e-03, &
     &8.597700e-04,2.242200e-03,2.635500e-03,2.955200e-03,3.253100e-03, &
     &3.429600e-03,3.455800e-03,3.280800e-03,2.242200e-03,9.976600e-04, &
     &2.015700e-03,2.051000e-03,1.885100e-03,1.820600e-03,2.434300e-03, &
     &2.970400e-03,3.831100e-03,2.015700e-03,4.139600e-04,1.981500e-03, &
     &2.088600e-03,2.043900e-03,1.893800e-03,2.520400e-03,2.712800e-03, &
     &3.335000e-03,1.981500e-03,4.803900e-04,1.957600e-03,2.132600e-03, &
     &2.179000e-03,2.179500e-03,2.488200e-03,2.494100e-03,3.210900e-03, &
     &1.957500e-03,5.795500e-04,1.948100e-03,2.182900e-03,2.323500e-03, &
     &2.467600e-03,2.609700e-03,2.834900e-03,2.586800e-03,1.948100e-03, &
     &6.671400e-04,1.950700e-03,2.252100e-03,2.491200e-03,2.735600e-03, &
     &2.898700e-03,2.941800e-03,2.783000e-03,1.950700e-03,7.752300e-04, &
     &1.728500e-03,1.737700e-03,1.530500e-03,1.675700e-03,2.168000e-03, &
     &2.560900e-03,3.388700e-03,1.728500e-03,3.228000e-04,1.701500e-03, &
     &1.765300e-03,1.687800e-03,1.511200e-03,2.171900e-03,2.408300e-03, &
     &2.806100e-03,1.701500e-03,3.741200e-04,1.685100e-03,1.810100e-03, &
     &1.807300e-03,1.753900e-03,2.239800e-03,2.111200e-03,2.733300e-03, &
     &1.685100e-03,4.315700e-04,1.678600e-03,1.856700e-03,1.929100e-03, &
     &1.992700e-03,2.134700e-03,2.269300e-03,2.280100e-03,1.678600e-03, &
     &5.044800e-04,1.687700e-03,1.915600e-03,2.071000e-03,2.242000e-03, &
     &2.362500e-03,2.531000e-03,2.318200e-03,1.687700e-03,5.858300e-04, &
     &1.483400e-03,1.471100e-03,1.252200e-03,1.447900e-03,1.985400e-03, &
     &2.256900e-03,2.977500e-03,1.483400e-03,2.508100e-04,1.460100e-03, &
     &1.487000e-03,1.369000e-03,1.266200e-03,1.806000e-03,2.082600e-03, &
     &2.497700e-03,1.460100e-03,2.927700e-04,1.446700e-03,1.527100e-03, &
     &1.497900e-03,1.350000e-03,1.849700e-03,1.961000e-03,2.290700e-03, &
     &1.446700e-03,3.327100e-04,1.443200e-03,1.571400e-03,1.596900e-03, &
     &1.593700e-03,1.790200e-03,1.932000e-03,2.242000e-03,1.443200e-03, &
     &3.846700e-04,1.455000e-03,1.623600e-03,1.712700e-03,1.806800e-03, &
     &1.848600e-03,2.117600e-03,1.801800e-03,1.455100e-03,4.455100e-04, &
     &1.277300e-03,1.249700e-03,1.006400e-03,1.250600e-03,1.735200e-03, &
     &2.106400e-03,2.518800e-03,1.277300e-03,2.102500e-04,1.259500e-03, &
     &1.263400e-03,1.114700e-03,1.129600e-03,1.582400e-03,1.807500e-03, &
     &2.297800e-03,1.259500e-03,2.360100e-04,1.247100e-03,1.290700e-03, &
     &1.222600e-03,1.055900e-03,1.555600e-03,1.726400e-03,1.831900e-03, &
     &1.247100e-03,2.667400e-04,1.246000e-03,1.327700e-03,1.323200e-03, &
     &1.283900e-03,1.526600e-03,1.563900e-03,1.903000e-03,1.246000e-03, &
     &3.049100e-04,1.257500e-03,1.372100e-03,1.414300e-03,1.445300e-03, &
     &1.500600e-03,1.767400e-03,1.743600e-03,1.257500e-03,3.506000e-04, &
     &1.095800e-03,1.059500e-03,7.766400e-04,1.108500e-03,1.539300e-03, &
     &1.933800e-03,2.193400e-03,1.095800e-03,1.964500e-04,1.081600e-03, &
     &1.072700e-03,9.069500e-04,1.002300e-03,1.443400e-03,1.585600e-03, &
     &2.029100e-03,1.081600e-03,2.120800e-04,1.071000e-03,1.088800e-03, &
     &9.912900e-04,8.744300e-04,1.317900e-03,1.503300e-03,1.707700e-03, &
     &1.071000e-03,2.348100e-04,1.070800e-03,1.118600e-03,1.087400e-03, &
     &9.596900e-04,1.267100e-03,1.401000e-03,1.591700e-03,1.070800e-03, &
     &2.633900e-04,1.080600e-03,1.157200e-03,1.163100e-03,1.154500e-03, &
     &1.248500e-03,1.429400e-03,1.600400e-03,1.080600e-03,2.980300e-04/
      data  absa(271:585,3) /                                           &
     &9.334800e-04,8.909200e-04,5.716100e-04,1.020800e-03,1.378400e-03, &
     &1.703700e-03,1.893500e-03,9.334800e-04,2.114600e-04,9.217100e-04, &
     &9.032900e-04,7.147700e-04,8.490300e-04,1.277800e-03,1.494500e-03, &
     &1.727000e-03,9.217100e-04,2.300500e-04,9.141900e-04,9.192000e-04, &
     &8.116000e-04,7.643500e-04,1.121300e-03,1.330100e-03,1.621400e-03, &
     &9.141900e-04,2.523400e-04,9.140200e-04,9.396800e-04,8.812600e-04, &
     &7.528700e-04,1.057000e-03,1.247500e-03,1.299800e-03,9.140200e-04, &
     &2.781500e-04,9.229000e-04,9.725400e-04,9.564400e-04,8.947900e-04, &
     &1.050800e-03,1.126800e-03,1.350100e-03,9.229000e-04,3.080600e-04, &
     &7.890000e-04,7.448800e-04,4.621800e-04,9.631800e-04,1.237200e-03, &
     &1.523700e-03,1.672200e-03,7.890000e-04,3.076500e-04,7.804300e-04, &
     &7.542800e-04,5.436600e-04,7.590900e-04,1.087900e-03,1.355000e-03, &
     &1.479400e-03,7.804300e-04,3.386400e-04,7.746600e-04,7.698000e-04, &
     &6.496300e-04,7.000900e-04,9.764900e-04,1.168900e-03,1.432600e-03, &
     &7.746600e-04,3.728600e-04,7.750600e-04,7.887000e-04,7.157500e-04, &
     &6.186400e-04,8.956500e-04,1.070800e-03,1.238700e-03,7.750600e-04, &
     &4.107000e-04,7.828700e-04,8.156100e-04,7.783600e-04,6.683800e-04, &
     &8.845300e-04,9.515800e-04,1.162000e-03,7.828700e-04,4.522200e-04, &
     &6.635300e-04,6.220700e-04,4.149700e-04,8.532500e-04,1.154500e-03, &
     &1.320200e-03,1.454300e-03,6.635300e-04,9.225500e-04,6.582400e-04, &
     &6.278600e-04,3.933900e-04,7.116400e-04,9.591000e-04,1.224800e-03, &
     &1.283400e-03,6.582400e-04,1.004700e-03,6.533100e-04,6.392100e-04, &
     &5.101600e-04,5.965400e-04,8.759600e-04,1.085700e-03,1.214500e-03, &
     &6.533100e-04,1.090000e-03,6.541300e-04,6.595000e-04,5.824400e-04, &
     &5.397400e-04,7.925900e-04,9.302400e-04,1.160000e-03,6.541300e-04, &
     &1.180100e-03,6.602200e-04,6.811000e-04,6.363900e-04,5.271600e-04, &
     &7.231100e-04,8.501600e-04,9.625600e-04,6.602200e-04,1.268400e-03, &
     &5.553700e-04,5.165800e-04,3.596900e-04,7.577800e-04,1.026800e-03, &
     &1.118800e-03,1.238500e-03,5.553700e-04,4.664700e-03,5.529900e-04, &
     &5.225900e-04,3.172800e-04,6.552600e-04,8.436300e-04,1.073800e-03, &
     &1.079000e-03,5.529900e-04,4.996000e-03,5.488100e-04,5.306500e-04, &
     &3.937300e-04,5.236100e-04,7.601400e-04,9.469700e-04,1.040900e-03, &
     &5.488100e-04,5.303500e-03,5.501000e-04,5.487800e-04,4.703800e-04, &
     &4.934200e-04,6.758300e-04,8.068300e-04,1.029900e-03,5.501000e-04, &
     &5.605500e-03,5.559800e-04,5.687100e-04,5.224700e-04,4.361500e-04, &
     &6.181500e-04,7.443100e-04,8.600800e-04,5.559800e-04,5.886600e-03, &
     &4.638300e-04,4.318100e-04,2.931100e-04,6.261300e-04,8.446400e-04, &
     &9.433200e-04,1.027600e-03,4.638300e-04,9.782000e-03,4.617100e-04, &
     &4.364800e-04,2.656200e-04,5.338200e-04,6.968500e-04,9.017900e-04, &
     &9.012800e-04,4.617100e-04,1.039800e-02,4.597100e-04,4.449100e-04, &
     &3.350800e-04,4.326700e-04,6.386400e-04,7.794400e-04,8.892200e-04, &
     &4.597100e-04,1.094400e-02,4.625900e-04,4.629800e-04,4.017500e-04, &
     &4.089400e-04,5.587400e-04,6.657400e-04,8.637800e-04,4.625900e-04, &
     &1.145200e-02,4.697400e-04,4.822300e-04,4.481900e-04,3.710400e-04, &
     &5.100700e-04,6.109100e-04,6.909500e-04,4.697400e-04,1.191600e-02, &
     &3.867700e-04,3.603500e-04,2.418400e-04,5.164700e-04,6.994500e-04, &
     &8.046000e-04,8.371700e-04,3.867700e-04,1.327400e-02,3.852100e-04, &
     &3.640200e-04,2.224200e-04,4.344700e-04,5.811000e-04,7.404700e-04, &
     &7.632100e-04,3.852100e-04,1.406800e-02,3.845800e-04,3.729600e-04, &
     &2.869600e-04,3.575100e-04,5.296000e-04,6.436600e-04,7.517900e-04, &
     &3.845800e-04,1.475800e-02,3.881000e-04,3.894400e-04,3.437700e-04, &
     &3.335500e-04,4.669200e-04,5.574600e-04,7.089500e-04,3.881000e-04, &
     &1.537600e-02,3.959500e-04,4.086300e-04,3.812500e-04,3.120200e-04, &
     &4.267800e-04,5.113100e-04,5.748900e-04,3.959500e-04,1.594100e-02, &
     &3.219400e-04,2.997600e-04,1.985200e-04,4.256700e-04,5.752500e-04, &
     &6.706100e-04,6.990700e-04,3.219400e-04,1.456500e-02,3.210300e-04, &
     &3.034200e-04,1.851900e-04,3.515700e-04,4.879100e-04,6.193900e-04, &
     &6.516000e-04,3.210300e-04,1.539500e-02,3.211300e-04,3.120500e-04, &
     &2.441000e-04,2.957100e-04,4.408200e-04,5.295700e-04,6.274100e-04, &
     &3.211200e-04,1.610700e-02,3.254200e-04,3.275400e-04,2.910300e-04, &
     &2.667800e-04,3.885800e-04,4.666300e-04,5.770000e-04,3.254200e-04, &
     &1.676400e-02,3.327100e-04,3.452200e-04,3.231300e-04,2.630600e-04, &
     &3.532500e-04,4.278600e-04,4.775800e-04,3.327100e-04,1.732900e-02/
      data  absa(1:270,4) /                                             &
     &3.253900e-03,3.494000e-03,3.438800e-03,3.065900e-03,3.452200e-03, &
     &4.118800e-03,4.147200e-03,3.253900e-03,9.964600e-04,3.236300e-03, &
     &3.604500e-03,3.702100e-03,3.590100e-03,3.146300e-03,4.336000e-03, &
     &4.083800e-03,3.236300e-03,1.095600e-03,3.233400e-03,3.770000e-03, &
     &3.960200e-03,3.962900e-03,3.808100e-03,4.292500e-03,5.121900e-03, &
     &3.233400e-03,1.300700e-03,3.249000e-03,3.974800e-03,4.207100e-03, &
     &4.293500e-03,4.316400e-03,4.260400e-03,5.603300e-03,3.249000e-03, &
     &1.594400e-03,3.269800e-03,4.174000e-03,4.449700e-03,4.615500e-03, &
     &4.804700e-03,5.153700e-03,5.555900e-03,3.269800e-03,1.911900e-03, &
     &2.822900e-03,2.998400e-03,2.924800e-03,2.571000e-03,2.959100e-03, &
     &3.568500e-03,3.347100e-03,2.822900e-03,7.103700e-04,2.818200e-03, &
     &3.107900e-03,3.151000e-03,3.022000e-03,2.645600e-03,3.506500e-03, &
     &3.509100e-03,2.818200e-03,8.294100e-04,2.827300e-03,3.264100e-03, &
     &3.399100e-03,3.388200e-03,3.107600e-03,3.633900e-03,4.145300e-03, &
     &2.827300e-03,9.932900e-04,2.847900e-03,3.453700e-03,3.637800e-03, &
     &3.692200e-03,3.590200e-03,3.498500e-03,4.807900e-03,2.847900e-03, &
     &1.220700e-03,2.876200e-03,3.643500e-03,3.864000e-03,3.982900e-03, &
     &4.019600e-03,4.213700e-03,4.605700e-03,2.876200e-03,1.464500e-03, &
     &2.448000e-03,2.550300e-03,2.427600e-03,1.929900e-03,2.439400e-03, &
     &2.960000e-03,3.081900e-03,2.448000e-03,5.131000e-04,2.448400e-03, &
     &2.648900e-03,2.624900e-03,2.461300e-03,2.189100e-03,2.811300e-03, &
     &2.908500e-03,2.448400e-03,6.069500e-04,2.463100e-03,2.781700e-03, &
     &2.857800e-03,2.802100e-03,2.336100e-03,3.195600e-03,3.291200e-03, &
     &2.463100e-03,7.431300e-04,2.484300e-03,2.944000e-03,3.073400e-03, &
     &3.094700e-03,2.959600e-03,2.962100e-03,3.825400e-03,2.484300e-03, &
     &8.983100e-04,2.515200e-03,3.119000e-03,3.280100e-03,3.352700e-03, &
     &3.337400e-03,3.265300e-03,3.726600e-03,2.515200e-03,1.079700e-03, &
     &2.125000e-03,2.167000e-03,1.999000e-03,1.519900e-03,1.996200e-03, &
     &2.499500e-03,2.902400e-03,2.125000e-03,3.753100e-04,2.120400e-03, &
     &2.248900e-03,2.170000e-03,1.939900e-03,1.996300e-03,2.426600e-03, &
     &2.600000e-03,2.120400e-03,4.475600e-04,2.141300e-03,2.358700e-03, &
     &2.362700e-03,2.254400e-03,1.919500e-03,2.465800e-03,2.517200e-03, &
     &2.141300e-03,5.470500e-04,2.165400e-03,2.498000e-03,2.566300e-03, &
     &2.537300e-03,2.372800e-03,2.476900e-03,2.831800e-03,2.165400e-03, &
     &6.612500e-04,2.191300e-03,2.645600e-03,2.753600e-03,2.781600e-03, &
     &2.740500e-03,2.570200e-03,3.260500e-03,2.191300e-03,7.971400e-04, &
     &1.826500e-03,1.838100e-03,1.645700e-03,1.248600e-03,1.722900e-03, &
     &2.054700e-03,2.684800e-03,1.826500e-03,2.859600e-04,1.827400e-03, &
     &1.904800e-03,1.798300e-03,1.475200e-03,1.746900e-03,2.111600e-03, &
     &2.113400e-03,1.827400e-03,3.419000e-04,1.850800e-03,2.000300e-03, &
     &1.962000e-03,1.818800e-03,1.607700e-03,1.951600e-03,2.107300e-03, &
     &1.850800e-03,4.129200e-04,1.879300e-03,2.118200e-03,2.135000e-03, &
     &2.051700e-03,1.808700e-03,2.207100e-03,2.271400e-03,1.879300e-03, &
     &4.978900e-04,1.906500e-03,2.243500e-03,2.305300e-03,2.292600e-03, &
     &2.222400e-03,2.082900e-03,2.556500e-03,1.906500e-03,5.997500e-04, &
     &1.573800e-03,1.553600e-03,1.346200e-03,1.090500e-03,1.534500e-03, &
     &1.837800e-03,2.369600e-03,1.573800e-03,2.457000e-04,1.578500e-03, &
     &1.610200e-03,1.486400e-03,1.087800e-03,1.453300e-03,1.809600e-03, &
     &1.920800e-03,1.578500e-03,2.865000e-04,1.593800e-03,1.688600e-03, &
     &1.624200e-03,1.432900e-03,1.397100e-03,1.658800e-03,1.797700e-03, &
     &1.593800e-03,3.364600e-04,1.620700e-03,1.790300e-03,1.774000e-03, &
     &1.660900e-03,1.409000e-03,1.788000e-03,1.826400e-03,1.620700e-03, &
     &3.992700e-04,1.651400e-03,1.894500e-03,1.918900e-03,1.870700e-03, &
     &1.730900e-03,1.765100e-03,1.895600e-03,1.651400e-03,4.734100e-04/
      data  absa(271:585,4) /                                           &
     &1.356600e-03,1.317600e-03,1.080000e-03,9.987900e-04,1.364500e-03, &
     &1.671600e-03,2.013800e-03,1.356600e-03,2.711700e-04,1.361600e-03, &
     &1.361400e-03,1.229400e-03,8.694300e-04,1.244100e-03,1.455700e-03, &
     &1.762700e-03,1.361600e-03,3.049700e-04,1.373800e-03,1.425100e-03, &
     &1.342400e-03,1.074800e-03,1.323900e-03,1.494800e-03,1.489300e-03, &
     &1.373800e-03,3.454700e-04,1.390900e-03,1.506200e-03,1.467500e-03, &
     &1.331400e-03,1.129900e-03,1.425600e-03,1.510100e-03,1.390900e-03, &
     &3.936300e-04,1.421400e-03,1.593900e-03,1.592900e-03,1.515900e-03, &
     &1.304400e-03,1.554600e-03,1.584700e-03,1.421400e-03,4.499900e-04, &
     &1.163800e-03,1.113900e-03,8.479600e-04,8.466800e-04,1.239600e-03, &
     &1.509400e-03,1.697500e-03,1.163800e-03,4.305200e-04,1.167100e-03, &
     &1.149100e-03,9.970200e-04,7.189400e-04,1.115700e-03,1.283500e-03, &
     &1.517100e-03,1.167100e-03,4.724400e-04,1.176300e-03,1.197100e-03, &
     &1.106100e-03,7.562500e-04,1.094800e-03,1.322700e-03,1.324300e-03, &
     &1.176300e-03,5.190800e-04,1.188200e-03,1.258200e-03,1.208100e-03, &
     &1.041000e-03,9.493100e-04,1.211200e-03,1.235000e-03,1.188200e-03, &
     &5.724200e-04,1.214100e-03,1.332200e-03,1.314200e-03,1.220800e-03, &
     &9.867100e-04,1.312800e-03,1.345600e-03,1.214100e-03,6.312000e-04, &
     &9.933700e-04,9.374300e-04,6.197000e-04,7.545600e-04,1.108900e-03, &
     &1.340700e-03,1.506800e-03,9.933700e-04,1.442200e-03,9.947100e-04, &
     &9.660100e-04,8.026300e-04,6.426000e-04,9.903500e-04,1.171000e-03, &
     &1.328900e-03,9.947100e-04,1.549800e-03,1.002800e-03,1.003700e-03, &
     &9.038800e-04,5.939400e-04,8.748500e-04,1.077900e-03,1.196800e-03, &
     &1.002800e-03,1.663200e-03,1.013800e-03,1.050000e-03,9.879400e-04, &
     &7.632200e-04,8.531200e-04,1.104700e-03,1.066400e-03,1.013800e-03, &
     &1.776400e-03,1.032400e-03,1.107200e-03,1.075100e-03,9.675500e-04, &
     &7.982900e-04,1.035400e-03,1.133900e-03,1.032400e-03,1.883600e-03, &
     &8.439000e-04,7.888300e-04,4.549600e-04,6.397800e-04,9.706200e-04, &
     &1.188800e-03,1.302500e-03,8.439000e-04,7.797800e-03,8.441700e-04, &
     &8.104700e-04,6.403900e-04,5.586700e-04,8.677500e-04,1.010000e-03, &
     &1.197200e-03,8.441700e-04,8.165100e-03,8.520900e-04,8.421800e-04, &
     &7.370100e-04,4.805300e-04,7.550300e-04,9.450700e-04,1.039400e-03, &
     &8.520900e-04,8.532000e-03,8.624300e-04,8.787100e-04,8.137800e-04, &
     &5.479400e-04,7.569300e-04,9.409300e-04,9.069400e-04,8.624300e-04, &
     &8.888600e-03,8.783800e-04,9.250000e-04,8.854400e-04,7.604400e-04, &
     &6.423600e-04,8.235400e-04,9.454000e-04,8.783900e-04,9.232500e-03, &
     &7.114000e-04,6.668600e-04,3.965900e-04,5.312800e-04,8.239000e-04, &
     &9.633400e-04,1.053500e-03,7.114000e-04,1.675200e-02,7.147000e-04, &
     &6.892800e-04,5.485700e-04,4.779000e-04,7.001700e-04,8.457800e-04, &
     &9.623900e-04,7.147000e-04,1.746700e-02,7.240600e-04,7.182900e-04, &
     &6.325200e-04,4.013600e-04,6.047300e-04,8.122900e-04,8.641300e-04, &
     &7.240600e-04,1.815400e-02,7.375000e-04,7.508800e-04,6.960300e-04, &
     &4.800700e-04,6.283400e-04,7.534500e-04,7.853000e-04,7.375000e-04, &
     &1.877900e-02,7.557500e-04,7.936700e-04,7.560600e-04,6.521300e-04, &
     &5.471800e-04,7.019300e-04,8.340400e-04,7.557500e-04,1.935200e-02, &
     &5.982900e-04,5.615700e-04,3.434700e-04,4.414500e-04,6.800800e-04, &
     &7.839700e-04,8.512700e-04,5.983000e-04,2.322300e-02,6.034400e-04, &
     &5.838700e-04,4.695700e-04,3.973700e-04,5.769600e-04,7.207800e-04, &
     &7.893000e-04,6.034400e-04,2.417100e-02,6.138300e-04,6.105700e-04, &
     &5.401400e-04,3.430600e-04,5.045000e-04,6.794100e-04,7.330600e-04, &
     &6.138300e-04,2.504200e-02,6.290900e-04,6.418700e-04,5.944300e-04, &
     &4.204900e-04,5.124400e-04,6.192100e-04,6.811500e-04,6.290900e-04, &
     &2.583000e-02,6.501000e-04,6.812300e-04,6.480500e-04,5.624300e-04, &
     &4.555500e-04,5.806900e-04,6.976600e-04,6.501000e-04,2.653700e-02, &
     &5.026900e-04,4.730900e-04,2.972200e-04,3.602900e-04,5.532700e-04, &
     &6.726700e-04,6.964100e-04,5.026900e-04,2.594900e-02,5.086300e-04, &
     &4.932400e-04,4.022700e-04,3.251200e-04,4.743500e-04,5.721800e-04, &
     &6.496500e-04,5.086300e-04,2.696600e-02,5.199800e-04,5.175400e-04, &
     &4.604200e-04,2.920000e-04,4.191900e-04,5.592000e-04,6.235500e-04, &
     &5.199700e-04,2.790500e-02,5.356500e-04,5.472400e-04,5.086500e-04, &
     &3.727300e-04,4.179900e-04,5.112500e-04,5.579000e-04,5.356500e-04, &
     &2.873500e-02,5.569800e-04,5.837300e-04,5.555700e-04,4.851900e-04, &
     &3.808000e-04,4.857500e-04,5.986600e-04,5.569800e-04,2.948100e-02/
      data  absa(1:270,5) /                                             &
     &5.177300e-03,5.517900e-03,5.479400e-03,5.059000e-03,3.887000e-03, &
     &4.629600e-03,5.924100e-03,5.177300e-03,1.527700e-03,5.203400e-03, &
     &5.699300e-03,5.719500e-03,5.606500e-03,5.157100e-03,4.638300e-03, &
     &6.999800e-03,5.203400e-03,2.032700e-03,5.252300e-03,5.878700e-03, &
     &6.008400e-03,6.068400e-03,6.039700e-03,6.107300e-03,5.920800e-03, &
     &5.252300e-03,2.512500e-03,5.305400e-03,6.074600e-03,6.301000e-03, &
     &6.520500e-03,6.811100e-03,7.326900e-03,7.591500e-03,5.305400e-03, &
     &3.025900e-03,5.367900e-03,6.288000e-03,6.589600e-03,6.976900e-03, &
     &7.542600e-03,8.261600e-03,9.573400e-03,5.367900e-03,3.598800e-03, &
     &4.605000e-03,4.890400e-03,4.782600e-03,4.281200e-03,3.096100e-03, &
     &4.006600e-03,5.011500e-03,4.605000e-03,1.183300e-03,4.654600e-03, &
     &5.066900e-03,5.015300e-03,4.802800e-03,4.237100e-03,3.857100e-03, &
     &5.708200e-03,4.654500e-03,1.525000e-03,4.716300e-03,5.244500e-03, &
     &5.281800e-03,5.219300e-03,5.040100e-03,4.815800e-03,4.811100e-03, &
     &4.716300e-03,1.885100e-03,4.784000e-03,5.437500e-03,5.542800e-03, &
     &5.614500e-03,5.755700e-03,6.097900e-03,6.065000e-03,4.784000e-03, &
     &2.287200e-03,4.854100e-03,5.635000e-03,5.802900e-03,5.998300e-03, &
     &6.391600e-03,6.922000e-03,7.841700e-03,4.854200e-03,2.741000e-03, &
     &4.056600e-03,4.266600e-03,4.113600e-03,3.490200e-03,2.432000e-03, &
     &3.744800e-03,4.059600e-03,4.056600e-03,8.553700e-04,4.119200e-03, &
     &4.434300e-03,4.337400e-03,4.012600e-03,3.286300e-03,3.171000e-03, &
     &4.691300e-03,4.119200e-03,1.091200e-03,4.188300e-03,4.606800e-03, &
     &4.571000e-03,4.408000e-03,4.058700e-03,3.397000e-03,4.095000e-03, &
     &4.188300e-03,1.356400e-03,4.260700e-03,4.787400e-03,4.830200e-03, &
     &4.760000e-03,4.678900e-03,4.680300e-03,4.604600e-03,4.260700e-03, &
     &1.658700e-03,4.329100e-03,4.972900e-03,5.082100e-03,5.113200e-03, &
     &5.238900e-03,5.550100e-03,6.145300e-03,4.329100e-03,2.012300e-03, &
     &3.545900e-03,3.682500e-03,3.493200e-03,2.763700e-03,1.920100e-03, &
     &3.046000e-03,3.274900e-03,3.545900e-03,6.156100e-04,3.606100e-03, &
     &3.836200e-03,3.718200e-03,3.322300e-03,2.349700e-03,2.662700e-03, &
     &3.684500e-03,3.606100e-03,7.801100e-04,3.675100e-03,4.000900e-03, &
     &3.935200e-03,3.721200e-03,3.158600e-03,2.659900e-03,3.928400e-03, &
     &3.675100e-03,9.754100e-04,3.747200e-03,4.165700e-03,4.154700e-03, &
     &4.047100e-03,3.757900e-03,3.498700e-03,3.468400e-03,3.747200e-03, &
     &1.206000e-03,3.817300e-03,4.339200e-03,4.392600e-03,4.357500e-03, &
     &4.291900e-03,4.273000e-03,4.366200e-03,3.817300e-03,1.474300e-03, &
     &3.091100e-03,3.154700e-03,2.951700e-03,2.158500e-03,1.708900e-03, &
     &2.506500e-03,2.673600e-03,3.091100e-03,4.525900e-04,3.143200e-03, &
     &3.295200e-03,3.153500e-03,2.714400e-03,1.730500e-03,2.374000e-03, &
     &2.917100e-03,3.143200e-03,5.694000e-04,3.201100e-03,3.441800e-03, &
     &3.352600e-03,3.099800e-03,2.442400e-03,2.172800e-03,3.356300e-03, &
     &3.201100e-03,7.131300e-04,3.269100e-03,3.592500e-03,3.547600e-03, &
     &3.413000e-03,3.030400e-03,2.454200e-03,2.785300e-03,3.269100e-03, &
     &8.864100e-04,3.341300e-03,3.750700e-03,3.751200e-03,3.695400e-03, &
     &3.514400e-03,3.303900e-03,3.117400e-03,3.341300e-03,1.091300e-03, &
     &2.681400e-03,2.694000e-03,2.470600e-03,1.624100e-03,1.579600e-03, &
     &1.998600e-03,2.311100e-03,2.681400e-03,3.567300e-04,2.728600e-03, &
     &2.817000e-03,2.656600e-03,2.195300e-03,1.395100e-03,2.018700e-03, &
     &2.316700e-03,2.728600e-03,4.392800e-04,2.778400e-03,2.939600e-03, &
     &2.832300e-03,2.543100e-03,1.804500e-03,1.858000e-03,2.523000e-03, &
     &2.778400e-03,5.422500e-04,2.845700e-03,3.070700e-03,3.004000e-03, &
     &2.831300e-03,2.430400e-03,1.875700e-03,2.428000e-03,2.845700e-03, &
     &6.688000e-04,2.914900e-03,3.214500e-03,3.179100e-03,3.092700e-03, &
     &2.871800e-03,2.502000e-03,2.411400e-03,2.914900e-03,8.209000e-04/
      data  absa(271:585,5) /                                           &
     &2.316700e-03,2.295200e-03,2.069600e-03,1.177300e-03,1.400100e-03, &
     &1.674200e-03,2.111300e-03,2.316700e-03,3.655600e-04,2.361700e-03, &
     &2.399500e-03,2.227800e-03,1.756100e-03,1.222100e-03,1.703900e-03, &
     &1.925200e-03,2.361700e-03,4.226400e-04,2.412500e-03,2.506600e-03, &
     &2.381800e-03,2.080400e-03,1.264200e-03,1.632800e-03,2.016000e-03, &
     &2.412400e-03,4.946600e-04,2.472600e-03,2.618900e-03,2.534600e-03, &
     &2.333700e-03,1.928500e-03,1.539600e-03,2.285100e-03,2.472600e-03, &
     &5.821100e-04,2.534800e-03,2.747300e-03,2.687000e-03,2.569600e-03, &
     &2.323500e-03,1.815300e-03,1.952600e-03,2.534800e-03,6.881100e-04, &
     &1.995500e-03,1.948800e-03,1.734300e-03,8.557600e-04,1.216900e-03, &
     &1.398200e-03,1.880600e-03,1.995500e-03,5.842500e-04,2.036300e-03, &
     &2.038500e-03,1.871500e-03,1.367800e-03,1.148800e-03,1.358300e-03, &
     &1.663000e-03,2.036300e-03,6.494300e-04,2.084800e-03,2.135500e-03, &
     &2.001600e-03,1.709900e-03,1.049000e-03,1.361200e-03,1.530400e-03, &
     &2.084800e-03,7.203900e-04,2.140200e-03,2.234700e-03,2.137700e-03, &
     &1.928100e-03,1.457600e-03,1.361500e-03,1.749400e-03,2.140200e-03, &
     &7.914400e-04,2.191800e-03,2.343900e-03,2.273900e-03,2.132300e-03, &
     &1.870100e-03,1.411700e-03,1.669400e-03,2.191800e-03,8.742800e-04, &
     &1.708900e-03,1.646100e-03,1.436300e-03,6.601100e-04,1.023500e-03, &
     &1.257600e-03,1.602100e-03,1.708900e-03,2.190500e-03,1.744900e-03, &
     &1.724000e-03,1.561100e-03,9.593900e-04,1.017100e-03,1.093000e-03, &
     &1.498000e-03,1.744900e-03,2.303200e-03,1.789200e-03,1.809500e-03, &
     &1.677900e-03,1.370000e-03,8.873300e-04,1.197600e-03,1.236200e-03, &
     &1.789200e-03,2.428500e-03,1.836900e-03,1.897500e-03,1.797500e-03, &
     &1.588800e-03,1.020200e-03,1.188300e-03,1.343000e-03,1.836900e-03, &
     &2.568000e-03,1.881200e-03,1.987400e-03,1.912300e-03,1.761400e-03, &
     &1.464900e-03,1.149100e-03,1.571300e-03,1.881200e-03,2.722100e-03, &
     &1.457200e-03,1.386800e-03,1.182600e-03,6.234600e-04,8.676200e-04, &
     &1.083600e-03,1.334800e-03,1.457200e-03,1.265800e-02,1.488600e-03, &
     &1.453100e-03,1.300400e-03,6.923900e-04,8.686800e-04,9.616800e-04, &
     &1.256900e-03,1.488600e-03,1.305900e-02,1.526400e-03,1.527400e-03, &
     &1.405100e-03,1.074700e-03,7.721800e-04,9.741000e-04,1.085900e-03, &
     &1.526400e-03,1.344900e-02,1.566400e-03,1.601800e-03,1.502100e-03, &
     &1.301600e-03,7.544200e-04,1.042100e-03,1.098600e-03,1.566400e-03, &
     &1.382300e-02,1.603900e-03,1.678200e-03,1.602900e-03,1.455800e-03, &
     &1.142800e-03,9.845900e-04,1.231100e-03,1.603900e-03,1.419700e-02, &
     &1.251700e-03,1.190900e-03,1.025300e-03,4.890500e-04,7.359700e-04, &
     &9.042700e-04,1.258800e-03,1.251700e-03,2.827000e-02,1.281700e-03, &
     &1.248900e-03,1.120800e-03,6.028700e-04,7.225400e-04,8.294600e-04, &
     &1.020500e-03,1.281700e-03,2.903200e-02,1.312700e-03,1.311200e-03, &
     &1.205900e-03,9.418100e-04,6.213100e-04,8.617100e-04,8.910100e-04, &
     &1.312700e-03,2.969800e-02,1.345200e-03,1.374100e-03,1.288300e-03, &
     &1.121500e-03,6.576600e-04,8.735400e-04,9.302100e-04,1.345200e-03, &
     &3.033600e-02,1.375300e-03,1.437100e-03,1.374600e-03,1.254700e-03, &
     &9.951700e-04,7.985700e-04,1.095900e-03,1.375300e-03,3.095600e-02, &
     &1.073300e-03,1.021500e-03,8.845400e-04,3.900600e-04,6.235900e-04, &
     &7.408500e-04,1.039500e-03,1.073300e-03,4.015800e-02,1.098700e-03, &
     &1.070300e-03,9.622100e-04,5.352800e-04,5.811500e-04,7.143800e-04, &
     &8.320300e-04,1.098700e-03,4.119600e-02,1.125700e-03,1.122200e-03, &
     &1.030900e-03,8.129100e-04,4.903300e-04,7.234100e-04,7.553600e-04, &
     &1.125700e-03,4.214900e-02,1.152000e-03,1.173700e-03,1.099900e-03, &
     &9.665400e-04,5.789000e-04,6.999100e-04,7.925700e-04,1.152000e-03, &
     &4.306000e-02,1.177000e-03,1.226600e-03,1.172700e-03,1.074600e-03, &
     &8.650600e-04,6.573700e-04,9.185100e-04,1.177000e-03,4.389900e-02, &
     &9.172300e-04,8.734000e-04,7.585500e-04,3.316000e-04,5.189800e-04, &
     &6.067500e-04,8.366600e-04,9.172300e-04,4.580500e-02,9.389400e-04, &
     &9.141600e-04,8.217900e-04,4.836900e-04,4.697700e-04,6.304600e-04, &
     &6.991700e-04,9.389400e-04,4.710400e-02,9.617400e-04,9.572900e-04, &
     &8.793200e-04,7.045300e-04,4.016200e-04,5.924800e-04,6.337200e-04, &
     &9.617400e-04,4.824900e-02,9.843800e-04,1.000400e-03,9.357500e-04, &
     &8.253600e-04,5.055700e-04,5.568500e-04,6.808200e-04,9.843800e-04, &
     &4.929600e-02,1.008000e-03,1.046400e-03,9.986199e-04,9.176900e-04, &
     &7.491100e-04,5.513300e-04,7.214100e-04,1.008000e-03,5.023600e-02/
      data  absa(1:270,6) /                                             &
     &8.533300e-03,9.079800e-03,9.153900e-03,8.937900e-03,8.008200e-03, &
     &5.578300e-03,6.611700e-03,8.533300e-03,2.826100e-03,8.410900e-03, &
     &9.345900e-03,9.662400e-03,9.754700e-03,9.579600e-03,8.402700e-03, &
     &6.496100e-03,8.410900e-03,3.578000e-03,8.303000e-03,9.632600e-03, &
     &1.020600e-02,1.061400e-02,1.085800e-02,1.046200e-02,9.845600e-03, &
     &8.303000e-03,4.409000e-03,8.223700e-03,9.895800e-03,1.079600e-02, &
     &1.154500e-02,1.209900e-02,1.236900e-02,1.207700e-02,8.223700e-03, &
     &5.305000e-03,8.159900e-03,1.018100e-02,1.146900e-02,1.249000e-02, &
     &1.337700e-02,1.416500e-02,1.431800e-02,8.159900e-03,6.298700e-03, &
     &7.709400e-03,8.149500e-03,8.181700e-03,7.969000e-03,7.057400e-03, &
     &4.658300e-03,5.945800e-03,7.709400e-03,2.125300e-03,7.609800e-03, &
     &8.385700e-03,8.618800e-03,8.620200e-03,8.366800e-03,7.235400e-03, &
     &5.461400e-03,7.609800e-03,2.691100e-03,7.538000e-03,8.632400e-03, &
     &9.069600e-03,9.357800e-03,9.532300e-03,9.134400e-03,8.409900e-03, &
     &7.538000e-03,3.328300e-03,7.492600e-03,8.875000e-03,9.578100e-03, &
     &1.016400e-02,1.060300e-02,1.075500e-02,1.037800e-02,7.492600e-03, &
     &4.028800e-03,7.477500e-03,9.162700e-03,1.015600e-02,1.098200e-02, &
     &1.169500e-02,1.235200e-02,1.266700e-02,7.477500e-03,4.811600e-03, &
     &6.912100e-03,7.218800e-03,7.179600e-03,6.888900e-03,5.850200e-03, &
     &3.227800e-03,4.987900e-03,6.912100e-03,1.516000e-03,6.848000e-03, &
     &7.427600e-03,7.520300e-03,7.404800e-03,7.001400e-03,5.705500e-03, &
     &4.338400e-03,6.848000e-03,1.927900e-03,6.813500e-03,7.649300e-03, &
     &7.897600e-03,8.014100e-03,8.017000e-03,7.544100e-03,6.517400e-03, &
     &6.813500e-03,2.402800e-03,6.812200e-03,7.895600e-03,8.313100e-03, &
     &8.696500e-03,8.995200e-03,8.975200e-03,8.488200e-03,6.812200e-03, &
     &2.937500e-03,6.849200e-03,8.165700e-03,8.793600e-03,9.390400e-03, &
     &9.916800e-03,1.034500e-02,1.048400e-02,6.849200e-03,3.539000e-03, &
     &6.139700e-03,6.332400e-03,6.226900e-03,5.866600e-03,4.660100e-03, &
     &2.633500e-03,4.350200e-03,6.139700e-03,1.067600e-03,6.107100e-03, &
     &6.528100e-03,6.506100e-03,6.298700e-03,5.731500e-03,4.212200e-03, &
     &3.524300e-03,6.107100e-03,1.367400e-03,6.117300e-03,6.742400e-03, &
     &6.835100e-03,6.792800e-03,6.635500e-03,6.008400e-03,4.411100e-03, &
     &6.117300e-03,1.721600e-03,6.161600e-03,6.985000e-03,7.201800e-03, &
     &7.353300e-03,7.463900e-03,7.305400e-03,6.735500e-03,6.161600e-03, &
     &2.129500e-03,6.232700e-03,7.249800e-03,7.616600e-03,7.940400e-03, &
     &8.279900e-03,8.519600e-03,8.478000e-03,6.232700e-03,2.589300e-03, &
     &5.411600e-03,5.505400e-03,5.355100e-03,4.938700e-03,3.403000e-03, &
     &2.392500e-03,3.502600e-03,5.411600e-03,7.599100e-04,5.411200e-03, &
     &5.701300e-03,5.602400e-03,5.321500e-03,4.573500e-03,2.784300e-03, &
     &3.302100e-03,5.411200e-03,9.788900e-04,5.457100e-03,5.912400e-03, &
     &5.893900e-03,5.746800e-03,5.424200e-03,4.578400e-03,3.171100e-03, &
     &5.457100e-03,1.242000e-03,5.530300e-03,6.153900e-03,6.232200e-03, &
     &6.216600e-03,6.139500e-03,5.800200e-03,5.069400e-03,5.530300e-03, &
     &1.550800e-03,5.612600e-03,6.423100e-03,6.612000e-03,6.719300e-03, &
     &6.830700e-03,6.874700e-03,6.712900e-03,5.612600e-03,1.906900e-03, &
     &4.739600e-03,4.746300e-03,4.551800e-03,4.043300e-03,2.263800e-03, &
     &2.314100e-03,2.880500e-03,4.739600e-03,5.669800e-04,4.767300e-03, &
     &4.935700e-03,4.780100e-03,4.445700e-03,3.530400e-03,1.892000e-03, &
     &2.974700e-03,4.767300e-03,7.214600e-04,4.832600e-03,5.146000e-03, &
     &5.053800e-03,4.836200e-03,4.345500e-03,3.263800e-03,2.449200e-03, &
     &4.832600e-03,9.139300e-04,4.913800e-03,5.389800e-03,5.367000e-03, &
     &5.244800e-03,5.013500e-03,4.489000e-03,3.478100e-03,4.913700e-03, &
     &1.144100e-03,5.000700e-03,5.660500e-03,5.724600e-03,5.683400e-03, &
     &5.615900e-03,5.444900e-03,5.034300e-03,5.000700e-03,1.413900e-03/
      data  absa(271:585,6) /                                           &
     &4.137800e-03,4.075400e-03,3.838900e-03,3.247500e-03,1.485700e-03, &
     &2.102500e-03,2.298400e-03,4.137800e-03,5.248100e-04,4.182200e-03, &
     &4.252100e-03,4.057000e-03,3.668800e-03,2.530600e-03,1.483100e-03, &
     &2.606700e-03,4.182200e-03,6.311100e-04,4.250900e-03,4.458300e-03, &
     &4.308100e-03,4.048600e-03,3.447300e-03,2.109100e-03,1.976800e-03, &
     &4.250900e-03,7.639700e-04,4.333400e-03,4.687600e-03,4.603700e-03, &
     &4.430800e-03,4.065100e-03,3.364700e-03,2.158700e-03,4.333400e-03, &
     &9.287600e-04,4.422500e-03,4.934200e-03,4.941000e-03,4.819100e-03, &
     &4.628000e-03,4.287000e-03,3.612000e-03,4.422600e-03,1.125200e-03, &
     &3.609400e-03,3.503300e-03,3.240000e-03,2.628700e-03,9.986300e-04, &
     &1.750000e-03,1.896000e-03,3.609400e-03,8.260000e-04,3.663700e-03, &
     &3.664200e-03,3.443000e-03,3.021100e-03,1.711900e-03,1.355800e-03, &
     &2.146200e-03,3.663700e-03,9.081200e-04,3.735400e-03,3.845100e-03, &
     &3.674200e-03,3.369100e-03,2.681900e-03,1.391000e-03,1.947400e-03, &
     &3.735400e-03,1.010100e-03,3.811900e-03,4.050900e-03,3.930400e-03, &
     &3.722800e-03,3.324800e-03,2.376800e-03,1.665000e-03,3.812000e-03, &
     &1.135300e-03,3.897400e-03,4.269200e-03,4.218900e-03,4.080900e-03, &
     &3.814700e-03,3.318600e-03,2.441900e-03,3.897400e-03,1.274200e-03, &
     &3.150900e-03,3.013500e-03,2.741400e-03,2.084800e-03,8.022500e-04, &
     &1.386000e-03,1.609500e-03,3.150900e-03,3.287400e-03,3.206900e-03, &
     &3.155200e-03,2.930000e-03,2.512000e-03,1.188200e-03,1.224400e-03, &
     &1.813400e-03,3.206900e-03,3.442600e-03,3.277900e-03,3.314200e-03, &
     &3.129200e-03,2.817700e-03,2.055600e-03,1.003200e-03,1.796400e-03, &
     &3.277900e-03,3.600200e-03,3.351200e-03,3.491800e-03,3.347700e-03, &
     &3.121400e-03,2.709000e-03,1.562500e-03,1.356500e-03,3.351200e-03, &
     &3.758600e-03,3.430100e-03,3.685200e-03,3.595100e-03,3.431400e-03, &
     &3.154700e-03,2.550400e-03,1.520700e-03,3.430100e-03,3.931200e-03, &
     &2.743400e-03,2.599000e-03,2.341800e-03,1.598800e-03,7.703500e-04, &
     &1.215900e-03,1.397800e-03,2.743400e-03,2.004600e-02,2.798700e-03, &
     &2.724500e-03,2.502200e-03,2.112600e-03,8.970800e-04,1.076300e-03, &
     &1.509300e-03,2.798700e-03,2.051600e-02,2.863900e-03,2.862300e-03, &
     &2.682500e-03,2.383700e-03,1.579100e-03,8.761400e-04,1.414900e-03, &
     &2.863900e-03,2.093800e-02,2.934100e-03,3.019800e-03,2.877700e-03, &
     &2.642500e-03,2.209500e-03,1.119700e-03,1.206200e-03,2.934200e-03, &
     &2.134500e-02,3.012900e-03,3.189900e-03,3.082500e-03,2.904500e-03, &
     &2.620100e-03,1.965400e-03,1.192600e-03,3.012900e-03,2.174400e-02, &
     &2.393000e-03,2.276000e-03,2.047500e-03,1.491700e-03,6.151900e-04, &
     &9.573900e-04,1.211700e-03,2.393000e-03,4.601000e-02,2.449500e-03, &
     &2.389700e-03,2.196400e-03,1.877400e-03,8.879500e-04,8.578500e-04, &
     &1.221200e-03,2.449500e-03,4.711800e-02,2.510800e-03,2.514900e-03, &
     &2.360700e-03,2.117900e-03,1.506300e-03,7.248700e-04,1.161700e-03, &
     &2.510800e-03,4.804400e-02,2.579700e-03,2.661300e-03,2.539100e-03, &
     &2.335300e-03,1.979100e-03,1.104900e-03,9.488300e-04,2.579700e-03, &
     &4.880500e-02,2.649900e-03,2.818200e-03,2.722900e-03,2.558000e-03, &
     &2.314200e-03,1.807900e-03,1.003500e-03,2.649900e-03,4.939100e-02, &
     &2.074600e-03,1.978300e-03,1.780100e-03,1.355600e-03,4.826700e-04, &
     &8.146300e-04,1.018500e-03,2.074600e-03,6.754700e-02,2.127300e-03, &
     &2.077000e-03,1.910500e-03,1.648100e-03,8.372400e-04,7.168300e-04, &
     &1.010300e-03,2.127300e-03,6.926600e-02,2.184400e-03,2.191500e-03, &
     &2.059400e-03,1.858700e-03,1.389200e-03,6.475100e-04,9.572800e-04, &
     &2.184400e-03,7.061900e-02,2.244100e-03,2.322600e-03,2.220600e-03, &
     &2.045300e-03,1.749100e-03,1.040500e-03,7.813800e-04,2.244100e-03, &
     &7.160200e-02,2.305000e-03,2.459800e-03,2.382200e-03,2.238100e-03, &
     &2.030400e-03,1.632500e-03,9.243800e-04,2.305000e-03,7.230300e-02, &
     &1.788300e-03,1.706500e-03,1.537400e-03,1.200700e-03,4.302500e-04, &
     &6.759000e-04,8.188500e-04,1.788300e-03,7.986000e-02,1.836300e-03, &
     &1.794800e-03,1.652800e-03,1.432400e-03,7.677400e-04,6.224600e-04, &
     &8.132900e-04,1.836300e-03,8.180700e-02,1.886900e-03,1.896000e-03, &
     &1.781800e-03,1.609500e-03,1.239700e-03,5.695000e-04,8.231800e-04, &
     &1.886900e-03,8.329100e-02,1.937800e-03,2.007400e-03,1.920600e-03, &
     &1.775500e-03,1.532200e-03,9.584500e-04,6.970800e-04,1.937800e-03, &
     &8.441600e-02,1.990000e-03,2.125800e-03,2.064400e-03,1.940500e-03, &
     &1.765100e-03,1.441900e-03,8.368800e-04,1.990000e-03,8.529200e-02/
      data  absa(1:270,7) /                                             &
     &1.647300e-02,1.663900e-02,1.662000e-02,1.604400e-02,1.502400e-02, &
     &1.318700e-02,7.621300e-03,1.647300e-02,5.936900e-03,1.628300e-02, &
     &1.731900e-02,1.760100e-02,1.737100e-02,1.671400e-02,1.560600e-02, &
     &1.267500e-02,1.628300e-02,7.530900e-03,1.604400e-02,1.793900e-02, &
     &1.861600e-02,1.873600e-02,1.850900e-02,1.793200e-02,1.631600e-02, &
     &1.604400e-02,9.303400e-03,1.578000e-02,1.856600e-02,1.970700e-02, &
     &2.021800e-02,2.046800e-02,2.039200e-02,2.022100e-02,1.578000e-02, &
     &1.124100e-02,1.551400e-02,1.923900e-02,2.086600e-02,2.184800e-02, &
     &2.251800e-02,2.293800e-02,2.433800e-02,1.551400e-02,1.336900e-02, &
     &1.553400e-02,1.569800e-02,1.565500e-02,1.506800e-02,1.413500e-02, &
     &1.227000e-02,7.418100e-03,1.553400e-02,4.464000e-03,1.534200e-02, &
     &1.632400e-02,1.659000e-02,1.635300e-02,1.583100e-02,1.481500e-02, &
     &1.254300e-02,1.534200e-02,5.697000e-03,1.509800e-02,1.690400e-02, &
     &1.754500e-02,1.769100e-02,1.749700e-02,1.708500e-02,1.577600e-02, &
     &1.509800e-02,7.087600e-03,1.483400e-02,1.749100e-02,1.858300e-02, &
     &1.913600e-02,1.938100e-02,1.939600e-02,1.891900e-02,1.483400e-02, &
     &8.639200e-03,1.458200e-02,1.808700e-02,1.971000e-02,2.069900e-02, &
     &2.141500e-02,2.184400e-02,2.210100e-02,1.458200e-02,1.034400e-02, &
     &1.437900e-02,1.440000e-02,1.427300e-02,1.371400e-02,1.277400e-02, &
     &1.075800e-02,5.922100e-03,1.437900e-02,3.162700e-03,1.418100e-02, &
     &1.496200e-02,1.520400e-02,1.490600e-02,1.435700e-02,1.327500e-02, &
     &1.075000e-02,1.418100e-02,4.072000e-03,1.395500e-02,1.548500e-02, &
     &1.607800e-02,1.612400e-02,1.592800e-02,1.541900e-02,1.414500e-02, &
     &1.395500e-02,5.122700e-03,1.371500e-02,1.601900e-02,1.701100e-02, &
     &1.744300e-02,1.760100e-02,1.759900e-02,1.715100e-02,1.371500e-02, &
     &6.325100e-03,1.348800e-02,1.656600e-02,1.801500e-02,1.888500e-02, &
     &1.946600e-02,1.988000e-02,1.989100e-02,1.348800e-02,7.636200e-03, &
     &1.310000e-02,1.294800e-02,1.270900e-02,1.215200e-02,1.121100e-02, &
     &8.954000e-03,3.923500e-03,1.310000e-02,2.207700e-03,1.292200e-02, &
     &1.342100e-02,1.356300e-02,1.327300e-02,1.268700e-02,1.146500e-02, &
     &8.593200e-03,1.292200e-02,2.890800e-03,1.271000e-02,1.388600e-02, &
     &1.437300e-02,1.437100e-02,1.408000e-02,1.340700e-02,1.198500e-02, &
     &1.271000e-02,3.676000e-03,1.251000e-02,1.437300e-02,1.520000e-02, &
     &1.550300e-02,1.554200e-02,1.536400e-02,1.483500e-02,1.251000e-02, &
     &4.589100e-03,1.232500e-02,1.488500e-02,1.609900e-02,1.675800e-02, &
     &1.716900e-02,1.743500e-02,1.747100e-02,1.232500e-02,5.617900e-03, &
     &1.178500e-02,1.150700e-02,1.116800e-02,1.060000e-02,9.650700e-03, &
     &6.941400e-03,2.934500e-03,1.178500e-02,1.549600e-03,1.161800e-02, &
     &1.188600e-02,1.190600e-02,1.160100e-02,1.100800e-02,9.748200e-03, &
     &6.371600e-03,1.161800e-02,2.051300e-03,1.144700e-02,1.228800e-02, &
     &1.262000e-02,1.254000e-02,1.219600e-02,1.147500e-02,9.844800e-03, &
     &1.144700e-02,2.647400e-03,1.129300e-02,1.271900e-02,1.335000e-02, &
     &1.350900e-02,1.347200e-02,1.320700e-02,1.251700e-02,1.129300e-02, &
     &3.341400e-03,1.118300e-02,1.317800e-02,1.412300e-02,1.458300e-02, &
     &1.488300e-02,1.501500e-02,1.492600e-02,1.118300e-02,4.131200e-03, &
     &1.048700e-02,1.012400e-02,9.724900e-03,9.145700e-03,8.128500e-03, &
     &4.899600e-03,1.967800e-03,1.048700e-02,1.093700e-03,1.034900e-02, &
     &1.043700e-02,1.033200e-02,9.975400e-03,9.286600e-03,7.916000e-03, &
     &4.387800e-03,1.034900e-02,1.459800e-03,1.022000e-02,1.078400e-02, &
     &1.092900e-02,1.075300e-02,1.035300e-02,9.543200e-03,7.823200e-03, &
     &1.022000e-02,1.900800e-03,1.013500e-02,1.114300e-02,1.153000e-02, &
     &1.157600e-02,1.143900e-02,1.108800e-02,1.027700e-02,1.013500e-02, &
     &2.422100e-03,1.010200e-02,1.155400e-02,1.219400e-02,1.248000e-02, &
     &1.265200e-02,1.267800e-02,1.249400e-02,1.010200e-02,3.025700e-03/
      data  absa(271:585,7) /                                           &
     &9.230900e-03,8.831900e-03,8.396800e-03,7.795200e-03,6.747500e-03, &
     &3.287000e-03,1.917900e-03,9.230900e-03,8.964500e-04,9.124200e-03, &
     &9.093200e-03,8.904600e-03,8.499400e-03,7.773700e-03,6.209500e-03, &
     &2.821100e-03,9.124200e-03,1.134600e-03,9.049900e-03,9.388000e-03, &
     &9.391200e-03,9.143700e-03,8.664000e-03,7.805900e-03,5.835800e-03, &
     &9.049900e-03,1.437900e-03,9.031900e-03,9.728100e-03,9.888800e-03, &
     &9.824000e-03,9.604300e-03,9.153500e-03,8.262500e-03,9.031900e-03, &
     &1.816200e-03,9.067700e-03,1.011400e-02,1.045300e-02,1.059000e-02, &
     &1.061400e-02,1.051500e-02,1.021200e-02,9.067800e-03,2.270000e-03, &
     &8.075000e-03,7.662300e-03,7.213800e-03,6.597500e-03,5.425700e-03, &
     &2.272300e-03,1.624900e-03,8.075000e-03,1.283100e-03,7.999700e-03, &
     &7.879300e-03,7.622700e-03,7.181700e-03,6.421600e-03,4.536600e-03, &
     &1.973600e-03,7.999700e-03,1.449700e-03,7.973900e-03,8.149600e-03, &
     &8.022000e-03,7.722000e-03,7.187400e-03,6.245500e-03,3.853000e-03, &
     &7.973900e-03,1.655200e-03,8.012800e-03,8.469400e-03,8.461400e-03, &
     &8.295100e-03,7.966800e-03,7.436800e-03,6.344400e-03,8.012800e-03, &
     &1.896500e-03,8.113600e-03,8.834100e-03,8.971000e-03,8.945900e-03, &
     &8.820300e-03,8.600600e-03,8.140200e-03,8.113600e-03,2.190900e-03, &
     &7.029600e-03,6.630800e-03,6.180400e-03,5.536000e-03,4.143700e-03, &
     &1.563200e-03,1.434800e-03,7.029600e-03,5.074600e-03,6.989100e-03, &
     &6.815400e-03,6.504700e-03,6.012600e-03,5.166400e-03,3.130900e-03, &
     &1.344000e-03,6.989100e-03,5.257500e-03,7.004700e-03,7.068200e-03, &
     &6.840100e-03,6.467100e-03,5.888100e-03,4.803200e-03,2.440800e-03, &
     &7.004700e-03,5.472500e-03,7.093700e-03,7.364200e-03,7.226600e-03, &
     &6.960200e-03,6.550500e-03,5.947200e-03,4.622500e-03,7.093700e-03, &
     &5.707500e-03,7.235900e-03,7.718900e-03,7.689800e-03,7.539300e-03, &
     &7.279600e-03,6.954000e-03,6.311500e-03,7.235900e-03,5.939500e-03, &
     &6.082400e-03,5.720100e-03,5.295000e-03,4.653300e-03,3.124300e-03, &
     &1.084900e-03,1.351400e-03,6.082400e-03,3.203600e-02,6.081600e-03, &
     &5.899900e-03,5.571100e-03,5.054300e-03,4.167400e-03,2.195100e-03, &
     &1.151300e-03,6.081600e-03,3.264600e-02,6.145400e-03,6.149600e-03, &
     &5.854600e-03,5.443700e-03,4.818000e-03,3.642400e-03,1.733000e-03, &
     &6.145400e-03,3.307900e-02,6.275800e-03,6.438200e-03,6.199100e-03, &
     &5.878300e-03,5.435000e-03,4.723700e-03,3.281000e-03,6.275700e-03, &
     &3.340100e-02,6.434400e-03,6.777400e-03,6.629500e-03,6.394100e-03, &
     &6.067800e-03,5.639700e-03,4.897800e-03,6.434400e-03,3.365200e-02, &
     &5.281100e-03,5.005500e-03,4.633500e-03,4.075700e-03,2.872700e-03, &
     &1.086500e-03,1.017100e-03,5.281100e-03,7.684000e-02,5.340900e-03, &
     &5.214000e-03,4.880600e-03,4.414000e-03,3.662200e-03,2.030200e-03, &
     &9.181100e-04,5.340900e-03,7.787000e-02,5.467400e-03,5.475800e-03, &
     &5.163800e-03,4.767900e-03,4.220300e-03,3.224700e-03,1.598000e-03, &
     &5.467400e-03,7.859400e-02,5.617500e-03,5.767700e-03,5.509200e-03, &
     &5.189700e-03,4.772800e-03,4.126700e-03,2.988800e-03,5.617500e-03, &
     &7.895900e-02,5.784800e-03,6.088500e-03,5.918900e-03,5.678200e-03, &
     &5.343100e-03,4.922300e-03,4.250000e-03,5.784800e-03,7.914800e-02, &
     &4.640600e-03,4.426400e-03,4.075000e-03,3.582200e-03,2.651000e-03, &
     &1.013200e-03,9.215600e-04,4.640600e-03,1.176800e-01,4.751300e-03, &
     &4.650100e-03,4.313300e-03,3.881100e-03,3.250700e-03,1.850100e-03, &
     &7.392400e-04,4.751300e-03,1.189200e-01,4.889200e-03,4.896600e-03, &
     &4.592000e-03,4.216200e-03,3.735700e-03,2.901500e-03,1.440200e-03, &
     &4.889200e-03,1.198800e-01,5.043400e-03,5.164900e-03,4.911700e-03, &
     &4.608700e-03,4.234000e-03,3.674300e-03,2.665200e-03,5.043400e-03, &
     &1.204000e-01,5.194300e-03,5.460400e-03,5.285900e-03,5.053200e-03, &
     &4.746600e-03,4.336700e-03,3.675800e-03,5.194300e-03,1.206600e-01, &
     &4.104000e-03,3.932000e-03,3.601600e-03,3.166000e-03,2.419800e-03, &
     &9.600600e-04,7.433600e-04,4.104000e-03,1.447800e-01,4.223200e-03, &
     &4.142500e-03,3.833100e-03,3.440700e-03,2.904600e-03,1.697900e-03, &
     &6.792100e-04,4.223200e-03,1.462300e-01,4.361100e-03,4.369800e-03, &
     &4.089900e-03,3.746100e-03,3.327300e-03,2.660300e-03,1.296300e-03, &
     &4.361100e-03,1.474800e-01,4.499200e-03,4.614800e-03,4.384100e-03, &
     &4.096300e-03,3.757000e-03,3.285900e-03,2.368700e-03,4.499200e-03, &
     &1.481700e-01,4.632700e-03,4.872900e-03,4.708600e-03,4.488400e-03, &
     &4.210200e-03,3.839100e-03,3.259200e-03,4.632700e-03,1.484800e-01/
      data  absa(1:270,8) /                                             &
     &3.244600e-02,3.096100e-02,2.994300e-02,2.881400e-02,2.670100e-02, &
     &2.382600e-02,2.078600e-02,3.244600e-02,1.567600e-02,3.252700e-02, &
     &3.184800e-02,3.199400e-02,3.117500e-02,2.971900e-02,2.853200e-02, &
     &2.815700e-02,3.252700e-02,2.006000e-02,3.255500e-02,3.303500e-02, &
     &3.400900e-02,3.363200e-02,3.309800e-02,3.403500e-02,3.609300e-02, &
     &3.255500e-02,2.531900e-02,3.252000e-02,3.442400e-02,3.589300e-02, &
     &3.622100e-02,3.717300e-02,4.003700e-02,4.379000e-02,3.252000e-02, &
     &3.144400e-02,3.243600e-02,3.576100e-02,3.782800e-02,3.916700e-02, &
     &4.208100e-02,4.677700e-02,5.169900e-02,3.243600e-02,3.833900e-02, &
     &3.325900e-02,3.163700e-02,3.050200e-02,2.932200e-02,2.719200e-02, &
     &2.404500e-02,1.941800e-02,3.325900e-02,1.240100e-02,3.330900e-02, &
     &3.254200e-02,3.257900e-02,3.186900e-02,3.010900e-02,2.790000e-02, &
     &2.553000e-02,3.330900e-02,1.597100e-02,3.335200e-02,3.375500e-02, &
     &3.471800e-02,3.439200e-02,3.324600e-02,3.225000e-02,3.234900e-02, &
     &3.335200e-02,2.027800e-02,3.333000e-02,3.517400e-02,3.673700e-02, &
     &3.691600e-02,3.664100e-02,3.727400e-02,3.944100e-02,3.333000e-02, &
     &2.523400e-02,3.322600e-02,3.656900e-02,3.877700e-02,3.971300e-02, &
     &4.059600e-02,4.297900e-02,4.703200e-02,3.322600e-02,3.075900e-02, &
     &3.339100e-02,3.159400e-02,3.017600e-02,2.873900e-02,2.663300e-02, &
     &2.333600e-02,1.817700e-02,3.339100e-02,9.143800e-03,3.346300e-02, &
     &3.244500e-02,3.215400e-02,3.136200e-02,2.962600e-02,2.696300e-02, &
     &2.319800e-02,3.346300e-02,1.196400e-02,3.350700e-02,3.366600e-02, &
     &3.434800e-02,3.402000e-02,3.266400e-02,3.072900e-02,2.867500e-02, &
     &3.350700e-02,1.531200e-02,3.348400e-02,3.507600e-02,3.646000e-02, &
     &3.668500e-02,3.585100e-02,3.476000e-02,3.444600e-02,3.348400e-02, &
     &1.914400e-02,3.336500e-02,3.649100e-02,3.854600e-02,3.940000e-02, &
     &3.930900e-02,3.934000e-02,4.103900e-02,3.336500e-02,2.342600e-02, &
     &3.282300e-02,3.085600e-02,2.921600e-02,2.753600e-02,2.526300e-02, &
     &2.200500e-02,1.712600e-02,3.282300e-02,6.484700e-03,3.291600e-02, &
     &3.170300e-02,3.108100e-02,3.005900e-02,2.825200e-02,2.556600e-02, &
     &2.164300e-02,3.291600e-02,8.641100e-03,3.294200e-02,3.285500e-02, &
     &3.317200e-02,3.267900e-02,3.144200e-02,2.928300e-02,2.618000e-02, &
     &3.294200e-02,1.125600e-02,3.289500e-02,3.420700e-02,3.526100e-02, &
     &3.538600e-02,3.468300e-02,3.299200e-02,3.083000e-02,3.289500e-02, &
     &1.426600e-02,3.279100e-02,3.559800e-02,3.734200e-02,3.814400e-02, &
     &3.795800e-02,3.691500e-02,3.606000e-02,3.279100e-02,1.762300e-02, &
     &3.152700e-02,2.944100e-02,2.766600e-02,2.580000e-02,2.351700e-02, &
     &2.029000e-02,1.528400e-02,3.152700e-02,4.548300e-03,3.162700e-02, &
     &3.025300e-02,2.941000e-02,2.819100e-02,2.638500e-02,2.375400e-02, &
     &1.978200e-02,3.162700e-02,6.166200e-03,3.165300e-02,3.137400e-02, &
     &3.139400e-02,3.070400e-02,2.949900e-02,2.741000e-02,2.420700e-02, &
     &3.165300e-02,8.144700e-03,3.158700e-02,3.268100e-02,3.337300e-02, &
     &3.336400e-02,3.271100e-02,3.106100e-02,2.836600e-02,3.158700e-02, &
     &1.046000e-02,3.145900e-02,3.403500e-02,3.539100e-02,3.606300e-02, &
     &3.594100e-02,3.474700e-02,3.264300e-02,3.145900e-02,1.309500e-02, &
     &2.969000e-02,2.751300e-02,2.563300e-02,2.360500e-02,2.129800e-02, &
     &1.814700e-02,1.314600e-02,2.969000e-02,3.136900e-03,2.977000e-02, &
     &2.828800e-02,2.718300e-02,2.578900e-02,2.403600e-02,2.156100e-02, &
     &1.754300e-02,2.977000e-02,4.318700e-03,2.978300e-02,2.929400e-02, &
     &2.904500e-02,2.819200e-02,2.696000e-02,2.503400e-02,2.185800e-02, &
     &2.978300e-02,5.786700e-03,2.969200e-02,3.052300e-02,3.094600e-02, &
     &3.071500e-02,3.000700e-02,2.849700e-02,2.580000e-02,2.969200e-02, &
     &7.550200e-03,2.953400e-02,3.178300e-02,3.286900e-02,3.326200e-02, &
     &3.306400e-02,3.199900e-02,2.975500e-02,2.953400e-02,9.580000e-03/
      data  absa(271:585,8) /                                           &
     &2.739900e-02,2.521900e-02,2.331800e-02,2.125000e-02,1.890500e-02, &
     &1.586600e-02,1.021100e-02,2.739900e-02,2.213300e-03,2.746500e-02, &
     &2.591800e-02,2.466400e-02,2.319500e-02,2.141500e-02,1.904400e-02, &
     &1.528700e-02,2.746500e-02,3.058100e-03,2.746700e-02,2.684700e-02, &
     &2.636300e-02,2.538100e-02,2.410300e-02,2.226100e-02,1.929800e-02, &
     &2.746700e-02,4.137900e-03,2.737700e-02,2.796700e-02,2.811300e-02, &
     &2.772100e-02,2.689700e-02,2.551300e-02,2.301100e-02,2.737700e-02, &
     &5.443400e-03,2.720500e-02,2.909500e-02,2.988900e-02,3.006400e-02, &
     &2.973500e-02,2.882300e-02,2.678500e-02,2.720500e-02,6.988600e-03, &
     &2.483800e-02,2.273000e-02,2.087900e-02,1.884700e-02,1.656200e-02, &
     &1.359800e-02,7.926300e-03,2.483800e-02,2.319700e-03,2.489000e-02, &
     &2.336000e-02,2.203300e-02,2.052300e-02,1.879700e-02,1.656700e-02, &
     &1.279000e-02,2.489000e-02,2.780600e-03,2.486200e-02,2.416000e-02, &
     &2.352800e-02,2.249100e-02,2.119900e-02,1.947700e-02,1.680200e-02, &
     &2.486200e-02,3.407900e-03,2.477500e-02,2.515400e-02,2.510000e-02, &
     &2.457800e-02,2.371100e-02,2.238100e-02,2.021900e-02,2.477500e-02, &
     &4.258000e-03,2.462200e-02,2.614800e-02,2.669900e-02,2.667100e-02, &
     &2.629400e-02,2.537200e-02,2.358900e-02,2.462200e-02,5.336100e-03, &
     &2.222100e-02,2.020900e-02,1.841800e-02,1.649700e-02,1.436200e-02, &
     &1.145200e-02,5.846400e-03,2.222100e-02,8.104500e-03,2.222800e-02, &
     &2.073800e-02,1.939900e-02,1.792900e-02,1.627400e-02,1.418000e-02, &
     &1.025600e-02,2.222800e-02,8.497600e-03,2.218100e-02,2.141900e-02, &
     &2.068500e-02,1.963600e-02,1.837000e-02,1.674000e-02,1.422100e-02, &
     &2.218100e-02,8.906400e-03,2.207700e-02,2.225900e-02,2.205300e-02, &
     &2.145200e-02,2.056100e-02,1.927100e-02,1.733700e-02,2.207700e-02, &
     &9.366600e-03,2.195900e-02,2.314000e-02,2.345000e-02,2.328100e-02, &
     &2.278900e-02,2.185600e-02,2.032800e-02,2.195900e-02,9.896000e-03, &
     &1.966500e-02,1.781300e-02,1.613500e-02,1.437900e-02,1.242300e-02, &
     &9.619400e-03,4.366500e-03,1.966500e-02,5.085900e-02,1.965500e-02, &
     &1.825400e-02,1.696100e-02,1.558700e-02,1.405300e-02,1.208800e-02, &
     &8.138200e-03,1.965500e-02,5.146500e-02,1.957700e-02,1.880500e-02, &
     &1.805400e-02,1.705800e-02,1.585000e-02,1.433600e-02,1.195000e-02, &
     &1.957700e-02,5.195500e-02,1.947300e-02,1.952300e-02,1.922700e-02, &
     &1.859100e-02,1.770000e-02,1.647800e-02,1.469300e-02,1.947300e-02, &
     &5.235400e-02,1.940500e-02,2.028800e-02,2.042300e-02,2.013200e-02, &
     &1.956400e-02,1.869100e-02,1.734700e-02,1.940500e-02,5.268200e-02, &
     &1.719900e-02,1.569200e-02,1.430700e-02,1.286100e-02,1.126200e-02, &
     &9.031600e-03,4.421200e-03,1.719900e-02,1.264100e-01,1.713900e-02, &
     &1.608900e-02,1.509400e-02,1.399500e-02,1.269900e-02,1.106300e-02, &
     &8.129400e-03,1.713900e-02,1.263000e-01,1.706200e-02,1.661600e-02, &
     &1.606800e-02,1.525000e-02,1.421300e-02,1.292700e-02,1.096800e-02, &
     &1.706200e-02,1.265700e-01,1.702700e-02,1.728400e-02,1.707400e-02, &
     &1.650300e-02,1.572700e-02,1.474700e-02,1.330200e-02,1.702700e-02, &
     &1.268000e-01,1.705100e-02,1.800300e-02,1.809700e-02,1.779500e-02, &
     &1.733800e-02,1.667000e-02,1.565600e-02,1.705100e-02,1.266800e-01, &
     &1.489200e-02,1.370700e-02,1.258900e-02,1.142400e-02,1.009600e-02, &
     &8.281500e-03,4.423300e-03,1.489200e-02,2.017800e-01,1.483000e-02, &
     &1.407600e-02,1.332700e-02,1.241500e-02,1.130600e-02,9.912800e-03, &
     &7.651000e-03,1.483000e-02,2.012700e-01,1.481500e-02,1.461600e-02, &
     &1.416600e-02,1.343600e-02,1.253100e-02,1.141900e-02,9.814400e-03, &
     &1.481500e-02,2.010900e-01,1.487400e-02,1.524900e-02,1.501900e-02, &
     &1.448400e-02,1.380200e-02,1.296900e-02,1.180200e-02,1.487400e-02, &
     &2.010800e-01,1.502800e-02,1.594700e-02,1.592300e-02,1.563000e-02, &
     &1.520500e-02,1.466500e-02,1.388800e-02,1.502800e-02,2.006100e-01, &
     &1.285600e-02,1.192600e-02,1.103400e-02,1.005100e-02,8.904800e-03, &
     &7.380800e-03,4.356000e-03,1.285600e-02,2.594700e-01,1.284900e-02, &
     &1.231700e-02,1.169200e-02,1.088200e-02,9.888400e-03,8.678600e-03, &
     &6.847900e-03,1.284900e-02,2.595300e-01,1.291300e-02,1.285000e-02, &
     &1.241700e-02,1.172100e-02,1.088200e-02,9.919000e-03,8.602300e-03, &
     &1.291300e-02,2.594200e-01,1.308800e-02,1.347100e-02,1.316900e-02, &
     &1.263700e-02,1.198900e-02,1.124800e-02,1.030100e-02,1.308800e-02, &
     &2.590900e-01,1.337300e-02,1.415900e-02,1.402900e-02,1.367900e-02, &
     &1.324100e-02,1.274900e-02,1.212500e-02,1.337300e-02,2.581500e-01/
      data  absa(1:270,9) /                                             &
     &6.473300e-02,6.052100e-02,5.825200e-02,5.686600e-02,5.652600e-02, &
     &5.574200e-02,5.204600e-02,6.473300e-02,5.623300e-02,6.547700e-02, &
     &6.304700e-02,6.310600e-02,6.461200e-02,6.679000e-02,6.750700e-02, &
     &6.472300e-02,6.547700e-02,7.272000e-02,6.621600e-02,6.610800e-02, &
     &6.918100e-02,7.426800e-02,7.904700e-02,8.049700e-02,7.828000e-02, &
     &6.621600e-02,9.164800e-02,6.679100e-02,6.957900e-02,7.673700e-02, &
     &8.524400e-02,9.184500e-02,9.452700e-02,9.244100e-02,6.679100e-02, &
     &1.130700e-01,6.729800e-02,7.383900e-02,8.535600e-02,9.714700e-02, &
     &1.055400e-01,1.097800e-01,1.075200e-01,6.729800e-02,1.367800e-01, &
     &7.087700e-02,6.525300e-02,6.123200e-02,5.794200e-02,5.566200e-02, &
     &5.370300e-02,5.025100e-02,7.087700e-02,4.855000e-02,7.155500e-02, &
     &6.749200e-02,6.547300e-02,6.455100e-02,6.505400e-02,6.526400e-02, &
     &6.323100e-02,7.155500e-02,6.333400e-02,7.215900e-02,7.021800e-02, &
     &7.074200e-02,7.327800e-02,7.645900e-02,7.827400e-02,7.683600e-02, &
     &7.215900e-02,8.052800e-02,7.267200e-02,7.332600e-02,7.745600e-02, &
     &8.331400e-02,8.906100e-02,9.238200e-02,9.143800e-02,7.267200e-02, &
     &1.001700e-01,7.306800e-02,7.709000e-02,8.513200e-02,9.451800e-02, &
     &1.030900e-01,1.079600e-01,1.065100e-01,7.306700e-02,1.222900e-01, &
     &7.783600e-02,7.055100e-02,6.455900e-02,5.916700e-02,5.441400e-02, &
     &5.031400e-02,4.579400e-02,7.783600e-02,3.888200e-02,7.843500e-02, &
     &7.253200e-02,6.809200e-02,6.461300e-02,6.235800e-02,6.060800e-02, &
     &5.827600e-02,7.843500e-02,5.137000e-02,7.893200e-02,7.482500e-02, &
     &7.252700e-02,7.198900e-02,7.247100e-02,7.287300e-02,7.176600e-02, &
     &7.893200e-02,6.608600e-02,7.937900e-02,7.750100e-02,7.838800e-02, &
     &8.084700e-02,8.409700e-02,8.680100e-02,8.656800e-02,7.937900e-02, &
     &8.314100e-02,7.969900e-02,8.069100e-02,8.512100e-02,9.100800e-02, &
     &9.744100e-02,1.022600e-01,1.016300e-01,7.969900e-02,1.025400e-01, &
     &8.490600e-02,7.624100e-02,6.868400e-02,6.126000e-02,5.432200e-02, &
     &4.802700e-02,4.141100e-02,8.490600e-02,3.032500e-02,8.569800e-02, &
     &7.824300e-02,7.174800e-02,6.577800e-02,6.093500e-02,5.671900e-02, &
     &5.261000e-02,8.569800e-02,4.054900e-02,8.627500e-02,8.032400e-02, &
     &7.542900e-02,7.200900e-02,6.953100e-02,6.753900e-02,6.547000e-02, &
     &8.627500e-02,5.270000e-02,8.671300e-02,8.257500e-02,8.046200e-02, &
     &7.974800e-02,7.973500e-02,8.032600e-02,7.997400e-02,8.671300e-02, &
     &6.702900e-02,8.702700e-02,8.527600e-02,8.650900e-02,8.881900e-02, &
     &9.176100e-02,9.479800e-02,9.480100e-02,8.702700e-02,8.350800e-02, &
     &9.150700e-02,8.162000e-02,7.282800e-02,6.414200e-02,5.556800e-02, &
     &4.725100e-02,3.888000e-02,9.150700e-02,2.322900e-02,9.240500e-02, &
     &8.367900e-02,7.586300e-02,6.821600e-02,6.104600e-02,5.451300e-02, &
     &4.826100e-02,9.240500e-02,3.150800e-02,9.311500e-02,8.570000e-02, &
     &7.933500e-02,7.357900e-02,6.842000e-02,6.387200e-02,5.956700e-02, &
     &9.311500e-02,4.151100e-02,9.363600e-02,8.796300e-02,8.377600e-02, &
     &8.033600e-02,7.728400e-02,7.504600e-02,7.288200e-02,9.363600e-02, &
     &5.333300e-02,9.401100e-02,9.050400e-02,8.912800e-02,8.824700e-02, &
     &8.782400e-02,8.797900e-02,8.707800e-02,9.401100e-02,6.715500e-02, &
     &9.747200e-02,8.653800e-02,7.662400e-02,6.682400e-02,5.705900e-02, &
     &4.726800e-02,3.713800e-02,9.747200e-02,1.722100e-02,9.845100e-02, &
     &8.851800e-02,7.953600e-02,7.073700e-02,6.195600e-02,5.332800e-02, &
     &4.492300e-02,9.845100e-02,2.378000e-02,9.927000e-02,9.059200e-02, &
     &8.299200e-02,7.564500e-02,6.833800e-02,6.124600e-02,5.464700e-02, &
     &9.927000e-02,3.182100e-02,9.987400e-02,9.282500e-02,8.714500e-02, &
     &8.171300e-02,7.602400e-02,7.089500e-02,6.625600e-02,9.987400e-02, &
     &4.151400e-02,1.003100e-01,9.536200e-02,9.219600e-02,8.867200e-02, &
     &8.523700e-02,8.216400e-02,7.901700e-02,1.003100e-01,5.289200e-02/
      data  absa(271:585,9) /                                           &
     &1.023200e-01,9.055300e-02,7.962400e-02,6.890600e-02,5.807000e-02, &
     &4.725600e-02,3.614700e-02,1.023200e-01,1.255100e-02,1.033700e-01, &
     &9.240700e-02,8.243400e-02,7.254800e-02,6.264300e-02,5.275300e-02, &
     &4.258100e-02,1.033700e-01,1.757500e-02,1.042800e-01,9.446300e-02, &
     &8.575600e-02,7.710300e-02,6.847200e-02,5.971100e-02,5.086100e-02, &
     &1.042800e-01,2.386500e-02,1.049900e-01,9.664900e-02,8.971500e-02, &
     &8.280400e-02,7.568200e-02,6.809400e-02,6.086200e-02,1.049900e-01, &
     &3.154600e-02,1.054700e-01,9.918000e-02,9.451900e-02,8.947900e-02, &
     &8.371700e-02,7.781300e-02,7.199300e-02,1.054700e-01,4.072100e-02, &
     &1.051800e-01,9.288600e-02,8.119100e-02,6.995700e-02,5.850800e-02, &
     &4.696500e-02,3.494700e-02,1.051800e-01,9.167000e-03,1.063600e-01, &
     &9.467400e-02,8.403600e-02,7.341300e-02,6.277600e-02,5.200700e-02, &
     &4.095100e-02,1.063600e-01,1.299800e-02,1.073300e-01,9.673800e-02, &
     &8.725200e-02,7.778300e-02,6.820300e-02,5.837200e-02,4.803400e-02, &
     &1.073300e-01,1.787800e-02,1.081200e-01,9.891100e-02,9.115200e-02, &
     &8.317300e-02,7.496300e-02,6.611600e-02,5.665500e-02,1.081200e-01, &
     &2.386800e-02,1.086300e-01,1.015100e-01,9.571700e-02,8.957800e-02, &
     &8.257200e-02,7.466900e-02,6.639700e-02,1.086300e-01,3.108200e-02, &
     &1.058900e-01,9.337800e-02,8.132000e-02,6.969900e-02,5.793900e-02, &
     &4.596300e-02,3.351000e-02,1.058900e-01,1.500500e-02,1.071000e-01, &
     &9.504600e-02,8.399200e-02,7.296800e-02,6.184000e-02,5.067000e-02, &
     &3.917200e-02,1.071000e-01,1.668700e-02,1.081100e-01,9.702500e-02, &
     &8.706200e-02,7.713500e-02,6.700800e-02,5.669300e-02,4.553900e-02, &
     &1.081100e-01,1.906200e-02,1.089300e-01,9.921000e-02,9.089300e-02, &
     &8.226800e-02,7.343200e-02,6.387200e-02,5.335400e-02,1.089300e-01, &
     &2.251700e-02,1.095100e-01,1.018000e-01,9.532800e-02,8.853300e-02, &
     &8.077700e-02,7.193300e-02,6.186000e-02,1.095100e-01,2.719400e-02, &
     &1.046300e-01,9.219100e-02,8.013200e-02,6.841300e-02,5.664100e-02, &
     &4.461900e-02,3.208000e-02,1.046300e-01,8.399100e-02,1.058200e-01, &
     &9.377000e-02,8.262700e-02,7.153900e-02,6.026500e-02,4.898900e-02, &
     &3.736600e-02,1.058200e-01,8.500800e-02,1.068300e-01,9.565100e-02, &
     &8.558700e-02,7.542900e-02,6.515400e-02,5.471500e-02,4.340800e-02, &
     &1.068300e-01,8.663600e-02,1.075900e-01,9.776400e-02,8.922000e-02, &
     &8.033600e-02,7.134900e-02,6.157600e-02,5.072000e-02,1.075900e-01, &
     &8.813300e-02,1.081400e-01,1.002700e-01,9.347600e-02,8.646100e-02, &
     &7.847000e-02,6.923200e-02,5.860400e-02,1.081400e-01,8.959500e-02, &
     &1.019200e-01,8.993400e-02,7.844200e-02,6.720600e-02,5.580700e-02, &
     &4.427400e-02,3.248500e-02,1.019200e-01,2.134600e-01,1.029400e-01, &
     &9.147400e-02,8.100100e-02,7.032400e-02,5.961800e-02,4.889000e-02, &
     &3.772400e-02,1.029400e-01,2.131900e-01,1.037600e-01,9.337000e-02, &
     &8.396200e-02,7.443500e-02,6.479500e-02,5.479500e-02,4.382700e-02, &
     &1.037600e-01,2.128900e-01,1.043700e-01,9.548900e-02,8.768200e-02, &
     &7.961400e-02,7.110200e-02,6.161900e-02,5.104600e-02,1.043700e-01, &
     &2.128700e-01,1.047500e-01,9.808300e-02,9.212400e-02,8.574300e-02, &
     &7.794600e-02,6.904800e-02,5.862700e-02,1.047500e-01,2.131000e-01, &
     &9.726100e-02,8.599100e-02,7.532400e-02,6.473700e-02,5.398900e-02, &
     &4.318400e-02,3.216900e-02,9.726100e-02,3.538400e-01,9.810100e-02, &
     &8.752800e-02,7.783800e-02,6.792100e-02,5.803100e-02,4.801100e-02, &
     &3.735600e-02,9.810100e-02,3.511000e-01,9.872100e-02,8.935800e-02, &
     &8.084400e-02,7.215600e-02,6.330300e-02,5.381200e-02,4.347800e-02, &
     &9.872100e-02,3.490500e-01,9.907300e-02,9.144800e-02,8.455600e-02, &
     &7.737300e-02,6.936900e-02,6.048200e-02,5.043400e-02,9.907300e-02, &
     &3.471000e-01,9.922900e-02,9.391700e-02,8.902800e-02,8.307000e-02, &
     &7.579500e-02,6.746400e-02,5.774500e-02,9.922900e-02,3.452600e-01, &
     &9.093800e-02,8.063300e-02,7.095400e-02,6.119800e-02,5.134900e-02, &
     &4.151300e-02,3.132100e-02,9.093800e-02,4.763000e-01,9.152400e-02, &
     &8.207600e-02,7.333300e-02,6.442700e-02,5.552600e-02,4.630400e-02, &
     &3.640800e-02,9.152400e-02,4.714900e-01,9.187000e-02,8.378500e-02, &
     &7.635400e-02,6.872600e-02,6.065000e-02,5.187800e-02,4.235000e-02, &
     &9.187000e-02,4.678100e-01,9.205700e-02,8.586400e-02,8.005300e-02, &
     &7.365000e-02,6.636100e-02,5.817500e-02,4.889000e-02,9.205700e-02, &
     &4.647100e-01,9.205100e-02,8.815300e-02,8.423800e-02,7.882900e-02, &
     &7.222400e-02,6.466200e-02,5.579000e-02,9.205100e-02,4.617700e-01/
      data  absa(1:270,10) /                                            &
     &1.897000e-01,1.672200e-01,1.594000e-01,1.465400e-01,1.341200e-01, &
     &1.199000e-01,1.015300e-01,1.897000e-01,1.268300e-01,1.931000e-01, &
     &1.758400e-01,1.703200e-01,1.628700e-01,1.519800e-01,1.363700e-01, &
     &1.133800e-01,1.931000e-01,1.649200e-01,1.964400e-01,1.861600e-01, &
     &1.846300e-01,1.785300e-01,1.668600e-01,1.530700e-01,1.300600e-01, &
     &1.964400e-01,2.095100e-01,1.990900e-01,1.951000e-01,1.979400e-01, &
     &1.945500e-01,1.881400e-01,1.697000e-01,1.404900e-01,1.990900e-01, &
     &2.602300e-01,2.014100e-01,2.042300e-01,2.119800e-01,2.135900e-01, &
     &2.032000e-01,1.783900e-01,1.616600e-01,2.014100e-01,3.181400e-01, &
     &1.851300e-01,1.641700e-01,1.557000e-01,1.429900e-01,1.302800e-01, &
     &1.155800e-01,9.757500e-02,1.851300e-01,1.203300e-01,1.895000e-01, &
     &1.738100e-01,1.671000e-01,1.596200e-01,1.469700e-01,1.306100e-01, &
     &1.096100e-01,1.895000e-01,1.592000e-01,1.936200e-01,1.839500e-01, &
     &1.819500e-01,1.741900e-01,1.616700e-01,1.482800e-01,1.256800e-01, &
     &1.936200e-01,2.028200e-01,1.972100e-01,1.934800e-01,1.953000e-01, &
     &1.911200e-01,1.828400e-01,1.650000e-01,1.370800e-01,1.972100e-01, &
     &2.520400e-01,2.002300e-01,2.032000e-01,2.102000e-01,2.081900e-01, &
     &1.974100e-01,1.746600e-01,1.534300e-01,2.002300e-01,3.080800e-01, &
     &1.800100e-01,1.591800e-01,1.495700e-01,1.363400e-01,1.240000e-01, &
     &1.105200e-01,9.351000e-02,1.800100e-01,1.021900e-01,1.852800e-01, &
     &1.690100e-01,1.609600e-01,1.532700e-01,1.406100e-01,1.248100e-01, &
     &1.068200e-01,1.852800e-01,1.377300e-01,1.902300e-01,1.792900e-01, &
     &1.758200e-01,1.670000e-01,1.543000e-01,1.416100e-01,1.225200e-01, &
     &1.902300e-01,1.787700e-01,1.946900e-01,1.889300e-01,1.890600e-01, &
     &1.831400e-01,1.744900e-01,1.594800e-01,1.340800e-01,1.946900e-01, &
     &2.272300e-01,1.982100e-01,1.994600e-01,2.041500e-01,1.992200e-01, &
     &1.897200e-01,1.722900e-01,1.517000e-01,1.982100e-01,2.824300e-01, &
     &1.791600e-01,1.569300e-01,1.431700e-01,1.297000e-01,1.182000e-01, &
     &1.054200e-01,8.881000e-02,1.791600e-01,8.162900e-02,1.839300e-01, &
     &1.649600e-01,1.540800e-01,1.465600e-01,1.347000e-01,1.196800e-01, &
     &1.010900e-01,1.839300e-01,1.130000e-01,1.882900e-01,1.739500e-01, &
     &1.691200e-01,1.609000e-01,1.483600e-01,1.353300e-01,1.168800e-01, &
     &1.882900e-01,1.501100e-01,1.923800e-01,1.836400e-01,1.824200e-01, &
     &1.761700e-01,1.676100e-01,1.543000e-01,1.305600e-01,1.923000e-01, &
     &1.953200e-01,1.957400e-01,1.946300e-01,1.970500e-01,1.926400e-01, &
     &1.851100e-01,1.715700e-01,1.514500e-01,1.957400e-01,2.470100e-01, &
     &1.879700e-01,1.645300e-01,1.453300e-01,1.268600e-01,1.121900e-01, &
     &9.871900e-02,8.193200e-02,1.879700e-01,6.516600e-02,1.916000e-01, &
     &1.692500e-01,1.521800e-01,1.401400e-01,1.291700e-01,1.130200e-01, &
     &9.448000e-02,1.916000e-01,9.207700e-02,1.944600e-01,1.757800e-01, &
     &1.640200e-01,1.550600e-01,1.423500e-01,1.278000e-01,1.106600e-01, &
     &1.944600e-01,1.247900e-01,1.973600e-01,1.818300e-01,1.766400e-01, &
     &1.699900e-01,1.617900e-01,1.482600e-01,1.281600e-01,1.973600e-01, &
     &1.634600e-01,2.001100e-01,1.907400e-01,1.908200e-01,1.882900e-01, &
     &1.808000e-01,1.685800e-01,1.500900e-01,2.001100e-01,2.082200e-01, &
     &2.022300e-01,1.769900e-01,1.532200e-01,1.312800e-01,1.109200e-01, &
     &9.156100e-02,7.366100e-02,2.022300e-01,5.137700e-02,2.051200e-01, &
     &1.796700e-01,1.578800e-01,1.393800e-01,1.226800e-01,1.054300e-01, &
     &8.738500e-02,2.051200e-01,7.385300e-02,2.079000e-01,1.845000e-01, &
     &1.652900e-01,1.511200e-01,1.352900e-01,1.202200e-01,1.039800e-01, &
     &2.079000e-01,1.008700e-01,2.100400e-01,1.882300e-01,1.750900e-01, &
     &1.628400e-01,1.538600e-01,1.415500e-01,1.242700e-01,2.100400e-01, &
     &1.336000e-01,2.118300e-01,1.942800e-01,1.851300e-01,1.817700e-01, &
     &1.749800e-01,1.642300e-01,1.470400e-01,2.118300e-01,1.717800e-01/
      data  absa(271:585,10) /                                          &
     &2.196600e-01,1.922300e-01,1.648700e-01,1.407500e-01,1.174300e-01, &
     &9.235200e-02,6.716500e-02,2.196600e-01,3.984400e-02,2.228900e-01, &
     &1.950500e-01,1.701200e-01,1.471100e-01,1.248200e-01,1.016600e-01, &
     &8.111600e-02,2.228900e-01,5.880300e-02,2.256200e-01,1.991800e-01, &
     &1.755800e-01,1.557900e-01,1.336100e-01,1.138100e-01,9.829600e-02, &
     &2.256200e-01,8.210500e-02,2.279800e-01,2.028300e-01,1.839300e-01, &
     &1.636000e-01,1.467200e-01,1.348200e-01,1.194200e-01,2.279800e-01, &
     &1.101300e-01,2.296500e-01,2.071300e-01,1.904500e-01,1.771100e-01, &
     &1.689000e-01,1.587500e-01,1.429400e-01,2.296500e-01,1.430100e-01, &
     &2.392700e-01,2.094000e-01,1.795300e-01,1.507400e-01,1.250500e-01, &
     &9.733800e-02,6.876100e-02,2.392700e-01,3.157200e-02,2.424300e-01, &
     &2.121600e-01,1.835900e-01,1.575600e-01,1.306900e-01,1.045600e-01, &
     &7.792300e-02,2.424300e-01,4.597800e-02,2.454700e-01,2.153400e-01, &
     &1.885300e-01,1.650300e-01,1.389600e-01,1.137700e-01,9.342500e-02, &
     &2.454700e-01,6.438100e-02,2.480200e-01,2.196600e-01,1.964800e-01, &
     &1.719700e-01,1.487200e-01,1.296700e-01,1.141700e-01,2.480200e-01, &
     &8.797000e-02,2.499800e-01,2.230900e-01,2.026100e-01,1.823200e-01, &
     &1.651700e-01,1.526400e-01,1.383400e-01,2.499800e-01,1.163900e-01, &
     &2.614800e-01,2.288200e-01,1.961800e-01,1.637000e-01,1.344800e-01, &
     &1.039500e-01,7.162900e-02,2.614800e-01,2.850300e-02,2.651900e-01, &
     &2.321000e-01,1.993700e-01,1.701500e-01,1.396400e-01,1.089200e-01, &
     &7.888900e-02,2.651900e-01,3.800800e-02,2.682400e-01,2.347800e-01, &
     &2.044900e-01,1.756200e-01,1.465200e-01,1.167400e-01,9.227000e-02, &
     &2.682400e-01,5.242200e-02,2.707800e-01,2.387700e-01,2.105400e-01, &
     &1.826400e-01,1.541200e-01,1.304100e-01,1.074900e-01,2.707800e-01, &
     &7.033800e-02,2.726400e-01,2.416100e-01,2.166200e-01,1.897800e-01, &
     &1.686000e-01,1.480400e-01,1.308000e-01,2.726400e-01,9.255400e-02, &
     &2.820100e-01,2.467800e-01,2.115600e-01,1.763800e-01,1.435200e-01, &
     &1.108400e-01,7.697200e-02,2.820100e-01,1.247100e-01,2.857600e-01, &
     &2.500600e-01,2.143800e-01,1.823100e-01,1.496100e-01,1.154900e-01, &
     &8.200600e-02,2.857600e-01,1.249600e-01,2.889300e-01,2.528600e-01, &
     &2.194900e-01,1.878700e-01,1.555100e-01,1.222800e-01,9.340600e-02, &
     &2.889300e-01,1.285700e-01,2.914300e-01,2.565300e-01,2.251800e-01, &
     &1.946600e-01,1.619700e-01,1.340900e-01,1.061400e-01,2.914300e-01, &
     &1.366400e-01,2.926900e-01,2.587800e-01,2.309700e-01,1.996700e-01, &
     &1.742600e-01,1.493300e-01,1.247700e-01,2.926900e-01,1.464800e-01, &
     &3.000300e-01,2.625500e-01,2.250600e-01,1.881900e-01,1.537100e-01, &
     &1.185100e-01,8.180900e-02,3.000300e-01,3.145400e-01,3.032400e-01, &
     &2.653500e-01,2.277500e-01,1.944800e-01,1.590300e-01,1.229200e-01, &
     &8.886500e-02,3.032400e-01,3.086100e-01,3.049300e-01,2.668600e-01, &
     &2.326600e-01,1.991800e-01,1.649000e-01,1.315300e-01,1.007800e-01, &
     &3.049300e-01,3.069900e-01,3.057700e-01,2.694000e-01,2.378900e-01, &
     &2.049500e-01,1.733800e-01,1.446700e-01,1.131400e-01,3.057700e-01, &
     &3.108200e-01,3.055100e-01,2.704400e-01,2.422700e-01,2.122900e-01, &
     &1.880100e-01,1.597900e-01,1.309000e-01,3.055100e-01,3.152700e-01, &
     &3.113400e-01,2.724300e-01,2.335400e-01,1.963900e-01,1.609000e-01, &
     &1.238700e-01,8.605200e-02,3.113400e-01,5.297800e-01,3.135900e-01, &
     &2.744100e-01,2.367700e-01,2.023800e-01,1.655200e-01,1.290100e-01, &
     &9.520700e-02,3.135900e-01,5.205200e-01,3.141500e-01,2.753700e-01, &
     &2.412200e-01,2.071500e-01,1.719300e-01,1.399700e-01,1.072000e-01, &
     &3.141500e-01,5.156000e-01,3.137200e-01,2.767800e-01,2.460900e-01, &
     &2.125600e-01,1.833500e-01,1.532200e-01,1.208100e-01,3.137200e-01, &
     &5.155700e-01,3.123900e-01,2.782200e-01,2.495600e-01,2.236700e-01, &
     &1.983800e-01,1.693700e-01,1.360600e-01,3.123900e-01,5.166700e-01, &
     &3.163800e-01,2.768300e-01,2.375000e-01,2.011400e-01,1.645600e-01, &
     &1.263200e-01,8.925300e-02,3.163800e-01,7.349700e-01,3.167100e-01, &
     &2.771300e-01,2.409700e-01,2.054200e-01,1.686600e-01,1.334700e-01, &
     &9.965800e-02,3.167100e-01,7.189100e-01,3.165900e-01,2.782400e-01, &
     &2.444800e-01,2.104800e-01,1.771500e-01,1.454900e-01,1.113200e-01, &
     &3.165900e-01,7.102000e-01,3.148400e-01,2.784500e-01,2.484900e-01, &
     &2.179600e-01,1.894800e-01,1.595500e-01,1.263500e-01,3.148400e-01, &
     &7.075600e-01,3.118600e-01,2.805400e-01,2.536200e-01,2.308600e-01, &
     &2.049600e-01,1.751200e-01,1.414300e-01,3.118600e-01,7.058400e-01/
      data  absa(1:270,11) /                                            &
     &3.132700e-01,2.743800e-01,2.386400e-01,2.164800e-01,1.869000e-01, &
     &1.567300e-01,1.273400e-01,3.132700e-01,1.498600e-01,3.139200e-01, &
     &2.749100e-01,2.520000e-01,2.273400e-01,2.030300e-01,1.754100e-01, &
     &1.408900e-01,3.139200e-01,1.970700e-01,3.138300e-01,2.765000e-01, &
     &2.610900e-01,2.419500e-01,2.192700e-01,1.865000e-01,1.495500e-01, &
     &3.138300e-01,2.515900e-01,3.127200e-01,2.840300e-01,2.722300e-01, &
     &2.558500e-01,2.285400e-01,2.009200e-01,1.869100e-01,3.127200e-01, &
     &3.130400e-01,3.109000e-01,2.895500e-01,2.819100e-01,2.666400e-01, &
     &2.412100e-01,2.130100e-01,2.413700e-01,3.109000e-01,3.811800e-01, &
     &3.132400e-01,2.742200e-01,2.392000e-01,2.150000e-01,1.849500e-01, &
     &1.552800e-01,1.257700e-01,3.132400e-01,1.504500e-01,3.147000e-01, &
     &2.755700e-01,2.522300e-01,2.265700e-01,2.021000e-01,1.742100e-01, &
     &1.383700e-01,3.147000e-01,1.986600e-01,3.153600e-01,2.792600e-01, &
     &2.614100e-01,2.421400e-01,2.188800e-01,1.847800e-01,1.507400e-01, &
     &3.153600e-01,2.567700e-01,3.150400e-01,2.877900e-01,2.737600e-01, &
     &2.563300e-01,2.294200e-01,1.999300e-01,1.711200e-01,3.150400e-01, &
     &3.230200e-01,3.138100e-01,2.932400e-01,2.851900e-01,2.695100e-01, &
     &2.405500e-01,2.079300e-01,2.170000e-01,3.138100e-01,3.962500e-01, &
     &3.120400e-01,2.731500e-01,2.370400e-01,2.109400e-01,1.796600e-01, &
     &1.489600e-01,1.201300e-01,3.120400e-01,1.375800e-01,3.146600e-01, &
     &2.754700e-01,2.502900e-01,2.218300e-01,1.965100e-01,1.691200e-01, &
     &1.325800e-01,3.146600e-01,1.858600e-01,3.161700e-01,2.799200e-01, &
     &2.594800e-01,2.388400e-01,2.144500e-01,1.803000e-01,1.445000e-01, &
     &3.161700e-01,2.426600e-01,3.168100e-01,2.889000e-01,2.722100e-01, &
     &2.533400e-01,2.258000e-01,1.947100e-01,1.579900e-01,3.168100e-01, &
     &3.076200e-01,3.166000e-01,2.949000e-01,2.847200e-01,2.681700e-01, &
     &2.381400e-01,2.050600e-01,1.841800e-01,3.166000e-01,3.816200e-01, &
     &3.086600e-01,2.701600e-01,2.334100e-01,2.059200e-01,1.736500e-01, &
     &1.415200e-01,1.135000e-01,3.086600e-01,1.172900e-01,3.126100e-01, &
     &2.736400e-01,2.467900e-01,2.168700e-01,1.891200e-01,1.622700e-01, &
     &1.287700e-01,3.126100e-01,1.626300e-01,3.151700e-01,2.786600e-01, &
     &2.563300e-01,2.332200e-01,2.081800e-01,1.752400e-01,1.401100e-01, &
     &3.151700e-01,2.174100e-01,3.171800e-01,2.880200e-01,2.694700e-01, &
     &2.486600e-01,2.206100e-01,1.894200e-01,1.569500e-01,3.172700e-01, &
     &2.801200e-01,3.185800e-01,2.947900e-01,2.819000e-01,2.630900e-01, &
     &2.344800e-01,2.006800e-01,1.693000e-01,3.185800e-01,3.497900e-01, &
     &3.035900e-01,2.657200e-01,2.287400e-01,1.997400e-01,1.682600e-01, &
     &1.365300e-01,1.095900e-01,3.035900e-01,9.556400e-02,3.096100e-01, &
     &2.709800e-01,2.419100e-01,2.117200e-01,1.819700e-01,1.568800e-01, &
     &1.268200e-01,3.096100e-01,1.354600e-01,3.143100e-01,2.773700e-01, &
     &2.523100e-01,2.274300e-01,2.021700e-01,1.726800e-01,1.376800e-01, &
     &3.143100e-01,1.848400e-01,3.178700e-01,2.873400e-01,2.657900e-01, &
     &2.430800e-01,2.153300e-01,1.867900e-01,1.534700e-01,3.178700e-01, &
     &2.431500e-01,3.202700e-01,2.946800e-01,2.787000e-01,2.569500e-01, &
     &2.318900e-01,2.001600e-01,1.685000e-01,3.202700e-01,3.115900e-01, &
     &2.986500e-01,2.613900e-01,2.241700e-01,1.923700e-01,1.626100e-01, &
     &1.330600e-01,1.040200e-01,2.986500e-01,7.472800e-02,3.061900e-01, &
     &2.680000e-01,2.365200e-01,2.057900e-01,1.768400e-01,1.516800e-01, &
     &1.222300e-01,3.061900e-01,1.082900e-01,3.124100e-01,2.751400e-01, &
     &2.481500e-01,2.208100e-01,1.972000e-01,1.691700e-01,1.339600e-01, &
     &3.124100e-01,1.515100e-01,3.166100e-01,2.853800e-01,2.610400e-01, &
     &2.384100e-01,2.116500e-01,1.824300e-01,1.488700e-01,3.166100e-01, &
     &2.034800e-01,3.200000e-01,2.929300e-01,2.747900e-01,2.514600e-01, &
     &2.288100e-01,1.989300e-01,1.674500e-01,3.200000e-01,2.652000e-01/
      data  absa(271:585,11) /                                          &
     &3.008100e-01,2.632400e-01,2.256700e-01,1.894700e-01,1.582400e-01, &
     &1.293400e-01,9.913900e-02,3.008100e-01,5.823600e-02,3.078500e-01, &
     &2.693800e-01,2.336200e-01,2.022500e-01,1.719700e-01,1.452600e-01, &
     &1.160600e-01,3.078500e-01,8.614300e-02,3.135500e-01,2.747100e-01, &
     &2.447500e-01,2.155800e-01,1.920300e-01,1.635900e-01,1.288400e-01, &
     &3.135500e-01,1.227900e-01,3.177300e-01,2.833900e-01,2.553400e-01, &
     &2.339600e-01,2.075500e-01,1.765800e-01,1.445000e-01,3.177300e-01, &
     &1.675200e-01,3.207300e-01,2.901800e-01,2.695200e-01,2.469700e-01, &
     &2.238100e-01,1.962300e-01,1.658200e-01,3.207300e-01,2.216500e-01, &
     &3.162900e-01,2.767600e-01,2.372800e-01,1.977600e-01,1.610900e-01, &
     &1.290100e-01,9.469900e-02,3.162900e-01,4.530000e-02,3.222700e-01, &
     &2.820300e-01,2.421400e-01,2.063600e-01,1.726200e-01,1.401600e-01, &
     &1.087700e-01,3.222700e-01,6.885300e-02,3.268800e-01,2.860700e-01, &
     &2.506900e-01,2.155600e-01,1.874800e-01,1.566100e-01,1.229900e-01, &
     &3.268800e-01,1.001800e-01,3.298100e-01,2.914000e-01,2.571200e-01, &
     &2.307800e-01,2.015800e-01,1.705800e-01,1.400600e-01,3.298100e-01, &
     &1.383800e-01,3.318800e-01,2.961800e-01,2.678400e-01,2.420900e-01, &
     &2.169600e-01,1.924000e-01,1.648000e-01,3.318800e-01,1.838800e-01, &
     &3.405400e-01,2.979800e-01,2.554300e-01,2.128700e-01,1.707900e-01, &
     &1.342100e-01,9.571000e-02,3.405400e-01,3.823600e-02,3.463300e-01, &
     &3.030500e-01,2.597600e-01,2.189000e-01,1.814700e-01,1.422500e-01, &
     &1.035000e-01,3.463300e-01,5.623800e-02,3.503700e-01,3.065700e-01, &
     &2.660200e-01,2.267800e-01,1.899400e-01,1.534400e-01,1.166700e-01, &
     &3.503700e-01,8.174300e-02,3.522800e-01,3.094400e-01,2.699200e-01, &
     &2.366000e-01,2.012300e-01,1.648700e-01,1.360200e-01,3.522800e-01, &
     &1.141300e-01,3.522500e-01,3.121100e-01,2.773100e-01,2.449300e-01, &
     &2.116000e-01,1.873800e-01,1.627600e-01,3.522500e-01,1.534800e-01, &
     &3.685200e-01,3.224700e-01,2.764400e-01,2.303900e-01,1.844800e-01, &
     &1.418800e-01,9.975700e-02,3.685200e-01,1.404000e-01,3.731500e-01, &
     &3.265200e-01,2.798900e-01,2.336600e-01,1.926100e-01,1.500300e-01, &
     &1.058600e-01,3.731500e-01,1.452600e-01,3.757100e-01,3.287800e-01, &
     &2.836600e-01,2.410400e-01,1.998700e-01,1.582000e-01,1.157800e-01, &
     &3.757100e-01,1.549700e-01,3.770500e-01,3.302400e-01,2.873500e-01, &
     &2.493300e-01,2.090700e-01,1.674800e-01,1.341300e-01,3.770500e-01, &
     &1.674600e-01,3.762800e-01,3.324700e-01,2.934300e-01,2.566300e-01, &
     &2.174800e-01,1.867300e-01,1.605800e-01,3.762800e-01,1.827500e-01, &
     &4.003800e-01,3.503500e-01,3.003400e-01,2.503000e-01,2.011600e-01, &
     &1.552200e-01,1.082300e-01,4.003800e-01,3.549000e-01,4.039600e-01, &
     &3.535000e-01,3.030100e-01,2.542500e-01,2.094600e-01,1.619500e-01, &
     &1.137400e-01,4.039600e-01,3.485600e-01,4.056500e-01,3.549600e-01, &
     &3.066500e-01,2.611200e-01,2.155100e-01,1.695800e-01,1.257200e-01, &
     &4.056500e-01,3.507600e-01,4.055800e-01,3.559500e-01,3.093800e-01, &
     &2.684000e-01,2.230100e-01,1.804600e-01,1.440300e-01,4.055800e-01, &
     &3.572200e-01,4.044600e-01,3.571200e-01,3.155300e-01,2.732300e-01, &
     &2.336600e-01,2.021000e-01,1.687500e-01,4.044600e-01,3.671900e-01, &
     &4.315400e-01,3.776400e-01,3.237000e-01,2.698100e-01,2.180400e-01, &
     &1.685000e-01,1.166900e-01,4.315400e-01,6.013400e-01,4.337400e-01, &
     &3.795600e-01,3.253600e-01,2.746600e-01,2.255500e-01,1.738500e-01, &
     &1.229000e-01,4.337400e-01,5.847900e-01,4.333100e-01,3.791600e-01, &
     &3.280800e-01,2.800000e-01,2.315600e-01,1.816600e-01,1.363000e-01, &
     &4.333100e-01,5.770100e-01,4.321600e-01,3.800900e-01,3.313600e-01, &
     &2.869200e-01,2.383500e-01,1.956900e-01,1.540600e-01,4.321600e-01, &
     &5.778800e-01,4.292400e-01,3.792900e-01,3.364400e-01,2.916200e-01, &
     &2.535800e-01,2.159800e-01,1.780100e-01,4.292400e-01,5.859000e-01, &
     &4.550700e-01,3.982000e-01,3.413400e-01,2.848600e-01,2.319900e-01, &
     &1.790800e-01,1.237800e-01,4.550700e-01,8.346600e-01,4.556000e-01, &
     &3.986500e-01,3.420700e-01,2.907600e-01,2.382400e-01,1.841300e-01, &
     &1.323100e-01,4.556000e-01,8.174300e-01,4.540800e-01,3.973800e-01, &
     &3.450800e-01,2.949400e-01,2.444700e-01,1.940000e-01,1.465800e-01, &
     &4.540800e-01,8.039500e-01,4.506100e-01,3.969300e-01,3.484100e-01, &
     &3.008600e-01,2.538600e-01,2.097600e-01,1.640700e-01,4.506100e-01, &
     &8.011200e-01,4.463200e-01,3.950900e-01,3.517900e-01,3.091000e-01, &
     &2.715300e-01,2.303000e-01,1.864500e-01,4.463200e-01,8.044500e-01/
      data  absa(1:270,12) /                                            &
     &4.513400e-01,3.950800e-01,3.389000e-01,2.882500e-01,2.477800e-01, &
     &1.992400e-01,1.487500e-01,4.513400e-01,1.882400e-01,4.430200e-01, &
     &3.878000e-01,3.347700e-01,2.979300e-01,2.516300e-01,2.088000e-01, &
     &1.642100e-01,4.430200e-01,2.439300e-01,4.344200e-01,3.802700e-01, &
     &3.411000e-01,2.999300e-01,2.602200e-01,2.194900e-01,2.033700e-01, &
     &4.344200e-01,3.121100e-01,4.254800e-01,3.724800e-01,3.400100e-01, &
     &3.036300e-01,2.687200e-01,2.352900e-01,2.620800e-01,4.254800e-01, &
     &4.021800e-01,4.163700e-01,3.718400e-01,3.395600e-01,3.070200e-01, &
     &2.766600e-01,3.004800e-01,3.337000e-01,4.163700e-01,5.181000e-01, &
     &4.599300e-01,4.025700e-01,3.452200e-01,2.946000e-01,2.512000e-01, &
     &2.007500e-01,1.499400e-01,4.599300e-01,1.838000e-01,4.521400e-01, &
     &3.956900e-01,3.430600e-01,3.031400e-01,2.554200e-01,2.117000e-01, &
     &1.651700e-01,4.521400e-01,2.430200e-01,4.439200e-01,3.885900e-01, &
     &3.483600e-01,3.054400e-01,2.649900e-01,2.241800e-01,1.873100e-01, &
     &4.439200e-01,3.130000e-01,4.354200e-01,3.819400e-01,3.476900e-01, &
     &3.098500e-01,2.729100e-01,2.316000e-01,2.475800e-01,4.354200e-01, &
     &3.963600e-01,4.265900e-01,3.810200e-01,3.459700e-01,3.126700e-01, &
     &2.810100e-01,2.855900e-01,3.226400e-01,4.265900e-01,5.018700e-01, &
     &4.683300e-01,4.098800e-01,3.514600e-01,2.972500e-01,2.525500e-01, &
     &2.007100e-01,1.465800e-01,4.683300e-01,1.749300e-01,4.612100e-01, &
     &4.036600e-01,3.487800e-01,3.068200e-01,2.566800e-01,2.103000e-01, &
     &1.655600e-01,4.612100e-01,2.337300e-01,4.537800e-01,3.971600e-01, &
     &3.541500e-01,3.089500e-01,2.667700e-01,2.248300e-01,1.737400e-01, &
     &4.537800e-01,3.065600e-01,4.457600e-01,3.913200e-01,3.537500e-01, &
     &3.140900e-01,2.747300e-01,2.311400e-01,2.167700e-01,4.457600e-01, &
     &3.929600e-01,4.370500e-01,3.904600e-01,3.532600e-01,3.167900e-01, &
     &2.850200e-01,2.571200e-01,2.893000e-01,4.370500e-01,4.902600e-01, &
     &4.759500e-01,4.165500e-01,3.571400e-01,2.992000e-01,2.521300e-01, &
     &1.998200e-01,1.438100e-01,4.759500e-01,1.587200e-01,4.703300e-01, &
     &4.116100e-01,3.541400e-01,3.092200e-01,2.584600e-01,2.073100e-01, &
     &1.621500e-01,4.703300e-01,2.180000e-01,4.635200e-01,4.056500e-01, &
     &3.597100e-01,3.120400e-01,2.667800e-01,2.229200e-01,1.712200e-01, &
     &4.635200e-01,2.901800e-01,4.558500e-01,4.002700e-01,3.592000e-01, &
     &3.181400e-01,2.757100e-01,2.298800e-01,1.880700e-01,4.558500e-01, &
     &3.761500e-01,4.474700e-01,3.999400e-01,3.604500e-01,3.210200e-01, &
     &2.848200e-01,2.419400e-01,2.487200e-01,4.474700e-01,4.773300e-01, &
     &4.833200e-01,4.229600e-01,3.626000e-01,3.023500e-01,2.504200e-01, &
     &1.986400e-01,1.413000e-01,4.833200e-01,1.374500e-01,4.786700e-01, &
     &4.189000e-01,3.594700e-01,3.112700e-01,2.592700e-01,2.049300e-01, &
     &1.575000e-01,4.786700e-01,1.959600e-01,4.725900e-01,4.135800e-01, &
     &3.652000e-01,3.145900e-01,2.672300e-01,2.204800e-01,1.703200e-01, &
     &4.725900e-01,2.674200e-01,4.653800e-01,4.085000e-01,3.651800e-01, &
     &3.217600e-01,2.768800e-01,2.277700e-01,1.808800e-01,4.653800e-01, &
     &3.519600e-01,4.576900e-01,4.089600e-01,3.672600e-01,3.257100e-01, &
     &2.832100e-01,2.409800e-01,2.146200e-01,4.576900e-01,4.512300e-01, &
     &4.899300e-01,4.287700e-01,3.675600e-01,3.063700e-01,2.486100e-01, &
     &1.959200e-01,1.409700e-01,4.899300e-01,1.130900e-01,4.862300e-01, &
     &4.255100e-01,3.648000e-01,3.125900e-01,2.593700e-01,2.029300e-01, &
     &1.535900e-01,4.862300e-01,1.665400e-01,4.815800e-01,4.214500e-01, &
     &3.698100e-01,3.181100e-01,2.657900e-01,2.180500e-01,1.703400e-01, &
     &4.815800e-01,2.341600e-01,4.758000e-01,4.167500e-01,3.710800e-01, &
     &3.245600e-01,2.780300e-01,2.283300e-01,1.806600e-01,4.758000e-01, &
     &3.160700e-01,4.675800e-01,4.165200e-01,3.736700e-01,3.314700e-01, &
     &2.838000e-01,2.422300e-01,1.984100e-01,4.675800e-01,4.118100e-01/
      data  absa(271:585,12) /                                          &
     &4.955600e-01,4.336500e-01,3.717500e-01,3.098500e-01,2.485400e-01, &
     &1.927700e-01,1.401300e-01,4.955600e-01,8.947300e-02,4.936300e-01, &
     &4.319500e-01,3.702900e-01,3.125600e-01,2.596300e-01,2.032800e-01, &
     &1.519400e-01,4.936300e-01,1.361900e-01,4.898800e-01,4.286600e-01, &
     &3.726500e-01,3.207300e-01,2.654900e-01,2.178700e-01,1.701000e-01, &
     &4.898800e-01,1.964400e-01,4.835600e-01,4.233500e-01,3.764000e-01, &
     &3.264800e-01,2.804500e-01,2.319000e-01,1.795500e-01,4.835600e-01, &
     &2.716300e-01,4.761300e-01,4.234300e-01,3.794100e-01,3.367700e-01, &
     &2.883900e-01,2.441600e-01,1.924000e-01,4.761300e-01,3.614600e-01, &
     &4.995200e-01,4.371300e-01,3.746900e-01,3.122800e-01,2.499200e-01, &
     &1.899200e-01,1.391000e-01,4.995200e-01,7.006800e-02,4.987600e-01, &
     &4.364700e-01,3.741500e-01,3.135900e-01,2.589800e-01,2.036500e-01, &
     &1.522500e-01,4.987600e-01,1.091100e-01,4.956100e-01,4.336700e-01, &
     &3.747800e-01,3.225300e-01,2.665200e-01,2.180200e-01,1.693100e-01, &
     &4.956100e-01,1.606500e-01,4.913200e-01,4.299500e-01,3.805600e-01, &
     &3.282500e-01,2.831300e-01,2.356100e-01,1.796300e-01,4.913200e-01, &
     &2.265700e-01,4.849300e-01,4.303700e-01,3.839200e-01,3.399900e-01, &
     &2.950600e-01,2.459200e-01,1.930500e-01,4.849300e-01,3.079800e-01, &
     &5.029700e-01,4.401100e-01,3.772700e-01,3.144500e-01,2.516400e-01, &
     &1.892300e-01,1.363000e-01,5.029700e-01,5.592800e-02,5.028000e-01, &
     &4.399900e-01,3.771900e-01,3.143900e-01,2.559600e-01,2.038700e-01, &
     &1.519400e-01,5.028000e-01,8.725900e-02,5.016500e-01,4.389900e-01, &
     &3.773300e-01,3.231600e-01,2.681500e-01,2.176500e-01,1.672900e-01, &
     &5.016500e-01,1.303200e-01,4.977500e-01,4.355800e-01,3.832500e-01, &
     &3.289800e-01,2.834800e-01,2.369600e-01,1.799200e-01,4.977500e-01, &
     &1.869700e-01,4.925600e-01,4.353300e-01,3.860000e-01,3.428500e-01, &
     &2.991700e-01,2.475700e-01,1.946900e-01,4.925600e-01,2.577600e-01, &
     &5.177300e-01,4.530500e-01,3.883200e-01,3.236100e-01,2.589400e-01, &
     &1.944400e-01,1.362600e-01,5.177300e-01,1.714300e-01,5.201400e-01, &
     &4.551800e-01,3.901400e-01,3.251100e-01,2.613700e-01,2.055800e-01, &
     &1.509100e-01,5.201400e-01,1.787800e-01,5.185900e-01,4.537600e-01, &
     &3.889900e-01,3.297700e-01,2.717800e-01,2.180600e-01,1.645000e-01, &
     &5.185900e-01,1.877800e-01,5.146400e-01,4.503600e-01,3.927800e-01, &
     &3.342900e-01,2.852000e-01,2.359300e-01,1.792300e-01,5.146400e-01, &
     &2.068600e-01,5.101800e-01,4.490500e-01,3.944000e-01,3.470300e-01, &
     &3.002600e-01,2.481700e-01,1.972700e-01,5.101800e-01,2.434200e-01, &
     &5.483200e-01,4.797700e-01,4.112600e-01,3.427400e-01,2.742000e-01, &
     &2.070300e-01,1.463600e-01,5.483200e-01,4.222900e-01,5.489000e-01, &
     &4.802900e-01,4.116900e-01,3.430800e-01,2.780300e-01,2.190200e-01, &
     &1.567500e-01,5.489000e-01,4.130400e-01,5.476000e-01,4.791200e-01, &
     &4.114800e-01,3.484500e-01,2.880200e-01,2.286400e-01,1.695700e-01, &
     &5.476000e-01,4.186600e-01,5.445100e-01,4.764600e-01,4.146600e-01, &
     &3.532400e-01,3.004300e-01,2.425300e-01,1.858800e-01,5.445100e-01, &
     &4.296300e-01,5.384400e-01,4.749900e-01,4.151400e-01,3.647200e-01, &
     &3.097700e-01,2.565500e-01,2.138700e-01,5.384400e-01,4.451300e-01, &
     &5.906500e-01,5.168400e-01,4.430400e-01,3.691400e-01,2.953600e-01, &
     &2.245200e-01,1.581200e-01,5.906500e-01,7.008800e-01,5.887200e-01, &
     &5.151600e-01,4.415700e-01,3.681800e-01,3.005000e-01,2.347000e-01, &
     &1.653300e-01,5.887200e-01,6.872400e-01,5.865700e-01,5.132800e-01, &
     &4.418300e-01,3.735700e-01,3.088300e-01,2.436900e-01,1.772000e-01, &
     &5.865700e-01,6.769200e-01,5.820200e-01,5.095400e-01,4.428700e-01, &
     &3.799600e-01,3.190100e-01,2.535500e-01,1.975400e-01,5.820200e-01, &
     &6.806300e-01,5.748800e-01,5.073600e-01,4.444800e-01,3.873400e-01, &
     &3.263600e-01,2.753000e-01,2.289600e-01,5.748800e-01,6.886400e-01, &
     &6.333000e-01,5.541400e-01,4.750000e-01,3.958500e-01,3.169700e-01, &
     &2.432900e-01,1.702400e-01,6.333000e-01,9.619300e-01,6.322300e-01, &
     &5.531900e-01,4.742400e-01,3.963800e-01,3.247300e-01,2.515200e-01, &
     &1.759900e-01,6.322300e-01,9.444400e-01,6.274400e-01,5.490500e-01, &
     &4.737300e-01,4.007600e-01,3.305000e-01,2.602500e-01,1.899300e-01, &
     &6.274400e-01,9.285900e-01,6.216100e-01,5.450200e-01,4.727900e-01, &
     &4.077400e-01,3.392200e-01,2.716400e-01,2.121600e-01,6.216100e-01, &
     &9.198300e-01,6.141600e-01,5.419000e-01,4.754500e-01,4.109400e-01, &
     &3.498800e-01,2.976700e-01,2.431500e-01,6.141600e-01,9.207600e-01/
      data  absa(1:270,13) /                                            &
     &5.680100e-01,4.975300e-01,4.261400e-01,3.556200e-01,2.978400e-01, &
     &2.376200e-01,1.706700e-01,5.680100e-01,2.884700e-01,5.450600e-01, &
     &4.771300e-01,4.094500e-01,3.561400e-01,2.990600e-01,2.368700e-01, &
     &2.180600e-01,5.450600e-01,3.956600e-01,5.220800e-01,4.570400e-01, &
     &4.010300e-01,3.509900e-01,2.964000e-01,2.738200e-01,2.961100e-01, &
     &5.220800e-01,5.381300e-01,5.000900e-01,4.377700e-01,3.942400e-01, &
     &3.474300e-01,3.138000e-01,3.565500e-01,3.884400e-01,5.000900e-01, &
     &7.124800e-01,4.784200e-01,4.206700e-01,3.868100e-01,3.443800e-01, &
     &3.822400e-01,4.487400e-01,4.967000e-01,4.784200e-01,9.206900e-01, &
     &5.892900e-01,5.157600e-01,4.425300e-01,3.689900e-01,3.086600e-01, &
     &2.459300e-01,1.741900e-01,5.892900e-01,2.701600e-01,5.649500e-01, &
     &4.944600e-01,4.240500e-01,3.695600e-01,3.094100e-01,2.458400e-01, &
     &2.090000e-01,5.649500e-01,3.613600e-01,5.406800e-01,4.732800e-01, &
     &4.175000e-01,3.638000e-01,3.086900e-01,2.678200e-01,2.884500e-01, &
     &5.406800e-01,4.868400e-01,5.170600e-01,4.525900e-01,4.084800e-01, &
     &3.607500e-01,3.165800e-01,3.432300e-01,3.802500e-01,5.170600e-01, &
     &6.534600e-01,4.940400e-01,4.383100e-01,4.009100e-01,3.560400e-01, &
     &3.727400e-01,4.356300e-01,4.865700e-01,4.940400e-01,8.544300e-01, &
     &6.146000e-01,5.379200e-01,4.611900e-01,3.844600e-01,3.158000e-01, &
     &2.524500e-01,1.806900e-01,6.146000e-01,2.447600e-01,5.890200e-01, &
     &5.155000e-01,4.420100e-01,3.820100e-01,3.198100e-01,2.524600e-01, &
     &1.929000e-01,5.890200e-01,3.238400e-01,5.635900e-01,4.932500e-01, &
     &4.334000e-01,3.771700e-01,3.192400e-01,2.608500e-01,2.606000e-01, &
     &5.635900e-01,4.295300e-01,5.385800e-01,4.713900e-01,4.243300e-01, &
     &3.739200e-01,3.204300e-01,3.100600e-01,3.486700e-01,5.385800e-01, &
     &5.677300e-01,5.149000e-01,4.569600e-01,4.159200e-01,3.699100e-01, &
     &3.482200e-01,4.012200e-01,4.511800e-01,5.149000e-01,7.438700e-01, &
     &6.414500e-01,5.613400e-01,4.812300e-01,4.011900e-01,3.233200e-01, &
     &2.577800e-01,1.849400e-01,6.414500e-01,2.163000e-01,6.141900e-01, &
     &5.375000e-01,4.607900e-01,3.924100e-01,3.292200e-01,2.590600e-01, &
     &1.889200e-01,6.141900e-01,2.920800e-01,5.881300e-01,5.146800e-01, &
     &4.479900e-01,3.900400e-01,3.267100e-01,2.651000e-01,2.268500e-01, &
     &5.881300e-01,3.913700e-01,5.627300e-01,4.924800e-01,4.405900e-01, &
     &3.855600e-01,3.306000e-01,2.862500e-01,3.076000e-01,5.627300e-01, &
     &5.058900e-01,5.380400e-01,4.758800e-01,4.306700e-01,3.836900e-01, &
     &3.339500e-01,3.592100e-01,4.049500e-01,5.380400e-01,6.523700e-01, &
     &6.675900e-01,5.842000e-01,5.008200e-01,4.174500e-01,3.341700e-01, &
     &2.610100e-01,1.876900e-01,6.675900e-01,1.937100e-01,6.399300e-01, &
     &5.599800e-01,4.800900e-01,4.034200e-01,3.376200e-01,2.649300e-01, &
     &1.897300e-01,6.399300e-01,2.640900e-01,6.133200e-01,5.366700e-01, &
     &4.631400e-01,4.026600e-01,3.339700e-01,2.694100e-01,2.081900e-01, &
     &6.133200e-01,3.592800e-01,5.874300e-01,5.140600e-01,4.564400e-01, &
     &3.963700e-01,3.394700e-01,2.762000e-01,2.643200e-01,5.874300e-01, &
     &4.755400e-01,5.621200e-01,4.952600e-01,4.457400e-01,3.961700e-01, &
     &3.357200e-01,3.140700e-01,3.582800e-01,5.621200e-01,6.083700e-01, &
     &6.947300e-01,6.079300e-01,5.211900e-01,4.344000e-01,3.476400e-01, &
     &2.633600e-01,1.889600e-01,6.947300e-01,1.725000e-01,6.672100e-01, &
     &5.838200e-01,5.005300e-01,4.171900e-01,3.456100e-01,2.712100e-01, &
     &1.917700e-01,6.672100e-01,2.404400e-01,6.400000e-01,5.600400e-01, &
     &4.802400e-01,4.155400e-01,3.440200e-01,2.720600e-01,2.020200e-01, &
     &6.400000e-01,3.309900e-01,6.139400e-01,5.372700e-01,4.742300e-01, &
     &4.081100e-01,3.465600e-01,2.798400e-01,2.294400e-01,6.139400e-01, &
     &4.421400e-01,5.908400e-01,5.187900e-01,4.625200e-01,4.075800e-01, &
     &3.460200e-01,2.875100e-01,3.043200e-01,5.908400e-01,5.778700e-01/
      data  absa(271:585,13) /                                          &
     &7.224900e-01,6.322500e-01,5.419200e-01,4.516600e-01,3.614100e-01, &
     &2.711500e-01,1.892600e-01,7.224900e-01,1.484000e-01,6.956900e-01, &
     &6.087600e-01,5.218300e-01,4.349300e-01,3.525300e-01,2.770000e-01, &
     &1.946300e-01,6.956900e-01,2.136600e-01,6.703000e-01,5.865600e-01, &
     &5.028200e-01,4.305400e-01,3.547200e-01,2.758200e-01,2.055800e-01, &
     &6.703000e-01,3.016900e-01,6.475000e-01,5.665900e-01,4.955500e-01, &
     &4.229700e-01,3.538200e-01,2.857100e-01,2.167300e-01,6.475000e-01, &
     &4.128100e-01,6.251200e-01,5.476000e-01,4.837400e-01,4.211600e-01, &
     &3.561900e-01,2.846800e-01,2.646600e-01,6.251200e-01,5.471400e-01, &
     &7.529400e-01,6.588700e-01,5.647400e-01,4.706400e-01,3.765400e-01, &
     &2.824800e-01,1.897400e-01,7.529400e-01,1.227400e-01,7.289100e-01, &
     &6.378100e-01,5.467100e-01,4.556300e-01,3.649800e-01,2.834200e-01, &
     &1.984400e-01,7.289100e-01,1.831000e-01,7.055700e-01,6.174400e-01, &
     &5.292800e-01,4.466600e-01,3.671600e-01,2.835100e-01,2.087900e-01, &
     &7.055700e-01,2.661400e-01,6.824400e-01,5.971900e-01,5.186700e-01, &
     &4.421000e-01,3.638300e-01,2.922300e-01,2.187700e-01,6.824400e-01, &
     &3.763500e-01,6.608900e-01,5.783300e-01,5.094400e-01,4.400500e-01, &
     &3.685700e-01,2.967600e-01,2.416000e-01,6.608900e-01,5.093000e-01, &
     &7.858200e-01,6.876200e-01,5.893400e-01,4.912300e-01,3.929800e-01, &
     &2.948700e-01,1.966800e-01,7.858200e-01,9.881600e-02,7.634000e-01, &
     &6.679800e-01,5.726000e-01,4.771800e-01,3.818600e-01,2.892200e-01, &
     &2.039100e-01,7.634000e-01,1.525700e-01,7.408300e-01,6.482500e-01, &
     &5.556100e-01,4.645900e-01,3.818000e-01,2.945600e-01,2.130500e-01, &
     &7.408300e-01,2.277100e-01,7.207100e-01,6.306500e-01,5.441400e-01, &
     &4.645900e-01,3.795600e-01,3.022600e-01,2.246000e-01,7.207100e-01, &
     &3.306000e-01,7.010100e-01,6.134000e-01,5.384800e-01,4.599600e-01, &
     &3.851600e-01,3.103000e-01,2.329200e-01,7.010100e-01,4.591600e-01, &
     &8.169900e-01,7.149000e-01,6.127900e-01,5.107000e-01,4.086200e-01, &
     &3.065100e-01,2.044700e-01,8.169900e-01,2.022300e-01,7.968000e-01, &
     &6.972500e-01,5.976800e-01,4.980800e-01,3.985700e-01,2.995400e-01, &
     &2.111600e-01,7.968000e-01,2.151200e-01,7.776900e-01,6.805400e-01, &
     &5.833200e-01,4.864600e-01,3.973500e-01,3.063800e-01,2.218200e-01, &
     &7.776900e-01,2.397300e-01,7.576000e-01,6.629400e-01,5.699300e-01, &
     &4.857100e-01,3.961700e-01,3.148200e-01,2.329400e-01,7.576000e-01, &
     &3.028500e-01,7.361800e-01,6.441400e-01,5.644200e-01,4.805200e-01, &
     &4.037800e-01,3.254500e-01,2.366600e-01,7.361800e-01,4.160100e-01, &
     &8.394200e-01,7.345000e-01,6.296300e-01,5.247100e-01,4.198700e-01, &
     &3.149900e-01,2.117300e-01,8.394200e-01,5.170400e-01,8.205100e-01, &
     &7.179800e-01,6.154400e-01,5.128900e-01,4.104100e-01,3.118000e-01, &
     &2.247700e-01,8.205100e-01,5.071500e-01,8.010400e-01,7.009900e-01, &
     &6.008900e-01,5.036200e-01,4.122200e-01,3.219800e-01,2.337700e-01, &
     &8.010400e-01,5.060200e-01,7.789700e-01,6.816800e-01,5.903000e-01, &
     &5.019000e-01,4.131600e-01,3.348400e-01,2.452100e-01,7.789700e-01, &
     &5.271900e-01,7.565700e-01,6.629400e-01,5.816800e-01,4.994000e-01, &
     &4.239700e-01,3.422900e-01,2.542200e-01,7.565700e-01,5.689300e-01, &
     &8.608400e-01,7.533200e-01,6.456900e-01,5.381100e-01,4.305400e-01, &
     &3.230200e-01,2.208900e-01,8.608400e-01,8.591500e-01,8.438300e-01, &
     &7.384900e-01,6.329600e-01,5.275700e-01,4.227200e-01,3.265200e-01, &
     &2.366200e-01,8.438300e-01,8.425800e-01,8.246100e-01,7.216200e-01, &
     &6.186100e-01,5.217300e-01,4.260900e-01,3.365100e-01,2.460200e-01, &
     &8.246100e-01,8.242400e-01,8.036200e-01,7.033000e-01,6.107600e-01, &
     &5.164200e-01,4.319600e-01,3.502400e-01,2.578800e-01,8.036200e-01, &
     &8.152600e-01,7.819600e-01,6.868600e-01,5.999300e-01,5.191500e-01, &
     &4.421900e-01,3.585700e-01,2.831800e-01,7.819600e-01,8.441700e-01, &
     &8.988500e-01,7.865200e-01,6.741700e-01,5.619000e-01,4.495700e-01, &
     &3.373600e-01,2.346800e-01,8.988500e-01,1.174700e+00,8.817600e-01, &
     &7.715700e-01,6.613800e-01,5.512600e-01,4.433400e-01,3.450300e-01, &
     &2.459100e-01,8.817600e-01,1.147400e+00,8.644500e-01,7.564400e-01, &
     &6.487100e-01,5.479700e-01,4.479800e-01,3.526000e-01,2.572900e-01, &
     &8.644500e-01,1.116700e+00,8.453100e-01,7.396800e-01,6.422800e-01, &
     &5.428800e-01,4.570300e-01,3.658800e-01,2.754600e-01,8.453100e-01, &
     &1.093700e+00,8.263600e-01,7.279100e-01,6.342700e-01,5.503500e-01, &
     &4.645600e-01,3.821000e-01,3.191400e-01,8.263600e-01,1.109100e+00/
      data  absa(1:270,14) /                                            &
     &6.540048e-01,5.721184e-01,4.909770e-01,4.092275e-01,3.287697e-01, &
     &2.834457e-01,2.768631e-01,6.540048e-01,6.917000e-01,6.225228e-01, &
     &5.448837e-01,4.670632e-01,3.937976e-01,3.647266e-01,3.700110e-01, &
     &3.825037e-01,6.225258e-01,9.617109e-01,5.910416e-01,5.173734e-01, &
     &4.441758e-01,4.251202e-01,4.517172e-01,4.929889e-01,5.091599e-01, &
     &5.910416e-01,1.288786e+00,5.618904e-01,4.919098e-01,4.543647e-01, &
     &4.990555e-01,5.863570e-01,6.385998e-01,6.571716e-01,5.618904e-01, &
     &1.673439e+00,5.334442e-01,4.667144e-01,4.947492e-01,6.254746e-01, &
     &7.413285e-01,8.077296e-01,8.252665e-01,5.334442e-01,2.113550e+00, &
     &6.917379e-01,6.054397e-01,5.189079e-01,4.326927e-01,3.477826e-01, &
     &2.930179e-01,2.754446e-01,6.917379e-01,6.771960e-01,6.574324e-01, &
     &5.755112e-01,4.935647e-01,4.166931e-01,3.796262e-01,3.719302e-01, &
     &3.863220e-01,6.574324e-01,9.567876e-01,6.235204e-01,5.457951e-01, &
     &4.696484e-01,4.457737e-01,4.598828e-01,5.029414e-01,5.207404e-01, &
     &6.235204e-01,1.298623e+00,5.910956e-01,5.174455e-01,4.796638e-01, &
     &5.160319e-01,6.007256e-01,6.609803e-01,6.834523e-01,5.910956e-01, &
     &1.704645e+00,5.604536e-01,4.907155e-01,5.201678e-01,6.429336e-01, &
     &7.673643e-01,8.448583e-01,8.712294e-01,5.604536e-01,2.175750e+00, &
     &7.369944e-01,6.450647e-01,5.531998e-01,4.612413e-01,3.690844e-01, &
     &2.949797e-01,2.538666e-01,7.369944e-01,6.058555e-01,6.994851e-01, &
     &6.123214e-01,5.250914e-01,4.392117e-01,3.846789e-01,3.564157e-01, &
     &3.590764e-01,6.994851e-01,8.739995e-01,6.627792e-01,5.802378e-01, &
     &4.979238e-01,4.573672e-01,4.484818e-01,4.773742e-01,4.981358e-01, &
     &6.627792e-01,1.212193e+00,6.269838e-01,5.489387e-01,5.005342e-01, &
     &5.136520e-01,5.770987e-01,6.398689e-01,6.672202e-01,6.269838e-01, &
     &1.624511e+00,5.937681e-01,5.198900e-01,5.328662e-01,6.270860e-01, &
     &7.498427e-01,8.318372e-01,8.668075e-01,5.937681e-01,2.117002e+00, &
     &7.874876e-01,6.892231e-01,5.910774e-01,4.928415e-01,3.945543e-01, &
     &3.014522e-01,2.374915e-01,7.874876e-01,5.316682e-01,7.445545e-01, &
     &6.517366e-01,5.588864e-01,4.660417e-01,3.915294e-01,3.428092e-01, &
     &3.216914e-01,7.445545e-01,7.712061e-01,7.051035e-01,6.172532e-01, &
     &5.293906e-01,4.696830e-01,4.392999e-01,4.379810e-01,4.599617e-01, &
     &7.051035e-01,1.084564e+00,6.666800e-01,5.836909e-01,5.220767e-01, &
     &5.117595e-01,5.424100e-01,6.000580e-01,6.304639e-01,6.666800e-01, &
     &1.491172e+00,6.297727e-01,5.514154e-01,5.440122e-01,6.055712e-01, &
     &7.149495e-01,7.955763e-01,8.356975e-01,6.297727e-01,1.985771e+00, &
     &8.389008e-01,7.342317e-01,6.295705e-01,5.248657e-01,4.198934e-01, &
     &3.152988e-01,2.297655e-01,8.389008e-01,4.649666e-01,7.919492e-01, &
     &6.931681e-01,5.944361e-01,4.955885e-01,4.044424e-01,3.366989e-01, &
     &2.916224e-01,7.919492e-01,6.819191e-01,7.484108e-01,6.550879e-01, &
     &5.618141e-01,4.853591e-01,4.362375e-01,4.080612e-01,4.169923e-01, &
     &7.484108e-01,9.680042e-01,7.072390e-01,6.192045e-01,5.453315e-01, &
     &5.148074e-01,5.156584e-01,5.573831e-01,5.866924e-01,7.072390e-01, &
     &1.343781e+00,6.676896e-01,5.845528e-01,5.584240e-01,5.900508e-01, &
     &6.723970e-01,7.540521e-01,7.941555e-01,6.676896e-01,1.822082e+00, &
     &8.928025e-01,7.814019e-01,6.699703e-01,5.584803e-01,4.470398e-01, &
     &3.354756e-01,2.290996e-01,8.928025e-01,3.986669e-01,8.425891e-01, &
     &7.374772e-01,6.323162e-01,5.272323e-01,4.227344e-01,3.360745e-01, &
     &2.703222e-01,8.425891e-01,5.911469e-01,7.940807e-01,6.951335e-01, &
     &5.961136e-01,5.041561e-01,4.368585e-01,3.866139e-01,3.689249e-01, &
     &7.940807e-01,8.509411e-01,7.502852e-01,6.567774e-01,5.703687e-01, &
     &5.213209e-01,4.950003e-01,5.044010e-01,5.336954e-01,7.502852e-01, &
     &1.196598e+00,7.080648e-01,6.198726e-01,5.753074e-01,5.776855e-01, &
     &6.232156e-01,6.966525e-01,7.398339e-01,7.080648e-01,1.639205e+00/
      data  absa(271:585,14) /                                          &
     &9.476042e-01,8.292823e-01,7.109426e-01,5.926445e-01,4.742929e-01, &
     &3.559982e-01,2.371706e-01,9.476042e-01,3.435473e-01,8.938949e-01, &
     &7.823405e-01,6.708230e-01,5.592054e-01,4.476774e-01,3.426293e-01, &
     &2.579922e-01,8.938949e-01,5.135880e-01,8.423353e-01,7.372488e-01, &
     &6.321821e-01,5.285321e-01,4.445795e-01,3.753586e-01,3.263676e-01, &
     &8.423353e-01,7.470983e-01,7.939792e-01,6.949704e-01,5.990389e-01, &
     &5.329770e-01,4.835371e-01,4.612865e-01,4.772714e-01,7.939792e-01, &
     &1.061737e+00,7.503806e-01,6.568944e-01,5.957661e-01,5.720993e-01, &
     &5.847729e-01,6.314818e-01,6.780830e-01,7.503806e-01,1.472612e+00, &
     &1.002786e+00,8.776228e-01,7.524148e-01,6.271870e-01,5.019116e-01, &
     &3.767165e-01,2.513162e-01,1.002786e+00,2.989113e-01,9.460810e-01, &
     &8.279787e-01,7.099196e-01,5.917951e-01,4.736525e-01,3.562676e-01, &
     &2.540449e-01,9.460810e-01,4.505759e-01,8.933464e-01,7.818918e-01, &
     &6.704301e-01,5.589569e-01,4.585582e-01,3.725011e-01,3.008276e-01, &
     &8.933464e-01,6.630111e-01,8.438035e-01,7.385452e-01,6.335496e-01, &
     &5.505549e-01,4.829211e-01,4.328966e-01,4.234085e-01,8.438035e-01, &
     &9.496084e-01,7.987214e-01,6.991503e-01,6.217417e-01,5.751832e-01, &
     &5.586804e-01,5.721346e-01,6.124358e-01,7.987214e-01,1.331840e+00, &
     &1.063254e+00,9.305180e-01,7.976962e-01,6.649210e-01,5.320401e-01, &
     &3.992552e-01,2.663782e-01,1.063254e+00,2.598541e-01,1.005687e+00, &
     &8.801488e-01,7.546166e-01,6.290167e-01,5.033855e-01,3.777314e-01, &
     &2.573538e-01,1.005687e+00,3.962885e-01,9.515613e-01,8.328559e-01, &
     &7.140477e-01,5.952569e-01,4.794976e-01,3.769751e-01,2.880725e-01, &
     &9.515613e-01,5.901570e-01,9.013619e-01,7.889990e-01,6.765511e-01, &
     &5.756904e-01,4.910213e-01,4.176570e-01,3.810977e-01,9.013619e-01, &
     &8.547969e-01,8.563212e-01,7.495386e-01,6.564465e-01,5.902062e-01, &
     &5.447891e-01,5.282731e-01,5.515317e-01,8.563212e-01,1.209756e+00, &
     &1.127087e+00,9.863424e-01,8.455573e-01,7.047145e-01,5.639471e-01, &
     &4.230722e-01,2.822065e-01,1.127087e+00,3.010595e-01,1.067881e+00, &
     &9.345231e-01,8.011838e-01,6.677510e-01,5.344274e-01,4.010490e-01, &
     &2.682177e-01,1.067881e+00,3.818287e-01,1.015335e+00,8.886499e-01, &
     &7.618427e-01,6.350663e-01,5.083914e-01,3.918389e-01,2.880580e-01, &
     &1.015335e+00,5.478168e-01,9.689668e-01,8.480575e-01,7.271125e-01, &
     &6.123098e-01,5.120024e-01,4.213431e-01,3.616893e-01,9.689668e-01, &
     &7.981656e-01,9.288097e-01,8.129776e-01,7.054108e-01,6.215338e-01, &
     &5.527309e-01,5.122191e-01,5.139692e-01,9.288097e-01,1.137513e+00, &
     &1.173352e+00,1.026727e+00,8.801147e-01,7.335477e-01,5.868955e-01, &
     &4.403682e-01,2.938087e-01,1.173352e+00,6.591916e-01,1.121399e+00, &
     &9.814805e-01,8.413203e-01,7.012480e-01,5.610973e-01,4.208493e-01, &
     &2.847119e-01,1.121399e+00,6.885412e-01,1.075903e+00,9.416041e-01, &
     &8.072338e-01,6.728282e-01,5.414481e-01,4.208088e-01,3.168922e-01, &
     &1.075903e+00,7.718862e-01,1.038082e+00,9.085345e-01,7.789626e-01, &
     &6.614202e-01,5.555907e-01,4.614604e-01,4.052378e-01,1.038082e+00, &
     &9.511091e-01,1.006534e+00,8.808681e-01,7.704271e-01,6.813436e-01, &
     &6.116924e-01,5.704511e-01,5.657784e-01,1.006534e+00,1.273090e+00, &
     &1.242372e+00,1.087158e+00,9.319829e-01,7.767339e-01,6.215223e-01, &
     &4.662369e-01,3.108293e-01,1.242372e+00,1.120651e+00,1.199225e+00, &
     &1.049449e+00,8.996235e-01,7.497535e-01,6.000026e-01,4.501338e-01, &
     &3.106964e-01,1.199225e+00,1.110297e+00,1.163827e+00,1.018477e+00, &
     &8.731078e-01,7.277235e-01,5.900510e-01,4.613684e-01,3.545513e-01, &
     &1.163827e+00,1.155700e+00,1.134953e+00,9.931890e-01,8.530508e-01, &
     &7.289525e-01,6.137648e-01,5.181038e-01,4.552266e-01,1.134953e+00, &
     &1.284166e+00,1.112419e+00,9.735395e-01,8.565917e-01,7.595087e-01, &
     &6.851682e-01,6.385202e-01,6.227467e-01,1.112419e+00,1.531588e+00, &
     &1.338130e+00,1.170962e+00,1.003767e+00,8.365734e-01,6.692854e-01, &
     &5.021732e-01,3.349118e-01,1.338130e+00,1.570955e+00,1.305214e+00, &
     &1.142175e+00,9.790406e-01,8.160265e-01,6.529050e-01,4.920150e-01, &
     &3.474598e-01,1.305214e+00,1.536160e+00,1.279404e+00,1.119497e+00, &
     &9.596735e-01,8.019266e-01,6.538864e-01,5.161908e-01,4.005427e-01, &
     &1.279404e+00,1.557463e+00,1.259091e+00,1.101810e+00,9.497449e-01, &
     &8.136011e-01,6.868908e-01,5.856661e-01,5.113727e-01,1.259091e+00, &
     &1.660014e+00,1.241171e+00,1.086423e+00,9.597698e-01,8.537390e-01, &
     &7.728492e-01,7.148460e-01,6.856565e-01,1.241171e+00,1.870186e+00/
 
!     the array absb(1410,NG04) = kb(6,5,13:59,NG04) contains absorption
!     coefs for each of the NG04=14 g-intervals for a range of pressure
!     levels  < ~100mb, temperatures, and ratios of o3 to co2.  the first
!     index in the array, js, runs from 1 to 6, and corresponds to
!     different o3 to co2 ratios, as expressed through the binary species
!     parameter eta, defined as eta = o3/(o3+rat*h2o), where rat is the
!     ratio of the integrated line strength in the band of co2 to that of
!     o3.  for instance, js=1 refers to no o3 (eta = 0) and js = 5
!     corresponds to eta = 1.0.  the second index, jt, which runs from 1
!     to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     third index, jp, runs from 13 to 59 and refers to the corresponding
!     pressure level in pref (e.g. jp = 13 is for a pressure of 95.5835 mb).
!     the fourth index, ig, goes from 1 to NG04=14, and tells us which
!     g-interval the absorption coefficients are for.
 
      data  absb(1:360,1) /                                             &
     &1.059000e-03,1.170800e-03,6.180400e-03,8.385100e-03,9.840100e-03, &
     &1.065000e-02,1.273700e-03,1.392100e-03,6.783700e-03,9.180200e-03, &
     &1.072400e-02,1.169400e-02,1.492800e-03,1.616700e-03,7.303700e-03, &
     &9.809700e-03,1.141300e-02,1.255900e-02,1.710100e-03,1.838000e-03, &
     &7.736100e-03,1.030500e-02,1.193200e-02,1.325200e-02,1.926800e-03, &
     &2.057400e-03,8.104000e-03,1.070900e-02,1.232100e-02,1.378700e-02, &
     &8.985300e-04,1.005300e-03,5.261200e-03,7.125700e-03,8.317000e-03, &
     &8.627700e-03,1.078500e-03,1.191400e-03,5.751300e-03,7.756400e-03, &
     &9.011800e-03,9.381900e-03,1.259100e-03,1.378200e-03,6.171500e-03, &
     &8.247800e-03,9.548400e-03,9.999600e-03,1.439700e-03,1.562700e-03, &
     &6.519300e-03,8.648700e-03,9.962000e-03,1.048500e-02,1.620100e-03, &
     &1.745900e-03,6.816500e-03,8.982700e-03,1.027300e-02,1.085500e-02, &
     &7.624800e-04,8.627900e-04,4.455700e-03,6.020700e-03,6.989600e-03, &
     &7.023600e-03,9.111700e-04,1.018000e-03,4.856100e-03,6.512700e-03, &
     &7.536900e-03,7.584600e-03,1.059600e-03,1.172300e-03,5.189800e-03, &
     &6.908900e-03,7.964300e-03,8.032500e-03,1.209400e-03,1.326300e-03, &
     &5.473400e-03,7.238000e-03,8.295700e-03,8.372300e-03,1.360300e-03, &
     &1.480200e-03,5.708500e-03,7.510400e-03,8.549700e-03,8.617800e-03, &
     &6.455800e-04,7.380400e-04,3.759600e-03,5.058900e-03,5.848500e-03, &
     &5.770500e-03,7.674800e-04,8.661200e-04,4.079600e-03,5.449600e-03, &
     &6.285800e-03,6.201000e-03,8.902900e-04,9.946600e-04,4.352300e-03, &
     &5.773500e-03,6.628600e-03,6.537500e-03,1.015400e-03,1.124200e-03, &
     &4.576700e-03,6.043000e-03,6.898100e-03,6.785500e-03,1.141200e-03, &
     &1.253200e-03,4.767300e-03,6.261000e-03,7.108300e-03,6.958500e-03, &
     &5.446100e-04,6.279200e-04,3.157500e-03,4.232900e-03,4.877300e-03, &
     &4.743300e-03,6.449800e-04,7.339500e-04,3.417800e-03,4.550000e-03, &
     &5.229100e-03,5.077800e-03,7.467700e-04,8.413700e-04,3.636800e-03, &
     &4.815300e-03,5.508000e-03,5.332800e-03,8.511700e-04,9.501600e-04, &
     &3.817600e-03,5.033700e-03,5.727900e-03,5.517300e-03,9.567000e-04, &
     &1.059100e-03,3.973600e-03,5.205700e-03,5.900100e-03,5.641100e-03, &
     &4.583100e-04,5.320700e-04,2.645300e-03,3.535000e-03,4.059500e-03, &
     &3.902500e-03,5.414800e-04,6.204800e-04,2.856400e-03,3.792000e-03, &
     &4.343000e-03,4.163800e-03,6.262000e-04,7.104600e-04,3.031600e-03, &
     &4.009300e-03,4.570500e-03,4.359400e-03,7.129600e-04,8.014000e-04, &
     &3.178500e-03,4.182200e-03,4.750000e-03,4.499300e-03,8.011700e-04, &
     &8.928300e-04,3.307300e-03,4.321500e-03,4.888800e-03,4.589100e-03, &
     &3.849400e-04,4.495700e-04,2.213000e-03,2.947000e-03,3.373400e-03, &
     &3.205200e-03,4.539200e-04,5.232600e-04,2.382200e-03,3.156700e-03, &
     &3.603700e-03,3.408700e-03,5.244200e-04,5.986000e-04,2.523100e-03, &
     &3.330700e-03,3.789400e-03,3.558400e-03,5.966800e-04,6.746200e-04, &
     &2.642300e-03,3.470200e-03,3.934300e-03,3.663800e-03,6.704700e-04, &
     &7.513300e-04,2.747900e-03,3.583300e-03,4.043900e-03,3.728600e-03, &
     &3.239100e-04,3.800200e-04,1.850500e-03,2.457500e-03,2.804500e-03, &
     &2.640000e-03,3.811100e-04,4.415000e-04,1.985500e-03,2.626800e-03, &
     &2.991300e-03,2.798000e-03,4.398500e-04,5.043800e-04,2.098000e-03, &
     &2.765700e-03,3.141200e-03,2.914000e-03,5.001200e-04,5.679600e-04, &
     &2.195200e-03,2.878300e-03,3.255700e-03,2.993700e-03,5.615100e-04, &
     &6.316900e-04,2.283400e-03,2.970000e-03,3.342700e-03,3.041000e-03, &
     &2.724000e-04,3.207100e-04,1.544200e-03,2.048100e-03,2.331000e-03, &
     &2.174800e-03,3.199200e-04,3.720000e-04,1.651900e-03,2.183100e-03, &
     &2.482200e-03,2.298400e-03,3.688300e-04,4.243200e-04,1.743000e-03, &
     &2.294500e-03,2.600400e-03,2.388000e-03,4.189000e-04,4.773600e-04, &
     &1.823000e-03,2.384900e-03,2.691600e-03,2.448300e-03,4.701800e-04, &
     &5.302000e-04,1.896300e-03,2.460100e-03,2.762000e-03,2.483400e-03, &
     &2.315300e-04,2.730300e-04,1.291500e-03,1.712000e-03,1.945600e-03, &
     &1.798900e-03,2.710300e-04,3.157800e-04,1.377300e-03,1.818700e-03, &
     &2.064300e-03,1.894000e-03,3.118700e-04,3.594700e-04,1.451200e-03, &
     &1.906800e-03,2.156600e-03,1.961500e-03,3.535000e-04,4.034500e-04, &
     &1.517200e-03,1.979400e-03,2.228800e-03,2.005900e-03,3.961900e-04, &
     &4.471300e-04,1.577100e-03,2.041500e-03,2.284300e-03,2.031000e-03, &
     &1.968000e-04,2.322400e-04,1.078500e-03,1.428800e-03,1.622300e-03, &
     &1.487100e-03,2.297000e-04,2.679100e-04,1.147400e-03,1.513800e-03, &
     &1.715300e-03,1.560000e-03,2.635600e-04,3.041100e-04,1.207500e-03, &
     &1.583900e-03,1.787500e-03,1.611100e-03,2.982300e-04,3.404900e-04, &
     &1.261500e-03,1.642800e-03,1.844400e-03,1.643600e-03,3.336600e-04, &
     &3.765500e-04,1.310600e-03,1.693600e-03,1.888500e-03,1.660600e-03, &
     &1.673200e-04,1.974900e-04,9.002400e-04,1.191200e-03,1.351500e-03, &
     &1.228400e-03,1.947000e-04,2.271200e-04,9.555800e-04,1.258700e-03, &
     &1.423900e-03,1.283800e-03,2.228100e-04,2.570700e-04,1.004800e-03, &
     &1.315300e-03,1.480800e-03,1.322100e-03,2.516900e-04,2.870800e-04, &
     &1.048400e-03,1.363000e-03,1.526000e-03,1.345300e-03,2.809400e-04, &
     &3.167400e-04,1.088600e-03,1.404600e-03,1.561400e-03,1.356100e-03/
      data  absb(361:720,1) /                                           &
     &1.423600e-04,1.679400e-04,7.512500e-04,9.928900e-04,1.125400e-03, &
     &1.014800e-03,1.651200e-04,1.924600e-04,7.959800e-04,1.046500e-03, &
     &1.181900e-03,1.056700e-03,1.884500e-04,2.172200e-04,8.359800e-04, &
     &1.092500e-03,1.226900e-03,1.085100e-03,2.125500e-04,2.419800e-04, &
     &8.713700e-04,1.131200e-03,1.263200e-03,1.101200e-03,2.364200e-04, &
     &2.660900e-04,9.037300e-04,1.164100e-03,1.290400e-03,1.107500e-03, &
     &1.213500e-04,1.429600e-04,6.270500e-04,8.275200e-04,9.367000e-04, &
     &8.388800e-04,1.402500e-04,1.632000e-04,6.633500e-04,8.708600e-04, &
     &9.812400e-04,8.702400e-04,1.596800e-04,1.836700e-04,6.955400e-04, &
     &9.076200e-04,1.017100e-03,8.908500e-04,1.796800e-04,2.041100e-04, &
     &7.242300e-04,9.389900e-04,1.046000e-03,9.017100e-04,1.991100e-04, &
     &2.235500e-04,7.504100e-04,9.646000e-04,1.066800e-03,9.048800e-04, &
     &1.034100e-04,1.215300e-04,5.231000e-04,6.896000e-04,7.791900e-04, &
     &6.937000e-04,1.191000e-04,1.382800e-04,5.524200e-04,7.242000e-04, &
     &8.141200e-04,7.171100e-04,1.352900e-04,1.552000e-04,5.782000e-04, &
     &7.537300e-04,8.428500e-04,7.317500e-04,1.517300e-04,1.719300e-04, &
     &6.015400e-04,7.786700e-04,8.656300e-04,7.389000e-04,1.675300e-04, &
     &1.876500e-04,6.228900e-04,7.988300e-04,8.813000e-04,7.399700e-04, &
     &8.806100e-05,1.032100e-04,4.362500e-04,5.743700e-04,6.477700e-04, &
     &5.734800e-04,1.011000e-04,1.170800e-04,4.598300e-04,6.022700e-04, &
     &6.755300e-04,5.909400e-04,1.145500e-04,1.310200e-04,4.804700e-04, &
     &6.256700e-04,6.982600e-04,6.012500e-04,1.280100e-04,1.446900e-04, &
     &4.995700e-04,6.454400e-04,7.160900e-04,6.058300e-04,1.408600e-04, &
     &1.573600e-04,5.169300e-04,6.617000e-04,7.279600e-04,6.057000e-04, &
     &7.500300e-05,8.766400e-05,3.637400e-04,4.783400e-04,5.384400e-04, &
     &4.748600e-04,8.584700e-05,9.915300e-05,3.826000e-04,5.006600e-04, &
     &5.604800e-04,4.878500e-04,9.700400e-05,1.106400e-04,3.992900e-04, &
     &5.192600e-04,5.785700e-04,4.950900e-04,1.079800e-04,1.216900e-04, &
     &4.147100e-04,5.346900e-04,5.920000e-04,4.979800e-04,1.183900e-04, &
     &1.319300e-04,4.288500e-04,5.479000e-04,6.012100e-04,4.971900e-04, &
     &6.385600e-05,7.442800e-05,3.030900e-04,3.983100e-04,4.474800e-04, &
     &3.933600e-04,7.287000e-05,8.390600e-05,3.181600e-04,4.159700e-04, &
     &4.650000e-04,4.029200e-04,8.207900e-05,9.334300e-05,3.316900e-04, &
     &4.306600e-04,4.791300e-04,4.080700e-04,9.101500e-05,1.022500e-04, &
     &3.443000e-04,4.431400e-04,4.894700e-04,4.097700e-04,9.939500e-05, &
     &1.105100e-04,3.557000e-04,4.535700e-04,4.965800e-04,4.087200e-04, &
     &5.435700e-05,6.317600e-05,2.524500e-04,3.315700e-04,3.717800e-04, &
     &3.264700e-04,6.186100e-05,7.099600e-05,2.644500e-04,3.453800e-04, &
     &3.857000e-04,3.335500e-04,6.941600e-05,7.870900e-05,2.755400e-04, &
     &3.571200e-04,3.967100e-04,3.372300e-04,7.665600e-05,8.588000e-05, &
     &2.857700e-04,3.670900e-04,4.044900e-04,3.382600e-04,8.338800e-05, &
     &9.252500e-05,2.950100e-04,3.753000e-04,4.100100e-04,3.372400e-04, &
     &4.625900e-05,5.360300e-05,2.101600e-04,2.758400e-04,3.089200e-04, &
     &2.710900e-04,5.249800e-05,6.005900e-05,2.198700e-04,2.867600e-04, &
     &3.198700e-04,2.763000e-04,5.865600e-05,6.629800e-05,2.289100e-04, &
     &2.961100e-04,3.283200e-04,2.789500e-04,6.449800e-05,7.207100e-05, &
     &2.371800e-04,3.040400e-04,3.343000e-04,2.795700e-04,6.991600e-05, &
     &7.742400e-05,2.447100e-04,3.105800e-04,3.385000e-04,2.785900e-04, &
     &3.936100e-05,4.546000e-05,1.749300e-04,2.293200e-04,2.565600e-04, &
     &2.252500e-04,4.451200e-05,5.076800e-05,1.828100e-04,2.380000e-04, &
     &2.651600e-04,2.291800e-04,4.951400e-05,5.578100e-05,1.901600e-04, &
     &2.454900e-04,2.716500e-04,2.311400e-04,5.422200e-05,6.042700e-05, &
     &1.968300e-04,2.516800e-04,2.762500e-04,2.315200e-04,5.856800e-05, &
     &6.473100e-05,2.029900e-04,2.569700e-04,2.793900e-04,2.305800e-04, &
     &3.332300e-05,3.837100e-05,1.453200e-04,1.902600e-04,2.127300e-04, &
     &1.868000e-04,3.754200e-05,4.270300e-05,1.517600e-04,1.972500e-04, &
     &2.194900e-04,1.898200e-04,4.160300e-05,4.675000e-05,1.577500e-04, &
     &2.032200e-04,2.244900e-04,1.912600e-04,4.541000e-05,5.050500e-05, &
     &1.632100e-04,2.082200e-04,2.281000e-04,1.914700e-04,4.887200e-05, &
     &5.394000e-05,1.682600e-04,2.125400e-04,2.304800e-04,1.906000e-04, &
     &2.784800e-05,3.201700e-05,1.201900e-04,1.572300e-04,1.757400e-04, &
     &1.546700e-04,3.130500e-05,3.555300e-05,1.254900e-04,1.629400e-04, &
     &1.811700e-04,1.571200e-04,3.462100e-05,3.884800e-05,1.303900e-04, &
     &1.678000e-04,1.851700e-04,1.583000e-04,3.770400e-05,4.189100e-05, &
     &1.349100e-04,1.718800e-04,1.880500e-04,1.584300e-04,4.047600e-05, &
     &4.464900e-05,1.390900e-04,1.754900e-04,1.899700e-04,1.577900e-04, &
     &2.295600e-05,2.638500e-05,9.892100e-05,1.294000e-04,1.446300e-04, &
     &1.277900e-04,2.579300e-05,2.928500e-05,1.033300e-04,1.341500e-04, &
     &1.491200e-04,1.298900e-04,2.852000e-05,3.199300e-05,1.074000e-04, &
     &1.382100e-04,1.524600e-04,1.309700e-04,3.102800e-05,3.447300e-05, &
     &1.111500e-04,1.416000e-04,1.548700e-04,1.311600e-04,3.326800e-05, &
     &3.670100e-05,1.146400e-04,1.446600e-04,1.564800e-04,1.307500e-04/
      data  absb(721:1080,1) /                                          &
     &1.856300e-05,2.137200e-05,8.085700e-05,1.058700e-04,1.183900e-04, &
     &1.050900e-04,2.090200e-05,2.377100e-05,8.455000e-05,1.099000e-04, &
     &1.222400e-04,1.070400e-04,2.315800e-05,2.601700e-05,8.796800e-05, &
     &1.133400e-04,1.251300e-04,1.080600e-04,2.523200e-05,2.806800e-05, &
     &9.113900e-05,1.163000e-04,1.272900e-04,1.083900e-04,2.707500e-05, &
     &2.989800e-05,9.407100e-05,1.189100e-04,1.287400e-04,1.082200e-04, &
     &1.498800e-05,1.728900e-05,6.605500e-05,8.657500e-05,9.685500e-05, &
     &8.649300e-05,1.691800e-05,1.927200e-05,6.915000e-05,8.999600e-05, &
     &1.001600e-04,8.828000e-05,1.878300e-05,2.113800e-05,7.202600e-05, &
     &9.296200e-05,1.027000e-04,8.927500e-05,2.049600e-05,2.283400e-05, &
     &7.468900e-05,9.547000e-05,1.045900e-04,8.970100e-05,2.201600e-05, &
     &2.433800e-05,7.716200e-05,9.770400e-05,1.059100e-04,8.971800e-05, &
     &1.209600e-05,1.398200e-05,5.394900e-05,7.078600e-05,7.923000e-05, &
     &7.128700e-05,1.368900e-05,1.562000e-05,5.654600e-05,7.369800e-05, &
     &8.206300e-05,7.293600e-05,1.523100e-05,1.716900e-05,5.896600e-05, &
     &7.622500e-05,8.427700e-05,7.390700e-05,1.664500e-05,1.857000e-05, &
     &6.120400e-05,7.836700e-05,8.594100e-05,7.441800e-05,1.790100e-05, &
     &1.981000e-05,6.329000e-05,8.029800e-05,8.713100e-05,7.456100e-05, &
     &9.627600e-06,1.116500e-05,4.383100e-05,5.759900e-05,6.450900e-05, &
     &5.827300e-05,1.093900e-05,1.251900e-05,4.602400e-05,6.010800e-05, &
     &6.699400e-05,5.981000e-05,1.222000e-05,1.381400e-05,4.807300e-05, &
     &6.229300e-05,6.898800e-05,6.075900e-05,1.340100e-05,1.498800e-05, &
     &4.996800e-05,6.417000e-05,7.049400e-05,6.131300e-05,1.445000e-05, &
     &1.602200e-05,5.174200e-05,6.583300e-05,7.159400e-05,6.153900e-05, &
     &7.638300e-06,8.890600e-06,3.555500e-05,4.680600e-05,5.245800e-05, &
     &4.756800e-05,8.719000e-06,1.001000e-05,3.742200e-05,4.897200e-05, &
     &5.463100e-05,4.898100e-05,9.781600e-06,1.109200e-05,3.915000e-05, &
     &5.086200e-05,5.641300e-05,4.989900e-05,1.077000e-05,1.207800e-05, &
     &4.076500e-05,5.250500e-05,5.778800e-05,5.046100e-05,1.165000e-05, &
     &1.294400e-05,4.227100e-05,5.394800e-05,5.880100e-05,5.074800e-05, &
     &6.054200e-06,7.072100e-06,2.882000e-05,3.800000e-05,4.262400e-05, &
     &3.881900e-05,6.940600e-06,7.995100e-06,3.041200e-05,3.987500e-05, &
     &4.452900e-05,4.011800e-05,7.820200e-06,8.896700e-06,3.187000e-05, &
     &4.150900e-05,4.610600e-05,4.098600e-05,8.646200e-06,9.723900e-06, &
     &3.323600e-05,4.293400e-05,4.733800e-05,4.154900e-05,9.384100e-06, &
     &1.045000e-05,3.451100e-05,4.418600e-05,4.827700e-05,4.187600e-05, &
     &4.753500e-06,5.576200e-06,2.326700e-05,3.072500e-05,3.450900e-05, &
     &3.157100e-05,5.476500e-06,6.335700e-06,2.463100e-05,3.236400e-05, &
     &3.618000e-05,3.277600e-05,6.206300e-06,7.087800e-06,2.587000e-05, &
     &3.378700e-05,3.758800e-05,3.360300e-05,6.897100e-06,7.784700e-06, &
     &2.702500e-05,3.503000e-05,3.871000e-05,3.416600e-05,7.520000e-06, &
     &8.399500e-06,2.811100e-05,3.612100e-05,3.958200e-05,3.452300e-05, &
     &3.710800e-06,4.373500e-06,1.873500e-05,2.477400e-05,2.785900e-05, &
     &2.562400e-05,4.298600e-06,4.997000e-06,1.989600e-05,2.620200e-05, &
     &2.932600e-05,2.674000e-05,4.900400e-06,5.620900e-06,2.095300e-05, &
     &2.744500e-05,3.058100e-05,2.753300e-05,5.480000e-06,6.209400e-06, &
     &2.194200e-05,2.853600e-05,3.160600e-05,2.808100e-05,6.006700e-06, &
     &6.732600e-06,2.286100e-05,2.948900e-05,3.240800e-05,2.845200e-05, &
     &2.891100e-06,3.422700e-06,1.506400e-05,1.994700e-05,2.245700e-05, &
     &2.079100e-05,3.367400e-06,3.933500e-06,1.605700e-05,2.118900e-05, &
     &2.374300e-05,2.181300e-05,3.862400e-06,4.449900e-06,1.696200e-05, &
     &2.227400e-05,2.485200e-05,2.256600e-05,4.345600e-06,4.944300e-06, &
     &1.779400e-05,2.321900e-05,2.577700e-05,2.309800e-05,4.791100e-06, &
     &5.389800e-06,1.858100e-05,2.405600e-05,2.650900e-05,2.347000e-05, &
     &2.238300e-06,2.663700e-06,1.207300e-05,1.601100e-05,1.804400e-05, &
     &1.683100e-05,2.624700e-06,3.081400e-06,1.292100e-05,1.708100e-05, &
     &1.917000e-05,1.776000e-05,3.028300e-06,3.506100e-06,1.370100e-05, &
     &1.803300e-05,2.015000e-05,1.846900e-05,3.430700e-06,3.921100e-06, &
     &1.440800e-05,1.886200e-05,2.098300e-05,1.898500e-05,3.806900e-06, &
     &4.300200e-06,1.507600e-05,1.959700e-05,2.165400e-05,1.935300e-05, &
     &1.715700e-06,2.053800e-06,9.624600e-06,1.278200e-05,1.441600e-05, &
     &1.353900e-05,2.027400e-06,2.393800e-06,1.035500e-05,1.371000e-05, &
     &1.541300e-05,1.438800e-05,2.354700e-06,2.742000e-06,1.102700e-05, &
     &1.454600e-05,1.627800e-05,1.505100e-05,2.688100e-06,3.088500e-06, &
     &1.163200e-05,1.527500e-05,1.702600e-05,1.554700e-05,3.005800e-06, &
     &3.410700e-06,1.219700e-05,1.591900e-05,1.764200e-05,1.591200e-05, &
     &1.310700e-06,1.578200e-06,7.650800e-06,1.017500e-05,1.148200e-05, &
     &1.088300e-05,1.561500e-06,1.854000e-06,8.282500e-06,1.098000e-05, &
     &1.236400e-05,1.165300e-05,1.825800e-06,2.138500e-06,8.857900e-06, &
     &1.171000e-05,1.312400e-05,1.226900e-05,2.099600e-06,2.425800e-06, &
     &9.378400e-06,1.235100e-05,1.379000e-05,1.274300e-05,2.366700e-06, &
     &2.698800e-06,9.857400e-06,1.291400e-05,1.435300e-05,1.310100e-05/
      data  absb(1081:1410,1) /                                         &
     &9.972200e-07,1.208800e-06,6.064000e-06,8.071400e-06,9.114400e-06, &
     &8.752900e-06,1.198400e-06,1.431500e-06,6.608900e-06,8.774300e-06, &
     &9.891600e-06,9.449200e-06,1.411900e-06,1.663100e-06,7.101100e-06, &
     &9.403900e-06,1.056000e-05,1.001600e-05,1.635100e-06,1.899700e-06, &
     &7.551300e-06,9.968500e-06,1.114800e-05,1.046500e-05,1.857900e-06, &
     &2.129700e-06,7.957700e-06,1.046100e-05,1.165400e-05,1.081700e-05, &
     &7.588600e-07,9.272100e-07,4.803800e-06,6.397800e-06,7.223100e-06, &
     &7.003300e-06,9.210000e-07,1.106300e-06,5.271400e-06,7.005600e-06, &
     &7.904000e-06,7.621600e-06,1.093300e-06,1.294700e-06,5.694500e-06, &
     &7.550000e-06,8.492200e-06,8.134600e-06,1.274100e-06,1.488200e-06, &
     &6.079700e-06,8.042100e-06,9.006600e-06,8.549000e-06,1.458600e-06, &
     &1.680700e-06,6.427400e-06,8.475000e-06,9.457400e-06,8.877900e-06, &
     &5.762900e-07,7.102900e-07,3.794300e-06,5.057000e-06,5.710800e-06, &
     &5.579100e-06,7.070200e-07,8.539300e-07,4.196600e-06,5.583900e-06, &
     &6.305600e-06,6.126200e-06,8.458700e-07,1.007100e-06,4.561000e-06, &
     &6.054900e-06,6.818600e-06,6.583200e-06,9.920500e-07,1.165100e-06, &
     &4.891400e-06,6.481500e-06,7.268100e-06,6.958200e-06,1.143700e-06, &
     &1.324500e-06,5.189900e-06,6.859300e-06,7.667000e-06,7.260400e-06, &
     &4.358400e-07,5.422400e-07,2.985500e-06,3.981700e-06,4.497600e-06, &
     &4.444200e-06,5.409700e-07,6.576400e-07,3.333400e-06,4.439200e-06, &
     &5.015300e-06,4.924600e-06,6.525300e-07,7.812900e-07,3.645600e-06, &
     &4.845800e-06,5.462500e-06,5.331400e-06,7.708600e-07,9.100200e-07, &
     &3.928700e-06,5.212700e-06,5.854600e-06,5.668800e-06,8.944400e-07, &
     &1.041300e-06,4.183700e-06,5.541800e-06,6.203700e-06,5.947500e-06, &
     &3.279600e-07,4.121400e-07,2.339400e-06,3.119500e-06,3.526200e-06, &
     &3.545500e-06,4.121300e-07,5.049800e-07,2.639900e-06,3.518400e-06, &
     &3.974200e-06,3.966200e-06,5.019400e-07,6.044200e-07,2.907300e-06, &
     &3.868000e-06,4.364200e-06,4.327300e-06,5.975200e-07,7.091400e-07, &
     &3.150500e-06,4.183700e-06,4.705900e-06,4.631300e-06,6.976500e-07, &
     &8.165900e-07,3.368400e-06,4.469700e-06,5.010600e-06,4.888200e-06, &
     &2.476800e-07,3.141200e-07,1.833300e-06,2.442000e-06,2.764900e-06, &
     &2.786200e-06,3.147600e-07,3.887300e-07,2.090200e-06,2.787600e-06, &
     &3.150000e-06,3.142600e-06,3.872400e-07,4.687200e-07,2.319200e-06, &
     &3.088200e-06,3.487400e-06,3.456400e-06,4.643400e-07,5.538400e-07, &
     &2.527600e-06,3.359300e-06,3.783200e-06,3.720600e-06,5.453700e-07, &
     &6.415600e-07,2.714100e-06,3.606400e-06,4.046800e-06,3.945300e-06, &
     &1.869300e-07,2.392700e-07,1.433600e-06,1.907400e-06,2.163500e-06, &
     &2.161900e-06,2.402500e-07,2.991800e-07,1.651900e-06,2.204800e-06, &
     &2.492600e-06,2.460400e-06,2.987200e-07,3.636000e-07,1.848800e-06, &
     &2.463300e-06,2.783200e-06,2.728200e-06,3.607500e-07,4.325100e-07, &
     &2.026500e-06,2.695400e-06,3.039100e-06,2.955100e-06,4.264800e-07, &
     &5.040400e-07,2.185500e-06,2.907000e-06,3.266300e-06,3.145800e-06, &
     &1.405400e-07,1.817600e-07,1.116100e-06,1.483400e-06,1.685800e-06, &
     &1.670600e-06,1.827200e-07,2.296200e-07,1.301400e-06,1.737700e-06, &
     &1.965600e-06,1.921500e-06,2.296800e-07,2.814400e-07,1.470200e-06, &
     &1.960200e-06,2.214900e-06,2.147800e-06,2.797300e-07,3.370900e-07, &
     &1.621900e-06,2.158600e-06,2.435800e-06,2.342800e-06,3.329200e-07, &
     &3.953500e-07,1.757800e-06,2.339800e-06,2.632100e-06,2.505800e-06, &
     &1.051000e-07,1.375000e-07,8.640500e-07,1.147300e-06,1.307600e-06, &
     &1.285000e-06,1.384900e-07,1.756000e-07,1.022200e-06,1.363800e-06, &
     &1.544600e-06,1.496100e-06,1.759900e-07,2.172700e-07,1.165900e-06, &
     &1.555600e-06,1.758300e-06,1.685900e-06,2.164200e-07,2.621600e-07, &
     &1.295400e-06,1.725200e-06,1.948300e-06,1.852800e-06,2.593700e-07, &
     &3.095400e-07,1.412000e-06,1.880200e-06,2.117700e-06,1.993100e-06, &
     &7.856200e-08,1.041200e-07,6.669700e-07,8.854700e-07,1.012200e-06, &
     &9.835900e-07,1.050500e-07,1.343500e-07,8.018600e-07,1.068800e-06, &
     &1.212300e-06,1.160200e-06,1.349100e-07,1.678100e-07,9.234300e-07, &
     &1.233000e-06,1.394700e-06,1.318900e-06,1.675500e-07,2.039800e-07, &
     &1.034100e-06,1.378100e-06,1.557600e-06,1.460000e-06,2.021900e-07, &
     &2.424500e-07,1.133700e-06,1.510400e-06,1.702900e-06,1.579700e-06, &
     &6.203200e-08,8.266700e-08,5.335800e-07,7.086000e-07,8.106100e-07, &
     &7.599200e-07,8.346400e-08,1.071400e-07,6.459600e-07,8.609200e-07, &
     &9.771400e-07,9.033000e-07,1.077200e-07,1.344500e-07,7.472700e-07, &
     &9.982200e-07,1.129300e-06,1.031000e-06,1.343400e-07,1.639400e-07, &
     &8.400000e-07,1.119700e-06,1.265800e-06,1.143100e-06,1.626000e-07, &
     &1.954000e-07,9.232800e-07,1.230700e-06,1.388100e-06,1.238800e-06/
      data  absb(1:360,2) /                                             &
     &3.652300e-03,3.893900e-03,1.927200e-02,2.774000e-02,3.351200e-02, &
     &3.362700e-02,4.069800e-03,4.300600e-03,2.014000e-02,2.915900e-02, &
     &3.560300e-02,3.637500e-02,4.441200e-03,4.665000e-03,2.090700e-02, &
     &3.032900e-02,3.717800e-02,3.873200e-02,4.748300e-03,4.965200e-03, &
     &2.159200e-02,3.126600e-02,3.822200e-02,4.051400e-02,4.982900e-03, &
     &5.193800e-03,2.216800e-02,3.196900e-02,3.879400e-02,4.174100e-02, &
     &3.086500e-03,3.320000e-03,1.653100e-02,2.381700e-02,2.889700e-02, &
     &2.814200e-02,3.436200e-03,3.660300e-03,1.725200e-02,2.496600e-02, &
     &3.054500e-02,3.021100e-02,3.743100e-03,3.958600e-03,1.789900e-02, &
     &2.589100e-02,3.168400e-02,3.182400e-02,3.987200e-03,4.195500e-03, &
     &1.845900e-02,2.659400e-02,3.236200e-02,3.290700e-02,4.170300e-03, &
     &4.374800e-03,1.891100e-02,2.707400e-02,3.268300e-02,3.359100e-02, &
     &2.611500e-03,2.831100e-03,1.408500e-02,2.030400e-02,2.471000e-02, &
     &2.351400e-02,2.904100e-03,3.114400e-03,1.468000e-02,2.121000e-02, &
     &2.593100e-02,2.499900e-02,3.153000e-03,3.354000e-03,1.521200e-02, &
     &2.190400e-02,2.671100e-02,2.606400e-02,3.344600e-03,3.539500e-03, &
     &1.564100e-02,2.240900e-02,2.714100e-02,2.675500e-02,3.484900e-03, &
     &3.679400e-03,1.599500e-02,2.275000e-02,2.733000e-02,2.715200e-02, &
     &2.212900e-03,2.416800e-03,1.192800e-02,1.717900e-02,2.093800e-02, &
     &1.961700e-02,2.453600e-03,2.649100e-03,1.240900e-02,1.786600e-02, &
     &2.179900e-02,2.068200e-02,2.651400e-03,2.838400e-03,1.282200e-02, &
     &1.838000e-02,2.233800e-02,2.142600e-02,2.795100e-03,2.977800e-03, &
     &1.315700e-02,1.876900e-02,2.263000e-02,2.190200e-02,2.903600e-03, &
     &3.086000e-03,1.343500e-02,1.902700e-02,2.274600e-02,2.214600e-02, &
     &1.873500e-03,2.062700e-03,1.003600e-02,1.442400e-02,1.757700e-02, &
     &1.626500e-02,2.066200e-03,2.248800e-03,1.041800e-02,1.494400e-02, &
     &1.819900e-02,1.705200e-02,2.219400e-03,2.392500e-03,1.073900e-02, &
     &1.535000e-02,1.858900e-02,1.759500e-02,2.329100e-03,2.499000e-03, &
     &1.100900e-02,1.565600e-02,1.879600e-02,1.792400e-02,2.416800e-03, &
     &2.586900e-03,1.122000e-02,1.586700e-02,1.887200e-02,1.807200e-02, &
     &1.580300e-03,1.754900e-03,8.398200e-03,1.203800e-02,1.465700e-02, &
     &1.344300e-02,1.732500e-03,1.901000e-03,8.700100e-03,1.244500e-02, &
     &1.512400e-02,1.403700e-02,1.850600e-03,2.009500e-03,8.959900e-03, &
     &1.277300e-02,1.541500e-02,1.444200e-02,1.937200e-03,2.094500e-03, &
     &9.168200e-03,1.302300e-02,1.557100e-02,1.467300e-02,2.008600e-03, &
     &2.166800e-03,9.336000e-03,1.318900e-02,1.562700e-02,1.476700e-02, &
     &1.326300e-03,1.484200e-03,6.996500e-03,1.000500e-02,1.217100e-02, &
     &1.107300e-02,1.446300e-03,1.597500e-03,7.242000e-03,1.033500e-02, &
     &1.253200e-02,1.152700e-02,1.539100e-03,1.681900e-03,7.447300e-03, &
     &1.060500e-02,1.275600e-02,1.182500e-02,1.608700e-03,1.751500e-03, &
     &7.613200e-03,1.080600e-02,1.287900e-02,1.198700e-02,1.666700e-03, &
     &1.811300e-03,7.748900e-03,1.092700e-02,1.292300e-02,1.204200e-02, &
     &1.110600e-03,1.250400e-03,5.817900e-03,8.301600e-03,1.008800e-02, &
     &9.125400e-03,1.206000e-03,1.338500e-03,6.016300e-03,8.572600e-03, &
     &1.036800e-02,9.472300e-03,1.278900e-03,1.405200e-03,6.176900e-03, &
     &8.790700e-03,1.054100e-02,9.694200e-03,1.335100e-03,1.462200e-03, &
     &6.311800e-03,8.943300e-03,1.064000e-02,9.807700e-03,1.382500e-03, &
     &1.512300e-03,6.421800e-03,9.035000e-03,1.067200e-02,9.836600e-03, &
     &9.278900e-04,1.049900e-03,4.830900e-03,6.877600e-03,8.344200e-03, &
     &7.515700e-03,1.003900e-03,1.118300e-03,4.987000e-03,7.101600e-03, &
     &8.565000e-03,7.781600e-03,1.061700e-03,1.172300e-03,5.116100e-03, &
     &7.272300e-03,8.703200e-03,7.946300e-03,1.107000e-03,1.218500e-03, &
     &5.223600e-03,7.388600e-03,8.779900e-03,8.025700e-03,1.145500e-03, &
     &1.260700e-03,5.314300e-03,7.459000e-03,8.797600e-03,8.038100e-03, &
     &7.783800e-04,8.827400e-04,4.014300e-03,5.707000e-03,6.907900e-03, &
     &6.201900e-03,8.380300e-04,9.354900e-04,4.136000e-03,5.883800e-03, &
     &7.078200e-03,6.400600e-03,8.831400e-04,9.791401e-04,4.237400e-03, &
     &6.014500e-03,7.184500e-03,6.516800e-03,9.196800e-04,1.016500e-03, &
     &4.324100e-03,6.102600e-03,7.235800e-03,6.568200e-03,9.504700e-04, &
     &1.051200e-03,4.401200e-03,6.154700e-03,7.242800e-03,6.567300e-03, &
     &6.521500e-04,7.403600e-04,3.330500e-03,4.731900e-03,5.714200e-03, &
     &5.113700e-03,6.989400e-04,7.816200e-04,3.426400e-03,4.869300e-03, &
     &5.845600e-03,5.260200e-03,7.338800e-04,8.161800e-04,3.507800e-03, &
     &4.968200e-03,5.922200e-03,5.341700e-03,7.633300e-04,8.469500e-04, &
     &3.579900e-03,5.034900e-03,5.956400e-03,5.373300e-03,7.890400e-04, &
     &8.761200e-04,3.645400e-03,5.075500e-03,5.957400e-03,5.364800e-03, &
     &5.461000e-04,6.197700e-04,2.759800e-03,3.920300e-03,4.724500e-03, &
     &4.211300e-03,5.822200e-04,6.520500e-04,2.836600e-03,4.025800e-03, &
     &4.822200e-03,4.318000e-03,6.096900e-04,6.797400e-04,2.903400e-03, &
     &4.101000e-03,4.877800e-03,4.373900e-03,6.334700e-04,7.050900e-04, &
     &2.964400e-03,4.152300e-03,4.899500e-03,4.391000e-03,6.554500e-04, &
     &7.302100e-04,3.019800e-03,4.186100e-03,4.897600e-03,4.378900e-03/
      data  absb(361:720,2) /                                           &
     &4.569000e-04,5.179300e-04,2.285200e-03,3.245800e-03,3.904300e-03, &
     &3.468000e-03,4.845800e-04,5.433400e-04,2.347500e-03,3.326400e-03, &
     &3.975200e-03,3.543400e-03,5.065400e-04,5.657300e-04,2.403600e-03, &
     &3.384700e-03,4.014700e-03,3.581300e-03,5.256800e-04,5.867600e-04, &
     &2.454700e-03,3.425800e-03,4.028400e-03,3.589300e-03,5.446900e-04, &
     &6.084100e-04,2.500000e-03,3.453000e-03,4.025200e-03,3.573500e-03, &
     &3.820500e-04,4.324200e-04,1.892500e-03,2.685700e-03,3.223700e-03, &
     &2.854100e-03,4.033500e-04,4.526300e-04,1.943800e-03,2.748400e-03, &
     &3.275700e-03,2.908700e-03,4.209200e-04,4.707500e-04,1.990400e-03, &
     &2.794200e-03,3.302600e-03,2.932400e-03,4.365500e-04,4.882100e-04, &
     &2.032600e-03,2.827100e-03,3.311900e-03,2.934400e-03,4.531600e-04, &
     &5.071200e-04,2.068500e-03,2.849900e-03,3.308400e-03,2.916200e-03, &
     &3.189600e-04,3.605200e-04,1.567300e-03,2.221100e-03,2.660100e-03, &
     &2.349200e-03,3.354400e-04,3.765400e-04,1.609500e-03,2.269700e-03, &
     &2.696900e-03,2.386800e-03,3.496500e-04,3.914300e-04,1.647800e-03, &
     &2.306800e-03,2.716300e-03,2.402300e-03,3.626800e-04,4.061200e-04, &
     &1.681800e-03,2.333300e-03,2.722700e-03,2.399900e-03,3.770800e-04, &
     &4.226300e-04,1.710400e-03,2.351400e-03,2.719100e-03,2.381100e-03, &
     &2.658500e-04,3.001400e-04,1.297900e-03,1.836300e-03,2.193500e-03, &
     &1.933200e-03,2.788700e-04,3.130000e-04,1.332500e-03,1.875300e-03, &
     &2.220700e-03,1.959300e-03,2.904100e-04,3.253000e-04,1.363700e-03, &
     &1.904700e-03,2.234800e-03,1.968700e-03,3.013900e-04,3.378600e-04, &
     &1.391000e-03,1.926000e-03,2.239500e-03,1.963700e-03,3.138100e-04, &
     &3.521800e-04,1.414700e-03,1.939500e-03,2.236300e-03,1.945800e-03, &
     &2.214300e-04,2.496800e-04,1.074800e-03,1.518200e-03,1.807800e-03, &
     &1.592300e-03,2.318600e-04,2.601600e-04,1.103300e-03,1.549300e-03, &
     &1.828100e-03,1.610400e-03,2.412100e-04,2.703600e-04,1.128500e-03, &
     &1.572600e-03,1.838800e-03,1.615500e-03,2.506200e-04,2.812800e-04, &
     &1.150600e-03,1.588800e-03,1.842000e-03,1.608200e-03,2.613000e-04, &
     &2.935800e-04,1.170400e-03,1.599200e-03,1.839100e-03,1.592400e-03, &
     &1.843400e-04,2.075400e-04,8.902600e-04,1.255400e-03,1.489900e-03, &
     &1.311900e-03,1.927100e-04,2.162000e-04,9.133900e-04,1.280000e-03, &
     &1.505500e-03,1.324500e-03,2.003400e-04,2.247700e-04,9.337300e-04, &
     &1.298100e-03,1.513300e-03,1.326200e-03,2.083800e-04,2.341600e-04, &
     &9.518800e-04,1.310400e-03,1.515900e-03,1.319000e-03,2.176600e-04, &
     &2.447500e-04,9.684200e-04,1.319000e-03,1.513000e-03,1.304700e-03, &
     &1.534200e-04,1.725400e-04,7.373600e-04,1.037900e-03,1.228000e-03, &
     &1.082300e-03,1.601800e-04,1.797200e-04,7.559300e-04,1.057400e-03, &
     &1.239700e-03,1.090800e-03,1.664800e-04,1.869700e-04,7.727400e-04, &
     &1.071400e-03,1.246000e-03,1.090600e-03,1.734200e-04,1.950600e-04, &
     &7.877300e-04,1.081200e-03,1.247600e-03,1.083700e-03,1.814900e-04, &
     &2.042000e-04,8.015400e-04,1.088100e-03,1.244500e-03,1.071100e-03, &
     &1.276700e-04,1.434700e-04,6.106600e-04,8.582300e-04,1.012100e-03, &
     &8.931000e-04,1.331200e-04,1.494100e-04,6.258100e-04,8.734500e-04, &
     &1.021400e-03,8.986000e-04,1.384400e-04,1.556200e-04,6.395200e-04, &
     &8.843200e-04,1.025900e-03,8.974200e-04,1.444700e-04,1.626000e-04, &
     &6.520500e-04,8.922600e-04,1.026600e-03,8.909800e-04,1.514400e-04, &
     &1.705400e-04,6.635900e-04,8.979400e-04,1.024000e-03,8.805600e-04, &
     &1.061900e-04,1.193100e-04,5.057300e-04,7.096400e-04,8.345500e-04, &
     &7.374700e-04,1.106100e-04,1.242400e-04,5.180800e-04,7.213600e-04, &
     &8.414800e-04,7.407500e-04,1.151700e-04,1.295900e-04,5.294400e-04, &
     &7.300700e-04,8.446900e-04,7.391300e-04,1.204100e-04,1.356300e-04, &
     &5.398500e-04,7.364700e-04,8.447900e-04,7.334900e-04,1.264800e-04, &
     &1.425600e-04,5.494700e-04,7.412300e-04,8.427100e-04,7.249800e-04, &
     &8.815700e-05,9.906200e-05,4.184200e-04,5.863300e-04,6.878900e-04, &
     &6.080700e-04,9.181100e-05,1.032100e-04,4.286300e-04,5.955600e-04, &
     &6.931200e-04,6.102300e-04,9.572900e-05,1.078200e-04,4.380800e-04, &
     &6.025900e-04,6.955600e-04,6.084800e-04,1.002500e-04,1.130200e-04, &
     &4.467800e-04,6.079100e-04,6.956200e-04,6.039300e-04,1.055500e-04, &
     &1.190700e-04,4.547800e-04,6.118000e-04,6.939500e-04,5.968900e-04, &
     &7.288900e-05,8.192500e-05,3.453300e-04,4.835200e-04,5.664300e-04, &
     &5.011700e-04,7.593800e-05,8.543800e-05,3.539400e-04,4.912100e-04, &
     &5.708100e-04,5.028200e-04,7.926100e-05,8.933700e-05,3.618800e-04, &
     &4.969300e-04,5.728400e-04,5.014300e-04,8.311900e-05,9.377900e-05, &
     &3.691800e-04,5.015600e-04,5.731400e-04,4.980800e-04,8.766600e-05, &
     &9.898200e-05,3.759900e-04,5.048700e-04,5.719400e-04,4.924200e-04, &
     &5.999500e-05,6.746800e-05,2.843300e-04,3.980100e-04,4.661000e-04, &
     &4.128100e-04,6.253200e-05,7.039900e-05,2.916000e-04,4.044700e-04, &
     &4.699200e-04,4.144300e-04,6.530800e-05,7.366100e-05,2.983800e-04, &
     &4.095000e-04,4.718700e-04,4.137200e-04,6.856200e-05,7.741200e-05, &
     &3.044800e-04,4.135500e-04,4.723400e-04,4.112200e-04,7.236700e-05, &
     &8.179500e-05,3.103300e-04,4.164200e-04,4.716100e-04,4.068900e-04/
      data  absb(721:1080,2) /                                          &
     &4.905900e-05,5.519900e-05,2.331700e-04,3.267100e-04,3.829500e-04, &
     &3.393800e-04,5.116500e-05,5.762000e-05,2.394100e-04,3.323900e-04, &
     &3.865200e-04,3.412000e-04,5.344300e-05,6.030400e-05,2.451900e-04, &
     &3.368700e-04,3.885300e-04,3.411000e-04,5.611400e-05,6.339500e-05, &
     &2.504400e-04,3.404900e-04,3.893000e-04,3.395500e-04,5.921400e-05, &
     &6.699900e-05,2.554600e-04,3.431800e-04,3.890500e-04,3.363100e-04, &
     &4.010400e-05,4.514500e-05,1.911800e-04,2.680800e-04,3.145700e-04, &
     &2.791200e-04,4.184800e-05,4.714500e-05,1.964900e-04,2.730500e-04, &
     &3.178900e-04,2.811200e-04,4.372100e-05,4.934800e-05,2.014300e-04, &
     &2.770900e-04,3.199000e-04,2.815400e-04,4.590800e-05,5.189300e-05, &
     &2.059500e-04,2.803300e-04,3.208600e-04,2.806200e-04,4.842800e-05, &
     &5.484800e-05,2.103000e-04,2.828700e-04,3.209800e-04,2.783200e-04, &
     &3.277900e-05,3.691300e-05,1.567600e-04,2.199600e-04,2.583500e-04, &
     &2.298600e-04,3.422600e-05,3.856800e-05,1.612700e-04,2.243100e-04, &
     &2.614000e-04,2.319300e-04,3.576400e-05,4.038200e-05,1.655000e-04, &
     &2.279000e-04,2.633400e-04,2.327100e-04,3.755800e-05,4.248000e-05, &
     &1.693900e-04,2.308200e-04,2.643900e-04,2.323000e-04,3.959600e-05, &
     &4.488900e-05,1.731500e-04,2.331300e-04,2.647700e-04,2.307200e-04, &
     &2.666900e-05,3.004900e-05,1.281200e-04,1.800300e-04,2.118700e-04, &
     &1.883800e-04,2.787100e-05,3.141100e-05,1.319700e-04,1.838900e-04, &
     &2.147200e-04,1.905200e-04,2.911500e-05,3.288300e-05,1.356400e-04, &
     &1.871700e-04,2.166400e-04,1.914900e-04,3.056900e-05,3.458400e-05, &
     &1.389900e-04,1.898000e-04,2.177900e-04,1.914700e-04,3.219200e-05, &
     &3.652500e-05,1.422300e-04,1.919200e-04,2.183500e-04,1.904500e-04, &
     &2.167100e-05,2.443600e-05,1.046400e-04,1.472100e-04,1.735400e-04, &
     &1.542200e-04,2.267300e-05,2.556400e-05,1.079400e-04,1.506700e-04, &
     &1.762400e-04,1.563500e-04,2.369200e-05,2.675800e-05,1.110900e-04, &
     &1.535900e-04,1.780900e-04,1.574600e-04,2.485900e-05,2.813300e-05, &
     &1.139800e-04,1.560000e-04,1.793200e-04,1.577200e-04,2.615700e-05, &
     &2.969400e-05,1.167900e-04,1.579700e-04,1.800600e-04,1.571400e-04, &
     &1.759900e-05,1.986800e-05,8.542800e-05,1.203300e-04,1.421000e-04, &
     &1.262400e-04,1.843700e-05,2.079800e-05,8.824700e-05,1.234000e-04, &
     &1.446000e-04,1.283200e-04,1.927600e-05,2.177100e-05,9.094000e-05, &
     &1.260000e-04,1.463600e-04,1.295300e-04,2.021400e-05,2.288300e-05, &
     &9.344400e-05,1.281900e-04,1.476100e-04,1.299500e-04,2.125600e-05, &
     &2.413800e-05,9.587900e-05,1.299900e-04,1.484200e-04,1.297100e-04, &
     &1.424100e-05,1.610700e-05,6.957500e-05,9.812200e-05,1.161000e-04, &
     &1.031300e-04,1.495300e-05,1.687600e-05,7.198900e-05,1.008800e-04, &
     &1.184700e-04,1.051600e-04,1.564300e-05,1.766800e-05,7.432200e-05, &
     &1.032100e-04,1.201600e-04,1.064300e-04,1.639200e-05,1.855900e-05, &
     &7.646900e-05,1.051900e-04,1.214000e-04,1.070200e-04,1.722500e-05, &
     &1.956100e-05,7.856900e-05,1.068600e-04,1.222800e-04,1.070400e-04, &
     &1.149800e-05,1.303600e-05,5.657600e-05,7.989500e-05,9.473300e-05, &
     &8.413100e-05,1.210600e-05,1.367000e-05,5.863700e-05,8.233300e-05, &
     &9.691700e-05,8.609400e-05,1.267600e-05,1.431700e-05,6.063400e-05, &
     &8.442900e-05,9.854600e-05,8.740900e-05,1.327700e-05,1.503100e-05, &
     &6.249900e-05,8.624000e-05,9.977200e-05,8.813000e-05,1.394300e-05, &
     &1.583200e-05,6.431000e-05,8.777000e-05,1.006600e-04,8.834400e-05, &
     &9.269300e-06,1.054300e-05,4.596300e-05,6.497800e-05,7.719400e-05, &
     &6.858900e-05,9.795700e-06,1.107400e-05,4.773900e-05,6.716500e-05, &
     &7.924100e-05,7.048300e-05,1.026700e-05,1.160000e-05,4.944500e-05, &
     &6.902700e-05,8.076900e-05,7.181200e-05,1.075400e-05,1.217400e-05, &
     &5.105000e-05,7.066100e-05,8.192100e-05,7.260100e-05,1.128700e-05, &
     &1.281400e-05,5.260500e-05,7.204800e-05,8.281900e-05,7.297400e-05, &
     &7.450300e-06,8.507500e-06,3.728100e-05,5.273500e-05,6.277600e-05, &
     &5.579700e-05,7.907100e-06,8.956600e-06,3.880100e-05,5.468200e-05, &
     &6.466200e-05,5.762100e-05,8.305400e-06,9.387400e-06,4.025400e-05, &
     &5.634700e-05,6.609600e-05,5.893600e-05,8.704700e-06,9.850800e-06, &
     &4.164300e-05,5.781500e-05,6.720600e-05,5.979300e-05,9.129300e-06, &
     &1.036200e-05,4.297800e-05,5.908600e-05,6.808700e-05,6.027500e-05, &
     &5.948200e-06,6.834300e-06,3.015200e-05,4.266500e-05,5.089800e-05, &
     &4.516900e-05,6.361000e-06,7.225000e-06,3.145500e-05,4.440600e-05, &
     &5.264300e-05,4.694200e-05,6.701800e-06,7.579900e-06,3.269500e-05, &
     &4.589700e-05,5.399200e-05,4.822900e-05,7.029600e-06,7.954900e-06, &
     &3.389600e-05,4.721000e-05,5.505000e-05,4.911200e-05,7.368400e-06, &
     &8.362300e-06,3.504200e-05,4.835900e-05,5.589500e-05,4.966500e-05, &
     &4.722600e-06,5.475500e-06,2.436600e-05,3.447000e-05,4.117300e-05, &
     &3.652000e-05,5.107500e-06,5.822000e-06,2.546900e-05,3.601000e-05, &
     &4.279700e-05,3.822200e-05,5.403000e-06,6.119600e-06,2.653500e-05, &
     &3.734200e-05,4.404900e-05,3.947400e-05,5.674000e-06,6.421300e-06, &
     &2.756600e-05,3.850700e-05,4.504100e-05,4.036700e-05,5.948500e-06, &
     &6.748300e-06,2.854400e-05,3.954200e-05,4.583900e-05,4.096600e-05/
      data  absb(1081:1410,2) /                                         &
     &3.728500e-06,4.368700e-06,1.966200e-05,2.780000e-05,3.321800e-05, &
     &2.950100e-05,4.088400e-06,4.682100e-06,2.060200e-05,2.915100e-05, &
     &3.472100e-05,3.111200e-05,4.349900e-06,4.938200e-06,2.151300e-05, &
     &3.033100e-05,3.587200e-05,3.232900e-05,4.578200e-06,5.183100e-06, &
     &2.238800e-05,3.137000e-05,3.680600e-05,3.322400e-05,4.803800e-06, &
     &5.447100e-06,2.322800e-05,3.229500e-05,3.755800e-05,3.386500e-05, &
     &2.938500e-06,3.475600e-06,1.586800e-05,2.241300e-05,2.677600e-05, &
     &2.374500e-05,3.264700e-06,3.762800e-06,1.666600e-05,2.359400e-05, &
     &2.815000e-05,2.521100e-05,3.502400e-06,3.986700e-06,1.743900e-05, &
     &2.463000e-05,2.919800e-05,2.636000e-05,3.696900e-06,4.188500e-06, &
     &1.818600e-05,2.554700e-05,3.005400e-05,2.721400e-05,3.881500e-06, &
     &4.401200e-06,1.891000e-05,2.636900e-05,3.075400e-05,2.785500e-05, &
     &2.310000e-06,2.756300e-06,1.280300e-05,1.805400e-05,2.154700e-05, &
     &1.904400e-05,2.596100e-06,3.018600e-06,1.347700e-05,1.907600e-05, &
     &2.278100e-05,2.036000e-05,2.816700e-06,3.217000e-06,1.413000e-05, &
     &1.998300e-05,2.374300e-05,2.143100e-05,2.984700e-06,3.386300e-06, &
     &1.476700e-05,2.079000e-05,2.452300e-05,2.222500e-05,3.138000e-06, &
     &3.558800e-06,1.538700e-05,2.151600e-05,2.516100e-05,2.284200e-05, &
     &1.809200e-06,2.178300e-06,1.032000e-05,1.452000e-05,1.729600e-05, &
     &1.525800e-05,2.055200e-06,2.412800e-06,1.088700e-05,1.540400e-05, &
     &1.840000e-05,1.643200e-05,2.259300e-06,2.591400e-06,1.144000e-05, &
     &1.619100e-05,1.927900e-05,1.741000e-05,2.406900e-06,2.736500e-06, &
     &1.198000e-05,1.689900e-05,1.998000e-05,1.815900e-05,2.536000e-06, &
     &2.876600e-06,1.250900e-05,1.753500e-05,2.056300e-05,1.874000e-05, &
     &1.410500e-06,1.715800e-06,8.308400e-06,1.165900e-05,1.384700e-05, &
     &1.221400e-05,1.620200e-06,1.919900e-06,8.786500e-06,1.242000e-05, &
     &1.483200e-05,1.326000e-05,1.804800e-06,2.083300e-06,9.254200e-06, &
     &1.310300e-05,1.562900e-05,1.414800e-05,1.938800e-06,2.209900e-06, &
     &9.709500e-06,1.372000e-05,1.625800e-05,1.485600e-05,2.048400e-06, &
     &2.325200e-06,1.015900e-05,1.427500e-05,1.678600e-05,1.540800e-05, &
     &1.100100e-06,1.352000e-06,6.691500e-06,9.365100e-06,1.108000e-05, &
     &9.691500e-06,1.277600e-06,1.526400e-06,7.098000e-06,1.001900e-05, &
     &1.195100e-05,1.059900e-05,1.438900e-06,1.674400e-06,7.489600e-06, &
     &1.060500e-05,1.266100e-05,1.137100e-05,1.561800e-06,1.785600e-06, &
     &7.873000e-06,1.113900e-05,1.322500e-05,1.200500e-05,1.656300e-06, &
     &1.882100e-06,8.253700e-06,1.162100e-05,1.370000e-05,1.249700e-05, &
     &8.564500e-07,1.063900e-06,5.388200e-06,7.516000e-06,8.856400e-06, &
     &7.641100e-06,1.006000e-06,1.211800e-06,5.733600e-06,8.078000e-06, &
     &9.617000e-06,8.415100e-06,1.144200e-06,1.343100e-06,6.060400e-06, &
     &8.580100e-06,1.024700e-05,9.070900e-06,1.256800e-06,1.442100e-06, &
     &6.382900e-06,9.038000e-06,1.075200e-05,9.623200e-06,1.338900e-06, &
     &1.523900e-06,6.704800e-06,9.456000e-06,1.117200e-05,1.004900e-05, &
     &6.644200e-07,8.337900e-07,4.332400e-06,6.019800e-06,7.062900e-06, &
     &6.004900e-06,7.895000e-07,9.595200e-07,4.627300e-06,6.504700e-06, &
     &7.721900e-06,6.668200e-06,9.071700e-07,1.073800e-06,4.900800e-06, &
     &6.932900e-06,8.280600e-06,7.228500e-06,1.008400e-06,1.162900e-06, &
     &5.171000e-06,7.326600e-06,8.730800e-06,7.699300e-06,1.081300e-06, &
     &1.233200e-06,5.441400e-06,7.687600e-06,9.101800e-06,8.075100e-06, &
     &5.131700e-07,6.495100e-07,3.479300e-06,4.812100e-06,5.619500e-06, &
     &4.703100e-06,6.173500e-07,7.575800e-07,3.730400e-06,5.229300e-06, &
     &6.186300e-06,5.274100e-06,7.169800e-07,8.554300e-07,3.960900e-06, &
     &5.596900e-06,6.679700e-06,5.751300e-06,8.060800e-07,9.360800e-07, &
     &4.186700e-06,5.932600e-06,7.078000e-06,6.153500e-06,8.722000e-07, &
     &9.972200e-07,4.412300e-06,6.244200e-06,7.406300e-06,6.483900e-06, &
     &3.948000e-07,5.043500e-07,2.793500e-06,3.843200e-06,4.465700e-06, &
     &3.676400e-06,4.821900e-07,5.977200e-07,3.007300e-06,4.202500e-06, &
     &4.951800e-06,4.162500e-06,5.660600e-07,6.807000e-07,3.201500e-06, &
     &4.517400e-06,5.383200e-06,4.568100e-06,6.428200e-07,7.525500e-07, &
     &3.389600e-06,4.802400e-06,5.733800e-06,4.908100e-06,7.031100e-07, &
     &8.064500e-07,3.578200e-06,5.069800e-06,6.023400e-06,5.189000e-06, &
     &3.153900e-07,4.048000e-07,2.273800e-06,3.121100e-06,3.618200e-06, &
     &2.920400e-06,3.882200e-07,4.832400e-07,2.452900e-06,3.423200e-06, &
     &4.026900e-06,3.311700e-06,4.580300e-07,5.525100e-07,2.614200e-06, &
     &3.687300e-06,4.390900e-06,3.639700e-06,5.220900e-07,6.131300e-07, &
     &2.770900e-06,3.926700e-06,4.688500e-06,3.910000e-06,5.735600e-07, &
     &6.588400e-07,2.928800e-06,4.151600e-06,4.935000e-06,4.128000e-06/
      data  absb(1:360,3) /                                             &
     &7.640900e-03,7.863000e-03,3.509900e-02,5.148900e-02,6.347800e-02, &
     &6.704500e-02,7.619400e-03,7.843900e-03,3.632000e-02,5.359000e-02, &
     &6.575500e-02,7.086100e-02,7.622100e-03,7.847800e-03,3.740800e-02, &
     &5.538800e-02,6.778900e-02,7.414000e-02,7.724500e-03,7.951600e-03, &
     &3.834600e-02,5.682200e-02,6.956600e-02,7.716600e-02,7.897800e-03, &
     &8.125500e-03,3.919100e-02,5.791600e-02,7.102900e-02,7.976600e-02, &
     &6.345800e-03,6.574300e-03,3.054400e-02,4.493700e-02,5.515000e-02, &
     &5.719700e-02,6.329300e-03,6.560500e-03,3.159100e-02,4.670600e-02, &
     &5.714200e-02,6.015500e-02,6.358700e-03,6.594500e-03,3.249600e-02, &
     &4.818500e-02,5.890900e-02,6.270600e-02,6.468600e-03,6.709200e-03, &
     &3.331300e-02,4.936200e-02,6.043100e-02,6.490800e-02,6.625500e-03, &
     &6.864000e-03,3.402400e-02,5.021800e-02,6.152800e-02,6.651600e-02, &
     &5.260800e-03,5.495500e-03,2.638400e-02,3.886900e-02,4.760200e-02, &
     &4.863500e-02,5.254800e-03,5.495600e-03,2.724900e-02,4.034500e-02, &
     &4.931000e-02,5.094500e-02,5.299300e-03,5.550000e-03,2.801900e-02, &
     &4.155100e-02,5.081400e-02,5.282300e-02,5.406600e-03,5.660800e-03, &
     &2.870800e-02,4.245200e-02,5.192600e-02,5.415400e-02,5.552100e-03, &
     &5.801700e-03,2.928200e-02,4.300700e-02,5.252600e-02,5.494300e-02, &
     &4.354800e-03,4.588000e-03,2.261000e-02,3.337500e-02,4.079000e-02, &
     &4.126000e-02,4.361900e-03,4.606800e-03,2.334800e-02,3.457700e-02, &
     &4.224100e-02,4.300900e-02,4.413600e-03,4.670500e-03,2.398400e-02, &
     &3.550400e-02,4.335300e-02,4.422400e-02,4.517800e-03,4.776600e-03, &
     &2.452800e-02,3.607200e-02,4.401000e-02,4.497500e-02,4.650400e-03, &
     &4.907100e-03,2.494200e-02,3.636300e-02,4.428200e-02,4.537900e-02, &
     &3.604600e-03,3.829100e-03,1.925700e-02,2.845100e-02,3.471100e-02, &
     &3.475600e-02,3.621300e-03,3.859200e-03,1.986200e-02,2.937400e-02, &
     &3.581900e-02,3.595700e-02,3.677100e-03,3.929100e-03,2.036300e-02, &
     &2.999400e-02,3.652600e-02,3.669900e-02,3.771400e-03,4.028300e-03, &
     &2.075900e-02,3.032600e-02,3.691000e-02,3.715200e-02,3.889900e-03, &
     &4.146600e-03,2.106500e-02,3.050500e-02,3.703500e-02,3.734700e-02, &
     &2.988500e-03,3.199800e-03,1.629600e-02,2.406100e-02,2.931000e-02, &
     &2.902100e-02,3.009200e-03,3.235700e-03,1.676700e-02,2.471100e-02, &
     &3.006900e-02,2.981800e-02,3.060100e-03,3.301900e-03,1.713700e-02, &
     &2.510700e-02,3.052700e-02,3.031400e-02,3.143300e-03,3.390400e-03, &
     &1.744500e-02,2.534000e-02,3.077200e-02,3.059500e-02,3.249100e-03, &
     &3.497500e-03,1.766300e-02,2.546100e-02,3.082200e-02,3.067700e-02, &
     &2.479200e-03,2.678600e-03,1.369100e-02,2.018000e-02,2.454400e-02, &
     &2.404000e-02,2.498200e-03,2.713400e-03,1.404900e-02,2.062900e-02, &
     &2.506900e-02,2.459700e-02,2.545200e-03,2.774600e-03,1.434400e-02, &
     &2.092100e-02,2.539000e-02,2.493500e-02,2.619600e-03,2.853000e-03, &
     &1.457900e-02,2.109700e-02,2.555500e-02,2.510700e-02,2.716200e-03, &
     &2.953000e-03,1.473200e-02,2.118600e-02,2.557200e-02,2.511800e-02, &
     &2.052800e-03,2.239500e-03,1.144000e-02,1.682200e-02,2.043700e-02, &
     &1.985400e-02,2.071100e-03,2.273600e-03,1.172300e-02,1.715800e-02, &
     &2.081700e-02,2.025400e-02,2.115100e-03,2.329300e-03,1.195700e-02, &
     &1.738000e-02,2.105000e-02,2.049200e-02,2.183300e-03,2.401500e-03, &
     &1.212900e-02,1.752200e-02,2.116800e-02,2.059700e-02,2.272400e-03, &
     &2.494900e-03,1.224900e-02,1.757800e-02,2.116600e-02,2.057100e-02, &
     &1.696500e-03,1.866600e-03,9.520000e-03,1.396500e-02,1.695200e-02, &
     &1.635700e-02,1.715200e-03,1.900200e-03,9.751700e-03,1.422700e-02, &
     &1.723600e-02,1.665000e-02,1.756700e-03,1.951000e-03,9.928300e-03, &
     &1.440800e-02,1.741900e-02,1.682100e-02,1.818200e-03,2.017900e-03, &
     &1.006100e-02,1.451200e-02,1.750200e-02,1.688300e-02,1.900200e-03, &
     &2.104900e-03,1.016000e-02,1.454700e-02,1.749300e-02,1.683800e-02, &
     &1.401200e-03,1.554300e-03,7.918700e-03,1.158200e-02,1.404400e-02, &
     &1.347500e-02,1.421700e-03,1.587800e-03,8.097500e-03,1.178900e-02, &
     &1.426000e-02,1.368600e-02,1.462500e-03,1.635600e-03,8.234200e-03, &
     &1.192800e-02,1.439900e-02,1.380200e-02,1.518900e-03,1.698200e-03, &
     &8.336300e-03,1.199600e-02,1.445500e-02,1.383000e-02,1.592900e-03, &
     &1.778500e-03,8.413100e-03,1.201500e-02,1.443000e-02,1.377200e-02, &
     &1.157000e-03,1.292900e-03,6.574400e-03,9.592900e-03,1.161500e-02, &
     &1.108600e-02,1.179000e-03,1.325700e-03,6.709800e-03,9.754400e-03, &
     &1.178200e-02,1.123700e-02,1.217500e-03,1.370400e-03,6.814100e-03, &
     &9.851500e-03,1.188900e-02,1.131500e-02,1.268600e-03,1.428200e-03, &
     &6.893400e-03,9.900200e-03,1.192000e-02,1.131800e-02,1.334000e-03, &
     &1.500100e-03,6.957700e-03,9.910800e-03,1.188600e-02,1.125400e-02, &
     &9.557400e-04,1.075300e-03,5.447600e-03,7.937600e-03,9.595900e-03, &
     &9.110000e-03,9.783400e-04,1.107000e-03,5.550600e-03,8.055700e-03, &
     &9.727600e-03,9.217600e-03,1.014000e-03,1.148500e-03,5.632300e-03, &
     &8.128100e-03,9.802800e-03,9.263500e-03,1.059400e-03,1.200500e-03, &
     &5.696600e-03,8.161200e-03,9.814500e-03,9.250500e-03,1.117200e-03, &
     &1.264400e-03,5.752300e-03,8.164300e-03,9.779400e-03,9.186500e-03/
      data  absb(361:720,3) /                                           &
     &7.903100e-04,8.949800e-04,4.509300e-03,6.559700e-03,7.922600e-03, &
     &7.481400e-03,8.126300e-04,9.245900e-04,4.588000e-03,6.646700e-03, &
     &8.024700e-03,7.557200e-03,8.447900e-04,9.625700e-04,4.652700e-03, &
     &6.697700e-03,8.072500e-03,7.581300e-03,8.854500e-04,1.009300e-03, &
     &4.708800e-03,6.718600e-03,8.072500e-03,7.558200e-03,9.363900e-04, &
     &1.065800e-03,4.758000e-03,6.721000e-03,8.036800e-03,7.494000e-03, &
     &6.544000e-04,7.455500e-04,3.728700e-03,5.415600e-03,6.539700e-03, &
     &6.143500e-03,6.758800e-04,7.729200e-04,3.791700e-03,5.478600e-03, &
     &6.611900e-03,6.192700e-03,7.045000e-04,8.070600e-04,3.845200e-03, &
     &5.513700e-03,6.641500e-03,6.201800e-03,7.413900e-04,8.491600e-04, &
     &3.895900e-03,5.529600e-03,6.634700e-03,6.172900e-03,7.867800e-04, &
     &8.996400e-04,3.939800e-03,5.533900e-03,6.600700e-03,6.113000e-03, &
     &5.426100e-04,6.213800e-04,3.081200e-03,4.467300e-03,5.393000e-03, &
     &5.043200e-03,5.624400e-04,6.462300e-04,3.132600e-03,4.513000e-03, &
     &5.444100e-03,5.074600e-03,5.879300e-04,6.766500e-04,3.179900e-03, &
     &4.538600e-03,5.459800e-03,5.073500e-03,6.213900e-04,7.145600e-04, &
     &3.224600e-03,4.553000e-03,5.448800e-03,5.044000e-03,6.618900e-04, &
     &7.592800e-04,3.262200e-03,4.558300e-03,5.419200e-03,4.988700e-03, &
     &4.504100e-04,5.180200e-04,2.545900e-03,3.682600e-03,4.443200e-03, &
     &4.138600e-03,4.681800e-04,5.402500e-04,2.590100e-03,3.716600e-03, &
     &4.477600e-03,4.157600e-03,4.912200e-04,5.673100e-04,2.631700e-03, &
     &3.737800e-03,4.484800e-03,4.151100e-03,5.216500e-04,6.015300e-04, &
     &2.670100e-03,3.751700e-03,4.473300e-03,4.121400e-03,5.574700e-04, &
     &6.405100e-04,2.700700e-03,3.758700e-03,4.449800e-03,4.072200e-03, &
     &3.741300e-04,4.319600e-04,2.104400e-03,3.034300e-03,3.658500e-03, &
     &3.398100e-03,3.901700e-04,4.516600e-04,2.142400e-03,3.061200e-03, &
     &3.681000e-03,3.409500e-03,4.115700e-04,4.762500e-04,2.179200e-03, &
     &3.080600e-03,3.683700e-03,3.400200e-03,4.386500e-04,5.066300e-04, &
     &2.209000e-03,3.093800e-03,3.674400e-03,3.373500e-03,4.701200e-04, &
     &5.403900e-04,2.235400e-03,3.100500e-03,3.655100e-03,3.329700e-03, &
     &3.110300e-04,3.602400e-04,1.740600e-03,2.500500e-03,3.011000e-03, &
     &2.791100e-03,3.257700e-04,3.778500e-04,1.773700e-03,2.523600e-03, &
     &3.025500e-03,2.797200e-03,3.453800e-04,4.001700e-04,1.803600e-03, &
     &2.540600e-03,3.026900e-03,2.787000e-03,3.693500e-04,4.267300e-04, &
     &1.828600e-03,2.552900e-03,3.018600e-03,2.761500e-03,3.967600e-04, &
     &4.560800e-04,1.851300e-03,2.558400e-03,3.004000e-03,2.724200e-03, &
     &2.590000e-04,3.006600e-04,1.440600e-03,2.061800e-03,2.477300e-03, &
     &2.294800e-03,2.726100e-04,3.165500e-04,1.468400e-03,2.081000e-03, &
     &2.487300e-03,2.297800e-03,2.903700e-04,3.366900e-04,1.492800e-03, &
     &2.096600e-03,2.488100e-03,2.287800e-03,3.115400e-04,3.597900e-04, &
     &1.513800e-03,2.106400e-03,2.482300e-03,2.265400e-03,3.350700e-04, &
     &3.850900e-04,1.534200e-03,2.111600e-03,2.470900e-03,2.233800e-03, &
     &2.161400e-04,2.512600e-04,1.193000e-03,1.700700e-03,2.038100e-03, &
     &1.887800e-03,2.286100e-04,2.657100e-04,1.216200e-03,1.718000e-03, &
     &2.046000e-03,1.889000e-03,2.445700e-04,2.836500e-04,1.236300e-03, &
     &1.730700e-03,2.047000e-03,1.879000e-03,2.629700e-04,3.036400e-04, &
     &1.254300e-03,1.738500e-03,2.043000e-03,1.859400e-03,2.832000e-04, &
     &3.252700e-04,1.272600e-03,1.743900e-03,2.033400e-03,1.832800e-03, &
     &1.807700e-04,2.103900e-04,9.884000e-04,1.404300e-03,1.677700e-03, &
     &1.554300e-03,1.922000e-04,2.235000e-04,1.007400e-03,1.418700e-03, &
     &1.683800e-03,1.553800e-03,2.062600e-04,2.391800e-04,1.024400e-03, &
     &1.428900e-03,1.685200e-03,1.544300e-03,2.221500e-04,2.563900e-04, &
     &1.040300e-03,1.435600e-03,1.681800e-03,1.527700e-03,2.395800e-04, &
     &2.749400e-04,1.056500e-03,1.441000e-03,1.674100e-03,1.505400e-03, &
     &1.511900e-04,1.760900e-04,8.185500e-04,1.159600e-03,1.381200e-03, &
     &1.279100e-03,1.614500e-04,1.878500e-04,8.342500e-04,1.171200e-03, &
     &1.386600e-03,1.277300e-03,1.736700e-04,2.013300e-04,8.488300e-04, &
     &1.179900e-03,1.388200e-03,1.269100e-03,1.873400e-04,2.160900e-04, &
     &8.630700e-04,1.186300e-03,1.385500e-03,1.255000e-03,2.022500e-04, &
     &2.320200e-04,8.775200e-04,1.192000e-03,1.379500e-03,1.236300e-03, &
     &1.258600e-04,1.467100e-04,6.765800e-04,9.564900e-04,1.137000e-03, &
     &1.052300e-03,1.347900e-04,1.569400e-04,6.901600e-04,9.665800e-04, &
     &1.142300e-03,1.050900e-03,1.452700e-04,1.684000e-04,7.025100e-04, &
     &9.740700e-04,1.143500e-03,1.044100e-03,1.569100e-04,1.809800e-04, &
     &7.153300e-04,9.805800e-04,1.141800e-03,1.032600e-03,1.695700e-04, &
     &1.945900e-04,7.279900e-04,9.863600e-04,1.137800e-03,1.017100e-03, &
     &1.041400e-04,1.215100e-04,5.580100e-04,7.882700e-04,9.359900e-04, &
     &8.655900e-04,1.117000e-04,1.301600e-04,5.697600e-04,7.972400e-04, &
     &9.408500e-04,8.649800e-04,1.205600e-04,1.398600e-04,5.809100e-04, &
     &8.044800e-04,9.427300e-04,8.599700e-04,1.303800e-04,1.504700e-04, &
     &5.920300e-04,8.104000e-04,9.417900e-04,8.508400e-04,1.410400e-04, &
     &1.619900e-04,6.030800e-04,8.160500e-04,9.393300e-04,8.381800e-04/
      data  absb(721:1080,3) /                                          &
     &8.532300e-05,9.966400e-05,4.588400e-04,6.485200e-04,7.697400e-04, &
     &7.114100e-04,9.152700e-05,1.068200e-04,4.690900e-04,6.566900e-04, &
     &7.746700e-04,7.119400e-04,9.887100e-05,1.148700e-04,4.788600e-04, &
     &6.634500e-04,7.769500e-04,7.084900e-04,1.070400e-04,1.237400e-04, &
     &4.888300e-04,6.693000e-04,7.773700e-04,7.016800e-04,1.159700e-04, &
     &1.333900e-04,4.984100e-04,6.748100e-04,7.762400e-04,6.918200e-04, &
     &6.986400e-05,8.170200e-05,3.772000e-04,5.335600e-04,6.330900e-04, &
     &5.849800e-04,7.494900e-05,8.760500e-05,3.861200e-04,5.408500e-04, &
     &6.377400e-04,5.861500e-04,8.103200e-05,9.429000e-05,3.946900e-04, &
     &5.471000e-04,6.404600e-04,5.842400e-04,8.783000e-05,1.016900e-04, &
     &4.033700e-04,5.526100e-04,6.415500e-04,5.791300e-04,9.529300e-05, &
     &1.097800e-04,4.117700e-04,5.578800e-04,6.415400e-04,5.716600e-04, &
     &5.719700e-05,6.697300e-05,3.100500e-04,4.387400e-04,5.205600e-04, &
     &4.813100e-04,6.137100e-05,7.184200e-05,3.177900e-04,4.453100e-04, &
     &5.250200e-04,4.829800e-04,6.640700e-05,7.739400e-05,3.254000e-04, &
     &4.511500e-04,5.279900e-04,4.821500e-04,7.206400e-05,8.356000e-05, &
     &3.330100e-04,4.563200e-04,5.296100e-04,4.785800e-04,7.830300e-05, &
     &9.035500e-05,3.403500e-04,4.613400e-04,5.303100e-04,4.730800e-04, &
     &4.652200e-05,5.452200e-05,2.542100e-04,3.602700e-04,4.276700e-04, &
     &3.947300e-04,4.986300e-05,5.847100e-05,2.609200e-04,3.661200e-04, &
     &4.319700e-04,3.968100e-04,5.396800e-05,6.302700e-05,2.675700e-04, &
     &3.715200e-04,4.351300e-04,3.968300e-04,5.862300e-05,6.812600e-05, &
     &2.742600e-04,3.763600e-04,4.371100e-04,3.945200e-04,6.378900e-05, &
     &7.376600e-05,2.807000e-04,3.810600e-04,4.383100e-04,3.905300e-04, &
     &3.780400e-05,4.433300e-05,2.082100e-04,2.954900e-04,3.510300e-04, &
     &3.234100e-04,4.049200e-05,4.755000e-05,2.140800e-04,3.008900e-04, &
     &3.553200e-04,3.258700e-04,4.379500e-05,5.126500e-05,2.198700e-04, &
     &3.057700e-04,3.584300e-04,3.263800e-04,4.761900e-05,5.546200e-05, &
     &2.257500e-04,3.102300e-04,3.606600e-04,3.250600e-04,5.189800e-05, &
     &6.015400e-05,2.313800e-04,3.146300e-04,3.621900e-04,3.222500e-04, &
     &3.072500e-05,3.604300e-05,1.704800e-04,2.422800e-04,2.880200e-04, &
     &2.649700e-04,3.288100e-05,3.866300e-05,1.755900e-04,2.471600e-04, &
     &2.921000e-04,2.674800e-04,3.552700e-05,4.168100e-05,1.806200e-04, &
     &2.515200e-04,2.951100e-04,2.684100e-04,3.866400e-05,4.513400e-05, &
     &1.857700e-04,2.556400e-04,2.974700e-04,2.678600e-04,4.219500e-05, &
     &4.902100e-05,1.906800e-04,2.597000e-04,2.991900e-04,2.659900e-04, &
     &2.489100e-05,2.918700e-05,1.392800e-04,1.983100e-04,2.359200e-04, &
     &2.167500e-04,2.659300e-05,3.130100e-05,1.437400e-04,2.027200e-04, &
     &2.398300e-04,2.194200e-04,2.869000e-05,3.374700e-05,1.481000e-04, &
     &2.066800e-04,2.428500e-04,2.207100e-04,3.123200e-05,3.654700e-05, &
     &1.525600e-04,2.103800e-04,2.451500e-04,2.207100e-04,3.412000e-05, &
     &3.974300e-05,1.568300e-04,2.140700e-04,2.469600e-04,2.195800e-04, &
     &2.014400e-05,2.360500e-05,1.136600e-04,1.621700e-04,1.930400e-04, &
     &1.772000e-04,2.146800e-05,2.528800e-05,1.174600e-04,1.660100e-04, &
     &1.966400e-04,1.797800e-04,2.311700e-05,2.725500e-05,1.212700e-04, &
     &1.696200e-04,1.995500e-04,1.813300e-04,2.516700e-05,2.952500e-05, &
     &1.251500e-04,1.729800e-04,2.018800e-04,1.818200e-04,2.750900e-05, &
     &3.213300e-05,1.289000e-04,1.763100e-04,2.037300e-04,1.812800e-04, &
     &1.631500e-05,1.909900e-05,9.265800e-05,1.324700e-04,1.577700e-04, &
     &1.448100e-04,1.734100e-05,2.042700e-05,9.596000e-05,1.359600e-04, &
     &1.612200e-04,1.473800e-04,1.864700e-05,2.202200e-05,9.923800e-05, &
     &1.391200e-04,1.638800e-04,1.490100e-04,2.026200e-05,2.384000e-05, &
     &1.026000e-04,1.421100e-04,1.661000e-04,1.498000e-04,2.216700e-05, &
     &2.596900e-05,1.058800e-04,1.451200e-04,1.679600e-04,1.497600e-04, &
     &1.321100e-05,1.544600e-05,7.542700e-05,1.080600e-04,1.287600e-04, &
     &1.182100e-04,1.399000e-05,1.647000e-05,7.824800e-05,1.111300e-04, &
     &1.319300e-04,1.206400e-04,1.501300e-05,1.775300e-05,8.110200e-05, &
     &1.139700e-04,1.344400e-04,1.223400e-04,1.627700e-05,1.921000e-05, &
     &8.398000e-05,1.166300e-04,1.365200e-04,1.233800e-04,1.781600e-05, &
     &2.093200e-05,8.685600e-05,1.193100e-04,1.383300e-04,1.237100e-04, &
     &1.069500e-05,1.247600e-05,6.124500e-05,8.792100e-05,1.048100e-04, &
     &9.623600e-05,1.126300e-05,1.324300e-05,6.364800e-05,9.065600e-05, &
     &1.077200e-04,9.851900e-05,1.204800e-05,1.425900e-05,6.611500e-05, &
     &9.316800e-05,1.100900e-04,1.002300e-04,1.303200e-05,1.542700e-05, &
     &6.859800e-05,9.556800e-05,1.120600e-04,1.014200e-04,1.425400e-05, &
     &1.679500e-05,7.109600e-05,9.793400e-05,1.137900e-04,1.019900e-04, &
     &8.684100e-06,1.009600e-05,4.969400e-05,7.145200e-05,8.525900e-05, &
     &7.830700e-05,9.079600e-06,1.065900e-05,5.174000e-05,7.390000e-05, &
     &8.787500e-05,8.045100e-05,9.676900e-06,1.145000e-05,5.383100e-05, &
     &7.609500e-05,9.006700e-05,8.211700e-05,1.044000e-05,1.238500e-05, &
     &5.596000e-05,7.822100e-05,9.189100e-05,8.337900e-05,1.139900e-05, &
     &1.346800e-05,5.811500e-05,8.030100e-05,9.349400e-05,8.413200e-05/
      data  absb(1081:1410,3) /                                         &
     &7.069500e-06,8.188300e-06,4.027000e-05,5.798100e-05,6.925900e-05, &
     &6.368100e-05,7.332200e-06,8.589700e-06,4.201400e-05,6.015600e-05, &
     &7.156900e-05,6.571400e-05,7.777900e-06,9.193200e-06,4.377800e-05, &
     &6.207500e-05,7.358100e-05,6.731100e-05,8.366700e-06,9.939100e-06, &
     &4.560500e-05,6.394500e-05,7.525400e-05,6.860200e-05,9.110000e-06, &
     &1.079700e-05,4.745500e-05,6.578300e-05,7.674100e-05,6.949600e-05, &
     &5.766600e-06,6.661700e-06,3.263400e-05,4.702600e-05,5.623100e-05, &
     &5.164600e-05,5.941300e-06,6.942300e-06,3.412100e-05,4.895100e-05, &
     &5.827500e-05,5.353300e-05,6.268300e-06,7.397200e-06,3.560700e-05, &
     &5.064100e-05,6.009000e-05,5.499900e-05,6.719900e-06,7.987900e-06, &
     &3.716700e-05,5.227500e-05,6.160800e-05,5.623500e-05,7.303400e-06, &
     &8.680800e-06,3.875700e-05,5.388100e-05,6.296800e-05,5.716700e-05, &
     &4.708600e-06,5.429900e-06,2.642400e-05,3.811500e-05,4.561000e-05, &
     &4.179400e-05,4.828700e-06,5.624000e-06,2.769700e-05,3.979900e-05, &
     &4.741200e-05,4.351200e-05,5.060600e-06,5.960400e-06,2.895200e-05, &
     &4.129000e-05,4.903100e-05,4.484900e-05,5.406500e-06,6.426300e-06, &
     &3.028300e-05,4.271700e-05,5.042400e-05,4.599500e-05,5.861500e-06, &
     &6.982000e-06,3.164100e-05,4.412000e-05,5.164700e-05,4.691200e-05, &
     &3.843600e-06,4.427400e-06,2.137300e-05,3.085800e-05,3.695300e-05, &
     &3.378500e-05,3.932800e-06,4.565100e-06,2.246800e-05,3.232000e-05, &
     &3.852700e-05,3.535300e-05,4.091400e-06,4.808500e-06,2.352100e-05, &
     &3.363100e-05,3.996300e-05,3.658500e-05,4.353100e-06,5.170100e-06, &
     &2.464300e-05,3.486100e-05,4.120800e-05,3.763000e-05,4.705000e-06, &
     &5.613100e-06,2.580100e-05,3.608400e-05,4.230800e-05,3.850700e-05, &
     &3.130700e-06,3.609000e-06,1.727100e-05,2.494800e-05,2.990500e-05, &
     &2.729100e-05,3.206200e-06,3.712600e-06,1.820700e-05,2.621000e-05, &
     &3.126300e-05,2.872800e-05,3.314400e-06,3.884400e-06,1.909600e-05, &
     &2.736700e-05,3.254800e-05,2.986900e-05,3.507700e-06,4.159500e-06, &
     &2.003400e-05,2.842700e-05,3.365200e-05,3.082300e-05,3.777200e-06, &
     &4.510100e-06,2.101800e-05,2.948700e-05,3.462900e-05,3.166400e-05, &
     &2.545200e-06,2.941700e-06,1.396500e-05,2.017800e-05,2.420900e-05, &
     &2.191100e-05,2.617300e-06,3.026500e-06,1.476000e-05,2.126600e-05, &
     &2.537700e-05,2.318800e-05,2.694300e-06,3.147500e-06,1.551200e-05, &
     &2.226900e-05,2.649700e-05,2.419300e-05,2.834600e-06,3.354900e-06, &
     &1.629500e-05,2.318300e-05,2.747400e-05,2.501500e-05,3.040800e-06, &
     &3.632400e-06,1.712700e-05,2.410000e-05,2.833900e-05,2.574500e-05, &
     &2.063200e-06,2.394000e-06,1.129600e-05,1.631600e-05,1.958600e-05, &
     &1.751900e-05,2.137300e-06,2.469100e-06,1.196100e-05,1.724200e-05, &
     &2.058300e-05,1.862100e-05,2.194900e-06,2.556100e-06,1.260000e-05, &
     &1.811100e-05,2.155900e-05,1.949900e-05,2.295000e-06,2.710900e-06, &
     &1.325000e-05,1.889900e-05,2.241400e-05,2.019800e-05,2.453000e-06, &
     &2.929100e-06,1.395100e-05,1.968600e-05,2.317700e-05,2.080000e-05, &
     &1.664200e-06,1.942600e-06,9.134100e-06,1.318100e-05,1.582900e-05, &
     &1.399200e-05,1.742900e-06,2.013900e-06,9.685100e-06,1.396300e-05, &
     &1.668100e-05,1.493600e-05,1.789600e-06,2.079500e-06,1.022500e-05, &
     &1.471600e-05,1.751700e-05,1.570200e-05,1.860700e-06,2.192300e-06, &
     &1.076800e-05,1.539700e-05,1.827400e-05,1.630600e-05,1.979900e-06, &
     &2.361700e-06,1.135600e-05,1.607000e-05,1.894800e-05,1.680100e-05, &
     &1.335300e-06,1.573000e-06,7.381100e-06,1.064000e-05,1.277700e-05, &
     &1.115800e-05,1.417900e-06,1.641600e-06,7.834500e-06,1.129600e-05, &
     &1.350600e-05,1.196200e-05,1.459900e-06,1.693900e-06,8.291700e-06, &
     &1.194500e-05,1.422000e-05,1.263300e-05,1.511200e-06,1.774700e-06, &
     &8.745000e-06,1.253100e-05,1.488500e-05,1.315800e-05,1.599300e-06, &
     &1.904700e-06,9.236200e-06,1.310300e-05,1.547100e-05,1.357100e-05, &
     &1.068200e-06,1.270700e-06,5.967300e-06,8.591500e-06,1.031300e-05, &
     &8.887500e-06,1.151000e-06,1.337200e-06,6.338300e-06,9.137100e-06, &
     &1.093200e-05,9.571700e-06,1.191800e-06,1.381300e-06,6.724600e-06, &
     &9.693500e-06,1.153900e-05,1.014900e-05,1.230300e-06,1.439900e-06, &
     &7.103100e-06,1.019800e-05,1.212000e-05,1.060300e-05,1.294300e-06, &
     &1.538700e-06,7.511300e-06,1.068200e-05,1.262900e-05,1.095500e-05, &
     &8.684400e-07,1.037100e-06,4.874900e-06,7.011100e-06,8.411500e-06, &
     &7.146100e-06,9.408300e-07,1.095400e-06,5.183600e-06,7.469100e-06, &
     &8.932800e-06,7.701600e-06,9.774100e-07,1.133100e-06,5.507000e-06, &
     &7.939300e-06,9.448800e-06,8.160700e-06,1.009200e-06,1.180600e-06, &
     &5.824600e-06,8.365100e-06,9.943200e-06,8.524600e-06,1.060200e-06, &
     &1.260800e-06,6.168200e-06,8.777800e-06,1.037600e-05,8.803000e-06/
      data  absb(1:360,4) /                                             &
     &1.194400e-02,1.216800e-02,5.992200e-02,8.936700e-02,1.107400e-01, &
     &1.194400e-01,1.208600e-02,1.230400e-02,6.146000e-02,9.145600e-02, &
     &1.134400e-01,1.241200e-01,1.235700e-02,1.257000e-02,6.288700e-02, &
     &9.335800e-02,1.157000e-01,1.284500e-01,1.272900e-02,1.293700e-02, &
     &6.414700e-02,9.501300e-02,1.176200e-01,1.322600e-01,1.323800e-02, &
     &1.344000e-02,6.515300e-02,9.639200e-02,1.191800e-01,1.357000e-01, &
     &1.001200e-02,1.024700e-02,5.297500e-02,7.894200e-02,9.734600e-02, &
     &1.036800e-01,1.018000e-02,1.041000e-02,5.440900e-02,8.085600e-02, &
     &9.974000e-02,1.075100e-01,1.046700e-02,1.068900e-02,5.569300e-02, &
     &8.257900e-02,1.018800e-01,1.109300e-01,1.085400e-02,1.106700e-02, &
     &5.677500e-02,8.402800e-02,1.036800e-01,1.138900e-01,1.134300e-02, &
     &1.154900e-02,5.771400e-02,8.529200e-02,1.051100e-01,1.165200e-01, &
     &8.377800e-03,8.630900e-03,4.649800e-02,6.916900e-02,8.492600e-02, &
     &8.947900e-02,8.566700e-03,8.810100e-03,4.775700e-02,7.091200e-02, &
     &8.713000e-02,9.262200e-02,8.858800e-03,9.089300e-03,4.886400e-02, &
     &7.237900e-02,8.905400e-02,9.541100e-02,9.239700e-03,9.459900e-03, &
     &4.982900e-02,7.369200e-02,9.068600e-02,9.779400e-02,9.672800e-03, &
     &9.884300e-03,5.071100e-02,7.486800e-02,9.200000e-02,9.967300e-02, &
     &7.003200e-03,7.280000e-03,4.049300e-02,6.008700e-02,7.365400e-02, &
     &7.684700e-02,7.204600e-03,7.465700e-03,4.155900e-02,6.155200e-02, &
     &7.559100e-02,7.952200e-02,7.495100e-03,7.740800e-03,4.252500e-02, &
     &6.287200e-02,7.730300e-02,8.185000e-02,7.837400e-03,8.073100e-03, &
     &4.343100e-02,6.406600e-02,7.869700e-02,8.356400e-02,8.202800e-03, &
     &8.426100e-03,4.425600e-02,6.500500e-02,7.959800e-02,8.443000e-02, &
     &5.851800e-03,6.153100e-03,3.495900e-02,5.174100e-02,6.346600e-02, &
     &6.560500e-02,6.057500e-03,6.341700e-03,3.587400e-02,5.301300e-02, &
     &6.515100e-02,6.782300e-02,6.323200e-03,6.595100e-03,3.676100e-02, &
     &5.416800e-02,6.656000e-02,6.949600e-02,6.622100e-03,6.878200e-03, &
     &3.756700e-02,5.510000e-02,6.747800e-02,7.035800e-02,6.934700e-03, &
     &7.177800e-03,3.825600e-02,5.564100e-02,6.781800e-02,7.053700e-02, &
     &4.888000e-03,5.205500e-03,2.996000e-02,4.425500e-02,5.434200e-02, &
     &5.568400e-02,5.083600e-03,5.388400e-03,3.078000e-02,4.535900e-02, &
     &5.570600e-02,5.729700e-02,5.319400e-03,5.612600e-03,3.154300e-02, &
     &4.623800e-02,5.663200e-02,5.824200e-02,5.579600e-03,5.855800e-03, &
     &3.219000e-02,4.679600e-02,5.706400e-02,5.857900e-02,5.842200e-03, &
     &6.108300e-03,3.270100e-02,4.706600e-02,5.710500e-02,5.848300e-02, &
     &4.083000e-03,4.400300e-03,2.553600e-02,3.763500e-02,4.618800e-02, &
     &4.683000e-02,4.262100e-03,4.573900e-03,2.622500e-02,3.847300e-02, &
     &4.711300e-02,4.782100e-02,4.470100e-03,4.772600e-03,2.682700e-02, &
     &3.902800e-02,4.762700e-02,4.831000e-02,4.683600e-03,4.974200e-03, &
     &2.730600e-02,3.935500e-02,4.780100e-02,4.840800e-02,4.910100e-03, &
     &5.190800e-03,2.767100e-02,3.954700e-02,4.773800e-02,4.819600e-02, &
     &3.418300e-03,3.728100e-03,2.163500e-02,3.176700e-02,3.891000e-02, &
     &3.903500e-02,3.575500e-03,3.884700e-03,2.217200e-02,3.232100e-02, &
     &3.946800e-02,3.963000e-02,3.747000e-03,4.048900e-03,2.262100e-02, &
     &3.267600e-02,3.975500e-02,3.989100e-02,3.925700e-03,4.220300e-03, &
     &2.299700e-02,3.292400e-02,3.982000e-02,3.986800e-02,4.124800e-03, &
     &4.410700e-03,2.323900e-02,3.308600e-02,3.973400e-02,3.962200e-02, &
     &2.860600e-03,3.159600e-03,1.819100e-02,2.660100e-02,3.251500e-02, &
     &3.231700e-02,2.992800e-03,3.293000e-03,1.859800e-02,2.697000e-02, &
     &3.286600e-02,3.269900e-02,3.136900e-03,3.430900e-03,1.896800e-02, &
     &2.724700e-02,3.303500e-02,3.283400e-02,3.291100e-03,3.580700e-03, &
     &1.924200e-02,2.745500e-02,3.306000e-02,3.275400e-02,3.466000e-03, &
     &3.748600e-03,1.940200e-02,2.757700e-02,3.298800e-02,3.250500e-02, &
     &2.395800e-03,2.678600e-03,1.522100e-02,2.216300e-02,2.703900e-02, &
     &2.667500e-02,2.508900e-03,2.792200e-03,1.555500e-02,2.244400e-02, &
     &2.726800e-02,2.691500e-02,2.633000e-03,2.912500e-03,1.584200e-02, &
     &2.267500e-02,2.737200e-02,2.696800e-02,2.769400e-03,3.046400e-03, &
     &1.603000e-02,2.284300e-02,2.739200e-02,2.685600e-02,2.923200e-03, &
     &3.195600e-03,1.614500e-02,2.290600e-02,2.733100e-02,2.661000e-02, &
     &2.004200e-03,2.264000e-03,1.269000e-02,1.840100e-02,2.240400e-02, &
     &2.195900e-02,2.102300e-03,2.361700e-03,1.296500e-02,1.863700e-02, &
     &2.256400e-02,2.210900e-02,2.210300e-03,2.468500e-03,1.317300e-02, &
     &1.883300e-02,2.264500e-02,2.210800e-02,2.330300e-03,2.587100e-03, &
     &1.331200e-02,1.894000e-02,2.266300e-02,2.198500e-02,2.466100e-03, &
     &2.721800e-03,1.339900e-02,1.897200e-02,2.260400e-02,2.176000e-02, &
     &1.676200e-03,1.909000e-03,1.055900e-02,1.525200e-02,1.852100e-02, &
     &1.804200e-02,1.761400e-03,1.993200e-03,1.077000e-02,1.545500e-02, &
     &1.864700e-02,1.812800e-02,1.856400e-03,2.089000e-03,1.092700e-02, &
     &1.559800e-02,1.871600e-02,1.809700e-02,1.961800e-03,2.195100e-03, &
     &1.102900e-02,1.566900e-02,1.872800e-02,1.797100e-02,2.078800e-03, &
     &2.313900e-03,1.109400e-02,1.568500e-02,1.865600e-02,1.776500e-02/
      data  absb(361:720,4) /                                           &
     &1.402500e-03,1.606700e-03,8.767600e-03,1.263200e-02,1.529500e-02, &
     &1.480800e-02,1.476700e-03,1.681000e-03,8.928500e-03,1.279200e-02, &
     &1.539800e-02,1.484900e-02,1.560000e-03,1.766400e-03,9.045100e-03, &
     &1.289300e-02,1.545800e-02,1.480300e-02,1.651800e-03,1.861300e-03, &
     &9.121800e-03,1.294500e-02,1.544900e-02,1.468200e-02,1.750300e-03, &
     &1.962200e-03,9.178800e-03,1.295400e-02,1.537800e-02,1.449600e-02, &
     &1.174300e-03,1.351500e-03,7.268000e-03,1.045300e-02,1.262400e-02, &
     &1.214300e-02,1.239700e-03,1.418700e-03,7.388400e-03,1.057200e-02, &
     &1.271300e-02,1.215800e-02,1.312100e-03,1.494400e-03,7.476900e-03, &
     &1.064700e-02,1.274800e-02,1.210100e-02,1.390400e-03,1.577400e-03, &
     &7.540100e-03,1.068400e-02,1.272800e-02,1.198600e-02,1.473600e-03, &
     &1.662500e-03,7.592500e-03,1.068300e-02,1.266200e-02,1.182300e-02, &
     &9.840199e-04,1.137300e-03,6.016200e-03,8.639400e-03,1.041900e-02, &
     &9.956100e-03,1.041100e-03,1.197200e-03,6.108600e-03,8.728700e-03, &
     &1.048300e-02,9.951900e-03,1.102900e-03,1.263300e-03,6.178100e-03, &
     &8.782700e-03,1.050100e-02,9.891800e-03,1.169500e-03,1.334400e-03, &
     &6.234100e-03,8.808300e-03,1.047800e-02,9.785700e-03,1.240900e-03, &
     &1.407900e-03,6.282200e-03,8.807900e-03,1.041800e-02,9.645300e-03, &
     &8.250200e-04,9.575100e-04,4.975800e-03,7.133800e-03,8.593800e-03, &
     &8.159900e-03,8.745000e-04,1.010500e-03,5.048600e-03,7.199600e-03, &
     &8.636900e-03,8.144100e-03,9.266400e-04,1.067400e-03,5.107000e-03, &
     &7.239000e-03,8.645700e-03,8.084900e-03,9.842600e-04,1.128700e-03, &
     &5.158700e-03,7.259300e-03,8.621800e-03,7.990700e-03,1.046000e-03, &
     &1.193200e-03,5.206600e-03,7.261200e-03,8.569400e-03,7.870500e-03, &
     &6.923600e-04,8.067400e-04,4.113300e-03,5.886300e-03,7.081500e-03, &
     &6.690000e-03,7.344100e-04,8.527000e-04,4.173500e-03,5.934900e-03, &
     &7.112200e-03,6.668300e-03,7.793000e-04,9.024700e-04,4.225200e-03, &
     &5.966200e-03,7.113600e-03,6.614000e-03,8.290500e-04,9.549000e-04, &
     &4.274600e-03,5.983500e-03,7.089800e-03,6.532800e-03,8.828800e-04, &
     &1.012100e-03,4.316800e-03,5.989800e-03,7.047500e-03,6.430700e-03, &
     &5.810900e-04,6.799200e-04,3.400700e-03,4.854600e-03,5.833800e-03, &
     &5.485700e-03,6.167200e-04,7.195300e-04,3.453100e-03,4.892100e-03, &
     &5.853800e-03,5.462300e-03,6.556400e-04,7.623500e-04,3.500100e-03, &
     &4.920000e-03,5.850800e-03,5.413600e-03,6.991600e-04,8.083700e-04, &
     &3.544500e-03,4.936100e-03,5.831500e-03,5.344800e-03,7.458800e-04, &
     &8.590700e-04,3.581400e-03,4.947000e-03,5.797200e-03,5.257500e-03, &
     &4.877300e-04,5.729800e-04,2.814200e-03,4.003400e-03,4.804600e-03, &
     &4.501800e-03,5.179000e-04,6.068700e-04,2.859200e-03,4.035200e-03, &
     &4.816300e-03,4.478500e-03,5.525900e-04,6.442000e-04,2.902600e-03, &
     &4.059600e-03,4.812800e-03,4.437000e-03,5.902700e-04,6.847300e-04, &
     &2.939600e-03,4.077900e-03,4.797200e-03,4.378900e-03,6.310900e-04, &
     &7.299600e-04,2.973000e-03,4.089200e-03,4.770300e-03,4.306300e-03, &
     &4.094300e-04,4.826000e-04,2.330700e-03,3.302600e-03,3.955300e-03, &
     &3.695100e-03,4.358500e-04,5.119400e-04,2.370600e-03,3.330700e-03, &
     &3.962700e-03,3.675100e-03,4.664400e-04,5.447100e-04,2.407500e-03, &
     &3.354400e-03,3.960800e-03,3.638800e-03,4.991800e-04,5.804500e-04, &
     &2.439500e-03,3.372500e-03,3.948500e-03,3.590000e-03,5.345800e-04, &
     &6.206900e-04,2.471000e-03,3.383900e-03,3.929200e-03,3.529900e-03, &
     &3.441000e-04,4.065400e-04,1.931700e-03,2.726900e-03,3.256000e-03, &
     &3.035700e-03,3.678000e-04,4.323100e-04,1.966900e-03,2.752400e-03, &
     &3.262200e-03,3.017100e-03,3.942200e-04,4.610300e-04,1.997900e-03, &
     &2.774900e-03,3.261700e-03,2.986900e-03,4.227400e-04,4.928900e-04, &
     &2.026800e-03,2.791000e-03,3.253300e-03,2.946100e-03,4.535600e-04, &
     &5.282600e-04,2.055800e-03,2.802600e-03,3.238800e-03,2.897100e-03, &
     &2.890700e-04,3.419700e-04,1.601700e-03,2.252700e-03,2.681600e-03, &
     &2.493400e-03,3.099900e-04,3.645900e-04,1.631400e-03,2.277000e-03, &
     &2.688100e-03,2.477400e-03,3.329200e-04,3.898900e-04,1.658700e-03, &
     &2.296500e-03,2.688200e-03,2.451600e-03,3.575800e-04,4.181700e-04, &
     &1.685100e-03,2.311800e-03,2.683700e-03,2.418300e-03,3.844300e-04, &
     &4.489100e-04,1.711700e-03,2.324100e-03,2.673400e-03,2.378900e-03, &
     &2.416300e-04,2.861300e-04,1.326200e-03,1.861000e-03,2.209200e-03, &
     &2.049200e-03,2.598000e-04,3.059000e-04,1.351800e-03,1.882900e-03, &
     &2.216100e-03,2.036400e-03,2.794800e-04,3.280600e-04,1.376200e-03, &
     &1.900000e-03,2.218600e-03,2.014900e-03,3.006600e-04,3.526800e-04, &
     &1.400400e-03,1.914900e-03,2.216500e-03,1.988900e-03,3.240100e-04, &
     &3.794200e-04,1.425000e-03,1.927800e-03,2.209900e-03,1.957800e-03, &
     &2.006600e-04,2.379700e-04,1.096200e-03,1.536300e-03,1.820200e-03, &
     &1.685100e-03,2.162300e-04,2.549800e-04,1.118800e-03,1.555700e-03, &
     &1.827900e-03,1.674900e-03,2.330300e-04,2.742300e-04,1.140700e-03, &
     &1.571800e-03,1.832500e-03,1.659100e-03,2.510200e-04,2.953400e-04, &
     &1.162600e-03,1.586300e-03,1.832400e-03,1.638200e-03,2.710700e-04, &
     &3.183900e-04,1.185000e-03,1.599000e-03,1.829500e-03,1.613800e-03/
      data  absb(721:1080,4) /                                          &
     &1.648900e-04,1.959800e-04,9.033800e-04,1.266000e-03,1.499200e-03, &
     &1.385800e-03,1.780000e-04,2.103500e-04,9.231900e-04,1.283500e-03, &
     &1.507800e-03,1.378900e-03,1.921300e-04,2.267000e-04,9.428600e-04, &
     &1.298700e-03,1.513800e-03,1.367300e-03,2.073100e-04,2.446700e-04, &
     &9.626000e-04,1.312900e-03,1.515900e-03,1.352000e-03,2.242600e-04, &
     &2.643300e-04,9.831700e-04,1.325500e-03,1.516000e-03,1.333000e-03, &
     &1.354500e-04,1.613300e-04,7.442300e-04,1.043000e-03,1.234500e-03, &
     &1.140000e-03,1.464700e-04,1.734600e-04,7.617600e-04,1.059000e-03, &
     &1.244000e-03,1.135700e-03,1.583400e-04,1.873100e-04,7.793300e-04, &
     &1.073100e-03,1.250500e-03,1.127500e-03,1.711200e-04,2.025400e-04, &
     &7.970900e-04,1.086600e-03,1.254200e-03,1.116300e-03,1.854300e-04, &
     &2.193200e-04,8.156700e-04,1.098900e-03,1.256200e-03,1.101400e-03, &
     &1.112800e-04,1.327900e-04,6.130800e-04,8.596000e-04,1.017100e-03, &
     &9.383100e-04,1.205400e-04,1.430500e-04,6.283800e-04,8.739400e-04, &
     &1.026400e-03,9.363500e-04,1.305100e-04,1.548000e-04,6.440800e-04, &
     &8.868800e-04,1.033200e-03,9.307800e-04,1.412600e-04,1.677400e-04, &
     &6.599400e-04,8.994600e-04,1.037800e-03,9.226800e-04,1.533800e-04, &
     &1.820900e-04,6.767800e-04,9.112300e-04,1.041300e-03,9.113700e-04, &
     &9.070500e-05,1.085200e-04,5.035500e-04,7.068100e-04,8.368400e-04, &
     &7.709100e-04,9.834800e-05,1.170600e-04,5.169700e-04,7.200900e-04, &
     &8.460100e-04,7.700400e-04,1.067100e-04,1.268900e-04,5.308600e-04, &
     &7.319100e-04,8.529800e-04,7.666600e-04,1.157000e-04,1.378100e-04, &
     &5.450700e-04,7.435500e-04,8.583100e-04,7.609300e-04,1.257800e-04, &
     &1.499000e-04,5.600200e-04,7.547300e-04,8.628400e-04,7.524500e-04, &
     &7.381700e-05,8.854900e-05,4.132500e-04,5.810600e-04,6.883000e-04, &
     &6.326900e-04,8.015800e-05,9.568000e-05,4.250100e-04,5.929300e-04, &
     &6.970000e-04,6.331000e-04,8.711600e-05,1.038400e-04,4.372200e-04, &
     &6.036900e-04,7.040100e-04,6.312200e-04,9.461000e-05,1.130300e-04, &
     &4.497600e-04,6.144800e-04,7.097700e-04,6.272600e-04,1.030500e-04, &
     &1.232400e-04,4.631100e-04,6.247500e-04,7.147700e-04,6.210100e-04, &
     &6.004700e-05,7.221000e-05,3.390000e-04,4.774900e-04,5.659600e-04, &
     &5.192600e-04,6.530700e-05,7.818300e-05,3.492700e-04,4.880000e-04, &
     &5.740400e-04,5.204900e-04,7.108300e-05,8.494800e-05,3.599100e-04, &
     &4.977600e-04,5.809200e-04,5.196800e-04,7.733900e-05,9.266800e-05, &
     &3.709800e-04,5.075900e-04,5.867600e-04,5.171700e-04,8.439100e-05, &
     &1.012800e-04,3.828400e-04,5.171000e-04,5.920000e-04,5.126500e-04, &
     &4.861100e-05,5.860100e-05,2.774900e-04,3.914500e-04,4.646400e-04, &
     &4.258400e-04,5.292500e-05,6.356200e-05,2.863700e-04,4.009400e-04, &
     &4.722600e-04,4.277300e-04,5.770400e-05,6.914300e-05,2.956500e-04, &
     &4.097600e-04,4.788200e-04,4.278400e-04,6.289000e-05,7.555500e-05, &
     &3.053100e-04,4.186100e-04,4.845400e-04,4.263200e-04,6.873300e-05, &
     &8.275400e-05,3.157400e-04,4.272900e-04,4.898500e-04,4.232400e-04, &
     &3.925500e-05,4.742800e-05,2.268200e-04,3.205300e-04,3.811500e-04, &
     &3.490400e-04,4.275600e-05,5.151800e-05,2.344600e-04,3.290000e-04, &
     &3.881800e-04,3.512600e-04,4.670200e-05,5.611800e-05,2.425400e-04, &
     &3.369600e-04,3.944500e-04,3.520400e-04,5.098800e-05,6.141400e-05, &
     &2.509300e-04,3.448300e-04,3.998400e-04,3.515000e-04,5.581800e-05, &
     &6.741300e-05,2.600400e-04,3.527100e-04,4.050800e-04,3.495500e-04, &
     &3.167700e-05,3.836000e-05,1.852300e-04,2.622200e-04,3.123800e-04, &
     &2.859200e-04,3.452200e-05,4.173100e-05,1.919200e-04,2.697100e-04, &
     &3.188300e-04,2.886000e-04,3.777500e-05,4.552300e-05,1.988200e-04, &
     &2.768000e-04,3.246900e-04,2.897900e-04,4.130600e-05,4.987200e-05, &
     &2.060800e-04,2.838400e-04,3.298400e-04,2.898400e-04,4.529200e-05, &
     &5.486400e-05,2.139500e-04,2.908800e-04,3.347300e-04,2.887600e-04, &
     &2.550100e-05,3.094900e-05,1.510600e-04,2.142200e-04,2.557000e-04, &
     &2.339600e-04,2.779500e-05,3.369800e-05,1.568100e-04,2.208300e-04, &
     &2.615300e-04,2.368300e-04,3.047300e-05,3.683000e-05,1.627100e-04, &
     &2.270400e-04,2.669500e-04,2.384200e-04,3.337600e-05,4.038500e-05, &
     &1.689900e-04,2.333200e-04,2.717800e-04,2.389400e-04,3.663700e-05, &
     &4.450700e-05,1.758500e-04,2.396200e-04,2.763800e-04,2.385500e-04, &
     &2.045000e-05,2.487100e-05,1.228500e-04,1.745800e-04,2.088300e-04, &
     &1.909700e-04,2.228600e-05,2.708600e-05,1.278400e-04,1.804200e-04, &
     &2.140400e-04,1.939500e-04,2.445400e-05,2.964900e-05,1.328600e-04, &
     &1.859100e-04,2.191000e-04,1.958100e-04,2.684400e-05,3.254500e-05, &
     &1.382500e-04,1.914300e-04,2.235800e-04,1.967300e-04,2.948400e-05, &
     &3.591800e-05,1.441100e-04,1.970000e-04,2.278100e-04,1.968400e-04, &
     &1.639500e-05,1.998700e-05,9.978700e-05,1.421400e-04,1.703200e-04, &
     &1.558200e-04,1.786000e-05,2.175300e-05,1.041300e-04,1.472500e-04, &
     &1.749900e-04,1.588400e-04,1.960000e-05,2.383400e-05,1.083900e-04, &
     &1.520700e-04,1.795700e-04,1.608300e-04,2.156700e-05,2.620800e-05, &
     &1.129900e-04,1.569000e-04,1.837000e-04,1.619900e-04,2.370400e-05, &
     &2.894600e-05,1.179700e-04,1.617800e-04,1.875300e-04,1.624600e-04/
      data  absb(1081:1410,4) /                                         &
     &1.313900e-05,1.606200e-05,8.097600e-05,1.156200e-04,1.387600e-04, &
     &1.271400e-04,1.430400e-05,1.745500e-05,8.471000e-05,1.200400e-04, &
     &1.428800e-04,1.300300e-04,1.569000e-05,1.913600e-05,8.834800e-05, &
     &1.242700e-04,1.470000e-04,1.321300e-04,1.730400e-05,2.108000e-05, &
     &9.222200e-05,1.284400e-04,1.507200e-04,1.334900e-04,1.904500e-05, &
     &2.329600e-05,9.647300e-05,1.327200e-04,1.542000e-04,1.342400e-04, &
     &1.055500e-05,1.293700e-05,6.569500e-05,9.404300e-05,1.130200e-04, &
     &1.034500e-04,1.147700e-05,1.403100e-05,6.889300e-05,9.781000e-05, &
     &1.165900e-04,1.061800e-04,1.258100e-05,1.538500e-05,7.202200e-05, &
     &1.015200e-04,1.202300e-04,1.082500e-04,1.390000e-05,1.697900e-05, &
     &7.529800e-05,1.051300e-04,1.236200e-04,1.096500e-04,1.533300e-05, &
     &1.878300e-05,7.891800e-05,1.088800e-04,1.267700e-04,1.105700e-04, &
     &8.492100e-06,1.042800e-05,5.329200e-05,7.644800e-05,9.198800e-05, &
     &8.402500e-05,9.212700e-06,1.128500e-05,5.600500e-05,7.965000e-05, &
     &9.506600e-05,8.653900e-05,1.009300e-05,1.237400e-05,5.869500e-05, &
     &8.289100e-05,9.827400e-05,8.850900e-05,1.116500e-05,1.367500e-05, &
     &6.146100e-05,8.602800e-05,1.013200e-04,8.992600e-05,1.234400e-05, &
     &1.514900e-05,6.453300e-05,8.929400e-05,1.041600e-04,9.088700e-05, &
     &6.843000e-06,8.409000e-06,4.319300e-05,6.207300e-05,7.481500e-05, &
     &6.821600e-05,7.394200e-06,9.079000e-06,4.549200e-05,6.481800e-05, &
     &7.747300e-05,7.054000e-05,8.096200e-06,9.945500e-06,4.780100e-05, &
     &6.763800e-05,8.024100e-05,7.236600e-05,8.953200e-06,1.099600e-05, &
     &5.013600e-05,7.035200e-05,8.298800e-05,7.373800e-05,9.925400e-06, &
     &1.220600e-05,5.272200e-05,7.315400e-05,8.550200e-05,7.472300e-05, &
     &5.527500e-06,6.782600e-06,3.499200e-05,5.038700e-05,6.079500e-05, &
     &5.537900e-05,5.936000e-06,7.307000e-06,3.690400e-05,5.268100e-05, &
     &6.307000e-05,5.747500e-05,6.491600e-06,7.987600e-06,3.888500e-05, &
     &5.512300e-05,6.544500e-05,5.919400e-05,7.172100e-06,8.831400e-06, &
     &4.085600e-05,5.746500e-05,6.787500e-05,6.053000e-05,7.969500e-06, &
     &9.822500e-06,4.303100e-05,5.987000e-05,7.011800e-05,6.152000e-05, &
     &4.484100e-06,5.485500e-06,2.837000e-05,4.091600e-05,4.940100e-05, &
     &4.476400e-05,4.780500e-06,5.896500e-06,2.996200e-05,4.283200e-05, &
     &5.135000e-05,4.657500e-05,5.217500e-06,6.430300e-06,3.164600e-05, &
     &4.492100e-05,5.337700e-05,4.810100e-05,5.759600e-06,7.107800e-06, &
     &3.331300e-05,4.695100e-05,5.551800e-05,4.929900e-05,6.412100e-06, &
     &7.921400e-06,3.514500e-05,4.900500e-05,5.749700e-05,5.021600e-05, &
     &3.650200e-06,4.445200e-06,2.300400e-05,3.322500e-05,4.013100e-05, &
     &3.607600e-05,3.858400e-06,4.763800e-06,2.432200e-05,3.482000e-05, &
     &4.179800e-05,3.760800e-05,4.197000e-06,5.182400e-06,2.574600e-05, &
     &3.659400e-05,4.352500e-05,3.892100e-05,4.629600e-06,5.723800e-06, &
     &2.717000e-05,3.835400e-05,4.538600e-05,3.995400e-05,5.159600e-06, &
     &6.389700e-06,2.870300e-05,4.010300e-05,4.713000e-05,4.074800e-05, &
     &2.979800e-06,3.609700e-06,1.864500e-05,2.695800e-05,3.256500e-05, &
     &2.904900e-05,3.120300e-06,3.850300e-06,1.972800e-05,2.828500e-05, &
     &3.399700e-05,3.036200e-05,3.377000e-06,4.176400e-06,2.092900e-05, &
     &2.978200e-05,3.546800e-05,3.148000e-05,3.719700e-06,4.607300e-06, &
     &2.213700e-05,3.129900e-05,3.706400e-05,3.237300e-05,4.147600e-06, &
     &5.148100e-06,2.342000e-05,3.279200e-05,3.859000e-05,3.307000e-05, &
     &2.438000e-06,2.937100e-06,1.510100e-05,2.184900e-05,2.638400e-05, &
     &2.337800e-05,2.528300e-06,3.113100e-06,1.599000e-05,2.296100e-05, &
     &2.762800e-05,2.450100e-05,2.717300e-06,3.365900e-06,1.699500e-05, &
     &2.420800e-05,2.887600e-05,2.544300e-05,2.988200e-06,3.707300e-06, &
     &1.801800e-05,2.551600e-05,3.023500e-05,2.622000e-05,3.330900e-06, &
     &4.142900e-06,1.909400e-05,2.679400e-05,3.157500e-05,2.682500e-05, &
     &1.999100e-06,2.396900e-06,1.223500e-05,1.771300e-05,2.138000e-05, &
     &1.881900e-05,2.055200e-06,2.521700e-06,1.296900e-05,1.864100e-05, &
     &2.245000e-05,1.975400e-05,2.191200e-06,2.718400e-06,1.380300e-05, &
     &1.967800e-05,2.350100e-05,2.055500e-05,2.404500e-06,2.986900e-06, &
     &1.466800e-05,2.079900e-05,2.465700e-05,2.121600e-05,2.677900e-06, &
     &3.336900e-06,1.557000e-05,2.189300e-05,2.582400e-05,2.173000e-05, &
     &1.643800e-06,1.970100e-06,1.001000e-05,1.448700e-05,1.747000e-05, &
     &1.523400e-05,1.686900e-06,2.068300e-06,1.062700e-05,1.527200e-05, &
     &1.838100e-05,1.597900e-05,1.794700e-06,2.229400e-06,1.133200e-05, &
     &1.615500e-05,1.928600e-05,1.662200e-05,1.969900e-06,2.451600e-06, &
     &1.206300e-05,1.710800e-05,2.026800e-05,1.713400e-05,2.196700e-06, &
     &2.743300e-06,1.283100e-05,1.804300e-05,2.127400e-05,1.752400e-05/
      data  absb(1:360,5) /                                             &
     &2.180700e-02,2.202100e-02,1.004400e-01,1.494000e-01,1.900400e-01, &
     &2.108400e-01,2.232500e-02,2.254300e-02,1.022700e-01,1.517000e-01, &
     &1.932400e-01,2.168200e-01,2.286600e-02,2.308200e-02,1.040000e-01, &
     &1.540600e-01,1.962500e-01,2.220900e-01,2.340700e-02,2.363000e-02, &
     &1.054200e-01,1.563400e-01,1.988200e-01,2.269100e-01,2.396900e-02, &
     &2.419800e-02,1.067300e-01,1.583200e-01,2.008400e-01,2.312300e-01, &
     &1.858400e-02,1.880100e-02,9.049200e-02,1.338300e-01,1.698900e-01, &
     &1.869000e-01,1.904300e-02,1.926000e-02,9.236300e-02,1.365000e-01, &
     &1.733800e-01,1.921500e-01,1.950900e-02,1.972700e-02,9.403600e-02, &
     &1.391100e-01,1.765200e-01,1.965300e-01,2.001200e-02,2.024000e-02, &
     &9.554700e-02,1.415200e-01,1.790400e-01,2.004600e-01,2.060100e-02, &
     &2.083100e-02,9.682500e-02,1.435400e-01,1.810500e-01,2.038100e-01, &
     &1.576400e-02,1.598600e-02,8.080500e-02,1.193000e-01,1.508400e-01, &
     &1.644200e-01,1.617600e-02,1.639800e-02,8.263000e-02,1.220500e-01, &
     &1.543000e-01,1.688100e-01,1.661400e-02,1.684100e-02,8.426500e-02, &
     &1.247000e-01,1.572200e-01,1.725800e-01,1.711900e-02,1.735300e-02, &
     &8.571600e-02,1.269500e-01,1.596900e-01,1.758800e-01,1.771300e-02, &
     &1.794700e-02,8.688400e-02,1.286700e-01,1.616800e-01,1.786400e-01, &
     &1.333000e-02,1.355900e-02,7.152500e-02,1.057000e-01,1.329200e-01, &
     &1.436000e-01,1.369300e-02,1.392400e-02,7.329100e-02,1.084000e-01, &
     &1.361400e-01,1.474500e-01,1.411600e-02,1.435600e-02,7.480400e-02, &
     &1.108400e-01,1.389200e-01,1.507800e-01,1.462700e-02,1.486900e-02, &
     &7.606700e-02,1.127500e-01,1.413200e-01,1.537300e-01,1.518200e-02, &
     &1.542200e-02,7.713700e-02,1.143200e-01,1.432500e-01,1.561800e-01, &
     &1.122600e-02,1.147100e-02,6.286400e-02,9.297000e-02,1.162400e-01, &
     &1.243500e-01,1.156700e-02,1.181300e-02,6.442700e-02,9.550500e-02, &
     &1.192100e-01,1.277300e-01,1.199000e-02,1.223900e-02,6.577300e-02, &
     &9.756600e-02,1.218300e-01,1.307600e-01,1.245900e-02,1.270900e-02, &
     &6.690000e-02,9.929100e-02,1.240900e-01,1.333500e-01,1.294200e-02, &
     &1.318800e-02,6.790200e-02,1.007700e-01,1.258600e-01,1.351300e-01, &
     &9.427400e-03,9.696500e-03,5.480300e-02,8.115600e-02,1.009500e-01, &
     &1.068900e-01,9.763600e-03,1.002900e-02,5.618000e-02,8.329200e-02, &
     &1.036800e-01,1.099400e-01,1.015900e-02,1.042300e-02,5.735900e-02, &
     &8.514200e-02,1.061200e-01,1.125600e-01,1.055700e-02,1.082300e-02, &
     &5.840300e-02,8.670900e-02,1.080300e-01,1.143000e-01,1.097900e-02, &
     &1.123700e-02,5.937600e-02,8.777400e-02,1.090300e-01,1.148300e-01, &
     &7.909800e-03,8.211600e-03,4.741400e-02,7.021600e-02,8.716000e-02, &
     &9.132200e-02,8.232600e-03,8.528800e-03,4.861000e-02,7.208700e-02, &
     &8.965700e-02,9.391500e-02,8.566200e-03,8.861700e-03,4.966400e-02, &
     &7.369100e-02,9.163600e-02,9.564600e-02,8.907400e-03,9.199500e-03, &
     &5.059900e-02,7.478400e-02,9.270600e-02,9.628600e-02,9.277700e-03, &
     &9.560300e-03,5.140400e-02,7.524800e-02,9.289000e-02,9.601500e-02, &
     &6.640600e-03,6.973000e-03,4.076500e-02,6.039500e-02,7.489400e-02, &
     &7.761500e-02,6.920700e-03,7.247700e-03,4.180200e-02,6.196500e-02, &
     &7.690100e-02,7.938100e-02,7.206500e-03,7.532300e-03,4.268900e-02, &
     &6.307100e-02,7.805200e-02,8.017700e-02,7.503300e-03,7.824500e-03, &
     &4.340100e-02,6.358600e-02,7.842500e-02,8.020500e-02,7.820700e-03, &
     &8.135300e-03,4.398600e-02,6.370400e-02,7.821100e-02,7.964400e-02, &
     &5.568400e-03,5.917200e-03,3.485700e-02,5.159400e-02,6.385800e-02, &
     &6.533100e-02,5.807900e-03,6.155700e-03,3.570800e-02,5.270500e-02, &
     &6.513200e-02,6.628500e-02,6.050300e-03,6.400100e-03,3.635200e-02, &
     &5.330000e-02,6.567500e-02,6.656900e-02,6.299800e-03,6.647700e-03, &
     &3.685200e-02,5.351900e-02,6.572000e-02,6.635200e-02,6.574400e-03, &
     &6.917200e-03,3.727100e-02,5.355400e-02,6.537100e-02,6.570800e-02, &
     &4.679200e-03,5.033100e-03,2.965700e-02,4.371600e-02,5.393100e-02, &
     &5.447200e-02,4.877800e-03,5.237100e-03,3.026100e-02,4.436600e-02, &
     &5.460700e-02,5.493500e-02,5.077000e-03,5.442200e-03,3.071000e-02, &
     &4.466500e-02,5.483600e-02,5.495900e-02,5.292700e-03,5.658600e-03, &
     &3.109600e-02,4.479800e-02,5.472400e-02,5.462200e-02,5.543400e-03, &
     &5.904200e-03,3.137900e-02,4.483800e-02,5.436000e-02,5.396900e-02, &
     &3.925000e-03,4.278800e-03,2.501200e-02,3.668500e-02,4.511700e-02, &
     &4.508100e-02,4.087300e-03,4.449100e-03,2.544300e-02,3.706500e-02, &
     &4.548500e-02,4.529500e-02,4.258100e-03,4.628800e-03,2.580300e-02, &
     &3.727100e-02,4.555900e-02,4.519900e-02,4.452200e-03,4.824700e-03, &
     &2.608300e-02,3.739800e-02,4.540400e-02,4.481600e-02,4.679700e-03, &
     &5.047800e-03,2.627300e-02,3.740900e-02,4.508800e-02,4.419600e-02, &
     &3.285800e-03,3.629100e-03,2.094700e-02,3.058500e-02,3.752200e-02, &
     &3.714900e-02,3.423600e-03,3.777500e-03,2.129600e-02,3.085500e-02, &
     &3.772900e-02,3.722500e-02,3.575600e-03,3.940400e-03,2.157400e-02, &
     &3.103400e-02,3.773100e-02,3.705900e-02,3.754700e-03,4.121700e-03, &
     &2.177200e-02,3.113200e-02,3.758900e-02,3.667100e-02,3.959200e-03, &
     &4.322000e-03,2.191100e-02,3.110500e-02,3.733600e-02,3.610500e-02/
      data  absb(361:720,5) /                                           &
     &2.748500e-03,3.071500e-03,1.748500e-02,2.541100e-02,3.108800e-02, &
     &3.052900e-02,2.869600e-03,3.206200e-03,1.776000e-02,2.563700e-02, &
     &3.121200e-02,3.052200e-02,3.009300e-03,3.356200e-03,1.796500e-02, &
     &2.579200e-02,3.120000e-02,3.032600e-02,3.171000e-03,3.520900e-03, &
     &1.811200e-02,2.583400e-02,3.108400e-02,2.996100e-02,3.354100e-03, &
     &3.704900e-03,1.822100e-02,2.578700e-02,3.086500e-02,2.946100e-02, &
     &2.301900e-03,2.599100e-03,1.455800e-02,2.108300e-02,2.570500e-02, &
     &2.504600e-02,2.409700e-03,2.721800e-03,1.476500e-02,2.127300e-02, &
     &2.579100e-02,2.499000e-02,2.537400e-03,2.858200e-03,1.492000e-02, &
     &2.137500e-02,2.578500e-02,2.478400e-02,2.683800e-03,3.009500e-03, &
     &1.503600e-02,2.139100e-02,2.568100e-02,2.445300e-02,2.841600e-03, &
     &3.173500e-03,1.512400e-02,2.134100e-02,2.546800e-02,2.401600e-02, &
     &1.928400e-03,2.197900e-03,1.209200e-02,1.747400e-02,2.123300e-02, &
     &2.052600e-02,2.027100e-03,2.311000e-03,1.224800e-02,1.761700e-02, &
     &2.130500e-02,2.044500e-02,2.141300e-03,2.433900e-03,1.236800e-02, &
     &1.768300e-02,2.129700e-02,2.024800e-02,2.270000e-03,2.570800e-03, &
     &1.246100e-02,1.768300e-02,2.118700e-02,1.995400e-02,2.405000e-03, &
     &2.713700e-03,1.254700e-02,1.764400e-02,2.099600e-02,1.957800e-02, &
     &1.617700e-03,1.859800e-03,1.002500e-02,1.446400e-02,1.753300e-02, &
     &1.681100e-02,1.707000e-03,1.961600e-03,1.014600e-02,1.456600e-02, &
     &1.759500e-02,1.672000e-02,1.808400e-03,2.073100e-03,1.024000e-02, &
     &1.461000e-02,1.756700e-02,1.653900e-02,1.919100e-03,2.193000e-03, &
     &1.032600e-02,1.461000e-02,1.746200e-02,1.628200e-02,2.036400e-03, &
     &2.320300e-03,1.040900e-02,1.458300e-02,1.729600e-02,1.596000e-02, &
     &1.359300e-03,1.575600e-03,8.301700e-03,1.195700e-02,1.447900e-02, &
     &1.377200e-02,1.440100e-03,1.667400e-03,8.396900e-03,1.203300e-02, &
     &1.451500e-02,1.368100e-02,1.528600e-03,1.766700e-03,8.478400e-03, &
     &1.206400e-02,1.447700e-02,1.351800e-02,1.623900e-03,1.872500e-03, &
     &8.558700e-03,1.206400e-02,1.438100e-02,1.329400e-02,1.727000e-03, &
     &1.986800e-03,8.643800e-03,1.205700e-02,1.423900e-02,1.302800e-02, &
     &1.144500e-03,1.336100e-03,6.872000e-03,9.879100e-03,1.195000e-02, &
     &1.128300e-02,1.215600e-03,1.418800e-03,6.949300e-03,9.934900e-03, &
     &1.196400e-02,1.119500e-02,1.292200e-03,1.506100e-03,7.024800e-03, &
     &9.958000e-03,1.192400e-02,1.105100e-02,1.374700e-03,1.600400e-03, &
     &7.103300e-03,9.969600e-03,1.184000e-02,1.086400e-02,1.467900e-03, &
     &1.704800e-03,7.190400e-03,9.972200e-03,1.172400e-02,1.064500e-02, &
     &9.657100e-04,1.135500e-03,5.686700e-03,8.159800e-03,9.853900e-03, &
     &9.250700e-03,1.026800e-03,1.208100e-03,5.756100e-03,8.201300e-03, &
     &9.856000e-03,9.170100e-03,1.093200e-03,1.285700e-03,5.827300e-03, &
     &8.224300e-03,9.817800e-03,9.048200e-03,1.166600e-03,1.371200e-03, &
     &5.907500e-03,8.242800e-03,9.746500e-03,8.894600e-03,1.250900e-03, &
     &1.466200e-03,5.989600e-03,8.255500e-03,9.657800e-03,8.712100e-03, &
     &8.154900e-04,9.664700e-04,4.708700e-03,6.739000e-03,8.122200e-03, &
     &7.586600e-03,8.680800e-04,1.030300e-03,4.774500e-03,6.773100e-03, &
     &8.118800e-03,7.515300e-03,9.263500e-04,1.099700e-03,4.844700e-03, &
     &6.799200e-03,8.082800e-03,7.416000e-03,9.929300e-04,1.177900e-03, &
     &4.922200e-03,6.822600e-03,8.027900e-03,7.287700e-03,1.068600e-03, &
     &1.264100e-03,4.995200e-03,6.844900e-03,7.962800e-03,7.136600e-03, &
     &6.886600e-04,8.234700e-04,3.904500e-03,5.566000e-03,6.693400e-03, &
     &6.225900e-03,7.345500e-04,8.798600e-04,3.966300e-03,5.598600e-03, &
     &6.686600e-03,6.167700e-03,7.869800e-04,9.428200e-04,4.036100e-03, &
     &5.628100e-03,6.658400e-03,6.084200e-03,8.470600e-04,1.014000e-03, &
     &4.103600e-03,5.656800e-03,6.618500e-03,5.977200e-03,9.157900e-04, &
     &1.092600e-03,4.172800e-03,5.681800e-03,6.569700e-03,5.851900e-03, &
     &5.805800e-04,7.002300e-04,3.240300e-03,4.600500e-03,5.516600e-03, &
     &5.111100e-03,6.212200e-04,7.504800e-04,3.300500e-03,4.633400e-03, &
     &5.509900e-03,5.062600e-03,6.686500e-04,8.078800e-04,3.363000e-03, &
     &4.665800e-03,5.490600e-03,4.992500e-03,7.227800e-04,8.722700e-04, &
     &3.424600e-03,4.697000e-03,5.461900e-03,4.903300e-03,7.842000e-04, &
     &9.441100e-04,3.491300e-03,4.722100e-03,5.429000e-03,4.799900e-03, &
     &4.868000e-04,5.916800e-04,2.688600e-03,3.803100e-03,4.547200e-03, &
     &4.200700e-03,5.228700e-04,6.364700e-04,2.744200e-03,3.836500e-03, &
     &4.544200e-03,4.161300e-03,5.649400e-04,6.880100e-04,2.799000e-03, &
     &3.871300e-03,4.532600e-03,4.103500e-03,6.134600e-04,7.459100e-04, &
     &2.856400e-03,3.901700e-03,4.515000e-03,4.030300e-03,6.671400e-04, &
     &8.105300e-04,2.920700e-03,3.929400e-03,4.495500e-03,3.947200e-03, &
     &4.055600e-04,4.961800e-04,2.228400e-03,3.144000e-03,3.749200e-03, &
     &3.455300e-03,4.371600e-04,5.357200e-04,2.277500e-03,3.177800e-03, &
     &3.751400e-03,3.424500e-03,4.740300e-04,5.813200e-04,2.327000e-03, &
     &3.212400e-03,3.746800e-03,3.378000e-03,5.165900e-04,6.328300e-04, &
     &2.380100e-03,3.241200e-03,3.738000e-03,3.319300e-03,5.632000e-04, &
     &6.900100e-04,2.440100e-03,3.271600e-03,3.726800e-03,3.253800e-03/
      data  absb(721:1080,5) /                                          &
     &3.344500e-04,4.113800e-04,1.841400e-03,2.596000e-03,3.091800e-03, &
     &2.844000e-03,3.613900e-04,4.454200e-04,1.885000e-03,2.629300e-03, &
     &3.098400e-03,2.821600e-03,3.930200e-04,4.849500e-04,1.929100e-03, &
     &2.662400e-03,3.099500e-03,2.786200e-03,4.296200e-04,5.300000e-04, &
     &1.977800e-03,2.691300e-03,3.098500e-03,2.740800e-03,4.695700e-04, &
     &5.798100e-04,2.032100e-03,2.722400e-03,3.093900e-03,2.689900e-03, &
     &2.756500e-04,3.406900e-04,1.521500e-03,2.143900e-03,2.550200e-03, &
     &2.341800e-03,2.986300e-04,3.700300e-04,1.559800e-03,2.175600e-03, &
     &2.560000e-03,2.326400e-03,3.257700e-04,4.042200e-04,1.599500e-03, &
     &2.206800e-03,2.565700e-03,2.299500e-03,3.570900e-04,4.433900e-04, &
     &1.642900e-03,2.234900e-03,2.569500e-03,2.265000e-03,3.915000e-04, &
     &4.869500e-04,1.692200e-03,2.265800e-03,2.569300e-03,2.225700e-03, &
     &2.272400e-04,2.821100e-04,1.257400e-03,1.770900e-03,2.103800e-03, &
     &1.929900e-03,2.468100e-04,3.073600e-04,1.291500e-03,1.800800e-03, &
     &2.115500e-03,1.919400e-03,2.701400e-04,3.370400e-04,1.326800e-03, &
     &1.829300e-03,2.124700e-03,1.899700e-03,2.969600e-04,3.710900e-04, &
     &1.365800e-03,1.856400e-03,2.131600e-03,1.873900e-03,3.266100e-04, &
     &4.091100e-04,1.409900e-03,1.886600e-03,2.134900e-03,1.844200e-03, &
     &1.857900e-04,2.316000e-04,1.036500e-03,1.460300e-03,1.734300e-03, &
     &1.586600e-03,2.022100e-04,2.529000e-04,1.066600e-03,1.487700e-03, &
     &1.747600e-03,1.581000e-03,2.218700e-04,2.782600e-04,1.097500e-03, &
     &1.514100e-03,1.758900e-03,1.566900e-03,2.446400e-04,3.074700e-04, &
     &1.132000e-03,1.539900e-03,1.768200e-03,1.547900e-03,2.698200e-04, &
     &3.402300e-04,1.171200e-03,1.568100e-03,1.774400e-03,1.525400e-03, &
     &1.516600e-04,1.898000e-04,8.537900e-04,1.203500e-03,1.429300e-03, &
     &1.303900e-03,1.654600e-04,2.077500e-04,8.802500e-04,1.228400e-03, &
     &1.443200e-03,1.301400e-03,1.819400e-04,2.293000e-04,9.074100e-04, &
     &1.252800e-03,1.456000e-03,1.291900e-03,2.012000e-04,2.542900e-04, &
     &9.378700e-04,1.276600e-03,1.466400e-03,1.278200e-03,2.226300e-04, &
     &2.825000e-04,9.723200e-04,1.302900e-03,1.474600e-03,1.261300e-03, &
     &1.237400e-04,1.554600e-04,7.030700e-04,9.913699e-04,1.177400e-03, &
     &1.071600e-03,1.353300e-04,1.705500e-04,7.262300e-04,1.014000e-03, &
     &1.191700e-03,1.071300e-03,1.491400e-04,1.888200e-04,7.499800e-04, &
     &1.036300e-03,1.204900e-03,1.065100e-03,1.653900e-04,2.102200e-04, &
     &7.769300e-04,1.058400e-03,1.216000e-03,1.055600e-03,1.836100e-04, &
     &2.344200e-04,8.071900e-04,1.082400e-03,1.225300e-03,1.043100e-03, &
     &1.004500e-04,1.266400e-04,5.773400e-04,8.153600e-04,9.688400e-04, &
     &8.797700e-04,1.100500e-04,1.391700e-04,5.977400e-04,8.358200e-04, &
     &9.829201e-04,8.814900e-04,1.215300e-04,1.544500e-04,6.185300e-04, &
     &8.560600e-04,9.961900e-04,8.782600e-04,1.351000e-04,1.725800e-04, &
     &6.418600e-04,8.760100e-04,1.007500e-03,8.718700e-04,1.504300e-04, &
     &1.931800e-04,6.682800e-04,8.976300e-04,1.017200e-03,8.629400e-04, &
     &8.130500e-05,1.028400e-04,4.733600e-04,6.697600e-04,7.962600e-04, &
     &7.218900e-04,8.919300e-05,1.131500e-04,4.911100e-04,6.879000e-04, &
     &8.098000e-04,7.250500e-04,9.867600e-05,1.258300e-04,5.091300e-04, &
     &7.061700e-04,8.225600e-04,7.241000e-04,1.099600e-04,1.411100e-04, &
     &5.293700e-04,7.243600e-04,8.341000e-04,7.201900e-04,1.228200e-04, &
     &1.585900e-04,5.523600e-04,7.437600e-04,8.440500e-04,7.141700e-04, &
     &6.578600e-05,8.342000e-05,3.877900e-04,5.495700e-04,6.538600e-04, &
     &5.920500e-04,7.223600e-05,9.193200e-05,4.033100e-04,5.660100e-04, &
     &6.667700e-04,5.962800e-04,8.005000e-05,1.024200e-04,4.188300e-04, &
     &5.823800e-04,6.788800e-04,5.968800e-04,8.940500e-05,1.152100e-04, &
     &4.361400e-04,5.985300e-04,6.899700e-04,5.949500e-04,1.001800e-04, &
     &1.300300e-04,4.561000e-04,6.157600e-04,6.997000e-04,5.910700e-04, &
     &5.310400e-05,6.747600e-05,3.171100e-04,4.503000e-04,5.363400e-04, &
     &4.852900e-04,5.831000e-05,7.444000e-05,3.305000e-04,4.647100e-04, &
     &5.481400e-04,4.899400e-04,6.472100e-05,8.307000e-05,3.438800e-04, &
     &4.794500e-04,5.594200e-04,4.917800e-04,7.244600e-05,9.371100e-05, &
     &3.587900e-04,4.939700e-04,5.701000e-04,4.913000e-04,8.143500e-05, &
     &1.062000e-04,3.760400e-04,5.093600e-04,5.797400e-04,4.892900e-04, &
     &4.268600e-05,5.431400e-05,2.585300e-04,3.679900e-04,4.390800e-04, &
     &3.968600e-04,4.683400e-05,5.995800e-05,2.701000e-04,3.805300e-04, &
     &4.499200e-04,4.019400e-04,5.203100e-05,6.695600e-05,2.817400e-04, &
     &3.938200e-04,4.602300e-04,4.046400e-04,5.834400e-05,7.568300e-05, &
     &2.943700e-04,4.067400e-04,4.703900e-04,4.052800e-04,6.577400e-05, &
     &8.610200e-05,3.090400e-04,4.202200e-04,4.795500e-04,4.044500e-04, &
     &3.431300e-05,4.368700e-05,2.107100e-04,3.003500e-04,3.590200e-04, &
     &3.243600e-04,3.759300e-05,4.825000e-05,2.205900e-04,3.112100e-04, &
     &3.687500e-04,3.295600e-04,4.178500e-05,5.390600e-05,2.306200e-04, &
     &3.229800e-04,3.781900e-04,3.328700e-04,4.690500e-05,6.099300e-05, &
     &2.412800e-04,3.343800e-04,3.876300e-04,3.342800e-04,5.302000e-05, &
     &6.964500e-05,2.536600e-04,3.462000e-04,3.962500e-04,3.344000e-04/
      data  absb(1081:1410,5) /                                         &
     &2.758300e-05,3.511500e-05,1.715500e-04,2.448100e-04,2.931700e-04, &
     &2.649800e-04,3.017000e-05,3.880000e-05,1.798600e-04,2.541800e-04, &
     &3.018900e-04,2.702500e-04,3.352100e-05,4.333600e-05,1.885200e-04, &
     &2.644700e-04,3.104300e-04,2.738700e-04,3.765700e-05,4.908400e-05, &
     &1.975800e-04,2.744900e-04,3.189900e-04,2.758600e-04,4.265300e-05, &
     &5.622600e-05,2.079900e-04,2.848400e-04,3.270300e-04,2.767600e-04, &
     &2.221700e-05,2.827100e-05,1.396900e-04,1.994800e-04,2.391900e-04, &
     &2.159700e-04,2.426600e-05,3.125600e-05,1.466700e-04,2.075400e-04, &
     &2.469300e-04,2.209700e-04,2.694100e-05,3.491400e-05,1.541300e-04, &
     &2.164000e-04,2.545700e-04,2.246100e-04,3.028500e-05,3.957500e-05, &
     &1.618600e-04,2.253000e-04,2.623400e-04,2.269200e-04,3.438200e-05, &
     &4.547100e-05,1.706700e-04,2.343500e-04,2.698600e-04,2.282500e-04, &
     &1.790300e-05,2.277300e-05,1.136900e-04,1.624100e-04,1.949800e-04, &
     &1.757300e-04,1.953600e-05,2.519200e-05,1.195400e-04,1.693700e-04, &
     &2.018100e-04,1.803500e-04,2.166000e-05,2.814400e-05,1.260100e-04, &
     &1.770000e-04,2.086600e-04,1.838700e-04,2.436400e-05,3.192900e-05, &
     &1.326400e-04,1.848600e-04,2.156000e-04,1.863300e-04,2.771300e-05, &
     &3.676700e-05,1.400700e-04,1.927300e-04,2.224900e-04,1.878600e-04, &
     &1.441900e-05,1.833700e-05,9.247000e-05,1.321400e-04,1.586900e-04, &
     &1.429000e-04,1.573200e-05,2.029200e-05,9.735500e-05,1.380800e-04, &
     &1.647600e-04,1.471700e-04,1.740200e-05,2.266700e-05,1.029100e-04, &
     &1.446000e-04,1.708300e-04,1.505400e-04,1.958100e-05,2.573000e-05, &
     &1.085700e-04,1.515200e-04,1.769700e-04,1.530500e-04,2.230100e-05, &
     &2.966600e-05,1.148400e-04,1.583200e-04,1.831900e-04,1.546800e-04, &
     &1.160300e-05,1.475900e-05,7.515400e-05,1.074000e-04,1.290400e-04, &
     &1.161800e-04,1.266700e-05,1.633300e-05,7.923500e-05,1.124800e-04, &
     &1.343800e-04,1.200700e-04,1.397500e-05,1.824500e-05,8.393300e-05, &
     &1.180000e-04,1.396000e-04,1.232900e-04,1.571800e-05,2.070800e-05, &
     &8.880300e-05,1.240200e-04,1.450200e-04,1.257400e-04,1.791600e-05, &
     &2.389500e-05,9.406900e-05,1.299500e-04,1.506100e-04,1.274900e-04, &
     &9.355200e-06,1.191200e-05,6.110000e-05,8.731600e-05,1.049200e-04, &
     &9.408000e-05,1.022300e-05,1.318000e-05,6.451900e-05,9.164800e-05, &
     &1.096000e-04,9.747400e-05,1.126000e-05,1.472800e-05,6.848700e-05, &
     &9.634600e-05,1.141000e-04,1.003100e-04,1.265300e-05,1.671400e-05, &
     &7.268000e-05,1.015600e-04,1.188100e-04,1.025400e-04,1.442900e-05, &
     &1.929900e-05,7.713700e-05,1.067000e-04,1.237800e-04,1.041700e-04, &
     &7.547800e-06,9.623300e-06,4.965100e-05,7.096100e-05,8.528900e-05, &
     &7.600500e-05,8.256000e-06,1.064500e-05,5.253500e-05,7.465100e-05, &
     &8.933800e-05,7.887200e-05,9.084300e-06,1.189700e-05,5.587100e-05, &
     &7.865400e-05,9.322000e-05,8.132000e-05,1.019300e-05,1.350100e-05, &
     &5.944400e-05,8.311900e-05,9.732500e-05,8.326300e-05,1.162800e-05, &
     &1.559900e-05,6.325200e-05,8.760600e-05,1.016900e-04,8.468300e-05, &
     &6.090300e-06,7.771800e-06,4.031000e-05,5.761200e-05,6.924400e-05, &
     &6.139700e-05,6.664100e-06,8.593000e-06,4.273600e-05,6.075500e-05, &
     &7.274400e-05,6.379300e-05,7.329100e-06,9.604000e-06,4.552300e-05, &
     &6.414600e-05,7.609700e-05,6.589200e-05,8.205900e-06,1.089700e-05, &
     &4.858200e-05,6.795800e-05,7.961200e-05,6.757200e-05,9.359300e-06, &
     &1.259600e-05,5.182600e-05,7.184900e-05,8.342600e-05,6.881600e-05, &
     &4.916900e-06,6.276800e-06,3.269200e-05,4.672600e-05,5.617400e-05, &
     &4.956100e-05,5.375800e-06,6.931300e-06,3.473000e-05,4.939900e-05, &
     &5.917100e-05,5.156600e-05,5.913100e-06,7.747500e-06,3.705500e-05, &
     &5.226100e-05,6.205600e-05,5.336200e-05,6.601600e-06,8.784300e-06, &
     &3.966100e-05,5.549800e-05,6.505800e-05,5.481300e-05,7.524500e-06, &
     &1.015900e-05,4.242000e-05,5.887000e-05,6.838400e-05,5.590900e-05, &
     &3.976900e-06,5.077100e-06,2.652000e-05,3.790500e-05,4.556600e-05, &
     &3.998800e-05,4.339500e-06,5.596400e-06,2.822200e-05,4.016100e-05, &
     &4.812000e-05,4.168300e-05,4.776500e-06,6.257300e-06,3.016200e-05, &
     &4.256700e-05,5.061200e-05,4.317400e-05,5.319100e-06,7.092400e-06, &
     &3.237700e-05,4.531900e-05,5.317200e-05,4.442800e-05,6.058400e-06, &
     &8.202800e-06,3.472700e-05,4.823200e-05,5.604200e-05,4.538100e-05, &
     &3.262500e-06,4.171600e-06,2.174700e-05,3.105200e-05,3.732900e-05, &
     &3.240900e-05,3.562200e-06,4.606200e-06,2.319100e-05,3.296600e-05, &
     &3.948800e-05,3.377500e-05,3.926500e-06,5.160300e-06,2.485700e-05, &
     &3.503900e-05,4.161000e-05,3.493600e-05,4.379600e-06,5.865100e-06, &
     &2.675800e-05,3.740700e-05,4.384000e-05,3.591200e-05,5.000400e-06, &
     &6.806400e-06,2.877800e-05,3.992000e-05,4.634400e-05,3.664500e-05/
      data  absb(1:360,6) /                                             &
     &4.253500e-02,4.276200e-02,1.699800e-01,2.594300e-01,3.311800e-01, &
     &3.675900e-01,4.368100e-02,4.390700e-02,1.709800e-01,2.616900e-01, &
     &3.356700e-01,3.765600e-01,4.488100e-02,4.510600e-02,1.723500e-01, &
     &2.633200e-01,3.384300e-01,3.833700e-01,4.609700e-02,4.631000e-02, &
     &1.738100e-01,2.643800e-01,3.396900e-01,3.885500e-01,4.733900e-02, &
     &4.753800e-02,1.751200e-01,2.649300e-01,3.399900e-01,3.926000e-01, &
     &3.665300e-02,3.688300e-02,1.572900e-01,2.394900e-01,3.062200e-01, &
     &3.356900e-01,3.764500e-02,3.787300e-02,1.590200e-01,2.421300e-01, &
     &3.101800e-01,3.431300e-01,3.867400e-02,3.890200e-02,1.607200e-01, &
     &2.439800e-01,3.125600e-01,3.492700e-01,3.971500e-02,3.992400e-02, &
     &1.622800e-01,2.453900e-01,3.143100e-01,3.539500e-01,4.081900e-02, &
     &4.102200e-02,1.634300e-01,2.465800e-01,3.153700e-01,3.572300e-01, &
     &3.148900e-02,3.171700e-02,1.445900e-01,2.188600e-01,2.792900e-01, &
     &3.033300e-01,3.232500e-02,3.255100e-02,1.465100e-01,2.215200e-01, &
     &2.828300e-01,3.102600e-01,3.320100e-02,3.341900e-02,1.481900e-01, &
     &2.237200e-01,2.857000e-01,3.158800e-01,3.410900e-02,3.431700e-02, &
     &1.495700e-01,2.257400e-01,2.879200e-01,3.200300e-01,3.519600e-02, &
     &3.540300e-02,1.507400e-01,2.275000e-01,2.893700e-01,3.230000e-01, &
     &2.693700e-02,2.716400e-02,1.316200e-01,1.977700e-01,2.516400e-01, &
     &2.723600e-01,2.765500e-02,2.788100e-02,1.334200e-01,2.006700e-01, &
     &2.553700e-01,2.788000e-01,2.840400e-02,2.861500e-02,1.350300e-01, &
     &2.032600e-01,2.585600e-01,2.838700e-01,2.927000e-02,2.947600e-02, &
     &1.364000e-01,2.057400e-01,2.610500e-01,2.876400e-01,3.041700e-02, &
     &3.062400e-02,1.376400e-01,2.079800e-01,2.629300e-01,2.904100e-01, &
     &2.295300e-02,2.318000e-02,1.184500e-01,1.772100e-01,2.246000e-01, &
     &2.422400e-01,2.355900e-02,2.378400e-02,1.202300e-01,1.803100e-01, &
     &2.285200e-01,2.480500e-01,2.425200e-02,2.446200e-02,1.217400e-01, &
     &1.832200e-01,2.318800e-01,2.525600e-01,2.516000e-02,2.536900e-02, &
     &1.231700e-01,1.859500e-01,2.346100e-01,2.559500e-01,2.632600e-02, &
     &2.653600e-02,1.244500e-01,1.881300e-01,2.368400e-01,2.584300e-01, &
     &1.948200e-02,1.971600e-02,1.056000e-01,1.576400e-01,1.988500e-01, &
     &2.133300e-01,2.002000e-02,2.024700e-02,1.072800e-01,1.608000e-01, &
     &2.027800e-01,2.185200e-01,2.071800e-02,2.093300e-02,1.088100e-01, &
     &1.638000e-01,2.061900e-01,2.225200e-01,2.165900e-02,2.187200e-02, &
     &1.102100e-01,1.663300e-01,2.091200e-01,2.257000e-01,2.272300e-02, &
     &2.293600e-02,1.115300e-01,1.684800e-01,2.114900e-01,2.281800e-01, &
     &1.647400e-02,1.672600e-02,9.327800e-02,1.391100e-01,1.747000e-01, &
     &1.860700e-01,1.698800e-02,1.722400e-02,9.491400e-02,1.422900e-01, &
     &1.785500e-01,1.906000e-01,1.771900e-02,1.794300e-02,9.640200e-02, &
     &1.450600e-01,1.820100e-01,1.942400e-01,1.860000e-02,1.882100e-02, &
     &9.780900e-02,1.474700e-01,1.849500e-01,1.971600e-01,1.951100e-02, &
     &1.973100e-02,9.919800e-02,1.495700e-01,1.872600e-01,1.988700e-01, &
     &1.389100e-02,1.417300e-02,8.175500e-02,1.219600e-01,1.524900e-01, &
     &1.610900e-01,1.443200e-02,1.469200e-02,8.331400e-02,1.248600e-01, &
     &1.562200e-01,1.650800e-01,1.513900e-02,1.538500e-02,8.478300e-02, &
     &1.274100e-01,1.595200e-01,1.683000e-01,1.591300e-02,1.615200e-02, &
     &8.622300e-02,1.296600e-01,1.621400e-01,1.701400e-01,1.668500e-02, &
     &1.691700e-02,8.764200e-02,1.313800e-01,1.635600e-01,1.701400e-01, &
     &1.170200e-02,1.203200e-02,7.110500e-02,1.061300e-01,1.323500e-01, &
     &1.385100e-01,1.224900e-02,1.255300e-02,7.259500e-02,1.087500e-01, &
     &1.358100e-01,1.419300e-01,1.287900e-02,1.316800e-02,7.403200e-02, &
     &1.110200e-01,1.386100e-01,1.439600e-01,1.353700e-02,1.381000e-02, &
     &7.541600e-02,1.127300e-01,1.401200e-01,1.441900e-01,1.419000e-02, &
     &1.445100e-02,7.668800e-02,1.135500e-01,1.402500e-01,1.430200e-01, &
     &9.900100e-03,1.028500e-02,6.155200e-02,9.190300e-02,1.144600e-01, &
     &1.185000e-01,1.040200e-02,1.076400e-02,6.292800e-02,9.412300e-02, &
     &1.172900e-01,1.206600e-01,1.094500e-02,1.128700e-02,6.421900e-02, &
     &9.574500e-02,1.188400e-01,1.211600e-01,1.150200e-02,1.182400e-02, &
     &6.535200e-02,9.654300e-02,1.191200e-01,1.204300e-01,1.205700e-02, &
     &1.236500e-02,6.630600e-02,9.669400e-02,1.185000e-01,1.188700e-01, &
     &8.371200e-03,8.801400e-03,5.298700e-02,7.903600e-02,9.822900e-02, &
     &1.002200e-01,8.808600e-03,9.223900e-03,5.415900e-02,8.056600e-02, &
     &9.988900e-02,1.010400e-01,9.269700e-03,9.665900e-03,5.515200e-02, &
     &8.137900e-02,1.003900e-01,1.007400e-01,9.732700e-03,1.011000e-02, &
     &5.597200e-02,8.163500e-02,1.000900e-01,9.970200e-02,1.021300e-02, &
     &1.057500e-02,5.662700e-02,8.163800e-02,9.923800e-02,9.809200e-02, &
     &7.072700e-03,7.536100e-03,4.532100e-02,6.726000e-02,8.327900e-02, &
     &8.364700e-02,7.442700e-03,7.898600e-03,4.618800e-02,6.809600e-02, &
     &8.401900e-02,8.374700e-02,7.826900e-03,8.267400e-03,4.689200e-02, &
     &6.845000e-02,8.401300e-02,8.314800e-02,8.218900e-03,8.644500e-03, &
     &4.751000e-02,6.858300e-02,8.351200e-02,8.203900e-02,8.650600e-03, &
     &9.063900e-03,4.797900e-02,6.858900e-02,8.268600e-02,8.053000e-02/
      data  absb(361:720,6) /                                           &
     &5.964800e-03,6.450600e-03,3.840700e-02,5.660500e-02,6.984000e-02, &
     &6.921800e-02,6.275300e-03,6.756700e-03,3.906100e-02,5.705700e-02, &
     &7.009800e-02,6.900500e-02,6.597900e-03,7.069200e-03,3.961800e-02, &
     &5.728300e-02,6.989000e-02,6.831200e-02,6.947200e-03,7.408900e-03, &
     &4.007200e-02,5.741000e-02,6.937100e-02,6.724100e-02,7.345800e-03, &
     &7.796800e-03,4.042400e-02,5.740700e-02,6.869000e-02,6.588300e-02, &
     &5.027600e-03,5.519700e-03,3.234100e-02,4.730600e-02,5.815900e-02, &
     &5.698700e-02,5.290500e-03,5.780800e-03,3.285600e-02,4.761000e-02, &
     &5.818800e-02,5.664000e-02,5.572400e-03,6.059500e-03,3.330600e-02, &
     &4.783100e-02,5.792800e-02,5.593900e-02,5.894600e-03,6.377000e-03, &
     &3.365300e-02,4.793500e-02,5.750200e-02,5.495600e-02,6.257400e-03, &
     &6.735500e-03,3.392800e-02,4.788700e-02,5.697000e-02,5.376200e-02, &
     &4.234900e-03,4.717900e-03,2.711600e-02,3.940100e-02,4.822000e-02, &
     &4.678200e-02,4.463400e-03,4.947000e-03,2.754300e-02,3.967400e-02, &
     &4.816200e-02,4.638500e-02,4.720200e-03,5.207100e-03,2.788600e-02, &
     &3.986900e-02,4.794100e-02,4.572200e-02,5.016000e-03,5.503900e-03, &
     &2.816700e-02,3.993400e-02,4.761500e-02,4.484600e-02,5.348100e-03, &
     &5.838000e-03,2.839400e-02,3.986000e-02,4.718400e-02,4.382400e-02, &
     &3.567400e-03,4.028400e-03,2.267300e-02,3.277200e-02,3.987200e-02, &
     &3.833200e-02,3.773400e-03,4.239800e-03,2.300800e-02,3.302800e-02, &
     &3.981000e-02,3.793000e-02,4.009700e-03,4.484500e-03,2.328600e-02, &
     &3.317500e-02,3.965400e-02,3.732400e-02,4.278800e-03,4.762700e-03, &
     &2.351400e-02,3.319400e-02,3.939800e-02,3.657100e-02,4.575700e-03, &
     &5.067600e-03,2.371900e-02,3.311800e-02,3.902000e-02,3.570800e-02, &
     &3.011500e-03,3.441100e-03,1.891100e-02,2.724700e-02,3.294300e-02, &
     &3.138200e-02,3.199400e-03,3.640700e-03,1.917900e-02,2.745500e-02, &
     &3.291100e-02,3.100000e-02,3.414700e-03,3.868200e-03,1.940900e-02, &
     &2.755200e-02,3.279800e-02,3.047200e-02,3.657900e-03,4.127000e-03, &
     &1.960500e-02,2.755900e-02,3.257300e-02,2.983500e-02,3.916200e-03, &
     &4.398700e-03,1.980900e-02,2.748800e-02,3.224000e-02,2.912000e-02, &
     &2.548100e-03,2.944400e-03,1.574500e-02,2.263400e-02,2.722600e-02, &
     &2.567700e-02,2.718800e-03,3.130700e-03,1.596600e-02,2.278600e-02, &
     &2.722000e-02,2.533500e-02,2.914800e-03,3.343900e-03,1.616000e-02, &
     &2.285500e-02,2.711900e-02,2.488200e-02,3.128000e-03,3.577300e-03, &
     &1.634800e-02,2.285400e-02,2.691700e-02,2.435400e-02,3.355300e-03, &
     &3.820200e-03,1.655800e-02,2.281100e-02,2.663000e-02,2.376800e-02, &
     &2.161500e-03,2.525700e-03,1.309800e-02,1.877800e-02,2.251900e-02, &
     &2.101800e-02,2.317000e-03,2.698600e-03,1.328400e-02,1.889100e-02, &
     &2.251500e-02,2.072200e-02,2.490500e-03,2.895300e-03,1.345900e-02, &
     &1.894600e-02,2.241400e-02,2.034500e-02,2.677700e-03,3.102400e-03, &
     &1.364900e-02,1.894900e-02,2.223500e-02,1.990800e-02,2.880300e-03, &
     &3.324300e-03,1.386000e-02,1.894600e-02,2.199600e-02,1.943700e-02, &
     &1.838500e-03,2.171800e-03,1.089600e-02,1.556400e-02,1.862800e-02, &
     &1.720900e-02,1.978700e-03,2.333300e-03,1.105800e-02,1.565700e-02, &
     &1.861300e-02,1.695600e-02,2.131100e-03,2.509000e-03,1.122500e-02, &
     &1.570100e-02,1.852200e-02,1.664200e-02,2.297100e-03,2.696400e-03, &
     &1.141600e-02,1.572500e-02,1.836900e-02,1.629100e-02,2.481400e-03, &
     &2.902100e-03,1.162900e-02,1.575700e-02,1.817700e-02,1.591300e-02, &
     &1.568600e-03,1.873700e-03,9.068100e-03,1.290200e-02,1.540800e-02, &
     &1.409600e-02,1.692000e-03,2.021400e-03,9.216800e-03,1.297600e-02, &
     &1.538400e-02,1.388300e-02,1.827300e-03,2.179100e-03,9.384300e-03, &
     &1.302200e-02,1.530400e-02,1.363200e-02,1.976500e-03,2.351600e-03, &
     &9.573000e-03,1.307100e-02,1.517800e-02,1.335000e-02,2.145200e-03, &
     &2.543200e-03,9.783000e-03,1.313100e-02,1.503700e-02,1.304500e-02, &
     &1.337200e-03,1.617800e-03,7.551900e-03,1.069300e-02,1.274000e-02, &
     &1.154900e-02,1.446100e-03,1.750300e-03,7.694500e-03,1.075700e-02, &
     &1.271500e-02,1.137700e-02,1.566000e-03,1.893700e-03,7.858300e-03, &
     &1.081600e-02,1.264800e-02,1.117600e-02,1.701400e-03,2.053400e-03, &
     &8.044800e-03,1.088400e-02,1.255900e-02,1.095000e-02,1.855800e-03, &
     &2.231500e-03,8.242300e-03,1.096300e-02,1.246400e-02,1.070500e-02, &
     &1.132900e-03,1.389500e-03,6.288000e-03,8.861000e-03,1.053200e-02, &
     &9.480900e-03,1.228400e-03,1.507900e-03,6.426200e-03,8.926100e-03, &
     &1.051600e-02,9.346200e-03,1.335100e-03,1.638600e-03,6.584500e-03, &
     &8.995800e-03,1.046800e-02,9.186500e-03,1.457300e-03,1.784900e-03, &
     &6.761400e-03,9.076000e-03,1.041000e-02,9.006400e-03,1.597000e-03, &
     &1.948700e-03,6.942000e-03,9.166200e-03,1.035100e-02,8.811700e-03, &
     &9.521100e-04,1.184300e-03,5.231200e-03,7.341200e-03,8.708700e-03, &
     &7.798100e-03,1.035400e-03,1.290100e-03,5.362500e-03,7.408800e-03, &
     &8.700500e-03,7.692800e-03,1.129600e-03,1.407900e-03,5.513800e-03, &
     &7.486200e-03,8.673200e-03,7.568900e-03,1.238800e-03,1.540900e-03, &
     &5.675000e-03,7.572600e-03,8.642400e-03,7.426200e-03,1.363800e-03, &
     &1.690200e-03,5.841600e-03,7.667700e-03,8.612400e-03,7.270800e-03/
      data  absb(721:1080,6) /                                          &
     &7.906700e-04,9.972800e-04,4.341200e-03,6.078100e-03,7.201000e-03, &
     &6.422500e-03,8.620700e-04,1.090300e-03,4.461800e-03,6.147700e-03, &
     &7.204000e-03,6.345000e-03,9.436500e-04,1.195100e-03,4.601600e-03, &
     &6.225900e-03,7.194900e-03,6.249100e-03,1.039000e-03,1.313700e-03, &
     &4.747400e-03,6.313400e-03,7.183500e-03,6.137100e-03,1.149300e-03, &
     &1.448200e-03,4.900800e-03,6.409200e-03,7.175900e-03,6.015300e-03, &
     &6.557400e-04,8.390200e-04,3.602900e-03,5.033800e-03,5.953500e-03, &
     &5.293100e-03,7.172300e-04,9.209200e-04,3.714300e-03,5.103300e-03, &
     &5.966400e-03,5.235600e-03,7.881700e-04,1.014000e-03,3.841000e-03, &
     &5.178800e-03,5.969400e-03,5.163100e-03,8.714200e-04,1.119900e-03, &
     &3.972200e-03,5.268500e-03,5.973800e-03,5.075800e-03,9.681400e-04, &
     &1.240600e-03,4.113000e-03,5.359400e-03,5.979600e-03,4.980900e-03, &
     &5.439400e-04,7.058700e-04,2.992000e-03,4.171200e-03,4.924100e-03, &
     &4.364800e-03,5.967900e-04,7.779400e-04,3.093800e-03,4.238700e-03, &
     &4.942900e-03,4.324400e-03,6.586200e-04,8.605700e-04,3.208000e-03, &
     &4.314900e-03,4.956000e-03,4.270500e-03,7.313600e-04,9.552100e-04, &
     &3.326100e-03,4.399800e-03,4.970400e-03,4.203700e-03,8.164600e-04, &
     &1.063700e-03,3.456500e-03,4.486800e-03,4.987500e-03,4.131300e-03, &
     &4.467900e-04,5.874500e-04,2.476300e-03,3.450500e-03,4.070800e-03, &
     &3.594500e-03,4.916900e-04,6.500500e-04,2.567700e-03,3.515200e-03, &
     &4.094300e-03,3.566700e-03,5.445000e-04,7.222200e-04,2.669300e-03, &
     &3.587300e-03,4.113500e-03,3.526600e-03,6.071200e-04,8.057800e-04, &
     &2.775300e-03,3.669600e-03,4.135300e-03,3.475900e-03,6.806100e-04, &
     &9.019800e-04,2.893700e-03,3.751000e-03,4.159500e-03,3.420200e-03, &
     &3.665400e-04,4.876300e-04,2.049700e-03,2.854400e-03,3.365200e-03, &
     &2.959300e-03,4.043600e-04,5.416800e-04,2.129700e-03,2.914300e-03, &
     &3.391300e-03,2.940900e-03,4.494100e-04,6.044200e-04,2.219700e-03, &
     &2.982500e-03,3.414500e-03,2.912200e-03,5.028800e-04,6.776600e-04, &
     &2.314300e-03,3.059600e-03,3.440700e-03,2.873800e-03,5.662700e-04, &
     &7.629600e-04,2.420900e-03,3.135400e-03,3.469300e-03,2.831200e-03, &
     &3.005600e-04,4.042300e-04,1.695500e-03,2.360400e-03,2.781500e-03, &
     &2.435900e-03,3.324000e-04,4.507800e-04,1.766200e-03,2.416200e-03, &
     &2.808700e-03,2.425000e-03,3.706000e-04,5.050100e-04,1.845500e-03, &
     &2.479500e-03,2.834200e-03,2.404700e-03,4.163800e-04,5.691200e-04, &
     &1.929900e-03,2.550800e-03,2.862600e-03,2.376500e-03,4.708900e-04, &
     &6.446300e-04,2.024900e-03,2.620800e-03,2.894300e-03,2.344700e-03, &
     &2.450200e-04,3.326100e-04,1.399100e-03,1.948100e-03,2.296100e-03, &
     &2.004500e-03,2.715200e-04,3.721200e-04,1.460600e-03,1.998800e-03, &
     &2.324100e-03,1.999900e-03,3.034300e-04,4.185100e-04,1.530100e-03, &
     &2.058100e-03,2.351500e-03,1.986700e-03,3.421700e-04,4.738400e-04, &
     &1.604700e-03,2.122500e-03,2.380400e-03,1.966200e-03,3.886500e-04, &
     &5.398000e-04,1.688800e-03,2.187100e-03,2.413400e-03,1.942300e-03, &
     &1.991500e-04,2.724900e-04,1.152700e-03,1.606800e-03,1.894900e-03, &
     &1.649200e-03,2.210400e-04,3.058600e-04,1.205900e-03,1.652400e-03, &
     &1.922000e-03,1.648700e-03,2.476400e-04,3.452900e-04,1.266800e-03, &
     &1.705100e-03,1.949000e-03,1.641000e-03,2.800500e-04,3.925300e-04, &
     &1.332200e-03,1.763500e-03,1.978600e-03,1.627400e-03,3.193700e-04, &
     &4.494800e-04,1.405800e-03,1.822400e-03,2.011400e-03,1.610300e-03, &
     &1.616900e-04,2.228700e-04,9.488600e-04,1.324400e-03,1.562400e-03, &
     &1.356400e-03,1.798800e-04,2.510700e-04,9.946200e-04,1.365000e-03, &
     &1.588500e-03,1.359500e-03,2.018800e-04,2.843000e-04,1.048100e-03, &
     &1.412100e-03,1.615100e-03,1.356100e-03,2.290100e-04,3.245800e-04, &
     &1.105600e-03,1.464300e-03,1.643400e-03,1.347100e-03,2.621500e-04, &
     &3.735900e-04,1.170000e-03,1.517800e-03,1.675000e-03,1.335100e-03, &
     &1.308700e-04,1.815300e-04,7.801400e-04,1.090300e-03,1.286200e-03, &
     &1.114900e-03,1.458800e-04,2.052300e-04,8.188700e-04,1.126000e-03, &
     &1.311300e-03,1.120100e-03,1.640100e-04,2.330900e-04,8.653100e-04, &
     &1.167000e-03,1.336200e-03,1.119900e-03,1.865700e-04,2.671600e-04, &
     &9.157600e-04,1.214100e-03,1.363600e-03,1.115000e-03,2.143300e-04, &
     &3.090100e-04,9.715600e-04,1.262100e-03,1.394000e-03,1.107500e-03, &
     &1.053200e-04,1.467800e-04,6.393100e-04,8.956600e-04,1.057000e-03, &
     &9.145700e-04,1.176500e-04,1.665800e-04,6.722500e-04,9.270200e-04, &
     &1.080800e-03,9.215300e-04,1.324100e-04,1.898000e-04,7.120200e-04, &
     &9.625000e-04,1.104100e-03,9.240400e-04,1.509000e-04,2.181400e-04, &
     &7.559200e-04,1.003800e-03,1.129600e-03,9.222400e-04,1.738500e-04, &
     &2.534400e-04,8.042000e-04,1.047100e-03,1.158000e-03,9.176500e-04, &
     &8.461700e-05,1.183800e-04,5.233400e-04,7.354600e-04,8.683500e-04, &
     &7.501700e-04,9.478500e-05,1.349500e-04,5.509100e-04,7.625100e-04, &
     &8.903100e-04,7.581600e-04,1.067900e-04,1.542600e-04,5.848800e-04, &
     &7.933200e-04,9.116800e-04,7.624500e-04,1.218800e-04,1.778400e-04, &
     &6.231400e-04,8.292200e-04,9.347900e-04,7.627600e-04,1.408300e-04, &
     &2.074100e-04,6.649100e-04,8.677800e-04,9.607300e-04,7.604900e-04/
      data  absb(1081:1410,6) /                                         &
     &6.786700e-05,9.527000e-05,4.278600e-04,6.031100e-04,7.121700e-04, &
     &6.151100e-04,7.624500e-05,1.090800e-04,4.509700e-04,6.266200e-04, &
     &7.324300e-04,6.236900e-04,8.602900e-05,1.251500e-04,4.796600e-04, &
     &6.528700e-04,7.515800e-04,6.292300e-04,9.830400e-05,1.446600e-04, &
     &5.125900e-04,6.838300e-04,7.725400e-04,6.313200e-04,1.138600e-04, &
     &1.693400e-04,5.486300e-04,7.179900e-04,7.959600e-04,6.310000e-04, &
     &5.447000e-05,7.674600e-05,3.497600e-04,4.942800e-04,5.839700e-04, &
     &5.030600e-04,6.141000e-05,8.823700e-05,3.691500e-04,5.145600e-04, &
     &6.021700e-04,5.115400e-04,6.943900e-05,1.016600e-04,3.931400e-04, &
     &5.372100e-04,6.193900e-04,5.175500e-04,7.945400e-05,1.179200e-04, &
     &4.216000e-04,5.641200e-04,6.383500e-04,5.207400e-04,9.227500e-05, &
     &1.385500e-04,4.530100e-04,5.944800e-04,6.595000e-04,5.217500e-04, &
     &4.372200e-05,6.180600e-05,2.857800e-04,4.046800e-04,4.785500e-04, &
     &4.107400e-04,4.945700e-05,7.134200e-05,3.021100e-04,4.223000e-04, &
     &4.948800e-04,4.188600e-04,5.606400e-05,8.255400e-05,3.222500e-04, &
     &4.420400e-04,5.104900e-04,4.250600e-04,6.423800e-05,9.612000e-05, &
     &3.467200e-04,4.652800e-04,5.274300e-04,4.288800e-04,7.479600e-05, &
     &1.133400e-04,3.737800e-04,4.919600e-04,5.461800e-04,4.305700e-04, &
     &3.507000e-05,4.969100e-05,2.333000e-04,3.309300e-04,3.917200e-04, &
     &3.352700e-04,3.976900e-05,5.754100e-05,2.470600e-04,3.463700e-04, &
     &4.067000e-04,3.429700e-04,4.522300e-05,6.691600e-05,2.638100e-04, &
     &3.632700e-04,4.204500e-04,3.491200e-04,5.187100e-05,7.820000e-05, &
     &2.847200e-04,3.831000e-04,4.353300e-04,3.532400e-04,6.052200e-05, &
     &9.255400e-05,3.079600e-04,4.064400e-04,4.519000e-04,3.554800e-04, &
     &2.811400e-05,3.989500e-05,1.903300e-04,2.703500e-04,3.202700e-04, &
     &2.737400e-04,3.191200e-05,4.627200e-05,2.018000e-04,2.836400e-04, &
     &3.336800e-04,2.808800e-04,3.641500e-05,5.408800e-05,2.157000e-04, &
     &2.981200e-04,3.460900e-04,2.868200e-04,4.182600e-05,6.348600e-05, &
     &2.333400e-04,3.149800e-04,3.589800e-04,2.912000e-04,4.888500e-05, &
     &7.540800e-05,2.533700e-04,3.353100e-04,3.735200e-04,2.938600e-04, &
     &2.261000e-05,3.212000e-05,1.554000e-04,2.209000e-04,2.618900e-04, &
     &2.225200e-04,2.567000e-05,3.730400e-05,1.650000e-04,2.323400e-04, &
     &2.738300e-04,2.288100e-04,2.939800e-05,4.382800e-05,1.766200e-04, &
     &2.447500e-04,2.848800e-04,2.341000e-04,3.383000e-05,5.168900e-05, &
     &1.914700e-04,2.591800e-04,2.962100e-04,2.381800e-04,3.962600e-05, &
     &6.163700e-05,2.086500e-04,2.767400e-04,3.089100e-04,2.407800e-04, &
     &1.820900e-05,2.588000e-05,1.268800e-04,1.804500e-04,2.139800e-04, &
     &1.803800e-04,2.065700e-05,3.008600e-05,1.349300e-04,1.902500e-04, &
     &2.245000e-04,1.858200e-04,2.373900e-05,3.551400e-05,1.446000e-04, &
     &2.008100e-04,2.343000e-04,1.903300e-04,2.739700e-05,4.208800e-05, &
     &1.571400e-04,2.130600e-04,2.441600e-04,1.938600e-04,3.215300e-05, &
     &5.038700e-05,1.718600e-04,2.282000e-04,2.553300e-04,1.962700e-04, &
     &1.465400e-05,2.083600e-05,1.035000e-04,1.472300e-04,1.745800e-04, &
     &1.461300e-04,1.660200e-05,2.422400e-05,1.102300e-04,1.556200e-04, &
     &1.838000e-04,1.508700e-04,1.914500e-05,2.871300e-05,1.183100e-04, &
     &1.645800e-04,1.924300e-04,1.546600e-04,2.216200e-05,3.420500e-05, &
     &1.287700e-04,1.750000e-04,2.010700e-04,1.577600e-04,2.604700e-05, &
     &4.111400e-05,1.413700e-04,1.879600e-04,2.108300e-04,1.599400e-04, &
     &1.179500e-05,1.676000e-05,8.430400e-05,1.199900e-04,1.421800e-04, &
     &1.183000e-04,1.333500e-05,1.947600e-05,8.996400e-05,1.271800e-04, &
     &1.503500e-04,1.224400e-04,1.541200e-05,2.315000e-05,9.668000e-05, &
     &1.347800e-04,1.577900e-04,1.256600e-04,1.789600e-05,2.772800e-05, &
     &1.053900e-04,1.435800e-04,1.653600e-04,1.283500e-04,2.107100e-05, &
     &3.347400e-05,1.161400e-04,1.545600e-04,1.738200e-04,1.302800e-04, &
     &9.514400e-06,1.350400e-05,6.867000e-05,9.775200e-05,1.157200e-04, &
     &9.573100e-05,1.072700e-05,1.568200e-05,7.342500e-05,1.039300e-04, &
     &1.228800e-04,9.926800e-05,1.241800e-05,1.867600e-05,7.903600e-05, &
     &1.104200e-04,1.294100e-04,1.020500e-04,1.447000e-05,2.249200e-05, &
     &8.630100e-05,1.178700e-04,1.360100e-04,1.043100e-04,1.706800e-05, &
     &2.729000e-05,9.544500e-05,1.271100e-04,1.432600e-04,1.059900e-04, &
     &7.820500e-06,1.114400e-05,5.655300e-05,8.051800e-05,9.525300e-05, &
     &7.775800e-05,8.841200e-06,1.299400e-05,6.064500e-05,8.580800e-05, &
     &1.013700e-04,8.056500e-05,1.027500e-05,1.555600e-05,6.550800e-05, &
     &9.140800e-05,1.070300e-04,8.276700e-05,1.202600e-05,1.886100e-05, &
     &7.187900e-05,9.791800e-05,1.127700e-04,8.444300e-05,1.425900e-05, &
     &2.305100e-05,7.985700e-05,1.061100e-04,1.192100e-04,8.569700e-05/
      data  absb(1:360,7) /                                             &
     &9.764700e-02,9.785500e-02,3.036300e-01,4.703100e-01,5.990400e-01, &
     &6.664000e-01,1.004900e-01,1.006900e-01,3.021800e-01,4.698200e-01, &
     &6.003600e-01,6.730800e-01,1.037700e-01,1.039600e-01,3.003300e-01, &
     &4.676200e-01,5.998300e-01,6.788300e-01,1.070400e-01,1.072200e-01, &
     &2.989200e-01,4.646700e-01,5.975100e-01,6.820400e-01,1.102300e-01, &
     &1.104000e-01,2.980200e-01,4.615500e-01,5.938200e-01,6.834200e-01, &
     &8.623500e-02,8.645000e-02,2.902800e-01,4.505500e-01,5.762000e-01, &
     &6.343500e-01,8.908400e-02,8.929200e-02,2.894500e-01,4.500200e-01, &
     &5.781700e-01,6.398000e-01,9.193900e-02,9.213300e-02,2.890200e-01, &
     &4.487100e-01,5.781400e-01,6.442700e-01,9.479300e-02,9.497900e-02, &
     &2.889700e-01,4.470800e-01,5.762100e-01,6.466700e-01,9.749300e-02, &
     &9.766800e-02,2.892400e-01,4.451800e-01,5.731700e-01,6.467100e-01, &
     &7.580400e-02,7.602900e-02,2.744600e-01,4.258900e-01,5.472000e-01, &
     &5.972600e-01,7.830000e-02,7.851700e-02,2.750200e-01,4.261800e-01, &
     &5.494800e-01,6.017100e-01,8.078500e-02,8.098900e-02,2.759900e-01, &
     &4.260900e-01,5.496400e-01,6.046900e-01,8.319500e-02,8.338800e-02, &
     &2.772000e-01,4.257900e-01,5.482700e-01,6.058700e-01,8.545500e-02, &
     &8.563600e-02,2.783200e-01,4.251000e-01,5.456500e-01,6.053400e-01, &
     &6.611800e-02,6.635500e-02,2.573200e-01,3.982900e-01,5.126500e-01, &
     &5.552700e-01,6.834000e-02,6.856500e-02,2.592200e-01,3.997200e-01, &
     &5.148100e-01,5.590100e-01,7.047900e-02,7.069100e-02,2.613100e-01, &
     &4.006400e-01,5.151300e-01,5.612900e-01,7.248900e-02,7.268900e-02, &
     &2.633500e-01,4.010800e-01,5.140600e-01,5.625300e-01,7.439700e-02, &
     &7.458600e-02,2.651800e-01,4.009800e-01,5.122200e-01,5.624300e-01, &
     &5.740600e-02,5.765000e-02,2.393000e-01,3.686600e-01,4.735700e-01, &
     &5.087800e-01,5.930900e-02,5.953700e-02,2.421400e-01,3.706000e-01, &
     &4.757300e-01,5.119200e-01,6.108200e-02,6.130100e-02,2.448100e-01, &
     &3.722000e-01,4.760800e-01,5.145700e-01,6.276900e-02,6.297600e-02, &
     &2.472600e-01,3.733300e-01,4.757500e-01,5.163900e-01,6.453800e-02, &
     &6.473800e-02,2.492100e-01,3.744400e-01,4.749100e-01,5.171800e-01, &
     &4.955200e-02,4.980100e-02,2.205600e-01,3.373500e-01,4.316100e-01, &
     &4.598800e-01,5.112100e-02,5.135900e-02,2.236100e-01,3.399100e-01, &
     &4.334500e-01,4.634600e-01,5.259300e-02,5.282100e-02,2.265400e-01, &
     &3.422000e-01,4.344000e-01,4.666700e-01,5.410900e-02,5.432300e-02, &
     &2.290500e-01,3.443800e-01,4.351300e-01,4.690500e-01,5.593900e-02, &
     &5.614500e-02,2.310700e-01,3.462800e-01,4.358100e-01,4.707500e-01, &
     &4.249400e-02,4.274600e-02,2.010600e-01,3.052000e-01,3.881300e-01, &
     &4.108700e-01,4.377900e-02,4.402200e-02,2.042500e-01,3.083600e-01, &
     &3.903600e-01,4.149400e-01,4.504700e-02,4.527900e-02,2.071400e-01, &
     &3.114900e-01,3.922700e-01,4.186600e-01,4.657200e-02,4.679100e-02, &
     &2.096000e-01,3.144200e-01,3.944300e-01,4.216200e-01,4.848600e-02, &
     &4.869300e-02,2.117800e-01,3.172400e-01,3.964800e-01,4.240600e-01, &
     &3.626900e-02,3.652800e-02,1.814500e-01,2.735800e-01,3.455600e-01, &
     &3.636200e-01,3.733900e-02,3.758900e-02,1.845400e-01,2.774400e-01, &
     &3.484900e-01,3.681500e-01,3.854900e-02,3.878700e-02,1.873200e-01, &
     &2.810700e-01,3.517300e-01,3.721400e-01,4.013500e-02,4.036000e-02, &
     &1.899100e-01,2.846800e-01,3.549400e-01,3.757800e-01,4.203400e-02, &
     &4.224400e-02,1.923100e-01,2.879600e-01,3.582500e-01,3.792000e-01, &
     &3.083800e-02,3.111000e-02,1.621700e-01,2.434700e-01,3.051900e-01, &
     &3.190900e-01,3.180200e-02,3.206300e-02,1.651500e-01,2.476100e-01, &
     &3.091100e-01,3.238500e-01,3.306200e-02,3.330900e-02,1.679600e-01, &
     &2.517300e-01,3.132400e-01,3.283600e-01,3.462900e-02,3.486200e-02, &
     &1.706600e-01,2.556100e-01,3.176200e-01,3.324300e-01,3.634200e-02, &
     &3.655600e-02,1.733100e-01,2.594500e-01,3.216100e-01,3.353600e-01, &
     &2.618500e-02,2.648000e-02,1.439000e-01,2.153500e-01,2.682500e-01, &
     &2.783100e-01,2.717000e-02,2.744500e-02,1.468100e-01,2.197200e-01, &
     &2.729800e-01,2.833200e-01,2.846100e-02,2.872100e-02,1.496700e-01, &
     &2.240300e-01,2.780000e-01,2.877100e-01,2.989500e-02,3.013600e-02, &
     &1.525200e-01,2.282600e-01,2.824500e-01,2.909400e-01,3.138900e-02, &
     &3.160900e-02,1.554600e-01,2.319200e-01,2.857600e-01,2.920400e-01, &
     &2.224200e-02,2.258500e-02,1.267800e-01,1.894200e-01,2.349400e-01, &
     &2.414300e-01,2.326900e-02,2.358400e-02,1.296600e-01,1.939200e-01, &
     &2.401200e-01,2.460100e-01,2.446200e-02,2.475200e-02,1.326200e-01, &
     &1.982600e-01,2.447900e-01,2.493200e-01,2.572400e-02,2.598700e-02, &
     &1.356200e-01,2.019400e-01,2.482700e-01,2.504400e-01,2.700900e-02, &
     &2.724700e-02,1.386600e-01,2.047200e-01,2.498700e-01,2.491100e-01, &
     &1.892400e-02,1.934200e-02,1.110500e-01,1.659000e-01,2.049900e-01, &
     &2.080200e-01,1.991000e-02,2.029000e-02,1.139700e-01,1.701800e-01, &
     &2.097000e-01,2.113500e-01,2.096500e-02,2.130800e-02,1.169000e-01, &
     &1.738200e-01,2.131900e-01,2.125500e-01,2.205200e-02,2.236200e-02, &
     &1.197600e-01,1.764700e-01,2.147200e-01,2.115500e-01,2.315900e-02, &
     &2.343800e-02,1.225400e-01,1.779000e-01,2.143600e-01,2.089900e-01/
      data  absb(361:720,7) /                                           &
     &1.612600e-02,1.663400e-02,9.691800e-02,1.445000e-01,1.777600e-01, &
     &1.775100e-01,1.700500e-02,1.747100e-02,9.965500e-02,1.480400e-01, &
     &1.811700e-01,1.788900e-01,1.790800e-02,1.833000e-02,1.023100e-01, &
     &1.505600e-01,1.827700e-01,1.783400e-01,1.883400e-02,1.921400e-02, &
     &1.048100e-01,1.518800e-01,1.826900e-01,1.764400e-01,1.980300e-02, &
     &2.014700e-02,1.070600e-01,1.524100e-01,1.814200e-01,1.736000e-01, &
     &1.373300e-02,1.433300e-02,8.416300e-02,1.249100e-01,1.526400e-01, &
     &1.495000e-01,1.448500e-02,1.504200e-02,8.657100e-02,1.272900e-01, &
     &1.543300e-01,1.493800e-01,1.526300e-02,1.577500e-02,8.879300e-02, &
     &1.286100e-01,1.545600e-01,1.480900e-01,1.606000e-02,1.652600e-02, &
     &9.076600e-02,1.292200e-01,1.537300e-01,1.459800e-01,1.693600e-02, &
     &1.735600e-02,9.241000e-02,1.295700e-01,1.522400e-01,1.432300e-01, &
     &1.167300e-02,1.234900e-02,7.266800e-02,1.067800e-01,1.294600e-01, &
     &1.244600e-01,1.231300e-02,1.295500e-02,7.461300e-02,1.081300e-01, &
     &1.299800e-01,1.237200e-01,1.297400e-02,1.357400e-02,7.636500e-02, &
     &1.088500e-01,1.295800e-01,1.222300e-01,1.368800e-02,1.424100e-02, &
     &7.787000e-02,1.093400e-01,1.285900e-01,1.201900e-01,1.450000e-02, &
     &1.500400e-02,7.915400e-02,1.096800e-01,1.272100e-01,1.176900e-01, &
     &9.901700e-03,1.063700e-02,6.226900e-02,9.033600e-02,1.087300e-01, &
     &1.028900e-01,1.044700e-02,1.115500e-02,6.383700e-02,9.116100e-02, &
     &1.087000e-01,1.019400e-01,1.103100e-02,1.170300e-02,6.523400e-02, &
     &9.175700e-02,1.081300e-01,1.004900e-01,1.168700e-02,1.231700e-02, &
     &6.643500e-02,9.224400e-02,1.072200e-01,9.862100e-02,1.245200e-02, &
     &1.303600e-02,6.745200e-02,9.254100e-02,1.061700e-01,9.643000e-02, &
     &8.394300e-03,9.165400e-03,5.304700e-02,7.594100e-02,9.076400e-02, &
     &8.473200e-02,8.866900e-03,9.621100e-03,5.435100e-02,7.661500e-02, &
     &9.053400e-02,8.376800e-02,9.397600e-03,1.012500e-02,5.550100e-02, &
     &7.720100e-02,8.998900e-02,8.242800e-02,1.001700e-02,1.070800e-02, &
     &5.648900e-02,7.764300e-02,8.931000e-02,8.078500e-02,1.073600e-02, &
     &1.138900e-02,5.730500e-02,7.787700e-02,8.854500e-02,7.891700e-02, &
     &7.119500e-03,7.906400e-03,4.504800e-02,6.370100e-02,7.550600e-02, &
     &6.960900e-02,7.543000e-03,8.322300e-03,4.614100e-02,6.433600e-02, &
     &7.524900e-02,6.869100e-02,8.039200e-03,8.802800e-03,4.709200e-02, &
     &6.488700e-02,7.486500e-02,6.751300e-02,8.626000e-03,9.365700e-03, &
     &4.790300e-02,6.526300e-02,7.440100e-02,6.610800e-02,9.296700e-03, &
     &1.000700e-02,4.861500e-02,6.544700e-02,7.385200e-02,6.454500e-02, &
     &6.047500e-03,6.833500e-03,3.815800e-02,5.342100e-02,6.269500e-02, &
     &5.711800e-02,6.442300e-03,7.230600e-03,3.908700e-02,5.403800e-02, &
     &6.253300e-02,5.630400e-02,6.915700e-03,7.699000e-03,3.988500e-02, &
     &5.450700e-02,6.231400e-02,5.529100e-02,7.464300e-03,8.237800e-03, &
     &4.058500e-02,5.481800e-02,6.200700e-02,5.412300e-02,8.087000e-03, &
     &8.842700e-03,4.123800e-02,5.495600e-02,6.157100e-02,5.284500e-02, &
     &5.157200e-03,5.928100e-03,3.228800e-02,4.483400e-02,5.206300e-02, &
     &4.683800e-02,5.534300e-03,6.317800e-03,3.306600e-02,4.537900e-02, &
     &5.202200e-02,4.613400e-02,5.979300e-03,6.773200e-03,3.375500e-02, &
     &4.578200e-02,5.190600e-02,4.528400e-02,6.492300e-03,7.287600e-03, &
     &3.438200e-02,4.603100e-02,5.167700e-02,4.433200e-02,7.059600e-03, &
     &7.851000e-03,3.502000e-02,4.615700e-02,5.132600e-02,4.332700e-02, &
     &4.419300e-03,5.167200e-03,2.728100e-02,3.764300e-02,4.328900e-02, &
     &3.841000e-02,4.778000e-03,5.550900e-03,2.795400e-02,3.811200e-02, &
     &4.332300e-02,3.782100e-02,5.195400e-03,5.989900e-03,2.855800e-02, &
     &3.844200e-02,4.325300e-02,3.713300e-02,5.667500e-03,6.476000e-03, &
     &2.916200e-02,3.866100e-02,4.307700e-02,3.638200e-02,6.186700e-03, &
     &6.998100e-03,2.981700e-02,3.881700e-02,4.279100e-02,3.559300e-02, &
     &3.796700e-03,4.519000e-03,2.303000e-02,3.160100e-02,3.605400e-02, &
     &3.150900e-02,4.131700e-03,4.888600e-03,2.361200e-02,3.199300e-02, &
     &3.611400e-02,3.102500e-02,4.519700e-03,5.308000e-03,2.417200e-02, &
     &3.228400e-02,3.607500e-02,3.047500e-02,4.949000e-03,5.761500e-03, &
     &2.476500e-02,3.250000e-02,3.593400e-02,2.988600e-02,5.427700e-03, &
     &6.250600e-03,2.545700e-02,3.270300e-02,3.571700e-02,2.926500e-02, &
     &3.248500e-03,3.940100e-03,1.939500e-02,2.648700e-02,3.006100e-02, &
     &2.589800e-02,3.557400e-03,4.290200e-03,1.991800e-02,2.683900e-02, &
     &3.013700e-02,2.550900e-02,3.908400e-03,4.682300e-03,2.045400e-02, &
     &2.711200e-02,3.012300e-02,2.508000e-02,4.297500e-03,5.103900e-03, &
     &2.105200e-02,2.734800e-02,3.002800e-02,2.462600e-02,4.740000e-03, &
     &5.564200e-03,2.174800e-02,2.760000e-02,2.987300e-02,2.413600e-02, &
     &2.760700e-03,3.414200e-03,1.629200e-02,2.216800e-02,2.507100e-02, &
     &2.132100e-02,3.040800e-03,3.742900e-03,1.677100e-02,2.249200e-02, &
     &2.516700e-02,2.102200e-02,3.354100e-03,4.105000e-03,1.728600e-02, &
     &2.276200e-02,2.517900e-02,2.069700e-02,3.703800e-03,4.492400e-03, &
     &1.788200e-02,2.302500e-02,2.512800e-02,2.034400e-02,4.111500e-03, &
     &4.927500e-03,1.856100e-02,2.332100e-02,2.503800e-02,1.996600e-02/
      data  absb(721:1080,7) /                                          &
     &2.316500e-03,2.924300e-03,1.363200e-02,1.851100e-02,2.091100e-02, &
     &1.758200e-02,2.562000e-03,3.224000e-03,1.407800e-02,1.881700e-02, &
     &2.102100e-02,1.735900e-02,2.837800e-03,3.553600e-03,1.456600e-02, &
     &1.908900e-02,2.106200e-02,1.711200e-02,3.150600e-03,3.910500e-03, &
     &1.513400e-02,1.936800e-02,2.105500e-02,1.684300e-02,3.515400e-03, &
     &4.311600e-03,1.578000e-02,1.969000e-02,2.102500e-02,1.655400e-02, &
     &1.943600e-03,2.504300e-03,1.140900e-02,1.544900e-02,1.743900e-02, &
     &1.450900e-02,2.158500e-03,2.777600e-03,1.182200e-02,1.574100e-02, &
     &1.756000e-02,1.434900e-02,2.401800e-03,3.076600e-03,1.227800e-02, &
     &1.601000e-02,1.762500e-02,1.416300e-02,2.680700e-03,3.407400e-03, &
     &1.282100e-02,1.630000e-02,1.765300e-02,1.396100e-02,3.007400e-03, &
     &3.776700e-03,1.342700e-02,1.663500e-02,1.767000e-02,1.374500e-02, &
     &1.632400e-03,2.147200e-03,9.557600e-03,1.289900e-02,1.454600e-02, &
     &1.198900e-02,1.820000e-03,2.394700e-03,9.933700e-03,1.317000e-02, &
     &1.467100e-02,1.187500e-02,2.034100e-03,2.667600e-03,1.036800e-02, &
     &1.343600e-02,1.475400e-02,1.174100e-02,2.282200e-03,2.970000e-03, &
     &1.087300e-02,1.372900e-02,1.481100e-02,1.159200e-02,2.577700e-03, &
     &3.316900e-03,1.145100e-02,1.407100e-02,1.486400e-02,1.142900e-02, &
     &1.356000e-03,1.820500e-03,7.978600e-03,1.074600e-02,1.211600e-02, &
     &9.893700e-03,1.518800e-03,2.043200e-03,8.320900e-03,1.100100e-02, &
     &1.224800e-02,9.811600e-03,1.704700e-03,2.289300e-03,8.718300e-03, &
     &1.125600e-02,1.234600e-02,9.713900e-03,1.922200e-03,2.566200e-03, &
     &9.187700e-03,1.154500e-02,1.242500e-02,9.603400e-03,2.182700e-03, &
     &2.882500e-03,9.721600e-03,1.188000e-02,1.250600e-02,9.479000e-03, &
     &1.124500e-03,1.541500e-03,6.659100e-03,8.947800e-03,1.008700e-02, &
     &8.164200e-03,1.264800e-03,1.740200e-03,6.968800e-03,9.187100e-03, &
     &1.022100e-02,8.105600e-03,1.426600e-03,1.962200e-03,7.330600e-03, &
     &9.430000e-03,1.032800e-02,8.035600e-03,1.616200e-03,2.213200e-03, &
     &7.761400e-03,9.709400e-03,1.042200e-02,7.953800e-03,1.845200e-03, &
     &2.502000e-03,8.254000e-03,1.003000e-02,1.052200e-02,7.859200e-03, &
     &9.321900e-04,1.304200e-03,5.555800e-03,7.450200e-03,8.393000e-03, &
     &6.737300e-03,1.053100e-03,1.481700e-03,5.835900e-03,7.672700e-03, &
     &8.526700e-03,6.697900e-03,1.193200e-03,1.682200e-03,6.166200e-03, &
     &7.901200e-03,8.637100e-03,6.648600e-03,1.359100e-03,1.910100e-03, &
     &6.559400e-03,8.165900e-03,8.740000e-03,6.590000e-03,1.559500e-03, &
     &2.171200e-03,7.014300e-03,8.471100e-03,8.852000e-03,6.519700e-03, &
     &7.665500e-04,1.094800e-03,4.619900e-03,6.192900e-03,6.973800e-03, &
     &5.559000e-03,8.700600e-04,1.251900e-03,4.872500e-03,6.398200e-03, &
     &7.105100e-03,5.535400e-03,9.906701e-04,1.431700e-03,5.171400e-03, &
     &6.609400e-03,7.216700e-03,5.503400e-03,1.133300e-03,1.636100e-03, &
     &5.523800e-03,6.854900e-03,7.322400e-03,5.461500e-03,1.307800e-03, &
     &1.872900e-03,5.939200e-03,7.140400e-03,7.439500e-03,5.409800e-03, &
     &6.271600e-04,9.144500e-04,3.837900e-03,5.142300e-03,5.788500e-03, &
     &4.587900e-03,7.153900e-04,1.052500e-03,4.060800e-03,5.328400e-03, &
     &5.913900e-03,4.575000e-03,8.186800e-04,1.212400e-03,4.326100e-03, &
     &5.522300e-03,6.023700e-03,4.556400e-03,9.407600e-04,1.395100e-03, &
     &4.643900e-03,5.749300e-03,6.130400e-03,4.529100e-03,1.090500e-03, &
     &1.607400e-03,5.018400e-03,6.013200e-03,6.249800e-03,4.493000e-03, &
     &5.122900e-04,7.619300e-04,3.185300e-03,4.267800e-03,4.800700e-03, &
     &3.786700e-03,5.870000e-04,8.830900e-04,3.382200e-03,4.437600e-03, &
     &4.920400e-03,3.783700e-03,6.753200e-04,1.025300e-03,3.617200e-03, &
     &4.613700e-03,5.026300e-03,3.775000e-03,7.799200e-04,1.188600e-03, &
     &3.900100e-03,4.819300e-03,5.130500e-03,3.758200e-03,9.089800e-04, &
     &1.380100e-03,4.237500e-03,5.060200e-03,5.246800e-03,3.733900e-03, &
     &4.164500e-04,6.311000e-04,2.635000e-03,3.535300e-03,3.976900e-03, &
     &3.125600e-03,4.790200e-04,7.363600e-04,2.809100e-03,3.688800e-03, &
     &4.088400e-03,3.128400e-03,5.540700e-04,8.623300e-04,3.015100e-03, &
     &3.848000e-03,4.189000e-03,3.126600e-03,6.435700e-04,1.008300e-03, &
     &3.267700e-03,4.034900e-03,4.289700e-03,3.119500e-03,7.535400e-04, &
     &1.178300e-03,3.568500e-03,4.254400e-03,4.401800e-03,3.106300e-03, &
     &3.360100e-04,5.177700e-04,2.172300e-03,2.919700e-03,3.286000e-03, &
     &2.576000e-03,3.875400e-04,6.079600e-04,2.323900e-03,3.058100e-03, &
     &3.391100e-03,2.584400e-03,4.506500e-04,7.179800e-04,2.502200e-03, &
     &3.201900e-03,3.487500e-03,2.588900e-03,5.261300e-04,8.468200e-04, &
     &2.723800e-03,3.368200e-03,3.581500e-03,2.588400e-03,6.192900e-04, &
     &9.978600e-04,2.989700e-03,3.565800e-03,3.686100e-03,2.582700e-03, &
     &2.708300e-04,4.234700e-04,1.789900e-03,2.408800e-03,2.713600e-03, &
     &2.124400e-03,3.127900e-04,4.999900e-04,1.920600e-03,2.533000e-03, &
     &2.811200e-03,2.136700e-03,3.655000e-04,5.953300e-04,2.074000e-03, &
     &2.661400e-03,2.900200e-03,2.145100e-03,4.289700e-04,7.091300e-04, &
     &2.266200e-03,2.808300e-03,2.987500e-03,2.149700e-03,5.074600e-04, &
     &8.431000e-04,2.499500e-03,2.984100e-03,3.083800e-03,2.149400e-03/
      data  absb(1081:1410,7) /                                         &
     &2.179800e-04,3.452800e-04,1.471000e-03,1.983300e-03,2.237500e-03, &
     &1.752800e-03,2.517700e-04,4.095600e-04,1.585000e-03,2.094300e-03, &
     &2.327300e-03,1.767800e-03,2.956800e-04,4.914400e-04,1.716100e-03, &
     &2.208900e-03,2.409400e-03,1.779100e-03,3.487400e-04,5.910000e-04, &
     &1.881800e-03,2.338000e-03,2.489200e-03,1.787400e-03,4.145800e-04, &
     &7.095100e-04,2.084900e-03,2.493400e-03,2.577200e-03,1.791900e-03, &
     &1.758500e-04,2.818900e-04,1.209300e-03,1.632900e-03,1.844100e-03, &
     &1.443000e-03,2.031900e-04,3.357400e-04,1.308000e-03,1.731300e-03, &
     &1.925600e-03,1.458400e-03,2.395400e-04,4.057600e-04,1.421000e-03, &
     &1.832600e-03,2.001100e-03,1.470800e-03,2.840200e-04,4.927100e-04, &
     &1.564200e-03,1.946800e-03,2.074600e-03,1.481300e-03,3.394300e-04, &
     &5.979000e-04,1.741700e-03,2.085200e-03,2.155500e-03,1.489000e-03, &
     &1.419000e-04,2.299200e-04,9.940400e-04,1.343500e-03,1.518100e-03, &
     &1.185700e-03,1.640400e-04,2.749700e-04,1.078900e-03,1.430400e-03, &
     &1.592100e-03,1.201000e-03,1.940400e-04,3.346000e-04,1.176800e-03, &
     &1.520400e-03,1.661600e-03,1.214400e-03,2.313100e-04,4.101500e-04, &
     &1.300000e-03,1.620700e-03,1.729000e-03,1.225700e-03,2.778000e-04, &
     &5.029200e-04,1.454600e-03,1.743200e-03,1.802400e-03,1.234700e-03, &
     &1.144400e-04,1.870700e-04,8.151000e-04,1.103600e-03,1.248100e-03, &
     &9.744200e-04,1.322200e-04,2.244600e-04,8.896600e-04,1.181000e-03, &
     &1.315300e-03,9.898701e-04,1.568500e-04,2.747900e-04,9.735000e-04, &
     &1.260200e-03,1.378500e-03,1.003100e-03,1.879800e-04,3.399800e-04, &
     &1.078700e-03,1.347900e-03,1.439900e-03,1.014700e-03,2.268500e-04, &
     &4.210300e-04,1.212900e-03,1.455300e-03,1.505800e-03,1.024600e-03, &
     &9.220300e-05,1.517800e-04,6.668400e-04,9.049100e-04,1.024800e-03, &
     &8.009500e-04,1.064500e-04,1.827300e-04,7.318000e-04,9.734500e-04, &
     &1.084800e-03,8.162700e-04,1.264500e-04,2.248000e-04,8.042100e-04, &
     &1.043200e-03,1.142000e-03,8.293500e-04,1.524000e-04,2.804800e-04, &
     &8.933200e-04,1.119600e-03,1.197600e-03,8.410800e-04,1.849300e-04, &
     &3.512000e-04,1.009200e-03,1.213000e-03,1.256800e-03,8.514400e-04, &
     &7.447500e-05,1.234500e-04,5.461800e-04,7.426100e-04,8.418300e-04, &
     &6.553000e-04,8.595900e-05,1.492300e-04,6.025100e-04,8.029400e-04, &
     &8.949000e-04,6.689100e-04,1.022900e-04,1.845400e-04,6.650700e-04, &
     &8.643500e-04,9.462200e-04,6.805200e-04,1.239900e-04,2.320800e-04, &
     &7.415600e-04,9.313300e-04,9.962600e-04,6.911300e-04,1.513200e-04, &
     &2.937800e-04,8.414700e-04,1.012500e-03,1.049400e-03,7.003900e-04, &
     &6.019200e-05,1.004000e-04,4.470000e-04,6.090800e-04,6.911200e-04, &
     &5.344400e-04,6.945700e-05,1.219100e-04,4.955400e-04,6.621600e-04, &
     &7.378900e-04,5.462000e-04,8.280600e-05,1.514700e-04,5.496800e-04, &
     &7.159600e-04,7.835500e-04,5.559500e-04,1.008900e-04,1.918800e-04, &
     &6.150600e-04,7.745100e-04,8.284400e-04,5.649400e-04,1.239100e-04, &
     &2.454900e-04,7.015200e-04,8.452400e-04,8.758900e-04,5.726400e-04, &
     &4.858000e-05,8.144700e-05,3.649900e-04,4.986000e-04,5.667400e-04, &
     &4.356700e-04,5.604700e-05,9.932000e-05,4.064900e-04,5.449200e-04, &
     &6.076000e-04,4.458600e-04,6.689300e-05,1.239100e-04,4.532000e-04, &
     &5.922400e-04,6.481800e-04,4.542200e-04,8.191200e-05,1.581200e-04, &
     &5.092100e-04,6.432600e-04,6.881700e-04,4.616600e-04,1.012600e-04, &
     &2.044300e-04,5.838000e-04,7.045600e-04,7.304100e-04,4.680800e-04, &
     &3.916000e-05,6.584800e-05,2.973400e-04,4.072000e-04,4.640100e-04, &
     &3.548700e-04,4.516900e-05,8.066700e-05,3.330300e-04,4.477100e-04, &
     &4.996000e-04,3.638500e-04,5.392200e-05,1.010700e-04,3.727100e-04, &
     &4.890100e-04,5.355600e-04,3.710000e-04,6.630900e-05,1.298600e-04, &
     &4.206600e-04,5.336300e-04,5.711800e-04,3.771500e-04,8.255800e-05, &
     &1.695700e-04,4.845800e-04,5.866000e-04,6.085400e-04,3.826100e-04, &
     &3.159500e-05,5.325100e-05,2.421400e-04,3.322000e-04,3.797900e-04, &
     &2.889300e-04,3.645300e-05,6.553000e-05,2.725600e-04,3.674400e-04, &
     &4.106800e-04,2.967000e-04,4.352200e-05,8.252200e-05,3.067000e-04, &
     &4.036200e-04,4.423900e-04,3.027600e-04,5.371800e-05,1.067200e-04, &
     &3.477400e-04,4.427300e-04,4.740800e-04,3.078000e-04,6.737700e-05, &
     &1.407000e-04,4.022500e-04,4.886300e-04,5.071700e-04,3.123400e-04, &
     &2.609500e-05,4.455700e-05,2.013500e-04,2.758600e-04,3.150900e-04, &
     &2.354200e-04,3.025100e-05,5.529600e-05,2.277000e-04,3.065200e-04, &
     &3.421000e-04,2.416000e-04,3.636400e-05,7.031500e-05,2.576200e-04, &
     &3.383900e-04,3.700800e-04,2.461500e-04,4.525200e-05,9.195500e-05, &
     &2.941000e-04,3.731800e-04,3.981400e-04,2.496800e-04,5.723900e-05, &
     &1.227100e-04,3.433600e-04,4.146400e-04,4.279400e-04,2.528000e-04/
      data  absb(1:360,8) /                                             &
     &3.059300e-01,3.060100e-01,5.893600e-01,8.820500e-01,1.094700e+00, &
     &1.194300e+00,3.057600e-01,3.058500e-01,5.841600e-01,8.744500e-01, &
     &1.084200e+00,1.194600e+00,3.073000e-01,3.073900e-01,5.783800e-01, &
     &8.662200e-01,1.073600e+00,1.194100e+00,3.114300e-01,3.115300e-01, &
     &5.723600e-01,8.566400e-01,1.062300e+00,1.192600e+00,3.182100e-01, &
     &3.183000e-01,5.667100e-01,8.458900e-01,1.049600e+00,1.188300e+00, &
     &2.654100e-01,2.655200e-01,5.804300e-01,8.835200e-01,1.102600e+00, &
     &1.193100e+00,2.669500e-01,2.670600e-01,5.753900e-01,8.777800e-01, &
     &1.095100e+00,1.193700e+00,2.711200e-01,2.712300e-01,5.700000e-01, &
     &8.710800e-01,1.086900e+00,1.191000e+00,2.780700e-01,2.781800e-01, &
     &5.651400e-01,8.627100e-01,1.076700e+00,1.186700e+00,2.873900e-01, &
     &2.875100e-01,5.612600e-01,8.528000e-01,1.064300e+00,1.180900e+00, &
     &2.317800e-01,2.319100e-01,5.718400e-01,8.769300e-01,1.102200e+00, &
     &1.181300e+00,2.356000e-01,2.357300e-01,5.672400e-01,8.734900e-01, &
     &1.097600e+00,1.180000e+00,2.421900e-01,2.423300e-01,5.627200e-01, &
     &8.682600e-01,1.090400e+00,1.176600e+00,2.507400e-01,2.508800e-01, &
     &5.591900e-01,8.609700e-01,1.080700e+00,1.172000e+00,2.600000e-01, &
     &2.601300e-01,5.569800e-01,8.526100e-01,1.068800e+00,1.165700e+00, &
     &2.041400e-01,2.042900e-01,5.596700e-01,8.637000e-01,1.090400e+00, &
     &1.156200e+00,2.100900e-01,2.102400e-01,5.562500e-01,8.614100e-01, &
     &1.086500e+00,1.155800e+00,2.175300e-01,2.176800e-01,5.535500e-01, &
     &8.565700e-01,1.080000e+00,1.153700e+00,2.258100e-01,2.259500e-01, &
     &5.521000e-01,8.507100e-01,1.071200e+00,1.149700e+00,2.345100e-01, &
     &2.346600e-01,5.516600e-01,8.444500e-01,1.059900e+00,1.144200e+00, &
     &1.811100e-01,1.812700e-01,5.437000e-01,8.406600e-01,1.063300e+00, &
     &1.117300e+00,1.875100e-01,1.876700e-01,5.422500e-01,8.387000e-01, &
     &1.060300e+00,1.118800e+00,1.947800e-01,1.949400e-01,5.418200e-01, &
     &8.352800e-01,1.054700e+00,1.117900e+00,2.022600e-01,2.024200e-01, &
     &5.424200e-01,8.313500e-01,1.046200e+00,1.115300e+00,2.097700e-01, &
     &2.099200e-01,5.440800e-01,8.266500e-01,1.035300e+00,1.110900e+00, &
     &1.603700e-01,1.605400e-01,5.235400e-01,8.074300e-01,1.021400e+00, &
     &1.066500e+00,1.665200e-01,1.666900e-01,5.246800e-01,8.067600e-01, &
     &1.019600e+00,1.069200e+00,1.729000e-01,1.730700e-01,5.265500e-01, &
     &8.047700e-01,1.014700e+00,1.069100e+00,1.793400e-01,1.795100e-01, &
     &5.294300e-01,8.025100e-01,1.006900e+00,1.067500e+00,1.858000e-01, &
     &1.859600e-01,5.321800e-01,7.999600e-01,9.967500e-01,1.064100e+00, &
     &1.414700e-01,1.416500e-01,4.993100e-01,7.657900e-01,9.670600e-01, &
     &1.003600e+00,1.468000e-01,1.469900e-01,5.023500e-01,7.662400e-01, &
     &9.659800e-01,1.006600e+00,1.522500e-01,1.524400e-01,5.065400e-01, &
     &7.661800e-01,9.612400e-01,1.007700e+00,1.577200e-01,1.579100e-01, &
     &5.107400e-01,7.659800e-01,9.536300e-01,1.007200e+00,1.633000e-01, &
     &1.634800e-01,5.143300e-01,7.648200e-01,9.445900e-01,1.004800e+00, &
     &1.241500e-01,1.243500e-01,4.715200e-01,7.170000e-01,9.018000e-01, &
     &9.319400e-01,1.287300e-01,1.289400e-01,4.768200e-01,7.187400e-01, &
     &9.002800e-01,9.359300e-01,1.333200e-01,1.335200e-01,4.822700e-01, &
     &7.202000e-01,8.959200e-01,9.381200e-01,1.380600e-01,1.382600e-01, &
     &4.868900e-01,7.211000e-01,8.900300e-01,9.386500e-01,1.430400e-01, &
     &1.432300e-01,4.909700e-01,7.215700e-01,8.836600e-01,9.377400e-01, &
     &1.082400e-01,1.084500e-01,4.408400e-01,6.623700e-01,8.284000e-01, &
     &8.541600e-01,1.121500e-01,1.123700e-01,4.474100e-01,6.656000e-01, &
     &8.272100e-01,8.588000e-01,1.161000e-01,1.163100e-01,4.532800e-01, &
     &6.684400e-01,8.243300e-01,8.621700e-01,1.203100e-01,1.205200e-01, &
     &4.583100e-01,6.711200e-01,8.210100e-01,8.647000e-01,1.251300e-01, &
     &1.253500e-01,4.622800e-01,6.732100e-01,8.177300e-01,8.668100e-01, &
     &9.413600e-02,9.435600e-02,4.081200e-01,6.055700e-01,7.510200e-01, &
     &7.733400e-01,9.745300e-02,9.768000e-02,4.147900e-01,6.099400e-01, &
     &7.509000e-01,7.790900e-01,1.009700e-01,1.012000e-01,4.207500e-01, &
     &6.144600e-01,7.503900e-01,7.845800e-01,1.050500e-01,1.052700e-01, &
     &4.258300e-01,6.184500e-01,7.503600e-01,7.897700e-01,1.099300e-01, &
     &1.101600e-01,4.299100e-01,6.215600e-01,7.507300e-01,7.951000e-01, &
     &8.134900e-02,8.158400e-02,3.735400e-01,5.479600e-01,6.735600e-01, &
     &6.929100e-01,8.427600e-02,8.451000e-02,3.802100e-01,5.538600e-01, &
     &6.757000e-01,7.006500e-01,8.764000e-02,8.787400e-02,3.859800e-01, &
     &5.594800e-01,6.783800e-01,7.084400e-01,9.178000e-02,9.202100e-02, &
     &3.910200e-01,5.647300e-01,6.817500e-01,7.165100e-01,9.668600e-02, &
     &9.693900e-02,3.953300e-01,5.695000e-01,6.860200e-01,7.245600e-01, &
     &6.999000e-02,7.023700e-02,3.385800e-01,4.921700e-01,5.997700e-01, &
     &6.160200e-01,7.271300e-02,7.295900e-02,3.448300e-01,4.990100e-01, &
     &6.046700e-01,6.257200e-01,7.609200e-02,7.633900e-02,3.505200e-01, &
     &5.058600e-01,6.103900e-01,6.359300e-01,8.027200e-02,8.053100e-02, &
     &3.558500e-01,5.125000e-01,6.172900e-01,6.460200e-01,8.504300e-02, &
     &8.530700e-02,3.609500e-01,5.191400e-01,6.246700e-01,6.547900e-01/
      data  absb(361:720,8) /                                           &
     &6.005800e-02,6.032500e-02,3.040400e-01,4.393100e-01,5.318000e-01, &
     &5.448800e-01,6.280800e-02,6.307000e-02,3.101900e-01,4.472000e-01, &
     &5.392700e-01,5.564700e-01,6.625300e-02,6.651700e-02,3.162000e-01, &
     &4.551500e-01,5.480400e-01,5.679300e-01,7.028600e-02,7.056400e-02, &
     &3.221000e-01,4.631700e-01,5.572900e-01,5.774800e-01,7.463100e-02, &
     &7.490400e-02,3.281800e-01,4.708400e-01,5.653500e-01,5.842800e-01, &
     &5.165900e-02,5.196800e-02,2.713600e-01,3.904400e-01,4.706100e-01, &
     &4.806600e-01,5.445400e-02,5.474900e-02,2.778000e-01,3.992500e-01, &
     &4.806000e-01,4.928000e-01,5.786400e-02,5.816000e-02,2.842700e-01, &
     &4.081800e-01,4.909200e-01,5.028900e-01,6.155100e-02,6.184900e-02, &
     &2.909500e-01,4.168500e-01,4.999800e-01,5.103300e-01,6.543400e-02, &
     &6.572400e-02,2.980600e-01,4.245300e-01,5.071600e-01,5.146900e-01, &
     &4.457400e-02,4.495900e-02,2.412600e-01,3.460900e-01,4.162900e-01, &
     &4.224800e-01,4.737200e-02,4.772700e-02,2.480300e-01,3.554800e-01, &
     &4.272100e-01,4.329100e-01,5.050900e-02,5.085500e-02,2.550500e-01, &
     &3.646400e-01,4.368700e-01,4.406700e-01,5.385700e-02,5.418700e-02, &
     &2.624200e-01,3.728100e-01,4.447800e-01,4.453100e-01,5.727500e-02, &
     &5.758900e-02,2.702900e-01,3.799700e-01,4.505500e-01,4.465100e-01, &
     &3.859500e-02,3.908300e-02,2.140900e-01,3.062600e-01,3.675800e-01, &
     &3.687000e-01,4.125000e-02,4.170100e-02,2.211500e-01,3.155200e-01, &
     &3.775600e-01,3.766400e-01,4.409000e-02,4.451000e-02,2.285800e-01, &
     &3.239100e-01,3.857900e-01,3.814400e-01,4.700600e-02,4.739100e-02, &
     &2.363800e-01,3.313600e-01,3.919300e-01,3.829900e-01,5.005400e-02, &
     &5.040200e-02,2.445200e-01,3.379100e-01,3.958000e-01,3.818600e-01, &
     &3.347600e-02,3.409800e-02,1.898500e-01,2.704400e-01,3.231000e-01, &
     &3.191000e-01,3.590500e-02,3.647300e-02,1.971000e-01,2.788100e-01, &
     &3.314700e-01,3.240900e-01,3.842000e-02,3.893300e-02,2.046800e-01, &
     &2.862900e-01,3.377500e-01,3.261100e-01,4.104300e-02,4.150200e-02, &
     &2.126100e-01,2.928400e-01,3.418700e-01,3.258400e-01,4.376400e-02, &
     &4.416300e-02,2.206900e-01,2.987900e-01,3.441400e-01,3.238200e-01, &
     &2.905900e-02,2.983300e-02,1.683100e-01,2.378900e-01,2.822800e-01, &
     &2.733000e-01,3.123600e-02,3.193400e-02,1.755400e-01,2.452400e-01, &
     &2.886100e-01,2.758300e-01,3.347300e-02,3.409500e-02,1.831400e-01, &
     &2.516600e-01,2.929700e-01,2.762800e-01,3.582900e-02,3.637000e-02, &
     &1.909900e-01,2.574300e-01,2.957300e-01,2.752600e-01,3.834200e-02, &
     &3.880600e-02,1.988900e-01,2.629100e-01,2.975300e-01,2.730800e-01, &
     &2.521500e-02,2.614400e-02,1.491900e-01,2.084100e-01,2.447900e-01, &
     &2.319800e-01,2.714400e-02,2.797900e-02,1.563400e-01,2.146200e-01, &
     &2.494000e-01,2.331100e-01,2.916900e-02,2.990700e-02,1.638000e-01, &
     &2.202000e-01,2.525000e-01,2.329100e-01,3.133900e-02,3.197500e-02, &
     &1.714500e-01,2.256000e-01,2.548400e-01,2.316900e-01,3.371000e-02, &
     &3.424800e-02,1.789700e-01,2.312200e-01,2.568100e-01,2.296800e-01, &
     &2.190800e-02,2.298800e-02,1.323400e-01,1.817900e-01,2.109800e-01, &
     &1.956700e-01,2.364400e-02,2.461700e-02,1.393200e-01,1.871200e-01, &
     &2.143800e-01,1.961400e-01,2.549300e-02,2.634500e-02,1.465500e-01, &
     &1.923700e-01,2.170500e-01,1.957000e-01,2.751800e-02,2.825200e-02, &
     &1.538000e-01,1.979000e-01,2.194800e-01,1.945500e-01,2.977300e-02, &
     &3.038700e-02,1.609800e-01,2.038300e-01,2.219000e-01,1.928600e-01, &
     &1.904500e-02,2.026100e-02,1.175200e-01,1.581200e-01,1.811000e-01, &
     &1.644800e-01,2.062600e-02,2.172400e-02,1.242300e-01,1.630700e-01, &
     &1.839700e-01,1.646400e-01,2.233600e-02,2.330200e-02,1.311400e-01, &
     &1.683900e-01,1.866400e-01,1.641800e-01,2.426600e-02,2.509300e-02, &
     &1.381100e-01,1.742100e-01,1.893800e-01,1.632500e-01,2.646600e-02, &
     &2.716400e-02,1.451300e-01,1.804800e-01,1.923800e-01,1.621100e-01, &
     &1.655600e-02,1.789200e-02,1.042900e-01,1.373600e-01,1.551600e-01, &
     &1.378900e-01,1.799600e-02,1.921000e-02,1.107200e-01,1.423600e-01, &
     &1.579400e-01,1.379700e-01,1.960800e-02,2.068100e-02,1.173900e-01, &
     &1.478800e-01,1.608100e-01,1.376400e-01,2.146400e-02,2.238700e-02, &
     &1.242100e-01,1.539600e-01,1.639500e-01,1.370600e-01,2.359400e-02, &
     &2.437900e-02,1.312600e-01,1.604800e-01,1.675600e-01,1.364500e-01, &
     &1.431900e-02,1.575800e-02,9.220400e-02,1.192500e-01,1.328600e-01, &
     &1.154800e-01,1.565200e-02,1.697800e-02,9.839900e-02,1.243300e-01, &
     &1.356700e-01,1.156400e-01,1.716900e-02,1.835000e-02,1.048700e-01, &
     &1.300300e-01,1.387900e-01,1.155400e-01,1.894400e-02,1.997500e-02, &
     &1.116700e-01,1.362900e-01,1.423600e-01,1.153400e-01,2.093800e-02, &
     &2.182400e-02,1.187700e-01,1.429400e-01,1.465100e-01,1.152200e-01, &
     &1.230400e-02,1.382900e-02,8.112000e-02,1.033400e-01,1.136600e-01, &
     &9.668600e-02,1.351700e-02,1.494200e-02,8.708200e-02,1.085000e-01, &
     &1.166000e-01,9.698100e-02,1.493900e-02,1.623200e-02,9.343900e-02, &
     &1.143100e-01,1.199500e-01,9.708500e-02,1.660400e-02,1.775400e-02, &
     &1.002000e-01,1.206100e-01,1.238400e-01,9.724500e-02,1.845800e-02, &
     &1.945800e-02,1.073200e-01,1.274100e-01,1.284000e-01,9.761100e-02/
      data  absb(721:1080,8) /                                          &
     &1.044100e-02,1.203700e-02,7.073300e-02,8.910400e-02,9.700600e-02, &
     &8.085300e-02,1.153800e-02,1.305500e-02,7.644400e-02,9.422700e-02, &
     &1.000200e-01,8.126100e-02,1.284000e-02,1.424700e-02,8.265300e-02, &
     &9.999200e-02,1.035100e-01,8.158700e-02,1.435500e-02,1.563400e-02, &
     &8.931200e-02,1.062900e-01,1.076100e-01,8.202200e-02,1.605900e-02, &
     &1.718800e-02,9.639400e-02,1.131600e-01,1.124000e-01,8.273100e-02, &
     &8.864500e-03,1.050100e-02,6.169800e-02,7.690800e-02,8.288300e-02, &
     &6.764200e-02,9.855400e-03,1.144100e-02,6.721300e-02,8.195400e-02, &
     &8.593100e-02,6.815000e-02,1.104100e-02,1.254000e-02,7.325800e-02, &
     &8.764200e-02,8.950600e-02,6.866700e-02,1.243000e-02,1.381700e-02, &
     &7.980100e-02,9.393600e-02,9.378200e-02,6.933900e-02,1.398300e-02, &
     &1.523500e-02,8.681400e-02,1.008300e-01,9.874200e-02,7.031900e-02, &
     &7.540400e-03,9.187400e-03,5.390600e-02,6.649500e-02,7.090200e-02, &
     &5.665700e-02,8.434000e-03,1.006100e-02,5.924500e-02,7.143500e-02, &
     &7.397900e-02,5.726100e-02,9.524200e-03,1.108900e-02,6.513200e-02, &
     &7.704800e-02,7.763600e-02,5.794300e-02,1.078100e-02,1.225900e-02, &
     &7.154900e-02,8.332600e-02,8.200400e-02,5.882300e-02,1.221300e-02, &
     &1.357000e-02,7.848800e-02,9.023400e-02,8.713900e-02,6.004500e-02, &
     &6.348000e-03,7.984100e-03,4.670700e-02,5.715400e-02,6.047800e-02, &
     &4.730900e-02,7.141600e-03,8.787600e-03,5.179900e-02,6.189200e-02, &
     &6.350400e-02,4.796900e-02,8.111300e-03,9.727400e-03,5.748400e-02, &
     &6.735000e-02,6.714000e-02,4.871800e-02,9.246500e-03,1.080100e-02, &
     &6.370700e-02,7.351100e-02,7.149700e-02,4.967600e-02,1.054400e-02, &
     &1.200100e-02,7.050500e-02,8.036800e-02,7.667400e-02,5.098100e-02, &
     &5.339100e-03,6.938300e-03,4.042100e-02,4.910400e-02,5.156700e-02, &
     &3.949500e-02,6.042000e-03,7.678500e-03,4.526000e-02,5.361700e-02, &
     &5.452300e-02,4.017400e-02,6.901700e-03,8.538900e-03,5.072600e-02, &
     &5.888600e-02,5.810600e-02,4.095000e-02,7.921500e-03,9.528100e-03, &
     &5.675800e-02,6.489400e-02,6.242500e-02,4.195300e-02,9.095800e-03, &
     &1.063200e-02,6.338000e-02,7.166500e-02,6.757500e-02,4.329400e-02, &
     &4.487400e-03,6.027700e-03,3.497300e-02,4.218100e-02,4.397200e-02, &
     &3.297600e-02,5.108400e-03,6.711700e-03,3.956900e-02,4.648100e-02, &
     &4.683800e-02,3.365600e-02,5.877400e-03,7.509200e-03,4.479300e-02, &
     &5.153400e-02,5.034900e-02,3.444000e-02,6.790600e-03,8.422700e-03, &
     &5.063100e-02,5.738400e-02,5.462000e-02,3.546200e-02,7.852500e-03, &
     &9.446700e-03,5.708200e-02,6.404400e-02,5.971800e-02,3.682400e-02, &
     &3.742200e-03,5.203300e-03,3.002400e-02,3.602200e-02,3.735800e-02, &
     &2.748600e-02,4.285500e-03,5.831600e-03,3.434400e-02,4.007000e-02, &
     &4.008900e-02,2.815400e-02,4.963800e-03,6.566600e-03,3.929600e-02, &
     &4.487000e-02,4.347200e-02,2.892900e-02,5.773600e-03,7.407100e-03, &
     &4.488300e-02,5.047800e-02,4.761400e-02,2.992000e-02,6.726900e-03, &
     &8.354700e-03,5.112600e-02,5.694600e-02,5.260300e-02,3.125900e-02, &
     &3.112300e-03,4.478700e-03,2.562900e-02,3.064500e-02,3.166200e-02, &
     &2.289100e-02,3.581900e-03,5.051000e-03,2.966200e-02,3.440400e-02, &
     &3.421300e-02,2.352500e-02,4.171700e-03,5.721900e-03,3.433700e-02, &
     &3.894100e-02,3.743700e-02,2.427400e-02,4.887400e-03,6.499700e-03, &
     &3.965100e-02,4.427800e-02,4.143100e-02,2.522900e-02,5.737700e-03, &
     &7.372600e-03,4.564900e-02,5.051100e-02,4.626500e-02,2.652600e-02, &
     &2.585300e-03,3.851300e-03,2.182300e-02,2.602600e-02,2.680400e-02, &
     &1.905800e-02,2.988800e-03,4.371900e-03,2.556300e-02,2.950200e-02, &
     &2.918200e-02,1.966800e-02,3.503700e-03,4.983200e-03,2.995700e-02, &
     &3.376300e-02,3.221300e-02,2.037900e-02,4.132200e-03,5.699500e-03, &
     &3.500000e-02,3.882400e-02,3.603200e-02,2.128600e-02,4.889200e-03, &
     &6.506000e-03,4.074100e-02,4.479300e-02,4.069900e-02,2.253300e-02, &
     &2.133100e-03,3.290900e-03,1.846100e-02,2.199600e-02,2.262300e-02, &
     &1.585100e-02,2.481500e-03,3.768600e-03,2.189300e-02,2.518100e-02, &
     &2.480500e-02,1.641800e-02,2.925500e-03,4.322400e-03,2.599200e-02, &
     &2.913500e-02,2.762000e-02,1.708200e-02,3.477300e-03,4.979400e-03, &
     &3.075400e-02,3.390500e-02,3.123300e-02,1.794200e-02,4.143900e-03, &
     &5.724000e-03,3.620900e-02,3.957900e-02,3.570500e-02,1.912400e-02, &
     &1.748900e-03,2.791700e-03,1.543900e-02,1.842200e-02,1.897800e-02, &
     &1.313400e-02,2.042800e-03,3.223400e-03,1.854100e-02,2.130200e-02, &
     &2.095200e-02,1.366100e-02,2.419200e-03,3.722300e-03,2.231400e-02, &
     &2.492700e-02,2.352500e-02,1.427300e-02,2.896900e-03,4.317100e-03, &
     &2.676400e-02,2.935600e-02,2.687400e-02,1.505800e-02,3.480700e-03, &
     &5.000600e-03,3.190600e-02,3.469300e-02,3.109400e-02,1.614200e-02, &
     &1.432700e-03,2.361800e-03,1.285100e-02,1.537200e-02,1.588500e-02, &
     &1.088300e-02,1.678500e-03,2.749500e-03,1.562600e-02,1.795000e-02, &
     &1.765400e-02,1.136600e-02,1.996700e-03,3.198600e-03,1.906900e-02, &
     &2.125200e-02,1.998700e-02,1.192200e-02,2.406700e-03,3.735000e-03, &
     &2.320300e-02,2.533900e-02,2.306600e-02,1.264000e-02,2.915600e-03, &
     &4.359700e-03,2.803500e-02,3.033500e-02,2.701000e-02,1.363500e-02/
      data  absb(1081:1410,8) /                                         &
     &1.168900e-03,1.988300e-03,1.064400e-02,1.277400e-02,1.325700e-02, &
     &9.010200e-03,1.377800e-03,2.338000e-03,1.310000e-02,1.505400e-02, &
     &1.483000e-02,9.452800e-03,1.643700e-03,2.741700e-03,1.621300e-02, &
     &1.804200e-02,1.692800e-02,9.961200e-03,1.994000e-03,3.223600e-03, &
     &2.002400e-02,2.180000e-02,1.973900e-02,1.062000e-02,2.434600e-03, &
     &3.794200e-03,2.454800e-02,2.644000e-02,2.339600e-02,1.153400e-02, &
     &9.560700e-04,1.675300e-03,8.816700e-03,1.061200e-02,1.105200e-02, &
     &7.437300e-03,1.131600e-03,1.989700e-03,1.098300e-02,1.262100e-02, &
     &1.245600e-02,7.836800e-03,1.356500e-03,2.353700e-03,1.379000e-02, &
     &1.532000e-02,1.434600e-02,8.291800e-03,1.656300e-03,2.788800e-03, &
     &1.729500e-02,1.878000e-02,1.691500e-02,8.883200e-03,2.037900e-03, &
     &3.308500e-03,2.152400e-02,2.309200e-02,2.030500e-02,9.714400e-03, &
     &7.825000e-04,1.409200e-03,7.289600e-03,8.796500e-03,9.193000e-03, &
     &6.125200e-03,9.296300e-04,1.691700e-03,9.185600e-03,1.055600e-02, &
     &1.044200e-02,6.481800e-03,1.119900e-03,2.020500e-03,1.170600e-02, &
     &1.298100e-02,1.214600e-02,6.889900e-03,1.375400e-03,2.411600e-03, &
     &1.491000e-02,1.615700e-02,1.448400e-02,7.415100e-03,1.705700e-03, &
     &2.885000e-03,1.884800e-02,2.016200e-02,1.761700e-02,8.157100e-03, &
     &6.374000e-04,1.179500e-03,6.005800e-03,7.269400e-03,7.623100e-03, &
     &5.041300e-03,7.629200e-04,1.434500e-03,7.647300e-03,8.797600e-03, &
     &8.727400e-03,5.362100e-03,9.227600e-04,1.730100e-03,9.888400e-03, &
     &1.094900e-02,1.025000e-02,5.726200e-03,1.139000e-03,2.081700e-03, &
     &1.279700e-02,1.384200e-02,1.236700e-02,6.191100e-03,1.424000e-03, &
     &2.509900e-03,1.643800e-02,1.754900e-02,1.524800e-02,6.852800e-03, &
     &5.173200e-04,9.817800e-04,4.929100e-03,5.986100e-03,6.301300e-03, &
     &4.147800e-03,6.231900e-04,1.210100e-03,6.334200e-03,7.298200e-03, &
     &7.266800e-03,4.435500e-03,7.589600e-04,1.477200e-03,8.307300e-03, &
     &9.188400e-03,8.616600e-03,4.761500e-03,9.403200e-04,1.792300e-03, &
     &1.092600e-02,1.179500e-02,1.052200e-02,5.176000e-03,1.185500e-03, &
     &2.177900e-03,1.426700e-02,1.521100e-02,1.315100e-02,5.767500e-03, &
     &4.209900e-04,8.189600e-04,4.058700e-03,4.941400e-03,5.212200e-03, &
     &3.395400e-03,5.107200e-04,1.023200e-03,5.265900e-03,6.069200e-03, &
     &6.057700e-03,3.646100e-03,6.263000e-04,1.264000e-03,7.001000e-03, &
     &7.731600e-03,7.254500e-03,3.926900e-03,7.806500e-04,1.549800e-03, &
     &9.360200e-03,1.008000e-02,8.977900e-03,4.279800e-03,9.913300e-04, &
     &1.897600e-03,1.242700e-02,1.323100e-02,1.138800e-02,4.788100e-03, &
     &3.426400e-04,6.819600e-04,3.341800e-03,4.078600e-03,4.307700e-03, &
     &2.769100e-03,4.182700e-04,8.640700e-04,4.377200e-03,5.043800e-03, &
     &5.043900e-03,2.983600e-03,5.165100e-04,1.080900e-03,5.897700e-03, &
     &6.500300e-03,6.100700e-03,3.220800e-03,6.475500e-04,1.339400e-03, &
     &8.014300e-03,8.608400e-03,7.658500e-03,3.514300e-03,8.291300e-04, &
     &1.655300e-03,1.082100e-02,1.150400e-02,9.866800e-03,3.938300e-03, &
     &2.780300e-04,5.648700e-04,2.742000e-03,3.356800e-03,3.549600e-03, &
     &2.254300e-03,3.412100e-04,7.262200e-04,3.622800e-03,4.178100e-03, &
     &4.186200e-03,2.438200e-03,4.244900e-04,9.214900e-04,4.946900e-03, &
     &5.441300e-03,5.111600e-03,2.638700e-03,5.359100e-04,1.154700e-03, &
     &6.831600e-03,7.320600e-03,6.507800e-03,2.883000e-03,6.920600e-04, &
     &1.441300e-03,9.386500e-03,9.961300e-03,8.522300e-03,3.234400e-03, &
     &2.250400e-04,4.650000e-04,2.240300e-03,2.754300e-03,2.916600e-03, &
     &1.832300e-03,2.779800e-04,6.078300e-04,2.985100e-03,3.449100e-03, &
     &3.462800e-03,1.989700e-03,3.475300e-04,7.822500e-04,4.131200e-03, &
     &4.535200e-03,4.265700e-03,2.159300e-03,4.420200e-04,9.927200e-04, &
     &5.797300e-03,6.195100e-03,5.506000e-03,2.362800e-03,5.755800e-04, &
     &1.251700e-03,8.105800e-03,8.587200e-03,7.336000e-03,2.652200e-03, &
     &1.822800e-04,3.820800e-04,1.830800e-03,2.261300e-03,2.397000e-03, &
     &1.488100e-03,2.263500e-04,5.077300e-04,2.462500e-03,2.850100e-03, &
     &2.864700e-03,1.621900e-03,2.851600e-04,6.641200e-04,3.451900e-03, &
     &3.783000e-03,3.559200e-03,1.764200e-03,3.653800e-04,8.544400e-04, &
     &4.923000e-03,5.245100e-03,4.658000e-03,1.933600e-03,4.791100e-04, &
     &1.088600e-03,7.007000e-03,7.406900e-03,6.320800e-03,2.171500e-03, &
     &1.531600e-04,3.300900e-04,1.569700e-03,1.926700e-03,2.028700e-03, &
     &1.220300e-03,1.917400e-04,4.447900e-04,2.148300e-03,2.464600e-03, &
     &2.452100e-03,1.330100e-03,2.439200e-04,5.896700e-04,3.069000e-03, &
     &3.334100e-03,3.101700e-03,1.448100e-03,3.159400e-04,7.676900e-04, &
     &4.454500e-03,4.718000e-03,4.152300e-03,1.588400e-03,4.193400e-04, &
     &9.885899e-04,6.443000e-03,6.795100e-03,5.762200e-03,1.786700e-03/
      data  absb(1:360,9) /                                             &
     &2.164000e+00,2.163000e+00,1.903700e+00,1.991400e+00,2.150700e+00, &
     &2.192400e+00,2.178000e+00,2.177000e+00,1.904300e+00,1.969200e+00, &
     &2.118300e+00,2.170200e+00,2.186300e+00,2.185300e+00,1.900400e+00, &
     &1.944300e+00,2.082200e+00,2.153300e+00,2.190800e+00,2.189800e+00, &
     &1.893900e+00,1.918300e+00,2.044000e+00,2.139000e+00,2.190500e+00, &
     &2.189500e+00,1.883600e+00,1.890200e+00,2.004200e+00,2.125500e+00, &
     &1.984700e+00,1.983800e+00,1.830300e+00,2.035300e+00,2.259000e+00, &
     &2.308800e+00,1.993400e+00,1.992500e+00,1.825000e+00,2.009100e+00, &
     &2.223100e+00,2.280100e+00,1.997600e+00,1.996700e+00,1.817000e+00, &
     &1.980200e+00,2.184000e+00,2.256600e+00,1.997400e+00,1.996500e+00, &
     &1.805300e+00,1.949500e+00,2.143100e+00,2.237200e+00,1.993900e+00, &
     &1.993000e+00,1.790400e+00,1.917700e+00,2.100400e+00,2.219200e+00, &
     &1.788900e+00,1.788200e+00,1.754700e+00,2.077900e+00,2.357300e+00, &
     &2.429000e+00,1.792800e+00,1.792000e+00,1.745200e+00,2.048600e+00, &
     &2.318900e+00,2.403700e+00,1.792800e+00,1.792000e+00,1.733000e+00, &
     &2.017100e+00,2.279000e+00,2.377500e+00,1.791700e+00,1.790900e+00, &
     &1.718200e+00,1.983800e+00,2.236600e+00,2.352800e+00,1.790700e+00, &
     &1.789900e+00,1.701000e+00,1.949500e+00,2.193400e+00,2.331700e+00, &
     &1.586900e+00,1.586300e+00,1.688300e+00,2.119300e+00,2.445500e+00, &
     &2.549200e+00,1.587400e+00,1.586800e+00,1.675000e+00,2.088100e+00, &
     &2.408700e+00,2.525900e+00,1.587900e+00,1.587300e+00,1.659600e+00, &
     &2.055900e+00,2.369400e+00,2.500600e+00,1.589300e+00,1.588600e+00, &
     &1.642000e+00,2.022100e+00,2.327500e+00,2.475800e+00,1.591500e+00, &
     &1.590800e+00,1.622500e+00,1.986000e+00,2.283700e+00,2.453100e+00, &
     &1.391100e+00,1.390600e+00,1.635700e+00,2.155100e+00,2.527000e+00, &
     &2.655000e+00,1.392400e+00,1.391900e+00,1.619700e+00,2.125100e+00, &
     &2.491400e+00,2.634200e+00,1.394800e+00,1.394300e+00,1.601600e+00, &
     &2.092700e+00,2.452900e+00,2.610400e+00,1.400100e+00,1.399500e+00, &
     &1.582400e+00,2.057300e+00,2.411800e+00,2.586200e+00,1.408900e+00, &
     &1.408300e+00,1.563200e+00,2.020200e+00,2.368500e+00,2.562500e+00, &
     &1.210900e+00,1.210400e+00,1.596400e+00,2.181400e+00,2.595200e+00, &
     &2.738900e+00,1.214000e+00,1.213600e+00,1.578400e+00,2.152500e+00, &
     &2.561600e+00,2.720900e+00,1.220800e+00,1.220400e+00,1.559500e+00, &
     &2.120100e+00,2.524700e+00,2.700500e+00,1.232200e+00,1.231800e+00, &
     &1.540700e+00,2.084900e+00,2.485000e+00,2.678400e+00,1.247700e+00, &
     &1.247200e+00,1.523000e+00,2.047800e+00,2.444000e+00,2.655300e+00, &
     &1.048700e+00,1.048400e+00,1.564900e+00,2.196800e+00,2.640900e+00, &
     &2.796300e+00,1.056000e+00,1.055700e+00,1.547400e+00,2.168700e+00, &
     &2.610800e+00,2.782900e+00,1.068500e+00,1.068200e+00,1.529200e+00, &
     &2.136800e+00,2.578200e+00,2.764900e+00,1.085900e+00,1.085500e+00, &
     &1.512100e+00,2.101900e+00,2.543800e+00,2.744500e+00,1.106500e+00, &
     &1.106200e+00,1.497500e+00,2.066100e+00,2.506200e+00,2.722200e+00, &
     &9.082700e-01,9.080500e-01,1.534100e+00,2.195600e+00,2.663200e+00, &
     &2.824200e+00,9.206400e-01,9.204000e-01,1.517200e+00,2.168700e+00, &
     &2.640000e+00,2.814500e+00,9.384400e-01,9.381900e-01,1.501600e+00, &
     &2.138800e+00,2.612900e+00,2.800000e+00,9.601300e-01,9.598600e-01, &
     &1.488500e+00,2.107100e+00,2.581400e+00,2.782800e+00,9.843000e-01, &
     &9.840000e-01,1.477100e+00,2.074100e+00,2.545400e+00,2.763600e+00, &
     &7.899300e-01,7.897800e-01,1.498600e+00,2.173300e+00,2.662300e+00, &
     &2.817900e+00,8.066700e-01,8.065000e-01,1.484800e+00,2.149600e+00, &
     &2.644600e+00,2.812900e+00,8.280200e-01,8.278400e-01,1.473300e+00, &
     &2.123500e+00,2.620800e+00,2.802900e+00,8.523200e-01,8.521100e-01, &
     &1.463900e+00,2.096000e+00,2.591300e+00,2.789800e+00,8.789900e-01, &
     &8.787600e-01,1.456600e+00,2.068100e+00,2.557600e+00,2.772700e+00, &
     &6.921700e-01,6.920700e-01,1.456700e+00,2.129400e+00,2.632000e+00, &
     &2.778900e+00,7.122000e-01,7.120900e-01,1.447800e+00,2.110600e+00, &
     &2.617300e+00,2.778300e+00,7.356600e-01,7.355300e-01,1.441300e+00, &
     &2.089700e+00,2.596300e+00,2.772200e+00,7.612800e-01,7.611300e-01, &
     &1.436300e+00,2.068200e+00,2.570300e+00,2.762400e+00,7.857400e-01, &
     &7.855500e-01,1.432700e+00,2.047700e+00,2.540100e+00,2.749200e+00, &
     &6.100800e-01,6.100300e-01,1.408300e+00,2.068100e+00,2.570500e+00, &
     &2.708300e+00,6.319800e-01,6.319200e-01,1.405100e+00,2.054800e+00, &
     &2.559300e+00,2.711700e+00,6.554300e-01,6.553500e-01,1.404000e+00, &
     &2.040300e+00,2.542700e+00,2.710200e+00,6.783700e-01,6.782600e-01, &
     &1.404100e+00,2.026300e+00,2.521300e+00,2.706000e+00,7.003000e-01, &
     &7.001600e-01,1.405000e+00,2.012700e+00,2.496100e+00,2.699400e+00, &
     &5.403300e-01,5.403300e-01,1.354600e+00,1.989900e+00,2.482200e+00, &
     &2.608400e+00,5.613900e-01,5.613800e-01,1.357700e+00,1.983600e+00, &
     &2.475900e+00,2.617400e+00,5.824500e-01,5.824200e-01,1.361800e+00, &
     &1.977000e+00,2.464900e+00,2.623200e+00,6.024100e-01,6.023300e-01, &
     &1.366400e+00,1.970700e+00,2.449800e+00,2.626800e+00,6.216500e-01, &
     &6.215500e-01,1.369900e+00,1.964600e+00,2.432100e+00,2.627700e+00/
      data  absb(361:720,9) /                                           &
     &4.783200e-01,4.783600e-01,1.297400e+00,1.900000e+00,2.373000e+00, &
     &2.487500e+00,4.973300e-01,4.973500e-01,1.305700e+00,1.901400e+00, &
     &2.373400e+00,2.503800e+00,5.152300e-01,5.152200e-01,1.314600e+00, &
     &1.903100e+00,2.369900e+00,2.518300e+00,5.325600e-01,5.325100e-01, &
     &1.322800e+00,1.905100e+00,2.363700e+00,2.532000e+00,5.496800e-01, &
     &5.496100e-01,1.329200e+00,1.906800e+00,2.356100e+00,2.543800e+00, &
     &4.220100e-01,4.220700e-01,1.236400e+00,1.802900e+00,2.250700e+00, &
     &2.353300e+00,4.380400e-01,4.380900e-01,1.249800e+00,1.812600e+00, &
     &2.259700e+00,2.378800e+00,4.535400e-01,4.535600e-01,1.263200e+00, &
     &1.822900e+00,2.265700e+00,2.404700e+00,4.690600e-01,4.690400e-01, &
     &1.274600e+00,1.833300e+00,2.270600e+00,2.430400e+00,4.849700e-01, &
     &4.849400e-01,1.283900e+00,1.842900e+00,2.274400e+00,2.454400e+00, &
     &3.703600e-01,3.704500e-01,1.173400e+00,1.702900e+00,2.123300e+00, &
     &2.215200e+00,3.839800e-01,3.840600e-01,1.191800e+00,1.721800e+00, &
     &2.142000e+00,2.252700e+00,3.978700e-01,3.979100e-01,1.208500e+00, &
     &1.741200e+00,2.159600e+00,2.291700e+00,4.122700e-01,4.122900e-01, &
     &1.223500e+00,1.760400e+00,2.176400e+00,2.330700e+00,4.278000e-01, &
     &4.277900e-01,1.235800e+00,1.778500e+00,2.192400e+00,2.367800e+00, &
     &3.238400e-01,3.239600e-01,1.111100e+00,1.605000e+00,1.996600e+00, &
     &2.081400e+00,3.360300e-01,3.361300e-01,1.133200e+00,1.633200e+00, &
     &2.027100e+00,2.132400e+00,3.488100e-01,3.488700e-01,1.153600e+00, &
     &1.662200e+00,2.057300e+00,2.185000e+00,3.626800e-01,3.627300e-01, &
     &1.172000e+00,1.690000e+00,2.087000e+00,2.237300e+00,3.780400e-01, &
     &3.780600e-01,1.187700e+00,1.717300e+00,2.116200e+00,2.286900e+00, &
     &2.831200e-01,2.832600e-01,1.050800e+00,1.513000e+00,1.878000e+00, &
     &1.958900e+00,2.943400e-01,2.944500e-01,1.076600e+00,1.551100e+00, &
     &1.921000e+00,2.024300e+00,3.065200e-01,3.066100e-01,1.100900e+00, &
     &1.588900e+00,1.964200e+00,2.090700e+00,3.201600e-01,3.202300e-01, &
     &1.122600e+00,1.626100e+00,2.007100e+00,2.154800e+00,3.357100e-01, &
     &3.357700e-01,1.142100e+00,1.661500e+00,2.048500e+00,2.215100e+00, &
     &2.476600e-01,2.478200e-01,9.943300e-01,1.430400e+00,1.771500e+00, &
     &1.851400e+00,2.583700e-01,2.585000e-01,1.024100e+00,1.477500e+00, &
     &1.827100e+00,1.930200e+00,2.704500e-01,2.705600e-01,1.051700e+00, &
     &1.524400e+00,1.883300e+00,2.008400e+00,2.842700e-01,2.843600e-01, &
     &1.077300e+00,1.570100e+00,1.938000e+00,2.082900e+00,3.001300e-01, &
     &3.002100e-01,1.100500e+00,1.613000e+00,1.989700e+00,2.153000e+00, &
     &2.171800e-01,2.173500e-01,9.433600e-01,1.359200e+00,1.680200e+00, &
     &1.762300e+00,2.277300e-01,2.278700e-01,9.766700e-01,1.414700e+00, &
     &1.748000e+00,1.853000e+00,2.399500e-01,2.400700e-01,1.008000e+00, &
     &1.469900e+00,1.815100e+00,1.940900e+00,2.541400e-01,2.542400e-01, &
     &1.037100e+00,1.522700e+00,1.879500e+00,2.025100e+00,2.701800e-01, &
     &2.702800e-01,1.064400e+00,1.571700e+00,1.939700e+00,2.103800e+00, &
     &1.912600e-01,1.914600e-01,8.985300e-01,1.299700e+00,1.604600e+00, &
     &1.690100e+00,2.019300e-01,2.020900e-01,9.354000e-01,1.363200e+00, &
     &1.682900e+00,1.790100e+00,2.144500e-01,2.145900e-01,9.703600e-01, &
     &1.425100e+00,1.759300e+00,1.887600e+00,2.289000e-01,2.290200e-01, &
     &1.003200e+00,1.483400e+00,1.831900e+00,1.980100e+00,2.447600e-01, &
     &2.448800e-01,1.034100e+00,1.537300e+00,1.899500e+00,2.066200e+00, &
     &1.694000e-01,1.696200e-01,8.604000e-01,1.251600e+00,1.544000e+00, &
     &1.633600e+00,1.804000e-01,1.805800e-01,9.006900e-01,1.321700e+00, &
     &1.631300e+00,1.742700e+00,1.932200e-01,1.933800e-01,9.390500e-01, &
     &1.388700e+00,1.715500e+00,1.848300e+00,2.075900e-01,2.077400e-01, &
     &9.752500e-01,1.451800e+00,1.795000e+00,1.947700e+00,2.228700e-01, &
     &2.230000e-01,1.009500e+00,1.510300e+00,1.868800e+00,2.039800e+00, &
     &1.507600e-01,1.510100e-01,8.274900e-01,1.211500e+00,1.494400e+00, &
     &1.586200e+00,1.620300e-01,1.622400e-01,8.709700e-01,1.286700e+00, &
     &1.589100e+00,1.703400e+00,1.749200e-01,1.751000e-01,9.124400e-01, &
     &1.358400e+00,1.680000e+00,1.815200e+00,1.888400e-01,1.890000e-01, &
     &9.516400e-01,1.425700e+00,1.765400e+00,1.920700e+00,2.034700e-01, &
     &2.036100e-01,9.885800e-01,1.488200e+00,1.844100e+00,2.018200e+00, &
     &1.341000e-01,1.344200e-01,7.962100e-01,1.172600e+00,1.447000e+00, &
     &1.540200e+00,1.454200e-01,1.456700e-01,8.426200e-01,1.252300e+00, &
     &1.548400e+00,1.663600e+00,1.580200e-01,1.582300e-01,8.869800e-01, &
     &1.328300e+00,1.645400e+00,1.781800e+00,1.713500e-01,1.715300e-01, &
     &9.289400e-01,1.399900e+00,1.736100e+00,1.893200e+00,1.854000e-01, &
     &1.855600e-01,9.684100e-01,1.466400e+00,1.819500e+00,1.996700e+00, &
     &1.188500e-01,1.192700e-01,7.645900e-01,1.131800e+00,1.397800e+00, &
     &1.489900e+00,1.299000e-01,1.302200e-01,8.138200e-01,1.215800e+00, &
     &1.505200e+00,1.619500e+00,1.420100e-01,1.422600e-01,8.609400e-01, &
     &1.296200e+00,1.607900e+00,1.744100e+00,1.547800e-01,1.549900e-01, &
     &9.055100e-01,1.372000e+00,1.703900e+00,1.861400e+00,1.683600e-01, &
     &1.685400e-01,9.476500e-01,1.442400e+00,1.792000e+00,1.970100e+00/
      data  absb(721:1080,9) /                                          &
     &1.042800e-01,1.048500e-01,7.289900e-01,1.083500e+00,1.338800e+00, &
     &1.425900e+00,1.148100e-01,1.152500e-01,7.811800e-01,1.171900e+00, &
     &1.452200e+00,1.561600e+00,1.262900e-01,1.266200e-01,8.310800e-01, &
     &1.256600e+00,1.560700e+00,1.692500e+00,1.385100e-01,1.387600e-01, &
     &8.784800e-01,1.337000e+00,1.662400e+00,1.816100e+00,1.515600e-01, &
     &1.517700e-01,9.233900e-01,1.411600e+00,1.755800e+00,1.930900e+00, &
     &9.160500e-02,9.234300e-02,6.961000e-01,1.038800e+00,1.284500e+00, &
     &1.367400e+00,1.015800e-01,1.021500e-01,7.508800e-01,1.131100e+00, &
     &1.403200e+00,1.508700e+00,1.124700e-01,1.128900e-01,8.033900e-01, &
     &1.220000e+00,1.516900e+00,1.645300e+00,1.241700e-01,1.244800e-01, &
     &8.533800e-01,1.304200e+00,1.623600e+00,1.775000e+00,1.367600e-01, &
     &1.370000e-01,9.008300e-01,1.382800e+00,1.721700e+00,1.895200e+00, &
     &8.065600e-02,8.159400e-02,6.660700e-01,9.981500e-01,1.235100e+00, &
     &1.315200e+00,9.006900e-02,9.078600e-02,7.232100e-01,1.094100e+00, &
     &1.358400e+00,1.461700e+00,1.003800e-01,1.009200e-01,7.781400e-01, &
     &1.186400e+00,1.476700e+00,1.603700e+00,1.116000e-01,1.120000e-01, &
     &8.305000e-01,1.274200e+00,1.587900e+00,1.739200e+00,1.238100e-01, &
     &1.241000e-01,8.802600e-01,1.356400e+00,1.690300e+00,1.864200e+00, &
     &7.034300e-02,7.151700e-02,6.325800e-01,9.507400e-01,1.176800e+00, &
     &1.249500e+00,7.910300e-02,8.002000e-02,6.918900e-01,1.050100e+00, &
     &1.304500e+00,1.400300e+00,8.879000e-02,8.949200e-02,7.492500e-01, &
     &1.146100e+00,1.427400e+00,1.547600e+00,9.946100e-02,9.997700e-02, &
     &8.041400e-01,1.237500e+00,1.543400e+00,1.688400e+00,1.111400e-01, &
     &1.115100e-01,8.563300e-01,1.323600e+00,1.650700e+00,1.819100e+00, &
     &6.126600e-02,6.269600e-02,6.002200e-01,9.045000e-01,1.119800e+00, &
     &1.185200e+00,6.944900e-02,7.059300e-02,6.616100e-01,1.007000e+00, &
     &1.251300e+00,1.339900e+00,7.851700e-02,7.940900e-02,7.212100e-01, &
     &1.106300e+00,1.378500e+00,1.491600e+00,8.861000e-02,8.927600e-02, &
     &7.783900e-01,1.201200e+00,1.499000e+00,1.637400e+00,9.977400e-02, &
     &1.002600e-01,8.328400e-01,1.290600e+00,1.610800e+00,1.773700e+00, &
     &5.336000e-02,5.505900e-02,5.696600e-01,8.603800e-01,1.065500e+00, &
     &1.124300e+00,6.099300e-02,6.238200e-02,6.328000e-01,9.656200e-01, &
     &1.200100e+00,1.282300e+00,6.950700e-02,7.061000e-02,6.944500e-01, &
     &1.067900e+00,1.331100e+00,1.438000e+00,7.903200e-02,7.987100e-02, &
     &7.537600e-01,1.165800e+00,1.455500e+00,1.588300e+00,8.968400e-02, &
     &9.030300e-02,8.103100e-01,1.258500e+00,1.571700e+00,1.729800e+00, &
     &4.613600e-02,4.812500e-02,5.370400e-01,8.122000e-01,1.005800e+00, &
     &1.056900e+00,5.316100e-02,5.482300e-02,6.016800e-01,9.198200e-01, &
     &1.143100e+00,1.217700e+00,6.112300e-02,6.247000e-02,6.653200e-01, &
     &1.024900e+00,1.277500e+00,1.377000e+00,7.004900e-02,7.109800e-02, &
     &7.267300e-01,1.125900e+00,1.406000e+00,1.531800e+00,8.011900e-02, &
     &8.090800e-02,7.853400e-01,1.221800e+00,1.526600e+00,1.678600e+00, &
     &3.968500e-02,4.197200e-02,5.041200e-01,7.629600e-01,9.442800e-01, &
     &9.878700e-01,4.615200e-02,4.810300e-02,5.700400e-01,8.724000e-01, &
     &1.083800e+00,1.150800e+00,5.352900e-02,5.514300e-02,6.353600e-01, &
     &9.800200e-01,1.221300e+00,1.313200e+00,6.190100e-02,6.318300e-02, &
     &6.987900e-01,1.084000e+00,1.353600e+00,1.472300e+00,7.135400e-02, &
     &7.234700e-02,7.593900e-01,1.182900e+00,1.478400e+00,1.624200e+00, &
     &3.407600e-02,3.665100e-02,4.723800e-01,7.151100e-01,8.844000e-01, &
     &9.213000e-01,4.002500e-02,4.226000e-02,5.393900e-01,8.258400e-01, &
     &1.025700e+00,1.085800e+00,4.684300e-02,4.873200e-02,6.060700e-01, &
     &9.357000e-01,1.165600e+00,1.250900e+00,5.466300e-02,5.619800e-02, &
     &6.712500e-01,1.042300e+00,1.301300e+00,1.413700e+00,6.356000e-02, &
     &6.477600e-02,7.338100e-01,1.144100e+00,1.429900e+00,1.570500e+00, &
     &2.907400e-02,3.193600e-02,4.402100e-01,6.661700e-01,8.230600e-01, &
     &8.531100e-01,3.451400e-02,3.703400e-02,5.080300e-01,7.777100e-01, &
     &9.653700e-01,1.018400e+00,4.081700e-02,4.298700e-02,5.757900e-01, &
     &8.893300e-01,1.107300e+00,1.185600e+00,4.806500e-02,4.987200e-02, &
     &6.425500e-01,9.982900e-01,1.246000e+00,1.351700e+00,5.642300e-02, &
     &5.788200e-02,7.070000e-01,1.102900e+00,1.378400e+00,1.513100e+00, &
     &2.453500e-02,2.768400e-02,4.062800e-01,6.138200e-01,7.574100e-01, &
     &7.794900e-01,2.944900e-02,3.226000e-02,4.744300e-01,7.256100e-01, &
     &8.997900e-01,9.446800e-01,3.523400e-02,3.769400e-02,5.431600e-01, &
     &8.384600e-01,1.043300e+00,1.113000e+00,4.191200e-02,4.400600e-02, &
     &6.111900e-01,9.496100e-01,1.184600e+00,1.281900e+00,4.967400e-02, &
     &5.140500e-02,6.774000e-01,1.057000e+00,1.320700e+00,1.447400e+00, &
     &2.061800e-02,2.402600e-02,3.734300e-01,5.629000e-01,6.935200e-01, &
     &7.084900e-01,2.501300e-02,2.810300e-02,4.415100e-01,6.743600e-01, &
     &8.351300e-01,8.726600e-01,3.030500e-02,3.304900e-02,5.109000e-01, &
     &7.878300e-01,9.795800e-01,1.041500e+00,3.646100e-02,3.884200e-02, &
     &5.799900e-01,9.007600e-01,1.122900e+00,1.212600e+00,4.363700e-02, &
     &4.564500e-02,6.476600e-01,1.010500e+00,1.262100e+00,1.381700e+00/
      data  absb(1081:1410,9) /                                         &
     &1.726200e-02,2.088900e-02,3.415400e-01,5.135300e-01,6.314700e-01, &
     &6.403500e-01,2.113700e-02,2.448900e-02,4.092400e-01,6.239700e-01, &
     &7.716400e-01,8.026800e-01,2.594500e-02,2.896300e-02,4.789500e-01, &
     &7.376400e-01,9.162200e-01,9.715900e-01,3.160500e-02,3.426900e-02, &
     &5.488500e-01,8.517400e-01,1.061000e+00,1.144200e+00,3.824800e-02, &
     &4.053400e-02,6.177600e-01,9.635000e-01,1.202800e+00,1.316800e+00, &
     &1.446100e-02,1.825600e-02,3.123800e-01,4.684500e-01,5.748800e-01, &
     &5.774400e-01,1.787000e-02,2.143900e-02,3.794900e-01,5.773200e-01, &
     &7.130200e-01,7.370300e-01,2.222200e-02,2.549000e-02,4.491400e-01, &
     &6.907900e-01,8.570200e-01,9.051600e-01,2.743500e-02,3.036100e-02, &
     &5.196600e-01,8.055300e-01,1.002700e+00,1.078100e+00,3.359900e-02, &
     &3.615000e-02,5.895500e-01,9.189700e-01,1.146500e+00,1.252900e+00, &
     &1.209700e-02,1.600300e-02,2.849200e-01,4.260300e-01,5.218200e-01, &
     &5.181600e-01,1.508300e-02,1.882900e-02,3.512700e-01,5.330400e-01, &
     &6.573500e-01,6.742900e-01,1.899700e-02,2.248800e-02,4.205800e-01, &
     &6.458300e-01,8.001900e-01,8.407700e-01,2.377500e-02,2.694800e-02, &
     &4.914300e-01,7.608400e-01,9.462800e-01,1.013400e+00,2.949900e-02, &
     &3.230400e-02,5.620500e-01,8.754700e-01,1.091500e+00,1.189500e+00, &
     &1.009500e-02,1.405000e-02,2.585400e-01,3.852900e-01,4.710900e-01, &
     &4.619700e-01,1.268000e-02,1.656200e-02,3.237800e-01,4.900000e-01, &
     &6.031500e-01,6.138500e-01,1.616700e-02,1.985100e-02,3.925700e-01, &
     &6.015000e-01,7.443400e-01,7.780500e-01,2.052400e-02,2.392300e-02, &
     &4.634300e-01,7.164400e-01,8.901100e-01,9.499400e-01,2.582100e-02, &
     &2.887200e-02,5.346500e-01,8.318300e-01,1.036300e+00,1.126800e+00, &
     &8.396300e-03,1.234300e-02,2.332500e-01,3.462600e-01,4.224400e-01, &
     &4.088300e-01,1.062100e-02,1.458100e-02,2.970000e-01,4.481100e-01, &
     &5.505100e-01,5.557200e-01,1.369300e-02,1.753700e-02,3.650100e-01, &
     &5.577800e-01,6.893300e-01,7.170500e-01,1.763300e-02,2.124200e-02, &
     &4.356200e-01,6.722200e-01,8.341200e-01,8.878000e-01,2.250600e-02, &
     &2.579100e-02,5.072100e-01,7.880300e-01,9.810200e-01,1.065000e+00, &
     &7.017700e-03,1.089400e-02,2.109500e-01,3.119900e-01,3.796900e-01, &
     &3.608500e-01,8.930200e-03,1.291800e-02,2.729800e-01,4.106600e-01, &
     &5.036300e-01,5.018100e-01,1.163400e-02,1.558900e-02,3.401300e-01, &
     &5.183800e-01,6.397000e-01,6.593000e-01,1.519900e-02,1.897900e-02, &
     &4.103200e-01,6.320000e-01,7.832700e-01,8.277000e-01,1.968700e-02, &
     &2.317700e-02,4.820100e-01,7.478400e-01,9.301500e-01,1.003400e+00, &
     &5.873100e-03,9.628600e-03,1.905200e-01,2.806300e-01,3.406900e-01, &
     &3.165500e-01,7.516800e-03,1.148000e-02,2.506400e-01,3.758600e-01, &
     &4.601900e-01,4.506900e-01,9.885300e-03,1.390000e-02,3.166900e-01, &
     &4.814000e-01,5.930700e-01,6.035000e-01,1.309600e-02,1.701800e-02, &
     &3.862800e-01,5.937100e-01,7.350000e-01,7.688700e-01,1.722200e-02, &
     &2.089900e-02,4.579100e-01,7.093500e-01,8.814400e-01,9.421500e-01, &
     &4.906000e-03,8.503900e-03,1.711100e-01,2.510600e-01,3.038500e-01, &
     &2.751100e-01,6.312000e-03,1.020100e-02,2.291500e-01,3.424300e-01, &
     &4.184700e-01,4.021500e-01,8.367200e-03,1.240100e-02,2.937800e-01, &
     &4.453700e-01,5.477400e-01,5.495900e-01,1.124000e-02,1.526800e-02, &
     &3.626300e-01,5.559500e-01,6.874600e-01,7.113800e-01,1.501000e-02, &
     &1.885100e-02,4.339800e-01,6.711300e-01,8.330000e-01,8.821700e-01, &
     &4.087800e-03,7.498200e-03,1.526900e-01,2.232400e-01,2.691100e-01, &
     &2.369600e-01,5.289800e-03,9.061000e-03,2.085000e-01,3.103900e-01, &
     &3.784200e-01,3.561500e-01,7.060600e-03,1.106900e-02,2.714600e-01, &
     &4.102100e-01,5.036600e-01,4.974500e-01,9.607100e-03,1.370000e-02, &
     &3.393900e-01,5.188700e-01,6.407200e-01,6.551100e-01,1.303100e-02, &
     &1.701300e-02,4.102500e-01,6.331600e-01,7.849800e-01,8.233100e-01, &
     &3.411000e-03,6.618700e-03,1.360800e-01,1.984400e-01,2.381200e-01, &
     &2.034700e-01,4.443700e-03,8.072300e-03,1.896900e-01,2.812300e-01, &
     &3.420800e-01,3.143900e-01,5.972500e-03,9.912300e-03,2.507900e-01, &
     &3.777700e-01,4.631100e-01,4.493100e-01,8.219100e-03,1.233300e-02, &
     &3.176500e-01,4.843300e-01,5.971500e-01,6.023600e-01,1.132500e-02, &
     &1.541900e-02,3.878900e-01,5.974000e-01,7.398200e-01,7.675700e-01, &
     &2.977700e-03,6.055900e-03,1.291100e-01,1.883100e-01,2.255700e-01, &
     &1.880400e-01,3.924300e-03,7.458600e-03,1.818800e-01,2.694200e-01, &
     &3.274200e-01,2.943100e-01,5.341000e-03,9.234100e-03,2.422900e-01, &
     &3.646100e-01,4.467000e-01,4.251600e-01,7.448400e-03,1.157400e-02, &
     &3.086900e-01,4.703100e-01,5.794800e-01,5.749300e-01,1.041600e-02, &
     &1.457300e-02,3.787200e-01,5.828100e-01,7.214600e-01,7.375600e-01/
      data  absb(1:360,10) /                                            &
     &7.528900e+00,7.524800e+00,5.802000e+00,4.223500e+00,3.478800e+00, &
     &3.383000e+00,7.537300e+00,7.533100e+00,5.796500e+00,4.194900e+00, &
     &3.410000e+00,3.309100e+00,7.534200e+00,7.530000e+00,5.790700e+00, &
     &4.165600e+00,3.340200e+00,3.269000e+00,7.492700e+00,7.488600e+00, &
     &5.756500e+00,4.120600e+00,3.264100e+00,3.256700e+00,7.421200e+00, &
     &7.417100e+00,5.697800e+00,4.061100e+00,3.185600e+00,3.249000e+00, &
     &7.457100e+00,7.452900e+00,5.730000e+00,4.251600e+00,3.697300e+00, &
     &3.624900e+00,7.440700e+00,7.436500e+00,5.721100e+00,4.211300e+00, &
     &3.624400e+00,3.566700e+00,7.396300e+00,7.392200e+00,5.681200e+00, &
     &4.155600e+00,3.552600e+00,3.511500e+00,7.329600e+00,7.325500e+00, &
     &5.624900e+00,4.093500e+00,3.476600e+00,3.470700e+00,7.246500e+00, &
     &7.242500e+00,5.561900e+00,4.024500e+00,3.402000e+00,3.449300e+00, &
     &7.191100e+00,7.187100e+00,5.528000e+00,4.296800e+00,3.962700e+00, &
     &3.909000e+00,7.151300e+00,7.147400e+00,5.495600e+00,4.228900e+00, &
     &3.887100e+00,3.840000e+00,7.092300e+00,7.088400e+00,5.446400e+00, &
     &4.146800e+00,3.806200e+00,3.782800e+00,6.993400e+00,6.989500e+00, &
     &5.371300e+00,4.063800e+00,3.732800e+00,3.729000e+00,6.886400e+00, &
     &6.882500e+00,5.289900e+00,3.976100e+00,3.648300e+00,3.670400e+00, &
     &6.791100e+00,6.787300e+00,5.220500e+00,4.319900e+00,4.250200e+00, &
     &4.246600e+00,6.726300e+00,6.722600e+00,5.171100e+00,4.232900e+00, &
     &4.159900e+00,4.174100e+00,6.633300e+00,6.629600e+00,5.098800e+00, &
     &4.144800e+00,4.070300e+00,4.109400e+00,6.528000e+00,6.524400e+00, &
     &5.019800e+00,4.049600e+00,3.980100e+00,4.040300e+00,6.416700e+00, &
     &6.413100e+00,4.936100e+00,3.949900e+00,3.892700e+00,3.961400e+00, &
     &6.253100e+00,6.249700e+00,4.828600e+00,4.368600e+00,4.517200e+00, &
     &4.636400e+00,6.167700e+00,6.164300e+00,4.762600e+00,4.279200e+00, &
     &4.429800e+00,4.560100e+00,6.074700e+00,6.071300e+00,4.690800e+00, &
     &4.186000e+00,4.342800e+00,4.481200e+00,5.960400e+00,5.957100e+00, &
     &4.605300e+00,4.089900e+00,4.257000e+00,4.393500e+00,5.829100e+00, &
     &5.825900e+00,4.508900e+00,3.993500e+00,4.173300e+00,4.301100e+00, &
     &5.626600e+00,5.623600e+00,4.420700e+00,4.498900e+00,4.805300e+00, &
     &5.024700e+00,5.542700e+00,5.539700e+00,4.351200e+00,4.402100e+00, &
     &4.722600e+00,4.947000e+00,5.437400e+00,5.434500e+00,4.266900e+00, &
     &4.305400e+00,4.642900e+00,4.854800e+00,5.311800e+00,5.309000e+00, &
     &4.172700e+00,4.204600e+00,4.556700e+00,4.765200e+00,5.178800e+00, &
     &5.176000e+00,4.082600e+00,4.104500e+00,4.458300e+00,4.676600e+00, &
     &4.989200e+00,4.986500e+00,4.102200e+00,4.629000e+00,5.155400e+00, &
     &5.394600e+00,4.895100e+00,4.892400e+00,4.016500e+00,4.527300e+00, &
     &5.070200e+00,5.307300e+00,4.779800e+00,4.777300e+00,3.923800e+00, &
     &4.426900e+00,4.975300e+00,5.220800e+00,4.659800e+00,4.657300e+00, &
     &3.835200e+00,4.330300e+00,4.870400e+00,5.140000e+00,4.550800e+00, &
     &4.548400e+00,3.746200e+00,4.229000e+00,4.759000e+00,5.060300e+00, &
     &4.344600e+00,4.342300e+00,3.879500e+00,4.752200e+00,5.506500e+00, &
     &5.753500e+00,4.243100e+00,4.240900e+00,3.792700e+00,4.656100e+00, &
     &5.400400e+00,5.680000e+00,4.139700e+00,4.137600e+00,3.704700e+00, &
     &4.558500e+00,5.287800e+00,5.603300e+00,4.048100e+00,4.046000e+00, &
     &3.615000e+00,4.457500e+00,5.172100e+00,5.526100e+00,3.976500e+00, &
     &3.974400e+00,3.534300e+00,4.359500e+00,5.055400e+00,5.440600e+00, &
     &3.721100e+00,3.719200e+00,3.761300e+00,4.907400e+00,5.782700e+00, &
     &6.115400e+00,3.633000e+00,3.631200e+00,3.671700e+00,4.811600e+00, &
     &5.671400e+00,6.050600e+00,3.558900e+00,3.557100e+00,3.580700e+00, &
     &4.710800e+00,5.563500e+00,5.972400e+00,3.507300e+00,3.505500e+00, &
     &3.501600e+00,4.609700e+00,5.460300e+00,5.888600e+00,3.469100e+00, &
     &3.467400e+00,3.436400e+00,4.505200e+00,5.354100e+00,5.809000e+00, &
     &3.154300e+00,3.152700e+00,3.678200e+00,5.044700e+00,6.016000e+00, &
     &6.425300e+00,3.096900e+00,3.095400e+00,3.589800e+00,4.949900e+00, &
     &5.920600e+00,6.365900e+00,3.062000e+00,3.060500e+00,3.505800e+00, &
     &4.848600e+00,5.826500e+00,6.298900e+00,3.042500e+00,3.041000e+00, &
     &3.439500e+00,4.744600e+00,5.728900e+00,6.228300e+00,3.054600e+00, &
     &3.053200e+00,3.385400e+00,4.635800e+00,5.625200e+00,6.160300e+00, &
     &2.685400e+00,2.684100e+00,3.630800e+00,5.145900e+00,6.239900e+00, &
     &6.674000e+00,2.661700e+00,2.660400e+00,3.546800e+00,5.054000e+00, &
     &6.165200e+00,6.631500e+00,2.658400e+00,2.657100e+00,3.470300e+00, &
     &4.959900e+00,6.078000e+00,6.582400e+00,2.687200e+00,2.685900e+00, &
     &3.411100e+00,4.858700e+00,5.985600e+00,6.528700e+00,2.741700e+00, &
     &2.740500e+00,3.356000e+00,4.754800e+00,5.888400e+00,6.468600e+00, &
     &2.315100e+00,2.314000e+00,3.588600e+00,5.227400e+00,6.431100e+00, &
     &6.878900e+00,2.323000e+00,2.321900e+00,3.511300e+00,5.144200e+00, &
     &6.370500e+00,6.854900e+00,2.360900e+00,2.359800e+00,3.452400e+00, &
     &5.051400e+00,6.298400e+00,6.816300e+00,2.417500e+00,2.416400e+00, &
     &3.398900e+00,4.952100e+00,6.218100e+00,6.771000e+00,2.476200e+00, &
     &2.475200e+00,3.357700e+00,4.853300e+00,6.127800e+00,6.724400e+00/
      data  absb(361:720,10) /                                          &
     &2.024400e+00,2.023500e+00,3.526900e+00,5.272400e+00,6.574000e+00, &
     &7.031500e+00,2.065100e+00,2.064300e+00,3.475000e+00,5.196500e+00, &
     &6.532700e+00,7.028300e+00,2.122900e+00,2.122000e+00,3.431600e+00, &
     &5.109800e+00,6.477700e+00,7.001300e+00,2.185800e+00,2.184900e+00, &
     &3.393200e+00,5.018900e+00,6.405000e+00,6.969900e+00,2.251900e+00, &
     &2.251000e+00,3.368000e+00,4.935400e+00,6.314300e+00,6.941100e+00, &
     &1.803800e+00,1.803100e+00,3.475100e+00,5.274100e+00,6.675400e+00, &
     &7.136700e+00,1.858400e+00,1.857700e+00,3.442100e+00,5.212800e+00, &
     &6.646800e+00,7.152500e+00,1.921700e+00,1.920900e+00,3.408900e+00, &
     &5.144500e+00,6.604000e+00,7.145700e+00,1.982400e+00,1.981600e+00, &
     &3.391900e+00,5.073600e+00,6.539800e+00,7.130100e+00,2.043100e+00, &
     &2.042300e+00,3.369300e+00,5.009800e+00,6.461400e+00,7.111600e+00, &
     &1.620500e+00,1.620000e+00,3.431200e+00,5.251200e+00,6.730200e+00, &
     &7.191600e+00,1.682100e+00,1.681500e+00,3.409600e+00,5.210700e+00, &
     &6.720400e+00,7.234100e+00,1.739300e+00,1.738700e+00,3.398600e+00, &
     &5.161100e+00,6.690100e+00,7.246100e+00,1.795200e+00,1.794500e+00, &
     &3.384900e+00,5.111800e+00,6.640000e+00,7.252100e+00,1.846700e+00, &
     &1.846000e+00,3.367800e+00,5.068800e+00,6.575000e+00,7.252900e+00, &
     &1.458100e+00,1.457700e+00,3.379300e+00,5.215100e+00,6.752800e+00, &
     &7.209900e+00,1.513000e+00,1.512600e+00,3.378500e+00,5.194700e+00, &
     &6.765300e+00,7.274000e+00,1.566900e+00,1.566400e+00,3.381000e+00, &
     &5.166400e+00,6.751200e+00,7.319200e+00,1.617200e+00,1.616600e+00, &
     &3.373200e+00,5.142500e+00,6.717700e+00,7.359000e+00,1.663100e+00, &
     &1.662500e+00,3.369400e+00,5.110900e+00,6.662400e+00,7.378200e+00, &
     &1.302200e+00,1.301900e+00,3.327000e+00,5.172800e+00,6.755900e+00, &
     &7.209600e+00,1.353300e+00,1.352900e+00,3.347300e+00,5.172300e+00, &
     &6.790500e+00,7.306900e+00,1.403100e+00,1.402700e+00,3.357100e+00, &
     &5.170300e+00,6.796500e+00,7.392500e+00,1.449100e+00,1.448700e+00, &
     &3.364300e+00,5.165200e+00,6.774100e+00,7.463700e+00,1.492600e+00, &
     &1.492100e+00,3.369700e+00,5.147300e+00,6.726100e+00,7.494000e+00, &
     &1.160000e+00,1.159700e+00,3.281100e+00,5.124200e+00,6.745500e+00, &
     &7.205500e+00,1.206400e+00,1.206100e+00,3.312500e+00,5.149700e+00, &
     &6.802700e+00,7.345600e+00,1.251100e+00,1.250800e+00,3.336600e+00, &
     &5.170700e+00,6.823300e+00,7.471200e+00,1.293900e+00,1.293500e+00, &
     &3.355600e+00,5.180100e+00,6.814300e+00,7.561100e+00,1.335000e+00, &
     &1.334600e+00,3.366000e+00,5.173500e+00,6.775400e+00,7.603100e+00, &
     &1.033500e+00,1.033300e+00,3.241300e+00,5.076800e+00,6.732800e+00, &
     &7.224700e+00,1.075100e+00,1.074900e+00,3.281700e+00,5.129400e+00, &
     &6.809600e+00,7.411800e+00,1.115400e+00,1.115200e+00,3.317300e+00, &
     &5.167800e+00,6.846700e+00,7.564800e+00,1.154900e+00,1.154600e+00, &
     &3.345300e+00,5.189900e+00,6.848500e+00,7.662600e+00,1.197600e+00, &
     &1.197300e+00,3.359700e+00,5.196800e+00,6.817400e+00,7.717300e+00, &
     &9.219600e-01,9.218400e-01,3.206100e+00,5.042000e+00,6.725100e+00, &
     &7.271700e+00,9.591600e-01,9.590100e-01,3.258100e+00,5.114300e+00, &
     &6.818700e+00,7.492100e+00,9.961300e-01,9.959300e-01,3.303000e+00, &
     &5.167800e+00,6.867700e+00,7.651500e+00,1.035900e+00,1.035700e+00, &
     &3.335600e+00,5.200200e+00,6.877900e+00,7.759600e+00,1.085500e+00, &
     &1.085100e+00,3.351900e+00,5.217200e+00,6.851700e+00,7.824600e+00, &
     &8.244400e-01,8.243800e-01,3.178600e+00,5.017300e+00,6.724300e+00, &
     &7.344800e+00,8.583800e-01,8.582600e-01,3.241100e+00,5.106100e+00, &
     &6.829900e+00,7.578300e+00,8.942500e-01,8.940700e-01,3.290900e+00, &
     &5.171500e+00,6.888900e+00,7.745100e+00,9.390200e-01,9.387500e-01, &
     &3.325200e+00,5.214600e+00,6.905600e+00,7.868100e+00,9.996300e-01, &
     &9.992600e-01,3.342900e+00,5.236400e+00,6.882000e+00,7.938300e+00, &
     &7.380800e-01,7.380700e-01,3.155400e+00,5.000500e+00,6.727000e+00, &
     &7.419300e+00,7.704100e-01,7.703100e-01,3.224500e+00,5.103700e+00, &
     &6.842800e+00,7.656400e+00,8.092700e-01,8.090800e-01,3.278500e+00, &
     &5.178600e+00,6.909000e+00,7.842100e+00,8.622600e-01,8.619800e-01, &
     &3.316100e+00,5.229000e+00,6.926400e+00,7.965400e+00,9.316100e-01, &
     &9.312900e-01,3.333200e+00,5.253500e+00,6.906800e+00,8.035900e+00, &
     &6.609100e-01,6.609000e-01,3.129700e+00,4.982600e+00,6.723100e+00, &
     &7.473000e+00,6.934300e-01,6.933700e-01,3.205400e+00,5.098500e+00, &
     &6.850400e+00,7.728900e+00,7.370700e-01,7.368900e-01,3.264700e+00, &
     &5.183300e+00,6.923300e+00,7.924400e+00,7.968900e-01,7.966500e-01, &
     &3.304700e+00,5.242100e+00,6.945600e+00,8.050600e+00,8.713500e-01, &
     &8.710700e-01,3.324800e+00,5.268800e+00,6.929900e+00,8.117500e+00, &
     &5.926100e-01,5.926300e-01,3.099800e+00,4.957200e+00,6.706300e+00, &
     &7.500600e+00,6.261600e-01,6.261100e-01,3.183000e+00,5.086700e+00, &
     &6.848900e+00,7.781100e+00,6.734300e-01,6.733000e-01,3.247800e+00, &
     &5.183200e+00,6.930900e+00,7.982600e+00,7.366000e-01,7.364000e-01, &
     &3.292800e+00,5.248400e+00,6.961100e+00,8.118400e+00,8.139500e-01, &
     &8.137200e-01,3.316500e+00,5.280700e+00,6.951200e+00,8.192500e+00/
      data  absb(721:1080,10) /                                         &
     &5.298900e-01,5.299600e-01,3.058000e+00,4.910400e+00,6.663700e+00, &
     &7.474000e+00,5.641900e-01,5.641400e-01,3.150600e+00,5.057600e+00, &
     &6.826200e+00,7.783600e+00,6.119600e-01,6.118600e-01,3.223200e+00, &
     &5.169400e+00,6.925400e+00,8.002100e+00,6.751600e-01,6.750300e-01, &
     &3.277300e+00,5.246800e+00,6.969600e+00,8.154600e+00,7.524200e-01, &
     &7.522500e-01,3.307700e+00,5.288000e+00,6.971200e+00,8.243600e+00, &
     &4.750500e-01,4.751300e-01,3.017600e+00,4.862800e+00,6.617200e+00, &
     &7.449400e+00,5.107100e-01,5.107000e-01,3.119700e+00,5.026900e+00, &
     &6.797500e+00,7.781000e+00,5.587700e-01,5.587200e-01,3.200200e+00, &
     &5.152600e+00,6.914800e+00,8.018000e+00,6.212300e-01,6.211600e-01, &
     &3.261900e+00,5.242400e+00,6.972500e+00,8.185300e+00,6.970000e-01, &
     &6.968900e-01,3.298600e+00,5.292700e+00,6.985000e+00,8.294500e+00, &
     &4.266700e-01,4.267500e-01,2.979200e+00,4.816200e+00,6.567800e+00, &
     &7.430100e+00,4.636800e-01,4.637100e-01,3.089800e+00,4.994900e+00, &
     &6.765700e+00,7.779100e+00,5.127100e-01,5.127100e-01,3.178900e+00, &
     &5.134500e+00,6.899500e+00,8.032700e+00,5.741800e-01,5.741600e-01, &
     &3.247400e+00,5.235000e+00,6.970500e+00,8.215400e+00,6.481300e-01, &
     &6.480800e-01,3.290600e+00,5.294600e+00,6.995400e+00,8.348100e+00, &
     &3.805900e-01,3.806600e-01,2.929400e+00,4.748200e+00,6.490000e+00, &
     &7.341300e+00,4.176400e-01,4.176800e-01,3.051700e+00,4.945500e+00, &
     &6.713700e+00,7.722000e+00,4.663100e-01,4.663500e-01,3.149800e+00, &
     &5.100400e+00,6.868200e+00,8.000300e+00,5.264400e-01,5.264800e-01, &
     &3.226500e+00,5.216200e+00,6.960300e+00,8.207200e+00,5.970200e-01, &
     &5.970300e-01,3.278700e+00,5.288200e+00,7.000400e+00,8.357100e+00, &
     &3.390600e-01,3.391400e-01,2.876400e+00,4.675000e+00,6.403100e+00, &
     &7.237400e+00,3.755500e-01,3.756200e-01,3.011600e+00,4.889900e+00, &
     &6.652700e+00,7.651000e+00,4.237400e-01,4.238200e-01,3.119200e+00, &
     &5.059600e+00,6.829800e+00,7.958400e+00,4.825200e-01,4.826100e-01, &
     &3.203200e+00,5.190900e+00,6.942300e+00,8.188300e+00,5.505500e-01, &
     &5.505900e-01,3.264700e+00,5.276700e+00,6.999300e+00,8.356400e+00, &
     &3.021600e-01,3.022700e-01,2.822800e+00,4.600100e+00,6.310000e+00, &
     &7.128300e+00,3.374900e-01,3.375900e-01,2.970000e+00,4.830300e+00, &
     &6.586400e+00,7.574900e+00,3.848000e-01,3.849200e-01,3.086500e+00, &
     &5.016200e+00,6.784700e+00,7.910000e+00,4.428800e-01,4.430100e-01, &
     &3.179000e+00,5.160800e+00,6.918400e+00,8.164700e+00,5.092800e-01, &
     &5.093500e-01,3.249000e+00,5.260700e+00,6.991800e+00,8.353300e+00, &
     &2.676800e-01,2.678100e-01,2.759500e+00,4.506800e+00,6.192400e+00, &
     &6.981600e+00,3.012100e-01,3.013400e-01,2.919500e+00,4.753800e+00, &
     &6.498500e+00,7.465800e+00,3.463600e-01,3.465200e-01,3.047500e+00, &
     &4.958600e+00,6.725000e+00,7.836300e+00,4.027900e-01,4.029400e-01, &
     &3.148700e+00,5.118600e+00,6.881600e+00,8.119300e+00,4.677500e-01, &
     &4.678400e-01,3.228100e+00,5.236500e+00,6.976500e+00,8.333500e+00, &
     &2.366300e-01,2.367900e-01,2.688900e+00,4.399600e+00,6.055900e+00, &
     &6.813500e+00,2.674800e-01,2.676400e-01,2.861800e+00,4.666700e+00, &
     &6.394300e+00,7.335500e+00,3.100700e-01,3.102800e-01,3.003300e+00, &
     &4.890400e+00,6.651000e+00,7.746900e+00,3.642600e-01,3.644400e-01, &
     &3.114300e+00,5.066600e+00,6.834100e+00,8.060900e+00,4.279000e-01, &
     &4.280000e-01,3.201700e+00,5.202700e+00,6.951000e+00,8.300500e+00, &
     &2.094300e-01,2.096100e-01,2.614900e+00,4.287000e+00,5.908800e+00, &
     &6.637600e+00,2.374800e-01,2.376800e-01,2.799600e+00,4.573900e+00, &
     &6.280000e+00,7.198100e+00,2.771700e-01,2.774100e-01,2.954500e+00, &
     &4.814900e+00,6.567900e+00,7.649800e+00,3.288100e-01,3.290000e-01, &
     &3.076900e+00,5.010000e+00,6.776700e+00,7.995600e+00,3.908900e-01, &
     &3.909900e-01,3.172900e+00,5.161700e+00,6.918400e+00,8.264700e+00, &
     &1.848800e-01,1.850900e-01,2.533700e+00,4.161900e+00,5.740800e+00, &
     &6.434300e+00,2.102900e-01,2.105200e-01,2.730800e+00,4.468500e+00, &
     &6.147600e+00,7.035100e+00,2.464100e-01,2.466900e-01,2.899100e+00, &
     &4.728200e+00,6.468000e+00,7.529900e+00,2.950200e-01,2.952300e-01, &
     &3.033600e+00,4.942800e+00,6.706400e+00,7.912200e+00,3.549200e-01, &
     &3.550400e-01,3.139500e+00,5.110800e+00,6.874200e+00,8.212200e+00, &
     &1.624000e-01,1.626300e-01,2.438800e+00,4.016600e+00,5.539700e+00, &
     &6.180400e+00,1.850400e-01,1.853200e-01,2.649600e+00,4.344200e+00, &
     &5.986400e+00,6.826500e+00,2.173500e-01,2.176400e-01,2.831600e+00, &
     &4.625000e+00,6.344100e+00,7.370400e+00,2.621900e-01,2.624300e-01, &
     &2.980700e+00,4.859700e+00,6.616500e+00,7.794800e+00,3.190400e-01, &
     &3.191600e-01,3.098700e+00,5.047300e+00,6.813200e+00,8.131800e+00, &
     &1.427400e-01,1.430900e-01,2.337800e+00,3.862100e+00,5.322300e+00, &
     &5.912900e+00,1.628900e-01,1.631900e-01,2.563100e+00,4.210800e+00, &
     &5.810300e+00,6.606200e+00,1.916700e-01,1.919800e-01,2.758400e+00, &
     &4.513300e+00,6.205100e+00,7.196700e+00,2.323900e-01,2.326400e-01, &
     &2.922600e+00,4.768000e+00,6.513500e+00,7.666500e+00,2.857700e-01, &
     &2.859200e-01,3.052500e+00,4.975900e+00,6.740100e+00,8.042300e+00/
      data  absb(1081:1410,10) /                                        &
     &1.250600e-01,1.256900e-01,2.231500e+00,3.698400e+00,5.091600e+00, &
     &5.636300e+00,1.434800e-01,1.438300e-01,2.471700e+00,4.069100e+00, &
     &5.617800e+00,6.374500e+00,1.690000e-01,1.693400e-01,2.680200e+00, &
     &4.392800e+00,6.051500e+00,7.012700e+00,2.058100e-01,2.060600e-01, &
     &2.858600e+00,4.668200e+00,6.396200e+00,7.529200e+00,2.551800e-01, &
     &2.553300e-01,3.002500e+00,4.896800e+00,6.655800e+00,7.945700e+00, &
     &1.095900e-01,1.107000e-01,2.126700e+00,3.536800e+00,4.861500e+00, &
     &5.353800e+00,1.268900e-01,1.274400e-01,2.380900e+00,3.930200e+00, &
     &5.423500e+00,6.130600e+00,1.497300e-01,1.500900e-01,2.601900e+00, &
     &4.272500e+00,5.894600e+00,6.811200e+00,1.830400e-01,1.833100e-01, &
     &2.792700e+00,4.567500e+00,6.273100e+00,7.374500e+00,2.286600e-01, &
     &2.288200e-01,2.950800e+00,4.814600e+00,6.565700e+00,7.828200e+00, &
     &9.576800e-02,9.766100e-02,2.021600e+00,3.375100e+00,4.626800e+00, &
     &5.059700e+00,1.121600e-01,1.130700e-01,2.288100e+00,3.787500e+00, &
     &5.221700e+00,5.874400e+00,1.329900e-01,1.334300e-01,2.521900e+00, &
     &4.148000e+00,5.728400e+00,6.594300e+00,1.630800e-01,1.633700e-01, &
     &2.724800e+00,4.462600e+00,6.141500e+00,7.203300e+00,2.052400e-01, &
     &2.054100e-01,2.896100e+00,4.728100e+00,6.466600e+00,7.694500e+00, &
     &8.317100e-02,8.622100e-02,1.914400e+00,3.207600e+00,4.381900e+00, &
     &4.758000e+00,9.891200e-02,1.003900e-01,2.190600e+00,3.637000e+00, &
     &5.008800e+00,5.608900e+00,1.180900e-01,1.187400e-01,2.438100e+00, &
     &4.018500e+00,5.550500e+00,6.368400e+00,1.453900e-01,1.457200e-01, &
     &2.652600e+00,4.351100e+00,5.998000e+00,7.021400e+00,1.840600e-01, &
     &1.842500e-01,2.836200e+00,4.635400e+00,6.356500e+00,7.553200e+00, &
     &7.176000e-02,7.622500e-02,1.804900e+00,3.033800e+00,4.128500e+00, &
     &4.454300e+00,8.673300e-02,8.913300e-02,2.089000e+00,3.480800e+00, &
     &4.783800e+00,5.338400e+00,1.047000e-01,1.057100e-01,2.349600e+00, &
     &3.882600e+00,5.359300e+00,6.134000e+00,1.296400e-01,1.300400e-01, &
     &2.575800e+00,4.232800e+00,5.843200e+00,6.831000e+00,1.648600e-01, &
     &1.650500e-01,2.771800e+00,4.535800e+00,6.234100e+00,7.404200e+00, &
     &6.188200e-02,6.794000e-02,1.702700e+00,2.870500e+00,3.889400e+00, &
     &4.146000e+00,7.615500e-02,7.968400e-02,1.993000e+00,3.332500e+00, &
     &4.567800e+00,5.050900e+00,9.324000e-02,9.482600e-02,2.264100e+00, &
     &3.751300e+00,5.173000e+00,5.877100e+00,1.163200e-01,1.169000e-01, &
     &2.502000e+00,4.118200e+00,5.689200e+00,6.612700e+00,1.486500e-01, &
     &1.488700e-01,2.708500e+00,4.438400e+00,6.111000e+00,7.226800e+00, &
     &5.314300e-02,6.092900e-02,1.603400e+00,2.710800e+00,3.651900e+00, &
     &3.834600e+00,6.666400e-02,7.154900e-02,1.899300e+00,3.185400e+00, &
     &4.352800e+00,4.744900e+00,8.298800e-02,8.543400e-02,2.178100e+00, &
     &3.618800e+00,4.985000e+00,5.601600e+00,1.045500e-01,1.054100e-01, &
     &2.428300e+00,4.003500e+00,5.531400e+00,6.367000e+00,1.345000e-01, &
     &1.347500e-01,2.644700e+00,4.340000e+00,5.983700e+00,7.024600e+00, &
     &4.536300e-02,5.476100e-02,1.505700e+00,2.546500e+00,3.410700e+00, &
     &3.527000e+00,5.800500e-02,6.443100e-02,1.804000e+00,3.034000e+00, &
     &4.132200e+00,4.434300e+00,7.359300e-02,7.714400e-02,2.089800e+00, &
     &3.482300e+00,4.788400e+00,5.317300e+00,9.388700e-02,9.523700e-02, &
     &2.351000e+00,3.885000e+00,5.364700e+00,6.110800e+00,1.218100e-01, &
     &1.221900e-01,2.577600e+00,4.236100e+00,5.848200e+00,6.808100e+00, &
     &3.848400e-02,4.933200e-02,1.408700e+00,2.377500e+00,3.167300e+00, &
     &3.219700e+00,5.014700e-02,5.822100e-02,1.707300e+00,2.879300e+00, &
     &3.904900e+00,4.127300e+00,6.493100e-02,6.981500e-02,1.998700e+00, &
     &3.342000e+00,4.583900e+00,5.021800e+00,8.410900e-02,8.618600e-02, &
     &2.269800e+00,3.760600e+00,5.187800e+00,5.844900e+00,1.102300e-01, &
     &1.108100e-01,2.507500e+00,4.127400e+00,5.702200e+00,6.574700e+00, &
     &3.262600e-02,4.463300e-02,1.317400e+00,2.215600e+00,2.936300e+00, &
     &2.927800e+00,4.329800e-02,5.292200e-02,1.614400e+00,2.730400e+00, &
     &3.683100e+00,3.832500e+00,5.724700e-02,6.359700e-02,1.910700e+00, &
     &3.204300e+00,4.382100e+00,4.723600e+00,7.547300e-02,7.852500e-02, &
     &2.189400e+00,3.636900e+00,5.012100e+00,5.574800e+00,1.000300e-01, &
     &1.009300e-01,2.438900e+00,4.019700e+00,5.554900e+00,6.332500e+00, &
     &2.907200e-02,4.170500e-02,1.280200e+00,2.149400e+00,2.842100e+00, &
     &2.779800e+00,3.925200e-02,4.983500e-02,1.576500e+00,2.668000e+00, &
     &3.591100e+00,3.665900e+00,5.300000e-02,6.027000e-02,1.874400e+00, &
     &3.147300e+00,4.299300e+00,4.541100e+00,7.121800e-02,7.485900e-02, &
     &2.156100e+00,3.585200e+00,4.938400e+00,5.379000e+00,9.558100e-02, &
     &9.667900e-02,2.409800e+00,3.975200e+00,5.493100e+00,6.151300e+00/
      data  absb(1:360,11) /                                            &
     &1.083000e+01,1.082400e+01,8.296600e+00,5.777500e+00,4.206700e+00, &
     &3.841600e+00,1.084200e+01,1.083600e+01,8.304800e+00,5.775600e+00, &
     &4.111700e+00,3.762600e+00,1.080600e+01,1.080000e+01,8.277000e+00, &
     &5.752400e+00,4.010300e+00,3.700500e+00,1.072400e+01,1.071800e+01, &
     &8.211200e+00,5.700200e+00,3.905800e+00,3.687500e+00,1.062100e+01, &
     &1.061500e+01,8.133700e+00,5.646500e+00,3.801300e+00,3.702800e+00, &
     &1.118100e+01,1.117500e+01,8.556800e+00,5.964900e+00,4.452200e+00, &
     &4.207700e+00,1.113300e+01,1.112700e+01,8.516700e+00,5.932300e+00, &
     &4.347600e+00,4.124700e+00,1.105300e+01,1.104700e+01,8.457000e+00, &
     &5.888900e+00,4.241500e+00,4.041700e+00,1.093300e+01,1.092700e+01, &
     &8.368200e+00,5.825200e+00,4.141300e+00,3.969500e+00,1.078000e+01, &
     &1.077400e+01,8.248100e+00,5.738200e+00,4.036200e+00,3.948100e+00, &
     &1.126500e+01,1.125900e+01,8.614400e+00,6.050400e+00,4.732300e+00, &
     &4.597100e+00,1.116200e+01,1.115600e+01,8.537800e+00,5.989500e+00, &
     &4.632300e+00,4.498800e+00,1.102200e+01,1.101500e+01,8.433700e+00, &
     &5.919900e+00,4.531200e+00,4.414200e+00,1.088000e+01,1.087400e+01, &
     &8.323400e+00,5.834800e+00,4.423700e+00,4.332600e+00,1.069800e+01, &
     &1.069200e+01,8.181100e+00,5.729400e+00,4.318900e+00,4.256900e+00, &
     &1.104700e+01,1.104100e+01,8.456600e+00,6.073300e+00,5.098700e+00, &
     &4.981400e+00,1.091200e+01,1.090500e+01,8.355800e+00,5.995600e+00, &
     &4.997900e+00,4.888400e+00,1.075800e+01,1.075200e+01,8.238100e+00, &
     &5.893500e+00,4.888100e+00,4.798600e+00,1.056900e+01,1.056300e+01, &
     &8.089800e+00,5.776000e+00,4.780800e+00,4.720000e+00,1.036300e+01, &
     &1.035700e+01,7.932400e+00,5.661400e+00,4.674600e+00,4.627200e+00, &
     &1.057700e+01,1.057200e+01,8.109800e+00,6.099100e+00,5.510600e+00, &
     &5.416500e+00,1.041100e+01,1.040500e+01,7.983500e+00,5.980500e+00, &
     &5.399600e+00,5.320600e+00,1.022400e+01,1.021900e+01,7.840600e+00, &
     &5.852000e+00,5.291000e+00,5.228900e+00,1.002800e+01,1.002200e+01, &
     &7.689000e+00,5.721500e+00,5.180300e+00,5.137300e+00,9.816000e+00, &
     &9.810500e+00,7.524400e+00,5.583900e+00,5.065300e+00,5.043200e+00, &
     &9.898600e+00,9.893100e+00,7.604400e+00,6.116400e+00,5.953400e+00, &
     &5.947400e+00,9.714000e+00,9.708600e+00,7.465400e+00,5.979500e+00, &
     &5.838300e+00,5.841100e+00,9.527300e+00,9.522000e+00,7.321000e+00, &
     &5.838300e+00,5.718900e+00,5.739500e+00,9.318200e+00,9.313000e+00, &
     &7.159400e+00,5.700600e+00,5.600200e+00,5.638500e+00,9.098400e+00, &
     &9.093400e+00,6.990100e+00,5.559600e+00,5.478400e+00,5.536100e+00, &
     &9.061700e+00,9.056700e+00,6.988200e+00,6.194400e+00,6.403200e+00, &
     &6.550600e+00,8.880700e+00,8.875800e+00,6.850800e+00,6.054100e+00, &
     &6.279000e+00,6.442100e+00,8.684000e+00,8.679300e+00,6.699300e+00, &
     &5.915500e+00,6.153000e+00,6.330200e+00,8.469000e+00,8.464300e+00, &
     &6.534600e+00,5.778200e+00,6.020500e+00,6.196900e+00,8.246100e+00, &
     &8.241500e+00,6.368300e+00,5.641800e+00,5.888400e+00,6.073800e+00, &
     &8.133800e+00,8.129400e+00,6.378700e+00,6.372400e+00,6.867600e+00, &
     &7.151200e+00,7.948900e+00,7.944600e+00,6.232300e+00,6.236700e+00, &
     &6.738000e+00,7.023500e+00,7.748400e+00,7.744200e+00,6.074700e+00, &
     &6.098400e+00,6.603700e+00,6.888600e+00,7.533600e+00,7.529500e+00, &
     &5.915800e+00,5.958500e+00,6.461500e+00,6.748300e+00,7.319200e+00, &
     &7.315300e+00,5.754000e+00,5.815400e+00,6.311400e+00,6.628500e+00, &
     &7.178300e+00,7.174500e+00,5.879200e+00,6.578900e+00,7.361300e+00, &
     &7.702200e+00,6.991900e+00,6.988200e+00,5.729900e+00,6.438900e+00, &
     &7.222500e+00,7.564700e+00,6.790900e+00,6.787300e+00,5.576600e+00, &
     &6.297300e+00,7.071200e+00,7.440500e+00,6.593900e+00,6.590300e+00, &
     &5.421700e+00,6.149000e+00,6.912900e+00,7.312200e+00,6.409300e+00, &
     &6.405900e+00,5.266300e+00,5.996300e+00,6.751600e+00,7.197000e+00, &
     &6.217700e+00,6.214400e+00,5.547900e+00,6.790000e+00,7.837400e+00, &
     &8.237500e+00,6.035600e+00,6.032400e+00,5.399500e+00,6.645100e+00, &
     &7.689500e+00,8.116600e+00,5.859600e+00,5.856500e+00,5.249900e+00, &
     &6.494300e+00,7.534200e+00,8.001600e+00,5.706900e+00,5.703900e+00, &
     &5.102900e+00,6.334200e+00,7.372100e+00,7.877900e+00,5.590700e+00, &
     &5.587800e+00,4.967700e+00,6.173100e+00,7.206800e+00,7.759800e+00, &
     &5.300100e+00,5.297400e+00,5.339200e+00,7.021200e+00,8.273100e+00, &
     &8.776900e+00,5.146500e+00,5.143900e+00,5.195900e+00,6.865800e+00, &
     &8.131800e+00,8.675600e+00,5.025900e+00,5.023400e+00,5.056800e+00, &
     &6.696400e+00,7.982200e+00,8.563500e+00,4.940800e+00,4.938300e+00, &
     &4.925600e+00,6.522900e+00,7.828300e+00,8.433700e+00,4.898200e+00, &
     &4.895700e+00,4.817000e+00,6.346700e+00,7.665600e+00,8.311700e+00, &
     &4.481000e+00,4.478800e+00,5.211700e+00,7.218700e+00,8.689400e+00, &
     &9.283000e+00,4.387500e+00,4.385400e+00,5.072900e+00,7.055200e+00, &
     &8.555200e+00,9.195200e+00,4.329800e+00,4.327700e+00,4.939500e+00, &
     &6.884100e+00,8.412900e+00,9.085400e+00,4.324000e+00,4.321900e+00, &
     &4.830500e+00,6.710600e+00,8.258300e+00,8.953400e+00,4.356800e+00, &
     &4.354700e+00,4.745000e+00,6.534100e+00,8.091700e+00,8.829800e+00/
      data  absb(361:720,11) /                                          &
     &3.815700e+00,3.813900e+00,5.126000e+00,7.375300e+00,9.080900e+00, &
     &9.730300e+00,3.782800e+00,3.780900e+00,4.988100e+00,7.225200e+00, &
     &8.954600e+00,9.652900e+00,3.796600e+00,3.794800e+00,4.869800e+00, &
     &7.069400e+00,8.811400e+00,9.549200e+00,3.844700e+00,3.842900e+00, &
     &4.780800e+00,6.905500e+00,8.654800e+00,9.422000e+00,3.932700e+00, &
     &3.930900e+00,4.702100e+00,6.729800e+00,8.488900e+00,9.293600e+00, &
     &3.303600e+00,3.302100e+00,5.057500e+00,7.519200e+00,9.418900e+00, &
     &1.010200e+01,3.328500e+00,3.327000e+00,4.928100e+00,7.384900e+00, &
     &9.302700e+00,1.004100e+01,3.388900e+00,3.387400e+00,4.832600e+00, &
     &7.237100e+00,9.167300e+00,9.952600e+00,3.483700e+00,3.482200e+00, &
     &4.752500e+00,7.075400e+00,9.013000e+00,9.833400e+00,3.586900e+00, &
     &3.585300e+00,4.687900e+00,6.908100e+00,8.842900e+00,9.710400e+00, &
     &2.916500e+00,2.915200e+00,4.985700e+00,7.656000e+00,9.711000e+00, &
     &1.042100e+01,2.983400e+00,2.982200e+00,4.887700e+00,7.529700e+00, &
     &9.610600e+00,1.038200e+01,3.075800e+00,3.074500e+00,4.813000e+00, &
     &7.387000e+00,9.483800e+00,1.030600e+01,3.179600e+00,3.178100e+00, &
     &4.748500e+00,7.232700e+00,9.330300e+00,1.019800e+01,3.295700e+00, &
     &3.294100e+00,4.703800e+00,7.068300e+00,9.156400e+00,1.008900e+01, &
     &2.615500e+00,2.614500e+00,4.927500e+00,7.763800e+00,9.955100e+00, &
     &1.069600e+01,2.704600e+00,2.703500e+00,4.864100e+00,7.647600e+00, &
     &9.868200e+00,1.068200e+01,2.807800e+00,2.806600e+00,4.808600e+00, &
     &7.513200e+00,9.747900e+00,1.061500e+01,2.922000e+00,2.920700e+00, &
     &4.766100e+00,7.360600e+00,9.599900e+00,1.052100e+01,3.041900e+00, &
     &3.040400e+00,4.723500e+00,7.204600e+00,9.419500e+00,1.042400e+01, &
     &2.373200e+00,2.372300e+00,4.890000e+00,7.837500e+00,1.015000e+01, &
     &1.095100e+01,2.471200e+00,2.470200e+00,4.848100e+00,7.731900e+00, &
     &1.007800e+01,1.094600e+01,2.578300e+00,2.577100e+00,4.811800e+00, &
     &7.603700e+00,9.972100e+00,1.089300e+01,2.690200e+00,2.688900e+00, &
     &4.785000e+00,7.458000e+00,9.826800e+00,1.082200e+01,2.804500e+00, &
     &2.803200e+00,4.740000e+00,7.315400e+00,9.648300e+00,1.074100e+01, &
     &2.165800e+00,2.165000e+00,4.867700e+00,7.886200e+00,1.031700e+01, &
     &1.116700e+01,2.266200e+00,2.265200e+00,4.842300e+00,7.791100e+00, &
     &1.026200e+01,1.117700e+01,2.369800e+00,2.368700e+00,4.824900e+00, &
     &7.671700e+00,1.016200e+01,1.114500e+01,2.477300e+00,2.476100e+00, &
     &4.795900e+00,7.538900e+00,1.001200e+01,1.110500e+01,2.587700e+00, &
     &2.586500e+00,4.756900e+00,7.411500e+00,9.834000e+00,1.102900e+01, &
     &1.979000e+00,1.978200e+00,4.850000e+00,7.914300e+00,1.046400e+01, &
     &1.136600e+01,2.077600e+00,2.076700e+00,4.842700e+00,7.831600e+00, &
     &1.041700e+01,1.139800e+01,2.179700e+00,2.178700e+00,4.832100e+00, &
     &7.724000e+00,1.031600e+01,1.141000e+01,2.284200e+00,2.283200e+00, &
     &4.802100e+00,7.607200e+00,1.017100e+01,1.139000e+01,2.390400e+00, &
     &2.389300e+00,4.770200e+00,7.487400e+00,9.988500e+00,1.130500e+01, &
     &1.806500e+00,1.805700e+00,4.833700e+00,7.932100e+00,1.059400e+01, &
     &1.155300e+01,1.905600e+00,1.904800e+00,4.840400e+00,7.860200e+00, &
     &1.055000e+01,1.163200e+01,2.007100e+00,2.006200e+00,4.829100e+00, &
     &7.766000e+00,1.044700e+01,1.167600e+01,2.109100e+00,2.108200e+00, &
     &4.805200e+00,7.665600e+00,1.029600e+01,1.164800e+01,2.214400e+00, &
     &2.213400e+00,4.780600e+00,7.552900e+00,1.010500e+01,1.155700e+01, &
     &1.651000e+00,1.650300e+00,4.821000e+00,7.948200e+00,1.070600e+01, &
     &1.176700e+01,1.749400e+00,1.748700e+00,4.834300e+00,7.886100e+00, &
     &1.065800e+01,1.188100e+01,1.850100e+00,1.849300e+00,4.825200e+00, &
     &7.807600e+00,1.054800e+01,1.191800e+01,1.952400e+00,1.951600e+00, &
     &4.810100e+00,7.716300e+00,1.039100e+01,1.187800e+01,2.059400e+00, &
     &2.058600e+00,4.789600e+00,7.604700e+00,1.019300e+01,1.178300e+01, &
     &1.509800e+00,1.509300e+00,4.811900e+00,7.965300e+00,1.079800e+01, &
     &1.197200e+01,1.606700e+00,1.606100e+00,4.828200e+00,7.916400e+00, &
     &1.074500e+01,1.209100e+01,1.706800e+00,1.706200e+00,4.825400e+00, &
     &7.847000e+00,1.063200e+01,1.211300e+01,1.811600e+00,1.810900e+00, &
     &4.814700e+00,7.762200e+00,1.047000e+01,1.207300e+01,1.923200e+00, &
     &1.922500e+00,4.797700e+00,7.652100e+00,1.026400e+01,1.196900e+01, &
     &1.377700e+00,1.377300e+00,4.800700e+00,7.986500e+00,1.087800e+01, &
     &1.215200e+01,1.472000e+00,1.471500e+00,4.822000e+00,7.950500e+00, &
     &1.082400e+01,1.227200e+01,1.571300e+00,1.570800e+00,4.827500e+00, &
     &7.890700e+00,1.071000e+01,1.229600e+01,1.679000e+00,1.678400e+00, &
     &4.822000e+00,7.808100e+00,1.054700e+01,1.226000e+01,1.798600e+00, &
     &1.798000e+00,4.807500e+00,7.700200e+00,1.033600e+01,1.215900e+01, &
     &1.251400e+00,1.251100e+00,4.786800e+00,8.010900e+00,1.094600e+01, &
     &1.230400e+01,1.343500e+00,1.343100e+00,4.817900e+00,7.987700e+00, &
     &1.089700e+01,1.242700e+01,1.443500e+00,1.443000e+00,4.831400e+00, &
     &7.935300e+00,1.078800e+01,1.247000e+01,1.553800e+00,1.553300e+00, &
     &4.831800e+00,7.858200e+00,1.062700e+01,1.243800e+01,1.681000e+00, &
     &1.680400e+00,4.820300e+00,7.752800e+00,1.041600e+01,1.233900e+01/
      data  absb(721:1080,11) /                                         &
     &1.128200e+00,1.128000e+00,4.769900e+00,8.031500e+00,1.100000e+01, &
     &1.239600e+01,1.216700e+00,1.216400e+00,4.812500e+00,8.024300e+00, &
     &1.097000e+01,1.254400e+01,1.315800e+00,1.315500e+00,4.835900e+00, &
     &7.981400e+00,1.087200e+01,1.261500e+01,1.428400e+00,1.428000e+00, &
     &4.841700e+00,7.912000e+00,1.072200e+01,1.259600e+01,1.561200e+00, &
     &1.560600e+00,4.834800e+00,7.813100e+00,1.051600e+01,1.250400e+01, &
     &1.020400e+00,1.020200e+00,4.752300e+00,8.047000e+00,1.104100e+01, &
     &1.247600e+01,1.104400e+00,1.104200e+00,4.806300e+00,8.052600e+00, &
     &1.103100e+01,1.265600e+01,1.202600e+00,1.202300e+00,4.838900e+00, &
     &8.020700e+00,1.094500e+01,1.275400e+01,1.317100e+00,1.316700e+00, &
     &4.850800e+00,7.958300e+00,1.080500e+01,1.274600e+01,1.455100e+00, &
     &1.454600e+00,4.848600e+00,7.866100e+00,1.060800e+01,1.265900e+01, &
     &9.269700e-01,9.269000e-01,4.734500e+00,8.052900e+00,1.107000e+01, &
     &1.255400e+01,1.008300e+00,1.008100e+00,4.800700e+00,8.073500e+00, &
     &1.107900e+01,1.277300e+01,1.103700e+00,1.103500e+00,4.840200e+00, &
     &8.052000e+00,1.100800e+01,1.289300e+01,1.220400e+00,1.220100e+00, &
     &4.859000e+00,7.997100e+00,1.087600e+01,1.289200e+01,1.362800e+00, &
     &1.362300e+00,4.860600e+00,7.911300e+00,1.068800e+01,1.281000e+01, &
     &8.375800e-01,8.376000e-01,4.706300e+00,8.048700e+00,1.108200e+01, &
     &1.255600e+01,9.158100e-01,9.157700e-01,4.786900e+00,8.087900e+00, &
     &1.112000e+01,1.281600e+01,1.007900e+00,1.007800e+00,4.837100e+00, &
     &8.080500e+00,1.107000e+01,1.297000e+01,1.122500e+00,1.122200e+00, &
     &4.863900e+00,8.035700e+00,1.095400e+01,1.298900e+01,1.266500e+00, &
     &1.266000e+00,4.871400e+00,7.959100e+00,1.077900e+01,1.292600e+01, &
     &7.580400e-01,7.581200e-01,4.674600e+00,8.034700e+00,1.107700e+01, &
     &1.253000e+01