#!/bin/bash
set -eu

SECONDS=0

if [[ $# != 4 ]]; then
  echo "Usage: $0 PATHTR MACHINE_ID NMMB_VER BUILD_NR"
  exit 1
fi

readonly PATHTR=$1
readonly MACHINE_ID=$2
readonly NMMB_VER=$3
readonly BUILD_NR=$4

hostname

echo "Compiling ${NMMB_VER}"
cd ${PATHTR}

./configure ${MACHINE_ID}

set +x
if [[ $MACHINE_ID = wcoss ]]; then
  source /usrx/local/Modules/default/init/sh
elif [[ $MACHINE_ID = wcoss_cray ]]; then
  source /opt/modules/default/init/sh
elif [[ $MACHINE_ID = theia ]]; then
  source /apps/lmod/lmod/init/sh
fi
source conf/modules.nmmb
module list
set -x

gmake clean

gmake ${NMMB_VER} J=-j4

mv NMMB.x ${PATHTR}/tests/NMMB_${BUILD_NR}.x
cp conf/modules.nmmb ${PATHTR}/tests/modules.nmmb_${BUILD_NR}

gmake cleanall

elapsed=$SECONDS
echo "Elapsed time $elapsed seconds. Compiling ${NMMB_VER} finished"
