!!!!!  ==============================================================  !!!!!
!!!!!             lw-rrtm3 radiation package description               !!!!!
!!!!!  ==============================================================  !!!!!
!                                                                          !
!   this package includes ncep's modifications of the rrtm-lw radiation    !
!   code from aer inc.                                                     !
!                                                                          !
!    the rrtm3 package includes these parts:                               !
!                                                                          !
!       'radlw_rrtm3_param.f'                                              !
!       'radlw_rrtm3_datatb.f'                                             !
!       'radlw_rrtm3_main.f'                                               !
!                                                                          !
!    the 'radlw_rrtm3_param.f' contains:                                   !
!                                                                          !
!       'module_radlw_parameters'  -- band parameters set up               !
!                                                                          !
!    the 'radlw_rrtm3_datatb.f' contains:                                  !
!                                                                          !
!       'module_radlw_avplank'     -- plank flux data                      !
!       'module_radlw_ref'         -- reference temperature and pressure   !
!       'module_radlw_cldprlw'     -- cloud property coefficients          !
!       'module_radlw_kgbnn'       -- absorption coeffients for 16         !
!                                     bands, where nn = 01-16              !
!                                                                          !
!    the 'radlw_rrtm3_main.f' contains:                                    !
!                                                                          !
!       'module_radlw_main'        -- main lw radiation transfer           !
!                                                                          !
!    in the main module 'module_radlw_main' there are only two             !
!    externally callable subroutines:                                      !
!                                                                          !
!       'lwrad'     -- main rrtm1 lw radiation routine                     !
!       'rlwinit'   -- initialization routine                              !
!                                                                          !
!    all the lw radiation subprograms become contained subprograms         !
!    in module 'module_radlw_main' and many of them are not directly       !
!    accessable from places outside the module.                            !
!                                                                          !
!    compilation sequence is:                                              !
!                                                                          !
!       'radlw_rrtm3_param.f'                                              !
!       'radlw_rrtm3_datatb.f'                                             !
!       'radlw_rrtm3_main.f'                                               !
!                                                                          !
!    and all should be put in front of routines that use lw modules        !
!                                                                          !
!    ncep modifications history log:                                       !
!                                                                          !
!       see list in program "radlw_rrtm3_main.f"                           !
!                                                                          !
!!!!!  ==============================================================  !!!!!
!!!!!                         end descriptions                         !!!!!
!!!!!  ==============================================================  !!!!!


!========================================!
      module module_radlw_avplank        !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NPLNK, NBANDS
!
      implicit none
!
      private

      real (kind=kind_phys), public :: totplnk(NPLNK,NBANDS)

      data totplnk(  1: 50, 1)  /                                       &
     & 0.14783e-05,0.15006e-05,0.15230e-05,0.15455e-05,0.15681e-05,     &
     & 0.15908e-05,0.16136e-05,0.16365e-05,0.16595e-05,0.16826e-05,     &
     & 0.17059e-05,0.17292e-05,0.17526e-05,0.17762e-05,0.17998e-05,     &
     & 0.18235e-05,0.18473e-05,0.18712e-05,0.18953e-05,0.19194e-05,     &
     & 0.19435e-05,0.19678e-05,0.19922e-05,0.20166e-05,0.20412e-05,     &
     & 0.20658e-05,0.20905e-05,0.21153e-05,0.21402e-05,0.21652e-05,     &
     & 0.21902e-05,0.22154e-05,0.22406e-05,0.22659e-05,0.22912e-05,     &
     & 0.23167e-05,0.23422e-05,0.23678e-05,0.23934e-05,0.24192e-05,     &
     & 0.24450e-05,0.24709e-05,0.24968e-05,0.25229e-05,0.25490e-05,     &
     & 0.25751e-05,0.26014e-05,0.26277e-05,0.26540e-05,0.26805e-05/
      data totplnk( 51:100, 1)  /                                       &
     & 0.27070e-05,0.27335e-05,0.27602e-05,0.27869e-05,0.28136e-05,     &
     & 0.28404e-05,0.28673e-05,0.28943e-05,0.29213e-05,0.29483e-05,     &
     & 0.29754e-05,0.30026e-05,0.30298e-05,0.30571e-05,0.30845e-05,     &
     & 0.31119e-05,0.31393e-05,0.31669e-05,0.31944e-05,0.32220e-05,     &
     & 0.32497e-05,0.32774e-05,0.33052e-05,0.33330e-05,0.33609e-05,     &
     & 0.33888e-05,0.34168e-05,0.34448e-05,0.34729e-05,0.35010e-05,     &
     & 0.35292e-05,0.35574e-05,0.35857e-05,0.36140e-05,0.36424e-05,     &
     & 0.36708e-05,0.36992e-05,0.37277e-05,0.37563e-05,0.37848e-05,     &
     & 0.38135e-05,0.38421e-05,0.38708e-05,0.38996e-05,0.39284e-05,     &
     & 0.39572e-05,0.39861e-05,0.40150e-05,0.40440e-05,0.40730e-05/
      data totplnk(101:150, 1)  /                                       &
     & 0.41020e-05,0.41311e-05,0.41602e-05,0.41893e-05,0.42185e-05,     &
     & 0.42477e-05,0.42770e-05,0.43063e-05,0.43356e-05,0.43650e-05,     &
     & 0.43944e-05,0.44238e-05,0.44533e-05,0.44828e-05,0.45124e-05,     &
     & 0.45419e-05,0.45715e-05,0.46012e-05,0.46309e-05,0.46606e-05,     &
     & 0.46903e-05,0.47201e-05,0.47499e-05,0.47797e-05,0.48096e-05,     &
     & 0.48395e-05,0.48695e-05,0.48994e-05,0.49294e-05,0.49594e-05,     &
     & 0.49895e-05,0.50196e-05,0.50497e-05,0.50798e-05,0.51100e-05,     &
     & 0.51402e-05,0.51704e-05,0.52007e-05,0.52309e-05,0.52612e-05,     &
     & 0.52916e-05,0.53219e-05,0.53523e-05,0.53827e-05,0.54132e-05,     &
     & 0.54436e-05,0.54741e-05,0.55047e-05,0.55352e-05,0.55658e-05/
      data totplnk(151:181, 1)  /                                       &
     & 0.55964e-05,0.56270e-05,0.56576e-05,0.56883e-05,0.57190e-05,     &
     & 0.57497e-05,0.57804e-05,0.58112e-05,0.58420e-05,0.58728e-05,     &
     & 0.59036e-05,0.59345e-05,0.59653e-05,0.59962e-05,0.60272e-05,     &
     & 0.60581e-05,0.60891e-05,0.61201e-05,0.61511e-05,0.61821e-05,     &
     & 0.62131e-05,0.62442e-05,0.62753e-05,0.63064e-05,0.63376e-05,     &
     & 0.63687e-05,0.63998e-05,0.64310e-05,0.64622e-05,0.64935e-05,     &
     & 0.65247e-05/
      data totplnk(  1: 50, 2)  /                                       &
     & 0.20262e-05,0.20757e-05,0.21257e-05,0.21763e-05,0.22276e-05,     &
     & 0.22794e-05,0.23319e-05,0.23849e-05,0.24386e-05,0.24928e-05,     &
     & 0.25477e-05,0.26031e-05,0.26591e-05,0.27157e-05,0.27728e-05,     &
     & 0.28306e-05,0.28889e-05,0.29478e-05,0.30073e-05,0.30673e-05,     &
     & 0.31279e-05,0.31890e-05,0.32507e-05,0.33129e-05,0.33757e-05,     &
     & 0.34391e-05,0.35029e-05,0.35674e-05,0.36323e-05,0.36978e-05,     &
     & 0.37638e-05,0.38304e-05,0.38974e-05,0.39650e-05,0.40331e-05,     &
     & 0.41017e-05,0.41708e-05,0.42405e-05,0.43106e-05,0.43812e-05,     &
     & 0.44524e-05,0.45240e-05,0.45961e-05,0.46687e-05,0.47418e-05,     &
     & 0.48153e-05,0.48894e-05,0.49639e-05,0.50389e-05,0.51143e-05/
      data totplnk( 51:100, 2)  /                                       &
     & 0.51902e-05,0.52666e-05,0.53434e-05,0.54207e-05,0.54985e-05,     &
     & 0.55767e-05,0.56553e-05,0.57343e-05,0.58139e-05,0.58938e-05,     &
     & 0.59742e-05,0.60550e-05,0.61362e-05,0.62179e-05,0.63000e-05,     &
     & 0.63825e-05,0.64654e-05,0.65487e-05,0.66324e-05,0.67166e-05,     &
     & 0.68011e-05,0.68860e-05,0.69714e-05,0.70571e-05,0.71432e-05,     &
     & 0.72297e-05,0.73166e-05,0.74039e-05,0.74915e-05,0.75796e-05,     &
     & 0.76680e-05,0.77567e-05,0.78459e-05,0.79354e-05,0.80252e-05,     &
     & 0.81155e-05,0.82061e-05,0.82970e-05,0.83883e-05,0.84799e-05,     &
     & 0.85719e-05,0.86643e-05,0.87569e-05,0.88499e-05,0.89433e-05,     &
     & 0.90370e-05,0.91310e-05,0.92254e-05,0.93200e-05,0.94150e-05/
      data totplnk(101:150, 2)  /                                       &
     & 0.95104e-05,0.96060e-05,0.97020e-05,0.97982e-05,0.98948e-05,     &
     & 0.99917e-05,0.10089e-04,0.10186e-04,0.10284e-04,0.10382e-04,     &
     & 0.10481e-04,0.10580e-04,0.10679e-04,0.10778e-04,0.10877e-04,     &
     & 0.10977e-04,0.11077e-04,0.11178e-04,0.11279e-04,0.11380e-04,     &
     & 0.11481e-04,0.11583e-04,0.11684e-04,0.11786e-04,0.11889e-04,     &
     & 0.11992e-04,0.12094e-04,0.12198e-04,0.12301e-04,0.12405e-04,     &
     & 0.12509e-04,0.12613e-04,0.12717e-04,0.12822e-04,0.12927e-04,     &
     & 0.13032e-04,0.13138e-04,0.13244e-04,0.13349e-04,0.13456e-04,     &
     & 0.13562e-04,0.13669e-04,0.13776e-04,0.13883e-04,0.13990e-04,     &
     & 0.14098e-04,0.14206e-04,0.14314e-04,0.14422e-04,0.14531e-04/
      data totplnk(151:181, 2)  /                                       &
     & 0.14639e-04,0.14748e-04,0.14857e-04,0.14967e-04,0.15076e-04,     &
     & 0.15186e-04,0.15296e-04,0.15407e-04,0.15517e-04,0.15628e-04,     &
     & 0.15739e-04,0.15850e-04,0.15961e-04,0.16072e-04,0.16184e-04,     &
     & 0.16296e-04,0.16408e-04,0.16521e-04,0.16633e-04,0.16746e-04,     &
     & 0.16859e-04,0.16972e-04,0.17085e-04,0.17198e-04,0.17312e-04,     &
     & 0.17426e-04,0.17540e-04,0.17654e-04,0.17769e-04,0.17883e-04,     &
     & 0.17998e-04/
      data totplnk(  1: 50, 3)  /                                       &
     & 1.34822e-06,1.39134e-06,1.43530e-06,1.48010e-06,1.52574e-06,     &
     & 1.57222e-06,1.61956e-06,1.66774e-06,1.71678e-06,1.76666e-06,     &
     & 1.81741e-06,1.86901e-06,1.92147e-06,1.97479e-06,2.02898e-06,     &
     & 2.08402e-06,2.13993e-06,2.19671e-06,2.25435e-06,2.31285e-06,     &
     & 2.37222e-06,2.43246e-06,2.49356e-06,2.55553e-06,2.61837e-06,     &
     & 2.68207e-06,2.74664e-06,2.81207e-06,2.87837e-06,2.94554e-06,     &
     & 3.01356e-06,3.08245e-06,3.15221e-06,3.22282e-06,3.29429e-06,     &
     & 3.36662e-06,3.43982e-06,3.51386e-06,3.58876e-06,3.66451e-06,     &
     & 3.74112e-06,3.81857e-06,3.89688e-06,3.97602e-06,4.05601e-06,     &
     & 4.13685e-06,4.21852e-06,4.30104e-06,4.38438e-06,4.46857e-06/
      data totplnk( 51:100, 3)  /                                       &
     & 4.55358e-06,4.63943e-06,4.72610e-06,4.81359e-06,4.90191e-06,     &
     & 4.99105e-06,5.08100e-06,5.17176e-06,5.26335e-06,5.35573e-06,     &
     & 5.44892e-06,5.54292e-06,5.63772e-06,5.73331e-06,5.82970e-06,     &
     & 5.92688e-06,6.02485e-06,6.12360e-06,6.22314e-06,6.32346e-06,     &
     & 6.42455e-06,6.52641e-06,6.62906e-06,6.73247e-06,6.83664e-06,     &
     & 6.94156e-06,7.04725e-06,7.15370e-06,7.26089e-06,7.36883e-06,     &
     & 7.47752e-06,7.58695e-06,7.69712e-06,7.80801e-06,7.91965e-06,     &
     & 8.03201e-06,8.14510e-06,8.25891e-06,8.37343e-06,8.48867e-06,     &
     & 8.60463e-06,8.72128e-06,8.83865e-06,8.95672e-06,9.07548e-06,     &
     & 9.19495e-06,9.31510e-06,9.43594e-06,9.55745e-06,9.67966e-06/
      data totplnk(101:150, 3)  /                                       &
     & 9.80254e-06,9.92609e-06,1.00503e-05,1.01752e-05,1.03008e-05,     &
     & 1.04270e-05,1.05539e-05,1.06814e-05,1.08096e-05,1.09384e-05,     &
     & 1.10679e-05,1.11980e-05,1.13288e-05,1.14601e-05,1.15922e-05,     &
     & 1.17248e-05,1.18581e-05,1.19920e-05,1.21265e-05,1.22616e-05,     &
     & 1.23973e-05,1.25337e-05,1.26706e-05,1.28081e-05,1.29463e-05,     &
     & 1.30850e-05,1.32243e-05,1.33642e-05,1.35047e-05,1.36458e-05,     &
     & 1.37875e-05,1.39297e-05,1.40725e-05,1.42159e-05,1.43598e-05,     &
     & 1.45044e-05,1.46494e-05,1.47950e-05,1.49412e-05,1.50879e-05,     &
     & 1.52352e-05,1.53830e-05,1.55314e-05,1.56803e-05,1.58297e-05,     &
     & 1.59797e-05,1.61302e-05,1.62812e-05,1.64327e-05,1.65848e-05/
      data totplnk(151:181, 3)  /                                       &
     & 1.67374e-05,1.68904e-05,1.70441e-05,1.71982e-05,1.73528e-05,     &
     & 1.75079e-05,1.76635e-05,1.78197e-05,1.79763e-05,1.81334e-05,     &
     & 1.82910e-05,1.84491e-05,1.86076e-05,1.87667e-05,1.89262e-05,     &
     & 1.90862e-05,1.92467e-05,1.94076e-05,1.95690e-05,1.97309e-05,     &
     & 1.98932e-05,2.00560e-05,2.02193e-05,2.03830e-05,2.05472e-05,     &
     & 2.07118e-05,2.08768e-05,2.10423e-05,2.12083e-05,2.13747e-05,     &
     & 2.15414e-05/
      data totplnk(  1: 50, 4)  /                                       &
     & 8.90528e-07,9.24222e-07,9.58757e-07,9.94141e-07,1.03038e-06,     &
     & 1.06748e-06,1.10545e-06,1.14430e-06,1.18403e-06,1.22465e-06,     &
     & 1.26618e-06,1.30860e-06,1.35193e-06,1.39619e-06,1.44136e-06,     &
     & 1.48746e-06,1.53449e-06,1.58246e-06,1.63138e-06,1.68124e-06,     &
     & 1.73206e-06,1.78383e-06,1.83657e-06,1.89028e-06,1.94495e-06,     &
     & 2.00060e-06,2.05724e-06,2.11485e-06,2.17344e-06,2.23303e-06,     &
     & 2.29361e-06,2.35519e-06,2.41777e-06,2.48134e-06,2.54592e-06,     &
     & 2.61151e-06,2.67810e-06,2.74571e-06,2.81433e-06,2.88396e-06,     &
     & 2.95461e-06,3.02628e-06,3.09896e-06,3.17267e-06,3.24741e-06,     &
     & 3.32316e-06,3.39994e-06,3.47774e-06,3.55657e-06,3.63642e-06/
      data totplnk( 51:100, 4)  /                                       &
     & 3.71731e-06,3.79922e-06,3.88216e-06,3.96612e-06,4.05112e-06,     &
     & 4.13714e-06,4.22419e-06,4.31227e-06,4.40137e-06,4.49151e-06,     &
     & 4.58266e-06,4.67485e-06,4.76806e-06,4.86229e-06,4.95754e-06,     &
     & 5.05383e-06,5.15113e-06,5.24946e-06,5.34879e-06,5.44916e-06,     &
     & 5.55053e-06,5.65292e-06,5.75632e-06,5.86073e-06,5.96616e-06,     &
     & 6.07260e-06,6.18003e-06,6.28848e-06,6.39794e-06,6.50838e-06,     &
     & 6.61983e-06,6.73229e-06,6.84573e-06,6.96016e-06,7.07559e-06,     &
     & 7.19200e-06,7.30940e-06,7.42779e-06,7.54715e-06,7.66749e-06,     &
     & 7.78882e-06,7.91110e-06,8.03436e-06,8.15859e-06,8.28379e-06,     &
     & 8.40994e-06,8.53706e-06,8.66515e-06,8.79418e-06,8.92416e-06/
      data totplnk(101:150, 4)  /                                       &
     & 9.05510e-06,9.18697e-06,9.31979e-06,9.45356e-06,9.58826e-06,     &
     & 9.72389e-06,9.86046e-06,9.99793e-06,1.01364e-05,1.02757e-05,     &
     & 1.04159e-05,1.05571e-05,1.06992e-05,1.08422e-05,1.09861e-05,     &
     & 1.11309e-05,1.12766e-05,1.14232e-05,1.15707e-05,1.17190e-05,     &
     & 1.18683e-05,1.20184e-05,1.21695e-05,1.23214e-05,1.24741e-05,     &
     & 1.26277e-05,1.27822e-05,1.29376e-05,1.30939e-05,1.32509e-05,     &
     & 1.34088e-05,1.35676e-05,1.37273e-05,1.38877e-05,1.40490e-05,     &
     & 1.42112e-05,1.43742e-05,1.45380e-05,1.47026e-05,1.48680e-05,     &
     & 1.50343e-05,1.52014e-05,1.53692e-05,1.55379e-05,1.57074e-05,     &
     & 1.58778e-05,1.60488e-05,1.62207e-05,1.63934e-05,1.65669e-05/
      data totplnk(151:181, 4)  /                                       &
     & 1.67411e-05,1.69162e-05,1.70920e-05,1.72685e-05,1.74459e-05,     &
     & 1.76240e-05,1.78029e-05,1.79825e-05,1.81629e-05,1.83440e-05,     &
     & 1.85259e-05,1.87086e-05,1.88919e-05,1.90760e-05,1.92609e-05,     &
     & 1.94465e-05,1.96327e-05,1.98199e-05,2.00076e-05,2.01961e-05,     &
     & 2.03853e-05,2.05752e-05,2.07658e-05,2.09571e-05,2.11491e-05,     &
     & 2.13418e-05,2.15352e-05,2.17294e-05,2.19241e-05,2.21196e-05,     &
     & 2.23158e-05/
      data totplnk(  1: 50, 5)  /                                       &
     & 5.70230e-07,5.94788e-07,6.20085e-07,6.46130e-07,6.72936e-07,     &
     & 7.00512e-07,7.28869e-07,7.58019e-07,7.87971e-07,8.18734e-07,     &
     & 8.50320e-07,8.82738e-07,9.15999e-07,9.50110e-07,9.85084e-07,     &
     & 1.02093e-06,1.05765e-06,1.09527e-06,1.13378e-06,1.17320e-06,     &
     & 1.21353e-06,1.25479e-06,1.29698e-06,1.34011e-06,1.38419e-06,     &
     & 1.42923e-06,1.47523e-06,1.52221e-06,1.57016e-06,1.61910e-06,     &
     & 1.66904e-06,1.71997e-06,1.77192e-06,1.82488e-06,1.87886e-06,     &
     & 1.93387e-06,1.98991e-06,2.04699e-06,2.10512e-06,2.16430e-06,     &
     & 2.22454e-06,2.28584e-06,2.34821e-06,2.41166e-06,2.47618e-06,     &
     & 2.54178e-06,2.60847e-06,2.67626e-06,2.74514e-06,2.81512e-06/
      data totplnk( 51:100, 5)  /                                       &
     & 2.88621e-06,2.95841e-06,3.03172e-06,3.10615e-06,3.18170e-06,     &
     & 3.25838e-06,3.33618e-06,3.41511e-06,3.49518e-06,3.57639e-06,     &
     & 3.65873e-06,3.74221e-06,3.82684e-06,3.91262e-06,3.99955e-06,     &
     & 4.08763e-06,4.17686e-06,4.26725e-06,4.35880e-06,4.45150e-06,     &
     & 4.54537e-06,4.64039e-06,4.73659e-06,4.83394e-06,4.93246e-06,     &
     & 5.03215e-06,5.13301e-06,5.23504e-06,5.33823e-06,5.44260e-06,     &
     & 5.54814e-06,5.65484e-06,5.76272e-06,5.87177e-06,5.98199e-06,     &
     & 6.09339e-06,6.20596e-06,6.31969e-06,6.43460e-06,6.55068e-06,     &
     & 6.66793e-06,6.78636e-06,6.90595e-06,7.02670e-06,7.14863e-06,     &
     & 7.27173e-06,7.39599e-06,7.52142e-06,7.64802e-06,7.77577e-06/
      data totplnk(101:150, 5)  /                                       &
     & 7.90469e-06,8.03477e-06,8.16601e-06,8.29841e-06,8.43198e-06,     &
     & 8.56669e-06,8.70256e-06,8.83957e-06,8.97775e-06,9.11706e-06,     &
     & 9.25753e-06,9.39915e-06,9.54190e-06,9.68580e-06,9.83085e-06,     &
     & 9.97704e-06,1.01243e-05,1.02728e-05,1.04224e-05,1.05731e-05,     &
     & 1.07249e-05,1.08779e-05,1.10320e-05,1.11872e-05,1.13435e-05,     &
     & 1.15009e-05,1.16595e-05,1.18191e-05,1.19799e-05,1.21418e-05,     &
     & 1.23048e-05,1.24688e-05,1.26340e-05,1.28003e-05,1.29676e-05,     &
     & 1.31361e-05,1.33056e-05,1.34762e-05,1.36479e-05,1.38207e-05,     &
     & 1.39945e-05,1.41694e-05,1.43454e-05,1.45225e-05,1.47006e-05,     &
     & 1.48797e-05,1.50600e-05,1.52413e-05,1.54236e-05,1.56070e-05/
      data totplnk(151:181, 5)  /                                       &
     & 1.57914e-05,1.59768e-05,1.61633e-05,1.63509e-05,1.65394e-05,     &
     & 1.67290e-05,1.69197e-05,1.71113e-05,1.73040e-05,1.74976e-05,     &
     & 1.76923e-05,1.78880e-05,1.80847e-05,1.82824e-05,1.84811e-05,     &
     & 1.86808e-05,1.88814e-05,1.90831e-05,1.92857e-05,1.94894e-05,     &
     & 1.96940e-05,1.98996e-05,2.01061e-05,2.03136e-05,2.05221e-05,     &
     & 2.07316e-05,2.09420e-05,2.11533e-05,2.13657e-05,2.15789e-05,     &
     & 2.17931e-05/
      data totplnk(  1: 50, 6)  /                                       &
     & 2.73493e-07,2.87408e-07,3.01848e-07,3.16825e-07,3.32352e-07,     &
     & 3.48439e-07,3.65100e-07,3.82346e-07,4.00189e-07,4.18641e-07,     &
     & 4.37715e-07,4.57422e-07,4.77774e-07,4.98784e-07,5.20464e-07,     &
     & 5.42824e-07,5.65879e-07,5.89638e-07,6.14115e-07,6.39320e-07,     &
     & 6.65266e-07,6.91965e-07,7.19427e-07,7.47666e-07,7.76691e-07,     &
     & 8.06516e-07,8.37151e-07,8.68607e-07,9.00896e-07,9.34029e-07,     &
     & 9.68018e-07,1.00287e-06,1.03860e-06,1.07522e-06,1.11274e-06,     &
     & 1.15117e-06,1.19052e-06,1.23079e-06,1.27201e-06,1.31418e-06,     &
     & 1.35731e-06,1.40141e-06,1.44650e-06,1.49257e-06,1.53965e-06,     &
     & 1.58773e-06,1.63684e-06,1.68697e-06,1.73815e-06,1.79037e-06/
      data totplnk( 51:100, 6)  /                                       &
     & 1.84365e-06,1.89799e-06,1.95341e-06,2.00991e-06,2.06750e-06,     &
     & 2.12619e-06,2.18599e-06,2.24691e-06,2.30895e-06,2.37212e-06,     &
     & 2.43643e-06,2.50189e-06,2.56851e-06,2.63628e-06,2.70523e-06,     &
     & 2.77536e-06,2.84666e-06,2.91916e-06,2.99286e-06,3.06776e-06,     &
     & 3.14387e-06,3.22120e-06,3.29975e-06,3.37953e-06,3.46054e-06,     &
     & 3.54280e-06,3.62630e-06,3.71105e-06,3.79707e-06,3.88434e-06,     &
     & 3.97288e-06,4.06270e-06,4.15380e-06,4.24617e-06,4.33984e-06,     &
     & 4.43479e-06,4.53104e-06,4.62860e-06,4.72746e-06,4.82763e-06,     &
     & 4.92911e-06,5.03191e-06,5.13603e-06,5.24147e-06,5.34824e-06,     &
     & 5.45634e-06,5.56578e-06,5.67656e-06,5.78867e-06,5.90213e-06/
      data totplnk(101:150, 6)  /                                       &
     & 6.01694e-06,6.13309e-06,6.25060e-06,6.36947e-06,6.48968e-06,     &
     & 6.61126e-06,6.73420e-06,6.85850e-06,6.98417e-06,7.11120e-06,     &
     & 7.23961e-06,7.36938e-06,7.50053e-06,7.63305e-06,7.76694e-06,     &
     & 7.90221e-06,8.03887e-06,8.17690e-06,8.31632e-06,8.45710e-06,     &
     & 8.59928e-06,8.74282e-06,8.88776e-06,9.03409e-06,9.18179e-06,     &
     & 9.33088e-06,9.48136e-06,9.63323e-06,9.78648e-06,9.94111e-06,     &
     & 1.00971e-05,1.02545e-05,1.04133e-05,1.05735e-05,1.07351e-05,     &
     & 1.08980e-05,1.10624e-05,1.12281e-05,1.13952e-05,1.15637e-05,     &
     & 1.17335e-05,1.19048e-05,1.20774e-05,1.22514e-05,1.24268e-05,     &
     & 1.26036e-05,1.27817e-05,1.29612e-05,1.31421e-05,1.33244e-05/
      data totplnk(151:181, 6)  /                                       &
     & 1.35080e-05,1.36930e-05,1.38794e-05,1.40672e-05,1.42563e-05,     &
     & 1.44468e-05,1.46386e-05,1.48318e-05,1.50264e-05,1.52223e-05,     &
     & 1.54196e-05,1.56182e-05,1.58182e-05,1.60196e-05,1.62223e-05,     &
     & 1.64263e-05,1.66317e-05,1.68384e-05,1.70465e-05,1.72559e-05,     &
     & 1.74666e-05,1.76787e-05,1.78921e-05,1.81069e-05,1.83230e-05,     &
     & 1.85404e-05,1.87591e-05,1.89791e-05,1.92005e-05,1.94232e-05,     &
     & 1.96471e-05/
      data totplnk(  1: 50, 7)  /                                       &
     & 1.25349e-07,1.32735e-07,1.40458e-07,1.48527e-07,1.56954e-07,     &
     & 1.65748e-07,1.74920e-07,1.84481e-07,1.94443e-07,2.04814e-07,     &
     & 2.15608e-07,2.26835e-07,2.38507e-07,2.50634e-07,2.63229e-07,     &
     & 2.76301e-07,2.89864e-07,3.03930e-07,3.18508e-07,3.33612e-07,     &
     & 3.49253e-07,3.65443e-07,3.82195e-07,3.99519e-07,4.17428e-07,     &
     & 4.35934e-07,4.55050e-07,4.74785e-07,4.95155e-07,5.16170e-07,     &
     & 5.37844e-07,5.60186e-07,5.83211e-07,6.06929e-07,6.31355e-07,     &
     & 6.56498e-07,6.82373e-07,7.08990e-07,7.36362e-07,7.64501e-07,     &
     & 7.93420e-07,8.23130e-07,8.53643e-07,8.84971e-07,9.17128e-07,     &
     & 9.50123e-07,9.83969e-07,1.01868e-06,1.05426e-06,1.09073e-06/
      data totplnk( 51:100, 7)  /                                       &
     & 1.12810e-06,1.16638e-06,1.20558e-06,1.24572e-06,1.28680e-06,     &
     & 1.32883e-06,1.37183e-06,1.41581e-06,1.46078e-06,1.50675e-06,     &
     & 1.55374e-06,1.60174e-06,1.65078e-06,1.70087e-06,1.75200e-06,     &
     & 1.80421e-06,1.85749e-06,1.91186e-06,1.96732e-06,2.02389e-06,     &
     & 2.08159e-06,2.14040e-06,2.20035e-06,2.26146e-06,2.32372e-06,     &
     & 2.38714e-06,2.45174e-06,2.51753e-06,2.58451e-06,2.65270e-06,     &
     & 2.72210e-06,2.79272e-06,2.86457e-06,2.93767e-06,3.01201e-06,     &
     & 3.08761e-06,3.16448e-06,3.24261e-06,3.32204e-06,3.40275e-06,     &
     & 3.48476e-06,3.56808e-06,3.65271e-06,3.73866e-06,3.82595e-06,     &
     & 3.91456e-06,4.00453e-06,4.09584e-06,4.18851e-06,4.28254e-06/
      data totplnk(101:150, 7)  /                                       &
     & 4.37796e-06,4.47475e-06,4.57293e-06,4.67249e-06,4.77346e-06,     &
     & 4.87583e-06,4.97961e-06,5.08481e-06,5.19143e-06,5.29948e-06,     &
     & 5.40896e-06,5.51989e-06,5.63226e-06,5.74608e-06,5.86136e-06,     &
     & 5.97810e-06,6.09631e-06,6.21597e-06,6.33713e-06,6.45976e-06,     &
     & 6.58388e-06,6.70950e-06,6.83661e-06,6.96521e-06,7.09531e-06,     &
     & 7.22692e-06,7.36005e-06,7.49468e-06,7.63084e-06,7.76851e-06,     &
     & 7.90773e-06,8.04846e-06,8.19072e-06,8.33452e-06,8.47985e-06,     &
     & 8.62674e-06,8.77517e-06,8.92514e-06,9.07666e-06,9.22975e-06,     &
     & 9.38437e-06,9.54057e-06,9.69832e-06,9.85762e-06,1.00185e-05,     &
     & 1.01810e-05,1.03450e-05,1.05106e-05,1.06777e-05,1.08465e-05/
      data totplnk(151:181, 7)  /                                       &
     & 1.10168e-05,1.11887e-05,1.13621e-05,1.15372e-05,1.17138e-05,     &
     & 1.18920e-05,1.20718e-05,1.22532e-05,1.24362e-05,1.26207e-05,     &
     & 1.28069e-05,1.29946e-05,1.31839e-05,1.33749e-05,1.35674e-05,     &
     & 1.37615e-05,1.39572e-05,1.41544e-05,1.43533e-05,1.45538e-05,     &
     & 1.47558e-05,1.49595e-05,1.51647e-05,1.53716e-05,1.55800e-05,     &
     & 1.57900e-05,1.60017e-05,1.62149e-05,1.64296e-05,1.66460e-05,     &
     & 1.68640e-05/
      data totplnk(  1: 50, 8)  /                                       &
     & 6.74445e-08,7.18176e-08,7.64153e-08,8.12456e-08,8.63170e-08,     &
     & 9.16378e-08,9.72168e-08,1.03063e-07,1.09184e-07,1.15591e-07,     &
     & 1.22292e-07,1.29296e-07,1.36613e-07,1.44253e-07,1.52226e-07,     &
     & 1.60540e-07,1.69207e-07,1.78236e-07,1.87637e-07,1.97421e-07,     &
     & 2.07599e-07,2.18181e-07,2.29177e-07,2.40598e-07,2.52456e-07,     &
     & 2.64761e-07,2.77523e-07,2.90755e-07,3.04468e-07,3.18673e-07,     &
     & 3.33381e-07,3.48603e-07,3.64352e-07,3.80638e-07,3.97474e-07,     &
     & 4.14871e-07,4.32841e-07,4.51395e-07,4.70547e-07,4.90306e-07,     &
     & 5.10687e-07,5.31699e-07,5.53357e-07,5.75670e-07,5.98652e-07,     &
     & 6.22315e-07,6.46672e-07,6.71731e-07,6.97511e-07,7.24018e-07/
      data totplnk( 51:100, 8)  /                                       &
     & 7.51266e-07,7.79269e-07,8.08038e-07,8.37584e-07,8.67922e-07,     &
     & 8.99061e-07,9.31016e-07,9.63797e-07,9.97417e-07,1.03189e-06,     &
     & 1.06722e-06,1.10343e-06,1.14053e-06,1.17853e-06,1.21743e-06,     &
     & 1.25726e-06,1.29803e-06,1.33974e-06,1.38241e-06,1.42606e-06,     &
     & 1.47068e-06,1.51630e-06,1.56293e-06,1.61056e-06,1.65924e-06,     &
     & 1.70894e-06,1.75971e-06,1.81153e-06,1.86443e-06,1.91841e-06,     &
     & 1.97350e-06,2.02968e-06,2.08699e-06,2.14543e-06,2.20500e-06,     &
     & 2.26573e-06,2.32762e-06,2.39068e-06,2.45492e-06,2.52036e-06,     &
     & 2.58700e-06,2.65485e-06,2.72393e-06,2.79424e-06,2.86580e-06,     &
     & 2.93861e-06,3.01269e-06,3.08803e-06,3.16467e-06,3.24259e-06/
      data totplnk(101:150, 8)  /                                       &
     & 3.32181e-06,3.40235e-06,3.48420e-06,3.56739e-06,3.65192e-06,     &
     & 3.73779e-06,3.82502e-06,3.91362e-06,4.00359e-06,4.09494e-06,     &
     & 4.18768e-06,4.28182e-06,4.37737e-06,4.47434e-06,4.57273e-06,     &
     & 4.67254e-06,4.77380e-06,4.87651e-06,4.98067e-06,5.08630e-06,     &
     & 5.19339e-06,5.30196e-06,5.41201e-06,5.52356e-06,5.63660e-06,     &
     & 5.75116e-06,5.86722e-06,5.98479e-06,6.10390e-06,6.22453e-06,     &
     & 6.34669e-06,6.47042e-06,6.59569e-06,6.72252e-06,6.85090e-06,     &
     & 6.98085e-06,7.11238e-06,7.24549e-06,7.38019e-06,7.51646e-06,     &
     & 7.65434e-06,7.79382e-06,7.93490e-06,8.07760e-06,8.22192e-06,     &
     & 8.36784e-06,8.51540e-06,8.66459e-06,8.81542e-06,8.96786e-06/
      data totplnk(151:181, 8)  /                                       &
     & 9.12197e-06,9.27772e-06,9.43513e-06,9.59419e-06,9.75490e-06,     &
     & 9.91728e-06,1.00813e-05,1.02471e-05,1.04144e-05,1.05835e-05,     &
     & 1.07543e-05,1.09267e-05,1.11008e-05,1.12766e-05,1.14541e-05,     &
     & 1.16333e-05,1.18142e-05,1.19969e-05,1.21812e-05,1.23672e-05,     &
     & 1.25549e-05,1.27443e-05,1.29355e-05,1.31284e-05,1.33229e-05,     &
     & 1.35193e-05,1.37173e-05,1.39170e-05,1.41185e-05,1.43217e-05,     &
     & 1.45267e-05/
      data totplnk(  1: 50, 9)  /                                       &
     & 2.61522e-08,2.80613e-08,3.00838e-08,3.22250e-08,3.44899e-08,     &
     & 3.68841e-08,3.94129e-08,4.20820e-08,4.48973e-08,4.78646e-08,     &
     & 5.09901e-08,5.42799e-08,5.77405e-08,6.13784e-08,6.52001e-08,     &
     & 6.92126e-08,7.34227e-08,7.78375e-08,8.24643e-08,8.73103e-08,     &
     & 9.23832e-08,9.76905e-08,1.03240e-07,1.09039e-07,1.15097e-07,     &
     & 1.21421e-07,1.28020e-07,1.34902e-07,1.42075e-07,1.49548e-07,     &
     & 1.57331e-07,1.65432e-07,1.73860e-07,1.82624e-07,1.91734e-07,     &
     & 2.01198e-07,2.11028e-07,2.21231e-07,2.31818e-07,2.42799e-07,     &
     & 2.54184e-07,2.65983e-07,2.78205e-07,2.90862e-07,3.03963e-07,     &
     & 3.17519e-07,3.31541e-07,3.46039e-07,3.61024e-07,3.76507e-07/
      data totplnk( 51:100, 9)  /                                       &
     & 3.92498e-07,4.09008e-07,4.26050e-07,4.43633e-07,4.61769e-07,     &
     & 4.80469e-07,4.99744e-07,5.19606e-07,5.40067e-07,5.61136e-07,     &
     & 5.82828e-07,6.05152e-07,6.28120e-07,6.51745e-07,6.76038e-07,     &
     & 7.01010e-07,7.26674e-07,7.53041e-07,7.80124e-07,8.07933e-07,     &
     & 8.36482e-07,8.65781e-07,8.95845e-07,9.26683e-07,9.58308e-07,     &
     & 9.90732e-07,1.02397e-06,1.05803e-06,1.09292e-06,1.12866e-06,     &
     & 1.16526e-06,1.20274e-06,1.24109e-06,1.28034e-06,1.32050e-06,     &
     & 1.36158e-06,1.40359e-06,1.44655e-06,1.49046e-06,1.53534e-06,     &
     & 1.58120e-06,1.62805e-06,1.67591e-06,1.72478e-06,1.77468e-06,     &
     & 1.82561e-06,1.87760e-06,1.93066e-06,1.98479e-06,2.04000e-06/
      data totplnk(101:150, 9)  /                                       &
     & 2.09631e-06,2.15373e-06,2.21228e-06,2.27196e-06,2.33278e-06,     &
     & 2.39475e-06,2.45790e-06,2.52222e-06,2.58773e-06,2.65445e-06,     &
     & 2.72238e-06,2.79152e-06,2.86191e-06,2.93354e-06,3.00643e-06,     &
     & 3.08058e-06,3.15601e-06,3.23273e-06,3.31075e-06,3.39009e-06,     &
     & 3.47074e-06,3.55272e-06,3.63605e-06,3.72072e-06,3.80676e-06,     &
     & 3.89417e-06,3.98297e-06,4.07315e-06,4.16474e-06,4.25774e-06,     &
     & 4.35217e-06,4.44802e-06,4.54532e-06,4.64406e-06,4.74428e-06,     &
     & 4.84595e-06,4.94911e-06,5.05376e-06,5.15990e-06,5.26755e-06,     &
     & 5.37671e-06,5.48741e-06,5.59963e-06,5.71340e-06,5.82871e-06,     &
     & 5.94559e-06,6.06403e-06,6.18404e-06,6.30565e-06,6.42885e-06/
      data totplnk(151:181, 9)  /                                       &
     & 6.55364e-06,6.68004e-06,6.80806e-06,6.93771e-06,7.06898e-06,     &
     & 7.20190e-06,7.33646e-06,7.47267e-06,7.61056e-06,7.75010e-06,     &
     & 7.89133e-06,8.03423e-06,8.17884e-06,8.32514e-06,8.47314e-06,     &
     & 8.62284e-06,8.77427e-06,8.92743e-06,9.08231e-06,9.23893e-06,     &
     & 9.39729e-06,9.55741e-06,9.71927e-06,9.88291e-06,1.00483e-05,     &
     & 1.02155e-05,1.03844e-05,1.05552e-05,1.07277e-05,1.09020e-05,     &
     & 1.10781e-05/
      data totplnk(  1: 50,10)  /                                       &
     & 8.89300e-09,9.63263e-09,1.04235e-08,1.12685e-08,1.21703e-08,     &
     & 1.31321e-08,1.41570e-08,1.52482e-08,1.64090e-08,1.76428e-08,     &
     & 1.89533e-08,2.03441e-08,2.18190e-08,2.33820e-08,2.50370e-08,     &
     & 2.67884e-08,2.86402e-08,3.05969e-08,3.26632e-08,3.48436e-08,     &
     & 3.71429e-08,3.95660e-08,4.21179e-08,4.48040e-08,4.76294e-08,     &
     & 5.05996e-08,5.37201e-08,5.69966e-08,6.04349e-08,6.40411e-08,     &
     & 6.78211e-08,7.17812e-08,7.59276e-08,8.02670e-08,8.48059e-08,     &
     & 8.95508e-08,9.45090e-08,9.96873e-08,1.05093e-07,1.10733e-07,     &
     & 1.16614e-07,1.22745e-07,1.29133e-07,1.35786e-07,1.42711e-07,     &
     & 1.49916e-07,1.57410e-07,1.65202e-07,1.73298e-07,1.81709e-07/
      data totplnk( 51:100,10)  /                                       &
     & 1.90441e-07,1.99505e-07,2.08908e-07,2.18660e-07,2.28770e-07,     &
     & 2.39247e-07,2.50101e-07,2.61340e-07,2.72974e-07,2.85013e-07,     &
     & 2.97467e-07,3.10345e-07,3.23657e-07,3.37413e-07,3.51623e-07,     &
     & 3.66298e-07,3.81448e-07,3.97082e-07,4.13212e-07,4.29848e-07,     &
     & 4.47000e-07,4.64680e-07,4.82898e-07,5.01664e-07,5.20991e-07,     &
     & 5.40888e-07,5.61369e-07,5.82440e-07,6.04118e-07,6.26410e-07,     &
     & 6.49329e-07,6.72887e-07,6.97095e-07,7.21964e-07,7.47506e-07,     &
     & 7.73732e-07,8.00655e-07,8.28287e-07,8.56635e-07,8.85717e-07,     &
     & 9.15542e-07,9.46122e-07,9.77469e-07,1.00960e-06,1.04251e-06,     &
     & 1.07623e-06,1.11077e-06,1.14613e-06,1.18233e-06,1.21939e-06/
      data totplnk(101:150,10)  /                                       &
     & 1.25730e-06,1.29610e-06,1.33578e-06,1.37636e-06,1.41785e-06,     &
     & 1.46027e-06,1.50362e-06,1.54792e-06,1.59319e-06,1.63942e-06,     &
     & 1.68665e-06,1.73487e-06,1.78410e-06,1.83435e-06,1.88564e-06,     &
     & 1.93797e-06,1.99136e-06,2.04582e-06,2.10137e-06,2.15801e-06,     &
     & 2.21576e-06,2.27463e-06,2.33462e-06,2.39577e-06,2.45806e-06,     &
     & 2.52153e-06,2.58617e-06,2.65201e-06,2.71905e-06,2.78730e-06,     &
     & 2.85678e-06,2.92749e-06,2.99946e-06,3.07269e-06,3.14720e-06,     &
     & 3.22299e-06,3.30007e-06,3.37847e-06,3.45818e-06,3.53923e-06,     &
     & 3.62161e-06,3.70535e-06,3.79046e-06,3.87695e-06,3.96481e-06,     &
     & 4.05409e-06,4.14477e-06,4.23687e-06,4.33040e-06,4.42538e-06/
      data totplnk(151:181,10)  /                                       &
     & 4.52180e-06,4.61969e-06,4.71905e-06,4.81991e-06,4.92226e-06,     &
     & 5.02611e-06,5.13148e-06,5.23839e-06,5.34681e-06,5.45681e-06,     &
     & 5.56835e-06,5.68146e-06,5.79614e-06,5.91242e-06,6.03030e-06,     &
     & 6.14978e-06,6.27088e-06,6.39360e-06,6.51798e-06,6.64398e-06,     &
     & 6.77165e-06,6.90099e-06,7.03198e-06,7.16468e-06,7.29906e-06,     &
     & 7.43514e-06,7.57294e-06,7.71244e-06,7.85369e-06,7.99666e-06,     &
     & 8.14138e-06/
      data totplnk(  1: 50,11)  /                                       &
     & 2.53767e-09,2.77242e-09,3.02564e-09,3.29851e-09,3.59228e-09,     &
     & 3.90825e-09,4.24777e-09,4.61227e-09,5.00322e-09,5.42219e-09,     &
     & 5.87080e-09,6.35072e-09,6.86370e-09,7.41159e-09,7.99628e-09,     &
     & 8.61974e-09,9.28404e-09,9.99130e-09,1.07437e-08,1.15436e-08,     &
     & 1.23933e-08,1.32953e-08,1.42522e-08,1.52665e-08,1.63410e-08,     &
     & 1.74786e-08,1.86820e-08,1.99542e-08,2.12985e-08,2.27179e-08,     &
     & 2.42158e-08,2.57954e-08,2.74604e-08,2.92141e-08,3.10604e-08,     &
     & 3.30029e-08,3.50457e-08,3.71925e-08,3.94476e-08,4.18149e-08,     &
     & 4.42991e-08,4.69043e-08,4.96352e-08,5.24961e-08,5.54921e-08,     &
     & 5.86277e-08,6.19081e-08,6.53381e-08,6.89231e-08,7.26681e-08/
      data totplnk( 51:100,11)  /                                       &
     & 7.65788e-08,8.06604e-08,8.49187e-08,8.93591e-08,9.39879e-08,     &
     & 9.88106e-08,1.03834e-07,1.09063e-07,1.14504e-07,1.20165e-07,     &
     & 1.26051e-07,1.32169e-07,1.38525e-07,1.45128e-07,1.51982e-07,     &
     & 1.59096e-07,1.66477e-07,1.74132e-07,1.82068e-07,1.90292e-07,     &
     & 1.98813e-07,2.07638e-07,2.16775e-07,2.26231e-07,2.36015e-07,     &
     & 2.46135e-07,2.56599e-07,2.67415e-07,2.78592e-07,2.90137e-07,     &
     & 3.02061e-07,3.14371e-07,3.27077e-07,3.40186e-07,3.53710e-07,     &
     & 3.67655e-07,3.82031e-07,3.96848e-07,4.12116e-07,4.27842e-07,     &
     & 4.44039e-07,4.60713e-07,4.77876e-07,4.95537e-07,5.13706e-07,     &
     & 5.32392e-07,5.51608e-07,5.71360e-07,5.91662e-07,6.12521e-07/
      data totplnk(101:150,11)  /                                       &
     & 6.33950e-07,6.55958e-07,6.78556e-07,7.01753e-07,7.25562e-07,     &
     & 7.49992e-07,7.75055e-07,8.00760e-07,8.27120e-07,8.54145e-07,     &
     & 8.81845e-07,9.10233e-07,9.39318e-07,9.69113e-07,9.99627e-07,     &
     & 1.03087e-06,1.06286e-06,1.09561e-06,1.12912e-06,1.16340e-06,     &
     & 1.19848e-06,1.23435e-06,1.27104e-06,1.30855e-06,1.34690e-06,     &
     & 1.38609e-06,1.42614e-06,1.46706e-06,1.50886e-06,1.55155e-06,     &
     & 1.59515e-06,1.63967e-06,1.68512e-06,1.73150e-06,1.77884e-06,     &
     & 1.82715e-06,1.87643e-06,1.92670e-06,1.97797e-06,2.03026e-06,     &
     & 2.08356e-06,2.13791e-06,2.19330e-06,2.24975e-06,2.30728e-06,     &
     & 2.36589e-06,2.42560e-06,2.48641e-06,2.54835e-06,2.61142e-06/
      data totplnk(151:181,11)  /                                       &
     & 2.67563e-06,2.74100e-06,2.80754e-06,2.87526e-06,2.94417e-06,     &
     & 3.01429e-06,3.08562e-06,3.15819e-06,3.23199e-06,3.30704e-06,     &
     & 3.38336e-06,3.46096e-06,3.53984e-06,3.62002e-06,3.70151e-06,     &
     & 3.78433e-06,3.86848e-06,3.95399e-06,4.04084e-06,4.12907e-06,     &
     & 4.21868e-06,4.30968e-06,4.40209e-06,4.49592e-06,4.59117e-06,     &
     & 4.68786e-06,4.78600e-06,4.88561e-06,4.98669e-06,5.08926e-06,     &
     & 5.19332e-06/
      data totplnk(  1: 50,12)  /                                       &
     & 2.73921e-10,3.04500e-10,3.38056e-10,3.74835e-10,4.15099e-10,     &
     & 4.59126e-10,5.07214e-10,5.59679e-10,6.16857e-10,6.79103e-10,     &
     & 7.46796e-10,8.20335e-10,9.00144e-10,9.86671e-10,1.08039e-09,     &
     & 1.18180e-09,1.29142e-09,1.40982e-09,1.53757e-09,1.67529e-09,     &
     & 1.82363e-09,1.98327e-09,2.15492e-09,2.33932e-09,2.53726e-09,     &
     & 2.74957e-09,2.97710e-09,3.22075e-09,3.48145e-09,3.76020e-09,     &
     & 4.05801e-09,4.37595e-09,4.71513e-09,5.07672e-09,5.46193e-09,     &
     & 5.87201e-09,6.30827e-09,6.77205e-09,7.26480e-09,7.78794e-09,     &
     & 8.34304e-09,8.93163e-09,9.55537e-09,1.02159e-08,1.09151e-08,     &
     & 1.16547e-08,1.24365e-08,1.32625e-08,1.41348e-08,1.50554e-08/
      data totplnk( 51:100,12)  /                                       &
     & 1.60264e-08,1.70500e-08,1.81285e-08,1.92642e-08,2.04596e-08,     &
     & 2.17171e-08,2.30394e-08,2.44289e-08,2.58885e-08,2.74209e-08,     &
     & 2.90290e-08,3.07157e-08,3.24841e-08,3.43371e-08,3.62782e-08,     &
     & 3.83103e-08,4.04371e-08,4.26617e-08,4.49878e-08,4.74190e-08,     &
     & 4.99589e-08,5.26113e-08,5.53801e-08,5.82692e-08,6.12826e-08,     &
     & 6.44245e-08,6.76991e-08,7.11105e-08,7.46634e-08,7.83621e-08,     &
     & 8.22112e-08,8.62154e-08,9.03795e-08,9.47081e-08,9.92066e-08,     &
     & 1.03879e-07,1.08732e-07,1.13770e-07,1.18998e-07,1.24422e-07,     &
     & 1.30048e-07,1.35880e-07,1.41924e-07,1.48187e-07,1.54675e-07,     &
     & 1.61392e-07,1.68346e-07,1.75543e-07,1.82988e-07,1.90688e-07/
      data totplnk(101:150,12)  /                                       &
     & 1.98650e-07,2.06880e-07,2.15385e-07,2.24172e-07,2.33247e-07,     &
     & 2.42617e-07,2.52289e-07,2.62272e-07,2.72571e-07,2.83193e-07,     &
     & 2.94147e-07,3.05440e-07,3.17080e-07,3.29074e-07,3.41430e-07,     &
     & 3.54155e-07,3.67259e-07,3.80747e-07,3.94631e-07,4.08916e-07,     &
     & 4.23611e-07,4.38725e-07,4.54267e-07,4.70245e-07,4.86666e-07,     &
     & 5.03541e-07,5.20879e-07,5.38687e-07,5.56975e-07,5.75751e-07,     &
     & 5.95026e-07,6.14808e-07,6.35107e-07,6.55932e-07,6.77293e-07,     &
     & 6.99197e-07,7.21656e-07,7.44681e-07,7.68278e-07,7.92460e-07,     &
     & 8.17235e-07,8.42614e-07,8.68606e-07,8.95223e-07,9.22473e-07,     &
     & 9.50366e-07,9.78915e-07,1.00813e-06,1.03802e-06,1.06859e-06/
      data totplnk(151:181,12)  /                                       &
     & 1.09986e-06,1.13184e-06,1.16453e-06,1.19796e-06,1.23212e-06,     &
     & 1.26703e-06,1.30270e-06,1.33915e-06,1.37637e-06,1.41440e-06,     &
     & 1.45322e-06,1.49286e-06,1.53333e-06,1.57464e-06,1.61679e-06,     &
     & 1.65981e-06,1.70370e-06,1.74847e-06,1.79414e-06,1.84071e-06,     &
     & 1.88821e-06,1.93663e-06,1.98599e-06,2.03631e-06,2.08759e-06,     &
     & 2.13985e-06,2.19310e-06,2.24734e-06,2.30260e-06,2.35888e-06,     &
     & 2.41619e-06/
      data totplnk(  1: 50,13)  /                                       &
     & 4.53634e-11,5.11435e-11,5.75754e-11,6.47222e-11,7.26531e-11,     &
     & 8.14420e-11,9.11690e-11,1.01921e-10,1.13790e-10,1.26877e-10,     &
     & 1.41288e-10,1.57140e-10,1.74555e-10,1.93665e-10,2.14613e-10,     &
     & 2.37548e-10,2.62633e-10,2.90039e-10,3.19948e-10,3.52558e-10,     &
     & 3.88073e-10,4.26716e-10,4.68719e-10,5.14331e-10,5.63815e-10,     &
     & 6.17448e-10,6.75526e-10,7.38358e-10,8.06277e-10,8.79625e-10,     &
     & 9.58770e-10,1.04410e-09,1.13602e-09,1.23495e-09,1.34135e-09,     &
     & 1.45568e-09,1.57845e-09,1.71017e-09,1.85139e-09,2.00268e-09,     &
     & 2.16464e-09,2.33789e-09,2.52309e-09,2.72093e-09,2.93212e-09,     &
     & 3.15740e-09,3.39757e-09,3.65341e-09,3.92579e-09,4.21559e-09/
      data totplnk( 51:100,13)  /                                       &
     & 4.52372e-09,4.85115e-09,5.19886e-09,5.56788e-09,5.95928e-09,     &
     & 6.37419e-09,6.81375e-09,7.27917e-09,7.77168e-09,8.29256e-09,     &
     & 8.84317e-09,9.42487e-09,1.00391e-08,1.06873e-08,1.13710e-08,     &
     & 1.20919e-08,1.28515e-08,1.36514e-08,1.44935e-08,1.53796e-08,     &
     & 1.63114e-08,1.72909e-08,1.83201e-08,1.94008e-08,2.05354e-08,     &
     & 2.17258e-08,2.29742e-08,2.42830e-08,2.56545e-08,2.70910e-08,     &
     & 2.85950e-08,3.01689e-08,3.18155e-08,3.35373e-08,3.53372e-08,     &
     & 3.72177e-08,3.91818e-08,4.12325e-08,4.33727e-08,4.56056e-08,     &
     & 4.79342e-08,5.03617e-08,5.28915e-08,5.55270e-08,5.82715e-08,     &
     & 6.11286e-08,6.41019e-08,6.71951e-08,7.04119e-08,7.37560e-08/
      data totplnk(101:150,13)  /                                       &
     & 7.72315e-08,8.08424e-08,8.45927e-08,8.84866e-08,9.25281e-08,     &
     & 9.67218e-08,1.01072e-07,1.05583e-07,1.10260e-07,1.15107e-07,     &
     & 1.20128e-07,1.25330e-07,1.30716e-07,1.36291e-07,1.42061e-07,     &
     & 1.48031e-07,1.54206e-07,1.60592e-07,1.67192e-07,1.74015e-07,     &
     & 1.81064e-07,1.88345e-07,1.95865e-07,2.03628e-07,2.11643e-07,     &
     & 2.19912e-07,2.28443e-07,2.37244e-07,2.46318e-07,2.55673e-07,     &
     & 2.65316e-07,2.75252e-07,2.85489e-07,2.96033e-07,3.06891e-07,     &
     & 3.18070e-07,3.29576e-07,3.41417e-07,3.53600e-07,3.66133e-07,     &
     & 3.79021e-07,3.92274e-07,4.05897e-07,4.19899e-07,4.34288e-07,     &
     & 4.49071e-07,4.64255e-07,4.79850e-07,4.95863e-07,5.12300e-07/
      data totplnk(151:181,13)  /                                       &
     & 5.29172e-07,5.46486e-07,5.64250e-07,5.82473e-07,6.01164e-07,     &
     & 6.20329e-07,6.39979e-07,6.60122e-07,6.80767e-07,7.01922e-07,     &
     & 7.23596e-07,7.45800e-07,7.68539e-07,7.91826e-07,8.15669e-07,     &
     & 8.40076e-07,8.65058e-07,8.90623e-07,9.16783e-07,9.43544e-07,     &
     & 9.70917e-07,9.98912e-07,1.02754e-06,1.05681e-06,1.08673e-06,     &
     & 1.11731e-06,1.14856e-06,1.18050e-06,1.21312e-06,1.24645e-06,     &
     & 1.28049e-06/
      data totplnk(  1: 50,14)  /                                       &
     & 1.40113e-11,1.59358e-11,1.80960e-11,2.05171e-11,2.32266e-11,     &
     & 2.62546e-11,2.96335e-11,3.33990e-11,3.75896e-11,4.22469e-11,     &
     & 4.74164e-11,5.31466e-11,5.94905e-11,6.65054e-11,7.42522e-11,     &
     & 8.27975e-11,9.22122e-11,1.02573e-10,1.13961e-10,1.26466e-10,     &
     & 1.40181e-10,1.55206e-10,1.71651e-10,1.89630e-10,2.09265e-10,     &
     & 2.30689e-10,2.54040e-10,2.79467e-10,3.07128e-10,3.37190e-10,     &
     & 3.69833e-10,4.05243e-10,4.43623e-10,4.85183e-10,5.30149e-10,     &
     & 5.78755e-10,6.31255e-10,6.87910e-10,7.49002e-10,8.14824e-10,     &
     & 8.85687e-10,9.61914e-10,1.04385e-09,1.13186e-09,1.22631e-09,     &
     & 1.32761e-09,1.43617e-09,1.55243e-09,1.67686e-09,1.80992e-09/
      data totplnk( 51:100,14)  /                                       &
     & 1.95212e-09,2.10399e-09,2.26607e-09,2.43895e-09,2.62321e-09,     &
     & 2.81949e-09,3.02844e-09,3.25073e-09,3.48707e-09,3.73820e-09,     &
     & 4.00490e-09,4.28794e-09,4.58819e-09,4.90647e-09,5.24371e-09,     &
     & 5.60081e-09,5.97875e-09,6.37854e-09,6.80120e-09,7.24782e-09,     &
     & 7.71950e-09,8.21740e-09,8.74271e-09,9.29666e-09,9.88054e-09,     &
     & 1.04956e-08,1.11434e-08,1.18251e-08,1.25422e-08,1.32964e-08,     &
     & 1.40890e-08,1.49217e-08,1.57961e-08,1.67140e-08,1.76771e-08,     &
     & 1.86870e-08,1.97458e-08,2.08553e-08,2.20175e-08,2.32342e-08,     &
     & 2.45077e-08,2.58401e-08,2.72334e-08,2.86900e-08,3.02122e-08,     &
     & 3.18021e-08,3.34624e-08,3.51954e-08,3.70037e-08,3.88899e-08/
      data totplnk(101:150,14)  /                                       &
     & 4.08568e-08,4.29068e-08,4.50429e-08,4.72678e-08,4.95847e-08,     &
     & 5.19963e-08,5.45058e-08,5.71161e-08,5.98309e-08,6.26529e-08,     &
     & 6.55857e-08,6.86327e-08,7.17971e-08,7.50829e-08,7.84933e-08,     &
     & 8.20323e-08,8.57035e-08,8.95105e-08,9.34579e-08,9.75488e-08,     &
     & 1.01788e-07,1.06179e-07,1.10727e-07,1.15434e-07,1.20307e-07,     &
     & 1.25350e-07,1.30566e-07,1.35961e-07,1.41539e-07,1.47304e-07,     &
     & 1.53263e-07,1.59419e-07,1.65778e-07,1.72345e-07,1.79124e-07,     &
     & 1.86122e-07,1.93343e-07,2.00792e-07,2.08476e-07,2.16400e-07,     &
     & 2.24568e-07,2.32988e-07,2.41666e-07,2.50605e-07,2.59813e-07,     &
     & 2.69297e-07,2.79060e-07,2.89111e-07,2.99455e-07,3.10099e-07/
      data totplnk(151:181,14)  /                                       &
     & 3.21049e-07,3.32311e-07,3.43893e-07,3.55801e-07,3.68041e-07,     &
     & 3.80621e-07,3.93547e-07,4.06826e-07,4.20465e-07,4.34473e-07,     &
     & 4.48856e-07,4.63620e-07,4.78774e-07,4.94325e-07,5.10280e-07,     &
     & 5.26648e-07,5.43436e-07,5.60652e-07,5.78302e-07,5.96397e-07,     &
     & 6.14943e-07,6.33949e-07,6.53421e-07,6.73370e-07,6.93803e-07,     &
     & 7.14731e-07,7.36157e-07,7.58095e-07,7.80549e-07,8.03533e-07,     &
     & 8.27050e-07/
      data totplnk(  1: 50,15)  /                                       &
     & 3.90483e-12,4.47999e-12,5.13122e-12,5.86739e-12,6.69829e-12,     &
     & 7.63467e-12,8.68833e-12,9.87221e-12,1.12005e-11,1.26885e-11,     &
     & 1.43534e-11,1.62134e-11,1.82888e-11,2.06012e-11,2.31745e-11,     &
     & 2.60343e-11,2.92087e-11,3.27277e-11,3.66242e-11,4.09334e-11,     &
     & 4.56935e-11,5.09455e-11,5.67338e-11,6.31057e-11,7.01127e-11,     &
     & 7.78096e-11,8.62554e-11,9.55130e-11,1.05651e-10,1.16740e-10,     &
     & 1.28858e-10,1.42089e-10,1.56519e-10,1.72243e-10,1.89361e-10,     &
     & 2.07978e-10,2.28209e-10,2.50173e-10,2.73999e-10,2.99820e-10,     &
     & 3.27782e-10,3.58034e-10,3.90739e-10,4.26067e-10,4.64196e-10,     &
     & 5.05317e-10,5.49631e-10,5.97347e-10,6.48689e-10,7.03891e-10/
      data totplnk( 51:100,15)  /                                       &
     & 7.63201e-10,8.26876e-10,8.95192e-10,9.68430e-10,1.04690e-09,     &
     & 1.13091e-09,1.22079e-09,1.31689e-09,1.41957e-09,1.52922e-09,     &
     & 1.64623e-09,1.77101e-09,1.90401e-09,2.04567e-09,2.19647e-09,     &
     & 2.35690e-09,2.52749e-09,2.70875e-09,2.90127e-09,3.10560e-09,     &
     & 3.32238e-09,3.55222e-09,3.79578e-09,4.05375e-09,4.32682e-09,     &
     & 4.61574e-09,4.92128e-09,5.24420e-09,5.58536e-09,5.94558e-09,     &
     & 6.32575e-09,6.72678e-09,7.14964e-09,7.59526e-09,8.06470e-09,     &
     & 8.55897e-09,9.07916e-09,9.62638e-09,1.02018e-08,1.08066e-08,     &
     & 1.14420e-08,1.21092e-08,1.28097e-08,1.35446e-08,1.43155e-08,     &
     & 1.51237e-08,1.59708e-08,1.68581e-08,1.77873e-08,1.87599e-08/
      data totplnk(101:150,15)  /                                       &
     & 1.97777e-08,2.08423e-08,2.19555e-08,2.31190e-08,2.43348e-08,     &
     & 2.56045e-08,2.69302e-08,2.83140e-08,2.97578e-08,3.12636e-08,     &
     & 3.28337e-08,3.44702e-08,3.61755e-08,3.79516e-08,3.98012e-08,     &
     & 4.17265e-08,4.37300e-08,4.58143e-08,4.79819e-08,5.02355e-08,     &
     & 5.25777e-08,5.50114e-08,5.75393e-08,6.01644e-08,6.28896e-08,     &
     & 6.57177e-08,6.86521e-08,7.16959e-08,7.48520e-08,7.81239e-08,     &
     & 8.15148e-08,8.50282e-08,8.86675e-08,9.24362e-08,9.63380e-08,     &
     & 1.00376e-07,1.04555e-07,1.08878e-07,1.13349e-07,1.17972e-07,     &
     & 1.22751e-07,1.27690e-07,1.32793e-07,1.38064e-07,1.43508e-07,     &
     & 1.49129e-07,1.54931e-07,1.60920e-07,1.67099e-07,1.73473e-07/
      data totplnk(151:181,15)  /                                       &
     & 1.80046e-07,1.86825e-07,1.93812e-07,2.01014e-07,2.08436e-07,     &
     & 2.16082e-07,2.23957e-07,2.32067e-07,2.40418e-07,2.49013e-07,     &
     & 2.57860e-07,2.66963e-07,2.76328e-07,2.85961e-07,2.95868e-07,     &
     & 3.06053e-07,3.16524e-07,3.27286e-07,3.38345e-07,3.49707e-07,     &
     & 3.61379e-07,3.73367e-07,3.85676e-07,3.98315e-07,4.11287e-07,     &
     & 4.24602e-07,4.38265e-07,4.52283e-07,4.66662e-07,4.81410e-07,     &
     & 4.96535e-07/
      data totplnk(  1: 50,16)  /                                       &
     & 0.28639e-12,0.33349e-12,0.38764e-12,0.44977e-12,0.52093e-12,     &
     & 0.60231e-12,0.69522e-12,0.80111e-12,0.92163e-12,0.10586e-11,     &
     & 0.12139e-11,0.13899e-11,0.15890e-11,0.18138e-11,0.20674e-11,     &
     & 0.23531e-11,0.26744e-11,0.30352e-11,0.34401e-11,0.38936e-11,     &
     & 0.44011e-11,0.49681e-11,0.56010e-11,0.63065e-11,0.70919e-11,     &
     & 0.79654e-11,0.89357e-11,0.10012e-10,0.11205e-10,0.12526e-10,     &
     & 0.13986e-10,0.15600e-10,0.17380e-10,0.19342e-10,0.21503e-10,     &
     & 0.23881e-10,0.26494e-10,0.29362e-10,0.32509e-10,0.35958e-10,     &
     & 0.39733e-10,0.43863e-10,0.48376e-10,0.53303e-10,0.58679e-10,     &
     & 0.64539e-10,0.70920e-10,0.77864e-10,0.85413e-10,0.93615e-10/
      data totplnk( 51:100,16)  /                                       &
     & 0.10252e-09,0.11217e-09,0.12264e-09,0.13397e-09,0.14624e-09,     &
     & 0.15950e-09,0.17383e-09,0.18930e-09,0.20599e-09,0.22399e-09,     &
     & 0.24339e-09,0.26427e-09,0.28674e-09,0.31090e-09,0.33686e-09,     &
     & 0.36474e-09,0.39466e-09,0.42676e-09,0.46115e-09,0.49800e-09,     &
     & 0.53744e-09,0.57964e-09,0.62476e-09,0.67298e-09,0.72448e-09,     &
     & 0.77945e-09,0.83809e-09,0.90062e-09,0.96725e-09,0.10382e-08,     &
     & 0.11138e-08,0.11941e-08,0.12796e-08,0.13704e-08,0.14669e-08,     &
     & 0.15694e-08,0.16781e-08,0.17934e-08,0.19157e-08,0.20453e-08,     &
     & 0.21825e-08,0.23278e-08,0.24815e-08,0.26442e-08,0.28161e-08,     &
     & 0.29978e-08,0.31898e-08,0.33925e-08,0.36064e-08,0.38321e-08/
      data totplnk(101:150,16)  /                                       &
     & 0.40700e-08,0.43209e-08,0.45852e-08,0.48636e-08,0.51567e-08,     &
     & 0.54652e-08,0.57897e-08,0.61310e-08,0.64897e-08,0.68667e-08,     &
     & 0.72626e-08,0.76784e-08,0.81148e-08,0.85727e-08,0.90530e-08,     &
     & 0.95566e-08,0.10084e-07,0.10638e-07,0.11217e-07,0.11824e-07,     &
     & 0.12458e-07,0.13123e-07,0.13818e-07,0.14545e-07,0.15305e-07,     &
     & 0.16099e-07,0.16928e-07,0.17795e-07,0.18699e-07,0.19643e-07,     &
     & 0.20629e-07,0.21656e-07,0.22728e-07,0.23845e-07,0.25010e-07,     &
     & 0.26223e-07,0.27487e-07,0.28804e-07,0.30174e-07,0.31600e-07,     &
     & 0.33084e-07,0.34628e-07,0.36233e-07,0.37902e-07,0.39637e-07,     &
     & 0.41440e-07,0.43313e-07,0.45259e-07,0.47279e-07,0.49376e-07/
      data totplnk(151:181,16)  /                                       &
     & 0.51552e-07,0.53810e-07,0.56153e-07,0.58583e-07,0.61102e-07,     &
     & 0.63713e-07,0.66420e-07,0.69224e-07,0.72129e-07,0.75138e-07,     &
     & 0.78254e-07,0.81479e-07,0.84818e-07,0.88272e-07,0.91846e-07,     &
     & 0.95543e-07,0.99366e-07,0.10332e-06,0.10740e-06,0.11163e-06,     &
     & 0.11599e-06,0.12050e-06,0.12515e-06,0.12996e-06,0.13493e-06,     &
     & 0.14005e-06,0.14534e-06,0.15080e-06,0.15643e-06,0.16224e-06,     &
     & 0.16823e-06/

!........................................!
      end module module_radlw_avplank    !
!========================================!


!========================================!
      module module_radlw_ref            !
!........................................!
!
      use physparam,               only : kind_phys
!
      implicit none
!
      public

!  ---  reference pressure and temperature
      real (kind=kind_phys), dimension(59) :: pref, preflog, tref

!  ...  these pressures are chosen such that the ln of the first one
!       has only a few non-zero digits (i.e. ln(pref(1)) = 6.96000) and
!       each subsequent ln(pref) differs from the previous one by 0.2.
      data pref /                                                       &
     &    1.05363e+03,8.62642e+02,7.06272e+02,5.78246e+02,4.73428e+02,  &
     &    3.87610e+02,3.17348e+02,2.59823e+02,2.12725e+02,1.74164e+02,  &
     &    1.42594e+02,1.16746e+02,9.55835e+01,7.82571e+01,6.40715e+01,  &
     &    5.24573e+01,4.29484e+01,3.51632e+01,2.87892e+01,2.35706e+01,  &
     &    1.92980e+01,1.57998e+01,1.29358e+01,1.05910e+01,8.67114e+00,  &
     &    7.09933e+00,5.81244e+00,4.75882e+00,3.89619e+00,3.18993e+00,  &
     &    2.61170e+00,2.13828e+00,1.75067e+00,1.43333e+00,1.17351e+00,  &
     &    9.60789e-01,7.86628e-01,6.44036e-01,5.27292e-01,4.31710e-01,  &
     &    3.53455e-01,2.89384e-01,2.36928e-01,1.93980e-01,1.58817e-01,  &
     &    1.30029e-01,1.06458e-01,8.71608e-02,7.13612e-02,5.84256e-02,  &
     &    4.78349e-02,3.91639e-02,3.20647e-02,2.62523e-02,2.14936e-02,  &
     &    1.75975e-02,1.44076e-02,1.17959e-02,9.65769e-03 /
      data preflog /                                                    &
     &     6.9600e+00, 6.7600e+00, 6.5600e+00, 6.3600e+00, 6.1600e+00,  &
     &     5.9600e+00, 5.7600e+00, 5.5600e+00, 5.3600e+00, 5.1600e+00,  &
     &     4.9600e+00, 4.7600e+00, 4.5600e+00, 4.3600e+00, 4.1600e+00,  &
     &     3.9600e+00, 3.7600e+00, 3.5600e+00, 3.3600e+00, 3.1600e+00,  &
     &     2.9600e+00, 2.7600e+00, 2.5600e+00, 2.3600e+00, 2.1600e+00,  &
     &     1.9600e+00, 1.7600e+00, 1.5600e+00, 1.3600e+00, 1.1600e+00,  &
     &     9.6000e-01, 7.6000e-01, 5.6000e-01, 3.6000e-01, 1.6000e-01,  &
     &    -4.0000e-02,-2.4000e-01,-4.4000e-01,-6.4000e-01,-8.4000e-01,  &
     &    -1.0400e+00,-1.2400e+00,-1.4400e+00,-1.6400e+00,-1.8400e+00,  &
     &    -2.0400e+00,-2.2400e+00,-2.4400e+00,-2.6400e+00,-2.8400e+00,  &
     &    -3.0400e+00,-3.2400e+00,-3.4400e+00,-3.6400e+00,-3.8400e+00,  &
     &    -4.0400e+00,-4.2400e+00,-4.4400e+00,-4.6400e+00 /

!  ...  these are the temperatures associated with the respective
!       pressures for the MLS standard atmosphere.
      data tref /                                                       &
     &     2.9420E+02, 2.8799E+02, 2.7894E+02, 2.6925E+02, 2.5983E+02,  &
     &     2.5017E+02, 2.4077E+02, 2.3179E+02, 2.2306E+02, 2.1578E+02,  &
     &     2.1570E+02, 2.1570E+02, 2.1570E+02, 2.1706E+02, 2.1858E+02,  &
     &     2.2018E+02, 2.2174E+02, 2.2328E+02, 2.2479E+02, 2.2655E+02,  &
     &     2.2834E+02, 2.3113E+02, 2.3401E+02, 2.3703E+02, 2.4022E+02,  &
     &     2.4371E+02, 2.4726E+02, 2.5085E+02, 2.5457E+02, 2.5832E+02,  &
     &     2.6216E+02, 2.6606E+02, 2.6999E+02, 2.7340E+02, 2.7536E+02,  &
     &     2.7568E+02, 2.7372E+02, 2.7163E+02, 2.6955E+02, 2.6593E+02,  &
     &     2.6211E+02, 2.5828E+02, 2.5360E+02, 2.4854E+02, 2.4348E+02,  &
     &     2.3809E+02, 2.3206E+02, 2.2603E+02, 2.2000E+02, 2.1435E+02,  &
     &     2.0887E+02, 2.0340E+02, 1.9792E+02, 1.9290E+02, 1.8809E+02,  &
     &     1.8329E+02, 1.7849E+02, 1.7394E+02, 1.7212E+02 /

      real (kind=kind_phys), dimension(7,59) :: chi_mls
      data chi_mls(1,1:12)  /                                           &
     &  1.8760e-02, 1.2223e-02, 5.8909e-03, 2.7675e-03, 1.4065e-03,     &
     &  7.5970e-04, 3.8876e-04, 1.6542e-04, 3.7190e-05, 7.4765e-06,     &
     &  4.3082e-06, 3.3319e-06/
      data chi_mls(1,13:59)  /                                          &
     &  3.2039e-06,  3.1619e-06,  3.2524e-06,  3.4226e-06,  3.6288e-06, &
     &  3.9148e-06,  4.1488e-06,  4.3081e-06,  4.4420e-06,  4.5778e-06, &
     &  4.7087e-06,  4.7943e-06,  4.8697e-06,  4.9260e-06,  4.9669e-06, &
     &  4.9963e-06,  5.0527e-06,  5.1266e-06,  5.2503e-06,  5.3571e-06, &
     &  5.4509e-06,  5.4830e-06,  5.5000e-06,  5.5000e-06,  5.4536e-06, &
     &  5.4047e-06,  5.3558e-06,  5.2533e-06,  5.1436e-06,  5.0340e-06, &
     &  4.8766e-06,  4.6979e-06,  4.5191e-06,  4.3360e-06,  4.1442e-06, &
     &  3.9523e-06,  3.7605e-06,  3.5722e-06,  3.3855e-06,  3.1988e-06, &
     &  3.0121e-06,  2.8262e-06,  2.6407e-06,  2.4552e-06,  2.2696e-06, &
     &  4.3360e-06,  4.1442e-06/

      data chi_mls(2,1:12)  /                                           &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04/
      data chi_mls(2,13:59)  /                                          &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04,  3.5500e-04, &
     &  3.5500e-04,  3.5471e-04,  3.5427e-04,  3.5384e-04,  3.5340e-04, &
     &  3.5500e-04,  3.5500e-04/

      data chi_mls(3,1:12)  /                                           &
     &  3.0170e-08,  3.4725e-08,  4.2477e-08,  5.2759e-08,  6.6944e-08, &
     &  8.7130e-08,  1.1391e-07,  1.5677e-07,  2.1788e-07,  3.2443e-07, &
     &  4.6594e-07,  5.6806e-07/
      data chi_mls(3,13:59)  /                                          &
     &  6.9607e-07,  1.1186e-06,  1.7618e-06,  2.3269e-06,  2.9577e-06, &
     &  3.6593e-06,  4.5950e-06,  5.3189e-06,  5.9618e-06,  6.5113e-06, &
     &  7.0635e-06,  7.6917e-06,  8.2577e-06,  8.7082e-06,  8.8325e-06, &
     &  8.7149e-06,  8.0943e-06,  7.3307e-06,  6.3101e-06,  5.3672e-06, &
     &  4.4829e-06,  3.8391e-06,  3.2827e-06,  2.8235e-06,  2.4906e-06, &
     &  2.1645e-06,  1.8385e-06,  1.6618e-06,  1.5052e-06,  1.3485e-06, &
     &  1.1972e-06,  1.0482e-06,  8.9926e-07,  7.6343e-07,  6.5381e-07, &
     &  5.4419e-07,  4.3456e-07,  3.6421e-07,  3.1194e-07,  2.5967e-07, &
     &  2.0740e-07,  1.9146e-07,  1.9364e-07,  1.9582e-07,  1.9800e-07, &
     &  7.6343e-07,  6.5381e-07/

      data chi_mls(4,1:12)  /                                           &
     &  3.2000e-07,  3.2000e-07,  3.2000e-07,  3.2000e-07,  3.2000e-07, &
     &  3.1965e-07,  3.1532e-07,  3.0383e-07,  2.9422e-07,  2.8495e-07, &
     &  2.7671e-07,  2.6471e-07/
      data chi_mls(4,13:59)  /                                          &
     &  2.4285e-07,  2.0955e-07,  1.7195e-07,  1.3749e-07,  1.1332e-07, &
     &  1.0035e-07,  9.1281e-08,  8.5463e-08,  8.0363e-08,  7.3372e-08, &
     &  6.5975e-08,  5.6039e-08,  4.7090e-08,  3.9977e-08,  3.2979e-08, &
     &  2.6064e-08,  2.1066e-08,  1.6592e-08,  1.3017e-08,  1.0090e-08, &
     &  7.6249e-09,  6.1159e-09,  4.6672e-09,  3.2857e-09,  2.8484e-09, &
     &  2.4620e-09,  2.0756e-09,  1.8551e-09,  1.6568e-09,  1.4584e-09, &
     &  1.3195e-09,  1.2072e-09,  1.0948e-09,  9.9780e-10,  9.3126e-10, &
     &  8.6472e-10,  7.9818e-10,  7.5138e-10,  7.1367e-10,  6.7596e-10, &
     &  6.3825e-10,  6.0981e-10,  5.8600e-10,  5.6218e-10,  5.3837e-10, &
     &  9.9780e-10,  9.3126e-10/

      data chi_mls(5,1:12)  /                                           &
     &  1.5000e-07,  1.4306e-07,  1.3474e-07,  1.3061e-07,  1.2793e-07, &
     &  1.2038e-07,  1.0798e-07,  9.4238e-08,  7.9488e-08,  6.1386e-08, &
     &  4.5563e-08,  3.3475e-08/
      data chi_mls(5,13:59)  /                                          &
     &  2.5118e-08,  1.8671e-08,  1.4349e-08,  1.2501e-08,  1.2407e-08, &
     &  1.3472e-08,  1.4900e-08,  1.6079e-08,  1.7156e-08,  1.8616e-08, &
     &  2.0106e-08,  2.1654e-08,  2.3096e-08,  2.4340e-08,  2.5643e-08, &
     &  2.6990e-08,  2.8456e-08,  2.9854e-08,  3.0943e-08,  3.2023e-08, &
     &  3.3101e-08,  3.4260e-08,  3.5360e-08,  3.6397e-08,  3.7310e-08, &
     &  3.8217e-08,  3.9123e-08,  4.1303e-08,  4.3652e-08,  4.6002e-08, &
     &  5.0289e-08,  5.5446e-08,  6.0603e-08,  6.8946e-08,  8.3652e-08, &
     &  9.8357e-08,  1.1306e-07,  1.4766e-07,  1.9142e-07,  2.3518e-07, &
     &  2.7894e-07,  3.5001e-07,  4.3469e-07,  5.1938e-07,  6.0407e-07, &
     &  6.8946e-08,  8.3652e-08/

      data chi_mls(6,1:12)  /                                           &
     &  1.7000e-06,  1.7000e-06,  1.6999e-06,  1.6904e-06,  1.6671e-06, &
     &  1.6351e-06,  1.6098e-06,  1.5590e-06,  1.5120e-06,  1.4741e-06, &
     &  1.4385e-06,  1.4002e-06/
      data chi_mls(6,13:59)  /                                          &
     &  1.3573e-06,  1.3130e-06,  1.2512e-06,  1.1668e-06,  1.0553e-06, &
     &  9.3281e-07,  8.1217e-07,  7.5239e-07,  7.0728e-07,  6.6722e-07, &
     &  6.2733e-07,  5.8604e-07,  5.4769e-07,  5.1480e-07,  4.8206e-07, &
     &  4.4943e-07,  4.1702e-07,  3.8460e-07,  3.5200e-07,  3.1926e-07, &
     &  2.8646e-07,  2.5498e-07,  2.2474e-07,  1.9588e-07,  1.8295e-07, &
     &  1.7089e-07,  1.5882e-07,  1.5536e-07,  1.5304e-07,  1.5072e-07, &
     &  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07, &
     &  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07, &
     &  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07,  1.5000e-07, &
     &  1.5000e-07,  1.5000e-07/

      data chi_mls(7,1:12)  /                                           &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090/
      data chi_mls(7,13:59)  /                                          &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090,  0.2090,  0.2090,  0.2090,                     &
     &  0.2090,  0.2090/

!........................................!
      end module module_radlw_ref        !
!========================================!


!========================================!
      module module_radlw_cldprlw        !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NBANDS
!
      implicit none
!
      public

      integer :: ipat(NBANDS)
! --- ipat is bands index for ebert & curry ice cloud (for iflagice=1)
      data ipat / 1, 2, 3,3,3, 4,4,4, 5,5,5,5,5,5,5,5 /

! --- absrain is the rain drop absorption coefficient (m2/g)
!     real (kind=kind_phys), parameter :: absrain = 3.07e-3       ! chou coeff
      real (kind=kind_phys), parameter :: absrain = 0.33e-3       ! ncar coeff

! --- abssnow is the snow flake absorption coefficient (micron)
      real (kind=kind_phys), parameter :: abssnow0 = 1.5          ! fu   coeff
! --- abssnow is the snow flake absorption coefficient (m2/g)
      real (kind=kind_phys), parameter :: abssnow1 = 2.34e-3      ! ncar coeff

! === absliq# is the liquid water absorption coefficient (m2/g).

! --- not in use
!     ccm2 method
!     real (kind=kind_phys), parameter :: absliqa = 0.0602410

! --- not in use
!     ccm3 method
!     real (kind=kind_phys), parameter :: absliqb = 0.0903614

! --- for iflagliq = 1
!     hu and stamnes method. the absorption coef's are listed for a range of
!     effective radii from 2.5 to 59.5 microns in increments of 1.0 micron.
      real (kind=kind_phys), dimension(58,NBANDS) :: absliq1

! band  1
      data absliq1(:, 1) /                                              &
     & 1.64047e-03, 6.90533e-02, 7.72017e-02, 7.78054e-02, 7.69523e-02, &
     & 7.58058e-02, 7.46400e-02, 7.35123e-02, 7.24162e-02, 7.13225e-02, &
     & 6.99145e-02, 6.66409e-02, 6.36582e-02, 6.09425e-02, 5.84593e-02, &
     & 5.61743e-02, 5.40571e-02, 5.20812e-02, 5.02245e-02, 4.84680e-02, &
     & 4.67959e-02, 4.51944e-02, 4.36516e-02, 4.21570e-02, 4.07015e-02, &
     & 3.92766e-02, 3.78747e-02, 3.64886e-02, 3.53632e-02, 3.41992e-02, &
     & 3.31016e-02, 3.20643e-02, 3.10817e-02, 3.01490e-02, 2.92620e-02, &
     & 2.84171e-02, 2.76108e-02, 2.68404e-02, 2.61031e-02, 2.53966e-02, &
     & 2.47189e-02, 2.40678e-02, 2.34418e-02, 2.28392e-02, 2.22586e-02, &
     & 2.16986e-02, 2.11580e-02, 2.06356e-02, 2.01305e-02, 1.96417e-02, &
     & 1.91682e-02, 1.87094e-02, 1.82643e-02, 1.78324e-02, 1.74129e-02, &
     & 1.70052e-02, 1.66088e-02, 1.62231e-02 /
! band  2
      data absliq1(:, 2) /                                              &
     & 2.19486e-01, 1.80687e-01, 1.59150e-01, 1.44731e-01, 1.33703e-01, &
     & 1.24355e-01, 1.15756e-01, 1.07318e-01, 9.86119e-02, 8.92739e-02, &
     & 8.34911e-02, 7.70773e-02, 7.15240e-02, 6.66615e-02, 6.23641e-02, &
     & 5.85359e-02, 5.51020e-02, 5.20032e-02, 4.91916e-02, 4.66283e-02, &
     & 4.42813e-02, 4.21236e-02, 4.01330e-02, 3.82905e-02, 3.65797e-02, &
     & 3.49869e-02, 3.35002e-02, 3.21090e-02, 3.08957e-02, 2.97601e-02, &
     & 2.86966e-02, 2.76984e-02, 2.67599e-02, 2.58758e-02, 2.50416e-02, &
     & 2.42532e-02, 2.35070e-02, 2.27997e-02, 2.21284e-02, 2.14904e-02, &
     & 2.08834e-02, 2.03051e-02, 1.97536e-02, 1.92271e-02, 1.87239e-02, &
     & 1.82425e-02, 1.77816e-02, 1.73399e-02, 1.69162e-02, 1.65094e-02, &
     & 1.61187e-02, 1.57430e-02, 1.53815e-02, 1.50334e-02, 1.46981e-02, &
     & 1.43748e-02, 1.40628e-02, 1.37617e-02 /
! band  3
      data absliq1(:, 3) /                                              &
     & 2.95174e-01, 2.34765e-01, 1.98038e-01, 1.72114e-01, 1.52083e-01, &
     & 1.35654e-01, 1.21613e-01, 1.09252e-01, 9.81263e-02, 8.79448e-02, &
     & 8.12566e-02, 7.44563e-02, 6.86374e-02, 6.36042e-02, 5.92094e-02, &
     & 5.53402e-02, 5.19087e-02, 4.88455e-02, 4.60951e-02, 4.36124e-02, &
     & 4.13607e-02, 3.93096e-02, 3.74338e-02, 3.57119e-02, 3.41261e-02, &
     & 3.26610e-02, 3.13036e-02, 3.00425e-02, 2.88497e-02, 2.78077e-02, &
     & 2.68317e-02, 2.59158e-02, 2.50545e-02, 2.42430e-02, 2.34772e-02, &
     & 2.27533e-02, 2.20679e-02, 2.14181e-02, 2.08011e-02, 2.02145e-02, &
     & 1.96561e-02, 1.91239e-02, 1.86161e-02, 1.81311e-02, 1.76673e-02, &
     & 1.72234e-02, 1.67981e-02, 1.63903e-02, 1.59989e-02, 1.56230e-02, &
     & 1.52615e-02, 1.49138e-02, 1.45791e-02, 1.42565e-02, 1.39455e-02, &
     & 1.36455e-02, 1.33559e-02, 1.30761e-02 /
! band  4
      data absliq1(:, 4) /                                              &
     & 3.00925e-01, 2.36949e-01, 1.96947e-01, 1.68692e-01, 1.47190e-01, &
     & 1.29986e-01, 1.15719e-01, 1.03568e-01, 9.30028e-02, 8.36658e-02, &
     & 7.71075e-02, 7.07002e-02, 6.52284e-02, 6.05024e-02, 5.63801e-02, &
     & 5.27534e-02, 4.95384e-02, 4.66690e-02, 4.40925e-02, 4.17664e-02, &
     & 3.96559e-02, 3.77326e-02, 3.59727e-02, 3.43561e-02, 3.28662e-02, &
     & 3.14885e-02, 3.02110e-02, 2.90231e-02, 2.78948e-02, 2.69109e-02, &
     & 2.59884e-02, 2.51217e-02, 2.43058e-02, 2.35364e-02, 2.28096e-02, &
     & 2.21218e-02, 2.14700e-02, 2.08515e-02, 2.02636e-02, 1.97041e-02, &
     & 1.91711e-02, 1.86625e-02, 1.81769e-02, 1.77126e-02, 1.72683e-02, &
     & 1.68426e-02, 1.64344e-02, 1.60427e-02, 1.56664e-02, 1.53046e-02, &
     & 1.49565e-02, 1.46214e-02, 1.42985e-02, 1.39871e-02, 1.36866e-02, &
     & 1.33965e-02, 1.31162e-02, 1.28453e-02 /
! band  5
      data absliq1(:, 5) /                                              &
     & 2.64691e-01, 2.12018e-01, 1.78009e-01, 1.53539e-01, 1.34721e-01, &
     & 1.19580e-01, 1.06996e-01, 9.62772e-02, 8.69710e-02, 7.87670e-02, &
     & 7.29272e-02, 6.70920e-02, 6.20977e-02, 5.77732e-02, 5.39910e-02, &
     & 5.06538e-02, 4.76866e-02, 4.50301e-02, 4.26374e-02, 4.04704e-02, &
     & 3.84981e-02, 3.66948e-02, 3.50394e-02, 3.35141e-02, 3.21038e-02, &
     & 3.07957e-02, 2.95788e-02, 2.84438e-02, 2.73790e-02, 2.64390e-02, &
     & 2.55565e-02, 2.47263e-02, 2.39437e-02, 2.32047e-02, 2.25056e-02, &
     & 2.18433e-02, 2.12149e-02, 2.06177e-02, 2.00495e-02, 1.95081e-02, &
     & 1.89917e-02, 1.84984e-02, 1.80269e-02, 1.75755e-02, 1.71431e-02, &
     & 1.67283e-02, 1.63303e-02, 1.59478e-02, 1.55801e-02, 1.52262e-02, &
     & 1.48853e-02, 1.45568e-02, 1.42400e-02, 1.39342e-02, 1.36388e-02, &
     & 1.33533e-02, 1.30773e-02, 1.28102e-02 /
! band  6
      data absliq1(:, 6) /                                              &
     & 8.81182e-02, 1.06745e-01, 9.79753e-02, 8.99625e-02, 8.35200e-02, &
     & 7.81899e-02, 7.35939e-02, 6.94696e-02, 6.56266e-02, 6.19148e-02, &
     & 5.83355e-02, 5.49306e-02, 5.19642e-02, 4.93325e-02, 4.69659e-02, &
     & 4.48148e-02, 4.28431e-02, 4.10231e-02, 3.93332e-02, 3.77563e-02, &
     & 3.62785e-02, 3.48882e-02, 3.35758e-02, 3.23333e-02, 3.11536e-02, &
     & 3.00310e-02, 2.89601e-02, 2.79365e-02, 2.70502e-02, 2.62618e-02, &
     & 2.55025e-02, 2.47728e-02, 2.40726e-02, 2.34013e-02, 2.27583e-02, &
     & 2.21422e-02, 2.15522e-02, 2.09869e-02, 2.04453e-02, 1.99260e-02, &
     & 1.94280e-02, 1.89501e-02, 1.84913e-02, 1.80506e-02, 1.76270e-02, &
     & 1.72196e-02, 1.68276e-02, 1.64500e-02, 1.60863e-02, 1.57357e-02, &
     & 1.53975e-02, 1.50710e-02, 1.47558e-02, 1.44511e-02, 1.41566e-02, &
     & 1.38717e-02, 1.35960e-02, 1.33290e-02 /
! band  7
      data absliq1(:, 7) /                                              &
     & 4.32174e-02, 7.36078e-02, 6.98340e-02, 6.65231e-02, 6.41948e-02, &
     & 6.23551e-02, 6.06638e-02, 5.88680e-02, 5.67124e-02, 5.38629e-02, &
     & 4.99579e-02, 4.86289e-02, 4.70120e-02, 4.52854e-02, 4.35466e-02, &
     & 4.18480e-02, 4.02169e-02, 3.86658e-02, 3.71992e-02, 3.58168e-02, &
     & 3.45155e-02, 3.32912e-02, 3.21390e-02, 3.10538e-02, 3.00307e-02, &
     & 2.90651e-02, 2.81524e-02, 2.72885e-02, 2.62821e-02, 2.55744e-02, &
     & 2.48799e-02, 2.42029e-02, 2.35460e-02, 2.29108e-02, 2.22981e-02, &
     & 2.17079e-02, 2.11402e-02, 2.05945e-02, 2.00701e-02, 1.95663e-02, &
     & 1.90824e-02, 1.86174e-02, 1.81706e-02, 1.77411e-02, 1.73281e-02, &
     & 1.69307e-02, 1.65483e-02, 1.61801e-02, 1.58254e-02, 1.54835e-02, &
     & 1.51538e-02, 1.48358e-02, 1.45288e-02, 1.42322e-02, 1.39457e-02, &
     & 1.36687e-02, 1.34008e-02, 1.31416e-02 /
! band  8
      data absliq1(:, 8) /                                              &
     & 1.41881e-01, 7.15419e-02, 6.30335e-02, 6.11132e-02, 6.01931e-02, &
     & 5.92420e-02, 5.78968e-02, 5.58876e-02, 5.28923e-02, 4.84462e-02, &
     & 4.60839e-02, 4.56013e-02, 4.45410e-02, 4.31866e-02, 4.17026e-02, &
     & 4.01850e-02, 3.86892e-02, 3.72461e-02, 3.58722e-02, 3.45749e-02, &
     & 3.33564e-02, 3.22155e-02, 3.11494e-02, 3.01541e-02, 2.92253e-02, &
     & 2.83584e-02, 2.75488e-02, 2.67925e-02, 2.57692e-02, 2.50704e-02, &
     & 2.43918e-02, 2.37350e-02, 2.31005e-02, 2.24888e-02, 2.18996e-02, &
     & 2.13325e-02, 2.07870e-02, 2.02623e-02, 1.97577e-02, 1.92724e-02, &
     & 1.88056e-02, 1.83564e-02, 1.79241e-02, 1.75079e-02, 1.71070e-02, &
     & 1.67207e-02, 1.63482e-02, 1.59890e-02, 1.56424e-02, 1.53077e-02, &
     & 1.49845e-02, 1.46722e-02, 1.43702e-02, 1.40782e-02, 1.37955e-02, &
     & 1.35219e-02, 1.32569e-02, 1.30000e-02 /
! band  9
      data absliq1(:, 9) /                                              &
     & 6.72726e-02, 6.61013e-02, 6.47866e-02, 6.33780e-02, 6.18985e-02, &
     & 6.03335e-02, 5.86136e-02, 5.65876e-02, 5.39839e-02, 5.03536e-02, &
     & 4.71608e-02, 4.63630e-02, 4.50313e-02, 4.34526e-02, 4.17876e-02, &
     & 4.01261e-02, 3.85171e-02, 3.69860e-02, 3.55442e-02, 3.41954e-02, &
     & 3.29384e-02, 3.17693e-02, 3.06832e-02, 2.96745e-02, 2.87374e-02, &
     & 2.78662e-02, 2.70557e-02, 2.63008e-02, 2.52450e-02, 2.45424e-02, &
     & 2.38656e-02, 2.32144e-02, 2.25885e-02, 2.19873e-02, 2.14099e-02, &
     & 2.08554e-02, 2.03230e-02, 1.98116e-02, 1.93203e-02, 1.88482e-02, &
     & 1.83944e-02, 1.79578e-02, 1.75378e-02, 1.71335e-02, 1.67440e-02, &
     & 1.63687e-02, 1.60069e-02, 1.56579e-02, 1.53210e-02, 1.49958e-02, &
     & 1.46815e-02, 1.43778e-02, 1.40841e-02, 1.37999e-02, 1.35249e-02, &
     & 1.32585e-02, 1.30004e-02, 1.27502e-02 /
! band 10
      data absliq1(:,10) /                                              &
     & 7.97040e-02, 7.63844e-02, 7.36499e-02, 7.13525e-02, 6.93043e-02, &
     & 6.72807e-02, 6.50227e-02, 6.22395e-02, 5.86093e-02, 5.37815e-02, &
     & 5.14682e-02, 4.97214e-02, 4.77392e-02, 4.56961e-02, 4.36858e-02, &
     & 4.17569e-02, 3.99328e-02, 3.82224e-02, 3.66265e-02, 3.51416e-02, &
     & 3.37617e-02, 3.24798e-02, 3.12887e-02, 3.01812e-02, 2.91505e-02, &
     & 2.81900e-02, 2.72939e-02, 2.64568e-02, 2.54165e-02, 2.46832e-02, &
     & 2.39783e-02, 2.33017e-02, 2.26531e-02, 2.20314e-02, 2.14359e-02, &
     & 2.08653e-02, 2.03187e-02, 1.97947e-02, 1.92924e-02, 1.88106e-02, &
     & 1.83483e-02, 1.79043e-02, 1.74778e-02, 1.70678e-02, 1.66735e-02, &
     & 1.62941e-02, 1.59286e-02, 1.55766e-02, 1.52371e-02, 1.49097e-02, &
     & 1.45937e-02, 1.42885e-02, 1.39936e-02, 1.37085e-02, 1.34327e-02, &
     & 1.31659e-02, 1.29075e-02, 1.26571e-02 /
! band 11
      data absliq1(:,11) /                                              &
     & 1.49438e-01, 1.33535e-01, 1.21542e-01, 1.11743e-01, 1.03263e-01, &
     & 9.55774e-02, 8.83382e-02, 8.12943e-02, 7.42533e-02, 6.70609e-02, &
     & 6.38761e-02, 5.97788e-02, 5.59841e-02, 5.25318e-02, 4.94132e-02, &
     & 4.66014e-02, 4.40644e-02, 4.17706e-02, 3.96910e-02, 3.77998e-02, &
     & 3.60742e-02, 3.44947e-02, 3.30442e-02, 3.17079e-02, 3.04730e-02, &
     & 2.93283e-02, 2.82642e-02, 2.72720e-02, 2.61789e-02, 2.53277e-02, &
     & 2.45237e-02, 2.37635e-02, 2.30438e-02, 2.23615e-02, 2.17140e-02, &
     & 2.10987e-02, 2.05133e-02, 1.99557e-02, 1.94241e-02, 1.89166e-02, &
     & 1.84317e-02, 1.79679e-02, 1.75238e-02, 1.70983e-02, 1.66901e-02, &
     & 1.62983e-02, 1.59219e-02, 1.55599e-02, 1.52115e-02, 1.48761e-02, &
     & 1.45528e-02, 1.42411e-02, 1.39402e-02, 1.36497e-02, 1.33690e-02, &
     & 1.30976e-02, 1.28351e-02, 1.25810e-02 /
! band 12
      data absliq1(:,12) /                                              &
     & 3.71985e-02, 3.88586e-02, 3.99070e-02, 4.04351e-02, 4.04610e-02, &
     & 3.99834e-02, 3.89953e-02, 3.74886e-02, 3.54551e-02, 3.28870e-02, &
     & 3.32576e-02, 3.22444e-02, 3.12384e-02, 3.02584e-02, 2.93146e-02, &
     & 2.84120e-02, 2.75525e-02, 2.67361e-02, 2.59618e-02, 2.52280e-02, &
     & 2.45327e-02, 2.38736e-02, 2.32487e-02, 2.26558e-02, 2.20929e-02, &
     & 2.15579e-02, 2.10491e-02, 2.05648e-02, 1.99749e-02, 1.95704e-02, &
     & 1.91731e-02, 1.87839e-02, 1.84032e-02, 1.80315e-02, 1.76689e-02, &
     & 1.73155e-02, 1.69712e-02, 1.66362e-02, 1.63101e-02, 1.59928e-02, &
     & 1.56842e-02, 1.53840e-02, 1.50920e-02, 1.48080e-02, 1.45318e-02, &
     & 1.42631e-02, 1.40016e-02, 1.37472e-02, 1.34996e-02, 1.32586e-02, &
     & 1.30239e-02, 1.27954e-02, 1.25728e-02, 1.23559e-02, 1.21445e-02, &
     & 1.19385e-02, 1.17376e-02, 1.15417e-02 /
! band 13
      data absliq1(:,13) /                                              &
     & 3.11868e-02, 4.48357e-02, 4.90224e-02, 4.96406e-02, 4.86806e-02, &
     & 4.69610e-02, 4.48630e-02, 4.25795e-02, 4.02138e-02, 3.78236e-02, &
     & 3.74266e-02, 3.60384e-02, 3.47074e-02, 3.34434e-02, 3.22499e-02, &
     & 3.11264e-02, 3.00704e-02, 2.90784e-02, 2.81463e-02, 2.72702e-02, &
     & 2.64460e-02, 2.56698e-02, 2.49381e-02, 2.42475e-02, 2.35948e-02, &
     & 2.29774e-02, 2.23925e-02, 2.18379e-02, 2.11793e-02, 2.07076e-02, &
     & 2.02470e-02, 1.97981e-02, 1.93613e-02, 1.89367e-02, 1.85243e-02, &
     & 1.81240e-02, 1.77356e-02, 1.73588e-02, 1.69935e-02, 1.66392e-02, &
     & 1.62956e-02, 1.59624e-02, 1.56393e-02, 1.53259e-02, 1.50219e-02, &
     & 1.47268e-02, 1.44404e-02, 1.41624e-02, 1.38925e-02, 1.36302e-02, &
     & 1.33755e-02, 1.31278e-02, 1.28871e-02, 1.26530e-02, 1.24253e-02, &
     & 1.22038e-02, 1.19881e-02, 1.17782e-02 /
! band 14
      data absliq1(:,14) /                                              &
     & 1.58988e-02, 3.50652e-02, 4.00851e-02, 4.07270e-02, 3.98101e-02, &
     & 3.83306e-02, 3.66829e-02, 3.50327e-02, 3.34497e-02, 3.19609e-02, &
     & 3.13712e-02, 3.03348e-02, 2.93415e-02, 2.83973e-02, 2.75037e-02, &
     & 2.66604e-02, 2.58654e-02, 2.51161e-02, 2.44100e-02, 2.37440e-02, &
     & 2.31154e-02, 2.25215e-02, 2.19599e-02, 2.14282e-02, 2.09242e-02, &
     & 2.04459e-02, 1.99915e-02, 1.95594e-02, 1.90254e-02, 1.86598e-02, &
     & 1.82996e-02, 1.79455e-02, 1.75983e-02, 1.72584e-02, 1.69260e-02, &
     & 1.66013e-02, 1.62843e-02, 1.59752e-02, 1.56737e-02, 1.53799e-02, &
     & 1.50936e-02, 1.48146e-02, 1.45429e-02, 1.42782e-02, 1.40203e-02, &
     & 1.37691e-02, 1.35243e-02, 1.32858e-02, 1.30534e-02, 1.28270e-02, &
     & 1.26062e-02, 1.23909e-02, 1.21810e-02, 1.19763e-02, 1.17766e-02, &
     & 1.15817e-02, 1.13915e-02, 1.12058e-02 /
! band 15
      data absliq1(:,15) /                                              &
     & 5.02079e-03, 2.17615e-02, 2.55449e-02, 2.59484e-02, 2.53650e-02, &
     & 2.45281e-02, 2.36843e-02, 2.29159e-02, 2.22451e-02, 2.16716e-02, &
     & 2.11451e-02, 2.05817e-02, 2.00454e-02, 1.95372e-02, 1.90567e-02, &
     & 1.86028e-02, 1.81742e-02, 1.77693e-02, 1.73866e-02, 1.70244e-02, &
     & 1.66815e-02, 1.63563e-02, 1.60477e-02, 1.57544e-02, 1.54755e-02, &
     & 1.52097e-02, 1.49564e-02, 1.47146e-02, 1.43684e-02, 1.41728e-02, &
     & 1.39762e-02, 1.37797e-02, 1.35838e-02, 1.33891e-02, 1.31961e-02, &
     & 1.30051e-02, 1.28164e-02, 1.26302e-02, 1.24466e-02, 1.22659e-02, &
     & 1.20881e-02, 1.19131e-02, 1.17412e-02, 1.15723e-02, 1.14063e-02, &
     & 1.12434e-02, 1.10834e-02, 1.09264e-02, 1.07722e-02, 1.06210e-02, &
     & 1.04725e-02, 1.03269e-02, 1.01839e-02, 1.00436e-02, 9.90593e-03, &
     & 9.77080e-03, 9.63818e-03, 9.50800e-03 /
! band 16
      data absliq1(:,16) /                                              &
     & 5.64971e-02, 9.04736e-02, 8.11726e-02, 7.05450e-02, 6.20052e-02, &
     & 5.54286e-02, 5.03503e-02, 4.63791e-02, 4.32290e-02, 4.06959e-02, &
     & 3.74690e-02, 3.52964e-02, 3.33799e-02, 3.16774e-02, 3.01550e-02, &
     & 2.87856e-02, 2.75474e-02, 2.64223e-02, 2.53953e-02, 2.44542e-02, &
     & 2.35885e-02, 2.27894e-02, 2.20494e-02, 2.13622e-02, 2.07222e-02, &
     & 2.01246e-02, 1.95654e-02, 1.90408e-02, 1.84398e-02, 1.80021e-02, &
     & 1.75816e-02, 1.71775e-02, 1.67889e-02, 1.64152e-02, 1.60554e-02, &
     & 1.57089e-02, 1.53751e-02, 1.50531e-02, 1.47426e-02, 1.44428e-02, &
     & 1.41532e-02, 1.38734e-02, 1.36028e-02, 1.33410e-02, 1.30875e-02, &
     & 1.28420e-02, 1.26041e-02, 1.23735e-02, 1.21497e-02, 1.19325e-02, &
     & 1.17216e-02, 1.15168e-02, 1.13177e-02, 1.11241e-02, 1.09358e-02, &
     & 1.07525e-02, 1.05741e-02, 1.04003e-02 /

! === ice cloud coefficients below are used for iflagliq > 0

!     absice#(j,ib) are the parameters needed to compute the ice water
!     absorption coefficients in spectral region ib for iflagice=#.  the
!     units of absice#(1,ib) are m2/g and absice#(2,ib) has units
!     (microns*m^2/g)).
! --- for iflagice = 2 or 3, absice0 is used for large ice partical size
!     such as refice > 131 microns.
      real (kind=kind_phys), dimension(2) :: absice0

      data absice0 / 0.005,  1.0 /
!!    data absice0 / 0.0029,  1.0 /       ! moorthi's coeff

! --- for iflagice = 1
!     ebert and curry method.
      real (kind=kind_phys), dimension(2,5) :: absice1

      data absice1 / 0.0036, 1.136,  0.0068, 0.600,  0.0003, 1.338,      &
     &               0.0016, 1.166,  0.0020, 1.118  /

! --- for iflagice = 2
!     streamer method. the absorption coef's are listed for a range of effective
!     radii from 5.0 to 131.0 microns in increments of 3.0 microns.
!     spherical ice particle parameterization absorption units (abs coef/iwc):
!     [(m^-1)/(g m^-3)]
      real (kind=kind_phys), dimension(43,NBANDS) :: absice2

! band 1
      data absice2(:,1) /                                                &
     & 7.798999e-02,6.340479e-02,5.417973e-02,4.766245e-02,4.272663e-02, &
     & 3.880939e-02,3.559544e-02,3.289241e-02,3.057511e-02,2.855800e-02, &
     & 2.678022e-02,2.519712e-02,2.377505e-02,2.248806e-02,2.131578e-02, &
     & 2.024194e-02,1.925337e-02,1.833926e-02,1.749067e-02,1.670007e-02, &
     & 1.596113e-02,1.526845e-02,1.461739e-02,1.400394e-02,1.342462e-02, &
     & 1.287639e-02,1.235656e-02,1.186279e-02,1.139297e-02,1.094524e-02, &
     & 1.051794e-02,1.010956e-02,9.718755e-03,9.344316e-03,8.985139e-03, &
     & 8.640223e-03,8.308656e-03,7.989606e-03,7.682312e-03,7.386076e-03, &
     & 7.100255e-03,6.824258e-03,6.557540e-03 /
! band 2
      data absice2(:,2) /                                                &
     & 2.784879e-02,2.709863e-02,2.619165e-02,2.529230e-02,2.443225e-02, &
     & 2.361575e-02,2.284021e-02,2.210150e-02,2.139548e-02,2.071840e-02, &
     & 2.006702e-02,1.943856e-02,1.883064e-02,1.824120e-02,1.766849e-02, &
     & 1.711099e-02,1.656737e-02,1.603647e-02,1.551727e-02,1.500886e-02, &
     & 1.451045e-02,1.402132e-02,1.354084e-02,1.306842e-02,1.260355e-02, &
     & 1.214575e-02,1.169460e-02,1.124971e-02,1.081072e-02,1.037731e-02, &
     & 9.949167e-03,9.526021e-03,9.107615e-03,8.693714e-03,8.284096e-03, &
     & 7.878558e-03,7.476910e-03,7.078974e-03,6.684586e-03,6.293589e-03, &
     & 5.905839e-03,5.521200e-03,5.139543e-03 /
! band 3
      data absice2(:,3) /                                                &
     & 1.065397e-01,8.005726e-02,6.546428e-02,5.589131e-02,4.898681e-02, &
     & 4.369932e-02,3.947901e-02,3.600676e-02,3.308299e-02,3.057561e-02, &
     & 2.839325e-02,2.647040e-02,2.475872e-02,2.322164e-02,2.183091e-02, &
     & 2.056430e-02,1.940407e-02,1.833586e-02,1.734787e-02,1.643034e-02, &
     & 1.557512e-02,1.477530e-02,1.402501e-02,1.331924e-02,1.265364e-02, &
     & 1.202445e-02,1.142838e-02,1.086257e-02,1.032445e-02,9.811791e-03, &
     & 9.322587e-03,8.855053e-03,8.407591e-03,7.978763e-03,7.567273e-03, &
     & 7.171949e-03,6.791728e-03,6.425642e-03,6.072809e-03,5.732424e-03, &
     & 5.403748e-03,5.086103e-03,4.778865e-03 /
! band 4
      data absice2(:,4) /                                                &
     & 1.804566e-01,1.168987e-01,8.680442e-02,6.910060e-02,5.738174e-02, &
     & 4.902332e-02,4.274585e-02,3.784923e-02,3.391734e-02,3.068690e-02, &
     & 2.798301e-02,2.568480e-02,2.370600e-02,2.198337e-02,2.046940e-02, &
     & 1.912777e-02,1.793016e-02,1.685420e-02,1.588193e-02,1.499882e-02, &
     & 1.419293e-02,1.345440e-02,1.277496e-02,1.214769e-02,1.156669e-02, &
     & 1.102694e-02,1.052412e-02,1.005451e-02,9.614854e-03,9.202335e-03, &
     & 8.814470e-03,8.449077e-03,8.104223e-03,7.778195e-03,7.469466e-03, &
     & 7.176671e-03,6.898588e-03,6.634117e-03,6.382264e-03,6.142134e-03, &
     & 5.912913e-03,5.693862e-03,5.484308e-03 /
! band 5
      data absice2(:,5) /                                                &
     & 2.131806e-01,1.311372e-01,9.407171e-02,7.299442e-02,5.941273e-02, &
     & 4.994043e-02,4.296242e-02,3.761113e-02,3.337910e-02,2.994978e-02, &
     & 2.711556e-02,2.473461e-02,2.270681e-02,2.095943e-02,1.943839e-02, &
     & 1.810267e-02,1.692057e-02,1.586719e-02,1.492275e-02,1.407132e-02, &
     & 1.329989e-02,1.259780e-02,1.195618e-02,1.136761e-02,1.082583e-02, &
     & 1.032552e-02,9.862158e-03,9.431827e-03,9.031157e-03,8.657217e-03, &
     & 8.307449e-03,7.979609e-03,7.671724e-03,7.382048e-03,7.109032e-03, &
     & 6.851298e-03,6.607615e-03,6.376881e-03,6.158105e-03,5.950394e-03, &
     & 5.752942e-03,5.565019e-03,5.385963e-03 /
! band 6
      data absice2(:,6) /                                                &
     & 1.546177e-01,1.039251e-01,7.910347e-02,6.412429e-02,5.399997e-02, &
     & 4.664937e-02,4.104237e-02,3.660781e-02,3.300218e-02,3.000586e-02, &
     & 2.747148e-02,2.529633e-02,2.340647e-02,2.174723e-02,2.027731e-02, &
     & 1.896487e-02,1.778492e-02,1.671761e-02,1.574692e-02,1.485978e-02, &
     & 1.404543e-02,1.329489e-02,1.260066e-02,1.195636e-02,1.135657e-02, &
     & 1.079664e-02,1.027257e-02,9.780871e-03,9.318505e-03,8.882815e-03, &
     & 8.471458e-03,8.082364e-03,7.713696e-03,7.363817e-03,7.031264e-03, &
     & 6.714725e-03,6.413021e-03,6.125086e-03,5.849958e-03,5.586764e-03, &
     & 5.334707e-03,5.093066e-03,4.861179e-03 /
! band 7
      data absice2(:,7) /                                                &
     & 7.583404e-02,6.181558e-02,5.312027e-02,4.696039e-02,4.225986e-02, &
     & 3.849735e-02,3.538340e-02,3.274182e-02,3.045798e-02,2.845343e-02, &
     & 2.667231e-02,2.507353e-02,2.362606e-02,2.230595e-02,2.109435e-02, &
     & 1.997617e-02,1.893916e-02,1.797328e-02,1.707016e-02,1.622279e-02, &
     & 1.542523e-02,1.467241e-02,1.395997e-02,1.328414e-02,1.264164e-02, &
     & 1.202958e-02,1.144544e-02,1.088697e-02,1.035218e-02,9.839297e-03, &
     & 9.346733e-03,8.873057e-03,8.416980e-03,7.977335e-03,7.553066e-03, &
     & 7.143210e-03,6.746888e-03,6.363297e-03,5.991700e-03,5.631422e-03, &
     & 5.281840e-03,4.942378e-03,4.612505e-03 /
! band 8
      data absice2(:,8) /                                                &
     & 9.022185e-02,6.922700e-02,5.710674e-02,4.898377e-02,4.305946e-02, &
     & 3.849553e-02,3.484183e-02,3.183220e-02,2.929794e-02,2.712627e-02, &
     & 2.523856e-02,2.357810e-02,2.210286e-02,2.078089e-02,1.958747e-02, &
     & 1.850310e-02,1.751218e-02,1.660205e-02,1.576232e-02,1.498440e-02, &
     & 1.426107e-02,1.358624e-02,1.295474e-02,1.236212e-02,1.180456e-02, &
     & 1.127874e-02,1.078175e-02,1.031106e-02,9.864433e-03,9.439878e-03, &
     & 9.035637e-03,8.650140e-03,8.281981e-03,7.929895e-03,7.592746e-03, &
     & 7.269505e-03,6.959238e-03,6.661100e-03,6.374317e-03,6.098185e-03, &
     & 5.832059e-03,5.575347e-03,5.327504e-03 /
! band 9
      data absice2(:,9) /                                                &
     & 1.294087e-01,8.788217e-02,6.728288e-02,5.479720e-02,4.635049e-02, &
     & 4.022253e-02,3.555576e-02,3.187259e-02,2.888498e-02,2.640843e-02, &
     & 2.431904e-02,2.253038e-02,2.098024e-02,1.962267e-02,1.842293e-02, &
     & 1.735426e-02,1.639571e-02,1.553060e-02,1.474552e-02,1.402953e-02, &
     & 1.337363e-02,1.277033e-02,1.221336e-02,1.169741e-02,1.121797e-02, &
     & 1.077117e-02,1.035369e-02,9.962643e-03,9.595509e-03,9.250088e-03, &
     & 8.924447e-03,8.616876e-03,8.325862e-03,8.050057e-03,7.788258e-03, &
     & 7.539388e-03,7.302478e-03,7.076656e-03,6.861134e-03,6.655197e-03, &
     & 6.458197e-03,6.269543e-03,6.088697e-03 /
! band 10
      data absice2(:,10) /                                               &
     & 1.593628e-01,1.014552e-01,7.458955e-02,5.903571e-02,4.887582e-02, &
     & 4.171159e-02,3.638480e-02,3.226692e-02,2.898717e-02,2.631256e-02, &
     & 2.408925e-02,2.221156e-02,2.060448e-02,1.921325e-02,1.799699e-02, &
     & 1.692456e-02,1.597177e-02,1.511961e-02,1.435289e-02,1.365933e-02, &
     & 1.302890e-02,1.245334e-02,1.192576e-02,1.144037e-02,1.099230e-02, &
     & 1.057739e-02,1.019208e-02,9.833302e-03,9.498395e-03,9.185047e-03, &
     & 8.891237e-03,8.615185e-03,8.355325e-03,8.110267e-03,7.878778e-03, &
     & 7.659759e-03,7.452224e-03,7.255291e-03,7.068166e-03,6.890130e-03, &
     & 6.720536e-03,6.558794e-03,6.404371e-03 /
! band 11
      data absice2(:,11) /                                               &
     & 1.656227e-01,1.032129e-01,7.487359e-02,5.871431e-02,4.828355e-02, &
     & 4.099989e-02,3.562924e-02,3.150755e-02,2.824593e-02,2.560156e-02, &
     & 2.341503e-02,2.157740e-02,2.001169e-02,1.866199e-02,1.748669e-02, &
     & 1.645421e-02,1.554015e-02,1.472535e-02,1.399457e-02,1.333553e-02, &
     & 1.273821e-02,1.219440e-02,1.169725e-02,1.124104e-02,1.082096e-02, &
     & 1.043290e-02,1.007336e-02,9.739338e-03,9.428223e-03,9.137756e-03, &
     & 8.865964e-03,8.611115e-03,8.371686e-03,8.146330e-03,7.933852e-03, &
     & 7.733187e-03,7.543386e-03,7.363597e-03,7.193056e-03,7.031072e-03, &
     & 6.877024e-03,6.730348e-03,6.590531e-03 /
! band 12
      data absice2(:,12) /                                               &
     & 9.194591e-02,6.446867e-02,4.962034e-02,4.042061e-02,3.418456e-02, &
     & 2.968856e-02,2.629900e-02,2.365572e-02,2.153915e-02,1.980791e-02, &
     & 1.836689e-02,1.714979e-02,1.610900e-02,1.520946e-02,1.442476e-02, &
     & 1.373468e-02,1.312345e-02,1.257858e-02,1.209010e-02,1.164990e-02, &
     & 1.125136e-02,1.088901e-02,1.055827e-02,1.025531e-02,9.976896e-03, &
     & 9.720255e-03,9.483022e-03,9.263160e-03,9.058902e-03,8.868710e-03, &
     & 8.691240e-03,8.525312e-03,8.369886e-03,8.224042e-03,8.086961e-03, &
     & 7.957917e-03,7.836258e-03,7.721400e-03,7.612821e-03,7.510045e-03, &
     & 7.412648e-03,7.320242e-03,7.232476e-03 /
! band 13
      data absice2(:,13) /                                               &
     & 1.437021e-01,8.872535e-02,6.392420e-02,4.991833e-02,4.096790e-02, &
     & 3.477881e-02,3.025782e-02,2.681909e-02,2.412102e-02,2.195132e-02, &
     & 2.017124e-02,1.868641e-02,1.743044e-02,1.635529e-02,1.542540e-02, &
     & 1.461388e-02,1.390003e-02,1.326766e-02,1.270395e-02,1.219860e-02, &
     & 1.174326e-02,1.133107e-02,1.095637e-02,1.061442e-02,1.030126e-02, &
     & 1.001352e-02,9.748340e-03,9.503256e-03,9.276155e-03,9.065205e-03, &
     & 8.868808e-03,8.685571e-03,8.514268e-03,8.353820e-03,8.203272e-03, &
     & 8.061776e-03,7.928578e-03,7.803001e-03,7.684443e-03,7.572358e-03, &
     & 7.466258e-03,7.365701e-03,7.270286e-03 /
! band 14
      data absice2(:,14) /                                               &
     & 1.288870e-01,8.160295e-02,5.964745e-02,4.703790e-02,3.888637e-02, &
     & 3.320115e-02,2.902017e-02,2.582259e-02,2.330224e-02,2.126754e-02, &
     & 1.959258e-02,1.819130e-02,1.700289e-02,1.598320e-02,1.509942e-02, &
     & 1.432666e-02,1.364572e-02,1.304156e-02,1.250220e-02,1.201803e-02, &
     & 1.158123e-02,1.118537e-02,1.082513e-02,1.049605e-02,1.019440e-02, &
     & 9.916989e-03,9.661116e-03,9.424457e-03,9.205005e-03,9.001022e-03, &
     & 8.810992e-03,8.633588e-03,8.467646e-03,8.312137e-03,8.166151e-03, &
     & 8.028878e-03,7.899597e-03,7.777663e-03,7.662498e-03,7.553581e-03, &
     & 7.450444e-03,7.352662e-03,7.259851e-03 /
! band 15
      data absice2(:,15) /                                               &
     & 8.254229e-02,5.808787e-02,4.492166e-02,3.675028e-02,3.119623e-02, &
     & 2.718045e-02,2.414450e-02,2.177073e-02,1.986526e-02,1.830306e-02, &
     & 1.699991e-02,1.589698e-02,1.495199e-02,1.413374e-02,1.341870e-02, &
     & 1.278883e-02,1.223002e-02,1.173114e-02,1.128322e-02,1.087900e-02, &
     & 1.051254e-02,1.017890e-02,9.873991e-03,9.594347e-03,9.337044e-03, &
     & 9.099589e-03,8.879842e-03,8.675960e-03,8.486341e-03,8.309594e-03, &
     & 8.144500e-03,7.989986e-03,7.845109e-03,7.709031e-03,7.581007e-03, &
     & 7.460376e-03,7.346544e-03,7.238978e-03,7.137201e-03,7.040780e-03, &
     & 6.949325e-03,6.862483e-03,6.779931e-03 /
! band 16
      data absice2(:,16) /                                               &
     & 1.382062e-01,8.643227e-02,6.282935e-02,4.934783e-02,4.063891e-02, &
     & 3.455591e-02,3.007059e-02,2.662897e-02,2.390631e-02,2.169972e-02, &
     & 1.987596e-02,1.834393e-02,1.703924e-02,1.591513e-02,1.493679e-02, &
     & 1.407780e-02,1.331775e-02,1.264061e-02,1.203364e-02,1.148655e-02, &
     & 1.099099e-02,1.054006e-02,1.012807e-02,9.750215e-03,9.402477e-03, &
     & 9.081428e-03,8.784143e-03,8.508107e-03,8.251146e-03,8.011373e-03, &
     & 7.787140e-03,7.577002e-03,7.379687e-03,7.194071e-03,7.019158e-03, &
     & 6.854061e-03,6.697986e-03,6.550224e-03,6.410138e-03,6.277153e-03, &
     & 6.150751e-03,6.030462e-03,5.915860e-03 /


! --- for iflagice = 3
!     fu parameterization. particle size 5 - 140 micron in increments of
!     3 microns. units = m2/g. hexagonal ice particle parameterization
!     absorption units (abs coef/iwc): [(m^-1)/(g m^-3)]
      real (kind=kind_phys), dimension(46,NBANDS) :: absice3

! band 1
      data absice3(:,1) /                     3.110649e-03,4.666352e-02, &
     & 6.606447e-02,6.531678e-02,6.012598e-02,5.437494e-02,4.906411e-02, &
     & 4.441146e-02,4.040585e-02,3.697334e-02,3.403027e-02,3.149979e-02, &
     & 2.931596e-02,2.742365e-02,2.577721e-02,2.433888e-02,2.307732e-02, &
     & 2.196644e-02,2.098437e-02,2.011264e-02,1.933561e-02,1.863992e-02, &
     & 1.801407e-02,1.744812e-02,1.693346e-02,1.646252e-02,1.602866e-02, &
     & 1.562600e-02,1.524933e-02,1.489399e-02,1.455580e-02,1.423098e-02, &
     & 1.391612e-02,1.360812e-02,1.330413e-02,1.300156e-02,1.269801e-02, &
     & 1.239127e-02,1.207928e-02,1.176014e-02,1.143204e-02,1.109334e-02, &
     & 1.074243e-02,1.037786e-02,9.998198e-03,9.602126e-03 /
! band 2
      data absice3(:,2) /                     3.984966e-04,1.681097e-02, &
     & 2.627680e-02,2.767465e-02,2.700722e-02,2.579180e-02,2.448677e-02, &
     & 2.323890e-02,2.209096e-02,2.104882e-02,2.010547e-02,1.925003e-02, &
     & 1.847128e-02,1.775883e-02,1.710358e-02,1.649769e-02,1.593449e-02, &
     & 1.540829e-02,1.491429e-02,1.444837e-02,1.400704e-02,1.358729e-02, &
     & 1.318654e-02,1.280258e-02,1.243346e-02,1.207750e-02,1.173325e-02, &
     & 1.139941e-02,1.107487e-02,1.075861e-02,1.044975e-02,1.014753e-02, &
     & 9.851229e-03,9.560240e-03,9.274003e-03,8.992020e-03,8.713845e-03, &
     & 8.439074e-03,8.167346e-03,7.898331e-03,7.631734e-03,7.367286e-03, &
     & 7.104742e-03,6.843882e-03,6.584504e-03,6.326424e-03 /
! band 3
      data absice3(:,3) /                     6.933163e-02,8.540475e-02, &
     & 7.701816e-02,6.771158e-02,5.986953e-02,5.348120e-02,4.824962e-02, &
     & 4.390563e-02,4.024411e-02,3.711404e-02,3.440426e-02,3.203200e-02, &
     & 2.993478e-02,2.806474e-02,2.638464e-02,2.486516e-02,2.348288e-02, &
     & 2.221890e-02,2.105780e-02,1.998687e-02,1.899552e-02,1.807490e-02, &
     & 1.721750e-02,1.641693e-02,1.566773e-02,1.496515e-02,1.430509e-02, &
     & 1.368398e-02,1.309865e-02,1.254634e-02,1.202456e-02,1.153114e-02, &
     & 1.106409e-02,1.062166e-02,1.020224e-02,9.804381e-03,9.426771e-03, &
     & 9.068205e-03,8.727578e-03,8.403876e-03,8.096160e-03,7.803564e-03, &
     & 7.525281e-03,7.260560e-03,7.008697e-03,6.769036e-03 /
! band 4
      data absice3(:,4) /                     1.765735e-01,1.382700e-01, &
     & 1.095129e-01,8.987475e-02,7.591185e-02,6.554169e-02,5.755500e-02, &
     & 5.122083e-02,4.607610e-02,4.181475e-02,3.822697e-02,3.516432e-02, &
     & 3.251897e-02,3.021073e-02,2.817876e-02,2.637607e-02,2.476582e-02, &
     & 2.331871e-02,2.201113e-02,2.082388e-02,1.974115e-02,1.874983e-02, &
     & 1.783894e-02,1.699922e-02,1.622280e-02,1.550296e-02,1.483390e-02, &
     & 1.421064e-02,1.362880e-02,1.308460e-02,1.257468e-02,1.209611e-02, &
     & 1.164628e-02,1.122287e-02,1.082381e-02,1.044725e-02,1.009154e-02, &
     & 9.755166e-03,9.436783e-03,9.135163e-03,8.849193e-03,8.577856e-03, &
     & 8.320225e-03,8.075451e-03,7.842755e-03,7.621418e-03 /
! band 5
      data absice3(:,5) /                     2.339673e-01,1.692124e-01, &
     & 1.291656e-01,1.033837e-01,8.562949e-02,7.273526e-02,6.298262e-02, &
     & 5.537015e-02,4.927787e-02,4.430246e-02,4.017061e-02,3.669072e-02, &
     & 3.372455e-02,3.116995e-02,2.894977e-02,2.700471e-02,2.528842e-02, &
     & 2.376420e-02,2.240256e-02,2.117959e-02,2.007567e-02,1.907456e-02, &
     & 1.816271e-02,1.732874e-02,1.656300e-02,1.585725e-02,1.520445e-02, &
     & 1.459852e-02,1.403419e-02,1.350689e-02,1.301260e-02,1.254781e-02, &
     & 1.210941e-02,1.169468e-02,1.130118e-02,1.092675e-02,1.056945e-02, &
     & 1.022757e-02,9.899560e-03,9.584021e-03,9.279705e-03,8.985479e-03, &
     & 8.700322e-03,8.423306e-03,8.153590e-03,7.890412e-03 /
! band 6
      data absice3(:,6) /                     1.145369e-01,1.174566e-01, &
     & 9.917866e-02,8.332990e-02,7.104263e-02,6.153370e-02,5.405472e-02, &
     & 4.806281e-02,4.317918e-02,3.913795e-02,3.574916e-02,3.287437e-02, &
     & 3.041067e-02,2.828017e-02,2.642292e-02,2.479206e-02,2.335051e-02, &
     & 2.206851e-02,2.092195e-02,1.989108e-02,1.895958e-02,1.811385e-02, &
     & 1.734245e-02,1.663573e-02,1.598545e-02,1.538456e-02,1.482700e-02, &
     & 1.430750e-02,1.382150e-02,1.336499e-02,1.293447e-02,1.252685e-02, &
     & 1.213939e-02,1.176968e-02,1.141555e-02,1.107508e-02,1.074655e-02, &
     & 1.042839e-02,1.011923e-02,9.817799e-03,9.522962e-03,9.233688e-03, &
     & 8.949041e-03,8.668171e-03,8.390301e-03,8.114723e-03 /
! band 7
      data absice3(:,7) /                     1.222345e-02,5.344230e-02, &
     & 5.523465e-02,5.128759e-02,4.676925e-02,4.266150e-02,3.910561e-02, &
     & 3.605479e-02,3.342843e-02,3.115052e-02,2.915776e-02,2.739935e-02, &
     & 2.583499e-02,2.443266e-02,2.316681e-02,2.201687e-02,2.096619e-02, &
     & 2.000112e-02,1.911044e-02,1.828481e-02,1.751641e-02,1.679866e-02, &
     & 1.612598e-02,1.549360e-02,1.489742e-02,1.433392e-02,1.380002e-02, &
     & 1.329305e-02,1.281068e-02,1.235084e-02,1.191172e-02,1.149171e-02, &
     & 1.108936e-02,1.070341e-02,1.033271e-02,9.976220e-03,9.633021e-03, &
     & 9.302273e-03,8.983216e-03,8.675161e-03,8.377478e-03,8.089595e-03, &
     & 7.810986e-03,7.541170e-03,7.279706e-03,7.026186e-03 /
! band 8
      data absice3(:,8) /                     6.711058e-02,6.918198e-02, &
     & 6.127484e-02,5.411944e-02,4.836902e-02,4.375293e-02,3.998077e-02, &
     & 3.683587e-02,3.416508e-02,3.186003e-02,2.984290e-02,2.805671e-02, &
     & 2.645895e-02,2.501733e-02,2.370689e-02,2.250808e-02,2.140532e-02, &
     & 2.038609e-02,1.944018e-02,1.855918e-02,1.773609e-02,1.696504e-02, &
     & 1.624106e-02,1.555990e-02,1.491793e-02,1.431197e-02,1.373928e-02, &
     & 1.319743e-02,1.268430e-02,1.219799e-02,1.173682e-02,1.129925e-02, &
     & 1.088393e-02,1.048961e-02,1.011516e-02,9.759543e-03,9.421813e-03, &
     & 9.101089e-03,8.796559e-03,8.507464e-03,8.233098e-03,7.972798e-03, &
     & 7.725942e-03,7.491940e-03,7.270238e-03,7.060305e-03 /
! band 9
      data absice3(:,9) /                     1.236780e-01,9.222386e-02, &
     & 7.383997e-02,6.204072e-02,5.381029e-02,4.770678e-02,4.296928e-02, &
     & 3.916131e-02,3.601540e-02,3.335878e-02,3.107493e-02,2.908247e-02, &
     & 2.732282e-02,2.575276e-02,2.433968e-02,2.305852e-02,2.188966e-02, &
     & 2.081757e-02,1.982974e-02,1.891599e-02,1.806794e-02,1.727865e-02, &
     & 1.654227e-02,1.585387e-02,1.520924e-02,1.460476e-02,1.403730e-02, &
     & 1.350416e-02,1.300293e-02,1.253153e-02,1.208808e-02,1.167094e-02, &
     & 1.127862e-02,1.090979e-02,1.056323e-02,1.023786e-02,9.932665e-03, &
     & 9.646744e-03,9.379250e-03,9.129409e-03,8.896500e-03,8.679856e-03, &
     & 8.478852e-03,8.292904e-03,8.121463e-03,7.964013e-03 /
! band 10
      data absice3(:,10) /                    1.655966e-01,1.134205e-01, &
     & 8.714344e-02,7.129241e-02,6.063739e-02,5.294203e-02,4.709309e-02, &
     & 4.247476e-02,3.871892e-02,3.559206e-02,3.293893e-02,3.065226e-02, &
     & 2.865558e-02,2.689288e-02,2.532221e-02,2.391150e-02,2.263582e-02, &
     & 2.147549e-02,2.041476e-02,1.944089e-02,1.854342e-02,1.771371e-02, &
     & 1.694456e-02,1.622989e-02,1.556456e-02,1.494415e-02,1.436491e-02, &
     & 1.382354e-02,1.331719e-02,1.284339e-02,1.239992e-02,1.198486e-02, &
     & 1.159647e-02,1.123323e-02,1.089375e-02,1.057679e-02,1.028124e-02, &
     & 1.000607e-02,9.750376e-03,9.513303e-03,9.294082e-03,9.092003e-03, &
     & 8.906412e-03,8.736702e-03,8.582314e-03,8.442725e-03 /
! band 11
      data absice3(:,11) /                    1.775615e-01,1.180046e-01, &
     & 8.929607e-02,7.233500e-02,6.108333e-02,5.303642e-02,4.696927e-02, &
     & 4.221206e-02,3.836768e-02,3.518576e-02,3.250063e-02,3.019825e-02, &
     & 2.819758e-02,2.643943e-02,2.487953e-02,2.348414e-02,2.222705e-02, &
     & 2.108762e-02,2.004936e-02,1.909892e-02,1.822539e-02,1.741975e-02, &
     & 1.667449e-02,1.598330e-02,1.534084e-02,1.474253e-02,1.418446e-02, &
     & 1.366325e-02,1.317597e-02,1.272004e-02,1.229321e-02,1.189350e-02, &
     & 1.151915e-02,1.116859e-02,1.084042e-02,1.053338e-02,1.024636e-02, &
     & 9.978326e-03,9.728357e-03,9.495613e-03,9.279327e-03,9.078798e-03, &
     & 8.893383e-03,8.722488e-03,8.565568e-03,8.422115e-03 /
! band 12
      data absice3(:,12) /                    9.465447e-02,6.432047e-02, &
     & 5.060973e-02,4.267283e-02,3.741843e-02,3.363096e-02,3.073531e-02, &
     & 2.842405e-02,2.651789e-02,2.490518e-02,2.351273e-02,2.229056e-02, &
     & 2.120335e-02,2.022541e-02,1.933763e-02,1.852546e-02,1.777763e-02, &
     & 1.708528e-02,1.644134e-02,1.584009e-02,1.527684e-02,1.474774e-02, &
     & 1.424955e-02,1.377957e-02,1.333549e-02,1.291534e-02,1.251743e-02, &
     & 1.214029e-02,1.178265e-02,1.144337e-02,1.112148e-02,1.081609e-02, &
     & 1.052642e-02,1.025178e-02,9.991540e-03,9.745130e-03,9.512038e-03, &
     & 9.291797e-03,9.083980e-03,8.888195e-03,8.704081e-03,8.531306e-03, &
     & 8.369560e-03,8.218558e-03,8.078032e-03,7.947730e-03 /
! band 13
      data absice3(:,13) /                    1.560311e-01,9.961097e-02, &
     & 7.502949e-02,6.115022e-02,5.214952e-02,4.578149e-02,4.099731e-02, &
     & 3.724174e-02,3.419343e-02,3.165356e-02,2.949251e-02,2.762222e-02, &
     & 2.598073e-02,2.452322e-02,2.321642e-02,2.203516e-02,2.096002e-02, &
     & 1.997579e-02,1.907036e-02,1.823401e-02,1.745879e-02,1.673819e-02, &
     & 1.606678e-02,1.544003e-02,1.485411e-02,1.430574e-02,1.379215e-02, &
     & 1.331092e-02,1.285996e-02,1.243746e-02,1.204183e-02,1.167164e-02, &
     & 1.132567e-02,1.100281e-02,1.070207e-02,1.042258e-02,1.016352e-02, &
     & 9.924197e-03,9.703953e-03,9.502199e-03,9.318400e-03,9.152066e-03, &
     & 9.002749e-03,8.870038e-03,8.753555e-03,8.652951e-03 /
! band 14
      data absice3(:,14) /                    1.559547e-01,9.896700e-02, &
     & 7.441231e-02,6.061469e-02,5.168730e-02,4.537821e-02,4.064106e-02, &
     & 3.692367e-02,3.390714e-02,3.139438e-02,2.925702e-02,2.740783e-02, &
     & 2.578547e-02,2.434552e-02,2.305506e-02,2.188910e-02,2.082842e-02, &
     & 1.985789e-02,1.896553e-02,1.814165e-02,1.737839e-02,1.666927e-02, &
     & 1.600891e-02,1.539279e-02,1.481712e-02,1.427865e-02,1.377463e-02, &
     & 1.330266e-02,1.286068e-02,1.244689e-02,1.205973e-02,1.169780e-02, &
     & 1.135989e-02,1.104492e-02,1.075192e-02,1.048004e-02,1.022850e-02, &
     & 9.996611e-03,9.783753e-03,9.589361e-03,9.412924e-03,9.253977e-03, &
     & 9.112098e-03,8.986903e-03,8.878039e-03,8.785184e-03 /
! band 15
      data absice3(:,15) /                    1.102926e-01,7.176622e-02, &
     & 5.530316e-02,4.606056e-02,4.006116e-02,3.579628e-02,3.256909e-02, &
     & 3.001360e-02,2.791920e-02,2.615617e-02,2.464023e-02,2.331426e-02, &
     & 2.213817e-02,2.108301e-02,2.012733e-02,1.925493e-02,1.845331e-02, &
     & 1.771269e-02,1.702531e-02,1.638493e-02,1.578648e-02,1.522579e-02, &
     & 1.469940e-02,1.420442e-02,1.373841e-02,1.329931e-02,1.288535e-02, &
     & 1.249502e-02,1.212700e-02,1.178015e-02,1.145348e-02,1.114612e-02, &
     & 1.085730e-02,1.058633e-02,1.033263e-02,1.009564e-02,9.874895e-03, &
     & 9.669960e-03,9.480449e-03,9.306014e-03,9.146339e-03,9.001138e-03, &
     & 8.870154e-03,8.753148e-03,8.649907e-03,8.560232e-03 /
! band 16
      data absice3(:,16) /                    1.688344e-01,1.077072e-01, &
     & 7.994467e-02,6.403862e-02,5.369850e-02,4.641582e-02,4.099331e-02, &
     & 3.678724e-02,3.342069e-02,3.065831e-02,2.834557e-02,2.637680e-02, &
     & 2.467733e-02,2.319286e-02,2.188299e-02,2.071701e-02,1.967121e-02, &
     & 1.872692e-02,1.786931e-02,1.708641e-02,1.636846e-02,1.570743e-02, &
     & 1.509665e-02,1.453052e-02,1.400433e-02,1.351407e-02,1.305631e-02, &
     & 1.262810e-02,1.222688e-02,1.185044e-02,1.149683e-02,1.116436e-02, &
     & 1.085153e-02,1.055701e-02,1.027961e-02,1.001831e-02,9.772141e-03, &
     & 9.540280e-03,9.321966e-03,9.116517e-03,8.923315e-03,8.741803e-03, &
     & 8.571472e-03,8.411860e-03,8.262543e-03,8.123136e-03 /

!........................................!
      end module module_radlw_cldprlw    !
!========================================!


!*********************************************************************!
!                descriptions for module_radlw_kgbnn                  !
!.....................................................................!
! *********        the original program descriptions        ********* !
!                                                                     !
!  rrtm longwave radiative transfer model                             !
!  atmospheric and environmental research, inc., cambridge, ma        !
!                                                                     !
!  original version:       e. j. mlawer, et al.                       !
!  revision for ncar ccm:  michael j. iacono; september, 1998         !
!  revision for gcms:      michael j. iacono; october,   2002         !
!                                                                     !
!  this file contains 16 subroutines that include the absorption      !
!  coefficients and other data for each of the 16 longwave spectral   !
!  bands used in rrtm.  here, the data are defined for 16 g-points,   !
!  or sub-intervals, per band.  these data are combined and weighted  !
!  using a mapping procedure in routine rrtmg_lw_init to reduce the   !
!  total number of g-points from 256 to 140 for use in the gcm.       !
!                                                                     !
! *********    *********    end description    *********    ********* !


!========================================!
      module module_radlw_kgb01          !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NG01
!
      implicit none
!
      private
!
      integer, public :: MSA01, MSB01, MSF01, MFR01, MMN01
      parameter (MSA01=65, MSB01=235, MSF01=10, MFR01=4, MMN01=19)

      real (kind=kind_phys), public ::                                  &
     &       absa(NG01,MSA01), absb(NG01,MSB01), selfref(NG01,MSF01),   &
     &       forref(NG01,MFR01), fracrefa(NG01), fracrefb(NG01),        &
     &       ka_mn2(NG01,MMN01), kb_mn2(NG01,MMN01)

! --- the array absa(NG01,65) = ka(NG01,5,13) contains absorption coefs
!     at the NG01=10 chosen g-values for a range of pressure levels>~100mb
!     and temperatures.  the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 1 to 13 and refers to the corresponding
!     pressure level in pref (e.g. jp = 1 is for a pressure of 1053.63 mb).
!     the third index, ig, goes from 1 to NG01=10, and tells us which
!     g-interval the absorption coefficients are for.

      data   absa(:, 1:33) /                                            &
     & 1.193600e-01,3.513800e-01,1.330212e+00,4.853272e+00,2.284154e+01,&
     & 1.116260e+02,3.333710e+02,5.746286e+02,1.040900e+03,1.207100e+03,&
     & 1.212700e-01,3.550200e-01,1.319757e+00,4.786713e+00,2.252379e+01,&
     & 1.106643e+02,3.327048e+02,5.759730e+02,1.060200e+03,1.241400e+03,&
     & 1.229000e-01,3.577400e-01,1.304913e+00,4.713986e+00,2.219045e+01,&
     & 1.095462e+02,3.330503e+02,5.768036e+02,1.071000e+03,1.306200e+03,&
     & 1.232400e-01,3.589400e-01,1.287264e+00,4.641578e+00,2.184150e+01,&
     & 1.083289e+02,3.336185e+02,5.766912e+02,1.085300e+03,1.364500e+03,&
     & 1.230200e-01,3.574000e-01,1.270102e+00,4.570358e+00,2.147597e+01,&
     & 1.070177e+02,3.341679e+02,5.763264e+02,1.101800e+03,1.412300e+03,&
     & 9.366600e-02,2.874000e-01,1.087800e+00,4.070402e+00,2.066780e+01,&
     & 1.128189e+02,3.643186e+02,6.406790e+02,1.215100e+03,1.467000e+03,&
     & 9.633600e-02,2.896100e-01,1.081249e+00,4.015953e+00,2.037104e+01,&
     & 1.118726e+02,3.626764e+02,6.438413e+02,1.230300e+03,1.488600e+03,&
     & 9.845700e-02,2.911900e-01,1.070530e+00,3.958723e+00,2.005769e+01,&
     & 1.107892e+02,3.613056e+02,6.471315e+02,1.234700e+03,1.554700e+03,&
     & 9.915500e-02,2.926800e-01,1.056941e+00,3.903525e+00,1.973378e+01,&
     & 1.095653e+02,3.604212e+02,6.481821e+02,1.247800e+03,1.626900e+03,&
     & 9.933000e-02,2.912800e-01,1.043931e+00,3.849457e+00,1.939847e+01,&
     & 1.082509e+02,3.588958e+02,6.490962e+02,1.268000e+03,1.687500e+03,&
     & 7.348000e-02,2.314200e-01,8.884229e-01,3.396692e+00,1.845497e+01,&
     & 1.129611e+02,3.888886e+02,7.209824e+02,1.419300e+03,1.784700e+03,&
     & 7.557100e-02,2.349500e-01,8.832390e-01,3.355601e+00,1.819551e+01,&
     & 1.121437e+02,3.866115e+02,7.231889e+02,1.432000e+03,1.799400e+03,&
     & 7.799800e-02,2.359500e-01,8.760165e-01,3.313635e+00,1.791376e+01,&
     & 1.110591e+02,3.847678e+02,7.268022e+02,1.438200e+03,1.839400e+03,&
     & 7.961900e-02,2.373100e-01,8.666666e-01,3.270549e+00,1.762547e+01,&
     & 1.097683e+02,3.839314e+02,7.282884e+02,1.446300e+03,1.909700e+03,&
     & 8.000000e-02,2.382800e-01,8.565867e-01,3.227601e+00,1.731873e+01,&
     & 1.084021e+02,3.820234e+02,7.300975e+02,1.460500e+03,1.986300e+03,&
     & 5.841700e-02,1.868400e-01,7.315432e-01,2.847073e+00,1.640865e+01,&
     & 1.118745e+02,4.055923e+02,8.105259e+02,1.634100e+03,2.140900e+03,&
     & 6.006200e-02,1.909000e-01,7.294171e-01,2.817289e+00,1.618199e+01,&
     & 1.111587e+02,4.034557e+02,8.105479e+02,1.647200e+03,2.171700e+03,&
     & 6.215000e-02,1.938700e-01,7.241329e-01,2.786490e+00,1.593335e+01,&
     & 1.101243e+02,4.023787e+02,8.111006e+02,1.660100e+03,2.195300e+03,&
     & 6.402400e-02,1.935500e-01,7.186190e-01,2.754068e+00,1.566954e+01,&
     & 1.088884e+02,4.019565e+02,8.109134e+02,1.670000e+03,2.243800e+03,&
     & 6.494300e-02,1.951800e-01,7.112514e-01,2.718606e+00,1.539614e+01,&
     & 1.075489e+02,4.000566e+02,8.119372e+02,1.684600e+03,2.305900e+03,&
     & 4.674200e-02,1.510800e-01,6.037870e-01,2.391540e+00,1.447808e+01,&
     & 1.092520e+02,4.197942e+02,9.043316e+02,1.878600e+03,2.541700e+03,&
     & 4.817100e-02,1.552500e-01,6.047062e-01,2.369106e+00,1.429319e+01,&
     & 1.086970e+02,4.171166e+02,9.027086e+02,1.890400e+03,2.591800e+03,&
     & 4.984000e-02,1.583200e-01,6.017935e-01,2.346687e+00,1.407356e+01,&
     & 1.078197e+02,4.157043e+02,9.017853e+02,1.902800e+03,2.619600e+03,&
     & 5.158000e-02,1.590400e-01,5.980677e-01,2.321015e+00,1.384376e+01,&
     & 1.066772e+02,4.152711e+02,9.004906e+02,1.910400e+03,2.659100e+03,&
     & 5.297400e-02,1.596200e-01,5.934596e-01,2.292307e+00,1.360965e+01,&
     & 1.054005e+02,4.138880e+02,8.994243e+02,1.925000e+03,2.712400e+03,&
     & 3.709300e-02,1.221900e-01,4.978293e-01,2.006819e+00,1.264649e+01,&
     & 1.052066e+02,4.339479e+02,9.995787e+02,2.149200e+03,3.024200e+03,&
     & 3.871200e-02,1.258500e-01,5.008943e-01,1.991241e+00,1.249737e+01,&
     & 1.047462e+02,4.305976e+02,9.975084e+02,2.166300e+03,3.068800e+03,&
     & 4.003100e-02,1.290100e-01,4.998807e-01,1.974954e+00,1.232072e+01,&
     & 1.039770e+02,4.285622e+02,9.957198e+02,2.177600e+03,3.111300e+03,&
     & 4.147300e-02,1.309000e-01,4.976969e-01,1.954464e+00,1.213428e+01,&
     & 1.030032e+02,4.274488e+02,9.935315e+02,2.183300e+03,3.153400e+03,&
     & 4.286800e-02,1.315800e-01,4.946753e-01,1.931586e+00,1.193215e+01,&
     & 1.018865e+02,4.255462e+02,9.915904e+02,2.194000e+03,3.207400e+03,&
     & 2.951500e-02,9.874300e-02,4.095862e-01,1.678325e+00,1.093942e+01,&
     & 9.973681e+01,4.480047e+02,1.096922e+03,2.431000e+03,3.649100e+03,&
     & 3.111400e-02,1.018500e-01,4.133892e-01,1.669678e+00,1.082885e+01,&
     & 9.942510e+01,4.437111e+02,1.093736e+03,2.456700e+03,3.669500e+03,&
     & 3.234400e-02,1.050600e-01,4.146088e-01,1.657254e+00,1.069408e+01,&
     & 9.885141e+01,4.403223e+02,1.091921e+03,2.472700e+03,3.693900e+03/
      data   absa(:,34:65) /                                            &
     & 3.349600e-02,1.076300e-01,4.130025e-01,1.642205e+00,1.053808e+01,&
     & 9.810418e+01,4.381100e+02,1.088989e+03,2.480400e+03,3.722900e+03,&
     & 3.471500e-02,1.082000e-01,4.116794e-01,1.624081e+00,1.036624e+01,&
     & 9.718125e+01,4.354195e+02,1.086363e+03,2.489100e+03,3.790600e+03,&
     & 2.354800e-02,7.996600e-02,3.372900e-01,1.397936e+00,9.373395e+00,&
     & 9.318855e+01,4.586371e+02,1.197788e+03,2.726100e+03,4.422300e+03,&
     & 2.501200e-02,8.292200e-02,3.413721e-01,1.395030e+00,9.299425e+00,&
     & 9.309348e+01,4.544842e+02,1.191700e+03,2.755200e+03,4.423200e+03,&
     & 2.617600e-02,8.585900e-02,3.436078e-01,1.386746e+00,9.194904e+00,&
     & 9.272558e+01,4.511219e+02,1.186527e+03,2.780300e+03,4.429700e+03,&
     & 2.725300e-02,8.846200e-02,3.433522e-01,1.375277e+00,9.070149e+00,&
     & 9.218125e+01,4.482803e+02,1.181951e+03,2.797000e+03,4.426800e+03,&
     & 2.826300e-02,8.928200e-02,3.424004e-01,1.361628e+00,8.928498e+00,&
     & 9.146506e+01,4.439193e+02,1.179378e+03,2.814100e+03,4.460800e+03,&
     & 1.913600e-02,6.572600e-02,2.831169e-01,1.169990e+00,7.950728e+00,&
     & 8.586195e+01,4.626912e+02,1.296161e+03,3.086700e+03,5.350200e+03,&
     & 2.042000e-02,6.895400e-02,2.867222e-01,1.169708e+00,7.905115e+00,&
     & 8.592706e+01,4.592619e+02,1.289998e+03,3.099400e+03,5.340000e+03,&
     & 2.160700e-02,7.178600e-02,2.892116e-01,1.164632e+00,7.829963e+00,&
     & 8.573880e+01,4.566414e+02,1.283186e+03,3.117000e+03,5.333800e+03,&
     & 2.260700e-02,7.367800e-02,2.901103e-01,1.156284e+00,7.732484e+00,&
     & 8.541199e+01,4.539296e+02,1.275164e+03,3.140200e+03,5.314000e+03,&
     & 2.350200e-02,7.523300e-02,2.893705e-01,1.145144e+00,7.619259e+00,&
     & 8.488612e+01,4.495377e+02,1.270284e+03,3.167900e+03,5.281600e+03,&
     & 1.694700e-02,6.001100e-02,2.602021e-01,9.953047e-01,6.741739e+00,&
     & 7.786549e+01,4.596587e+02,1.385127e+03,3.526900e+03,6.433300e+03,&
     & 1.898600e-02,6.223000e-02,2.593436e-01,9.994519e-01,6.697210e+00,&
     & 7.808293e+01,4.573176e+02,1.379413e+03,3.520400e+03,6.425700e+03,&
     & 2.061700e-02,6.525400e-02,2.568719e-01,9.994221e-01,6.639799e+00,&
     & 7.806792e+01,4.550929e+02,1.372582e+03,3.522500e+03,6.409300e+03,&
     & 2.189600e-02,6.703100e-02,2.555179e-01,9.953572e-01,6.560791e+00,&
     & 7.789237e+01,4.523494e+02,1.365789e+03,3.534500e+03,6.374400e+03,&
     & 2.292800e-02,6.905200e-02,2.545633e-01,9.869050e-01,6.466288e+00,&
     & 7.744399e+01,4.483808e+02,1.360537e+03,3.560100e+03,6.316200e+03,&
     & 1.472400e-02,5.574300e-02,2.358630e-01,8.308066e-01,5.860127e+00,&
     & 6.958767e+01,4.483488e+02,1.462860e+03,4.027100e+03,7.680500e+03,&
     & 1.649000e-02,5.709900e-02,2.376393e-01,8.300004e-01,5.810899e+00,&
     & 6.984032e+01,4.466177e+02,1.457308e+03,4.009600e+03,7.677800e+03,&
     & 1.846800e-02,5.880200e-02,2.346714e-01,8.300051e-01,5.758537e+00,&
     & 6.985918e+01,4.451580e+02,1.450433e+03,4.002400e+03,7.646600e+03,&
     & 1.987500e-02,6.087500e-02,2.294956e-01,8.293927e-01,5.680820e+00,&
     & 6.963681e+01,4.426020e+02,1.445881e+03,4.005200e+03,7.586500e+03,&
     & 2.109500e-02,6.269000e-02,2.251394e-01,8.250843e-01,5.593849e+00,&
     & 6.911537e+01,4.392723e+02,1.441286e+03,4.024600e+03,7.510600e+03,&
     & 1.233200e-02,4.959800e-02,2.104042e-01,6.872789e-01,5.043961e+00,&
     & 6.201474e+01,4.288498e+02,1.531632e+03,4.579800e+03,9.107300e+03,&
     & 1.399200e-02,5.123400e-02,2.088251e-01,6.895375e-01,5.009066e+00,&
     & 6.216300e+01,4.289138e+02,1.524358e+03,4.558500e+03,9.097200e+03,&
     & 1.554900e-02,5.265900e-02,2.069473e-01,6.882566e-01,4.952448e+00,&
     & 6.207713e+01,4.281520e+02,1.518488e+03,4.550300e+03,9.042800e+03,&
     & 1.713700e-02,5.395100e-02,2.025723e-01,6.865166e-01,4.885107e+00,&
     & 6.170330e+01,4.265277e+02,1.515506e+03,4.544200e+03,8.944500e+03,&
     & 1.819000e-02,5.543100e-02,1.976387e-01,6.850500e-01,4.807973e+00,&
     & 6.115202e+01,4.241421e+02,1.509950e+03,4.553200e+03,8.899700e+03,&
     & 1.014400e-02,4.193800e-02,1.766623e-01,5.758703e-01,4.289268e+00,&
     & 5.485925e+01,4.051891e+02,1.587371e+03,5.191100e+03,1.069900e+04,&
     & 1.153900e-02,4.354000e-02,1.751071e-01,5.774601e-01,4.252882e+00,&
     & 5.499755e+01,4.057529e+02,1.579188e+03,5.171700e+03,1.066800e+04,&
     & 1.286100e-02,4.499000e-02,1.736541e-01,5.752734e-01,4.200737e+00,&
     & 5.483432e+01,4.058467e+02,1.574155e+03,5.155300e+03,1.058000e+04,&
     & 1.422500e-02,4.607400e-02,1.700864e-01,5.743388e-01,4.136504e+00,&
     & 5.449538e+01,4.046072e+02,1.570843e+03,5.139500e+03,1.049300e+04,&
     & 1.522400e-02,4.699900e-02,1.662093e-01,5.726528e-01,4.071345e+00,&
     & 5.401111e+01,4.026425e+02,1.564332e+03,5.139700e+03,1.047300e+04/

! --- the array absb(NG01,235) = kb(NG01,5,13:59) contains absorption coefs
!     at the NG01=10 chosen g-values for a range of pressure levels < ~100mb
!     and temperatures. the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 13 to 59 and refers to the jpth reference
!     pressure level (see taumol.f for the value of these pressure levels
!     in mb).  the third index, ig, goes from 1 to NG01=10, and tells us
!     which g-interval the absorption coefficients are for.

      data   absb(:, 1:30) /                                            &
     & 1.014400e-02,4.193800e-02,1.766623e-01,5.758703e-01,4.289268e+00,&
     & 5.485925e+01,4.051891e+02,1.587371e+03,5.191100e+03,1.069900e+04,&
     & 1.153900e-02,4.354000e-02,1.751071e-01,5.774601e-01,4.252882e+00,&
     & 5.499755e+01,4.057529e+02,1.579188e+03,5.171700e+03,1.066800e+04,&
     & 1.286100e-02,4.499000e-02,1.736541e-01,5.752734e-01,4.200737e+00,&
     & 5.483432e+01,4.058467e+02,1.574155e+03,5.155300e+03,1.058000e+04,&
     & 1.422500e-02,4.607400e-02,1.700864e-01,5.743388e-01,4.136504e+00,&
     & 5.449538e+01,4.046072e+02,1.570843e+03,5.139500e+03,1.049300e+04,&
     & 1.522400e-02,4.699900e-02,1.662093e-01,5.726528e-01,4.071345e+00,&
     & 5.401111e+01,4.026425e+02,1.564332e+03,5.139700e+03,1.047300e+04,&
     & 8.432700e-03,3.592800e-02,1.490077e-01,4.913412e-01,3.597405e+00,&
     & 4.803045e+01,3.795583e+02,1.625123e+03,5.854700e+03,1.246900e+04,&
     & 9.598900e-03,3.744700e-02,1.478901e-01,4.925064e-01,3.566675e+00,&
     & 4.799924e+01,3.806922e+02,1.618788e+03,5.828500e+03,1.244300e+04,&
     & 1.073400e-02,3.893500e-02,1.472122e-01,4.908730e-01,3.528394e+00,&
     & 4.777584e+01,3.805881e+02,1.616526e+03,5.796300e+03,1.233800e+04,&
     & 1.189000e-02,3.981600e-02,1.436156e-01,4.906764e-01,3.483612e+00,&
     & 4.742774e+01,3.798169e+02,1.611271e+03,5.776600e+03,1.227900e+04,&
     & 1.287200e-02,4.066600e-02,1.404734e-01,4.895451e-01,3.428964e+00,&
     & 4.698086e+01,3.784275e+02,1.602900e+03,5.771500e+03,1.226000e+04,&
     & 6.996700e-03,3.053900e-02,1.250961e-01,4.222657e-01,3.015113e+00,&
     & 4.145260e+01,3.530337e+02,1.648415e+03,6.529800e+03,1.451300e+04,&
     & 7.967600e-03,3.183600e-02,1.251029e-01,4.221786e-01,2.992619e+00,&
     & 4.138936e+01,3.536972e+02,1.645508e+03,6.485800e+03,1.446600e+04,&
     & 8.955900e-03,3.308600e-02,1.232455e-01,4.226819e-01,2.960251e+00,&
     & 4.119461e+01,3.536062e+02,1.642435e+03,6.450600e+03,1.436100e+04,&
     & 9.911900e-03,3.409600e-02,1.209816e-01,4.222659e-01,2.921781e+00,&
     & 4.090617e+01,3.526166e+02,1.635296e+03,6.431200e+03,1.436000e+04,&
     & 1.053300e-02,3.520300e-02,1.188503e-01,4.205343e-01,2.877553e+00,&
     & 4.052653e+01,3.500126e+02,1.627152e+03,6.424300e+03,1.437600e+04,&
     & 5.798800e-03,2.554200e-02,1.039381e-01,3.606133e-01,2.522203e+00,&
     & 3.552795e+01,3.244815e+02,1.657291e+03,7.211700e+03,1.676900e+04,&
     & 6.606800e-03,2.660700e-02,1.037445e-01,3.605956e-01,2.502999e+00,&
     & 3.545863e+01,3.249187e+02,1.657190e+03,7.151000e+03,1.670600e+04,&
     & 7.455300e-03,2.765400e-02,1.023324e-01,3.609507e-01,2.477357e+00,&
     & 3.528161e+01,3.245654e+02,1.650994e+03,7.118900e+03,1.672700e+04,&
     & 8.240200e-03,2.862200e-02,1.011007e-01,3.599312e-01,2.447236e+00,&
     & 3.499769e+01,3.224892e+02,1.644137e+03,7.100000e+03,1.677500e+04,&
     & 8.531000e-03,2.984900e-02,9.963746e-02,3.583706e-01,2.412229e+00,&
     & 3.461698e+01,3.193512e+02,1.636774e+03,7.087000e+03,1.679500e+04,&
     & 4.805500e-03,2.105900e-02,8.621721e-02,3.060988e-01,2.148814e+00,&
     & 3.015527e+01,2.952775e+02,1.650209e+03,7.895300e+03,1.923300e+04,&
     & 5.478100e-03,2.215900e-02,8.577229e-02,3.068463e-01,2.131646e+00,&
     & 3.008982e+01,2.953814e+02,1.648675e+03,7.829100e+03,1.928500e+04,&
     & 6.188400e-03,2.309700e-02,8.521250e-02,3.066416e-01,2.110389e+00,&
     & 2.990235e+01,2.937504e+02,1.643788e+03,7.789000e+03,1.938700e+04,&
     & 6.814800e-03,2.397000e-02,8.460518e-02,3.052170e-01,2.085996e+00,&
     & 2.963261e+01,2.909075e+02,1.637469e+03,7.767000e+03,1.944500e+04,&
     & 6.956300e-03,2.502100e-02,8.338927e-02,3.042380e-01,2.057979e+00,&
     & 2.928569e+01,2.877027e+02,1.629993e+03,7.748900e+03,1.944300e+04,&
     & 3.987700e-03,1.742000e-02,7.091391e-02,2.588769e-01,1.840773e+00,&
     & 2.545239e+01,2.648904e+02,1.624103e+03,8.585500e+03,2.208200e+04,&
     & 4.542300e-03,1.834400e-02,7.089205e-02,2.594402e-01,1.828667e+00,&
     & 2.535451e+01,2.641407e+02,1.623490e+03,8.520800e+03,2.214100e+04,&
     & 5.132500e-03,1.922300e-02,7.075569e-02,2.587811e-01,1.812077e+00,&
     & 2.516766e+01,2.623628e+02,1.619933e+03,8.466800e+03,2.229600e+04,&
     & 5.509800e-03,2.009200e-02,7.017199e-02,2.581146e-01,1.790366e+00,&
     & 2.491532e+01,2.598497e+02,1.615516e+03,8.420600e+03,2.236200e+04,&
     & 5.694600e-03,2.088700e-02,6.927422e-02,2.574991e-01,1.765575e+00,&
     & 2.459914e+01,2.571600e+02,1.606768e+03,8.398000e+03,2.237300e+04/
      data   absb(:,31:60) /                                            &
     & 3.311000e-03,1.452700e-02,5.874414e-02,2.195227e-01,1.581633e+00,&
     & 2.131953e+01,2.335208e+02,1.581395e+03,9.267400e+03,2.539200e+04,&
     & 3.788000e-03,1.529400e-02,5.908161e-02,2.197548e-01,1.575160e+00,&
     & 2.120052e+01,2.326136e+02,1.581078e+03,9.204900e+03,2.541900e+04,&
     & 4.280600e-03,1.607100e-02,5.910353e-02,2.192417e-01,1.560617e+00,&
     & 2.102725e+01,2.310802e+02,1.579816e+03,9.132600e+03,2.553300e+04,&
     & 4.499600e-03,1.695000e-02,5.873994e-02,2.188461e-01,1.542154e+00,&
     & 2.080521e+01,2.289780e+02,1.575271e+03,9.073600e+03,2.562300e+04,&
     & 4.678400e-03,1.766000e-02,5.814696e-02,2.185560e-01,1.521241e+00,&
     & 2.054420e+01,2.265454e+02,1.564930e+03,9.052500e+03,2.562200e+04,&
     & 2.763100e-03,1.205700e-02,4.875163e-02,1.848414e-01,1.357815e+00,&
     & 1.782403e+01,2.030134e+02,1.521786e+03,9.910800e+03,2.922700e+04,&
     & 3.175600e-03,1.274000e-02,4.912349e-02,1.848562e-01,1.350247e+00,&
     & 1.771222e+01,2.023551e+02,1.523089e+03,9.835600e+03,2.922800e+04,&
     & 3.580300e-03,1.337500e-02,4.913834e-02,1.846480e-01,1.336997e+00,&
     & 1.755870e+01,2.010689e+02,1.522434e+03,9.763600e+03,2.923200e+04,&
     & 3.710000e-03,1.421200e-02,4.891038e-02,1.844641e-01,1.322531e+00,&
     & 1.736359e+01,1.993669e+02,1.515955e+03,9.714100e+03,2.927200e+04,&
     & 3.859800e-03,1.483600e-02,4.855203e-02,1.846215e-01,1.305869e+00,&
     & 1.714645e+01,1.972381e+02,1.504126e+03,9.690500e+03,2.928600e+04,&
     & 2.311300e-03,1.002400e-02,4.045422e-02,1.549941e-01,1.160499e+00,&
     & 1.501422e+01,1.738649e+02,1.446471e+03,1.048600e+04,3.368900e+04,&
     & 2.658400e-03,1.063000e-02,4.076300e-02,1.550789e-01,1.152598e+00,&
     & 1.489769e+01,1.734622e+02,1.448553e+03,1.041500e+04,3.355600e+04,&
     & 2.934700e-03,1.120200e-02,4.081501e-02,1.551843e-01,1.141220e+00,&
     & 1.474152e+01,1.726405e+02,1.446026e+03,1.035500e+04,3.351100e+04,&
     & 3.048100e-03,1.191800e-02,4.068593e-02,1.554098e-01,1.128795e+00,&
     & 1.456505e+01,1.711720e+02,1.438740e+03,1.031700e+04,3.343600e+04,&
     & 3.182400e-03,1.246000e-02,4.050209e-02,1.553722e-01,1.115211e+00,&
     & 1.437159e+01,1.692746e+02,1.428120e+03,1.028700e+04,3.339900e+04,&
     & 1.951000e-03,8.358600e-03,3.349484e-02,1.294550e-01,9.844043e-01,&
     & 1.268797e+01,1.479302e+02,1.356798e+03,1.098500e+04,3.864000e+04,&
     & 2.238900e-03,8.872100e-03,3.371721e-02,1.297402e-01,9.772945e-01,&
     & 1.256544e+01,1.475124e+02,1.358508e+03,1.092000e+04,3.849400e+04,&
     & 2.407600e-03,9.431900e-03,3.378756e-02,1.299560e-01,9.678937e-01,&
     & 1.242097e+01,1.465223e+02,1.355698e+03,1.087500e+04,3.830400e+04,&
     & 2.510600e-03,1.001600e-02,3.370110e-02,1.303530e-01,9.571356e-01,&
     & 1.226686e+01,1.450350e+02,1.349453e+03,1.084500e+04,3.811800e+04,&
     & 2.629300e-03,1.045100e-02,3.363421e-02,1.302384e-01,9.469851e-01,&
     & 1.208673e+01,1.433761e+02,1.339821e+03,1.080400e+04,3.800600e+04,&
     & 1.649000e-03,7.002300e-03,2.770825e-02,1.081529e-01,8.306480e-01,&
     & 1.088455e+01,1.238507e+02,1.257243e+03,1.139800e+04,4.413500e+04,&
     & 1.883300e-03,7.429200e-03,2.788541e-02,1.084674e-01,8.251828e-01,&
     & 1.078199e+01,1.232477e+02,1.258616e+03,1.134200e+04,4.389400e+04,&
     & 1.983900e-03,7.942500e-03,2.796562e-02,1.087786e-01,8.173557e-01,&
     & 1.065735e+01,1.223359e+02,1.256343e+03,1.130800e+04,4.360000e+04,&
     & 2.070700e-03,8.400100e-03,2.796006e-02,1.090250e-01,8.089808e-01,&
     & 1.050621e+01,1.210715e+02,1.250795e+03,1.127600e+04,4.319100e+04,&
     & 2.175700e-03,8.666800e-03,2.797716e-02,1.088907e-01,8.005203e-01,&
     & 1.035172e+01,1.195737e+02,1.242990e+03,1.123400e+04,4.306300e+04,&
     & 1.392100e-03,5.880500e-03,2.298321e-02,9.053824e-02,7.005726e-01,&
     & 9.421341e+00,1.022069e+02,1.151962e+03,1.170900e+04,5.012000e+04,&
     & 1.582200e-03,6.241400e-03,2.314073e-02,9.089147e-02,6.958805e-01,&
     & 9.315166e+00,1.017995e+02,1.152992e+03,1.167200e+04,4.972300e+04,&
     & 1.641600e-03,6.685500e-03,2.323652e-02,9.122551e-02,6.897028e-01,&
     & 9.197809e+00,1.009725e+02,1.151422e+03,1.164500e+04,4.927600e+04,&
     & 1.713600e-03,7.038000e-03,2.329659e-02,9.131888e-02,6.832330e-01,&
     & 9.071070e+00,9.993155e+01,1.146662e+03,1.161400e+04,4.884700e+04,&
     & 1.801900e-03,7.188100e-03,2.337516e-02,9.129986e-02,6.764224e-01,&
     & 8.937166e+00,9.876683e+01,1.138527e+03,1.157600e+04,4.855000e+04/
      data   absb(:,61:90) /                                            &
     & 1.175400e-03,4.930000e-03,1.904351e-02,7.569116e-02,5.892978e-01,&
     & 8.179385e+00,8.385544e+01,1.045843e+03,1.191400e+04,5.640000e+04,&
     & 1.298600e-03,5.265900e-03,1.920163e-02,7.602868e-02,5.852882e-01,&
     & 8.083537e+00,8.349017e+01,1.046830e+03,1.189600e+04,5.582400e+04,&
     & 1.354600e-03,5.613000e-03,1.933810e-02,7.626621e-02,5.803157e-01,&
     & 7.974722e+00,8.289613e+01,1.044506e+03,1.187800e+04,5.526000e+04,&
     & 1.418400e-03,5.813900e-03,1.944791e-02,7.639689e-02,5.750631e-01,&
     & 7.859206e+00,8.212041e+01,1.038509e+03,1.186200e+04,5.475300e+04,&
     & 1.495100e-03,5.974400e-03,1.950885e-02,7.639370e-02,5.700702e-01,&
     & 7.747555e+00,8.116056e+01,1.029581e+03,1.183700e+04,5.431800e+04,&
     & 9.938400e-04,4.134600e-03,1.578688e-02,6.312154e-02,4.935942e-01,&
     & 7.095015e+00,6.910643e+01,9.396095e+02,1.204000e+04,6.274200e+04,&
     & 1.069200e-03,4.426800e-03,1.594301e-02,6.348456e-02,4.901479e-01,&
     & 7.010754e+00,6.867417e+01,9.402294e+02,1.203100e+04,6.210100e+04,&
     & 1.118100e-03,4.699400e-03,1.608285e-02,6.361676e-02,4.865586e-01,&
     & 6.918640e+00,6.808493e+01,9.363489e+02,1.202900e+04,6.144900e+04,&
     & 1.176700e-03,4.818900e-03,1.618333e-02,6.376781e-02,4.830741e-01,&
     & 6.817125e+00,6.742993e+01,9.297413e+02,1.202000e+04,6.083800e+04,&
     & 1.242300e-03,4.970000e-03,1.623073e-02,6.383266e-02,4.795228e-01,&
     & 6.722241e+00,6.661450e+01,9.218653e+02,1.199800e+04,6.024600e+04,&
     & 8.393200e-04,3.447800e-03,1.304439e-02,5.236301e-02,4.109024e-01,&
     & 6.129192e+00,5.836709e+01,8.339681e+02,1.207100e+04,6.925600e+04,&
     & 8.844600e-04,3.694900e-03,1.317900e-02,5.263729e-02,4.085678e-01,&
     & 6.056998e+00,5.780937e+01,8.326719e+02,1.208100e+04,6.849800e+04,&
     & 9.249600e-04,3.876000e-03,1.330284e-02,5.281921e-02,4.061403e-01,&
     & 5.975415e+00,5.726530e+01,8.285338e+02,1.208900e+04,6.775500e+04,&
     & 9.755500e-04,3.980000e-03,1.337050e-02,5.300853e-02,4.037396e-01,&
     & 5.890972e+00,5.664834e+01,8.231204e+02,1.208500e+04,6.703500e+04,&
     & 1.028600e-03,4.108300e-03,1.341038e-02,5.308676e-02,4.008395e-01,&
     & 5.816136e+00,5.589261e+01,8.169800e+02,1.206900e+04,6.625500e+04,&
     & 7.065500e-04,2.866200e-03,1.073488e-02,4.328003e-02,3.406788e-01,&
     & 5.256366e+00,5.022765e+01,7.314061e+02,1.202100e+04,7.584500e+04,&
     & 7.341800e-04,3.072000e-03,1.084328e-02,4.351710e-02,3.392009e-01,&
     & 5.193073e+00,4.977106e+01,7.291455e+02,1.205800e+04,7.489000e+04,&
     & 7.664700e-04,3.185500e-03,1.094058e-02,4.371445e-02,3.375325e-01,&
     & 5.123839e+00,4.923589e+01,7.261499e+02,1.206800e+04,7.403800e+04,&
     & 8.085300e-04,3.284400e-03,1.098872e-02,4.388375e-02,3.355316e-01,&
     & 5.061271e+00,4.866184e+01,7.222318e+02,1.206800e+04,7.312500e+04,&
     & 8.509100e-04,3.384100e-03,1.102586e-02,4.400720e-02,3.331646e-01,&
     & 4.996233e+00,4.803567e+01,7.173148e+02,1.207300e+04,7.211900e+04,&
     & 5.801600e-04,2.370000e-03,8.752782e-03,3.541844e-02,2.799500e-01,&
     & 4.447780e+00,4.314701e+01,6.374967e+02,1.188600e+04,8.241600e+04,&
     & 6.055800e-04,2.528900e-03,8.827337e-03,3.562845e-02,2.788537e-01,&
     & 4.394529e+00,4.279644e+01,6.360259e+02,1.194000e+04,8.129200e+04,&
     & 6.343900e-04,2.604900e-03,8.891873e-03,3.581436e-02,2.775997e-01,&
     & 4.342493e+00,4.232577e+01,6.341818e+02,1.197000e+04,8.017200e+04,&
     & 6.694000e-04,2.684600e-03,8.928581e-03,3.594100e-02,2.760088e-01,&
     & 4.292497e+00,4.183288e+01,6.311666e+02,1.199500e+04,7.898800e+04,&
     & 7.018700e-04,2.755500e-03,8.948481e-03,3.605503e-02,2.742040e-01,&
     & 4.244228e+00,4.132105e+01,6.275835e+02,1.201700e+04,7.773300e+04,&
     & 4.775700e-04,1.952900e-03,7.093579e-03,2.886526e-02,2.291023e-01,&
     & 3.733051e+00,3.716626e+01,5.522108e+02,1.167600e+04,8.892300e+04,&
     & 4.992400e-04,2.073400e-03,7.146847e-03,2.904003e-02,2.281474e-01,&
     & 3.694653e+00,3.679907e+01,5.522026e+02,1.174900e+04,8.752400e+04,&
     & 5.244200e-04,2.123600e-03,7.191431e-03,2.919272e-02,2.272006e-01,&
     & 3.653622e+00,3.642779e+01,5.512116e+02,1.180800e+04,8.611400e+04,&
     & 5.539700e-04,2.176600e-03,7.212682e-03,2.930211e-02,2.258024e-01,&
     & 3.615500e+00,3.597555e+01,5.496286e+02,1.186100e+04,8.463300e+04,&
     & 5.782900e-04,2.227900e-03,7.223310e-03,2.939120e-02,2.244613e-01,&
     & 3.576634e+00,3.559861e+01,5.473504e+02,1.190800e+04,8.308300e+04/
      data   absb(:, 91:120) /                                          &
     & 3.942000e-04,1.595100e-03,5.698356e-03,2.332178e-02,1.859950e-01,&
     & 3.102976e+00,3.188564e+01,4.770407e+02,1.141600e+04,9.512800e+04,&
     & 4.112300e-04,1.676100e-03,5.729873e-03,2.346600e-02,1.852558e-01,&
     & 3.074604e+00,3.156989e+01,4.778549e+02,1.151500e+04,9.347400e+04,&
     & 4.329800e-04,1.710300e-03,5.756101e-03,2.358032e-02,1.843056e-01,&
     & 3.042590e+00,3.123311e+01,4.774408e+02,1.160900e+04,9.140900e+04,&
     & 4.556300e-04,1.745800e-03,5.771376e-03,2.366834e-02,1.832970e-01,&
     & 3.013996e+00,3.090483e+01,4.770090e+02,1.169400e+04,8.960900e+04,&
     & 4.743700e-04,1.785600e-03,5.769516e-03,2.373973e-02,1.823908e-01,&
     & 2.985547e+00,3.068286e+01,4.760052e+02,1.176400e+04,8.812100e+04,&
     & 3.257100e-04,1.296500e-03,4.573862e-03,1.882510e-02,1.508330e-01,&
     & 2.570632e+00,2.739472e+01,4.103610e+02,1.110800e+04,1.010900e+05,&
     & 3.396000e-04,1.354600e-03,4.587108e-03,1.894185e-02,1.501852e-01,&
     & 2.549390e+00,2.709442e+01,4.117716e+02,1.125000e+04,9.905600e+04,&
     & 3.570400e-04,1.376700e-03,4.606381e-03,1.902091e-02,1.494812e-01,&
     & 2.526947e+00,2.682763e+01,4.123097e+02,1.138500e+04,9.695900e+04,&
     & 3.738700e-04,1.401600e-03,4.610044e-03,1.909221e-02,1.488003e-01,&
     & 2.506266e+00,2.660391e+01,4.125809e+02,1.150300e+04,9.483800e+04,&
     & 3.884900e-04,1.434500e-03,4.614761e-03,1.913289e-02,1.480705e-01,&
     & 2.484274e+00,2.642290e+01,4.131173e+02,1.159800e+04,9.272800e+04,&
     & 2.674100e-04,1.049700e-03,3.664402e-03,1.518707e-02,1.221016e-01,&
     & 2.123546e+00,2.344244e+01,3.531183e+02,1.077300e+04,1.066800e+05,&
     & 2.802700e-04,1.091600e-03,3.669808e-03,1.526438e-02,1.215909e-01,&
     & 2.108387e+00,2.322781e+01,3.542442e+02,1.096300e+04,1.042600e+05,&
     & 2.934900e-04,1.106100e-03,3.680235e-03,1.532142e-02,1.211227e-01,&
     & 2.093371e+00,2.303970e+01,3.554292e+02,1.114100e+04,1.017700e+05,&
     & 3.063600e-04,1.125900e-03,3.684176e-03,1.536637e-02,1.205480e-01,&
     & 2.078998e+00,2.287805e+01,3.569159e+02,1.129400e+04,9.930900e+04,&
     & 3.179000e-04,1.149000e-03,3.683579e-03,1.539177e-02,1.200807e-01,&
     & 2.062922e+00,2.274045e+01,3.583265e+02,1.142500e+04,9.686400e+04,&
     & 2.202900e-04,8.526300e-04,2.949498e-03,1.230204e-02,9.932941e-02,&
     & 1.760430e+00,2.010163e+01,3.032903e+02,1.043800e+04,1.118100e+05,&
     & 2.307300e-04,8.843900e-04,2.951551e-03,1.236370e-02,9.893663e-02,&
     & 1.750234e+00,1.995453e+01,3.049126e+02,1.067300e+04,1.090100e+05,&
     & 2.412000e-04,8.929900e-04,2.956847e-03,1.240749e-02,9.859748e-02,&
     & 1.739739e+00,1.984498e+01,3.069168e+02,1.088500e+04,1.061900e+05,&
     & 2.511600e-04,9.090100e-04,2.960290e-03,1.243701e-02,9.822059e-02,&
     & 1.728290e+00,1.973887e+01,3.089631e+02,1.107700e+04,1.033900e+05,&
     & 2.597700e-04,9.268300e-04,2.958323e-03,1.244894e-02,9.791181e-02,&
     & 1.718001e+00,1.965007e+01,3.108524e+02,1.124900e+04,1.006200e+05,&
     & 1.809200e-04,6.896100e-04,2.375210e-03,9.968060e-03,8.084893e-02,&
     & 1.459105e+00,1.719463e+01,2.605315e+02,1.008900e+04,1.166900e+05,&
     & 1.891300e-04,7.145200e-04,2.376033e-03,1.001759e-02,8.058918e-02,&
     & 1.452526e+00,1.713484e+01,2.629484e+02,1.036800e+04,1.135200e+05,&
     & 1.972300e-04,7.212500e-04,2.380142e-03,1.004500e-02,8.034907e-02,&
     & 1.445624e+00,1.706816e+01,2.656506e+02,1.062100e+04,1.103600e+05,&
     & 2.049000e-04,7.340800e-04,2.379463e-03,1.006769e-02,8.011265e-02,&
     & 1.438217e+00,1.700435e+01,2.679469e+02,1.085200e+04,1.072400e+05,&
     & 2.112000e-04,7.471800e-04,2.377516e-03,1.007276e-02,7.988777e-02,&
     & 1.431088e+00,1.699218e+01,2.704497e+02,1.106400e+04,1.041400e+05,&
     & 1.477500e-04,5.553800e-04,1.919071e-03,8.076979e-03,6.594389e-02,&
     & 1.210502e+00,1.470411e+01,2.243540e+02,9.720100e+03,1.214300e+05,&
     & 1.542600e-04,5.745400e-04,1.917172e-03,8.119503e-03,6.574594e-02,&
     & 1.206502e+00,1.468387e+01,2.272886e+02,1.004100e+04,1.174100e+05,&
     & 1.603800e-04,5.846800e-04,1.916133e-03,8.143572e-03,6.561601e-02,&
     & 1.202069e+00,1.465903e+01,2.301404e+02,1.034100e+04,1.144400e+05,&
     & 1.664300e-04,5.929500e-04,1.915537e-03,8.162862e-03,6.545745e-02,&
     & 1.197894e+00,1.465898e+01,2.327614e+02,1.061400e+04,1.109900e+05,&
     & 1.713700e-04,6.031200e-04,1.913701e-03,8.166842e-03,6.530503e-02,&
     & 1.193597e+00,1.469704e+01,2.359650e+02,1.086100e+04,1.075900e+05/
      data   absb(:,121:150) /                                          &
     & 1.200500e-04,4.468700e-04,1.557327e-03,6.562460e-03,5.399734e-02,&
     & 1.006517e+00,1.259629e+01,1.929111e+02,9.316300e+03,1.262900e+05,&
     & 1.253400e-04,4.622800e-04,1.555399e-03,6.601992e-03,5.388511e-02,&
     & 1.004870e+00,1.258826e+01,1.960260e+02,9.680500e+03,1.224800e+05,&
     & 1.300100e-04,4.748500e-04,1.550221e-03,6.629754e-03,5.380455e-02,&
     & 1.002335e+00,1.262133e+01,1.991228e+02,1.002400e+04,1.186800e+05,&
     & 1.349500e-04,4.805200e-04,1.550478e-03,6.642861e-03,5.370264e-02,&
     & 1.000943e+00,1.265011e+01,2.022261e+02,1.034200e+04,1.149200e+05,&
     & 1.388800e-04,4.882600e-04,1.548488e-03,6.646531e-03,5.361208e-02,&
     & 9.986561e-01,1.271110e+01,2.057089e+02,1.063200e+04,1.112000e+05,&
     & 9.756000e-05,3.591100e-04,1.262637e-03,5.325036e-03,4.417375e-02,&
     & 8.352630e-01,1.074509e+01,1.662733e+02,8.927200e+03,1.307700e+05,&
     & 1.017700e-04,3.717600e-04,1.260920e-03,5.360477e-03,4.409955e-02,&
     & 8.352534e-01,1.076629e+01,1.695237e+02,9.330700e+03,1.266900e+05,&
     & 1.054000e-04,3.827800e-04,1.254620e-03,5.389449e-03,4.405623e-02,&
     & 8.353272e-01,1.081340e+01,1.725752e+02,9.716900e+03,1.226000e+05,&
     & 1.092400e-04,3.899800e-04,1.253350e-03,5.398355e-03,4.400527e-02,&
     & 8.355897e-01,1.088650e+01,1.758759e+02,1.007400e+04,1.185700e+05,&
     & 1.125600e-04,3.948700e-04,1.251613e-03,5.403536e-03,4.397471e-02,&
     & 8.350216e-01,1.096663e+01,1.797667e+02,1.040200e+04,1.145800e+05,&
     & 7.934400e-05,2.882500e-04,1.022358e-03,4.312781e-03,3.608283e-02,&
     & 6.925135e-01,9.126984e+00,1.440777e+02,8.552600e+03,1.341300e+05,&
     & 8.261500e-05,2.986800e-04,1.020038e-03,4.345658e-03,3.603680e-02,&
     & 6.937049e-01,9.189947e+00,1.470725e+02,8.999300e+03,1.301300e+05,&
     & 8.536800e-05,3.076100e-04,1.015631e-03,4.370856e-03,3.602297e-02,&
     & 6.944242e-01,9.258099e+00,1.502720e+02,9.420600e+03,1.262000e+05,&
     & 8.840500e-05,3.150000e-04,1.012791e-03,4.382561e-03,3.601653e-02,&
     & 6.960847e-01,9.343501e+00,1.538426e+02,9.815400e+03,1.219100e+05,&
     & 9.118600e-05,3.206500e-04,1.010833e-03,4.388161e-03,3.601917e-02,&
     & 6.967398e-01,9.435754e+00,1.577634e+02,1.018000e+04,1.176800e+05,&
     & 6.457500e-05,2.322100e-04,8.343751e-04,3.520436e-03,2.966079e-02,&
     & 5.764234e-01,7.784254e+00,1.248983e+02,8.149400e+03,1.390500e+05,&
     & 6.700800e-05,2.411700e-04,8.332454e-04,3.548501e-03,2.967798e-02,&
     & 5.788651e-01,7.850520e+00,1.278580e+02,8.635500e+03,1.344800e+05,&
     & 6.936900e-05,2.491600e-04,8.293472e-04,3.572675e-03,2.968373e-02,&
     & 5.807767e-01,7.939411e+00,1.308233e+02,9.096200e+03,1.299300e+05,&
     & 7.174000e-05,2.553900e-04,8.266836e-04,3.585559e-03,2.971778e-02,&
     & 5.830478e-01,8.031159e+00,1.344044e+02,9.528500e+03,1.254000e+05,&
     & 7.400300e-05,2.614900e-04,8.241710e-04,3.590482e-03,2.974305e-02,&
     & 5.849549e-01,8.137189e+00,1.384939e+02,9.930500e+03,1.209500e+05,&
     & 5.269700e-05,1.871100e-04,6.822103e-04,2.873991e-03,2.439278e-02,&
     & 4.801886e-01,6.623899e+00,1.089390e+02,7.752900e+03,1.430200e+05,&
     & 5.433400e-05,1.952000e-04,6.808557e-04,2.898857e-03,2.443601e-02,&
     & 4.835084e-01,6.709445e+00,1.115537e+02,8.278800e+03,1.382200e+05,&
     & 5.640900e-05,2.018400e-04,6.778570e-04,2.920672e-03,2.446923e-02,&
     & 4.857216e-01,6.802094e+00,1.145488e+02,8.776600e+03,1.334600e+05,&
     & 5.822800e-05,2.073200e-04,6.751046e-04,2.935994e-03,2.451587e-02,&
     & 4.886329e-01,6.913816e+00,1.178088e+02,9.244600e+03,1.287300e+05,&
     & 6.001400e-05,2.120800e-04,6.729793e-04,2.941133e-03,2.455875e-02,&
     & 4.909497e-01,7.025080e+00,1.219840e+02,9.677300e+03,1.240700e+05,&
     & 4.308900e-05,1.504400e-04,5.581555e-04,2.343711e-03,2.006303e-02,&
     & 3.996826e-01,5.631420e+00,9.493945e+01,7.376000e+03,1.467500e+05,&
     & 4.412000e-05,1.580600e-04,5.561794e-04,2.364997e-03,2.011630e-02,&
     & 4.027770e-01,5.718851e+00,9.776510e+01,7.933900e+03,1.417300e+05,&
     & 4.581500e-05,1.634900e-04,5.536429e-04,2.385704e-03,2.015340e-02,&
     & 4.059117e-01,5.832478e+00,1.008087e+02,8.468100e+03,1.367300e+05,&
     & 4.721800e-05,1.681300e-04,5.513420e-04,2.399312e-03,2.021198e-02,&
     & 4.088943e-01,5.935563e+00,1.040143e+02,8.968100e+03,1.318200e+05,&
     & 4.865800e-05,1.718600e-04,5.493186e-04,2.404927e-03,2.027353e-02,&
     & 4.115796e-01,6.053133e+00,1.077793e+02,9.434000e+03,1.269800e+05/
      data   absb(:,151:180) /                                          &
     & 3.442900e-05,1.214700e-04,4.567436e-04,1.911139e-03,1.649618e-02,&
     & 3.323881e-01,4.776971e+00,8.275173e+01,6.981900e+03,1.504700e+05,&
     & 3.584700e-05,1.275400e-04,4.550413e-04,1.928533e-03,1.655344e-02,&
     & 3.358899e-01,4.878547e+00,8.558285e+01,7.572100e+03,1.452800e+05,&
     & 3.714900e-05,1.320200e-04,4.535401e-04,1.946546e-03,1.659720e-02,&
     & 3.389940e-01,4.982463e+00,8.861048e+01,8.140900e+03,1.401000e+05,&
     & 3.838000e-05,1.360300e-04,4.507841e-04,1.960422e-03,1.665736e-02,&
     & 3.423356e-01,5.095083e+00,9.199958e+01,8.674600e+03,1.350000e+05,&
     & 3.947900e-05,1.392200e-04,4.488471e-04,1.967194e-03,1.672433e-02,&
     & 3.452449e-01,5.220169e+00,9.573755e+01,9.169100e+03,1.294100e+05,&
     & 2.716900e-05,9.763100e-05,3.734186e-04,1.557397e-03,1.355455e-02,&
     & 2.761778e-01,4.047495e+00,7.234216e+01,6.582700e+03,1.541300e+05,&
     & 2.930000e-05,1.025400e-04,3.728353e-04,1.571498e-03,1.360995e-02,&
     & 2.794650e-01,4.145757e+00,7.515471e+01,7.208100e+03,1.487800e+05,&
     & 3.012800e-05,1.066400e-04,3.711150e-04,1.586524e-03,1.366249e-02,&
     & 2.826371e-01,4.258321e+00,7.803878e+01,7.808400e+03,1.434400e+05,&
     & 3.117500e-05,1.100000e-04,3.688479e-04,1.599502e-03,1.372245e-02,&
     & 2.861057e-01,4.370794e+00,8.134862e+01,8.374000e+03,1.381600e+05,&
     & 3.202100e-05,1.127800e-04,3.668478e-04,1.607007e-03,1.378983e-02,&
     & 2.890558e-01,4.498500e+00,8.519766e+01,8.898200e+03,1.330000e+05,&
     & 2.141100e-05,7.855100e-05,3.049498e-04,1.267381e-03,1.111307e-02,&
     & 2.291533e-01,3.427174e+00,6.362709e+01,6.190100e+03,1.576400e+05,&
     & 2.378200e-05,8.238600e-05,3.055002e-04,1.278267e-03,1.117145e-02,&
     & 2.322803e-01,3.521659e+00,6.618382e+01,6.848500e+03,1.521400e+05,&
     & 2.436000e-05,8.625200e-05,3.038523e-04,1.289904e-03,1.122568e-02,&
     & 2.352589e-01,3.633312e+00,6.887787e+01,7.479500e+03,1.466500e+05,&
     & 2.528700e-05,8.882100e-05,3.016269e-04,1.303037e-03,1.127863e-02,&
     & 2.385093e-01,3.740191e+00,7.207152e+01,8.078600e+03,1.405500e+05,&
     & 2.602500e-05,9.111300e-05,2.998465e-04,1.309757e-03,1.133820e-02,&
     & 2.415825e-01,3.863186e+00,7.597735e+01,8.630300e+03,1.358600e+05,&
     & 1.675400e-05,6.308200e-05,2.491341e-04,1.029960e-03,9.105503e-03,&
     & 1.899080e-01,2.891210e+00,5.610943e+01,5.802400e+03,1.610400e+05,&
     & 1.879500e-05,6.621700e-05,2.496823e-04,1.039676e-03,9.157697e-03,&
     & 1.926864e-01,2.984048e+00,5.852342e+01,6.480100e+03,1.554600e+05,&
     & 1.993100e-05,6.926400e-05,2.489131e-04,1.049251e-03,9.209641e-03,&
     & 1.955293e-01,3.090055e+00,6.120483e+01,7.141300e+03,1.498100e+05,&
     & 2.053200e-05,7.159700e-05,2.471870e-04,1.059299e-03,9.263077e-03,&
     & 1.986097e-01,3.197479e+00,6.413690e+01,7.770200e+03,1.442200e+05,&
     & 2.114500e-05,7.359600e-05,2.451926e-04,1.067084e-03,9.317358e-03,&
     & 2.016349e-01,3.314719e+00,6.776067e+01,8.354800e+03,1.387400e+05,&
     & 1.306700e-05,5.066800e-05,2.048159e-04,8.357262e-04,7.463298e-03,&
     & 1.572614e-01,2.433440e+00,4.949183e+01,5.393800e+03,1.645300e+05,&
     & 1.475700e-05,5.314800e-05,2.047054e-04,8.459937e-04,7.514236e-03,&
     & 1.597814e-01,2.525746e+00,5.193193e+01,6.087000e+03,1.589100e+05,&
     & 1.624700e-05,5.564800e-05,2.044213e-04,8.537071e-04,7.562223e-03,&
     & 1.624012e-01,2.624435e+00,5.431958e+01,6.777800e+03,1.531400e+05,&
     & 1.657500e-05,5.802300e-05,2.031808e-04,8.616870e-04,7.612026e-03,&
     & 1.653270e-01,2.730764e+00,5.716447e+01,7.434100e+03,1.474200e+05,&
     & 1.718400e-05,5.946000e-05,2.011333e-04,8.698032e-04,7.665678e-03,&
     & 1.680835e-01,2.842383e+00,6.064289e+01,8.049500e+03,1.418000e+05,&
     & 1.019300e-05,4.072300e-05,1.687541e-04,6.762672e-04,6.099954e-03,&
     & 1.299364e-01,2.045879e+00,4.381018e+01,5.009200e+03,1.677500e+05,&
     & 1.152700e-05,4.265200e-05,1.678015e-04,6.869052e-04,6.152895e-03,&
     & 1.322824e-01,2.129371e+00,4.620675e+01,5.705200e+03,1.621900e+05,&
     & 1.284100e-05,4.471400e-05,1.675079e-04,6.936401e-04,6.198200e-03,&
     & 1.346526e-01,2.222329e+00,4.856062e+01,6.411100e+03,1.564000e+05,&
     & 1.359900e-05,4.656200e-05,1.668700e-04,6.998837e-04,6.240238e-03,&
     & 1.371500e-01,2.318396e+00,5.122704e+01,7.096200e+03,1.505400e+05,&
     & 1.394600e-05,4.811000e-05,1.651901e-04,7.065099e-04,6.285452e-03,&
     & 1.398677e-01,2.423966e+00,5.433575e+01,7.740900e+03,1.448100e+05/
      data   absb(:,181:210) /                                          &
     & 7.941700e-06,3.257700e-05,1.389622e-04,5.463982e-04,4.968668e-03,&
     & 1.072193e-01,1.706997e+00,3.894784e+01,4.604500e+03,1.710400e+05,&
     & 8.997100e-06,3.424100e-05,1.382027e-04,5.553115e-04,5.019336e-03,&
     & 1.091856e-01,1.786728e+00,4.112940e+01,5.344600e+03,1.652800e+05,&
     & 1.011200e-05,3.584500e-05,1.372852e-04,5.627179e-04,5.060776e-03,&
     & 1.112935e-01,1.875282e+00,4.359930e+01,6.046900e+03,1.595700e+05,&
     & 1.104500e-05,3.741800e-05,1.367830e-04,5.676953e-04,5.100599e-03,&
     & 1.135207e-01,1.964914e+00,4.593274e+01,6.756200e+03,1.536300e+05,&
     & 1.128500e-05,3.870400e-05,1.358856e-04,5.724608e-04,5.138900e-03,&
     & 1.160527e-01,2.059224e+00,4.893143e+01,7.430200e+03,1.477300e+05,&
     & 6.195000e-06,2.654800e-05,1.142017e-04,4.434507e-04,4.061342e-03,&
     & 8.850287e-02,1.430374e+00,3.458707e+01,4.241400e+03,1.740100e+05,&
     & 7.067800e-06,2.764500e-05,1.146965e-04,4.496430e-04,4.110004e-03,&
     & 9.035841e-02,1.501987e+00,3.688433e+01,4.994000e+03,1.681800e+05,&
     & 7.957100e-06,2.888700e-05,1.133140e-04,4.570641e-04,4.149426e-03,&
     & 9.233982e-02,1.578998e+00,3.911642e+01,5.717700e+03,1.624000e+05,&
     & 8.785900e-06,3.024300e-05,1.125404e-04,4.619405e-04,4.182837e-03,&
     & 9.423511e-02,1.668998e+00,4.163129e+01,6.431800e+03,1.564800e+05,&
     & 9.311600e-06,3.128500e-05,1.118460e-04,4.659609e-04,4.217335e-03,&
     & 9.654011e-02,1.756837e+00,4.431282e+01,7.130800e+03,1.505100e+05,&
     & 4.812100e-06,2.163200e-05,9.413931e-05,3.602520e-04,3.321665e-03,&
     & 7.318085e-02,1.197379e+00,3.075832e+01,3.905800e+03,1.766700e+05,&
     & 5.554000e-06,2.230500e-05,9.482170e-05,3.655918e-04,3.369596e-03,&
     & 7.487307e-02,1.262034e+00,3.314145e+01,4.643500e+03,1.710400e+05,&
     & 6.263400e-06,2.340200e-05,9.411423e-05,3.713657e-04,3.406399e-03,&
     & 7.661400e-02,1.333608e+00,3.542573e+01,5.414400e+03,1.649900e+05,&
     & 6.996800e-06,2.442000e-05,9.295135e-05,3.763276e-04,3.438850e-03,&
     & 7.831394e-02,1.413223e+00,3.771263e+01,6.132000e+03,1.591200e+05,&
     & 7.575000e-06,2.542400e-05,9.211663e-05,3.801034e-04,3.470086e-03,&
     & 8.039551e-02,1.496788e+00,4.049997e+01,6.834000e+03,1.531800e+05,&
     & 3.773200e-06,1.749400e-05,7.787031e-05,2.917190e-04,2.710953e-03,&
     & 6.047625e-02,9.987274e-01,2.731742e+01,3.582800e+03,1.792200e+05,&
     & 4.340000e-06,1.815800e-05,7.820364e-05,2.969652e-04,2.755494e-03,&
     & 6.184768e-02,1.060317e+00,2.963243e+01,4.324200e+03,1.735600e+05,&
     & 4.936800e-06,1.894600e-05,7.829726e-05,3.011455e-04,2.790005e-03,&
     & 6.339650e-02,1.123929e+00,3.206216e+01,5.083500e+03,1.677200e+05,&
     & 5.525500e-06,1.974600e-05,7.716338e-05,3.058237e-04,2.819293e-03,&
     & 6.501476e-02,1.195756e+00,3.450973e+01,5.830800e+03,1.616900e+05,&
     & 6.050700e-06,2.062600e-05,7.622375e-05,3.092608e-04,2.849085e-03,&
     & 6.680782e-02,1.272463e+00,3.709181e+01,6.545500e+03,1.557200e+05,&
     & 2.958800e-06,1.406000e-05,6.498269e-05,2.351736e-04,2.207100e-03,&
     & 4.984141e-02,8.327580e-01,2.425444e+01,3.273300e+03,1.815300e+05,&
     & 3.385500e-06,1.492400e-05,6.437416e-05,2.408144e-04,2.247217e-03,&
     & 5.106383e-02,8.835278e-01,2.651729e+01,3.995000e+03,1.762200e+05,&
     & 3.893400e-06,1.529600e-05,6.484358e-05,2.440572e-04,2.279711e-03,&
     & 5.236843e-02,9.420509e-01,2.904483e+01,4.759000e+03,1.703500e+05,&
     & 4.355800e-06,1.604700e-05,6.422153e-05,2.476467e-04,2.305781e-03,&
     & 5.385392e-02,1.006056e+00,3.155191e+01,5.530000e+03,1.642200e+05,&
     & 4.837700e-06,1.666100e-05,6.318191e-05,2.508873e-04,2.331062e-03,&
     & 5.544591e-02,1.076425e+00,3.410120e+01,6.261300e+03,1.581900e+05,&
     & 2.263700e-06,1.150200e-05,5.409641e-05,1.913949e-04,1.812767e-03,&
     & 4.139308e-02,6.966840e-01,2.155043e+01,2.997300e+03,1.836300e+05,&
     & 2.655000e-06,1.218900e-05,5.378751e-05,1.959818e-04,1.847532e-03,&
     & 4.244713e-02,7.447507e-01,2.386942e+01,3.703300e+03,1.784800e+05,&
     & 3.064000e-06,1.259100e-05,5.369946e-05,1.995299e-04,1.878080e-03,&
     & 4.363150e-02,7.968853e-01,2.629102e+01,4.479800e+03,1.725900e+05,&
     & 3.467000e-06,1.307200e-05,5.366971e-05,2.021344e-04,1.904098e-03,&
     & 4.489577e-02,8.576664e-01,2.882089e+01,5.246800e+03,1.665700e+05,&
     & 3.864500e-06,1.358500e-05,5.288031e-05,2.050214e-04,1.927504e-03,&
     & 4.637463e-02,9.208700e-01,3.151690e+01,6.005400e+03,1.604200e+05/
      data   absb(:,211:235) /                                          &
     & 1.739400e-06,9.473100e-06,4.563838e-05,1.557865e-04,1.493661e-03,&
     & 3.455495e-02,5.835786e-01,1.925122e+01,2.734700e+03,1.855100e+05,&
     & 2.131800e-06,9.900000e-06,4.545426e-05,1.596786e-04,1.526199e-03,&
     & 3.545846e-02,6.282760e-01,2.147305e+01,3.452900e+03,1.804300e+05,&
     & 2.409200e-06,1.049900e-05,4.475665e-05,1.635121e-04,1.556715e-03,&
     & 3.650696e-02,6.754686e-01,2.392610e+01,4.202000e+03,1.747900e+05,&
     & 2.771800e-06,1.073000e-05,4.481076e-05,1.659395e-04,1.581755e-03,&
     & 3.762834e-02,7.312044e-01,2.655364e+01,4.993200e+03,1.686700e+05,&
     & 3.096900e-06,1.120100e-05,4.448881e-05,1.681242e-04,1.605482e-03,&
     & 3.898851e-02,7.930304e-01,2.917476e+01,5.736000e+03,1.626700e+05,&
     & 1.337900e-06,7.784200e-06,3.794717e-05,1.276226e-04,1.230863e-03,&
     & 2.874245e-02,4.906990e-01,1.710831e+01,2.495300e+03,1.872300e+05,&
     & 1.696200e-06,8.060900e-06,3.825195e-05,1.304785e-04,1.261127e-03,&
     & 2.965448e-02,5.293689e-01,1.941395e+01,3.195600e+03,1.823300e+05,&
     & 1.918200e-06,8.632800e-06,3.766703e-05,1.337435e-04,1.289446e-03,&
     & 3.060807e-02,5.727603e-01,2.184731e+01,3.936600e+03,1.768700e+05,&
     & 2.201900e-06,8.907300e-06,3.740798e-05,1.362225e-04,1.313935e-03,&
     & 3.158456e-02,6.223633e-01,2.446152e+01,4.717600e+03,1.708900e+05,&
     & 2.505700e-06,9.225800e-06,3.726862e-05,1.380280e-04,1.337532e-03,&
     & 3.278351e-02,6.813537e-01,2.718855e+01,5.481800e+03,1.648000e+05,&
     & 1.089400e-06,6.127100e-06,3.158340e-05,1.048375e-04,1.012832e-03,&
     & 2.400573e-02,4.097914e-01,1.537667e+01,2.261700e+03,1.888600e+05,&
     & 1.308600e-06,6.699900e-06,3.239312e-05,1.063566e-04,1.041240e-03,&
     & 2.478671e-02,4.453238e-01,1.748305e+01,2.941300e+03,1.842000e+05,&
     & 1.525000e-06,7.036800e-06,3.215555e-05,1.089376e-04,1.067794e-03,&
     & 2.561376e-02,4.857489e-01,1.986569e+01,3.688100e+03,1.788300e+05,&
     & 1.782500e-06,7.446600e-06,3.144232e-05,1.115837e-04,1.091335e-03,&
     & 2.660656e-02,5.318314e-01,2.262563e+01,4.449900e+03,1.729900e+05,&
     & 2.007800e-06,7.639500e-06,3.121672e-05,1.134173e-04,1.113037e-03,&
     & 2.762634e-02,5.850740e-01,2.526450e+01,5.234900e+03,1.668100e+05,&
     & 8.250500e-07,4.787300e-06,2.656058e-05,8.599989e-05,8.358993e-04,&
     & 2.009312e-02,3.431457e-01,1.389403e+01,2.037000e+03,1.903700e+05,&
     & 1.018000e-06,5.561500e-06,2.684447e-05,8.760306e-05,8.608185e-04,&
     & 2.080354e-02,3.748374e-01,1.594760e+01,2.714800e+03,1.858100e+05,&
     & 1.254800e-06,5.747000e-06,2.731576e-05,8.904149e-05,8.863475e-04,&
     & 2.157788e-02,4.117652e-01,1.821223e+01,3.446000e+03,1.806700e+05,&
     & 1.458400e-06,6.163700e-06,2.680017e-05,9.118702e-05,9.080531e-04,&
     & 2.242998e-02,4.542731e-01,2.088348e+01,4.222400e+03,1.747700e+05,&
     & 1.739800e-06,6.370500e-06,2.630685e-05,9.319223e-05,9.287046e-04,&
     & 2.336703e-02,5.044867e-01,2.375255e+01,4.990600e+03,1.688100e+05,&
     & 7.180200e-07,3.864900e-06,2.256658e-05,7.172499e-05,7.028164e-04,&
     & 1.721199e-02,2.936671e-01,1.321355e+01,1.947800e+03,1.910000e+05,&
     & 8.678400e-07,4.596600e-06,2.270775e-05,7.318428e-05,7.275395e-04,&
     & 1.792357e-02,3.237851e-01,1.519158e+01,2.613000e+03,1.865900e+05,&
     & 1.097400e-06,4.796500e-06,2.314181e-05,7.428212e-05,7.522643e-04,&
     & 1.865225e-02,3.576812e-01,1.736163e+01,3.352900e+03,1.813200e+05,&
     & 1.350400e-06,5.149000e-06,2.293358e-05,7.590926e-05,7.728592e-04,&
     & 1.950171e-02,3.997745e-01,1.983285e+01,4.120500e+03,1.756200e+05,&
     & 1.431400e-06,5.388000e-06,2.240495e-05,7.783655e-05,7.936564e-04,&
     & 2.039213e-02,4.493887e-01,2.278674e+01,4.899000e+03,1.695600e+05/

! --- the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG01=10).

      data  selfref(:, :) /                                             &
     & 2.168030e+00,3.701490e+00,6.362042e+00,6.498625e+00,6.557401e+00,&
     & 6.583180e+00,7.064571e+00,7.464597e+00,7.518950e+00,7.847740e+00,&
     & 1.982360e+00,3.431450e+00,5.778778e+00,5.903115e+00,5.954698e+00,&
     & 6.024436e+00,6.415106e+00,6.770832e+00,6.688460e+00,6.806730e+00,&
     & 1.812600e+00,3.181100e+00,5.249020e+00,5.362198e+00,5.407467e+00,&
     & 5.513122e+00,5.825835e+00,6.141552e+00,5.949700e+00,5.903800e+00,&
     & 1.657370e+00,2.949020e+00,4.767855e+00,4.870861e+00,4.910594e+00,&
     & 5.045202e+00,5.291130e+00,5.570755e+00,5.292540e+00,5.120650e+00,&
     & 1.515440e+00,2.733870e+00,4.330824e+00,4.424562e+00,4.459444e+00,&
     & 4.616993e+00,4.805899e+00,5.053016e+00,4.707960e+00,4.441380e+00,&
     & 1.385670e+00,2.534410e+00,3.933878e+00,4.019174e+00,4.049802e+00,&
     & 4.225135e+00,4.365522e+00,4.583395e+00,4.187950e+00,3.852230e+00,&
     & 1.267000e+00,2.349510e+00,3.573335e+00,3.650940e+00,3.677838e+00,&
     & 3.866529e+00,3.965830e+00,4.157423e+00,3.725380e+00,3.341220e+00,&
     & 1.158500e+00,2.178100e+00,3.245858e+00,3.316453e+00,3.340089e+00,&
     & 3.538366e+00,3.603021e+00,3.771042e+00,3.313900e+00,2.898000e+00,&
     & 1.059290e+00,2.019190e+00,2.948406e+00,3.012624e+00,3.033394e+00,&
     & 3.238053e+00,3.273677e+00,3.420571e+00,2.947870e+00,2.513570e+00,&
     & 9.685760e-01,1.871880e+00,2.678235e+00,2.736639e+00,2.754912e+00,&
     & 2.963225e+00,2.974673e+00,3.102675e+00,2.622270e+00,2.180140e+00/

! --- the array forref contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  the first
!     index refers to reference temperature (296,260,224,260) and
!     pressure (970,475,219,3 mbar) levels.  The second index
!     runs over the g-channel (1 to NG01=10).

      data  forref(:, :) /                                              &
     & 3.674200E-02,1.066400E-01,2.698528E-01,2.783334E-01,2.878464E-01,&
     & 3.080541E-01,3.036985E-01,3.112085E-01,2.122600E-01,1.284700E-01,&
     & 4.045000E-02,1.108500E-01,3.051763E-01,3.160518E-01,3.255052E-01,&
     & 3.326603E-01,3.477623E-01,3.764727E-01,3.348100E-01,3.211300E-01,&
     & 4.695200E-02,1.199900E-01,3.413866E-01,3.665323E-01,3.760285E-01,&
     & 3.717261E-01,3.947360E-01,4.344193E-01,4.346800E-01,4.708300E-01,&
     & 7.064500E-02,1.661800E-01,3.010472E-01,2.986289E-01,2.913346E-01,&
     & 2.864983E-01,2.796532E-01,3.049337E-01,3.068100E-01,3.677800E-01/

      data  ka_mn2(:, :) /                                              &
     & 5.120420E-08,2.309380E-07,1.233875E-06,3.404911E-06,3.034329E-06,&
     & 2.794253E-06,2.772649E-06,2.803828E-06,3.034470E-06,1.486550E-06,&
     & 5.512390E-08,2.416960E-07,1.275577E-06,3.296129E-06,2.942325E-06,&
     & 2.723483E-06,2.702214E-06,2.723417E-06,2.885590E-06,1.482830E-06,&
     & 5.934360E-08,2.529550E-07,1.318817E-06,3.190927E-06,2.853138E-06,&
     & 2.654555E-06,2.633985E-06,2.645397E-06,2.744010E-06,1.479130E-06,&
     & 6.388630E-08,2.647380E-07,1.363666E-06,3.089172E-06,2.766672E-06,&
     & 2.587417E-06,2.567869E-06,2.569694E-06,2.609380E-06,1.475430E-06,&
     & 6.877670E-08,2.770710E-07,1.410189E-06,2.990755E-06,2.682850E-06,&
     & 2.522020E-06,2.503811E-06,2.496240E-06,2.481350E-06,1.471740E-06,&
     & 7.404150E-08,2.899780E-07,1.458450E-06,2.895555E-06,2.601588E-06,&
     & 2.458315E-06,2.441728E-06,2.424955E-06,2.359610E-06,1.468060E-06,&
     & 7.970930E-08,3.034860E-07,1.508520E-06,2.803479E-06,2.522806E-06,&
     & 2.396268E-06,2.381551E-06,2.355783E-06,2.243840E-06,1.464390E-06,&
     & 8.581100E-08,3.176230E-07,1.560477E-06,2.714407E-06,2.446428E-06,&
     & 2.335813E-06,2.323214E-06,2.288660E-06,2.133750E-06,1.460720E-06,&
     & 9.237970E-08,3.324190E-07,1.614398E-06,2.628246E-06,2.372385E-06,&
     & 2.276932E-06,2.266654E-06,2.223520E-06,2.029060E-06,1.457070E-06,&
     & 9.945130E-08,3.479040E-07,1.670359E-06,2.544896E-06,2.300594E-06,&
     & 2.219573E-06,2.211809E-06,2.160297E-06,1.929510E-06,1.453430E-06,&
     & 1.070640E-07,3.641110E-07,1.728450E-06,2.464263E-06,2.230998E-06,&
     & 2.163691E-06,2.158616E-06,2.098933E-06,1.834840E-06,1.449790E-06,&
     & 1.152600E-07,3.810720E-07,1.788757E-06,2.386262E-06,2.163523E-06,&
     & 2.109256E-06,2.107026E-06,2.039384E-06,1.744810E-06,1.446170E-06,&
     & 1.240830E-07,3.988240E-07,1.851384E-06,2.310795E-06,2.098102E-06,&
     & 2.056222E-06,2.056976E-06,1.981583E-06,1.659210E-06,1.442550E-06,&
     & 1.335810E-07,4.174020E-07,1.916406E-06,2.237783E-06,2.034683E-06,&
     & 2.004552E-06,2.008422E-06,1.925482E-06,1.577800E-06,1.438940E-06,&
     & 1.438070E-07,4.368460E-07,1.983936E-06,2.167142E-06,1.973187E-06,&
     & 1.954209E-06,1.961300E-06,1.871024E-06,1.500390E-06,1.435340E-06,&
     & 1.548150E-07,4.571960E-07,2.054075E-06,2.098796E-06,1.913573E-06,&
     & 1.905157E-06,1.915570E-06,1.818158E-06,1.426770E-06,1.431760E-06,&
     & 1.666660E-07,4.784940E-07,2.126946E-06,2.032665E-06,1.855773E-06,&
     & 1.857369E-06,1.871185E-06,1.766843E-06,1.356770E-06,1.428170E-06,&
     & 1.794240E-07,5.007840E-07,2.202641E-06,1.968674E-06,1.799725E-06,&
     & 1.810808E-06,1.828097E-06,1.717031E-06,1.290200E-06,1.424600E-06,&
     & 1.931590E-07,5.241120E-07,2.281302E-06,1.906758E-06,1.745393E-06,&
     & 1.765440E-06,1.786258E-06,1.668673E-06,1.226900E-06,1.421040E-06/

      data  kb_mn2(:, :) /                                              &
     & 5.120420E-08,2.309380E-07,1.233875E-06,3.404911E-06,3.034329E-06,&
     & 2.794253E-06,2.772649E-06,2.803828E-06,3.034470E-06,1.486550E-06,&
     & 5.512390E-08,2.416960E-07,1.275577E-06,3.296129E-06,2.942325E-06,&
     & 2.723483E-06,2.702214E-06,2.723417E-06,2.885590E-06,1.482830E-06,&
     & 5.934360E-08,2.529550E-07,1.318817E-06,3.190927E-06,2.853138E-06,&
     & 2.654555E-06,2.633985E-06,2.645397E-06,2.744010E-06,1.479130E-06,&
     & 6.388630E-08,2.647380E-07,1.363666E-06,3.089172E-06,2.766672E-06,&
     & 2.587417E-06,2.567869E-06,2.569694E-06,2.609380E-06,1.475430E-06,&
     & 6.877670E-08,2.770710E-07,1.410189E-06,2.990755E-06,2.682850E-06,&
     & 2.522020E-06,2.503811E-06,2.496240E-06,2.481350E-06,1.471740E-06,&
     & 7.404150E-08,2.899780E-07,1.458450E-06,2.895555E-06,2.601588E-06,&
     & 2.458315E-06,2.441728E-06,2.424955E-06,2.359610E-06,1.468060E-06,&
     & 7.970930E-08,3.034860E-07,1.508520E-06,2.803479E-06,2.522806E-06,&
     & 2.396268E-06,2.381551E-06,2.355783E-06,2.243840E-06,1.464390E-06,&
     & 8.581100E-08,3.176230E-07,1.560477E-06,2.714407E-06,2.446428E-06,&
     & 2.335813E-06,2.323214E-06,2.288660E-06,2.133750E-06,1.460720E-06,&
     & 9.237970E-08,3.324190E-07,1.614398E-06,2.628246E-06,2.372385E-06,&
     & 2.276932E-06,2.266654E-06,2.223520E-06,2.029060E-06,1.457070E-06,&
     & 9.945130E-08,3.479040E-07,1.670359E-06,2.544896E-06,2.300594E-06,&
     & 2.219573E-06,2.211809E-06,2.160297E-06,1.929510E-06,1.453430E-06,&
     & 1.070640E-07,3.641110E-07,1.728450E-06,2.464263E-06,2.230998E-06,&
     & 2.163691E-06,2.158616E-06,2.098933E-06,1.834840E-06,1.449790E-06,&
     & 1.152600E-07,3.810720E-07,1.788757E-06,2.386262E-06,2.163523E-06,&
     & 2.109256E-06,2.107026E-06,2.039384E-06,1.744810E-06,1.446170E-06,&
     & 1.240830E-07,3.988240E-07,1.851384E-06,2.310795E-06,2.098102E-06,&
     & 2.056222E-06,2.056976E-06,1.981583E-06,1.659210E-06,1.442550E-06,&
     & 1.335810E-07,4.174020E-07,1.916406E-06,2.237783E-06,2.034683E-06,&
     & 2.004552E-06,2.008422E-06,1.925482E-06,1.577800E-06,1.438940E-06,&
     & 1.438070E-07,4.368460E-07,1.983936E-06,2.167142E-06,1.973187E-06,&
     & 1.954209E-06,1.961300E-06,1.871024E-06,1.500390E-06,1.435340E-06,&
     & 1.548150E-07,4.571960E-07,2.054075E-06,2.098796E-06,1.913573E-06,&
     & 1.905157E-06,1.915570E-06,1.818158E-06,1.426770E-06,1.431760E-06,&
     & 1.666660E-07,4.784940E-07,2.126946E-06,2.032665E-06,1.855773E-06,&
     & 1.857369E-06,1.871185E-06,1.766843E-06,1.356770E-06,1.428170E-06,&
     & 1.794240E-07,5.007840E-07,2.202641E-06,1.968674E-06,1.799725E-06,&
     & 1.810808E-06,1.828097E-06,1.717031E-06,1.290200E-06,1.424600E-06,&
     & 1.931590E-07,5.241120E-07,2.281302E-06,1.906758E-06,1.745393E-06,&
     & 1.765440E-06,1.786258E-06,1.668673E-06,1.226900E-06,1.421040E-06/

! --- planck fraction mapping level: p = 212.7250 mbar, t = 223.06 k

      data  fracrefa(:) /                                               &
     & 2.122700e-01,1.889700e-01,2.549100e-01,1.786410e-01,1.173490e-01,&
     & 3.829770e-02,5.787100e-03,3.175300e-03,5.316900e-04,7.647600e-05/

! --- planck fraction mapping level: p = 212.7250 mbar, t = 223.06 k
!     these planck fractions were calculated using lower atmosphere
!     parameters.

      data  fracrefb(:) /                                               &
     & 2.122700e-01,1.889700e-01,2.549100e-01,1.786410e-01,1.173490e-01,&
     & 3.829770e-02,5.787100e-03,3.175300e-03,5.316900e-04,7.647600e-05/

!........................................!
      end module module_radlw_kgb01      !
!========================================!


!========================================!
      module module_radlw_kgb02          !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NG02
!
      implicit none
!
      private
!
      integer, public :: MSA02, MSB02, MSF02, MFR02
      parameter (MSA02=65, MSB02=235, MSF02=10, MFR02=4)

      real (kind=kind_phys), public ::                                  &
     &       absa(NG02,MSA02), absb(NG02,MSB02), selfref(NG02,MSF02),   &
     &       forref(NG02,MFR02), fracrefa(NG02), fracrefb(NG02)

! --- the array absa(NG02,65) = ka(NG02,5,13) contains absorption coefs
!     at the NG02=12 chosen g-values for a range of pressure levels>~100mb
!     and temperatures.  the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 1 to 13 and refers to the corresponding
!     pressure level in pref (e.g. jp = 1 is for a pressure of 1053.63 mb).
!     the third index, ig, goes from 1 to NG02=12, and tells us which
!     g-interval the absorption coefficients are for.

      data   absa(:,  1: 25) /                                          &
     & 4.944400E-03,1.002700E-02,2.047500E-02,3.415000E-02,7.412800E-02,&
     & 2.061300E-01,6.492400E-01,1.585200E+00,6.013277E+00,1.953498E+01,&
     & 3.522639E+01,7.170971E+01,5.945900E-03,1.179100E-02,2.488600E-02,&
     & 4.036700E-02,9.032800E-02,2.515700E-01,7.730700E-01,1.893700E+00,&
     & 7.217752E+00,2.384686E+01,4.519749E+01,9.302171E+01,7.090900E-03,&
     & 1.393200E-02,2.805600E-02,4.928000E-02,1.084500E-01,3.017800E-01,&
     & 9.038600E-01,2.223300E+00,8.556270E+00,2.855482E+01,5.673227E+01,&
     & 1.171197E+02,8.208200E-03,1.666600E-02,3.168700E-02,5.910000E-02,&
     & 1.284200E-01,3.568300E-01,1.038800E+00,2.575900E+00,1.001266E+01,&
     & 3.378377E+01,6.952789E+01,1.437207E+02,9.207100E-03,2.012600E-02,&
     & 3.601100E-02,6.949900E-02,1.499300E-01,4.154200E-01,1.177300E+00,&
     & 2.944700E+00,1.157710E+01,3.948620E+01,8.343575E+01,1.732833E+02,&
     & 3.625300E-03,7.405600E-03,1.529300E-02,2.550400E-02,5.642100E-02,&
     & 1.581900E-01,5.057700E-01,1.302000E+00,5.404800E+00,1.931877E+01,&
     & 3.501349E+01,7.738421E+01,4.386000E-03,8.828500E-03,1.864900E-02,&
     & 3.044700E-02,6.893200E-02,1.943200E-01,6.078600E-01,1.560800E+00,&
     & 6.539959E+00,2.354261E+01,4.507376E+01,1.016215E+02,5.254100E-03,&
     & 1.046000E-02,2.119700E-02,3.732100E-02,8.329400E-02,2.345200E-01,&
     & 7.163900E-01,1.840800E+00,7.803242E+00,2.813705E+01,5.690383E+01,&
     & 1.292157E+02,6.041900E-03,1.266900E-02,2.410600E-02,4.494400E-02,&
     & 9.911100E-02,2.785800E-01,8.285500E-01,2.141500E+00,9.186269E+00,&
     & 3.310030E+01,7.035003E+01,1.603019E+02,6.883500E-03,1.528200E-02,&
     & 2.748500E-02,5.329800E-02,1.161700E-01,3.258700E-01,9.449300E-01,&
     & 2.461400E+00,1.067922E+01,3.845742E+01,8.507015E+01,1.952131E+02,&
     & 2.533800E-03,5.266100E-03,1.091800E-02,1.837100E-02,4.091600E-02,&
     & 1.153100E-01,3.738400E-01,1.012600E+00,4.588054E+00,1.792464E+01,&
     & 3.367887E+01,7.748452E+01,3.098500E-03,6.292800E-03,1.348000E-02,&
     & 2.208500E-02,5.038500E-02,1.430600E-01,4.563800E-01,1.223900E+00,&
     & 5.608161E+00,2.215926E+01,4.315130E+01,1.038670E+02,3.740000E-03,&
     & 7.554000E-03,1.549600E-02,2.722600E-02,6.125700E-02,1.743500E-01,&
     & 5.436100E-01,1.455300E+00,6.760208E+00,2.661942E+01,5.466589E+01,&
     & 1.344875E+02,4.299600E-03,9.238700E-03,1.776900E-02,3.299400E-02,&
     & 7.347400E-02,2.087600E-01,6.356300E-01,1.704000E+00,8.031504E+00,&
     & 3.135371E+01,6.808686E+01,1.698614E+02,4.967500E-03,1.118200E-02,&
     & 2.039800E-02,3.940300E-02,8.673200E-02,2.463200E-01,7.310800E-01,&
     & 1.970200E+00,9.400717E+00,3.654827E+01,8.301260E+01,2.096201E+02,&
     & 1.775500E-03,3.783000E-03,7.739500E-03,1.323500E-02,2.943000E-02,&
     & 8.328400E-02,2.715700E-01,7.685600E-01,3.798968E+00,1.605929E+01,&
     & 3.206772E+01,7.368439E+01,2.197300E-03,4.514400E-03,9.662500E-03,&
     & 1.604600E-02,3.655600E-02,1.044400E-01,3.376900E-01,9.402500E-01,&
     & 4.696894E+00,2.003915E+01,4.111361E+01,1.012819E+02,2.666400E-03,&
     & 5.462200E-03,1.137900E-02,1.981300E-02,4.474200E-02,1.286400E-01,&
     & 4.079800E-01,1.131600E+00,5.714865E+00,2.443126E+01,5.195613E+01,&
     & 1.344106E+02,3.111100E-03,6.686900E-03,1.313000E-02,2.415600E-02,&
     & 5.419900E-02,1.556000E-01,4.829800E-01,1.338600E+00,6.830858E+00,&
     & 2.928685E+01,6.466049E+01,1.730232E+02,3.609100E-03,8.143500E-03,&
     & 1.517000E-02,2.908200E-02,6.458000E-02,1.853500E-01,5.615800E-01,&
     & 1.560500E+00,8.049216E+00,3.446437E+01,7.929820E+01,2.169127E+02,&
     & 1.256500E-03,2.748000E-03,5.499500E-03,9.599800E-03,2.121200E-02,&
     & 6.016600E-02,1.964800E-01,5.761600E-01,3.098845E+00,1.413651E+01,&
     & 3.072892E+01,6.799917E+01,1.578900E-03,3.304200E-03,6.906300E-03,&
     & 1.170900E-02,2.660200E-02,7.631500E-02,2.483800E-01,7.135900E-01,&
     & 3.877155E+00,1.790609E+01,3.921055E+01,9.627558E+01,1.919600E-03,&
     & 3.972600E-03,8.523300E-03,1.433800E-02,3.278000E-02,9.493700E-02,&
     & 3.052100E-01,8.683200E-01,4.762634E+00,2.211825E+01,4.949310E+01,&
     & 1.310325E+02,2.309600E-03,4.825800E-03,9.812500E-03,1.770700E-02,&
     & 4.008400E-02,1.160400E-01,3.659000E-01,1.038800E+00,5.744773E+00,&
     & 2.677399E+01,6.173005E+01,1.721304E+02,2.651900E-03,5.951000E-03,&
     & 1.136800E-02,2.150500E-02,4.823600E-02,1.395800E-01,4.300500E-01,&
     & 1.222800E+00,6.820642E+00,3.193634E+01,7.573209E+01,2.192692E+02/
      data   absa(:, 26: 50) /                                          &
     & 8.862400E-04,2.006300E-03,3.900200E-03,6.902200E-03,1.515100E-02,&
     & 4.300300E-02,1.396600E-01,4.235000E-01,2.468341E+00,1.219654E+01,&
     & 2.882590E+01,6.263361E+01,1.117500E-03,2.398400E-03,4.930700E-03,&
     & 8.563000E-03,1.912900E-02,5.523000E-02,1.798700E-01,5.326800E-01,&
     & 3.133123E+00,1.556280E+01,3.726426E+01,8.841400E+01,1.381800E-03,&
     & 2.871300E-03,6.203700E-03,1.039500E-02,2.389700E-02,6.944700E-02,&
     & 2.252400E-01,6.560500E-01,3.890294E+00,1.948190E+01,4.706654E+01,&
     & 1.235954E+02,1.693400E-03,3.486400E-03,7.310000E-03,1.286900E-02,&
     & 2.943600E-02,8.578100E-02,2.740500E-01,7.933400E-01,4.734638E+00,&
     & 2.396097E+01,5.869748E+01,1.660609E+02,1.963500E-03,4.313500E-03,&
     & 8.468900E-03,1.578700E-02,3.579800E-02,1.042400E-01,3.259300E-01,&
     & 9.422300E-01,5.671975E+00,2.890648E+01,7.222433E+01,2.154145E+02,&
     & 6.284300E-04,1.484600E-03,2.736900E-03,5.062200E-03,1.071800E-02,&
     & 3.049000E-02,9.835300E-02,3.068600E-01,1.933490E+00,1.038320E+01,&
     & 2.646348E+01,5.991856E+01,7.925300E-04,1.745300E-03,3.507800E-03,&
     & 6.186100E-03,1.380200E-02,3.976900E-02,1.291700E-01,3.922500E-01,&
     & 2.492441E+00,1.333433E+01,3.494088E+01,8.256641E+01,1.001200E-03,&
     & 2.098100E-03,4.435200E-03,7.564200E-03,1.738900E-02,5.061800E-02,&
     & 1.644500E-01,4.901000E-01,3.132172E+00,1.684098E+01,4.485384E+01,&
     & 1.145766E+02,1.222200E-03,2.544400E-03,5.509800E-03,9.283500E-03,&
     & 2.150500E-02,6.320000E-02,2.036500E-01,5.994400E-01,3.855852E+00,&
     & 2.090759E+01,5.622177E+01,1.566366E+02,1.473400E-03,3.105600E-03,&
     & 6.346300E-03,1.153000E-02,2.644000E-02,7.759700E-02,2.453100E-01,&
     & 7.196700E-01,4.665478E+00,2.553266E+01,6.926113E+01,2.073040E+02,&
     & 4.502300E-04,1.121000E-03,1.929400E-03,3.773400E-03,7.491700E-03,&
     & 2.157000E-02,6.879500E-02,2.207000E-01,1.487856E+00,8.745265E+00,&
     & 2.405343E+01,5.871087E+01,5.648300E-04,1.287900E-03,2.502800E-03,&
     & 4.495600E-03,9.912500E-03,2.857300E-02,9.224400E-02,2.868800E-01,&
     & 1.947839E+00,1.136738E+01,3.219331E+01,7.956594E+01,7.156800E-04,&
     & 1.544900E-03,3.175100E-03,5.574900E-03,1.257800E-02,3.680300E-02,&
     & 1.195100E-01,3.634800E-01,2.481517E+00,1.449670E+01,4.211189E+01,&
     & 1.082280E+02,8.902600E-04,1.852400E-03,4.025500E-03,6.772100E-03,&
     & 1.577000E-02,4.643700E-02,1.505300E-01,4.500700E-01,3.094219E+00,&
     & 1.814991E+01,5.348641E+01,1.476106E+02,1.092900E-03,2.256200E-03,&
     & 4.759300E-03,8.425300E-03,1.948300E-02,5.762600E-02,1.839200E-01,&
     & 5.459700E-01,3.787395E+00,2.234890E+01,6.626404E+01,1.981963E+02,&
     & 3.252000E-04,8.557400E-04,1.280600E-03,2.961900E-03,5.116800E-03,&
     & 1.515500E-02,4.772000E-02,1.575000E-01,1.121637E+00,7.202352E+00,&
     & 2.172719E+01,5.785118E+01,4.040700E-04,9.642300E-04,1.765900E-03,&
     & 3.331500E-03,7.036800E-03,2.045000E-02,6.537400E-02,2.083200E-01,&
     & 1.494962E+00,9.508649E+00,2.937548E+01,7.751093E+01,5.120900E-04,&
     & 1.133600E-03,2.278600E-03,4.062100E-03,9.108900E-03,2.667300E-02,&
     & 8.629400E-02,2.677400E-01,1.933591E+00,1.230357E+01,3.886673E+01,&
     & 1.042746E+02,6.494900E-04,1.365900E-03,2.893300E-03,4.969400E-03,&
     & 1.152700E-02,3.400400E-02,1.104400E-01,3.358400E-01,2.441720E+00,&
     & 1.556581E+01,5.013019E+01,1.406601E+02,7.958100E-04,1.659400E-03,&
     & 3.611200E-03,6.111700E-03,1.429300E-02,4.262000E-02,1.372100E-01,&
     & 4.116900E-01,3.024704E+00,1.937381E+01,6.276931E+01,1.889857E+02,&
     & 2.412600E-04,6.684800E-04,8.642900E-04,2.220400E-03,3.698300E-03,&
     & 1.085200E-02,3.388100E-02,1.145800E-01,8.519646E-01,5.998988E+00,&
     & 1.977045E+01,5.882394E+01,2.958100E-04,7.401600E-04,1.287100E-03,&
     & 2.512300E-03,5.062700E-03,1.489300E-02,4.721100E-02,1.539800E-01,&
     & 1.153366E+00,8.007828E+00,2.714673E+01,7.753900E+01,3.740400E-04,&
     & 8.547900E-04,1.666100E-03,3.017600E-03,6.699100E-03,1.966800E-02,&
     & 6.337700E-02,2.004700E-01,1.515323E+00,1.046035E+01,3.630810E+01,&
     & 1.034219E+02,4.758500E-04,1.027400E-03,2.120700E-03,3.732100E-03,&
     & 8.527500E-03,2.532400E-02,8.229400E-02,2.542000E-01,1.938589E+00,&
     & 1.340382E+01,4.717326E+01,1.390180E+02,5.908500E-04,1.234300E-03,&
     & 2.695600E-03,4.554500E-03,1.069600E-02,3.199200E-02,1.037400E-01,&
     & 3.145200E-01,2.426376E+00,1.683331E+01,5.973290E+01,1.859478E+02/
      data   absa(:, 51: 65) /                                          &
     & 1.950100E-04,5.502200E-04,7.098900E-04,1.828800E-03,3.048400E-03,&
     & 9.051100E-03,2.830400E-02,9.635200E-02,7.434837E-01,5.681689E+00,&
     & 2.078122E+01,6.745005E+01,2.415200E-04,6.047300E-04,1.055500E-03,&
     & 2.060200E-03,4.191600E-03,1.242200E-02,3.938600E-02,1.294500E-01,&
     & 1.007571E+00,7.610196E+00,2.848452E+01,8.902419E+01,3.064900E-04,&
     & 6.996300E-04,1.369100E-03,2.483800E-03,5.534600E-03,1.637400E-02,&
     & 5.291100E-02,1.685000E-01,1.326750E+00,9.954843E+00,3.808500E+01,&
     & 1.180042E+02,3.910400E-04,8.410600E-04,1.745000E-03,3.068500E-03,&
     & 7.051300E-03,2.108400E-02,6.867100E-02,2.134300E-01,1.700806E+00,&
     & 1.275367E+01,4.933945E+01,1.580657E+02,4.888100E-04,1.009700E-03,&
     & 2.218400E-03,3.750800E-03,8.849800E-03,2.664300E-02,8.647700E-02,&
     & 2.641800E-01,2.128649E+00,1.600788E+01,6.238418E+01,2.103504E+02,&
     & 1.588100E-04,4.497200E-04,5.863000E-04,1.505100E-03,2.517400E-03,&
     & 7.533200E-03,2.364300E-02,8.085900E-02,6.432431E-01,5.321027E+00,&
     & 2.160492E+01,7.708402E+01,1.976300E-04,4.943600E-04,8.661500E-04,&
     & 1.691600E-03,3.471400E-03,1.033800E-02,3.284900E-02,1.086900E-01,&
     & 8.739707E-01,7.138283E+00,2.959083E+01,1.017898E+02,2.517700E-04,&
     & 5.723900E-04,1.126500E-03,2.046600E-03,4.571800E-03,1.362300E-02,&
     & 4.412100E-02,1.414200E-01,1.152064E+00,9.359849E+00,3.948405E+01,&
     & 1.347318E+02,3.244100E-04,6.873800E-04,1.435700E-03,2.523900E-03,&
     & 5.834100E-03,1.753100E-02,5.724600E-02,1.790500E-01,1.477780E+00,&
     & 1.200431E+01,5.105678E+01,1.796750E+02,4.063200E-04,8.303800E-04,&
     & 1.822100E-03,3.090500E-03,7.319500E-03,2.217400E-02,7.205200E-02,&
     & 2.215900E-01,1.847414E+00,1.503577E+01,6.439994E+01,2.387644E+02,&
     & 1.300300E-04,3.674500E-04,4.837200E-04,1.237300E-03,2.077000E-03,&
     & 6.256800E-03,1.967800E-02,6.768500E-02,5.527753E-01,4.902282E+00,&
     & 2.225079E+01,8.726790E+01,1.621600E-04,4.046000E-04,7.103100E-04,&
     & 1.390700E-03,2.868400E-03,8.575400E-03,2.733900E-02,9.102800E-02,&
     & 7.519311E-01,6.593505E+00,3.046937E+01,1.151903E+02,2.076800E-04,&
     & 4.682800E-04,9.261800E-04,1.684800E-03,3.771800E-03,1.131300E-02,&
     & 3.669300E-02,1.183800E-01,9.923565E-01,8.646098E+00,4.048815E+01,&
     & 1.531617E+02,2.686400E-04,5.642700E-04,1.178700E-03,2.076400E-03,&
     & 4.819200E-03,1.456200E-02,4.758300E-02,1.499000E-01,1.270646E+00,&
     & 1.107301E+01,5.226123E+01,2.041494E+02,3.349700E-04,6.838700E-04,&
     & 1.499800E-03,2.545500E-03,6.041200E-03,1.843900E-02,5.983800E-02,&
     & 1.855900E-01,1.586675E+00,1.389204E+01,6.566659E+01,2.705407E+02/

! --- the array absb(NG02,235) = kb(NG02,5,13:59) contains absorption coefs
!     at the NG02=12 chosen g-values for a range of pressure levels< ~100mb
!     and temperatures. the first index in the array, jt, which runs from
!     1 to 5, corresponds to different temperatures.  more specifically,
!     jt = 1-5 means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively.  the
!     second index, jp, runs from 13 to 59 and refers to the jpth reference
!     pressure level (see taumol.f for the value of these pressure levels
!     in mb).  the third index, ig, goes from 1 to NG02=12, and tells us
!     which g-interval the absorption coefficients are for.

      data   absb(:,  1: 25) /                                          &
     & 1.300000E-04,3.678200E-04,4.832900E-04,1.237500E-03,2.076800E-03,&
     & 6.256300E-03,1.967800E-02,6.770300E-02,5.530531E-01,4.905021E+00,&
     & 2.226307E+01,8.732056E+01,1.621600E-04,4.046000E-04,7.103100E-04,&
     & 1.390700E-03,2.868400E-03,8.575400E-03,2.733900E-02,9.102800E-02,&
     & 7.519311E-01,6.593505E+00,3.046937E+01,1.151903E+02,2.076800E-04,&
     & 4.682800E-04,9.261800E-04,1.684800E-03,3.771800E-03,1.131300E-02,&
     & 3.669300E-02,1.183800E-01,9.923565E-01,8.646098E+00,4.048815E+01,&
     & 1.531617E+02,2.686400E-04,5.642700E-04,1.178700E-03,2.076400E-03,&
     & 4.819200E-03,1.456200E-02,4.758300E-02,1.499000E-01,1.270646E+00,&
     & 1.107301E+01,5.226123E+01,2.041494E+02,3.349700E-04,6.838700E-04,&
     & 1.499800E-03,2.545500E-03,6.041200E-03,1.843900E-02,5.983800E-02,&
     & 1.855900E-01,1.586675E+00,1.389204E+01,6.566659E+01,2.705407E+02,&
     & 1.085000E-04,3.020600E-04,4.157300E-04,1.035200E-03,1.756400E-03,&
     & 5.340700E-03,1.685500E-02,5.822200E-02,4.862504E-01,4.570015E+00,&
     & 2.345911E+01,1.001579E+02,1.360200E-04,3.353400E-04,5.962100E-04,&
     & 1.162600E-03,2.433200E-03,7.287400E-03,2.333200E-02,7.800700E-02,&
     & 6.596580E-01,6.151633E+00,3.186175E+01,1.331495E+02,1.755300E-04,&
     & 3.890400E-04,7.778100E-04,1.415300E-03,3.182400E-03,9.603100E-03,&
     & 3.120000E-02,1.011800E-01,8.669796E-01,8.056362E+00,4.197745E+01,&
     & 1.782609E+02,2.268600E-04,4.690800E-04,9.925300E-04,1.741000E-03,&
     & 4.062500E-03,1.234400E-02,4.035400E-02,1.278400E-01,1.107368E+00,&
     & 1.030318E+01,5.384863E+01,2.374828E+02,2.816200E-04,5.735400E-04,&
     & 1.256100E-03,2.141000E-03,5.088900E-03,1.561600E-02,5.054900E-02,&
     & 1.581100E-01,1.381359E+00,1.291414E+01,6.747303E+01,3.122435E+02,&
     & 9.086400E-05,2.490300E-04,3.574500E-04,8.691600E-04,1.490800E-03,&
     & 4.562400E-03,1.444700E-02,5.006900E-02,4.265627E-01,4.224471E+00,&
     & 2.448805E+01,1.146573E+02,1.147600E-04,2.771800E-04,5.035600E-04,&
     & 9.745000E-04,2.071200E-03,6.202600E-03,1.992600E-02,6.683800E-02,&
     & 5.762193E-01,5.675222E+00,3.292823E+01,1.540117E+02,1.483200E-04,&
     & 3.257400E-04,6.539100E-04,1.191800E-03,2.693400E-03,8.161600E-03,&
     & 2.653900E-02,8.646900E-02,7.543865E-01,7.437331E+00,4.302646E+01,&
     & 2.068535E+02,1.908100E-04,3.927100E-04,8.399900E-04,1.461700E-03,&
     & 3.435300E-03,1.048000E-02,3.420300E-02,1.090100E-01,9.621639E-01,&
     & 9.511734E+00,5.488035E+01,2.749093E+02,2.369800E-04,4.820200E-04,&
     & 1.055900E-03,1.809000E-03,4.290900E-03,1.323600E-02,4.274100E-02,&
     & 1.346800E-01,1.199380E+00,1.189659E+01,6.859742E+01,3.587524E+02,&
     & 7.620200E-05,2.057000E-04,3.075800E-04,7.155600E-04,1.283700E-03,&
     & 3.895700E-03,1.237500E-02,4.303800E-02,3.729041E-01,3.860561E+00,&
     & 2.516332E+01,1.317036E+02,9.689700E-05,2.304300E-04,4.251200E-04,&
     & 8.181200E-04,1.762400E-03,5.279300E-03,1.700700E-02,5.724700E-02,&
     & 5.013452E-01,5.191967E+00,3.361380E+01,1.775088E+02,1.252100E-04,&
     & 2.732300E-04,5.506300E-04,1.004000E-03,2.285000E-03,6.925900E-03,&
     & 2.257000E-02,7.383800E-02,6.546915E-01,6.795976E+00,4.356923E+01,&
     & 2.386453E+02,1.603200E-04,3.294000E-04,7.103200E-04,1.231100E-03,&
     & 2.912000E-03,8.884600E-03,2.901100E-02,9.287600E-02,8.339132E-01,&
     & 8.674408E+00,5.530814E+01,3.157412E+02,1.992500E-04,4.053900E-04,&
     & 8.840500E-04,1.528600E-03,3.636600E-03,1.120200E-02,3.615500E-02,&
     & 1.146200E-01,1.037258E+00,1.081744E+01,6.891814E+01,4.100336E+02,&
     & 6.398400E-05,1.697300E-04,2.642800E-04,5.896500E-04,1.100700E-03,&
     & 3.320900E-03,1.057200E-02,3.690500E-02,3.242127E-01,3.488107E+00,&
     & 2.539369E+01,1.509522E+02,8.167100E-05,1.922600E-04,3.593900E-04,&
     & 6.852100E-04,1.497000E-03,4.481500E-03,1.448000E-02,4.892200E-02,&
     & 4.345028E-01,4.684986E+00,3.369204E+01,2.038017E+02,1.056500E-04,&
     & 2.290800E-04,4.647600E-04,8.437200E-04,1.937200E-03,5.869800E-03,&
     & 1.914800E-02,6.292100E-02,5.664944E-01,6.122466E+00,4.348620E+01,&
     & 2.733041E+02,1.344800E-04,2.762700E-04,5.999000E-04,1.037500E-03,&
     & 2.463300E-03,7.520400E-03,2.455700E-02,7.898000E-02,7.197708E-01,&
     & 7.794669E+00,5.502017E+01,3.600156E+02,1.669600E-04,3.405700E-04,&
     & 7.344400E-04,1.297600E-03,3.086800E-03,9.448600E-03,3.054300E-02,&
     & 9.724900E-02,8.924907E-01,9.686957E+00,6.838464E+01,4.649345E+02/
      data   absb(:, 26: 50) /                                          &
     & 5.374900E-05,1.405900E-04,2.262000E-04,4.872600E-04,9.399800E-04,&
     & 2.829000E-03,9.018700E-03,3.153900E-02,2.812836E-01,3.119591E+00,&
     & 2.514284E+01,1.725588E+02,6.875900E-05,1.601800E-04,3.037100E-04,&
     & 5.734200E-04,1.269700E-03,3.808900E-03,1.230800E-02,4.167000E-02,&
     & 3.759118E-01,4.184593E+00,3.325525E+01,2.325869E+02,8.903600E-05,&
     & 1.918200E-04,3.924200E-04,7.097900E-04,1.637800E-03,4.977300E-03,&
     & 1.623000E-02,5.345000E-02,4.888705E-01,5.449038E+00,4.285910E+01,&
     & 3.102397E+02,1.127400E-04,2.317100E-04,5.056900E-04,8.735000E-04,&
     & 2.080200E-03,6.368400E-03,2.076200E-02,6.695100E-02,6.192504E-01,&
     & 6.907857E+00,5.414852E+01,4.064277E+02,1.382400E-04,2.873000E-04,&
     & 6.105700E-04,1.099600E-03,2.608200E-03,7.989000E-03,2.575400E-02,&
     & 8.233500E-02,7.661204E-01,8.564466E+00,6.718098E+01,5.221488E+02,&
     & 4.516000E-05,1.161700E-04,1.934900E-04,4.034600E-04,8.010000E-04,&
     & 2.411200E-03,7.696000E-03,2.684000E-02,2.436369E-01,2.760901E+00,&
     & 2.448432E+01,1.960246E+02,5.787400E-05,1.335800E-04,2.570300E-04,&
     & 4.792300E-04,1.074200E-03,3.246200E-03,1.046200E-02,3.536600E-02,&
     & 3.247434E-01,3.693467E+00,3.234538E+01,2.633294E+02,7.495400E-05,&
     & 1.604200E-04,3.304500E-04,5.951200E-04,1.384900E-03,4.231600E-03,&
     & 1.375700E-02,4.526400E-02,4.209599E-01,4.793346E+00,4.169395E+01,&
     & 3.491120E+02,9.448700E-05,1.942400E-04,4.257200E-04,7.347400E-04,&
     & 1.756900E-03,5.406000E-03,1.755300E-02,5.656900E-02,5.317288E-01,&
     & 6.068155E+00,5.263661E+01,4.548085E+02,1.148500E-04,2.417700E-04,&
     & 5.088500E-04,9.290900E-04,2.203000E-03,6.772000E-03,2.171200E-02,&
     & 6.949600E-02,6.562262E-01,7.523582E+00,6.528703E+01,5.805857E+02,&
     & 3.805000E-05,9.654600E-05,1.660100E-04,3.325200E-04,6.866300E-04,&
     & 2.069100E-03,6.594700E-03,2.291800E-02,2.115262E-01,2.439897E+00,&
     & 2.368919E+01,2.216178E+02,4.893400E-05,1.118700E-04,2.167900E-04,&
     & 4.034000E-04,9.119500E-04,2.779100E-03,8.929500E-03,3.009000E-02,&
     & 2.811967E-01,3.244400E+00,3.127030E+01,2.965780E+02,6.337600E-05,&
     & 1.346100E-04,2.793800E-04,5.012900E-04,1.175700E-03,3.612200E-03,&
     & 1.170700E-02,3.840400E-02,3.633901E-01,4.200375E+00,4.032057E+01,&
     & 3.909667E+02,7.939300E-05,1.631900E-04,3.587700E-04,6.212000E-04,&
     & 1.488300E-03,4.602800E-03,1.488000E-02,4.792800E-02,4.574454E-01,&
     & 5.317863E+00,5.088797E+01,5.061948E+02,9.556500E-05,2.043000E-04,&
     & 4.245600E-04,7.873800E-04,1.864700E-03,5.771500E-03,1.833200E-02,&
     & 5.883100E-02,5.628974E-01,6.583557E+00,6.300681E+01,6.430230E+02,&
     & 3.212100E-05,8.046500E-05,1.397300E-04,2.782400E-04,5.870500E-04,&
     & 1.773900E-03,5.651800E-03,1.955600E-02,1.835343E-01,2.139678E+00,&
     & 2.274357E+01,2.481140E+02,4.136800E-05,9.351200E-05,1.835600E-04,&
     & 3.395900E-04,7.739900E-04,2.372400E-03,7.636200E-03,2.558600E-02,&
     & 2.431160E-01,2.838213E+00,3.000905E+01,3.306772E+02,5.358500E-05,&
     & 1.126000E-04,2.366000E-04,4.220600E-04,9.975200E-04,3.072900E-03,&
     & 9.989700E-03,3.257000E-02,3.128686E-01,3.671241E+00,3.868144E+01,&
     & 4.338326E+02,6.674900E-05,1.371200E-04,3.016300E-04,5.245600E-04,&
     & 1.260700E-03,3.912300E-03,1.264600E-02,4.058700E-02,3.927711E-01,&
     & 4.637386E+00,4.876592E+01,5.589903E+02,7.970400E-05,1.724000E-04,&
     & 3.543800E-04,6.665100E-04,1.577100E-03,4.908100E-03,1.551500E-02,&
     & 4.975300E-02,4.823975E-01,5.723956E+00,6.023212E+01,7.073226E+02,&
     & 2.759700E-05,6.752100E-05,1.202400E-04,2.368600E-04,5.105000E-04,&
     & 1.546800E-03,4.955100E-03,1.698800E-02,1.619222E-01,1.908323E+00,&
     & 2.201598E+01,2.807742E+02,3.560600E-05,7.910000E-05,1.577500E-04,&
     & 2.911100E-04,6.682600E-04,2.053500E-03,6.656200E-03,2.211100E-02,&
     & 2.132374E-01,2.522141E+00,2.906818E+01,3.722075E+02,4.606600E-05,&
     & 9.485300E-05,2.042400E-04,3.606700E-04,8.588000E-04,2.651200E-03,&
     & 8.661100E-03,2.802800E-02,2.731588E-01,3.249877E+00,3.738984E+01,&
     & 4.854642E+02,5.691900E-05,1.169400E-04,2.571800E-04,4.483600E-04,&
     & 1.083500E-03,3.377000E-03,1.088300E-02,3.485200E-02,3.415288E-01,&
     & 4.086002E+00,4.698581E+01,6.224706E+02,6.725200E-05,1.475600E-04,&
     & 2.987000E-04,5.722500E-04,1.351400E-03,4.226000E-03,1.328500E-02,&
     & 4.260900E-02,4.180874E-01,5.019222E+00,5.789336E+01,7.835770E+02/
      data   absb(:, 51: 75) /                                          &
     & 2.370300E-05,5.663200E-05,1.042100E-04,2.020300E-04,4.421600E-04,&
     & 1.347500E-03,4.346300E-03,1.481100E-02,1.426495E-01,1.702312E+00,&
     & 2.116813E+01,3.156430E+02,3.067200E-05,6.721100E-05,1.358100E-04,&
     & 2.498500E-04,5.770000E-04,1.776800E-03,5.801900E-03,1.920100E-02,&
     & 1.867358E-01,2.239651E+00,2.785880E+01,4.166086E+02,3.925100E-05,&
     & 8.087500E-05,1.757600E-04,3.088000E-04,7.390600E-04,2.295900E-03,&
     & 7.487400E-03,2.426900E-02,2.380755E-01,2.871586E+00,3.574453E+01,&
     & 5.406955E+02,4.862200E-05,9.962400E-05,2.178500E-04,3.854500E-04,&
     & 9.310200E-04,2.914100E-03,9.342400E-03,3.011200E-02,2.965504E-01,&
     & 3.591337E+00,4.488103E+01,6.890865E+02,5.678300E-05,1.263800E-04,&
     & 2.525600E-04,4.911300E-04,1.157200E-03,3.637300E-03,1.139300E-02,&
     & 3.666300E-02,3.621136E-01,4.393692E+00,5.518737E+01,8.628609E+02,&
     & 2.044400E-05,4.786600E-05,9.064200E-05,1.721500E-04,3.839700E-04,&
     & 1.175200E-03,3.808800E-03,1.296500E-02,1.255283E-01,1.520913E+00,&
     & 2.019605E+01,3.530780E+02,2.647100E-05,5.731000E-05,1.173600E-04,&
     & 2.140900E-04,4.992600E-04,1.543900E-03,5.043900E-03,1.674500E-02,&
     & 1.634553E-01,1.991288E+00,2.647982E+01,4.641212E+02,3.353500E-05,&
     & 6.915400E-05,1.514200E-04,2.649100E-04,6.368200E-04,1.989500E-03,&
     & 6.461700E-03,2.111800E-02,2.074271E-01,2.538807E+00,3.391563E+01,&
     & 5.992684E+02,4.144100E-05,8.530100E-05,1.833400E-04,3.334000E-04,&
     & 8.009900E-04,2.517000E-03,8.040600E-03,2.609300E-02,2.575182E-01,&
     & 3.158890E+00,4.252858E+01,7.595900E+02,4.807000E-05,1.083100E-04,&
     & 2.143200E-04,4.212900E-04,9.915500E-04,3.132800E-03,9.763100E-03,&
     & 3.168900E-02,3.136243E-01,3.846951E+00,5.234107E+01,9.453167E+02,&
     & 1.769100E-05,4.065200E-05,7.865300E-05,1.474400E-04,3.345200E-04,&
     & 1.026300E-03,3.336400E-03,1.139300E-02,1.105643E-01,1.361480E+00,&
     & 1.915701E+01,3.933803E+02,2.289900E-05,4.893300E-05,1.013900E-04,&
     & 1.834100E-04,4.335200E-04,1.344400E-03,4.385500E-03,1.464300E-02,&
     & 1.431854E-01,1.772245E+00,2.506590E+01,5.145993E+02,2.873700E-05,&
     & 5.925700E-05,1.304600E-04,2.276100E-04,5.497200E-04,1.726400E-03,&
     & 5.589100E-03,1.838300E-02,1.809963E-01,2.246912E+00,3.206448E+01,&
     & 6.608701E+02,3.477600E-05,7.383500E-05,1.552000E-04,2.882600E-04,&
     & 6.894600E-04,2.176100E-03,6.919900E-03,2.264400E-02,2.239763E-01,&
     & 2.781962E+00,4.016085E+01,8.331051E+02,4.082000E-05,9.295100E-05,&
     & 1.820000E-04,3.613800E-04,8.520400E-04,2.699000E-03,8.373000E-03,&
     & 2.740000E-02,2.718826E-01,3.374223E+00,4.948242E+01,1.030628E+03,&
     & 1.539100E-05,3.465500E-05,6.834700E-05,1.271200E-04,2.925300E-04,&
     & 9.016600E-04,2.930200E-03,1.003800E-02,9.772406E-02,1.222936E+00,&
     & 1.816212E+01,4.374975E+02,1.990000E-05,4.169400E-05,8.833000E-05,&
     & 1.579500E-04,3.770500E-04,1.175800E-03,3.826900E-03,1.283000E-02,&
     & 1.259299E-01,1.582894E+00,2.376227E+01,5.690402E+02,2.470800E-05,&
     & 5.093500E-05,1.122100E-04,1.967100E-04,4.763700E-04,1.503100E-03,&
     & 4.848400E-03,1.601500E-02,1.585160E-01,1.995343E+00,3.032743E+01,&
     & 7.268852E+02,2.943800E-05,6.397900E-05,1.313900E-04,2.504600E-04,&
     & 5.954600E-04,1.887100E-03,5.972400E-03,1.963200E-02,1.954428E-01,&
     & 2.457948E+00,3.797224E+01,9.083003E+02,3.488400E-05,8.004200E-05,&
     & 1.550100E-04,3.110900E-04,7.341000E-04,2.330600E-03,7.193000E-03,&
     & 2.370400E-02,2.365639E-01,2.969611E+00,4.669937E+01,1.121556E+03,&
     & 1.340100E-05,2.963300E-05,5.943800E-05,1.101200E-04,2.551600E-04,&
     & 7.914100E-04,2.569400E-03,8.812300E-03,8.633863E-02,1.098149E+00,&
     & 1.719391E+01,4.835690E+02,1.723100E-05,3.556200E-05,7.711000E-05,&
     & 1.362600E-04,3.274000E-04,1.026900E-03,3.341400E-03,1.117800E-02,&
     & 1.107163E-01,1.411395E+00,2.245179E+01,6.257466E+02,2.130000E-05,&
     & 4.385300E-05,9.648400E-05,1.696900E-04,4.127100E-04,1.307400E-03,&
     & 4.203500E-03,1.389000E-02,1.388218E-01,1.769418E+00,2.863362E+01,&
     & 7.947998E+02,2.504100E-05,5.534800E-05,1.116300E-04,2.169700E-04,&
     & 5.142300E-04,1.634800E-03,5.144500E-03,1.699200E-02,1.705266E-01,&
     & 2.171404E+00,3.580367E+01,9.911327E+02,2.984300E-05,6.892000E-05,&
     & 1.319800E-04,2.676400E-04,6.318300E-04,2.009200E-03,6.171000E-03,&
     & 2.049200E-02,2.059277E-01,2.615627E+00,4.395134E+01,1.214128E+03/
      data   absb(:, 76:100) /                                          &
     & 1.167100E-05,2.543200E-05,5.186500E-05,9.526800E-05,2.221600E-04,&
     & 6.937100E-04,2.255700E-03,7.697400E-03,7.621794E-02,9.830786E-01,&
     & 1.623335E+01,5.314969E+02,1.482700E-05,3.061400E-05,6.706200E-05,&
     & 1.177500E-04,2.838900E-04,8.959200E-04,2.911700E-03,9.712700E-03,&
     & 9.729380E-02,1.256633E+00,2.117237E+01,6.842053E+02,1.838300E-05,&
     & 3.766500E-05,8.162200E-05,1.481100E-04,3.574800E-04,1.135500E-03,&
     & 3.636200E-03,1.204000E-02,1.214737E-01,1.568155E+00,2.701198E+01,&
     & 8.643340E+02,2.130700E-05,4.787100E-05,9.518900E-05,1.873900E-04,&
     & 4.436700E-04,1.413700E-03,4.428400E-03,1.471600E-02,1.487779E-01,&
     & 1.916695E+00,3.372030E+01,1.072441E+03,2.554900E-05,5.932800E-05,&
     & 1.125000E-04,2.300200E-04,5.434400E-04,1.732700E-03,5.285900E-03,&
     & 1.769600E-02,1.793669E-01,2.302558E+00,4.137375E+01,1.307428E+03,&
     & 1.018300E-05,2.184800E-05,4.522900E-05,8.199000E-05,1.942500E-04,&
     & 6.079500E-04,1.979100E-03,6.720600E-03,6.737592E-02,8.804866E-01,&
     & 1.533805E+01,5.821898E+02,1.279800E-05,2.643200E-05,5.824800E-05,&
     & 1.018300E-04,2.464200E-04,7.816600E-04,2.533700E-03,8.438200E-03,&
     & 8.559402E-02,1.119413E+00,1.999201E+01,7.435991E+02,1.553500E-05,&
     & 3.284400E-05,6.937100E-05,1.288700E-04,3.096600E-04,9.857200E-04,&
     & 3.143100E-03,1.045800E-02,1.064290E-01,1.391553E+00,2.549421E+01,&
     & 9.368858E+02,1.819700E-05,4.138300E-05,8.130500E-05,1.615500E-04,&
     & 3.828500E-04,1.223300E-03,3.808300E-03,1.274000E-02,1.300439E-01,&
     & 1.695356E+00,3.182690E+01,1.156571E+03,2.183800E-05,5.104700E-05,&
     & 9.598700E-05,1.977900E-04,4.674300E-04,1.493800E-03,4.522700E-03,&
     & 1.528200E-02,1.564113E-01,2.031990E+00,3.905742E+01,1.402829E+03,&
     & 8.884400E-06,1.868000E-05,3.954800E-05,7.081200E-05,1.691600E-04,&
     & 5.323000E-04,1.734800E-03,5.855200E-03,5.951015E-02,7.881512E-01,&
     & 1.450670E+01,6.347640E+02,1.104300E-05,2.278200E-05,5.023600E-05,&
     & 8.819700E-05,2.140500E-04,6.810600E-04,2.200400E-03,7.352400E-03,&
     & 7.525976E-02,9.974532E-01,1.890256E+01,8.085544E+02,1.317200E-05,&
     & 2.857800E-05,5.892700E-05,1.120900E-04,2.678200E-04,8.552200E-04,&
     & 2.712800E-03,9.075900E-03,9.331670E-02,1.235099E+00,2.409039E+01,&
     & 1.011018E+03,1.559300E-05,3.576600E-05,6.936100E-05,1.393200E-04,&
     & 3.300800E-04,1.057600E-03,3.269500E-03,1.102200E-02,1.137076E-01,&
     & 1.501588E+00,3.013174E+01,1.241435E+03,1.867800E-05,4.377200E-05,&
     & 8.198500E-05,1.699000E-04,4.017600E-04,1.285900E-03,3.867100E-03,&
     & 1.317500E-02,1.364237E-01,1.796654E+00,3.698551E+01,1.498730E+03,&
     & 7.731300E-06,1.597100E-05,3.467200E-05,6.129700E-05,1.472200E-04,&
     & 4.659200E-04,1.516800E-03,5.114500E-03,5.258411E-02,7.058484E-01,&
     & 1.376998E+01,6.897694E+02,9.551800E-06,1.969000E-05,4.335700E-05,&
     & 7.624200E-05,1.859600E-04,5.930300E-04,1.909000E-03,6.399600E-03,&
     & 6.626295E-02,8.897034E-01,1.793300E+01,8.741238E+02,1.123700E-05,&
     & 2.482500E-05,5.011900E-05,9.737100E-05,2.316200E-04,7.422100E-04,&
     & 2.338900E-03,7.875800E-03,8.190917E-02,1.098953E+00,2.287884E+01,&
     & 1.087089E+03,1.338200E-05,3.090700E-05,5.923000E-05,1.200400E-04,&
     & 2.845500E-04,9.134600E-04,2.804200E-03,9.528300E-03,9.952056E-02,&
     & 1.333518E+00,2.866042E+01,1.328167E+03,1.599900E-05,3.756400E-05,&
     & 7.008700E-05,1.457800E-04,3.453500E-04,1.106100E-03,3.306300E-03,&
     & 1.135100E-02,1.190953E-01,1.594102E+00,3.526052E+01,1.595830E+03,&
     & 6.679400E-06,1.380400E-05,3.029100E-05,5.306800E-05,1.282200E-04,&
     & 4.075100E-04,1.324500E-03,4.468600E-03,4.649969E-02,6.332059E-01,&
     & 1.311180E+01,7.471530E+02,8.278100E-06,1.697700E-05,3.676100E-05,&
     & 6.674300E-05,1.614600E-04,5.164300E-04,1.654600E-03,5.575300E-03,&
     & 5.836614E-02,7.954880E-01,1.709929E+01,9.418257E+02,9.592400E-06,&
     & 2.156200E-05,4.285900E-05,8.435800E-05,2.002100E-04,6.436600E-04,&
     & 2.014800E-03,6.832600E-03,7.190849E-02,9.800614E-01,2.187291E+01,&
     & 1.165153E+03,1.149600E-05,2.671200E-05,5.062100E-05,1.034100E-04,&
     & 2.452800E-04,7.884800E-04,2.406700E-03,8.233100E-03,8.716679E-02,&
     & 1.186748E+00,2.744441E+01,1.409639E+03,1.371700E-05,3.227500E-05,&
     & 5.982600E-05,1.251400E-04,2.967700E-04,9.509500E-04,2.825600E-03,&
     & 9.779800E-03,1.040882E-01,1.417963E+00,3.388099E+01,1.693575E+03/
      data   absb(:,101:125) /                                          &
     & 5.781500E-06,1.194500E-05,2.634300E-05,4.602100E-05,1.115800E-04,&
     & 3.561000E-04,1.154700E-03,3.907500E-03,4.110830E-02,5.687716E-01,&
     & 1.255120E+01,8.065112E+02,7.004200E-06,1.485600E-05,3.129100E-05,&
     & 5.821000E-05,1.401100E-04,4.493400E-04,1.432200E-03,4.854400E-03,&
     & 5.141696E-02,7.124767E-01,1.641404E+01,1.011090E+03,8.209800E-06,&
     & 1.869600E-05,3.668500E-05,7.282300E-05,1.731300E-04,5.575300E-04,&
     & 1.735500E-03,5.924000E-03,6.317150E-02,8.755015E-01,2.104443E+01,&
     & 1.244479E+03,9.848900E-06,2.303700E-05,4.325100E-05,8.909500E-05,&
     & 2.113300E-04,6.801500E-04,2.063900E-03,7.115400E-03,7.637257E-02,&
     & 1.059141E+00,2.649909E+01,1.505322E+03,1.176600E-05,2.765900E-05,&
     & 5.113600E-05,1.073200E-04,2.549600E-04,8.166800E-04,2.412700E-03,&
     & 8.421600E-03,9.105290E-02,1.266874E+00,3.284007E+01,1.791565E+03,&
     & 4.964100E-06,1.025200E-05,2.261900E-05,3.961100E-05,9.635600E-05,&
     & 3.084900E-04,9.973200E-04,3.388500E-03,3.604304E-02,5.073863E-01,&
     & 1.197763E+01,8.605342E+02,5.923500E-06,1.285100E-05,2.647900E-05,&
     & 5.032500E-05,1.205500E-04,3.877300E-04,1.229900E-03,4.194300E-03,&
     & 4.496504E-02,6.343248E-01,1.573548E+01,1.073684E+03,7.009000E-06,&
     & 1.607500E-05,3.116000E-05,6.248400E-05,1.485400E-04,4.790900E-04,&
     & 1.485100E-03,5.101700E-03,5.513957E-02,7.787021E-01,2.024310E+01,&
     & 1.315772E+03,8.389500E-06,1.967000E-05,3.681700E-05,7.613100E-05,&
     & 1.807900E-04,5.824200E-04,1.758500E-03,6.109600E-03,6.654969E-02,&
     & 9.428567E-01,2.560193E+01,1.584887E+03,1.003700E-05,2.356100E-05,&
     & 4.345400E-05,9.141800E-05,2.175800E-04,6.969700E-04,2.048600E-03,&
     & 7.210200E-03,7.924418E-02,1.129122E+00,3.187234E+01,1.878681E+03,&
     & 4.178000E-06,8.628800E-06,1.904400E-05,3.331400E-05,8.134300E-05,&
     & 2.610000E-04,8.424000E-04,2.875500E-03,3.091620E-02,4.433302E-01,&
     & 1.121677E+01,8.954015E+02,4.952000E-06,1.084700E-05,2.209400E-05,&
     & 4.249300E-05,1.015100E-04,3.272900E-04,1.036500E-03,3.551500E-03,&
     & 3.856058E-02,5.543502E-01,1.482130E+01,1.114374E+03,5.879700E-06,&
     & 1.353200E-05,2.606900E-05,5.251900E-05,1.249000E-04,4.034400E-04,&
     & 1.248200E-03,4.314200E-03,4.725509E-02,6.816553E-01,1.918544E+01,&
     & 1.361938E+03,7.028800E-06,1.650200E-05,3.081400E-05,6.385100E-05,&
     & 1.517800E-04,4.896100E-04,1.474500E-03,5.154000E-03,5.704114E-02,&
     & 8.274832E-01,2.441352E+01,1.636154E+03,8.412300E-06,1.973300E-05,&
     & 3.633200E-05,7.654300E-05,1.823900E-04,5.844900E-04,1.714900E-03,&
     & 6.086700E-03,6.791454E-02,9.939002E-01,3.055585E+01,1.935028E+03,&
     & 3.437000E-06,7.097000E-06,1.566000E-05,2.739700E-05,6.696500E-05,&
     & 2.152500E-04,6.945900E-04,2.381900E-03,2.589677E-02,3.780024E-01,&
     & 1.025632E+01,9.071883E+02,4.069000E-06,8.924600E-06,1.815000E-05,&
     & 3.495600E-05,8.352000E-05,2.697200E-04,8.547900E-04,2.942900E-03,&
     & 3.232544E-02,4.743080E-01,1.366081E+01,1.128366E+03,4.833500E-06,&
     & 1.113000E-05,2.142000E-05,4.317000E-05,1.027500E-04,3.323600E-04,&
     & 1.029000E-03,3.574400E-03,3.967546E-02,5.855423E-01,1.783259E+01,&
     & 1.377978E+03,5.776600E-06,1.356400E-05,2.531800E-05,5.246600E-05,&
     & 1.248200E-04,4.032000E-04,1.215100E-03,4.274300E-03,4.797381E-02,&
     & 7.137071E-01,2.287715E+01,1.654422E+03,6.914000E-06,1.621700E-05,&
     & 2.984500E-05,6.287900E-05,1.499300E-04,4.810600E-04,1.413100E-03,&
     & 5.050300E-03,5.718591E-02,8.609322E-01,2.882038E+01,1.955507E+03,&
     & 2.736600E-06,5.654600E-06,1.248100E-05,2.184200E-05,5.320600E-05,&
     & 1.712700E-04,5.541800E-04,1.908000E-03,2.098131E-02,3.111038E-01,&
     & 9.010344E+00,8.866869E+02,3.261700E-06,7.091200E-06,1.456700E-05,&
     & 2.776900E-05,6.654500E-05,2.150500E-04,6.843100E-04,2.365100E-03,&
     & 2.626627E-02,3.928934E-01,1.214704E+01,1.105232E+03,3.861700E-06,&
     & 8.866700E-06,1.716000E-05,3.442400E-05,8.199000E-05,2.656200E-04,&
     & 8.260500E-04,2.879400E-03,3.234222E-02,4.884466E-01,1.604277E+01,&
     & 1.352461E+03,4.622400E-06,1.084200E-05,2.027300E-05,4.191200E-05,&
     & 9.976400E-05,3.228800E-04,9.777200E-04,3.453900E-03,3.926263E-02,&
     & 5.993257E-01,2.079324E+01,1.627044E+03,5.530800E-06,1.298000E-05,&
     & 2.392400E-05,5.031400E-05,1.200100E-04,3.860500E-04,1.139300E-03,&
     & 4.090600E-03,4.710200E-02,7.259559E-01,2.644149E+01,1.926258E+03/
      data   absb(:,126:150) /                                          &
     & 2.176300E-06,4.496400E-06,9.922900E-06,1.735200E-05,4.220800E-05,&
     & 1.359200E-04,4.410300E-04,1.525200E-03,1.696072E-02,2.556857E-01,&
     & 7.926197E+00,8.635819E+02,2.615500E-06,5.618000E-06,1.170700E-05,&
     & 2.197100E-05,5.290200E-05,1.710700E-04,5.466600E-04,1.896100E-03,&
     & 2.131937E-02,3.249265E-01,1.082501E+01,1.079056E+03,3.081100E-06,&
     & 7.048400E-06,1.372800E-05,2.738900E-05,6.529900E-05,2.118400E-04,&
     & 6.616400E-04,2.315400E-03,2.633031E-02,4.069821E-01,1.446455E+01,&
     & 1.323625E+03,3.693900E-06,8.648100E-06,1.620800E-05,3.342900E-05,&
     & 7.957700E-05,2.580300E-04,7.853100E-04,2.787500E-03,3.207296E-02,&
     & 5.026747E-01,1.894617E+01,1.595550E+03,4.415200E-06,1.037700E-05,&
     & 1.914700E-05,4.019500E-05,9.589500E-05,3.091700E-04,9.171700E-04,&
     & 3.307600E-03,3.880654E-02,6.112013E-01,2.432668E+01,1.892570E+03,&
     & 1.731300E-06,3.579400E-06,7.898000E-06,1.377000E-05,3.347200E-05,&
     & 1.078500E-04,3.507800E-04,1.218600E-03,1.369585E-02,2.103003E-01,&
     & 7.001648E+00,8.400762E+02,2.101700E-06,4.446000E-06,9.382400E-06,&
     & 1.741400E-05,4.204100E-05,1.360700E-04,4.364700E-04,1.520400E-03,&
     & 1.729851E-02,2.691761E-01,9.692351E+00,1.052390E+03,2.460600E-06,&
     & 5.600600E-06,1.099400E-05,2.177800E-05,5.198400E-05,1.688500E-04,&
     & 5.298600E-04,1.862500E-03,2.144687E-02,3.393698E-01,1.310378E+01,&
     & 1.293842E+03,2.951900E-06,6.905500E-06,1.295600E-05,2.664800E-05,&
     & 6.346200E-05,2.061400E-04,6.305600E-04,2.248300E-03,2.631828E-02,&
     & 4.211618E-01,1.734536E+01,1.562956E+03,3.526600E-06,8.293500E-06,&
     & 1.531900E-05,3.210000E-05,7.659300E-05,2.475500E-04,7.380900E-04,&
     & 2.674600E-03,3.198625E-02,5.152432E-01,2.248498E+01,1.850474E+03,&
     & 1.346900E-06,2.784900E-06,6.121400E-06,1.069600E-05,2.592500E-05,&
     & 8.344500E-05,2.722300E-04,9.504700E-04,1.080731E-02,1.682165E-01,&
     & 5.988328E+00,7.967462E+02,1.669300E-06,3.424400E-06,7.414800E-06,&
     & 1.345000E-05,3.266000E-05,1.057300E-04,3.409900E-04,1.191900E-03,&
     & 1.373786E-02,2.173494E-01,8.432590E+00,1.002376E+03,1.934400E-06,&
     & 4.349700E-06,8.641100E-06,1.696800E-05,4.050900E-05,1.317400E-04,&
     & 4.162300E-04,1.467900E-03,1.714222E-02,2.763455E-01,1.155654E+01,&
     & 1.237706E+03,2.318200E-06,5.388800E-06,1.020300E-05,2.079500E-05,&
     & 4.962700E-05,1.614500E-04,4.976300E-04,1.780000E-03,2.119015E-02,&
     & 3.451891E-01,1.550089E+01,1.501123E+03,2.766700E-06,6.510300E-06,&
     & 1.205200E-05,2.516400E-05,6.003700E-05,1.946500E-04,5.847900E-04,&
     & 2.125500E-03,2.583898E-02,4.259348E-01,2.031888E+01,1.790551E+03,&
     & 1.046100E-06,2.163400E-06,4.707900E-06,8.292600E-06,2.000300E-05,&
     & 6.427400E-05,2.101600E-04,7.379700E-04,8.484136E-03,1.339141E-01,&
     & 5.096008E+00,7.516961E+02,1.292700E-06,2.666100E-06,5.879200E-06,&
     & 1.030100E-05,2.526700E-05,8.183600E-05,2.652900E-04,9.305500E-04,&
     & 1.086617E-02,1.746629E-01,7.310858E+00,9.503164E+02,1.520100E-06,&
     & 3.362300E-06,6.781400E-06,1.315000E-05,3.146900E-05,1.023800E-04,&
     & 3.257800E-04,1.152300E-03,1.367343E-02,2.238772E-01,1.017124E+01,&
     & 1.178855E+03,1.810700E-06,4.185600E-06,8.007500E-06,1.619600E-05,&
     & 3.867200E-05,1.260000E-04,3.914600E-04,1.404200E-03,1.702106E-02,&
     & 2.819854E-01,1.382605E+01,1.435734E+03,2.165300E-06,5.084900E-06,&
     & 9.464900E-06,1.966300E-05,4.692300E-05,1.525600E-04,4.619000E-04,&
     & 1.683700E-03,2.082206E-02,3.509792E-01,1.832796E+01,1.719530E+03,&
     & 8.065800E-07,1.695100E-06,3.604800E-06,6.432100E-06,1.541100E-05,&
     & 4.942500E-05,1.618600E-04,5.719500E-04,6.646346E-03,1.064555E-01,&
     & 4.339023E+00,7.078673E+02,1.002200E-06,2.068800E-06,4.569800E-06,&
     & 7.993000E-06,1.951900E-05,6.324200E-05,2.059900E-04,7.253100E-04,&
     & 8.578858E-03,1.402310E-01,6.338516E+00,8.992170E+02,1.194300E-06,&
     & 2.595800E-06,5.344900E-06,1.015300E-05,2.442000E-05,7.946100E-05,&
     & 2.545400E-04,9.034100E-04,1.089794E-02,1.811234E-01,8.961333E+00,&
     & 1.120610E+03,1.414300E-06,3.247900E-06,6.285400E-06,1.259900E-05,&
     & 3.010100E-05,9.819700E-05,3.074900E-04,1.106200E-03,1.365748E-02,&
     & 2.300392E-01,1.234072E+01,1.371044E+03,1.694500E-06,3.973300E-06,&
     & 7.426300E-06,1.534500E-05,3.663700E-05,1.194000E-04,3.644100E-04,&
     & 1.332000E-03,1.684139E-02,2.885673E-01,1.655227E+01,1.648537E+03/
      data   absb(:,151:175) /                                          &
     & 6.102200E-07,1.315600E-06,2.721600E-06,4.929400E-06,1.168700E-05,&
     & 3.739300E-05,1.224400E-04,4.363200E-04,5.115562E-03,8.310293E-02,&
     & 3.608072E+00,6.559334E+02,7.684700E-07,1.588900E-06,3.507600E-06,&
     & 6.114700E-06,1.486700E-05,4.814200E-05,1.575500E-04,5.571600E-04,&
     & 6.664149E-03,1.106708E-01,5.379527E+00,8.382401E+02,9.363700E-07,&
     & 1.970300E-06,4.178300E-06,7.722200E-06,1.869800E-05,6.081800E-05,&
     & 1.963100E-04,6.986600E-04,8.561860E-03,1.442871E-01,7.748814E+00,&
     & 1.050802E+03,1.094500E-06,2.487200E-06,4.893200E-06,9.671100E-06,&
     & 2.314000E-05,7.557500E-05,2.387100E-04,8.607400E-04,1.081005E-02,&
     & 1.849725E-01,1.082106E+01,1.292610E+03,1.313700E-06,3.072700E-06,&
     & 5.766100E-06,1.184000E-05,2.826900E-05,9.233700E-05,2.845800E-04,&
     & 1.042100E-03,1.344441E-02,2.341101E-01,1.472212E+01,1.562341E+03,&
     & 4.584000E-07,1.008300E-06,2.046800E-06,3.779600E-06,8.767900E-06,&
     & 2.803100E-05,9.165600E-05,3.296700E-04,3.897828E-03,6.415715E-02,&
     & 2.960903E+00,6.021974E+02,5.861300E-07,1.210800E-06,2.650400E-06,&
     & 4.651800E-06,1.126100E-05,3.636400E-05,1.194000E-04,4.243900E-04,&
     & 5.134013E-03,8.649916E-02,4.505906E+00,7.749368E+02,7.255800E-07,&
     & 1.491800E-06,3.264800E-06,5.813600E-06,1.420900E-05,4.622300E-05,&
     & 1.502100E-04,5.360700E-04,6.660909E-03,1.139612E-01,6.626183E+00,&
     & 9.775247E+02,8.473100E-07,1.889800E-06,3.782000E-06,7.380800E-06,&
     & 1.767300E-05,5.775400E-05,1.840800E-04,6.649400E-04,8.487142E-03,&
     & 1.475848E-01,9.403271E+00,1.210020E+03,1.013000E-06,2.348400E-06,&
     & 4.470100E-06,9.067700E-06,2.169300E-05,7.096000E-05,2.208400E-04,&
     & 8.099500E-04,1.067335E-02,1.883960E-01,1.297552E+01,1.470799E+03,&
     & 3.442400E-07,7.759700E-07,1.536100E-06,2.864900E-06,6.593100E-06,&
     & 2.095200E-05,6.834300E-05,2.483000E-04,2.957356E-03,4.935408E-02,&
     & 2.422132E+00,5.515556E+02,4.450400E-07,9.317800E-07,1.989300E-06,&
     & 3.544600E-06,8.508700E-06,2.739600E-05,9.013000E-05,3.223000E-04,&
     & 3.935704E-03,6.738364E-02,3.761720E+00,7.144763E+02,5.524200E-07,&
     & 1.139600E-06,2.518400E-06,4.404500E-06,1.077600E-05,3.505000E-05,&
     & 1.146000E-04,4.102500E-04,5.166939E-03,8.976608E-02,5.646014E+00,&
     & 9.072560E+02,6.569100E-07,1.432300E-06,2.939300E-06,5.600300E-06,&
     & 1.347800E-05,4.404800E-05,1.415500E-04,5.122900E-04,6.649440E-03,&
     & 1.174756E-01,8.158482E+00,1.129945E+03,7.792500E-07,1.791900E-06,&
     & 3.460200E-06,6.941900E-06,1.661400E-05,5.441300E-05,1.710200E-04,&
     & 6.279400E-04,8.432459E-03,1.514939E-01,1.141379E+01,1.381751E+03,&
     & 2.569700E-07,5.964000E-07,1.150300E-06,2.163600E-06,4.908000E-06,&
     & 1.550400E-05,5.043800E-05,1.851700E-04,2.219700E-03,3.753465E-02,&
     & 1.951992E+00,5.007899E+02,3.326100E-07,7.174300E-07,1.483200E-06,&
     & 2.689700E-06,6.375500E-06,2.046900E-05,6.733600E-05,2.427000E-04,&
     & 2.987773E-03,5.195442E-02,3.098503E+00,6.534503E+02,4.192100E-07,&
     & 8.666400E-07,1.913700E-06,3.334800E-06,8.116000E-06,2.638000E-05,&
     & 8.669200E-05,3.114300E-04,3.967874E-03,7.007856E-02,4.749458E+00,&
     & 8.355826E+02,5.121800E-07,1.073900E-06,2.282300E-06,4.210900E-06,&
     & 1.021300E-05,3.335300E-05,1.081300E-04,3.918900E-04,5.165412E-03,&
     & 9.273540E-02,7.000908E+00,1.047796E+03,5.977300E-07,1.358500E-06,&
     & 2.671900E-06,5.278500E-06,1.264700E-05,4.146500E-05,1.316000E-04,&
     & 4.836300E-04,6.617044E-03,1.208792E-01,9.944111E+00,1.289605E+03,&
     & 1.898700E-07,4.587500E-07,8.377700E-07,1.642300E-06,3.591900E-06,&
     & 1.128500E-05,3.655300E-05,1.358500E-04,1.637327E-03,2.796480E-02,&
     & 1.531407E+00,4.479353E+02,2.456700E-07,5.430300E-07,1.097100E-06,&
     & 2.032500E-06,4.703800E-06,1.507100E-05,4.946200E-05,1.800800E-04,&
     & 2.232802E-03,3.930451E-02,2.489103E+00,5.892823E+02,3.154400E-07,&
     & 6.520200E-07,1.421700E-06,2.501900E-06,6.053400E-06,1.959600E-05,&
     & 6.464800E-05,2.331700E-04,3.001470E-03,5.378812E-02,3.902480E+00,&
     & 7.596612E+02,3.905300E-07,8.041500E-07,1.773900E-06,3.109200E-06,&
     & 7.648500E-06,2.496100E-05,8.156300E-05,2.960300E-04,3.955710E-03,&
     & 7.209910E-02,5.882025E+00,9.599128E+02,4.578700E-07,1.016500E-06,&
     & 2.044300E-06,3.969700E-06,9.528100E-06,3.124300E-05,1.001800E-04,&
     & 3.682600E-04,5.120684E-03,9.511582E-02,8.511992E+00,1.190092E+03/
      data   absb(:,176:200) /                                          &
     & 1.405800E-07,3.563400E-07,6.140700E-07,1.243800E-06,2.606200E-06,&
     & 8.171300E-06,2.634300E-05,9.913500E-05,1.198696E-03,2.070687E-02,&
     & 1.193147E+00,3.993415E+02,1.813800E-07,4.138500E-07,8.097200E-07,&
     & 1.517600E-06,3.473900E-06,1.104800E-05,3.614200E-05,1.330100E-04,&
     & 1.657580E-03,2.957369E-02,1.984506E+00,5.295494E+02,2.348300E-07,&
     & 4.996800E-07,1.045300E-06,1.880500E-06,4.498700E-06,1.450700E-05,&
     & 4.793300E-05,1.738800E-04,2.257342E-03,4.108124E-02,3.184129E+00,&
     & 6.882080E+02,2.933000E-07,6.050500E-07,1.336300E-06,2.338600E-06,&
     & 5.708500E-06,1.862600E-05,6.126400E-05,2.227800E-04,3.011524E-03,&
     & 5.582426E-02,4.908920E+00,8.765688E+02,3.519700E-07,7.577900E-07,&
     & 1.577600E-06,2.959800E-06,7.161800E-06,2.347800E-05,7.598600E-05,&
     & 2.794700E-04,3.944536E-03,7.459970E-02,7.247744E+00,1.094918E+03,&
     & 1.046200E-07,2.796600E-07,4.389000E-07,9.663700E-07,1.862100E-06,&
     & 5.889200E-06,1.886600E-05,7.190400E-05,8.710741E-04,1.523415E-02,&
     & 9.229128E-01,3.546856E+02,1.338500E-07,3.160700E-07,5.967600E-07,&
     & 1.142100E-06,2.549600E-06,8.059400E-06,2.626300E-05,9.773300E-05,&
     & 1.221446E-03,2.212193E-02,1.569784E+00,4.742739E+02,1.734700E-07,&
     & 3.784900E-07,7.744900E-07,1.418400E-06,3.324600E-06,1.070000E-05,&
     & 3.531100E-05,1.291800E-04,1.685142E-03,3.121603E-02,2.578792E+00,&
     & 6.214396E+02,2.205300E-07,4.553900E-07,1.001800E-06,1.752000E-06,&
     & 4.257800E-06,1.385400E-05,4.577800E-05,1.669900E-04,2.277440E-03,&
     & 4.304700E-02,4.065967E+00,7.977869E+02,2.739600E-07,5.607300E-07,&
     & 1.215100E-06,2.202700E-06,5.368400E-06,1.759100E-05,5.742500E-05,&
     & 2.112900E-04,3.017208E-03,5.827061E-02,6.133633E+00,1.004252E+03,&
     & 7.920500E-08,2.233500E-07,3.023200E-07,7.668100E-07,1.331100E-06,&
     & 4.252700E-06,1.355700E-05,5.230700E-05,6.356496E-04,1.123422E-02,&
     & 7.180650E-01,3.164464E+02,9.961100E-08,2.461900E-07,4.363200E-07,&
     & 8.701500E-07,1.874800E-06,5.898900E-06,1.913900E-05,7.201900E-05,&
     & 9.043685E-04,1.658883E-02,1.249317E+00,4.264181E+02,1.289000E-07,&
     & 2.883200E-07,5.750100E-07,1.071800E-06,2.471700E-06,7.916000E-06,&
     & 2.606400E-05,9.621600E-05,1.263903E-03,2.377130E-02,2.099431E+00,&
     & 5.629826E+02,1.669500E-07,3.456300E-07,7.460000E-07,1.323300E-06,&
     & 3.189300E-06,1.034100E-05,3.426800E-05,1.255400E-04,1.730706E-03,&
     & 3.325778E-02,3.381162E+00,7.283070E+02,2.067000E-07,4.252000E-07,&
     & 9.396400E-07,1.643600E-06,4.038600E-06,1.322300E-05,4.347300E-05,&
     & 1.602000E-04,2.320621E-03,4.563479E-02,5.210097E+00,9.235004E+02,&
     & 6.062800E-08,1.681000E-07,2.182000E-07,5.763800E-07,9.837400E-07,&
     & 3.067200E-06,9.729700E-06,3.796900E-05,4.630154E-04,8.262556E-03,&
     & 5.581993E-01,2.824977E+02,7.439600E-08,1.918400E-07,3.255800E-07,&
     & 6.667400E-07,1.366500E-06,4.314600E-06,1.392600E-05,5.299700E-05,&
     & 6.690555E-04,1.242132E-02,9.941828E-01,3.835061E+02,9.604900E-08,&
     & 2.212600E-07,4.293300E-07,8.076500E-07,1.839300E-06,5.853700E-06,&
     & 1.921600E-05,7.162000E-05,9.475504E-04,1.807590E-02,1.707032E+00,&
     & 5.101281E+02,1.245400E-07,2.668100E-07,5.541100E-07,1.001900E-06,&
     & 2.388700E-06,7.717900E-06,2.559700E-05,9.431500E-05,1.314332E-03,&
     & 2.566413E-02,2.809163E+00,6.648231E+02,1.563800E-07,3.227200E-07,&
     & 7.123600E-07,1.244800E-06,3.038800E-06,9.942000E-06,3.286700E-05,&
     & 1.214300E-04,1.784590E-03,3.570364E-02,4.417731E+00,8.491036E+02,&
     & 4.500200E-08,1.247700E-07,1.614200E-07,4.357900E-07,7.229300E-07,&
     & 2.191900E-06,6.956300E-06,2.741300E-05,3.349854E-04,6.039039E-03,&
     & 4.310480E-01,2.515201E+02,5.594300E-08,1.518300E-07,2.309600E-07,&
     & 5.264100E-07,9.852500E-07,3.141500E-06,1.008500E-05,3.882500E-05,&
     & 4.918654E-04,9.245965E-03,7.862801E-01,3.440443E+02,7.153200E-08,&
     & 1.705100E-07,3.181500E-07,6.148000E-07,1.361600E-06,4.313000E-06,&
     & 1.410300E-05,5.309300E-05,7.059345E-04,1.368480E-02,1.379136E+00,&
     & 4.610312E+02,9.284400E-08,2.032500E-07,4.142800E-07,7.636000E-07,&
     & 1.779500E-06,5.743500E-06,1.902200E-05,7.066500E-05,9.932344E-04,&
     & 1.972035E-02,2.320302E+00,6.052929E+02,1.185200E-07,2.446500E-07,&
     & 5.367000E-07,9.410100E-07,2.285800E-06,7.457600E-06,2.475400E-05,&
     & 9.172000E-05,1.365712E-03,2.782332E-02,3.722270E+00,7.788007E+02/
      data   absb(:,201:225) /                                          &
     & 3.255500E-08,9.169700E-08,1.223900E-07,3.263000E-07,5.353900E-07,&
     & 1.548900E-06,4.950200E-06,1.965400E-05,2.403566E-04,4.382718E-03,&
     & 3.302407E-01,2.232196E+02,4.249000E-08,1.216300E-07,1.592700E-07,&
     & 4.117500E-07,7.132200E-07,2.274000E-06,7.264400E-06,2.828900E-05,&
     & 3.590972E-04,6.835260E-03,6.169670E-01,3.076795E+02,5.338300E-08,&
     & 1.329300E-07,2.341500E-07,4.686600E-07,1.002500E-06,3.163800E-06,&
     & 1.030200E-05,3.917900E-05,5.225542E-04,1.029914E-02,1.106434E+00,&
     & 4.153973E+02,6.914900E-08,1.554600E-07,3.084800E-07,5.767000E-07,&
     & 1.327500E-06,4.257500E-06,1.407000E-05,5.270800E-05,7.452110E-04,&
     & 1.508844E-02,1.902379E+00,5.494844E+02,8.972700E-08,1.865400E-07,&
     & 4.001000E-07,7.127300E-07,1.715700E-06,5.576700E-06,1.855800E-05,&
     & 6.902400E-05,1.038173E-03,2.159963E-02,3.116360E+00,7.121583E+02,&
     & 2.369600E-08,6.806600E-08,9.428700E-08,2.450800E-07,3.953200E-07,&
     & 1.105500E-06,3.549900E-06,1.417600E-05,1.744438E-04,3.196092E-03,&
     & 2.551668E-01,1.995710E+02,3.265300E-08,9.072400E-08,1.177200E-07,&
     & 3.122600E-07,5.307400E-07,1.656900E-06,5.269600E-06,2.073400E-05,&
     & 2.649392E-04,5.078957E-03,4.898290E-01,2.770889E+02,4.014000E-08,&
     & 1.042600E-07,1.760900E-07,3.623400E-07,7.358500E-07,2.335300E-06,&
     & 7.568500E-06,2.907700E-05,3.911316E-04,7.785196E-03,8.979262E-01,&
     & 3.767082E+02,5.191400E-08,1.198800E-07,2.322600E-07,4.378500E-07,&
     & 9.948500E-07,3.173800E-06,1.046200E-05,3.953400E-05,5.659950E-04,&
     & 1.159206E-02,1.574672E+00,5.016559E+02,6.744100E-08,1.445900E-07,&
     & 2.997200E-07,5.433400E-07,1.294100E-06,4.192900E-06,1.396500E-05,&
     & 5.223400E-05,7.990147E-04,1.684334E-02,2.631960E+00,6.546088E+02,&
     & 1.724700E-08,5.085300E-08,7.355900E-08,1.886700E-07,2.957400E-07,&
     & 7.795900E-07,2.551700E-06,1.022300E-05,1.268190E-04,2.330049E-03,&
     & 1.969864E-01,1.787663E+02,2.454600E-08,6.811600E-08,8.815800E-08,&
     & 2.384900E-07,3.953400E-07,1.202500E-06,3.833200E-06,1.519400E-05,&
     & 1.961036E-04,3.771786E-03,3.900442E-01,2.500808E+02,3.046900E-08,&
     & 8.294900E-08,1.262700E-07,2.881200E-07,5.389800E-07,1.724100E-06,&
     & 5.567100E-06,2.159200E-05,2.939673E-04,5.879986E-03,7.309793E-01,&
     & 3.422110E+02,3.908700E-08,9.308600E-08,1.740100E-07,3.365600E-07,&
     & 7.453400E-07,2.367700E-06,7.787000E-06,2.966400E-05,4.317946E-04,&
     & 8.898094E-03,1.306133E+00,4.587923E+02,5.084000E-08,1.110600E-07,&
     & 2.265900E-07,4.179500E-07,9.751000E-07,3.156700E-06,1.050200E-05,&
     & 3.958500E-05,6.177974E-04,1.314073E-02,2.226018E+00,6.026095E+02,&
     & 1.251500E-08,3.809700E-08,5.747400E-08,1.388800E-07,2.215800E-07,&
     & 5.539300E-07,1.825000E-06,7.330500E-06,9.171155E-05,1.686569E-03,&
     & 1.507932E-01,1.597544E+02,1.802500E-08,5.070800E-08,6.741900E-08,&
     & 1.805200E-07,2.957500E-07,8.666600E-07,2.780200E-06,1.108900E-05,&
     & 1.444621E-04,2.786476E-03,3.087303E-01,2.252002E+02,2.329600E-08,&
     & 6.660100E-08,8.906400E-08,2.277000E-07,3.955300E-07,1.267300E-06,&
     & 4.080700E-06,1.597600E-05,2.198258E-04,4.421790E-03,5.914644E-01,&
     & 3.103140E+02,2.945600E-08,7.309700E-08,1.294900E-07,2.589600E-07,&
     & 5.566200E-07,1.761900E-06,5.776000E-06,2.219600E-05,3.278716E-04,&
     & 6.797717E-03,1.077987E+00,4.187279E+02,3.830000E-08,8.562600E-08,&
     & 1.706700E-07,3.192200E-07,7.361200E-07,2.369500E-06,7.876500E-06,&
     & 2.990600E-05,4.765178E-04,1.020676E-02,1.873003E+00,5.535584E+02,&
     & 9.021100E-09,2.857500E-08,4.531700E-08,9.921100E-08,1.738700E-07,&
     & 3.836200E-07,1.302000E-06,5.223100E-06,6.588611E-05,1.220342E-03,&
     & 1.145005E-01,1.423158E+02,1.318300E-08,3.777800E-08,5.204300E-08,&
     & 1.362800E-07,2.199900E-07,6.217400E-07,2.009600E-06,8.047500E-06,&
     & 1.057056E-04,2.052530E-03,2.418182E-01,2.023769E+02,1.789100E-08,&
     & 5.054300E-08,6.542400E-08,1.730900E-07,2.959700E-07,9.300200E-07,&
     & 2.978300E-06,1.176900E-05,1.634717E-04,3.307840E-03,4.757559E-01,&
     & 2.781575E+02,2.222000E-08,5.722600E-08,9.776100E-08,2.004000E-07,&
     & 4.115200E-07,1.306800E-06,4.268800E-06,1.654800E-05,2.473568E-04,&
     & 5.173898E-03,8.856949E-01,3.813354E+02,2.885700E-08,6.619300E-08,&
     & 1.288200E-07,2.431500E-07,5.543400E-07,1.774000E-06,5.887200E-06,&
     & 2.252400E-05,3.649047E-04,7.899390E-03,1.566916E+00,5.074447E+02/
      data   absb(:,226:235) /                                          &
     & 6.493500E-09,2.127400E-08,3.498800E-08,7.231100E-08,1.381300E-07,&
     & 2.638100E-07,9.321600E-07,3.723000E-06,4.743365E-05,8.874735E-04,&
     & 8.693139E-02,1.271393E+02,9.647200E-09,2.831900E-08,4.061700E-08,&
     & 1.044000E-07,1.656900E-07,4.433000E-07,1.458000E-06,5.848900E-06,&
     & 7.749149E-05,1.529303E-03,1.897678E-01,1.824372E+02,1.370600E-08,&
     & 3.806100E-08,4.897000E-08,1.324900E-07,2.219700E-07,6.799100E-07,&
     & 2.184200E-06,8.684800E-06,1.216676E-04,2.512265E-03,3.846381E-01,&
     & 2.548871E+02,1.685800E-08,4.548500E-08,7.160100E-08,1.583900E-07,&
     & 3.038600E-07,9.706600E-07,3.163400E-06,1.236300E-05,1.869776E-04,&
     & 3.974491E-03,7.311717E-01,3.483199E+02,2.180300E-08,5.133600E-08,&
     & 9.743100E-08,1.870700E-07,4.177400E-07,1.331000E-06,4.409700E-06,&
     & 1.699900E-05,2.798372E-04,6.128387E-03,1.316511E+00,4.663946E+02,&
     & 5.041300E-09,1.678500E-08,2.813100E-08,5.644900E-08,1.115300E-07,&
     & 2.012000E-07,7.263400E-07,2.889300E-06,3.761251E-05,7.256240E-04,&
     & 7.616846E-02,1.214370E+02,7.547700E-09,2.238900E-08,3.265300E-08,&
     & 8.396900E-08,1.301400E-07,3.441500E-07,1.140500E-06,4.577800E-06,&
     & 6.195711E-05,1.274860E-03,1.697967E-01,1.748988E+02,1.080000E-08,&
     & 3.004700E-08,3.898600E-08,1.057900E-07,1.751300E-07,5.323700E-07,&
     & 1.716700E-06,6.844700E-06,9.838250E-05,2.126454E-03,3.502418E-01,&
     & 2.450637E+02,1.339200E-08,3.685000E-08,5.567800E-08,1.287000E-07,&
     & 2.383200E-07,7.650100E-07,2.495000E-06,9.795500E-06,1.528737E-04,&
     & 3.411825E-03,6.727303E-01,3.357825E+02,1.729000E-08,4.130800E-08,&
     & 7.693300E-08,1.498700E-07,3.309600E-07,1.053300E-06,3.491900E-06,&
     & 1.353400E-05,2.315021E-04,5.286700E-03,1.221836E+00,4.507178E+02/

! --- the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG02=12).

      data  selfref(:, :) /                                             &
     & 7.256950E-01,9.619960E-01,9.725840E-01,1.247900E+00,1.235740E+00,&
     & 1.209210E+00,1.381120E+00,1.303210E+00,1.289824E+00,1.419931E+00,&
     & 1.560989E+00,1.669523E+00,6.535910E-01,8.778530E-01,9.026580E-01,&
     & 1.143530E+00,1.129280E+00,1.106600E+00,1.267270E+00,1.201270E+00,&
     & 1.198051E+00,1.327587E+00,1.460123E+00,1.556237E+00,5.886500E-01,&
     & 8.010700E-01,8.377600E-01,1.047900E+00,1.032000E+00,1.012700E+00,&
     & 1.162800E+00,1.107300E+00,1.112838E+00,1.241311E+00,1.365824E+00,&
     & 1.450815E+00,5.301620E-01,7.310030E-01,7.775270E-01,9.602630E-01,&
     & 9.430960E-01,9.267660E-01,1.066940E+00,1.020680E+00,1.033717E+00,&
     & 1.160689E+00,1.277656E+00,1.352679E+00,4.774850E-01,6.670640E-01,&
     & 7.216260E-01,8.799560E-01,8.618510E-01,8.481240E-01,9.789900E-01,&
     & 9.408400E-01,9.602479E-01,1.085347E+00,1.195224E+00,1.261326E+00,&
     & 4.300420E-01,6.087180E-01,6.697430E-01,8.063640E-01,7.876050E-01,&
     & 7.761550E-01,8.982870E-01,8.672430E-01,8.920257E-01,1.014946E+00,&
     & 1.118144E+00,1.176273E+00,3.873130E-01,5.554760E-01,6.215910E-01,&
     & 7.389270E-01,7.197550E-01,7.102930E-01,8.242360E-01,7.994030E-01,&
     & 8.286737E-01,9.491525E-01,1.046077E+00,1.097071E+00,3.488300E-01,&
     & 5.068900E-01,5.769000E-01,6.771300E-01,6.577500E-01,6.500200E-01,&
     & 7.562900E-01,7.368700E-01,7.698427E-01,8.876617E-01,9.786811E-01,&
     & 1.023300E+00,3.141700E-01,4.625540E-01,5.354230E-01,6.205010E-01,&
     & 6.010870E-01,5.948610E-01,6.939450E-01,6.792290E-01,7.152073E-01,&
     & 8.301906E-01,9.156608E-01,9.545887E-01,2.829540E-01,4.220960E-01,&
     & 4.969270E-01,5.686080E-01,5.493050E-01,5.443840E-01,6.367390E-01,&
     & 6.260960E-01,6.644681E-01,7.764753E-01,8.567281E-01,8.905786E-01/

! --- the array forref contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  the first
!     index refers to reference temperature (296,260,224,260) and
!     pressure (970,475,219,3 mbar) levels.  the second index
!     runs over the g-channel (1 to NG02=12).

      data  forref(:, :) /                                              &
     & 2.854900E-03,4.828100E-03,6.257000E-03,8.273100E-03,7.905600E-03,&
     & 7.784000E-03,1.011500E-02,9.659900E-03,1.022842E-02,1.288835E-02,&
     & 1.489441E-02,1.597860E-02,3.003600E-03,5.109300E-03,5.731700E-03,&
     & 9.224600E-03,8.982900E-03,8.647700E-03,1.144800E-02,1.039100E-02,&
     & 1.047711E-02,1.259355E-02,1.506581E-02,1.664673E-02,3.077100E-03,&
     & 5.120600E-03,5.842600E-03,9.572700E-03,1.033800E-02,9.373700E-03,&
     & 1.280500E-02,1.127200E-02,1.140053E-02,1.219900E-02,1.458269E-02,&
     & 1.684562E-02,3.307200E-03,5.024000E-03,6.847400E-03,8.273600E-03,&
     & 8.615100E-03,8.676200E-03,1.147600E-02,1.024600E-02,1.080142E-02,&
     & 1.053970E-02,1.035826E-02,1.047106E-02 /

! --- planck fraction mapping level: p = 1053.630 mbar, t = 294.2 k

      data  fracrefa(:) /                     1.638800e-01,1.524100e-01,&
     & 1.429000e-01,1.286400e-01,1.161500e-01,1.004700e-01,8.001300e-02,&
     & 6.044500e-02,4.491790e-02,6.339500e-03,3.294200e-03,5.454090e-04/

! --- planck fraction mapping level: p = 3.206e-2 mb, t = 197.92 k

      data  fracrefb(:) /                     1.469700e-01,1.482600e-01,&
     & 1.427800e-01,1.332000e-01,1.196500e-01,1.029700e-01,8.417000e-02,&
     & 6.328200e-02,4.753240e-02,6.915200e-03,3.658500e-03,6.127360e-04/


!........................................!
      end module module_radlw_kgb02      !
!========================================!


!========================================!
      module module_radlw_kgb03          !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NG03
!
      implicit none
!
      private
!
      integer, public :: MSA03, MSB03, MSF03, MFR03, MAF03, MBF03, MMN03
      parameter (MSA03=585, MSB03=1175, MSF03=10, MFR03=4)
      parameter (MAF03=9, MBF03=5, MMN03=19)

      real (kind=kind_phys), public ::           forref(NG03,MFR03),    &
     &       absa(NG03,MSA03), absb(NG03,MSB03), selfref(NG03,MSF03),   &
     &       fracrefa(NG03,MAF03), fracrefb(NG03,MBF03),                &
     &       ka_mn2o(NG03,MAF03,MMN03), kb_mn2o(NG03,MBF03,MMN03)

! --- the array absa(NG03,585) = ka(NG03,9,5,13) contains absorption coefs
!     at the NG03=16 g-intervals for a range of pressure levels > ~100mb,
!     temperatures, and ratios of water vapor to co2.  the first index in
!     the array, js, runs from 1 to 9, and corresponds to different water
!     vapor to co2 ratios, as expressed through the binary species
!     parameter eta, defined as eta = gas1/(gas1+(rat)*gas2), where rat is
!     the ratio of the reference mls column amount value of gas1 to that
!     of gas2. the 2nd index in the array, jt, which runs from 1 to 5,
!     corresponds to different temperatures. more specifically, jt = 1-5
!     means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively. the
!     third index, jp, runs from 1 to 13 and refers to the reference
!     pressure level (e.g. jp = 1 is for a pressure of 1053.63 mb).  the
!     fourth index, ig, goes from 1 to NG03=16, and tells us which
!     g-interval the absorption coefficients are for.

      data   absa(:,  1: 20) /                                          &
     & 3.188600E-07,1.307300E-06,5.254600E-06,2.019700E-05,1.503300E-04,&
     & 5.871000E-04,1.384800E-03,3.569600E-03,7.943300E-03,1.387900E-02,&
     & 2.099100E-02,4.432700E-02,8.918900E-02,1.447300E-01,1.699300E-01,&
     & 1.725400E-01,1.896900E-04,4.205900E-04,7.118900E-04,1.166700E-03,&
     & 2.044600E-03,3.744700E-03,7.426500E-03,1.600700E-02,4.969600E-02,&
     & 1.098600E-01,1.451000E-01,1.990100E-01,2.754700E-01,4.519600E-01,&
     & 6.231900E-01,6.646200E-01,4.123900E-04,6.756100E-04,1.088200E-03,&
     & 1.870300E-03,3.168100E-03,5.659800E-03,1.132800E-02,2.911900E-02,&
     & 8.939900E-02,1.919200E-01,2.753000E-01,3.956700E-01,5.475500E-01,&
     & 8.969800E-01,1.230200E+00,1.311500E+00,6.466700E-04,8.660900E-04,&
     & 1.540700E-03,2.359700E-03,4.092800E-03,7.421500E-03,1.576500E-02,&
     & 4.211000E-02,1.289100E-01,2.870000E-01,4.125300E-01,5.884800E-01,&
     & 8.146600E-01,1.331600E+00,1.811700E+00,1.931800E+00,8.529200E-04,&
     & 1.352000E-03,1.669400E-03,2.844200E-03,4.964500E-03,9.230800E-03,&
     & 2.061700E-02,5.486000E-02,1.703100E-01,3.812900E-01,5.488800E-01,&
     & 7.747600E-01,1.073400E+00,1.748300E+00,2.353400E+00,2.508400E+00,&
     & 1.183600E-03,1.608500E-03,2.048400E-03,3.300400E-03,5.875200E-03,&
     & 1.130200E-02,2.576000E-02,6.807600E-02,2.132700E-01,4.752700E-01,&
     & 6.831700E-01,9.485300E-01,1.316700E+00,2.132900E+00,2.822400E+00,&
     & 3.007600E+00,1.400600E-03,2.090800E-03,2.852300E-03,3.920900E-03,&
     & 6.889100E-03,1.374500E-02,3.139400E-02,8.391700E-02,2.563500E-01,&
     & 5.706700E-01,8.104000E-01,1.093400E+00,1.526200E+00,2.449200E+00,&
     & 3.142700E+00,3.344900E+00,1.541100E-03,3.526200E-03,4.169600E-03,&
     & 5.105000E-03,9.746000E-03,1.713000E-02,3.917400E-02,1.055800E-01,&
     & 2.983400E-01,6.677900E-01,9.020400E-01,1.152700E+00,1.654500E+00,&
     & 2.536600E+00,3.068300E+00,3.252300E+00,8.329300E-04,1.784600E-03,&
     & 2.506700E-03,4.403200E-03,8.237500E-03,1.637600E-02,3.796200E-02,&
     & 1.053400E-01,3.400500E-01,7.624300E-01,1.097700E+00,1.549500E+00,&
     & 2.146700E+00,3.496700E+00,4.706700E+00,5.016900E+00,4.320800E-07,&
     & 1.819700E-06,7.709200E-06,2.987800E-05,2.038900E-04,7.109500E-04,&
     & 1.667100E-03,4.286300E-03,9.577300E-03,1.695400E-02,2.637700E-02,&
     & 5.390500E-02,1.056400E-01,1.684600E-01,1.965200E-01,1.994500E-01,&
     & 2.228600E-04,5.076800E-04,8.764900E-04,1.428300E-03,2.496600E-03,&
     & 4.529500E-03,8.994500E-03,1.972200E-02,6.061000E-02,1.330300E-01,&
     & 1.742000E-01,2.474000E-01,3.344800E-01,5.555400E-01,7.835500E-01,&
     & 8.168800E-01,4.462700E-04,8.411000E-04,1.342600E-03,2.293400E-03,&
     & 3.846500E-03,6.895600E-03,1.380300E-02,3.579100E-02,1.088200E-01,&
     & 2.356400E-01,3.353400E-01,4.924200E-01,6.633300E-01,1.103900E+00,&
     & 1.546300E+00,1.611800E+00,7.233000E-04,1.023800E-03,1.836000E-03,&
     & 2.962100E-03,4.992900E-03,9.132900E-03,1.921100E-02,5.166000E-02,&
     & 1.573000E-01,3.520000E-01,5.028400E-01,7.336700E-01,9.835400E-01,&
     & 1.641700E+00,2.277500E+00,2.374100E+00,9.369400E-04,1.376500E-03,&
     & 2.234500E-03,3.476300E-03,6.124500E-03,1.144100E-02,2.513000E-02,&
     & 6.717000E-02,2.082700E-01,4.670200E-01,6.697800E-01,9.682300E-01,&
     & 1.289700E+00,2.161100E+00,2.957200E+00,3.083600E+00,1.233700E-03,&
     & 1.923900E-03,2.301800E-03,4.166500E-03,7.294000E-03,1.406900E-02,&
     & 3.143400E-02,8.349300E-02,2.608900E-01,5.805400E-01,8.350800E-01,&
     & 1.189200E+00,1.571900E+00,2.645600E+00,3.545000E+00,3.696600E+00,&
     & 1.548200E-03,2.299700E-03,2.950000E-03,4.894800E-03,8.777600E-03,&
     & 1.726000E-02,3.854100E-02,1.031400E-01,3.137400E-01,6.952300E-01,&
     & 9.936200E-01,1.376700E+00,1.809700E+00,3.046300E+00,3.941900E+00,&
     & 4.111600E+00,1.777300E-03,3.575600E-03,4.824700E-03,5.862000E-03,&
     & 1.149900E-02,2.198400E-02,4.924400E-02,1.298000E-01,3.655900E-01,&
     & 8.137200E-01,1.115200E+00,1.453400E+00,1.947400E+00,3.169500E+00,&
     & 3.832000E+00,3.998000E+00,1.003800E-03,2.076700E-03,2.867800E-03,&
     & 5.466100E-03,1.018200E-02,2.015900E-02,4.632500E-02,1.293600E-01,&
     & 4.158400E-01,9.336700E-01,1.339500E+00,1.936400E+00,2.579400E+00,&
     & 4.322200E+00,5.914400E+00,6.167300E+00,5.883400E-07,2.508400E-06,&
     & 1.109600E-05,4.286700E-05,2.676900E-04,8.482400E-04,1.971400E-03,&
     & 5.056700E-03,1.135500E-02,2.036900E-02,3.230100E-02,6.406900E-02,&
     & 1.223200E-01,1.917400E-01,2.220000E-01,2.251000E-01,2.614300E-04,&
     & 6.129000E-04,1.056900E-03,1.715200E-03,3.007900E-03,5.399400E-03,&
     & 1.073800E-02,2.393900E-02,7.272300E-02,1.590600E-01,2.047000E-01,&
     & 2.976200E-01,4.025100E-01,6.674900E-01,9.561700E-01,1.007000E+00/
      data   absa(:, 21: 40) /                                          &
     & 5.044100E-04,1.020200E-03,1.613300E-03,2.774200E-03,4.607600E-03,&
     & 8.256700E-03,1.662100E-02,4.334100E-02,1.304800E-01,2.852300E-01,&
     & 4.001400E-01,5.926700E-01,7.974500E-01,1.327600E+00,1.887200E+00,&
     & 1.984100E+00,7.742400E-04,1.269300E-03,2.214500E-03,3.574400E-03,&
     & 5.993800E-03,1.101000E-02,2.315300E-02,6.243700E-02,1.891700E-01,&
     & 4.264000E-01,5.993600E-01,8.839600E-01,1.180900E+00,1.975600E+00,&
     & 2.780600E+00,2.915900E+00,1.040300E-03,1.551600E-03,2.739600E-03,&
     & 4.236100E-03,7.370300E-03,1.390900E-02,3.024200E-02,8.102800E-02,&
     & 2.509600E-01,5.662700E-01,7.973000E-01,1.168000E+00,1.546300E+00,&
     & 2.602700E+00,3.611400E+00,3.774800E+00,1.333100E-03,2.007800E-03,&
     & 3.015900E-03,5.027200E-03,8.825000E-03,1.720400E-02,3.782700E-02,&
     & 1.009400E-01,3.143500E-01,7.040500E-01,9.929400E-01,1.437900E+00,&
     & 1.879800E+00,3.188600E+00,4.331500E+00,4.503700E+00,1.790800E-03,&
     & 2.546100E-03,3.217900E-03,5.964200E-03,1.091600E-02,2.109100E-02,&
     & 4.647000E-02,1.248500E-01,3.782800E-01,8.374800E-01,1.184000E+00,&
     & 1.673400E+00,2.151200E+00,3.678900E+00,4.821200E+00,4.968900E+00,&
     & 2.084500E-03,3.492200E-03,5.111300E-03,7.937800E-03,1.346800E-02,&
     & 2.713200E-02,6.028600E-02,1.569700E-01,4.421100E-01,9.660400E-01,&
     & 1.337100E+00,1.785300E+00,2.285300E+00,3.843300E+00,4.682800E+00,&
     & 4.788300E+00,1.161900E-03,2.266800E-03,3.602400E-03,6.604400E-03,&
     & 1.226800E-02,2.452400E-02,5.580600E-02,1.565700E-01,5.010700E-01,&
     & 1.132100E+00,1.594300E+00,2.335900E+00,3.092500E+00,5.205500E+00,&
     & 7.222800E+00,7.549500E+00,7.992600E-07,3.422400E-06,1.573600E-05,&
     & 5.986900E-05,3.402400E-04,9.996200E-04,2.302800E-03,5.886500E-03,&
     & 1.327700E-02,2.406100E-02,3.861000E-02,7.459900E-02,1.390600E-01,&
     & 2.149000E-01,2.472000E-01,2.504800E-01,3.053200E-04,7.339200E-04,&
     & 1.260100E-03,2.033500E-03,3.583100E-03,6.367500E-03,1.268300E-02,&
     & 2.869900E-02,8.620400E-02,1.874200E-01,2.399000E-01,3.490800E-01,&
     & 4.815100E-01,7.847600E-01,1.141100E+00,1.225200E+00,5.765500E-04,&
     & 1.210400E-03,1.938000E-03,3.282700E-03,5.475100E-03,9.792900E-03,&
     & 1.978800E-02,5.184000E-02,1.548300E-01,3.406500E-01,4.744500E-01,&
     & 6.954800E-01,9.537000E-01,1.560900E+00,2.252800E+00,2.414000E+00,&
     & 8.466700E-04,1.545500E-03,2.651000E-03,4.244200E-03,7.112400E-03,&
     & 1.311600E-02,2.763400E-02,7.454800E-02,2.252000E-01,5.098700E-01,&
     & 7.093900E-01,1.037800E+00,1.411700E+00,2.323300E+00,3.319300E+00,&
     & 3.547900E+00,1.118900E-03,1.886600E-03,3.242400E-03,5.104600E-03,&
     & 8.742300E-03,1.666400E-02,3.604200E-02,9.666900E-02,2.993300E-01,&
     & 6.781000E-01,9.418600E-01,1.372500E+00,1.847700E+00,3.063900E+00,&
     & 4.311600E+00,4.592800E+00,1.484900E-03,2.196600E-03,3.789300E-03,&
     & 5.917900E-03,1.060000E-02,2.067000E-02,4.506300E-02,1.206600E-01,&
     & 3.748000E-01,8.449200E-01,1.168700E+00,1.692100E+00,2.244000E+00,&
     & 3.756300E+00,5.171300E+00,5.480600E+00,1.779300E-03,2.962400E-03,&
     & 3.999200E-03,7.140100E-03,1.298500E-02,2.552000E-02,5.540000E-02,&
     & 1.494700E-01,4.511700E-01,1.007800E+00,1.384200E+00,1.973400E+00,&
     & 2.562700E+00,4.339600E+00,5.755200E+00,6.047100E+00,2.339200E-03,&
     & 3.870800E-03,5.079400E-03,9.660100E-03,1.675700E-02,3.300900E-02,&
     & 7.232900E-02,1.879400E-01,5.286500E-01,1.140300E+00,1.565700E+00,&
     & 2.119200E+00,2.705400E+00,4.549300E+00,5.595900E+00,5.783100E+00,&
     & 1.275800E-03,2.590900E-03,4.445500E-03,7.849000E-03,1.465200E-02,&
     & 2.950400E-02,6.655100E-02,1.874800E-01,5.976200E-01,1.355800E+00,&
     & 1.883200E+00,2.744900E+00,3.695300E+00,6.127900E+00,8.623100E+00,&
     & 9.185600E+00,1.072600E-06,4.599000E-06,2.176800E-05,8.151700E-05,&
     & 4.202000E-04,1.167700E-03,2.659700E-03,6.769500E-03,1.532600E-02,&
     & 2.791100E-02,4.528500E-02,8.527400E-02,1.553700E-01,2.369100E-01,&
     & 2.706700E-01,2.741300E-01,3.555900E-04,8.703000E-04,1.488100E-03,&
     & 2.383400E-03,4.218000E-03,7.444900E-03,1.483900E-02,3.403100E-02,&
     & 1.011600E-01,2.168000E-01,2.804400E-01,4.039400E-01,5.689100E-01,&
     & 9.076500E-01,1.336800E+00,1.458500E+00,6.647200E-04,1.425300E-03,&
     & 2.301300E-03,3.844000E-03,6.429400E-03,1.151700E-02,2.334100E-02,&
     & 6.135800E-02,1.818800E-01,4.034700E-01,5.586600E-01,8.040400E-01,&
     & 1.128200E+00,1.804200E+00,2.639200E+00,2.873500E+00,9.558600E-04,&
     & 1.839500E-03,3.127200E-03,4.995900E-03,8.345300E-03,1.547600E-02,&
     & 3.268000E-02,8.809600E-02,2.655900E-01,6.036500E-01,8.345400E-01,&
     & 1.198300E+00,1.672300E+00,2.683400E+00,3.888500E+00,4.223300E+00/
      data   absa(:, 41: 60) /                                          &
     & 1.228700E-03,2.253700E-03,3.850500E-03,6.021400E-03,1.024800E-02,&
     & 1.974000E-02,4.260000E-02,1.142000E-01,3.538000E-01,8.016300E-01,&
     & 1.107400E+00,1.583000E+00,2.191800E+00,3.534800E+00,5.053100E+00,&
     & 5.467800E+00,1.562900E-03,2.631400E-03,4.493400E-03,7.069200E-03,&
     & 1.244900E-02,2.453000E-02,5.321100E-02,1.428900E-01,4.432700E-01,&
     & 9.966300E-01,1.374200E+00,1.947700E+00,2.665400E+00,4.336200E+00,&
     & 6.061700E+00,6.491300E+00,1.968400E-03,3.077900E-03,5.133600E-03,&
     & 8.426500E-03,1.535000E-02,3.034900E-02,6.542900E-02,1.772000E-01,&
     & 5.340200E-01,1.184200E+00,1.624300E+00,2.266200E+00,3.048000E+00,&
     & 5.016000E+00,6.749000E+00,7.199600E+00,2.652100E-03,4.244200E-03,&
     & 5.879600E-03,1.144300E-02,1.995500E-02,3.938500E-02,8.581600E-02,&
     & 2.223700E-01,6.266400E-01,1.343000E+00,1.808700E+00,2.452100E+00,&
     & 3.198900E+00,5.277400E+00,6.568100E+00,6.883500E+00,1.478100E-03,&
     & 2.966300E-03,5.364200E-03,9.288800E-03,1.721400E-02,3.502800E-02,&
     & 7.875100E-02,2.224000E-01,7.064000E-01,1.602800E+00,2.214100E+00,&
     & 3.165900E+00,4.383400E+00,7.069600E+00,1.010600E+01,1.093600E+01,&
     & 3.730100E-07,1.517800E-06,6.418900E-06,2.536600E-05,1.839900E-04,&
     & 7.315100E-04,1.736500E-03,4.711800E-03,1.177600E-02,2.215800E-02,&
     & 3.033400E-02,6.166500E-02,1.265100E-01,2.129600E-01,2.549500E-01,&
     & 2.594900E-01,1.510100E-04,3.426900E-04,6.443600E-04,1.067100E-03,&
     & 1.841900E-03,3.644800E-03,7.510400E-03,1.587700E-02,4.787800E-02,&
     & 1.127600E-01,1.580600E-01,2.107700E-01,2.751100E-01,4.621500E-01,&
     & 6.771400E-01,7.407300E-01,3.061300E-04,6.074800E-04,9.438900E-04,&
     & 1.613100E-03,2.849800E-03,5.201600E-03,1.085500E-02,2.539900E-02,&
     & 8.497200E-02,1.889100E-01,2.539100E-01,3.835500E-01,5.481100E-01,&
     & 9.198400E-01,1.342900E+00,1.468500E+00,5.244400E-04,7.198600E-04,&
     & 1.223900E-03,2.112300E-03,3.582200E-03,6.642100E-03,1.364900E-02,&
     & 3.591800E-02,1.187800E-01,2.751800E-01,3.805600E-01,5.733900E-01,&
     & 8.179200E-01,1.370600E+00,1.991100E+00,2.176400E+00,6.678500E-04,&
     & 9.367400E-04,1.586200E-03,2.368500E-03,4.244200E-03,7.940000E-03,&
     & 1.679400E-02,4.645700E-02,1.536600E-01,3.652400E-01,5.069500E-01,&
     & 7.605500E-01,1.082200E+00,1.809100E+00,2.610200E+00,2.850900E+00,&
     & 9.034700E-04,1.312100E-03,1.594300E-03,2.718500E-03,4.881400E-03,&
     & 9.101800E-03,2.048700E-02,5.693900E-02,1.906100E-01,4.531700E-01,&
     & 6.331800E-01,9.423600E-01,1.336900E+00,2.224500E+00,3.174100E+00,&
     & 3.463900E+00,1.104700E-03,1.610200E-03,2.176100E-03,3.041800E-03,&
     & 5.314100E-03,1.051600E-02,2.462200E-02,6.806800E-02,2.303300E-01,&
     & 5.365200E-01,7.590800E-01,1.109100E+00,1.570200E+00,2.586000E+00,&
     & 3.617600E+00,3.940500E+00,1.271700E-03,2.406900E-03,2.976800E-03,&
     & 3.487900E-03,6.958200E-03,1.254900E-02,2.978500E-02,8.453600E-02,&
     & 2.721100E-01,6.129600E-01,8.781300E-01,1.216800E+00,1.738800E+00,&
     & 2.773000E+00,3.698900E+00,4.009700E+00,6.092000E-04,1.324700E-03,&
     & 1.831900E-03,3.314300E-03,6.189000E-03,1.251400E-02,2.929600E-02,&
     & 8.555500E-02,3.031400E-01,7.302000E-01,1.013800E+00,1.521000E+00,&
     & 2.164300E+00,3.618200E+00,5.220400E+00,5.701700E+00,5.046400E-07,&
     & 2.129900E-06,9.513900E-06,3.767100E-05,2.529200E-04,8.899000E-04,&
     & 2.119100E-03,5.710800E-03,1.429400E-02,2.725600E-02,3.822400E-02,&
     & 7.623400E-02,1.515300E-01,2.501600E-01,2.971300E-01,3.022000E-01,&
     & 1.790000E-04,4.252400E-04,7.986300E-04,1.308800E-03,2.277100E-03,&
     & 4.421600E-03,9.184100E-03,1.957100E-02,5.895600E-02,1.380800E-01,&
     & 1.923400E-01,2.563900E-01,3.438400E-01,5.643200E-01,8.613900E-01,&
     & 9.212800E-01,3.460600E-04,7.370300E-04,1.174800E-03,2.001400E-03,&
     & 3.495800E-03,6.365900E-03,1.324600E-02,3.148700E-02,1.041600E-01,&
     & 2.310000E-01,3.117300E-01,4.782600E-01,6.841700E-01,1.123700E+00,&
     & 1.708500E+00,1.817200E+00,5.411200E-04,9.377600E-04,1.510400E-03,&
     & 2.610600E-03,4.393800E-03,8.166300E-03,1.672200E-02,4.443300E-02,&
     & 1.455900E-01,3.405100E-01,4.670600E-01,7.153200E-01,1.019700E+00,&
     & 1.675600E+00,2.532600E+00,2.693100E+00,7.770600E-04,1.039800E-03,&
     & 1.909400E-03,3.031200E-03,5.228300E-03,9.830200E-03,2.061300E-02,&
     & 5.736600E-02,1.887100E-01,4.518000E-01,6.220900E-01,9.500700E-01,&
     & 1.346600E+00,2.215100E+00,3.319100E+00,3.546000E+00,9.310800E-04,&
     & 1.436700E-03,2.087600E-03,3.387300E-03,6.033000E-03,1.139200E-02,&
     & 2.516400E-02,7.015400E-02,2.345700E-01,5.601500E-01,7.770700E-01,&
     & 1.179300E+00,1.657400E+00,2.729400E+00,4.035800E+00,4.308000E+00/
      data   absa(:, 61: 80) /                                          &
     & 1.290900E-03,1.735300E-03,2.217200E-03,3.901700E-03,6.835300E-03,&
     & 1.332100E-02,3.031900E-02,8.405200E-02,2.835800E-01,6.616000E-01,&
     & 9.333400E-01,1.394100E+00,1.931800E+00,3.186400E+00,4.597700E+00,&
     & 4.900700E+00,1.467100E-03,2.406100E-03,3.369000E-03,4.521500E-03,&
     & 8.023000E-03,1.628300E-02,3.731000E-02,1.047200E-01,3.354900E-01,&
     & 7.497300E-01,1.085700E+00,1.545200E+00,2.093300E+00,3.460600E+00,&
     & 4.690400E+00,4.987600E+00,7.363700E-04,1.524300E-03,2.207900E-03,&
     & 4.114300E-03,7.697600E-03,1.546900E-02,3.600200E-02,1.057000E-01,&
     & 3.729000E-01,9.031400E-01,1.243800E+00,1.900100E+00,2.693000E+00,&
     & 4.430100E+00,6.638200E+00,7.091800E+00,6.910900E-07,2.961200E-06,&
     & 1.392000E-05,5.454100E-05,3.354000E-04,1.071400E-03,2.533300E-03,&
     & 6.786600E-03,1.706600E-02,3.274200E-02,4.704200E-02,9.189200E-02,&
     & 1.771600E-01,2.869200E-01,3.379100E-01,3.434100E-01,2.121000E-04,&
     & 5.175300E-04,9.773800E-04,1.579500E-03,2.771100E-03,5.288300E-03,&
     & 1.103000E-02,2.374300E-02,7.134500E-02,1.664500E-01,2.279300E-01,&
     & 3.037600E-01,4.232300E-01,6.737500E-01,1.063200E+00,1.129100E+00,&
     & 4.030800E-04,8.862600E-04,1.433700E-03,2.430600E-03,4.225700E-03,&
     & 7.656400E-03,1.592100E-02,3.840300E-02,1.256500E-01,2.757500E-01,&
     & 3.777500E-01,5.776100E-01,8.416000E-01,1.342500E+00,2.108900E+00,&
     & 2.236000E+00,5.967000E-04,1.150000E-03,1.842200E-03,3.172600E-03,&
     & 5.310900E-03,9.845700E-03,2.020600E-02,5.406900E-02,1.758900E-01,&
     & 4.100700E-01,5.657300E-01,8.644500E-01,1.253000E+00,2.003300E+00,&
     & 3.127300E+00,3.308800E+00,8.357200E-04,1.289600E-03,2.290400E-03,&
     & 3.713700E-03,6.335200E-03,1.190900E-02,2.496600E-02,6.965700E-02,&
     & 2.285700E-01,5.442700E-01,7.527500E-01,1.148800E+00,1.652500E+00,&
     & 2.651200E+00,4.099600E+00,4.325200E+00,1.053900E-03,1.526300E-03,&
     & 2.666400E-03,4.120800E-03,7.345000E-03,1.394000E-02,3.043200E-02,&
     & 8.499700E-02,2.847100E-01,6.755500E-01,9.385600E-01,1.428100E+00,&
     & 2.028500E+00,3.274300E+00,4.986200E+00,5.238300E+00,1.289500E-03,&
     & 2.087600E-03,2.665500E-03,4.773700E-03,8.356700E-03,1.640500E-02,&
     & 3.670100E-02,1.021100E-01,3.440200E-01,8.005000E-01,1.122700E+00,&
     & 1.692300E+00,2.352300E+00,3.838400E+00,5.682300E+00,5.936000E+00,&
     & 1.628100E-03,2.638900E-03,3.332200E-03,5.737600E-03,1.014200E-02,&
     & 2.016600E-02,4.555900E-02,1.276200E-01,4.065800E-01,9.101900E-01,&
     & 1.303400E+00,1.891700E+00,2.505200E+00,4.214500E+00,5.794800E+00,&
     & 6.031800E+00,8.391700E-04,1.696600E-03,2.797300E-03,4.990100E-03,&
     & 9.371600E-03,1.884700E-02,4.360300E-02,1.283800E-01,4.527200E-01,&
     & 1.087900E+00,1.504900E+00,2.297500E+00,3.304900E+00,5.302300E+00,&
     & 8.199000E+00,8.650200E+00,9.444900E-07,4.089700E-06,1.981500E-05,&
     & 7.705600E-05,4.292800E-04,1.278200E-03,2.982800E-03,7.943600E-03,&
     & 2.008900E-02,3.859300E-02,5.679000E-02,1.083700E-01,2.030400E-01,&
     & 3.232700E-01,3.775100E-01,3.832500E-01,2.497300E-04,6.259600E-04,&
     & 1.174500E-03,1.885700E-03,3.326700E-03,6.263700E-03,1.305100E-02,&
     & 2.846000E-02,8.520100E-02,1.980700E-01,2.666300E-01,3.527300E-01,&
     & 5.091400E-01,7.964500E-01,1.277800E+00,1.387400E+00,4.686200E-04,&
     & 1.059700E-03,1.725500E-03,2.900900E-03,5.059500E-03,9.099500E-03,&
     & 1.893200E-02,4.623100E-02,1.497200E-01,3.247500E-01,4.551500E-01,&
     & 6.810600E-01,1.012800E+00,1.586600E+00,2.534700E+00,2.748100E+00,&
     & 6.766200E-04,1.384300E-03,2.215000E-03,3.783600E-03,6.359700E-03,&
     & 1.173800E-02,2.414500E-02,6.499000E-02,2.102200E-01,4.855200E-01,&
     & 6.810100E-01,1.019200E+00,1.508300E+00,2.366900E+00,3.759100E+00,&
     & 4.066600E+00,9.029400E-04,1.585000E-03,2.763800E-03,4.436400E-03,&
     & 7.571900E-03,1.424200E-02,2.991500E-02,8.359800E-02,2.738400E-01,&
     & 6.453100E-01,9.048900E-01,1.354800E+00,1.989400E+00,3.132300E+00,&
     & 4.927700E+00,5.315900E+00,1.138800E-03,1.809800E-03,3.195000E-03,&
     & 5.023500E-03,8.775300E-03,1.676100E-02,3.645400E-02,1.018200E-01,&
     & 3.417000E-01,8.034100E-01,1.124400E+00,1.685800E+00,2.442500E+00,&
     & 3.867900E+00,5.994400E+00,6.436700E+00,1.423000E-03,2.126800E-03,&
     & 3.514400E-03,5.642700E-03,1.013700E-02,1.987100E-02,4.391900E-02,&
     & 1.226000E-01,4.127200E-01,9.578600E-01,1.336300E+00,2.001200E+00,&
     & 2.827300E+00,4.542500E+00,6.834500E+00,7.279000E+00,1.878000E-03,&
     & 2.865600E-03,3.660100E-03,6.936500E-03,1.248700E-02,2.460400E-02,&
     & 5.467400E-02,1.535600E-01,4.870400E-01,1.099400E+00,1.535200E+00,&
     & 2.248800E+00,2.994700E+00,5.010000E+00,6.983000E+00,7.305900E+00/
      data   absa(:, 81:100) /                                          &
     & 9.523600E-04,1.958400E-03,3.429100E-03,5.984800E-03,1.122600E-02,&
     & 2.275300E-02,5.223300E-02,1.544000E-01,5.435000E-01,1.289800E+00,&
     & 1.809000E+00,2.709400E+00,3.978500E+00,6.264500E+00,9.855400E+00,&
     & 1.063200E+01,1.278500E-06,5.568700E-06,2.756700E-05,1.056600E-04,&
     & 5.332600E-04,1.510100E-03,3.470900E-03,9.187300E-03,2.330700E-02,&
     & 4.471300E-02,6.719800E-02,1.252300E-01,2.285600E-01,3.585100E-01,&
     & 4.154400E-01,4.215300E-01,2.928300E-04,7.455500E-04,1.393700E-03,&
     & 2.234400E-03,3.939700E-03,7.349100E-03,1.529100E-02,3.372200E-02,&
     & 1.005900E-01,2.313900E-01,3.090900E-01,4.052600E-01,5.970800E-01,&
     & 9.351800E-01,1.505400E+00,1.666000E+00,5.440700E-04,1.260000E-03,&
     & 2.055300E-03,3.413700E-03,5.980700E-03,1.072800E-02,2.227900E-02,&
     & 5.499900E-02,1.760200E-01,3.840100E-01,5.385500E-01,7.973500E-01,&
     & 1.188200E+00,1.862100E+00,2.985500E+00,3.299200E+00,7.752200E-04,&
     & 1.634700E-03,2.651300E-03,4.455200E-03,7.517400E-03,1.386500E-02,&
     & 2.857300E-02,7.719400E-02,2.483400E-01,5.743100E-01,8.062000E-01,&
     & 1.192100E+00,1.770500E+00,2.777700E+00,4.427800E+00,4.882300E+00,&
     & 1.005300E-03,1.907000E-03,3.273600E-03,5.267100E-03,8.938300E-03,&
     & 1.685000E-02,3.552000E-02,9.913700E-02,3.244200E-01,7.632900E-01,&
     & 1.072000E+00,1.581600E+00,2.337500E+00,3.673000E+00,5.806700E+00,&
     & 6.381900E+00,1.225400E-03,2.191400E-03,3.795200E-03,5.985300E-03,&
     & 1.036500E-02,1.989200E-02,4.328400E-02,1.206800E-01,4.057000E-01,&
     & 9.502600E-01,1.333900E+00,1.962500E+00,2.875300E+00,4.529700E+00,&
     & 7.064700E+00,7.729000E+00,1.559200E-03,2.416600E-03,4.283700E-03,&
     & 6.724900E-03,1.199200E-02,2.368700E-02,5.212700E-02,1.458400E-01,&
     & 4.899800E-01,1.131700E+00,1.587200E+00,2.321300E+00,3.341700E+00,&
     & 5.302900E+00,8.055700E+00,8.741000E+00,1.903100E-03,3.300700E-03,&
     & 4.492200E-03,8.239700E-03,1.478900E-02,2.958100E-02,6.500800E-02,&
     & 1.828500E-01,5.784400E-01,1.300700E+00,1.807500E+00,2.608700E+00,&
     & 3.559800E+00,5.828100E+00,8.236400E+00,8.773700E+00,1.116400E-03,&
     & 2.266900E-03,4.116000E-03,7.129600E-03,1.325100E-02,2.717100E-02,&
     & 6.197900E-02,1.837500E-01,6.452300E-01,1.525600E+00,2.143200E+00,&
     & 3.162500E+00,4.674600E+00,7.345800E+00,1.161300E+01,1.276400E+01,&
     & 5.592100E-07,2.223400E-06,9.631900E-06,3.955800E-05,2.812600E-04,&
     & 1.161400E-03,2.809200E-03,7.928900E-03,2.234800E-02,4.488900E-02,&
     & 5.838600E-02,1.112000E-01,2.315500E-01,4.056900E-01,4.960800E-01,&
     & 5.064400E-01,1.192400E-04,2.744400E-04,5.978900E-04,1.074200E-03,&
     & 1.876500E-03,3.928600E-03,8.431800E-03,1.889800E-02,5.024000E-02,&
     & 1.194500E-01,1.753300E-01,2.486800E-01,3.610600E-01,4.734600E-01,&
     & 6.898400E-01,7.825500E-01,2.250900E-04,5.008500E-04,9.078900E-04,&
     & 1.524800E-03,2.658800E-03,5.299200E-03,1.135200E-02,2.565300E-02,&
     & 8.049600E-02,1.991000E-01,2.713400E-01,3.680800E-01,5.152400E-01,&
     & 9.013900E-01,1.374600E+00,1.558700E+00,3.431800E-04,6.953400E-04,&
     & 1.107700E-03,1.850100E-03,3.348500E-03,6.292000E-03,1.367200E-02,&
     & 3.161000E-02,1.107200E-01,2.659200E-01,3.428000E-01,5.184000E-01,&
     & 7.707400E-01,1.348300E+00,2.050200E+00,2.323900E+00,5.230800E-04,&
     & 7.762900E-04,1.252500E-03,2.183000E-03,3.822100E-03,7.180300E-03,&
     & 1.543400E-02,3.834700E-02,1.381400E-01,3.271600E-01,4.532700E-01,&
     & 6.901700E-01,1.023700E+00,1.789200E+00,2.712100E+00,3.071600E+00,&
     & 6.561600E-04,8.885400E-04,1.512000E-03,2.326100E-03,4.163600E-03,&
     & 7.957100E-03,1.683400E-02,4.582200E-02,1.648800E-01,4.082000E-01,&
     & 5.655000E-01,8.605600E-01,1.271700E+00,2.220400E+00,3.345500E+00,&
     & 3.784800E+00,8.523000E-04,1.191700E-03,1.495900E-03,2.439100E-03,&
     & 4.468200E-03,8.545500E-03,1.868000E-02,5.349400E-02,1.940100E-01,&
     & 4.883200E-01,6.760600E-01,1.027100E+00,1.507900E+00,2.625200E+00,&
     & 3.912200E+00,4.417700E+00,1.006900E-03,1.537300E-03,2.127600E-03,&
     & 2.589000E-03,4.484600E-03,9.034900E-03,2.155100E-02,6.217400E-02,&
     & 2.288100E-01,5.645000E-01,7.824400E-01,1.175800E+00,1.706700E+00,&
     & 2.935800E+00,4.249000E+00,4.774000E+00,4.126800E-04,9.159500E-04,&
     & 1.345600E-03,2.382900E-03,4.391900E-03,9.056700E-03,2.143700E-02,&
     & 6.478900E-02,2.547000E-01,6.533300E-01,9.064600E-01,1.380200E+00,&
     & 2.047400E+00,3.578400E+00,5.424200E+00,6.143100E+00,7.505500E-07,&
     & 3.131700E-06,1.453100E-05,5.959400E-05,3.944900E-04,1.452600E-03,&
     & 3.452400E-03,9.725000E-03,2.744200E-02,5.609600E-02,7.413600E-02,&
     & 1.405300E-01,2.822200E-01,4.835700E-01,5.859100E-01,5.975900E-01/
      data   absa(:,101:120) /                                          &
     & 1.448300E-04,3.426300E-04,7.564000E-04,1.347600E-03,2.330600E-03,&
     & 4.833800E-03,1.043600E-02,2.337800E-02,6.274800E-02,1.484700E-01,&
     & 2.191200E-01,3.153600E-01,4.312200E-01,5.758500E-01,8.942200E-01,&
     & 9.916900E-01,2.680500E-04,6.225700E-04,1.141200E-03,1.894000E-03,&
     & 3.323100E-03,6.507600E-03,1.406000E-02,3.196000E-02,1.000800E-01,&
     & 2.484500E-01,3.331100E-01,4.558300E-01,6.611400E-01,1.101600E+00,&
     & 1.781200E+00,1.975100E+00,3.934500E-04,8.494100E-04,1.398900E-03,&
     & 2.318200E-03,4.165000E-03,7.770400E-03,1.689100E-02,3.965000E-02,&
     & 1.370200E-01,3.307100E-01,4.226600E-01,6.544200E-01,9.885400E-01,&
     & 1.648200E+00,2.657900E+00,2.945000E+00,5.424500E-04,1.012700E-03,&
     & 1.570300E-03,2.748600E-03,4.724100E-03,8.919700E-03,1.907100E-02,&
     & 4.815700E-02,1.704700E-01,4.117100E-01,5.620300E-01,8.717300E-01,&
     & 1.312000E+00,2.188800E+00,3.515100E+00,3.892600E+00,7.686300E-04,&
     & 1.014300E-03,1.794400E-03,3.041000E-03,5.168400E-03,9.962900E-03,&
     & 2.084700E-02,5.746300E-02,2.037900E-01,5.141800E-01,7.007500E-01,&
     & 1.087900E+00,1.627800E+00,2.718500E+00,4.336000E+00,4.796600E+00,&
     & 8.693100E-04,1.336200E-03,1.938600E-03,3.083900E-03,5.588400E-03,&
     & 1.079900E-02,2.320600E-02,6.698700E-02,2.401500E-01,6.157800E-01,&
     & 8.370700E-01,1.300300E+00,1.924800E+00,3.220500E+00,5.069400E+00,&
     & 5.598600E+00,1.126600E-03,1.658300E-03,2.169600E-03,3.328700E-03,&
     & 5.916700E-03,1.162500E-02,2.695500E-02,7.790500E-02,2.837100E-01,&
     & 7.108100E-01,9.695900E-01,1.494700E+00,2.161600E+00,3.618400E+00,&
     & 5.502000E+00,6.049300E+00,5.082900E-04,1.039300E-03,1.710900E-03,&
     & 2.966200E-03,5.507400E-03,1.129800E-02,2.656500E-02,8.112500E-02,&
     & 3.156300E-01,8.222400E-01,1.123600E+00,1.743300E+00,2.623800E+00,&
     & 4.377700E+00,7.030300E+00,7.785200E+00,1.028200E-06,4.408000E-06,&
     & 2.145700E-05,8.749500E-05,5.326900E-04,1.772500E-03,4.182700E-03,&
     & 1.169000E-02,3.306600E-02,6.870200E-02,9.157300E-02,1.724900E-01,&
     & 3.349000E-01,5.618400E-01,6.740900E-01,6.869600E-01,1.741800E-04,&
     & 4.242200E-04,9.361000E-04,1.665100E-03,2.850000E-03,5.834300E-03,&
     & 1.265300E-02,2.847700E-02,7.671100E-02,1.816100E-01,2.650900E-01,&
     & 3.864300E-01,5.092500E-01,6.853900E-01,1.123100E+00,1.218600E+00,&
     & 3.182300E-04,7.634700E-04,1.411500E-03,2.310800E-03,4.083500E-03,&
     & 7.868000E-03,1.707200E-02,3.905000E-02,1.222900E-01,3.012400E-01,&
     & 4.009600E-01,5.483000E-01,8.304900E-01,1.318200E+00,2.237700E+00,&
     & 2.426500E+00,4.605200E-04,1.027900E-03,1.727200E-03,2.851500E-03,&
     & 5.083400E-03,9.429800E-03,2.047700E-02,4.873500E-02,1.670000E-01,&
     & 3.961700E-01,5.173000E-01,7.988500E-01,1.241700E+00,1.972600E+00,&
     & 3.337900E+00,3.618600E+00,6.064600E-04,1.238700E-03,1.936900E-03,&
     & 3.379800E-03,5.767700E-03,1.086600E-02,2.316000E-02,5.925100E-02,&
     & 2.074000E-01,5.008900E-01,6.881200E-01,1.064500E+00,1.647600E+00,&
     & 2.620600E+00,4.415300E+00,4.782500E+00,8.069900E-04,1.296700E-03,&
     & 2.200300E-03,3.735900E-03,6.323500E-03,1.217900E-02,2.538900E-02,&
     & 7.059000E-02,2.484900E-01,6.255400E-01,8.574700E-01,1.329200E+00,&
     & 2.043000E+00,3.255500E+00,5.445200E+00,5.863000E+00,9.901000E-04,&
     & 1.393200E-03,2.501200E-03,3.832700E-03,6.882900E-03,1.326400E-02,&
     & 2.836100E-02,8.211800E-02,2.933900E-01,7.493300E-01,1.023700E+00,&
     & 1.590500E+00,2.413300E+00,3.861600E+00,6.366600E+00,6.878600E+00,&
     & 1.282200E-03,1.840800E-03,2.316700E-03,4.190500E-03,7.474500E-03,&
     & 1.452500E-02,3.301600E-02,9.559600E-02,3.468500E-01,8.666200E-01,&
     & 1.182300E+00,1.833800E+00,2.695400E+00,4.359700E+00,6.909700E+00,&
     & 7.432800E+00,5.835300E-04,1.215200E-03,2.126500E-03,3.594900E-03,&
     & 6.834700E-03,1.384700E-02,3.245100E-02,9.956200E-02,3.860400E-01,&
     & 1.000300E+00,1.375300E+00,2.128800E+00,3.294900E+00,5.241100E+00,&
     & 8.830700E+00,9.564900E+00,1.416500E-06,6.167000E-06,3.111200E-05,&
     & 1.245000E-04,6.930400E-04,2.136800E-03,4.995800E-03,1.381900E-02,&
     & 3.926900E-02,8.194900E-02,1.111500E-01,2.067600E-01,3.889800E-01,&
     & 6.393700E-01,7.592600E-01,7.729100E-01,2.077600E-04,5.213000E-04,&
     & 1.138800E-03,2.029300E-03,3.441800E-03,6.957600E-03,1.510300E-02,&
     & 3.423000E-02,9.236600E-02,2.181300E-01,3.141000E-01,4.578000E-01,&
     & 5.995100E-01,8.007400E-01,1.368800E+00,1.504400E+00,3.764000E-04,&
     & 9.242500E-04,1.720000E-03,2.784900E-03,4.946500E-03,9.396700E-03,&
     & 2.038000E-02,4.705300E-02,1.474900E-01,3.578800E-01,4.762600E-01,&
     & 6.454900E-01,1.013200E+00,1.565900E+00,2.727100E+00,2.994200E+00/
      data   absa(:,121:140) /                                          &
     & 5.389600E-04,1.241200E-03,2.090100E-03,3.450200E-03,6.126300E-03,&
     & 1.129800E-02,2.451200E-02,5.893600E-02,2.010300E-01,4.667500E-01,&
     & 6.244700E-01,9.543700E-01,1.515100E+00,2.342000E+00,4.069200E+00,&
     & 4.462200E+00,6.973600E-04,1.484900E-03,2.359000E-03,4.076000E-03,&
     & 6.966800E-03,1.303800E-02,2.779000E-02,7.176100E-02,2.492400E-01,&
     & 6.011200E-01,8.311800E-01,1.271000E+00,2.011400E+00,3.110100E+00,&
     & 5.381400E+00,5.891800E+00,8.710800E-04,1.602200E-03,2.686400E-03,&
     & 4.500200E-03,7.636600E-03,1.463300E-02,3.062100E-02,8.539100E-02,&
     & 2.994400E-01,7.498200E-01,1.036500E+00,1.586400E+00,2.496400E+00,&
     & 3.861700E+00,6.641000E+00,7.247100E+00,1.094800E-03,1.641500E-03,&
     & 2.976800E-03,4.743200E-03,8.313300E-03,1.601300E-02,3.427000E-02,&
     & 9.914800E-02,3.544300E-01,8.972200E-01,1.238300E+00,1.897000E+00,&
     & 2.953100E+00,4.573500E+00,7.770600E+00,8.430800E+00,1.303500E-03,&
     & 2.093500E-03,2.911400E-03,5.070800E-03,9.101000E-03,1.777400E-02,&
     & 3.987800E-02,1.154700E-01,4.195800E-01,1.036900E+00,1.428000E+00,&
     & 2.189600E+00,3.304300E+00,5.159500E+00,8.445200E+00,9.032100E+00,&
     & 6.842900E-04,1.420100E-03,2.584400E-03,4.355100E-03,8.283100E-03,&
     & 1.680700E-02,3.915800E-02,1.205900E-01,4.666300E-01,1.199600E+00,&
     & 1.661500E+00,2.541100E+00,4.022400E+00,6.220100E+00,1.076300E+01,&
     & 1.178400E+01,1.934400E-06,8.526400E-06,4.373500E-05,1.740500E-04,&
     & 8.713300E-04,2.553000E-03,5.880200E-03,1.612600E-02,4.593300E-02,&
     & 9.575200E-02,1.324500E-01,2.421200E-01,4.429500E-01,7.154200E-01,&
     & 8.420000E-01,8.565500E-01,2.474400E-04,6.350700E-04,1.363200E-03,&
     & 2.431600E-03,4.117800E-03,8.221300E-03,1.777600E-02,4.061000E-02,&
     & 1.097200E-01,2.579200E-01,3.672500E-01,5.287100E-01,6.922800E-01,&
     & 9.329000E-01,1.628400E+00,1.830800E+00,4.426300E-04,1.107200E-03,&
     & 2.066300E-03,3.318200E-03,5.908800E-03,1.111900E-02,2.405500E-02,&
     & 5.593500E-02,1.756200E-01,4.186000E-01,5.568300E-01,7.548400E-01,&
     & 1.194100E+00,1.859400E+00,3.244300E+00,3.644300E+00,6.298300E-04,&
     & 1.484300E-03,2.503100E-03,4.114200E-03,7.302600E-03,1.338600E-02,&
     & 2.903000E-02,7.035000E-02,2.386900E-01,5.474200E-01,7.433600E-01,&
     & 1.126900E+00,1.786300E+00,2.780300E+00,4.840500E+00,5.430300E+00,&
     & 8.025800E-04,1.774700E-03,2.835900E-03,4.838700E-03,8.312500E-03,&
     & 1.546700E-02,3.299900E-02,8.575800E-02,2.959200E-01,7.166900E-01,&
     & 9.898800E-01,1.500000E+00,2.371900E+00,3.690700E+00,6.404000E+00,&
     & 7.169600E+00,9.750300E-04,1.936200E-03,3.212400E-03,5.367300E-03,&
     & 9.099600E-03,1.739600E-02,3.651600E-02,1.019300E-01,3.567100E-01,&
     & 8.925500E-01,1.235500E+00,1.870000E+00,2.944900E+00,4.581500E+00,&
     & 7.903600E+00,8.819100E+00,1.165100E-03,2.023300E-03,3.564300E-03,&
     & 5.671600E-03,9.911300E-03,1.910500E-02,4.097000E-02,1.181500E-01,&
     & 4.235400E-01,1.064800E+00,1.478000E+00,2.233600E+00,3.487900E+00,&
     & 5.422800E+00,9.246000E+00,1.026100E+01,1.449700E-03,2.157200E-03,&
     & 3.813800E-03,6.003600E-03,1.088800E-02,2.140500E-02,4.765100E-02,&
     & 1.379400E-01,5.020500E-01,1.223400E+00,1.713200E+00,2.564700E+00,&
     & 3.917000E+00,6.099700E+00,1.005700E+01,1.099400E+01,8.146100E-04,&
     & 1.661900E-03,3.076600E-03,5.255400E-03,9.853900E-03,2.019800E-02,&
     & 4.678400E-02,1.442800E-01,5.576200E-01,1.429300E+00,1.978800E+00,&
     & 2.998700E+00,4.743400E+00,7.381100E+00,1.280800E+01,1.433900E+01,&
     & 8.573200E-07,3.283500E-06,1.433200E-05,6.099300E-05,4.294200E-04,&
     & 1.839300E-03,4.558900E-03,1.321700E-02,4.210600E-02,9.277900E-02,&
     & 1.164100E-01,2.009200E-01,4.243800E-01,7.761300E-01,9.721500E-01,&
     & 9.966000E-01,9.646700E-05,2.211100E-04,5.048100E-04,1.086500E-03,&
     & 2.120900E-03,4.271900E-03,1.007900E-02,2.347900E-02,6.436900E-02,&
     & 1.364700E-01,1.977000E-01,3.056600E-01,5.077700E-01,7.248200E-01,&
     & 8.506700E-01,8.718700E-01,1.742400E-04,3.919900E-04,8.388500E-04,&
     & 1.506400E-03,2.661100E-03,5.610800E-03,1.233700E-02,2.953900E-02,&
     & 8.455500E-02,2.037400E-01,2.943900E-01,4.332100E-01,6.151900E-01,&
     & 8.821300E-01,1.353200E+00,1.605800E+00,2.510000E-04,5.478200E-04,&
     & 1.038600E-03,1.795600E-03,3.095400E-03,6.423800E-03,1.399400E-02,&
     & 3.375100E-02,1.054200E-01,2.688000E-01,3.752500E-01,5.277000E-01,&
     & 7.059600E-01,1.290600E+00,2.024700E+00,2.402000E+00,3.306500E-04,&
     & 7.147900E-04,1.152800E-03,1.949200E-03,3.509200E-03,6.886700E-03,&
     & 1.524900E-02,3.672100E-02,1.269000E-01,3.247400E-01,4.372200E-01,&
     & 6.016000E-01,9.343800E-01,1.717400E+00,2.689500E+00,3.190000E+00/
      data   absa(:,141:160) /                                          &
     & 4.872400E-04,7.615400E-04,1.215300E-03,2.075800E-03,3.779500E-03,&
     & 7.192400E-03,1.607000E-02,3.916100E-02,1.475000E-01,3.663000E-01,&
     & 5.009400E-01,7.502300E-01,1.164500E+00,2.140600E+00,3.341900E+00,&
     & 3.959600E+00,6.029900E-04,8.234500E-04,1.323600E-03,2.137600E-03,&
     & 3.753600E-03,7.406000E-03,1.632100E-02,4.233900E-02,1.648700E-01,&
     & 4.291500E-01,6.000900E-01,8.987000E-01,1.389200E+00,2.553600E+00,&
     & 3.962400E+00,4.688400E+00,7.858200E-04,1.088800E-03,1.323600E-03,&
     & 1.997400E-03,3.680300E-03,7.286200E-03,1.619100E-02,4.702500E-02,&
     & 1.857600E-01,4.964400E-01,6.973100E-01,1.043200E+00,1.594600E+00,&
     & 2.927200E+00,4.466200E+00,5.260200E+00,2.980800E-04,6.174900E-04,&
     & 9.917700E-04,1.719400E-03,3.183300E-03,6.315600E-03,1.549200E-02,&
     & 4.784700E-02,2.065100E-01,5.735700E-01,8.019600E-01,1.201300E+00,&
     & 1.868600E+00,3.434800E+00,5.379100E+00,6.380000E+00,1.130800E-06,&
     & 4.617700E-06,2.174500E-05,9.373900E-05,6.127800E-04,2.351000E-03,&
     & 5.683400E-03,1.644700E-02,5.257600E-02,1.160400E-01,1.496600E-01,&
     & 2.607100E-01,5.291100E-01,9.405400E-01,1.163200E+00,1.190900E+00,&
     & 1.182600E-04,2.823900E-04,6.579700E-04,1.393800E-03,2.680100E-03,&
     & 5.333000E-03,1.263800E-02,2.941700E-02,8.102600E-02,1.747700E-01,&
     & 2.576500E-01,3.870300E-01,6.265300E-01,9.013600E-01,1.026400E+00,&
     & 1.045400E+00,2.130300E-04,4.939200E-04,1.077100E-03,1.909000E-03,&
     & 3.364800E-03,6.992300E-03,1.546400E-02,3.709300E-02,1.068300E-01,&
     & 2.592400E-01,3.725200E-01,5.575700E-01,7.590300E-01,1.078100E+00,&
     & 1.793700E+00,2.081300E+00,3.026100E-04,6.929900E-04,1.328200E-03,&
     & 2.265500E-03,3.910800E-03,7.980100E-03,1.758300E-02,4.254600E-02,&
     & 1.328000E-01,3.428800E-01,4.683400E-01,6.593000E-01,9.259100E-01,&
     & 1.585000E+00,2.684700E+00,3.113500E+00,3.918600E-04,8.708900E-04,&
     & 1.486000E-03,2.471400E-03,4.428900E-03,8.582900E-03,1.915400E-02,&
     & 4.645600E-02,1.595000E-01,4.114300E-01,5.421600E-01,7.661900E-01,&
     & 1.232000E+00,2.109800E+00,3.566700E+00,4.133800E+00,5.084900E-04,&
     & 1.003500E-03,1.549200E-03,2.646800E-03,4.730500E-03,9.035200E-03,&
     & 2.016600E-02,4.976500E-02,1.849100E-01,4.566100E-01,6.360600E-01,&
     & 9.573200E-01,1.535200E+00,2.629500E+00,4.431700E+00,5.132000E+00,&
     & 7.032200E-04,9.411300E-04,1.618800E-03,2.799800E-03,4.767700E-03,&
     & 9.367000E-03,2.045600E-02,5.392200E-02,2.065500E-01,5.393300E-01,&
     & 7.607500E-01,1.147700E+00,1.830700E+00,3.137200E+00,5.253800E+00,&
     & 6.075400E+00,8.227500E-04,1.277600E-03,1.546800E-03,2.599300E-03,&
     & 4.718700E-03,9.379000E-03,2.043800E-02,5.972400E-02,2.330700E-01,&
     & 6.279200E-01,8.797500E-01,1.336400E+00,2.095500E+00,3.602000E+00,&
     & 5.921200E+00,6.817600E+00,3.546200E-04,7.221200E-04,1.275700E-03,&
     & 2.176600E-03,4.011200E-03,7.978700E-03,1.945600E-02,6.070300E-02,&
     & 2.596600E-01,7.185300E-01,1.018400E+00,1.532100E+00,2.463700E+00,&
     & 4.219400E+00,7.133300E+00,8.267500E+00,1.540900E-06,6.547000E-06,&
     & 3.266700E-05,1.399900E-04,8.443100E-04,2.932800E-03,6.961900E-03,&
     & 2.005500E-02,6.407900E-02,1.432500E-01,1.871000E-01,3.264000E-01,&
     & 6.394500E-01,1.109500E+00,1.357400E+00,1.388300E+00,1.441300E-04,&
     & 3.577700E-04,8.361400E-04,1.751200E-03,3.331600E-03,6.547700E-03,&
     & 1.549200E-02,3.616300E-02,9.962200E-02,2.181000E-01,3.224500E-01,&
     & 4.799400E-01,7.508600E-01,1.084300E+00,1.221700E+00,1.305300E+00,&
     & 2.581800E-04,6.155000E-04,1.347900E-03,2.388800E-03,4.164800E-03,&
     & 8.552400E-03,1.896900E-02,4.572700E-02,1.319400E-01,3.220400E-01,&
     & 4.567900E-01,6.873700E-01,9.290200E-01,1.288700E+00,2.295100E+00,&
     & 2.605400E+00,3.626300E-04,8.606600E-04,1.667300E-03,2.801800E-03,&
     & 4.859700E-03,9.752200E-03,2.161200E-02,5.254100E-02,1.639200E-01,&
     & 4.234500E-01,5.720500E-01,7.957500E-01,1.181600E+00,1.917000E+00,&
     & 3.435200E+00,3.897200E+00,4.646900E-04,1.068600E-03,1.858200E-03,&
     & 3.068700E-03,5.482900E-03,1.052300E-02,2.356800E-02,5.747200E-02,&
     & 1.967200E-01,5.027000E-01,6.619400E-01,9.461700E-01,1.572800E+00,&
     & 2.551200E+00,4.562500E+00,5.174600E+00,5.759200E-04,1.218100E-03,&
     & 1.941600E-03,3.309700E-03,5.848400E-03,1.110500E-02,2.477000E-02,&
     & 6.184400E-02,2.276900E-01,5.539000E-01,7.915100E-01,1.182100E+00,&
     & 1.960000E+00,3.179100E+00,5.668600E+00,6.424500E+00,7.386700E-04,&
     & 1.220400E-03,2.003600E-03,3.482500E-03,5.913500E-03,1.157100E-02,&
     & 2.512000E-02,6.705800E-02,2.545100E-01,6.583900E-01,9.464300E-01,&
     & 1.417800E+00,2.338000E+00,3.791900E+00,6.722200E+00,7.605600E+00/
      data   absa(:,161:180) /                                          &
     & 8.749600E-04,1.319600E-03,2.102400E-03,3.229700E-03,5.945100E-03,&
     & 1.168400E-02,2.522300E-02,7.409000E-02,2.878100E-01,7.686200E-01,&
     & 1.091900E+00,1.654100E+00,2.679300E+00,4.351100E+00,7.578800E+00,&
     & 8.541500E+00,4.276000E-04,8.585600E-04,1.575400E-03,2.691200E-03,&
     & 4.989100E-03,9.912400E-03,2.399700E-02,7.524100E-02,3.214200E-01,&
     & 8.752600E-01,1.267100E+00,1.891400E+00,3.145300E+00,5.102100E+00,&
     & 9.125000E+00,1.034900E+01,2.130000E-06,9.289600E-06,4.809300E-05,&
     & 2.028400E-04,1.117500E-03,3.613600E-03,8.400600E-03,2.400600E-02,&
     & 7.678100E-02,1.732000E-01,2.285300E-01,3.985500E-01,7.543200E-01,&
     & 1.279100E+00,1.547300E+00,1.581300E+00,1.756300E-04,4.482600E-04,&
     & 1.047200E-03,2.157600E-03,4.050600E-03,7.970800E-03,1.864400E-02,&
     & 4.378500E-02,1.203600E-01,2.669400E-01,3.920100E-01,5.834800E-01,&
     & 8.794600E-01,1.260300E+00,1.462100E+00,1.601700E+00,3.102600E-04,&
     & 7.610600E-04,1.654100E-03,2.950700E-03,5.074700E-03,1.030600E-02,&
     & 2.289200E-02,5.546900E-02,1.604000E-01,3.893800E-01,5.504100E-01,&
     & 8.207800E-01,1.107300E+00,1.538200E+00,2.848700E+00,3.196500E+00,&
     & 4.322800E-04,1.054700E-03,2.046200E-03,3.417900E-03,5.964700E-03,&
     & 1.174800E-02,2.610800E-02,6.375500E-02,1.995500E-01,5.094500E-01,&
     & 6.881000E-01,9.383000E-01,1.456900E+00,2.303800E+00,4.263500E+00,&
     & 4.780300E+00,5.485900E-04,1.298900E-03,2.291000E-03,3.740800E-03,&
     & 6.696600E-03,1.270800E-02,2.848700E-02,6.992000E-02,2.390900E-01,&
     & 6.040600E-01,7.887600E-01,1.149000E+00,1.939400E+00,3.064900E+00,&
     & 5.665100E+00,6.344600E+00,6.668100E-04,1.467100E-03,2.392700E-03,&
     & 4.062800E-03,7.110200E-03,1.344000E-02,2.998100E-02,7.552700E-02,&
     & 2.758400E-01,6.693600E-01,9.578700E-01,1.435200E+00,2.418300E+00,&
     & 3.817300E+00,7.038700E+00,7.872800E+00,7.958100E-04,1.526000E-03,&
     & 2.456900E-03,4.258900E-03,7.212700E-03,1.403200E-02,3.045700E-02,&
     & 8.200000E-02,3.087200E-01,8.005800E-01,1.145800E+00,1.720700E+00,&
     & 2.887500E+00,4.551300E+00,8.349100E+00,9.311800E+00,9.993200E-04,&
     & 1.423800E-03,2.601000E-03,4.055400E-03,7.266800E-03,1.427100E-02,&
     & 3.072400E-02,9.038700E-02,3.501700E-01,9.340500E-01,1.324100E+00,&
     & 2.004100E+00,3.317300E+00,5.208300E+00,9.417700E+00,1.042300E+01,&
     & 5.089200E-04,1.023700E-03,1.921000E-03,3.282200E-03,6.079400E-03,&
     & 1.217200E-02,2.918300E-02,9.196800E-02,3.914900E-01,1.063900E+00,&
     & 1.533500E+00,2.296300E+00,3.878200E+00,6.129400E+00,1.133000E+01,&
     & 1.268900E+01,2.929100E-06,1.307100E-05,6.861000E-05,2.865300E-04,&
     & 1.433400E-03,4.344200E-03,1.005300E-02,2.830100E-02,9.060500E-02,&
     & 2.052800E-01,2.730400E-01,4.757000E-01,8.713400E-01,1.446500E+00,&
     & 1.730500E+00,1.766600E+00,2.127200E-04,5.573300E-04,1.293300E-03,&
     & 2.610100E-03,4.894800E-03,9.576100E-03,2.209900E-02,5.229500E-02,&
     & 1.431400E-01,3.215300E-01,4.653000E-01,6.941500E-01,1.012300E+00,&
     & 1.429200E+00,1.731200E+00,1.974200E+00,3.686400E-04,9.362500E-04,&
     & 1.999500E-03,3.591700E-03,6.105600E-03,1.227700E-02,2.723900E-02,&
     & 6.627200E-02,1.922300E-01,4.626800E-01,6.541100E-01,9.547200E-01,&
     & 1.282900E+00,1.836200E+00,3.433000E+00,3.939800E+00,5.116500E-04,&
     & 1.282100E-03,2.475200E-03,4.118900E-03,7.206900E-03,1.399700E-02,&
     & 3.108000E-02,7.626300E-02,2.394300E-01,6.039200E-01,8.151300E-01,&
     & 1.092200E+00,1.740300E+00,2.749900E+00,5.136600E+00,5.891800E+00,&
     & 6.467700E-04,1.555900E-03,2.785800E-03,4.503100E-03,8.073700E-03,&
     & 1.516300E-02,3.397500E-02,8.388300E-02,2.864500E-01,7.163600E-01,&
     & 9.268200E-01,1.377600E+00,2.317200E+00,3.657900E+00,6.825700E+00,&
     & 7.819100E+00,7.761900E-04,1.751600E-03,2.910700E-03,4.887600E-03,&
     & 8.555500E-03,1.605300E-02,3.583100E-02,9.094100E-02,3.291100E-01,&
     & 8.067800E-01,1.140600E+00,1.719600E+00,2.890200E+00,4.556100E+00,&
     & 8.482500E+00,9.697600E+00,8.981400E-04,1.836400E-03,2.984700E-03,&
     & 5.108500E-03,8.693400E-03,1.679500E-02,3.649600E-02,9.888400E-02,&
     & 3.694500E-01,9.659600E-01,1.365300E+00,2.059400E+00,3.452800E+00,&
     & 5.428000E+00,1.006500E+01,1.146300E+01,1.089700E-03,1.711500E-03,&
     & 3.091200E-03,4.972800E-03,8.756000E-03,1.716300E-02,3.698900E-02,&
     & 1.087600E-01,4.207100E-01,1.124800E+00,1.582500E+00,2.390200E+00,&
     & 3.974400E+00,6.205000E+00,1.135600E+01,1.280400E+01,6.006400E-04,&
     & 1.216500E-03,2.324200E-03,3.939400E-03,7.189600E-03,1.492200E-02,&
     & 3.508600E-02,1.110200E-01,4.706100E-01,1.284800E+00,1.825200E+00,&
     & 2.752800E+00,4.633500E+00,7.315000E+00,1.365100E+01,1.563800E+01/
      data   absa(:,181:200) /                                          &
     & 1.241500E-06,4.500200E-06,1.935700E-05,8.621300E-05,6.092600E-04,&
     & 2.668800E-03,6.768900E-03,1.993200E-02,7.185000E-02,1.724100E-01,&
     & 2.236100E-01,3.324700E-01,7.120700E-01,1.355300E+00,1.738800E+00,&
     & 1.790500E+00,7.827700E-05,1.786900E-04,4.318800E-04,1.023500E-03,&
     & 2.352900E-03,4.805200E-03,1.190300E-02,2.890900E-02,8.961700E-02,&
     & 1.881500E-01,2.431800E-01,3.959400E-01,6.871100E-01,1.185900E+00,&
     & 1.521500E+00,1.566800E+00,1.377800E-04,3.111200E-04,6.976000E-04,&
     & 1.446300E-03,2.835500E-03,5.783200E-03,1.364800E-02,3.392900E-02,&
     & 1.035800E-01,2.208800E-01,3.153900E-01,4.905600E-01,8.324100E-01,&
     & 1.188900E+00,1.377200E+00,1.630600E+00,1.928400E-04,4.290600E-04,&
     & 9.188100E-04,1.693200E-03,3.079700E-03,6.479700E-03,1.457100E-02,&
     & 3.696300E-02,1.141700E-01,2.681000E-01,3.944300E-01,5.881300E-01,&
     & 8.652900E-01,1.282000E+00,1.964100E+00,2.442400E+00,2.474000E-04,&
     & 5.357000E-04,1.044400E-03,1.858600E-03,3.214900E-03,6.850200E-03,&
     & 1.509100E-02,3.859900E-02,1.241000E-01,3.222000E-01,4.571600E-01,&
     & 6.560700E-01,8.855000E-01,1.612600E+00,2.614000E+00,3.249900E+00,&
     & 3.042200E-04,6.632100E-04,1.086100E-03,1.889900E-03,3.340000E-03,&
     & 6.821800E-03,1.524900E-02,3.909000E-02,1.344500E-01,3.681000E-01,&
     & 5.010900E-01,6.803500E-01,1.040600E+00,2.013300E+00,3.257300E+00,&
     & 4.047800E+00,4.504600E-04,6.660600E-04,1.080800E-03,1.832500E-03,&
     & 3.391000E-03,6.524200E-03,1.496300E-02,3.810000E-02,1.450000E-01,&
     & 3.958500E-01,5.215400E-01,7.903200E-01,1.245100E+00,2.410000E+00,&
     & 3.885300E+00,4.823700E+00,5.509700E-04,8.008800E-04,1.052800E-03,&
     & 1.693100E-03,2.980100E-03,6.072200E-03,1.394100E-02,3.664700E-02,&
     & 1.528900E-01,4.347600E-01,6.067900E-01,9.184000E-01,1.440700E+00,&
     & 2.791700E+00,4.451500E+00,5.514100E+00,2.155700E-04,4.384500E-04,&
     & 7.620200E-04,1.216700E-03,2.268100E-03,4.675300E-03,1.107200E-02,&
     & 3.457000E-02,1.639300E-01,4.955900E-01,6.957100E-01,1.055700E+00,&
     & 1.667000E+00,3.225100E+00,5.228000E+00,6.499800E+00,1.590900E-06,&
     & 6.270900E-06,2.983300E-05,1.349700E-04,8.813100E-04,3.468800E-03,&
     & 8.588900E-03,2.522100E-02,9.116000E-02,2.192800E-01,2.878100E-01,&
     & 4.428200E-01,9.094400E-01,1.674600E+00,2.116900E+00,2.176300E+00,&
     & 9.752100E-05,2.352600E-04,5.654800E-04,1.363900E-03,3.019600E-03,&
     & 6.129700E-03,1.508000E-02,3.686700E-02,1.141100E-01,2.429700E-01,&
     & 3.245100E-01,5.120300E-01,8.841800E-01,1.465300E+00,1.852100E+00,&
     & 1.904100E+00,1.712500E-04,3.994600E-04,9.144000E-04,1.886700E-03,&
     & 3.635300E-03,7.323000E-03,1.739000E-02,4.318400E-02,1.321800E-01,&
     & 2.876200E-01,4.153600E-01,6.448600E-01,1.038400E+00,1.472200E+00,&
     & 1.796200E+00,2.165800E+00,2.385200E-04,5.482200E-04,1.200500E-03,&
     & 2.181300E-03,3.971800E-03,8.178200E-03,1.853000E-02,4.714700E-02,&
     & 1.461000E-01,3.490700E-01,5.063000E-01,7.715200E-01,1.095700E+00,&
     & 1.579000E+00,2.647000E+00,3.244000E+00,3.022100E-04,6.844600E-04,&
     & 1.360400E-03,2.373100E-03,4.131600E-03,8.632200E-03,1.922200E-02,&
     & 4.939400E-02,1.589000E-01,4.150600E-01,5.834400E-01,8.409000E-01,&
     & 1.161000E+00,2.013200E+00,3.523000E+00,4.316600E+00,3.656300E-04,&
     & 8.165000E-04,1.425600E-03,2.435200E-03,4.269400E-03,8.619500E-03,&
     & 1.947300E-02,5.006000E-02,1.719400E-01,4.691900E-01,6.385500E-01,&
     & 8.662800E-01,1.402900E+00,2.513300E+00,4.391500E+00,5.377100E+00,&
     & 4.652500E-04,8.984100E-04,1.394500E-03,2.375700E-03,4.303700E-03,&
     & 8.312600E-03,1.908400E-02,4.901600E-02,1.848700E-01,4.975600E-01,&
     & 6.729700E-01,1.017900E+00,1.678800E+00,3.007100E+00,5.239600E+00,&
     & 6.407100E+00,6.132000E-04,8.366100E-04,1.387200E-03,2.216900E-03,&
     & 3.901200E-03,7.854000E-03,1.776400E-02,4.737900E-02,1.944000E-01,&
     & 5.522200E-01,7.826600E-01,1.184100E+00,1.942900E+00,3.479500E+00,&
     & 6.011700E+00,7.324700E+00,2.598700E-04,5.325000E-04,9.442100E-04,&
     & 1.570700E-03,2.939200E-03,5.938500E-03,1.383300E-02,4.495900E-02,&
     & 2.089900E-01,6.288400E-01,8.972600E-01,1.358900E+00,2.247200E+00,&
     & 4.026200E+00,7.046000E+00,8.633200E+00,2.142300E-06,8.921500E-06,&
     & 4.557800E-05,2.046900E-04,1.230300E-03,4.405800E-03,1.067900E-02,&
     & 3.123200E-02,1.126600E-01,2.726500E-01,3.615900E-01,5.691200E-01,&
     & 1.121700E+00,2.007100E+00,2.504100E+00,2.570200E+00,1.216300E-04,&
     & 3.051500E-04,7.273000E-04,1.768400E-03,3.806600E-03,7.663000E-03,&
     & 1.874500E-02,4.582400E-02,1.416300E-01,3.060700E-01,4.191500E-01,&
     & 6.390000E-01,1.105100E+00,1.756300E+00,2.190900E+00,2.248800E+00/
      data   absa(:,201:220) /                                          &
     & 2.088100E-04,5.100700E-04,1.176200E-03,2.397000E-03,4.578700E-03,&
     & 9.101300E-03,2.159900E-02,5.377300E-02,1.645200E-01,3.648300E-01,&
     & 5.270700E-01,8.224700E-01,1.255000E+00,1.764400E+00,2.311000E+00,&
     & 2.767100E+00,2.912900E-04,6.905300E-04,1.526900E-03,2.767900E-03,&
     & 4.963100E-03,1.014700E-02,2.303900E-02,5.891800E-02,1.821600E-01,&
     & 4.437000E-01,6.297600E-01,9.672700E-01,1.367700E+00,1.892600E+00,&
     & 3.455300E+00,4.144600E+00,3.662500E-04,8.573900E-04,1.732900E-03,&
     & 2.981600E-03,5.197200E-03,1.066700E-02,2.392400E-02,6.182600E-02,&
     & 1.985600E-01,5.176100E-01,7.267400E-01,1.036900E+00,1.477000E+00,&
     & 2.470500E+00,4.598600E+00,5.514500E+00,4.390800E-04,1.009200E-03,&
     & 1.816800E-03,3.054900E-03,5.364500E-03,1.068000E-02,2.426800E-02,&
     & 6.262600E-02,2.150400E-01,5.769000E-01,7.974000E-01,1.069800E+00,&
     & 1.815400E+00,3.082600E+00,5.730800E+00,6.869200E+00,5.252400E-04,&
     & 1.099700E-03,1.775100E-03,3.009800E-03,5.380400E-03,1.035500E-02,&
     & 2.380700E-02,6.139900E-02,2.309300E-01,6.053000E-01,8.498500E-01,&
     & 1.270600E+00,2.173800E+00,3.688000E+00,6.840500E+00,8.186200E+00,&
     & 7.142200E-04,9.511800E-04,1.693500E-03,2.879800E-03,4.926300E-03,&
     & 9.854300E-03,2.209000E-02,5.964300E-02,2.425500E-01,6.786600E-01,&
     & 9.893800E-01,1.478500E+00,2.518200E+00,4.263000E+00,7.847300E+00,&
     & 9.358400E+00,3.185300E-04,6.412300E-04,1.165200E-03,1.980200E-03,&
     & 3.698300E-03,7.382800E-03,1.733500E-02,5.635800E-02,2.617900E-01,&
     & 7.729000E-01,1.132500E+00,1.695900E+00,2.907700E+00,4.940400E+00,&
     & 9.197200E+00,1.102900E+01,2.953800E-06,1.281400E-05,6.791500E-05,&
     & 3.011800E-04,1.661900E-03,5.511500E-03,1.305500E-02,3.791100E-02,&
     & 1.364200E-01,3.328800E-01,4.441600E-01,7.093100E-01,1.346000E+00,&
     & 2.346100E+00,2.891500E+00,2.965200E+00,1.507200E-04,3.918800E-04,&
     & 9.222700E-04,2.241200E-03,4.736300E-03,9.436100E-03,2.282800E-02,&
     & 5.589000E-02,1.724900E-01,3.761000E-01,5.245200E-01,7.806900E-01,&
     & 1.342900E+00,2.053900E+00,2.530100E+00,2.594100E+00,2.541600E-04,&
     & 6.441800E-04,1.483900E-03,2.995200E-03,5.666200E-03,1.116300E-02,&
     & 2.630300E-02,6.583500E-02,2.007800E-01,4.516600E-01,6.501700E-01,&
     & 1.015300E+00,1.488700E+00,2.062300E+00,2.913600E+00,3.429100E+00,&
     & 3.525500E-04,8.612000E-04,1.896400E-03,3.451400E-03,6.125300E-03,&
     & 1.238500E-02,2.813600E-02,7.231700E-02,2.229700E-01,5.466200E-01,&
     & 7.688000E-01,1.172600E+00,1.656700E+00,2.262800E+00,4.364000E+00,&
     & 5.137000E+00,4.406300E-04,1.061800E-03,2.154000E-03,3.705500E-03,&
     & 6.422500E-03,1.298600E-02,2.923000E-02,7.582000E-02,2.439600E-01,&
     & 6.295100E-01,8.865800E-01,1.242300E+00,1.820600E+00,3.010700E+00,&
     & 5.810100E+00,6.834600E+00,5.215600E-04,1.243000E-03,2.258000E-03,&
     & 3.767500E-03,6.656000E-03,1.301000E-02,2.968500E-02,7.676900E-02,&
     & 2.643300E-01,6.986500E-01,9.627000E-01,1.304300E+00,2.260900E+00,&
     & 3.756200E+00,7.241800E+00,8.511500E+00,6.063900E-04,1.332700E-03,&
     & 2.228400E-03,3.735800E-03,6.605100E-03,1.266200E-02,2.917000E-02,&
     & 7.540800E-02,2.834700E-01,7.297300E-01,1.039900E+00,1.560400E+00,&
     & 2.708200E+00,4.491800E+00,8.644700E+00,1.014200E+01,7.482000E-04,&
     & 1.236000E-03,2.076800E-03,3.568100E-03,6.084400E-03,1.209900E-02,&
     & 2.704600E-02,7.361100E-02,2.975300E-01,8.284200E-01,1.212500E+00,&
     & 1.814600E+00,3.142500E+00,5.185000E+00,9.918400E+00,1.159000E+01,&
     & 3.868600E-04,7.683000E-04,1.418700E-03,2.452400E-03,4.548200E-03,&
     & 9.080300E-03,2.137200E-02,6.949800E-02,3.221300E-01,9.457500E-01,&
     & 1.384600E+00,2.082900E+00,3.619900E+00,6.020300E+00,1.162000E+01,&
     & 1.366900E+01,4.080800E-06,1.837600E-05,9.823200E-05,4.317800E-04,&
     & 2.168100E-03,6.786200E-03,1.575100E-02,4.522500E-02,1.623900E-01,&
     & 3.991500E-01,5.339400E-01,8.594900E-01,1.579500E+00,2.683200E+00,&
     & 3.265500E+00,3.344200E+00,1.849200E-04,4.986500E-04,1.161400E-03,&
     & 2.769200E-03,5.827300E-03,1.148200E-02,2.727100E-02,6.720300E-02,&
     & 2.066000E-01,4.519500E-01,6.363800E-01,9.382500E-01,1.588100E+00,&
     & 2.356900E+00,2.857400E+00,2.926000E+00,3.079300E-04,8.064400E-04,&
     & 1.841700E-03,3.669900E-03,6.880800E-03,1.356300E-02,3.154700E-02,&
     & 7.932200E-02,2.411400E-01,5.470700E-01,7.840700E-01,1.210500E+00,&
     & 1.751700E+00,2.357800E+00,3.566000E+00,4.222500E+00,4.215500E-04,&
     & 1.067000E-03,2.316200E-03,4.250700E-03,7.438900E-03,1.494200E-02,&
     & 3.383300E-02,8.705800E-02,2.689400E-01,6.610300E-01,9.219700E-01,&
     & 1.382900E+00,1.932400E+00,2.726600E+00,5.343800E+00,6.323100E+00/
      data   absa(:,221:240) /                                          &
     & 5.263000E-04,1.303800E-03,2.633300E-03,4.534100E-03,7.826900E-03,&
     & 1.558800E-02,3.520400E-02,9.139400E-02,2.948400E-01,7.577300E-01,&
     & 1.057200E+00,1.459200E+00,2.185900E+00,3.630600E+00,7.112300E+00,&
     & 8.411700E+00,6.189200E-04,1.504300E-03,2.767800E-03,4.590400E-03,&
     & 8.120400E-03,1.564300E-02,3.570700E-02,9.272800E-02,3.195800E-01,&
     & 8.389100E-01,1.132800E+00,1.574800E+00,2.728400E+00,4.529200E+00,&
     & 8.867500E+00,1.047300E+01,7.082000E-04,1.604900E-03,2.727800E-03,&
     & 4.560600E-03,8.016600E-03,1.526100E-02,3.518100E-02,9.129000E-02,&
     & 3.420700E-01,8.709700E-01,1.255500E+00,1.887000E+00,3.269400E+00,&
     & 5.414600E+00,1.058300E+01,1.247300E+01,8.004900E-04,1.543200E-03,&
     & 2.534300E-03,4.349700E-03,7.400300E-03,1.462700E-02,3.265400E-02,&
     & 8.946700E-02,3.595800E-01,1.000500E+00,1.461100E+00,2.193800E+00,&
     & 3.797100E+00,6.248000E+00,1.215200E+01,1.422600E+01,4.625700E-04,&
     & 9.131400E-04,1.713500E-03,2.990400E-03,5.495000E-03,1.102600E-02,&
     & 2.602900E-02,8.454500E-02,3.909500E-01,1.140400E+00,1.671100E+00,&
     & 2.518900E+00,4.367600E+00,7.259500E+00,1.422400E+01,1.682300E+01,&
     & 1.727600E-06,5.789200E-06,2.408700E-05,1.122400E-04,8.331900E-04,&
     & 3.572400E-03,9.209400E-03,2.766800E-02,1.114000E-01,2.977800E-01,&
     & 3.915400E-01,5.250900E-01,1.102300E+00,2.179800E+00,2.865700E+00,&
     & 2.965900E+00,6.306600E-05,1.466300E-04,3.602300E-04,9.624800E-04,&
     & 2.454100E-03,5.437000E-03,1.372400E-02,3.484200E-02,1.214400E-01,&
     & 2.896700E-01,3.696000E-01,5.172100E-01,9.752600E-01,1.907600E+00,&
     & 2.507700E+00,2.595700E+00,1.098500E-04,2.406500E-04,5.762000E-04,&
     & 1.348600E-03,2.930900E-03,6.029400E-03,1.503600E-02,3.814700E-02,&
     & 1.321800E-01,2.924200E-01,3.666000E-01,5.737800E-01,1.061700E+00,&
     & 1.663400E+00,2.149500E+00,2.225100E+00,1.504300E-04,3.306400E-04,&
     & 7.477500E-04,1.565100E-03,3.123900E-03,6.391400E-03,1.537100E-02,&
     & 3.971900E-02,1.371800E-01,2.907600E-01,4.082600E-01,6.338400E-01,&
     & 1.100800E+00,1.661000E+00,1.942600E+00,2.419200E+00,1.879200E-04,&
     & 4.113500E-04,8.900700E-04,1.673900E-03,3.123200E-03,6.604700E-03,&
     & 1.510600E-02,4.005600E-02,1.365300E-01,3.160600E-01,4.612300E-01,&
     & 6.969200E-01,1.065100E+00,1.612600E+00,2.550900E+00,3.221200E+00,&
     & 2.254700E-04,4.816900E-04,9.542900E-04,1.721700E-03,3.030400E-03,&
     & 6.523200E-03,1.447300E-02,3.907300E-02,1.340200E-01,3.521600E-01,&
     & 5.008400E-01,7.341900E-01,1.017800E+00,1.808600E+00,3.182700E+00,&
     & 4.019100E+00,2.727800E-04,5.837900E-04,9.176400E-04,1.620000E-03,&
     & 2.895300E-03,6.027700E-03,1.353200E-02,3.662500E-02,1.317400E-01,&
     & 3.751400E-01,5.215400E-01,7.186400E-01,1.083600E+00,2.168100E+00,&
     & 3.806900E+00,4.805500E+00,4.002900E-04,5.771000E-04,8.463600E-04,&
     & 1.381200E-03,2.623200E-03,5.066100E-03,1.202000E-02,3.205500E-02,&
     & 1.294600E-01,3.636000E-01,5.272800E-01,7.931700E-01,1.259000E+00,&
     & 2.521200E+00,4.397300E+00,5.543200E+00,1.562500E-04,3.181400E-04,&
     & 5.795900E-04,9.302400E-04,1.685400E-03,3.153000E-03,8.167000E-03,&
     & 2.402600E-02,1.267700E-01,4.028600E-01,6.032000E-01,9.086600E-01,&
     & 1.447400E+00,2.895500E+00,5.101700E+00,6.442400E+00,2.118900E-06,&
     & 7.969000E-06,3.713900E-05,1.778800E-04,1.203800E-03,4.718200E-03,&
     & 1.198600E-02,3.552500E-02,1.442000E-01,3.836400E-01,5.127500E-01,&
     & 7.095700E-01,1.446400E+00,2.756800E+00,3.565600E+00,3.683200E+00,&
     & 8.047600E-05,1.959000E-04,4.823200E-04,1.297900E-03,3.254400E-03,&
     & 7.138200E-03,1.763400E-02,4.507300E-02,1.582700E-01,3.734700E-01,&
     & 4.855600E-01,6.962500E-01,1.281900E+00,2.412400E+00,3.120000E+00,&
     & 3.222300E+00,1.366400E-04,3.204100E-04,7.656400E-04,1.796300E-03,&
     & 3.839700E-03,7.836500E-03,1.936500E-02,4.955300E-02,1.711900E-01,&
     & 3.838400E-01,4.973200E-01,7.663800E-01,1.374800E+00,2.131900E+00,&
     & 2.674200E+00,2.761600E+00,1.884100E-04,4.322200E-04,9.934100E-04,&
     & 2.062100E-03,4.074000E-03,8.270600E-03,1.983400E-02,5.163000E-02,&
     & 1.777600E-01,3.840200E-01,5.478800E-01,8.582100E-01,1.407800E+00,&
     & 2.089000E+00,2.585700E+00,3.305700E+00,2.349200E-04,5.333400E-04,&
     & 1.178100E-03,2.201300E-03,4.083500E-03,8.505300E-03,1.951600E-02,&
     & 5.202600E-02,1.774200E-01,4.181100E-01,6.069900E-01,9.331400E-01,&
     & 1.385700E+00,2.037900E+00,3.417500E+00,4.402600E+00,2.788800E-04,&
     & 6.205600E-04,1.266500E-03,2.237700E-03,3.987900E-03,8.349500E-03,&
     & 1.875000E-02,5.081800E-02,1.745400E-01,4.614100E-01,6.533300E-01,&
     & 9.624400E-01,1.347600E+00,2.340200E+00,4.265000E+00,5.493100E+00/
      data   absa(:,241:260) /                                          &
     & 3.223600E-04,7.175100E-04,1.233000E-03,2.127800E-03,3.775300E-03,&
     & 7.728200E-03,1.760200E-02,4.772800E-02,1.713400E-01,4.890800E-01,&
     & 6.741800E-01,9.291100E-01,1.488200E+00,2.804500E+00,5.102100E+00,&
     & 6.566600E+00,4.605700E-04,6.675800E-04,1.091800E-03,1.880900E-03,&
     & 3.408200E-03,6.619800E-03,1.559300E-02,4.193500E-02,1.676000E-01,&
     & 4.693700E-01,6.864800E-01,1.041000E+00,1.730400E+00,3.259200E+00,&
     & 5.896200E+00,7.576800E+00,1.965300E-04,3.906700E-04,7.268800E-04,&
     & 1.204200E-03,2.146800E-03,4.140700E-03,1.051100E-02,3.162700E-02,&
     & 1.639900E-01,5.234900E-01,7.858000E-01,1.191500E+00,1.987500E+00,&
     & 3.746400E+00,6.835000E+00,8.805100E+00,2.791700E-06,1.132300E-05,&
     & 5.783600E-05,2.734000E-04,1.685200E-03,6.115000E-03,1.518000E-02,&
     & 4.468900E-02,1.812400E-01,4.819600E-01,6.514100E-01,9.289200E-01,&
     & 1.830800E+00,3.365300E+00,4.280700E+00,4.411600E+00,1.020000E-04,&
     & 2.600400E-04,6.345700E-04,1.714800E-03,4.199000E-03,9.198100E-03,&
     & 2.206700E-02,5.677600E-02,2.000200E-01,4.736600E-01,6.212800E-01,&
     & 9.064700E-01,1.624200E+00,2.944700E+00,3.745800E+00,3.860400E+00,&
     & 1.695400E-04,4.191400E-04,9.948200E-04,2.332300E-03,4.921700E-03,&
     & 9.943000E-03,2.439300E-02,6.256000E-02,2.158900E-01,4.880500E-01,&
     & 6.513000E-01,9.942100E-01,1.715500E+00,2.649400E+00,3.210500E+00,&
     & 3.309600E+00,2.314100E-04,5.585500E-04,1.290200E-03,2.661900E-03,&
     & 5.194500E-03,1.046400E-02,2.496300E-02,6.541300E-02,2.238900E-01,&
     & 4.974700E-01,7.071200E-01,1.118000E+00,1.745600E+00,2.526000E+00,&
     & 3.389100E+00,4.323800E+00,2.896100E-04,6.814000E-04,1.523500E-03,&
     & 2.823800E-03,5.232500E-03,1.067100E-02,2.459600E-02,6.604100E-02,&
     & 2.242300E-01,5.376100E-01,7.720200E-01,1.191200E+00,1.767500E+00,&
     & 2.477400E+00,4.492900E+00,5.758900E+00,3.414300E-04,7.898900E-04,&
     & 1.628400E-03,2.863100E-03,5.073800E-03,1.048200E-02,2.368000E-02,&
     & 6.456800E-02,2.212700E-01,5.813800E-01,8.330300E-01,1.207400E+00,&
     & 1.723700E+00,2.946400E+00,5.608200E+00,7.185200E+00,3.902300E-04,&
     & 8.885200E-04,1.598300E-03,2.728400E-03,4.791800E-03,9.693100E-03,&
     & 2.227400E-02,6.072100E-02,2.171100E-01,6.123900E-01,8.531400E-01,&
     & 1.160600E+00,1.955400E+00,3.530000E+00,6.710000E+00,8.590500E+00,&
     & 4.835200E-04,8.877500E-04,1.400500E-03,2.418300E-03,4.293900E-03,&
     & 8.386800E-03,1.975000E-02,5.325200E-02,2.120400E-01,5.866200E-01,&
     & 8.695300E-01,1.321400E+00,2.276000E+00,4.098000E+00,7.761600E+00,&
     & 9.913800E+00,2.394700E-04,4.831000E-04,8.911000E-04,1.521700E-03,&
     & 2.682500E-03,5.333100E-03,1.312400E-02,4.042100E-02,2.079300E-01,&
     & 6.589000E-01,9.931500E-01,1.514400E+00,2.609400E+00,4.717800E+00,&
     & 8.985700E+00,1.151800E+01,3.816800E-06,1.635800E-05,8.782700E-05,&
     & 4.095900E-04,2.305500E-03,7.744700E-03,1.887900E-02,5.512200E-02,&
     & 2.224800E-01,5.900400E-01,8.111200E-01,1.174900E+00,2.245300E+00,&
     & 3.998000E+00,5.017000E+00,5.162800E+00,1.281100E-04,3.405300E-04,&
     & 8.302900E-04,2.233100E-03,5.287400E-03,1.149400E-02,2.727200E-02,&
     & 7.018700E-02,2.463600E-01,5.924600E-01,7.698900E-01,1.143200E+00,&
     & 1.997500E+00,3.498100E+00,4.389300E+00,4.516700E+00,2.105400E-04,&
     & 5.404400E-04,1.277600E-03,2.967800E-03,6.188600E-03,1.244500E-02,&
     & 3.006800E-02,7.737100E-02,2.660900E-01,6.069800E-01,8.219300E-01,&
     & 1.256000E+00,2.078100E+00,3.208100E+00,3.766700E+00,3.853000E+00,&
     & 2.837000E-04,7.130500E-04,1.636500E-03,3.379900E-03,6.514800E-03,&
     & 1.302400E-02,3.082100E-02,8.116600E-02,2.759400E-01,6.253500E-01,&
     & 8.849200E-01,1.397700E+00,2.129500E+00,2.975900E+00,4.337800E+00,&
     & 5.459800E+00,3.521700E-04,8.608800E-04,1.921400E-03,3.573600E-03,&
     & 6.553300E-03,1.320700E-02,3.041100E-02,8.206000E-02,2.771500E-01,&
     & 6.712500E-01,9.607300E-01,1.468600E+00,2.182800E+00,2.969400E+00,&
     & 5.773800E+00,7.271100E+00,4.138500E-04,9.876500E-04,2.053800E-03,&
     & 3.592800E-03,6.361400E-03,1.289400E-02,2.935500E-02,8.020000E-02,&
     & 2.747900E-01,7.143200E-01,1.036200E+00,1.469100E+00,2.132700E+00,&
     & 3.644100E+00,7.208700E+00,9.072200E+00,4.678000E-04,1.097400E-03,&
     & 2.018100E-03,3.427100E-03,5.994900E-03,1.194600E-02,2.761600E-02,&
     & 7.528900E-02,2.701700E-01,7.492600E-01,1.044300E+00,1.428100E+00,&
     & 2.465200E+00,4.364300E+00,8.627000E+00,1.084600E+01,5.325300E-04,&
     & 1.100000E-03,1.767500E-03,3.055200E-03,5.344000E-03,1.039500E-02,&
     & 2.453900E-02,6.610700E-02,2.628300E-01,7.262700E-01,1.066600E+00,&
     & 1.646200E+00,2.871300E+00,5.063300E+00,9.983700E+00,1.251500E+01/
      data   absa(:,261:280) /                                          &
     & 2.942100E-04,5.794800E-04,1.091200E-03,1.884300E-03,3.299000E-03,&
     & 6.692100E-03,1.613700E-02,5.071100E-02,2.585600E-01,8.220200E-01,&
     & 1.215900E+00,1.887600E+00,3.289300E+00,5.836400E+00,1.154800E+01,&
     & 1.454200E+01,5.279900E-06,2.377500E-05,1.295100E-04,5.962000E-04,&
     & 3.055000E-03,9.679600E-03,2.311800E-02,6.667400E-02,2.677400E-01,&
     & 7.122500E-01,9.862800E-01,1.444200E+00,2.683600E+00,4.637100E+00,&
     & 5.740300E+00,5.896800E+00,1.589300E-04,4.408900E-04,1.072500E-03,&
     & 2.832800E-03,6.559200E-03,1.419000E-02,3.304900E-02,8.524700E-02,&
     & 2.974800E-01,7.233600E-01,9.359600E-01,1.401600E+00,2.398600E+00,&
     & 4.056900E+00,5.022600E+00,5.160200E+00,2.591000E-04,6.908200E-04,&
     & 1.620600E-03,3.700800E-03,7.679500E-03,1.533000E-02,3.638200E-02,&
     & 9.418400E-02,3.218300E-01,7.396900E-01,1.006500E+00,1.548000E+00,&
     & 2.457700E+00,3.767600E+00,4.372500E+00,4.505400E+00,3.451700E-04,&
     & 9.014800E-04,2.055400E-03,4.197200E-03,8.059100E-03,1.596700E-02,&
     & 3.741900E-02,9.874100E-02,3.345000E-01,7.629900E-01,1.084000E+00,&
     & 1.692200E+00,2.556700E+00,3.423100E+00,5.398400E+00,6.752700E+00,&
     & 4.243400E-04,1.078300E-03,2.376800E-03,4.433000E-03,8.042600E-03,&
     & 1.615800E-02,3.701900E-02,9.989100E-02,3.367500E-01,8.224800E-01,&
     & 1.168700E+00,1.762100E+00,2.587700E+00,3.572400E+00,7.193600E+00,&
     & 8.993500E+00,4.984200E-04,1.223600E-03,2.536900E-03,4.452500E-03,&
     & 7.825600E-03,1.566100E-02,3.579000E-02,9.770200E-02,3.349900E-01,&
     & 8.695100E-01,1.248900E+00,1.756400E+00,2.566300E+00,4.446500E+00,&
     & 8.977400E+00,1.121800E+01,5.572800E-04,1.340900E-03,2.500400E-03,&
     & 4.218500E-03,7.418500E-03,1.449200E-02,3.362800E-02,9.166000E-02,&
     & 3.300600E-01,9.067900E-01,1.247400E+00,1.732100E+00,3.010400E+00,&
     & 5.324500E+00,1.074700E+01,1.340900E+01,6.119500E-04,1.331700E-03,&
     & 2.204700E-03,3.771100E-03,6.541200E-03,1.267400E-02,2.991500E-02,&
     & 8.078400E-02,3.202000E-01,8.799100E-01,1.298300E+00,2.010500E+00,&
     & 3.506400E+00,6.174700E+00,1.244000E+01,1.545700E+01,3.497800E-04,&
     & 6.962700E-04,1.322200E-03,2.298800E-03,4.017000E-03,8.249800E-03,&
     & 1.903200E-02,6.332100E-02,3.168000E-01,1.000300E+00,1.479600E+00,&
     & 2.304800E+00,4.016100E+00,7.118600E+00,1.438700E+01,1.798700E+01,&
     & 2.614100E-06,8.009100E-06,3.161000E-05,1.534400E-04,1.203000E-03,&
     & 4.961600E-03,1.318000E-02,4.005600E-02,1.773200E-01,5.298300E-01,&
     & 6.981100E-01,9.184900E-01,1.778800E+00,3.650000E+00,4.911300E+00,&
     & 5.122000E+00,5.166200E-05,1.260500E-04,3.073600E-04,9.231600E-04,&
     & 2.789500E-03,6.612100E-03,1.667200E-02,4.489800E-02,1.753400E-01,&
     & 4.870900E-01,6.240400E-01,8.062400E-01,1.556500E+00,3.194000E+00,&
     & 4.297400E+00,4.457800E+00,8.724900E-05,1.971600E-04,4.809900E-04,&
     & 1.277300E-03,3.193200E-03,6.841600E-03,1.759200E-02,4.597100E-02,&
     & 1.780300E-01,4.481300E-01,5.743100E-01,7.905000E-01,1.429600E+00,&
     & 2.737700E+00,3.683500E+00,3.841200E+00,1.209900E-04,2.563500E-04,&
     & 6.187500E-04,1.500000E-03,3.308500E-03,6.810100E-03,1.745800E-02,&
     & 4.535200E-02,1.771400E-01,4.188300E-01,5.259600E-01,7.567500E-01,&
     & 1.454100E+00,2.352100E+00,3.069700E+00,3.184700E+00,1.482000E-04,&
     & 3.169700E-04,7.242500E-04,1.610200E-03,3.249700E-03,6.676800E-03,&
     & 1.651300E-02,4.365900E-02,1.702200E-01,3.871000E-01,5.021900E-01,&
     & 7.617800E-01,1.380900E+00,2.200500E+00,2.615300E+00,3.136700E+00,&
     & 1.738600E-04,3.672700E-04,8.071400E-04,1.612700E-03,3.037300E-03,&
     & 6.369600E-03,1.505800E-02,4.074700E-02,1.570200E-01,3.591000E-01,&
     & 5.101100E-01,7.813300E-01,1.248200E+00,1.922600E+00,3.109100E+00,&
     & 3.917000E+00,1.997300E-04,4.106400E-04,8.276500E-04,1.511500E-03,&
     & 2.686000E-03,5.814100E-03,1.309500E-02,3.655400E-02,1.382100E-01,&
     & 3.519800E-01,5.228900E-01,7.760800E-01,1.100900E+00,1.895100E+00,&
     & 3.725100E+00,4.691500E+00,2.882300E-04,4.323400E-04,7.139700E-04,&
     & 1.237700E-03,2.249100E-03,4.673300E-03,1.065000E-02,3.020500E-02,&
     & 1.172600E-01,3.436400E-01,4.994600E-01,6.911600E-01,1.085200E+00,&
     & 2.203200E+00,4.323900E+00,5.441700E+00,1.246200E-04,2.415000E-04,&
     & 4.262700E-04,7.076400E-04,1.350700E-03,2.522700E-03,5.464200E-03,&
     & 1.819600E-02,9.262400E-02,3.270800E-01,5.022800E-01,7.799100E-01,&
     & 1.244200E+00,2.522400E+00,4.978300E+00,6.273400E+00,3.045100E-06,&
     & 1.077600E-05,4.873400E-05,2.439800E-04,1.756100E-03,6.695400E-03,&
     & 1.743400E-02,5.218500E-02,2.347700E-01,6.982000E-01,9.325700E-01,&
     & 1.241300E+00,2.410000E+00,4.738000E+00,6.256200E+00,6.514600E+00/
      data   absa(:,281:300) /                                          &
     & 6.690300E-05,1.703400E-04,4.235200E-04,1.280900E-03,3.736600E-03,&
     & 8.818900E-03,2.212500E-02,5.863300E-02,2.331600E-01,6.418200E-01,&
     & 8.343000E-01,1.091800E+00,2.108900E+00,4.146000E+00,5.474300E+00,&
     & 5.700500E+00,1.109900E-04,2.658900E-04,6.547300E-04,1.747700E-03,&
     & 4.198900E-03,9.177800E-03,2.317400E-02,6.048000E-02,2.366400E-01,&
     & 5.977300E-01,7.675100E-01,1.076900E+00,1.924600E+00,3.553500E+00,&
     & 4.692000E+00,4.885200E+00,1.507900E-04,3.471500E-04,8.390900E-04,&
     & 2.034700E-03,4.378000E-03,9.128100E-03,2.283500E-02,6.008500E-02,&
     & 2.340300E-01,5.619900E-01,7.136000E-01,1.042000E+00,1.936300E+00,&
     & 3.074600E+00,3.910200E+00,4.072000E+00,1.877900E-04,4.206200E-04,&
     & 9.803600E-04,2.152200E-03,4.327500E-03,8.893900E-03,2.161100E-02,&
     & 5.787400E-02,2.249700E-01,5.158500E-01,6.835300E-01,1.060800E+00,&
     & 1.818500E+00,2.856000E+00,3.433400E+00,4.422400E+00,2.174600E-04,&
     & 4.858300E-04,1.091900E-03,2.131100E-03,4.045400E-03,8.419600E-03,&
     & 1.972900E-02,5.408000E-02,2.077100E-01,4.819800E-01,6.881300E-01,&
     & 1.072600E+00,1.663600E+00,2.486200E+00,4.181200E+00,5.523700E+00,&
     & 2.453200E-04,5.375700E-04,1.119500E-03,1.995000E-03,3.582300E-03,&
     & 7.647800E-03,1.718100E-02,4.854600E-02,1.828500E-01,4.753800E-01,&
     & 6.935800E-01,1.040400E+00,1.481900E+00,2.532500E+00,5.009500E+00,&
     & 6.615100E+00,2.879100E-04,5.955100E-04,9.562100E-04,1.666900E-03,&
     & 2.996200E-03,6.122700E-03,1.411700E-02,4.007200E-02,1.552100E-01,&
     & 4.559300E-01,6.601800E-01,9.131800E-01,1.512400E+00,2.949800E+00,&
     & 5.816800E+00,7.674400E+00,1.568600E-04,2.972500E-04,5.500900E-04,&
     & 9.177400E-04,1.742400E-03,3.212900E-03,7.137500E-03,2.406000E-02,&
     & 1.231200E-01,4.283800E-01,6.720000E-01,1.035800E+00,1.732400E+00,&
     & 3.379000E+00,6.695800E+00,8.844700E+00,3.882100E-06,1.518900E-05,&
     & 7.577700E-05,3.805800E-04,2.469500E-03,8.902300E-03,2.256600E-02,&
     & 6.643400E-02,3.005400E-01,8.916600E-01,1.198400E+00,1.644400E+00,&
     & 3.131900E+00,5.909900E+00,7.660400E+00,7.964200E+00,8.623400E-05,&
     & 2.295900E-04,5.718900E-04,1.747700E-03,4.864100E-03,1.158400E-02,&
     & 2.827400E-02,7.512200E-02,2.994700E-01,8.201100E-01,1.075500E+00,&
     & 1.450000E+00,2.740500E+00,5.171300E+00,6.703100E+00,6.967900E+00,&
     & 1.415500E-04,3.547600E-04,8.698200E-04,2.344000E-03,5.489000E-03,&
     & 1.198400E-02,2.951900E-02,7.754400E-02,3.037100E-01,7.752000E-01,&
     & 9.966000E-01,1.420900E+00,2.500300E+00,4.432600E+00,5.745300E+00,&
     & 5.971500E+00,1.881700E-04,4.596400E-04,1.108500E-03,2.682900E-03,&
     & 5.704600E-03,1.189900E-02,2.909300E-02,7.721600E-02,2.998900E-01,&
     & 7.219500E-01,9.400800E-01,1.392900E+00,2.463600E+00,3.903800E+00,&
     & 4.788000E+00,4.977200E+00,2.307900E-04,5.542600E-04,1.294100E-03,&
     & 2.803900E-03,5.626600E-03,1.144600E-02,2.759200E-02,7.458400E-02,&
     & 2.879700E-01,6.697700E-01,8.976000E-01,1.420000E+00,2.311100E+00,&
     & 3.534100E+00,4.484400E+00,5.935200E+00,2.714200E-04,6.304900E-04,&
     & 1.433200E-03,2.755500E-03,5.245600E-03,1.083000E-02,2.517700E-02,&
     & 6.985800E-02,2.659600E-01,6.290800E-01,8.990600E-01,1.399200E+00,&
     & 2.165200E+00,3.082300E+00,5.506300E+00,7.411600E+00,3.036200E-04,&
     & 6.932800E-04,1.459500E-03,2.587600E-03,4.675500E-03,9.722300E-03,&
     & 2.203200E-02,6.270300E-02,2.347600E-01,6.172000E-01,8.963100E-01,&
     & 1.332100E+00,1.911400E+00,3.293000E+00,6.597500E+00,8.877500E+00,&
     & 3.342400E-04,7.390200E-04,1.266600E-03,2.176300E-03,3.869400E-03,&
     & 7.793500E-03,1.818500E-02,5.178800E-02,1.994500E-01,5.835800E-01,&
     & 8.401600E-01,1.174000E+00,2.008000E+00,3.833300E+00,7.662800E+00,&
     & 1.029800E+01,1.930900E-04,3.680200E-04,6.893000E-04,1.158600E-03,&
     & 2.197000E-03,4.007100E-03,9.308400E-03,3.050700E-02,1.592900E-01,&
     & 5.487600E-01,8.624700E-01,1.338800E+00,2.298200E+00,4.394900E+00,&
     & 8.817800E+00,1.187000E+01,5.216800E-06,2.200700E-05,1.175800E-04,&
     & 5.773900E-04,3.403600E-03,1.138200E-02,2.865300E-02,8.323900E-02,&
     & 3.745900E-01,1.104800E+00,1.506100E+00,2.112200E+00,3.936000E+00,&
     & 7.140600E+00,9.101800E+00,9.445400E+00,1.099000E-04,3.065700E-04,&
     & 7.663500E-04,2.334900E-03,6.257200E-03,1.488300E-02,3.532100E-02,&
     & 9.408900E-02,3.749500E-01,1.015000E+00,1.355500E+00,1.866900E+00,&
     & 3.444000E+00,6.248000E+00,7.964300E+00,8.265000E+00,1.787900E-04,&
     & 4.669200E-04,1.142800E-03,3.069800E-03,7.024700E-03,1.534000E-02,&
     & 3.678000E-02,9.731200E-02,3.793700E-01,9.749300E-01,1.270400E+00,&
     & 1.804000E+00,3.159800E+00,5.356100E+00,6.826800E+00,7.084700E+00/
      data   absa(:,301:320) /                                          &
     & 2.348800E-04,5.998300E-04,1.443100E-03,3.447000E-03,7.318200E-03,&
     & 1.507700E-02,3.628700E-02,9.700000E-02,3.746500E-01,9.055500E-01,&
     & 1.200900E+00,1.804900E+00,3.037200E+00,4.793600E+00,5.733100E+00,&
     & 5.904700E+00,2.858500E-04,7.132200E-04,1.672300E-03,3.579000E-03,&
     & 7.122000E-03,1.457200E-02,3.443400E-02,9.388500E-02,3.591500E-01,&
     & 8.526100E-01,1.141800E+00,1.818800E+00,2.874700E+00,4.229000E+00,&
     & 5.749800E+00,7.653700E+00,3.313800E-04,8.091300E-04,1.835900E-03,&
     & 3.533100E-03,6.659500E-03,1.361300E-02,3.153500E-02,8.807600E-02,&
     & 3.323500E-01,7.949600E-01,1.146900E+00,1.757000E+00,2.733400E+00,&
     & 3.729600E+00,7.085400E+00,9.558400E+00,3.703800E-04,8.789800E-04,&
     & 1.855500E-03,3.305400E-03,5.947000E-03,1.212400E-02,2.770500E-02,&
     & 7.904200E-02,2.947100E-01,7.749500E-01,1.130200E+00,1.650100E+00,&
     & 2.381400E+00,4.186700E+00,8.490000E+00,1.144800E+01,4.002900E-04,&
     & 9.139800E-04,1.621400E-03,2.780500E-03,4.890500E-03,9.724200E-03,&
     & 2.290000E-02,6.504700E-02,2.510800E-01,7.295400E-01,1.028300E+00,&
     & 1.486100E+00,2.557900E+00,4.872000E+00,9.865900E+00,1.328100E+01,&
     & 2.284100E-04,4.535800E-04,8.450300E-04,1.445800E-03,2.708900E-03,&
     & 4.923800E-03,1.184800E-02,3.638200E-02,2.037000E-01,6.932800E-01,&
     & 1.068700E+00,1.698900E+00,2.925400E+00,5.589000E+00,1.134700E+01,&
     & 1.530700E+01,7.187900E-06,3.237700E-05,1.771900E-04,8.520800E-04,&
     & 4.546100E-03,1.437100E-02,3.576500E-02,1.022100E-01,4.565300E-01,&
     & 1.338600E+00,1.855100E+00,2.625000E+00,4.801000E+00,8.406700E+00,&
     & 1.055800E+01,1.094200E+01,1.389100E-04,4.036300E-04,1.017600E-03,&
     & 3.038300E-03,7.933100E-03,1.872300E-02,4.343000E-02,1.156100E-01,&
     & 4.585700E-01,1.229500E+00,1.673600E+00,2.326500E+00,4.200900E+00,&
     & 7.355900E+00,9.237800E+00,9.573100E+00,2.227500E-04,6.072800E-04,&
     & 1.489200E-03,3.900200E-03,8.863700E-03,1.915400E-02,4.510000E-02,&
     & 1.199200E-01,4.634600E-01,1.195000E+00,1.579100E+00,2.228900E+00,&
     & 3.876400E+00,6.305000E+00,7.918300E+00,8.205200E+00,2.911400E-04,&
     & 7.748100E-04,1.852900E-03,4.334700E-03,9.132600E-03,1.891000E-02,&
     & 4.443500E-02,1.195400E-01,4.578100E-01,1.115100E+00,1.485000E+00,&
     & 2.267300E+00,3.652600E+00,5.695300E+00,6.755300E+00,7.198500E+00,&
     & 3.506800E-04,9.113900E-04,2.128400E-03,4.500400E-03,8.910200E-03,&
     & 1.819300E-02,4.224500E-02,1.157200E-01,4.388700E-01,1.054300E+00,&
     & 1.417500E+00,2.245600E+00,3.506500E+00,4.931900E+00,7.187800E+00,&
     & 9.591500E+00,4.029800E-04,1.023800E-03,2.307400E-03,4.441500E-03,&
     & 8.327500E-03,1.685400E-02,3.883400E-02,1.084500E-01,4.074800E-01,&
     & 9.806400E-01,1.422500E+00,2.142600E+00,3.307800E+00,4.498100E+00,&
     & 8.893300E+00,1.197800E+01,4.492900E-04,1.098800E-03,2.319200E-03,&
     & 4.123600E-03,7.412000E-03,1.491700E-02,3.425300E-02,9.727800E-02,&
     & 3.626800E-01,9.559100E-01,1.380400E+00,2.004000E+00,2.882400E+00,&
     & 5.205300E+00,1.065800E+01,1.434400E+01,4.775800E-04,1.124400E-03,&
     & 2.027700E-03,3.478800E-03,6.098900E-03,1.193900E-02,2.826000E-02,&
     & 8.012600E-02,3.097600E-01,8.948400E-01,1.233300E+00,1.837300E+00,&
     & 3.162500E+00,6.055100E+00,1.238500E+01,1.663400E+01,2.733300E-04,&
     & 5.428300E-04,1.026900E-03,1.782500E-03,3.277800E-03,6.031700E-03,&
     & 1.468800E-02,4.542600E-02,2.519500E-01,8.540400E-01,1.309800E+00,&
     & 2.099700E+00,3.615600E+00,6.947800E+00,1.423800E+01,1.918300E+01,&
     & 4.889500E-06,1.364600E-05,5.001600E-05,2.503500E-04,2.044900E-03,&
     & 8.700100E-03,2.174700E-02,6.930600E-02,3.321900E-01,1.088100E+00,&
     & 1.475100E+00,1.982700E+00,3.465600E+00,7.279300E+00,1.000900E+01,&
     & 1.053300E+01,4.664200E-05,1.171800E-04,3.035000E-04,9.808900E-04,&
     & 3.705300E-03,9.774700E-03,2.445400E-02,6.949400E-02,3.046700E-01,&
     & 9.522500E-01,1.290700E+00,1.734900E+00,3.032400E+00,6.369500E+00,&
     & 8.757100E+00,9.214600E+00,7.335300E-05,1.773900E-04,4.313000E-04,&
     & 1.302600E-03,4.086000E-03,9.507100E-03,2.429200E-02,6.760000E-02,&
     & 2.861800E-01,8.569900E-01,1.141300E+00,1.498100E+00,2.599300E+00,&
     & 5.459300E+00,7.506100E+00,7.898300E+00,9.823000E-05,2.232700E-04,&
     & 5.411700E-04,1.517300E-03,4.149900E-03,8.937900E-03,2.308000E-02,&
     & 6.326700E-02,2.672100E-01,7.404300E-01,9.978800E-01,1.337100E+00,&
     & 2.253600E+00,4.549600E+00,6.254700E+00,6.581400E+00,1.218600E-04,&
     & 2.576800E-04,6.274000E-04,1.635700E-03,3.992200E-03,8.222700E-03,&
     & 2.111100E-02,5.732200E-02,2.460100E-01,6.371900E-01,8.376500E-01,&
     & 1.145300E+00,2.076800E+00,3.666800E+00,5.004200E+00,5.266100E+00/
      data   absa(:,321:340) /                                          &
     & 1.404000E-04,2.922700E-04,6.860300E-04,1.653500E-03,3.622700E-03,&
     & 7.296200E-03,1.854300E-02,5.009100E-02,2.181100E-01,5.469900E-01,&
     & 7.031200E-01,9.660200E-01,1.832300E+00,3.073900E+00,3.799300E+00,&
     & 3.949300E+00,1.547200E-04,3.216800E-04,7.153100E-04,1.538600E-03,&
     & 3.042100E-03,6.186800E-03,1.530000E-02,4.174100E-02,1.814500E-01,&
     & 4.436600E-01,5.843700E-01,8.730900E-01,1.479400E+00,2.381200E+00,&
     & 3.611200E+00,4.531500E+00,1.715800E-04,3.394500E-04,6.720600E-04,&
     & 1.261300E-03,2.228200E-03,4.795300E-03,1.105400E-02,3.143300E-02,&
     & 1.326900E-01,3.372200E-01,5.121200E-01,7.725400E-01,1.110000E+00,&
     & 1.885000E+00,4.205200E+00,5.273700E+00,1.211600E-04,2.043500E-04,&
     & 3.453400E-04,5.481200E-04,1.095400E-03,2.079400E-03,4.855800E-03,&
     & 1.205300E-02,6.640100E-02,2.536500E-01,4.084800E-01,6.657100E-01,&
     & 1.071900E+00,2.141400E+00,4.819400E+00,6.049700E+00,5.403200E-06,&
     & 1.779700E-05,7.630500E-05,3.998300E-04,3.026000E-03,1.161800E-02,&
     & 3.038900E-02,9.135700E-02,4.495000E-01,1.472900E+00,2.011000E+00,&
     & 2.715100E+00,4.795300E+00,9.714800E+00,1.308900E+01,1.375000E+01,&
     & 6.047900E-05,1.598200E-04,4.211000E-04,1.407400E-03,5.123200E-03,&
     & 1.317800E-02,3.332700E-02,9.223700E-02,4.137400E-01,1.289200E+00,&
     & 1.759700E+00,2.375800E+00,4.196000E+00,8.500400E+00,1.145400E+01,&
     & 1.203200E+01,9.519100E-05,2.416000E-04,6.020200E-04,1.843100E-03,&
     & 5.562500E-03,1.295800E-02,3.292600E-02,8.933500E-02,3.899900E-01,&
     & 1.160300E+00,1.559500E+00,2.050700E+00,3.596400E+00,7.285800E+00,&
     & 9.817100E+00,1.031300E+01,1.260600E-04,3.035100E-04,7.526200E-04,&
     & 2.118300E-03,5.587300E-03,1.224500E-02,3.113400E-02,8.385700E-02,&
     & 3.646100E-01,1.005700E+00,1.360300E+00,1.831300E+00,3.119500E+00,&
     & 6.071900E+00,8.181100E+00,8.593400E+00,1.526000E-04,3.544100E-04,&
     & 8.696700E-04,2.269500E-03,5.332100E-03,1.118000E-02,2.853300E-02,&
     & 7.644400E-02,3.338800E-01,8.773500E-01,1.153900E+00,1.569100E+00,&
     & 2.855800E+00,4.906700E+00,6.545100E+00,6.874500E+00,1.777400E-04,&
     & 3.964400E-04,9.499800E-04,2.261000E-03,4.845800E-03,9.875900E-03,&
     & 2.500300E-02,6.745100E-02,2.949000E-01,7.462400E-01,9.729100E-01,&
     & 1.355100E+00,2.496000E+00,4.105000E+00,5.006400E+00,5.484600E+00,&
     & 1.964100E-04,4.303500E-04,9.853900E-04,2.089200E-03,4.070300E-03,&
     & 8.495900E-03,2.040200E-02,5.647400E-02,2.450800E-01,6.068500E-01,&
     & 7.969800E-01,1.232500E+00,2.023400E+00,3.150400E+00,4.905900E+00,&
     & 6.576300E+00,2.096500E-04,4.454700E-04,9.268200E-04,1.696600E-03,&
     & 3.031900E-03,6.468900E-03,1.472400E-02,4.265900E-02,1.793500E-01,&
     & 4.583900E-01,7.011000E-01,1.053700E+00,1.526400E+00,2.596000E+00,&
     & 5.712900E+00,7.613900E+00,1.426400E-04,2.602700E-04,4.461500E-04,&
     & 7.048700E-04,1.421800E-03,2.679800E-03,6.178800E-03,1.612700E-02,&
     & 9.002600E-02,3.496800E-01,5.525900E-01,8.996600E-01,1.515100E+00,&
     & 2.969800E+00,6.548100E+00,8.778700E+00,6.599700E-06,2.472600E-05,&
     & 1.191100E-04,6.252400E-04,4.349900E-03,1.535100E-02,4.029000E-02,&
     & 1.180100E-01,5.871700E-01,1.919300E+00,2.628600E+00,3.599700E+00,&
     & 6.411900E+00,1.240800E+01,1.638700E+01,1.717500E+01,7.877200E-05,&
     & 2.181600E-04,5.830400E-04,1.988300E-03,6.868500E-03,1.766500E-02,&
     & 4.350500E-02,1.195500E-01,5.416600E-01,1.681600E+00,2.300100E+00,&
     & 3.149900E+00,5.610600E+00,1.085800E+01,1.433900E+01,1.502900E+01,&
     & 1.235300E-04,3.265000E-04,8.220900E-04,2.553500E-03,7.348400E-03,&
     & 1.731900E-02,4.295000E-02,1.158800E-01,5.110000E-01,1.515600E+00,&
     & 2.038500E+00,2.729100E+00,4.809100E+00,9.305800E+00,1.229000E+01,&
     & 1.288100E+01,1.621200E-04,4.089300E-04,1.021300E-03,2.897100E-03,&
     & 7.318300E-03,1.626700E-02,4.067600E-02,1.090800E-01,4.773600E-01,&
     & 1.326500E+00,1.778500E+00,2.437300E+00,4.163700E+00,7.754900E+00,&
     & 1.024200E+01,1.073500E+01,1.942700E-04,4.747900E-04,1.173800E-03,&
     & 3.059900E-03,6.956500E-03,1.483800E-02,3.719100E-02,9.988100E-02,&
     & 4.357900E-01,1.153400E+00,1.536200E+00,2.103400E+00,3.765800E+00,&
     & 6.300800E+00,8.194100E+00,8.588300E+00,2.231300E-04,5.278400E-04,&
     & 1.277400E-03,3.025900E-03,6.308600E-03,1.318800E-02,3.242200E-02,&
     & 8.824300E-02,3.846100E-01,9.774100E-01,1.288900E+00,1.859300E+00,&
     & 3.252900E+00,5.258600E+00,6.351700E+00,7.563400E+00,2.463600E-04,&
     & 5.699000E-04,1.319100E-03,2.753400E-03,5.380500E-03,1.116700E-02,&
     & 2.642700E-02,7.414600E-02,3.192500E-01,7.995100E-01,1.059000E+00,&
     & 1.657900E+00,2.677700E+00,3.982000E+00,6.506600E+00,9.069200E+00/
      data   absa(:,341:360) /                                          &
     & 2.598600E-04,5.841400E-04,1.230700E-03,2.212800E-03,3.999100E-03,&
     & 8.442500E-03,1.911100E-02,5.616500E-02,2.335800E-01,6.080900E-01,&
     & 9.225000E-01,1.377300E+00,1.992100E+00,3.486500E+00,7.577800E+00,&
     & 1.055500E+01,1.718800E-04,3.234200E-04,5.594800E-04,8.934700E-04,&
     & 1.782700E-03,3.411300E-03,7.679900E-03,2.160000E-02,1.183300E-01,&
     & 4.527500E-01,7.227500E-01,1.178900E+00,2.030600E+00,3.988600E+00,&
     & 8.684000E+00,1.210700E+01,8.654800E-06,3.573900E-05,1.864900E-04,&
     & 9.647500E-04,6.098800E-03,2.009200E-02,5.207200E-02,1.495000E-01,&
     & 7.440600E-01,2.419600E+00,3.335000E+00,4.666500E+00,8.253200E+00,&
     & 1.530100E+01,1.980900E+01,2.070700E+01,1.020500E-04,2.971900E-04,&
     & 7.992300E-04,2.748900E-03,9.004800E-03,2.291100E-02,5.580900E-02,&
     & 1.519700E-01,6.877800E-01,2.122000E+00,2.918200E+00,4.083200E+00,&
     & 7.221100E+00,1.338800E+01,1.733300E+01,1.812000E+01,1.590300E-04,&
     & 4.396700E-04,1.110200E-03,3.472500E-03,9.472800E-03,2.243100E-02,&
     & 5.489500E-02,1.474900E-01,6.499600E-01,1.909700E+00,2.585000E+00,&
     & 3.551900E+00,6.189800E+00,1.147600E+01,1.485600E+01,1.553200E+01,&
     & 2.072000E-04,5.445900E-04,1.360200E-03,3.885600E-03,9.379800E-03,&
     & 2.118100E-02,5.171400E-02,1.389400E-01,6.062200E-01,1.694200E+00,&
     & 2.261700E+00,3.154400E+00,5.368800E+00,9.563200E+00,1.238100E+01,&
     & 1.294400E+01,2.458100E-04,6.296100E-04,1.553000E-03,4.035500E-03,&
     & 8.948700E-03,1.939300E-02,4.697800E-02,1.273600E-01,5.524100E-01,&
     & 1.469300E+00,1.978000E+00,2.746800E+00,4.794800E+00,7.836400E+00,&
     & 9.904700E+00,1.035600E+01,2.775900E-04,6.943500E-04,1.680500E-03,&
     & 3.935700E-03,8.166900E-03,1.711900E-02,4.090700E-02,1.127100E-01,&
     & 4.872800E-01,1.243900E+00,1.658000E+00,2.461700E+00,4.102500E+00,&
     & 6.469600E+00,7.956900E+00,9.976600E+00,3.031400E-04,7.401600E-04,&
     & 1.728800E-03,3.548400E-03,6.916200E-03,1.436900E-02,3.341100E-02,&
     & 9.495300E-02,4.041900E-01,1.019400E+00,1.375800E+00,2.138800E+00,&
     & 3.445800E+00,4.860100E+00,8.418900E+00,1.196300E+01,3.203700E-04,&
     & 7.470300E-04,1.593200E-03,2.845000E-03,5.172700E-03,1.069500E-02,&
     & 2.436200E-02,7.188000E-02,2.965700E-01,7.813900E-01,1.172900E+00,&
     & 1.746400E+00,2.506200E+00,4.551300E+00,9.805200E+00,1.392100E+01,&
     & 2.020300E-04,3.950800E-04,6.895100E-04,1.114100E-03,2.209000E-03,&
     & 4.256700E-03,9.320800E-03,2.797200E-02,1.518900E-01,5.753600E-01,&
     & 9.153200E-01,1.507900E+00,2.614300E+00,5.208100E+00,1.123500E+01,&
     & 1.597000E+01,1.179200E-05,5.299300E-05,2.866400E-04,1.449200E-03,&
     & 8.230100E-03,2.562500E-02,6.616000E-02,1.864600E-01,9.190700E-01,&
     & 2.966200E+00,4.134600E+00,5.866900E+00,1.028300E+01,1.831900E+01,&
     & 2.331000E+01,2.432000E+01,1.316800E-04,4.033300E-04,1.089100E-03,&
     & 3.723400E-03,1.159200E-02,2.913600E-02,7.025800E-02,1.894200E-01,&
     & 8.512500E-01,2.606400E+00,3.618100E+00,5.133500E+00,8.997100E+00,&
     & 1.602900E+01,2.039600E+01,2.128200E+01,2.023600E-04,5.850000E-04,&
     & 1.489400E-03,4.602300E-03,1.205800E-02,2.864000E-02,6.865400E-02,&
     & 1.839200E-01,8.056900E-01,2.339000E+00,3.210600E+00,4.479200E+00,&
     & 7.711800E+00,1.374000E+01,1.748200E+01,1.823800E+01,2.606600E-04,&
     & 7.184500E-04,1.795600E-03,5.076100E-03,1.193600E-02,2.698000E-02,&
     & 6.432000E-02,1.734600E-01,7.501200E-01,2.096600E+00,2.826400E+00,&
     & 3.955900E+00,6.708700E+00,1.144900E+01,1.456900E+01,1.520000E+01,&
     & 3.075900E-04,8.250500E-04,2.023800E-03,5.189800E-03,1.138600E-02,&
     & 2.461200E-02,5.824000E-02,1.592400E-01,6.836900E-01,1.812200E+00,&
     & 2.483500E+00,3.481700E+00,5.916300E+00,9.479800E+00,1.165400E+01,&
     & 1.216100E+01,3.449700E-04,9.010800E-04,2.179500E-03,5.004100E-03,&
     & 1.034500E-02,2.170300E-02,5.066700E-02,1.411300E-01,6.018500E-01,&
     & 1.551700E+00,2.071400E+00,3.124100E+00,5.063000E+00,7.715000E+00,&
     & 9.799800E+00,1.272300E+01,3.738900E-04,9.466500E-04,2.214400E-03,&
     & 4.496200E-03,8.706900E-03,1.820200E-02,4.156100E-02,1.185600E-01,&
     & 4.999500E-01,1.269800E+00,1.738500E+00,2.664900E+00,4.287700E+00,&
     & 5.821500E+00,1.061300E+01,1.525400E+01,3.896800E-04,9.458700E-04,&
     & 2.010500E-03,3.608200E-03,6.541500E-03,1.331000E-02,3.053100E-02,&
     & 8.958000E-02,3.683200E-01,9.817500E-01,1.446800E+00,2.162900E+00,&
     & 3.059700E+00,5.787700E+00,1.236200E+01,1.775200E+01,2.400800E-04,&
     & 4.728000E-04,8.326200E-04,1.387600E-03,2.687900E-03,5.210100E-03,&
     & 1.109700E-02,3.556600E-02,1.910100E-01,7.142000E-01,1.143000E+00,&
     & 1.873200E+00,3.270200E+00,6.622600E+00,1.416200E+01,2.036400E+01/
      data   absa(:,361:380) /                                          &
     & 1.768600E-05,4.525000E-05,1.529300E-04,7.771700E-04,6.434100E-03,&
     & 2.841100E-02,6.987900E-02,2.209600E-01,1.148500E+00,4.069300E+00,&
     & 5.768100E+00,8.038700E+00,1.303900E+01,2.709300E+01,3.813000E+01,&
     & 4.036300E+01,6.292500E-05,1.468600E-04,4.671100E-04,1.607600E-03,&
     & 8.493200E-03,2.780500E-02,6.638600E-02,1.993100E-01,1.008900E+00,&
     & 3.560900E+00,5.046800E+00,7.034000E+00,1.140900E+01,2.370600E+01,&
     & 3.336200E+01,3.531800E+01,8.519800E-05,2.023000E-04,5.942900E-04,&
     & 1.932700E-03,8.631900E-03,2.543600E-02,6.141600E-02,1.812600E-01,&
     & 8.788000E-01,3.052100E+00,4.326000E+00,6.029300E+00,9.778600E+00,&
     & 2.032100E+01,2.859600E+01,3.027300E+01,1.021300E-04,2.482800E-04,&
     & 6.714300E-04,2.095000E-03,8.310800E-03,2.267700E-02,5.486200E-02,&
     & 1.610600E-01,7.576200E-01,2.547000E+00,3.605000E+00,5.024500E+00,&
     & 8.148600E+00,1.693400E+01,2.383000E+01,2.522700E+01,1.154300E-04,&
     & 2.803600E-04,7.027000E-04,2.172700E-03,7.701800E-03,1.951600E-02,&
     & 4.728300E-02,1.383400E-01,6.362200E-01,2.094600E+00,2.910900E+00,&
     & 4.019600E+00,6.519200E+00,1.354700E+01,1.906500E+01,2.018100E+01,&
     & 1.278000E-04,2.980100E-04,7.257800E-04,2.150700E-03,6.776300E-03,&
     & 1.586700E-02,3.911200E-02,1.128300E-01,5.137700E-01,1.623100E+00,&
     & 2.267300E+00,3.095700E+00,4.900000E+00,1.016100E+01,1.429800E+01,&
     & 1.513400E+01,1.399400E-04,2.992100E-04,7.203100E-04,2.023900E-03,&
     & 5.511500E-03,1.195800E-02,2.984600E-02,8.479000E-02,3.906800E-01,&
     & 1.134200E+00,1.577600E+00,2.177300E+00,3.552600E+00,6.773500E+00,&
     & 9.532200E+00,1.009000E+01,1.416400E-04,2.881500E-04,6.702300E-04,&
     & 1.661900E-03,3.776700E-03,7.596900E-03,1.902600E-02,5.346500E-02,&
     & 2.532300E-01,6.934100E-01,9.130200E-01,1.235700E+00,2.208300E+00,&
     & 3.894700E+00,4.925400E+00,5.421200E+00,1.030600E-04,2.457700E-04,&
     & 4.685700E-04,6.528300E-04,9.547500E-04,2.061200E-03,5.028100E-03,&
     & 1.312400E-02,5.405700E-02,2.325400E-01,3.385600E-01,4.205000E-01,&
     & 6.124900E-01,1.790400E+00,4.521000E+00,6.199600E+00,1.862900E-05,&
     & 5.659200E-05,2.274300E-04,1.225700E-03,9.675900E-03,3.881400E-02,&
     & 9.707200E-02,3.011100E-01,1.591900E+00,5.652500E+00,8.051900E+00,&
     & 1.128000E+01,1.819000E+01,3.735600E+01,5.135000E+01,5.423100E+01,&
     & 7.914500E-05,2.011000E-04,6.543500E-04,2.421600E-03,1.221300E-02,&
     & 3.790800E-02,9.219900E-02,2.726900E-01,1.398300E+00,4.945900E+00,&
     & 7.046300E+00,9.870500E+00,1.591600E+01,3.268700E+01,4.493300E+01,&
     & 4.744400E+01,1.083900E-04,2.818100E-04,8.326000E-04,2.820500E-03,&
     & 1.226600E-02,3.486700E-02,8.554000E-02,2.473100E-01,1.219300E+00,&
     & 4.239600E+00,6.039500E+00,8.460100E+00,1.364300E+01,2.801700E+01,&
     & 3.851400E+01,4.066700E+01,1.317700E-04,3.440500E-04,9.222100E-04,&
     & 3.070600E-03,1.172500E-02,3.094800E-02,7.685500E-02,2.182800E-01,&
     & 1.053900E+00,3.536700E+00,5.033100E+00,7.050100E+00,1.136900E+01,&
     & 2.334700E+01,3.209400E+01,3.389600E+01,1.500200E-04,3.816700E-04,&
     & 9.847600E-04,3.155800E-03,1.074100E-02,2.664100E-02,6.649200E-02,&
     & 1.861600E-01,8.875900E-01,2.914300E+00,4.058600E+00,5.640200E+00,&
     & 9.095300E+00,1.867900E+01,2.567700E+01,2.711400E+01,1.648100E-04,&
     & 4.086300E-04,1.020400E-03,3.089300E-03,9.385500E-03,2.166800E-02,&
     & 5.470700E-02,1.520200E-01,7.182700E-01,2.253300E+00,3.176200E+00,&
     & 4.333400E+00,6.833100E+00,1.400800E+01,1.925800E+01,2.033600E+01,&
     & 1.757800E-04,4.151400E-04,1.023500E-03,2.863900E-03,7.565400E-03,&
     & 1.634500E-02,4.154900E-02,1.145700E-01,5.460300E-01,1.586700E+00,&
     & 2.207300E+00,3.049200E+00,4.954400E+00,9.339300E+00,1.283800E+01,&
     & 1.355700E+01,1.833100E-04,3.911500E-04,9.495500E-04,2.321500E-03,&
     & 5.151700E-03,1.042900E-02,2.636600E-02,7.243400E-02,3.523600E-01,&
     & 9.656700E-01,1.296800E+00,1.746700E+00,3.091700E+00,5.367200E+00,&
     & 6.624200E+00,7.487600E+00,1.369200E-04,3.244100E-04,5.670800E-04,&
     & 8.132600E-04,1.193300E-03,2.590300E-03,6.374900E-03,1.689000E-02,&
     & 7.356700E-02,2.970600E-01,3.970500E-01,4.683700E-01,1.317400E+00,&
     & 2.556300E+00,6.322500E+00,8.563800E+00,2.165500E-05,7.701700E-05,&
     & 3.560100E-04,1.925800E-03,1.427400E-02,5.153700E-02,1.327400E-01,&
     & 3.954700E-01,2.120200E+00,7.533600E+00,1.074000E+01,1.520200E+01,&
     & 2.471700E+01,4.901000E+01,6.586500E+01,6.937500E+01,1.025900E-04,&
     & 2.802700E-04,9.485500E-04,3.578800E-03,1.711600E-02,5.034700E-02,&
     & 1.263900E-01,3.581100E-01,1.862900E+00,6.592100E+00,9.397100E+00,&
     & 1.330200E+01,2.162800E+01,4.288300E+01,5.763300E+01,6.070600E+01/
      data   absa(:,381:400) /                                          &
     & 1.404700E-04,3.931600E-04,1.160200E-03,4.133100E-03,1.697000E-02,&
     & 4.626200E-02,1.167000E-01,3.238000E-01,1.628200E+00,5.650200E+00,&
     & 8.054900E+00,1.140100E+01,1.853800E+01,3.675700E+01,4.939800E+01,&
     & 5.203000E+01,1.713900E-04,4.718700E-04,1.287500E-03,4.412100E-03,&
     & 1.603000E-02,4.114400E-02,1.041200E-01,2.863600E-01,1.408400E+00,&
     & 4.719700E+00,6.712900E+00,9.500800E+00,1.544900E+01,3.063000E+01,&
     & 4.116700E+01,4.336300E+01,1.962400E-04,5.192500E-04,1.364000E-03,&
     & 4.482500E-03,1.454500E-02,3.532400E-02,8.957600E-02,2.446500E-01,&
     & 1.187500E+00,3.891500E+00,5.419000E+00,7.600900E+00,1.235900E+01,&
     & 2.450500E+01,3.293100E+01,3.469300E+01,2.145100E-04,5.566900E-04,&
     & 1.406700E-03,4.345600E-03,1.262400E-02,2.892400E-02,7.340000E-02,&
     & 1.996800E-01,9.628300E-01,3.003000E+00,4.235500E+00,5.844600E+00,&
     & 9.299600E+00,1.837900E+01,2.470100E+01,2.601900E+01,2.269800E-04,&
     & 5.630800E-04,1.407000E-03,3.975100E-03,1.009200E-02,2.192300E-02,&
     & 5.554800E-02,1.507500E-01,7.299200E-01,2.142000E+00,2.953100E+00,&
     & 4.103300E+00,6.741400E+00,1.225700E+01,1.646500E+01,1.734600E+01,&
     & 2.286300E-04,5.317700E-04,1.303200E-03,3.154600E-03,6.827300E-03,&
     & 1.406400E-02,3.501700E-02,9.631900E-02,4.691100E-01,1.286200E+00,&
     & 1.752100E+00,2.407200E+00,4.157800E+00,7.040000E+00,8.540600E+00,&
     & 1.064200E+01,1.735000E-04,4.100300E-04,6.471400E-04,1.007200E-03,&
     & 1.495600E-03,3.211600E-03,7.928300E-03,2.103000E-02,9.726900E-02,&
     & 3.640200E-01,4.043700E-01,9.006700E-01,1.784100E+00,3.534700E+00,&
     & 8.471100E+00,1.216900E+01,2.746100E-05,1.102500E-04,5.591100E-04,&
     & 3.005800E-03,2.034800E-02,6.690900E-02,1.772500E-01,5.062200E-01,&
     & 2.735400E+00,9.669600E+00,1.384000E+01,1.980400E+01,3.257300E+01,&
     & 6.173500E+01,8.119400E+01,8.536400E+01,1.357500E-04,3.947100E-04,&
     & 1.360600E-03,5.181600E-03,2.345600E-02,6.523400E-02,1.672600E-01,&
     & 4.600800E-01,2.405000E+00,8.460800E+00,1.211000E+01,1.732800E+01,&
     & 2.850300E+01,5.401800E+01,7.104100E+01,7.469400E+01,1.840900E-04,&
     & 5.461200E-04,1.627200E-03,5.892600E-03,2.292500E-02,6.036400E-02,&
     & 1.527600E-01,4.170100E-01,2.103800E+00,7.252600E+00,1.038000E+01,&
     & 1.485300E+01,2.443200E+01,4.630000E+01,6.089100E+01,6.400300E+01,&
     & 2.236600E-04,6.482400E-04,1.778200E-03,6.213300E-03,2.141500E-02,&
     & 5.394300E-02,1.360600E-01,3.680600E-01,1.821400E+00,6.067500E+00,&
     & 8.650200E+00,1.237700E+01,2.035900E+01,3.858300E+01,5.073800E+01,&
     & 5.334900E+01,2.548400E-04,7.105500E-04,1.867100E-03,6.251300E-03,&
     & 1.926000E-02,4.644300E-02,1.166800E-01,3.147700E-01,1.536600E+00,&
     & 4.988600E+00,7.007700E+00,9.904000E+00,1.628800E+01,3.086800E+01,&
     & 4.059100E+01,4.267500E+01,2.781500E-04,7.524500E-04,1.915900E-03,&
     & 5.994300E-03,1.650200E-02,3.812400E-02,9.538500E-02,2.574000E-01,&
     & 1.247100E+00,3.855800E+00,5.454900E+00,7.631900E+00,1.226700E+01,&
     & 2.315000E+01,3.044900E+01,3.200700E+01,2.915200E-04,7.555700E-04,&
     & 1.889900E-03,5.416000E-03,1.309800E-02,2.894700E-02,7.189500E-02,&
     & 1.950400E-01,9.417700E-01,2.777900E+00,3.835400E+00,5.358900E+00,&
     & 8.860600E+00,1.545800E+01,2.029700E+01,2.133800E+01,2.871900E-04,&
     & 7.071400E-04,1.737400E-03,4.173500E-03,8.859700E-03,1.854900E-02,&
     & 4.501700E-02,1.251700E-01,6.039100E-01,1.661800E+00,2.270400E+00,&
     & 3.220600E+00,5.401100E+00,8.807100E+00,1.090200E+01,1.437900E+01,&
     & 2.142500E-04,5.054700E-04,7.385800E-04,1.213300E-03,1.891300E-03,&
     & 3.862300E-03,9.770000E-03,2.556700E-02,1.233800E-01,4.096100E-01,&
     & 5.438500E-01,1.327700E+00,2.324100E+00,4.739300E+00,1.105000E+01,&
     & 1.644400E+01,3.672700E-05,1.637700E-04,8.708100E-04,4.586000E-03,&
     & 2.794700E-02,8.607800E-02,2.290000E-01,6.397000E-01,3.431700E+00,&
     & 1.205900E+01,1.729100E+01,2.509100E+01,4.156200E+01,7.528400E+01,&
     & 9.697600E+01,1.017300E+02,1.818900E-04,5.526600E-04,1.935600E-03,&
     & 7.356100E-03,3.139200E-02,8.401800E-02,2.146900E-01,5.828200E-01,&
     & 3.017600E+00,1.055200E+01,1.512900E+01,2.195500E+01,3.636800E+01,&
     & 6.587300E+01,8.485100E+01,8.901100E+01,2.425800E-04,7.526000E-04,&
     & 2.266900E-03,8.169400E-03,3.035000E-02,7.784300E-02,1.956200E-01,&
     & 5.275300E-01,2.642100E+00,9.044700E+00,1.296900E+01,1.881900E+01,&
     & 3.117300E+01,5.646300E+01,7.273400E+01,7.629400E+01,2.902200E-04,&
     & 8.846300E-04,2.442900E-03,8.531500E-03,2.804200E-02,6.950600E-02,&
     & 1.734600E-01,4.658900E-01,2.287700E+00,7.585800E+00,1.080800E+01,&
     & 1.568300E+01,2.597700E+01,4.705200E+01,6.060900E+01,6.357800E+01/
      data   absa(:,401:420) /                                          &
     & 3.292100E-04,9.621700E-04,2.549800E-03,8.500900E-03,2.492000E-02,&
     & 5.985300E-02,1.489200E-01,3.982100E-01,1.931000E+00,6.213600E+00,&
     & 8.791300E+00,1.255400E+01,2.078100E+01,3.764000E+01,4.848500E+01,&
     & 5.085800E+01,3.561700E-04,1.008400E-03,2.583400E-03,8.069600E-03,&
     & 2.117100E-02,4.915900E-02,1.212600E-01,3.259400E-01,1.567700E+00,&
     & 4.823300E+00,6.811800E+00,9.697000E+00,1.567800E+01,2.823300E+01,&
     & 3.636600E+01,3.814700E+01,3.698300E-04,1.001000E-03,2.515000E-03,&
     & 7.159700E-03,1.672000E-02,3.714600E-02,9.101500E-02,2.474400E-01,&
     & 1.181400E+00,3.479900E+00,4.859400E+00,6.819000E+00,1.126100E+01,&
     & 1.888900E+01,2.424400E+01,2.543100E+01,3.585000E-04,9.283100E-04,&
     & 2.276300E-03,5.391400E-03,1.127500E-02,2.397700E-02,5.662100E-02,&
     & 1.589200E-01,7.563500E-01,2.091500E+00,2.864300E+00,4.141200E+00,&
     & 6.830100E+00,1.065400E+01,1.360900E+01,1.871500E+01,2.586600E-04,&
     & 5.999200E-04,8.713900E-04,1.452400E-03,2.315900E-03,4.609500E-03,&
     & 1.185100E-02,3.070700E-02,1.535300E-01,3.753100E-01,9.384400E-01,&
     & 1.657000E+00,2.954100E+00,6.163500E+00,1.402200E+01,2.140600E+01,&
     & 7.266300E-05,1.740800E-04,5.502500E-04,2.763200E-03,2.321800E-02,&
     & 1.047900E-01,2.611000E-01,7.960900E-01,4.443600E+00,1.708800E+01,&
     & 2.528100E+01,3.685300E+01,5.795100E+01,1.150100E+02,1.649500E+02,&
     & 1.751800E+02,1.280500E-04,2.870900E-04,9.163800E-04,3.757800E-03,&
     & 2.454700E-02,9.480400E-02,2.319100E-01,6.987700E-01,3.888200E+00,&
     & 1.495200E+01,2.212100E+01,3.224700E+01,5.070800E+01,1.006400E+02,&
     & 1.443400E+02,1.532600E+02,1.461000E-04,3.252700E-04,1.052400E-03,&
     & 3.892900E-03,2.345600E-02,8.415800E-02,2.043100E-01,6.063100E-01,&
     & 3.334800E+00,1.281600E+01,1.896100E+01,2.764100E+01,4.346400E+01,&
     & 8.626200E+01,1.237100E+02,1.313800E+02,1.552300E-04,3.483500E-04,&
     & 1.115100E-03,3.864800E-03,2.145200E-02,7.241900E-02,1.764300E-01,&
     & 5.132300E-01,2.788800E+00,1.068100E+01,1.580100E+01,2.303500E+01,&
     & 3.622000E+01,7.188300E+01,1.030800E+02,1.094600E+02,1.593100E-04,&
     & 3.589400E-04,1.117300E-03,3.715000E-03,1.885500E-02,5.989700E-02,&
     & 1.469300E-01,4.217600E-01,2.247700E+00,8.544400E+00,1.264100E+01,&
     & 1.842700E+01,2.897600E+01,5.750600E+01,8.247800E+01,8.758900E+01,&
     & 1.576800E-04,3.591900E-04,1.067200E-03,3.438600E-03,1.570300E-02,&
     & 4.701400E-02,1.154500E-01,3.304000E-01,1.713400E+00,6.408100E+00,&
     & 9.480600E+00,1.382000E+01,2.173200E+01,4.313000E+01,6.186200E+01,&
     & 6.568400E+01,1.495000E-04,3.526300E-04,9.764900E-04,2.982400E-03,&
     & 1.204700E-02,3.351300E-02,8.190800E-02,2.355700E-01,1.187100E+00,&
     & 4.316900E+00,6.320700E+00,9.214200E+00,1.448800E+01,2.875500E+01,&
     & 4.124000E+01,4.379500E+01,1.359300E-04,3.148400E-04,7.734500E-04,&
     & 2.304200E-03,7.788400E-03,1.891500E-02,4.648000E-02,1.334000E-01,&
     & 6.578200E-01,2.261200E+00,3.292100E+00,4.701700E+00,7.252000E+00,&
     & 1.437800E+01,2.062000E+01,2.189800E+01,1.120700E-04,2.757100E-04,&
     & 6.500200E-04,1.159500E-03,1.411500E-03,2.395900E-03,5.544800E-03,&
     & 1.836400E-02,7.066300E-02,1.532500E-01,2.822500E-01,5.209600E-01,&
     & 5.653800E-01,5.711600E-01,1.630500E+00,6.609600E+00,7.401900E-05,&
     & 2.096100E-04,7.912600E-04,4.361800E-03,3.535200E-02,1.459300E-01,&
     & 3.630400E-01,1.118500E+00,6.299700E+00,2.426500E+01,3.608900E+01,&
     & 5.286600E+01,8.130600E+01,1.632300E+02,2.282800E+02,2.420900E+02,&
     & 1.510800E-04,3.681600E-04,1.300200E-03,5.843900E-03,3.647900E-02,&
     & 1.321400E-01,3.230500E-01,9.817900E-01,5.512400E+00,2.123200E+01,&
     & 3.157700E+01,4.625500E+01,7.114100E+01,1.428300E+02,1.997300E+02,&
     & 2.118100E+02,1.762500E-04,4.314300E-04,1.486000E-03,6.023700E-03,&
     & 3.447100E-02,1.170500E-01,2.852300E-01,8.516300E-01,4.728800E+00,&
     & 1.819900E+01,2.706600E+01,3.964800E+01,6.097900E+01,1.224200E+02,&
     & 1.712100E+02,1.815200E+02,1.910300E-04,4.688100E-04,1.559800E-03,&
     & 5.917300E-03,3.129900E-02,1.007400E-01,2.461200E-01,7.211100E-01,&
     & 3.955900E+00,1.516700E+01,2.255500E+01,3.304000E+01,5.081300E+01,&
     & 1.020200E+02,1.426700E+02,1.512700E+02,1.972900E-04,4.965900E-04,&
     & 1.544100E-03,5.619800E-03,2.723900E-02,8.354700E-02,2.046800E-01,&
     & 5.929200E-01,3.189700E+00,1.213200E+01,1.804400E+01,2.643100E+01,&
     & 4.065200E+01,8.161400E+01,1.141400E+02,1.210200E+02,1.981700E-04,&
     & 5.014700E-04,1.501500E-03,5.073900E-03,2.266800E-02,6.554200E-02,&
     & 1.611700E-01,4.636800E-01,2.433400E+00,9.099600E+00,1.353200E+01,&
     & 1.982500E+01,3.048900E+01,6.121300E+01,8.560400E+01,9.077900E+01/
      data   absa(:,421:440) /                                          &
     & 1.914400E-04,4.927200E-04,1.339900E-03,4.396600E-03,1.731800E-02,&
     & 4.677200E-02,1.148900E-01,3.277700E-01,1.691500E+00,6.119400E+00,&
     & 9.022600E+00,1.321700E+01,2.032600E+01,4.080700E+01,5.706200E+01,&
     & 6.051000E+01,1.740800E-04,4.333900E-04,1.090900E-03,3.384600E-03,&
     & 1.099000E-02,2.637500E-02,6.535000E-02,1.849400E-01,9.395400E-01,&
     & 3.211500E+00,4.719700E+00,6.722300E+00,1.016300E+01,2.040500E+01,&
     & 2.853600E+01,3.025800E+01,1.549900E-04,3.885900E-04,8.349900E-04,&
     & 1.331000E-03,1.742800E-03,2.875600E-03,7.003200E-03,2.273100E-02,&
     & 8.741800E-02,2.090700E-01,3.937500E-01,8.570500E-01,6.576100E-01,&
     & 4.694400E-01,5.339300E+00,8.747700E+00,8.240300E-05,2.777600E-04,&
     & 1.223700E-03,6.807600E-03,5.304100E-02,1.967800E-01,5.018500E-01,&
     & 1.497700E+00,8.561900E+00,3.285900E+01,4.899700E+01,7.244000E+01,&
     & 1.115800E+02,2.195000E+02,2.992500E+02,3.170200E+02,1.886300E-04,&
     & 5.019200E-04,1.932100E-03,8.861600E-03,5.329000E-02,1.782500E-01,&
     & 4.468800E-01,1.315200E+00,7.492500E+00,2.875200E+01,4.287300E+01,&
     & 6.338200E+01,9.762500E+01,1.920600E+02,2.618400E+02,2.773900E+02,&
     & 2.241400E-04,5.960300E-04,2.158700E-03,9.086700E-03,4.975300E-02,&
     & 1.577300E-01,3.941700E-01,1.142200E+00,6.427900E+00,2.464600E+01,&
     & 3.674900E+01,5.432600E+01,8.367900E+01,1.646200E+02,2.244400E+02,&
     & 2.377700E+02,2.453600E-04,6.518100E-04,2.252600E-03,8.829700E-03,&
     & 4.463400E-02,1.359000E-01,3.390900E-01,9.692700E-01,5.377100E+00,&
     & 2.053700E+01,3.062300E+01,4.527200E+01,6.973000E+01,1.371800E+02,&
     & 1.870300E+02,1.981000E+02,2.537300E-04,6.935700E-04,2.223500E-03,&
     & 8.298000E-03,3.859300E-02,1.127700E-01,2.811700E-01,7.981500E-01,&
     & 4.336500E+00,1.643000E+01,2.449800E+01,3.621800E+01,5.578600E+01,&
     & 1.097500E+02,1.496300E+02,1.584900E+02,2.554900E-04,7.031200E-04,&
     & 2.104000E-03,7.512000E-03,3.183000E-02,8.846200E-02,2.205600E-01,&
     & 6.226900E-01,3.313600E+00,1.232300E+01,1.837300E+01,2.716400E+01,&
     & 4.183900E+01,8.231100E+01,1.122200E+02,1.188800E+02,2.493900E-04,&
     & 6.786400E-04,1.874400E-03,6.436600E-03,2.400400E-02,6.314400E-02,&
     & 1.564800E-01,4.405400E-01,2.306000E+00,8.288500E+00,1.224900E+01,&
     & 1.810800E+01,2.789300E+01,5.487500E+01,7.481500E+01,7.924900E+01,&
     & 2.281100E-04,5.925300E-04,1.523800E-03,4.835700E-03,1.503200E-02,&
     & 3.573300E-02,8.903700E-02,2.471900E-01,1.284300E+00,4.352800E+00,&
     & 6.413000E+00,9.210300E+00,1.395300E+01,2.743800E+01,3.740800E+01,&
     & 3.962300E+01,2.055100E-04,5.146700E-04,1.029800E-03,1.442700E-03,&
     & 2.171100E-03,3.471900E-03,8.610500E-03,2.771400E-02,1.043600E-01,&
     & 2.809300E-01,6.095000E-01,9.798400E-01,1.053000E+00,1.024500E+00,&
     & 8.330800E+00,1.237700E+01,1.009300E-04,3.942400E-04,1.929500E-03,&
     & 1.072700E-02,7.681900E-02,2.590100E-01,6.744800E-01,1.958800E+00,&
     & 1.121900E+01,4.286900E+01,6.409000E+01,9.532700E+01,1.487700E+02,&
     & 2.826400E+02,3.771900E+02,3.979100E+02,2.472300E-04,7.124300E-04,&
     & 2.906800E-03,1.324700E-02,7.590500E-02,2.345100E-01,6.003800E-01,&
     & 1.720900E+00,9.818000E+00,3.751200E+01,5.607900E+01,8.341400E+01,&
     & 1.301800E+02,2.473000E+02,3.300300E+02,3.481700E+02,2.962600E-04,&
     & 8.449800E-04,3.193900E-03,1.338600E-02,7.011800E-02,2.078700E-01,&
     & 5.281700E-01,1.496300E+00,8.422800E+00,3.215300E+01,4.806800E+01,&
     & 7.150100E+01,1.115800E+02,2.119700E+02,2.828700E+02,2.984100E+02,&
     & 3.229600E-04,9.247300E-04,3.288400E-03,1.289500E-02,6.238600E-02,&
     & 1.793100E-01,4.530500E-01,1.269900E+00,7.048600E+00,2.679500E+01,&
     & 4.005900E+01,5.958200E+01,9.298400E+01,1.766600E+02,2.357300E+02,&
     & 2.486900E+02,3.334800E-04,9.748400E-04,3.182800E-03,1.207900E-02,&
     & 5.344800E-02,1.489100E-01,3.747900E-01,1.044000E+00,5.689800E+00,&
     & 2.143500E+01,3.204800E+01,4.766700E+01,7.438800E+01,1.413200E+02,&
     & 1.885900E+02,1.989600E+02,3.352200E-04,9.821600E-04,2.973900E-03,&
     & 1.084100E-02,4.359500E-02,1.169300E-01,2.936700E-01,8.123100E-01,&
     & 4.353200E+00,1.607700E+01,2.403600E+01,3.575000E+01,5.579100E+01,&
     & 1.059900E+02,1.414400E+02,1.492300E+02,3.267700E-04,9.364400E-04,&
     & 2.610000E-03,9.182600E-03,3.257200E-02,8.323000E-02,2.093300E-01,&
     & 5.721500E-01,3.031900E+00,1.083300E+01,1.602900E+01,2.383400E+01,&
     & 3.719400E+01,7.066400E+01,9.429400E+01,9.947200E+01,2.982600E-04,&
     & 8.072400E-04,2.096700E-03,6.807400E-03,2.001000E-02,4.706700E-02,&
     & 1.185200E-01,3.216500E-01,1.691600E+00,5.676400E+00,8.390200E+00,&
     & 1.214600E+01,1.861900E+01,3.533000E+01,4.714600E+01,4.973600E+01/
      data   absa(:,441:460) /                                          &
     & 2.637900E-04,6.563200E-04,1.238900E-03,1.562300E-03,2.640500E-03,&
     & 4.312900E-03,1.021500E-02,3.354100E-02,1.259300E-01,3.463800E-01,&
     & 8.322900E-01,1.177400E+00,1.046900E+00,2.856000E+00,1.095300E+01,&
     & 1.710200E+01,1.320000E-04,5.840300E-04,3.042000E-03,1.657800E-02,&
     & 1.074100E-01,3.348500E-01,8.877000E-01,2.494800E+00,1.429500E+01,&
     & 5.409800E+01,8.097700E+01,1.214300E+02,1.925900E+02,3.510200E+02,&
     & 4.595500E+02,4.834200E+02,3.336700E-04,1.022600E-03,4.356000E-03,&
     & 1.964100E-02,1.044600E-01,3.028600E-01,7.896100E-01,2.193100E+00,&
     & 1.251000E+01,4.733600E+01,7.085600E+01,1.062500E+02,1.685100E+02,&
     & 3.071600E+02,4.021400E+02,4.229500E+02,4.001100E-04,1.201100E-03,&
     & 4.691100E-03,1.951700E-02,9.578000E-02,2.680800E-01,6.942900E-01,&
     & 1.906600E+00,1.073400E+01,4.057500E+01,6.073500E+01,9.106900E+01,&
     & 1.444400E+02,2.632600E+02,3.446700E+02,3.625100E+02,4.333200E-04,&
     & 1.308900E-03,4.725200E-03,1.862700E-02,8.467600E-02,2.313500E-01,&
     & 5.950000E-01,1.619400E+00,8.981900E+00,3.381600E+01,5.061100E+01,&
     & 7.588900E+01,1.203700E+02,2.193900E+02,2.872400E+02,3.021100E+02,&
     & 4.449300E-04,1.368900E-03,4.524600E-03,1.718400E-02,7.211700E-02,&
     & 1.923600E-01,4.915800E-01,1.330500E+00,7.253000E+00,2.705200E+01,&
     & 4.048900E+01,6.071300E+01,9.629800E+01,1.755100E+02,2.297900E+02,&
     & 2.416900E+02,4.426100E-04,1.368600E-03,4.166600E-03,1.522700E-02,&
     & 5.840600E-02,1.508700E-01,3.840100E-01,1.036300E+00,5.551400E+00,&
     & 2.029100E+01,3.036800E+01,4.553700E+01,7.222200E+01,1.316400E+02,&
     & 1.723500E+02,1.812800E+02,4.261100E-04,1.284700E-03,3.629200E-03,&
     & 1.271000E-02,4.333800E-02,1.067200E-01,2.729200E-01,7.318700E-01,&
     & 3.864300E+00,1.370700E+01,2.026000E+01,3.035800E+01,4.814500E+01,&
     & 8.775900E+01,1.149000E+02,1.208300E+02,3.858100E-04,1.091600E-03,&
     & 2.860800E-03,9.314000E-03,2.614800E-02,6.049800E-02,1.536400E-01,&
     & 4.125800E-01,2.156400E+00,7.195200E+00,1.059100E+01,1.551600E+01,&
     & 2.411500E+01,4.387900E+01,5.744800E+01,6.042700E+01,3.291200E-04,&
     & 8.074500E-04,1.467700E-03,1.826600E-03,3.015200E-03,5.241200E-03,&
     & 1.214000E-02,3.946100E-02,1.500400E-01,4.893500E-01,9.645600E-01,&
     & 1.341600E+00,9.033600E-01,5.592800E+00,1.397500E+01,2.275200E+01,&
     & 1.039300E-04,2.509300E-04,8.012400E-04,4.339700E-03,3.526700E-02,&
     & 1.572900E-01,4.053200E-01,1.178600E+00,7.005000E+00,2.931700E+01,&
     & 4.540500E+01,6.934800E+01,1.072400E+02,2.051300E+02,2.934700E+02,&
     & 3.138000E+02,1.584000E-04,3.566500E-04,1.160000E-03,5.263300E-03,&
     & 3.541900E-02,1.405800E-01,3.582400E-01,1.032600E+00,6.129600E+00,&
     & 2.565200E+01,3.973000E+01,6.068000E+01,9.383400E+01,1.794800E+02,&
     & 2.567700E+02,2.745300E+02,1.720300E-04,3.870100E-04,1.257700E-03,&
     & 5.231400E-03,3.301800E-02,1.239900E-01,3.123900E-01,8.919400E-01,&
     & 5.254900E+00,2.198700E+01,3.405500E+01,5.201200E+01,8.042500E+01,&
     & 1.538400E+02,2.201000E+02,2.352600E+02,1.764800E-04,3.963100E-04,&
     & 1.291300E-03,5.001700E-03,2.965200E-02,1.059600E-01,2.673200E-01,&
     & 7.504000E-01,4.386800E+00,1.832400E+01,2.837900E+01,4.334200E+01,&
     & 6.702800E+01,1.282100E+02,1.834200E+02,1.960900E+02,1.745400E-04,&
     & 3.937200E-04,1.275800E-03,4.631400E-03,2.566100E-02,8.695300E-02,&
     & 2.202400E-01,6.110000E-01,3.524200E+00,1.465800E+01,2.270400E+01,&
     & 3.467300E+01,5.362100E+01,1.025600E+02,1.467300E+02,1.568600E+02,&
     & 1.666700E-04,3.814400E-04,1.194800E-03,4.130800E-03,2.108100E-02,&
     & 6.744900E-02,1.712300E-01,4.731100E-01,2.666900E+00,1.099400E+01,&
     & 1.702700E+01,2.600600E+01,4.021500E+01,7.692400E+01,1.100500E+02,&
     & 1.176400E+02,1.530800E-04,3.537300E-04,1.060700E-03,3.462100E-03,&
     & 1.581200E-02,4.738800E-02,1.196900E-01,3.310000E-01,1.824500E+00,&
     & 7.331300E+00,1.135200E+01,1.733800E+01,2.680800E+01,5.128100E+01,&
     & 7.336500E+01,7.845500E+01,1.293900E-04,3.142300E-04,8.246400E-04,&
     & 2.559700E-03,9.820300E-03,2.609800E-02,6.609400E-02,1.818400E-01,&
     & 9.816800E-01,3.787700E+00,5.762900E+00,8.670200E+00,1.340500E+01,&
     & 2.564000E+01,3.668500E+01,3.921900E+01,1.099300E-04,3.010400E-04,&
     & 6.857900E-04,1.258200E-03,1.503900E-03,2.492800E-03,5.421400E-03,&
     & 1.991200E-02,8.574500E-02,2.255400E-01,2.297800E-01,3.046600E-01,&
     & 7.594700E-01,9.448900E-01,2.503000E-01,4.170200E-05,1.062300E-04,&
     & 3.056100E-04,1.167300E-03,6.693400E-03,5.408800E-02,2.195700E-01,&
     & 5.660600E-01,1.657700E+00,9.955400E+00,4.154900E+01,6.451600E+01,&
     & 9.935200E+01,1.513500E+02,2.891500E+02,4.084600E+02,4.345800E+02/
      data   absa(:,461:480) /                                          &
     & 1.847300E-04,4.539700E-04,1.664200E-03,8.147700E-03,5.313700E-02,&
     & 1.964100E-01,5.005000E-01,1.452700E+00,8.711400E+00,3.635500E+01,&
     & 5.645000E+01,8.693000E+01,1.324400E+02,2.530000E+02,3.573800E+02,&
     & 3.803200E+02,2.051000E-04,5.052100E-04,1.800300E-03,8.094900E-03,&
     & 4.910200E-02,1.727200E-01,4.369300E-01,1.255700E+00,7.468700E+00,&
     & 3.116200E+01,4.838500E+01,7.451100E+01,1.135200E+02,2.168700E+02,&
     & 3.063500E+02,3.259600E+02,2.142400E-04,5.301700E-04,1.839500E-03,&
     & 7.718800E-03,4.371900E-02,1.476300E-01,3.730100E-01,1.058300E+00,&
     & 6.235100E+00,2.596800E+01,4.032100E+01,6.209300E+01,9.459600E+01,&
     & 1.807200E+02,2.553000E+02,2.716500E+02,2.152900E-04,5.336600E-04,&
     & 1.798700E-03,7.118800E-03,3.749800E-02,1.213500E-01,3.065000E-01,&
     & 8.633000E-01,5.009800E+00,2.077500E+01,3.225800E+01,4.967600E+01,&
     & 7.567700E+01,1.445800E+02,2.042300E+02,2.173600E+02,2.073200E-04,&
     & 5.281600E-04,1.675900E-03,6.297700E-03,3.062200E-02,9.435800E-02,&
     & 2.375900E-01,6.675800E-01,3.794200E+00,1.558100E+01,2.419300E+01,&
     & 3.725700E+01,5.675800E+01,1.084400E+02,1.531900E+02,1.630000E+02,&
     & 1.933200E-04,4.962000E-04,1.497700E-03,5.171300E-03,2.291400E-02,&
     & 6.624600E-02,1.661800E-01,4.665900E-01,2.598000E+00,1.038800E+01,&
     & 1.612900E+01,2.483900E+01,3.783900E+01,7.228700E+01,1.021200E+02,&
     & 1.086600E+02,1.673500E-04,4.311500E-04,1.159700E-03,3.777900E-03,&
     & 1.403600E-02,3.657900E-02,9.140600E-02,2.558500E-01,1.400100E+00,&
     & 5.386800E+00,8.174300E+00,1.241900E+01,1.891900E+01,3.614600E+01,&
     & 5.105800E+01,5.433100E+01,1.503400E-04,4.140900E-04,8.771400E-04,&
     & 1.457400E-03,1.858800E-03,3.114100E-03,6.547600E-03,2.457400E-02,&
     & 1.047800E-01,2.398300E-01,3.845000E-01,6.851000E-01,7.756800E-01,&
     & 1.010100E+00,2.226100E+00,1.060300E+01,1.188000E-04,4.093500E-04,&
     & 1.820800E-03,1.043200E-02,8.130900E-02,2.979600E-01,7.710900E-01,&
     & 2.252900E+00,1.353300E+01,5.619100E+01,8.757000E+01,1.356300E+02,&
     & 2.063400E+02,3.898100E+02,5.393400E+02,5.727900E+02,2.282100E-04,&
     & 6.219700E-04,2.507200E-03,1.242800E-02,7.851500E-02,2.664700E-01,&
     & 6.823000E-01,1.974500E+00,1.184200E+01,4.916800E+01,7.662900E+01,&
     & 1.186800E+02,1.805600E+02,3.410800E+02,4.719100E+02,5.012100E+02,&
     & 2.593500E-04,6.999500E-04,2.673600E-03,1.219600E-02,7.187300E-02,&
     & 2.343200E-01,5.954700E-01,1.707800E+00,1.015200E+01,4.214300E+01,&
     & 6.567800E+01,1.017300E+02,1.547600E+02,2.923600E+02,4.045000E+02,&
     & 4.296300E+02,2.736900E-04,7.384500E-04,2.693500E-03,1.156000E-02,&
     & 6.345500E-02,2.002800E-01,5.080300E-01,1.439500E+00,8.477100E+00,&
     & 3.511700E+01,5.473800E+01,8.476900E+01,1.289600E+02,2.436400E+02,&
     & 3.370800E+02,3.580200E+02,2.771700E-04,7.464600E-04,2.625500E-03,&
     & 1.056600E-02,5.400800E-02,1.647600E-01,4.171900E-01,1.174300E+00,&
     & 6.812300E+00,2.809600E+01,4.378500E+01,6.781800E+01,1.031700E+02,&
     & 1.949000E+02,2.696900E+02,2.863900E+02,2.678200E-04,7.405400E-04,&
     & 2.419600E-03,9.246400E-03,4.370900E-02,1.281000E-01,3.229900E-01,&
     & 9.066800E-01,5.164000E+00,2.107100E+01,3.284000E+01,5.086600E+01,&
     & 7.738400E+01,1.461700E+02,2.022500E+02,2.147900E+02,2.500200E-04,&
     & 7.003500E-04,2.107200E-03,7.615600E-03,3.227700E-02,8.998900E-02,&
     & 2.259300E-01,6.314200E-01,3.540500E+00,1.405200E+01,2.189400E+01,&
     & 3.390800E+01,5.158700E+01,9.746000E+01,1.348300E+02,1.432100E+02,&
     & 2.199300E-04,5.898500E-04,1.635000E-03,5.514100E-03,1.942400E-02,&
     & 4.974100E-02,1.245000E-01,3.447700E-01,1.911100E+00,7.290300E+00,&
     & 1.110500E+01,1.695700E+01,2.579200E+01,4.873000E+01,6.741900E+01,&
     & 7.160600E+01,1.982200E-04,5.444800E-04,1.107000E-03,1.658200E-03,&
     & 2.249800E-03,3.734700E-03,7.889200E-03,2.977100E-02,1.257300E-01,&
     & 2.834700E-01,5.052800E-01,1.046700E+00,1.144600E+00,5.891300E-01,&
     & 7.074500E+00,1.473700E+01,1.456100E-04,5.858400E-04,2.887200E-03,&
     & 1.649100E-02,1.180000E-01,3.948300E-01,1.034500E+00,2.966000E+00,&
     & 1.777100E+01,7.316200E+01,1.142100E+02,1.775300E+02,2.738800E+02,&
     & 5.042900E+02,6.828000E+02,7.260300E+02,2.966500E-04,8.903000E-04,&
     & 3.829800E-03,1.875900E-02,1.124400E-01,3.534900E-01,9.143900E-01,&
     & 2.601200E+00,1.555100E+01,6.401600E+01,9.992400E+01,1.553500E+02,&
     & 2.396300E+02,4.412400E+02,5.974500E+02,6.319900E+02,3.431800E-04,&
     & 1.001600E-03,4.002800E-03,1.825800E-02,1.021700E-01,3.105800E-01,&
     & 7.974600E-01,2.249900E+00,1.333300E+01,5.487100E+01,8.565000E+01,&
     & 1.331500E+02,2.054000E+02,3.781900E+02,5.120900E+02,5.445000E+02/
      data   absa(:,481:500) /                                          &
     & 3.628700E-04,1.049500E-03,4.009000E-03,1.710900E-02,8.956700E-02,&
     & 2.656500E-01,6.787700E-01,1.897500E+00,1.113400E+01,4.572900E+01,&
     & 7.137200E+01,1.109600E+02,1.711600E+02,3.151500E+02,4.267600E+02,&
     & 4.537900E+02,3.664200E-04,1.064500E-03,3.840000E-03,1.547200E-02,&
     & 7.566400E-02,2.191100E-01,5.562700E-01,1.546900E+00,8.951200E+00,&
     & 3.658300E+01,5.709900E+01,8.876500E+01,1.369200E+02,2.521200E+02,&
     & 3.414100E+02,3.629900E+02,3.538600E-04,1.048700E-03,3.482800E-03,&
     & 1.346300E-02,6.055900E-02,1.703200E-01,4.305300E-01,1.194100E+00,&
     & 6.787600E+00,2.743900E+01,4.282600E+01,6.657600E+01,1.027000E+02,&
     & 1.891000E+02,2.560500E+02,2.722600E+02,3.294400E-04,9.818400E-04,&
     & 2.982700E-03,1.096300E-02,4.438700E-02,1.193900E-01,3.010300E-01,&
     & 8.295600E-01,4.657700E+00,1.830900E+01,2.854900E+01,4.438400E+01,&
     & 6.846400E+01,1.260600E+02,1.707000E+02,1.815000E+02,2.881100E-04,&
     & 8.140500E-04,2.282500E-03,7.797300E-03,2.635300E-02,6.567400E-02,&
     & 1.653300E-01,4.524700E-01,2.517200E+00,9.496500E+00,1.450600E+01,&
     & 2.220600E+01,3.423300E+01,6.303400E+01,8.535300E+01,9.075500E+01,&
     & 2.531900E-04,6.770600E-04,1.330600E-03,1.833500E-03,2.724800E-03,&
     & 4.479400E-03,9.682300E-03,3.534000E-02,1.485500E-01,3.436300E-01,&
     & 6.358000E-01,1.328900E+00,1.496700E+00,1.022700E+00,1.190900E+01,&
     & 2.041800E+01,1.905400E-04,8.758900E-04,4.575800E-03,2.543000E-02,&
     & 1.647200E-01,5.129300E-01,1.346200E+00,3.825200E+00,2.268000E+01,&
     & 9.212600E+01,1.440400E+02,2.250800E+02,3.525400E+02,6.298500E+02,&
     & 8.361900E+02,8.981000E+02,3.980900E-04,1.305000E-03,5.821400E-03,&
     & 2.807800E-02,1.553800E-01,4.588900E-01,1.189100E+00,3.356000E+00,&
     & 1.984600E+01,8.061100E+01,1.260400E+02,1.969400E+02,3.084400E+02,&
     & 5.511300E+02,7.316700E+02,7.858400E+02,4.648600E-04,1.446400E-03,&
     & 5.995400E-03,2.700200E-02,1.403500E-01,4.028800E-01,1.036200E+00,&
     & 2.902500E+00,1.701900E+01,6.909500E+01,1.080300E+02,1.688100E+02,&
     & 2.644200E+02,4.724100E+02,6.271300E+02,6.735500E+02,4.919800E-04,&
     & 1.505300E-03,5.880600E-03,2.503200E-02,1.226500E-01,3.440200E-01,&
     & 8.806500E-01,2.449300E+00,1.421400E+01,5.758200E+01,9.003300E+01,&
     & 1.406800E+02,2.203500E+02,3.936800E+02,5.226200E+02,5.612600E+02,&
     & 4.937300E-04,1.517500E-03,5.545700E-03,2.239200E-02,1.031500E-01,&
     & 2.833900E-01,7.207100E-01,1.996200E+00,1.143000E+01,4.606800E+01,&
     & 7.202600E+01,1.125500E+02,1.762800E+02,3.149500E+02,4.181000E+02,&
     & 4.490100E+02,4.746200E-04,1.477900E-03,4.967100E-03,1.926100E-02,&
     & 8.213100E-02,2.199800E-01,5.579100E-01,1.536400E+00,8.674500E+00,&
     & 3.455400E+01,5.402000E+01,8.440500E+01,1.322000E+02,2.362100E+02,&
     & 3.135900E+02,3.367400E+02,4.367600E-04,1.369100E-03,4.197900E-03,&
     & 1.547400E-02,5.977100E-02,1.538300E-01,3.904400E-01,1.066200E+00,&
     & 5.953800E+00,2.307300E+01,3.601100E+01,5.626700E+01,8.813400E+01,&
     & 1.574700E+02,2.090400E+02,2.245100E+02,3.766400E-04,1.115400E-03,&
     & 3.153700E-03,1.078400E-02,3.497900E-02,8.449300E-02,2.146400E-01,&
     & 5.820700E-01,3.217500E+00,1.195400E+01,1.833400E+01,2.816800E+01,&
     & 4.406700E+01,7.873400E+01,1.045300E+02,1.122500E+02,3.122200E-04,&
     & 8.366800E-04,1.589600E-03,2.007500E-03,3.217600E-03,5.391600E-03,&
     & 1.173600E-02,4.074000E-02,1.720300E-01,4.647000E-01,7.961200E-01,&
     & 1.637100E+00,1.395100E+00,3.170400E+00,1.537200E+01,2.734500E+01,&
     & 1.107000E-04,2.698100E-04,8.695700E-04,4.927300E-03,3.964700E-02,&
     & 1.749600E-01,4.642000E-01,1.333400E+00,8.104700E+00,3.668400E+01,&
     & 5.927100E+01,9.581500E+01,1.492900E+02,2.748000E+02,3.958700E+02,&
     & 4.256400E+02,1.594800E-04,3.616500E-04,1.191800E-03,5.793100E-03,&
     & 3.895500E-02,1.562000E-01,4.098800E-01,1.168300E+00,7.092000E+00,&
     & 3.209900E+01,5.185900E+01,8.383600E+01,1.306300E+02,2.404300E+02,&
     & 3.463700E+02,3.725200E+02,1.693500E-04,3.839300E-04,1.259700E-03,&
     & 5.674600E-03,3.586600E-02,1.372000E-01,3.569800E-01,1.008000E+00,&
     & 6.080200E+00,2.751400E+01,4.445300E+01,7.186000E+01,1.119700E+02,&
     & 2.060900E+02,2.969000E+02,3.192700E+02,1.712300E-04,3.862100E-04,&
     & 1.268800E-03,5.361100E-03,3.188200E-02,1.169200E-01,3.042200E-01,&
     & 8.469500E-01,5.076100E+00,2.292700E+01,3.704400E+01,5.988500E+01,&
     & 9.330600E+01,1.717300E+02,2.474200E+02,2.660500E+02,1.674200E-04,&
     & 3.777300E-04,1.237500E-03,4.884700E-03,2.737200E-02,9.566400E-02,&
     & 2.491800E-01,6.888100E-01,4.076700E+00,1.834200E+01,2.963500E+01,&
     & 4.790700E+01,7.464800E+01,1.374000E+02,1.979400E+02,2.128700E+02/
      data   absa(:,501:520) /                                          &
     & 1.563600E-04,3.586300E-04,1.151300E-03,4.270900E-03,2.228300E-02,&
     & 7.389600E-02,1.925200E-01,5.304300E-01,3.084100E+00,1.375700E+01,&
     & 2.222600E+01,3.593100E+01,5.598400E+01,1.030500E+02,1.484400E+02,&
     & 1.596200E+02,1.410800E-04,3.272300E-04,1.011000E-03,3.485500E-03,&
     & 1.658100E-02,5.151700E-02,1.342300E-01,3.671500E-01,2.105800E+00,&
     & 9.174300E+00,1.481800E+01,2.395300E+01,3.732200E+01,6.869600E+01,&
     & 9.896400E+01,1.064300E+02,1.164100E-04,2.813600E-04,7.862000E-04,&
     & 2.488900E-03,1.013700E-02,2.813100E-02,7.316000E-02,1.974900E-01,&
     & 1.126600E+00,4.721700E+00,7.486100E+00,1.197700E+01,1.866100E+01,&
     & 3.435000E+01,4.948400E+01,5.321200E+01,9.360900E-05,2.793700E-04,&
     & 6.660700E-04,1.152600E-03,1.442800E-03,2.401100E-03,4.739600E-03,&
     & 1.881000E-02,9.085200E-02,2.606800E-01,2.202400E-01,2.403500E-01,&
     & 7.717900E-01,1.033100E+00,3.464200E-05,3.397400E-05,1.135000E-04,&
     & 3.318900E-04,1.284100E-03,7.688400E-03,6.114700E-02,2.453500E-01,&
     & 6.545000E-01,1.851000E+00,1.156700E+01,5.186800E+01,8.418500E+01,&
     & 1.369400E+02,2.121300E+02,3.843400E+02,5.527200E+02,5.969600E+02,&
     & 1.849900E-04,4.617200E-04,1.726200E-03,8.913200E-03,5.915400E-02,&
     & 2.191100E-01,5.781100E-01,1.622100E+00,1.012100E+01,4.538700E+01,&
     & 7.366500E+01,1.198200E+02,1.856200E+02,3.362900E+02,4.835900E+02,&
     & 5.223200E+02,2.015600E-04,5.022400E-04,1.822700E-03,8.677700E-03,&
     & 5.399100E-02,1.922200E-01,5.033300E-01,1.401500E+00,8.677500E+00,&
     & 3.890100E+01,6.313800E+01,1.027000E+02,1.590900E+02,2.882400E+02,&
     & 4.145500E+02,4.477400E+02,2.069000E-04,5.154600E-04,1.831000E-03,&
     & 8.178200E-03,4.763300E-02,1.639400E-01,4.280400E-01,1.179500E+00,&
     & 7.244100E+00,3.241900E+01,5.261500E+01,8.558800E+01,1.325800E+02,&
     & 2.402000E+02,3.454300E+02,3.730700E+02,2.045800E-04,5.113400E-04,&
     & 1.770200E-03,7.432700E-03,4.051500E-02,1.343900E-01,3.499600E-01,&
     & 9.604500E-01,5.818100E+00,2.593400E+01,4.209400E+01,6.846800E+01,&
     & 1.060600E+02,1.921700E+02,2.763600E+02,2.984700E+02,1.945000E-04,&
     & 4.941900E-04,1.636400E-03,6.464800E-03,3.282100E-02,1.037900E-01,&
     & 2.701900E-01,7.400200E-01,4.402700E+00,1.945200E+01,3.157000E+01,&
     & 5.135200E+01,7.954600E+01,1.441200E+02,2.072500E+02,2.238500E+02,&
     & 1.767800E-04,4.607800E-04,1.437900E-03,5.237200E-03,2.423100E-02,&
     & 7.240900E-02,1.877800E-01,5.128100E-01,3.008000E+00,1.296700E+01,&
     & 2.104600E+01,3.423400E+01,5.303300E+01,9.608200E+01,1.381800E+02,&
     & 1.492400E+02,1.498500E-04,3.950300E-04,1.099000E-03,3.698100E-03,&
     & 1.461100E-02,3.952800E-02,1.021200E-01,2.771700E-01,1.609100E+00,&
     & 6.691600E+00,1.061500E+01,1.711800E+01,2.651700E+01,4.804100E+01,&
     & 6.908600E+01,7.461900E+01,1.283900E-04,3.816500E-04,8.631400E-04,&
     & 1.337300E-03,1.779500E-03,2.936700E-03,5.950600E-03,2.286500E-02,&
     & 1.108100E-01,2.791600E-01,3.880200E-01,5.712600E-01,8.310200E-01,&
     & 1.069700E+00,1.720700E+00,1.284100E+01,1.273300E-04,4.494500E-04,&
     & 2.018300E-03,1.210700E-02,9.196200E-02,3.348900E-01,8.934800E-01,&
     & 2.525200E+00,1.575600E+01,7.008100E+01,1.139900E+02,1.860700E+02,&
     & 2.884800E+02,5.183500E+02,7.340800E+02,8.013000E+02,2.273500E-04,&
     & 6.361400E-04,2.622900E-03,1.371100E-02,8.753700E-02,2.991600E-01,&
     & 7.890000E-01,2.214000E+00,1.378700E+01,6.132200E+01,9.974900E+01,&
     & 1.628200E+02,2.524200E+02,4.535700E+02,6.422600E+02,7.010900E+02,&
     & 2.540200E-04,7.001500E-04,2.728600E-03,1.317700E-02,7.948600E-02,&
     & 2.620400E-01,6.866600E-01,1.914000E+00,1.182000E+01,5.256100E+01,&
     & 8.549600E+01,1.395600E+02,2.163500E+02,3.887600E+02,5.505200E+02,&
     & 6.009500E+02,2.644200E-04,7.230900E-04,2.713500E-03,1.225000E-02,&
     & 6.973900E-02,2.233700E-01,5.827200E-01,1.612800E+00,9.868400E+00,&
     & 4.380100E+01,7.124500E+01,1.163000E+02,1.803000E+02,3.239800E+02,&
     & 4.588400E+02,5.008200E+02,2.634800E-04,7.184000E-04,2.611200E-03,&
     & 1.103600E-02,5.895700E-02,1.831100E-01,4.760300E-01,1.313700E+00,&
     & 7.926300E+00,3.504300E+01,5.699700E+01,9.303800E+01,1.442500E+02,&
     & 2.591700E+02,3.670400E+02,4.006400E+02,2.518900E-04,6.988200E-04,&
     & 2.398700E-03,9.516000E-03,4.722200E-02,1.417100E-01,3.667700E-01,&
     & 1.011500E+00,6.001400E+00,2.628200E+01,4.274900E+01,6.978100E+01,&
     & 1.081800E+02,1.943800E+02,2.752900E+02,3.004900E+02,2.299200E-04,&
     & 6.506200E-04,2.047200E-03,7.680100E-03,3.448800E-02,9.896700E-02,&
     & 2.547300E-01,6.995700E-01,4.103000E+00,1.752600E+01,2.849900E+01,&
     & 4.651800E+01,7.211600E+01,1.295900E+02,1.835200E+02,2.003000E+02/
      data   absa(:,521:540) /                                          &
     & 1.965500E-04,5.469700E-04,1.549600E-03,5.415500E-03,2.042500E-02,&
     & 5.406200E-02,1.378900E-01,3.777600E-01,2.196900E+00,9.053000E+00,&
     & 1.438300E+01,2.325900E+01,3.605900E+01,6.479500E+01,9.175700E+01,&
     & 1.001600E+02,1.692800E-04,5.028300E-04,1.068100E-03,1.519400E-03,&
     & 2.154800E-03,3.511000E-03,7.317900E-03,2.742100E-02,1.325600E-01,&
     & 3.314500E-01,4.934200E-01,8.881300E-01,1.276900E+00,6.615200E-01,&
     & 6.455500E+00,1.760400E+01,1.562700E-04,6.494900E-04,3.221200E-03,&
     & 1.886900E-02,1.337500E-01,4.464500E-01,1.175600E+00,3.372400E+00,&
     & 2.073100E+01,9.095700E+01,1.484200E+02,2.426800E+02,3.797600E+02,&
     & 6.729200E+02,9.377800E+02,1.042400E+03,2.945600E-04,9.245900E-04,&
     & 4.050400E-03,2.081100E-02,1.259300E-01,3.988100E-01,1.037400E+00,&
     & 2.958100E+00,1.814100E+01,7.959100E+01,1.298700E+02,2.123500E+02,&
     & 3.322600E+02,5.887800E+02,8.204400E+02,9.120900E+02,3.354900E-04,&
     & 1.009600E-03,4.147200E-03,1.983300E-02,1.136200E-01,3.494000E-01,&
     & 9.017400E-01,2.556400E+00,1.555400E+01,6.822700E+01,1.113200E+02,&
     & 1.820100E+02,2.848100E+02,5.046700E+02,7.033100E+02,7.818600E+02,&
     & 3.514200E-04,1.040400E-03,4.070200E-03,1.832500E-02,9.898300E-02,&
     & 2.976400E-01,7.653300E-01,2.153000E+00,1.298900E+01,5.685900E+01,&
     & 9.277000E+01,1.516800E+02,2.373300E+02,4.205500E+02,5.860700E+02,&
     & 6.515100E+02,3.505500E-04,1.030100E-03,3.858300E-03,1.636100E-02,&
     & 8.293800E-02,2.443800E-01,6.250900E-01,1.752000E+00,1.043600E+01,&
     & 4.548800E+01,7.421600E+01,1.213400E+02,1.898600E+02,3.364500E+02,&
     & 4.688300E+02,5.212100E+02,3.347500E-04,9.970400E-04,3.474800E-03,&
     & 1.398300E-02,6.596100E-02,1.889900E-01,4.818000E-01,1.347100E+00,&
     & 7.904700E+00,3.411400E+01,5.566200E+01,9.101000E+01,1.424000E+02,&
     & 2.523400E+02,3.516600E+02,3.909200E+02,3.047300E-04,9.206400E-04,&
     & 2.926200E-03,1.116000E-02,4.784900E-02,1.316900E-01,3.351100E-01,&
     & 9.294700E-01,5.407100E+00,2.276000E+01,3.710700E+01,6.067000E+01,&
     & 9.493200E+01,1.682300E+02,2.344300E+02,2.605900E+02,2.589200E-04,&
     & 7.572600E-04,2.191400E-03,7.683700E-03,2.797700E-02,7.174500E-02,&
     & 1.818500E-01,5.011200E-01,2.896200E+00,1.175100E+01,1.876100E+01,&
     & 3.033500E+01,4.746400E+01,8.411200E+01,1.172200E+02,1.303000E+02,&
     & 2.165300E-04,6.371500E-04,1.260100E-03,1.746800E-03,2.582300E-03,&
     & 4.274400E-03,8.952300E-03,3.239300E-02,1.569000E-01,3.605300E-01,&
     & 6.819400E-01,1.123700E+00,1.681200E+00,1.139000E+00,1.088400E+01,&
     & 2.440800E+01,2.044100E-04,9.794800E-04,5.151100E-03,2.906300E-02,&
     & 1.861900E-01,5.844000E-01,1.529700E+00,4.379200E+00,2.648300E+01,&
     & 1.147800E+02,1.869400E+02,3.064200E+02,4.850800E+02,8.427300E+02,&
     & 1.162900E+03,1.310700E+03,3.946200E-04,1.369500E-03,6.219600E-03,&
     & 3.113100E-02,1.738900E-01,5.213500E-01,1.349400E+00,3.842200E+00,&
     & 2.317600E+01,1.004400E+02,1.635600E+02,2.681300E+02,4.244400E+02,&
     & 7.373900E+02,1.017500E+03,1.146700E+03,4.546100E-04,1.475500E-03,&
     & 6.259100E-03,2.946100E-02,1.561400E-01,4.560800E-01,1.172900E+00,&
     & 3.321000E+00,1.987200E+01,8.608600E+01,1.402000E+02,2.298200E+02,&
     & 3.638000E+02,6.320500E+02,8.721600E+02,9.829600E+02,4.763700E-04,&
     & 1.509800E-03,6.040200E-03,2.699300E-02,1.356300E-01,3.880400E-01,&
     & 9.940100E-01,2.798300E+00,1.659400E+01,7.174300E+01,1.168300E+02,&
     & 1.915200E+02,3.031800E+02,5.266800E+02,7.268400E+02,8.191500E+02,&
     & 4.745600E-04,1.482300E-03,5.630200E-03,2.383800E-02,1.135600E-01,&
     & 3.178400E-01,8.105200E-01,2.275500E+00,1.333900E+01,5.739400E+01,&
     & 9.347400E+01,1.532200E+02,2.425300E+02,4.213500E+02,5.814200E+02,&
     & 6.553800E+02,4.507100E-04,1.417300E-03,4.994600E-03,2.019200E-02,&
     & 8.990000E-02,2.455500E-01,6.238700E-01,1.746100E+00,1.011100E+01,&
     & 4.304600E+01,7.010700E+01,1.149100E+02,1.819000E+02,3.160200E+02,&
     & 4.360900E+02,4.914800E+02,4.080500E-04,1.291800E-03,4.164100E-03,&
     & 1.592400E-02,6.474300E-02,1.708200E-01,4.329000E-01,1.205900E+00,&
     & 6.915000E+00,2.873700E+01,4.673800E+01,7.660600E+01,1.212700E+02,&
     & 2.106900E+02,2.907300E+02,3.276600E+02,3.404700E-04,1.047200E-03,&
     & 3.058100E-03,1.073700E-02,3.743700E-02,9.283600E-02,2.343300E-01,&
     & 6.475200E-01,3.709500E+00,1.481400E+01,2.368200E+01,3.831000E+01,&
     & 6.063300E+01,1.053400E+02,1.453700E+02,1.638500E+02,2.677900E-04,&
     & 7.812000E-04,1.493200E-03,1.988400E-03,3.041600E-03,5.054600E-03,&
     & 1.084500E-02,3.707000E-02,1.818600E-01,4.514400E-01,7.505100E-01,&
     & 1.530800E+00,1.683700E+00,2.240900E+00,1.687100E+01,3.285300E+01/
      data   absa(:,541:560) /                                          &
     & 9.479600E-05,2.334700E-04,7.557000E-04,4.386900E-03,3.534800E-02,&
     & 1.554800E-01,4.216700E-01,1.211600E+00,7.469900E+00,3.596500E+01,&
     & 6.116200E+01,1.039600E+02,1.684400E+02,2.972500E+02,4.340800E+02,&
     & 4.812200E+02,1.356600E-04,3.098400E-04,1.024500E-03,5.179800E-03,&
     & 3.459400E-02,1.393400E-01,3.727600E-01,1.062700E+00,6.536400E+00,&
     & 3.147200E+01,5.351600E+01,9.097300E+01,1.473900E+02,2.600900E+02,&
     & 3.798000E+02,4.210500E+02,1.436100E-04,3.274000E-04,1.077200E-03,&
     & 5.098900E-03,3.165100E-02,1.222600E-01,3.255300E-01,9.175800E-01,&
     & 5.606200E+00,2.697500E+01,4.587100E+01,7.797300E+01,1.263300E+02,&
     & 2.229500E+02,3.255300E+02,3.608700E+02,1.447900E-04,3.283600E-04,&
     & 1.086000E-03,4.816900E-03,2.803200E-02,1.039600E-01,2.772600E-01,&
     & 7.727700E-01,4.683500E+00,2.247900E+01,3.822500E+01,6.498200E+01,&
     & 1.052800E+02,1.857800E+02,2.712900E+02,3.007600E+02,1.411800E-04,&
     & 3.196400E-04,1.052400E-03,4.379400E-03,2.397200E-02,8.506800E-02,&
     & 2.269500E-01,6.299600E-01,3.765000E+00,1.798400E+01,3.058100E+01,&
     & 5.198400E+01,8.421900E+01,1.486200E+02,2.170400E+02,2.406000E+02,&
     & 1.314700E-04,3.030700E-04,9.755700E-04,3.783900E-03,1.947600E-02,&
     & 6.571100E-02,1.752200E-01,4.848700E-01,2.855500E+00,1.348800E+01,&
     & 2.293600E+01,3.899100E+01,6.316700E+01,1.114700E+02,1.627800E+02,&
     & 1.804600E+02,1.181900E-04,2.756200E-04,8.561000E-04,3.052100E-03,&
     & 1.452000E-02,4.570200E-02,1.218400E-01,3.353600E-01,1.956000E+00,&
     & 9.023200E+00,1.529100E+01,2.599200E+01,4.211000E+01,7.431400E+01,&
     & 1.085100E+02,1.203000E+02,9.717000E-05,2.356400E-04,6.622000E-04,&
     & 2.158700E-03,8.848300E-03,2.487300E-02,6.614300E-02,1.796400E-01,&
     & 1.051500E+00,4.664800E+00,7.772200E+00,1.300300E+01,2.105500E+01,&
     & 3.715800E+01,5.425400E+01,6.014800E+01,7.630300E-05,2.367400E-04,&
     & 5.796000E-04,9.478400E-04,1.207300E-03,2.074000E-03,4.003000E-03,&
     & 1.546800E-02,8.527300E-02,2.470500E-01,3.050100E-01,2.889600E-01,&
     & 6.474600E-01,8.588300E-01,3.338700E-01,7.399300E+00,9.738700E-05,&
     & 2.902700E-04,1.128900E-03,6.948100E-03,5.465700E-02,2.189700E-01,&
     & 6.014000E-01,1.681800E+00,1.068000E+01,5.080000E+01,8.664300E+01,&
     & 1.481700E+02,2.397400E+02,4.129400E+02,6.111300E+02,6.920600E+02,&
     & 1.574200E-04,3.985700E-04,1.499500E-03,8.052500E-03,5.271700E-02,&
     & 1.963100E-01,5.318800E-01,1.475500E+00,9.345400E+00,4.445100E+01,&
     & 7.581500E+01,1.296500E+02,2.097800E+02,3.613400E+02,5.348200E+02,&
     & 6.055700E+02,1.711500E-04,4.317000E-04,1.573600E-03,7.845800E-03,&
     & 4.788000E-02,1.724000E-01,4.638000E-01,1.274600E+00,8.016500E+00,&
     & 3.810100E+01,6.498400E+01,1.111300E+02,1.798100E+02,3.097100E+02,&
     & 4.584100E+02,5.190700E+02,1.753500E-04,4.414400E-04,1.576100E-03,&
     & 7.331400E-03,4.216900E-02,1.467600E-01,3.936500E-01,1.074800E+00,&
     & 6.697600E+00,3.175200E+01,5.415300E+01,9.260400E+01,1.498300E+02,&
     & 2.580900E+02,3.820100E+02,4.325500E+02,1.730000E-04,4.348200E-04,&
     & 1.519100E-03,6.607800E-03,3.591900E-02,1.200300E-01,3.218400E-01,&
     & 8.763400E-01,5.385400E+00,2.540300E+01,4.332400E+01,7.408900E+01,&
     & 1.198700E+02,2.064900E+02,3.056000E+02,3.460300E+02,1.638300E-04,&
     & 4.194300E-04,1.405500E-03,5.710000E-03,2.902800E-02,9.264500E-02,&
     & 2.477800E-01,6.737700E-01,4.087700E+00,1.905300E+01,3.249300E+01,&
     & 5.556200E+01,8.990100E+01,1.548700E+02,2.292000E+02,2.595500E+02,&
     & 1.482400E-04,3.894300E-04,1.221300E-03,4.566300E-03,2.142400E-02,&
     & 6.453800E-02,1.719000E-01,4.651800E-01,2.803600E+00,1.273900E+01,&
     & 2.166200E+01,3.704300E+01,5.993700E+01,1.032400E+02,1.527900E+02,&
     & 1.730200E+02,1.251300E-04,3.319400E-04,9.339000E-04,3.213600E-03,&
     & 1.283200E-02,3.519100E-02,9.302300E-02,2.490100E-01,1.507800E+00,&
     & 6.598200E+00,1.101600E+01,1.852300E+01,2.996700E+01,5.162100E+01,&
     & 7.639700E+01,8.650800E+01,1.046900E-04,3.236500E-04,7.529500E-04,&
     & 1.096100E-03,1.499700E-03,2.512400E-03,5.110400E-03,1.870900E-02,&
     & 1.041100E-01,2.894100E-01,3.806900E-01,6.407100E-01,7.797700E-01,&
     & 7.440300E-01,3.406000E+00,1.550100E+01,1.094800E-04,3.952400E-04,&
     & 1.789100E-03,1.102100E-02,8.259300E-02,3.009300E-01,8.180700E-01,&
     & 2.286100E+00,1.462000E+01,6.839300E+01,1.169700E+02,2.005600E+02,&
     & 3.261700E+02,5.548400E+02,8.203300E+02,9.470300E+02,1.935400E-04,&
     & 5.547200E-04,2.294200E-03,1.245800E-02,7.866800E-02,2.695400E-01,&
     & 7.229500E-01,2.007100E+00,1.279300E+01,5.984600E+01,1.023500E+02,&
     & 1.754900E+02,2.854000E+02,4.854800E+02,7.178000E+02,8.286700E+02/
      data   absa(:,561:580) /                                          &
     & 2.160100E-04,6.067600E-04,2.370900E-03,1.197700E-02,7.103800E-02,&
     & 2.361800E-01,6.300400E-01,1.735800E+00,1.097300E+01,5.129600E+01,&
     & 8.772700E+01,1.504200E+02,2.446200E+02,4.161100E+02,6.152500E+02,&
     & 7.103000E+02,2.245000E-04,6.231900E-04,2.351300E-03,1.102100E-02,&
     & 6.222600E-02,2.011900E-01,5.345700E-01,1.464400E+00,9.167800E+00,&
     & 4.274600E+01,7.310700E+01,1.253500E+02,2.038600E+02,3.467700E+02,&
     & 5.127200E+02,5.918900E+02,2.232100E-04,6.159700E-04,2.264600E-03,&
     & 9.825800E-03,5.255500E-02,1.647800E-01,4.364300E-01,1.194000E+00,&
     & 7.373500E+00,3.419900E+01,5.848600E+01,1.002800E+02,1.630900E+02,&
     & 2.774100E+02,4.101700E+02,4.735400E+02,2.128700E-04,5.971000E-04,&
     & 2.061600E-03,8.408300E-03,4.198000E-02,1.274000E-01,3.360500E-01,&
     & 9.183700E-01,5.597200E+00,2.565000E+01,4.386300E+01,7.521000E+01,&
     & 1.223100E+02,2.080600E+02,3.076400E+02,3.551200E+02,1.935000E-04,&
     & 5.527800E-04,1.754500E-03,6.741900E-03,3.059500E-02,8.884800E-02,&
     & 2.329200E-01,6.351300E-01,3.838200E+00,1.715100E+01,2.924200E+01,&
     & 5.013800E+01,8.154400E+01,1.387100E+02,2.050900E+02,2.367500E+02,&
     & 1.643300E-04,4.621300E-04,1.328300E-03,4.694700E-03,1.805700E-02,&
     & 4.836600E-02,1.254900E-01,3.422600E-01,2.061800E+00,8.889000E+00,&
     & 1.487900E+01,2.508000E+01,4.077000E+01,6.935100E+01,1.025400E+02,&
     & 1.183800E+02,1.381900E-04,4.255200E-04,9.211900E-04,1.223800E-03,&
     & 1.848400E-03,3.038500E-03,6.434700E-03,2.246400E-02,1.238600E-01,&
     & 3.377600E-01,4.951000E-01,7.607300E-01,1.511800E+00,6.577900E-01,&
     & 7.384800E+00,2.102900E+01,1.344500E-04,5.748600E-04,2.887200E-03,&
     & 1.731000E-02,1.196800E-01,4.048000E-01,1.077800E+00,3.074700E+00,&
     & 1.925800E+01,8.895700E+01,1.518600E+02,2.610700E+02,4.266500E+02,&
     & 7.201600E+02,1.062300E+03,1.233800E+03,2.508300E-04,8.139300E-04,&
     & 3.567500E-03,1.892300E-02,1.126900E-01,3.624000E-01,9.521600E-01,&
     & 2.700300E+00,1.685200E+01,7.783700E+01,1.328800E+02,2.284200E+02,&
     & 3.733200E+02,6.301700E+02,9.295200E+02,1.085400E+03,2.854900E-04,&
     & 8.821600E-04,3.637200E-03,1.800100E-02,1.013400E-01,3.171500E-01,&
     & 8.289000E-01,2.336500E+00,1.445500E+01,6.672100E+01,1.138900E+02,&
     & 1.958100E+02,3.199900E+02,5.401500E+02,7.967100E+02,9.302600E+02,&
     & 2.984700E-04,9.045400E-04,3.562800E-03,1.650900E-02,8.827700E-02,&
     & 2.698300E-01,7.021100E-01,1.971200E+00,1.207900E+01,5.560400E+01,&
     & 9.491600E+01,1.631700E+02,2.666700E+02,4.501300E+02,6.639000E+02,&
     & 7.752600E+02,2.972500E-04,8.920600E-04,3.340700E-03,1.465700E-02,&
     & 7.412500E-02,2.207600E-01,5.725900E-01,1.605000E+00,9.719700E+00,&
     & 4.448500E+01,7.593600E+01,1.305400E+02,2.133300E+02,3.601000E+02,&
     & 5.311100E+02,6.201800E+02,2.834300E-04,8.556600E-04,3.003100E-03,&
     & 1.241900E-02,5.901900E-02,1.703900E-01,4.407800E-01,1.232400E+00,&
     & 7.381700E+00,3.336400E+01,5.694900E+01,9.790100E+01,1.599900E+02,&
     & 2.700700E+02,3.983400E+02,4.651300E+02,2.576300E-04,7.849900E-04,&
     & 2.520700E-03,9.854800E-03,4.272600E-02,1.184700E-01,3.051100E-01,&
     & 8.508200E-01,5.063900E+00,2.233100E+01,3.796700E+01,6.526700E+01,&
     & 1.066700E+02,1.800400E+02,2.655600E+02,3.100900E+02,2.172000E-04,&
     & 6.442200E-04,1.886300E-03,6.691600E-03,2.487900E-02,6.438800E-02,&
     & 1.645600E-01,4.576100E-01,2.722500E+00,1.155400E+01,1.934200E+01,&
     & 3.266500E+01,5.333200E+01,9.002500E+01,1.327800E+02,1.542300E+02,&
     & 1.760100E-04,5.347600E-04,1.088800E-03,1.432600E-03,2.211300E-03,&
     & 3.694900E-03,7.849000E-03,2.627900E-02,1.461000E-01,3.940000E-01,&
     & 5.791200E-01,1.055000E+00,1.665200E+00,1.113300E+00,1.331000E+01,&
     & 2.912200E+01,1.757300E-04,8.724600E-04,4.650900E-03,2.661900E-02,&
     & 1.669400E-01,5.310900E-01,1.386800E+00,4.046200E+00,2.462100E+01,&
     & 1.124800E+02,1.907800E+02,3.281800E+02,5.409800E+02,9.055100E+02,&
     & 1.330800E+03,1.569500E+03,3.365700E-04,1.212200E-03,5.532700E-03,&
     & 2.829600E-02,1.560600E-01,4.745100E-01,1.224600E+00,3.554700E+00,&
     & 2.154600E+01,9.842200E+01,1.669400E+02,2.871700E+02,4.733600E+02,&
     & 7.923500E+02,1.164500E+03,1.373400E+03,3.871000E-04,1.298900E-03,&
     & 5.499400E-03,2.662300E-02,1.399300E-01,4.146100E-01,1.064700E+00,&
     & 3.075200E+00,1.848500E+01,8.435900E+01,1.430900E+02,2.461300E+02,&
     & 4.057300E+02,6.791600E+02,9.981300E+02,1.177200E+03,4.056000E-04,&
     & 1.322100E-03,5.286200E-03,2.418700E-02,1.214600E-01,3.523900E-01,&
     & 9.015000E-01,2.594800E+00,1.544800E+01,7.029600E+01,1.192400E+02,&
     & 2.051200E+02,3.381100E+02,5.659600E+02,8.317400E+02,9.810400E+02/
      data   absa(:,581:585) /                                          &
     & 4.035700E-04,1.295500E-03,4.899300E-03,2.129400E-02,1.015800E-01,&
     & 2.879000E-01,7.354700E-01,2.110700E+00,1.243200E+01,5.624000E+01,&
     & 9.539400E+01,1.640900E+02,2.704800E+02,4.527600E+02,6.654200E+02,&
     & 7.848400E+02,3.825700E-04,1.226000E-03,4.353400E-03,1.793900E-02,&
     & 8.036800E-02,2.220200E-01,5.661500E-01,1.618800E+00,9.445400E+00,&
     & 4.218200E+01,7.154600E+01,1.230700E+02,2.028600E+02,3.395800E+02,&
     & 4.990700E+02,5.886000E+02,3.465300E-04,1.107100E-03,3.609200E-03,&
     & 1.410300E-02,5.774200E-02,1.543500E-01,3.919100E-01,1.115900E+00,&
     & 6.477100E+00,2.827400E+01,4.769700E+01,8.204000E+01,1.352500E+02,&
     & 2.263800E+02,3.327100E+02,3.924000E+02,2.868500E-04,8.917400E-04,&
     & 2.644700E-03,9.414100E-03,3.336100E-02,8.362800E-02,2.113500E-01,&
     & 5.982500E-01,3.485300E+00,1.461400E+01,2.432700E+01,4.109300E+01,&
     & 6.761900E+01,1.131900E+02,1.663500E+02,1.962000E+02,2.185500E-04,&
     & 6.584900E-04,1.271500E-03,1.671200E-03,2.620900E-03,4.308700E-03,&
     & 9.690300E-03,3.026100E-02,1.700700E-01,4.629400E-01,6.700000E-01,&
     & 1.406900E+00,1.727400E+00,2.547400E+00,1.849900E+01,3.928900E+01/

! --- the array absb(NG03,1175) = kb(NG03,5,5,13:59) contains absorption
!     coefs at the NG03=16 g-intervals for a range of pressure levels <
!     ~100mb, temperatures, and ratios of h2o to co2. the first index in
!     the array, js, runs from 1 to 5, and corresponds to different gas
!     amount ratios, as expressed through the binary species parameter
!     eta, defined as eta = gas1/(gas1+rat*gas2), where rat is the ratio
!     of the reference mls column amount value of gas1 to that of gas2.
!     the second index, jt, which runs from 1 to 5, corresponds to
!     different temperatures.  more specifically, jt = 1-5 means that
!     the data are for the corresponding temperature of tref-30, tref-15,
!     tref, tref+15, and tref+30, respectively.  the third index, jp,
!     runs from 13 to 59 and refers to the reference pressure level (e.g.
!     jp = 13 is for a pressure of 95.5835 mb). the fourth index, ig,
!     goes from 1 to NG03=16, and tells us which g-interval the absorption
!     coefficients are for.

      data   absb(:,  1: 20) /                                          &
     & 9.479600E-05,2.334700E-04,7.557000E-04,4.386900E-03,3.534800E-02,&
     & 1.554800E-01,4.216700E-01,1.211600E+00,7.469900E+00,3.596500E+01,&
     & 6.116200E+01,1.039600E+02,1.684400E+02,2.972500E+02,4.340800E+02,&
     & 4.812200E+02,1.436100E-04,3.274000E-04,1.077200E-03,5.098900E-03,&
     & 3.165100E-02,1.222600E-01,3.255300E-01,9.175800E-01,5.606200E+00,&
     & 2.697500E+01,4.587100E+01,7.797300E+01,1.263300E+02,2.229500E+02,&
     & 3.255300E+02,3.608700E+02,1.411800E-04,3.196400E-04,1.052400E-03,&
     & 4.379400E-03,2.397200E-02,8.506800E-02,2.269500E-01,6.299600E-01,&
     & 3.765000E+00,1.798400E+01,3.058100E+01,5.198400E+01,8.421900E+01,&
     & 1.486200E+02,2.170400E+02,2.406000E+02,1.181900E-04,2.756200E-04,&
     & 8.561000E-04,3.052100E-03,1.452000E-02,4.570200E-02,1.218400E-01,&
     & 3.353600E-01,1.956000E+00,9.023200E+00,1.529100E+01,2.599200E+01,&
     & 4.211000E+01,7.431400E+01,1.085100E+02,1.203000E+02,7.630300E-05,&
     & 2.367400E-04,5.796000E-04,9.478400E-04,1.207300E-03,2.074000E-03,&
     & 4.003000E-03,1.546800E-02,8.527300E-02,2.470500E-01,3.050100E-01,&
     & 2.889600E-01,6.474600E-01,8.588300E-01,3.338700E-01,7.399300E+00,&
     & 9.738700E-05,2.902700E-04,1.128900E-03,6.948100E-03,5.465700E-02,&
     & 2.189700E-01,6.014000E-01,1.681800E+00,1.068000E+01,5.080000E+01,&
     & 8.664300E+01,1.481700E+02,2.397400E+02,4.129400E+02,6.111300E+02,&
     & 6.920600E+02,1.711500E-04,4.317000E-04,1.573600E-03,7.845800E-03,&
     & 4.788000E-02,1.724000E-01,4.638000E-01,1.274600E+00,8.016500E+00,&
     & 3.810100E+01,6.498400E+01,1.111300E+02,1.798100E+02,3.097100E+02,&
     & 4.584100E+02,5.190700E+02,1.730000E-04,4.348200E-04,1.519100E-03,&
     & 6.607800E-03,3.591900E-02,1.200300E-01,3.218400E-01,8.763400E-01,&
     & 5.385400E+00,2.540300E+01,4.332400E+01,7.408900E+01,1.198700E+02,&
     & 2.064900E+02,3.056000E+02,3.460300E+02,1.482400E-04,3.894300E-04,&
     & 1.221300E-03,4.566300E-03,2.142400E-02,6.453800E-02,1.719000E-01,&
     & 4.651800E-01,2.803600E+00,1.273900E+01,2.166200E+01,3.704300E+01,&
     & 5.993700E+01,1.032400E+02,1.527900E+02,1.730200E+02,1.046900E-04,&
     & 3.236500E-04,7.529500E-04,1.096100E-03,1.499700E-03,2.512400E-03,&
     & 5.110400E-03,1.870900E-02,1.041100E-01,2.894100E-01,3.806900E-01,&
     & 6.407100E-01,7.797700E-01,7.440300E-01,3.406000E+00,1.550100E+01,&
     & 1.095100E-04,3.953400E-04,1.789600E-03,1.102300E-02,8.260200E-02,&
     & 3.009500E-01,8.181600E-01,2.286500E+00,1.462300E+01,6.840900E+01,&
     & 1.170000E+02,2.006100E+02,3.262600E+02,5.550200E+02,8.206200E+02,&
     & 9.473800E+02,2.160400E-04,6.068400E-04,2.371400E-03,1.198000E-02,&
     & 7.104500E-02,2.362100E-01,6.301500E-01,1.736000E+00,1.097600E+01,&
     & 5.130900E+01,8.775100E+01,1.504600E+02,2.446900E+02,4.162500E+02,&
     & 6.154700E+02,7.105600E+02,2.232300E-04,6.160200E-04,2.265000E-03,&
     & 9.828000E-03,5.256200E-02,1.647900E-01,4.365000E-01,1.194200E+00,&
     & 7.375200E+00,3.420800E+01,5.850200E+01,1.003000E+02,1.631300E+02,&
     & 2.775100E+02,4.103100E+02,4.737200E+02,1.935000E-04,5.528100E-04,&
     & 1.754700E-03,6.743100E-03,3.059900E-02,8.885900E-02,2.329600E-01,&
     & 6.352500E-01,3.839100E+00,1.715600E+01,2.925000E+01,5.015200E+01,&
     & 8.156600E+01,1.387500E+02,2.051600E+02,2.368300E+02,1.381800E-04,&
     & 4.255000E-04,9.211300E-04,1.224000E-03,1.848700E-03,3.038200E-03,&
     & 6.436500E-03,2.246900E-02,1.239000E-01,3.377100E-01,4.949100E-01,&
     & 7.611600E-01,1.511800E+00,6.600800E-01,7.388900E+00,2.104000E+01,&
     & 1.344900E-04,5.750100E-04,2.888100E-03,1.731600E-02,1.197000E-01,&
     & 4.048500E-01,1.078000E+00,3.075400E+00,1.926400E+01,8.898100E+01,&
     & 1.519000E+02,2.611400E+02,4.267600E+02,7.202900E+02,1.062500E+03,&
     & 1.240600E+03,2.855200E-04,8.822900E-04,3.638100E-03,1.800700E-02,&
     & 1.013600E-01,3.171900E-01,8.290800E-01,2.337100E+00,1.445900E+01,&
     & 6.673900E+01,1.139200E+02,1.958600E+02,3.200600E+02,5.402400E+02,&
     & 7.968400E+02,9.304200E+02,2.972800E-04,8.921400E-04,3.341400E-03,&
     & 1.466100E-02,7.413900E-02,2.207900E-01,5.727100E-01,1.605400E+00,&
     & 9.722600E+00,4.449700E+01,7.595500E+01,1.305700E+02,2.133800E+02,&
     & 3.601700E+02,5.312000E+02,6.202900E+02,2.576400E-04,7.850400E-04,&
     & 2.521100E-03,9.856800E-03,4.273300E-02,1.184800E-01,3.051900E-01,&
     & 8.510200E-01,5.065400E+00,2.233700E+01,3.797700E+01,6.528400E+01,&
     & 1.066900E+02,1.800800E+02,2.656000E+02,3.101400E+02,1.759700E-04,&
     & 5.348100E-04,1.088600E-03,1.432600E-03,2.211700E-03,3.695900E-03,&
     & 7.851400E-03,2.628800E-02,1.461600E-01,3.941800E-01,5.790800E-01,&
     & 1.055300E+00,1.664200E+00,1.115500E+00,1.332400E+01,2.913900E+01/
      data   absb(:, 21: 40) /                                          &
     & 1.757700E-04,8.727400E-04,4.652600E-03,2.662800E-02,1.669700E-01,&
     & 5.311800E-01,1.387100E+00,4.047300E+00,2.462900E+01,1.125200E+02,&
     & 1.908500E+02,3.283100E+02,5.411900E+02,9.059200E+02,1.331400E+03,&
     & 1.570300E+03,3.871400E-04,1.299200E-03,5.501200E-03,2.663200E-02,&
     & 1.399600E-01,4.146700E-01,1.065000E+00,3.076100E+00,1.849100E+01,&
     & 8.438900E+01,1.431400E+02,2.462200E+02,4.058900E+02,6.794600E+02,&
     & 9.986100E+02,1.177800E+03,4.035900E-04,1.295700E-03,4.900500E-03,&
     & 2.130100E-02,1.016000E-01,2.879600E-01,7.356600E-01,2.111300E+00,&
     & 1.243700E+01,5.626000E+01,9.542900E+01,1.641500E+02,2.705900E+02,&
     & 4.529600E+02,6.657500E+02,7.852200E+02,3.465400E-04,1.107200E-03,&
     & 3.609900E-03,1.410700E-02,5.775500E-02,1.543800E-01,3.920200E-01,&
     & 1.116200E+00,6.479200E+00,2.828400E+01,4.771500E+01,8.207100E+01,&
     & 1.353000E+02,2.264800E+02,3.328700E+02,3.925900E+02,2.185100E-04,&
     & 6.584500E-04,1.271500E-03,1.671500E-03,2.621000E-03,4.310300E-03,&
     & 9.693100E-03,3.027600E-02,1.701400E-01,4.634800E-01,6.697900E-01,&
     & 1.406700E+00,1.731300E+00,2.546500E+00,1.851000E+01,3.930800E+01,&
     & 7.900000E-05,2.001900E-04,6.562800E-04,3.885600E-03,3.141300E-02,&
     & 1.373200E-01,3.842500E-01,1.107800E+00,6.893800E+00,3.477300E+01,&
     & 6.201400E+01,1.113500E+02,1.904100E+02,3.243500E+02,4.892700E+02,&
     & 5.757600E+02,1.211300E-04,2.799900E-04,9.236900E-04,4.561500E-03,&
     & 2.797100E-02,1.082500E-01,2.980100E-01,8.405900E-01,5.178300E+00,&
     & 2.607900E+01,4.651100E+01,8.351200E+01,1.428100E+02,2.432600E+02,&
     & 3.669600E+02,4.318200E+02,1.192000E-04,2.724800E-04,9.024900E-04,&
     & 3.890700E-03,2.108900E-02,7.539700E-02,2.068800E-01,5.794600E-01,&
     & 3.487500E+00,1.738600E+01,3.100700E+01,5.567600E+01,9.520500E+01,&
     & 1.621700E+02,2.446500E+02,2.878800E+02,9.966400E-05,2.356100E-04,&
     & 7.314400E-04,2.692400E-03,1.278200E-02,4.049500E-02,1.105500E-01,&
     & 3.061200E-01,1.826400E+00,8.785000E+00,1.550400E+01,2.783900E+01,&
     & 4.760400E+01,8.109200E+01,1.223300E+02,1.439400E+02,6.364600E-05,&
     & 2.089200E-04,5.216600E-04,7.676300E-04,9.983400E-04,1.753800E-03,&
     & 3.466800E-03,1.206300E-02,7.671400E-02,2.351400E-01,3.559200E-01,&
     & 4.105300E-01,4.859300E-01,7.809800E-01,1.463900E+00,1.400900E+01,&
     & 8.187000E-05,2.525200E-04,1.000100E-03,6.225300E-03,4.900100E-02,&
     & 1.946300E-01,5.438600E-01,1.533500E+00,9.852700E+00,4.875400E+01,&
     & 8.723800E+01,1.569500E+02,2.694300E+02,4.489200E+02,6.924700E+02,&
     & 8.324400E+02,1.452600E-04,3.744800E-04,1.368100E-03,7.052800E-03,&
     & 4.266900E-02,1.534400E-01,4.209300E-01,1.166100E+00,7.400600E+00,&
     & 3.656500E+01,6.543100E+01,1.177100E+02,2.020700E+02,3.366800E+02,&
     & 5.193800E+02,6.243100E+02,1.470500E-04,3.754600E-04,1.319700E-03,&
     & 5.896800E-03,3.189000E-02,1.067000E-01,2.917700E-01,8.049900E-01,&
     & 4.985100E+00,2.437600E+01,4.362100E+01,7.847500E+01,1.347200E+02,&
     & 2.244400E+02,3.462400E+02,4.161900E+02,1.255700E-04,3.347800E-04,&
     & 1.046900E-03,4.041800E-03,1.890100E-02,5.741700E-02,1.554400E-01,&
     & 4.262700E-01,2.610600E+00,1.231600E+01,2.181100E+01,3.924000E+01,&
     & 6.736000E+01,1.122300E+02,1.731100E+02,2.080900E+02,8.637600E-05,&
     & 2.857400E-04,6.614800E-04,8.605100E-04,1.274900E-03,2.172500E-03,&
     & 4.542900E-03,1.471800E-02,9.207700E-02,2.903500E-01,3.921900E-01,&
     & 6.237200E-01,1.052300E+00,5.460200E-01,5.016100E+00,1.913500E+01,&
     & 9.297500E-05,3.459900E-04,1.603700E-03,1.000200E-02,7.364800E-02,&
     & 2.689600E-01,7.399800E-01,2.088400E+00,1.346400E+01,6.553500E+01,&
     & 1.171400E+02,2.112100E+02,3.632600E+02,6.009900E+02,9.369300E+02,&
     & 1.139200E+03,1.845100E-04,5.324600E-04,2.085900E-03,1.075200E-02,&
     & 6.316900E-02,2.117300E-01,5.713700E-01,1.588600E+00,1.011500E+01,&
     & 4.915100E+01,8.785100E+01,1.584100E+02,2.724400E+02,4.507500E+02,&
     & 7.026300E+02,8.543600E+02,1.906300E-04,5.378800E-04,1.973800E-03,&
     & 8.858200E-03,4.655700E-02,1.473900E-01,3.949700E-01,1.094900E+00,&
     & 6.818800E+00,3.276900E+01,5.857000E+01,1.056000E+02,1.816200E+02,&
     & 3.004900E+02,4.683900E+02,5.695600E+02,1.648900E-04,4.775100E-04,&
     & 1.515100E-03,6.006500E-03,2.714000E-02,7.925400E-02,2.099500E-01,&
     & 5.805000E-01,3.570700E+00,1.656600E+01,2.928700E+01,5.280200E+01,&
     & 9.081300E+01,1.502500E+02,2.342200E+02,2.848000E+02,1.134800E-04,&
     & 3.697800E-04,7.935000E-04,1.006500E-03,1.554500E-03,2.681000E-03,&
     & 5.617100E-03,1.785700E-02,1.092600E-01,3.540100E-01,4.429200E-01,&
     & 8.030100E-01,1.465800E+00,1.032500E+00,9.213600E+00,2.579800E+01/
      data   absb(:, 41: 60) /                                          &
     & 1.149900E-04,5.087300E-04,2.622500E-03,1.569900E-02,1.063300E-01,&
     & 3.629400E-01,9.764200E-01,2.812000E+00,1.771700E+01,8.515200E+01,&
     & 1.513900E+02,2.731300E+02,4.708200E+02,7.793700E+02,1.219800E+03,&
     & 1.497000E+03,2.447800E-04,7.799200E-04,3.228400E-03,1.622900E-02,&
     & 9.003500E-02,2.844600E-01,7.524600E-01,2.141300E+00,1.331100E+01,&
     & 6.387100E+01,1.135400E+02,2.048500E+02,3.531200E+02,5.845300E+02,&
     & 9.148400E+02,1.122600E+03,2.546000E-04,7.860700E-04,2.928100E-03,&
     & 1.316300E-02,6.578800E-02,1.976100E-01,5.195200E-01,1.474500E+00,&
     & 8.974900E+00,4.258300E+01,7.569900E+01,1.365700E+02,2.354200E+02,&
     & 3.896900E+02,6.098900E+02,7.484400E+02,2.203100E-04,6.814500E-04,&
     & 2.194100E-03,8.797000E-03,3.784200E-02,1.059100E-01,2.757700E-01,&
     & 7.809800E-01,4.700000E+00,2.154300E+01,3.786400E+01,6.828300E+01,&
     & 1.177100E+02,1.948500E+02,3.049500E+02,3.742300E+02,1.445100E-04,&
     & 4.636900E-04,9.271600E-04,1.222700E-03,1.868000E-03,3.174800E-03,&
     & 6.986700E-03,2.100700E-02,1.281500E-01,4.095200E-01,5.246000E-01,&
     & 1.017000E+00,1.612000E+00,1.501600E+00,1.601500E+01,3.561200E+01,&
     & 1.507700E-04,7.793700E-04,4.243700E-03,2.426900E-02,1.484700E-01,&
     & 4.775200E-01,1.261000E+00,3.698900E+00,2.268100E+01,1.071400E+02,&
     & 1.898200E+02,3.412400E+02,5.908600E+02,9.803400E+02,1.542400E+03,&
     & 1.899900E+03,3.322800E-04,1.154400E-03,4.900200E-03,2.403000E-02,&
     & 1.245200E-01,3.732300E-01,9.701700E-01,2.818900E+00,1.704100E+01,&
     & 8.035400E+01,1.423500E+02,2.559200E+02,4.431200E+02,7.352700E+02,&
     & 1.156800E+03,1.424900E+03,3.458000E-04,1.146400E-03,4.318700E-03,&
     & 1.913700E-02,9.018000E-02,2.590500E-01,6.688800E-01,1.939600E+00,&
     & 1.149200E+01,5.357000E+01,9.490800E+01,1.706200E+02,2.954200E+02,&
     & 4.901800E+02,7.712200E+02,9.498500E+02,2.971600E-04,9.630000E-04,&
     & 3.169100E-03,1.253600E-02,5.112300E-02,1.386400E-01,3.542700E-01,&
     & 1.025700E+00,6.017800E+00,2.712700E+01,4.748400E+01,8.530800E+01,&
     & 1.477100E+02,2.451000E+02,3.856000E+02,4.749800E+02,1.779800E-04,&
     & 5.708400E-04,1.060900E-03,1.447400E-03,2.212400E-03,3.768400E-03,&
     & 8.653500E-03,2.429500E-02,1.488500E-01,4.686100E-01,6.625700E-01,&
     & 1.106400E+00,1.846200E+00,3.489400E+00,2.060700E+01,4.789700E+01,&
     & 6.314600E-05,1.649600E-04,5.502100E-04,3.265900E-03,2.669100E-02,&
     & 1.160900E-01,3.329900E-01,9.704200E-01,6.104700E+00,3.170800E+01,&
     & 5.918600E+01,1.118600E+02,2.033100E+02,3.443000E+02,5.441900E+02,&
     & 6.768600E+02,9.937300E-05,2.331300E-04,7.705800E-04,3.877000E-03,&
     & 2.376700E-02,9.186400E-02,2.593300E-01,7.394700E-01,4.590800E+00,&
     & 2.378000E+01,4.438800E+01,8.389700E+01,1.524900E+02,2.582300E+02,&
     & 4.081500E+02,5.075800E+02,9.837300E-05,2.274500E-04,7.499700E-04,&
     & 3.310100E-03,1.791800E-02,6.405600E-02,1.799100E-01,5.103400E-01,&
     & 3.107400E+00,1.585400E+01,2.959200E+01,5.593500E+01,1.016500E+02,&
     & 1.721500E+02,2.720900E+02,3.384500E+02,8.269100E-05,1.981500E-04,&
     & 6.072100E-04,2.304800E-03,1.084600E-02,3.449600E-02,9.590500E-02,&
     & 2.694900E-01,1.639200E+00,8.078000E+00,1.484100E+01,2.796600E+01,&
     & 5.082800E+01,8.607100E+01,1.360500E+02,1.692200E+02,5.239700E-05,&
     & 1.719100E-04,4.551300E-04,5.757300E-04,8.437600E-04,1.472400E-03,&
     & 2.988600E-03,9.793800E-03,6.276800E-02,2.272500E-01,3.202100E-01,&
     & 4.895200E-01,7.021100E-01,4.744200E-01,3.320500E+00,1.723200E+01,&
     & 6.607800E-05,2.099500E-04,8.504600E-04,5.324100E-03,4.156300E-02,&
     & 1.657500E-01,4.696200E-01,1.343600E+00,8.701900E+00,4.429900E+01,&
     & 8.263800E+01,1.563800E+02,2.849100E+02,4.769400E+02,7.678500E+02,&
     & 9.758500E+02,1.200600E-04,3.164200E-04,1.153300E-03,6.037200E-03,&
     & 3.632800E-02,1.309900E-01,3.644800E-01,1.026200E+00,6.544200E+00,&
     & 3.322700E+01,6.197900E+01,1.172900E+02,2.136900E+02,3.577000E+02,&
     & 5.758800E+02,7.319300E+02,1.222800E-04,3.172500E-04,1.117300E-03,&
     & 5.049400E-03,2.713000E-02,9.123400E-02,2.523400E-01,7.087400E-01,&
     & 4.430100E+00,2.214900E+01,4.131900E+01,7.819400E+01,1.424600E+02,&
     & 2.384600E+02,3.839200E+02,4.879000E+02,1.046900E-04,2.835200E-04,&
     & 8.762600E-04,3.491600E-03,1.608200E-02,4.916100E-02,1.342100E-01,&
     & 3.751700E-01,2.335600E+00,1.130100E+01,2.071300E+01,3.909700E+01,&
     & 7.123200E+01,1.192400E+02,1.919800E+02,2.439500E+02,7.041100E-05,&
     & 2.330000E-04,5.609300E-04,6.832100E-04,1.061100E-03,1.869500E-03,&
     & 3.871800E-03,1.220300E-02,7.576800E-02,2.723700E-01,3.770800E-01,&
     & 5.850700E-01,1.119300E+00,9.895700E-01,6.458500E+00,2.352100E+01/
      data   absb(:, 61: 80) /                                          &
     & 7.582100E-05,2.905800E-04,1.382800E-03,8.600200E-03,6.255900E-02,&
     & 2.296200E-01,6.398700E-01,1.844900E+00,1.184700E+01,5.945100E+01,&
     & 1.102800E+02,2.087800E+02,3.810400E+02,6.365900E+02,1.042000E+03,&
     & 1.337700E+03,1.536000E-04,4.540600E-04,1.789800E-03,9.208600E-03,&
     & 5.385800E-02,1.810900E-01,4.951200E-01,1.410900E+00,8.909100E+00,&
     & 4.458700E+01,8.271600E+01,1.565900E+02,2.857900E+02,4.774500E+02,&
     & 7.815400E+02,1.003200E+03,1.586900E-04,4.609000E-04,1.663000E-03,&
     & 7.633400E-03,3.963200E-02,1.260300E-01,3.421100E-01,9.724800E-01,&
     & 6.035400E+00,2.972700E+01,5.514400E+01,1.043900E+02,1.905400E+02,&
     & 3.182900E+02,5.210200E+02,6.688100E+02,1.381400E-04,4.058200E-04,&
     & 1.277200E-03,5.197400E-03,2.313300E-02,6.781400E-02,1.815000E-01,&
     & 5.131600E-01,3.184000E+00,1.517500E+01,2.765200E+01,5.219700E+01,&
     & 9.526300E+01,1.591500E+02,2.605000E+02,3.344100E+02,9.160300E-05,&
     & 3.007900E-04,6.612900E-04,8.473600E-04,1.284500E-03,2.293500E-03,&
     & 4.880500E-03,1.480700E-02,9.015200E-02,3.148000E-01,4.648800E-01,&
     & 6.768700E-01,1.348200E+00,1.327700E+00,1.259300E+01,3.174000E+01,&
     & 9.437200E-05,4.318000E-04,2.288500E-03,1.354700E-02,9.047700E-02,&
     & 3.107700E-01,8.458600E-01,2.462600E+00,1.562700E+01,7.691400E+01,&
     & 1.420100E+02,2.679000E+02,4.898600E+02,8.231600E+02,1.365000E+03,&
     & 1.757500E+03,2.044800E-04,6.678600E-04,2.767100E-03,1.399200E-02,&
     & 7.684400E-02,2.443000E-01,6.538800E-01,1.884000E+00,1.175300E+01,&
     & 5.768800E+01,1.065100E+02,2.009200E+02,3.674000E+02,6.173500E+02,&
     & 1.023900E+03,1.318100E+03,2.127900E-04,6.743900E-04,2.497700E-03,&
     & 1.134700E-02,5.621600E-02,1.693400E-01,4.515500E-01,1.300600E+00,&
     & 7.959200E+00,3.846000E+01,7.100800E+01,1.339500E+02,2.449200E+02,&
     & 4.115700E+02,6.825400E+02,8.787600E+02,1.852100E-04,5.793800E-04,&
     & 1.867400E-03,7.583400E-03,3.222300E-02,9.095700E-02,2.390800E-01,&
     & 6.903000E-01,4.191800E+00,1.963300E+01,3.563500E+01,6.697900E+01,&
     & 1.224600E+02,2.057800E+02,3.412700E+02,4.393500E+02,1.158700E-04,&
     & 3.780200E-04,7.605700E-04,1.028700E-03,1.561700E-03,2.763300E-03,&
     & 6.127900E-03,1.751800E-02,1.059600E-01,3.589500E-01,5.364300E-01,&
     & 7.898100E-01,1.609400E+00,2.654500E+00,1.774300E+01,4.332100E+01,&
     & 1.241600E-04,6.667400E-04,3.700000E-03,2.100900E-02,1.265500E-01,&
     & 4.096800E-01,1.094800E+00,3.224100E+00,2.006500E+01,9.618700E+01,&
     & 1.778000E+02,3.330500E+02,6.093200E+02,1.033900E+03,1.732800E+03,&
     & 2.230800E+03,2.775300E-04,9.969700E-04,4.235400E-03,2.076200E-02,&
     & 1.061300E-01,3.216000E-01,8.442800E-01,2.464000E+00,1.509600E+01,&
     & 7.213700E+01,1.333600E+02,2.498100E+02,4.569900E+02,7.753600E+02,&
     & 1.299500E+03,1.673000E+03,2.896700E-04,9.845100E-04,3.711800E-03,&
     & 1.657400E-02,7.665200E-02,2.230200E-01,5.824600E-01,1.695700E+00,&
     & 1.022900E+01,4.809700E+01,8.890800E+01,1.665400E+02,3.046800E+02,&
     & 5.169500E+02,8.663600E+02,1.115400E+03,2.501000E-04,8.207600E-04,&
     & 2.714600E-03,1.081100E-02,4.356100E-02,1.192500E-01,3.083900E-01,&
     & 8.976600E-01,5.386700E+00,2.453700E+01,4.468000E+01,8.327200E+01,&
     & 1.523300E+02,2.584400E+02,4.331900E+02,5.577400E+02,1.440900E-04,&
     & 4.709900E-04,8.702400E-04,1.206600E-03,1.906100E-03,3.281900E-03,&
     & 7.484900E-03,2.076700E-02,1.234800E-01,4.013600E-01,6.180900E-01,&
     & 9.554000E-01,1.679800E+00,4.875300E+00,2.277900E+01,5.799900E+01,&
     & 4.933500E-05,1.327300E-04,4.518100E-04,2.669700E-03,2.198600E-02,&
     & 9.638700E-02,2.805100E-01,8.299500E-01,5.271000E+00,2.800000E+01,&
     & 5.387700E+01,1.074100E+02,2.077400E+02,3.622400E+02,5.996100E+02,&
     & 7.863700E+02,8.023700E-05,1.916000E-04,6.319200E-04,3.223400E-03,&
     & 1.971600E-02,7.649300E-02,2.189900E-01,6.367100E-01,3.970600E+00,&
     & 2.100100E+01,4.040700E+01,8.055200E+01,1.558300E+02,2.716800E+02,&
     & 4.496800E+02,5.898300E+02,8.024700E-05,1.886300E-04,6.174800E-04,&
     & 2.752900E-03,1.493800E-02,5.333500E-02,1.518300E-01,4.395400E-01,&
     & 2.705200E+00,1.400800E+01,2.694000E+01,5.370600E+01,1.038800E+02,&
     & 1.811100E+02,2.997800E+02,3.932100E+02,6.803600E-05,1.653400E-04,&
     & 4.952200E-04,1.945100E-03,9.017200E-03,2.883500E-02,8.089600E-02,&
     & 2.320600E-01,1.438300E+00,7.187900E+00,1.361700E+01,2.685200E+01,&
     & 5.193700E+01,9.055500E+01,1.498900E+02,1.966100E+02,4.262300E-05,&
     & 1.403400E-04,3.656600E-04,4.418400E-04,6.942600E-04,1.227300E-03,&
     & 2.550900E-03,8.072000E-03,5.064000E-02,1.868400E-01,3.045900E-01,&
     & 4.187400E-01,8.399900E-01,8.636100E-01,4.394900E+00,2.108800E+01/
      data   absb(:, 81:100) /                                          &
     & 5.217300E-05,1.702200E-04,7.083700E-04,4.418600E-03,3.444800E-02,&
     & 1.376900E-01,3.950600E-01,1.157000E+00,7.484300E+00,3.898300E+01,&
     & 7.473200E+01,1.489800E+02,2.888300E+02,5.015500E+02,8.404400E+02,&
     & 1.133300E+03,9.783400E-05,2.627400E-04,9.644300E-04,5.034700E-03,&
     & 3.020100E-02,1.091700E-01,3.078100E-01,8.883500E-01,5.638600E+00,&
     & 2.923800E+01,5.605200E+01,1.117400E+02,2.166200E+02,3.761500E+02,&
     & 6.303200E+02,8.499500E+02,1.002200E-04,2.659000E-04,9.202800E-04,&
     & 4.252300E-03,2.256300E-02,7.607400E-02,2.130200E-01,6.126000E-01,&
     & 3.843500E+00,1.950000E+01,3.736800E+01,7.448900E+01,1.444200E+02,&
     & 2.507700E+02,4.201900E+02,5.666600E+02,8.672500E-05,2.377400E-04,&
     & 7.244900E-04,2.948600E-03,1.340200E-02,4.111700E-02,1.132400E-01,&
     & 3.236900E-01,2.042800E+00,1.000700E+01,1.889500E+01,3.724400E+01,&
     & 7.220900E+01,1.253900E+02,2.101100E+02,2.833200E+02,5.721100E-05,&
     & 1.865500E-04,4.422400E-04,5.582600E-04,8.652800E-04,1.560700E-03,&
     & 3.310800E-03,1.009100E-02,6.069000E-02,2.311100E-01,3.638100E-01,&
     & 5.040500E-01,1.026800E+00,1.309800E+00,9.120100E+00,2.869000E+01,&
     & 6.046100E-05,2.379800E-04,1.171900E-03,7.154600E-03,5.194300E-02,&
     & 1.913100E-01,5.387000E-01,1.578100E+00,1.020300E+01,5.209000E+01,&
     & 9.930300E+01,1.972100E+02,3.830200E+02,6.668200E+02,1.143800E+03,&
     & 1.549700E+03,1.260500E-04,3.789400E-04,1.507100E-03,7.728000E-03,&
     & 4.483700E-02,1.512300E-01,4.185500E-01,1.212800E+00,7.686900E+00,&
     & 3.907100E+01,7.447300E+01,1.478900E+02,2.872900E+02,5.001200E+02,&
     & 8.577000E+02,1.162300E+03,1.306100E-04,3.874800E-04,1.391600E-03,&
     & 6.404000E-03,3.311600E-02,1.052300E-01,2.893800E-01,8.372500E-01,&
     & 5.238000E+00,2.606300E+01,4.964900E+01,9.859900E+01,1.915300E+02,&
     & 3.334300E+02,5.719500E+02,7.749300E+02,1.147000E-04,3.403200E-04,&
     & 1.070400E-03,4.400100E-03,1.927400E-02,5.673800E-02,1.535700E-01,&
     & 4.435400E-01,2.780900E+00,1.338000E+01,2.512400E+01,4.930100E+01,&
     & 9.577000E+01,1.667200E+02,2.859500E+02,3.874500E+02,7.432400E-05,&
     & 2.399800E-04,5.187800E-04,6.888100E-04,1.058000E-03,1.963800E-03,&
     & 4.201300E-03,1.234900E-02,7.201700E-02,2.716800E-01,4.232500E-01,&
     & 6.190100E-01,1.205400E+00,2.081000E+00,1.470900E+01,3.894900E+01,&
     & 7.569400E-05,3.581200E-04,1.934700E-03,1.140600E-02,7.519200E-02,&
     & 2.589900E-01,7.152600E-01,2.103800E+00,1.347800E+01,6.696200E+01,&
     & 1.276800E+02,2.514400E+02,4.885600E+02,8.598000E+02,1.499300E+03,&
     & 2.033000E+03,1.682700E-04,5.638100E-04,2.341000E-03,1.181100E-02,&
     & 6.404800E-02,2.039900E-01,5.544900E-01,1.617600E+00,1.015500E+01,&
     & 5.022300E+01,9.575400E+01,1.885900E+02,3.664200E+02,6.448500E+02,&
     & 1.124500E+03,1.524700E+03,1.757200E-04,5.680700E-04,2.105400E-03,&
     & 9.585500E-03,4.676700E-02,1.416500E-01,3.828300E-01,1.117100E+00,&
     & 6.917000E+00,3.351700E+01,6.383700E+01,1.257300E+02,2.442700E+02,&
     & 4.299000E+02,7.496500E+02,1.016400E+03,1.540400E-04,4.859900E-04,&
     & 1.575000E-03,6.424100E-03,2.682900E-02,7.620300E-02,2.026900E-01,&
     & 5.921600E-01,3.668700E+00,1.721700E+01,3.232500E+01,6.287900E+01,&
     & 1.221300E+02,2.149600E+02,3.748400E+02,5.082100E+02,9.368600E-05,&
     & 3.061700E-04,5.938100E-04,8.329500E-04,1.313200E-03,2.361800E-03,&
     & 5.190200E-03,1.475500E-02,8.524300E-02,3.109100E-01,4.728500E-01,&
     & 7.494700E-01,1.263000E+00,4.011800E+00,1.951700E+01,5.250000E+01,&
     & 9.995500E-05,5.554000E-04,3.126700E-03,1.778100E-02,1.049200E-01,&
     & 3.421400E-01,9.272700E-01,2.738500E+00,1.736500E+01,8.357000E+01,&
     & 1.592700E+02,3.105800E+02,6.047100E+02,1.076800E+03,1.902600E+03,&
     & 2.578900E+03,2.286600E-04,8.447800E-04,3.593300E-03,1.757700E-02,&
     & 8.810900E-02,2.693400E-01,7.178500E-01,2.102300E+00,1.308800E+01,&
     & 6.268700E+01,1.194500E+02,2.329500E+02,4.535400E+02,8.075600E+02,&
     & 1.427000E+03,1.934200E+03,2.395600E-04,8.310900E-04,3.144600E-03,&
     & 1.400100E-02,6.382700E-02,1.867500E-01,4.954800E-01,1.449000E+00,&
     & 8.912300E+00,4.185800E+01,7.963200E+01,1.552900E+02,3.023500E+02,&
     & 5.383800E+02,9.513300E+02,1.289500E+03,2.082600E-04,6.877000E-04,&
     & 2.301200E-03,9.164500E-03,3.631200E-02,1.001400E-01,2.620000E-01,&
     & 7.689200E-01,4.718200E+00,2.153100E+01,4.035100E+01,7.768600E+01,&
     & 1.511800E+02,2.691900E+02,4.756900E+02,6.447800E+02,1.154800E-04,&
     & 3.797300E-04,6.879000E-04,9.709800E-04,1.600600E-03,2.828100E-03,&
     & 6.406800E-03,1.766700E-02,9.904000E-02,3.627600E-01,5.097600E-01,&
     & 8.749100E-01,1.561100E+00,6.015100E+00,2.499500E+01,6.950500E+01/
      data   absb(:,101:120) /                                          &
     & 3.826600E-05,1.057700E-04,3.714900E-04,2.189600E-03,1.806700E-02,&
     & 7.927100E-02,2.337800E-01,7.069200E-01,4.490200E+00,2.426400E+01,&
     & 4.764800E+01,9.983800E+01,2.058900E+02,3.801100E+02,6.574000E+02,&
     & 9.137100E+02,6.444900E-05,1.568000E-04,5.200800E-04,2.653800E-03,&
     & 1.624200E-02,6.312600E-02,1.831800E-01,5.458600E-01,3.391100E+00,&
     & 1.819800E+01,3.573500E+01,7.487900E+01,1.544200E+02,2.850900E+02,&
     & 4.930400E+02,6.852900E+02,6.517200E-05,1.553600E-04,5.076200E-04,&
     & 2.290400E-03,1.231700E-02,4.410000E-02,1.269800E-01,3.766100E-01,&
     & 2.324400E+00,1.219500E+01,2.382300E+01,4.991900E+01,1.029400E+02,&
     & 1.900700E+02,3.286800E+02,4.568600E+02,5.578900E-05,1.378600E-04,&
     & 4.075700E-04,1.641400E-03,7.458700E-03,2.391700E-02,6.771700E-02,&
     & 1.988900E-01,1.248100E+00,6.266400E+00,1.216400E+01,2.501200E+01,&
     & 5.147300E+01,9.502900E+01,1.643400E+02,2.284300E+02,3.513000E-05,&
     & 1.141600E-04,2.884700E-04,3.548000E-04,5.808400E-04,1.021700E-03,&
     & 2.192700E-03,6.748300E-03,4.028300E-02,1.702100E-01,2.574400E-01,&
     & 3.933800E-01,7.089800E-01,1.272000E+00,5.987700E+00,2.551800E+01,&
     & 4.089500E-05,1.365900E-04,5.883200E-04,3.644400E-03,2.844300E-02,&
     & 1.134500E-01,3.294800E-01,9.829500E-01,6.373900E+00,3.364500E+01,&
     & 6.572400E+01,1.371700E+02,2.838300E+02,5.260100E+02,9.176900E+02,&
     & 1.311600E+03,7.929700E-05,2.165800E-04,8.061200E-04,4.189700E-03,&
     & 2.505400E-02,9.018200E-02,2.574200E-01,7.589300E-01,4.815200E+00,&
     & 2.523400E+01,4.929300E+01,1.028700E+02,2.128700E+02,3.944800E+02,&
     & 6.882500E+02,9.836600E+02,8.175800E-05,2.214700E-04,7.616900E-04,&
     & 3.544000E-03,1.872000E-02,6.297700E-02,1.782200E-01,5.230700E-01,&
     & 3.300500E+00,1.691300E+01,3.286300E+01,6.858300E+01,1.419100E+02,&
     & 2.630100E+02,4.588400E+02,6.557400E+02,7.154800E-05,1.976600E-04,&
     & 6.034800E-04,2.480500E-03,1.109800E-02,3.415600E-02,9.489600E-02,&
     & 2.765900E-01,1.769300E+00,8.704900E+00,1.679200E+01,3.436100E+01,&
     & 7.095700E+01,1.315000E+02,2.294100E+02,3.278800E+02,4.678100E-05,&
     & 1.513600E-04,3.472300E-04,4.497100E-04,7.233400E-04,1.329900E-03,&
     & 2.858400E-03,8.485000E-03,4.902500E-02,1.975100E-01,3.105900E-01,&
     & 4.789300E-01,8.756600E-01,1.554300E+00,1.158900E+01,3.490400E+01,&
     & 4.780700E-05,1.935300E-04,9.799500E-04,5.991600E-03,4.279500E-02,&
     & 1.579700E-01,4.500000E-01,1.336700E+00,8.702800E+00,4.464300E+01,&
     & 8.713800E+01,1.805200E+02,3.735400E+02,6.976100E+02,1.244100E+03,&
     & 1.788000E+03,1.027800E-04,3.159100E-04,1.258200E-03,6.468600E-03,&
     & 3.706200E-02,1.251100E-01,3.508000E-01,1.032700E+00,6.574000E+00,&
     & 3.348600E+01,6.534900E+01,1.353900E+02,2.801600E+02,5.232000E+02,&
     & 9.331100E+02,1.341000E+03,1.069700E-04,3.244700E-04,1.165400E-03,&
     & 5.374300E-03,2.740800E-02,8.708700E-02,2.424100E-01,7.137300E-01,&
     & 4.502200E+00,2.245200E+01,4.356900E+01,9.025900E+01,1.867800E+02,&
     & 3.488000E+02,6.220300E+02,8.939600E+02,9.484000E-05,2.833700E-04,&
     & 8.980300E-04,3.697400E-03,1.596500E-02,4.705900E-02,1.287200E-01,&
     & 3.788400E-01,2.407000E+00,1.158600E+01,2.227000E+01,4.524200E+01,&
     & 9.338900E+01,1.743900E+02,3.110300E+02,4.469800E+02,6.013300E-05,&
     & 1.966100E-04,4.048300E-04,5.579900E-04,9.009900E-04,1.662800E-03,&
     & 3.612600E-03,1.047800E-02,5.928300E-02,2.220100E-01,3.584700E-01,&
     & 5.726200E-01,1.008300E+00,2.984100E+00,1.607000E+01,4.741200E+01,&
     & 6.015900E-05,2.939300E-04,1.614700E-03,9.596300E-03,6.191900E-02,&
     & 2.140200E-01,5.988700E-01,1.775600E+00,1.153000E+01,5.720700E+01,&
     & 1.116900E+02,2.288000E+02,4.740600E+02,8.951500E+02,1.628600E+03,&
     & 2.341100E+03,1.376500E-04,4.724100E-04,1.968500E-03,9.912800E-03,&
     & 5.289100E-02,1.689700E-01,4.657900E-01,1.369700E+00,8.713900E+00,&
     & 4.290200E+01,8.376900E+01,1.716000E+02,3.555300E+02,6.713600E+02,&
     & 1.221400E+03,1.755800E+03,1.444600E-04,4.760900E-04,1.773300E-03,&
     & 8.055300E-03,3.865300E-02,1.175200E-01,3.215100E-01,9.434400E-01,&
     & 5.968300E+00,2.879100E+01,5.584500E+01,1.144000E+02,2.370200E+02,&
     & 4.475700E+02,8.143500E+02,1.170500E+03,1.275900E-04,4.046000E-04,&
     & 1.329800E-03,5.406800E-03,2.222100E-02,6.333200E-02,1.704200E-01,&
     & 4.998000E-01,3.183900E+00,1.489900E+01,2.854300E+01,5.739500E+01,&
     & 1.185100E+02,2.237800E+02,4.071600E+02,5.852600E+02,7.513900E-05,&
     & 2.488700E-04,4.713600E-04,6.724100E-04,1.119300E-03,2.015100E-03,&
     & 4.520800E-03,1.279700E-02,7.021700E-02,2.555400E-01,4.018400E-01,&
     & 6.830600E-01,1.240900E+00,4.640900E+00,2.126300E+01,6.321800E+01/
      data   absb(:,121:140) /                                          &
     & 7.974700E-05,4.559800E-04,2.607100E-03,1.502500E-02,8.621900E-02,&
     & 2.830500E-01,7.771100E-01,2.312700E+00,1.491000E+01,7.119300E+01,&
     & 1.384600E+02,2.822000E+02,5.825200E+02,1.118100E+03,2.064700E+03,&
     & 2.960300E+03,1.870400E-04,7.074000E-04,3.024700E-03,1.480900E-02,&
     & 7.260800E-02,2.233200E-01,6.035700E-01,1.783800E+00,1.126600E+01,&
     & 5.340200E+01,1.038500E+02,2.116500E+02,4.368800E+02,8.385700E+02,&
     & 1.548500E+03,2.220400E+03,1.969200E-04,6.958900E-04,2.645000E-03,&
     & 1.181000E-02,5.268700E-02,1.550200E-01,4.166000E-01,1.230300E+00,&
     & 7.705800E+00,3.585600E+01,6.923700E+01,1.410900E+02,2.912600E+02,&
     & 5.590300E+02,1.032300E+03,1.480100E+03,1.725900E-04,5.745200E-04,&
     & 1.945800E-03,7.716000E-03,2.995700E-02,8.341500E-02,2.203500E-01,&
     & 6.534700E-01,4.097300E+00,1.860800E+01,3.538600E+01,7.087000E+01,&
     & 1.456300E+02,2.795400E+02,5.161700E+02,7.400600E+02,9.164800E-05,&
     & 3.030400E-04,5.592100E-04,7.706300E-04,1.367100E-03,2.463800E-03,&
     & 5.553900E-03,1.535500E-02,8.109200E-02,2.954700E-01,4.625400E-01,&
     & 7.602200E-01,1.570100E+00,6.615700E+00,2.719400E+01,8.234400E+01,&
     & 2.918400E-05,8.275000E-05,3.006100E-04,1.799700E-03,1.470800E-02,&
     & 6.421100E-02,1.922700E-01,5.910800E-01,3.751200E+00,2.047700E+01,&
     & 4.073100E+01,8.883600E+01,1.963100E+02,3.922200E+02,7.074300E+02,&
     & 1.045300E+03,5.121100E-05,1.268600E-04,4.288400E-04,2.188600E-03,&
     & 1.332700E-02,5.130200E-02,1.511000E-01,4.583600E-01,2.845900E+00,&
     & 1.535600E+01,3.055000E+01,6.662700E+01,1.472300E+02,2.941500E+02,&
     & 5.305600E+02,7.840100E+02,5.236200E-05,1.274200E-04,4.164800E-04,&
     & 1.908200E-03,1.011300E-02,3.590200E-02,1.048300E-01,3.162500E-01,&
     & 1.961200E+00,1.036700E+01,2.039800E+01,4.442100E+01,9.815100E+01,&
     & 1.961100E+02,3.537100E+02,5.226700E+02,4.545100E-05,1.140300E-04,&
     & 3.375400E-04,1.367000E-03,6.129000E-03,1.955400E-02,5.603200E-02,&
     & 1.674400E-01,1.062200E+00,5.362200E+00,1.048200E+01,2.242300E+01,&
     & 4.907600E+01,9.805100E+01,1.768500E+02,2.613200E+02,2.893700E-05,&
     & 9.396100E-05,2.312700E-04,2.902100E-04,4.831600E-04,8.798300E-04,&
     & 1.922000E-03,5.728700E-03,3.438200E-02,1.353400E-01,2.292900E-01,&
     & 3.735500E-01,6.527700E-01,1.380200E+00,7.546500E+00,3.056500E+01,&
     & 3.150200E-05,1.079300E-04,4.824600E-04,3.012000E-03,2.313600E-02,&
     & 9.212000E-02,2.713500E-01,8.205200E-01,5.326500E+00,2.817800E+01,&
     & 5.603800E+01,1.213600E+02,2.679400E+02,5.410500E+02,9.847300E+02,&
     & 1.493500E+03,6.360500E-05,1.770700E-04,6.679300E-04,3.474600E-03,&
     & 2.049100E-02,7.343300E-02,2.123800E-01,6.368100E-01,4.041200E+00,&
     & 2.113200E+01,4.202700E+01,9.101700E+01,2.009500E+02,4.057700E+02,&
     & 7.385600E+02,1.120200E+03,6.609600E-05,1.835300E-04,6.327000E-04,&
     & 2.945000E-03,1.534100E-02,5.135500E-02,1.470700E-01,4.394500E-01,&
     & 2.783500E+00,1.427800E+01,2.805800E+01,6.067900E+01,1.339700E+02,&
     & 2.705300E+02,4.923500E+02,7.467400E+02,5.859100E-05,1.633600E-04,&
     & 5.043200E-04,2.070600E-03,9.114700E-03,2.789000E-02,7.838200E-02,&
     & 2.328900E-01,1.502600E+00,7.414900E+00,1.442100E+01,3.065100E+01,&
     & 6.698300E+01,1.352600E+02,2.461800E+02,3.734100E+02,3.820200E-05,&
     & 1.252400E-04,2.727900E-04,3.728200E-04,6.037400E-04,1.153600E-03,&
     & 2.492300E-03,7.303200E-03,4.220900E-02,1.563400E-01,2.684100E-01,&
     & 4.312300E-01,7.925300E-01,2.007900E+00,1.270800E+01,4.220400E+01,&
     & 3.712900E-05,1.548100E-04,8.039200E-04,4.979800E-03,3.474700E-02,&
     & 1.283300E-01,3.704900E-01,1.113100E+00,7.293700E+00,3.721000E+01,&
     & 7.413000E+01,1.585700E+02,3.506000E+02,7.144100E+02,1.329900E+03,&
     & 2.030900E+03,8.286500E-05,2.607800E-04,1.048600E-03,5.399000E-03,&
     & 3.028300E-02,1.018600E-01,2.896000E-01,8.633800E-01,5.534100E+00,&
     & 2.791100E+01,5.560200E+01,1.189300E+02,2.629700E+02,5.358300E+02,&
     & 9.974100E+02,1.523200E+03,8.693200E-05,2.695000E-04,9.714700E-04,&
     & 4.493800E-03,2.239300E-02,7.108100E-02,2.002200E-01,5.957700E-01,&
     & 3.809300E+00,1.886200E+01,3.712700E+01,7.928400E+01,1.753100E+02,&
     & 3.572300E+02,6.649500E+02,1.015400E+03,7.793100E-05,2.344400E-04,&
     & 7.530100E-04,3.081600E-03,1.307700E-02,3.848300E-02,1.064200E-01,&
     & 3.157800E-01,2.048500E+00,9.838400E+00,1.909500E+01,4.008800E+01,&
     & 8.765800E+01,1.786100E+02,3.324800E+02,5.050200E+02,4.877700E-05,&
     & 1.621100E-04,3.200700E-04,4.593000E-04,7.659800E-04,1.437800E-03,&
     & 3.197600E-03,9.089500E-03,5.116500E-02,1.802000E-01,3.008300E-01,&
     & 5.103900E-01,9.798400E-01,3.362400E+00,1.743300E+01,5.712700E+01/
      data   absb(:,141:160) /                                          &
     & 4.695300E-05,2.364100E-04,1.326000E-03,8.008100E-03,5.028800E-02,&
     & 1.739000E-01,4.923100E-01,1.476500E+00,9.704400E+00,4.754600E+01,&
     & 9.441400E+01,2.005000E+02,4.421400E+02,9.126500E+02,1.737900E+03,&
     & 2.647900E+03,1.112800E-04,3.902400E-04,1.638600E-03,8.264400E-03,&
     & 4.305700E-02,1.378700E-01,3.839800E-01,1.144400E+00,7.362500E+00,&
     & 3.565900E+01,7.081100E+01,1.503600E+02,3.316100E+02,6.845000E+02,&
     & 1.303400E+03,1.986200E+03,1.176300E-04,3.953600E-04,1.479200E-03,&
     & 6.722300E-03,3.149000E-02,9.601200E-02,2.651500E-01,7.890900E-01,&
     & 5.063700E+00,2.410000E+01,4.732300E+01,1.002500E+02,2.210700E+02,&
     & 4.563200E+02,8.688700E+02,1.324100E+03,1.049600E-04,3.358600E-04,&
     & 1.116400E-03,4.503200E-03,1.813000E-02,5.193000E-02,1.406900E-01,&
     & 4.182700E-01,2.713600E+00,1.260000E+01,2.437100E+01,5.073500E+01,&
     & 1.105400E+02,2.281600E+02,4.344700E+02,6.620200E+02,6.080600E-05,&
     & 2.025500E-04,3.814400E-04,5.473400E-04,9.506900E-04,1.764100E-03,&
     & 3.952900E-03,1.117900E-02,6.024700E-02,2.150700E-01,3.414200E-01,&
     & 5.838800E-01,1.241400E+00,4.965000E+00,2.299600E+01,7.542900E+01,&
     & 6.250200E-05,3.669900E-04,2.147300E-03,1.249200E-02,6.975600E-02,&
     & 2.301100E-01,6.403500E-01,1.925000E+00,1.259700E+01,5.897300E+01,&
     & 1.168700E+02,2.463100E+02,5.411700E+02,1.133600E+03,2.200900E+03,&
     & 3.339900E+03,1.512900E-04,5.829900E-04,2.512600E-03,1.237300E-02,&
     & 5.900500E-02,1.820600E-01,4.989200E-01,1.489800E+00,9.556100E+00,&
     & 4.422900E+01,8.765500E+01,1.847300E+02,4.058600E+02,8.501500E+02,&
     & 1.650600E+03,2.504900E+03,1.602500E-04,5.753100E-04,2.206700E-03,&
     & 9.864400E-03,4.285000E-02,1.266800E-01,3.441800E-01,1.028400E+00,&
     & 6.565300E+00,2.988000E+01,5.860400E+01,1.231600E+02,2.705800E+02,&
     & 5.667900E+02,1.100400E+03,1.670000E+03,1.418400E-04,4.769400E-04,&
     & 1.627600E-03,6.425500E-03,2.441200E-02,6.840400E-02,1.822000E-01,&
     & 5.457600E-01,3.505200E+00,1.565000E+01,3.022800E+01,6.238800E+01,&
     & 1.353000E+02,2.833800E+02,5.502000E+02,8.350000E+02,7.453600E-05,&
     & 2.445900E-04,4.465300E-04,6.302000E-04,1.163300E-03,2.165400E-03,&
     & 4.807400E-03,1.349800E-02,7.072100E-02,2.346700E-01,3.993200E-01,&
     & 6.707800E-01,1.548700E+00,6.876100E+00,2.935800E+01,9.702100E+01,&
     & 2.267200E-05,6.578900E-05,2.472400E-04,1.506400E-03,1.227100E-02,&
     & 5.278800E-02,1.609700E-01,5.011400E-01,3.194900E+00,1.737300E+01,&
     & 3.504300E+01,7.888600E+01,1.854600E+02,4.083900E+02,7.779700E+02,&
     & 1.215700E+03,4.124200E-05,1.037700E-04,3.591000E-04,1.845100E-03,&
     & 1.113000E-02,4.229900E-02,1.268100E-01,3.902800E-01,2.435800E+00,&
     & 1.304000E+01,2.628100E+01,5.916700E+01,1.390900E+02,3.063000E+02,&
     & 5.834700E+02,9.117900E+02,4.252700E-05,1.057300E-04,3.473400E-04,&
     & 1.605600E-03,8.451100E-03,2.967300E-02,8.798300E-02,2.696800E-01,&
     & 1.686200E+00,8.839000E+00,1.764500E+01,3.944500E+01,9.272800E+01,&
     & 2.042000E+02,3.889800E+02,6.079000E+02,3.734200E-05,9.474700E-05,&
     & 2.834900E-04,1.152200E-03,5.116800E-03,1.622700E-02,4.706700E-02,&
     & 1.430300E-01,9.152300E-01,4.658800E+00,9.088000E+00,2.011900E+01,&
     & 4.639600E+01,1.020900E+02,1.944900E+02,3.039400E+02,2.393400E-05,&
     & 7.830900E-05,1.851100E-04,2.468200E-04,4.129300E-04,7.631000E-04,&
     & 1.699800E-03,5.029900E-03,2.975500E-02,1.197200E-01,1.904100E-01,&
     & 3.386600E-01,6.178900E-01,1.419800E+00,8.905800E+00,3.649700E+01,&
     & 2.469900E-05,8.673900E-05,4.012500E-04,2.547400E-03,1.920500E-02,&
     & 7.588900E-02,2.267400E-01,6.976800E-01,4.538200E+00,2.379300E+01,&
     & 4.809500E+01,1.068900E+02,2.519100E+02,5.596800E+02,1.079500E+03,&
     & 1.730800E+03,5.160000E-05,1.466700E-04,5.601700E-04,2.929400E-03,&
     & 1.703600E-02,6.064800E-02,1.781200E-01,5.430800E-01,3.460100E+00,&
     & 1.785700E+01,3.607200E+01,8.016700E+01,1.889300E+02,4.197700E+02,&
     & 8.096400E+02,1.298100E+03,5.395300E-05,1.532100E-04,5.318900E-04,&
     & 2.491500E-03,1.276300E-02,4.245700E-02,1.233700E-01,3.749300E-01,&
     & 2.394000E+00,1.210900E+01,2.422400E+01,5.344400E+01,1.259600E+02,&
     & 2.798500E+02,5.397400E+02,8.653900E+02,4.835000E-05,1.363000E-04,&
     & 4.249300E-04,1.750700E-03,7.590200E-03,2.310800E-02,6.575800E-02,&
     & 1.989600E-01,1.294500E+00,6.396300E+00,1.250000E+01,2.728900E+01,&
     & 6.302000E+01,1.399200E+02,2.698800E+02,4.327000E+02,3.147300E-05,&
     & 1.040000E-04,2.205500E-04,3.153800E-04,5.199300E-04,1.003500E-03,&
     & 2.214800E-03,6.475200E-03,3.702600E-02,1.377400E-01,2.200500E-01,&
     & 4.028300E-01,7.304900E-01,2.224100E+00,1.376000E+01,5.018600E+01/
      data   absb(:,161:180) /                                          &
     & 2.933400E-05,1.257000E-04,6.692400E-04,4.218600E-03,2.878900E-02,&
     & 1.057500E-01,3.094200E-01,9.455500E-01,6.234400E+00,3.133600E+01,&
     & 6.328000E+01,1.392100E+02,3.275200E+02,7.363700E+02,1.450300E+03,&
     & 2.342100E+03,6.754700E-05,2.169600E-04,8.834200E-04,4.579800E-03,&
     & 2.510300E-02,8.419000E-02,2.423900E-01,7.353700E-01,4.753200E+00,&
     & 2.352000E+01,4.746500E+01,1.044000E+02,2.456300E+02,5.522600E+02,&
     & 1.087700E+03,1.756500E+03,7.129400E-05,2.249300E-04,8.206700E-04,&
     & 3.806300E-03,1.857900E-02,5.885200E-02,1.676800E-01,5.073300E-01,&
     & 3.285100E+00,1.596100E+01,3.188400E+01,6.960100E+01,1.637600E+02,&
     & 3.681800E+02,7.251500E+02,1.171000E+03,6.446100E-05,1.958500E-04,&
     & 6.386000E-04,2.598800E-03,1.086400E-02,3.199300E-02,8.924700E-02,&
     & 2.686400E-01,1.769700E+00,8.439000E+00,1.650500E+01,3.555300E+01,&
     & 8.196300E+01,1.841000E+02,3.625800E+02,5.855600E+02,4.002500E-05,&
     & 1.335500E-04,2.626000E-04,3.867400E-04,6.556100E-04,1.264800E-03,&
     & 2.817100E-03,8.132300E-03,4.504500E-02,1.609100E-01,2.519000E-01,&
     & 4.500100E-01,9.141800E-01,3.565300E+00,1.873900E+01,6.796000E+01,&
     & 3.728600E-05,1.925400E-04,1.106100E-03,6.801900E-03,4.147000E-02,&
     & 1.432800E-01,4.112100E-01,1.251500E+00,8.334900E+00,3.986600E+01,&
     & 8.045900E+01,1.754100E+02,4.110900E+02,9.350400E+02,1.890600E+03,&
     & 3.043600E+03,9.083800E-05,3.249200E-04,1.379200E-03,7.006300E-03,&
     & 3.554900E-02,1.139400E-01,3.215600E-01,9.720400E-01,6.352100E+00,&
     & 2.993500E+01,6.035200E+01,1.315600E+02,3.083200E+02,7.012600E+02,&
     & 1.417900E+03,2.282900E+03,9.662500E-05,3.297200E-04,1.246200E-03,&
     & 5.698200E-03,2.604900E-02,7.953300E-02,2.222600E-01,6.709000E-01,&
     & 4.382700E+00,2.033100E+01,4.056200E+01,8.771400E+01,2.055500E+02,&
     & 4.675100E+02,9.452300E+02,1.521900E+03,8.686200E-05,2.811000E-04,&
     & 9.437600E-04,3.803200E-03,1.500600E-02,4.315500E-02,1.180500E-01,&
     & 3.557700E-01,2.351800E+00,1.075600E+01,2.105000E+01,4.479300E+01,&
     & 1.029500E+02,2.337500E+02,4.726300E+02,7.609300E+02,4.986900E-05,&
     & 1.647800E-04,3.122600E-04,4.612400E-04,8.139500E-04,1.571400E-03,&
     & 3.485200E-03,1.000700E-02,5.353200E-02,1.795500E-01,3.034700E-01,&
     & 5.084300E-01,1.166300E+00,5.103500E+00,2.464100E+01,8.894000E+01,&
     & 4.982200E-05,2.995200E-04,1.796400E-03,1.059500E-02,5.747000E-02,&
     & 1.894000E-01,5.366100E-01,1.632600E+00,1.085800E+01,4.949500E+01,&
     & 9.940500E+01,2.152300E+02,5.006900E+02,1.156000E+03,2.386300E+03,&
     & 3.825700E+03,1.235200E-04,4.840200E-04,2.112600E-03,1.048600E-02,&
     & 4.874300E-02,1.502800E-01,4.189100E-01,1.267400E+00,8.268900E+00,&
     & 3.717500E+01,7.455500E+01,1.614200E+02,3.755400E+02,8.669700E+02,&
     & 1.789700E+03,2.869100E+03,1.315200E-04,4.801000E-04,1.858300E-03,&
     & 8.352800E-03,3.538300E-02,1.048800E-01,2.889700E-01,8.747800E-01,&
     & 5.697800E+00,2.525700E+01,5.014100E+01,1.076400E+02,2.503500E+02,&
     & 5.780100E+02,1.193300E+03,1.912900E+03,1.171300E-04,3.989200E-04,&
     & 1.372100E-03,5.424900E-03,2.017500E-02,5.681700E-02,1.530800E-01,&
     & 4.636300E-01,3.049000E+00,1.333900E+01,2.607200E+01,5.499300E+01,&
     & 1.255100E+02,2.890100E+02,5.965600E+02,9.563700E+02,6.121900E-05,&
     & 1.983100E-04,3.674600E-04,5.332000E-04,9.959800E-04,1.914900E-03,&
     & 4.270300E-03,1.214400E-02,6.233800E-02,2.066300E-01,3.381400E-01,&
     & 5.960700E-01,1.468200E+00,6.904400E+00,3.148500E+01,1.132000E+02,&
     & 1.800300E-05,5.358800E-05,2.093400E-04,1.310200E-03,1.060400E-02,&
     & 4.452000E-02,1.381600E-01,4.361800E-01,2.798300E+00,1.503700E+01,&
     & 3.069800E+01,7.032800E+01,1.766000E+02,4.297100E+02,8.787400E+02,&
     & 1.449900E+03,3.380200E-05,8.663200E-05,3.070000E-04,1.598300E-03,&
     & 9.586100E-03,3.575800E-02,1.089900E-01,3.407000E-01,2.143000E+00,&
     & 1.132200E+01,2.302800E+01,5.275000E+01,1.324500E+02,3.222900E+02,&
     & 6.590700E+02,1.087500E+03,3.504200E-05,8.924700E-05,2.972200E-04,&
     & 1.385900E-03,7.265500E-03,2.512800E-02,7.556800E-02,2.354400E-01,&
     & 1.490700E+00,7.684400E+00,1.555900E+01,3.520900E+01,8.830100E+01,&
     & 2.148500E+02,4.393900E+02,7.250200E+02,3.106800E-05,8.006700E-05,&
     & 2.426700E-04,9.929100E-04,4.382300E-03,1.375300E-02,4.038400E-02,&
     & 1.251400E-01,8.078700E-01,4.112700E+00,8.074400E+00,1.808100E+01,&
     & 4.434400E+01,1.074300E+02,2.196900E+02,3.625000E+02,2.007400E-05,&
     & 6.577500E-05,1.492600E-04,2.122800E-04,3.561700E-04,6.657100E-04,&
     & 1.508400E-03,4.491800E-03,2.663800E-02,1.048500E-01,1.685100E-01,&
     & 3.123700E-01,5.862400E-01,1.539300E+00,9.755600E+00,4.345100E+01/
      data   absb(:,181:200) /                                          &
     & 1.981100E-05,7.160600E-05,3.426000E-04,2.226900E-03,1.649500E-02,&
     & 6.404500E-02,1.939000E-01,6.084400E-01,3.980100E+00,2.051500E+01,&
     & 4.193800E+01,9.481200E+01,2.378200E+02,5.858700E+02,1.212800E+03,&
     & 2.049400E+03,4.260000E-05,1.237700E-04,4.818700E-04,2.541000E-03,&
     & 1.461300E-02,5.127100E-02,1.523700E-01,4.750600E-01,3.047300E+00,&
     & 1.545000E+01,3.144900E+01,7.111000E+01,1.783500E+02,4.394200E+02,&
     & 9.096200E+02,1.537100E+03,4.476500E-05,1.301100E-04,4.576300E-04,&
     & 2.156300E-03,1.093400E-02,3.590100E-02,1.055800E-01,3.277900E-01,&
     & 2.116700E+00,1.049900E+01,2.126600E+01,4.745300E+01,1.189100E+02,&
     & 2.929300E+02,6.063800E+02,1.024700E+03,4.042600E-05,1.156100E-04,&
     & 3.656600E-04,1.507200E-03,6.479800E-03,1.958200E-02,5.634700E-02,&
     & 1.740500E-01,1.142300E+00,5.618200E+00,1.107500E+01,2.438700E+01,&
     & 5.973400E+01,1.464700E+02,3.031900E+02,5.123600E+02,2.618800E-05,&
     & 8.737400E-05,1.799100E-04,2.681600E-04,4.486500E-04,8.739100E-04,&
     & 1.953300E-03,5.821300E-03,3.334400E-02,1.214800E-01,1.960400E-01,&
     & 3.665500E-01,7.062700E-01,2.260100E+00,1.489600E+01,5.992300E+01,&
     & 2.374000E-05,1.049000E-04,5.716300E-04,3.689600E-03,2.465100E-02,&
     & 8.908200E-02,2.643100E-01,8.250400E-01,5.485400E+00,2.688600E+01,&
     & 5.497100E+01,1.230700E+02,3.072900E+02,7.661700E+02,1.620900E+03,&
     & 2.759500E+03,5.599000E-05,1.840000E-04,7.599100E-04,3.977800E-03,&
     & 2.143000E-02,7.116400E-02,2.073400E-01,6.431500E-01,4.197800E+00,&
     & 2.025200E+01,4.122600E+01,9.230500E+01,2.304600E+02,5.746400E+02,&
     & 1.215700E+03,2.069500E+03,5.940000E-05,1.912500E-04,7.064400E-04,&
     & 3.297700E-03,1.580300E-02,4.982100E-02,1.434900E-01,4.437700E-01,&
     & 2.909500E+00,1.379200E+01,2.787300E+01,6.160700E+01,1.536500E+02,&
     & 3.831100E+02,8.105100E+02,1.379700E+03,5.401900E-05,1.663000E-04,&
     & 5.499000E-04,2.245400E-03,9.215500E-03,2.712200E-02,7.638100E-02,&
     & 2.352100E-01,1.565000E+00,7.374100E+00,1.455300E+01,3.168500E+01,&
     & 7.724800E+01,1.915500E+02,4.052400E+02,6.898400E+02,3.327500E-05,&
     & 1.102500E-04,2.155700E-04,3.281900E-04,5.636000E-04,1.109200E-03,&
     & 2.482900E-03,7.344900E-03,4.006700E-02,1.456100E-01,2.333400E-01,&
     & 4.112700E-01,8.636900E-01,3.535300E+00,2.018000E+01,8.010700E+01,&
     & 3.036200E-05,1.610700E-04,9.487300E-04,5.941400E-03,3.521400E-02,&
     & 1.206100E-01,3.523000E-01,1.090400E+00,7.352200E+00,3.428700E+01,&
     & 6.968300E+01,1.548200E+02,3.835700E+02,9.679800E+02,2.100900E+03,&
     & 3.570200E+03,7.543500E-05,2.757000E-04,1.184500E-03,6.096000E-03,&
     & 3.021800E-02,9.605100E-02,2.757900E-01,8.489200E-01,5.624000E+00,&
     & 2.583200E+01,5.226400E+01,1.161200E+02,2.876800E+02,7.259400E+02,&
     & 1.575600E+03,2.677500E+03,8.063000E-05,2.797200E-04,1.071900E-03,&
     & 4.935300E-03,2.211900E-02,6.712700E-02,1.904900E-01,5.856000E-01,&
     & 3.891000E+00,1.761500E+01,3.532200E+01,7.755600E+01,1.917900E+02,&
     & 4.839800E+02,1.050400E+03,1.785000E+03,7.280800E-05,2.386400E-04,&
     & 8.115000E-04,3.274400E-03,1.272200E-02,3.651800E-02,1.010700E-01,&
     & 3.103300E-01,2.086800E+00,9.386000E+00,1.847400E+01,3.992200E+01,&
     & 9.651300E+01,2.419700E+02,5.252500E+02,8.925300E+02,4.138000E-05,&
     & 1.359000E-04,2.556400E-04,3.922500E-04,7.004600E-04,1.363500E-03,&
     & 3.117500E-03,9.113600E-03,4.760300E-02,1.629400E-01,2.815500E-01,&
     & 4.726400E-01,1.025500E+00,5.091900E+00,2.643300E+01,1.038800E+02,&
     & 4.074300E-05,2.504400E-04,1.538300E-03,9.257800E-03,4.868500E-02,&
     & 1.592200E-01,4.595900E-01,1.418200E+00,9.600600E+00,4.284100E+01,&
     & 8.579600E+01,1.892100E+02,4.665200E+02,1.189800E+03,2.641000E+03,&
     & 4.467500E+03,1.026300E-04,4.087000E-04,1.817500E-03,9.110200E-03,&
     & 4.124300E-02,1.265800E-01,3.591700E-01,1.104000E+00,7.337500E+00,&
     & 3.227800E+01,6.435000E+01,1.419000E+02,3.499100E+02,8.923500E+02,&
     & 1.980800E+03,3.350500E+03,1.096300E-04,4.064300E-04,1.596500E-03,&
     & 7.225500E-03,2.994800E-02,8.840500E-02,2.477400E-01,7.621200E-01,&
     & 5.066200E+00,2.202300E+01,4.349600E+01,9.481800E+01,2.332700E+02,&
     & 5.948900E+02,1.320500E+03,2.233700E+03,9.799800E-05,3.383200E-04,&
     & 1.175500E-03,4.671200E-03,1.704800E-02,4.797700E-02,1.313200E-01,&
     & 4.040400E-01,2.708700E+00,1.171100E+01,2.278100E+01,4.886600E+01,&
     & 1.175100E+02,2.974400E+02,6.602600E+02,1.116800E+03,5.044200E-05,&
     & 1.624300E-04,3.040700E-04,4.533600E-04,8.545000E-04,1.666400E-03,&
     & 3.825700E-03,1.108400E-02,5.550400E-02,1.862400E-01,3.181900E-01,&
     & 5.528800E-01,1.310500E+00,6.783500E+00,3.372400E+01,1.310200E+02/
      data   absb(:,201:220) /                                          &
     & 1.441000E-05,4.399500E-05,1.784300E-04,1.147300E-03,9.236500E-03,&
     & 3.777700E-02,1.188500E-01,3.815700E-01,2.472300E+00,1.315200E+01,&
     & 2.696100E+01,6.232900E+01,1.655200E+02,4.488900E+02,9.967300E+02,&
     & 1.735400E+03,2.787200E-05,7.277600E-05,2.635000E-04,1.388800E-03,&
     & 8.334900E-03,3.038300E-02,9.372500E-02,2.988900E-01,1.901700E+00,&
     & 9.943800E+00,2.023900E+01,4.674500E+01,1.241400E+02,3.366600E+02,&
     & 7.476100E+02,1.301500E+03,2.902700E-05,7.569500E-05,2.556400E-04,&
     & 1.201600E-03,6.306400E-03,2.133100E-02,6.504100E-02,2.066200E-01,&
     & 1.326900E+00,6.778000E+00,1.372100E+01,3.131400E+01,8.276100E+01,&
     & 2.244400E+02,4.983900E+02,8.676200E+02,2.594300E-05,6.805000E-05,&
     & 2.087000E-04,8.601100E-04,3.787000E-03,1.169400E-02,3.480300E-02,&
     & 1.098900E-01,7.171700E-01,3.647100E+00,7.235700E+00,1.613200E+01,&
     & 4.183400E+01,1.122200E+02,2.491900E+02,4.338300E+02,1.682000E-05,&
     & 5.549500E-05,1.213300E-04,1.812700E-04,3.055600E-04,5.784500E-04,&
     & 1.341100E-03,4.017200E-03,2.384200E-02,9.185300E-02,1.563300E-01,&
     & 2.853300E-01,5.423300E-01,1.642700E+00,1.052400E+01,5.112100E+01,&
     & 1.601800E-05,5.961100E-05,2.933200E-04,1.956500E-03,1.427000E-02,&
     & 5.433100E-02,1.663500E-01,5.324900E-01,3.523400E+00,1.786600E+01,&
     & 3.662400E+01,8.373400E+01,2.214400E+02,6.083000E+02,1.367300E+03,&
     & 2.433300E+03,3.534800E-05,1.048200E-04,4.155700E-04,2.218100E-03,&
     & 1.264200E-02,4.348400E-02,1.310200E-01,4.165200E-01,2.708900E+00,&
     & 1.351100E+01,2.748600E+01,6.279100E+01,1.660800E+02,4.562300E+02,&
     & 1.025500E+03,1.824800E+03,3.732000E-05,1.105600E-04,3.954400E-04,&
     & 1.874600E-03,9.438300E-03,3.048100E-02,9.081300E-02,2.876400E-01,&
     & 1.885400E+00,9.229800E+00,1.864200E+01,4.207300E+01,1.107200E+02,&
     & 3.041700E+02,6.836600E+02,1.216600E+03,3.390000E-05,9.820200E-05,&
     & 3.159700E-04,1.303800E-03,5.569400E-03,1.668400E-02,4.848100E-02,&
     & 1.528800E-01,1.015600E+00,4.959500E+00,9.838200E+00,2.171700E+01,&
     & 5.600600E+01,1.520800E+02,3.418400E+02,6.083100E+02,2.189300E-05,&
     & 7.315800E-05,1.467700E-04,2.283000E-04,3.849900E-04,7.576200E-04,&
     & 1.730100E-03,5.244200E-03,2.942300E-02,1.114100E-01,1.847700E-01,&
     & 3.309700E-01,6.655100E-01,2.229800E+00,1.607500E+01,7.012200E+01,&
     & 1.936400E-05,8.798900E-05,4.913200E-04,3.252000E-03,2.118800E-02,&
     & 7.542800E-02,2.270700E-01,7.228000E-01,4.862400E+00,2.346900E+01,&
     & 4.784200E+01,1.084300E+02,2.844700E+02,7.908000E+02,1.816600E+03,&
     & 3.256600E+03,4.663000E-05,1.563400E-04,6.553700E-04,3.480800E-03,&
     & 1.841500E-02,6.029400E-02,1.784500E-01,5.645600E-01,3.735900E+00,&
     & 1.774700E+01,3.591300E+01,8.132100E+01,2.133400E+02,5.931200E+02,&
     & 1.362500E+03,2.442600E+03,4.970100E-05,1.626800E-04,6.087400E-04,&
     & 2.869400E-03,1.358200E-02,4.224500E-02,1.234800E-01,3.895100E-01,&
     & 2.594800E+00,1.213500E+01,2.436200E+01,5.451600E+01,1.422300E+02,&
     & 3.954100E+02,9.082900E+02,1.628300E+03,4.537600E-05,1.417200E-04,&
     & 4.743700E-04,1.946100E-03,7.888800E-03,2.305800E-02,6.573100E-02,&
     & 2.066100E-01,1.393400E+00,6.508600E+00,1.285200E+01,2.819800E+01,&
     & 7.202900E+01,1.976900E+02,4.541200E+02,8.142000E+02,2.772300E-05,&
     & 9.098700E-05,1.772800E-04,2.780000E-04,4.863200E-04,9.539600E-04,&
     & 2.202700E-03,6.669200E-03,3.553800E-02,1.278500E-01,2.279300E-01,&
     & 3.820500E-01,7.826700E-01,3.436700E+00,2.169000E+01,9.303700E+01,&
     & 2.492300E-05,1.354800E-04,8.185400E-04,5.220400E-03,3.020400E-02,&
     & 1.018100E-01,3.029900E-01,9.567500E-01,6.524500E+00,3.012000E+01,&
     & 6.040300E+01,1.359700E+02,3.542600E+02,9.937100E+02,2.340400E+03,&
     & 4.187500E+03,6.293600E-05,2.339400E-04,1.022000E-03,5.331700E-03,&
     & 2.589500E-02,8.119300E-02,2.374800E-01,7.463400E-01,5.009500E+00,&
     & 2.276100E+01,4.535500E+01,1.019800E+02,2.657000E+02,7.452700E+02,&
     & 1.755300E+03,3.140400E+03,6.750500E-05,2.379800E-04,9.237400E-04,&
     & 4.297200E-03,1.892200E-02,5.684400E-02,1.640300E-01,5.147400E-01,&
     & 3.471500E+00,1.556700E+01,3.079400E+01,6.839800E+01,1.771400E+02,&
     & 4.968400E+02,1.170200E+03,2.093700E+03,6.112900E-05,2.029500E-04,&
     & 6.988100E-04,2.834200E-03,1.085900E-02,3.097800E-02,8.715400E-02,&
     & 2.728500E-01,1.858600E+00,8.330500E+00,1.624700E+01,3.545500E+01,&
     & 8.979100E+01,2.484200E+02,5.850800E+02,1.046800E+03,3.425300E-05,&
     & 1.118900E-04,2.108500E-04,3.310500E-04,6.014400E-04,1.179600E-03,&
     & 2.764600E-03,8.275400E-03,4.199200E-02,1.517600E-01,2.587500E-01,&
     & 4.617200E-01,9.332200E-01,4.860900E+00,2.834600E+01,1.196800E+02/
      data   absb(:,221:240) /                                          &
     & 3.358100E-05,2.103200E-04,1.323300E-03,8.106900E-03,4.173800E-02,&
     & 1.341900E-01,3.949100E-01,1.243000E+00,8.526900E+00,3.788400E+01,&
     & 7.432800E+01,1.656600E+02,4.302800E+02,1.215500E+03,2.925800E+03,&
     & 5.226900E+03,8.565700E-05,3.452500E-04,1.567400E-03,7.950800E-03,&
     & 3.526600E-02,1.069300E-01,3.090900E-01,9.686200E-01,6.541900E+00,&
     & 2.860900E+01,5.582700E+01,1.242400E+02,3.227100E+02,9.115900E+02,&
     & 2.194200E+03,3.920100E+03,9.174000E-05,3.439900E-04,1.373700E-03,&
     & 6.274700E-03,2.555300E-02,7.482500E-02,2.132300E-01,6.678200E-01,&
     & 4.526400E+00,1.956000E+01,3.792100E+01,8.337000E+01,2.151300E+02,&
     & 6.077100E+02,1.462900E+03,2.613300E+03,8.218300E-05,2.868300E-04,&
     & 1.010500E-03,4.036000E-03,1.449100E-02,4.069300E-02,1.132000E-01,&
     & 3.536400E-01,2.418000E+00,1.044800E+01,1.997800E+01,4.332000E+01,&
     & 1.091500E+02,3.038700E+02,7.314000E+02,1.306600E+03,4.150200E-05,&
     & 1.332600E-04,2.500000E-04,3.858500E-04,7.316700E-04,1.437600E-03,&
     & 3.366300E-03,1.009000E-02,4.938000E-02,1.730900E-01,3.000300E-01,&
     & 5.228900E-01,1.146900E+00,6.547900E+00,3.603300E+01,1.496300E+02,&
     & 1.160600E-05,3.680300E-05,1.560000E-04,1.038200E-03,8.208400E-03,&
     & 3.283200E-02,1.037100E-01,3.410100E-01,2.245300E+00,1.175700E+01,&
     & 2.410600E+01,5.585300E+01,1.553600E+02,4.712700E+02,1.148300E+03,&
     & 2.113600E+03,2.334500E-05,6.251800E-05,2.316500E-04,1.239600E-03,&
     & 7.415400E-03,2.638700E-02,8.193600E-02,2.674900E-01,1.735300E+00,&
     & 8.911800E+00,1.814500E+01,4.189600E+01,1.165200E+02,3.534300E+02,&
     & 8.612500E+02,1.585300E+03,2.445800E-05,6.574600E-05,2.245500E-04,&
     & 1.067800E-03,5.598600E-03,1.854300E-02,5.688600E-02,1.849100E-01,&
     & 1.211000E+00,6.138200E+00,1.231800E+01,2.823900E+01,7.768100E+01,&
     & 2.356300E+02,5.741500E+02,1.056900E+03,2.204400E-05,5.898900E-05,&
     & 1.838000E-04,7.627300E-04,3.344700E-03,1.019000E-02,3.045200E-02,&
     & 9.833900E-02,6.523400E-01,3.311500E+00,6.578800E+00,1.463000E+01,&
     & 3.961100E+01,1.178200E+02,2.870700E+02,5.284400E+02,1.434100E-05,&
     & 4.754700E-05,9.896500E-05,1.546600E-04,2.603000E-04,5.076400E-04,&
     & 1.197300E-03,3.639800E-03,2.129500E-02,8.105700E-02,1.434600E-01,&
     & 2.647900E-01,5.161700E-01,1.692500E+00,1.176800E+01,6.058100E+01,&
     & 1.310800E-05,5.076100E-05,2.587900E-04,1.772000E-03,1.259300E-02,&
     & 4.698700E-02,1.451500E-01,4.748000E-01,3.193300E+00,1.598000E+01,&
     & 3.248900E+01,7.465900E+01,2.059600E+02,6.323900E+02,1.563000E+03,&
     & 2.931600E+03,2.986000E-05,9.100300E-05,3.664700E-04,1.989300E-03,&
     & 1.113200E-02,3.768400E-02,1.144300E-01,3.718400E-01,2.466400E+00,&
     & 1.210900E+01,2.445500E+01,5.599300E+01,1.544600E+02,4.742800E+02,&
     & 1.172300E+03,2.198700E+03,3.170300E-05,9.619300E-05,3.489100E-04,&
     & 1.669500E-03,8.285500E-03,2.645800E-02,7.934500E-02,2.567400E-01,&
     & 1.717600E+00,8.333600E+00,1.662000E+01,3.775800E+01,1.029800E+02,&
     & 3.161800E+02,7.815200E+02,1.465900E+03,2.897300E-05,8.539300E-05,&
     & 2.793400E-04,1.155600E-03,4.883000E-03,1.448000E-02,4.237700E-02,&
     & 1.364300E-01,9.225200E-01,4.483200E+00,8.864500E+00,1.962100E+01,&
     & 5.257200E+01,1.580900E+02,3.907600E+02,7.329200E+02,1.854400E-05,&
     & 6.078500E-05,1.203800E-04,1.935600E-04,3.315000E-04,6.607600E-04,&
     & 1.540800E-03,4.750600E-03,2.617400E-02,9.890600E-02,1.767300E-01,&
     & 3.058700E-01,6.247400E-01,2.242700E+00,1.762400E+01,8.238500E+01,&
     & 1.605800E-05,7.568000E-05,4.358300E-04,2.936900E-03,1.855800E-02,&
     & 6.504600E-02,1.981500E-01,6.427300E-01,4.401200E+00,2.110800E+01,&
     & 4.211100E+01,9.628700E+01,2.631200E+02,8.155300E+02,2.059300E+03,&
     & 3.880200E+03,3.959800E-05,1.360100E-04,5.788800E-04,3.120000E-03,&
     & 1.611800E-02,5.201800E-02,1.558400E-01,5.029500E-01,3.395800E+00,&
     & 1.599100E+01,3.170400E+01,7.221500E+01,1.973300E+02,6.116400E+02,&
     & 1.544500E+03,2.910100E+03,4.239900E-05,1.412400E-04,5.375300E-04,&
     & 2.555700E-03,1.187900E-02,3.644800E-02,1.078800E-01,3.472200E-01,&
     & 2.359500E+00,1.099200E+01,2.158500E+01,4.871000E+01,1.315700E+02,&
     & 4.077500E+02,1.029600E+03,1.940100E+03,3.884300E-05,1.231600E-04,&
     & 4.178200E-04,1.723700E-03,6.881800E-03,1.993200E-02,5.746100E-02,&
     & 1.843500E-01,1.263800E+00,5.897100E+00,1.150200E+01,2.538800E+01,&
     & 6.722000E+01,2.039000E+02,5.148400E+02,9.700700E+02,2.327200E-05,&
     & 7.592900E-05,1.449200E-04,2.362400E-04,4.171800E-04,8.268900E-04,&
     & 1.960900E-03,6.033300E-03,3.165700E-02,1.158600E-01,2.113500E-01,&
     & 3.696100E-01,7.403300E-01,3.340900E+00,2.365400E+01,1.082300E+02/
      data   absb(:,241:260) /                                          &
     & 2.087100E-05,1.171100E-04,7.239300E-04,4.699200E-03,2.642300E-02,&
     & 8.744700E-02,2.635200E-01,8.510400E-01,5.883400E+00,2.728500E+01,&
     & 5.309100E+01,1.200200E+02,3.267000E+02,1.018900E+03,2.628200E+03,&
     & 4.954400E+03,5.359200E-05,2.030300E-04,9.032800E-04,4.763600E-03,&
     & 2.260800E-02,6.981400E-02,2.069700E-01,6.653000E-01,4.535000E+00,&
     & 2.065900E+01,3.997900E+01,9.002300E+01,2.450000E+02,7.641700E+02,&
     & 1.971100E+03,3.715600E+03,5.766800E-05,2.062500E-04,8.145100E-04,&
     & 3.817800E-03,1.649000E-02,4.889800E-02,1.431300E-01,4.590500E-01,&
     & 3.146700E+00,1.417400E+01,2.724800E+01,6.073600E+01,1.633700E+02,&
     & 5.094400E+02,1.314000E+03,2.477000E+03,5.230300E-05,1.759900E-04,&
     & 6.136600E-04,2.506300E-03,9.424200E-03,2.667900E-02,7.612800E-02,&
     & 2.434000E-01,1.682400E+00,7.586300E+00,1.447900E+01,3.175300E+01,&
     & 8.353800E+01,2.548000E+02,6.570200E+02,1.238600E+03,2.859400E-05,&
     & 9.200800E-05,1.740400E-04,2.785500E-04,5.183700E-04,1.018000E-03,&
     & 2.433300E-03,7.488800E-03,3.764400E-02,1.350700E-01,2.454500E-01,&
     & 4.427300E-01,8.856200E-01,4.669700E+00,3.077700E+01,1.378100E+02,&
     & 2.828700E-05,1.810800E-04,1.164100E-03,7.228200E-03,3.642300E-02,&
     & 1.150400E-01,3.422100E-01,1.107900E+00,7.650100E+00,3.467600E+01,&
     & 6.553100E+01,1.459600E+02,3.953900E+02,1.237800E+03,3.262500E+03,&
     & 6.151200E+03,7.291000E-05,2.976800E-04,1.380700E-03,7.054200E-03,&
     & 3.071200E-02,9.187800E-02,2.682100E-01,8.652600E-01,5.891200E+00,&
     & 2.624800E+01,4.934400E+01,1.094700E+02,2.965600E+02,9.283500E+02,&
     & 2.446800E+03,4.613500E+03,7.827400E-05,2.968300E-04,1.206200E-03,&
     & 5.548700E-03,2.221000E-02,6.428600E-02,1.853700E-01,5.962100E-01,&
     & 4.082800E+00,1.796600E+01,3.366100E+01,7.387800E+01,1.977800E+02,&
     & 6.189000E+02,1.631300E+03,3.057900E+03,7.019100E-05,2.476800E-04,&
     & 8.853200E-04,3.549000E-03,1.255600E-02,3.497200E-02,9.864700E-02,&
     & 3.154400E-01,2.180600E+00,9.581000E+00,1.784000E+01,3.869000E+01,&
     & 1.012600E+02,3.096500E+02,8.156600E+02,1.537800E+03,3.449500E-05,&
     & 1.099800E-04,2.054800E-04,3.263000E-04,6.275700E-04,1.241200E-03,&
     & 2.939300E-03,9.126900E-03,4.426300E-02,1.585100E-01,2.818400E-01,&
     & 5.056000E-01,1.077700E+00,6.276000E+00,3.887100E+01,1.712700E+02,&
     & 9.397300E-06,3.100300E-05,1.367700E-04,9.413100E-04,7.296200E-03,&
     & 2.862500E-02,9.063900E-02,3.042100E-01,2.057100E+00,1.048100E+01,&
     & 2.158600E+01,4.998700E+01,1.437000E+02,4.871300E+02,1.316700E+03,&
     & 2.561200E+03,1.963600E-05,5.382300E-05,2.043300E-04,1.109500E-03,&
     & 6.576700E-03,2.301300E-02,7.173400E-02,2.389700E-01,1.596700E+00,&
     & 7.968500E+00,1.631400E+01,3.750100E+01,1.077900E+02,3.653400E+02,&
     & 9.875600E+02,1.920800E+03,2.070400E-05,5.706100E-05,1.978800E-04,&
     & 9.514800E-04,4.957600E-03,1.618000E-02,4.982400E-02,1.651600E-01,&
     & 1.111500E+00,5.549000E+00,1.111500E+01,2.541800E+01,7.194100E+01,&
     & 2.435600E+02,6.583300E+02,1.280500E+03,1.879300E-05,5.127100E-05,&
     & 1.623200E-04,6.766000E-04,2.951800E-03,8.895400E-03,2.669500E-02,&
     & 8.792300E-02,5.960500E-01,2.999600E+00,5.969600E+00,1.332500E+01,&
     & 3.697900E+01,1.219200E+02,3.291900E+02,6.403100E+02,1.220400E-05,&
     & 4.028000E-05,8.007100E-05,1.324400E-04,2.214700E-04,4.455100E-04,&
     & 1.061100E-03,3.263100E-03,1.882700E-02,7.430900E-02,1.311800E-01,&
     & 2.488000E-01,5.088100E-01,1.659900E+00,1.311900E+01,7.079500E+01,&
     & 1.078700E-05,4.349600E-05,2.285100E-04,1.603500E-03,1.111600E-02,&
     & 4.074000E-02,1.268400E-01,4.220000E-01,2.905700E+00,1.442000E+01,&
     & 2.887200E+01,6.651400E+01,1.891000E+02,6.477500E+02,1.776600E+03,&
     & 3.507800E+03,2.532200E-05,7.910300E-05,3.239200E-04,1.784400E-03,&
     & 9.787800E-03,3.271500E-02,1.001400E-01,3.311600E-01,2.253500E+00,&
     & 1.095500E+01,2.182400E+01,4.990300E+01,1.418200E+02,4.858300E+02,&
     & 1.332400E+03,2.630800E+03,2.702500E-05,8.363500E-05,3.077400E-04,&
     & 1.489400E-03,7.282200E-03,2.297900E-02,6.942600E-02,2.288800E-01,&
     & 1.568100E+00,7.587800E+00,1.490000E+01,3.382800E+01,9.467500E+01,&
     & 3.238700E+02,8.883000E+02,1.753800E+03,2.483100E-05,7.436900E-05,&
     & 2.462300E-04,1.026200E-03,4.273600E-03,1.258900E-02,3.710700E-02,&
     & 1.216900E-01,8.399900E-01,4.080500E+00,7.988400E+00,1.776900E+01,&
     & 4.874700E+01,1.621200E+02,4.441300E+02,8.768400E+02,1.565400E-05,&
     & 5.062400E-05,9.805900E-05,1.644200E-04,2.845200E-04,5.708100E-04,&
     & 1.371400E-03,4.252900E-03,2.333700E-02,8.625300E-02,1.679100E-01,&
     & 2.908900E-01,5.956100E-01,2.193800E+00,1.926700E+01,9.534700E+01/
      data   absb(:,261:280) /                                          &
     & 1.338500E-05,6.540100E-05,3.863900E-04,2.652200E-03,1.629400E-02,&
     & 5.614000E-02,1.726800E-01,5.707200E-01,3.980000E+00,1.921900E+01,&
     & 3.739200E+01,8.515500E+01,2.406500E+02,8.302300E+02,2.317300E+03,&
     & 4.597200E+03,3.372900E-05,1.183000E-04,5.116700E-04,2.795000E-03,&
     & 1.414200E-02,4.493100E-02,1.359700E-01,4.474700E-01,3.083300E+00,&
     & 1.460000E+01,2.825600E+01,6.388700E+01,1.804800E+02,6.226800E+02,&
     & 1.738000E+03,3.447500E+03,3.629000E-05,1.226900E-04,4.745700E-04,&
     & 2.277500E-03,1.039700E-02,3.153900E-02,9.412300E-02,3.090000E-01,&
     & 2.143400E+00,1.007300E+01,1.931800E+01,4.332500E+01,1.205100E+02,&
     & 4.151200E+02,1.158600E+03,2.298400E+03,3.330700E-05,1.070700E-04,&
     & 3.674900E-04,1.527100E-03,6.003900E-03,1.724400E-02,5.023700E-02,&
     & 1.640700E-01,1.146400E+00,5.397700E+00,1.033300E+01,2.279600E+01,&
     & 6.213400E+01,2.078600E+02,5.793300E+02,1.149300E+03,1.960900E-05,&
     & 6.212700E-05,1.188000E-04,2.000800E-04,3.576800E-04,7.148300E-04,&
     & 1.721200E-03,5.391200E-03,2.819000E-02,1.058000E-01,1.923900E-01,&
     & 3.673000E-01,7.031700E-01,3.200300E+00,2.570700E+01,1.241100E+02,&
     & 1.756600E-05,1.014700E-04,6.380100E-04,4.210600E-03,2.316400E-02,&
     & 7.528200E-02,2.286600E-01,7.567200E-01,5.288500E+00,2.510800E+01,&
     & 4.728600E+01,1.058800E+02,2.977500E+02,1.030000E+03,2.934300E+03,&
     & 5.824600E+03,4.574500E-05,1.757600E-04,7.969400E-04,4.240200E-03,&
     & 1.976800E-02,6.022100E-02,1.797200E-01,5.925300E-01,4.092200E+00,&
     & 1.906900E+01,3.571500E+01,7.944000E+01,2.233200E+02,7.724900E+02,&
     & 2.200700E+03,4.368000E+03,4.936800E-05,1.785200E-04,7.167500E-04,&
     & 3.387100E-03,1.438300E-02,4.221800E-02,1.243200E-01,4.089100E-01,&
     & 2.842100E+00,1.311500E+01,2.441700E+01,5.389800E+01,1.491600E+02,&
     & 5.149900E+02,1.467100E+03,2.911900E+03,4.483300E-05,1.524800E-04,&
     & 5.395400E-04,2.213100E-03,8.189900E-03,2.305400E-02,6.627700E-02,&
     & 2.168800E-01,1.518200E+00,7.002000E+00,1.302500E+01,2.839000E+01,&
     & 7.699400E+01,2.580300E+02,7.335500E+02,1.455900E+03,2.389300E-05,&
     & 7.557800E-05,1.429500E-04,2.344500E-04,4.450700E-04,8.757000E-04,&
     & 2.116100E-03,6.696000E-03,3.382800E-02,1.226500E-01,2.285400E-01,&
     & 4.222600E-01,8.595600E-01,4.434100E+00,3.318600E+01,1.573400E+02,&
     & 2.393100E-05,1.562500E-04,1.021100E-03,6.419600E-03,3.181500E-02,&
     & 9.920000E-02,2.958400E-01,9.873100E-01,6.847100E+00,3.204300E+01,&
     & 5.858700E+01,1.286700E+02,3.598700E+02,1.245000E+03,3.614100E+03,&
     & 7.174900E+03,6.221500E-05,2.569000E-04,1.209600E-03,6.242700E-03,&
     & 2.678200E-02,7.919700E-02,2.322700E-01,7.723900E-01,5.291800E+00,&
     & 2.433700E+01,4.422500E+01,9.655400E+01,2.699000E+02,9.337400E+02,&
     & 2.710500E+03,5.381200E+03,6.691900E-05,2.563400E-04,1.056100E-03,&
     & 4.894000E-03,1.934100E-02,5.542200E-02,1.606700E-01,5.322000E-01,&
     & 3.672400E+00,1.670400E+01,3.022800E+01,6.552100E+01,1.803400E+02,&
     & 6.224900E+02,1.807000E+03,3.587400E+03,6.004500E-05,2.135700E-04,&
     & 7.755200E-04,3.113000E-03,1.091300E-02,3.013800E-02,8.554700E-02,&
     & 2.820400E-01,1.959400E+00,8.894200E+00,1.610300E+01,3.452600E+01,&
     & 9.318200E+01,3.120800E+02,9.035100E+02,1.793700E+03,2.866800E-05,&
     & 9.073300E-05,1.684100E-04,2.749600E-04,5.359300E-04,1.069000E-03,&
     & 2.534600E-03,8.265100E-03,3.995600E-02,1.438100E-01,2.638300E-01,&
     & 4.878600E-01,1.011400E+00,5.972900E+00,4.163400E+01,1.948500E+02,&
     & 7.717000E-06,2.647100E-05,1.206500E-04,8.549300E-04,6.513200E-03,&
     & 2.522500E-02,8.007100E-02,2.733500E-01,1.907000E+00,9.527600E+00,&
     & 1.961000E+01,4.523700E+01,1.324200E+02,5.011200E+02,1.513900E+03,&
     & 3.104000E+03,1.667900E-05,4.686300E-05,1.805900E-04,1.000800E-03,&
     & 5.853000E-03,2.029400E-02,6.344400E-02,2.149300E-01,1.485700E+00,&
     & 7.276800E+00,1.485900E+01,3.399000E+01,9.931300E+01,3.758300E+02,&
     & 1.135400E+03,2.327900E+03,1.768500E-05,4.981800E-05,1.751300E-04,&
     & 8.527400E-04,4.401100E-03,1.427600E-02,4.406400E-02,1.486300E-01,&
     & 1.032900E+00,5.082600E+00,1.020400E+01,2.308200E+01,6.650700E+01,&
     & 2.505600E+02,7.569500E+02,1.552000E+03,1.612800E-05,4.480700E-05,&
     & 1.438100E-04,6.021300E-04,2.615600E-03,7.842700E-03,2.364400E-02,&
     & 7.912000E-02,5.518100E-01,2.746500E+00,5.484300E+00,1.226600E+01,&
     & 3.440300E+01,1.257500E+02,3.784800E+02,7.760300E+02,1.035800E-05,&
     & 3.288600E-05,6.479000E-05,1.122400E-04,1.886600E-04,3.860200E-04,&
     & 9.334800E-04,2.920600E-03,1.666300E-02,6.465500E-02,1.230500E-01,&
     & 2.337400E-01,4.777800E-01,1.572400E+00,1.476600E+01,8.173100E+01/
      data   absb(:,281:300) /                                          &
     & 9.012000E-06,3.773100E-05,2.038700E-04,1.457600E-03,9.897900E-03,&
     & 3.571200E-02,1.118100E-01,3.781800E-01,2.667700E+00,1.327100E+01,&
     & 2.616800E+01,5.973100E+01,1.733400E+02,6.615300E+02,2.021300E+03,&
     & 4.201500E+03,2.165900E-05,6.928000E-05,2.874200E-04,1.607000E-03,&
     & 8.692500E-03,2.869500E-02,8.835400E-02,2.970400E-01,2.077300E+00,&
     & 1.012100E+01,1.982500E+01,4.488200E+01,1.300100E+02,4.961400E+02,&
     & 1.515900E+03,3.151100E+03,2.322100E-05,7.291500E-05,2.733100E-04,&
     & 1.335400E-03,6.452100E-03,2.014900E-02,6.127100E-02,2.053300E-01,&
     & 1.444800E+00,7.021400E+00,1.361700E+01,3.051800E+01,8.707300E+01,&
     & 3.307600E+02,1.010700E+03,2.100700E+03,2.139500E-05,6.489200E-05,&
     & 2.177100E-04,9.164200E-04,3.767000E-03,1.104900E-02,3.279400E-02,&
     & 1.092200E-01,7.721400E-01,3.765700E+00,7.302800E+00,1.622200E+01,&
     & 4.513300E+01,1.660400E+02,5.053200E+02,1.050300E+03,1.320600E-05,&
     & 4.119800E-05,7.916900E-05,1.396500E-04,2.439800E-04,4.937200E-04,&
     & 1.188200E-03,3.795900E-03,2.066200E-02,7.929100E-02,1.469600E-01,&
     & 2.909300E-01,5.565200E-01,2.125000E+00,2.103900E+01,1.091500E+02,&
     & 1.131900E-05,5.724800E-05,3.441300E-04,2.400500E-03,1.445800E-02,&
     & 4.906000E-02,1.514900E-01,5.119700E-01,3.625200E+00,1.786300E+01,&
     & 3.400900E+01,7.614700E+01,2.198100E+02,8.416200E+02,2.613200E+03,&
     & 5.452600E+03,2.898900E-05,1.034700E-04,4.551800E-04,2.508300E-03,&
     & 1.249800E-02,3.931000E-02,1.193900E-01,4.016700E-01,2.818700E+00,&
     & 1.362200E+01,2.575400E+01,5.722700E+01,1.648600E+02,6.312000E+02,&
     & 1.959800E+03,4.089600E+03,3.128900E-05,1.069800E-04,4.204400E-04,&
     & 2.037500E-03,9.161500E-03,2.758600E-02,8.272500E-02,2.773000E-01,&
     & 1.959500E+00,9.420100E+00,1.766600E+01,3.896100E+01,1.104500E+02,&
     & 4.207900E+02,1.306600E+03,2.726300E+03,2.871700E-05,9.340300E-05,&
     & 3.245800E-04,1.360600E-03,5.266700E-03,1.509100E-02,4.422300E-02,&
     & 1.472300E-01,1.046300E+00,5.030700E+00,9.447500E+00,2.070000E+01,&
     & 5.738900E+01,2.113200E+02,6.532800E+02,1.363200E+03,1.636100E-05,&
     & 5.080800E-05,9.599500E-05,1.686900E-04,3.083800E-04,6.153900E-04,&
     & 1.483200E-03,4.821800E-03,2.517900E-02,9.546100E-02,1.761900E-01,&
     & 3.460700E-01,6.830300E-01,3.048800E+00,2.779900E+01,1.414200E+02,&
     & 1.499200E-05,8.879100E-05,5.656900E-04,3.780500E-03,2.043400E-02,&
     & 6.578500E-02,1.997800E-01,6.802100E-01,4.792100E+00,2.332500E+01,&
     & 4.320200E+01,9.459200E+01,2.715000E+02,1.038700E+03,3.279800E+03,&
     & 6.848600E+03,3.938500E-05,1.531900E-04,7.054200E-04,3.788200E-03,&
     & 1.740000E-02,5.264300E-02,1.572200E-01,5.332300E-01,3.721300E+00,&
     & 1.778300E+01,3.269700E+01,7.109200E+01,2.036000E+02,7.790300E+02,&
     & 2.459800E+03,5.136500E+03,4.255500E-05,1.553000E-04,6.316900E-04,&
     & 3.016800E-03,1.263500E-02,3.688900E-02,1.088800E-01,3.676900E-01,&
     & 2.584700E+00,1.227300E+01,2.239800E+01,4.844900E+01,1.364400E+02,&
     & 5.193400E+02,1.639900E+03,3.424300E+03,3.863300E-05,1.324700E-04,&
     & 4.754200E-04,1.959000E-03,7.177500E-03,2.012400E-02,5.812800E-02,&
     & 1.950800E-01,1.378400E+00,6.542000E+00,1.196600E+01,2.570300E+01,&
     & 7.103500E+01,2.609200E+02,8.199300E+02,1.712000E+03,1.989100E-05,&
     & 6.181200E-05,1.159300E-04,1.982400E-04,3.803800E-04,7.536500E-04,&
     & 1.819000E-03,6.036700E-03,3.030000E-02,1.127400E-01,2.071100E-01,&
     & 4.033800E-01,8.331200E-01,4.196400E+00,3.558500E+01,1.785600E+02,&
     & 2.052000E-05,1.362400E-04,8.981700E-04,5.734000E-03,2.801100E-02,&
     & 8.652000E-02,2.577000E-01,8.874000E-01,6.187500E+00,2.956400E+01,&
     & 5.395000E+01,1.150800E+02,3.283700E+02,1.249700E+03,4.009600E+03,&
     & 8.359200E+03,5.347900E-05,2.230300E-04,1.061600E-03,5.542900E-03,&
     & 2.355200E-02,6.911900E-02,2.026000E-01,6.952000E-01,4.798100E+00,&
     & 2.253600E+01,4.081000E+01,8.650700E+01,2.463000E+02,9.372700E+02,&
     & 3.007300E+03,6.269400E+03,5.760000E-05,2.222000E-04,9.269500E-04,&
     & 4.325200E-03,1.698800E-02,4.833500E-02,1.403000E-01,4.789200E-01,&
     & 3.329900E+00,1.553700E+01,2.791400E+01,5.898600E+01,1.650900E+02,&
     & 6.248500E+02,2.004800E+03,4.179300E+03,5.165400E-05,1.847400E-04,&
     & 6.804300E-04,2.739700E-03,9.554200E-03,2.629500E-02,7.484400E-02,&
     & 2.537300E-01,1.773800E+00,8.281600E+00,1.488100E+01,3.124100E+01,&
     & 8.610300E+01,3.140700E+02,1.002400E+03,2.089600E+03,2.374600E-05,&
     & 7.432400E-05,1.362100E-04,2.289900E-04,4.584200E-04,9.200000E-04,&
     & 2.174700E-03,7.408300E-03,3.585800E-02,1.341800E-01,2.449100E-01,&
     & 4.634700E-01,9.563800E-01,5.666100E+00,4.434300E+01,2.204200E+02/
      data   absb(:,301:320) /                                          &
     & 6.383800E-06,2.280800E-05,1.074000E-04,7.808300E-04,5.849600E-03,&
     & 2.234400E-02,7.095100E-02,2.466700E-01,1.767900E+00,8.816000E+00,&
     & 1.791300E+01,4.120700E+01,1.213700E+02,5.095700E+02,1.731100E+03,&
     & 3.735300E+03,1.424800E-05,4.104800E-05,1.609200E-04,9.061300E-04,&
     & 5.246300E-03,1.797600E-02,5.626900E-02,1.940800E-01,1.382300E+00,&
     & 6.767300E+00,1.359900E+01,3.105400E+01,9.104200E+01,3.821700E+02,&
     & 1.298300E+03,2.801100E+03,1.516800E-05,4.358900E-05,1.558800E-04,&
     & 7.685500E-04,3.934700E-03,1.264500E-02,3.910800E-02,1.342400E-01,&
     & 9.600500E-01,4.722000E+00,9.413700E+00,2.114500E+01,6.122400E+01,&
     & 2.547900E+02,8.655500E+02,1.867500E+03,1.390600E-05,3.931600E-05,&
     & 1.276300E-04,5.395500E-04,2.327100E-03,6.941200E-03,2.101600E-02,&
     & 7.143600E-02,5.121500E-01,2.537900E+00,5.061600E+00,1.134400E+01,&
     & 3.188600E+01,1.283600E+02,4.327900E+02,9.337900E+02,8.825100E-06,&
     & 2.689100E-05,5.283500E-05,9.339700E-05,1.644500E-04,3.319500E-04,&
     & 8.096400E-04,2.609800E-03,1.475600E-02,5.848900E-02,1.124400E-01,&
     & 2.195900E-01,4.561100E-01,1.486500E+00,1.641000E+01,9.375200E+01,&
     & 7.587800E-06,3.298500E-05,1.827700E-04,1.329300E-03,8.841700E-03,&
     & 3.153100E-02,9.862300E-02,3.410700E-01,2.450600E+00,1.235700E+01,&
     & 2.400200E+01,5.402900E+01,1.582300E+02,6.677100E+02,2.288000E+03,&
     & 4.991500E+03,1.863500E-05,6.093600E-05,2.565300E-04,1.451600E-03,&
     & 7.760400E-03,2.528100E-02,7.801300E-02,2.680900E-01,1.914900E+00,&
     & 9.468500E+00,1.821800E+01,4.071700E+01,1.186700E+02,5.007800E+02,&
     & 1.716000E+03,3.743800E+03,2.005000E-05,6.390700E-05,2.434600E-04,&
     & 1.202100E-03,5.734700E-03,1.778400E-02,5.408800E-02,1.852700E-01,&
     & 1.331000E+00,6.573500E+00,1.257700E+01,2.777400E+01,7.984100E+01,&
     & 3.338500E+02,1.144000E+03,2.495900E+03,1.851300E-05,5.689800E-05,&
     & 1.932500E-04,8.212500E-04,3.332100E-03,9.741500E-03,2.901500E-02,&
     & 9.848000E-02,7.100900E-01,3.513000E+00,6.743300E+00,1.487800E+01,&
     & 4.170700E+01,1.682400E+02,5.720400E+02,1.247900E+03,1.111900E-05,&
     & 3.388800E-05,6.470800E-05,1.164400E-04,2.108100E-04,4.239300E-04,&
     & 1.024700E-03,3.382000E-03,1.841300E-02,7.206400E-02,1.357400E-01,&
     & 2.784300E-01,5.343000E-01,2.018400E+00,2.285200E+01,1.244700E+02,&
     & 9.647500E-06,5.048100E-05,3.077500E-04,2.173000E-03,1.286800E-02,&
     & 4.315300E-02,1.329500E-01,4.623700E-01,3.309200E+00,1.655700E+01,&
     & 3.137300E+01,6.873500E+01,2.001700E+02,8.446600E+02,2.929300E+03,&
     & 6.415900E+03,2.505200E-05,9.071300E-05,4.057700E-04,2.254600E-03,&
     & 1.107700E-02,3.462100E-02,1.048800E-01,3.630800E-01,2.582100E+00,&
     & 1.267800E+01,2.380800E+01,5.180200E+01,1.501200E+02,6.335100E+02,&
     & 2.197000E+03,4.812000E+03,2.711000E-05,9.368700E-05,3.730100E-04,&
     & 1.827600E-03,8.097800E-03,2.431200E-02,7.270900E-02,2.505700E-01,&
     & 1.793000E+00,8.797600E+00,1.639000E+01,3.539100E+01,1.010200E+02,&
     & 4.223300E+02,1.464600E+03,3.208100E+03,2.484600E-05,8.169300E-05,&
     & 2.876600E-04,1.213600E-03,4.643300E-03,1.328800E-02,3.891900E-02,&
     & 1.329800E-01,9.556600E-01,4.691700E+00,8.773200E+00,1.891900E+01,&
     & 5.290300E+01,2.129000E+02,7.323400E+02,1.604000E+03,1.373400E-05,&
     & 4.161500E-05,7.847900E-05,1.403900E-04,2.655900E-04,5.256500E-04,&
     & 1.277600E-03,4.315700E-03,2.261300E-02,8.628100E-02,1.658700E-01,&
     & 3.230200E-01,6.682600E-01,2.876000E+00,2.989700E+01,1.604100E+02,&
     & 1.288900E-05,7.815100E-05,5.034800E-04,3.399400E-03,1.810000E-02,&
     & 5.787500E-02,1.747000E-01,6.138500E-01,4.358100E+00,2.144400E+01,&
     & 4.021200E+01,8.541600E+01,2.472700E+02,1.037900E+03,3.644100E+03,&
     & 7.980300E+03,3.407500E-05,1.340600E-04,6.243400E-04,3.390100E-03,&
     & 1.538200E-02,4.628500E-02,1.376400E-01,4.816800E-01,3.395600E+00,&
     & 1.640800E+01,3.051000E+01,6.436800E+01,1.854500E+02,7.784300E+02,&
     & 2.733100E+03,5.984900E+03,3.683400E-05,1.356300E-04,5.583800E-04,&
     & 2.685400E-03,1.115600E-02,3.242600E-02,9.537300E-02,3.322400E-01,&
     & 2.356100E+00,1.137600E+01,2.094900E+01,4.403000E+01,1.248100E+02,&
     & 5.189500E+02,1.822000E+03,3.989900E+03,3.338500E-05,1.154700E-04,&
     & 4.197200E-04,1.737400E-03,6.311500E-03,1.767600E-02,5.095800E-02,&
     & 1.763200E-01,1.253900E+00,6.071700E+00,1.118200E+01,2.348500E+01,&
     & 6.553000E+01,2.617100E+02,9.110100E+02,1.995100E+03,1.660900E-05,&
     & 5.083400E-05,9.299900E-05,1.652900E-04,3.258300E-04,6.483200E-04,&
     & 1.559200E-03,5.339900E-03,2.740700E-02,1.041600E-01,1.935300E-01,&
     & 3.814000E-01,7.910600E-01,3.964600E+00,3.800300E+01,2.015700E+02/
      data   absb(:,321:340) /                                          &
     & 1.770600E-05,1.194600E-04,7.923600E-04,5.117700E-03,2.469500E-02,&
     & 7.613400E-02,2.249300E-01,7.990500E-01,5.614800E+00,2.707200E+01,&
     & 5.050700E+01,1.043000E+02,2.986800E+02,1.245400E+03,4.420900E+03,&
     & 9.653200E+03,4.618100E-05,1.945200E-04,9.339300E-04,4.929600E-03,&
     & 2.072200E-02,6.079300E-02,1.770800E-01,6.268200E-01,4.368400E+00,&
     & 2.070300E+01,3.831400E+01,7.857000E+01,2.240100E+02,9.341100E+02,&
     & 3.315700E+03,7.240800E+03,4.975100E-05,1.933700E-04,8.148600E-04,&
     & 3.830800E-03,1.492500E-02,4.252400E-02,1.227000E-01,4.318600E-01,&
     & 3.029600E+00,1.434700E+01,2.625200E+01,5.376700E+01,1.508100E+02,&
     & 6.227300E+02,2.210400E+03,4.827200E+03,4.454400E-05,1.603700E-04,&
     & 5.971200E-04,2.413800E-03,8.382400E-03,2.310900E-02,6.550200E-02,&
     & 2.291300E-01,1.610800E+00,7.655100E+00,1.399300E+01,2.861300E+01,&
     & 7.936300E+01,3.140900E+02,1.105200E+03,2.413500E+03,1.973500E-05,&
     & 6.034600E-05,1.109100E-04,1.929200E-04,3.910500E-04,7.838000E-04,&
     & 1.865700E-03,6.491300E-03,3.273000E-02,1.257200E-01,2.268900E-01,&
     & 4.333800E-01,9.277300E-01,5.343200E+00,4.703700E+01,2.475600E+02,&
     & 5.339300E-06,1.993400E-05,9.754300E-05,7.241400E-04,5.322400E-03,&
     & 1.999400E-02,6.345100E-02,2.240400E-01,1.655000E+00,8.243700E+00,&
     & 1.661000E+01,3.787000E+01,1.116600E+02,5.154300E+02,1.975300E+03,&
     & 4.473600E+03,1.228800E-05,3.634900E-05,1.451500E-04,8.299800E-04,&
     & 4.744000E-03,1.610200E-02,5.035200E-02,1.764900E-01,1.297000E+00,&
     & 6.364500E+00,1.264800E+01,2.864600E+01,8.375000E+01,3.865700E+02,&
     & 1.481400E+03,3.355100E+03,1.313200E-05,3.856200E-05,1.407900E-04,&
     & 6.999100E-04,3.545500E-03,1.132300E-02,3.499900E-02,1.221400E-01,&
     & 8.991000E-01,4.444200E+00,8.789900E+00,1.959200E+01,5.664100E+01,&
     & 2.577200E+02,9.876600E+02,2.236700E+03,1.209600E-05,3.480900E-05,&
     & 1.146900E-04,4.896200E-04,2.085600E-03,6.221600E-03,1.881100E-02,&
     & 6.502200E-02,4.785600E-01,2.379900E+00,4.718000E+00,1.056000E+01,&
     & 2.976100E+01,1.304000E+02,4.938200E+02,1.118300E+03,7.526400E-06,&
     & 2.236900E-05,4.320300E-05,7.925900E-05,1.427300E-04,2.862900E-04,&
     & 7.069600E-04,2.338400E-03,1.323500E-02,5.304600E-02,1.041000E-01,&
     & 2.106700E-01,4.374100E-01,1.431000E+00,1.801800E+01,1.073100E+02,&
     & 6.460900E-06,2.929100E-05,1.663700E-04,1.225900E-03,7.988000E-03,&
     & 2.807900E-02,8.764600E-02,3.101300E-01,2.272400E+00,1.148300E+01,&
     & 2.239500E+01,4.948600E+01,1.450500E+02,6.705500E+02,2.584400E+03,&
     & 5.902300E+03,1.618900E-05,5.405100E-05,2.321100E-04,1.325500E-03,&
     & 6.977300E-03,2.258100E-02,6.932100E-02,2.440300E-01,1.780400E+00,&
     & 8.843700E+00,1.704800E+01,3.742500E+01,1.088000E+02,5.029200E+02,&
     & 1.938300E+03,4.426400E+03,1.746700E-05,5.666700E-05,2.190600E-04,&
     & 1.091700E-03,5.140100E-03,1.586900E-02,4.812800E-02,1.687000E-01,&
     & 1.234800E+00,6.160500E+00,1.180400E+01,2.564500E+01,7.358600E+01,&
     & 3.352800E+02,1.292200E+03,2.951100E+03,1.613100E-05,5.030100E-05,&
     & 1.733800E-04,7.417700E-04,2.975000E-03,8.687500E-03,2.582000E-02,&
     & 8.974100E-02,6.570200E-01,3.288300E+00,6.325700E+00,1.379100E+01,&
     & 3.877800E+01,1.696900E+02,6.460600E+02,1.475600E+03,9.433200E-06,&
     & 2.789500E-05,5.350100E-05,9.758000E-05,1.826100E-04,3.631400E-04,&
     & 8.910800E-04,3.017900E-03,1.663200E-02,6.527800E-02,1.281200E-01,&
     & 2.527700E-01,5.362000E-01,1.977900E+00,2.455100E+01,1.415600E+02,&
     & 8.320000E-06,4.504400E-05,2.789800E-04,1.984800E-03,1.156400E-02,&
     & 3.841700E-02,1.175600E-01,4.204900E-01,3.050100E+00,1.526100E+01,&
     & 2.949500E+01,6.299300E+01,1.833600E+02,8.439300E+02,3.275800E+03,&
     & 7.504600E+03,2.185300E-05,8.041900E-05,3.649700E-04,2.046200E-03,&
     & 9.921500E-03,3.083400E-02,9.280400E-02,3.306600E-01,2.386200E+00,&
     & 1.173900E+01,2.245300E+01,4.762600E+01,1.375300E+02,6.329400E+02,&
     & 2.456700E+03,5.627900E+03,2.368100E-05,8.281200E-05,3.342000E-04,&
     & 1.650300E-03,7.234300E-03,2.163700E-02,6.433600E-02,2.283800E-01,&
     & 1.654500E+00,8.169500E+00,1.549800E+01,3.266600E+01,9.304100E+01,&
     & 4.219500E+02,1.637900E+03,3.752100E+03,2.165300E-05,7.200700E-05,&
     & 2.571700E-04,1.089500E-03,4.133400E-03,1.180500E-02,3.446500E-02,&
     & 1.213800E-01,8.794500E-01,4.359300E+00,8.285100E+00,1.751600E+01,&
     & 4.916800E+01,2.136200E+02,8.189600E+02,1.876100E+03,1.159300E-05,&
     & 3.461100E-05,6.439100E-05,1.162900E-04,2.290300E-04,4.522900E-04,&
     & 1.106300E-03,3.803900E-03,2.060200E-02,8.019100E-02,1.532100E-01,&
     & 3.007700E-01,6.572700E-01,2.714000E+00,3.209100E+01,1.812300E+02/
      data   absb(:,341:360) /                                          &
     & 1.120900E-05,6.964300E-05,4.527800E-04,3.086300E-03,1.615700E-02,&
     & 5.144800E-02,1.540100E-01,5.579000E-01,3.999800E+00,1.970000E+01,&
     & 3.786800E+01,7.865900E+01,2.261300E+02,1.033900E+03,4.039200E+03,&
     & 9.241200E+03,2.973700E-05,1.185500E-04,5.578500E-04,3.055400E-03,&
     & 1.369800E-02,4.117400E-02,1.215000E-01,4.382100E-01,3.125300E+00,&
     & 1.513500E+01,2.882900E+01,5.943900E+01,1.696100E+02,7.753800E+02,&
     & 3.029300E+03,6.930400E+03,3.213300E-05,1.195800E-04,4.975300E-04,&
     & 2.412300E-03,9.905700E-03,2.884400E-02,8.421800E-02,3.023700E-01,&
     & 2.165800E+00,1.053400E+01,1.985400E+01,4.075600E+01,1.148100E+02,&
     & 5.169100E+02,2.019600E+03,4.620700E+03,2.904600E-05,1.014400E-04,&
     & 3.729300E-04,1.550200E-03,5.593400E-03,1.571200E-02,4.502200E-02,&
     & 1.605600E-01,1.150500E+00,5.619700E+00,1.059300E+01,2.181400E+01,&
     & 6.080900E+01,2.617300E+02,1.009800E+03,2.310200E+03,1.394100E-05,&
     & 4.183600E-05,7.635700E-05,1.373200E-04,2.789700E-04,5.589000E-04,&
     & 1.342000E-03,4.665800E-03,2.512000E-02,9.760100E-02,1.838100E-01,&
     & 3.509500E-01,7.587700E-01,3.761400E+00,4.050400E+01,2.263900E+02,&
     & 1.544300E-05,1.058900E-04,7.049500E-04,4.599900E-03,2.189500E-02,&
     & 6.770800E-02,1.984700E-01,7.237700E-01,5.141700E+00,2.485700E+01,&
     & 4.732100E+01,9.665800E+01,2.733900E+02,1.237700E+03,4.864300E+03,&
     & 1.107000E+04,4.019600E-05,1.712800E-04,8.285900E-04,4.408100E-03,&
     & 1.834900E-02,5.415100E-02,1.562600E-01,5.683700E-01,4.012500E+00,&
     & 1.907200E+01,3.603000E+01,7.299700E+01,2.050700E+02,9.282200E+02,&
     & 3.648400E+03,8.302900E+03,4.330200E-05,1.696900E-04,7.205500E-04,&
     & 3.415900E-03,1.319900E-02,3.787600E-02,1.082200E-01,3.919600E-01,&
     & 2.780500E+00,1.324800E+01,2.479500E+01,5.003900E+01,1.388300E+02,&
     & 6.188100E+02,2.432300E+03,5.535100E+03,3.863900E-05,1.403300E-04,&
     & 5.270200E-04,2.140200E-03,7.399200E-03,2.055900E-02,5.783300E-02,&
     & 2.079500E-01,1.475600E+00,7.065300E+00,1.324700E+01,2.674200E+01,&
     & 7.361600E+01,3.133900E+02,1.216100E+03,2.767600E+03,1.648100E-05,&
     & 4.921900E-05,9.148300E-05,1.638600E-04,3.323800E-04,6.698300E-04,&
     & 1.605700E-03,5.627500E-03,3.018800E-02,1.170400E-01,2.157700E-01,&
     & 4.072700E-01,9.022100E-01,5.052400E+00,4.985300E+01,2.764500E+02,&
     & 4.502900E-06,1.755900E-05,8.890500E-05,6.704000E-04,4.837200E-03,&
     & 1.789600E-02,5.679300E-02,2.041100E-01,1.551700E+00,7.708100E+00,&
     & 1.555200E+01,3.508900E+01,1.028600E+02,5.168000E+02,2.237200E+03,&
     & 5.265800E+03,1.064600E-05,3.231300E-05,1.313600E-04,7.604900E-04,&
     & 4.290900E-03,1.442900E-02,4.505700E-02,1.608800E-01,1.218100E+00,&
     & 5.988500E+00,1.189300E+01,2.661900E+01,7.719700E+01,3.876000E+02,&
     & 1.677900E+03,3.974500E+03,1.142900E-05,3.421600E-05,1.269000E-04,&
     & 6.393100E-04,3.193500E-03,1.015200E-02,3.133900E-02,1.113100E-01,&
     & 8.430300E-01,4.181400E+00,8.278700E+00,1.832500E+01,5.252000E+01,&
     & 2.584400E+02,1.118700E+03,2.649700E+03,1.054900E-05,3.083500E-05,&
     & 1.031200E-04,4.442400E-04,1.870300E-03,5.577200E-03,1.684200E-02,&
     & 5.930300E-02,4.476200E-01,2.230600E+00,4.440100E+00,9.888100E+00,&
     & 2.788100E+01,1.313900E+02,5.593200E+02,1.324800E+03,6.426300E-06,&
     & 1.825500E-05,3.555600E-05,6.589000E-05,1.222200E-04,2.442700E-04,&
     & 6.057100E-04,2.056800E-03,1.192200E-02,4.740900E-02,9.547800E-02,&
     & 1.987600E-01,4.206700E-01,1.464400E+00,1.941200E+01,1.219900E+02,&
     & 5.540800E-06,2.618200E-05,1.515700E-04,1.128200E-03,7.221900E-03,&
     & 2.504200E-02,7.802700E-02,2.825600E-01,2.118700E+00,1.057600E+01,&
     & 2.112900E+01,4.589900E+01,1.333900E+02,6.687700E+02,2.896400E+03,&
     & 6.904600E+03,1.412400E-05,4.807900E-05,2.099300E-04,1.209600E-03,&
     & 6.278500E-03,2.015700E-02,6.173200E-02,2.226000E-01,1.662500E+00,&
     & 8.191500E+00,1.615700E+01,3.480000E+01,1.001000E+02,5.015800E+02,&
     & 2.172300E+03,5.178100E+03,1.527200E-05,5.026700E-05,1.970800E-04,&
     & 9.910500E-04,4.615000E-03,1.417300E-02,4.285300E-02,1.539200E-01,&
     & 1.150800E+00,5.718200E+00,1.121100E+01,2.394400E+01,6.815900E+01,&
     & 3.344200E+02,1.448200E+03,3.430500E+03,1.408000E-05,4.449800E-05,&
     & 1.555000E-04,6.694100E-04,2.659400E-03,7.757100E-03,2.296800E-02,&
     & 8.196100E-02,6.107800E-01,3.050400E+00,5.997000E+00,1.289000E+01,&
     & 3.627200E+01,1.700600E+02,7.241000E+02,1.726100E+03,8.012800E-06,&
     & 2.304200E-05,4.370800E-05,8.087600E-05,1.556400E-04,3.097900E-04,&
     & 7.618000E-04,2.634900E-03,1.509000E-02,5.851200E-02,1.193000E-01,&
     & 2.329800E-01,5.299400E-01,1.974300E+00,2.619900E+01,1.596700E+02/
      data   absb(:,361:380) /                                          &
     & 7.223500E-06,4.035000E-05,2.531300E-04,1.814700E-03,1.038400E-02,&
     & 3.420800E-02,1.042100E-01,3.825100E-01,2.828500E+00,1.401400E+01,&
     & 2.779800E+01,5.873700E+01,1.684100E+02,8.391200E+02,3.636300E+03,&
     & 8.680900E+03,1.912800E-05,7.154000E-05,3.277900E-04,1.855600E-03,&
     & 8.891200E-03,2.747500E-02,8.231400E-02,3.011200E-01,2.217400E+00,&
     & 1.083700E+01,2.124800E+01,4.450600E+01,1.264000E+02,6.293500E+02,&
     & 2.727200E+03,6.510500E+03,2.073400E-05,7.335900E-05,2.994300E-04,&
     & 1.488900E-03,6.466400E-03,1.928400E-02,5.710900E-02,2.080500E-01,&
     & 1.534400E+00,7.562900E+00,1.471400E+01,3.059600E+01,8.608700E+01,&
     & 4.196400E+02,1.818100E+03,4.340300E+03,1.890200E-05,6.353800E-05,&
     & 2.297400E-04,9.771400E-04,3.677800E-03,1.052700E-02,3.057900E-02,&
     & 1.106800E-01,8.139000E-01,4.031500E+00,7.858800E+00,1.644500E+01,&
     & 4.588600E+01,2.134300E+02,9.091200E+02,2.170000E+03,9.787400E-06,&
     & 2.835900E-05,5.244900E-05,9.634400E-05,1.936100E-04,3.867100E-04,&
     & 9.457300E-04,3.277200E-03,1.873300E-02,7.395500E-02,1.414700E-01,&
     & 2.819100E-01,6.214400E-01,2.642300E+00,3.416400E+01,2.031700E+02,&
     & 9.804400E-06,6.222700E-05,4.070700E-04,2.794000E-03,1.440100E-02,&
     & 4.583700E-02,1.365100E-01,5.056200E-01,3.694600E+00,1.811300E+01,&
     & 3.543700E+01,7.377000E+01,2.079600E+02,1.025500E+03,4.448700E+03,&
     & 1.051400E+04,2.602200E-05,1.050000E-04,4.985000E-04,2.751600E-03,&
     & 1.218300E-02,3.671700E-02,1.076900E-01,3.978500E-01,2.893800E+00,&
     & 1.397300E+01,2.708400E+01,5.585800E+01,1.561000E+02,7.690700E+02,&
     & 3.336500E+03,7.933700E+03,2.810200E-05,1.055000E-04,4.426700E-04,&
     & 2.162700E-03,8.798400E-03,2.572900E-02,7.464500E-02,2.746400E-01,&
     & 2.002600E+00,9.739000E+00,1.874000E+01,3.836900E+01,1.062900E+02,&
     & 5.128400E+02,2.224400E+03,5.289300E+03,2.532100E-05,8.923100E-05,&
     & 3.310700E-04,1.381100E-03,4.956600E-03,1.400500E-02,3.991500E-02,&
     & 1.459800E-01,1.061100E+00,5.184700E+00,1.002400E+01,2.060100E+01,&
     & 5.670200E+01,2.609100E+02,1.112200E+03,2.644800E+03,1.164200E-05,&
     & 3.380400E-05,6.315300E-05,1.154600E-04,2.344500E-04,4.739900E-04,&
     & 1.142500E-03,4.007700E-03,2.296400E-02,9.079400E-02,1.696600E-01,&
     & 3.248100E-01,7.296300E-01,3.593900E+00,4.300300E+01,2.520200E+02,&
     & 1.353100E-05,9.412900E-05,6.280400E-04,4.120600E-03,1.940000E-02,&
     & 6.028400E-02,1.759100E-01,6.544500E-01,4.729700E+00,2.286200E+01,&
     & 4.419600E+01,9.110700E+01,2.515900E+02,1.227300E+03,5.319300E+03,&
     & 1.254800E+04,3.505800E-05,1.511400E-04,7.343400E-04,3.934000E-03,&
     & 1.624300E-02,4.820500E-02,1.386200E-01,5.144100E-01,3.702600E+00,&
     & 1.759300E+01,3.377800E+01,6.894000E+01,1.888800E+02,9.204800E+02,&
     & 3.989400E+03,9.411500E+03,3.776200E-05,1.490300E-04,6.374800E-04,&
     & 3.036300E-03,1.167000E-02,3.372200E-02,9.601800E-02,3.549700E-01,&
     & 2.563900E+00,1.224600E+01,2.335000E+01,4.729600E+01,1.286500E+02,&
     & 6.137800E+02,2.659600E+03,6.274600E+03,3.358000E-05,1.228500E-04,&
     & 4.647000E-04,1.895600E-03,6.531600E-03,1.827500E-02,5.132500E-02,&
     & 1.885100E-01,1.358500E+00,6.522800E+00,1.249400E+01,2.535600E+01,&
     & 6.869100E+01,3.122600E+02,1.329800E+03,3.137300E+03,1.371200E-05,&
     & 4.008200E-05,7.441000E-05,1.379100E-04,2.786900E-04,5.665700E-04,&
     & 1.360800E-03,4.805500E-03,2.779900E-02,1.087100E-01,2.014200E-01,&
     & 3.817100E-01,8.656300E-01,4.826500E+00,5.270100E+01,3.056800E+02,&
     & 3.826700E-06,1.557000E-05,8.107100E-05,6.196300E-04,4.390700E-03,&
     & 1.600900E-02,5.083200E-02,1.862800E-01,1.455700E+00,7.206300E+00,&
     & 1.468300E+01,3.281800E+01,9.525600E+01,5.147100E+02,2.511600E+03,&
     & 6.204000E+03,9.260500E-06,2.872900E-05,1.189300E-04,6.961700E-04,&
     & 3.880000E-03,1.291200E-02,4.033500E-02,1.469900E-01,1.145000E+00,&
     & 5.619600E+00,1.129200E+01,2.494300E+01,7.161900E+01,3.860400E+02,&
     & 1.883700E+03,4.652900E+03,9.975300E-06,3.039100E-05,1.144100E-04,&
     & 5.820500E-04,2.878500E-03,9.095000E-03,2.806200E-02,1.017100E-01,&
     & 7.912400E-01,3.920300E+00,7.871800E+00,1.728000E+01,4.893600E+01,&
     & 2.576100E+02,1.255800E+03,3.102000E+03,9.208700E-06,2.733100E-05,&
     & 9.267000E-05,4.023900E-04,1.679300E-03,4.990700E-03,1.508000E-02,&
     & 5.423500E-02,4.192200E-01,2.088200E+00,4.210600E+00,9.322600E+00,&
     & 2.627700E+01,1.316100E+02,6.278400E+02,1.551100E+03,5.491000E-06,&
     & 1.492800E-05,2.904800E-05,5.384200E-05,1.035200E-04,2.074900E-04,&
     & 5.095900E-04,1.779900E-03,1.067100E-02,4.312900E-02,8.735600E-02,&
     & 1.781700E-01,4.067600E-01,1.497500E+00,2.087600E+01,1.374900E+02/
      data   absb(:,381:400) /                                          &
     & 4.781300E-06,2.345400E-05,1.381800E-04,1.035400E-03,6.518000E-03,&
     & 2.234400E-02,6.949100E-02,2.574900E-01,1.980700E+00,9.781700E+00,&
     & 1.988600E+01,4.318400E+01,1.233700E+02,6.639000E+02,3.218900E+03,&
     & 7.979900E+03,1.236100E-05,4.286800E-05,1.893700E-04,1.101300E-03,&
     & 5.650000E-03,1.799300E-02,5.497300E-02,2.032200E-01,1.557200E+00,&
     & 7.608500E+00,1.528100E+01,3.281100E+01,9.272600E+01,4.979300E+02,&
     & 2.414200E+03,5.985400E+03,1.338100E-05,4.464700E-05,1.773000E-04,&
     & 8.981500E-04,4.143100E-03,1.264600E-02,3.818700E-02,1.405300E-01,&
     & 1.076200E+00,5.308400E+00,1.063800E+01,2.266800E+01,6.344300E+01,&
     & 3.322700E+02,1.609600E+03,3.990100E+03,1.230100E-05,3.941600E-05,&
     & 1.393200E-04,6.029800E-04,2.378100E-03,6.927300E-03,2.046600E-02,&
     & 7.488100E-02,5.702400E-01,2.819600E+00,5.686100E+00,1.220800E+01,&
     & 3.407200E+01,1.698400E+02,8.047600E+02,1.995200E+03,6.780900E-06,&
     & 1.868500E-05,3.546700E-05,6.602200E-05,1.309000E-04,2.619600E-04,&
     & 6.448800E-04,2.251500E-03,1.358500E-02,5.481200E-02,1.071400E-01,&
     & 2.185700E-01,4.997800E-01,1.975500E+00,2.794900E+01,1.786900E+02,&
     & 6.305200E-06,3.621800E-05,2.292500E-04,1.651600E-03,9.299500E-03,&
     & 3.051600E-02,9.268400E-02,3.472800E-01,2.635300E+00,1.290400E+01,&
     & 2.597300E+01,5.561600E+01,1.558300E+02,8.309900E+02,4.008500E+03,&
     & 9.915700E+03,1.678400E-05,6.362700E-05,2.944900E-04,1.679700E-03,&
     & 7.942800E-03,2.452100E-02,7.323000E-02,2.738000E-01,2.069400E+00,&
     & 1.002900E+01,1.993700E+01,4.223500E+01,1.171200E+02,6.232800E+02,&
     & 3.006000E+03,7.438500E+03,1.818400E-05,6.499500E-05,2.676200E-04,&
     & 1.341200E-03,5.764100E-03,1.721600E-02,5.082300E-02,1.892000E-01,&
     & 1.429700E+00,7.002500E+00,1.387100E+01,2.910500E+01,8.017400E+01,&
     & 4.159000E+02,2.004200E+03,4.957800E+03,1.652000E-05,5.610600E-05,&
     & 2.048400E-04,8.750700E-04,3.268400E-03,9.389700E-03,2.721600E-02,&
     & 1.007500E-01,7.565200E-01,3.723600E+00,7.421000E+00,1.565600E+01,&
     & 4.304600E+01,2.126600E+02,1.002100E+03,2.479300E+03,8.187200E-06,&
     & 2.277000E-05,4.299400E-05,8.012300E-05,1.616300E-04,3.259400E-04,&
     & 7.960600E-04,2.786300E-03,1.701200E-02,6.839500E-02,1.306100E-01,&
     & 2.576200E-01,5.721800E-01,2.659200E+00,3.615600E+01,2.257300E+02,&
     & 8.609200E-06,5.568600E-05,3.654400E-04,2.519700E-03,1.280600E-02,&
     & 4.085600E-02,1.215500E-01,4.575500E-01,3.426800E+00,1.669600E+01,&
     & 3.303200E+01,7.025900E+01,1.922300E+02,1.015900E+03,4.866000E+03,&
     & 1.196100E+04,2.280000E-05,9.311300E-05,4.442700E-04,2.470900E-03,&
     & 1.081600E-02,3.275500E-02,9.588600E-02,3.604400E-01,2.690000E+00,&
     & 1.293500E+01,2.534500E+01,5.331900E+01,1.444700E+02,7.619700E+02,&
     & 3.649500E+03,8.970600E+03,2.460300E-05,9.310000E-05,3.935600E-04,&
     & 1.933800E-03,7.799200E-03,2.295800E-02,6.645500E-02,2.489400E-01,&
     & 1.860000E+00,9.013500E+00,1.763000E+01,3.665900E+01,9.892600E+01,&
     & 5.084200E+02,2.432900E+03,5.979900E+03,2.207800E-05,7.849700E-05,&
     & 2.933800E-04,1.227400E-03,4.386300E-03,1.247500E-02,3.554800E-02,&
     & 1.324300E-01,9.835700E-01,4.794300E+00,9.439900E+00,1.969300E+01,&
     & 5.316400E+01,2.599400E+02,1.216500E+03,2.990000E+03,9.654100E-06,&
     & 2.736300E-05,5.133500E-05,9.707400E-05,1.942200E-04,3.974800E-04,&
     & 9.567800E-04,3.390300E-03,2.100500E-02,8.271600E-02,1.574400E-01,&
     & 3.037100E-01,6.968300E-01,3.485400E+00,4.544800E+01,2.780600E+02,&
     & 1.189100E-05,8.368600E-05,5.587300E-04,3.674400E-03,1.715500E-02,&
     & 5.362700E-02,1.568800E-01,5.904500E-01,4.375400E+00,2.109600E+01,&
     & 4.121000E+01,8.712300E+01,2.331500E+02,1.216800E+03,5.776400E+03,&
     & 1.406000E+04,3.061300E-05,1.333900E-04,6.511300E-04,3.495800E-03,&
     & 1.436100E-02,4.290000E-02,1.236300E-01,4.649400E-01,3.433700E+00,&
     & 1.630900E+01,3.158200E+01,6.607900E+01,1.752100E+02,9.126200E+02,&
     & 4.332200E+03,1.054500E+04,3.296400E-05,1.310400E-04,5.634600E-04,&
     & 2.690000E-03,1.030500E-02,3.001400E-02,8.558300E-02,3.210100E-01,&
     & 2.374500E+00,1.136800E+01,2.193300E+01,4.539600E+01,1.199200E+02,&
     & 6.089800E+02,2.888300E+03,7.030000E+03,2.919900E-05,1.075500E-04,&
     & 4.093300E-04,1.673100E-03,5.759900E-03,1.624700E-02,4.573200E-02,&
     & 1.705200E-01,1.255000E+00,6.050600E+00,1.175900E+01,2.437900E+01,&
     & 6.441800E+01,3.113800E+02,1.444200E+03,3.515100E+03,1.137100E-05,&
     & 3.254100E-05,6.014400E-05,1.160300E-04,2.302000E-04,4.738700E-04,&
     & 1.141500E-03,4.040400E-03,2.555600E-02,9.993500E-02,1.845600E-01,&
     & 3.547800E-01,8.187800E-01,4.683700E+00,5.559100E+01,3.349900E+02/
      data   absb(:,401:420) /                                          &
     & 3.255400E-06,1.384300E-05,7.420300E-05,5.725500E-04,3.973000E-03,&
     & 1.426200E-02,4.529600E-02,1.689700E-01,1.357500E+00,6.727800E+00,&
     & 1.379000E+01,3.085900E+01,8.853200E+01,5.081700E+02,2.778800E+03,&
     & 7.134100E+03,8.064600E-06,2.562300E-05,1.078100E-04,6.371900E-04,&
     & 3.503300E-03,1.152200E-02,3.592200E-02,1.335800E-01,1.070700E+00,&
     & 5.263600E+00,1.066200E+01,2.351100E+01,6.669500E+01,3.811300E+02,&
     & 2.084200E+03,5.350600E+03,8.711500E-06,2.706500E-05,1.034100E-04,&
     & 5.300100E-04,2.590300E-03,8.111500E-03,2.499200E-02,9.250100E-02,&
     & 7.389900E-01,3.671700E+00,7.445100E+00,1.636000E+01,4.575700E+01,&
     & 2.547400E+02,1.389500E+03,3.567100E+03,8.044300E-06,2.429500E-05,&
     & 8.345800E-05,3.641500E-04,1.504300E-03,4.453000E-03,1.342300E-02,&
     & 4.942200E-02,3.916300E-01,1.943700E+00,3.976600E+00,8.828000E+00,&
     & 2.481000E+01,1.309200E+02,6.947700E+02,1.783500E+03,4.659700E-06,&
     & 1.213400E-05,2.367100E-05,4.378300E-05,8.613800E-05,1.740700E-04,&
     & 4.274300E-04,1.507000E-03,9.518700E-03,3.926600E-02,7.802100E-02,&
     & 1.667900E-01,3.849200E-01,1.486100E+00,2.256100E+01,1.539800E+02,&
     & 4.126700E-06,2.100900E-05,1.260500E-04,9.489900E-04,5.850100E-03,&
     & 1.988700E-02,6.169400E-02,2.329400E-01,1.844300E+00,9.051500E+00,&
     & 1.850700E+01,4.086700E+01,1.146300E+02,6.538500E+02,3.529800E+03,&
     & 9.057700E+03,1.082600E-05,3.824800E-05,1.711300E-04,1.000600E-03,&
     & 5.058900E-03,1.602700E-02,4.883300E-02,1.840600E-01,1.453400E+00,&
     & 7.071000E+00,1.428800E+01,3.112800E+01,8.632500E+01,4.903800E+02,&
     & 2.647200E+03,6.793500E+03,1.173700E-05,3.973200E-05,1.593600E-04,&
     & 8.134100E-04,3.698100E-03,1.127600E-02,3.392200E-02,1.273300E-01,&
     & 1.002900E+00,4.935500E+00,9.975800E+00,2.158400E+01,5.930000E+01,&
     & 3.276800E+02,1.764800E+03,4.529000E+03,1.075400E-05,3.497700E-05,&
     & 1.248700E-04,5.424300E-04,2.116500E-03,6.168700E-03,1.819100E-02,&
     & 6.794200E-02,5.308900E-01,2.613000E+00,5.336300E+00,1.163100E+01,&
     & 3.208700E+01,1.685100E+02,8.824600E+02,2.264300E+03,5.716900E-06,&
     & 1.504400E-05,2.912100E-05,5.393000E-05,1.086600E-04,2.185400E-04,&
     & 5.390700E-04,1.897500E-03,1.220700E-02,4.983400E-02,9.582000E-02,&
     & 2.045100E-01,4.464600E-01,1.980700E+00,2.993600E+01,1.986300E+02,&
     & 5.499800E-06,3.248300E-05,2.070300E-04,1.497300E-03,8.275200E-03,&
     & 2.714100E-02,8.227600E-02,3.130700E-01,2.444300E+00,1.191900E+01,&
     & 2.409100E+01,5.291500E+01,1.443800E+02,8.186200E+02,4.359700E+03,&
     & 1.112200E+04,1.472200E-05,5.667600E-05,2.639500E-04,1.514300E-03,&
     & 7.054000E-03,2.182700E-02,6.505300E-02,2.470400E-01,1.924500E+00,&
     & 9.297800E+00,1.857500E+01,4.029400E+01,1.086900E+02,6.139700E+02,&
     & 3.269600E+03,8.342600E+03,1.594400E-05,5.756900E-05,2.391900E-04,&
     & 1.204800E-03,5.112200E-03,1.532300E-02,4.514800E-02,1.708100E-01,&
     & 1.329300E+00,6.477000E+00,1.297700E+01,2.784500E+01,7.477200E+01,&
     & 4.101300E+02,2.179800E+03,5.561500E+03,1.444100E-05,4.959200E-05,&
     & 1.824800E-04,7.808300E-04,2.893800E-03,8.351800E-03,2.417100E-02,&
     & 9.104300E-02,7.024900E-01,3.441200E+00,6.939800E+00,1.498700E+01,&
     & 4.046800E+01,2.109000E+02,1.089900E+03,2.780600E+03,6.832600E-06,&
     & 1.840800E-05,3.505700E-05,6.680300E-05,1.320600E-04,2.711600E-04,&
     & 6.593500E-04,2.337500E-03,1.529200E-02,6.207700E-02,1.189800E-01,&
     & 2.367000E-01,5.395300E-01,2.608300E+00,3.846400E+01,2.490300E+02,&
     & 7.545400E-06,4.971200E-05,3.274100E-04,2.257200E-03,1.132300E-02,&
     & 3.624600E-02,1.079100E-01,4.112600E-01,3.171500E+00,1.538000E+01,&
     & 3.065200E+01,6.702800E+01,1.785100E+02,1.001500E+03,5.252600E+03,&
     & 1.328000E+04,1.995700E-05,8.257400E-05,3.959800E-04,2.204400E-03,&
     & 9.554800E-03,2.909200E-02,8.519700E-02,3.243200E-01,2.495800E+00,&
     & 1.197800E+01,2.359300E+01,5.103000E+01,1.343400E+02,7.511500E+02,&
     & 3.939500E+03,9.960900E+03,2.153300E-05,8.223400E-05,3.495200E-04,&
     & 1.719900E-03,6.880900E-03,2.038600E-02,5.906600E-02,2.241700E-01,&
     & 1.723700E+00,8.349900E+00,1.647400E+01,3.519000E+01,9.241200E+01,&
     & 5.016900E+02,2.626300E+03,6.640000E+03,1.925600E-05,6.902500E-05,&
     & 2.596100E-04,1.086100E-03,3.863900E-03,1.106400E-02,3.159800E-02,&
     & 1.193100E-01,9.103600E-01,4.436200E+00,8.825100E+00,1.894400E+01,&
     & 4.995400E+01,2.579900E+02,1.313100E+03,3.319900E+03,8.067400E-06,&
     & 2.225900E-05,4.144400E-05,8.098500E-05,1.577000E-04,3.287400E-04,&
     & 7.935800E-04,2.819900E-03,1.885100E-02,7.679800E-02,1.437300E-01,&
     & 2.799900E-01,6.410700E-01,3.436600E+00,4.812500E+01,3.045000E+02/
      data   absb(:,421:440) /                                          &
     & 1.042100E-05,7.430300E-05,4.962400E-04,3.252700E-03,1.508700E-02,&
     & 4.742700E-02,1.396400E-01,5.299200E-01,4.041000E+00,1.942000E+01,&
     & 3.826800E+01,8.316900E+01,2.175200E+02,1.200400E+03,6.195600E+03,&
     & 1.547800E+04,2.669200E-05,1.175300E-04,5.766100E-04,3.084900E-03,&
     & 1.262400E-02,3.801900E-02,1.100500E-01,4.177000E-01,3.179000E+00,&
     & 1.509700E+01,2.941900E+01,6.327300E+01,1.636500E+02,9.002300E+02,&
     & 4.646700E+03,1.160900E+04,2.875200E-05,1.152600E-04,4.972400E-04,&
     & 2.368500E-03,9.049800E-03,2.658500E-02,7.623500E-02,2.886000E-01,&
     & 2.196400E+00,1.053600E+01,2.053400E+01,4.357100E+01,1.124600E+02,&
     & 6.013000E+02,3.097900E+03,7.739400E+03,2.537800E-05,9.415900E-05,&
     & 3.600600E-04,1.468600E-03,5.049100E-03,1.438500E-02,4.071300E-02,&
     & 1.533700E-01,1.159000E+00,5.604500E+00,1.102600E+01,2.347400E+01,&
     & 6.072400E+01,3.091100E+02,1.548900E+03,3.869700E+03,9.463500E-06,&
     & 2.634300E-05,4.875100E-05,9.620100E-05,1.880500E-04,3.897200E-04,&
     & 9.451900E-04,3.353500E-03,2.312100E-02,9.166900E-02,1.683700E-01,&
     & 3.296300E-01,7.636500E-01,4.630900E+00,5.861500E+01,3.643100E+02,&
     & 2.772200E-06,1.228300E-05,6.767700E-05,5.263700E-04,3.571900E-03,&
     & 1.267600E-02,4.018500E-02,1.524200E-01,1.261500E+00,6.288200E+00,&
     & 1.283500E+01,2.918100E+01,8.271000E+01,4.989000E+02,3.036900E+03,&
     & 8.056600E+03,7.025700E-06,2.282600E-05,9.746800E-05,5.808100E-04,&
     & 3.139900E-03,1.024600E-02,3.188600E-02,1.207100E-01,9.970500E-01,&
     & 4.935500E+00,9.984200E+00,2.230800E+01,6.247600E+01,3.741600E+02,&
     & 2.277700E+03,6.042300E+03,7.607000E-06,2.407700E-05,9.313800E-05,&
     & 4.801000E-04,2.316200E-03,7.217300E-03,2.219500E-02,8.366400E-02,&
     & 6.881000E-01,3.432300E+00,6.989300E+00,1.557000E+01,4.304500E+01,&
     & 2.505100E+02,1.518500E+03,4.028400E+03,7.020900E-06,2.158600E-05,&
     & 7.492300E-05,3.281600E-04,1.339200E-03,3.963700E-03,1.191900E-02,&
     & 4.477800E-02,3.645100E-01,1.811500E+00,3.728600E+00,8.404600E+00,&
     & 2.351100E+01,1.296700E+02,7.592600E+02,2.014200E+03,3.914800E-06,&
     & 9.701700E-06,1.928700E-05,3.553600E-05,7.137300E-05,1.441600E-04,&
     & 3.548500E-04,1.266900E-03,8.424100E-03,3.571300E-02,6.976500E-02,&
     & 1.521700E-01,3.418900E-01,1.479200E+00,2.441300E+01,1.711500E+02,&
     & 3.562900E-06,1.879600E-05,1.143100E-04,8.628900E-04,5.210700E-03,&
     & 1.765300E-02,5.462600E-02,2.092700E-01,1.710200E+00,8.416900E+00,&
     & 1.712600E+01,3.881000E+01,1.067500E+02,6.418300E+02,3.824400E+03,&
     & 1.010100E+04,9.475300E-06,3.407000E-05,1.537400E-04,9.035700E-04,&
     & 4.498600E-03,1.424400E-02,4.327800E-02,1.655900E-01,1.351000E+00,&
     & 6.590600E+00,1.330500E+01,2.966400E+01,8.058600E+01,4.813700E+02,&
     & 2.868400E+03,7.575900E+03,1.028700E-05,3.521600E-05,1.428400E-04,&
     & 7.321500E-04,3.281600E-03,1.001700E-02,3.008400E-02,1.146500E-01,&
     & 9.320300E-01,4.584100E+00,9.323800E+00,2.063400E+01,5.562000E+01,&
     & 3.221300E+02,1.912200E+03,5.050500E+03,9.395100E-06,3.099000E-05,&
     & 1.115300E-04,4.852100E-04,1.873000E-03,5.477000E-03,1.613500E-02,&
     & 6.129000E-02,4.926200E-01,2.426200E+00,4.978500E+00,1.113100E+01,&
     & 3.034500E+01,1.667100E+02,9.560900E+02,2.525200E+03,4.764100E-06,&
     & 1.206000E-05,2.359100E-05,4.482400E-05,8.811900E-05,1.811300E-04,&
     & 4.430300E-04,1.582400E-03,1.076900E-02,4.575200E-02,8.799000E-02,&
     & 1.825500E-01,4.057800E-01,1.963900E+00,3.206100E+01,2.190100E+02,&
     & 4.793200E-06,2.905200E-05,1.862300E-04,1.345600E-03,7.316500E-03,&
     & 2.402200E-02,7.295300E-02,2.803600E-01,2.260200E+00,1.102400E+01,&
     & 2.231900E+01,5.031600E+01,1.348200E+02,8.045700E+02,4.685900E+03,&
     & 1.226700E+04,1.289300E-05,5.036100E-05,2.358300E-04,1.355300E-03,&
     & 6.231500E-03,1.934100E-02,5.770100E-02,2.216700E-01,1.784500E+00,&
     & 8.636300E+00,1.727800E+01,3.845600E+01,1.016900E+02,6.034200E+02,&
     & 3.514100E+03,9.199500E+03,1.395900E-05,5.095000E-05,2.129100E-04,&
     & 1.074700E-03,4.507800E-03,1.358300E-02,4.004800E-02,1.534000E-01,&
     & 1.231500E+00,6.014500E+00,1.210000E+01,2.668600E+01,7.022600E+01,&
     & 4.036900E+02,2.343000E+03,6.133400E+03,1.260000E-05,4.371600E-05,&
     & 1.619300E-04,6.922300E-04,2.546900E-03,7.399800E-03,2.144200E-02,&
     & 8.186500E-02,6.502400E-01,3.186400E+00,6.472800E+00,1.439300E+01,&
     & 3.822400E+01,2.088900E+02,1.171500E+03,3.066800E+03,5.670800E-06,&
     & 1.484700E-05,2.815800E-05,5.531900E-05,1.066200E-04,2.228200E-04,&
     & 5.416900E-04,1.934200E-03,1.356900E-02,5.747300E-02,1.083000E-01,&
     & 2.148900E-01,5.041800E-01,2.556400E+00,4.093300E+01,2.724300E+02/
      data   absb(:,441:460) /                                          &
     & 6.598200E-06,4.424500E-05,2.918000E-04,2.006500E-03,9.952000E-03,&
     & 3.199600E-02,9.581200E-02,3.679600E-01,2.927500E+00,1.419200E+01,&
     & 2.841200E+01,6.365200E+01,1.675200E+02,9.852100E+02,5.606500E+03,&
     & 1.451100E+04,1.743100E-05,7.292900E-05,3.516300E-04,1.950700E-03,&
     & 8.389200E-03,2.572100E-02,7.570100E-02,2.906500E-01,2.310300E+00,&
     & 1.110300E+01,2.195600E+01,4.862500E+01,1.262800E+02,7.389000E+02,&
     & 4.205000E+03,1.088300E+04,1.881000E-05,7.248700E-05,3.092100E-04,&
     & 1.517200E-03,6.032700E-03,1.802700E-02,5.249700E-02,2.010000E-01,&
     & 1.594700E+00,7.743900E+00,1.538300E+01,3.367500E+01,8.717900E+01,&
     & 4.941500E+02,2.803200E+03,7.255600E+03,1.675900E-05,6.057100E-05,&
     & 2.289200E-04,9.551800E-04,3.384700E-03,9.778500E-03,2.807500E-02,&
     & 1.070700E-01,8.408500E-01,4.112000E+00,8.249300E+00,1.818800E+01,&
     & 4.733400E+01,2.556400E+02,1.401600E+03,3.627900E+03,6.690200E-06,&
     & 1.786800E-05,3.332800E-05,6.682800E-05,1.280300E-04,2.678400E-04,&
     & 6.550900E-04,2.314300E-03,1.686800E-02,7.072900E-02,1.285400E-01,&
     & 2.525800E-01,5.978900E-01,3.416200E+00,5.089700E+01,3.308200E+02,&
     & 9.106600E-06,6.568600E-05,4.391800E-04,2.857300E-03,1.316600E-02,&
     & 4.177300E-02,1.240200E-01,4.740700E-01,3.727200E+00,1.789000E+01,&
     & 3.554000E+01,7.895600E+01,2.054800E+02,1.182000E+03,6.571700E+03,&
     & 1.677200E+04,2.323100E-05,1.033600E-04,5.085400E-04,2.700800E-03,&
     & 1.102900E-02,3.351200E-02,9.786200E-02,3.743100E-01,2.940100E+00,&
     & 1.397800E+01,2.742200E+01,6.028200E+01,1.547700E+02,8.865100E+02,&
     & 4.928700E+03,1.257900E+04,2.504100E-05,1.010800E-04,4.375100E-04,&
     & 2.071200E-03,7.900300E-03,2.345000E-02,6.780600E-02,2.584900E-01,&
     & 2.030100E+00,9.765100E+00,1.922100E+01,4.167100E+01,1.067800E+02,&
     & 5.927400E+02,3.285800E+03,8.385800E+03,2.203100E-05,8.223500E-05,&
     & 3.156900E-04,1.280200E-03,4.403000E-03,1.268800E-02,3.623500E-02,&
     & 1.374500E-01,1.070100E+00,5.186000E+00,1.033200E+01,2.256900E+01,&
     & 5.781100E+01,3.064600E+02,1.642900E+03,4.193100E+03,7.839400E-06,&
     & 2.087700E-05,3.950100E-05,7.931300E-05,1.512100E-04,3.173700E-04,&
     & 7.785000E-04,2.761200E-03,2.072000E-02,8.553400E-02,1.504100E-01,&
     & 2.964200E-01,7.230400E-01,4.634500E+00,6.172100E+01,3.931700E+02,&
     & 2.350600E-06,1.086400E-05,6.139300E-05,4.794500E-04,3.178800E-03,&
     & 1.117800E-02,3.534800E-02,1.361100E-01,1.162800E+00,5.843900E+00,&
     & 1.186600E+01,2.753800E+01,7.698900E+01,4.868200E+02,3.264800E+03,&
     & 8.898200E+03,6.105200E-06,2.030300E-05,8.769400E-05,5.244700E-04,&
     & 2.786400E-03,9.051400E-03,2.809000E-02,1.079600E-01,9.213000E-01,&
     & 4.605100E+00,9.284000E+00,2.115900E+01,5.832200E+01,3.651300E+02,&
     & 2.448600E+03,6.673900E+03,6.630500E-06,2.134100E-05,8.363000E-05,&
     & 4.324900E-04,2.050700E-03,6.380100E-03,1.955900E-02,7.486500E-02,&
     & 6.354800E-01,3.195700E+00,6.515300E+00,1.481500E+01,4.041400E+01,&
     & 2.449400E+02,1.632400E+03,4.449300E+03,6.119600E-06,1.913800E-05,&
     & 6.704800E-05,2.938300E-04,1.182500E-03,3.504800E-03,1.051300E-02,&
     & 4.012200E-02,3.362900E-01,1.686300E+00,3.469300E+00,8.000200E+00,&
     & 2.225200E+01,1.277500E+02,8.161800E+02,2.224500E+03,3.286100E-06,&
     & 7.831200E-06,1.538200E-05,2.939000E-05,5.720000E-05,1.177000E-04,&
     & 2.903900E-04,1.047900E-03,7.321200E-03,3.265400E-02,6.288000E-02,&
     & 1.352300E-01,3.059200E-01,1.454900E+00,2.642600E+01,1.890100E+02,&
     & 3.061600E-06,1.671800E-05,1.029000E-04,7.758700E-04,4.596400E-03,&
     & 1.552300E-02,4.805300E-02,1.861100E-01,1.571000E+00,7.803300E+00,&
     & 1.580800E+01,3.662100E+01,9.959600E+01,6.268600E+02,4.075600E+03,&
     & 1.102500E+04,8.267000E-06,3.026300E-05,1.374300E-04,8.097200E-04,&
     & 3.961700E-03,1.254700E-02,3.811800E-02,1.475100E-01,1.244200E+00,&
     & 6.137800E+00,1.234200E+01,2.812300E+01,7.538000E+01,4.701400E+02,&
     & 3.056600E+03,8.268100E+03,8.987400E-06,3.118000E-05,1.273100E-04,&
     & 6.532800E-04,2.884900E-03,8.830300E-03,2.649600E-02,1.022400E-01,&
     & 8.584000E-01,4.262200E+00,8.659600E+00,1.964600E+01,5.227400E+01,&
     & 3.152000E+02,2.037800E+03,5.512200E+03,8.193300E-06,2.736300E-05,&
     & 9.924100E-05,4.306500E-04,1.642900E-03,4.827600E-03,1.422100E-02,&
     & 5.473400E-02,4.534100E-01,2.251500E+00,4.619300E+00,1.061700E+01,&
     & 2.870700E+01,1.643200E+02,1.019000E+03,2.756000E+03,3.969000E-06,&
     & 9.690900E-06,1.865100E-05,3.690600E-05,7.040100E-05,1.472400E-04,&
     & 3.596400E-04,1.299700E-03,9.408900E-03,4.218300E-02,7.861600E-02,&
     & 1.607200E-01,3.767700E-01,1.897300E+00,3.447100E+01,2.398400E+02/
      data   absb(:,461:480) /                                          &
     & 4.151800E-06,2.578400E-05,1.662600E-04,1.197400E-03,6.401400E-03,&
     & 2.106000E-02,6.421200E-02,2.488200E-01,2.074100E+00,1.019600E+01,&
     & 2.058700E+01,4.734700E+01,1.265300E+02,7.864000E+02,4.956300E+03,&
     & 1.325000E+04,1.124500E-05,4.448500E-05,2.095600E-04,1.200400E-03,&
     & 5.449500E-03,1.699200E-02,5.084500E-02,1.970600E-01,1.641800E+00,&
     & 8.023500E+00,1.602200E+01,3.634100E+01,9.565600E+01,5.898100E+02,&
     & 3.717300E+03,9.938700E+03,1.218000E-05,4.495900E-05,1.885100E-04,&
     & 9.486800E-04,3.935000E-03,1.194300E-02,3.530900E-02,1.365000E-01,&
     & 1.132600E+00,5.583600E+00,1.125000E+01,2.534100E+01,6.631300E+01,&
     & 3.952400E+02,2.478200E+03,6.625800E+03,1.097300E-05,3.843600E-05,&
     & 1.430100E-04,6.082700E-04,2.220800E-03,6.502500E-03,1.891900E-02,&
     & 7.295400E-02,5.974300E-01,2.953300E+00,6.017100E+00,1.371800E+01,&
     & 3.629300E+01,2.059100E+02,1.239200E+03,3.312700E+03,4.707700E-06,&
     & 1.170300E-05,2.274800E-05,4.501600E-05,8.524700E-05,1.787500E-04,&
     & 4.411700E-04,1.578900E-03,1.190800E-02,5.301100E-02,9.490800E-02,&
     & 1.920400E-01,4.586400E-01,2.520300E+00,4.366600E+01,2.960900E+02,&
     & 5.727800E-06,3.903500E-05,2.581900E-04,1.761700E-03,8.637500E-03,&
     & 2.797600E-02,8.442900E-02,3.263100E-01,2.683800E+00,1.307200E+01,&
     & 2.625100E+01,5.988100E+01,1.583900E+02,9.640600E+02,5.891100E+03,&
     & 1.553500E+04,1.515400E-05,6.411300E-05,3.101600E-04,1.707400E-03,&
     & 7.287800E-03,2.253100E-02,6.677200E-02,2.581900E-01,2.123600E+00,&
     & 1.028600E+01,2.037800E+01,4.593600E+01,1.196000E+02,7.230500E+02,&
     & 4.418100E+03,1.165200E+04,1.636600E-05,6.359300E-05,2.721100E-04,&
     & 1.325500E-03,5.239300E-03,1.579900E-02,4.632200E-02,1.787200E-01,&
     & 1.465000E+00,7.177800E+00,1.431800E+01,3.197700E+01,8.283500E+01,&
     & 4.842300E+02,2.945500E+03,7.767800E+03,1.454900E-05,5.293000E-05,&
     & 2.008100E-04,8.317200E-04,2.938500E-03,8.566700E-03,2.478700E-02,&
     & 9.528600E-02,7.724600E-01,3.800500E+00,7.681800E+00,1.735000E+01,&
     & 4.515200E+01,2.521700E+02,1.472700E+03,3.884100E+03,5.539800E-06,&
     & 1.408300E-05,2.703900E-05,5.425200E-05,1.014600E-04,2.145000E-04,&
     & 5.311600E-04,1.899000E-03,1.484100E-02,6.487500E-02,1.138400E-01,&
     & 2.265800E-01,5.516800E-01,3.480000E+00,5.375000E+01,3.569900E+02,&
     & 7.890600E-06,5.760000E-05,3.853500E-04,2.482500E-03,1.134700E-02,&
     & 3.640500E-02,1.092800E-01,4.208800E-01,3.415800E+00,1.646300E+01,&
     & 3.289300E+01,7.437500E+01,1.952500E+02,1.158600E+03,6.863700E+03,&
     & 1.781300E+04,2.010900E-05,9.042700E-05,4.453500E-04,2.342300E-03,&
     & 9.522900E-03,2.927100E-02,8.633900E-02,3.326400E-01,2.703600E+00,&
     & 1.292400E+01,2.548700E+01,5.698700E+01,1.473300E+02,8.689400E+02,&
     & 5.147700E+03,1.336100E+04,2.170800E-05,8.819000E-05,3.825400E-04,&
     & 1.793300E-03,6.816900E-03,2.049000E-02,5.990100E-02,2.298600E-01,&
     & 1.866200E+00,9.029200E+00,1.792800E+01,3.960200E+01,1.019900E+02,&
     & 5.817100E+02,3.431900E+03,8.907500E+03,1.905300E-05,7.149100E-05,&
     & 2.752200E-04,1.106100E-03,3.799700E-03,1.108800E-02,3.203200E-02,&
     & 1.223100E-01,9.836000E-01,4.784900E+00,9.646700E+00,2.156300E+01,&
     & 5.541800E+01,3.026000E+02,1.716000E+03,4.453500E+03,6.456600E-06,&
     & 1.669600E-05,3.179000E-05,6.413800E-05,1.189100E-04,2.550300E-04,&
     & 6.334800E-04,2.252300E-03,1.828000E-02,7.777200E-02,1.324100E-01,&
     & 2.620500E-01,6.787800E-01,4.731100E+00,6.498000E+01,4.217200E+02,&
     & 2.009700E-06,9.686100E-06,5.590800E-05,4.373800E-04,2.835900E-03,&
     & 9.901300E-03,3.131100E-02,1.221000E-01,1.077000E+00,5.466400E+00,&
     & 1.109500E+01,2.614700E+01,7.261700E+01,4.796000E+02,3.497200E+03,&
     & 9.746800E+03,5.332300E-06,1.812900E-05,7.917800E-05,4.750900E-04,&
     & 2.479200E-03,8.034300E-03,2.489600E-02,9.699400E-02,8.553000E-01,&
     & 4.329100E+00,8.722400E+00,2.020000E+01,5.519800E+01,3.597000E+02,&
     & 2.623000E+03,7.310000E+03,5.802100E-06,1.900900E-05,7.522700E-05,&
     & 3.904100E-04,1.819800E-03,5.667400E-03,1.733600E-02,6.732600E-02,&
     & 5.899800E-01,2.999900E+00,6.122600E+00,1.419200E+01,3.845400E+01,&
     & 2.417600E+02,1.748700E+03,4.872900E+03,5.350200E-06,1.700500E-05,&
     & 6.016600E-05,2.636900E-04,1.046200E-03,3.112900E-03,9.324700E-03,&
     & 3.612300E-02,3.120500E-01,1.580800E+00,3.251900E+00,7.672000E+00,&
     & 2.128500E+01,1.271300E+02,8.743400E+02,2.436600E+03,2.724100E-06,&
     & 6.338900E-06,1.230100E-05,2.401900E-05,4.571200E-05,9.636100E-05,&
     & 2.360800E-04,8.590400E-04,6.388600E-03,2.992300E-02,5.683900E-02,&
     & 1.182900E-01,2.783100E-01,1.404900E+00,2.860700E+01,2.073600E+02/
      data   absb(:,481:500) /                                          &
     & 2.650800E-06,1.495700E-05,9.302900E-05,6.993700E-04,4.062700E-03,&
     & 1.370600E-02,4.257500E-02,1.665200E-01,1.452100E+00,7.287400E+00,&
     & 1.475100E+01,3.461800E+01,9.449600E+01,6.178800E+02,4.330600E+03,&
     & 1.194200E+04,7.238300E-06,2.692900E-05,1.233600E-04,7.259900E-04,&
     & 3.496200E-03,1.110100E-02,3.380100E-02,1.321000E-01,1.152900E+00,&
     & 5.771000E+00,1.156000E+01,2.672800E+01,7.172700E+01,4.633900E+02,&
     & 3.248000E+03,8.956200E+03,7.877300E-06,2.769200E-05,1.137300E-04,&
     & 5.835400E-04,2.541000E-03,7.812500E-03,2.351100E-02,9.167000E-02,&
     & 7.946700E-01,4.006800E+00,8.122600E+00,1.876800E+01,4.992700E+01,&
     & 3.112500E+02,2.165300E+03,5.970800E+03,7.164800E-06,2.420900E-05,&
     & 8.841500E-05,3.824500E-04,1.443100E-03,4.274600E-03,1.261600E-02,&
     & 4.910700E-02,4.194200E-01,2.112200E+00,4.332500E+00,1.017300E+01,&
     & 2.753900E+01,1.634700E+02,1.082700E+03,2.985500E+03,3.275500E-06,&
     & 7.768900E-06,1.523600E-05,2.989200E-05,5.602200E-05,1.190200E-04,&
     & 2.945200E-04,1.062300E-03,8.247900E-03,3.826700E-02,7.085500E-02,&
     & 1.444800E-01,3.461600E-01,1.861000E+00,3.694300E+01,2.609200E+02,&
     & 3.618400E-06,2.298900E-05,1.490000E-04,1.066000E-03,5.607800E-03,&
     & 1.854600E-02,5.693500E-02,2.222200E-01,1.914100E+00,9.504100E+00,&
     & 1.920500E+01,4.473300E+01,1.209500E+02,7.756600E+02,5.228800E+03,&
     & 1.421700E+04,9.834800E-06,3.943400E-05,1.867700E-04,1.063900E-03,&
     & 4.771100E-03,1.499500E-02,4.512900E-02,1.762600E-01,1.518700E+00,&
     & 7.523100E+00,1.501500E+01,3.448800E+01,9.166200E+01,5.817500E+02,&
     & 3.921600E+03,1.066300E+04,1.065600E-05,3.974400E-05,1.674400E-04,&
     & 8.377600E-04,3.444200E-03,1.053600E-02,3.135900E-02,1.222000E-01,&
     & 1.047300E+00,5.237400E+00,1.055400E+01,2.418100E+01,6.373900E+01,&
     & 3.904700E+02,2.614400E+03,7.108600E+03,9.573700E-06,3.383700E-05,&
     & 1.265200E-04,5.349700E-04,1.941800E-03,5.732800E-03,1.680900E-02,&
     & 6.535700E-02,5.522900E-01,2.766100E+00,5.642400E+00,1.314000E+01,&
     & 3.503200E+01,2.047900E+02,1.307200E+03,3.554200E+03,3.877400E-06,&
     & 9.373800E-06,1.854400E-05,3.643700E-05,6.726700E-05,1.437300E-04,&
     & 3.609300E-04,1.293100E-03,1.046800E-02,4.733100E-02,8.572100E-02,&
     & 1.729000E-01,4.122600E-01,2.573600E+00,4.634200E+01,3.197800E+02,&
     & 4.995100E-06,3.460600E-05,2.293800E-04,1.549000E-03,7.504700E-03,&
     & 2.455000E-02,7.484200E-02,2.916000E-01,2.477300E+00,1.217600E+01,&
     & 2.450400E+01,5.664400E+01,1.522000E+02,9.523100E+02,6.175600E+03,&
     & 1.652600E+04,1.320500E-05,5.654500E-05,2.744300E-04,1.496500E-03,&
     & 6.340600E-03,1.981100E-02,5.925600E-02,2.309600E-01,1.966500E+00,&
     & 9.615600E+00,1.911900E+01,4.362000E+01,1.152100E+02,7.142000E+02,&
     & 4.631400E+03,1.239400E+04,1.427100E-05,5.592600E-05,2.400200E-04,&
     & 1.158800E-03,4.558100E-03,1.388600E-02,4.115600E-02,1.599300E-01,&
     & 1.356500E+00,6.706600E+00,1.346100E+01,3.054200E+01,8.004200E+01,&
     & 4.790400E+02,3.087500E+03,8.262500E+03,1.265600E-05,4.635600E-05,&
     & 1.764800E-04,7.249700E-04,2.554800E-03,7.531300E-03,2.203900E-02,&
     & 8.534200E-02,7.149400E-01,3.544900E+00,7.221400E+00,1.665300E+01,&
     & 4.383300E+01,2.508600E+02,1.543900E+03,4.131300E+03,4.519400E-06,&
     & 1.125300E-05,2.201200E-05,4.369800E-05,7.954700E-05,1.733200E-04,&
     & 4.343500E-04,1.546800E-03,1.307700E-02,5.862500E-02,1.013700E-01,&
     & 2.020000E-01,5.153100E-01,3.572400E+00,5.674400E+01,3.830000E+02,&
     & 6.865400E-06,5.071200E-05,3.393600E-04,2.160900E-03,9.779200E-03,&
     & 3.185300E-02,9.693300E-02,3.761700E-01,3.153600E+00,1.532200E+01,&
     & 3.072300E+01,7.066700E+01,1.883700E+02,1.146400E+03,7.154300E+03,&
     & 1.881500E+04,1.744500E-05,7.930100E-05,3.911200E-04,2.035200E-03,&
     & 8.221300E-03,2.566700E-02,7.674000E-02,2.976800E-01,2.504400E+00,&
     & 1.208400E+01,2.391800E+01,5.433100E+01,1.424000E+02,8.597800E+02,&
     & 5.365700E+03,1.411100E+04,1.886000E-05,7.705900E-05,3.353200E-04,&
     & 1.555300E-03,5.886800E-03,1.796900E-02,5.327400E-02,2.058900E-01,&
     & 1.727900E+00,8.448300E+00,1.688700E+01,3.794900E+01,9.883600E+01,&
     & 5.762600E+02,3.576900E+03,9.407700E+03,1.651100E-05,6.228500E-05,&
     & 2.404000E-04,9.566600E-04,3.284800E-03,9.724600E-03,2.847600E-02,&
     & 1.097100E-01,9.101100E-01,4.470900E+00,9.092200E+00,2.075500E+01,&
     & 5.399100E+01,3.012800E+02,1.788400E+03,4.703400E+03,5.259700E-06,&
     & 1.327600E-05,2.588500E-05,5.153200E-05,9.276300E-05,2.062500E-04,&
     & 5.153300E-04,1.839400E-03,1.619600E-02,6.934000E-02,1.210100E-01,&
     & 2.302300E-01,6.489500E-01,4.852500E+00,6.838700E+01,4.496800E+02/
      data   absb(:,501:520) /                                          &
     & 1.730700E-06,8.688100E-06,5.102700E-05,3.988900E-04,2.528400E-03,&
     & 8.798000E-03,2.788600E-02,1.098600E-01,1.000400E+00,5.151200E+00,&
     & 1.046900E+01,2.486700E+01,6.958600E+01,4.767300E+02,3.732300E+03,&
     & 1.058500E+04,4.671900E-06,1.621500E-05,7.159200E-05,4.299900E-04,&
     & 2.205700E-03,7.151900E-03,2.220600E-02,8.738200E-02,7.968600E-01,&
     & 4.096700E+00,8.265300E+00,1.932500E+01,5.307500E+01,3.575800E+02,&
     & 2.799300E+03,7.886800E+03,5.092600E-06,1.696500E-05,6.775200E-05,&
     & 3.519700E-04,1.615500E-03,5.045100E-03,1.546500E-02,6.073700E-02,&
     & 5.494300E-01,2.836200E+00,5.802700E+00,1.364200E+01,3.711900E+01,&
     & 2.408600E+02,1.866200E+03,5.292400E+03,4.686400E-06,1.512200E-05,&
     & 5.398400E-05,2.363400E-04,9.258800E-04,2.771200E-03,8.317600E-03,&
     & 3.260900E-02,2.903600E-01,1.493300E+00,3.080300E+00,7.388400E+00,&
     & 2.062000E+01,1.276400E+02,9.331000E+02,2.646100E+03,2.250400E-06,&
     & 5.083900E-06,1.006900E-05,1.931100E-05,3.626700E-05,7.820200E-05,&
     & 1.933000E-04,7.017700E-04,5.616900E-03,2.639300E-02,5.138900E-02,&
     & 1.047700E-01,2.542100E-01,1.359200E+00,3.088000E+01,2.260300E+02,&
     & 2.307900E-06,1.342600E-05,8.430600E-05,6.299100E-04,3.588600E-03,&
     & 1.213500E-02,3.795400E-02,1.496100E-01,1.347200E+00,6.859900E+00,&
     & 1.390500E+01,3.285700E+01,9.119000E+01,6.146300E+02,4.585500E+03,&
     & 1.283500E+04,6.354000E-06,2.403700E-05,1.108200E-04,6.502100E-04,&
     & 3.084400E-03,9.843500E-03,3.016100E-02,1.188700E-01,1.072000E+00,&
     & 5.455200E+00,1.096300E+01,2.548600E+01,6.943200E+01,4.609900E+02,&
     & 3.439100E+03,9.628000E+03,6.915200E-06,2.462800E-05,1.017800E-04,&
     & 5.205900E-04,2.238200E-03,6.932500E-03,2.098100E-02,8.254200E-02,&
     & 7.388700E-01,3.790200E+00,7.703800E+00,1.799300E+01,4.846700E+01,&
     & 3.102400E+02,2.292700E+03,6.418200E+03,6.276400E-06,2.143400E-05,&
     & 7.878600E-05,3.393200E-04,1.269500E-03,3.790200E-03,1.126000E-02,&
     & 4.426000E-02,3.900200E-01,1.999300E+00,4.099800E+00,9.774800E+00,&
     & 2.683400E+01,1.640400E+02,1.146300E+03,3.209100E+03,2.692600E-06,&
     & 6.231800E-06,1.242400E-05,2.411700E-05,4.400300E-05,9.625000E-05,&
     & 2.404800E-04,8.648900E-04,7.246400E-03,3.404000E-02,6.340800E-02,&
     & 1.280700E-01,3.096400E-01,1.884400E+00,3.945800E+01,2.821500E+02,&
     & 3.166500E-06,2.055000E-05,1.337800E-04,9.475500E-04,4.909700E-03,&
     & 1.636700E-02,5.072900E-02,1.997400E-01,1.776700E+00,8.939500E+00,&
     & 1.808000E+01,4.248200E+01,1.172500E+02,7.725300E+02,5.498800E+03,&
     & 1.514700E+04,8.614700E-06,3.502700E-05,1.666600E-04,9.412900E-04,&
     & 4.180500E-03,1.325100E-02,4.026900E-02,1.586100E-01,1.414500E+00,&
     & 7.103800E+00,1.420900E+01,3.289900E+01,8.911700E+01,5.793700E+02,&
     & 4.123900E+03,1.135900E+04,9.334300E-06,3.516000E-05,1.488600E-04,&
     & 7.390400E-04,3.015700E-03,9.307500E-03,2.799600E-02,1.099500E-01,&
     & 9.749300E-01,4.948900E+00,9.996900E+00,2.320800E+01,6.213400E+01,&
     & 3.894800E+02,2.749400E+03,7.572300E+03,8.361400E-06,2.982000E-05,&
     & 1.119800E-04,4.699100E-04,1.699300E-03,5.063700E-03,1.500800E-02,&
     & 5.883600E-02,5.140000E-01,2.610400E+00,5.342100E+00,1.265800E+01,&
     & 3.431800E+01,2.054400E+02,1.374700E+03,3.786300E+03,3.181400E-06,&
     & 7.512300E-06,1.501700E-05,2.935400E-05,5.282500E-05,1.172300E-04,&
     & 2.928300E-04,1.053300E-03,9.168200E-03,4.282000E-02,7.712800E-02,&
     & 1.512200E-01,3.832000E-01,2.667200E+00,4.906600E+01,3.398300E+02,&
     & 4.373100E-06,3.076200E-05,2.040700E-04,1.361700E-03,6.516500E-03,&
     & 2.159400E-02,6.668000E-02,2.621900E-01,2.300600E+00,1.144900E+01,&
     & 2.305500E+01,5.402800E+01,1.481000E+02,9.492200E+02,6.455600E+03,&
     & 1.746100E+04,1.152800E-05,4.997100E-05,2.431000E-04,1.311300E-03,&
     & 5.516700E-03,1.745100E-02,5.291000E-02,2.079300E-01,1.832100E+00,&
     & 9.081600E+00,1.808500E+01,4.174900E+01,1.123600E+02,7.118900E+02,&
     & 4.841500E+03,1.309600E+04,1.246400E-05,4.923600E-05,2.120400E-04,&
     & 1.012900E-03,3.964500E-03,1.223800E-02,3.676800E-02,1.439600E-01,&
     & 1.263400E+00,6.336700E+00,1.276500E+01,2.937800E+01,7.825700E+01,&
     & 4.781500E+02,3.227900E+03,8.731300E+03,1.102300E-05,4.064000E-05,&
     & 1.551900E-04,6.318000E-04,2.221500E-03,6.639000E-03,1.968500E-02,&
     & 7.688400E-02,6.656800E-01,3.342100E+00,6.850400E+00,1.608700E+01,&
     & 4.310800E+01,2.515800E+02,1.613900E+03,4.365400E+03,3.716400E-06,&
     & 8.928600E-06,1.783300E-05,3.502900E-05,6.188900E-05,1.412900E-04,&
     & 3.517400E-04,1.262400E-03,1.149300E-02,5.191900E-02,9.214100E-02,&
     & 1.765600E-01,4.858800E-01,3.705400E+00,5.983400E+01,4.084700E+02/
      data   absb(:,521:540) /                                          &
     & 5.987800E-06,4.471900E-05,2.993200E-04,1.880500E-03,8.420900E-03,&
     & 2.792200E-02,8.632500E-02,3.385500E-01,2.930600E+00,1.442300E+01,&
     & 2.890100E+01,6.769900E+01,1.840400E+02,1.144600E+03,7.436400E+03,&
     & 1.963100E+04,1.515100E-05,6.959200E-05,3.439900E-04,1.768800E-03,&
     & 7.089900E-03,2.255300E-02,6.849100E-02,2.685200E-01,2.333900E+00,&
     & 1.142600E+01,2.262900E+01,5.222000E+01,1.394000E+02,8.584200E+02,&
     & 5.577500E+03,1.481500E+04,1.640000E-05,6.743200E-05,2.942500E-04,&
     & 1.348500E-03,5.077500E-03,1.579800E-02,4.757900E-02,1.857400E-01,&
     & 1.610200E+00,7.985000E+00,1.603100E+01,3.668200E+01,9.692800E+01,&
     & 5.760300E+02,3.718300E+03,9.877000E+03,1.431600E-05,5.432200E-05,&
     & 2.100200E-04,8.276000E-04,2.835400E-03,8.548000E-03,2.544800E-02,&
     & 9.906000E-02,8.482700E-01,4.217900E+00,8.640000E+00,2.015700E+01,&
     & 5.324600E+01,3.023900E+02,1.859100E+03,4.938900E+03,4.297400E-06,&
     & 1.056900E-05,2.075100E-05,4.130900E-05,7.261000E-05,1.659800E-04,&
     & 4.178100E-04,1.497600E-03,1.414700E-02,6.240200E-02,1.094900E-01,&
     & 2.002900E-01,6.202100E-01,5.035300E+00,7.193600E+01,4.720100E+02,&
     & 1.498100E-06,7.779100E-06,4.642300E-05,3.621400E-04,2.252000E-03,&
     & 7.829700E-03,2.497100E-02,9.935500E-02,9.325600E-01,4.864600E+00,&
     & 9.952400E+00,2.369800E+01,6.770300E+01,4.782900E+02,3.974300E+03,&
     & 1.143200E+04,4.083400E-06,1.444200E-05,6.438500E-05,3.871600E-04,&
     & 1.960200E-03,6.372700E-03,1.990100E-02,7.909100E-02,7.441600E-01,&
     & 3.888000E+00,7.898800E+00,1.850500E+01,5.178500E+01,3.588200E+02,&
     & 2.980800E+03,8.573700E+03,4.453100E-06,1.504600E-05,6.065100E-05,&
     & 3.154900E-04,1.432800E-03,4.495200E-03,1.386000E-02,5.500100E-02,&
     & 5.126400E-01,2.693200E+00,5.543700E+00,1.312100E+01,3.633400E+01,&
     & 2.421400E+02,1.987200E+03,5.715800E+03,4.084300E-06,1.336000E-05,&
     & 4.808400E-05,2.105900E-04,8.186800E-04,2.467100E-03,7.450800E-03,&
     & 2.953400E-02,2.707900E-01,1.419400E+00,2.938200E+00,7.118700E+00,&
     & 2.021400E+01,1.291700E+02,9.935900E+02,2.857900E+03,1.853900E-06,&
     & 4.160000E-06,8.231300E-06,1.569200E-05,2.941700E-05,6.387900E-05,&
     & 1.594300E-04,5.815500E-04,4.946500E-03,2.378100E-02,4.732100E-02,&
     & 9.588800E-02,2.282600E-01,1.336000E+00,3.285000E+01,2.429300E+02,&
     & 2.015000E-06,1.201900E-05,7.607500E-05,5.647400E-04,3.168100E-03,&
     & 1.077000E-02,3.399300E-02,1.353000E-01,1.256100E+00,6.467200E+00,&
     & 1.322400E+01,3.135900E+01,8.916500E+01,6.176500E+02,4.851700E+03,&
     & 1.365600E+04,5.556900E-06,2.134600E-05,9.912400E-05,5.796300E-04,&
     & 2.721500E-03,8.751000E-03,2.704400E-02,1.076400E-01,1.002000E+00,&
     & 5.178200E+00,1.046100E+01,2.442700E+01,6.804600E+01,4.633100E+02,&
     & 3.638400E+03,1.030800E+04,6.041900E-06,2.177100E-05,9.058600E-05,&
     & 4.620400E-04,1.971700E-03,6.161600E-03,1.881700E-02,7.477100E-02,&
     & 6.903400E-01,3.601800E+00,7.346300E+00,1.733500E+01,4.764300E+01,&
     & 3.122600E+02,2.425700E+03,6.871500E+03,5.471600E-06,1.885700E-05,&
     & 6.978000E-05,2.996600E-04,1.116600E-03,3.364400E-03,1.010200E-02,&
     & 4.007600E-02,3.643400E-01,1.896200E+00,3.908700E+00,9.440200E+00,&
     & 2.648500E+01,1.659400E+02,1.212900E+03,3.436000E+03,2.228500E-06,&
     & 5.035300E-06,1.016800E-05,1.945000E-05,3.549000E-05,7.913700E-05,&
     & 1.973700E-04,7.150300E-04,6.396000E-03,3.049200E-02,5.841800E-02,&
     & 1.154000E-01,2.797800E-01,1.920300E+00,4.161500E+01,3.011400E+02,&
     & 2.772500E-06,1.832400E-05,1.198100E-04,8.403400E-04,4.297700E-03,&
     & 1.448400E-02,4.543100E-02,1.808700E-01,1.658700E+00,8.453500E+00,&
     & 1.716600E+01,4.070100E+01,1.151100E+02,7.774300E+02,5.784800E+03,&
     & 1.609600E+04,7.515100E-06,3.097200E-05,1.481100E-04,8.306700E-04,&
     & 3.661500E-03,1.174100E-02,3.611600E-02,1.437300E-01,1.323900E+00,&
     & 6.749700E+00,1.356000E+01,3.162400E+01,8.769200E+01,5.831000E+02,&
     & 4.338600E+03,1.207300E+04,8.138700E-06,3.094900E-05,1.317600E-04,&
     & 6.497100E-04,2.640300E-03,8.248200E-03,2.511800E-02,9.966600E-02,&
     & 9.120600E-01,4.705400E+00,9.553700E+00,2.241300E+01,6.129000E+01,&
     & 3.925600E+02,2.892300E+03,8.047300E+03,7.269000E-06,2.611700E-05,&
     & 9.859700E-05,4.114400E-04,1.486900E-03,4.484400E-03,1.346800E-02,&
     & 5.333900E-02,4.809200E-01,2.477000E+00,5.103400E+00,1.226600E+01,&
     & 3.400700E+01,2.079200E+02,1.446200E+03,4.024000E+03,2.633400E-06,&
     & 6.044700E-06,1.220500E-05,2.369300E-05,4.185400E-05,9.660000E-05,&
     & 2.409700E-04,8.682700E-04,8.157600E-03,3.833900E-02,7.018100E-02,&
     & 1.337100E-01,3.572300E-01,2.734900E+00,5.151400E+01,3.642300E+02/
      data   absb(:,541:560) /                                          &
     & 3.825600E-06,2.726100E-05,1.812300E-04,1.195700E-03,5.659700E-03,&
     & 1.905000E-02,5.975100E-02,2.375000E-01,2.150100E+00,1.085600E+01,&
     & 2.188700E+01,5.204100E+01,1.459800E+02,9.568600E+02,6.756600E+03,&
     & 1.843500E+04,1.001900E-05,4.393200E-05,2.147200E-04,1.147500E-03,&
     & 4.796700E-03,1.542700E-02,4.748500E-02,1.886700E-01,1.716700E+00,&
     & 8.648400E+00,1.726400E+01,4.033800E+01,1.109600E+02,7.176200E+02,&
     & 5.067300E+03,1.374400E+04,1.083600E-05,4.315700E-05,1.866200E-04,&
     & 8.838900E-04,3.446200E-03,1.082000E-02,3.300700E-02,1.306300E-01,&
     & 1.183700E+00,6.035000E+00,1.221100E+01,2.853000E+01,7.742200E+01,&
     & 4.825600E+02,3.378300E+03,9.218100E+03,9.554900E-06,3.544200E-05,&
     & 1.359000E-04,5.496200E-04,1.929800E-03,5.867800E-03,1.767300E-02,&
     & 6.982200E-02,6.235100E-01,3.179300E+00,6.552600E+00,1.567600E+01,&
     & 4.287700E+01,2.547500E+02,1.689100E+03,4.608800E+03,3.070900E-06,&
     & 7.190500E-06,1.449200E-05,2.825300E-05,4.934800E-05,1.149500E-04,&
     & 2.898300E-04,1.040900E-03,1.019400E-02,4.657000E-02,8.470600E-02,&
     & 1.549000E-01,4.637700E-01,3.803100E+00,6.263200E+01,4.311100E+02,&
     & 5.221700E-06,3.938500E-05,2.637600E-04,1.638000E-03,7.268100E-03,&
     & 2.452400E-02,7.741600E-02,3.076200E-01,2.741300E+00,1.372300E+01,&
     & 2.748700E+01,6.549100E+01,1.823800E+02,1.155000E+03,7.746700E+03,&
     & 2.074300E+04,1.311600E-05,6.088800E-05,3.019000E-04,1.537300E-03,&
     & 6.125300E-03,1.986700E-02,6.153000E-02,2.443200E-01,2.190500E+00,&
     & 1.090900E+01,2.162200E+01,5.066300E+01,1.383600E+02,8.662900E+02,&
     & 5.809900E+03,1.545800E+04,1.420700E-05,5.879500E-05,2.575300E-04,&
     & 1.169500E-03,4.387300E-03,1.391900E-02,4.275100E-02,1.689700E-01,&
     & 1.511500E+00,7.624600E+00,1.535000E+01,3.576800E+01,9.632700E+01,&
     & 5.818900E+02,3.873400E+03,1.037100E+04,1.236800E-05,4.717900E-05,&
     & 1.830100E-04,7.157600E-04,2.451400E-03,7.529200E-03,2.286300E-02,&
     & 9.014000E-02,7.963500E-01,4.021400E+00,8.269800E+00,1.975500E+01,&
     & 5.316800E+01,3.063100E+02,1.936700E+03,5.185700E+03,3.549200E-06,&
     & 8.513300E-06,1.694600E-05,3.295700E-05,5.818600E-05,1.345300E-04,&
     & 3.432800E-04,1.235700E-03,1.254200E-02,5.622600E-02,9.858800E-02,&
     & 1.815700E-01,5.769000E-01,5.202100E+00,7.512900E+01,5.008600E+02,&
     & 1.268300E-06,6.694900E-06,4.021500E-05,3.135900E-04,1.936600E-03,&
     & 6.763000E-03,2.179600E-02,8.751900E-02,8.484000E-01,4.490200E+00,&
     & 9.289600E+00,2.210800E+01,6.486100E+01,4.722600E+02,4.139200E+03,&
     & 1.205200E+04,3.471700E-06,1.239000E-05,5.551600E-05,3.344600E-04,&
     & 1.685400E-03,5.512600E-03,1.738700E-02,6.976900E-02,6.784600E-01,&
     & 3.607900E+00,7.398800E+00,1.735900E+01,4.974600E+01,3.544300E+02,&
     & 3.104400E+03,9.039100E+03,3.784300E-06,1.287300E-05,5.217800E-05,&
     & 2.719300E-04,1.230400E-03,3.888400E-03,1.211100E-02,4.855200E-02,&
     & 4.672500E-01,2.502700E+00,5.183600E+00,1.235400E+01,3.502600E+01,&
     & 2.395700E+02,2.069700E+03,6.026100E+03,3.463900E-06,1.141000E-05,&
     & 4.126500E-05,1.809100E-04,7.019900E-04,2.134000E-03,6.508400E-03,&
     & 2.608500E-02,2.467800E-01,1.315600E+00,2.747800E+00,6.708500E+00,&
     & 1.955100E+01,1.285100E+02,1.034800E+03,3.013000E+03,1.503300E-06,&
     & 3.283700E-06,6.630000E-06,1.243700E-05,2.300800E-05,5.172100E-05,&
     & 1.283500E-04,4.686800E-04,4.258100E-03,2.123800E-02,4.141700E-02,&
     & 8.392500E-02,2.015600E-01,1.308600E+00,3.400500E+01,2.542500E+02,&
     & 1.713000E-06,1.034200E-05,6.564600E-05,4.858300E-04,2.710200E-03,&
     & 9.298500E-03,2.969800E-02,1.195300E-01,1.146600E+00,5.991800E+00,&
     & 1.234600E+01,2.939000E+01,8.597600E+01,6.121400E+02,5.033800E+03,&
     & 1.441000E+04,4.724200E-06,1.828900E-05,8.520700E-05,4.975200E-04,&
     & 2.329600E-03,7.566200E-03,2.366600E-02,9.520400E-02,9.171300E-01,&
     & 4.815400E+00,9.812000E+00,2.299900E+01,6.578500E+01,4.592300E+02,&
     & 3.775600E+03,1.080800E+04,5.132100E-06,1.859900E-05,7.769100E-05,&
     & 3.956600E-04,1.687200E-03,5.325200E-03,1.647900E-02,6.612900E-02,&
     & 6.317900E-01,3.349700E+00,6.889500E+00,1.638800E+01,4.617500E+01,&
     & 3.099800E+02,2.516900E+03,7.204600E+03,4.638600E-06,1.606800E-05,&
     & 5.969400E-05,2.559300E-04,9.549000E-04,2.907000E-03,8.843300E-03,&
     & 3.547000E-02,3.331900E-01,1.763900E+00,3.662100E+00,8.946400E+00,&
     & 2.578200E+01,1.654600E+02,1.258500E+03,3.602600E+03,1.804500E-06,&
     & 4.007200E-06,8.135100E-06,1.530500E-05,2.766400E-05,6.403200E-05,&
     & 1.586300E-04,5.774000E-04,5.531700E-03,2.715300E-02,5.161400E-02,&
     & 9.996200E-02,2.540100E-01,1.915400E+00,4.288900E+01,3.139200E+02/
      data   absb(:,561:580) /                                          &
     & 2.359800E-06,1.572900E-05,1.029800E-04,7.187500E-04,3.657400E-03,&
     & 1.248900E-02,3.976000E-02,1.603500E-01,1.518500E+00,7.869300E+00,&
     & 1.603800E+01,3.843500E+01,1.116500E+02,7.728000E+02,5.982400E+03,&
     & 1.679600E+04,6.379400E-06,2.644700E-05,1.269400E-04,7.090900E-04,&
     & 3.120600E-03,1.014100E-02,3.167500E-02,1.275600E-01,1.215100E+00,&
     & 6.309800E+00,1.273700E+01,2.996600E+01,8.524500E+01,5.797600E+02,&
     & 4.486700E+03,1.259800E+04,6.904300E-06,2.638200E-05,1.126600E-04,&
     & 5.535800E-04,2.249900E-03,7.124600E-03,2.203500E-02,8.846300E-02,&
     & 8.372700E-01,4.396400E+00,8.985600E+00,2.132400E+01,5.971600E+01,&
     & 3.907700E+02,2.991000E+03,8.398700E+03,6.155200E-06,2.219800E-05,&
     & 8.405900E-05,3.499300E-04,1.266200E-03,3.874900E-03,1.181200E-02,&
     & 4.736100E-02,4.413300E-01,2.312400E+00,4.799200E+00,1.169400E+01,&
     & 3.327300E+01,2.077300E+02,1.495500E+03,4.199400E+03,2.131200E-06,&
     & 4.811100E-06,9.810300E-06,1.863500E-05,3.308900E-05,7.697400E-05,&
     & 1.939600E-04,7.011800E-04,7.062500E-03,3.357300E-02,6.217300E-02,&
     & 1.180600E-01,3.284600E-01,2.735700E+00,5.298300E+01,3.783200E+02,&
     & 3.253300E-06,2.332600E-05,1.550300E-04,1.017100E-03,4.796300E-03,&
     & 1.640000E-02,5.240200E-02,2.112300E-01,1.973700E+00,1.015600E+01,&
     & 2.050100E+01,4.941800E+01,1.425000E+02,9.539700E+02,6.965200E+03,&
     & 1.916000E+04,8.486100E-06,3.742400E-05,1.833400E-04,9.751300E-04,&
     & 4.069400E-03,1.331200E-02,4.173500E-02,1.680100E-01,1.581000E+00,&
     & 8.119300E+00,1.624600E+01,3.843900E+01,1.085300E+02,7.155400E+02,&
     & 5.223900E+03,1.437000E+04,9.177300E-06,3.669400E-05,1.590500E-04,&
     & 7.502300E-04,2.922800E-03,9.338900E-03,2.902900E-02,1.163900E-01,&
     & 1.089900E+00,5.665800E+00,1.150700E+01,2.732300E+01,7.583800E+01,&
     & 4.816500E+02,3.482600E+03,9.579900E+03,8.077100E-06,3.005200E-05,&
     & 1.155100E-04,4.656900E-04,1.637100E-03,5.065900E-03,1.553800E-02,&
     & 6.223500E-02,5.742100E-01,2.981200E+00,6.171500E+00,1.506300E+01,&
     & 4.216200E+01,2.550800E+02,1.741400E+03,4.790400E+03,2.479700E-06,&
     & 5.750300E-06,1.163000E-05,2.220500E-05,3.937200E-05,9.114800E-05,&
     & 2.329200E-04,8.422000E-04,8.857100E-03,4.129800E-02,7.434600E-02,&
     & 1.363000E-01,4.267500E-01,3.828600E+00,6.432700E+01,4.463400E+02,&
     & 4.431700E-06,3.358200E-05,2.247600E-04,1.387200E-03,6.135200E-03,&
     & 2.104900E-02,6.805300E-02,2.748400E-01,2.526200E+00,1.286700E+01,&
     & 2.586500E+01,6.254600E+01,1.791000E+02,1.154000E+03,7.964200E+03,&
     & 2.148300E+04,1.108400E-05,5.173500E-05,2.569700E-04,1.301500E-03,&
     & 5.179500E-03,1.709800E-02,5.417300E-02,2.186100E-01,2.025100E+00,&
     & 1.027700E+01,2.042900E+01,4.853500E+01,1.360800E+02,8.655200E+02,&
     & 5.973300E+03,1.611400E+04,1.200900E-05,4.985200E-05,2.188600E-04,&
     & 9.891200E-04,3.711100E-03,1.198500E-02,3.766400E-02,1.512100E-01,&
     & 1.397500E+00,7.186000E+00,1.451500E+01,3.444700E+01,9.489100E+01,&
     & 5.818700E+02,3.982200E+03,1.074200E+04,1.043600E-05,3.992100E-05,&
     & 1.551400E-04,6.044900E-04,2.074000E-03,6.485700E-03,2.014100E-02,&
     & 8.071700E-02,7.362500E-01,3.787200E+00,7.813900E+00,1.909200E+01,&
     & 5.258100E+01,3.070800E+02,1.991100E+03,5.371100E+03,2.846000E-06,&
     & 6.831700E-06,1.359100E-05,2.604500E-05,4.627600E-05,1.068300E-04,&
     & 2.759800E-04,1.003300E-03,1.089700E-02,4.961900E-02,8.698900E-02,&
     & 1.658500E-01,5.225600E-01,5.263600E+00,7.708700E+01,5.170800E+02,&
     & 1.044600E-06,5.511600E-06,3.299400E-05,2.580800E-04,1.603400E-03,&
     & 5.649600E-03,1.843900E-02,7.484900E-02,7.516500E-01,4.031700E+00,&
     & 8.464100E+00,2.012900E+01,6.076400E+01,4.569300E+02,4.214600E+03,&
     & 1.241100E+04,2.859600E-06,1.019500E-05,4.566000E-05,2.759900E-04,&
     & 1.397600E-03,4.611900E-03,1.473600E-02,5.973700E-02,6.022600E-01,&
     & 3.257500E+00,6.768000E+00,1.589100E+01,4.673200E+01,3.430100E+02,&
     & 3.160800E+03,9.307800E+03,3.114200E-06,1.058500E-05,4.293000E-05,&
     & 2.244000E-04,1.020200E-03,3.253000E-03,1.026900E-02,4.159300E-02,&
     & 4.146500E-01,2.259100E+00,4.738400E+00,1.134600E+01,3.305200E+01,&
     & 2.322000E+02,2.107200E+03,6.205000E+03,2.848800E-06,9.381400E-06,&
     & 3.396900E-05,1.493700E-04,5.818600E-04,1.785200E-03,5.518100E-03,&
     & 2.235300E-02,2.189200E-01,1.186400E+00,2.508900E+00,6.164300E+00,&
     & 1.851400E+01,1.252000E+02,1.053600E+03,3.102600E+03,1.184100E-06,&
     & 2.555600E-06,5.154200E-06,9.663100E-06,1.766300E-05,4.031200E-05,&
     & 1.005900E-04,3.666000E-04,3.551200E-03,1.832200E-02,3.537000E-02,&
     & 7.216600E-02,1.722700E-01,1.253300E+00,3.422500E+01,2.588700E+02/
      data   absb(:,581:600) /                                          &
     & 1.411500E-06,8.513700E-06,5.391600E-05,3.996400E-04,2.242100E-03,&
     & 7.776700E-03,2.522800E-02,1.027800E-01,1.021000E+00,5.423000E+00,&
     & 1.128300E+01,2.696700E+01,8.134700E+01,5.957400E+02,5.120000E+03,&
     & 1.480800E+04,3.891100E-06,1.503700E-05,7.010400E-05,4.100300E-04,&
     & 1.930700E-03,6.337200E-03,2.013500E-02,8.197200E-02,8.186600E-01,&
     & 4.376400E+00,9.007700E+00,2.119800E+01,6.241600E+01,4.471000E+02,&
     & 3.840100E+03,1.110600E+04,4.223600E-06,1.529600E-05,6.394600E-05,&
     & 3.260200E-04,1.398300E-03,4.463000E-03,1.402400E-02,5.695500E-02,&
     & 5.637100E-01,3.044400E+00,6.327200E+00,1.515400E+01,4.393300E+01,&
     & 3.022100E+02,2.559900E+03,7.404300E+03,3.814800E-06,1.320900E-05,&
     & 4.913200E-05,2.109700E-04,7.911800E-04,2.438000E-03,7.525700E-03,&
     & 3.054400E-02,2.972900E-01,1.600800E+00,3.358600E+00,8.285800E+00,&
     & 2.461900E+01,1.619900E+02,1.280000E+03,3.702100E+03,1.418800E-06,&
     & 3.132500E-06,6.349800E-06,1.183400E-05,2.154700E-05,4.992900E-05,&
     & 1.242100E-04,4.533600E-04,4.649600E-03,2.343700E-02,4.342700E-02,&
     & 8.591700E-02,2.317000E-01,1.841100E+00,4.313900E+01,3.192700E+02,&
     & 1.944700E-06,1.294800E-05,8.455200E-05,5.909200E-04,3.020600E-03,&
     & 1.046100E-02,3.389100E-02,1.384300E-01,1.358400E+00,7.180700E+00,&
     & 1.470900E+01,3.556800E+01,1.065300E+02,7.560900E+02,6.079100E+03,&
     & 1.722800E+04,5.252900E-06,2.175300E-05,1.044300E-04,5.838300E-04,&
     & 2.582400E-03,8.514400E-03,2.705800E-02,1.102900E-01,1.090200E+00,&
     & 5.777000E+00,1.174000E+01,2.784700E+01,8.151400E+01,5.672300E+02,&
     & 4.559400E+03,1.292100E+04,5.682200E-06,2.169400E-05,9.271700E-05,&
     & 4.559000E-04,1.862300E-03,5.983600E-03,1.883200E-02,7.651900E-02,&
     & 7.510900E-01,4.023600E+00,8.285200E+00,1.990100E+01,5.720300E+01,&
     & 3.828200E+02,3.039600E+03,8.613000E+03,5.061200E-06,1.825000E-05,&
     & 6.917000E-05,2.882400E-04,1.048400E-03,3.254900E-03,1.009700E-02,&
     & 4.100000E-02,3.958300E-01,2.114700E+00,4.419200E+00,1.093400E+01,&
     & 3.201800E+01,2.042100E+02,1.519800E+03,4.306700E+03,1.676300E-06,&
     & 3.768000E-06,7.666500E-06,1.435300E-05,2.588600E-05,6.011800E-05,&
     & 1.517900E-04,5.539000E-04,5.958000E-03,2.893400E-02,5.369900E-02,&
     & 1.019300E-01,2.985900E-01,2.650400E+00,5.329100E+01,3.844200E+02,&
     & 2.680600E-06,1.919800E-05,1.273100E-04,8.359500E-04,3.957000E-03,&
     & 1.374000E-02,4.485500E-02,1.838500E-01,1.775200E+00,9.321400E+00,&
     & 1.889200E+01,4.609200E+01,1.371100E+02,9.375100E+02,7.071800E+03,&
     & 1.961800E+04,6.985400E-06,3.078700E-05,1.508600E-04,8.027700E-04,&
     & 3.363000E-03,1.118200E-02,3.578300E-02,1.464900E-01,1.426100E+00,&
     & 7.486000E+00,1.503500E+01,3.597500E+01,1.046100E+02,7.032800E+02,&
     & 5.303700E+03,1.471400E+04,7.550600E-06,3.017100E-05,1.308800E-04,&
     & 6.176300E-04,2.416100E-03,7.849200E-03,2.489900E-02,1.014900E-01,&
     & 9.830500E-01,5.224700E+00,1.065200E+01,2.569700E+01,7.319600E+01,&
     & 4.738600E+02,3.535700E+03,9.809200E+03,6.640200E-06,2.470600E-05,&
     & 9.499900E-05,3.833400E-04,1.354100E-03,4.259800E-03,1.333100E-02,&
     & 5.425700E-02,5.181700E-01,2.745300E+00,5.708200E+00,1.420000E+01,&
     & 4.083800E+01,2.516500E+02,1.767900E+03,4.904700E+03,1.949200E-06,&
     & 4.519300E-06,9.088300E-06,1.718900E-05,3.087200E-05,7.106400E-05,&
     & 1.825400E-04,6.668200E-04,7.494700E-03,3.547600E-02,6.428700E-02,&
     & 1.216700E-01,3.826500E-01,3.740700E+00,6.471300E+01,4.529700E+02,&
     & 3.650300E-06,2.762400E-05,1.845500E-04,1.139600E-03,5.058200E-03,&
     & 1.761200E-02,5.841100E-02,2.405900E-01,2.284200E+00,1.187100E+01,&
     & 2.397600E+01,5.878500E+01,1.734900E+02,1.138100E+03,8.080300E+03,&
     & 2.196500E+04,9.121000E-06,4.255000E-05,2.113100E-04,1.070700E-03,&
     & 4.278500E-03,1.435000E-02,4.661100E-02,1.916000E-01,1.837000E+00,&
     & 9.515200E+00,1.902800E+01,4.575000E+01,1.320200E+02,8.535300E+02,&
     & 6.060100E+03,1.647400E+04,9.880000E-06,4.097500E-05,1.800000E-04,&
     & 8.137500E-04,3.066800E-03,1.006400E-02,3.241900E-02,1.325600E-01,&
     & 1.267900E+00,6.653800E+00,1.352600E+01,3.263400E+01,9.217900E+01,&
     & 5.743000E+02,4.040100E+03,1.098200E+04,8.578400E-06,3.281100E-05,&
     & 1.275600E-04,4.974300E-04,1.715000E-03,5.448500E-03,1.733500E-02,&
     & 7.080800E-02,6.680600E-01,3.505700E+00,7.270600E+00,1.814100E+01,&
     & 5.127100E+01,3.037800E+02,2.020100E+03,5.491500E+03,2.247800E-06,&
     & 5.346300E-06,1.060600E-05,2.032600E-05,3.630100E-05,8.357700E-05,&
     & 2.165400E-04,7.959300E-04,9.261600E-03,4.247600E-02,7.587000E-02,&
     & 1.495800E-01,4.715400E-01,5.170400E+00,7.753500E+01,5.190900E+02/
      data   absb(:,601:620) /                                          &
     & 8.314100E-07,4.294300E-06,2.542900E-05,2.012100E-04,1.274800E-03,&
     & 4.542300E-03,1.502500E-02,6.177800E-02,6.407100E-01,3.494500E+00,&
     & 7.450600E+00,1.773700E+01,5.504000E+01,4.292200E+02,4.183000E+03,&
     & 1.246400E+04,2.260600E-06,7.962500E-06,3.550200E-05,2.164700E-04,&
     & 1.114600E-03,3.713400E-03,1.202500E-02,4.935000E-02,5.145700E-01,&
     & 2.832200E+00,5.989700E+00,1.407400E+01,4.245600E+01,3.223200E+02,&
     & 3.137200E+03,9.348700E+03,2.458900E-06,8.282500E-06,3.350700E-05,&
     & 1.764700E-04,8.140700E-04,2.621600E-03,8.380800E-03,3.437700E-02,&
     & 3.542300E-01,1.964200E+00,4.190500E+00,1.006900E+01,3.016600E+01,&
     & 2.184700E+02,2.091500E+03,6.231800E+03,2.252100E-06,7.355500E-06,&
     & 2.661200E-05,1.178500E-04,4.645000E-04,1.439200E-03,4.504300E-03,&
     & 1.848100E-02,1.869100E-01,1.031600E+00,2.215300E+00,5.465900E+00,&
     & 1.696700E+01,1.183400E+02,1.045700E+03,3.115900E+03,9.195300E-07,&
     & 1.986200E-06,3.987200E-06,7.431000E-06,1.358100E-05,3.125600E-05,&
     & 7.829300E-05,2.883400E-04,2.927300E-03,1.529200E-02,2.996300E-02,&
     & 6.304500E-02,1.468600E-01,1.121300E+00,3.317100E+01,2.541600E+02,&
     & 1.118600E-06,6.637900E-06,4.178900E-05,3.133000E-04,1.789800E-03,&
     & 6.287900E-03,2.067800E-02,8.559500E-02,8.781900E-01,4.747400E+00,&
     & 1.002900E+01,2.399100E+01,7.475100E+01,5.652200E+02,5.095500E+03,&
     & 1.491000E+04,3.075900E-06,1.177200E-05,5.477400E-05,3.232700E-04,&
     & 1.544700E-03,5.132100E-03,1.654000E-02,6.834300E-02,7.056600E-01,&
     & 3.847700E+00,8.038900E+00,1.895500E+01,5.752200E+01,4.242200E+02,&
     & 3.821800E+03,1.118100E+04,3.337400E-06,1.199800E-05,5.011800E-05,&
     & 2.576800E-04,1.119200E-03,3.614900E-03,1.152200E-02,4.751300E-02,&
     & 4.857600E-01,2.674900E+00,5.642600E+00,1.358600E+01,4.062700E+01,&
     & 2.871300E+02,2.547700E+03,7.455100E+03,3.017000E-06,1.038600E-05,&
     & 3.864400E-05,1.671700E-04,6.335400E-04,1.973900E-03,6.184900E-03,&
     & 2.547400E-02,2.561200E-01,1.405700E+00,2.989800E+00,7.427500E+00,&
     & 2.282800E+01,1.545300E+02,1.273900E+03,3.727200E+03,1.107500E-06,&
     & 2.438800E-06,4.924400E-06,9.119900E-06,1.672900E-05,3.873400E-05,&
     & 9.725200E-05,3.569300E-04,3.848200E-03,1.982900E-02,3.722000E-02,&
     & 7.470200E-02,1.974500E-01,1.676000E+00,4.193800E+01,3.143600E+02,&
     & 1.539200E-06,1.012400E-05,6.592000E-05,4.658000E-04,2.418700E-03,&
     & 8.490000E-03,2.796400E-02,1.162700E-01,1.178100E+00,6.356300E+00,&
     & 1.314400E+01,3.198500E+01,9.912600E+01,7.233200E+02,6.065100E+03,&
     & 1.737700E+04,4.159000E-06,1.708700E-05,8.196300E-05,4.626200E-04,&
     & 2.071400E-03,6.922700E-03,2.236400E-02,9.274400E-02,9.475500E-01,&
     & 5.135100E+00,1.053400E+01,2.516000E+01,7.600100E+01,5.428100E+02,&
     & 4.549000E+03,1.303300E+04,4.497200E-06,1.706800E-05,7.297400E-05,&
     & 3.618100E-04,1.494700E-03,4.866700E-03,1.557200E-02,6.438700E-02,&
     & 6.525500E-01,3.575400E+00,7.430900E+00,1.804800E+01,5.344600E+01,&
     & 3.667300E+02,3.032700E+03,8.689300E+03,4.008500E-06,1.439500E-05,&
     & 5.461000E-05,2.291900E-04,8.418700E-04,2.648200E-03,8.348600E-03,&
     & 3.448100E-02,3.439500E-01,1.877400E+00,3.955900E+00,9.928100E+00,&
     & 3.000300E+01,1.962100E+02,1.516300E+03,4.344200E+03,1.310900E-06,&
     & 2.944800E-06,5.979400E-06,1.105000E-05,2.020500E-05,4.668200E-05,&
     & 1.192600E-04,4.370700E-04,4.950700E-03,2.492500E-02,4.641600E-02,&
     & 8.909500E-02,2.583000E-01,2.434400E+00,5.195700E+01,3.794200E+02,&
     & 2.123200E-06,1.507000E-05,9.982500E-05,6.621200E-04,3.176200E-03,&
     & 1.118300E-02,3.722500E-02,1.556200E-01,1.551300E+00,8.333300E+00,&
     & 1.699900E+01,4.188900E+01,1.288800E+02,9.033800E+02,7.070800E+03,&
     & 1.981700E+04,5.543300E-06,2.426600E-05,1.189200E-04,6.385900E-04,&
     & 2.705700E-03,9.117200E-03,2.976400E-02,1.241100E-01,1.249800E+00,&
     & 6.718200E+00,1.358500E+01,3.282400E+01,9.852700E+01,6.777700E+02,&
     & 5.302900E+03,1.486200E+04,5.987200E-06,2.381200E-05,1.033900E-04,&
     & 4.919000E-04,1.944900E-03,6.401700E-03,2.071900E-02,8.602500E-02,&
     & 8.613200E-01,4.687200E+00,9.621700E+00,2.355500E+01,6.905600E+01,&
     & 4.571100E+02,3.535400E+03,9.908800E+03,5.269700E-06,1.954300E-05,&
     & 7.525400E-05,3.057600E-04,1.090200E-03,3.476100E-03,1.109200E-02,&
     & 4.600700E-02,4.540400E-01,2.461000E+00,5.149000E+00,1.303100E+01,&
     & 3.864300E+01,2.433400E+02,1.767800E+03,4.953100E+03,1.531800E-06,&
     & 3.528700E-06,7.102100E-06,1.328000E-05,2.403800E-05,5.559200E-05,&
     & 1.438600E-04,5.296500E-04,6.267900E-03,3.051300E-02,5.548600E-02,&
     & 1.065600E-01,3.327800E-01,3.473500E+00,6.324400E+01,4.481500E+02/
      data   absb(:,621:640) /                                          &
     & 2.897100E-06,2.176700E-05,1.454300E-04,9.067200E-04,4.070100E-03,&
     & 1.435200E-02,4.877900E-02,2.051400E-01,2.011700E+00,1.070500E+01,&
     & 2.174100E+01,5.398800E+01,1.645300E+02,1.103400E+03,8.093700E+03,&
     & 2.221200E+04,7.254900E-06,3.365300E-05,1.673100E-04,8.547200E-04,&
     & 3.450400E-03,1.171900E-02,3.901300E-02,1.635700E-01,1.622700E+00,&
     & 8.609400E+00,1.732700E+01,4.216200E+01,1.254100E+02,8.276400E+02,&
     & 6.070800E+03,1.666000E+04,7.852000E-06,3.245000E-05,1.427300E-04,&
     & 6.502700E-04,2.474100E-03,8.220900E-03,2.714300E-02,1.132400E-01,&
     & 1.120100E+00,6.014300E+00,1.232200E+01,3.020500E+01,8.768500E+01,&
     & 5.572500E+02,4.047000E+03,1.110700E+04,6.821600E-06,2.602400E-05,&
     & 1.013500E-04,3.979600E-04,1.383600E-03,4.454900E-03,1.451300E-02,&
     & 6.046100E-02,5.904200E-01,3.166400E+00,6.615200E+00,1.681500E+01,&
     & 4.891800E+01,2.953400E+02,2.023500E+03,5.553100E+03,1.772000E-06,&
     & 4.187900E-06,8.299300E-06,1.571900E-05,2.836500E-05,6.550300E-05,&
     & 1.712700E-04,6.331500E-04,7.768800E-03,3.683400E-02,6.581600E-02,&
     & 1.314900E-01,4.126000E-01,4.851000E+00,7.591400E+01,5.197000E+02,&
     & 6.610000E-07,3.335700E-06,1.951000E-05,1.561000E-04,1.010200E-03,&
     & 3.639200E-03,1.219400E-02,5.088100E-02,5.450700E-01,3.028800E+00,&
     & 6.556600E+00,1.567100E+01,4.985900E+01,4.035500E+02,4.136700E+03,&
     & 1.245500E+04,1.783400E-06,6.196300E-06,2.749900E-05,1.691300E-04,&
     & 8.855900E-04,2.980100E-03,9.777200E-03,4.067800E-02,4.388500E-01,&
     & 2.461900E+00,5.301400E+00,1.249100E+01,3.858600E+01,3.031400E+02,&
     & 3.102300E+03,9.342100E+03,1.937100E-06,6.460300E-06,2.604800E-05,&
     & 1.382300E-04,6.474100E-04,2.105000E-03,6.815400E-03,2.835600E-02,&
     & 3.019700E-01,1.708400E+00,3.705700E+00,8.946200E+00,2.755000E+01,&
     & 2.057800E+02,2.068300E+03,6.227700E+03,1.776300E-06,5.749900E-06,&
     & 2.077400E-05,9.264500E-05,3.694700E-04,1.156200E-03,3.663000E-03,&
     & 1.524700E-02,1.593400E-01,8.967400E-01,1.957900E+00,4.848900E+00,&
     & 1.554700E+01,1.119500E+02,1.034200E+03,3.113900E+03,7.122500E-07,&
     & 1.540200E-06,3.072600E-06,5.671600E-06,1.041200E-05,2.409000E-05,&
     & 6.072100E-05,2.260300E-04,2.391500E-03,1.271500E-02,2.535600E-02,&
     & 5.406700E-02,1.239600E-01,1.008800E+00,3.206100E+01,2.484300E+02,&
     & 8.849900E-07,5.157800E-06,3.225200E-05,2.446700E-04,1.424900E-03,&
     & 5.065800E-03,1.689200E-02,7.111500E-02,7.543500E-01,4.160800E+00,&
     & 8.915100E+00,2.138700E+01,6.873800E+01,5.366000E+02,5.055200E+03,&
     & 1.494400E+04,2.425500E-06,9.186300E-06,4.262300E-05,2.539800E-04,&
     & 1.232700E-03,4.141600E-03,1.354000E-02,5.687300E-02,6.077200E-01,&
     & 3.383400E+00,7.184100E+00,1.697400E+01,5.303200E+01,4.028600E+02,&
     & 3.791300E+03,1.120800E+04,2.630700E-06,9.381900E-06,3.914600E-05,&
     & 2.029500E-04,8.931900E-04,2.919400E-03,9.434900E-03,3.954800E-02,&
     & 4.182600E-01,2.351500E+00,5.040000E+00,1.218400E+01,3.761200E+01,&
     & 2.729600E+02,2.527500E+03,7.471500E+03,2.379300E-06,8.143400E-06,&
     & 3.029100E-05,1.320600E-04,5.058400E-04,1.594600E-03,5.065500E-03,&
     & 2.121100E-02,2.205300E-01,1.235300E+00,2.665600E+00,6.660400E+00,&
     & 2.120000E+01,1.474200E+02,1.263800E+03,3.735600E+03,8.630200E-07,&
     & 1.894500E-06,3.810200E-06,6.981100E-06,1.290100E-05,2.986800E-05,&
     & 7.593100E-05,2.805400E-04,3.163800E-03,1.655500E-02,3.189100E-02,&
     & 6.550900E-02,1.672000E-01,1.528100E+00,4.066800E+01,3.083700E+02,&
     & 1.215500E-06,7.890100E-06,5.118700E-05,3.659100E-04,1.931800E-03,&
     & 6.871100E-03,2.299300E-02,9.749000E-02,1.021100E+00,5.634600E+00,&
     & 1.177800E+01,2.878500E+01,9.237300E+01,6.924500E+02,6.033100E+03,&
     & 1.745800E+04,3.284800E-06,1.338000E-05,6.409700E-05,3.654100E-04,&
     & 1.657900E-03,5.610700E-03,1.842700E-02,7.789600E-02,8.232300E-01,&
     & 4.572100E+00,9.468900E+00,2.275600E+01,7.099900E+01,5.197300E+02,&
     & 4.525000E+03,1.309300E+04,3.550300E-06,1.338900E-05,5.722300E-05,&
     & 2.863300E-04,1.196700E-03,3.945400E-03,1.283400E-02,5.410300E-02,&
     & 5.669500E-01,3.180700E+00,6.676800E+00,1.637300E+01,5.005300E+01,&
     & 3.515200E+02,3.016800E+03,8.728900E+03,3.167500E-06,1.132100E-05,&
     & 4.297000E-05,1.817500E-04,6.743400E-04,2.148100E-03,6.882500E-03,&
     & 2.895900E-02,2.988300E-01,1.668800E+00,3.548800E+00,9.014600E+00,&
     & 2.817000E+01,1.885800E+02,1.508300E+03,4.364600E+03,1.026700E-06,&
     & 2.292000E-06,4.639000E-06,8.464500E-06,1.567200E-05,3.607200E-05,&
     & 9.348000E-05,3.439900E-04,4.090300E-03,2.125300E-02,3.970900E-02,&
     & 7.756800E-02,2.237000E-01,2.240700E+00,5.054200E+01,3.732600E+02/
      data   absb(:,641:660) /                                          &
     & 1.677900E-06,1.179100E-05,7.800400E-05,5.230200E-04,2.543400E-03,&
     & 9.073100E-03,3.080400E-02,1.315700E-01,1.355700E+00,7.463900E+00,&
     & 1.533300E+01,3.811700E+01,1.213000E+02,8.711300E+02,7.050300E+03,&
     & 1.994500E+04,4.388500E-06,1.906600E-05,9.343000E-05,5.067100E-04,&
     & 2.171400E-03,7.412700E-03,2.468600E-02,1.050600E-01,1.095000E+00,&
     & 6.037000E+00,1.230400E+01,2.999600E+01,9.291800E+01,6.536000E+02,&
     & 5.287400E+03,1.495900E+04,4.736400E-06,1.873900E-05,8.142100E-05,&
     & 3.907700E-04,1.561600E-03,5.206600E-03,1.719200E-02,7.284900E-02,&
     & 7.547600E-01,4.209200E+00,8.712200E+00,2.160100E+01,6.527900E+01,&
     & 4.411700E+02,3.525200E+03,9.972000E+03,4.172100E-06,1.541800E-05,&
     & 5.943700E-05,2.433100E-04,8.756200E-04,2.828100E-03,9.206500E-03,&
     & 3.894500E-02,3.979900E-01,2.209000E+00,4.654200E+00,1.196700E+01,&
     & 3.662600E+01,2.353500E+02,1.762600E+03,4.986600E+03,1.204100E-06,&
     & 2.752100E-06,5.509900E-06,1.016000E-05,1.879500E-05,4.314000E-05,&
     & 1.131200E-04,4.186000E-04,5.207700E-03,2.621500E-02,4.736000E-02,&
     & 9.407100E-02,2.870400E-01,3.232400E+00,6.167000E+01,4.419800E+02,&
     & 2.293800E-06,1.710100E-05,1.142400E-04,7.195300E-04,3.268300E-03,&
     & 1.166300E-02,4.062600E-02,1.748300E-01,1.773000E+00,9.672300E+00,&
     & 1.976200E+01,4.966700E+01,1.562700E+02,1.070300E+03,8.088600E+03,&
     & 2.239100E+04,5.757800E-06,2.653700E-05,1.320700E-04,6.807100E-04,&
     & 2.776500E-03,9.541800E-03,3.256900E-02,1.396600E-01,1.434500E+00,&
     & 7.805400E+00,1.581200E+01,3.892100E+01,1.193000E+02,8.029100E+02,&
     & 6.066200E+03,1.679200E+04,6.225600E-06,2.562900E-05,1.128600E-04,&
     & 5.184100E-04,1.992300E-03,6.695400E-03,2.267300E-02,9.675800E-02,&
     & 9.901700E-01,5.449800E+00,1.124400E+01,2.799500E+01,8.354700E+01,&
     & 5.409200E+02,4.044100E+03,1.119500E+04,5.412900E-06,2.059100E-05,&
     & 8.030500E-05,3.177100E-04,1.114200E-03,3.631000E-03,1.212700E-02,&
     & 5.164500E-02,5.220300E-01,2.866900E+00,6.031900E+00,1.561000E+01,&
     & 4.673900E+01,2.871400E+02,2.022000E+03,5.597400E+03,1.394100E-06,&
     & 3.278800E-06,6.458000E-06,1.208700E-05,2.214500E-05,5.113900E-05,&
     & 1.348100E-04,5.036500E-04,6.500400E-03,3.167300E-02,5.665000E-02,&
     & 1.146900E-01,3.618000E-01,4.552600E+00,7.417500E+01,5.134900E+02,&
     & 5.262200E-07,2.592500E-06,1.495500E-05,1.209600E-04,7.994600E-04,&
     & 2.911800E-03,9.886300E-03,4.187200E-02,4.635300E-01,2.634600E+00,&
     & 5.781500E+00,1.390100E+01,4.530200E+01,3.804800E+02,4.083600E+03,&
     & 1.240600E+04,1.407400E-06,4.822100E-06,2.128200E-05,1.319900E-04,&
     & 7.029800E-04,2.388600E-03,7.938500E-03,3.354800E-02,3.740600E-01,&
     & 2.150100E+00,4.698700E+00,1.113700E+01,3.517100E+01,2.859500E+02,&
     & 3.062500E+03,9.307600E+03,1.526800E-06,5.037700E-06,2.023700E-05,&
     & 1.081500E-04,5.141600E-04,1.688200E-03,5.533600E-03,2.339800E-02,&
     & 2.575400E-01,1.489700E+00,3.283900E+00,7.984600E+00,2.523600E+01,&
     & 1.943300E+02,2.041800E+03,6.203500E+03,1.401300E-06,4.492800E-06,&
     & 1.620800E-05,7.273600E-05,2.936800E-04,9.275500E-04,2.975300E-03,&
     & 1.257600E-02,1.358800E-01,7.817900E-01,1.733600E+00,4.319500E+00,&
     & 1.428600E+01,1.061400E+02,1.020800E+03,3.102400E+03,5.482100E-07,&
     & 1.189600E-06,2.341400E-06,4.313200E-06,7.972000E-06,1.839100E-05,&
     & 4.682900E-05,1.761400E-04,1.934300E-03,1.049400E-02,2.136100E-02,&
     & 4.618300E-02,1.056800E-01,9.124200E-01,3.097300E+01,2.423900E+02,&
     & 7.006900E-07,4.008000E-06,2.486700E-05,1.908600E-04,1.133300E-03,&
     & 4.075000E-03,1.378200E-02,5.909400E-02,6.481200E-01,3.662300E+00,&
     & 7.940300E+00,1.915000E+01,6.339100E+01,5.106700E+02,5.006800E+03,&
     & 1.493400E+04,1.913000E-06,7.165700E-06,3.314400E-05,1.993700E-04,&
     & 9.829000E-04,3.338100E-03,1.106800E-02,4.731600E-02,5.236000E-01,&
     & 2.986800E+00,6.430200E+00,1.527000E+01,4.904100E+01,3.834800E+02,&
     & 3.754900E+03,1.120000E+04,2.073700E-06,7.333900E-06,3.054700E-05,&
     & 1.597000E-04,7.125500E-04,2.354000E-03,7.713500E-03,3.292400E-02,&
     & 3.603900E-01,2.074800E+00,4.510900E+00,1.097600E+01,3.492300E+01,&
     & 2.601000E+02,2.503400E+03,7.467200E+03,1.876500E-06,6.382200E-06,&
     & 2.372400E-05,1.042600E-04,4.035300E-04,1.286300E-03,4.142600E-03,&
     & 1.766200E-02,1.900200E-01,1.090000E+00,2.384800E+00,5.990500E+00,&
     & 1.975100E+01,1.408900E+02,1.251600E+03,3.733700E+03,6.683200E-07,&
     & 1.463600E-06,2.929800E-06,5.318100E-06,9.922300E-06,2.280600E-05,&
     & 5.890300E-05,2.195200E-04,2.584700E-03,1.380100E-02,2.690900E-02,&
     & 5.609300E-02,1.424900E-01,1.402500E+00,3.942300E+01,3.019300E+02/
      data   absb(:,661:680) /                                          &
     & 9.602900E-07,6.148000E-06,3.971800E-05,2.872000E-04,1.541800E-03,&
     & 5.551300E-03,1.888400E-02,8.181400E-02,8.860700E-01,5.014900E+00,&
     & 1.058900E+01,2.601000E+01,8.632300E+01,6.645100E+02,5.991700E+03,&
     & 1.749200E+04,2.594200E-06,1.047100E-05,5.009200E-05,2.884400E-04,&
     & 1.325900E-03,4.542000E-03,1.516300E-02,6.545800E-02,7.166500E-01,&
     & 4.081900E+00,8.548600E+00,2.065300E+01,6.650700E+01,4.988000E+02,&
     & 4.493400E+03,1.311800E+04,2.802300E-06,1.049800E-05,4.484800E-05,&
     & 2.264100E-04,9.573900E-04,3.194800E-03,1.056800E-02,4.546800E-02,&
     & 4.936500E-01,2.837600E+00,6.023200E+00,1.489700E+01,4.704000E+01,&
     & 3.375900E+02,2.995900E+03,8.745600E+03,2.502400E-06,8.899800E-06,&
     & 3.379200E-05,1.440500E-04,5.397000E-04,1.739700E-03,5.669200E-03,&
     & 2.434300E-02,2.601300E-01,1.488900E+00,3.196600E+00,8.208600E+00,&
     & 2.653300E+01,1.815900E+02,1.497900E+03,4.372500E+03,8.007300E-07,&
     & 1.775700E-06,3.559700E-06,6.456600E-06,1.214100E-05,2.768200E-05,&
     & 7.275800E-05,2.700500E-04,3.363000E-03,1.794800E-02,3.327400E-02,&
     & 6.765600E-02,1.930300E-01,2.076500E+00,4.914000E+01,3.665000E+02,&
     & 1.325900E-06,9.222400E-06,6.090200E-05,4.128600E-04,2.035500E-03,&
     & 7.349200E-03,2.547200E-02,1.112900E-01,1.187700E+00,6.707400E+00,&
     & 1.389000E+01,3.480900E+01,1.145700E+02,8.414100E+02,7.019000E+03,&
     & 2.002800E+04,3.473700E-06,1.497500E-05,7.336500E-05,4.018000E-04,&
     & 1.741800E-03,6.017900E-03,2.045900E-02,8.902600E-02,9.619900E-01,&
     & 5.443200E+00,1.118800E+01,2.751100E+01,8.791400E+01,6.314000E+02,&
     & 5.264600E+03,1.502200E+04,3.746400E-06,1.474000E-05,6.408000E-05,&
     & 3.102000E-04,1.253300E-03,4.228500E-03,1.425200E-02,6.177600E-02,&
     & 6.633800E-01,3.790600E+00,7.919100E+00,1.987200E+01,6.189900E+01,&
     & 4.263800E+02,3.509600E+03,1.001300E+04,3.302200E-06,1.215900E-05,&
     & 4.691300E-05,1.935000E-04,7.030300E-04,2.297900E-03,7.632900E-03,&
     & 3.303100E-02,3.498600E-01,1.988300E+00,4.224400E+00,1.102600E+01,&
     & 3.482400E+01,2.279200E+02,1.754800E+03,5.007200E+03,9.384100E-07,&
     & 2.140700E-06,4.266500E-06,7.729600E-06,1.459100E-05,3.335200E-05,&
     & 8.828000E-05,3.303000E-04,4.296300E-03,2.219000E-02,4.039000E-02,&
     & 8.164900E-02,2.486800E-01,3.022900E+00,6.011000E+01,4.351200E+02,&
     & 1.816200E-06,1.343000E-05,8.967300E-05,5.706300E-04,2.623300E-03,&
     & 9.466700E-03,3.379300E-02,1.492200E-01,1.567100E+00,8.767500E+00,&
     & 1.803200E+01,4.584800E+01,1.488700E+02,1.039600E+03,8.070300E+03,&
     & 2.251200E+04,4.569100E-06,2.091900E-05,1.041600E-04,5.419100E-04,&
     & 2.233200E-03,7.761600E-03,2.715900E-02,1.194400E-01,1.271200E+00,&
     & 7.101900E+00,1.448700E+01,3.605200E+01,1.138300E+02,7.799200E+02,&
     & 6.052600E+03,1.688500E+04,4.935400E-06,2.023200E-05,8.916300E-05,&
     & 4.131700E-04,1.602700E-03,5.448500E-03,1.891200E-02,8.278400E-02,&
     & 8.776100E-01,4.957200E+00,1.029700E+01,2.603900E+01,7.984700E+01,&
     & 5.257100E+02,4.035200E+03,1.125700E+04,4.294400E-06,1.628600E-05,&
     & 6.359200E-05,2.535500E-04,8.967300E-04,2.956000E-03,1.012300E-02,&
     & 4.413200E-02,4.628600E-01,2.605400E+00,5.520100E+00,1.453700E+01,&
     & 4.477900E+01,2.794700E+02,2.017600E+03,5.628000E+03,1.089600E-06,&
     & 2.551700E-06,5.000300E-06,9.208300E-06,1.727800E-05,3.965100E-05,&
     & 1.054900E-04,4.003000E-04,5.383900E-03,2.696100E-02,4.882400E-02,&
     & 9.974700E-02,3.141600E-01,4.295200E+00,7.244200E+01,5.067100E+02,&
     & 4.127100E-07,1.950300E-06,1.097300E-05,9.012000E-05,6.155800E-04,&
     & 2.271200E-03,7.818300E-03,3.364700E-02,3.844800E-01,2.241400E+00,&
     & 4.966300E+00,1.208100E+01,4.017700E+01,3.513300E+02,3.973100E+03,&
     & 1.219100E+04,1.084200E-06,3.625600E-06,1.583400E-05,9.940500E-05,&
     & 5.433900E-04,1.865800E-03,6.287200E-03,2.699600E-02,3.110700E-01,&
     & 1.831200E+00,4.058000E+00,9.724300E+00,3.129800E+01,2.641500E+02,&
     & 2.980000E+03,9.142800E+03,1.173600E-06,3.798300E-06,1.514100E-05,&
     & 8.177400E-05,3.979900E-04,1.319200E-03,4.384000E-03,1.883000E-02,&
     & 2.141000E-01,1.266900E+00,2.836800E+00,6.973300E+00,2.256500E+01,&
     & 1.797000E+02,1.986500E+03,6.095500E+03,1.077700E-06,3.398300E-06,&
     & 1.220700E-05,5.534800E-05,2.276100E-04,7.247900E-04,2.358300E-03,&
     & 1.012300E-02,1.129700E-01,6.646400E-01,1.496100E+00,3.765300E+00,&
     & 1.280500E+01,9.849500E+01,9.932700E+02,3.047600E+03,4.178700E-07,&
     & 9.097000E-07,1.769500E-06,3.280200E-06,6.067900E-06,1.399500E-05,&
     & 3.593400E-05,1.366400E-04,1.556800E-03,8.603300E-03,1.797700E-02,&
     & 3.958100E-02,8.813800E-02,7.836600E-01,2.911900E+01,2.303100E+02/
      data   absb(:,681:700) /                                          &
     & 5.438900E-07,3.009600E-06,1.841700E-05,1.439600E-04,8.810000E-04,&
     & 3.204000E-03,1.100200E-02,4.807700E-02,5.450100E-01,3.146100E+00,&
     & 6.926900E+00,1.683800E+01,5.719900E+01,4.777100E+02,4.901000E+03,&
     & 1.476800E+04,1.470900E-06,5.407200E-06,2.485100E-05,1.517200E-04,&
     & 7.663800E-04,2.628800E-03,8.845600E-03,3.853500E-02,4.412600E-01,&
     & 2.573100E+00,5.639100E+00,1.348400E+01,4.437600E+01,3.588000E+02,&
     & 3.676000E+03,1.107600E+04,1.592600E-06,5.550900E-06,2.303700E-05,&
     & 1.219900E-04,5.562300E-04,1.854900E-03,6.166500E-03,2.683600E-02,&
     & 3.038000E-01,1.785500E+00,3.954000E+00,9.695300E+00,3.174300E+01,&
     & 2.435600E+02,2.450500E+03,7.384000E+03,1.442100E-06,4.850900E-06,&
     & 1.799200E-05,8.008100E-05,3.150700E-04,1.014000E-03,3.312900E-03,&
     & 1.439400E-02,1.600900E-01,9.382600E-01,2.089400E+00,5.280100E+00,&
     & 1.800600E+01,1.322700E+02,1.225200E+03,3.692000E+03,5.101700E-07,&
     & 1.129500E-06,2.230400E-06,4.045000E-06,7.610400E-06,1.745500E-05,&
     & 4.550500E-05,1.711500E-04,2.104200E-03,1.142500E-02,2.294900E-02,&
     & 4.856800E-02,1.185600E-01,1.227600E+00,3.728400E+01,2.887900E+02,&
     & 7.418800E-07,4.634100E-06,2.971800E-05,2.189700E-04,1.207200E-03,&
     & 4.398500E-03,1.520400E-02,6.735600E-02,7.540300E-01,4.364500E+00,&
     & 9.357800E+00,2.310400E+01,7.915000E+01,6.281700E+02,5.896700E+03,&
     & 1.739100E+04,1.998200E-06,7.943600E-06,3.786700E-05,2.217200E-04,&
     & 1.040400E-03,3.605000E-03,1.222400E-02,5.394800E-02,6.113200E-01,&
     & 3.563900E+00,7.589100E+00,1.842500E+01,6.113500E+01,4.716300E+02,&
     & 4.422600E+03,1.304400E+04,2.156100E-06,7.988100E-06,3.406500E-05,&
     & 1.745300E-04,7.513600E-04,2.537200E-03,8.520100E-03,3.749800E-02,&
     & 4.209800E-01,2.477200E+00,5.345200E+00,1.330200E+01,4.339800E+01,&
     & 3.193700E+02,2.948200E+03,8.695900E+03,1.928400E-06,6.797400E-06,&
     & 2.581000E-05,1.115000E-04,4.237300E-04,1.381300E-03,4.572700E-03,&
     & 2.006300E-02,2.218000E-01,1.300100E+00,2.832700E+00,7.321800E+00,&
     & 2.454000E+01,1.720900E+02,1.474200E+03,4.348300E+03,6.157500E-07,&
     & 1.374900E-06,2.732500E-06,4.939100E-06,9.344400E-06,2.129500E-05,&
     & 5.660300E-05,2.119400E-04,2.749400E-03,1.515000E-02,2.835000E-02,&
     & 5.895500E-02,1.635900E-01,1.843400E+00,4.670600E+01,3.525300E+02,&
     & 1.024200E-06,6.995900E-06,4.605000E-05,3.181800E-04,1.602900E-03,&
     & 5.856500E-03,2.066700E-02,9.261200E-02,1.022000E+00,5.919500E+00,&
     & 1.240700E+01,3.127300E+01,1.065100E+02,8.027700E+02,6.940100E+03,&
     & 2.000100E+04,2.685400E-06,1.142900E-05,5.592700E-05,3.114800E-04,&
     & 1.374200E-03,4.801300E-03,1.663900E-02,7.416100E-02,8.299500E-01,&
     & 4.819600E+00,1.002800E+01,2.481800E+01,8.189000E+01,6.024100E+02,&
     & 5.204900E+03,1.500100E+04,2.892400E-06,1.127800E-05,4.902400E-05,&
     & 2.409600E-04,9.894400E-04,3.375300E-03,1.159600E-02,5.147300E-02,&
     & 5.721500E-01,3.356100E+00,7.089400E+00,1.796700E+01,5.778600E+01,&
     & 4.071100E+02,3.470100E+03,1.000100E+04,2.552900E-06,9.339000E-06,&
     & 3.606500E-05,1.507500E-04,5.550100E-04,1.834200E-03,6.214800E-03,&
     & 2.751400E-02,3.016500E-01,1.760300E+00,3.774400E+00,9.975700E+00,&
     & 3.257600E+01,2.178800E+02,1.735000E+03,5.000700E+03,7.261300E-07,&
     & 1.656000E-06,3.283600E-06,5.926000E-06,1.131800E-05,2.575600E-05,&
     & 6.892200E-05,2.601700E-04,3.544300E-03,1.898400E-02,3.439900E-02,&
     & 7.085900E-02,2.142100E-01,2.712300E+00,5.738300E+01,4.205500E+02,&
     & 1.406700E-06,1.026200E-05,6.846200E-05,4.433800E-04,2.076200E-03,&
     & 7.577600E-03,2.765600E-02,1.253400E-01,1.362700E+00,7.834400E+00,&
     & 1.624000E+01,4.171100E+01,1.398500E+02,9.997800E+02,8.013400E+03,&
     & 2.255900E+04,3.547600E-06,1.606100E-05,8.002200E-05,4.229900E-04,&
     & 1.771000E-03,6.221900E-03,2.228000E-02,1.004000E-01,1.108000E+00,&
     & 6.366200E+00,1.309100E+01,3.292000E+01,1.071000E+02,7.501100E+02,&
     & 6.009600E+03,1.691900E+04,3.824900E-06,1.557500E-05,6.868400E-05,&
     & 3.230400E-04,1.271100E-03,4.368500E-03,1.552100E-02,6.962300E-02,&
     & 7.649200E-01,4.440900E+00,9.299100E+00,2.384800E+01,7.525500E+01,&
     & 5.057700E+02,4.006600E+03,1.128100E+04,3.333100E-06,1.257300E-05,&
     & 4.917900E-05,1.986900E-04,7.113400E-04,2.369900E-03,8.310200E-03,&
     & 3.714800E-02,4.034800E-01,2.332400E+00,4.978700E+00,1.331900E+01,&
     & 4.228200E+01,2.691100E+02,2.003300E+03,5.640400E+03,8.461000E-07,&
     & 1.976500E-06,3.878000E-06,7.042900E-06,1.349700E-05,3.071500E-05,&
     & 8.277900E-05,3.169400E-04,4.464300E-03,2.328600E-02,4.202700E-02,&
     & 8.653900E-02,2.756000E-01,3.891100E+00,6.939500E+01,4.916000E+02/
      data   absb(:,701:720) /                                          &
     & 3.243200E-07,1.464500E-06,7.993600E-06,6.658600E-05,4.715000E-04,&
     & 1.761200E-03,6.150000E-03,2.691900E-02,3.174500E-01,1.900900E+00,&
     & 4.248500E+00,1.048500E+01,3.548300E+01,3.234200E+02,3.850300E+03,&
     & 1.191800E+04,8.339200E-07,2.713100E-06,1.170200E-05,7.434400E-05,&
     & 4.178600E-04,1.449200E-03,4.952400E-03,2.162500E-02,2.573300E-01,&
     & 1.558100E+00,3.486200E+00,8.480000E+00,2.774500E+01,2.432400E+02,&
     & 2.887700E+03,8.938100E+03,9.002500E-07,2.849100E-06,1.125000E-05,&
     & 6.139100E-05,3.064100E-04,1.025000E-03,3.453800E-03,1.509100E-02,&
     & 1.771300E-01,1.077200E+00,2.435200E+00,6.078700E+00,2.010400E+01,&
     & 1.656700E+02,1.925200E+03,5.959000E+03,8.265900E-07,2.557100E-06,&
     & 9.132600E-06,4.182600E-05,1.755900E-04,5.632500E-04,1.857900E-03,&
     & 8.107300E-03,9.343600E-02,5.639000E-01,1.284900E+00,3.276900E+00,&
     & 1.143500E+01,9.109400E+01,9.625800E+02,2.979400E+03,3.169900E-07,&
     & 6.945100E-07,1.328900E-06,2.478900E-06,4.607700E-06,1.060400E-05,&
     & 2.749400E-05,1.056900E-04,1.247200E-03,7.014500E-03,1.508800E-02,&
     & 3.360600E-02,7.457800E-02,6.681800E-01,2.722400E+01,2.176600E+02,&
     & 4.221500E-07,2.250200E-06,1.354100E-05,1.078600E-04,6.814700E-04,&
     & 2.508000E-03,8.732600E-03,3.895900E-02,4.563800E-01,2.699700E+00,&
     & 6.016600E+00,1.478600E+01,5.144300E+01,4.457300E+02,4.781500E+03,&
     & 1.454600E+04,1.127700E-06,4.058600E-06,1.851000E-05,1.147100E-04,&
     & 5.948600E-04,2.060800E-03,7.036100E-03,3.125800E-02,3.704200E-01,&
     & 2.209400E+00,4.927100E+00,1.189400E+01,4.003300E+01,3.349300E+02,&
     & 3.586200E+03,1.091000E+04,1.218600E-06,4.179900E-06,1.726100E-05,&
     & 9.262700E-05,4.320900E-04,1.454600E-03,4.903500E-03,2.176900E-02,&
     & 2.549100E-01,1.533400E+00,3.453700E+00,8.557600E+00,2.876600E+01,&
     & 2.274700E+02,2.390800E+03,7.223900E+03,1.104900E-06,3.667400E-06,&
     & 1.356300E-05,6.113400E-05,2.449800E-04,7.955200E-04,2.634900E-03,&
     & 1.167400E-02,1.343600E-01,8.048800E-01,1.824300E+00,4.649300E+00,&
     & 1.635800E+01,1.238200E+02,1.195300E+03,3.636400E+03,3.895900E-07,&
     & 8.666000E-07,1.687600E-06,3.083100E-06,5.813500E-06,1.331000E-05,&
     & 3.503600E-05,1.333500E-04,1.699300E-03,9.500500E-03,1.945300E-02,&
     & 4.145700E-02,1.008000E-01,1.066200E+00,3.510100E+01,2.747300E+02,&
     & 5.720300E-07,3.475000E-06,2.208500E-05,1.658800E-04,9.421300E-04,&
     & 3.468100E-03,1.218200E-02,5.522700E-02,6.398200E-01,3.788500E+00,&
     & 8.248500E+00,2.053000E+01,7.235300E+01,5.925200E+02,5.787200E+03,&
     & 1.723700E+04,1.533500E-06,5.993100E-06,2.845000E-05,1.694300E-04,&
     & 8.137200E-04,2.847700E-03,9.812100E-03,4.430400E-02,5.197200E-01,&
     & 3.103500E+00,6.722100E+00,1.643700E+01,5.602400E+01,4.448800E+02,&
     & 4.340100E+03,1.292700E+04,1.653000E-06,6.046500E-06,2.572800E-05,&
     & 1.338300E-04,5.878000E-04,2.005100E-03,6.836400E-03,3.081000E-02,&
     & 3.578400E-01,2.156700E+00,4.732100E+00,1.187100E+01,3.992800E+01,&
     & 3.014500E+02,2.893500E+03,8.618700E+03,1.480800E-06,5.165400E-06,&
     & 1.960600E-05,8.589900E-05,3.314500E-04,1.092300E-03,3.670400E-03,&
     & 1.648500E-02,1.885100E-01,1.132000E+00,2.506000E+00,6.521800E+00,&
     & 2.264400E+01,1.626900E+02,1.446700E+03,4.309200E+03,4.722900E-07,&
     & 1.060200E-06,2.089600E-06,3.771200E-06,7.171500E-06,1.634900E-05,&
     & 4.390000E-05,1.662000E-04,2.239300E-03,1.266500E-02,2.419800E-02,&
     & 5.084200E-02,1.379800E-01,1.631000E+00,4.419700E+01,3.342100E+02,&
     & 7.889200E-07,5.279200E-06,3.459900E-05,2.438300E-04,1.258200E-03,&
     & 4.650100E-03,1.669800E-02,7.681900E-02,8.776300E-01,5.208300E+00,&
     & 1.106600E+01,2.809300E+01,9.882100E+01,7.644700E+02,6.845800E+03,&
     & 1.992500E+04,2.068200E-06,8.677400E-06,4.239300E-05,2.403700E-04,&
     & 1.080900E-03,3.818800E-03,1.347000E-02,6.160900E-02,7.139700E-01,&
     & 4.258700E+00,8.979100E+00,2.237400E+01,7.612400E+01,5.736900E+02,&
     & 5.134100E+03,1.494200E+04,2.225100E-06,8.585000E-06,3.731000E-05,&
     & 1.864500E-04,7.784400E-04,2.684500E-03,9.390100E-03,4.277000E-02,&
     & 4.923200E-01,2.963200E+00,6.345900E+00,1.622300E+01,5.386200E+01,&
     & 3.878700E+02,3.422500E+03,9.961300E+03,1.966300E-06,7.139600E-06,&
     & 2.759100E-05,1.170000E-04,4.368500E-04,1.458800E-03,5.036000E-03,&
     & 2.284300E-02,2.594800E-01,1.555200E+00,3.373400E+00,9.006800E+00,&
     & 3.041400E+01,2.078000E+02,1.711500E+03,4.980800E+03,5.601900E-07,&
     & 1.282000E-06,2.514200E-06,4.547800E-06,8.728500E-06,1.985500E-05,&
     & 5.380900E-05,2.048400E-04,2.908600E-03,1.609600E-02,2.957000E-02,&
     & 6.122900E-02,1.839500E-01,2.423100E+00,5.458300E+01,4.046800E+02/
      data   absb(:,721:740) /                                          &
     & 1.086200E-06,7.802400E-06,5.197300E-05,3.430000E-04,1.638800E-03,&
     & 6.049100E-03,2.254100E-02,1.050400E-01,1.182900E+00,6.989900E+00,&
     & 1.463600E+01,3.792100E+01,1.312100E+02,9.600200E+02,7.939600E+03,&
     & 2.256600E+04,2.744700E-06,1.227300E-05,6.116600E-05,3.288900E-04,&
     & 1.401000E-03,4.974100E-03,1.820200E-02,8.429000E-02,9.642000E-01,&
     & 5.695700E+00,1.183400E+01,3.003900E+01,1.006200E+02,7.202700E+02,&
     & 5.954700E+03,1.692500E+04,2.953500E-06,1.193400E-05,5.264900E-05,&
     & 2.516800E-04,1.005500E-03,3.494400E-03,1.268600E-02,5.843900E-02,&
     & 6.656900E-01,3.971500E+00,8.399600E+00,2.181200E+01,7.081700E+01,&
     & 4.858900E+02,3.969900E+03,1.128200E+04,2.577600E-06,9.665300E-06,&
     & 3.785900E-05,1.551400E-04,5.626600E-04,1.895300E-03,6.797800E-03,&
     & 3.117100E-02,3.511400E-01,2.085100E+00,4.488600E+00,1.219000E+01,&
     & 3.985800E+01,2.586900E+02,1.984900E+03,5.640800E+03,6.559100E-07,&
     & 1.528100E-06,2.998500E-06,5.391000E-06,1.046500E-05,2.379300E-05,&
     & 6.478400E-05,2.503100E-04,3.694800E-03,2.000700E-02,3.612800E-02,&
     & 7.528200E-02,2.397100E-01,3.511000E+00,6.625900E+01,4.754600E+02,&
     & 2.558700E-07,1.103000E-06,5.813100E-06,4.899800E-05,3.600900E-04,&
     & 1.361900E-03,4.821600E-03,2.147000E-02,2.614800E-01,1.607300E+00,&
     & 3.634600E+00,9.107900E+00,3.131200E+01,2.974100E+02,3.721800E+03,&
     & 1.161100E+04,6.425300E-07,2.029800E-06,8.628700E-06,5.541900E-05,&
     & 3.203900E-04,1.122500E-03,3.887800E-03,1.728100E-02,2.124400E-01,&
     & 1.321400E+00,2.994800E+00,7.399300E+00,2.458200E+01,2.237500E+02,&
     & 2.791300E+03,8.708800E+03,6.916700E-07,2.135400E-06,8.339500E-06,&
     & 4.594700E-05,2.354000E-04,7.939000E-04,2.712100E-03,1.205800E-02,&
     & 1.462000E-01,9.141000E-01,2.089600E+00,5.302300E+00,1.789800E+01,&
     & 1.525600E+02,1.858100E+03,5.805300E+03,6.342000E-07,1.922000E-06,&
     & 6.818000E-06,3.151600E-05,1.351100E-04,4.365400E-04,1.458500E-03,&
     & 6.478800E-03,7.710600E-02,4.786900E-01,1.101800E+00,2.853400E+00,&
     & 1.020300E+01,8.413000E+01,9.304300E+02,2.902700E+03,2.395200E-07,&
     & 5.276900E-07,9.932100E-07,1.866700E-06,3.481800E-06,7.989200E-06,&
     & 2.093000E-05,8.123800E-05,9.924900E-04,5.665800E-03,1.259900E-02,&
     & 2.807500E-02,6.331100E-02,5.709900E-01,2.539700E+01,2.050500E+02,&
     & 3.286300E-07,1.683000E-06,9.928600E-06,8.048400E-05,5.259100E-04,&
     & 1.958500E-03,6.915100E-03,3.149400E-02,3.815200E-01,2.316600E+00,&
     & 5.224400E+00,1.300500E+01,4.625700E+01,4.154500E+02,4.655200E+03,&
     & 1.428400E+04,8.649700E-07,3.042900E-06,1.375300E-05,8.648100E-05,&
     & 4.607500E-04,1.610900E-03,5.579300E-03,2.531600E-02,3.103600E-01,&
     & 1.901600E+00,4.297400E+00,1.051000E+01,3.610600E+01,3.122400E+02,&
     & 3.491300E+03,1.063900E+04,9.326400E-07,3.143700E-06,1.290300E-05,&
     & 7.010300E-05,3.350500E-04,1.137500E-03,3.888200E-03,1.763100E-02,&
     & 2.136700E-01,1.317500E+00,3.011600E+00,7.561900E+00,2.605900E+01,&
     & 2.121700E+02,2.327500E+03,7.141700E+03,8.464900E-07,2.768000E-06,&
     & 1.020100E-05,4.654400E-05,1.900500E-04,6.224400E-04,2.090200E-03,&
     & 9.452300E-03,1.125800E-01,6.910000E-01,1.591100E+00,4.101900E+00,&
     & 1.485000E+01,1.157600E+02,1.163800E+03,3.570900E+03,2.977500E-07,&
     & 6.599200E-07,1.273900E-06,2.335400E-06,4.417400E-06,1.011100E-05,&
     & 2.686200E-05,1.034400E-04,1.366900E-03,7.808200E-03,1.632300E-02,&
     & 3.544100E-02,8.598700E-02,9.262800E-01,3.298500E+01,2.606600E+02,&
     & 4.416400E-07,2.603100E-06,1.636900E-05,1.253100E-04,7.337700E-04,&
     & 2.728900E-03,9.731700E-03,4.522200E-02,5.421900E-01,3.293500E+00,&
     & 7.264300E+00,1.827700E+01,6.613400E+01,5.585800E+02,5.667600E+03,&
     & 1.703800E+04,1.176100E-06,4.514900E-06,2.132400E-05,1.292300E-04,&
     & 6.353900E-04,2.243700E-03,7.853300E-03,3.633300E-02,4.415200E-01,&
     & 2.704500E+00,5.949900E+00,1.469700E+01,5.132400E+01,4.194400E+02,&
     & 4.251500E+03,1.277800E+04,1.266700E-06,4.568800E-06,1.938700E-05,&
     & 1.023800E-04,4.592700E-04,1.580500E-03,5.474700E-03,2.526200E-02,&
     & 3.041600E-01,1.877300E+00,4.187700E+00,1.061700E+01,3.671100E+01,&
     & 2.843300E+02,2.834200E+03,8.519600E+03,1.136100E-06,3.919200E-06,&
     & 1.486100E-05,6.604400E-05,2.590400E-04,8.612700E-04,2.938800E-03,&
     & 1.352200E-02,1.601700E-01,9.857500E-01,2.217200E+00,5.819000E+00,&
     & 2.087900E+01,1.536700E+02,1.416900E+03,4.259100E+03,3.612000E-07,&
     & 8.146500E-07,1.586200E-06,2.870800E-06,5.479700E-06,1.250000E-05,&
     & 3.389700E-05,1.297700E-04,1.822300E-03,1.048400E-02,2.061900E-02,&
     & 4.308900E-02,1.169600E-01,1.442600E+00,4.177700E+01,3.222800E+02/
      data   absb(:,741:760) /                                          &
     & 6.077400E-07,3.977200E-06,2.591700E-05,1.863300E-04,9.866500E-04,&
     & 3.685200E-03,1.345900E-02,6.364400E-02,7.531000E-01,4.588100E+00,&
     & 9.874700E+00,2.528900E+01,9.164900E+01,7.275900E+02,6.740400E+03,&
     & 1.979900E+04,1.591400E-06,6.576800E-06,3.205800E-05,1.850300E-04,&
     & 8.490000E-04,3.031100E-03,1.087600E-02,5.112800E-02,6.141200E-01,&
     & 3.763900E+00,8.044700E+00,2.022100E+01,7.073900E+01,5.460900E+02,&
     & 5.055200E+03,1.485000E+04,1.710000E-06,6.525200E-06,2.833300E-05,&
     & 1.439700E-04,6.115200E-04,2.131600E-03,7.584400E-03,3.550600E-02,&
     & 4.234500E-01,2.617700E+00,5.685400E+00,1.467000E+01,5.019100E+01,&
     & 3.693300E+02,3.370600E+03,9.899700E+03,1.513100E-06,5.449500E-06,&
     & 2.106400E-05,9.064500E-05,3.433500E-04,1.158300E-03,4.069700E-03,&
     & 1.895100E-02,2.232100E-01,1.373700E+00,3.020600E+00,8.136500E+00,&
     & 2.839600E+01,1.980800E+02,1.685200E+03,4.950200E+03,4.315700E-07,&
     & 9.875000E-07,1.928900E-06,3.460600E-06,6.721900E-06,1.524800E-05,&
     & 4.175900E-05,1.610500E-04,2.376600E-03,1.360100E-02,2.528200E-02,&
     & 5.231700E-02,1.586800E-01,2.165700E+00,5.183300E+01,3.886500E+02,&
     & 8.380200E-07,5.921200E-06,3.935500E-05,2.647600E-04,1.291900E-03,&
     & 4.823500E-03,1.832000E-02,8.797400E-02,1.027200E+00,6.237000E+00,&
     & 1.320600E+01,3.453500E+01,1.231500E+02,9.213100E+02,7.854800E+03,&
     & 2.252500E+04,2.121100E-06,9.360400E-06,4.665200E-05,2.553400E-04,&
     & 1.107100E-03,3.970200E-03,1.483800E-02,7.067100E-02,8.394500E-01,&
     & 5.096700E+00,1.071600E+01,2.745200E+01,9.455000E+01,6.912800E+02,&
     & 5.891100E+03,1.689400E+04,2.278500E-06,9.125300E-06,4.027500E-05,&
     & 1.957800E-04,7.945400E-04,2.789200E-03,1.034300E-02,4.904300E-02,&
     & 5.796000E-01,3.553400E+00,7.600100E+00,1.996900E+01,6.664900E+01,&
     & 4.664800E+02,3.927700E+03,1.126200E+04,1.991200E-06,7.418200E-06,&
     & 2.909900E-05,1.209800E-04,4.445500E-04,1.513400E-03,5.545600E-03,&
     & 2.614300E-02,3.057700E-01,1.865400E+00,4.054400E+00,1.116400E+01,&
     & 3.757000E+01,2.485000E+02,1.963700E+03,5.631100E+03,5.072100E-07,&
     & 1.177600E-06,2.309100E-06,4.108400E-06,8.099600E-06,1.835000E-05,&
     & 5.054000E-05,1.971900E-04,3.046300E-03,1.703900E-02,3.087600E-02,&
     & 6.543600E-02,2.088600E-01,3.167300E+00,6.318800E+01,4.587400E+02,&
     & 2.023300E-07,8.242800E-07,4.137900E-06,3.524200E-05,2.706800E-04,&
     & 1.039200E-03,3.727100E-03,1.686100E-02,2.118400E-01,1.340400E+00,&
     & 3.066000E+00,7.824700E+00,2.722800E+01,2.701200E+02,3.573800E+03,&
     & 1.123900E+04,4.912000E-07,1.495300E-06,6.227600E-06,4.043600E-05,&
     & 2.419500E-04,8.569500E-04,3.007600E-03,1.359000E-02,1.723300E-01,&
     & 1.105800E+00,2.537000E+00,6.383400E+00,2.145800E+01,2.033000E+02,&
     & 2.680100E+03,8.429600E+03,5.263900E-07,1.573700E-06,6.050500E-06,&
     & 3.371400E-05,1.781600E-04,6.059800E-04,2.098300E-03,9.485300E-03,&
     & 1.186600E-01,7.646100E-01,1.768700E+00,4.569700E+00,1.569400E+01,&
     & 1.387500E+02,1.787000E+03,5.619900E+03,4.808900E-07,1.419600E-06,&
     & 4.986200E-06,2.328100E-05,1.024900E-04,3.333200E-04,1.128300E-03,&
     & 5.094500E-03,6.257700E-02,4.003100E-01,9.321600E-01,2.455100E+00,&
     & 8.961400E+00,7.670400E+01,8.934200E+02,2.809800E+03,1.796500E-07,&
     & 3.947900E-07,7.315300E-07,1.391900E-06,2.583700E-06,5.955200E-06,&
     & 1.571500E-05,6.184400E-05,7.758900E-04,4.484700E-03,1.030800E-02,&
     & 2.311700E-02,5.360800E-02,4.718800E-01,2.326400E+01,1.898100E+02,&
     & 2.553800E-07,1.242200E-06,7.122800E-06,5.889700E-05,4.010400E-04,&
     & 1.510100E-03,5.403400E-03,2.510200E-02,3.145100E-01,1.966900E+00,&
     & 4.485600E+00,1.133600E+01,4.105300E+01,3.833300E+02,4.511100E+03,&
     & 1.396600E+04,6.569200E-07,2.243000E-06,1.001200E-05,6.405400E-05,&
     & 3.525400E-04,1.243600E-03,4.365000E-03,2.021000E-02,2.565200E-01,&
     & 1.617300E+00,3.705600E+00,9.197800E+00,3.214000E+01,2.881600E+02,&
     & 3.383400E+03,1.047300E+04,7.054700E-07,2.324300E-06,9.453800E-06,&
     & 5.216800E-05,2.567200E-04,8.783200E-04,3.042700E-03,1.408000E-02,&
     & 1.766000E-01,1.119400E+00,2.594500E+00,6.614300E+00,2.330600E+01,&
     & 1.959600E+02,2.255900E+03,6.983900E+03,6.407500E-07,2.053200E-06,&
     & 7.528800E-06,3.486500E-05,1.458200E-04,4.807100E-04,1.634700E-03,&
     & 7.545000E-03,9.298700E-02,5.870400E-01,1.370000E+00,3.580400E+00,&
     & 1.330200E+01,1.070700E+02,1.127700E+03,3.491400E+03,2.249600E-07,&
     & 4.984600E-07,9.446600E-07,1.754800E-06,3.314600E-06,7.596100E-06,&
     & 2.036600E-05,7.957300E-05,1.083100E-03,6.271700E-03,1.360100E-02,&
     & 2.965900E-02,7.180000E-02,7.839000E-01,3.049400E+01,2.434800E+02/
      data   absb(:,761:780) /                                          &
     & 3.391700E-07,1.920400E-06,1.188900E-05,9.317000E-05,5.661800E-04,&
     & 2.125400E-03,7.686500E-03,3.657000E-02,4.543800E-01,2.836100E+00,&
     & 6.337200E+00,1.613700E+01,5.980100E+01,5.226800E+02,5.536400E+03,&
     & 1.680300E+04,8.917900E-07,3.344400E-06,1.568800E-05,9.704600E-05,&
     & 4.915000E-04,1.749800E-03,6.212000E-03,2.943000E-02,3.707400E-01,&
     & 2.333700E+00,5.214000E+00,1.303000E+01,4.651600E+01,3.925500E+02,&
     & 4.152200E+03,1.260200E+04,9.586900E-07,3.395900E-06,1.435000E-05,&
     & 7.725100E-05,3.553800E-04,1.232500E-03,4.331200E-03,2.047300E-02,&
     & 2.554300E-01,1.618500E+00,3.667600E+00,9.415300E+00,3.339000E+01,&
     & 2.661700E+02,2.768100E+03,8.401100E+03,8.598600E-07,2.926300E-06,&
     & 1.107500E-05,5.010600E-05,2.004500E-04,6.718100E-04,2.325100E-03,&
     & 1.095400E-02,1.344800E-01,8.494900E-01,1.941900E+00,5.144900E+00,&
     & 1.903000E+01,1.440000E+02,1.384100E+03,4.200500E+03,2.746900E-07,&
     & 6.179200E-07,1.189200E-06,2.166800E-06,4.143200E-06,9.447700E-06,&
     & 2.593800E-05,1.006300E-04,1.461100E-03,8.530800E-03,1.730600E-02,&
     & 3.685700E-02,9.710500E-02,1.243400E+00,3.890900E+01,3.035000E+02,&
     & 4.644600E-07,2.951500E-06,1.907400E-05,1.404800E-04,7.683500E-04,&
     & 2.897400E-03,1.073500E-02,5.223100E-02,6.400700E-01,4.009400E+00,&
     & 8.740900E+00,2.262200E+01,8.423900E+01,6.884700E+02,6.629700E+03,&
     & 1.966800E+04,1.210100E-06,4.908300E-06,2.384400E-05,1.407500E-04,&
     & 6.621600E-04,2.386000E-03,8.687100E-03,4.198000E-02,5.232800E-01,&
     & 3.294800E+00,7.153600E+00,1.815000E+01,6.513500E+01,5.167600E+02,&
     & 4.972300E+03,1.475100E+04,1.297800E-06,4.884700E-06,2.117900E-05,&
     & 1.098600E-04,4.767500E-04,1.678800E-03,6.056500E-03,2.916300E-02,&
     & 3.607900E-01,2.290000E+00,5.054500E+00,1.316500E+01,4.633500E+01,&
     & 3.495400E+02,3.314700E+03,9.833900E+03,1.149800E-06,4.097700E-06,&
     & 1.584500E-05,6.944800E-05,2.678100E-04,9.119500E-04,3.250400E-03,&
     & 1.556200E-02,1.900700E-01,1.202000E+00,2.683900E+00,7.285600E+00,&
     & 2.627400E+01,1.875200E+02,1.657400E+03,4.916600E+03,3.304400E-07,&
     & 7.519600E-07,1.463700E-06,2.607400E-06,5.131500E-06,1.158500E-05,&
     & 3.215100E-05,1.255200E-04,1.917800E-03,1.125900E-02,2.152600E-02,&
     & 4.455700E-02,1.339100E-01,1.891900E+00,4.857500E+01,3.686500E+02,&
     & 6.411200E-07,4.432800E-06,2.935100E-05,2.022000E-04,1.012700E-03,&
     & 3.824400E-03,1.474400E-02,7.305500E-02,8.847900E-01,5.526200E+00,&
     & 1.184600E+01,3.125300E+01,1.147900E+02,8.805000E+02,7.771300E+03,&
     & 2.250600E+04,1.621200E-06,7.040900E-06,3.507300E-05,1.964400E-04,&
     & 8.692300E-04,3.151700E-03,1.196500E-02,5.874100E-02,7.247700E-01,&
     & 4.528000E+00,9.643200E+00,2.492500E+01,8.824700E+01,6.606800E+02,&
     & 5.828500E+03,1.687900E+04,1.737300E-06,6.883100E-06,3.038200E-05,&
     & 1.508900E-04,6.240500E-04,2.214000E-03,8.345900E-03,4.076100E-02,&
     & 5.004600E-01,3.154200E+00,6.837400E+00,1.814400E+01,6.231400E+01,&
     & 4.459100E+02,3.885600E+03,1.125400E+04,1.520100E-06,5.617800E-06,&
     & 2.206800E-05,9.349200E-05,3.489900E-04,1.200500E-03,4.475600E-03,&
     & 2.171900E-02,2.639800E-01,1.655600E+00,3.643700E+00,1.013600E+01,&
     & 3.514500E+01,2.376000E+02,1.942900E+03,5.626100E+03,3.902800E-07,&
     & 9.006000E-07,1.758100E-06,3.127800E-06,6.198300E-06,1.401300E-05,&
     & 3.912600E-05,1.549100E-04,2.477400E-03,1.438400E-02,2.623800E-02,&
     & 5.586400E-02,1.784000E-01,2.797000E+00,5.953900E+01,4.378900E+02,&
     & 1.612200E-07,6.179100E-07,2.920400E-06,2.500400E-05,2.013900E-04,&
     & 7.868300E-04,2.856000E-03,1.311200E-02,1.698200E-01,1.106600E+00,&
     & 2.566400E+00,6.678200E+00,2.346500E+01,2.433300E+02,3.414400E+03,&
     & 1.082500E+04,3.755100E-07,1.096400E-06,4.446200E-06,2.913800E-05,&
     & 1.810600E-04,6.487500E-04,2.306700E-03,1.058300E-02,1.384600E-01,&
     & 9.154700E-01,2.130600E+00,5.472900E+00,1.856200E+01,1.832000E+02,&
     & 2.560800E+03,8.118600E+03,3.996000E-07,1.152600E-06,4.342300E-06,&
     & 2.443700E-05,1.335800E-04,4.587800E-04,1.608800E-03,7.386700E-03,&
     & 9.529900E-02,6.327500E-01,1.485300E+00,3.911600E+00,1.363800E+01,&
     & 1.251300E+02,1.707200E+03,5.412500E+03,3.637700E-07,1.039600E-06,&
     & 3.606900E-06,1.698900E-05,7.709400E-05,2.522300E-04,8.642300E-04,&
     & 3.965600E-03,5.024800E-02,3.315000E-01,7.818500E-01,2.098400E+00,&
     & 7.792500E+00,6.932400E+01,8.536400E+02,2.706400E+03,1.335100E-07,&
     & 2.927600E-07,5.348100E-07,1.025000E-06,1.896000E-06,4.396800E-06,&
     & 1.169100E-05,4.670800E-05,5.985700E-04,3.489700E-03,8.339000E-03,&
     & 1.919400E-02,4.487400E-02,3.854300E-01,2.106500E+01,1.739100E+02/
      data   absb(:,781:800) /                                          &
     & 1.993800E-07,9.145800E-07,5.052700E-06,4.258500E-05,3.034500E-04,&
     & 1.155900E-03,4.191400E-03,1.983800E-02,2.570600E-01,1.654200E+00,&
     & 3.826500E+00,9.837000E+00,3.614600E+01,3.516000E+02,4.356900E+03,&
     & 1.360300E+04,4.977300E-07,1.641000E-06,7.211000E-06,4.693800E-05,&
     & 2.677400E-04,9.530500E-04,3.387800E-03,1.599500E-02,2.100500E-01,&
     & 1.363500E+00,3.174800E+00,8.012700E+00,2.838200E+01,2.643900E+02,&
     & 3.267400E+03,1.020200E+04,5.319500E-07,1.704400E-06,6.850800E-06,&
     & 3.842200E-05,1.952500E-04,6.727700E-04,2.361700E-03,1.114400E-02,&
     & 1.446200E-01,9.439900E-01,2.220400E+00,5.757600E+00,2.067200E+01,&
     & 1.798300E+02,2.178400E+03,6.801400E+03,4.825800E-07,1.510300E-06,&
     & 5.498200E-06,2.586500E-05,1.111200E-04,3.683000E-04,1.268000E-03,&
     & 5.970300E-03,7.612600E-02,4.949400E-01,1.171700E+00,3.108700E+00,&
     & 1.181400E+01,9.839100E+01,1.089300E+03,3.400600E+03,1.685700E-07,&
     & 3.730500E-07,6.948100E-07,1.311200E-06,2.459500E-06,5.639400E-06,&
     & 1.533600E-05,6.077600E-05,8.478500E-04,4.943000E-03,1.111100E-02,&
     & 2.474100E-02,5.906300E-02,6.541000E-01,2.792900E+01,2.252600E+02,&
     & 2.607500E-07,1.408100E-06,8.540200E-06,6.856300E-05,4.343900E-04,&
     & 1.645400E-03,6.025700E-03,2.934500E-02,3.778600E-01,2.426600E+00,&
     & 5.500600E+00,1.419400E+01,5.371400E+01,4.867200E+02,5.394400E+03,&
     & 1.653000E+04,6.733400E-07,2.456700E-06,1.141900E-05,7.223200E-05,&
     & 3.782200E-04,1.355800E-03,4.875300E-03,2.364900E-02,3.090400E-01,&
     & 2.002000E+00,4.541800E+00,1.150600E+01,4.187300E+01,3.655900E+02,&
     & 4.045800E+03,1.239800E+04,7.216200E-07,2.503500E-06,1.051500E-05,&
     & 5.776100E-05,2.735500E-04,9.553400E-04,3.399100E-03,1.645800E-02,&
     & 2.128600E-01,1.388700E+00,3.191500E+00,8.311900E+00,3.016500E+01,&
     & 2.479400E+02,2.697100E+03,8.264900E+03,6.471900E-07,2.166700E-06,&
     & 8.172400E-06,3.770000E-05,1.543300E-04,5.205500E-04,1.824800E-03,&
     & 8.798400E-03,1.120400E-01,7.284700E-01,1.689200E+00,4.530800E+00,&
     & 1.721200E+01,1.342200E+02,1.348600E+03,4.132700E+03,2.076800E-07,&
     & 4.641400E-07,8.854300E-07,1.618600E-06,3.115800E-06,7.085900E-06,&
     & 1.967400E-05,7.748700E-05,1.160500E-03,6.868200E-03,1.431200E-02,&
     & 3.129100E-02,7.982800E-02,1.057400E+00,3.594300E+01,2.833700E+02,&
     & 3.544000E-07,2.174200E-06,1.389400E-05,1.050100E-04,5.960000E-04,&
     & 2.266900E-03,8.507400E-03,4.254200E-02,5.407100E-01,3.488600E+00,&
     & 7.699000E+00,2.017200E+01,7.698100E+01,6.490700E+02,6.510500E+03,&
     & 1.951100E+04,9.152800E-07,3.632300E-06,1.756200E-05,1.063000E-04,&
     & 5.142500E-04,1.868600E-03,6.895300E-03,3.423700E-02,4.430300E-01,&
     & 2.870800E+00,6.329500E+00,1.624600E+01,5.961400E+01,4.872100E+02,&
     & 4.882800E+03,1.463400E+04,9.792600E-07,3.626700E-06,1.568200E-05,&
     & 8.325300E-05,3.702500E-04,1.314800E-03,4.806700E-03,2.378200E-02,&
     & 3.055500E-01,1.993100E+00,4.470700E+00,1.178100E+01,4.251900E+01,&
     & 3.295900E+02,3.255400E+03,9.755700E+03,8.683100E-07,3.056000E-06,&
     & 1.181400E-05,5.286000E-05,2.079500E-04,7.139900E-04,2.578300E-03,&
     & 1.269600E-02,1.609000E-01,1.045900E+00,2.372800E+00,6.499700E+00,&
     & 2.416000E+01,1.768300E+02,1.627600E+03,4.877800E+03,2.512800E-07,&
     & 5.682500E-07,1.098400E-06,1.965100E-06,3.874600E-06,8.746200E-06,&
     & 2.460100E-05,9.739100E-05,1.545300E-03,9.138100E-03,1.802200E-02,&
     & 3.762200E-02,1.124800E-01,1.633800E+00,4.518200E+01,3.470300E+02,&
     & 4.888200E-07,3.293900E-06,2.169200E-05,1.534300E-04,7.918400E-04,&
     & 3.020100E-03,1.179800E-02,6.032700E-02,7.584100E-01,4.877300E+00,&
     & 1.059000E+01,2.821900E+01,1.065100E+02,8.393500E+02,7.682900E+03,&
     & 2.248200E+04,1.232100E-06,5.255300E-06,2.615000E-05,1.501900E-04,&
     & 6.803800E-04,2.491700E-03,9.589300E-03,4.854400E-02,6.225800E-01,&
     & 4.004600E+00,8.650800E+00,2.257000E+01,8.198300E+01,6.298100E+02,&
     & 5.762200E+03,1.686100E+04,1.317100E-06,5.151600E-06,2.273800E-05,&
     & 1.156700E-04,4.883900E-04,1.750900E-03,6.687600E-03,3.367700E-02,&
     & 4.299600E-01,2.787300E+00,6.130800E+00,1.642800E+01,5.801300E+01,&
     & 4.251200E+02,3.841400E+03,1.124100E+04,1.153600E-06,4.222800E-06,&
     & 1.661900E-05,7.187200E-05,2.730300E-04,9.490400E-04,3.586600E-03,&
     & 1.793400E-02,2.267500E-01,1.463000E+00,3.265600E+00,9.162800E+00,&
     & 3.273400E+01,2.264600E+02,1.920800E+03,5.620300E+03,2.984300E-07,&
     & 6.847000E-07,1.325800E-06,2.371000E-06,4.711300E-06,1.063900E-05,&
     & 3.011000E-05,1.211500E-04,1.995900E-03,1.196000E-02,2.228400E-02,&
     & 4.783100E-02,1.490100E-01,2.446000E+00,5.571500E+01,4.151200E+02/
      data   absb(:,801:820) /                                          &
     & 1.298800E-07,4.681800E-07,2.065400E-06,1.764800E-05,1.492400E-04,&
     & 5.936500E-04,2.179500E-03,1.014600E-02,1.354500E-01,9.073900E-01,&
     & 2.144900E+00,5.677000E+00,2.018600E+01,2.182600E+02,3.250500E+03,&
     & 1.039800E+04,2.887000E-07,8.072000E-07,3.170600E-06,2.089900E-05,&
     & 1.347900E-04,4.895900E-04,1.762000E-03,8.198500E-03,1.106200E-01,&
     & 7.542400E-01,1.785200E+00,4.679400E+00,1.602100E+01,1.643900E+02,&
     & 2.437900E+03,7.798900E+03,3.053200E-07,8.451500E-07,3.110600E-06,&
     & 1.762400E-05,9.973900E-05,3.460700E-04,1.228800E-03,5.722500E-03,&
     & 7.615500E-02,5.212800E-01,1.243400E+00,3.342500E+00,1.180800E+01,&
     & 1.124000E+02,1.625400E+03,5.199400E+03,2.758200E-07,7.609900E-07,&
     & 2.602700E-06,1.233200E-05,5.775600E-05,1.902000E-04,6.597600E-04,&
     & 3.071200E-03,4.015100E-02,2.727300E-01,6.545900E-01,1.790200E+00,&
     & 6.751100E+00,6.238700E+01,8.127100E+02,2.599700E+03,9.868400E-08,&
     & 2.164300E-07,3.884300E-07,7.477800E-07,1.382700E-06,3.222900E-06,&
     & 8.635500E-06,3.506800E-05,4.571100E-04,2.709800E-03,6.537400E-03,&
     & 1.580600E-02,3.757500E-02,3.136200E-01,1.898400E+01,1.587600E+02,&
     & 1.568900E-07,6.772800E-07,3.578500E-06,3.064800E-05,2.288000E-04,&
     & 8.821800E-04,3.238400E-03,1.560700E-02,2.091900E-01,1.385200E+00,&
     & 3.258600E+00,8.532200E+00,3.173500E+01,3.215100E+02,4.197400E+03,&
     & 1.320700E+04,3.784600E-07,1.201300E-06,5.180000E-06,3.422800E-05,&
     & 2.027000E-04,7.280300E-04,2.619000E-03,1.260100E-02,1.712000E-01,&
     & 1.146700E+00,2.712000E+00,6.976000E+00,2.499600E+01,2.417900E+02,&
     & 3.148100E+03,9.905200E+03,4.023500E-07,1.249300E-06,4.949800E-06,&
     & 2.814500E-05,1.480800E-04,5.139000E-04,1.825500E-03,8.780600E-03,&
     & 1.179000E-01,7.930400E-01,1.896200E+00,5.007800E+00,1.828000E+01,&
     & 1.645200E+02,2.098900E+03,6.603200E+03,3.640200E-07,1.109600E-06,&
     & 4.002900E-06,1.910100E-05,8.439500E-05,2.811500E-04,9.800000E-04,&
     & 4.701900E-03,6.207300E-02,4.157800E-01,1.000200E+00,2.699100E+00,&
     & 1.045900E+01,9.013000E+01,1.049300E+03,3.301800E+03,1.256100E-07,&
     & 2.784000E-07,5.055200E-07,9.715000E-07,1.808100E-06,4.170900E-06,&
     & 1.147000E-05,4.614400E-05,6.579800E-04,3.854800E-03,8.966100E-03,&
     & 2.041700E-02,4.952400E-02,5.422900E-01,2.549300E+01,2.076100E+02,&
     & 2.016500E-07,1.034000E-06,6.115600E-06,5.024400E-05,3.322900E-04,&
     & 1.270500E-03,4.709500E-03,2.345100E-02,3.131600E-01,2.071300E+00,&
     & 4.767700E+00,1.249800E+01,4.811100E+01,4.520200E+02,5.246600E+03,&
     & 1.622000E+04,5.092000E-07,1.803200E-06,8.289900E-06,5.352000E-05,&
     & 2.903200E-04,1.048200E-03,3.813500E-03,1.893000E-02,2.566300E-01,&
     & 1.715100E+00,3.951200E+00,1.016200E+01,3.759500E+01,3.395700E+02,&
     & 3.935000E+03,1.216500E+04,5.434300E-07,1.843100E-06,7.682500E-06,&
     & 4.300100E-05,2.101500E-04,7.383800E-04,2.658900E-03,1.317700E-02,&
     & 1.767900E-01,1.189200E+00,2.772900E+00,7.336700E+00,2.718200E+01,&
     & 2.303400E+02,2.623200E+03,8.109500E+03,4.873300E-07,1.601100E-06,&
     & 6.011400E-06,2.824300E-05,1.185700E-04,4.022500E-04,1.426900E-03,&
     & 7.043400E-03,9.299500E-02,6.242600E-01,1.466800E+00,3.989900E+00,&
     & 1.552600E+01,1.247600E+02,1.311700E+03,4.054300E+03,1.562000E-07,&
     & 3.480900E-07,6.489900E-07,1.207300E-06,2.326100E-06,5.281800E-06,&
     & 1.481900E-05,5.945700E-05,9.116400E-04,5.460400E-03,1.172300E-02,&
     & 2.609300E-02,6.770000E-02,8.943200E-01,3.311300E+01,2.636800E+02,&
     & 2.712000E-07,1.600400E-06,1.009000E-05,7.819100E-05,4.615200E-04,&
     & 1.769200E-03,6.718800E-03,3.451400E-02,4.556700E-01,3.032600E+00,&
     & 6.775900E+00,1.799700E+01,7.018000E+01,6.109800E+02,6.383300E+03,&
     & 1.931800E+04,6.921600E-07,2.683400E-06,1.289900E-05,7.999500E-05,&
     & 3.989300E-04,1.459700E-03,5.453300E-03,2.782500E-02,3.741600E-01,&
     & 2.500600E+00,5.590700E+00,1.454800E+01,5.443800E+01,4.586400E+02,&
     & 4.787500E+03,1.439000E+04,7.388100E-07,2.687500E-06,1.158400E-05,&
     & 6.288800E-05,2.872100E-04,1.026900E-03,3.802100E-03,1.932700E-02,&
     & 2.581300E-01,1.734500E+00,3.945900E+00,1.055200E+01,3.892600E+01,&
     & 3.102700E+02,3.191800E+03,9.658800E+03,6.553300E-07,2.274000E-06,&
     & 8.784900E-06,4.015700E-05,1.612000E-04,5.576800E-04,2.039100E-03,&
     & 1.031100E-02,1.359000E-01,9.098800E-01,2.094300E+00,5.801800E+00,&
     & 2.215500E+01,1.664800E+02,1.595800E+03,4.829700E+03,1.900900E-07,&
     & 4.276700E-07,8.118200E-07,1.483100E-06,2.908000E-06,6.556700E-06,&
     & 1.869200E-05,7.543400E-05,1.228700E-03,7.388700E-03,1.489300E-02,&
     & 3.235600E-02,9.216800E-02,1.409400E+00,4.193000E+01,3.257400E+02/
      data   absb(:,821:840) /                                          &
     & 3.731000E-07,2.443100E-06,1.597400E-05,1.160500E-04,6.185700E-04,&
     & 2.380600E-03,9.416000E-03,4.967500E-02,6.491900E-01,4.300800E+00,&
     & 9.461700E+00,2.551000E+01,9.862000E+01,7.990300E+02,7.586800E+03,&
     & 2.242400E+04,9.356800E-07,3.914400E-06,1.943600E-05,1.144900E-04,&
     & 5.320400E-04,1.965700E-03,7.662700E-03,4.004300E-02,5.340100E-01,&
     & 3.538700E+00,7.757400E+00,2.045500E+01,7.601500E+01,5.995600E+02,&
     & 5.690100E+03,1.681800E+04,9.976200E-07,3.846900E-06,1.697200E-05,&
     & 8.844800E-05,3.819000E-04,1.381200E-03,5.342800E-03,2.778400E-02,&
     & 3.688200E-01,2.461200E+00,5.495400E+00,1.488500E+01,5.388900E+01,&
     & 4.046500E+02,3.793400E+03,1.121200E+04,8.742500E-07,3.167500E-06,&
     & 1.248100E-05,5.514000E-05,2.134100E-04,7.484100E-04,2.864800E-03,&
     & 1.478600E-02,1.944800E-01,1.291400E+00,2.925700E+00,8.282300E+00,&
     & 3.044900E+01,2.154900E+02,1.896700E+03,5.606100E+03,2.278500E-07,&
     & 5.184700E-07,9.926000E-07,1.785800E-06,3.561200E-06,8.034700E-06,&
     & 2.307100E-05,9.454000E-05,1.602900E-03,9.732100E-03,1.887900E-02,&
     & 4.061000E-02,1.254600E-01,2.133600E+00,5.202700E+01,3.925900E+02,&
     & 1.056400E-07,3.571500E-07,1.453800E-06,1.224100E-05,1.090600E-04,&
     & 4.433500E-04,1.644200E-03,7.735100E-03,1.066800E-01,7.319900E-01,&
     & 1.769300E+00,4.763800E+00,1.716800E+01,1.933400E+02,3.066200E+03,&
     & 9.918900E+03,2.219700E-07,5.942100E-07,2.238100E-06,1.475400E-05,&
     & 9.905900E-05,3.656000E-04,1.330100E-03,6.259000E-03,8.716500E-02,&
     & 6.114500E-01,1.477800E+00,3.949600E+00,1.367400E+01,1.456700E+02,&
     & 2.299600E+03,7.440000E+03,2.329000E-07,6.173400E-07,2.204400E-06,&
     & 1.252800E-05,7.347700E-05,2.582000E-04,9.273100E-04,4.371200E-03,&
     & 6.000700E-02,4.224000E-01,1.028600E+00,2.821800E+00,1.010200E+01,&
     & 9.970500E+01,1.533100E+03,4.960000E+03,2.087500E-07,5.530500E-07,&
     & 1.857000E-06,8.815100E-06,4.273400E-05,1.418600E-04,4.972400E-04,&
     & 2.347000E-03,3.162800E-02,2.211700E-01,5.411000E-01,1.510500E+00,&
     & 5.772100E+00,5.544500E+01,7.667200E+02,2.479700E+03,7.245400E-08,&
     & 1.580000E-07,2.778000E-07,5.384800E-07,1.002400E-06,2.339400E-06,&
     & 6.312300E-06,2.602400E-05,3.444400E-04,2.078500E-03,5.047400E-03,&
     & 1.260400E-02,3.150600E-02,2.510600E-01,1.690500E+01,1.434200E+02,&
     & 1.240400E-07,5.018700E-07,2.505400E-06,2.173100E-05,1.704300E-04,&
     & 6.665200E-04,2.475600E-03,1.211700E-02,1.679300E-01,1.143800E+00,&
     & 2.747800E+00,7.324800E+00,2.755100E+01,2.908400E+02,4.015500E+03,&
     & 1.273100E+04,2.874500E-07,8.738100E-07,3.676100E-06,2.462500E-05,&
     & 1.516500E-04,5.504800E-04,2.003800E-03,9.801900E-03,1.377000E-01,&
     & 9.509800E-01,2.293000E+00,6.018900E+00,2.175900E+01,2.187800E+02,&
     & 3.011600E+03,9.548200E+03,3.037900E-07,9.084800E-07,3.533300E-06,&
     & 2.035200E-05,1.110800E-04,3.885700E-04,1.396100E-03,6.831200E-03,&
     & 9.480500E-02,6.583300E-01,1.600900E+00,4.315700E+00,1.597500E+01,&
     & 1.489500E+02,2.007900E+03,6.365300E+03,2.733500E-07,8.084300E-07,&
     & 2.880300E-06,1.392100E-05,6.347300E-05,2.125400E-04,7.485800E-04,&
     & 3.658100E-03,4.992900E-02,3.447100E-01,8.445700E-01,2.322000E+00,&
     & 9.147200E+00,8.171200E+01,1.003900E+03,3.182600E+03,9.297100E-08,&
     & 2.056300E-07,3.666600E-07,7.079200E-07,1.322700E-06,3.054300E-06,&
     & 8.488700E-06,3.473700E-05,5.037200E-04,2.980500E-03,7.072600E-03,&
     & 1.694300E-02,4.136800E-02,4.416700E-01,2.304100E+01,1.895400E+02,&
     & 1.562400E-07,7.551500E-07,4.320500E-06,3.632800E-05,2.519300E-04,&
     & 9.713900E-04,3.643000E-03,1.852100E-02,2.564000E-01,1.748100E+00,&
     & 4.094100E+00,1.093100E+01,4.263100E+01,4.160500E+02,5.074100E+03,&
     & 1.582000E+04,3.836900E-07,1.311800E-06,5.943000E-06,3.913900E-05,&
     & 2.207900E-04,8.023300E-04,2.952700E-03,1.497200E-02,2.105700E-01,&
     & 1.452500E+00,3.405300E+00,8.915500E+00,3.338900E+01,3.126000E+02,&
     & 3.805600E+03,1.186500E+04,4.073700E-07,1.344500E-06,5.545100E-06,&
     & 3.162600E-05,1.600500E-04,5.652100E-04,2.058400E-03,1.042300E-02,&
     & 1.451100E-01,1.006800E+00,2.387500E+00,6.428500E+00,2.423300E+01,&
     & 2.120600E+02,2.537000E+03,7.909900E+03,3.650000E-07,1.172100E-06,&
     & 4.370900E-06,2.094000E-05,9.037600E-05,3.079600E-04,1.103400E-03,&
     & 5.570700E-03,7.632400E-02,5.284500E-01,1.262600E+00,3.485800E+00,&
     & 1.385500E+01,1.149400E+02,1.268500E+03,3.954800E+03,1.167100E-07,&
     & 2.596700E-07,4.705200E-07,8.955500E-07,1.719100E-06,3.901600E-06,&
     & 1.106500E-05,4.522700E-05,7.078600E-04,4.271700E-03,9.502300E-03,&
     & 2.173400E-02,5.658100E-02,7.458900E-01,3.024100E+01,2.432400E+02/
      data   absb(:,841:860) /                                          &
     & 2.072700E-07,1.167700E-06,7.229900E-06,5.753100E-05,3.545700E-04,&
     & 1.369700E-03,5.255100E-03,2.771800E-02,3.801400E-01,2.609800E+00,&
     & 5.918900E+00,1.594800E+01,6.337400E+01,5.708700E+02,6.229400E+03,&
     & 1.903600E+04,5.205100E-07,1.963300E-06,9.361600E-06,5.951000E-05,&
     & 3.071100E-04,1.131300E-03,4.270200E-03,2.237600E-02,3.127600E-01,&
     & 2.158200E+00,4.899900E+00,1.293300E+01,4.924500E+01,4.285700E+02,&
     & 4.672100E+03,1.427700E+04,5.540700E-07,1.972600E-06,8.460100E-06,&
     & 4.702400E-05,2.212100E-04,7.953900E-04,2.977500E-03,1.554900E-02,&
     & 2.158700E-01,1.496300E+00,3.453500E+00,9.380500E+00,3.531100E+01,&
     & 2.899300E+02,3.114900E+03,9.517300E+03,4.915600E-07,1.676600E-06,&
     & 6.462800E-06,3.021000E-05,1.241200E-04,4.317700E-04,1.596000E-03,&
     & 8.294200E-03,1.136200E-01,7.850100E-01,1.832400E+00,5.143200E+00,&
     & 2.011700E+01,1.555900E+02,1.557300E+03,4.759000E+03,1.431400E-07,&
     & 3.210800E-07,5.953900E-07,1.109000E-06,2.164000E-06,4.893000E-06,&
     & 1.409300E-05,5.806400E-05,9.678400E-04,5.863100E-03,1.232200E-02,&
     & 2.740700E-02,7.498100E-02,1.199500E+00,3.862200E+01,3.034000E+02,&
     & 2.835700E-07,1.795000E-06,1.162100E-05,8.682100E-05,4.801600E-04,&
     & 1.863000E-03,7.449000E-03,4.052100E-02,5.507800E-01,3.766300E+00,&
     & 8.388700E+00,2.292300E+01,9.054500E+01,7.556600E+02,7.463700E+03,&
     & 2.228300E+04,7.058600E-07,2.888500E-06,1.428500E-05,8.644300E-05,&
     & 4.135000E-04,1.540100E-03,6.070000E-03,3.272000E-02,4.540600E-01,&
     & 3.103100E+00,6.902600E+00,1.843800E+01,6.987200E+01,5.670300E+02,&
     & 5.597800E+03,1.671200E+04,7.504700E-07,2.846800E-06,1.253500E-05,&
     & 6.704600E-05,2.966900E-04,1.082200E-03,4.232300E-03,2.270800E-02,&
     & 3.136400E-01,2.156400E+00,4.889300E+00,1.340700E+01,4.962700E+01,&
     & 3.827200E+02,3.732000E+03,1.106800E+04,6.579800E-07,2.355300E-06,&
     & 9.283600E-06,4.196800E-05,1.658500E-04,5.860300E-04,2.267500E-03,&
     & 1.208400E-02,1.653400E-01,1.131200E+00,2.602000E+00,7.435800E+00,&
     & 2.809100E+01,2.037200E+02,1.866000E+03,5.570800E+03,1.723500E-07,&
     & 3.901100E-07,7.356500E-07,1.345100E-06,2.668100E-06,6.021100E-06,&
     & 1.754000E-05,7.348000E-05,1.280300E-03,7.783100E-03,1.561700E-02,&
     & 3.430900E-02,1.035600E-01,1.842000E+00,4.825700E+01,3.687300E+02,&
     & 8.691600E-08,2.739800E-07,1.014300E-06,8.244900E-06,7.779100E-05,&
     & 3.249400E-04,1.214500E-03,5.759200E-03,8.215900E-02,5.723200E-01,&
     & 1.424100E+00,3.908000E+00,1.428500E+01,1.673400E+02,2.847200E+03,&
     & 9.346500E+03,1.706600E-07,4.358100E-07,1.553800E-06,1.014600E-05,&
     & 7.116400E-05,2.678100E-04,9.833700E-04,4.667200E-03,6.719400E-02,&
     & 4.803200E-01,1.194100E+00,3.256900E+00,1.142000E+01,1.261500E+02,&
     & 2.135400E+03,7.009800E+03,1.773100E-07,4.470400E-07,1.532500E-06,&
     & 8.680700E-06,5.296600E-05,1.890600E-04,6.853600E-04,3.259300E-03,&
     & 4.625500E-02,3.321000E-01,8.300200E-01,2.326300E+00,8.447400E+00,&
     & 8.646700E+01,1.423600E+03,4.673300E+03,1.574000E-07,3.966800E-07,&
     & 1.297900E-06,6.151800E-06,3.095000E-05,1.037900E-04,3.673000E-04,&
     & 1.750100E-03,2.436900E-02,1.740300E-01,4.364300E-01,1.244600E+00,&
     & 4.817300E+00,4.818200E+01,7.120800E+02,2.336600E+03,5.295600E-08,&
     & 1.132300E-07,1.973300E-07,3.833200E-07,7.197900E-07,1.670300E-06,&
     & 4.551700E-06,1.909500E-05,2.569600E-04,1.546100E-03,3.782800E-03,&
     & 1.016900E-02,2.664700E-02,1.960700E-01,1.472300E+01,1.274100E+02,&
     & 9.860300E-08,3.710300E-07,1.720800E-06,1.499900E-05,1.243600E-04,&
     & 4.947700E-04,1.859100E-03,9.206000E-03,1.318300E-01,9.238600E-01,&
     & 2.269800E+00,6.156700E+00,2.342100E+01,2.579800E+02,3.795200E+03,&
     & 1.213100E+04,2.173700E-07,6.285000E-07,2.553800E-06,1.729300E-05,&
     & 1.113400E-04,4.087600E-04,1.504500E-03,7.457600E-03,1.082900E-01,&
     & 7.711600E-01,1.898600E+00,5.088300E+00,1.854700E+01,1.941400E+02,&
     & 2.846400E+03,9.097900E+03,2.280000E-07,6.516300E-07,2.469400E-06,&
     & 1.438400E-05,8.175800E-05,2.882200E-04,1.048200E-03,5.199700E-03,&
     & 7.455800E-02,5.336400E-01,1.324700E+00,3.649700E+00,1.365800E+01,&
     & 1.322700E+02,1.897600E+03,6.065300E+03,2.036500E-07,5.800000E-07,&
     & 2.030500E-06,9.918400E-06,4.685600E-05,1.578000E-04,5.613000E-04,&
     & 2.784800E-03,3.926000E-02,2.793400E-01,6.982200E-01,1.960700E+00,&
     & 7.822200E+00,7.269000E+01,9.487400E+02,3.032500E+03,6.835500E-08,&
     & 1.499000E-07,2.630400E-07,5.106900E-07,9.546600E-07,2.223500E-06,&
     & 6.194600E-06,2.583900E-05,3.806400E-04,2.320900E-03,5.467600E-03,&
     & 1.373300E-02,3.514200E-02,3.472800E-01,2.045100E+01,1.703300E+02/
      data   absb(:,861:880) /                                          &
     & 1.211400E-07,5.457700E-07,2.982800E-06,2.566300E-05,1.876700E-04,&
     & 7.319000E-04,2.771400E-03,1.434600E-02,2.057900E-01,1.442900E+00,&
     & 3.454700E+00,9.405300E+00,3.701400E+01,3.768200E+02,4.858100E+03,&
     & 1.527900E+04,2.869300E-07,9.395600E-07,4.170200E-06,2.803100E-05,&
     & 1.651800E-04,6.044100E-04,2.247000E-03,1.161400E-02,1.693200E-01,&
     & 1.202400E+00,2.883600E+00,7.698200E+00,2.906400E+01,2.831900E+02,&
     & 3.643600E+03,1.145900E+04,3.025700E-07,9.653100E-07,3.920200E-06,&
     & 2.277600E-05,1.199500E-04,4.258100E-04,1.565400E-03,8.083500E-03,&
     & 1.166400E-01,8.340600E-01,2.019600E+00,5.543200E+00,2.118200E+01,&
     & 1.921600E+02,2.429000E+03,7.639500E+03,2.706000E-07,8.441500E-07,&
     & 3.116700E-06,1.521400E-05,6.785500E-05,2.319600E-04,8.387500E-04,&
     & 4.320800E-03,6.136500E-02,4.375700E-01,1.067800E+00,2.997800E+00,&
     & 1.211900E+01,1.042500E+02,1.214500E+03,3.819900E+03,8.609800E-08,&
     & 1.926200E-07,3.406500E-07,6.550700E-07,1.255300E-06,2.860000E-06,&
     & 8.184200E-06,3.420300E-05,5.429900E-04,3.276300E-03,7.621300E-03,&
     & 1.816200E-02,4.622300E-02,6.049600E-01,2.720300E+01,2.212100E+02,&
     & 1.577000E-07,8.389500E-07,5.064400E-06,4.148300E-05,2.687700E-04,&
     & 1.045000E-03,4.046800E-03,2.184500E-02,3.112700E-01,2.204700E+00,&
     & 5.087100E+00,1.394100E+01,5.619600E+01,5.259600E+02,6.030300E+03,&
     & 1.860900E+04,3.873500E-07,1.411600E-06,6.654100E-06,4.344200E-05,&
     & 2.335000E-04,8.636200E-04,3.290300E-03,1.767800E-02,2.567300E-01,&
     & 1.827300E+00,4.228800E+00,1.133700E+01,4.375400E+01,3.948900E+02,&
     & 4.522700E+03,1.395600E+04,4.107500E-07,1.424100E-06,6.059300E-06,&
     & 3.451400E-05,1.682300E-04,6.071100E-04,2.294100E-03,1.228400E-02,&
     & 1.771300E-01,1.267500E+00,2.976600E+00,8.215000E+00,3.147700E+01,&
     & 2.671800E+02,3.015100E+03,9.304200E+03,3.640100E-07,1.216900E-06,&
     & 4.666000E-06,2.233900E-05,9.443800E-05,3.295400E-04,1.228300E-03,&
     & 6.549300E-03,9.323400E-02,6.649500E-01,1.577800E+00,4.489700E+00,&
     & 1.795100E+01,1.434300E+02,1.507500E+03,4.652200E+03,1.068100E-07,&
     & 2.395100E-07,4.332600E-07,8.214000E-07,1.600100E-06,3.620300E-06,&
     & 1.051400E-05,4.440700E-05,7.535400E-04,4.562800E-03,9.965800E-03,&
     & 2.320700E-02,6.256100E-02,9.919000E-01,3.511200E+01,2.788800E+02,&
     & 2.136600E-07,1.296400E-06,8.278200E-06,6.380700E-05,3.685500E-04,&
     & 1.440300E-03,5.805300E-03,3.249600E-02,4.594400E-01,3.245600E+00,&
     & 7.332100E+00,2.031400E+01,8.180400E+01,7.063700E+02,7.293100E+03,&
     & 2.201100E+04,5.260700E-07,2.095600E-06,1.030000E-05,6.426300E-05,&
     & 3.177400E-04,1.192000E-03,4.734900E-03,2.628000E-02,3.794700E-01,&
     & 2.681200E+00,6.054200E+00,1.639600E+01,6.321500E+01,5.300600E+02,&
     & 5.469800E+03,1.650800E+04,5.576600E-07,2.072900E-06,9.095600E-06,&
     & 5.003400E-05,2.279700E-04,8.371500E-04,3.301800E-03,1.823400E-02,&
     & 2.622000E-01,1.861400E+00,4.283700E+00,1.191500E+01,4.500000E+01,&
     & 3.577600E+02,3.646700E+03,1.100600E+04,4.889900E-07,1.724700E-06,&
     & 6.787900E-06,3.150400E-05,1.274200E-04,4.531100E-04,1.768500E-03,&
     & 9.701800E-03,1.381800E-01,9.762300E-01,2.279000E+00,6.582500E+00,&
     & 2.551200E+01,1.903900E+02,1.823300E+03,5.502500E+03,1.293600E-07,&
     & 2.920800E-07,5.401700E-07,1.005700E-06,1.985500E-06,4.486400E-06,&
     & 1.324400E-05,5.677300E-05,1.012300E-03,6.107000E-03,1.305500E-02,&
     & 2.897400E-02,8.493600E-02,1.553900E+00,4.423900E+01,3.424400E+02,&
     & 7.269000E-08,2.138700E-07,7.203000E-07,5.516100E-06,5.504400E-05,&
     & 2.368000E-04,8.920900E-04,4.251100E-03,6.280500E-02,4.427000E-01,&
     & 1.133700E+00,3.188700E+00,1.183900E+01,1.435900E+02,2.625300E+03,&
     & 8.792500E+03,1.324300E-07,3.247100E-07,1.084500E-06,6.934500E-06,&
     & 5.069300E-05,1.952700E-04,7.227300E-04,3.449800E-03,5.137200E-02,&
     & 3.731300E-01,9.560600E-01,2.669000E+00,9.501300E+00,1.083100E+02,&
     & 1.969100E+03,6.594500E+03,1.363500E-07,3.263100E-07,1.067600E-06,&
     & 5.971100E-06,3.789100E-05,1.376400E-04,5.034800E-04,2.409300E-03,&
     & 3.533700E-02,2.580900E-01,6.647900E-01,1.904900E+00,7.034200E+00,&
     & 7.435000E+01,1.312700E+03,4.396600E+03,1.195900E-07,2.855900E-07,&
     & 9.061100E-07,4.263000E-06,2.226700E-05,7.549700E-05,2.695800E-04,&
     & 1.293600E-03,1.862700E-02,1.353500E-01,3.494100E-01,1.017700E+00,&
     & 3.999100E+00,4.151500E+01,6.567900E+02,2.198100E+03,3.942200E-08,&
     & 7.999500E-08,1.376100E-07,2.709000E-07,5.142000E-07,1.178900E-06,&
     & 3.245000E-06,1.385900E-05,1.879900E-04,1.137400E-03,2.831900E-03,&
     & 7.979500E-03,2.227600E-02,1.511200E-01,1.271500E+01,1.126200E+02/
      data   absb(:,881:900) /                                          &
     & 7.963400E-08,2.787300E-07,1.187200E-06,1.027400E-05,9.021500E-05,&
     & 3.663400E-04,1.387700E-03,6.934700E-03,1.028200E-01,7.374900E-01,&
     & 1.866100E+00,5.142500E+00,1.982000E+01,2.273600E+02,3.569200E+03,&
     & 1.152900E+04,1.655600E-07,4.556900E-07,1.773000E-06,1.206700E-05,&
     & 8.117000E-05,3.023300E-04,1.124300E-03,5.625400E-03,8.444000E-02,&
     & 6.193500E-01,1.565300E+00,4.275400E+00,1.573700E+01,1.711500E+02,&
     & 2.676900E+03,8.646800E+03,1.723500E-07,4.690200E-07,1.722800E-06,&
     & 1.010100E-05,5.977000E-05,2.131300E-04,7.826100E-04,3.922600E-03,&
     & 5.815000E-02,4.290600E-01,1.090200E+00,3.065700E+00,1.162000E+01,&
     & 1.167000E+02,1.784600E+03,5.764400E+03,1.527000E-07,4.158400E-07,&
     & 1.427100E-06,7.007500E-06,3.441300E-05,1.166100E-04,4.186300E-04,&
     & 2.101900E-03,3.062400E-02,2.245300E-01,5.743200E-01,1.647600E+00,&
     & 6.646400E+00,6.424200E+01,8.923100E+02,2.882400E+03,4.988200E-08,&
     & 1.085600E-07,1.870600E-07,3.646800E-07,6.907500E-07,1.596300E-06,&
     & 4.486700E-06,1.911700E-05,2.849700E-04,1.737900E-03,4.175800E-03,&
     & 1.106400E-02,2.914800E-02,2.722800E-01,1.803000E+01,1.523200E+02,&
     & 9.500200E-08,3.981000E-07,2.056100E-06,1.799900E-05,1.390700E-04,&
     & 5.489500E-04,2.099100E-03,1.101800E-02,1.639700E-01,1.183900E+00,&
     & 2.904500E+00,8.049700E+00,3.199400E+01,3.395500E+02,4.637500E+03,&
     & 1.470200E+04,2.157000E-07,6.742500E-07,2.916100E-06,1.996400E-05,&
     & 1.229200E-04,4.537200E-04,1.702000E-03,8.939000E-03,1.351600E-01,&
     & 9.892800E-01,2.432100E+00,6.622500E+00,2.517400E+01,2.552700E+02,&
     & 3.478200E+03,1.102700E+04,2.259200E-07,6.928700E-07,2.760900E-06,&
     & 1.629100E-05,8.944700E-05,3.194400E-04,1.185200E-03,6.224200E-03,&
     & 9.314800E-02,6.861300E-01,1.701200E+00,4.764200E+00,1.841700E+01,&
     & 1.732600E+02,2.318800E+03,7.351300E+03,2.010200E-07,6.074000E-07,&
     & 2.213500E-06,1.098200E-05,5.071600E-05,1.740200E-04,6.341600E-04,&
     & 3.328400E-03,4.899400E-02,3.600200E-01,8.987000E-01,2.572200E+00,&
     & 1.054000E+01,9.406400E+01,1.159500E+03,3.675500E+03,6.314800E-08,&
     & 1.407300E-07,2.454400E-07,4.759300E-07,9.030700E-07,2.088800E-06,&
     & 6.005200E-06,2.564800E-05,4.129600E-04,2.503200E-03,5.961700E-03,&
     & 1.474300E-02,3.829700E-02,4.858700E-01,2.436400E+01,2.000900E+02,&
     & 1.210500E-07,6.044800E-07,3.532700E-06,2.974800E-05,2.028200E-04,&
     & 7.954300E-04,3.103000E-03,1.711300E-02,2.535300E-01,1.851200E+00,&
     & 4.357000E+00,1.218300E+01,4.957200E+01,4.825700E+02,5.824400E+03,&
     & 1.813900E+04,2.890700E-07,1.014300E-06,4.710200E-06,3.150200E-05,&
     & 1.768800E-04,6.571700E-04,2.524600E-03,1.387000E-02,2.094800E-01,&
     & 1.539500E+00,3.635700E+00,9.934900E+00,3.867500E+01,3.623600E+02,&
     & 4.368300E+03,1.360400E+04,3.048200E-07,1.026500E-06,4.322300E-06,&
     & 2.517300E-05,1.275300E-04,4.618100E-04,1.759500E-03,9.643900E-03,&
     & 1.445400E-01,1.067700E+00,2.556500E+00,7.183800E+00,2.792300E+01,&
     & 2.452100E+02,2.912000E+03,9.070000E+03,2.697600E-07,8.809700E-07,&
     & 3.354000E-06,1.642400E-05,7.159300E-05,2.506200E-04,9.416600E-04,&
     & 5.140100E-03,7.603000E-02,5.607500E-01,1.354600E+00,3.912200E+00,&
     & 1.593600E+01,1.316500E+02,1.456000E+03,4.535000E+03,7.924200E-08,&
     & 1.771200E-07,3.123100E-07,6.051000E-07,1.166500E-06,2.662100E-06,&
     & 7.806400E-06,3.373600E-05,5.797000E-04,3.523800E-03,7.984000E-03,&
     & 1.921100E-02,5.230000E-02,8.159800E-01,3.179200E+01,2.552800E+02,&
     & 1.618000E-07,9.354200E-07,5.870100E-06,4.662700E-05,2.825200E-04,&
     & 1.109900E-03,4.501200E-03,2.591900E-02,3.815100E-01,2.786200E+00,&
     & 6.392200E+00,1.798400E+01,7.360000E+01,6.584100E+02,7.114100E+03,&
     & 2.169600E+04,3.922400E-07,1.516600E-06,7.394300E-06,4.751900E-05,&
     & 2.438200E-04,9.189000E-04,3.675200E-03,2.100500E-02,3.157800E-01,&
     & 2.306500E+00,5.298000E+00,1.455500E+01,5.696600E+01,4.940800E+02,&
     & 5.335600E+03,1.627200E+04,4.143700E-07,1.505200E-06,6.572900E-06,&
     & 3.715900E-05,1.749200E-04,6.452000E-04,2.562700E-03,1.457500E-02,&
     & 2.182300E-01,1.600900E+00,3.743200E+00,1.057300E+01,4.063800E+01,&
     & 3.335100E+02,3.557000E+03,1.084600E+04,3.632200E-07,1.258700E-06,&
     & 4.943200E-06,2.355600E-05,9.770200E-05,3.491700E-04,1.371600E-03,&
     & 7.753900E-03,1.149900E-01,8.398100E-01,1.990400E+00,5.822000E+00,&
     & 2.306800E+01,1.774400E+02,1.778500E+03,5.423600E+03,9.693600E-08,&
     & 2.175800E-07,3.936400E-07,7.469700E-07,1.464900E-06,3.322600E-06,&
     & 9.918800E-06,4.361700E-05,7.906200E-04,4.739800E-03,1.051900E-02,&
     & 2.421400E-02,6.965000E-02,1.304300E+00,4.042400E+01,3.166600E+02/
      data   absb(:,901:920) /                                          &
     & 6.177400E-08,1.698300E-07,5.246300E-07,3.671200E-06,3.858700E-05,&
     & 1.716700E-04,6.505200E-04,3.109800E-03,4.767500E-02,3.382900E-01,&
     & 8.921100E-01,2.586900E+00,9.747100E+00,1.220500E+02,2.404000E+03,&
     & 8.253200E+03,1.040100E-07,2.462400E-07,7.640600E-07,4.708500E-06,&
     & 3.579800E-05,1.415600E-04,5.274100E-04,2.527300E-03,3.903300E-02,&
     & 2.848200E-01,7.578100E-01,2.174100E+00,7.858400E+00,9.210200E+01,&
     & 1.803000E+03,6.189900E+03,1.060700E-07,2.404700E-07,7.478900E-07,&
     & 4.082100E-06,2.687300E-05,9.969700E-05,3.673800E-04,1.764500E-03,&
     & 2.687500E-02,1.969900E-01,5.267400E-01,1.548600E+00,5.826700E+00,&
     & 6.333200E+01,1.202000E+03,4.126200E+03,9.139400E-08,2.074200E-07,&
     & 6.322400E-07,2.934400E-06,1.589500E-05,5.462100E-05,1.966500E-04,&
     & 9.470800E-04,1.416700E-02,1.033900E-01,2.769900E-01,8.260300E-01,&
     & 3.302000E+00,3.543200E+01,6.015500E+02,2.063300E+03,2.923800E-08,&
     & 5.587400E-08,9.426900E-08,1.890200E-07,3.628400E-07,8.217700E-07,&
     & 2.292800E-06,9.937000E-06,1.359100E-04,8.186100E-04,2.058700E-03,&
     & 6.233000E-03,1.819600E-02,1.159500E-01,1.086100E+01,9.915800E+01,&
     & 6.536600E-08,2.131600E-07,8.273300E-07,6.980800E-06,6.497300E-05,&
     & 2.697800E-04,1.029100E-03,5.178400E-03,7.968300E-02,5.820000E-01,&
     & 1.520300E+00,4.274100E+00,1.670400E+01,1.989900E+02,3.340100E+03,&
     & 1.092500E+04,1.273200E-07,3.339200E-07,1.232600E-06,8.357400E-06,&
     & 5.878400E-05,2.227000E-04,8.337800E-04,4.206800E-03,6.554000E-02,&
     & 4.906800E-01,1.281200E+00,3.570200E+00,1.330200E+01,1.498500E+02,&
     & 2.505100E+03,8.193900E+03,1.315100E-07,3.393900E-07,1.200700E-06,&
     & 7.049500E-06,4.340400E-05,1.568800E-04,5.803500E-04,2.933900E-03,&
     & 4.512000E-02,3.401300E-01,8.920600E-01,2.559100E+00,9.837600E+00,&
     & 1.022800E+02,1.670000E+03,5.462500E+03,1.152600E-07,2.985200E-07,&
     & 1.000500E-06,4.915800E-06,2.511800E-05,8.577200E-05,3.102400E-04,&
     & 1.572500E-03,2.375600E-02,1.781600E-01,4.697000E-01,1.374500E+00,&
     & 5.616500E+00,5.639300E+01,8.351200E+02,2.731200E+03,3.607500E-08,&
     & 7.737300E-08,1.309200E-07,2.586200E-07,4.934000E-07,1.133500E-06,&
     & 3.214100E-06,1.398700E-05,2.095200E-04,1.263400E-03,3.107700E-03,&
     & 8.678000E-03,2.455200E-02,2.117700E-01,1.577700E+01,1.355600E+02,&
     & 7.541600E-08,2.940000E-07,1.417400E-06,1.253300E-05,1.024700E-04,&
     & 4.103300E-04,1.581600E-03,8.394700E-03,1.296600E-01,9.636500E-01,&
     & 2.434300E+00,6.848500E+00,2.753200E+01,3.042500E+02,4.412700E+03,&
     & 1.409800E+04,1.632100E-07,4.857900E-07,2.034200E-06,1.412900E-05,&
     & 9.096000E-05,3.391100E-04,1.283200E-03,6.822800E-03,1.070800E-01,&
     & 8.085700E-01,2.041500E+00,5.667100E+00,2.170600E+01,2.287600E+02,&
     & 3.309500E+03,1.057400E+04,1.696700E-07,4.980200E-07,1.937600E-06,&
     & 1.159800E-05,6.635500E-05,2.385900E-04,8.929100E-04,4.753800E-03,&
     & 7.380400E-02,5.608100E-01,1.426500E+00,4.078700E+00,1.592200E+01,&
     & 1.553400E+02,2.206300E+03,7.049900E+03,1.498500E-07,4.368100E-07,&
     & 1.565700E-06,7.874100E-06,3.772000E-05,1.299300E-04,4.768700E-04,&
     & 2.541800E-03,3.883700E-02,2.941800E-01,7.529200E-01,2.199700E+00,&
     & 9.111200E+00,8.441500E+01,1.103100E+03,3.525000E+03,4.628600E-08,&
     & 1.017300E-07,1.746000E-07,3.416400E-07,6.525100E-07,1.502200E-06,&
     & 4.360800E-06,1.908500E-05,3.099100E-04,1.879500E-03,4.506200E-03,&
     & 1.193500E-02,3.185900E-02,3.874900E-01,2.169300E+01,1.801500E+02,&
     & 9.386300E-08,4.377700E-07,2.455200E-06,2.119900E-05,1.524100E-04,&
     & 6.028900E-04,2.368700E-03,1.329300E-02,2.050600E-01,1.545700E+00,&
     & 3.720500E+00,1.062300E+01,4.351600E+01,4.410400E+02,5.611500E+03,&
     & 1.762800E+04,2.165600E-07,7.286700E-07,3.322100E-06,2.272500E-05,&
     & 1.333400E-04,4.987000E-04,1.927300E-03,1.079900E-02,1.698000E-01,&
     & 1.289400E+00,3.114200E+00,8.688000E+00,3.401700E+01,3.312200E+02,&
     & 4.208700E+03,1.322100E+04,2.268200E-07,7.391200E-07,3.070200E-06,&
     & 1.825300E-05,9.628300E-05,3.504000E-04,1.342200E-03,7.511300E-03,&
     & 1.171400E-01,8.945800E-01,2.186800E+00,6.273300E+00,2.464500E+01,&
     & 2.241300E+02,2.805800E+03,8.813900E+03,2.001800E-07,6.363200E-07,&
     & 2.400400E-06,1.200800E-05,5.413100E-05,1.900100E-04,7.173700E-04,&
     & 4.005800E-03,6.162800E-02,4.697300E-01,1.158500E+00,3.405400E+00,&
     & 1.407100E+01,1.203600E+02,1.403000E+03,4.407100E+03,5.826100E-08,&
     & 1.296600E-07,2.255300E-07,4.389500E-07,8.417600E-07,1.942100E-06,&
     & 5.739000E-06,2.545100E-05,4.409500E-04,2.710400E-03,6.137700E-03,&
     & 1.578000E-02,4.236800E-02,6.695000E-01,2.865900E+01,2.325800E+02/
      data   absb(:,921:940) /                                          &
     & 1.233400E-07,6.752200E-07,4.142300E-06,3.389300E-05,2.158500E-04,&
     & 8.526800E-04,3.476500E-03,2.052100E-02,3.151500E-01,2.381200E+00,&
     & 5.556400E+00,1.591400E+01,6.591300E+01,6.118200E+02,6.927400E+03,&
     & 2.133400E+04,2.928500E-07,1.095300E-06,5.285100E-06,3.494500E-05,&
     & 1.866100E-04,7.061200E-04,2.840300E-03,1.666800E-02,2.614700E-01,&
     & 1.975500E+00,4.624300E+00,1.290600E+01,5.109400E+01,4.591400E+02,&
     & 5.195600E+03,1.600000E+04,3.080700E-07,1.090500E-06,4.730500E-06,&
     & 2.746100E-05,1.338700E-04,4.955900E-04,1.979700E-03,1.157400E-02,&
     & 1.807400E-01,1.370800E+00,3.263800E+00,9.365100E+00,3.654000E+01,&
     & 3.098700E+02,3.463600E+03,1.066800E+04,2.698600E-07,9.160000E-07,&
     & 3.584000E-06,1.752900E-05,7.476200E-05,2.680800E-04,1.058000E-03,&
     & 6.152200E-03,9.522600E-02,7.192500E-01,1.734600E+00,5.139200E+00,&
     & 2.076200E+01,1.648000E+02,1.731800E+03,5.333800E+03,7.184300E-08,&
     & 1.604200E-07,2.842400E-07,5.498500E-07,1.068800E-06,2.446400E-06,&
     & 7.361600E-06,3.336300E-05,6.082000E-04,3.610500E-03,8.387900E-03,&
     & 2.041500E-02,5.795600E-02,1.087200E+00,3.680800E+01,2.887700E+02,&
     & 5.320600E-08,1.374800E-07,3.965900E-07,2.483500E-06,2.720400E-05,&
     & 1.253100E-04,4.788900E-04,2.291800E-03,3.654800E-02,2.599800E-01,&
     & 6.994400E-01,2.109800E+00,8.080400E+00,1.041000E+02,2.203000E+03,&
     & 7.788600E+03,8.310300E-08,1.910500E-07,5.517800E-07,3.229900E-06,&
     & 2.541200E-05,1.033300E-04,3.879800E-04,1.863600E-03,2.994300E-02,&
     & 2.196200E-01,5.973000E-01,1.780400E+00,6.544200E+00,7.860100E+01,&
     & 1.652300E+03,5.841400E+03,8.362600E-08,1.807400E-07,5.344000E-07,&
     & 2.816800E-06,1.914600E-05,7.275400E-05,2.700900E-04,1.300800E-03,&
     & 2.061000E-02,1.518800E-01,4.154400E-01,1.266300E+00,4.852800E+00,&
     & 5.413400E+01,1.101500E+03,3.894300E+03,7.104200E-08,1.529400E-07,&
     & 4.472200E-07,2.035800E-06,1.139700E-05,3.978100E-05,1.444800E-04,&
     & 6.978900E-04,1.086500E-02,7.950600E-02,2.189200E-01,6.742600E-01,&
     & 2.747100E+00,3.032000E+01,5.513700E+02,1.947100E+03,2.041800E-08,&
     & 4.073400E-08,6.593000E-08,1.334200E-07,2.575300E-07,5.826000E-07,&
     & 1.635600E-06,7.197900E-06,9.991700E-05,6.036300E-04,1.515900E-03,&
     & 4.850900E-03,1.548000E-02,8.943700E-02,9.281300E+00,8.756200E+01,&
     & 5.459900E-08,1.668500E-07,5.921000E-07,4.789500E-06,4.700900E-05,&
     & 2.002800E-04,7.695600E-04,3.891300E-03,6.227900E-02,4.597400E-01,&
     & 1.238600E+00,3.576400E+00,1.420800E+01,1.747600E+02,3.129700E+03,&
     & 1.039900E+04,9.931400E-08,2.502700E-07,8.714000E-07,5.833800E-06,&
     & 4.277800E-05,1.652000E-04,6.238500E-04,3.167000E-03,5.120900E-02,&
     & 3.894000E-01,1.049500E+00,2.999900E+00,1.134300E+01,1.316600E+02,&
     & 2.347300E+03,7.799600E+03,1.017100E-07,2.497100E-07,8.480300E-07,&
     & 4.951600E-06,3.168900E-05,1.162500E-04,4.339600E-04,2.208900E-03,&
     & 3.525400E-02,2.698200E-01,7.310500E-01,2.148700E+00,8.391600E+00,&
     & 8.994300E+01,1.564900E+03,5.199500E+03,8.807400E-08,2.171200E-07,&
     & 7.081700E-07,3.472100E-06,1.841600E-05,6.351700E-05,2.317000E-04,&
     & 1.184200E-03,1.856600E-02,1.415500E-01,3.849300E-01,1.152900E+00,&
     & 4.779300E+00,4.964700E+01,7.826500E+02,2.600000E+03,2.666900E-08,&
     & 5.554100E-08,9.356200E-08,1.847500E-07,3.566800E-07,8.131200E-07,&
     & 2.329900E-06,1.033100E-05,1.565300E-04,9.502300E-04,2.363900E-03,&
     & 6.966500E-03,2.110800E-02,1.648700E-01,1.381800E+01,1.209900E+02,&
     & 6.098100E-08,2.220500E-07,9.939600E-07,8.793300E-06,7.592300E-05,&
     & 3.088100E-04,1.199800E-03,6.439000E-03,1.031800E-01,7.857800E-01,&
     & 2.047500E+00,5.861900E+00,2.386500E+01,2.736300E+02,4.208100E+03,&
     & 1.355400E+04,1.251500E-07,3.558000E-07,1.434500E-06,1.006200E-05,&
     & 6.768000E-05,2.552400E-04,9.738500E-04,5.244100E-03,8.533200E-02,&
     & 6.618900E-01,1.723300E+00,4.874600E+00,1.884500E+01,2.057800E+02,&
     & 3.156100E+03,1.016500E+04,1.291700E-07,3.624100E-07,1.372200E-06,&
     & 8.307700E-06,4.945900E-05,1.795500E-04,6.771400E-04,3.653100E-03,&
     & 5.880800E-02,4.593100E-01,1.203000E+00,3.509400E+00,1.385600E+01,&
     & 1.397700E+02,2.104100E+03,6.776900E+03,1.130500E-07,3.170900E-07,&
     & 1.116000E-06,5.672200E-06,2.818800E-05,9.776500E-05,3.613800E-04,&
     & 1.953800E-03,3.096200E-02,2.409100E-01,6.344300E-01,1.893400E+00,&
     & 7.917300E+00,7.599800E+01,1.051900E+03,3.388200E+03,3.417100E-08,&
     & 7.408800E-08,1.261900E-07,2.476100E-07,4.763000E-07,1.096300E-06,&
     & 3.200700E-06,1.434400E-05,2.370300E-04,1.436600E-03,3.512900E-03,&
     & 9.733600E-03,2.807000E-02,3.088000E-01,1.934100E+01,1.625700E+02/
      data   absb(:,941:960) /                                          &
     & 7.399200E-08,3.226500E-07,1.725800E-06,1.520200E-05,1.151600E-04,&
     & 4.601500E-04,1.822200E-03,1.039700E-02,1.668800E-01,1.293000E+00,&
     & 3.198700E+00,9.312800E+00,3.843900E+01,4.047000E+02,5.421400E+03,&
     & 1.715800E+04,1.641600E-07,5.295300E-07,2.362400E-06,1.650300E-05,&
     & 1.010700E-04,3.806100E-04,1.483300E-03,8.464900E-03,1.383900E-01,&
     & 1.082900E+00,2.683800E+00,7.648800E+00,3.008400E+01,3.039800E+02,&
     & 4.066000E+03,1.286900E+04,1.706600E-07,5.372300E-07,2.197300E-06,&
     & 1.330500E-05,7.308900E-05,2.673100E-04,1.032000E-03,5.889200E-03,&
     & 9.548700E-02,7.514700E-01,1.882800E+00,5.516300E+00,2.186100E+01,&
     & 2.056900E+02,2.710700E+03,8.579100E+03,1.499500E-07,4.632300E-07,&
     & 1.729200E-06,8.816800E-06,4.112900E-05,1.448800E-04,5.507000E-04,&
     & 3.142300E-03,5.023600E-02,3.945000E-01,9.972100E-01,2.988100E+00,&
     & 1.248400E+01,1.104500E+02,1.355300E+03,4.288900E+03,4.310000E-08,&
     & 9.583000E-08,1.644400E-07,3.224000E-07,6.173600E-07,1.434000E-06,&
     & 4.263200E-06,1.939700E-05,3.417100E-04,2.125000E-03,4.913100E-03,&
     & 1.312400E-02,3.671600E-02,5.471100E-01,2.590200E+01,2.121500E+02,&
     & 9.540100E-08,4.935500E-07,2.948000E-06,2.480000E-05,1.656800E-04,&
     & 6.598800E-04,2.706400E-03,1.637100E-02,2.618500E-01,2.041800E+00,&
     & 4.861300E+00,1.421000E+01,5.931100E+01,5.705900E+02,6.764100E+03,&
     & 2.101100E+04,2.207400E-07,7.977700E-07,3.805200E-06,2.582800E-05,&
     & 1.436400E-04,5.463600E-04,2.211300E-03,1.331700E-02,2.176700E-01,&
     & 1.699000E+00,4.060400E+00,1.154300E+01,4.604000E+01,4.282300E+02,&
     & 5.073100E+03,1.575800E+04,2.310600E-07,7.961700E-07,3.427000E-06,&
     & 2.039700E-05,1.030700E-04,3.832000E-04,1.540500E-03,9.250400E-03,&
     & 1.504500E-01,1.179000E+00,2.863800E+00,8.363500E+00,3.300700E+01,&
     & 2.890000E+02,3.382100E+03,1.050500E+04,2.020000E-07,6.711100E-07,&
     & 2.613100E-06,1.309300E-05,5.755600E-05,2.070900E-04,8.223400E-04,&
     & 4.918500E-03,7.926300E-02,6.188000E-01,1.521600E+00,4.572700E+00,&
     & 1.876500E+01,1.536300E+02,1.691000E+03,5.253100E+03,5.367900E-08,&
     & 1.200000E-07,2.085500E-07,4.081400E-07,7.881100E-07,1.820200E-06,&
     & 5.527300E-06,2.574100E-05,4.761700E-04,2.871600E-03,6.810200E-03,&
     & 1.735200E-02,4.798200E-02,9.113500E-01,3.360200E+01,2.688500E+02,&
     & 4.628200E-08,1.131000E-07,3.078000E-07,1.701100E-06,1.913200E-05,&
     & 9.163300E-05,3.534400E-04,1.692800E-03,2.795200E-02,2.013200E-01,&
     & 5.432400E-01,1.715300E+00,6.697400E+00,8.859100E+01,2.012800E+03,&
     & 7.365300E+03,6.715100E-08,1.509500E-07,4.072400E-07,2.225600E-06,&
     & 1.802200E-05,7.550900E-05,2.863500E-04,1.376700E-03,2.296900E-02,&
     & 1.691000E-01,4.672500E-01,1.455100E+00,5.450600E+00,6.691800E+01,&
     & 1.509600E+03,5.524000E+03,6.643600E-08,1.387300E-07,3.877200E-07,&
     & 1.950400E-06,1.362000E-05,5.312800E-05,1.991200E-04,9.602300E-04,&
     & 1.581100E-02,1.167400E-01,3.254600E-01,1.034100E+00,4.040100E+00,&
     & 4.616100E+01,1.006400E+03,3.682700E+03,5.611700E-08,1.141600E-07,&
     & 3.190900E-07,1.415400E-06,8.158500E-06,2.902000E-05,1.063600E-04,&
     & 5.138200E-04,8.341700E-03,6.110700E-02,1.717200E-01,5.498100E-01,&
     & 2.283500E+00,2.588100E+01,5.039000E+02,1.841200E+03,1.431000E-08,&
     & 2.893000E-08,4.715200E-08,9.490000E-08,1.825100E-07,4.146400E-07,&
     & 1.168000E-06,5.224600E-06,7.467100E-05,4.448500E-04,1.129700E-03,&
     & 3.801100E-03,1.289700E-02,7.082500E-02,7.892700E+00,7.723100E+01,&
     & 4.629300E-08,1.329700E-07,4.338900E-07,3.295300E-06,3.401500E-05,&
     & 1.489100E-04,5.763100E-04,2.927200E-03,4.881700E-02,3.604100E-01,&
     & 1.005400E+00,2.996900E+00,1.210500E+01,1.531500E+02,2.927600E+03,&
     & 9.918900E+03,7.846400E-08,1.910400E-07,6.237600E-07,4.079000E-06,&
     & 3.110400E-05,1.227000E-04,4.673800E-04,2.383900E-03,4.017100E-02,&
     & 3.065600E-01,8.563200E-01,2.523100E+00,9.689400E+00,1.154200E+02,&
     & 2.195700E+03,7.439200E+03,7.961100E-08,1.860300E-07,6.044200E-07,&
     & 3.479400E-06,2.311200E-05,8.627900E-05,3.250200E-04,1.662800E-03,&
     & 2.764100E-02,2.128200E-01,5.962300E-01,1.805400E+00,7.174200E+00,&
     & 7.891400E+01,1.463800E+03,4.959400E+03,6.795200E-08,1.594400E-07,&
     & 5.038700E-07,2.453700E-06,1.349300E-05,4.709900E-05,1.733200E-04,&
     & 8.910300E-04,1.455500E-02,1.116100E-01,3.142600E-01,9.676500E-01,&
     & 4.072900E+00,4.361100E+01,7.320600E+02,2.466000E+03,2.031300E-08,&
     & 3.964900E-08,6.684800E-08,1.327300E-07,2.574200E-07,5.880700E-07,&
     & 1.690200E-06,7.638800E-06,1.181400E-04,7.315700E-04,1.784400E-03,&
     & 5.553900E-03,1.823400E-02,1.280800E-01,1.204600E+01,1.079800E+02/
      data   absb(:,961:980) /                                          &
     & 5.008400E-08,1.708900E-07,7.057800E-07,6.174600E-06,5.625100E-05,&
     & 2.329200E-04,9.114200E-04,4.942900E-03,8.250800E-02,6.358200E-01,&
     & 1.718000E+00,5.026500E+00,2.072600E+01,2.459100E+02,4.009800E+03,&
     & 1.304700E+04,9.703600E-08,2.638700E-07,1.018300E-06,7.168900E-06,&
     & 5.035100E-05,1.924900E-04,7.398200E-04,4.031900E-03,6.821900E-02,&
     & 5.386900E-01,1.452300E+00,4.197200E+00,1.639200E+01,1.849700E+02,&
     & 3.007300E+03,9.785200E+03,9.928800E-08,2.660900E-07,9.766100E-07,&
     & 5.954400E-06,3.686400E-05,1.352900E-04,5.142400E-04,2.808700E-03,&
     & 4.698300E-02,3.742300E-01,1.013600E+00,3.020500E+00,1.207600E+01,&
     & 1.256700E+02,2.004900E+03,6.523500E+03,8.602300E-08,2.314200E-07,&
     & 7.977300E-07,4.083200E-06,2.108200E-05,7.364600E-05,2.741000E-04,&
     & 1.502000E-03,2.470700E-02,1.965600E-01,5.345600E-01,1.629400E+00,&
     & 6.885600E+00,6.839100E+01,1.002500E+03,3.261500E+03,2.513700E-08,&
     & 5.411800E-08,9.167300E-08,1.801400E-07,3.485300E-07,8.037100E-07,&
     & 2.354300E-06,1.078100E-05,1.809600E-04,1.122500E-03,2.728800E-03,&
     & 8.031800E-03,2.429700E-02,2.463300E-01,1.720400E+01,1.465600E+02,&
     & 5.907100E-08,2.412100E-07,1.220200E-06,1.091200E-05,8.711700E-05,&
     & 3.523300E-04,1.404500E-03,8.136400E-03,1.358800E-01,1.080200E+00,&
     & 2.756000E+00,8.164100E+00,3.401000E+01,3.712500E+02,5.239900E+03,&
     & 1.670200E+04,1.255300E-07,3.878200E-07,1.685700E-06,1.199300E-05,&
     & 7.668600E-05,2.912300E-04,1.143700E-03,6.638900E-03,1.128500E-01,&
     & 9.077700E-01,2.317800E+00,6.734200E+00,2.664600E+01,2.788900E+02,&
     & 3.929900E+03,1.252700E+04,1.294800E-07,3.926200E-07,1.576200E-06,&
     & 9.704600E-06,5.552600E-05,2.043300E-04,7.954400E-04,4.618800E-03,&
     & 7.785900E-02,6.303000E-01,1.624400E+00,4.859300E+00,1.940200E+01,&
     & 1.887100E+02,2.620000E+03,8.351000E+03,1.130000E-07,3.386000E-07,&
     & 1.248100E-06,6.475400E-06,3.129600E-05,1.107200E-04,4.239500E-04,&
     & 2.465400E-03,4.097000E-02,3.307400E-01,8.601100E-01,2.628400E+00,&
     & 1.107700E+01,1.013300E+02,1.310000E+03,4.175200E+03,3.203600E-08,&
     & 7.092000E-08,1.208000E-07,2.377700E-07,4.561400E-07,1.061500E-06,&
     & 3.172900E-06,1.482700E-05,2.675400E-04,1.653100E-03,3.914700E-03,&
     & 1.098700E-02,3.144700E-02,4.464400E-01,2.338700E+01,1.932800E+02,&
     & 7.464000E-08,3.639100E-07,2.105000E-06,1.817300E-05,1.274200E-04,&
     & 5.116600E-04,2.113100E-03,1.306800E-02,2.177600E-01,1.749800E+00,&
     & 4.263600E+00,1.273100E+01,5.341400E+01,5.323200E+02,6.610100E+03,&
     & 2.069300E+04,1.674700E-07,5.837000E-07,2.746300E-06,1.909700E-05,&
     & 1.107500E-04,4.236800E-04,1.726800E-03,1.065600E-02,1.813100E-01,&
     & 1.460200E+00,3.572500E+00,1.036400E+01,4.150800E+01,3.995300E+02,&
     & 4.957500E+03,1.552000E+04,1.742300E-07,5.833100E-07,2.487800E-06,&
     & 1.514400E-05,7.949000E-05,2.969700E-04,1.202300E-03,7.402000E-03,&
     & 1.253200E-01,1.013500E+00,2.517600E+00,7.496600E+00,2.982500E+01,&
     & 2.695900E+02,3.305000E+03,1.034700E+04,1.517000E-07,4.930400E-07,&
     & 1.907800E-06,9.786700E-06,4.438600E-05,1.603800E-04,6.409000E-04,&
     & 3.937200E-03,6.599900E-02,5.321900E-01,1.337600E+00,4.084200E+00,&
     & 1.696500E+01,1.432400E+02,1.652500E+03,5.173400E+03,4.021700E-08,&
     & 8.964300E-08,1.548800E-07,3.033400E-07,5.832400E-07,1.362300E-06,&
     & 4.162000E-06,1.992100E-05,3.785600E-04,2.317200E-03,5.460100E-03,&
     & 1.478400E-02,4.165900E-02,7.609800E-01,3.065400E+01,2.476000E+02,&
     & 4.062900E-08,9.443200E-08,2.446700E-07,1.177900E-06,1.334300E-05,&
     & 6.674800E-05,2.593300E-04,1.239900E-03,2.119900E-02,1.554700E-01,&
     & 4.165900E-01,1.382900E+00,5.513900E+00,7.483200E+01,1.827200E+03,&
     & 6.956200E+03,5.487500E-08,1.210000E-07,3.067200E-07,1.538100E-06,&
     & 1.268000E-05,5.495100E-05,2.102000E-04,1.009100E-03,1.745900E-02,&
     & 1.305200E-01,3.601200E-01,1.179300E+00,4.509900E+00,5.655100E+01,&
     & 1.370400E+03,5.217200E+03,5.334600E-08,1.083000E-07,2.854000E-07,&
     & 1.349700E-06,9.620500E-06,3.863700E-05,1.460800E-04,7.035700E-04,&
     & 1.202500E-02,9.006100E-02,2.510200E-01,8.369200E-01,3.345200E+00,&
     & 3.907200E+01,9.137300E+02,3.477800E+03,4.494000E-08,8.617300E-08,&
     & 2.292700E-07,9.815800E-07,5.793700E-06,2.107200E-05,7.795100E-05,&
     & 3.765000E-04,6.345200E-03,4.707500E-02,1.327000E-01,4.448900E-01,&
     & 1.885900E+00,2.192100E+01,4.576100E+02,1.738900E+03,9.909500E-09,&
     & 2.045400E-08,3.376600E-08,6.630500E-08,1.275700E-07,2.942300E-07,&
     & 8.275900E-07,3.752200E-06,5.510700E-05,3.316000E-04,8.377500E-04,&
     & 2.911100E-03,1.083900E-02,5.856800E-02,6.642800E+00,6.776200E+01/
      data   absb(:, 981:1000) /                                        &
     & 3.981000E-08,1.075400E-07,3.257700E-07,2.262300E-06,2.445700E-05,&
     & 1.103400E-04,4.307000E-04,2.189900E-03,3.808800E-02,2.834700E-01,&
     & 8.045100E-01,2.500100E+00,1.026500E+01,1.334000E+02,2.725600E+03,&
     & 9.456300E+03,6.275300E-08,1.481600E-07,4.513900E-07,2.841200E-06,&
     & 2.248900E-05,9.089800E-05,3.491700E-04,1.782900E-03,3.135400E-02,&
     & 2.404900E-01,6.907400E-01,2.114000E+00,8.239200E+00,1.005600E+02,&
     & 2.044200E+03,7.092200E+03,6.277900E-08,1.403100E-07,4.338200E-07,&
     & 2.434200E-06,1.676200E-05,6.380400E-05,2.425700E-04,1.243000E-03,&
     & 2.157100E-02,1.666600E-01,4.814800E-01,1.511000E+00,6.106600E+00,&
     & 6.880400E+01,1.362700E+03,4.728400E+03,5.304500E-08,1.178400E-07,&
     & 3.590600E-07,1.726600E-06,9.834200E-06,3.477300E-05,1.291900E-04,&
     & 6.657900E-04,1.135300E-02,8.743300E-02,2.540400E-01,8.082400E-01,&
     & 3.459400E+00,3.804800E+01,6.816700E+02,2.364200E+03,1.435500E-08,&
     & 2.888400E-08,4.740900E-08,9.486500E-08,1.842700E-07,4.218500E-07,&
     & 1.216500E-06,5.610000E-06,8.806900E-05,5.507800E-04,1.342400E-03,&
     & 4.428500E-03,1.530700E-02,9.973700E-02,1.040900E+01,9.603400E+01,&
     & 4.174900E-08,1.336500E-07,5.067200E-07,4.317000E-06,4.149000E-05,&
     & 1.752500E-04,6.904800E-04,3.766500E-03,6.561900E-02,5.118400E-01,&
     & 1.430300E+00,4.299300E+00,1.796900E+01,2.200000E+02,3.809800E+03,&
     & 1.254400E+04,7.593500E-08,1.980300E-07,7.255500E-07,5.085400E-06,&
     & 3.727200E-05,1.447200E-04,5.607900E-04,3.079500E-03,5.432100E-02,&
     & 4.350100E-01,1.214600E+00,3.603800E+00,1.423100E+01,1.655300E+02,&
     & 2.857300E+03,9.408100E+03,7.694500E-08,1.966400E-07,6.959500E-07,&
     & 4.246800E-06,2.734700E-05,1.016100E-04,3.896200E-04,2.144700E-03,&
     & 3.741600E-02,3.021100E-01,8.478300E-01,2.592000E+00,1.049200E+01,&
     & 1.125100E+02,1.904900E+03,6.272100E+03,6.593200E-08,1.692500E-07,&
     & 5.700100E-07,2.926000E-06,1.569700E-05,5.527700E-05,2.073300E-04,&
     & 1.146400E-03,1.969200E-02,1.586800E-01,4.473000E-01,1.397200E+00,&
     & 5.970200E+00,6.125100E+01,9.524000E+02,3.135800E+03,1.854700E-08,&
     & 3.931400E-08,6.599100E-08,1.302600E-07,2.531100E-07,5.838600E-07,&
     & 1.720800E-06,8.063200E-06,1.368000E-04,8.700800E-04,2.096100E-03,&
     & 6.498800E-03,2.078200E-02,1.957300E-01,1.520500E+01,1.316300E+02,&
     & 4.773400E-08,1.825600E-07,8.651600E-07,7.796900E-06,6.569800E-05,&
     & 2.689600E-04,1.078500E-03,6.326100E-03,1.101800E-01,8.969700E-01,&
     & 2.366100E+00,7.136200E+00,3.002200E+01,3.394400E+02,5.057500E+03,&
     & 1.622800E+04,9.667200E-08,2.856500E-07,1.201800E-06,8.677200E-06,&
     & 5.801900E-05,2.224600E-04,8.781500E-04,5.172900E-03,9.159300E-02,&
     & 7.569000E-01,1.996800E+00,5.909300E+00,2.353900E+01,2.550300E+02,&
     & 3.793100E+03,1.217100E+04,9.892700E-08,2.876700E-07,1.128900E-06,&
     & 7.053100E-06,4.206700E-05,1.559800E-04,6.103900E-04,3.599400E-03,&
     & 6.319100E-02,5.256100E-01,1.398500E+00,4.265400E+00,1.717300E+01,&
     & 1.725600E+02,2.528800E+03,8.113900E+03,8.555900E-08,2.475700E-07,&
     & 8.988400E-07,4.733300E-06,2.374100E-05,8.449700E-05,3.249100E-04,&
     & 1.922400E-03,3.325400E-02,2.757600E-01,7.398400E-01,2.307600E+00,&
     & 9.794200E+00,9.262100E+01,1.264300E+03,4.056300E+03,2.378800E-08,&
     & 5.155200E-08,8.864600E-08,1.738400E-07,3.345400E-07,7.802900E-07,&
     & 2.347400E-06,1.126500E-05,2.064100E-04,1.267200E-03,3.091200E-03,&
     & 9.077700E-03,2.761500E-02,3.616700E-01,2.100800E+01,1.754400E+02,&
     & 5.900200E-08,2.700600E-07,1.501100E-06,1.326100E-05,9.776900E-05,&
     & 3.963800E-04,1.644900E-03,1.036300E-02,1.803900E-01,1.492700E+00,&
     & 3.736400E+00,1.138800E+01,4.797600E+01,4.956300E+02,6.454400E+03,&
     & 2.021400E+04,1.276300E-07,4.278200E-07,1.977700E-06,1.407500E-05,&
     & 8.519900E-05,3.281400E-04,1.344800E-03,8.471000E-03,1.504400E-01,&
     & 1.249300E+00,3.139300E+00,9.294900E+00,3.731100E+01,3.720100E+02,&
     & 4.840800E+03,1.526600E+04,1.318600E-07,4.275000E-07,1.801200E-06,&
     & 1.120300E-05,6.120000E-05,2.297800E-04,9.358500E-04,5.884200E-03,&
     & 1.039800E-01,8.674100E-01,2.210100E+00,6.711300E+00,2.686800E+01,&
     & 2.509900E+02,3.227200E+03,1.017700E+04,1.142300E-07,3.618700E-07,&
     & 1.389000E-06,7.283700E-06,3.418400E-05,1.239700E-04,4.983000E-04,&
     & 3.130200E-03,5.476200E-02,4.555100E-01,1.173800E+00,3.647500E+00,&
     & 1.528400E+01,1.332600E+02,1.613500E+03,5.089700E+03,2.993200E-08,&
     & 6.623900E-08,1.141100E-07,2.248500E-07,4.307400E-07,1.011400E-06,&
     & 3.117700E-06,1.537000E-05,2.976600E-04,1.845800E-03,4.323000E-03,&
     & 1.258400E-02,3.588300E-02,6.320900E-01,2.786300E+01,2.271400E+02/
      data   absb(:,1001:1020) /                                        &
     & 3.597500E-08,7.993900E-08,1.989300E-07,8.308900E-07,9.228600E-06,&
     & 4.838700E-05,1.889300E-04,9.021600E-04,1.591700E-02,1.200300E-01,&
     & 3.178400E-01,1.099600E+00,4.508900E+00,6.265500E+01,1.645500E+03,&
     & 6.570700E+03,4.539900E-08,9.827200E-08,2.365500E-07,1.068700E-06,&
     & 8.843800E-06,3.978900E-05,1.532400E-04,7.340800E-04,1.312400E-02,&
     & 1.005100E-01,2.747000E-01,9.444800E-01,3.705000E+00,4.737800E+01,&
     & 1.234100E+03,4.889600E+03,4.277100E-08,8.630700E-08,2.139800E-07,&
     & 9.351800E-07,6.739400E-06,2.795600E-05,1.064300E-04,5.116400E-04,&
     & 9.046900E-03,6.926800E-02,1.911200E-01,6.699900E-01,2.748600E+00,&
     & 3.278600E+01,8.227500E+02,3.285400E+03,3.620000E-08,6.601200E-08,&
     & 1.665000E-07,6.799700E-07,4.079600E-06,1.522400E-05,5.676500E-05,&
     & 2.734000E-04,4.772800E-03,3.624800E-02,1.009900E-01,3.561800E-01,&
     & 1.544900E+00,1.840200E+01,4.121800E+02,1.642800E+03,6.763500E-09,&
     & 1.460400E-08,2.369700E-08,4.583100E-08,8.799000E-08,2.071000E-07,&
     & 5.801200E-07,2.659000E-06,4.022700E-05,2.445700E-04,6.010000E-04,&
     & 2.175200E-03,8.898800E-03,5.032400E-02,5.529200E+00,5.908600E+01,&
     & 3.467200E-08,8.827900E-08,2.508300E-07,1.555600E-06,1.746200E-05,&
     & 8.142200E-05,3.203000E-04,1.626200E-03,2.945300E-02,2.212000E-01,&
     & 6.373300E-01,2.071400E+00,8.659500E+00,1.153300E+02,2.522500E+03,&
     & 9.017800E+03,5.077600E-08,1.167300E-07,3.315900E-07,1.971100E-06,&
     & 1.614500E-05,6.705500E-05,2.597700E-04,1.327000E-03,2.429500E-02,&
     & 1.875400E-01,5.504300E-01,1.759800E+00,6.970100E+00,8.696100E+01,&
     & 1.891900E+03,6.763300E+03,4.976300E-08,1.075800E-07,3.142200E-07,&
     & 1.696600E-06,1.207100E-05,4.703400E-05,1.803300E-04,9.242500E-04,&
     & 1.672800E-02,1.298900E-01,3.837600E-01,1.256700E+00,5.164600E+00,&
     & 5.956200E+01,1.261300E+03,4.508800E+03,4.177800E-08,8.793700E-08,&
     & 2.568000E-07,1.208300E-06,7.120400E-06,2.556900E-05,9.598800E-05,&
     & 4.942500E-04,8.806400E-03,6.822600E-02,2.026300E-01,6.710500E-01,&
     & 2.921700E+00,3.294700E+01,6.310200E+02,2.254400E+03,1.000100E-08,&
     & 2.045100E-08,3.379200E-08,6.749700E-08,1.300400E-07,3.003200E-07,&
     & 8.679000E-07,4.081000E-06,6.542800E-05,4.079100E-04,1.015200E-03,&
     & 3.416400E-03,1.292800E-02,7.655500E-02,8.919900E+00,8.497300E+01,&
     & 3.532500E-08,1.062300E-07,3.692500E-07,3.004800E-06,3.039700E-05,&
     & 1.314300E-04,5.213300E-04,2.851300E-03,5.202000E-02,4.069400E-01,&
     & 1.181000E+00,3.665300E+00,1.553900E+01,1.956500E+02,3.605400E+03,&
     & 1.206300E+04,6.002000E-08,1.507800E-07,5.196300E-07,3.590800E-06,&
     & 2.743600E-05,1.084600E-04,4.230300E-04,2.332700E-03,4.305800E-02,&
     & 3.477500E-01,1.007700E+00,3.082700E+00,1.232400E+01,1.472500E+02,&
     & 2.704200E+03,9.047600E+03,6.015600E-08,1.465400E-07,4.971000E-07,&
     & 3.013100E-06,2.017700E-05,7.609200E-05,2.935900E-04,1.623700E-03,&
     & 2.965300E-02,2.417600E-01,7.033300E-01,2.214800E+00,9.085600E+00,&
     & 1.001400E+02,1.802800E+03,6.031700E+03,5.099800E-08,1.242500E-07,&
     & 4.070500E-07,2.084400E-06,1.162600E-05,4.132500E-05,1.560400E-04,&
     & 8.678900E-04,1.559900E-02,1.271200E-01,3.711800E-01,1.192600E+00,&
     & 5.156900E+00,5.456000E+01,9.014100E+02,3.015900E+03,1.372600E-08,&
     & 2.820800E-08,4.705700E-08,9.348500E-08,1.817300E-07,4.213200E-07,&
     & 1.245900E-06,5.966800E-06,1.027000E-04,6.505700E-04,1.579900E-03,&
     & 5.128900E-03,1.792200E-02,1.544100E-01,1.334200E+01,1.177000E+02,&
     & 3.913300E-08,1.401100E-07,6.162400E-07,5.543800E-06,4.931900E-05,&
     & 2.047800E-04,8.247400E-04,4.884300E-03,8.903100E-02,7.382400E-01,&
     & 2.018400E+00,6.220700E+00,2.642500E+01,3.090100E+02,4.870300E+03,&
     & 1.575500E+04,7.503800E-08,2.120300E-07,8.571600E-07,6.246800E-06,&
     & 4.368100E-05,1.693700E-04,6.714900E-04,4.000700E-03,7.395500E-02,&
     & 6.267000E-01,1.710900E+00,5.168000E+00,2.073500E+01,2.322000E+02,&
     & 3.652700E+03,1.181600E+04,7.614300E-08,2.115300E-07,8.076000E-07,&
     & 5.101600E-06,3.172200E-05,1.187200E-04,4.661200E-04,2.784600E-03,&
     & 5.099000E-02,4.355600E-01,1.198500E+00,3.728200E+00,1.515300E+01,&
     & 1.571100E+02,2.435200E+03,7.877200E+03,6.506300E-08,1.812900E-07,&
     & 6.455800E-07,3.438700E-06,1.794300E-05,6.423600E-05,2.478100E-04,&
     & 1.486600E-03,2.684300E-02,2.286200E-01,6.337700E-01,2.016600E+00,&
     & 8.625300E+00,8.432700E+01,1.217600E+03,3.938600E+03,1.748000E-08,&
     & 3.725500E-08,6.432700E-08,1.259400E-07,2.439200E-07,5.695400E-07,&
     & 1.725600E-06,8.487900E-06,1.563200E-04,9.873800E-04,2.363600E-03,&
     & 7.483600E-03,2.390700E-02,2.915900E-01,1.876600E+01,1.585800E+02/
      data   absb(:,1021:1040) /                                        &
     & 4.714000E-08,2.021100E-07,1.070100E-06,9.632800E-06,7.484800E-05,&
     & 3.066200E-04,1.274200E-03,8.161900E-03,1.487800E-01,1.266600E+00,&
     & 3.269300E+00,1.014400E+01,4.297900E+01,4.602400E+02,6.297000E+03,&
     & 1.999900E+04,9.779200E-08,3.144300E-07,1.420700E-06,1.032900E-05,&
     & 6.536900E-05,2.537400E-04,1.042400E-03,6.688500E-03,1.242700E-01,&
     & 1.063200E+00,2.752500E+00,8.305400E+00,3.344400E+01,3.454700E+02,&
     & 4.722800E+03,1.499900E+04,1.002600E-07,3.135700E-07,1.300600E-06,&
     & 8.244600E-06,4.702100E-05,1.775500E-04,7.249300E-04,4.647800E-03,&
     & 8.588900E-02,7.385200E-01,1.935500E+00,5.996700E+00,2.411900E+01,&
     & 2.330400E+02,3.148500E+03,9.999500E+03,8.627600E-08,2.653900E-07,&
     & 1.008100E-06,5.397800E-06,2.626900E-05,9.570500E-05,3.855800E-04,&
     & 2.473500E-03,4.524200E-02,3.876500E-01,1.027800E+00,3.250800E+00,&
     & 1.371900E+01,1.236300E+02,1.574200E+03,5.000000E+03,2.221100E-08,&
     & 4.831400E-08,8.370300E-08,1.645000E-07,3.171900E-07,7.467300E-07,&
     & 2.316400E-06,1.174400E-05,2.309500E-04,1.407700E-03,3.408600E-03,&
     & 1.039000E-02,3.130700E-02,5.201200E-01,2.523100E+01,2.075100E+02,&
     & 3.202600E-08,6.861200E-08,1.656900E-07,6.103400E-07,6.477000E-06,&
     & 3.554800E-05,1.396900E-04,6.693900E-04,1.211800E-02,9.396000E-02,&
     & 2.458700E-01,8.809600E-01,3.736900E+00,5.304600E+01,1.490500E+03,&
     & 6.272100E+03,3.817300E-08,8.085800E-08,1.882600E-07,7.640700E-07,&
     & 6.251500E-06,2.920100E-05,1.131700E-04,5.449700E-04,1.001400E-02,&
     & 7.877100E-02,2.129800E-01,7.600300E-01,3.084400E+00,4.013300E+01,&
     & 1.117900E+03,4.704100E+03,3.491300E-08,7.008000E-08,1.651600E-07,&
     & 6.637100E-07,4.777000E-06,2.049900E-05,7.856100E-05,3.791000E-04,&
     & 6.909300E-03,5.424000E-02,1.482900E-01,5.382800E-01,2.285500E+00,&
     & 2.781600E+01,7.452600E+02,3.136200E+03,2.955400E-08,5.108800E-08,&
     & 1.246300E-07,4.801600E-07,2.907400E-06,1.114200E-05,4.187000E-05,&
     & 2.022500E-04,3.647900E-03,2.840100E-02,7.820600E-02,2.865200E-01,&
     & 1.280600E+00,1.561100E+01,3.734300E+02,1.568100E+03,4.789500E-09,&
     & 1.095200E-08,1.734100E-08,3.196000E-08,6.261100E-08,1.488800E-07,&
     & 4.156300E-07,1.923900E-06,3.041300E-05,1.931600E-04,4.487400E-04,&
     & 1.702800E-03,7.596900E-03,4.254200E-02,4.624100E+00,5.187500E+01,&
     & 3.045900E-08,7.378600E-08,1.991600E-07,1.097700E-06,1.260800E-05,&
     & 6.086700E-05,2.419700E-04,1.227800E-03,2.315700E-02,1.767600E-01,&
     & 5.052400E-01,1.734200E+00,7.394500E+00,1.007400E+02,2.349400E+03,&
     & 8.674100E+03,4.171200E-08,9.390200E-08,2.509500E-07,1.393000E-06,&
     & 1.172400E-05,5.008000E-05,1.960700E-04,1.003000E-03,1.912200E-02,&
     & 1.498400E-01,4.389600E-01,1.479000E+00,5.970000E+00,7.598200E+01,&
     & 1.762100E+03,6.505600E+03,4.017200E-08,8.443100E-08,2.332300E-07,&
     & 1.202100E-06,8.783700E-06,3.510200E-05,1.360200E-04,6.983600E-04,&
     & 1.317200E-02,1.033600E-01,3.067400E-01,1.055900E+00,4.424100E+00,&
     & 5.207500E+01,1.174700E+03,4.337000E+03,3.341700E-08,6.705900E-08,&
     & 1.871600E-07,8.578400E-07,5.204400E-06,1.905300E-05,7.232500E-05,&
     & 3.731400E-04,6.936400E-03,5.412100E-02,1.623600E-01,5.637200E-01,&
     & 2.497600E+00,2.880300E+01,5.877800E+02,2.168200E+03,7.220200E-09,&
     & 1.495000E-08,2.474300E-08,4.901200E-08,9.422200E-08,2.195700E-07,&
     & 6.327300E-07,3.019400E-06,5.072000E-05,3.156800E-04,7.805400E-04,&
     & 2.771500E-03,1.117000E-02,6.432200E-02,7.666600E+00,7.562800E+01,&
     & 3.034400E-08,8.623600E-08,2.780000E-07,2.127000E-06,2.253200E-05,&
     & 9.990500E-05,4.001500E-04,2.198400E-03,4.192900E-02,3.286700E-01,&
     & 9.787000E-01,3.166000E+00,1.361000E+01,1.755700E+02,3.431700E+03,&
     & 1.170000E+04,4.824800E-08,1.175100E-07,3.808300E-07,2.570500E-06,&
     & 2.040500E-05,8.229400E-05,3.248700E-04,1.799600E-03,3.471100E-02,&
     & 2.796900E-01,8.420400E-01,2.670000E+00,1.080700E+01,1.321500E+02,&
     & 2.573800E+03,8.774800E+03,4.772800E-08,1.114800E-07,3.619800E-07,&
     & 2.163700E-06,1.504300E-05,5.767900E-05,2.252700E-04,1.251100E-03,&
     & 2.391300E-02,1.944700E-01,5.878400E-01,1.916200E+00,7.971400E+00,&
     & 8.988200E+01,1.715900E+03,5.849900E+03,3.999900E-08,9.290900E-08,&
     & 2.948900E-07,1.502400E-06,8.695000E-06,3.127800E-05,1.195100E-04,&
     & 6.677700E-04,1.257800E-02,1.023100E-01,3.105200E-01,1.030500E+00,&
     & 4.512800E+00,4.897600E+01,8.579300E+02,2.924900E+03,1.038700E-08,&
     & 2.068900E-08,3.459300E-08,6.867300E-08,1.341100E-07,3.116700E-07,&
     & 9.208100E-07,4.505600E-06,8.049900E-05,5.251200E-04,1.270100E-03,&
     & 4.240900E-03,1.612900E-02,1.216300E-01,1.174400E+01,1.059600E+02/
      data   absb(:,1041:1060) /                                        &
     & 3.265000E-08,1.101700E-07,4.495300E-07,3.996500E-06,3.739700E-05,&
     & 1.578400E-04,6.407500E-04,3.833100E-03,7.318200E-02,6.096500E-01,&
     & 1.736800E+00,5.491600E+00,2.356000E+01,2.838200E+02,4.717300E+03,&
     & 1.540400E+04,5.916900E-08,1.606500E-07,6.221800E-07,4.551400E-06,&
     & 3.321200E-05,1.304800E-04,5.216200E-04,3.145700E-03,6.082100E-02,&
     & 5.198000E-01,1.478700E+00,4.573300E+00,1.849400E+01,2.132900E+02,&
     & 3.538000E+03,1.155300E+04,5.945300E-08,1.582300E-07,5.863700E-07,&
     & 3.732000E-06,2.414500E-05,9.137600E-05,3.621800E-04,2.188600E-03,&
     & 4.191100E-02,3.616900E-01,1.035700E+00,3.296700E+00,1.353000E+01,&
     & 1.443100E+02,2.358700E+03,7.702000E+03,5.024100E-08,1.345800E-07,&
     & 4.694700E-07,2.522600E-06,1.368500E-05,4.939600E-05,1.921900E-04,&
     & 1.168700E-03,2.205400E-02,1.900300E-01,5.477500E-01,1.783300E+00,&
     & 7.683700E+00,7.741700E+01,1.179300E+03,3.851000E+03,1.320200E-08,&
     & 2.783700E-08,4.765700E-08,9.358700E-08,1.824500E-07,4.256900E-07,&
     & 1.292600E-06,6.496400E-06,1.245200E-04,8.097600E-04,1.934000E-03,&
     & 6.361400E-03,2.183800E-02,2.354200E-01,1.683600E+01,1.440400E+02,&
     & 3.829800E-08,1.546200E-07,7.765300E-07,7.083000E-06,5.787800E-05,&
     & 2.399000E-04,1.001100E-03,6.543200E-03,1.243400E-01,1.082200E+00,&
     & 2.893300E+00,9.131600E+00,3.894900E+01,4.307500E+02,6.181000E+03,&
     & 1.975200E+04,7.604000E-08,2.349500E-07,1.034800E-06,7.665400E-06,&
     & 5.064500E-05,1.984400E-04,8.197800E-04,5.370900E-03,1.039100E-01,&
     & 9.122300E-01,2.441900E+00,7.496200E+00,3.031100E+01,3.233500E+02,&
     & 4.635700E+03,1.481400E+04,7.730400E-08,2.332500E-07,9.510600E-07,&
     & 6.132900E-06,3.644400E-05,1.387900E-04,5.699200E-04,3.730700E-03,&
     & 7.180700E-02,6.337400E-01,1.716300E+00,5.412800E+00,2.188200E+01,&
     & 2.180600E+02,3.090500E+03,9.875800E+03,6.597500E-08,1.969800E-07,&
     & 7.396400E-07,4.035100E-06,2.038200E-05,7.472600E-05,3.027500E-04,&
     & 1.985900E-03,3.781000E-02,3.326900E-01,9.108200E-01,2.932500E+00,&
     & 1.243400E+01,1.155700E+02,1.545200E+03,4.937900E+03,1.681500E-08,&
     & 3.638300E-08,6.291400E-08,1.238200E-07,2.387100E-07,5.643200E-07,&
     & 1.753900E-06,9.110700E-06,1.870600E-04,1.175000E-03,2.844300E-03,&
     & 9.099600E-03,2.823900E-02,4.292700E-01,2.295500E+01,1.903000E+02,&
     & 2.867700E-08,5.973200E-08,1.404300E-07,4.638500E-07,4.585200E-06,&
     & 2.625400E-05,1.037000E-04,5.011100E-04,9.266300E-03,7.390600E-02,&
     & 1.941800E-01,7.008000E-01,3.114700E+00,4.501000E+01,1.350300E+03,&
     & 6.023100E+03,3.244100E-08,6.740300E-08,1.534800E-07,5.592100E-07,&
     & 4.439000E-06,2.155100E-05,8.406400E-05,4.075500E-04,7.678500E-03,&
     & 6.210700E-02,1.669800E-01,6.094100E-01,2.577700E+00,3.407600E+01,&
     & 1.012700E+03,4.517300E+03,2.874800E-08,5.777700E-08,1.305000E-07,&
     & 4.801900E-07,3.401600E-06,1.510900E-05,5.832000E-05,2.832100E-04,&
     & 5.303000E-03,4.286400E-02,1.158200E-01,4.313200E-01,1.905000E+00,&
     & 2.365600E+01,6.751700E+02,3.011600E+03,2.415100E-08,3.991500E-08,&
     & 9.579000E-08,3.433700E-07,2.076700E-06,8.201300E-06,3.103500E-05,&
     & 1.508100E-04,2.796200E-03,2.244500E-02,6.092400E-02,2.299100E-01,&
     & 1.063700E+00,1.327100E+01,3.383700E+02,1.505800E+03,3.545900E-09,&
     & 8.503700E-09,1.302100E-08,2.239400E-08,4.496100E-08,1.077600E-07,&
     & 3.012500E-07,1.402500E-06,2.333100E-05,1.559900E-04,3.520900E-04,&
     & 1.349700E-03,6.536900E-03,3.850800E-02,3.849600E+00,4.558300E+01,&
     & 2.698100E-08,6.257600E-08,1.619500E-07,7.898900E-07,9.136300E-06,&
     & 4.575600E-05,1.838600E-04,9.350200E-04,1.830300E-02,1.436900E-01,&
     & 3.979100E-01,1.455400E+00,6.343900E+00,8.826200E+01,2.192200E+03,&
     & 8.382300E+03,3.472000E-08,7.669000E-08,1.945400E-07,9.964000E-07,&
     & 8.546800E-06,3.759400E-05,1.489900E-04,7.636500E-04,1.516900E-02,&
     & 1.205000E-01,3.489200E-01,1.247100E+00,5.134700E+00,6.658000E+01,&
     & 1.644100E+03,6.286800E+03,3.239100E-08,6.786300E-08,1.766100E-07,&
     & 8.598600E-07,6.413800E-06,2.633000E-05,1.033000E-04,5.311300E-04,&
     & 1.045300E-02,8.313400E-02,2.439200E-01,8.893700E-01,3.805400E+00,&
     & 4.565500E+01,1.096100E+03,4.191200E+03,2.697400E-08,5.193000E-08,&
     & 1.384200E-07,6.131300E-07,3.813600E-06,1.426600E-05,5.488100E-05,&
     & 2.833800E-04,5.503900E-03,4.356700E-02,1.292900E-01,4.746300E-01,&
     & 2.145400E+00,2.523200E+01,5.485300E+02,2.095600E+03,5.356000E-09,&
     & 1.105900E-08,1.831000E-08,3.597700E-08,6.920400E-08,1.622700E-07,&
     & 4.662400E-07,2.249800E-06,4.006200E-05,2.533500E-04,6.318800E-04,&
     & 2.328200E-03,1.002400E-02,5.712300E-02,6.570800E+00,6.736200E+01/
      data   absb(:,1061:1080) /                                        &
     & 2.640900E-08,7.112600E-08,2.149800E-07,1.519200E-06,1.677000E-05,&
     & 7.638700E-05,3.095400E-04,1.707700E-03,3.413100E-02,2.676000E-01,&
     & 8.084500E-01,2.745800E+00,1.198500E+01,1.580500E+02,3.273900E+03,&
     & 1.139800E+04,3.935500E-08,9.320000E-08,2.840000E-07,1.851600E-06,&
     & 1.523800E-05,6.284000E-05,2.512300E-04,1.399300E-03,2.825800E-02,&
     & 2.282700E-01,6.994600E-01,2.324300E+00,9.522900E+00,1.189700E+02,&
     & 2.455400E+03,8.548800E+03,3.816700E-08,8.638200E-08,2.671400E-07,&
     & 1.562400E-06,1.125100E-05,4.398300E-05,1.741300E-04,9.726100E-04,&
     & 1.945400E-02,1.583500E-01,4.891200E-01,1.667100E+00,7.025800E+00,&
     & 8.093000E+01,1.637000E+03,5.699200E+03,3.173900E-08,7.039500E-08,&
     & 2.156100E-07,1.087800E-06,6.524500E-06,2.381300E-05,9.231200E-05,&
     & 5.189100E-04,1.023000E-02,8.309600E-02,2.589400E-01,8.949300E-01,&
     & 3.971300E+00,4.407300E+01,8.185300E+02,2.849600E+03,7.744800E-09,&
     & 1.557300E-08,2.576900E-08,5.150000E-08,1.002000E-07,2.332200E-07,&
     & 6.885000E-07,3.428900E-06,6.488700E-05,4.290900E-04,1.059100E-03,&
     & 3.658500E-03,1.433000E-02,9.551900E-02,1.032000E+01,9.554200E+01,&
     & 2.764900E-08,8.823000E-08,3.338400E-07,2.898000E-06,2.847500E-05,&
     & 1.223300E-04,5.020300E-04,3.034200E-03,6.067200E-02,5.035100E-01,&
     & 1.497000E+00,4.877800E+00,2.114500E+01,2.616100E+02,4.581800E+03,&
     & 1.512400E+04,4.721500E-08,1.237800E-07,4.566300E-07,3.332100E-06,&
     & 2.534300E-05,1.010500E-04,4.085500E-04,2.494100E-03,5.039800E-02,&
     & 4.310500E-01,1.280400E+00,4.070400E+00,1.660000E+01,1.966200E+02,&
     & 3.436400E+03,1.134300E+04,4.697000E-08,1.198400E-07,4.294600E-07,&
     & 2.742600E-06,1.843900E-05,7.072900E-05,2.833000E-04,1.733800E-03,&
     & 3.473300E-02,3.000600E-01,8.967800E-01,2.931800E+00,1.214800E+01,&
     & 1.330200E+02,2.291000E+03,7.561700E+03,3.914400E-08,1.008500E-07,&
     & 3.436700E-07,1.858100E-06,1.047400E-05,3.818400E-05,1.501900E-04,&
     & 9.245400E-04,1.827000E-02,1.578200E-01,4.742400E-01,1.585100E+00,&
     & 6.881400E+00,7.130100E+01,1.145500E+03,3.780800E+03,1.005600E-08,&
     & 2.122500E-08,3.573100E-08,7.076200E-08,1.379600E-07,3.224200E-07,&
     & 9.777200E-07,5.013100E-06,1.016900E-04,6.920200E-04,1.613800E-03,&
     & 5.567300E-03,1.992900E-02,1.900000E-01,1.509400E+01,1.309900E+02,&
     & 3.155300E-08,1.202600E-07,5.698000E-07,5.235600E-06,4.498800E-05,&
     & 1.886600E-04,7.935400E-04,5.283400E-03,1.046800E-01,9.245800E-01,&
     & 2.570000E+00,8.267000E+00,3.550500E+01,4.046600E+02,6.088800E+03,&
     & 1.956800E+04,5.977600E-08,1.776500E-07,7.595600E-07,5.713600E-06,&
     & 3.942300E-05,1.560400E-04,6.497600E-04,4.344700E-03,8.748800E-02,&
     & 7.828800E-01,2.177400E+00,6.797100E+00,2.762800E+01,3.037800E+02,&
     & 4.566600E+03,1.467600E+04,6.021900E-08,1.750000E-07,6.995400E-07,&
     & 4.582600E-06,2.837300E-05,1.090700E-04,4.511300E-04,3.018200E-03,&
     & 6.045000E-02,5.439600E-01,1.530400E+00,4.906300E+00,1.995600E+01,&
     & 2.048000E+02,3.044400E+03,9.784100E+03,5.085100E-08,1.472100E-07,&
     & 5.454400E-07,3.025300E-06,1.587200E-05,5.866000E-05,2.395400E-04,&
     & 1.605300E-03,3.181000E-02,2.858200E-01,8.115000E-01,2.658100E+00,&
     & 1.132300E+01,1.084100E+02,1.522200E+03,4.892000E+03,1.289700E-08,&
     & 2.778300E-08,4.797800E-08,9.433800E-08,1.825800E-07,4.319000E-07,&
     & 1.340900E-06,7.121000E-06,1.553700E-04,1.020700E-03,2.427700E-03,&
     & 8.048100E-03,2.607000E-02,3.539600E-01,2.087600E+01,1.746400E+02,&
     & 2.587100E-08,5.268700E-08,1.208600E-07,3.637100E-07,3.254300E-06,&
     & 1.935200E-05,7.669300E-05,3.761600E-04,7.038300E-03,5.777700E-02,&
     & 1.537000E-01,5.505000E-01,2.584100E+00,3.799900E+01,1.216400E+03,&
     & 5.798900E+03,2.789600E-08,5.685700E-08,1.272300E-07,4.182200E-07,&
     & 3.146900E-06,1.588600E-05,6.216200E-05,3.051900E-04,5.845200E-03,&
     & 4.849600E-02,1.314500E-01,4.827700E-01,2.141200E+00,2.879100E+01,&
     & 9.122700E+02,4.349200E+03,2.402500E-08,4.789500E-08,1.053900E-07,&
     & 3.528100E-07,2.415800E-06,1.112400E-05,4.312000E-05,2.117000E-04,&
     & 4.038100E-03,3.348900E-02,9.132100E-02,3.412800E-01,1.579200E+00,&
     & 2.001400E+01,6.081800E+02,2.899500E+03,1.994100E-08,3.200100E-08,&
     & 7.444600E-08,2.478600E-07,1.478700E-06,6.028400E-06,2.293300E-05,&
     & 1.124700E-04,2.128800E-03,1.757900E-02,4.812400E-02,1.818100E-01,&
     & 8.784700E-01,1.121400E+01,3.048700E+02,1.449700E+03,2.578900E-09,&
     & 6.627500E-09,9.226100E-09,1.607200E-08,3.193200E-08,7.783200E-08,&
     & 2.168400E-07,1.014000E-06,1.781100E-05,1.244200E-04,2.753100E-04,&
     & 1.066600E-03,5.727200E-03,3.499400E-02,3.172400E+00,3.982800E+01/
      data   absb(:,1081:1100) /                                        &
     & 2.411100E-08,5.376600E-08,1.343400E-07,5.778600E-07,6.598900E-06,&
     & 3.437800E-05,1.393400E-04,7.128100E-04,1.440800E-02,1.166500E-01,&
     & 3.161600E-01,1.208800E+00,5.427900E+00,7.705900E+01,2.037600E+03,&
     & 8.123200E+03,2.923000E-08,6.341500E-08,1.540700E-07,7.177600E-07,&
     & 6.203800E-06,2.819700E-05,1.129400E-04,5.817300E-04,1.196600E-02,&
     & 9.780500E-02,2.758300E-01,1.042600E+00,4.404700E+00,5.814000E+01,&
     & 1.528200E+03,6.092400E+03,2.656200E-08,5.517100E-08,1.361600E-07,&
     & 6.168400E-07,4.669600E-06,1.972100E-05,7.821900E-05,4.042000E-04,&
     & 8.252300E-03,6.743300E-02,1.924500E-01,7.435000E-01,3.262100E+00,&
     & 3.988800E+01,1.018800E+03,4.061600E+03,2.201200E-08,4.034100E-08,&
     & 1.039600E-07,4.388900E-07,2.783100E-06,1.066700E-05,4.152000E-05,&
     & 2.150500E-04,4.344800E-03,3.534200E-02,1.017100E-01,3.974400E-01,&
     & 1.837000E+00,2.202100E+01,5.098900E+02,2.030800E+03,3.921100E-09,&
     & 8.217600E-09,1.344700E-08,2.645000E-08,5.053100E-08,1.194800E-07,&
     & 3.417900E-07,1.667300E-06,3.148800E-05,2.068900E-04,5.026900E-04,&
     & 1.942100E-03,9.008500E-03,5.168500E-02,5.589000E+00,5.972900E+01,&
     & 2.326000E-08,5.948700E-08,1.700000E-07,1.089300E-06,1.245300E-05,&
     & 5.834900E-05,2.391000E-04,1.322900E-03,2.769500E-02,2.188000E-01,&
     & 6.619900E-01,2.375300E+00,1.054100E+01,1.418700E+02,3.117500E+03,&
     & 1.113900E+04,3.244300E-08,7.507000E-08,2.150600E-07,1.333500E-06,&
     & 1.135200E-05,4.795000E-05,1.940300E-04,1.084600E-03,2.295300E-02,&
     & 1.863600E-01,5.764900E-01,2.017800E+00,8.380200E+00,1.068000E+02,&
     & 2.338100E+03,8.354600E+03,3.089100E-08,6.790000E-08,1.991600E-07,&
     & 1.127100E-06,8.394500E-06,3.352000E-05,1.344100E-04,7.536700E-04,&
     & 1.581100E-02,1.290500E-01,4.035200E-01,1.446300E+00,6.180100E+00,&
     & 7.265500E+01,1.558800E+03,5.569700E+03,2.539200E-08,5.387400E-08,&
     & 1.586100E-07,7.863600E-07,4.882000E-06,1.811100E-05,7.118900E-05,&
     & 4.012600E-04,8.308000E-03,6.780400E-02,2.138600E-01,7.755900E-01,&
     & 3.487000E+00,3.953100E+01,7.794700E+02,2.784900E+03,5.799100E-09,&
     & 1.160500E-08,1.923300E-08,3.860300E-08,7.453800E-08,1.736300E-07,&
     & 5.127400E-07,2.592100E-06,5.223900E-05,3.514900E-04,8.677500E-04,&
     & 3.148600E-03,1.289400E-02,7.740800E-02,9.006000E+00,8.580100E+01,&
     & 2.374400E-08,7.173600E-08,2.515500E-07,2.101000E-06,2.165500E-05,&
     & 9.486600E-05,3.937800E-04,2.403400E-03,5.032700E-02,4.157900E-01,&
     & 1.282200E+00,4.333600E+00,1.899800E+01,2.406900E+02,4.449100E+03,&
     & 1.489000E+04,3.810500E-08,9.666300E-08,3.374600E-07,2.436800E-06,&
     & 1.931400E-05,7.829000E-05,3.205400E-04,1.975400E-03,4.181500E-02,&
     & 3.563300E-01,1.102100E+00,3.622700E+00,1.491400E+01,1.809100E+02,&
     & 3.336800E+03,1.116700E+04,3.744100E-08,9.160600E-08,3.159200E-07,&
     & 2.011400E-06,1.406500E-05,5.472300E-05,2.219800E-04,1.371400E-03,&
     & 2.882700E-02,2.477900E-01,7.725600E-01,2.606100E+00,1.091000E+01,&
     & 1.223700E+02,2.224600E+03,7.444800E+03,3.075000E-08,7.598300E-08,&
     & 2.520400E-07,1.365200E-06,8.002800E-06,2.951000E-05,1.174800E-04,&
     & 7.302700E-04,1.514900E-02,1.304300E-01,4.089100E-01,1.407500E+00,&
     & 6.163100E+00,6.553000E+01,1.112300E+03,3.722400E+03,7.737000E-09,&
     & 1.610500E-08,2.685900E-08,5.330300E-08,1.039700E-07,2.438500E-07,&
     & 7.384000E-07,3.857700E-06,8.295200E-05,5.743700E-04,1.351900E-03,&
     & 4.877200E-03,1.821600E-02,1.521600E-01,1.346300E+01,1.187400E+02,&
     & 2.635700E-08,9.481100E-08,4.208800E-07,3.867500E-06,3.495000E-05,&
     & 1.483900E-04,6.295700E-04,4.258900E-03,8.847700E-02,7.839200E-01,&
     & 2.278300E+00,7.487100E+00,3.238700E+01,3.800700E+02,6.002700E+03,&
     & 1.942900E+04,4.741900E-08,1.354700E-07,5.590700E-07,4.253600E-06,&
     & 3.067300E-05,1.227300E-04,5.153100E-04,3.508900E-03,7.378600E-02,&
     & 6.681000E-01,1.936800E+00,6.164800E+00,2.519500E+01,2.853300E+02,&
     & 4.502000E+03,1.457200E+04,4.726400E-08,1.320400E-07,5.152500E-07,&
     & 3.420500E-06,2.208500E-05,8.568000E-05,3.575300E-04,2.436400E-03,&
     & 5.090500E-02,4.649800E-01,1.362200E+00,4.445500E+00,1.820000E+01,&
     & 1.923000E+02,3.001400E+03,9.714800E+03,3.943500E-08,1.103600E-07,&
     & 4.022000E-07,2.262200E-06,1.236300E-05,4.604500E-05,1.895200E-04,&
     & 1.295600E-03,2.678300E-02,2.443400E-01,7.222100E-01,2.408400E+00,&
     & 1.031100E+01,1.016400E+02,1.500700E+03,4.857400E+03,9.894800E-09,&
     & 2.120300E-08,3.654900E-08,7.162600E-08,1.392500E-07,3.302200E-07,&
     & 1.022200E-06,5.565600E-06,1.290000E-04,8.739200E-04,2.080100E-03,&
     & 7.263300E-03,2.501700E-02,2.884200E-01,1.891200E+01,1.598800E+02/
      data   absb(:,1101:1120) /                                        &
     & 2.353500E-08,4.703000E-08,1.055300E-07,2.943100E-07,2.316600E-06,&
     & 1.425500E-05,5.653500E-05,2.816300E-04,5.298400E-03,4.496200E-02,&
     & 1.216500E-01,4.269100E-01,2.127300E+00,3.195100E+01,1.088900E+03,&
     & 5.602100E+03,2.425900E-08,4.856800E-08,1.070700E-07,3.213300E-07,&
     & 2.239000E-06,1.168000E-05,4.582900E-05,2.285100E-04,4.404800E-03,&
     & 3.774500E-02,1.043300E-01,3.759300E-01,1.766300E+00,2.422600E+01,&
     & 8.166400E+02,4.201600E+03,2.030900E-08,3.998800E-08,8.715300E-08,&
     & 2.645700E-07,1.714200E-06,8.177600E-06,3.175400E-05,1.582500E-04,&
     & 3.044200E-03,2.602000E-02,7.230300E-02,2.660600E-01,1.299700E+00,&
     & 1.686300E+01,5.444300E+02,2.801000E+03,1.643500E-08,2.621900E-08,&
     & 5.894400E-08,1.814600E-07,1.050400E-06,4.423500E-06,1.688000E-05,&
     & 8.380100E-05,1.606200E-03,1.366900E-02,3.800900E-02,1.419500E-01,&
     & 7.218200E-01,9.428100E+00,2.729800E+02,1.400500E+03,1.842400E-09,&
     & 4.940800E-09,6.803300E-09,1.125900E-08,2.268200E-08,5.592700E-08,&
     & 1.553500E-07,7.292000E-07,1.348500E-05,1.007400E-04,2.193800E-04,&
     & 8.379300E-04,4.999000E-03,3.308600E-02,2.582100E+00,3.459300E+01,&
     & 2.175000E-08,4.681100E-08,1.136200E-07,4.321200E-07,4.754000E-06,&
     & 2.581500E-05,1.054300E-04,5.431600E-04,1.127700E-02,9.397500E-02,&
     & 2.519800E-01,9.956700E-01,4.628800E+00,6.699500E+01,1.887100E+03,&
     & 7.903200E+03,2.498100E-08,5.301500E-08,1.248700E-07,5.228000E-07,&
     & 4.489200E-06,2.113200E-05,8.539300E-05,4.428800E-04,9.383900E-03,&
     & 7.903900E-02,2.193800E-01,8.632500E-01,3.765300E+00,5.055500E+01,&
     & 1.415400E+03,5.927400E+03,2.197500E-08,4.554600E-08,1.070800E-07,&
     & 4.460100E-07,3.384600E-06,1.476300E-05,5.909900E-05,3.073600E-04,&
     & 6.474500E-03,5.446800E-02,1.531100E-01,6.146300E-01,2.787600E+00,&
     & 3.469900E+01,9.435700E+02,3.951600E+03,1.796500E-08,3.176900E-08,&
     & 7.950600E-08,3.152700E-07,2.024500E-06,7.966300E-06,3.133600E-05,&
     & 1.632400E-04,3.412600E-03,2.858300E-02,8.087700E-02,3.285900E-01,&
     & 1.565300E+00,1.913300E+01,4.723100E+02,1.975800E+03,2.848500E-09,&
     & 6.135300E-09,9.894300E-09,1.912200E-08,3.698800E-08,8.752200E-08,&
     & 2.494100E-07,1.227500E-06,2.466400E-05,1.688800E-04,3.987500E-04,&
     & 1.624200E-03,7.993900E-03,4.551600E-02,4.710200E+00,5.276600E+01,&
     & 2.071600E-08,5.049400E-08,1.372900E-07,7.867900E-07,9.224600E-06,&
     & 4.455200E-05,1.844700E-04,1.024200E-03,2.238300E-02,1.808300E-01,&
     & 5.360600E-01,2.048600E+00,9.245900E+00,1.270500E+02,2.964800E+03,&
     & 1.091900E+04,2.709500E-08,6.137000E-08,1.657700E-07,9.612900E-07,&
     & 8.432000E-06,3.657900E-05,1.497600E-04,8.390700E-04,1.859800E-02,&
     & 1.530500E-01,4.703900E-01,1.744900E+00,7.357200E+00,9.565000E+01,&
     & 2.223600E+03,8.188900E+03,2.507300E-08,5.448700E-08,1.503900E-07,&
     & 8.134000E-07,6.243800E-06,2.553100E-05,1.036400E-04,5.825000E-04,&
     & 1.281000E-02,1.059800E-01,3.294500E-01,1.250200E+00,5.425800E+00,&
     & 6.506200E+01,1.482400E+03,5.459300E+03,2.051800E-08,4.171000E-08,&
     & 1.175500E-07,5.676600E-07,3.642500E-06,1.376100E-05,5.485000E-05,&
     & 3.098400E-04,6.727800E-03,5.551900E-02,1.750800E-01,6.701800E-01,&
     & 3.055000E+00,3.535900E+01,7.413100E+02,2.729500E+03,4.329600E-09,&
     & 8.653600E-09,1.431000E-08,2.868100E-08,5.532800E-08,1.292500E-07,&
     & 3.798000E-07,1.950400E-06,4.207300E-05,2.818000E-04,6.995400E-04,&
     & 2.739900E-03,1.176100E-02,6.795800E-02,7.791100E+00,7.678400E+01,&
     & 2.068800E-08,5.921600E-08,1.930300E-07,1.524000E-06,1.644800E-05,&
     & 7.358900E-05,3.091000E-04,1.897700E-03,4.179300E-02,3.454100E-01,&
     & 1.088000E+00,3.849600E+00,1.706700E+01,2.210600E+02,4.319400E+03,&
     & 1.470900E+04,3.115000E-08,7.659200E-08,2.518500E-07,1.781000E-06,&
     & 1.470400E-05,6.064000E-05,2.513200E-04,1.563000E-03,3.472200E-02,&
     & 2.943100E-01,9.427300E-01,3.223400E+00,1.339500E+01,1.661600E+02,&
     & 3.239500E+03,1.103100E+04,2.999800E-08,7.099400E-08,2.338600E-07,&
     & 1.472500E-06,1.071700E-05,4.234100E-05,1.739700E-04,1.084800E-03,&
     & 2.390100E-02,2.047600E-01,6.614200E-01,2.315900E+00,9.795200E+00,&
     & 1.123700E+02,2.159700E+03,7.354200E+03,2.438900E-08,5.769300E-08,&
     & 1.853300E-07,1.001300E-06,6.106900E-06,2.279700E-05,9.197600E-05,&
     & 5.769100E-04,1.256100E-02,1.078000E-01,3.502700E-01,1.249200E+00,&
     & 5.522200E+00,6.009600E+01,1.079800E+03,3.677100E+03,6.094900E-09,&
     & 1.191600E-08,2.015500E-08,4.021200E-08,7.821000E-08,1.836400E-07,&
     & 5.550600E-07,2.952600E-06,6.809900E-05,4.793100E-04,1.145400E-03,&
     & 4.264900E-03,1.685100E-02,1.202500E-01,1.192400E+01,1.074100E+02/
      data   absb(:,1121:1140) /                                        &
     & 2.233600E-08,7.590800E-08,3.137800E-07,2.854600E-06,2.714000E-05,&
     & 1.168700E-04,4.999800E-04,3.429000E-03,7.487900E-02,6.621200E-01,&
     & 2.013900E+00,6.786700E+00,2.957400E+01,3.568300E+02,5.925200E+03,&
     & 1.934400E+04,3.795700E-08,1.045100E-07,4.131300E-07,3.161700E-06,&
     & 2.384900E-05,9.656500E-05,4.088800E-04,2.829800E-03,6.244900E-02,&
     & 5.658900E-01,1.719100E+00,5.592700E+00,2.299300E+01,2.678900E+02,&
     & 4.443900E+03,1.450800E+04,3.741500E-08,1.003500E-07,3.802500E-07,&
     & 2.549400E-06,1.718200E-05,6.734900E-05,2.834100E-04,1.963900E-03,&
     & 4.307500E-02,3.939000E-01,1.209700E+00,4.028500E+00,1.660600E+01,&
     & 1.804900E+02,2.962600E+03,9.671900E+03,3.078300E-08,8.309700E-08,&
     & 2.965600E-07,1.687500E-06,9.623300E-06,3.614500E-05,1.499900E-04,&
     & 1.043700E-03,2.264300E-02,2.072600E-01,6.410000E-01,2.182300E+00,&
     & 9.391200E+00,9.524000E+01,1.481300E+03,4.835900E+03,7.564900E-09,&
     & 1.623000E-08,2.761900E-08,5.448000E-08,1.061100E-07,2.519000E-07,&
     & 7.793400E-07,4.320300E-06,1.070100E-04,7.597900E-04,1.790100E-03,&
     & 6.509300E-03,2.285200E-02,2.346300E-01,1.705800E+01,1.458200E+02,&
     & 1.042500E-08,2.052400E-08,4.518600E-08,1.192000E-07,8.159400E-07,&
     & 5.128300E-06,2.033800E-05,1.029900E-04,1.942200E-03,1.706200E-02,&
     & 4.691900E-02,1.635600E-01,8.474400E-01,1.312000E+01,4.729600E+02,&
     & 2.646100E+03,1.183000E-08,2.337700E-08,5.089000E-08,1.419300E-07,&
     & 9.001600E-07,4.816400E-06,1.891300E-05,9.589600E-05,1.856200E-03,&
     & 1.642200E-02,4.626800E-02,1.648200E-01,8.114500E-01,1.142700E+01,&
     & 4.072400E+02,2.278400E+03,1.134000E-08,2.210300E-08,4.783200E-08,&
     & 1.338000E-07,8.066100E-07,3.953300E-06,1.537800E-05,7.784400E-05,&
     & 1.507000E-03,1.330100E-02,3.758400E-02,1.363000E-01,7.019400E-01,&
     & 9.342100E+00,3.186700E+02,1.782900E+03,1.098200E-08,1.729100E-08,&
     & 3.747200E-08,1.078200E-07,5.954300E-07,2.584400E-06,9.885300E-06,&
     & 4.978800E-05,9.617800E-04,8.467600E-03,2.391100E-02,8.791600E-02,&
     & 4.717200E-01,6.304100E+00,1.934100E+02,1.063800E+03,1.344300E-09,&
     & 3.630300E-09,5.169600E-09,7.952500E-09,1.626900E-08,4.041100E-08,&
     & 1.118300E-07,5.262300E-07,1.024200E-05,8.214200E-05,1.798800E-04,&
     & 6.587700E-04,4.463900E-03,2.929000E-02,2.105200E+00,3.008400E+01,&
     & 9.564800E-09,2.002300E-08,4.740100E-08,1.618600E-07,1.672800E-06,&
     & 9.466300E-06,3.891700E-05,2.030700E-04,4.296300E-03,3.704400E-02,&
     & 9.962800E-02,3.965300E-01,1.930300E+00,2.837500E+01,8.495800E+02,&
     & 3.754700E+03,1.200200E-08,2.500800E-08,5.761800E-08,2.169600E-07,&
     & 1.819300E-06,8.882900E-06,3.614400E-05,1.901300E-04,4.112600E-03,&
     & 3.579100E-02,9.883200E-02,3.977100E-01,1.804900E+00,2.458600E+01,&
     & 7.315200E+02,3.232900E+03,1.204500E-08,2.483100E-08,5.635700E-08,&
     & 2.147700E-07,1.612200E-06,7.275600E-06,2.933500E-05,1.545000E-04,&
     & 3.337800E-03,2.893300E-02,8.074400E-02,3.321900E-01,1.564500E+00,&
     & 1.981500E+01,5.724200E+02,2.529800E+03,1.171000E-08,2.027300E-08,&
     & 4.895500E-08,1.816500E-07,1.168900E-06,4.739700E-06,1.880000E-05,&
     & 9.903500E-05,2.127800E-03,1.834400E-02,5.143800E-02,2.152200E-01,&
     & 1.059500E+00,1.320500E+01,3.468200E+02,1.530900E+03,2.084900E-09,&
     & 4.707000E-09,7.424300E-09,1.381400E-08,2.716100E-08,6.461600E-08,&
     & 1.830900E-07,9.061600E-07,1.947500E-05,1.397900E-04,3.248200E-04,&
     & 1.356100E-03,7.171800E-03,4.178300E-02,3.964300E+00,4.670600E+01,&
     & 9.014600E-09,2.107600E-08,5.501000E-08,2.808700E-07,3.332500E-06,&
     & 1.660800E-05,6.947800E-05,3.883900E-04,8.832100E-03,7.362700E-02,&
     & 2.109700E-01,8.597800E-01,3.959300E+00,5.546200E+01,1.371900E+03,&
     & 5.218200E+03,1.274700E-08,2.835600E-08,7.288200E-08,3.907600E-07,&
     & 3.507600E-06,1.562800E-05,6.468400E-05,3.651500E-04,8.431200E-03,&
     & 7.117600E-02,2.135800E-01,8.438800E-01,3.618500E+00,4.793800E+01,&
     & 1.181200E+03,4.493000E+03,1.351200E-08,2.898700E-08,7.579700E-08,&
     & 3.876000E-07,3.049700E-06,1.279100E-05,5.251700E-05,2.969500E-04,&
     & 6.826700E-03,5.764800E-02,1.757000E-01,7.095900E-01,3.131800E+00,&
     & 3.826400E+01,9.243400E+02,3.515900E+03,1.320100E-08,2.584000E-08,&
     & 7.013600E-08,3.267900E-07,2.158100E-06,8.323200E-06,3.362000E-05,&
     & 1.907800E-04,4.343700E-03,3.653400E-02,1.131800E-01,4.600900E-01,&
     & 2.130800E+00,2.512600E+01,5.594800E+02,2.127600E+03,3.265400E-09,&
     & 6.504800E-09,1.068700E-08,2.139400E-08,4.146800E-08,9.691600E-08,&
     & 2.833300E-07,1.473700E-06,3.434700E-05,2.307200E-04,5.819400E-04,&
     & 2.423100E-03,1.075900E-02,6.249700E-02,6.735200E+00,6.885500E+01/
      data   absb(:,1141:1160) /                                        &
     & 8.849300E-09,2.407200E-08,7.371800E-08,5.419100E-07,6.090800E-06,&
     & 2.786900E-05,1.184300E-04,7.329400E-04,1.700600E-02,1.403600E-01,&
     & 4.483700E-01,1.668500E+00,7.487800E+00,9.896200E+01,2.041000E+03,&
     & 7.085200E+03,1.436900E-08,3.437700E-08,1.065300E-07,7.300900E-07,&
     & 6.261500E-06,2.633100E-05,1.105200E-04,6.930300E-04,1.622000E-02,&
     & 1.377600E-01,4.480200E-01,1.607100E+00,6.742300E+00,8.539700E+01,&
     & 1.757400E+03,6.100600E+03,1.592900E-08,3.657700E-08,1.147000E-07,&
     & 7.091600E-07,5.362100E-06,2.154900E-05,8.971300E-05,5.642600E-04,&
     & 1.311200E-02,1.121900E-01,3.693600E-01,1.354600E+00,5.780700E+00,&
     & 6.776400E+01,1.375200E+03,4.773800E+03,1.546600E-08,3.514400E-08,&
     & 1.088400E-07,5.841300E-07,3.701800E-06,1.401000E-05,5.732800E-05,&
     & 3.625500E-04,8.324500E-03,7.145900E-02,2.372700E-01,8.829500E-01,&
     & 3.939000E+00,4.378400E+01,8.322100E+02,2.888900E+03,4.735600E-09,&
     & 8.968900E-09,1.519800E-08,3.072400E-08,5.955600E-08,1.388400E-07,&
     & 4.195100E-07,2.271000E-06,5.645300E-05,4.052100E-04,9.796200E-04,&
     & 3.894400E-03,1.527000E-02,9.957900E-02,1.055000E+01,9.741100E+01,&
     & 9.308600E-09,3.000400E-08,1.154700E-07,1.029900E-06,1.027400E-05,&
     & 4.491600E-05,1.943400E-04,1.353200E-03,3.100100E-02,2.737500E-01,&
     & 8.656800E-01,3.005700E+00,1.320100E+01,1.633000E+02,2.847200E+03,&
     & 9.386700E+03,1.713800E-08,4.562600E-08,1.720300E-07,1.316700E-06,&
     & 1.037500E-05,4.258200E-05,1.821800E-04,1.280600E-03,2.966400E-02,&
     & 2.685700E-01,8.523000E-01,2.844500E+00,1.177400E+01,1.407500E+02,&
     & 2.451500E+03,8.082200E+03,1.957300E-08,5.047400E-08,1.851700E-07,&
     & 1.248800E-06,8.775400E-06,3.483000E-05,1.480600E-04,1.042600E-03,&
     & 2.401300E-02,2.192500E-01,7.045600E-01,2.402200E+00,9.971700E+00,&
     & 1.112600E+02,1.918400E+03,6.324400E+03,1.921400E-08,4.997600E-08,&
     & 1.742200E-07,1.000800E-06,5.951900E-06,2.258600E-05,9.468500E-05,&
     & 6.701700E-04,1.527400E-02,1.396500E-01,4.517800E-01,1.574100E+00,&
     & 6.809800E+00,7.092300E+01,1.160900E+03,3.827300E+03,5.827800E-09,&
     & 1.242800E-08,2.115300E-08,4.188500E-08,8.135100E-08,1.930500E-07,&
     & 5.979600E-07,3.369800E-06,9.031500E-05,6.686800E-04,1.578900E-03,&
     & 5.959600E-03,2.104600E-02,1.910600E-01,1.539500E+01,1.333500E+02,&
     & 9.038000E-09,1.770000E-08,3.872000E-08,1.003900E-07,6.519900E-07,&
     & 4.116600E-06,1.648600E-05,8.545000E-05,1.668000E-03,1.502600E-02,&
     & 4.195500E-02,1.455100E-01,7.838900E-01,1.238400E+01,4.568000E+02,&
     & 2.651900E+03,1.008000E-08,1.984300E-08,4.302700E-08,1.171400E-07,&
     & 7.168200E-07,3.876300E-06,1.539400E-05,7.984800E-05,1.599500E-03,&
     & 1.462000E-02,4.149600E-02,1.472500E-01,7.536100E-01,1.082100E+01,&
     & 3.947700E+02,2.291800E+03,9.605900E-09,1.864300E-08,4.019000E-08,&
     & 1.097400E-07,6.428500E-07,3.193200E-06,1.256500E-05,6.507300E-05,&
     & 1.304900E-03,1.189100E-02,3.392400E-02,1.225100E-01,6.554500E-01,&
     & 8.876000E+00,3.104600E+02,1.802300E+03,9.158400E-09,1.452000E-08,&
     & 3.125200E-08,8.750400E-08,4.753300E-07,2.098400E-06,8.120400E-06,&
     & 4.187500E-05,8.383600E-04,7.613900E-03,2.174800E-02,7.956100E-02,&
     & 4.439000E-01,6.009200E+00,1.897600E+02,1.098500E+03,1.108100E-09,&
     & 2.967900E-09,4.139700E-09,6.467400E-09,1.339800E-08,3.313800E-08,&
     & 9.117800E-08,4.325300E-07,9.217900E-06,7.777200E-05,1.705400E-04,&
     & 6.807400E-04,4.773100E-03,2.980200E-02,1.925600E+00,2.839900E+01,&
     & 8.269100E-09,1.714900E-08,4.021300E-08,1.324100E-07,1.336100E-06,&
     & 7.667900E-06,3.193700E-05,1.717000E-04,3.771200E-03,3.359800E-02,&
     & 9.009600E-02,3.608000E-01,1.831600E+00,2.713500E+01,8.332700E+02,&
     & 3.770900E+03,1.016500E-08,2.100800E-08,4.810300E-08,1.743500E-07,&
     & 1.453100E-06,7.218300E-06,2.980000E-05,1.613300E-04,3.625800E-03,&
     & 3.261800E-02,8.987200E-02,3.645100E-01,1.714400E+00,2.359200E+01,&
     & 7.201200E+02,3.258900E+03,1.011500E-08,2.074700E-08,4.663800E-08,&
     & 1.718900E-07,1.291300E-06,5.935600E-06,2.429200E-05,1.317000E-04,&
     & 2.956100E-03,2.647500E-02,7.369600E-02,3.064900E-01,1.490600E+00,&
     & 1.908500E+01,5.663200E+02,2.562900E+03,9.701400E-09,1.683000E-08,&
     & 4.006200E-08,1.449600E-07,9.409900E-07,3.884900E-06,1.566500E-05,&
     & 8.486600E-05,1.897900E-03,1.687300E-02,4.737800E-02,2.000300E-01,&
     & 1.015400E+00,1.276700E+01,3.455500E+02,1.562000E+03,1.753300E-09,&
     & 3.908100E-09,6.038000E-09,1.145800E-08,2.244500E-08,5.354200E-08,&
     & 1.506500E-07,7.522300E-07,1.801700E-05,1.336300E-04,3.163800E-04,&
     & 1.432400E-03,7.318200E-03,4.373500E-02,3.677900E+00,4.442900E+01/
      data   absb(:,1161:1175) /                                        &
     & 7.764100E-09,1.787300E-08,4.599400E-08,2.249300E-07,2.685200E-06,&
     & 1.357800E-05,5.768300E-05,3.332400E-04,7.914400E-03,6.777800E-02,&
     & 1.916900E-01,8.081100E-01,3.801200E+00,5.369200E+01,1.361100E+03,&
     & 5.253400E+03,1.068800E-08,2.361200E-08,5.969400E-08,3.106000E-07,&
     & 2.834100E-06,1.280900E-05,5.390500E-05,3.148000E-04,7.608200E-03,&
     & 6.572400E-02,1.939000E-01,7.982300E-01,3.479600E+00,4.656800E+01,&
     & 1.176300E+03,4.540100E+03,1.120000E-08,2.404600E-08,6.145200E-08,&
     & 3.084100E-07,2.471700E-06,1.052700E-05,4.394200E-05,2.571600E-04,&
     & 6.188600E-03,5.354800E-02,1.603700E-01,6.748900E-01,3.022000E+00,&
     & 3.731400E+01,9.251000E+02,3.570400E+03,1.088900E-08,2.109800E-08,&
     & 5.650500E-08,2.605200E-07,1.757200E-06,6.884400E-06,2.829900E-05,&
     & 1.661000E-04,3.964700E-03,3.408500E-02,1.039400E-01,4.413800E-01,&
     & 2.069700E+00,2.459100E+01,5.639300E+02,2.176100E+03,2.739400E-09,&
     & 5.459300E-09,8.844300E-09,1.773500E-08,3.466000E-08,8.103700E-08,&
     & 2.349600E-07,1.232900E-06,3.243500E-05,2.312700E-04,5.937400E-04,&
     & 2.570900E-03,1.097000E-02,6.706100E-02,6.320100E+00,6.584400E+01,&
     & 7.575600E-09,2.020100E-08,6.048700E-08,4.320200E-07,4.957500E-06,&
     & 2.297200E-05,9.932300E-05,6.400000E-04,1.556200E-02,1.297300E-01,&
     & 4.117000E-01,1.605800E+00,7.266800E+00,9.683100E+01,2.042900E+03,&
     & 7.155500E+03,1.192700E-08,2.828700E-08,8.568500E-08,5.817200E-07,&
     & 5.110400E-06,2.177500E-05,9.308800E-05,6.078600E-04,1.491700E-02,&
     & 1.274900E-01,4.145900E-01,1.551200E+00,6.553400E+00,8.385200E+01,&
     & 1.765500E+03,6.183900E+03,1.308300E-08,2.990500E-08,9.174300E-08,&
     & 5.665400E-07,4.391500E-06,1.789100E-05,7.592700E-05,4.969100E-04,&
     & 1.212700E-02,1.043900E-01,3.438600E-01,1.313800E+00,5.633200E+00,&
     & 6.681000E+01,1.388400E+03,4.863200E+03,1.266700E-08,2.847300E-08,&
     & 8.681800E-08,4.682900E-07,3.048500E-06,1.169000E-05,4.881300E-05,&
     & 3.211200E-04,7.757900E-03,6.670500E-02,2.229700E-01,8.624400E-01,&
     & 3.861100E+00,4.332400E+01,8.462300E+02,2.964000E+03,3.931300E-09,&
     & 7.479100E-09,1.287900E-08,2.581800E-08,4.956600E-08,1.173500E-07,&
     & 3.492200E-07,1.916500E-06,5.486200E-05,3.994900E-04,1.008200E-03,&
     & 4.275300E-03,1.531700E-02,1.082500E-01,9.980400E+00,9.360800E+01,&
     & 7.888600E-09,2.490500E-08,9.318800E-08,8.252300E-07,8.432000E-06,&
     & 3.729600E-05,1.645100E-04,1.202000E-03,2.878900E-02,2.538300E-01,&
     & 8.183900E-01,2.924900E+00,1.291100E+01,1.612900E+02,2.870000E+03,&
     & 9.506900E+03,1.408800E-08,3.706500E-08,1.372200E-07,1.056300E-06,&
     & 8.539800E-06,3.549000E-05,1.550700E-04,1.145600E-03,2.760700E-02,&
     & 2.500600E-01,8.110700E-01,2.773000E+00,1.153600E+01,1.395100E+02,&
     & 2.480300E+03,8.216000E+03,1.599200E-08,4.070300E-08,1.475200E-07,&
     & 1.005300E-06,7.246400E-06,2.915000E-05,1.266100E-04,9.358400E-04,&
     & 2.244600E-02,2.052000E-01,6.747000E-01,2.351700E+00,9.791500E+00,&
     & 1.107600E+02,1.950600E+03,6.461300E+03,1.568800E-08,4.012500E-08,&
     & 1.389200E-07,8.085200E-07,4.941800E-06,1.900700E-05,8.143900E-05,&
     & 6.039800E-04,1.435600E-02,1.315600E-01,4.362400E-01,1.552000E+00,&
     & 6.722900E+00,7.088100E+01,1.188900E+03,3.938100E+03,4.820200E-09,&
     & 1.039100E-08,1.799900E-08,3.557200E-08,6.810500E-08,1.627000E-07,&
     & 5.009300E-07,2.863800E-06,8.915500E-05,6.655100E-04,1.686900E-03,&
     & 6.336700E-03,2.201500E-02,1.765200E-01,1.473900E+01,1.285400E+02/

! --- the array ka_mxxx(NG03,9,19) contains the absorption coefficient for
!     a minor species at the NG03=16 chosen g-values for a reference pressure
!     level below 100~ mb.   the first index in the array, js, runs from 1
!     to 9, and corresponds to different gas column amount ratios, as
!     expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the ratio of the
!     reference mls column amount value of gas1 to that of gas2.  the
!     second index refers to temperature in 7.2 degree increments.  for
!     instance, jt = 1 refers to a temperature of 188.0, jt = 2 refers to
!     195.2, etc. the third index runs over the g-channel (1 to NG03=16).

      data  ka_mn2o(:,:, 1) /                                           &
     & 1.281780E-05,1.621520E-03,5.265780E-02,4.651350E-01,1.538850E+00,&
     & 1.838090E+00,3.227050E+00,2.146410E+00,1.564830E+00,7.686160E-01,&
     & 6.910620E-01,5.307960E-01,2.419660E-01,9.083400E-02,8.802470E-02,&
     & 8.846060E-02,1.007250E-01,3.737160E-01,8.183930E-01,9.715920E-01,&
     & 1.833680E+00,1.826240E+00,1.438110E+00,8.836870E-01,4.095260E-01,&
     & 4.972710E-01,1.986980E-01,1.384690E-01,1.543850E-01,3.369450E-02,&
     & 3.891070E-07,8.138980E-07,1.941430E-01,5.462400E-01,1.024540E+00,&
     & 1.480900E+00,1.495930E+00,1.354420E+00,1.225860E+00,4.498400E-01,&
     & 3.356720E-01,2.444430E-01,2.119500E-01,1.507410E-01,2.005180E-01,&
     & 9.116780E-02,3.865370E-07,8.326660E-07,2.981270E-01,8.353990E-01,&
     & 1.117550E+00,1.505990E+00,1.400480E+00,1.105100E+00,7.943800E-01,&
     & 3.922920E-01,3.191300E-01,2.019640E-01,3.142100E-01,1.804440E-01,&
     & 2.039740E-01,8.439990E-02,3.819130E-07,8.703480E-07,4.450290E-01,&
     & 1.044330E+00,1.419930E+00,1.253960E+00,1.222530E+00,1.010830E+00,&
     & 4.469350E-01,3.389200E-01,3.043850E-01,2.569720E-01,3.135360E-01,&
     & 1.805950E-01,2.094100E-01,7.412790E-02,3.772650E-07,9.079570E-07,&
     & 7.156770E-01,1.223410E+00,1.377250E+00,1.271040E+00,1.079300E+00,&
     & 5.914150E-01,4.202110E-01,3.016730E-01,2.987890E-01,2.573220E-01,&
     & 3.132150E-01,1.799040E-01,2.198080E-01,5.668050E-02,3.778770E-07,&
     & 8.590720E-04,9.896050E-01,1.675950E+00,1.345790E+00,9.578770E-01,&
     & 7.870660E-01,3.681890E-01,3.420940E-01,2.993810E-01,3.087120E-01,&
     & 2.565510E-01,3.142360E-01,1.787120E-01,2.470740E-01,1.230180E-02,&
     & 3.804950E-07,9.172940E-07,1.122290E+00,2.768900E+00,9.152680E-01,&
     & 4.757870E-01,3.833620E-01,2.987210E-01,2.949190E-01,2.875590E-01,&
     & 3.105710E-01,2.736290E-01,2.974530E-01,1.723460E-01,2.552820E-01,&
     & 3.224030E-07,3.878810E-07,9.173410E-07,7.209590E-01,8.009440E-01,&
     & 1.125140E+00,2.425330E+00,8.972780E-01,3.761160E-01,2.974410E-01,&
     & 2.962380E-01,3.164360E-01,2.572940E-01,3.126940E-01,1.805170E-01,&
     & 2.099910E-01,7.330520E-02,3.772650E-07,9.079570E-07 /
      data  ka_mn2o(:,:, 2) /                                           &
     & 1.554720E-05,1.816270E-03,5.590000E-02,4.696770E-01,1.535900E+00,&
     & 1.840360E+00,3.219660E+00,2.125850E+00,1.557920E+00,7.632630E-01,&
     & 6.841510E-01,5.504440E-01,2.505340E-01,9.504210E-02,9.017930E-02,&
     & 9.059710E-02,1.044700E-01,3.724910E-01,8.206230E-01,9.744720E-01,&
     & 1.835300E+00,1.815640E+00,1.423670E+00,8.831700E-01,4.103010E-01,&
     & 5.100540E-01,2.011820E-01,1.409590E-01,1.540150E-01,3.451440E-02,&
     & 4.537680E-07,9.491300E-07,1.973800E-01,5.429720E-01,1.032100E+00,&
     & 1.482380E+00,1.492790E+00,1.341740E+00,1.216390E+00,4.526830E-01,&
     & 3.389820E-01,2.470960E-01,2.135600E-01,1.508550E-01,1.949010E-01,&
     & 8.857610E-02,4.507630E-07,9.710210E-07,3.000160E-01,8.367660E-01,&
     & 1.123480E+00,1.505410E+00,1.392280E+00,1.094730E+00,7.927950E-01,&
     & 3.935740E-01,3.230280E-01,2.028690E-01,3.131430E-01,1.799440E-01,&
     & 1.982580E-01,8.200040E-02,4.453690E-07,1.014960E-06,4.452430E-01,&
     & 1.048640E+00,1.423530E+00,1.252300E+00,1.212020E+00,1.002210E+00,&
     & 4.497600E-01,3.411510E-01,3.071550E-01,2.568370E-01,3.124590E-01,&
     & 1.800330E-01,2.035430E-01,7.201960E-02,4.399510E-07,1.058820E-06,&
     & 7.145640E-01,1.228850E+00,1.380290E+00,1.264160E+00,1.069980E+00,&
     & 5.904270E-01,4.217110E-01,3.047520E-01,3.009960E-01,2.571870E-01,&
     & 3.121230E-01,1.792540E-01,2.136430E-01,5.506760E-02,4.406700E-07,&
     & 9.197730E-04,9.851280E-01,1.682960E+00,1.345840E+00,9.497120E-01,&
     & 7.827670E-01,3.700290E-01,3.435890E-01,3.024310E-01,3.104910E-01,&
     & 2.564210E-01,3.131230E-01,1.778680E-01,2.401270E-01,1.195170E-02,&
     & 4.437260E-07,1.069710E-06,1.115020E+00,2.769810E+00,9.127790E-01,&
     & 4.772080E-01,3.844050E-01,2.999320E-01,2.974600E-01,2.891530E-01,&
     & 3.122620E-01,2.734600E-01,2.964200E-01,1.708730E-01,2.481050E-01,&
     & 3.759860E-07,4.523290E-07,1.069770E-06,7.228390E-01,7.955310E-01,&
     & 1.135230E+00,2.413570E+00,8.928730E-01,3.772760E-01,2.992070E-01,&
     & 2.975880E-01,3.182000E-01,2.571490E-01,3.116220E-01,1.799510E-01,&
     & 2.041030E-01,7.121990E-02,4.399510E-07,1.058820E-06 /
      data  ka_mn2o(:,:, 3) /                                           &
     & 1.885780E-05,2.034430E-03,5.934190E-02,4.742640E-01,1.532970E+00,&
     & 1.842640E+00,3.212300E+00,2.105490E+00,1.551050E+00,7.579480E-01,&
     & 6.773090E-01,5.708180E-01,2.594060E-01,9.944520E-02,9.238680E-02,&
     & 9.278520E-02,1.083550E-01,3.712710E-01,8.228600E-01,9.773600E-01,&
     & 1.836920E+00,1.805100E+00,1.409380E+00,8.826540E-01,4.110780E-01,&
     & 5.231650E-01,2.036980E-01,1.434930E-01,1.536460E-01,3.535420E-02,&
     & 5.291730E-07,1.106830E-06,2.006700E-01,5.397240E-01,1.039720E+00,&
     & 1.483850E+00,1.489650E+00,1.329180E+00,1.207000E+00,4.555430E-01,&
     & 3.423260E-01,2.497780E-01,2.151840E-01,1.509690E-01,1.894420E-01,&
     & 8.605800E-02,5.256620E-07,1.132370E-06,3.019160E-01,8.381350E-01,&
     & 1.129440E+00,1.504830E+00,1.384130E+00,1.084460E+00,7.912130E-01,&
     & 3.948610E-01,3.269730E-01,2.037770E-01,3.120800E-01,1.794450E-01,&
     & 1.927030E-01,7.966920E-02,5.193690E-07,1.183600E-06,4.454580E-01,&
     & 1.052970E+00,1.427130E+00,1.250650E+00,1.201600E+00,9.936560E-01,&
     & 4.526020E-01,3.433970E-01,3.099490E-01,2.567020E-01,3.113860E-01,&
     & 1.794740E-01,1.978410E-01,6.997120E-02,5.130530E-07,1.234750E-06,&
     & 7.134520E-01,1.234310E+00,1.383340E+00,1.257310E+00,1.060750E+00,&
     & 5.894410E-01,4.232160E-01,3.078630E-01,3.032200E-01,2.570520E-01,&
     & 3.110340E-01,1.786070E-01,2.076510E-01,5.350060E-02,5.138970E-07,&
     & 9.847640E-04,9.806710E-01,1.690000E+00,1.345890E+00,9.416170E-01,&
     & 7.784900E-01,3.718770E-01,3.450910E-01,3.055120E-01,3.122810E-01,&
     & 2.562910E-01,3.120140E-01,1.770270E-01,2.333750E-01,1.161160E-02,&
     & 5.174650E-07,1.247460E-06,1.107790E+00,2.770720E+00,9.102980E-01,&
     & 4.786330E-01,3.854520E-01,3.011490E-01,3.000220E-01,2.907560E-01,&
     & 3.139610E-01,2.732910E-01,2.953910E-01,1.694130E-01,2.411300E-01,&
     & 4.384750E-07,5.274860E-07,1.247520E-06,7.247230E-01,7.901550E-01,&
     & 1.145410E+00,2.401880E+00,8.884900E-01,3.784390E-01,3.009840E-01,&
     & 2.989450E-01,3.199740E-01,2.570040E-01,3.105540E-01,1.793860E-01,&
     & 1.983800E-01,6.919390E-02,5.130530E-07,1.234750E-06 /
      data  ka_mn2o(:,:, 4) /                                           &
     & 2.287350E-05,2.278780E-03,6.299570E-02,4.788950E-01,1.530040E+00,&
     & 1.844910E+00,3.204940E+00,2.085320E+00,1.544200E+00,7.526690E-01,&
     & 6.705350E-01,5.919470E-01,2.685910E-01,1.040520E-01,9.464820E-02,&
     & 9.502610E-02,1.123840E-01,3.700540E-01,8.251030E-01,9.802570E-01,&
     & 1.838540E+00,1.794630E+00,1.395220E+00,8.821370E-01,4.118570E-01,&
     & 5.366140E-01,2.062440E-01,1.460730E-01,1.532790E-01,3.621440E-02,&
     & 6.171090E-07,1.290730E-06,2.040160E-01,5.364950E-01,1.047400E+00,&
     & 1.485320E+00,1.486520E+00,1.316730E+00,1.197670E+00,4.584210E-01,&
     & 3.457020E-01,2.524890E-01,2.168190E-01,1.510840E-01,1.841360E-01,&
     & 8.361160E-02,6.130060E-07,1.320520E-06,3.038290E-01,8.395070E-01,&
     & 1.135430E+00,1.504260E+00,1.376030E+00,1.074290E+00,7.896340E-01,&
     & 3.961510E-01,3.309660E-01,2.046900E-01,3.110210E-01,1.789480E-01,&
     & 1.873020E-01,7.740420E-02,6.056640E-07,1.380260E-06,4.456730E-01,&
     & 1.057310E+00,1.430740E+00,1.249000E+00,1.191260E+00,9.851780E-01,&
     & 4.554620E-01,3.456580E-01,3.127700E-01,2.565670E-01,3.103160E-01,&
     & 1.789160E-01,1.922980E-01,6.798110E-02,5.983030E-07,1.439910E-06,&
     & 7.123420E-01,1.239800E+00,1.386400E+00,1.250500E+00,1.051590E+00,&
     & 5.884570E-01,4.247260E-01,3.110050E-01,3.054600E-01,2.569170E-01,&
     & 3.099490E-01,1.779620E-01,2.018270E-01,5.197820E-02,5.992920E-07,&
     & 1.054350E-03,9.762340E-01,1.697070E+00,1.345940E+00,9.335910E-01,&
     & 7.742370E-01,3.737350E-01,3.466000E-01,3.086240E-01,3.140800E-01,&
     & 2.561610E-01,3.109080E-01,1.761900E-01,2.268130E-01,1.128110E-02,&
     & 6.034580E-07,1.454740E-06,1.100610E+00,2.771630E+00,9.078230E-01,&
     & 4.800630E-01,3.865010E-01,3.023700E-01,3.026060E-01,2.923670E-01,&
     & 3.156700E-01,2.731220E-01,2.943660E-01,1.679650E-01,2.343500E-01,&
     & 5.113490E-07,6.151290E-07,1.454800E-06,7.266120E-01,7.848150E-01,&
     & 1.155680E+00,2.390240E+00,8.841280E-01,3.796060E-01,3.027720E-01,&
     & 3.003090E-01,3.217590E-01,2.568600E-01,3.094890E-01,1.788230E-01,&
     & 1.928180E-01,6.722550E-02,5.983030E-07,1.439910E-06 /
      data  ka_mn2o(:,:, 5) /                                           &
     & 2.774420E-05,2.552480E-03,6.687440E-02,4.835720E-01,1.527110E+00,&
     & 1.847200E+00,3.197610E+00,2.065340E+00,1.537390E+00,7.474280E-01,&
     & 6.638290E-01,6.138570E-01,2.781020E-01,1.088730E-01,9.696500E-02,&
     & 9.732120E-02,1.165630E-01,3.688410E-01,8.273520E-01,9.831630E-01,&
     & 1.840160E+00,1.784210E+00,1.381210E+00,8.816210E-01,4.126370E-01,&
     & 5.504080E-01,2.088230E-01,1.486990E-01,1.529120E-01,3.709560E-02,&
     & 7.196580E-07,1.505190E-06,2.074170E-01,5.332850E-01,1.055140E+00,&
     & 1.486800E+00,1.483400E+00,1.304400E+00,1.188420E+00,4.613180E-01,&
     & 3.491110E-01,2.552290E-01,2.184670E-01,1.511980E-01,1.789780E-01,&
     & 8.123470E-02,7.148630E-07,1.539940E-06,3.057540E-01,8.408800E-01,&
     & 1.141460E+00,1.503680E+00,1.367980E+00,1.064200E+00,7.880590E-01,&
     & 3.974460E-01,3.350080E-01,2.056060E-01,3.099650E-01,1.784520E-01,&
     & 1.820540E-01,7.520370E-02,7.062970E-07,1.609590E-06,4.458890E-01,&
     & 1.061680E+00,1.434360E+00,1.247350E+00,1.181020E+00,9.767720E-01,&
     & 4.583400E-01,3.479340E-01,3.156160E-01,2.564320E-01,3.092500E-01,&
     & 1.783590E-01,1.869110E-01,6.604760E-02,6.977170E-07,1.679160E-06,&
     & 7.112340E-01,1.245310E+00,1.389470E+00,1.243730E+00,1.042510E+00,&
     & 5.874740E-01,4.262420E-01,3.141800E-01,3.077170E-01,2.567820E-01,&
     & 3.088670E-01,1.773200E-01,1.961660E-01,5.049910E-02,6.988780E-07,&
     & 1.128850E-03,9.718170E-01,1.704170E+00,1.345990E+00,9.256330E-01,&
     & 7.700080E-01,3.756030E-01,3.481150E-01,3.117680E-01,3.158900E-01,&
     & 2.560300E-01,3.098060E-01,1.753570E-01,2.204360E-01,1.096010E-02,&
     & 7.037410E-07,1.696460E-06,1.093480E+00,2.772540E+00,9.053550E-01,&
     & 4.814960E-01,3.875520E-01,3.035970E-01,3.052120E-01,2.939870E-01,&
     & 3.173880E-01,2.729530E-01,2.933440E-01,1.665300E-01,2.277620E-01,&
     & 5.963350E-07,7.173350E-07,1.696530E-06,7.285060E-01,7.795110E-01,&
     & 1.166040E+00,2.378660E+00,8.797870E-01,3.807770E-01,3.045700E-01,&
     & 3.016780E-01,3.235530E-01,2.567150E-01,3.084280E-01,1.782620E-01,&
     & 1.874110E-01,6.531310E-02,6.977170E-07,1.679160E-06 /
      data  ka_mn2o(:,:, 6) /                                           &
     & 3.365200E-05,2.859060E-03,7.099200E-02,4.882940E-01,1.524190E+00,&
     & 1.849480E+00,3.190290E+00,2.045560E+00,1.530600E+00,7.422230E-01,&
     & 6.571900E-01,6.365790E-01,2.879500E-01,1.139170E-01,9.933850E-02,&
     & 9.967170E-02,1.208980E-01,3.676330E-01,8.296080E-01,9.860770E-01,&
     & 1.841780E+00,1.773860E+00,1.367350E+00,8.811060E-01,4.134180E-01,&
     & 5.645560E-01,2.114330E-01,1.513730E-01,1.525450E-01,3.799820E-02,&
     & 8.392480E-07,1.755280E-06,2.108750E-01,5.300950E-01,1.062930E+00,&
     & 1.488280E+00,1.480280E+00,1.292190E+00,1.179240E+00,4.642330E-01,&
     & 3.525540E-01,2.579990E-01,2.201270E-01,1.513130E-01,1.739650E-01,&
     & 7.892530E-02,8.336440E-07,1.795810E-06,3.076910E-01,8.422560E-01,&
     & 1.147520E+00,1.503100E+00,1.359970E+00,1.054220E+00,7.864860E-01,&
     & 3.987460E-01,3.391000E-01,2.065270E-01,3.089130E-01,1.779580E-01,&
     & 1.769520E-01,7.306560E-02,8.236510E-07,1.877030E-06,4.461040E-01,&
     & 1.066060E+00,1.437990E+00,1.245700E+00,1.170870E+00,9.684370E-01,&
     & 4.612370E-01,3.502250E-01,3.184880E-01,2.562970E-01,3.081880E-01,&
     & 1.778050E-01,1.816740E-01,6.416910E-02,8.136500E-07,1.958160E-06,&
     & 7.101270E-01,1.250840E+00,1.392540E+00,1.237000E+00,1.033520E+00,&
     & 5.864930E-01,4.277630E-01,3.173870E-01,3.099900E-01,2.566470E-01,&
     & 3.077900E-01,1.766800E-01,1.906640E-01,4.906210E-02,8.150120E-07,&
     & 1.208610E-03,9.674210E-01,1.711300E+00,1.346030E+00,9.177430E-01,&
     & 7.658010E-01,3.774790E-01,3.496370E-01,3.149450E-01,3.177100E-01,&
     & 2.559000E-01,3.087090E-01,1.745280E-01,2.142380E-01,1.064820E-02,&
     & 8.206890E-07,1.978350E-06,1.086390E+00,2.773450E+00,9.028930E-01,&
     & 4.829340E-01,3.886070E-01,3.048280E-01,3.078410E-01,2.956170E-01,&
     & 3.191150E-01,2.727840E-01,2.923250E-01,1.651070E-01,2.213580E-01,&
     & 6.954460E-07,8.365230E-07,1.978430E-06,7.304050E-01,7.742430E-01,&
     & 1.176490E+00,2.367130E+00,8.754680E-01,3.819510E-01,3.063790E-01,&
     & 3.030540E-01,3.253570E-01,2.565700E-01,3.073700E-01,1.777020E-01,&
     & 1.821560E-01,6.345510E-02,8.136500E-07,1.958160E-06 /
      data  ka_mn2o(:,:, 7) /                                           &
     & 4.081790E-05,3.202450E-03,7.536310E-02,4.930630E-01,1.521280E+00,&
     & 1.851770E+00,3.182990E+00,2.025960E+00,1.523840E+00,7.370540E-01,&
     & 6.506170E-01,6.601420E-01,2.981460E-01,1.191940E-01,1.017700E-01,&
     & 1.020790E-01,1.253940E-01,3.664280E-01,8.318690E-01,9.890000E-01,&
     & 1.843400E+00,1.763560E+00,1.353620E+00,8.805900E-01,4.142010E-01,&
     & 5.790690E-01,2.140770E-01,1.540940E-01,1.521800E-01,3.892280E-02,&
     & 9.787100E-07,2.046930E-06,2.143900E-01,5.269230E-01,1.070770E+00,&
     & 1.489760E+00,1.477170E+00,1.280100E+00,1.170140E+00,4.671660E-01,&
     & 3.560310E-01,2.607990E-01,2.218000E-01,1.514270E-01,1.690920E-01,&
     & 7.668170E-02,9.721620E-07,2.094200E-06,3.096400E-01,8.436350E-01,&
     & 1.153600E+00,1.502520E+00,1.352010E+00,1.044330E+00,7.849170E-01,&
     & 4.000490E-01,3.432410E-01,2.074520E-01,3.078640E-01,1.774650E-01,&
     & 1.719930E-01,7.098840E-02,9.605030E-07,2.188900E-06,4.463190E-01,&
     & 1.070460E+00,1.441630E+00,1.244050E+00,1.160800E+00,9.601740E-01,&
     & 4.641520E-01,3.525310E-01,3.213860E-01,2.561620E-01,3.071290E-01,&
     & 1.772520E-01,1.765850E-01,6.234400E-02,9.488460E-07,2.283520E-06,&
     & 7.090220E-01,1.256400E+00,1.395620E+00,1.230300E+00,1.024590E+00,&
     & 5.855140E-01,4.292900E-01,3.206260E-01,3.122810E-01,2.565120E-01,&
     & 3.067160E-01,1.760420E-01,1.853170E-01,4.766590E-02,9.504440E-07,&
     & 1.294010E-03,9.630440E-01,1.718460E+00,1.346080E+00,9.099200E-01,&
     & 7.616170E-01,3.793650E-01,3.511650E-01,3.181530E-01,3.195410E-01,&
     & 2.557700E-01,3.076150E-01,1.737030E-01,2.082150E-01,1.034520E-02,&
     & 9.570720E-07,2.307080E-06,1.079350E+00,2.774360E+00,9.004380E-01,&
     & 4.843770E-01,3.896650E-01,3.060640E-01,3.104920E-01,2.972550E-01,&
     & 3.208520E-01,2.726150E-01,2.913110E-01,1.636960E-01,2.151350E-01,&
     & 8.110280E-07,9.755150E-07,2.307160E-06,7.323090E-01,7.690110E-01,&
     & 1.187040E+00,2.355660E+00,8.711700E-01,3.831290E-01,3.081990E-01,&
     & 3.044360E-01,3.271720E-01,2.564260E-01,3.063160E-01,1.771440E-01,&
     & 1.770480E-01,6.165000E-02,9.488460E-07,2.283520E-06 /
      data  ka_mn2o(:,:, 8) /                                           &
     & 4.950980E-05,3.587100E-03,8.000340E-02,4.978780E-01,1.518370E+00,&
     & 1.854060E+00,3.175710E+00,2.006560E+00,1.517120E+00,7.319210E-01,&
     & 6.441110E-01,6.845770E-01,3.087040E-01,1.247160E-01,1.042610E-01,&
     & 1.045440E-01,1.300570E-01,3.652270E-01,8.341370E-01,9.919310E-01,&
     & 1.845030E+00,1.753330E+00,1.340020E+00,8.800750E-01,4.149860E-01,&
     & 5.939540E-01,2.167530E-01,1.568650E-01,1.518160E-01,3.986980E-02,&
     & 1.141350E-06,2.387030E-06,2.179640E-01,5.237710E-01,1.078680E+00,&
     & 1.491240E+00,1.474060E+00,1.268110E+00,1.161100E+00,4.701180E-01,&
     & 3.595430E-01,2.636300E-01,2.234860E-01,1.515420E-01,1.643560E-01,&
     & 7.450170E-02,1.133700E-06,2.442170E-06,3.116010E-01,8.450150E-01,&
     & 1.159720E+00,1.501950E+00,1.344100E+00,1.034530E+00,7.833510E-01,&
     & 4.013570E-01,3.474330E-01,2.083810E-01,3.068190E-01,1.769730E-01,&
     & 1.671730E-01,6.897020E-02,1.120090E-06,2.552590E-06,4.465350E-01,&
     & 1.074880E+00,1.445280E+00,1.242410E+00,1.150820E+00,9.519810E-01,&
     & 4.670850E-01,3.548520E-01,3.243100E-01,2.560270E-01,3.060740E-01,&
     & 1.767010E-01,1.716370E-01,6.057080E-02,1.106510E-06,2.662940E-06,&
     & 7.079190E-01,1.261990E+00,1.398700E+00,1.223640E+00,1.015750E+00,&
     & 5.845360E-01,4.308220E-01,3.238990E-01,3.145880E-01,2.563770E-01,&
     & 3.056460E-01,1.754060E-01,1.801190E-01,4.630960E-02,1.108380E-06,&
     & 1.385440E-03,9.586870E-01,1.725650E+00,1.346130E+00,9.021640E-01,&
     & 7.574570E-01,3.812600E-01,3.527000E-01,3.213940E-01,3.213820E-01,&
     & 2.556400E-01,3.065250E-01,1.728820E-01,2.023600E-01,1.005080E-02,&
     & 1.116120E-06,2.690430E-06,1.072350E+00,2.775270E+00,8.979900E-01,&
     & 4.858230E-01,3.907250E-01,3.073060E-01,3.131670E-01,2.989020E-01,&
     & 3.225980E-01,2.724470E-01,2.902990E-01,1.622970E-01,2.090860E-01,&
     & 9.458210E-07,1.137600E-06,2.690510E-06,7.342180E-01,7.638130E-01,&
     & 1.197680E+00,2.344250E+00,8.668930E-01,3.843100E-01,3.100290E-01,&
     & 3.058240E-01,3.289960E-01,2.562820E-01,3.052660E-01,1.765880E-01,&
     & 1.720840E-01,5.989630E-02,1.106510E-06,2.662940E-06  /
      data  ka_mn2o(:,:, 9) /                                           &
     & 6.005250E-05,4.017940E-03,8.492940E-02,5.027400E-01,1.515470E+00,&
     & 1.856350E+00,3.168440E+00,1.987330E+00,1.510420E+00,7.268240E-01,&
     & 6.376690E-01,7.099160E-01,3.196350E-01,1.304940E-01,1.068130E-01,&
     & 1.070690E-01,1.348930E-01,3.640310E-01,8.364100E-01,9.948710E-01,&
     & 1.846650E+00,1.743150E+00,1.326570E+00,8.795600E-01,4.157710E-01,&
     & 6.092220E-01,2.194630E-01,1.596850E-01,1.514520E-01,4.083990E-02,&
     & 1.331010E-06,2.783640E-06,2.215980E-01,5.206370E-01,1.086650E+00,&
     & 1.492720E+00,1.470960E+00,1.256240E+00,1.152130E+00,4.730880E-01,&
     & 3.630890E-01,2.664910E-01,2.251850E-01,1.516570E-01,1.597520E-01,&
     & 7.238380E-02,1.322070E-06,2.847960E-06,3.135750E-01,8.463980E-01,&
     & 1.165880E+00,1.501370E+00,1.336230E+00,1.024820E+00,7.817870E-01,&
     & 4.026690E-01,3.516760E-01,2.093140E-01,3.057770E-01,1.764830E-01,&
     & 1.624890E-01,6.700940E-02,1.306200E-06,2.976710E-06,4.467500E-01,&
     & 1.079320E+00,1.448940E+00,1.240770E+00,1.140920E+00,9.438590E-01,&
     & 4.700370E-01,3.571890E-01,3.272610E-01,2.558930E-01,3.050220E-01,&
     & 1.761520E-01,1.668290E-01,5.884810E-02,1.290360E-06,3.105410E-06,&
     & 7.068180E-01,1.267600E+00,1.401790E+00,1.217010E+00,1.006980E+00,&
     & 5.835590E-01,4.323590E-01,3.272050E-01,3.169120E-01,2.562430E-01,&
     & 3.045790E-01,1.747730E-01,1.750670E-01,4.499180E-02,1.292560E-06,&
     & 1.483340E-03,9.543500E-01,1.732870E+00,1.346180E+00,8.944730E-01,&
     & 7.533190E-01,3.831650E-01,3.542420E-01,3.246680E-01,3.232340E-01,&
     & 2.555110E-01,3.054390E-01,1.720640E-01,1.966710E-01,9.764740E-03,&
     & 1.301600E-06,3.137480E-06,1.065400E+00,2.776180E+00,8.955490E-01,&
     & 4.872740E-01,3.917880E-01,3.085520E-01,3.158640E-01,3.005590E-01,&
     & 3.243540E-01,2.722790E-01,2.892910E-01,1.609100E-01,2.032080E-01,&
     & 1.103020E-06,1.326620E-06,3.137570E-06,7.361320E-01,7.586520E-01,&
     & 1.208410E+00,2.332890E+00,8.626370E-01,3.854950E-01,3.118700E-01,&
     & 3.072190E-01,3.308310E-01,2.561370E-01,3.042200E-01,1.760340E-01,&
     & 1.672590E-01,5.819240E-02,1.290360E-06,3.105410E-06 /
      data  ka_mn2o(:,:,10) /                                           &
     & 7.284010E-05,4.500530E-03,9.015860E-02,5.076490E-01,1.512570E+00,&
     & 1.858640E+00,3.161190E+00,1.968300E+00,1.503760E+00,7.217620E-01,&
     & 6.312920E-01,7.361940E-01,3.309530E-01,1.365400E-01,1.094280E-01,&
     & 1.096550E-01,1.399090E-01,3.628380E-01,8.386900E-01,9.978200E-01,&
     & 1.848280E+00,1.733040E+00,1.313250E+00,8.790460E-01,4.165590E-01,&
     & 6.248830E-01,2.222070E-01,1.625560E-01,1.510890E-01,4.183360E-02,&
     & 1.552200E-06,3.246150E-06,2.252920E-01,5.175230E-01,1.094670E+00,&
     & 1.494200E+00,1.467870E+00,1.244480E+00,1.143230E+00,4.760780E-01,&
     & 3.666700E-01,2.693830E-01,2.268960E-01,1.517720E-01,1.552780E-01,&
     & 7.032610E-02,1.541750E-06,3.321170E-06,3.155620E-01,8.477830E-01,&
     & 1.172060E+00,1.500790E+00,1.328410E+00,1.015200E+00,7.802270E-01,&
     & 4.039850E-01,3.559710E-01,2.102510E-01,3.047390E-01,1.759940E-01,&
     & 1.579350E-01,6.510440E-02,1.523230E-06,3.471300E-06,4.469660E-01,&
     & 1.083770E+00,1.452610E+00,1.239130E+00,1.131110E+00,9.358050E-01,&
     & 4.730070E-01,3.595410E-01,3.302390E-01,2.557580E-01,3.039740E-01,&
     & 1.756040E-01,1.621550E-01,5.717430E-02,1.504770E-06,3.621390E-06,&
     & 7.057180E-01,1.273230E+00,1.404890E+00,1.210430E+00,9.982910E-01,&
     & 5.825850E-01,4.339020E-01,3.305450E-01,3.192530E-01,2.561080E-01,&
     & 3.035170E-01,1.741420E-01,1.701570E-01,4.371150E-02,1.507350E-06,&
     & 1.588150E-03,9.500320E-01,1.740120E+00,1.346230E+00,8.868490E-01,&
     & 7.492030E-01,3.850790E-01,3.557910E-01,3.279760E-01,3.250970E-01,&
     & 2.553810E-01,3.043570E-01,1.712510E-01,1.911410E-01,9.486850E-03,&
     & 1.517900E-06,3.658800E-06,1.058500E+00,2.777090E+00,8.931140E-01,&
     & 4.887300E-01,3.928550E-01,3.098040E-01,3.185840E-01,3.022250E-01,&
     & 3.261200E-01,2.721100E-01,2.882870E-01,1.595350E-01,1.974950E-01,&
     & 1.286340E-06,1.547040E-06,3.658900E-06,7.380510E-01,7.535250E-01,&
     & 1.219250E+00,2.321580E+00,8.584020E-01,3.866840E-01,3.137230E-01,&
     & 3.086200E-01,3.326750E-01,2.559930E-01,3.031770E-01,1.754810E-01,&
     & 1.625690E-01,5.653700E-02,1.504770E-06,3.621390E-06 /
      data  ka_mn2o(:,:,11) /                                           &
     & 8.835080E-05,5.041090E-03,9.570990E-02,5.126070E-01,1.509680E+00,&
     & 1.860940E+00,3.153950E+00,1.949440E+00,1.497120E+00,7.167360E-01,&
     & 6.249780E-01,7.634440E-01,3.426720E-01,1.428650E-01,1.121070E-01,&
     & 1.123040E-01,1.451120E-01,3.616490E-01,8.409760E-01,1.000780E+00,&
     & 1.849910E+00,1.722980E+00,1.300060E+00,8.785310E-01,4.173480E-01,&
     & 6.409460E-01,2.249850E-01,1.654780E-01,1.507280E-01,4.285150E-02,&
     & 1.810130E-06,3.785510E-06,2.290480E-01,5.144260E-01,1.102750E+00,&
     & 1.495690E+00,1.464790E+00,1.232830E+00,1.134400E+00,4.790860E-01,&
     & 3.702860E-01,2.723070E-01,2.286210E-01,1.518870E-01,1.509280E-01,&
     & 6.832690E-02,1.797920E-06,3.873020E-06,3.175610E-01,8.491700E-01,&
     & 1.178280E+00,1.500220E+00,1.320640E+00,1.005680E+00,7.786710E-01,&
     & 4.053060E-01,3.603190E-01,2.111930E-01,3.037050E-01,1.755060E-01,&
     & 1.535090E-01,6.325350E-02,1.776320E-06,4.048070E-06,4.471820E-01,&
     & 1.088240E+00,1.456280E+00,1.237490E+00,1.121390E+00,9.278210E-01,&
     & 4.759960E-01,3.619080E-01,3.332440E-01,2.556240E-01,3.029300E-01,&
     & 1.750580E-01,1.576120E-01,5.554820E-02,1.754800E-06,4.223100E-06,&
     & 7.046200E-01,1.278890E+00,1.408000E+00,1.203870E+00,9.896740E-01,&
     & 5.816120E-01,4.354500E-01,3.339190E-01,3.216120E-01,2.559740E-01,&
     & 3.024580E-01,1.735130E-01,1.653850E-01,4.246760E-02,1.757830E-06,&
     & 1.700370E-03,9.457340E-01,1.747400E+00,1.346270E+00,8.792890E-01,&
     & 7.451100E-01,3.870030E-01,3.573460E-01,3.313170E-01,3.269700E-01,&
     & 2.552510E-01,3.032780E-01,1.704410E-01,1.857670E-01,9.216870E-03,&
     & 1.770140E-06,4.266760E-06,1.051640E+00,2.778000E+00,8.906860E-01,&
     & 4.901890E-01,3.939240E-01,3.110600E-01,3.213280E-01,3.038990E-01,&
     & 3.278950E-01,2.719420E-01,2.872860E-01,1.581710E-01,1.919420E-01,&
     & 1.500120E-06,1.804090E-06,4.266860E-06,7.399750E-01,7.484320E-01,&
     & 1.230180E+00,2.310330E+00,8.541870E-01,3.878760E-01,3.155860E-01,&
     & 3.100270E-01,3.345300E-01,2.558490E-01,3.021370E-01,1.749310E-01,&
     & 1.580100E-01,5.492870E-02,1.754800E-06,4.223100E-06 /
      data  ka_mn2o(:,:,12) /                                           &
     & 1.071640E-04,5.646570E-03,1.016030E-01,5.176130E-01,1.506790E+00,&
     & 1.863240E+00,3.146730E+00,1.930770E+00,1.490510E+00,7.117440E-01,&
     & 6.187280E-01,7.917020E-01,3.548060E-01,1.494840E-01,1.148510E-01,&
     & 1.150160E-01,1.505080E-01,3.604640E-01,8.432690E-01,1.003740E+00,&
     & 1.851540E+00,1.712980E+00,1.287010E+00,8.780170E-01,4.181380E-01,&
     & 6.574220E-01,2.277980E-01,1.684540E-01,1.503670E-01,4.389420E-02,&
     & 2.110940E-06,4.414490E-06,2.328670E-01,5.113490E-01,1.110890E+00,&
     & 1.497170E+00,1.461710E+00,1.221290E+00,1.125640E+00,4.821130E-01,&
     & 3.739380E-01,2.752620E-01,2.303580E-01,1.520020E-01,1.467010E-01,&
     & 6.638450E-02,2.096660E-06,4.516560E-06,3.195720E-01,8.505590E-01,&
     & 1.184530E+00,1.499640E+00,1.312910E+00,9.962380E-01,7.771170E-01,&
     & 4.066300E-01,3.647190E-01,2.121390E-01,3.026740E-01,1.750200E-01,&
     & 1.492070E-01,6.145520E-02,2.071470E-06,4.720670E-06,4.473980E-01,&
     & 1.092740E+00,1.459970E+00,1.235860E+00,1.111740E+00,9.199040E-01,&
     & 4.790040E-01,3.642910E-01,3.362760E-01,2.554890E-01,3.018890E-01,&
     & 1.745140E-01,1.531960E-01,5.396830E-02,2.046380E-06,4.924800E-06,&
     & 7.035240E-01,1.284580E+00,1.411110E+00,1.197350E+00,9.811310E-01,&
     & 5.806400E-01,4.370040E-01,3.373280E-01,3.239880E-01,2.558390E-01,&
     & 3.014030E-01,1.728870E-01,1.607460E-01,4.125920E-02,2.049930E-06,&
     & 1.820520E-03,9.414550E-01,1.754710E+00,1.346320E+00,8.717940E-01,&
     & 7.410400E-01,3.889370E-01,3.589080E-01,3.346930E-01,3.288540E-01,&
     & 2.551210E-01,3.022040E-01,1.696360E-01,1.805440E-01,8.954580E-03,&
     & 2.064300E-06,4.975740E-06,1.044820E+00,2.778910E+00,8.882640E-01,&
     & 4.916530E-01,3.949960E-01,3.123220E-01,3.240960E-01,3.055840E-01,&
     & 3.296790E-01,2.717740E-01,2.862890E-01,1.568190E-01,1.865460E-01,&
     & 1.749440E-06,2.103840E-06,4.975840E-06,7.419040E-01,7.433740E-01,&
     & 1.241210E+00,2.299140E+00,8.499940E-01,3.890720E-01,3.174600E-01,&
     & 3.114410E-01,3.363960E-01,2.557050E-01,3.011010E-01,1.743820E-01,&
     & 1.535800E-01,5.336610E-02,2.046380E-06,4.924800E-06 /
      data  ka_mn2o(:,:,13) /                                           &
     & 1.299840E-04,6.324770E-03,1.078590E-01,5.226670E-01,1.503910E+00,&
     & 1.865550E+00,3.139530E+00,1.912270E+00,1.483930E+00,7.067880E-01,&
     & 6.125400E-01,8.210070E-01,3.673700E-01,1.564090E-01,1.176620E-01,&
     & 1.177940E-01,1.561040E-01,3.592830E-01,8.455670E-01,1.006720E+00,&
     & 1.853170E+00,1.703040E+00,1.274080E+00,8.775040E-01,4.189300E-01,&
     & 6.743210E-01,2.306460E-01,1.714820E-01,1.500070E-01,4.496220E-02,&
     & 2.461720E-06,5.147960E-06,2.367490E-01,5.082900E-01,1.119100E+00,&
     & 1.498660E+00,1.458630E+00,1.209850E+00,1.116950E+00,4.851590E-01,&
     & 3.776260E-01,2.782500E-01,2.321090E-01,1.521170E-01,1.425920E-01,&
     & 6.449730E-02,2.445040E-06,5.267030E-06,3.215970E-01,8.519510E-01,&
     & 1.190820E+00,1.499060E+00,1.305220E+00,9.868900E-01,7.755660E-01,&
     & 4.079600E-01,3.691730E-01,2.130890E-01,3.016460E-01,1.745350E-01,&
     & 1.450260E-01,5.970810E-02,2.415650E-06,5.505020E-06,4.476140E-01,&
     & 1.097250E+00,1.463670E+00,1.234230E+00,1.102190E+00,9.120550E-01,&
     & 4.820310E-01,3.666890E-01,3.393360E-01,2.553550E-01,3.008520E-01,&
     & 1.739710E-01,1.489040E-01,5.243340E-02,2.386410E-06,5.743080E-06,&
     & 7.024290E-01,1.290290E+00,1.414230E+00,1.190870E+00,9.726630E-01,&
     & 5.796710E-01,4.385640E-01,3.407710E-01,3.263820E-01,2.557050E-01,&
     & 3.003510E-01,1.722620E-01,1.562380E-01,4.008510E-02,2.390570E-06,&
     & 1.949150E-03,9.371960E-01,1.762060E+00,1.346370E+00,8.643630E-01,&
     & 7.369910E-01,3.908800E-01,3.604770E-01,3.381020E-01,3.307490E-01,&
     & 2.549920E-01,3.011330E-01,1.688340E-01,1.754670E-01,8.699740E-03,&
     & 2.407350E-06,5.802510E-06,1.038050E+00,2.779820E+00,8.858490E-01,&
     & 4.931220E-01,3.960710E-01,3.135890E-01,3.268870E-01,3.072770E-01,&
     & 3.314740E-01,2.716060E-01,2.852950E-01,1.554790E-01,1.813010E-01,&
     & 2.040200E-06,2.453400E-06,5.802610E-06,7.438380E-01,7.383500E-01,&
     & 1.252330E+00,2.288000E+00,8.458210E-01,3.902720E-01,3.193450E-01,&
     & 3.128610E-01,3.382720E-01,2.555610E-01,3.000690E-01,1.738340E-01,&
     & 1.492730E-01,5.184800E-02,2.386410E-06,5.743080E-06 /
      data  ka_mn2o(:,:,14) /                                           &
     & 1.576630E-04,7.084440E-03,1.145000E-01,5.277710E-01,1.501040E+00,&
     & 1.867850E+00,3.132350E+00,1.893950E+00,1.477380E+00,7.018660E-01,&
     & 6.064140E-01,8.513960E-01,3.803790E-01,1.636550E-01,1.205420E-01,&
     & 1.206390E-01,1.619090E-01,3.581060E-01,8.478720E-01,1.009700E+00,&
     & 1.854800E+00,1.693160E+00,1.261290E+00,8.769900E-01,4.197230E-01,&
     & 6.916550E-01,2.335290E-01,1.745650E-01,1.496470E-01,4.605620E-02,&
     & 2.870800E-06,6.003310E-06,2.406960E-01,5.052490E-01,1.127360E+00,&
     & 1.500150E+00,1.455570E+00,1.198530E+00,1.108320E+00,4.882250E-01,&
     & 3.813500E-01,2.812690E-01,2.338730E-01,1.522330E-01,1.385980E-01,&
     & 6.266380E-02,2.851310E-06,6.142190E-06,3.236340E-01,8.533450E-01,&
     & 1.197140E+00,1.498490E+00,1.297580E+00,9.776290E-01,7.740190E-01,&
     & 4.092930E-01,3.736820E-01,2.140430E-01,3.006220E-01,1.740510E-01,&
     & 1.409620E-01,5.801060E-02,2.817010E-06,6.419700E-06,4.478300E-01,&
     & 1.101780E+00,1.467370E+00,1.232600E+00,1.092710E+00,9.042730E-01,&
     & 4.850780E-01,3.691040E-01,3.424240E-01,2.552200E-01,2.998190E-01,&
     & 1.734300E-01,1.447330E-01,5.094210E-02,2.782940E-06,6.697330E-06,&
     & 7.013360E-01,1.296020E+00,1.417360E+00,1.184420E+00,9.642670E-01,&
     & 5.787030E-01,4.401290E-01,3.442490E-01,3.287930E-01,2.555700E-01,&
     & 2.993030E-01,1.716400E-01,1.518560E-01,3.894440E-02,2.787820E-06,&
     & 2.086880E-03,9.329560E-01,1.769430E+00,1.346420E+00,8.569950E-01,&
     & 7.329650E-01,3.928330E-01,3.620530E-01,3.415470E-01,3.326550E-01,&
     & 2.548620E-01,3.000660E-01,1.680360E-01,1.705340E-01,8.452160E-03,&
     & 2.807410E-06,6.766670E-06,1.031320E+00,2.780740E+00,8.834410E-01,&
     & 4.945950E-01,3.971490E-01,3.148600E-01,3.297030E-01,3.089800E-01,&
     & 3.332780E-01,2.714380E-01,2.843040E-01,1.541500E-01,1.762040E-01,&
     & 2.379280E-06,2.861050E-06,6.766770E-06,7.457770E-01,7.333600E-01,&
     & 1.263560E+00,2.276910E+00,8.416680E-01,3.914750E-01,3.212420E-01,&
     & 3.142880E-01,3.401580E-01,2.554170E-01,2.990400E-01,1.732890E-01,&
     & 1.450870E-01,5.037300E-02,2.782940E-06,6.697330E-06 /
      data  ka_mn2o(:,:,15) /                                           &
     & 1.912360E-04,7.935340E-03,1.215500E-01,5.329250E-01,1.498170E+00,&
     & 1.870160E+00,3.125180E+00,1.875810E+00,1.470860E+00,6.969780E-01,&
     & 6.003490E-01,8.829100E-01,3.938480E-01,1.712370E-01,1.234930E-01,&
     & 1.235530E-01,1.679300E-01,3.569320E-01,8.501830E-01,1.012700E+00,&
     & 1.856440E+00,1.683330E+00,1.248620E+00,8.764770E-01,4.205180E-01,&
     & 7.094350E-01,2.364490E-01,1.777040E-01,1.492890E-01,4.717690E-02,&
     & 3.347860E-06,7.000780E-06,2.447080E-01,5.022260E-01,1.135680E+00,&
     & 1.501640E+00,1.452510E+00,1.187310E+00,1.099760E+00,4.913100E-01,&
     & 3.851110E-01,2.843220E-01,2.356510E-01,1.523480E-01,1.347150E-01,&
     & 6.088240E-02,3.325080E-06,7.162770E-06,3.256840E-01,8.547420E-01,&
     & 1.203490E+00,1.497910E+00,1.289990E+00,9.684550E-01,7.724740E-01,&
     & 4.106310E-01,3.782460E-01,2.150020E-01,2.996020E-01,1.735690E-01,&
     & 1.370120E-01,5.636140E-02,3.285070E-06,7.486350E-06,4.480460E-01,&
     & 1.106320E+00,1.471080E+00,1.230970E+00,1.083310E+00,8.965570E-01,&
     & 4.881430E-01,3.715340E-01,3.455400E-01,2.550860E-01,2.987890E-01,&
     & 1.728910E-01,1.406780E-01,4.949320E-02,3.245350E-06,7.810130E-06,&
     & 7.002450E-01,1.301780E+00,1.420490E+00,1.178010E+00,9.559440E-01,&
     & 5.777360E-01,4.417000E-01,3.477630E-01,3.312220E-01,2.554360E-01,&
     & 2.982590E-01,1.710210E-01,1.475960E-01,3.783620E-02,3.251070E-06,&
     & 2.234340E-03,9.287350E-01,1.776830E+00,1.346470E+00,8.496900E-01,&
     & 7.289610E-01,3.947950E-01,3.636360E-01,3.450260E-01,3.345720E-01,&
     & 2.547330E-01,2.990030E-01,1.672410E-01,1.657390E-01,8.211630E-03,&
     & 3.273940E-06,7.891040E-06,1.024640E+00,2.781650E+00,8.810390E-01,&
     & 4.960720E-01,3.982290E-01,3.161380E-01,3.325430E-01,3.106930E-01,&
     & 3.350920E-01,2.712700E-01,2.833170E-01,1.528330E-01,1.712500E-01,&
     & 2.774720E-06,3.336420E-06,7.891130E-06,7.477210E-01,7.284040E-01,&
     & 1.274890E+00,2.265880E+00,8.375360E-01,3.926820E-01,3.231500E-01,&
     & 3.157210E-01,3.420550E-01,2.552730E-01,2.980150E-01,1.727450E-01,&
     & 1.410190E-01,4.894010E-02,3.245350E-06,7.810130E-06 /
      data  ka_mn2o(:,:,16) /                                           &
     & 2.319580E-04,8.888450E-03,1.290340E-01,5.381300E-01,1.495300E+00,&
     & 1.872470E+00,3.118030E+00,1.857840E+00,1.464370E+00,6.921240E-01,&
     & 5.943450E-01,9.155910E-01,4.077940E-01,1.791700E-01,1.265160E-01,&
     & 1.265370E-01,1.741750E-01,3.557630E-01,8.525010E-01,1.015700E+00,&
     & 1.858070E+00,1.673560E+00,1.236090E+00,8.759650E-01,4.213150E-01,&
     & 7.276710E-01,2.394050E-01,1.808990E-01,1.489320E-01,4.832480E-02,&
     & 3.904200E-06,8.163980E-06,2.487880E-01,4.992210E-01,1.144070E+00,&
     & 1.503130E+00,1.449460E+00,1.176190E+00,1.091270E+00,4.944140E-01,&
     & 3.889090E-01,2.874080E-01,2.374420E-01,1.524630E-01,1.309420E-01,&
     & 5.915160E-02,3.877580E-06,8.352940E-06,3.277480E-01,8.561400E-01,&
     & 1.209880E+00,1.497340E+00,1.282440E+00,9.593670E-01,7.709330E-01,&
     & 4.119730E-01,3.828650E-01,2.159640E-01,2.985840E-01,1.730880E-01,&
     & 1.331720E-01,5.475900E-02,3.830900E-06,8.730230E-06,4.482620E-01,&
     & 1.110890E+00,1.474810E+00,1.229340E+00,1.074000E+00,8.889070E-01,&
     & 4.912280E-01,3.739800E-01,3.486840E-01,2.549520E-01,2.977620E-01,&
     & 1.723540E-01,1.367360E-01,4.808550E-02,3.784600E-06,9.107840E-06,&
     & 6.991560E-01,1.307570E+00,1.423630E+00,1.171630E+00,9.476920E-01,&
     & 5.767710E-01,4.432760E-01,3.513130E-01,3.336690E-01,2.553020E-01,&
     & 2.972190E-01,1.704030E-01,1.434570E-01,3.675950E-02,3.791310E-06,&
     & 2.392220E-03,9.245330E-01,1.784260E+00,1.346510E+00,8.424470E-01,&
     & 7.249790E-01,3.967680E-01,3.652250E-01,3.485410E-01,3.365000E-01,&
     & 2.546030E-01,2.979440E-01,1.664510E-01,1.610790E-01,7.977940E-03,&
     & 3.818010E-06,9.202230E-06,1.017990E+00,2.782560E+00,8.786440E-01,&
     & 4.975530E-01,3.993130E-01,3.174200E-01,3.354070E-01,3.124140E-01,&
     & 3.369150E-01,2.711020E-01,2.823340E-01,1.515270E-01,1.664350E-01,&
     & 3.235870E-06,3.890780E-06,9.202310E-06,7.496700E-01,7.234820E-01,&
     & 1.286320E+00,2.254900E+00,8.334240E-01,3.938930E-01,3.250690E-01,&
     & 3.171610E-01,3.439620E-01,2.551290E-01,2.969930E-01,1.722020E-01,&
     & 1.370650E-01,4.754790E-02,3.784600E-06,9.107840E-06 /
      data  ka_mn2o(:,:,17) /                                           &
     & 2.813520E-04,9.956030E-03,1.369790E-01,5.433850E-01,1.492450E+00,&
     & 1.874790E+00,3.110890E+00,1.840040E+00,1.457910E+00,6.873040E-01,&
     & 5.884010E-01,9.494810E-01,4.222340E-01,1.874710E-01,1.296130E-01,&
     & 1.295930E-01,1.806520E-01,3.545970E-01,8.548250E-01,1.018710E+00,&
     & 1.859710E+00,1.663850E+00,1.223670E+00,8.754520E-01,4.221120E-01,&
     & 7.463770E-01,2.423980E-01,1.841510E-01,1.485750E-01,4.950060E-02,&
     & 4.552980E-06,9.520450E-06,2.529360E-01,4.962350E-01,1.152520E+00,&
     & 1.504630E+00,1.446410E+00,1.165180E+00,1.082840E+00,4.975380E-01,&
     & 3.927450E-01,2.905270E-01,2.392470E-01,1.525790E-01,1.272740E-01,&
     & 5.747000E-02,4.521880E-06,9.740860E-06,3.298240E-01,8.575410E-01,&
     & 1.216300E+00,1.496760E+00,1.274930E+00,9.503650E-01,7.693940E-01,&
     & 4.133200E-01,3.875410E-01,2.169320E-01,2.975710E-01,1.726090E-01,&
     & 1.294400E-01,5.320220E-02,4.467410E-06,1.018080E-05,4.484790E-01,&
     & 1.115470E+00,1.478540E+00,1.227720E+00,1.064760E+00,8.813230E-01,&
     & 4.943320E-01,3.764430E-01,3.518570E-01,2.548180E-01,2.967390E-01,&
     & 1.718180E-01,1.329060E-01,4.671790E-02,4.413450E-06,1.062120E-05,&
     & 6.980680E-01,1.313380E+00,1.426780E+00,1.165290E+00,9.395120E-01,&
     & 5.758080E-01,4.448580E-01,3.548990E-01,3.361340E-01,2.551680E-01,&
     & 2.961820E-01,1.697880E-01,1.394330E-01,3.571350E-02,4.421320E-06,&
     & 2.561250E-03,9.203500E-01,1.791730E+00,1.346560E+00,8.352660E-01,&
     & 7.210180E-01,3.987500E-01,3.668220E-01,3.520920E-01,3.384390E-01,&
     & 2.544740E-01,2.968880E-01,1.656640E-01,1.565500E-01,7.750910E-03,&
     & 4.452490E-06,1.073130E-05,1.011400E+00,2.783480E+00,8.762550E-01,&
     & 4.990390E-01,4.004000E-01,3.187070E-01,3.382960E-01,3.141460E-01,&
     & 3.387490E-01,2.709350E-01,2.813540E-01,1.502320E-01,1.617560E-01,&
     & 3.773670E-06,4.537250E-06,1.073140E-05,7.516240E-01,7.185920E-01,&
     & 1.297850E+00,2.243970E+00,8.293330E-01,3.951070E-01,3.270000E-01,&
     & 3.186070E-01,3.458800E-01,2.549860E-01,2.959750E-01,1.716620E-01,&
     & 1.332220E-01,4.619530E-02,4.413450E-06,1.062120E-05 /
      data  ka_mn2o(:,:,18) /                                           &
     & 3.412630E-04,1.115180E-02,1.454130E-01,5.486910E-01,1.489590E+00,&
     & 1.877110E+00,3.103770E+00,1.822420E+00,1.451470E+00,6.825170E-01,&
     & 5.825170E-01,9.846260E-01,4.371860E-01,1.961560E-01,1.327850E-01,&
     & 1.327230E-01,1.873690E-01,3.534350E-01,8.571550E-01,1.021730E+00,&
     & 1.861350E+00,1.654190E+00,1.211390E+00,8.749400E-01,4.229120E-01,&
     & 7.655630E-01,2.454290E-01,1.874620E-01,1.482190E-01,5.070510E-02,&
     & 5.309580E-06,1.110230E-05,2.571520E-01,4.932660E-01,1.161030E+00,&
     & 1.506120E+00,1.443370E+00,1.154270E+00,1.074470E+00,5.006820E-01,&
     & 3.966180E-01,2.936800E-01,2.410650E-01,1.526950E-01,1.237090E-01,&
     & 5.583630E-02,5.273230E-06,1.135940E-05,3.319130E-01,8.589440E-01,&
     & 1.222750E+00,1.496190E+00,1.267470E+00,9.414470E-01,7.678590E-01,&
     & 4.146710E-01,3.922740E-01,2.179030E-01,2.965610E-01,1.721310E-01,&
     & 1.258130E-01,5.168970E-02,5.209690E-06,1.187240E-05,4.486950E-01,&
     & 1.120080E+00,1.482280E+00,1.226100E+00,1.055610E+00,8.738030E-01,&
     & 4.974560E-01,3.789210E-01,3.550590E-01,2.546840E-01,2.957200E-01,&
     & 1.712840E-01,1.291820E-01,4.538910E-02,5.146790E-06,1.238590E-05,&
     & 6.969820E-01,1.319220E+00,1.429930E+00,1.158980E+00,9.314020E-01,&
     & 5.748460E-01,4.464450E-01,3.585210E-01,3.386180E-01,2.550340E-01,&
     & 2.951480E-01,1.691750E-01,1.355230E-01,3.469720E-02,5.156020E-06,&
     & 2.742230E-03,9.161870E-01,1.799220E+00,1.346610E+00,8.281470E-01,&
     & 7.170790E-01,4.007420E-01,3.684260E-01,3.556790E-01,3.403900E-01,&
     & 2.543450E-01,2.958360E-01,1.648810E-01,1.521480E-01,7.530330E-03,&
     & 5.192410E-06,1.251440E-05,1.004840E+00,2.784390E+00,8.738730E-01,&
     & 5.005300E-01,4.014890E-01,3.200000E-01,3.412100E-01,3.158870E-01,&
     & 3.405930E-01,2.707670E-01,2.803770E-01,1.489480E-01,1.572080E-01,&
     & 4.400850E-06,5.291120E-06,1.251450E-05,7.535840E-01,7.137360E-01,&
     & 1.309480E+00,2.233100E+00,8.252610E-01,3.963260E-01,3.289420E-01,&
     & 3.200600E-01,3.478090E-01,2.548420E-01,2.949600E-01,1.711230E-01,&
     & 1.294860E-01,4.488110E-02,5.146790E-06,1.238590E-05 /
      data  ka_mn2o(:,:,19) /                                           &
     & 4.139320E-04,1.249130E-02,1.543660E-01,5.540490E-01,1.486750E+00,&
     & 1.879430E+00,3.096670E+00,1.804960E+00,1.445070E+00,6.777640E-01,&
     & 5.766910E-01,1.021070E+00,4.526670E-01,2.052430E-01,1.360360E-01,&
     & 1.359280E-01,1.943370E-01,3.522770E-01,8.594910E-01,1.024760E+00,&
     & 1.862990E+00,1.644590E+00,1.199220E+00,8.744280E-01,4.237130E-01,&
     & 7.852420E-01,2.484970E-01,1.908330E-01,1.478640E-01,5.193880E-02,&
     & 6.191900E-06,1.294700E-05,2.614390E-01,4.903150E-01,1.169600E+00,&
     & 1.507620E+00,1.440330E+00,1.143470E+00,1.066180E+00,5.038450E-01,&
     & 4.005300E-01,2.968680E-01,2.428970E-01,1.528100E-01,1.202440E-01,&
     & 5.424900E-02,6.149430E-06,1.324680E-05,3.340160E-01,8.603500E-01,&
     & 1.229240E+00,1.495610E+00,1.260050E+00,9.326120E-01,7.663270E-01,&
     & 4.160270E-01,3.970650E-01,2.188790E-01,2.955540E-01,1.716540E-01,&
     & 1.222870E-01,5.022020E-02,6.075290E-06,1.384500E-05,4.489120E-01,&
     & 1.124700E+00,1.486030E+00,1.224480E+00,1.046530E+00,8.663470E-01,&
     & 5.006000E-01,3.814160E-01,3.582890E-01,2.545500E-01,2.947040E-01,&
     & 1.707510E-01,1.255630E-01,4.409820E-02,6.001980E-06,1.444390E-05,&
     & 6.958980E-01,1.325080E+00,1.433090E+00,1.152700E+00,9.233630E-01,&
     & 5.738860E-01,4.480380E-01,3.621810E-01,3.411190E-01,2.549000E-01,&
     & 2.941190E-01,1.685640E-01,1.317220E-01,3.370990E-02,6.012800E-06,&
     & 2.935990E-03,9.120420E-01,1.806750E+00,1.346660E+00,8.210870E-01,&
     & 7.131610E-01,4.027440E-01,3.700360E-01,3.593020E-01,3.423510E-01,&
     & 2.542150E-01,2.947880E-01,1.641010E-01,1.478700E-01,7.316030E-03,&
     & 6.055280E-06,1.459390E-05,9.983280E-01,2.785300E+00,8.714970E-01,&
     & 5.020250E-01,4.025820E-01,3.212980E-01,3.441480E-01,3.176380E-01,&
     & 3.424470E-01,2.706000E-01,2.794040E-01,1.476750E-01,1.527880E-01,&
     & 5.132270E-06,6.170260E-06,1.459390E-05,7.555480E-01,7.089120E-01,&
     & 1.321220E+00,2.222280E+00,8.212090E-01,3.975480E-01,3.308950E-01,&
     & 3.215200E-01,3.497490E-01,2.546980E-01,2.939490E-01,1.705860E-01,&
     & 1.258550E-01,4.360440E-02,6.001980E-06,1.444390E-05 /

! --- the array kb_mxxx contains the absorption coefficient for a minor
!     species at the NG03=16 chosen g-values for a reference pressure
!     level above 100~ mb.   the first index in the array, js, runs from
!     1 to 10, and corresponds to different gas column amounts ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the ratio of the
!     reference mls column amount value of gas1 to that of gas2.  the
!     second index refers to temperature in 7.2 degree increments.  for
!     instance, jt = 1 refers to a temperature of 188.0, jt = 2 refers
!     to 195.2, etc. the third index runs over the g-channel (1 to NG03=16).

      data  kb_mn2o(:,:, 1: 2) /                                        &
     & 7.720090E-08,1.945270E-04,8.747970E-03,1.186730E-01,3.977570E-01,&
     & 6.986750E-01,1.829850E+00,4.468430E+00,7.928260E+00,1.052650E+00,&
     & 1.742390E-01,1.602690E-01,2.018460E-01,2.878180E-02,1.522340E-02,&
     & 1.082570E-02,1.299320E-05,7.496150E-04,1.439740E-02,1.321610E-01,&
     & 3.994250E-01,6.988580E-01,1.832290E+00,4.443470E+00,7.892440E+00,&
     & 1.052460E+00,1.741140E-01,1.604970E-01,2.017560E-01,2.885000E-02,&
     & 1.522340E-02,1.082570E-02,6.445180E-05,1.391620E-03,1.830510E-02,&
     & 1.443840E-01,4.005270E-01,7.081510E-01,1.849460E+00,4.431380E+00,&
     & 7.797990E+00,1.052360E+00,1.741420E-01,1.604070E-01,2.018360E-01,&
     & 2.880360E-02,1.520760E-02,1.082570E-02,3.234540E-04,2.423540E-03,&
     & 2.812580E-02,1.580260E-01,4.114550E-01,7.222690E-01,1.883540E+00,&
     & 4.474370E+00,7.537500E+00,9.308360E-01,1.740740E-01,1.604750E-01,&
     & 2.018450E-01,2.877500E-02,1.524220E-02,1.082630E-02,1.459780E-04,&
     & 1.399080E-03,8.829580E-03,4.048850E-02,8.655760E-02,1.758770E-01,&
     & 3.351540E-01,8.828380E-01,5.063190E+00,1.657860E+01,2.319050E+01,&
     & 3.257430E+01,5.341540E+01,1.118480E+02,6.947820E+01,4.534500E-08,&
     & 1.158830E-07,2.386090E-04,9.668280E-03,1.229830E-01,4.010820E-01,&
     & 7.009990E-01,1.836840E+00,4.497930E+00,7.831680E+00,1.039860E+00,&
     & 1.778730E-01,1.628730E-01,2.031100E-01,3.178680E-02,1.692560E-02,&
     & 1.151880E-02,1.782070E-05,8.827160E-04,1.561180E-02,1.365500E-01,&
     & 4.020350E-01,7.014240E-01,1.839430E+00,4.472780E+00,7.795700E+00,&
     & 1.039730E+00,1.777560E-01,1.630960E-01,2.030200E-01,3.184940E-02,&
     & 1.692560E-02,1.151880E-02,8.109960E-05,1.598590E-03,1.968510E-02,&
     & 1.488200E-01,4.028480E-01,7.107270E-01,1.857070E+00,4.460170E+00,&
     & 7.700760E+00,1.039630E+00,1.777800E-01,1.630060E-01,2.031000E-01,&
     & 3.181090E-02,1.690490E-02,1.151880E-02,3.821120E-04,2.736230E-03,&
     & 2.978060E-02,1.626260E-01,4.130770E-01,7.249810E-01,1.891670E+00,&
     & 4.503960E+00,7.437150E+00,9.210990E-01,1.777160E-01,1.630700E-01,&
     & 2.031030E-01,3.177830E-02,1.694880E-02,1.151910E-02,1.756460E-04,&
     & 1.591330E-03,9.538420E-03,4.160640E-02,8.836220E-02,1.785780E-01,&
     & 3.432580E-01,8.922570E-01,5.085950E+00,1.665410E+01,2.330110E+01,&
     & 3.279920E+01,5.319540E+01,1.094890E+02,6.734690E+01,5.751930E-08/
      data  kb_mn2o(:,:, 3: 4) /                                        &
     & 1.739470E-07,2.926800E-04,1.068540E-02,1.274490E-01,4.044340E-01,&
     & 7.033310E-01,1.843860E+00,4.527630E+00,7.736280E+00,1.027230E+00,&
     & 1.815830E-01,1.655190E-01,2.043810E-01,3.510560E-02,1.881810E-02,&
     & 1.225630E-02,2.444190E-05,1.039450E-03,1.692860E-02,1.410840E-01,&
     & 4.046620E-01,7.039990E-01,1.846590E+00,4.502280E+00,7.700140E+00,&
     & 1.027140E+00,1.814750E-01,1.657380E-01,2.042910E-01,3.516060E-02,&
     & 1.881810E-02,1.225630E-02,1.020470E-04,1.836340E-03,2.116920E-02,&
     & 1.533920E-01,4.051820E-01,7.133110E-01,1.864710E+00,4.489160E+00,&
     & 7.604740E+00,1.027040E+00,1.814940E-01,1.656480E-01,2.043710E-01,&
     & 3.513220E-02,1.879160E-02,1.225630E-02,4.514080E-04,3.089260E-03,&
     & 3.153280E-02,1.673600E-01,4.147050E-01,7.277040E-01,1.899830E+00,&
     & 4.533750E+00,7.338140E+00,9.114640E-01,1.814350E-01,1.657060E-01,&
     & 2.043700E-01,3.509510E-02,1.884640E-02,1.225620E-02,2.113440E-04,&
     & 1.810000E-03,1.030420E-02,4.275510E-02,9.020440E-02,1.813210E-01,&
     & 3.515570E-01,9.017770E-01,5.108810E+00,1.672990E+01,2.341230E+01,&
     & 3.302560E+01,5.297630E+01,1.071790E+02,6.528100E+01,7.296200E-08,&
     & 2.611040E-07,3.590050E-04,1.180950E-02,1.320770E-01,4.078140E-01,&
     & 7.056710E-01,1.850910E+00,4.557520E+00,7.642040E+00,1.014750E+00,&
     & 1.853700E-01,1.682080E-01,2.056600E-01,3.877080E-02,2.092220E-02,&
     & 1.304100E-02,3.352320E-05,1.224010E-03,1.835640E-02,1.457690E-01,&
     & 4.073060E-01,7.065830E-01,1.853790E+00,4.531980E+00,7.605760E+00,&
     & 1.014710E+00,1.852710E-01,1.684220E-01,2.055700E-01,3.881610E-02,&
     & 2.092220E-02,1.304100E-02,1.284060E-04,2.109460E-03,2.276510E-02,&
     & 1.581040E-01,4.075300E-01,7.159050E-01,1.872380E+00,4.518340E+00,&
     & 7.509910E+00,1.014610E+00,1.852860E-01,1.683320E-01,2.056500E-01,&
     & 3.880020E-02,2.088900E-02,1.304100E-02,5.332700E-04,3.487830E-03,&
     & 3.338800E-02,1.722320E-01,4.163400E-01,7.304370E-01,1.908030E+00,&
     & 4.563740E+00,7.240450E+00,9.019300E-01,1.852310E-01,1.683860E-01,&
     & 2.056440E-01,3.875800E-02,2.095650E-02,1.304040E-02,2.542960E-04,&
     & 2.058720E-03,1.113140E-02,4.393550E-02,9.208500E-02,1.841070E-01,&
     & 3.600580E-01,9.113980E-01,5.131770E+00,1.680620E+01,2.352400E+01,&
     & 3.325360E+01,5.275820E+01,1.049180E+02,6.327850E+01,9.255090E-08/
      data  kb_mn2o(:,:, 5: 6) /                                        &
     & 3.919320E-07,4.403600E-04,1.305190E-02,1.368740E-01,4.112230E-01,&
     & 7.080190E-01,1.857980E+00,4.587610E+00,7.548950E+00,1.002430E+00,&
     & 1.892360E-01,1.709400E-01,2.069470E-01,4.281870E-02,2.326170E-02,&
     & 1.387590E-02,4.597860E-05,1.441350E-03,1.990470E-02,1.506100E-01,&
     & 4.099680E-01,7.091770E-01,1.861000E+00,4.561880E+00,7.512530E+00,&
     & 1.002430E+00,1.891470E-01,1.711500E-01,2.068570E-01,4.285170E-02,&
     & 2.326170E-02,1.387590E-02,1.615730E-04,2.423190E-03,2.448130E-02,&
     & 1.629620E-01,4.098920E-01,7.185080E-01,1.880080E+00,4.547700E+00,&
     & 7.416270E+00,1.002330E+00,1.891570E-01,1.710600E-01,2.069370E-01,&
     & 4.285120E-02,2.322030E-02,1.387590E-02,6.299780E-04,3.937830E-03,&
     & 3.535240E-02,1.772450E-01,4.179810E-01,7.331800E-01,1.916260E+00,&
     & 4.593920E+00,7.144060E+00,8.924950E-01,1.891070E-01,1.711090E-01,&
     & 2.069260E-01,4.280330E-02,2.330280E-02,1.387490E-02,3.059780E-04,&
     & 2.341610E-03,1.202500E-02,4.514850E-02,9.400490E-02,1.869350E-01,&
     & 3.687640E-01,9.211220E-01,5.154830E+00,1.688270E+01,2.363620E+01,&
     & 3.348320E+01,5.254090E+01,1.027050E+02,6.133730E+01,1.173990E-07,&
     & 5.883110E-07,5.401500E-04,1.442500E-02,1.418450E-01,4.146590E-01,&
     & 7.103750E-01,1.865080E+00,4.617900E+00,7.456990E+00,9.902500E-01,&
     & 1.931820E-01,1.737170E-01,2.082420E-01,4.728930E-02,2.586260E-02,&
     & 1.476430E-02,6.306170E-05,1.697270E-03,2.158360E-02,1.556110E-01,&
     & 4.126470E-01,7.117800E-01,1.868250E+00,4.591970E+00,7.420450E+00,&
     & 9.903030E-01,1.931040E-01,1.739220E-01,2.081520E-01,4.730680E-02,&
     & 2.586260E-02,1.476430E-02,2.033070E-04,2.783580E-03,2.632700E-02,&
     & 1.679680E-01,4.122670E-01,7.211210E-01,1.887810E+00,4.577250E+00,&
     & 7.323790E+00,9.902030E-01,1.931080E-01,1.738320E-01,2.082320E-01,&
     & 4.732520E-02,2.581190E-02,1.476430E-02,7.442230E-04,4.445890E-03,&
     & 3.743240E-02,1.824050E-01,4.196290E-01,7.359330E-01,1.924530E+00,&
     & 4.624310E+00,7.048950E+00,8.831590E-01,1.930640E-01,1.738760E-01,&
     & 2.082170E-01,4.727080E-02,2.591180E-02,1.476270E-02,3.681630E-04,&
     & 2.663380E-03,1.299040E-02,4.639500E-02,9.596470E-02,1.898060E-01,&
     & 3.776800E-01,9.309500E-01,5.178000E+00,1.695960E+01,2.374890E+01,&
     & 3.371430E+01,5.232450E+01,1.005380E+02,5.945580E+01,1.489180E-07/
      data  kb_mn2o(:,:, 7: 8) /                                        &
     & 8.830880E-07,6.625540E-04,1.594260E-02,1.469960E-01,4.181250E-01,&
     & 7.127380E-01,1.872210E+00,4.648390E+00,7.366160E+00,9.782200E-01,&
     & 1.972110E-01,1.765400E-01,2.095460E-01,5.222660E-02,2.875450E-02,&
     & 1.570960E-02,8.649200E-05,1.998630E-03,2.340410E-02,1.607790E-01,&
     & 4.153430E-01,7.143930E-01,1.875530E+00,4.622270E+00,7.329490E+00,&
     & 9.783190E-01,1.971440E-01,1.767380E-01,2.094560E-01,5.222510E-02,&
     & 2.875450E-02,1.570960E-02,2.558210E-04,3.197580E-03,2.831170E-02,&
     & 1.731280E-01,4.146560E-01,7.237430E-01,1.895580E+00,4.607000E+00,&
     & 7.232470E+00,9.782190E-01,1.971430E-01,1.766490E-01,2.095360E-01,&
     & 5.226630E-02,2.869280E-02,1.570960E-02,8.791870E-04,5.019500E-03,&
     & 3.963480E-02,1.877140E-01,4.212830E-01,7.386970E-01,1.932830E+00,&
     & 4.654900E+00,6.955100E+00,8.739210E-01,1.971040E-01,1.766870E-01,&
     & 2.095150E-01,5.220460E-02,2.881290E-02,1.570730E-02,4.429860E-04,&
     & 3.029370E-03,1.403330E-02,4.767590E-02,9.796550E-02,1.927220E-01,&
     & 3.868120E-01,9.408830E-01,5.201270E+00,1.703690E+01,2.386220E+01,&
     & 3.394710E+01,5.210900E+01,9.841750E+01,5.763190E+01,1.889000E-07,&
     & 1.325560E-06,8.126970E-04,1.761980E-02,1.523340E-01,4.216200E-01,&
     & 7.151100E-01,1.879370E+00,4.679080E+00,7.276430E+00,9.663380E-01,&
     & 2.013240E-01,1.794080E-01,2.108570E-01,5.767940E-02,3.196960E-02,&
     & 1.671540E-02,1.186280E-04,2.353510E-03,2.537810E-02,1.661180E-01,&
     & 4.180570E-01,7.170160E-01,1.882830E+00,4.652760E+00,7.239650E+00,&
     & 9.664800E-01,2.012680E-01,1.796010E-01,2.107670E-01,5.765470E-02,&
     & 3.196960E-02,1.671540E-02,3.218990E-04,3.673140E-03,3.044610E-02,&
     & 1.784470E-01,4.170580E-01,7.263750E-01,1.903380E+00,4.636940E+00,&
     & 7.142290E+00,9.663800E-01,2.012610E-01,1.795110E-01,2.108470E-01,&
     & 5.772320E-02,3.189510E-02,1.671540E-02,1.038630E-03,5.667120E-03,&
     & 4.196670E-02,1.931790E-01,4.229440E-01,7.414710E-01,1.941170E+00,&
     & 4.685690E+00,6.862510E+00,8.647790E-01,2.012290E-01,1.795440E-01,&
     & 2.108220E-01,5.765330E-02,3.203890E-02,1.671240E-02,5.330170E-04,&
     & 3.445640E-03,1.515990E-02,4.899210E-02,1.000080E-01,1.956820E-01,&
     & 3.961640E-01,9.509210E-01,5.224640E+00,1.711450E+01,2.397600E+01,&
     & 3.418150E+01,5.189430E+01,9.634140E+01,5.586400E+01,2.396160E-07/
      data  kb_mn2o(:,:, 9:10) /                                        &
     & 1.989750E-06,9.968640E-04,1.947350E-02,1.578660E-01,4.251440E-01,&
     & 7.174890E-01,1.886550E+00,4.709970E+00,7.187790E+00,9.545990E-01,&
     & 2.055230E-01,1.823220E-01,2.121770E-01,6.370150E-02,3.554430E-02,&
     & 1.778570E-02,1.627030E-04,2.771390E-03,2.751870E-02,1.716340E-01,&
     & 4.207890E-01,7.196480E-01,1.890160E+00,4.683450E+00,7.150910E+00,&
     & 9.547840E-01,2.054790E-01,1.825100E-01,2.120870E-01,6.364880E-02,&
     & 3.554430E-02,1.778570E-02,4.050450E-04,4.219440E-03,3.274140E-02,&
     & 1.839290E-01,4.194750E-01,7.290170E-01,1.911200E+00,4.667080E+00,&
     & 7.053230E+00,9.546840E-01,2.054660E-01,1.824200E-01,2.121670E-01,&
     & 6.374990E-02,3.545490E-02,1.778570E-02,1.226980E-03,6.398290E-03,&
     & 4.443580E-02,1.988020E-01,4.246110E-01,7.442560E-01,1.949550E+00,&
     & 4.716680E+00,6.771150E+00,8.557330E-01,2.054390E-01,1.824480E-01,&
     & 2.121360E-01,6.367070E-02,3.562600E-02,1.778180E-02,6.413440E-04,&
     & 3.919120E-03,1.637690E-02,5.034480E-02,1.020930E-01,1.986880E-01,&
     & 4.057430E-01,9.610670E-01,5.248130E+00,1.719250E+01,2.409040E+01,&
     & 3.441740E+01,5.168060E+01,9.430910E+01,5.415030E+01,3.039480E-07,&
     & 2.986720E-06,1.222760E-03,2.152210E-02,1.635990E-01,4.286970E-01,&
     & 7.198760E-01,1.893760E+00,4.741060E+00,7.100230E+00,9.430030E-01,&
     & 2.098090E-01,1.852840E-01,2.135050E-01,7.035230E-02,3.951870E-02,&
     & 1.892440E-02,2.231550E-04,3.263470E-03,2.983970E-02,1.773340E-01,&
     & 4.235390E-01,7.222890E-01,1.897530E+00,4.714350E+00,7.063250E+00,&
     & 9.432300E-01,2.097780E-01,1.854660E-01,2.134150E-01,7.026610E-02,&
     & 3.951870E-02,1.892440E-02,5.096670E-04,4.846980E-03,3.520970E-02,&
     & 1.895800E-01,4.219060E-01,7.316680E-01,1.919070E+00,4.697410E+00,&
     & 6.965280E+00,9.431300E-01,2.097590E-01,1.853760E-01,2.134950E-01,&
     & 7.040580E-02,3.941200E-02,1.892440E-02,1.449490E-03,7.223790E-03,&
     & 4.705020E-02,2.045890E-01,4.262850E-01,7.470510E-01,1.957960E+00,&
     & 4.747880E+00,6.681010E+00,8.467810E-01,2.097380E-01,1.853980E-01,&
     & 2.134590E-01,7.031620E-02,3.961480E-02,1.891960E-02,7.716870E-04,&
     & 4.457660E-03,1.769170E-02,5.173470E-02,1.042210E-01,2.017400E-01,&
     & 4.155530E-01,9.713210E-01,5.271710E+00,1.727080E+01,2.420530E+01,&
     & 3.465500E+01,5.146770E+01,9.231960E+01,5.248920E+01,3.855510E-07/
      data  kb_mn2o(:,:,11:12) /                                        &
     & 4.483240E-06,1.499860E-03,2.378630E-02,1.695410E-01,4.322800E-01,&
     & 7.222710E-01,1.901000E+00,4.772360E+00,7.013740E+00,9.315480E-01,&
     & 2.141850E-01,1.882950E-01,2.148410E-01,7.769760E-02,4.393740E-02,&
     & 2.013600E-02,3.060670E-04,3.842930E-03,3.235660E-02,1.832230E-01,&
     & 4.263070E-01,7.249410E-01,1.904920E+00,4.745440E+00,6.976680E+00,&
     & 9.318150E-01,2.141660E-01,1.884690E-01,2.147510E-01,7.757140E-02,&
     & 4.393740E-02,2.013600E-02,6.413130E-04,5.567860E-03,3.786420E-02,&
     & 1.954040E-01,4.243510E-01,7.343290E-01,1.926960E+00,4.727930E+00,&
     & 6.878430E+00,9.317150E-01,2.141410E-01,1.883800E-01,2.148310E-01,&
     & 7.775670E-02,4.381070E-02,2.013600E-02,1.712350E-03,8.155810E-03,&
     & 4.981850E-02,2.105440E-01,4.279660E-01,7.498560E-01,1.966410E+00,&
     & 4.779280E+00,6.592060E+00,8.379230E-01,2.141270E-01,1.883960E-01,&
     & 2.147900E-01,7.765530E-02,4.405010E-02,2.013020E-02,9.285220E-04,&
     & 5.070210E-03,1.911200E-02,5.316300E-02,1.063940E-01,2.048390E-01,&
     & 4.256010E-01,9.816850E-01,5.295400E+00,1.734950E+01,2.432080E+01,&
     & 3.489430E+01,5.125580E+01,9.037220E+01,5.087910E+01,4.890640E-07,&
     & 6.729600E-06,1.839740E-03,2.628870E-02,1.756980E-01,4.358930E-01,&
     & 7.246740E-01,1.908270E+00,4.803870E+00,6.928310E+00,9.202320E-01,&
     & 2.186520E-01,1.913540E-01,2.161860E-01,8.580970E-02,4.885030E-02,&
     & 2.142520E-02,4.197840E-04,4.525280E-03,3.508570E-02,1.893070E-01,&
     & 4.290920E-01,7.276020E-01,1.912330E+00,4.776750E+00,6.891160E+00,&
     & 9.205390E-01,2.186470E-01,1.915220E-01,2.160960E-01,8.563620E-02,&
     & 4.885030E-02,2.142520E-02,8.069640E-04,6.395950E-03,4.071870E-02,&
     & 2.014070E-01,4.268090E-01,7.369990E-01,1.934890E+00,4.758660E+00,&
     & 6.792660E+00,9.204390E-01,2.186150E-01,1.914330E-01,2.161760E-01,&
     & 8.587510E-02,4.870030E-02,2.142520E-02,2.022890E-03,9.208070E-03,&
     & 5.274960E-02,2.166730E-01,4.296530E-01,7.526720E-01,1.974890E+00,&
     & 4.810890E+00,6.504300E+00,8.291580E-01,2.186070E-01,1.914420E-01,&
     & 2.161290E-01,8.576040E-02,4.898210E-02,2.141830E-02,1.117230E-03,&
     & 5.766930E-03,2.064630E-02,5.463080E-02,1.086120E-01,2.079860E-01,&
     & 4.358920E-01,9.921590E-01,5.319200E+00,1.742850E+01,2.443680E+01,&
     & 3.513520E+01,5.104460E+01,8.846580E+01,4.931830E+01,6.203690E-07/
      data  kb_mn2o(:,:,13:14) /                                        &
     & 1.010150E-05,2.256650E-03,2.905440E-02,1.820780E-01,4.395360E-01,&
     & 7.270850E-01,1.915560E+00,4.835590E+00,6.843910E+00,9.090540E-01,&
     & 2.232120E-01,1.944620E-01,2.175390E-01,9.476880E-02,5.431240E-02,&
     & 2.279700E-02,5.757530E-04,5.328780E-03,3.804510E-02,1.955940E-01,&
     & 4.318960E-01,7.302730E-01,1.919780E+00,4.808260E+00,6.806690E+00,&
     & 9.093990E-01,2.232210E-01,1.946240E-01,2.174490E-01,9.453950E-02,&
     & 5.431240E-02,2.279700E-02,1.015400E-03,7.347200E-03,4.378840E-02,&
     & 2.075940E-01,4.292830E-01,7.396790E-01,1.942850E+00,4.789580E+00,&
     & 6.707970E+00,9.093000E-01,2.231820E-01,1.945350E-01,2.175290E-01,&
     & 9.484100E-02,5.413570E-02,2.279700E-02,2.389740E-03,1.039610E-02,&
     & 5.585310E-02,2.229800E-01,4.313460E-01,7.554990E-01,1.983410E+00,&
     & 4.842710E+00,6.417710E+00,8.204850E-01,2.231810E-01,1.945380E-01,&
     & 2.174770E-01,9.471140E-02,5.446620E-02,2.278880E-02,1.344290E-03,&
     & 6.559380E-03,2.230380E-02,5.613910E-02,1.108770E-01,2.111810E-01,&
     & 4.464310E-01,1.002740E+00,5.343110E+00,1.750790E+01,2.455330E+01,&
     & 3.537780E+01,5.083440E+01,8.659960E+01,4.780550E+01,7.869250E-07,&
     & 1.516290E-05,2.768030E-03,3.211100E-02,1.886910E-01,4.432090E-01,&
     & 7.295040E-01,1.922880E+00,4.867510E+00,6.760540E+00,8.980110E-01,&
     & 2.278670E-01,1.976220E-01,2.189000E-01,1.046630E-01,6.038540E-02,&
     & 2.425650E-02,7.896710E-04,6.274950E-03,4.125400E-02,2.020890E-01,&
     & 4.347190E-01,7.329540E-01,1.927260E+00,4.839980E+00,6.723260E+00,&
     & 8.983940E-01,2.278900E-01,1.977760E-01,2.188100E-01,1.043680E-01,&
     & 6.038540E-02,2.425650E-02,1.277680E-03,8.439920E-03,4.708960E-02,&
     & 2.139720E-01,4.317700E-01,7.423690E-01,1.950840E+00,4.820710E+00,&
     & 6.624320E+00,8.982950E-01,2.278450E-01,1.976870E-01,2.188900E-01,&
     & 1.047430E-01,6.017770E-02,2.425650E-02,2.823110E-03,1.173740E-02,&
     & 5.913930E-02,2.294710E-01,4.330470E-01,7.583360E-01,1.991970E+00,&
     & 4.874740E+00,6.332270E+00,8.119020E-01,2.278520E-01,1.976840E-01,&
     & 2.188330E-01,1.045970E-01,6.056430E-02,2.424700E-02,1.617500E-03,&
     & 7.460730E-03,2.409440E-02,5.768900E-02,1.131880E-01,2.144250E-01,&
     & 4.572250E-01,1.013440E+00,5.367120E+00,1.758770E+01,2.467050E+01,&
     & 3.562200E+01,5.062500E+01,8.477280E+01,4.633900E+01,9.981990E-07/
      data  kb_mn2o(:,:,15:16) /                                        &
     & 2.276040E-05,3.395300E-03,3.548910E-02,1.955430E-01,4.469130E-01,&
     & 7.319310E-01,1.930230E+00,4.899650E+00,6.678190E+00,8.871020E-01,&
     & 2.326200E-01,2.008320E-01,2.202700E-01,1.155910E-01,6.713730E-02,&
     & 2.580960E-02,1.083070E-03,7.389110E-03,4.473360E-02,2.088000E-01,&
     & 4.375590E-01,7.356440E-01,1.934760E+00,4.871910E+00,6.640850E+00,&
     & 8.875220E-01,2.326580E-01,2.009790E-01,2.201810E-01,1.152190E-01,&
     & 6.713730E-02,2.580960E-02,1.607700E-03,9.695160E-03,5.063960E-02,&
     & 2.205460E-01,4.342720E-01,7.450680E-01,1.958860E+00,4.852040E+00,&
     & 6.541720E+00,8.874230E-01,2.326050E-01,2.008910E-01,2.202600E-01,&
     & 1.156790E-01,6.689400E-02,2.580960E-02,3.335080E-03,1.325170E-02,&
     & 6.261870E-02,2.361510E-01,4.347540E-01,7.611840E-01,2.000560E+00,&
     & 4.906980E+00,6.247970E+00,8.034090E-01,2.326190E-01,2.008810E-01,&
     & 2.201980E-01,1.155140E-01,6.734520E-02,2.579860E-02,1.946230E-03,&
     & 8.485940E-03,2.602870E-02,5.928170E-02,1.155480E-01,2.177190E-01,&
     & 4.682800E-01,1.024260E+00,5.391240E+00,1.766780E+01,2.478810E+01,&
     & 3.586790E+01,5.041650E+01,8.298450E+01,4.491750E+01,1.266190E-06,&
     & 3.416460E-05,4.164720E-03,3.922270E-02,2.026450E-01,4.506490E-01,&
     & 7.343660E-01,1.937610E+00,4.932000E+00,6.596840E+00,8.763260E-01,&
     & 2.374710E-01,2.040950E-01,2.216490E-01,1.276590E-01,7.464430E-02,&
     & 2.746200E-02,1.485480E-03,8.701110E-03,4.850670E-02,2.157340E-01,&
     & 4.404190E-01,7.383450E-01,1.942300E+00,4.904050E+00,6.559450E+00,&
     & 8.767820E-01,2.375250E-01,2.042340E-01,2.215590E-01,1.271980E-01,&
     & 7.464430E-02,2.746200E-02,2.022960E-03,1.113710E-02,5.445730E-02,&
     & 2.273210E-01,4.367880E-01,7.477780E-01,1.966920E+00,4.883570E+00,&
     & 6.460150E+00,8.766830E-01,2.374640E-01,2.041460E-01,2.216390E-01,&
     & 1.277570E-01,7.436000E-02,2.746200E-02,3.939890E-03,1.496150E-02,&
     & 6.630300E-02,2.430250E-01,4.364680E-01,7.640430E-01,2.009200E+00,&
     & 4.939440E+00,6.164790E+00,7.950050E-01,2.374870E-01,2.041290E-01,&
     & 2.215710E-01,1.275700E-01,7.488530E-02,2.744940E-02,2.341770E-03,&
     & 9.652020E-03,2.811830E-02,6.091840E-02,1.179570E-01,2.210630E-01,&
     & 4.796030E-01,1.035180E+00,5.415470E+00,1.774830E+01,2.490640E+01,&
     & 3.611560E+01,5.020890E+01,8.123390E+01,4.353960E+01,1.606140E-06/
      data  kb_mn2o(:,:,17:18) /                                        &
     & 5.128310E-05,5.108490E-03,4.334910E-02,2.100040E-01,4.544150E-01,&
     & 7.368090E-01,1.945020E+00,4.964560E+00,6.516480E+00,8.656810E-01,&
     & 2.424240E-01,2.074110E-01,2.230360E-01,1.409880E-01,8.299060E-02,&
     & 2.922030E-02,2.037400E-03,1.024610E-02,5.259800E-02,2.228980E-01,&
     & 4.432960E-01,7.410550E-01,1.949860E+00,4.936400E+00,6.479040E+00,&
     & 8.661710E-01,2.424940E-01,2.075420E-01,2.229460E-01,1.404220E-01,&
     & 8.299060E-02,2.922030E-02,2.545490E-03,1.279350E-02,5.856280E-02,&
     & 2.343050E-01,4.393190E-01,7.504970E-01,1.975010E+00,4.915310E+00,&
     & 6.379600E+00,8.660730E-01,2.424250E-01,2.074540E-01,2.230260E-01,&
     & 1.410950E-01,8.265930E-02,2.922030E-02,4.654390E-03,1.689180E-02,&
     & 7.020390E-02,2.501000E-01,4.381880E-01,7.669120E-01,2.017870E+00,&
     & 4.972110E+00,6.082720E+00,7.866890E-01,2.424560E-01,2.074300E-01,&
     & 2.229520E-01,1.408850E-01,8.326960E-02,2.920580E-02,2.817700E-03,&
     & 1.097830E-02,3.037570E-02,6.260030E-02,1.204170E-01,2.244590E-01,&
     & 4.911990E-01,1.046230E+00,5.439810E+00,1.782910E+01,2.502520E+01,&
     & 3.636490E+01,5.000210E+01,7.952030E+01,4.220400E+01,2.037360E-06,&
     & 7.697870E-05,6.266130E-03,4.790950E-02,2.176310E-01,4.582130E-01,&
     & 7.392610E-01,1.952450E+00,4.997330E+00,6.437100E+00,8.551650E-01,&
     & 2.474790E-01,2.107800E-01,2.244320E-01,1.557080E-01,9.227010E-02,&
     & 3.109110E-02,2.794390E-03,1.206530E-02,5.703440E-02,2.303000E-01,&
     & 4.461930E-01,7.437750E-01,1.957460E+00,4.968960E+00,6.399630E+00,&
     & 8.556900E-01,2.475670E-01,2.109030E-01,2.243420E-01,1.550210E-01,&
     & 9.227010E-02,3.109110E-02,3.202980E-03,1.469620E-02,6.297770E-02,&
     & 2.415030E-01,4.418650E-01,7.532260E-01,1.983130E+00,4.947250E+00,&
     & 6.300050E+00,8.555910E-01,2.474900E-01,2.108160E-01,2.244220E-01,&
     & 1.558270E-01,9.188470E-02,3.109110E-02,5.498450E-03,1.907120E-02,&
     & 7.433440E-02,2.573800E-01,4.399160E-01,7.697920E-01,2.026570E+00,&
     & 5.005000E+00,6.001740E+00,7.784600E-01,2.475290E-01,2.107840E-01,&
     & 2.243430E-01,1.555890E-01,9.259270E-02,3.107460E-02,3.390350E-03,&
     & 1.248690E-02,3.281420E-02,6.432860E-02,1.229270E-01,2.279070E-01,&
     & 5.030750E-01,1.057390E+00,5.464260E+00,1.791030E+01,2.514460E+01,&
     & 3.661590E+01,4.979610E+01,7.784280E+01,4.090940E+01,2.584350E-06/
      data  kb_mn2o(:,:,19) /                                           &
     & 1.155490E-04,7.686110E-03,5.294970E-02,2.255340E-01,4.620430E-01,&
     & 7.417200E-01,1.959910E+00,5.030330E+00,6.358690E+00,8.447770E-01,&
     & 2.526410E-01,2.142050E-01,2.258370E-01,1.719650E-01,1.025870E-01,&
     & 3.308170E-02,3.832620E-03,1.420760E-02,6.184500E-02,2.379470E-01,&
     & 4.491090E-01,7.465060E-01,1.965080E+00,5.001740E+00,6.321180E+00,&
     & 8.453350E-01,2.527460E-01,2.143190E-01,2.257470E-01,1.711380E-01,&
     & 1.025870E-01,3.308170E-02,4.030310E-03,1.688190E-02,6.772560E-02,&
     & 2.489220E-01,4.444260E-01,7.559650E-01,1.991290E+00,4.979410E+00,&
     & 6.221500E+00,8.452360E-01,2.526610E-01,2.142320E-01,2.258270E-01,&
     & 1.720960E-01,1.021400E-01,3.308170E-02,6.495580E-03,2.153180E-02,&
     & 7.870790E-02,2.648720E-01,4.416500E-01,7.726830E-01,2.035320E+00,&
     & 5.038100E+00,5.921840E+00,7.703160E-01,2.527090E-01,2.141920E-01,&
     & 2.257410E-01,1.718290E-01,1.029590E-01,3.306300E-02,4.079390E-03,&
     & 1.420280E-02,3.544860E-02,6.610470E-02,1.254900E-01,2.314080E-01,&
     & 5.152390E-01,1.068670E+00,5.488820E+00,1.799190E+01,2.526450E+01,&
     & 3.686870E+01,4.959100E+01,7.620070E+01,3.965440E+01,3.278190E-06/

! --- the array selfref contains the coefficient of the water vapor
!     self-continuum (including the energy term).  the first index
!     refers to temperature in 7.2 degree increments.  for instance,
!     jt = 1 refers to a temperature of 245.6, jt = 2 refers to 252.8,
!     etc.  the second index runs over the g-channel (1 to NG03=16).

      data  selfref(:, :) /                                             &
     & 5.119260E-01,5.028630E-01,4.576280E-01,4.286340E-01,4.210020E-01,&
     & 3.975170E-01,3.921140E-01,3.795550E-01,3.926440E-01,4.065420E-01,&
     & 4.096720E-01,3.851400E-01,4.873490E-01,5.643390E-01,5.911230E-01,&
     & 5.045900E-01,4.328630E-01,4.350080E-01,3.996630E-01,3.817360E-01,&
     & 3.774930E-01,3.611670E-01,3.575540E-01,3.472640E-01,3.580480E-01,&
     & 3.712000E-01,3.762370E-01,3.619890E-01,4.421920E-01,5.061940E-01,&
     & 5.264200E-01,4.652350E-01,3.660100E-01,3.763100E-01,3.490400E-01,&
     & 3.399700E-01,3.384800E-01,3.281400E-01,3.260400E-01,3.177200E-01,&
     & 3.265000E-01,3.389300E-01,3.455300E-01,3.402300E-01,4.012200E-01,&
     & 4.540400E-01,4.688000E-01,4.289500E-01,3.094820E-01,3.255320E-01,&
     & 3.048290E-01,3.027730E-01,3.034990E-01,2.981330E-01,2.973040E-01,&
     & 2.906900E-01,2.977320E-01,3.094650E-01,3.173290E-01,3.197790E-01,&
     & 3.640440E-01,4.072590E-01,4.174860E-01,3.954950E-01,2.616850E-01,&
     & 2.816060E-01,2.662180E-01,2.696470E-01,2.721330E-01,2.708710E-01,&
     & 2.711000E-01,2.659590E-01,2.714980E-01,2.825620E-01,2.914300E-01,&
     & 3.005570E-01,3.303130E-01,3.652980E-01,3.717900E-01,3.646490E-01,&
     & 2.212690E-01,2.436070E-01,2.324980E-01,2.401440E-01,2.440090E-01,&
     & 2.461010E-01,2.472060E-01,2.433320E-01,2.475760E-01,2.579980E-01,&
     & 2.676450E-01,2.824900E-01,2.997070E-01,3.276610E-01,3.310950E-01,&
     & 3.362090E-01,1.870960E-01,2.107360E-01,2.030490E-01,2.138700E-01,&
     & 2.187920E-01,2.235970E-01,2.254180E-01,2.226310E-01,2.257620E-01,&
     & 2.355690E-01,2.458010E-01,2.655100E-01,2.719370E-01,2.939010E-01,&
     & 2.948540E-01,3.099870E-01,1.582000E-01,1.823000E-01,1.773300E-01,&
     & 1.904700E-01,1.961800E-01,2.031500E-01,2.055500E-01,2.036900E-01,&
     & 2.058700E-01,2.150900E-01,2.257400E-01,2.495500E-01,2.467400E-01,&
     & 2.636200E-01,2.625800E-01,2.858100E-01,1.337670E-01,1.577010E-01,&
     & 1.548690E-01,1.696300E-01,1.759050E-01,1.845730E-01,1.874330E-01,&
     & 1.863610E-01,1.877310E-01,1.963910E-01,2.073160E-01,2.345490E-01,&
     & 2.238780E-01,2.364590E-01,2.338390E-01,2.635190E-01,1.131080E-01,&
     & 1.364220E-01,1.352520E-01,1.510710E-01,1.577260E-01,1.676950E-01,&
     & 1.709130E-01,1.705060E-01,1.711900E-01,1.793180E-01,1.903960E-01,&
     & 2.204510E-01,2.031340E-01,2.120960E-01,2.082430E-01,2.429660E-01/

! --- the array forref contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  the first
!     index refers to reference temperature (296,260,224,260) and
!     pressure (970,475,219,3 mbar) levels.  the second index
!     runs over the g-channel (1 to NG03=16).

      data  forref(:, :) /                                              &
     & 9.003900E-04,1.108100E-03,1.073200E-03,1.188100E-03,1.248800E-03,&
     & 1.317000E-03,1.331700E-03,1.316800E-03,1.336900E-03,1.422800E-03,&
     & 1.538500E-03,1.737600E-03,1.712200E-03,1.900200E-03,1.888100E-03,&
     & 2.159500E-03,1.272600E-03,1.368000E-03,1.249400E-03,1.204900E-03,&
     & 1.204800E-03,1.125600E-03,1.117000E-03,1.069700E-03,1.117700E-03,&
     & 1.188300E-03,1.221900E-03,1.217900E-03,1.569200E-03,1.910300E-03,&
     & 2.021900E-03,1.693700E-03,1.552700E-03,1.647700E-03,1.497300E-03,&
     & 1.340000E-03,1.082000E-03,9.331500E-04,8.813200E-04,8.150800E-04,&
     & 8.355900E-04,7.649200E-04,8.234300E-04,7.127400E-04,6.601100E-04,&
     & 6.717900E-04,6.703900E-04,6.702100E-04,1.676300E-03,1.606600E-03,&
     & 1.392700E-03,1.208700E-03,9.846300E-04,8.841400E-04,8.097600E-04,&
     & 7.875800E-04,7.737600E-04,7.578500E-04,7.415200E-04,7.381400E-04,&
     & 7.427800E-04,7.174500E-04,6.721600E-04,6.409700E-04 /

! --- planck fraction mapping level: p=212.7250 mbar, t = 223.06 k

      data  fracrefa(:,:) /                                             &
     & 1.625100e-01,1.557200e-01,1.455700e-01,1.320800e-01,1.158200e-01,&
     & 9.689500e-02,7.872000e-02,5.846200e-02,3.963100e-02,4.300100e-03,&
     & 3.555500e-03,2.810100e-03,2.054700e-03,1.310900e-03,4.940300e-04,&
     & 6.951500e-05,1.600600e-01,1.557600e-01,1.460900e-01,1.327600e-01,&
     & 1.159400e-01,9.733600e-02,7.903500e-02,5.869600e-02,3.972300e-02,&
     & 4.300100e-03,3.555500e-03,2.810100e-03,2.054700e-03,1.310900e-03,&
     & 4.940300e-04,6.951500e-05,1.595200e-01,1.556600e-01,1.459000e-01,&
     & 1.329400e-01,1.159900e-01,9.751100e-02,7.912700e-02,5.888800e-02,&
     & 3.987400e-02,4.300100e-03,3.555500e-03,2.810200e-03,2.054700e-03,&
     & 1.310900e-03,4.940300e-04,6.951500e-05,1.590700e-01,1.554100e-01,&
     & 1.458500e-01,1.331600e-01,1.159600e-01,9.764700e-02,7.924300e-02,&
     & 5.902400e-02,4.002800e-02,4.311200e-03,3.555500e-03,2.810200e-03,&
     & 2.054700e-03,1.310900e-03,4.940300e-04,6.951500e-05,1.586200e-01,&
     & 1.551700e-01,1.458800e-01,1.332800e-01,1.158500e-01,9.784000e-02,&
     & 7.936400e-02,5.917400e-02,4.016000e-02,4.340300e-03,3.590000e-03,&
     & 2.810200e-03,2.054700e-03,1.310900e-03,4.940300e-04,6.951500e-05,&
     & 1.583000e-01,1.549000e-01,1.458200e-01,1.333100e-01,1.156700e-01,&
     & 9.807900e-02,7.951000e-02,5.936900e-02,4.032600e-02,4.334300e-03,&
     & 3.590800e-03,2.852700e-03,2.065500e-03,1.310900e-03,4.940300e-04,&
     & 6.951500e-05,1.578900e-01,1.543500e-01,1.459500e-01,1.330400e-01,&
     & 1.156600e-01,9.842600e-02,7.970400e-02,5.961800e-02,4.052000e-02,&
     & 4.381200e-03,3.614700e-03,2.839500e-03,2.130100e-03,1.314500e-03,&
     & 4.940300e-04,6.951500e-05,1.570400e-01,1.539800e-01,1.456400e-01,&
     & 1.322200e-01,1.158600e-01,9.923000e-02,8.001100e-02,6.014900e-02,&
     & 4.079000e-02,4.425300e-03,3.653400e-03,2.919100e-03,2.137300e-03,&
     & 1.355800e-03,5.163100e-04,7.879400e-05,1.527000e-01,1.512600e-01,&
     & 1.426400e-01,1.310600e-01,1.174000e-01,1.013700e-01,8.305700e-02,&
     & 6.228200e-02,4.230100e-02,4.648600e-03,3.815900e-03,3.047200e-03,&
     & 2.287000e-03,1.481800e-03,5.677300e-04,7.879400e-05 /

! --- planck fraction mapping level: p = 95.8 mbar, t = 215.7 k

      data  fracrefb(:,:) /                                             &
     & 1.641300e-01,1.566500e-01,1.460600e-01,1.318400e-01,1.151700e-01,&
     & 9.624300e-02,7.798200e-02,5.816500e-02,3.931100e-02,4.258600e-03,&
     & 3.518900e-03,2.779300e-03,2.037600e-03,1.293800e-03,4.885300e-04,&
     & 6.874500e-05,1.625400e-01,1.567400e-01,1.465200e-01,1.322100e-01,&
     & 1.153500e-01,9.643900e-02,7.815500e-02,5.825400e-02,3.934300e-02,&
     & 4.258600e-03,3.518900e-03,2.779300e-03,2.037600e-03,1.293800e-03,&
     & 4.885300e-04,6.874500e-05,1.617700e-01,1.566400e-01,1.466900e-01,&
     & 1.324200e-01,1.154100e-01,9.653600e-02,7.825700e-02,5.838700e-02,&
     & 3.943100e-02,4.258700e-03,3.518900e-03,2.779300e-03,2.037600e-03,&
     & 1.293800e-03,4.885300e-04,6.874500e-05,1.607700e-01,1.567900e-01,&
     & 1.464800e-01,1.327300e-01,1.154600e-01,9.677900e-02,7.837100e-02,&
     & 5.854600e-02,3.961100e-02,4.277200e-03,3.519000e-03,2.779300e-03,&
     & 2.037600e-03,1.293800e-03,4.885300e-04,6.874500e-05,1.606700e-01,&
     & 1.560800e-01,1.424700e-01,1.288100e-01,1.144900e-01,9.880200e-02,&
     & 8.082800e-02,6.097700e-02,4.149400e-02,4.511600e-03,3.729000e-03,&
     & 2.946000e-03,2.194800e-03,1.377800e-03,5.455200e-04,7.996900e-05/

!........................................!
      end module module_radlw_kgb03      !
!========================================!


!========================================!
      module module_radlw_kgb04          !
!........................................!
!
      use physparam,               only : kind_phys
      use module_radlw_parameters, only : NG04
!
      implicit none
!
      private
!
      integer, public :: MSA04, MSB04, MSF04, MFR04, MAF04, MBF04
      parameter (MSA04=585, MSB04=1175, MSF04=10, MFR04=4)
      parameter (MAF04=9, MBF04=5)

      real (kind=kind_phys), public ::           forref(NG04,MFR04),    &
     &       absa(NG04,MSA04), absb(NG04,MSB04), selfref(NG04,MSF04),   &
     &       fracrefa(NG04,MAF04), fracrefb(NG04,MBF04)

! --- the array absa(NG04,585) = ka(NG04,9,5,13) contains absorption coefs
!     at the NG04=14 g-intervals for a range of pressure levels > ~100mb,
!     temperatures, and ratios of water vapor to co2.  the first index in
!     the array, js, runs from 1 to 9, and corresponds to different gas
!     column amount ratios, as expressed through the binary species
!     parameter eta, defined as eta = gas1/(gas1+(rat)*gas2), where rat is
!     the ratio of the reference mls column amount value of gas1 to that
!     of gas2. the 2nd index in the array, jt, which runs from 1 to 5,
!     corresponds to different temperatures. more specifically, jt = 1-5
!     means that the data are for the corresponding temperature of
!     tref-30, tref-15, tref, tref+15, and tref+30, respectively. the
!     third index, jp, runs from 1 to 13 and refers to the reference
!     pressure level (e.g. jp = 1 is for a pressure of 1053.63 mb).  the
!     fourth index, ig, goes from 1 to NG04=14, and tells us which
!     g-interval the absorption coefficients are for.

      data   absa(:,  1: 20) /                                          &
     & 1.069700E-02,2.450100E-02,3.756400E-02,5.205700E-02,8.290100E-02,&
     & 1.366400E-01,2.641200E-01,5.202200E-01,1.037000E+00,3.027700E+00,&
     & 5.028400E+00,7.284900E+00,9.244100E+00,1.070513E+01,1.015100E-02,&
     & 2.254600E-02,3.349200E-02,4.619100E-02,7.392400E-02,1.214200E-01,&
     & 2.320900E-01,4.563500E-01,9.085700E-01,2.649500E+00,4.399700E+00,&
     & 6.374500E+00,8.089300E+00,9.368710E+00,9.254900E-03,2.020600E-02,&
     & 2.938500E-02,4.079100E-02,6.465700E-02,1.060400E-01,2.013600E-01,&
     & 3.925200E-01,7.802300E-01,2.271600E+00,3.771300E+00,5.464300E+00,&
     & 6.933400E+00,8.029690E+00,8.264500E-03,1.758000E-02,2.506400E-02,&
     & 3.526400E-02,5.559700E-02,9.067300E-02,1.704100E-01,3.301000E-01,&
     & 6.519200E-01,1.893300E+00,3.143300E+00,4.553700E+00,5.778200E+00,&
     & 6.691806E+00,7.206100E-03,1.473300E-02,2.067900E-02,2.938600E-02,&
     & 4.647200E-02,7.530700E-02,1.398700E-01,2.682300E-01,5.245700E-01,&
     & 1.515300E+00,2.514800E+00,3.643100E+00,4.622800E+00,5.353926E+00,&
     & 6.066200E-03,1.175700E-02,1.615900E-02,2.331100E-02,3.679600E-02,&
     & 5.995100E-02,1.099700E-01,2.056700E-01,4.002500E-01,1.137200E+00,&
     & 1.886700E+00,2.732600E+00,3.467200E+00,4.015527E+00,4.981600E-03,&
     & 8.587100E-03,1.150200E-02,1.693300E-02,2.670900E-02,4.404900E-02,&
     & 7.997700E-02,1.445200E-01,2.782800E-01,7.595100E-01,1.258500E+00,&
     & 1.822300E+00,2.311900E+00,2.677617E+00,4.886700E-03,4.971500E-03,&
     & 6.536700E-03,9.974100E-03,1.594800E-02,2.703700E-02,4.829400E-02,&
     & 8.486500E-02,1.580400E-01,4.243100E-01,6.303400E-01,9.119000E-01,&
     & 1.156700E+00,1.339909E+00,2.026900E-04,4.135800E-04,3.979400E-04,&
     & 9.474200E-04,1.780200E-03,3.420000E-03,7.140600E-03,1.839600E-02,&
     & 5.889700E-02,1.165300E-01,1.332400E-01,1.609100E-01,2.285500E-01,&
     & 5.348145E-01,1.167700E-02,2.539200E-02,3.691600E-02,5.179900E-02,&
     & 8.337000E-02,1.347900E-01,2.611400E-01,5.217700E-01,1.049200E+00,&
     & 3.087700E+00,5.042800E+00,7.153000E+00,8.862300E+00,1.017422E+01,&
     & 1.113800E-02,2.350400E-02,3.315100E-02,4.637000E-02,7.461800E-02,&
     & 1.204100E-01,2.304100E-01,4.578900E-01,9.196200E-01,2.702100E+00,&
     & 4.412200E+00,6.258800E+00,7.755200E+00,8.903187E+00,1.021600E-02,&
     & 2.106100E-02,2.916000E-02,4.142400E-02,6.569800E-02,1.058100E-01,&
     & 2.008400E-01,3.947400E-01,7.901400E-01,2.316700E+00,3.782200E+00,&
     & 5.364800E+00,6.647300E+00,7.631481E+00,9.190900E-03,1.828200E-02,&
     & 2.501800E-02,3.594200E-02,5.701900E-02,9.111400E-02,1.714100E-01,&
     & 3.334200E-01,6.610100E-01,1.931100E+00,3.152100E+00,4.470900E+00,&
     & 5.539700E+00,6.359651E+00,8.055300E-03,1.534000E-02,2.075100E-02,&
     & 3.015100E-02,4.781200E-02,7.666900E-02,1.425300E-01,2.711400E-01,&
     & 5.353500E-01,1.545400E+00,2.522300E+00,3.577000E+00,4.432000E+00,&
     & 5.088102E+00,6.822300E-03,1.223800E-02,1.638900E-02,2.409000E-02,&
     & 3.797800E-02,6.185100E-02,1.137000E-01,2.103100E-01,4.121900E-01,&
     & 1.159900E+00,1.892100E+00,2.683000E+00,3.324500E+00,3.816530E+00,&
     & 5.540800E-03,8.892100E-03,1.190100E-02,1.782700E-02,2.785500E-02,&
     & 4.600900E-02,8.442600E-02,1.510400E-01,2.906400E-01,7.948000E-01,&
     & 1.262000E+00,1.789100E+00,2.216800E+00,2.544906E+00,4.685400E-03,&
     & 5.111400E-03,7.267800E-03,1.113800E-02,1.714600E-02,2.915100E-02,&
     & 5.229200E-02,9.217400E-02,1.738100E-01,4.615800E-01,6.604000E-01,&
     & 8.954800E-01,1.109100E+00,1.273286E+00,2.382500E-04,3.896600E-04,&
     & 5.468600E-04,1.164300E-03,2.393500E-03,4.424400E-03,9.233900E-03,&
     & 2.377400E-02,7.641400E-02,1.513300E-01,1.716000E-01,2.242100E-01,&
     & 3.233500E-01,7.312700E-01,1.260500E-02,2.602700E-02,3.639900E-02,&
     & 5.177400E-02,8.423500E-02,1.331300E-01,2.574600E-01,5.224600E-01,&
     & 1.061700E+00,3.144300E+00,5.045000E+00,7.015800E+00,8.483300E+00,&
     & 9.647580E+00,1.209200E-02,2.422100E-02,3.290300E-02,4.687500E-02,&
     & 7.573000E-02,1.195600E-01,2.284600E-01,4.586300E-01,9.310200E-01,&
     & 2.751400E+00,4.414800E+00,6.138900E+00,7.423300E+00,8.442497E+00/
      data   absa(:, 21: 40) /                                          &
     & 1.117900E-02,2.167300E-02,2.903100E-02,4.224000E-02,6.725700E-02,&
     & 1.056100E-01,2.004300E-01,3.970800E-01,8.003200E-01,2.358900E+00,&
     & 3.784100E+00,5.262400E+00,6.362500E+00,7.236163E+00,1.012100E-02,&
     & 1.883000E-02,2.501200E-02,3.682500E-02,5.866700E-02,9.188700E-02,&
     & 1.729400E-01,3.360400E-01,6.720000E-01,1.966500E+00,3.154000E+00,&
     & 4.385300E+00,5.302600E+00,6.030346E+00,8.915900E-03,1.580700E-02,&
     & 2.090000E-02,3.110500E-02,4.922900E-02,7.823700E-02,1.455800E-01,&
     & 2.754100E-01,5.476100E-01,1.573800E+00,2.523400E+00,3.508900E+00,&
     & 4.242300E+00,4.824746E+00,7.602700E-03,1.252500E-02,1.671800E-02,&
     & 2.510100E-02,3.929800E-02,6.377100E-02,1.177400E-01,2.169200E-01,&
     & 4.262000E-01,1.183900E+00,1.893000E+00,2.631700E+00,3.182500E+00,&
     & 3.619038E+00,6.039200E-03,9.166800E-03,1.238900E-02,1.896700E-02,&
     & 2.896600E-02,4.810900E-02,8.868600E-02,1.587600E-01,3.067400E-01,&
     & 8.493600E-01,1.262900E+00,1.755100E+00,2.121900E+00,2.413347E+00,&
     & 4.349800E-03,5.599700E-03,8.080100E-03,1.218900E-02,1.833400E-02,&
     & 3.160400E-02,5.616100E-02,9.996100E-02,1.953800E-01,4.888300E-01,&
     & 7.055300E-01,9.020400E-01,1.061800E+00,1.207797E+00,2.824500E-04,&
     & 3.771100E-04,7.422000E-04,1.446700E-03,3.038200E-03,5.564400E-03,&
     & 1.160700E-02,3.015600E-02,9.670100E-02,1.896300E-01,2.203300E-01,&
     & 3.051300E-01,4.436700E-01,9.663896E-01,1.348400E-02,2.667300E-02,&
     & 3.612600E-02,5.204900E-02,8.517600E-02,1.319500E-01,2.532900E-01,&
     & 5.222200E-01,1.071500E+00,3.190200E+00,5.031400E+00,6.875200E+00,&
     & 8.121500E+00,9.161989E+00,1.304600E-02,2.491900E-02,3.278200E-02,&
     & 4.782200E-02,7.701900E-02,1.190400E-01,2.264100E-01,4.590400E-01,&
     & 9.398000E-01,2.792100E+00,4.402700E+00,6.015800E+00,7.106500E+00,&
     & 8.016419E+00,1.215300E-02,2.228200E-02,2.904700E-02,4.328600E-02,&
     & 6.897200E-02,1.058300E-01,2.004600E-01,3.993600E-01,8.085000E-01,&
     & 2.393500E+00,3.774100E+00,5.156800E+00,6.091700E+00,6.872440E+00,&
     & 1.104100E-02,1.934900E-02,2.519800E-02,3.796200E-02,6.028700E-02,&
     & 9.321200E-02,1.746500E-01,3.391800E-01,6.826400E-01,1.995200E+00,&
     & 3.145400E+00,4.297500E+00,5.076100E+00,5.727119E+00,9.780600E-03,&
     & 1.613900E-02,2.127900E-02,3.233600E-02,5.068000E-02,7.988900E-02,&
     & 1.486800E-01,2.814500E-01,5.604300E-01,1.597100E+00,2.516600E+00,&
     & 3.438600E+00,4.061400E+00,4.582042E+00,8.292100E-03,1.283500E-02,&
     & 1.715200E-02,2.650500E-02,4.061200E-02,6.565200E-02,1.220200E-01,&
     & 2.239600E-01,4.420500E-01,1.226800E+00,1.887900E+00,2.579200E+00,&
     & 3.046800E+00,3.436844E+00,6.502300E-03,9.424700E-03,1.304500E-02,&
     & 2.016300E-02,3.027100E-02,5.031800E-02,9.293300E-02,1.678900E-01,&
     & 3.259200E-01,8.992700E-01,1.282800E+00,1.720000E+00,2.031600E+00,&
     & 2.291823E+00,4.302300E-03,5.914300E-03,8.948200E-03,1.317600E-02,&
     & 1.967900E-02,3.433400E-02,6.012900E-02,1.081500E-01,2.222900E-01,&
     & 5.142600E-01,7.298100E-01,9.205600E-01,1.064100E+00,1.164160E+00,&
     & 3.031800E-04,4.380700E-04,8.947800E-04,1.845700E-03,3.747800E-03,&
     & 6.809700E-03,1.425800E-02,3.763400E-02,1.194300E-01,2.388500E-01,&
     & 2.781900E-01,4.013000E-01,5.916700E-01,1.239462E+00,1.433000E-02,&
     & 2.719300E-02,3.599600E-02,5.243500E-02,8.623000E-02,1.310000E-01,&
     & 2.491400E-01,5.213000E-01,1.080100E+00,3.231100E+00,5.006100E+00,&
     & 6.731200E+00,7.767200E+00,8.690802E+00,1.399700E-02,2.544700E-02,&
     & 3.283300E-02,4.887700E-02,7.845000E-02,1.187100E-01,2.244900E-01,&
     & 4.596700E-01,9.475100E-01,2.827500E+00,4.380800E+00,5.889700E+00,&
     & 6.796400E+00,7.604279E+00,1.311400E-02,2.273300E-02,2.927000E-02,&
     & 4.444900E-02,7.070500E-02,1.064500E-01,2.008000E-01,4.013500E-01,&
     & 8.173300E-01,2.424200E+00,3.755000E+00,5.048600E+00,5.825800E+00,&
     & 6.517967E+00,1.194300E-02,1.971200E-02,2.559300E-02,3.928800E-02,&
     & 6.183200E-02,9.449100E-02,1.767000E-01,3.439300E-01,6.936800E-01,&
     & 2.020600E+00,3.129800E+00,4.207500E+00,4.854500E+00,5.431738E+00/
      data   absa(:, 41: 60) /                                          &
     & 1.055700E-02,1.646900E-02,2.171200E-02,3.389400E-02,5.206600E-02,&
     & 8.151000E-02,1.523400E-01,2.880700E-01,5.761300E-01,1.618200E+00,&
     & 2.504100E+00,3.366300E+00,3.884500E+00,4.346349E+00,8.856700E-03,&
     & 1.319000E-02,1.772300E-02,2.797100E-02,4.206500E-02,6.745500E-02,&
     & 1.263200E-01,2.322500E-01,4.607900E-01,1.284600E+00,1.878500E+00,&
     & 2.525100E+00,2.913700E+00,3.260216E+00,6.870900E-03,9.707800E-03,&
     & 1.381200E-02,2.135700E-02,3.163800E-02,5.264800E-02,9.746900E-02,&
     & 1.776000E-01,3.501400E-01,9.346800E-01,1.331100E+00,1.688600E+00,&
     & 1.943000E+00,2.174232E+00,4.357700E-03,6.274600E-03,9.724300E-03,&
     & 1.414200E-02,2.112700E-02,3.714200E-02,6.480300E-02,1.166900E-01,&
     & 2.531900E-01,5.547000E-01,7.451400E-01,9.131200E-01,1.044600E+00,&
     & 1.244338E+00,3.275100E-04,5.150000E-04,1.097500E-03,2.276500E-03,&
     & 4.534400E-03,8.179800E-03,1.719300E-02,4.634500E-02,1.448700E-01,&
     & 2.933700E-01,3.494500E-01,5.116300E-01,7.690100E-01,1.549592E+00,&
     & 1.383300E-02,3.193500E-02,4.954500E-02,6.928300E-02,1.131900E-01,&
     & 1.894800E-01,3.822600E-01,8.185200E-01,1.744200E+00,4.536200E+00,&
     & 7.710900E+00,1.138000E+01,1.469900E+01,1.735343E+01,1.280600E-02,&
     & 2.897100E-02,4.384000E-02,6.112400E-02,1.003200E-01,1.674500E-01,&
     & 3.353000E-01,7.174500E-01,1.527200E+00,3.969600E+00,6.747400E+00,&
     & 9.957100E+00,1.286300E+01,1.518477E+01,1.146500E-02,2.568900E-02,&
     & 3.827300E-02,5.331200E-02,8.714100E-02,1.451200E-01,2.894300E-01,&
     & 6.163300E-01,1.310200E+00,3.402700E+00,5.783900E+00,8.534900E+00,&
     & 1.102400E+01,1.301574E+01,1.002500E-02,2.213900E-02,3.247200E-02,&
     & 4.563700E-02,7.408600E-02,1.230000E-01,2.438400E-01,5.156400E-01,&
     & 1.093300E+00,2.835800E+00,4.820100E+00,7.112600E+00,9.187600E+00,&
     & 1.084678E+01,8.520800E-03,1.835700E-02,2.655800E-02,3.763900E-02,&
     & 6.119600E-02,1.009800E-01,1.978600E-01,4.164300E-01,8.764900E-01,&
     & 2.269200E+00,3.856400E+00,5.689600E+00,7.349900E+00,8.677265E+00,&
     & 6.958900E-03,1.439800E-02,2.051000E-02,2.944400E-02,4.790300E-02,&
     & 7.902100E-02,1.525900E-01,3.173200E-01,6.609100E-01,1.702500E+00,&
     & 2.892600E+00,4.268000E+00,5.512900E+00,6.508272E+00,5.333600E-03,&
     & 1.031400E-02,1.433200E-02,2.092600E-02,3.405300E-02,5.659500E-02,&
     & 1.081700E-01,2.178600E-01,4.490200E-01,1.135800E+00,1.928900E+00,&
     & 2.845600E+00,3.675800E+00,4.339616E+00,4.229400E-03,5.786000E-03,&
     & 7.799200E-03,1.198700E-02,1.947900E-02,3.306800E-02,6.316100E-02,&
     & 1.206700E-01,2.389100E-01,5.944600E-01,9.651600E-01,1.423400E+00,&
     & 1.838300E+00,2.170533E+00,1.441900E-04,2.770400E-04,3.076900E-04,&
     & 6.770800E-04,1.332400E-03,2.506400E-03,5.437200E-03,1.467500E-02,&
     & 5.236200E-02,1.145000E-01,1.353800E-01,1.602300E-01,2.190100E-01,&
     & 5.200328E-01,1.514400E-02,3.332200E-02,4.870900E-02,6.923000E-02,&
     & 1.144400E-01,1.871900E-01,3.776900E-01,8.199800E-01,1.761700E+00,&
     & 4.649000E+00,7.755300E+00,1.119000E+01,1.408100E+01,1.646973E+01,&
     & 1.406800E-02,3.038800E-02,4.335900E-02,6.136500E-02,1.017400E-01,&
     & 1.658200E-01,3.322600E-01,7.188600E-01,1.542700E+00,4.068100E+00,&
     & 6.785700E+00,9.791300E+00,1.232100E+01,1.441087E+01,1.264400E-02,&
     & 2.693500E-02,3.796900E-02,5.405200E-02,8.878300E-02,1.443900E-01,&
     & 2.879800E-01,6.178700E-01,1.323800E+00,3.487400E+00,5.816700E+00,&
     & 8.392600E+00,1.056100E+01,1.235226E+01,1.111900E-02,2.318000E-02,&
     & 3.230400E-02,4.652800E-02,7.601900E-02,1.231000E-01,2.432600E-01,&
     & 5.188300E-01,1.104900E+00,2.906800E+00,4.847300E+00,6.994400E+00,&
     & 8.801200E+00,1.029440E+01,9.520400E-03,1.919600E-02,2.651300E-02,&
     & 3.856900E-02,6.313500E-02,1.018600E-01,1.992300E-01,4.204700E-01,&
     & 8.868700E-01,2.325800E+00,3.878400E+00,5.595600E+00,7.041400E+00,&
     & 8.235245E+00,7.823600E-03,1.507600E-02,2.060300E-02,3.038200E-02,&
     & 4.950800E-02,8.066700E-02,1.558900E-01,3.210800E-01,6.727600E-01,&
     & 1.745000E+00,2.909100E+00,4.197100E+00,5.280900E+00,6.176740E+00/
      data   absa(:, 61: 80) /                                          &
     & 6.022000E-03,1.077800E-02,1.462600E-02,2.175800E-02,3.540300E-02,&
     & 5.842800E-02,1.126200E-01,2.236900E-01,4.618000E-01,1.165600E+00,&
     & 1.940000E+00,2.798300E+00,3.521100E+00,4.118464E+00,4.408600E-03,&
     & 6.019500E-03,8.405100E-03,1.293800E-02,2.048800E-02,3.491800E-02,&
     & 6.732900E-02,1.286700E-01,2.518800E-01,6.484700E-01,9.743400E-01,&
     & 1.399800E+00,1.761300E+00,2.060000E+00,1.735500E-04,2.793300E-04,&
     & 4.147600E-04,8.461800E-04,1.782700E-03,3.280500E-03,7.087000E-03,&
     & 1.912200E-02,6.869100E-02,1.491100E-01,1.789900E-01,2.109200E-01,&
     & 3.166500E-01,7.259171E-01,1.639700E-02,3.437200E-02,4.816500E-02,&
     & 6.947400E-02,1.160800E-01,1.855000E-01,3.718200E-01,8.216100E-01,&
     & 1.776800E+00,4.755900E+00,7.777700E+00,1.099400E+01,1.347000E+01,&
     & 1.560002E+01,1.529900E-02,3.148400E-02,4.312000E-02,6.206500E-02,&
     & 1.034900E-01,1.647500E-01,3.284200E-01,7.205100E-01,1.556300E+00,&
     & 4.161700E+00,6.806000E+00,9.619600E+00,1.178600E+01,1.365225E+01,&
     & 1.381900E-02,2.788800E-02,3.779500E-02,5.523500E-02,9.080200E-02,&
     & 1.441600E-01,2.855900E-01,6.206300E-01,1.335900E+00,3.567600E+00,&
     & 5.833200E+00,8.245100E+00,1.010200E+01,1.170080E+01,1.223000E-02,&
     & 2.396600E-02,3.224800E-02,4.769500E-02,7.832200E-02,1.235100E-01,&
     & 2.430400E-01,5.230500E-01,1.115500E+00,2.973500E+00,4.861700E+00,&
     & 6.871400E+00,8.417800E+00,9.750338E+00,1.052500E-02,1.986000E-02,&
     & 2.657000E-02,3.980300E-02,6.511800E-02,1.033000E-01,2.012300E-01,&
     & 4.241300E-01,8.993300E-01,2.379300E+00,3.889700E+00,5.497000E+00,&
     & 6.734500E+00,7.801162E+00,8.689400E-03,1.558500E-02,2.083800E-02,&
     & 3.150200E-02,5.119800E-02,8.246500E-02,1.595200E-01,3.266000E-01,&
     & 6.866600E-01,1.785100E+00,2.917800E+00,4.123300E+00,5.051200E+00,&
     & 5.851380E+00,6.732200E-03,1.107900E-02,1.497700E-02,2.292400E-02,&
     & 3.680100E-02,6.031400E-02,1.173400E-01,2.314500E-01,4.756800E-01,&
     & 1.217400E+00,1.945700E+00,2.749100E+00,3.367800E+00,3.901658E+00,&
     & 4.588300E-03,6.344800E-03,8.968500E-03,1.398900E-02,2.162300E-02,&
     & 3.696200E-02,7.151600E-02,1.378200E-01,2.692500E-01,6.901800E-01,&
     & 1.017500E+00,1.375300E+00,1.684700E+00,1.951428E+00,2.102200E-04,&
     & 2.711800E-04,5.683200E-04,1.072600E-03,2.278900E-03,4.149900E-03,&
     & 8.969300E-03,2.447300E-02,8.759900E-02,1.906600E-01,2.266200E-01,&
     & 2.824900E-01,4.414100E-01,9.757483E-01,1.760800E-02,3.524700E-02,&
     & 4.796200E-02,7.004100E-02,1.178600E-01,1.845100E-01,3.654500E-01,&
     & 8.214900E-01,1.790200E+00,4.849900E+00,7.775600E+00,1.078900E+01,&
     & 1.287100E+01,1.477490E+01,1.651800E-02,3.238200E-02,4.307700E-02,&
     & 6.326200E-02,1.054500E-01,1.646000E-01,3.242100E-01,7.207100E-01,&
     & 1.568300E+00,4.243800E+00,6.803900E+00,9.440400E+00,1.126300E+01,&
     & 1.292867E+01,1.501000E-02,2.865400E-02,3.784400E-02,5.663100E-02,&
     & 9.314700E-02,1.445400E-01,2.832400E-01,6.230100E-01,1.346700E+00,&
     & 3.637800E+00,5.832300E+00,8.091700E+00,9.654200E+00,1.108149E+01,&
     & 1.334900E-02,2.462700E-02,3.239300E-02,4.914000E-02,8.058700E-02,&
     & 1.248700E-01,2.431800E-01,5.258700E-01,1.127200E+00,3.032200E+00,&
     & 4.860200E+00,6.743100E+00,8.045200E+00,9.234900E+00,1.152400E-02,&
     & 2.040400E-02,2.687300E-02,4.124600E-02,6.704200E-02,1.051500E-01,&
     & 2.034300E-01,4.286500E-01,9.129200E-01,2.426300E+00,3.888500E+00,&
     & 5.395000E+00,6.436500E+00,7.388246E+00,9.566500E-03,1.594900E-02,&
     & 2.123800E-02,3.295400E-02,5.294300E-02,8.441900E-02,1.633700E-01,&
     & 3.340700E-01,7.021200E-01,1.821300E+00,2.916900E+00,4.046400E+00,&
     & 4.827600E+00,5.541918E+00,7.358600E-03,1.139200E-02,1.540700E-02,&
     & 2.439300E-02,3.820100E-02,6.235300E-02,1.217900E-01,2.403200E-01,&
     & 4.931300E-01,1.286400E+00,1.945200E+00,2.698000E+00,3.218700E+00,&
     & 3.695075E+00,4.770200E-03,6.653900E-03,9.643100E-03,1.506100E-02,&
     & 2.279800E-02,3.932000E-02,7.570400E-02,1.476100E-01,2.921800E-01,&
     & 7.215500E-01,1.063400E+00,1.385400E+00,1.611100E+00,1.848481E+00/
      data   absa(:, 81:100) /                                          &
     & 2.184500E-04,3.336000E-04,6.774500E-04,1.392600E-03,2.827200E-03,&
     & 5.126500E-03,1.106200E-02,3.086900E-02,1.089200E-01,2.383800E-01,&
     & 2.853100E-01,3.716700E-01,5.955800E-01,1.270402E+00,1.879500E-02,&
     & 3.602200E-02,4.802500E-02,7.079800E-02,1.196900E-01,1.842300E-01,&
     & 3.593400E-01,8.195700E-01,1.800700E+00,4.928300E+00,7.749500E+00,&
     & 1.057400E+01,1.229800E+01,1.399857E+01,1.773900E-02,3.313200E-02,&
     & 4.337800E-02,6.464800E-02,1.075700E-01,1.650100E-01,3.201800E-01,&
     & 7.198600E-01,1.578100E+00,4.313000E+00,6.781700E+00,9.252800E+00,&
     & 1.076100E+01,1.224855E+01,1.621100E-02,2.930400E-02,3.820200E-02,&
     & 5.817400E-02,9.556700E-02,1.455300E-01,2.818400E-01,6.243600E-01,&
     & 1.355800E+00,3.697200E+00,5.813100E+00,7.930600E+00,9.224200E+00,&
     & 1.049969E+01,1.445800E-02,2.520000E-02,3.284700E-02,5.078100E-02,&
     & 8.276300E-02,1.267200E-01,2.440400E-01,5.283800E-01,1.139000E+00,&
     & 3.081500E+00,4.844600E+00,6.609500E+00,7.686900E+00,8.749698E+00,&
     & 1.250400E-02,2.086100E-02,2.737400E-02,4.297600E-02,6.896100E-02,&
     & 1.071500E-01,2.062800E-01,4.346200E-01,9.266800E-01,2.465700E+00,&
     & 3.875800E+00,5.287700E+00,6.150200E+00,6.999778E+00,1.036700E-02,&
     & 1.633100E-02,2.174200E-02,3.474400E-02,5.462600E-02,8.633800E-02,&
     & 1.678100E-01,3.421000E-01,7.189500E-01,1.873700E+00,2.907500E+00,&
     & 3.966200E+00,4.612700E+00,5.250361E+00,7.874600E-03,1.178500E-02,&
     & 1.599900E-02,2.586400E-02,3.978500E-02,6.435300E-02,1.265400E-01,&
     & 2.507000E-01,5.134500E-01,1.348000E+00,1.964300E+00,2.644600E+00,&
     & 3.075600E+00,3.501130E+00,4.950500E-03,6.992700E-03,1.039100E-02,&
     & 1.609200E-02,2.402000E-02,4.189300E-02,8.039100E-02,1.572600E-01,&
     & 3.200900E-01,7.618000E-01,1.086300E+00,1.386200E+00,1.603500E+00,&
     & 1.783844E+00,2.445200E-04,3.947700E-04,8.353900E-04,1.722300E-03,&
     & 3.445400E-03,6.210200E-03,1.338200E-02,3.831100E-02,1.329000E-01,&
     & 2.922400E-01,3.563400E-01,4.762800E-01,7.765200E-01,1.613789E+00,&
     & 2.334900E-02,5.598100E-02,8.812000E-02,1.246800E-01,2.069000E-01,&
     & 3.524900E-01,7.341900E-01,1.705000E+00,3.976900E+00,9.151200E+00,&
     & 1.593200E+01,2.401900E+01,3.177900E+01,3.831297E+01,2.107300E-02,&
     & 4.989500E-02,7.738600E-02,1.094800E-01,1.821500E-01,3.097600E-01,&
     & 6.430200E-01,1.493200E+00,3.480500E+00,8.007700E+00,1.394100E+01,&
     & 2.101500E+01,2.780700E+01,3.352289E+01,1.853400E-02,4.368000E-02,&
     & 6.697700E-02,9.427700E-02,1.572500E-01,2.668300E-01,5.524900E-01,&
     & 1.281400E+00,2.983900E+00,6.864700E+00,1.194900E+01,1.801200E+01,&
     & 2.383400E+01,2.873551E+01,1.588600E-02,3.719000E-02,5.650000E-02,&
     & 7.947100E-02,1.321900E-01,2.237800E-01,4.624900E-01,1.069500E+00,&
     & 2.487500E+00,5.720200E+00,9.957800E+00,1.501100E+01,1.986300E+01,&
     & 2.394835E+01,1.315400E-02,3.048500E-02,4.583800E-02,6.470300E-02,&
     & 1.072500E-01,1.809800E-01,3.727900E-01,8.577500E-01,1.991200E+00,&
     & 4.576400E+00,7.967100E+00,1.201000E+01,1.589000E+01,1.915757E+01,&
     & 1.034600E-02,2.356200E-02,3.502700E-02,4.971300E-02,8.246700E-02,&
     & 1.384600E-01,2.824400E-01,6.475100E-01,1.494800E+00,3.433000E+00,&
     & 5.975400E+00,9.007000E+00,1.191800E+01,1.436828E+01,7.474900E-03,&
     & 1.642500E-02,2.399500E-02,3.448300E-02,5.733000E-02,9.621900E-02,&
     & 1.925400E-01,4.383300E-01,9.989200E-01,2.289300E+00,3.984000E+00,&
     & 6.005100E+00,7.945400E+00,9.579636E+00,4.544000E-03,9.044900E-03,&
     & 1.270400E-02,1.872900E-02,3.133800E-02,5.286200E-02,1.046100E-01,&
     & 2.280600E-01,5.092800E-01,1.145600E+00,1.992600E+00,3.002900E+00,&
     & 3.973300E+00,4.790696E+00,9.552200E-05,1.701500E-04,2.267600E-04,&
     & 4.622000E-04,9.157300E-04,1.747600E-03,3.832000E-03,1.091000E-02,&
     & 4.277700E-02,1.023800E-01,1.271400E-01,1.545800E-01,1.963800E-01,&
     & 4.684201E-01,2.571800E-02,5.879900E-02,8.679900E-02,1.247300E-01,&
     & 2.101300E-01,3.494500E-01,7.243800E-01,1.709300E+00,4.008400E+00,&
     & 9.429500E+00,1.607600E+01,2.366800E+01,3.043100E+01,3.631342E+01/
      data   absa(:,101:120) /                                          &
     & 2.327200E-02,5.263100E-02,7.641900E-02,1.097200E-01,1.853700E-01,&
     & 3.072900E-01,6.353100E-01,1.497100E+00,3.508200E+00,8.251200E+00,&
     & 1.406700E+01,2.071200E+01,2.662800E+01,3.177571E+01,2.050300E-02,&
     & 4.609100E-02,6.641900E-02,9.493900E-02,1.602600E-01,2.650300E-01,&
     & 5.469700E-01,1.284800E+00,3.008400E+00,7.072600E+00,1.205800E+01,&
     & 1.775200E+01,2.282300E+01,2.723904E+01,1.762200E-02,3.922600E-02,&
     & 5.611900E-02,8.050500E-02,1.351700E-01,2.230400E-01,4.591000E-01,&
     & 1.072600E+00,2.508200E+00,5.894100E+00,1.004800E+01,1.479400E+01,&
     & 1.902000E+01,2.269803E+01,1.464800E-02,3.213700E-02,4.562300E-02,&
     & 6.592400E-02,1.101700E-01,1.813500E-01,3.705500E-01,8.621600E-01,&
     & 2.008200E+00,4.716000E+00,8.038700E+00,1.183500E+01,1.521700E+01,&
     & 1.815870E+01,1.159600E-02,2.483600E-02,3.491600E-02,5.089500E-02,&
     & 8.525500E-02,1.397100E-01,2.823400E-01,6.528800E-01,1.508400E+00,&
     & 3.537600E+00,6.029600E+00,8.876400E+00,1.141200E+01,1.361939E+01,&
     & 8.453100E-03,1.730100E-02,2.402500E-02,3.557100E-02,5.944800E-02,&
     & 9.814700E-02,1.955300E-01,4.426100E-01,1.012300E+00,2.359100E+00,&
     & 4.019900E+00,5.918100E+00,7.608600E+00,9.080295E+00,5.165200E-03,&
     & 9.510900E-03,1.300400E-02,1.954600E-02,3.268900E-02,5.470400E-02,&
     & 1.095300E-01,2.343500E-01,5.218900E-01,1.189400E+00,2.010500E+00,&
     & 2.959400E+00,3.804900E+00,4.540805E+00,1.195700E-04,1.830500E-04,&
     & 3.016800E-04,5.878500E-04,1.250700E-03,2.308200E-03,5.060700E-03,&
     & 1.437000E-02,5.704100E-02,1.368300E-01,1.705600E-01,2.054800E-01,&
     & 2.773600E-01,6.726954E-01,2.802500E-02,6.099600E-02,8.600100E-02,&
     & 1.255700E-01,2.138500E-01,3.478600E-01,7.130800E-01,1.712300E+00,&
     & 4.034500E+00,9.692900E+00,1.616400E+01,2.329900E+01,2.910300E+01,&
     & 3.437177E+01,2.542100E-02,5.481300E-02,7.600500E-02,1.107400E-01,&
     & 1.890400E-01,3.061600E-01,6.264400E-01,1.500000E+00,3.531600E+00,&
     & 8.481200E+00,1.414500E+01,2.038900E+01,2.546500E+01,3.007535E+01,&
     & 2.245200E-02,4.800600E-02,6.618400E-02,9.644300E-02,1.637900E-01,&
     & 2.647500E-01,5.406000E-01,1.287400E+00,3.028600E+00,7.270400E+00,&
     & 1.212400E+01,1.747500E+01,2.182600E+01,2.578287E+01,1.935300E-02,&
     & 4.082000E-02,5.600800E-02,8.233000E-02,1.386500E-01,2.236700E-01,&
     & 4.543700E-01,1.076400E+00,2.525900E+00,6.059400E+00,1.010300E+01,&
     & 1.456300E+01,1.818800E+01,2.148226E+01,1.616300E-02,3.341400E-02,&
     & 4.559100E-02,6.761700E-02,1.137400E-01,1.825700E-01,3.682600E-01,&
     & 8.671100E-01,2.023200E+00,4.847900E+00,8.082900E+00,1.165000E+01,&
     & 1.455100E+01,1.718645E+01,1.287600E-02,2.578700E-02,3.499000E-02,&
     & 5.254700E-02,8.813300E-02,1.417800E-01,2.833300E-01,6.579400E-01,&
     & 1.522300E+00,3.636400E+00,6.062700E+00,8.737800E+00,1.091400E+01,&
     & 1.289096E+01,9.444000E-03,1.798500E-02,2.426300E-02,3.693800E-02,&
     & 6.160400E-02,1.004300E-01,1.991600E-01,4.484200E-01,1.027500E+00,&
     & 2.425000E+00,4.042400E+00,5.825600E+00,7.276600E+00,8.594738E+00,&
     & 5.815100E-03,9.818700E-03,1.342400E-02,2.066600E-02,3.407000E-02,&
     & 5.663300E-02,1.144100E-01,2.436000E-01,5.350800E-01,1.258100E+00,&
     & 2.021700E+00,2.913400E+00,3.638700E+00,4.298184E+00,1.463800E-04,&
     & 1.890500E-04,3.967600E-04,7.746700E-04,1.618200E-03,2.955600E-03,&
     & 6.478400E-03,1.859000E-02,7.378000E-02,1.775000E-01,2.213500E-01,&
     & 2.651000E-01,3.955100E-01,9.259287E-01,3.027300E-02,6.270700E-02,&
     & 8.569100E-02,1.267500E-01,2.177200E-01,3.480500E-01,7.009700E-01,&
     & 1.712100E+00,4.058800E+00,9.928900E+00,1.621100E+01,2.289500E+01,&
     & 2.781000E+01,3.248403E+01,2.754200E-02,5.648100E-02,7.599400E-02,&
     & 1.123100E-01,1.927600E-01,3.069000E-01,6.169600E-01,1.499800E+00,&
     & 3.553500E+00,8.688500E+00,1.418500E+01,2.003300E+01,2.433400E+01,&
     & 2.842323E+01,2.440000E-02,4.938800E-02,6.627000E-02,9.860400E-02,&
     & 1.675300E-01,2.662300E-01,5.335300E-01,1.288000E+00,3.048200E+00,&
     & 7.447700E+00,1.215900E+01,1.717200E+01,2.085800E+01,2.436545E+01/
      data   absa(:,121:140) /                                          &
     & 2.111000E-02,4.198300E-02,5.615800E-02,8.450200E-02,1.425300E-01,&
     & 2.255200E-01,4.496300E-01,1.079200E+00,2.543000E+00,6.206600E+00,&
     & 1.013200E+01,1.431000E+01,1.738100E+01,2.030311E+01,1.771300E-02,&
     & 3.434400E-02,4.578800E-02,6.970000E-02,1.172300E-01,1.850800E-01,&
     & 3.670000E-01,8.714500E-01,2.038000E+00,4.965200E+00,8.106200E+00,&
     & 1.144900E+01,1.390600E+01,1.624472E+01,1.416900E-02,2.652600E-02,&
     & 3.529600E-02,5.447200E-02,9.081300E-02,1.448000E-01,2.853000E-01,&
     & 6.622300E-01,1.538900E+00,3.725100E+00,6.080000E+00,8.586800E+00,&
     & 1.042900E+01,1.218327E+01,1.044500E-02,1.846100E-02,2.470700E-02,&
     & 3.855300E-02,6.376600E-02,1.030600E-01,2.035100E-01,4.561400E-01,&
     & 1.044700E+00,2.484200E+00,4.053800E+00,5.725000E+00,6.953200E+00,&
     & 8.122513E+00,6.407800E-03,1.011700E-02,1.383000E-02,2.207500E-02,&
     & 3.551300E-02,5.884600E-02,1.191400E-01,2.539400E-01,5.528400E-01,&
     & 1.337600E+00,2.036100E+00,2.862900E+00,3.476900E+00,4.061930E+00,&
     & 1.537500E-04,2.409600E-04,4.918600E-04,9.992200E-04,2.031100E-03,&
     & 3.697000E-03,8.090800E-03,2.369900E-02,9.293900E-02,2.241200E-01,&
     & 2.796700E-01,3.434000E-01,5.445200E-01,1.230706E+00,3.248800E-02,&
     & 6.419500E-02,8.617200E-02,1.284600E-01,2.214300E-01,3.501300E-01,&
     & 6.896200E-01,1.707200E+00,4.076600E+00,1.011600E+01,1.621300E+01,&
     & 2.245700E+01,2.658500E+01,3.073862E+01,2.966800E-02,5.789000E-02,&
     & 7.671600E-02,1.144900E-01,1.963800E-01,3.094800E-01,6.083800E-01,&
     & 1.495700E+00,3.569400E+00,8.851100E+00,1.418700E+01,1.965000E+01,&
     & 2.326200E+01,2.689796E+01,2.636600E-02,5.059300E-02,6.696500E-02,&
     & 1.011900E-01,1.712300E-01,2.691800E-01,5.268800E-01,1.286900E+00,&
     & 3.062400E+00,7.588000E+00,1.216000E+01,1.684500E+01,1.993800E+01,&
     & 2.305633E+01,2.291200E-02,4.297700E-02,5.682000E-02,8.701600E-02,&
     & 1.463300E-01,2.285000E-01,4.464800E-01,1.080700E+00,2.555300E+00,&
     & 6.323300E+00,1.013400E+01,1.403600E+01,1.661600E+01,1.921326E+01,&
     & 1.928500E-02,3.516600E-02,4.648900E-02,7.208400E-02,1.205200E-01,&
     & 1.886500E-01,3.670800E-01,8.740100E-01,2.051700E+00,5.059200E+00,&
     & 8.106800E+00,1.122900E+01,1.329300E+01,1.536931E+01,1.546300E-02,&
     & 2.717000E-02,3.597700E-02,5.666900E-02,9.355600E-02,1.479900E-01,&
     & 2.881400E-01,6.681800E-01,1.554500E+00,3.795100E+00,6.081000E+00,&
     & 8.422500E+00,9.969300E+00,1.152795E+01,1.141100E-02,1.891000E-02,&
     & 2.533200E-02,4.055500E-02,6.594400E-02,1.056800E-01,2.085900E-01,&
     & 4.658200E-01,1.061400E+00,2.551100E+00,4.054400E+00,5.615200E+00,&
     & 6.646500E+00,7.686605E+00,6.903500E-03,1.051100E-02,1.438700E-02,&
     & 2.351800E-02,3.711500E-02,6.113100E-02,1.238700E-01,2.661900E-01,&
     & 5.740900E-01,1.394100E+00,2.088700E+00,2.808100E+00,3.324300E+00,&
     & 3.843942E+00,1.741400E-04,2.917200E-04,6.117300E-04,1.245300E-03,&
     & 2.508800E-03,4.528100E-03,9.898800E-03,2.955100E-02,1.148700E-01,&
     & 2.754500E-01,3.508500E-01,4.383400E-01,7.192500E-01,1.594114E+00,&
     & 3.968000E-02,1.004600E-01,1.610000E-01,2.302900E-01,3.850700E-01,&
     & 6.662300E-01,1.423800E+00,3.567100E+00,9.234700E+00,1.942500E+01,&
     & 3.350500E+01,5.194300E+01,7.054200E+01,8.705502E+01,3.524600E-02,&
     & 8.869600E-02,1.410600E-01,2.018500E-01,3.378000E-01,5.838600E-01,&
     & 1.246500E+00,3.122600E+00,8.080800E+00,1.699700E+01,2.931600E+01,&
     & 4.544800E+01,6.172500E+01,7.616921E+01,3.068700E-02,7.695000E-02,&
     & 1.211700E-01,1.733500E-01,2.904800E-01,5.015300E-01,1.069300E+00,&
     & 2.678000E+00,6.926700E+00,1.456800E+01,2.512800E+01,3.895800E+01,&
     & 5.290900E+01,6.529071E+01,2.598900E-02,6.501000E-02,1.016000E-01,&
     & 1.448500E-01,2.431400E-01,4.189900E-01,8.924200E-01,2.233400E+00,&
     & 5.773000E+00,1.214100E+01,2.094000E+01,3.246400E+01,4.408700E+01,&
     & 5.440605E+01,2.119900E-02,5.285400E-02,8.195300E-02,1.166900E-01,&
     & 1.957000E-01,3.364000E-01,7.159100E-01,1.788700E+00,4.619100E+00,&
     & 9.712700E+00,1.675300E+01,2.597200E+01,3.527200E+01,4.352211E+01/
      data   absa(:,141:160) /                                          &
     & 1.634000E-02,4.044500E-02,6.218900E-02,8.861100E-02,1.482700E-01,&
     & 2.540700E-01,5.397600E-01,1.343900E+00,3.465300E+00,7.285600E+00,&
     & 1.256400E+01,1.947900E+01,2.645300E+01,3.264569E+01,1.139400E-02,&
     & 2.775300E-02,4.218400E-02,6.040900E-02,1.010000E-01,1.722500E-01,&
     & 3.632200E-01,9.003000E-01,2.311500E+00,4.856900E+00,8.377000E+00,&
     & 1.298600E+01,1.763500E+01,2.176301E+01,6.323200E-03,1.471500E-02,&
     & 2.186000E-02,3.169900E-02,5.329600E-02,9.105800E-02,1.866800E-01,&
     & 4.587900E-01,1.158600E+00,2.429200E+00,4.188800E+00,6.493000E+00,&
     & 8.818400E+00,1.088284E+01,6.314200E-05,1.152700E-04,1.592000E-04,&
     & 3.037100E-04,6.214700E-04,1.195800E-03,2.635100E-03,7.864600E-03,&
     & 3.363900E-02,8.520800E-02,1.134300E-01,1.424800E-01,1.819900E-01,&
     & 4.036670E-01,4.406700E-02,1.058400E-01,1.585400E-01,2.298800E-01,&
     & 3.914600E-01,6.634000E-01,1.405100E+00,3.578400E+00,9.323100E+00,&
     & 1.995400E+01,3.395700E+01,5.135200E+01,6.751100E+01,8.220083E+01,&
     & 3.924500E-02,9.364400E-02,1.389700E-01,2.015800E-01,3.437900E-01,&
     & 5.816700E-01,1.230600E+00,3.132400E+00,8.158700E+00,1.746000E+01,&
     & 2.971200E+01,4.493500E+01,5.906900E+01,7.192255E+01,3.418600E-02,&
     & 8.134300E-02,1.197700E-01,1.732900E-01,2.960500E-01,4.997400E-01,&
     & 1.056600E+00,2.686700E+00,6.994200E+00,1.496500E+01,2.546900E+01,&
     & 3.851400E+01,5.063400E+01,6.164542E+01,2.898300E-02,6.872500E-02,&
     & 1.006700E-01,1.452500E-01,2.481900E-01,4.177600E-01,8.828500E-01,&
     & 2.240500E+00,5.829500E+00,1.247100E+01,2.122400E+01,3.209400E+01,&
     & 4.219200E+01,5.137476E+01,2.369000E-02,5.581700E-02,8.140800E-02,&
     & 1.175100E-01,2.001800E-01,3.361900E-01,7.095100E-01,1.794500E+00,&
     & 4.665000E+00,9.976700E+00,1.697900E+01,2.567500E+01,3.375500E+01,&
     & 4.109779E+01,1.831500E-02,4.266300E-02,6.186600E-02,8.973800E-02,&
     & 1.522800E-01,2.550300E-01,5.358200E-01,1.349500E+00,3.500600E+00,&
     & 7.483100E+00,1.273500E+01,1.925700E+01,2.531700E+01,3.082448E+01,&
     & 1.283500E-02,2.925800E-02,4.208300E-02,6.144900E-02,1.044900E-01,&
     & 1.742300E-01,3.616500E-01,9.065800E-01,2.336400E+00,4.989300E+00,&
     & 8.489900E+00,1.283800E+01,1.687800E+01,2.055014E+01,7.215600E-03,&
     & 1.551900E-02,2.189600E-02,3.256900E-02,5.554000E-02,9.328900E-02,&
     & 1.898000E-01,4.639500E-01,1.175700E+00,2.495400E+00,4.245600E+00,&
     & 6.419500E+00,8.438900E+00,1.027620E+01,8.215400E-05,1.210200E-04,&
     & 2.190100E-04,4.023600E-04,8.608800E-04,1.608000E-03,3.533700E-03,&
     & 1.054800E-02,4.558400E-02,1.170800E-01,1.560100E-01,1.950200E-01,&
     & 2.459900E-01,5.981708E-01,4.838200E-02,1.104100E-01,1.571300E-01,&
     & 2.322900E-01,3.993000E-01,6.648000E-01,1.382600E+00,3.583200E+00,&
     & 9.388300E+00,2.042300E+01,3.427300E+01,5.062300E+01,6.463300E+01,&
     & 7.775458E+01,4.318900E-02,9.792600E-02,1.379300E-01,2.039300E-01,&
     & 3.511100E-01,5.830600E-01,1.211700E+00,3.136900E+00,8.216000E+00,&
     & 1.787000E+01,2.999200E+01,4.429400E+01,5.655400E+01,6.803768E+01,&
     & 3.763400E-02,8.512300E-02,1.192400E-01,1.756600E-01,3.027800E-01,&
     & 5.012100E-01,1.041300E+00,2.690200E+00,7.043500E+00,1.531800E+01,&
     & 2.570700E+01,3.796400E+01,4.847700E+01,5.831323E+01,3.195500E-02,&
     & 7.188200E-02,1.004600E-01,1.478000E-01,2.541100E-01,4.199000E-01,&
     & 8.713700E-01,2.243700E+00,5.871400E+00,1.276400E+01,2.142100E+01,&
     & 3.163900E+01,4.039700E+01,4.859824E+01,2.618400E-02,5.834100E-02,&
     & 8.131000E-02,1.202000E-01,2.055000E-01,3.389300E-01,7.012000E-01,&
     & 1.798100E+00,4.699200E+00,1.021200E+01,1.713800E+01,2.530900E+01,&
     & 3.231600E+01,3.888057E+01,2.031700E-02,4.455800E-02,6.192600E-02,&
     & 9.206200E-02,1.571800E-01,2.581800E-01,5.302400E-01,1.354900E+00,&
     & 3.527100E+00,7.659600E+00,1.285400E+01,1.898300E+01,2.423700E+01,&
     & 2.916005E+01,1.432900E-02,3.055400E-02,4.217600E-02,6.339700E-02,&
     & 1.082500E-01,1.776800E-01,3.608500E-01,9.130500E-01,2.355500E+00,&
     & 5.106800E+00,8.569300E+00,1.265500E+01,1.615800E+01,1.944039E+01/
      data   absa(:,161:180) /                                          &
     & 8.134300E-03,1.622400E-02,2.213400E-02,3.395700E-02,5.776800E-02,&
     & 9.598700E-02,1.936700E-01,4.703600E-01,1.193000E+00,2.554400E+00,&
     & 4.285200E+00,6.328000E+00,8.079900E+00,9.717680E+00,1.001500E-04,&
     & 1.345000E-04,2.828100E-04,5.445400E-04,1.130800E-03,2.092900E-03,&
     & 4.591200E-03,1.383400E-02,5.975900E-02,1.567300E-01,2.053600E-01,&
     & 2.589800E-01,3.397000E-01,8.465578E-01,5.263100E-02,1.140300E-01,&
     & 1.568000E-01,2.350700E-01,4.075000E-01,6.700300E-01,1.360900E+00,&
     & 3.580200E+00,9.438300E+00,2.086400E+01,3.453700E+01,4.979900E+01,&
     & 6.182800E+01,7.345464E+01,4.705100E-02,1.013600E-01,1.379500E-01,&
     & 2.066500E-01,3.588300E-01,5.878900E-01,1.193700E+00,3.134300E+00,&
     & 8.259900E+00,1.825700E+01,3.021600E+01,4.357600E+01,5.410300E+01,&
     & 6.427502E+01,4.106900E-02,8.807800E-02,1.195600E-01,1.786800E-01,&
     & 3.095700E-01,5.062700E-01,1.027100E+00,2.688200E+00,7.082100E+00,&
     & 1.564900E+01,2.590100E+01,3.735200E+01,4.637000E+01,5.509123E+01,&
     & 3.494500E-02,7.431900E-02,1.007100E-01,1.512100E-01,2.602600E-01,&
     & 4.251800E-01,8.604900E-01,2.243000E+00,5.904200E+00,1.304200E+01,&
     & 2.158500E+01,3.112400E+01,3.864300E+01,4.590997E+01,2.871600E-02,&
     & 6.026600E-02,8.158800E-02,1.235000E-01,2.111200E-01,3.441700E-01,&
     & 6.928000E-01,1.800600E+00,4.726100E+00,1.043300E+01,1.726900E+01,&
     & 2.490100E+01,3.091500E+01,3.672915E+01,2.236100E-02,4.602800E-02,&
     & 6.213600E-02,9.496400E-02,1.621500E-01,2.630600E-01,5.265000E-01,&
     & 1.359600E+00,3.548200E+00,7.825000E+00,1.295100E+01,1.867600E+01,&
     & 2.318600E+01,2.754605E+01,1.585600E-02,3.154900E-02,4.246900E-02,&
     & 6.585400E-02,1.117500E-01,1.823000E-01,3.623100E-01,9.178500E-01,&
     & 2.374200E+00,5.217300E+00,8.634600E+00,1.245100E+01,1.545800E+01,&
     & 1.836549E+01,9.073500E-03,1.673000E-02,2.257400E-02,3.560400E-02,&
     & 5.990500E-02,9.913400E-02,1.984800E-01,4.792700E-01,1.211000E+00,&
     & 2.609800E+00,4.317800E+00,6.225700E+00,7.729900E+00,9.183329E+00,&
     & 1.076300E-04,1.748300E-04,3.550900E-04,7.099800E-04,1.443500E-03,&
     & 2.652700E-03,5.814200E-03,1.778700E-02,7.629400E-02,2.029300E-01,&
     & 2.646200E-01,3.303500E-01,4.698700E-01,1.154933E+00,5.681200E-02,&
     & 1.167500E-01,1.580700E-01,2.382500E-01,4.154000E-01,6.781500E-01,&
     & 1.340900E+00,3.571400E+00,9.475000E+00,2.124800E+01,3.471300E+01,&
     & 4.889800E+01,5.911200E+01,6.933518E+01,5.087900E-02,1.039100E-01,&
     & 1.394000E-01,2.099000E-01,3.662400E-01,5.956600E-01,1.177300E+00,&
     & 3.126700E+00,8.292600E+00,1.859200E+01,3.037000E+01,4.279100E+01,&
     & 5.173000E+01,6.067781E+01,4.448600E-02,9.022600E-02,1.209300E-01,&
     & 1.824000E-01,3.161800E-01,5.141600E-01,1.014000E+00,2.682700E+00,&
     & 7.110600E+00,1.593800E+01,2.603200E+01,3.667700E+01,4.433700E+01,&
     & 5.200473E+01,3.794900E-02,7.606200E-02,1.019100E-01,1.551500E-01,&
     & 2.664100E-01,4.328100E-01,8.493200E-01,2.241700E+00,5.928300E+00,&
     & 1.328100E+01,2.169600E+01,3.056600E+01,3.694600E+01,4.334062E+01,&
     & 3.126600E-02,6.169900E-02,8.258000E-02,1.270400E-01,2.170900E-01,&
     & 3.509800E-01,6.860600E-01,1.802200E+00,4.746300E+00,1.062400E+01,&
     & 1.735600E+01,2.445200E+01,2.955800E+01,3.467219E+01,2.443900E-02,&
     & 4.711900E-02,6.303600E-02,9.807500E-02,1.669900E-01,2.695200E-01,&
     & 5.248600E-01,1.363500E+00,3.564800E+00,7.969200E+00,1.301800E+01,&
     & 1.834000E+01,2.216900E+01,2.600358E+01,1.739700E-02,3.231500E-02,&
     & 4.325200E-02,6.838400E-02,1.152100E-01,1.876400E-01,3.648200E-01,&
     & 9.239200E-01,2.392600E+00,5.313100E+00,8.679100E+00,1.222600E+01,&
     & 1.477900E+01,1.733777E+01,9.986500E-03,1.716000E-02,2.316900E-02,&
     & 3.749400E-02,6.207900E-02,1.024900E-01,2.036900E-01,4.907600E-01,&
     & 1.228300E+00,2.693100E+00,4.340000E+00,6.113400E+00,7.390300E+00,&
     & 8.669778E+00,1.243300E-04,2.141500E-04,4.443700E-04,8.953600E-04,&
     & 1.808100E-03,3.289600E-03,7.204800E-03,2.230600E-02,9.554200E-02,&
     & 2.542100E-01,3.323000E-01,4.183500E-01,6.306200E-01,1.527971E+00/
      data   absa(:,181:200) /                                          &
     & 6.165900E-02,1.644000E-01,2.729500E-01,3.894500E-01,6.603900E-01,&
     & 1.155000E+00,2.520600E+00,6.741800E+00,1.958500E+01,4.014700E+01,&
     & 6.481300E+01,1.037300E+02,1.443900E+02,1.822766E+02,5.436000E-02,&
     & 1.444800E-01,2.389600E-01,3.410300E-01,5.784900E-01,1.011200E+00,&
     & 2.206200E+00,5.900300E+00,1.713700E+01,3.513000E+01,5.671200E+01,&
     & 9.075900E+01,1.263400E+02,1.595004E+02,4.700000E-02,1.246400E-01,&
     & 2.049700E-01,2.925900E-01,4.965900E-01,8.677200E-01,1.891700E+00,&
     & 5.058700E+00,1.468900E+01,3.011100E+01,4.860800E+01,7.779600E+01,&
     & 1.083000E+02,1.367123E+02,3.957100E-02,1.047500E-01,1.710700E-01,&
     & 2.441500E-01,4.146500E-01,7.239900E-01,1.577300E+00,4.217100E+00,&
     & 1.224200E+01,2.509300E+01,4.050700E+01,6.482600E+01,9.024800E+01,&
     & 1.139280E+02,3.204600E-02,8.470600E-02,1.374200E-01,1.957100E-01,&
     & 3.326800E-01,5.801800E-01,1.263100E+00,3.375400E+00,9.794100E+00,&
     & 2.007300E+01,3.240800E+01,5.185700E+01,7.219900E+01,9.114264E+01,&
     & 2.443100E-02,6.445800E-02,1.037200E-01,1.475400E-01,2.506800E-01,&
     & 4.362000E-01,9.492300E-01,2.533800E+00,7.346500E+00,1.505600E+01,&
     & 2.430600E+01,3.889400E+01,5.415100E+01,6.835838E+01,1.673100E-02,&
     & 4.388300E-02,6.989700E-02,9.956500E-02,1.687800E-01,2.924400E-01,&
     & 6.358800E-01,1.692100E+00,4.898800E+00,1.003800E+01,1.620400E+01,&
     & 2.593100E+01,3.609900E+01,4.557264E+01,8.900200E-03,2.282400E-02,&
     & 3.575600E-02,5.135200E-02,8.690600E-02,1.497600E-01,3.219400E-01,&
     & 8.517300E-01,2.451500E+00,5.018900E+00,8.101700E+00,1.296600E+01,&
     & 1.805000E+01,2.278636E+01,4.413500E-05,7.521300E-05,1.134500E-04,&
     & 2.040900E-04,4.139200E-04,8.106900E-04,1.803900E-03,5.526900E-03,&
     & 2.610200E-02,6.835900E-02,9.635600E-02,1.288700E-01,1.657900E-01,&
     & 3.508902E-01,6.917700E-02,1.741800E-01,2.690900E-01,3.898100E-01,&
     & 6.713800E-01,1.156400E+00,2.486400E+00,6.765600E+00,1.978000E+01,&
     & 4.092400E+01,6.616400E+01,1.027600E+02,1.383800E+02,1.718754E+02,&
     & 6.107700E-02,1.533000E-01,2.356700E-01,3.414700E-01,5.884300E-01,&
     & 1.012800E+00,2.176500E+00,5.921200E+00,1.730900E+01,3.581000E+01,&
     & 5.789500E+01,8.990800E+01,1.210900E+02,1.503707E+02,5.288500E-02,&
     & 1.324300E-01,2.022800E-01,2.930500E-01,5.053800E-01,8.689100E-01,&
     & 1.866900E+00,5.076500E+00,1.483700E+01,3.069200E+01,4.962300E+01,&
     & 7.706500E+01,1.037800E+02,1.289020E+02,4.454000E-02,1.114000E-01,&
     & 1.692200E-01,2.446600E-01,4.223800E-01,7.253400E-01,1.557500E+00,&
     & 4.231900E+00,1.236500E+01,2.557600E+01,4.135200E+01,6.422200E+01,&
     & 8.648000E+01,1.074165E+02,3.608300E-02,9.010900E-02,1.361800E-01,&
     & 1.965900E-01,3.394000E-01,5.814700E-01,1.248300E+00,3.387300E+00,&
     & 9.893200E+00,2.046100E+01,3.308400E+01,5.138200E+01,6.918000E+01,&
     & 8.593694E+01,2.755300E-02,6.851900E-02,1.030300E-01,1.487500E-01,&
     & 2.563300E-01,4.378100E-01,9.395300E-01,2.542800E+00,7.421600E+00,&
     & 1.534600E+01,2.481300E+01,3.853500E+01,5.189000E+01,6.444893E+01,&
     & 1.892000E-02,4.657600E-02,6.959800E-02,1.008800E-01,1.733400E-01,&
     & 2.947700E-01,6.305100E-01,1.699000E+00,4.950000E+00,1.023200E+01,&
     & 1.654200E+01,2.569000E+01,3.459300E+01,4.296804E+01,1.013800E-02,&
     & 2.420200E-02,3.574100E-02,5.238700E-02,9.001000E-02,1.528200E-01,&
     & 3.208000E-01,8.585700E-01,2.478900E+00,5.116000E+00,8.270700E+00,&
     & 1.284500E+01,1.729900E+01,2.148423E+01,5.727800E-05,8.051000E-05,&
     & 1.588700E-04,2.733900E-04,5.903900E-04,1.115700E-03,2.459800E-03,&
     & 7.573200E-03,3.585900E-02,9.692600E-02,1.365200E-01,1.802700E-01,&
     & 2.298800E-01,5.219719E-01,7.656100E-02,1.825400E-01,2.665400E-01,&
     & 3.949700E-01,6.843400E-01,1.166900E+00,2.450200E+00,6.774600E+00,&
     & 1.993500E+01,4.153600E+01,6.722800E+01,1.014800E+02,1.325900E+02,&
     & 1.622586E+02,6.772100E-02,1.608800E-01,2.334800E-01,3.461200E-01,&
     & 6.001400E-01,1.022300E+00,2.145500E+00,5.928900E+00,1.744400E+01,&
     & 3.634300E+01,5.882600E+01,8.879400E+01,1.160200E+02,1.419746E+02/
      data   absa(:,201:220) /                                          &
     & 5.867600E-02,1.391200E-01,2.007700E-01,2.972400E-01,5.159600E-01,&
     & 8.775200E-01,1.841000E+00,5.083500E+00,1.495400E+01,3.115300E+01,&
     & 5.042500E+01,7.611300E+01,9.943200E+01,1.216914E+02,4.943600E-02,&
     & 1.170200E-01,1.683300E-01,2.486100E-01,4.316700E-01,7.326500E-01,&
     & 1.537000E+00,4.238000E+00,1.246300E+01,2.596200E+01,4.201800E+01,&
     & 6.342000E+01,8.286000E+01,1.014120E+02,4.010900E-02,9.458600E-02,&
     & 1.358300E-01,2.002800E-01,3.472100E-01,5.879900E-01,1.233300E+00,&
     & 3.392400E+00,9.972100E+00,2.076900E+01,3.361300E+01,5.073600E+01,&
     & 6.628500E+01,8.113381E+01,3.067500E-02,7.183700E-02,1.028800E-01,&
     & 1.522600E-01,2.627300E-01,4.439900E-01,9.294200E-01,2.547400E+00,&
     & 7.481400E+00,1.557700E+01,2.521100E+01,3.805500E+01,4.971800E+01,&
     & 6.084854E+01,2.114900E-02,4.876700E-02,6.962700E-02,1.036900E-01,&
     & 1.785000E-01,3.005400E-01,6.240300E-01,1.705700E+00,4.991100E+00,&
     & 1.038500E+01,1.680800E+01,2.537100E+01,3.314600E+01,4.056503E+01,&
     & 1.142900E-02,2.535000E-02,3.583400E-02,5.417700E-02,9.327700E-02,&
     & 1.573500E-01,3.216000E-01,8.654800E-01,2.501700E+00,5.192800E+00,&
     & 8.404400E+00,1.268600E+01,1.657300E+01,2.028282E+01,6.817700E-05,&
     & 9.619600E-05,2.043200E-04,3.798400E-04,7.885600E-04,1.477900E-03,&
     & 3.247100E-03,1.013700E-02,4.757500E-02,1.330400E-01,1.847200E-01,&
     & 2.435000E-01,3.106300E-01,7.584247E-01,8.385500E-02,1.893700E-01,&
     & 2.663300E-01,4.014900E-01,6.993500E-01,1.183000E+00,2.417600E+00,&
     & 6.764100E+00,2.005100E+01,4.216600E+01,6.803500E+01,9.998100E+01,&
     & 1.269700E+02,1.532078E+02,7.428700E-02,1.671300E-01,2.334600E-01,&
     & 3.520400E-01,6.138100E-01,1.036800E+00,2.117700E+00,5.920000E+00,&
     & 1.754600E+01,3.689600E+01,5.953600E+01,8.748600E+01,1.111000E+02,&
     & 1.340595E+02,6.439800E-02,1.445400E-01,2.012500E-01,3.027000E-01,&
     & 5.282100E-01,8.903000E-01,1.818100E+00,5.075900E+00,1.504100E+01,&
     & 3.162400E+01,5.102400E+01,7.498900E+01,9.521900E+01,1.149205E+02,&
     & 5.431700E-02,1.215500E-01,1.690300E-01,2.538200E-01,4.422400E-01,&
     & 7.440700E-01,1.518900E+00,4.232000E+00,1.253700E+01,2.635300E+01,&
     & 4.252300E+01,6.249200E+01,7.935700E+01,9.577034E+01,4.413900E-02,&
     & 9.819500E-02,1.363200E-01,2.054600E-01,3.560600E-01,5.986100E-01,&
     & 1.219300E+00,3.389100E+00,1.003200E+01,2.108300E+01,3.401900E+01,&
     & 4.999200E+01,6.348200E+01,7.661233E+01,3.385500E-02,7.451400E-02,&
     & 1.033400E-01,1.568400E-01,2.700500E-01,4.535400E-01,9.184500E-01,&
     & 2.548700E+00,7.527300E+00,1.581300E+01,2.551300E+01,3.749600E+01,&
     & 4.760900E+01,5.745987E+01,2.343400E-02,5.056900E-02,6.996800E-02,&
     & 1.072400E-01,1.843500E-01,3.082600E-01,6.193700E-01,1.709900E+00,&
     & 5.022700E+00,1.054200E+01,1.701000E+01,2.499600E+01,3.174000E+01,&
     & 3.830803E+01,1.275800E-02,2.630800E-02,3.615200E-02,5.645800E-02,&
     & 9.663000E-02,1.627500E-01,3.241500E-01,8.710000E-01,2.523900E+00,&
     & 5.271500E+00,8.506400E+00,1.249800E+01,1.587100E+01,1.915441E+01,&
     & 7.565500E-05,1.269600E-04,2.578400E-04,5.016000E-04,1.025600E-03,&
     & 1.900100E-03,4.172700E-03,1.321900E-02,6.148400E-02,1.757900E-01,&
     & 2.424200E-01,3.189500E-01,4.151000E-01,1.063746E+00,9.111200E-02,&
     & 1.945200E-01,2.686800E-01,4.077300E-01,7.152400E-01,1.201600E+00,&
     & 2.394300E+00,6.741300E+00,2.013500E+01,4.277100E+01,6.855400E+01,&
     & 9.840300E+01,1.215200E+02,1.445435E+02,8.083600E-02,1.718300E-01,&
     & 2.359200E-01,3.578600E-01,6.282700E-01,1.053400E+00,2.097700E+00,&
     & 5.900800E+00,1.762000E+01,3.742500E+01,5.998700E+01,8.609800E+01,&
     & 1.063200E+02,1.264777E+02,7.009300E-02,1.486400E-01,2.036600E-01,&
     & 3.083900E-01,5.410400E-01,9.052900E-01,1.801500E+00,5.060600E+00,&
     & 1.510600E+01,3.207900E+01,5.142000E+01,7.380100E+01,9.112900E+01,&
     & 1.084019E+02,5.920500E-02,1.249500E-01,1.710900E-01,2.595600E-01,&
     & 4.531900E-01,7.581300E-01,1.505500E+00,4.220700E+00,1.259100E+01,&
     & 2.673200E+01,4.284900E+01,6.149800E+01,7.594200E+01,9.034176E+01/
      data   absa(:,221:240) /                                          &
     & 4.819500E-02,1.008600E-01,1.380300E-01,2.109000E-01,3.655000E-01,&
     & 6.114000E-01,1.208200E+00,3.383300E+00,1.007600E+01,2.138500E+01,&
     & 3.427700E+01,4.919900E+01,6.075200E+01,7.227644E+01,3.707600E-02,&
     & 7.652000E-02,1.046700E-01,1.614100E-01,2.782800E-01,4.643200E-01,&
     & 9.121000E-01,2.547500E+00,7.560900E+00,1.604000E+01,2.571000E+01,&
     & 3.690200E+01,4.556800E+01,5.420322E+01,2.575700E-02,5.196400E-02,&
     & 7.093200E-02,1.108600E-01,1.902500E-01,3.174600E-01,6.189200E-01,&
     & 1.712800E+00,5.046300E+00,1.069300E+01,1.714000E+01,2.459800E+01,&
     & 3.037800E+01,3.613857E+01,1.411000E-02,2.704000E-02,3.687700E-02,&
     & 5.883800E-02,9.998800E-02,1.686600E-01,3.285600E-01,8.781300E-01,&
     & 2.545000E+00,5.347300E+00,8.570200E+00,1.230100E+01,1.519000E+01,&
     & 1.807052E+01,8.992100E-05,1.561100E-04,3.243600E-04,6.438400E-04,&
     & 1.302300E-03,2.388500E-03,5.238300E-03,1.673600E-02,7.795200E-02,&
     & 2.239300E-01,3.091900E-01,4.049100E-01,5.550300E-01,1.439717E+00,&
     & 8.888200E-02,2.492100E-01,4.335700E-01,6.210900E-01,1.060500E+00,&
     & 1.872800E+00,4.153500E+00,1.175500E+01,3.863100E+01,8.002700E+01,&
     & 1.180100E+02,1.944900E+02,2.781500E+02,3.589079E+02,7.809400E-02,&
     & 2.185900E-01,3.795100E-01,5.437000E-01,9.283500E-01,1.639400E+00,&
     & 3.634900E+00,1.028700E+01,3.380100E+01,7.002200E+01,1.032600E+02,&
     & 1.702100E+02,2.433900E+02,3.139802E+02,6.725700E-02,1.879800E-01,&
     & 3.254200E-01,4.661900E-01,7.963800E-01,1.405700E+00,3.116300E+00,&
     & 8.818200E+00,2.897400E+01,6.002300E+01,8.850600E+01,1.458900E+02,&
     & 2.086200E+02,2.691472E+02,5.637600E-02,1.574000E-01,2.712900E-01,&
     & 3.887700E-01,6.641600E-01,1.172400E+00,2.597600E+00,7.349400E+00,&
     & 2.414400E+01,5.001900E+01,7.375700E+01,1.215700E+02,1.738400E+02,&
     & 2.242954E+02,4.546800E-02,1.267900E-01,2.172800E-01,3.113200E-01,&
     & 5.320400E-01,9.387300E-01,2.078900E+00,5.881200E+00,1.931600E+01,&
     & 4.001300E+01,5.900200E+01,9.725800E+01,1.390800E+02,1.794304E+02,&
     & 3.447100E-02,9.603000E-02,1.634600E-01,2.338300E-01,3.998800E-01,&
     & 7.050200E-01,1.560400E+00,4.412700E+00,1.448800E+01,3.001100E+01,&
     & 4.425400E+01,7.294300E+01,1.043000E+02,1.345792E+02,2.337200E-02,&
     & 6.501100E-02,1.096400E-01,1.567100E-01,2.677200E-01,4.711900E-01,&
     & 1.042400E+00,2.944200E+00,9.659700E+00,2.000700E+01,2.950300E+01,&
     & 4.862800E+01,6.954100E+01,8.972021E+01,1.214100E-02,3.351300E-02,&
     & 5.566200E-02,7.960200E-02,1.359900E-01,2.374600E-01,5.249900E-01,&
     & 1.475700E+00,4.831500E+00,1.000400E+01,1.475100E+01,2.431400E+01,&
     & 3.476900E+01,4.485812E+01,3.400800E-05,4.781600E-05,8.332500E-05,&
     & 1.334100E-04,2.666500E-04,5.340100E-04,1.211900E-03,3.767000E-03,&
     & 1.960400E-02,5.392400E-02,7.734400E-02,1.101400E-01,1.493200E-01,&
     & 3.026225E-01,1.008800E-01,2.665700E-01,4.279400E-01,6.231400E-01,&
     & 1.079300E+00,1.885500E+00,4.099900E+00,1.179000E+01,3.902200E+01,&
     & 8.117300E+01,1.210800E+02,1.930900E+02,2.670300E+02,3.382935E+02,&
     & 8.869000E-02,2.339800E-01,3.745900E-01,5.455600E-01,9.450800E-01,&
     & 1.650600E+00,3.588200E+00,1.031800E+01,3.414500E+01,7.102400E+01,&
     & 1.059400E+02,1.689700E+02,2.336500E+02,2.960010E+02,7.645400E-02,&
     & 2.014700E-01,3.212300E-01,4.679300E-01,8.109700E-01,1.415900E+00,&
     & 3.076500E+00,8.844400E+00,2.926800E+01,6.087800E+01,9.080800E+01,&
     & 1.448300E+02,2.002800E+02,2.537250E+02,6.416600E-02,1.689000E-01,&
     & 2.679800E-01,3.903700E-01,6.766900E-01,1.180800E+00,2.565000E+00,&
     & 7.371800E+00,2.439000E+01,5.073100E+01,7.567200E+01,1.207000E+02,&
     & 1.669000E+02,2.114391E+02,5.176400E-02,1.361900E-01,2.149400E-01,&
     & 3.127000E-01,5.423900E-01,9.457500E-01,2.053600E+00,5.899000E+00,&
     & 1.951300E+01,4.058400E+01,6.054100E+01,9.655900E+01,1.335100E+02,&
     & 1.691511E+02,3.925600E-02,1.032200E-01,1.619700E-01,2.353400E-01,&
     & 4.081600E-01,7.104900E-01,1.542600E+00,4.426100E+00,1.463600E+01,&
     & 3.043900E+01,4.540600E+01,7.241900E+01,1.001400E+02,1.268557E+02/
      data   absa(:,241:260) /                                          &
     & 2.665100E-02,6.986600E-02,1.089400E-01,1.582700E-01,2.739600E-01,&
     & 4.753400E-01,1.031900E+00,2.953500E+00,9.759500E+00,2.029300E+01,&
     & 3.027100E+01,4.827900E+01,6.676400E+01,8.457087E+01,1.390600E-02,&
     & 3.591500E-02,5.548800E-02,8.099200E-02,1.401100E-01,2.412200E-01,&
     & 5.207600E-01,1.482400E+00,4.883100E+00,1.014700E+01,1.513400E+01,&
     & 2.413900E+01,3.338100E+01,4.228656E+01,4.149600E-05,5.577100E-05,&
     & 1.143300E-04,1.815200E-04,3.957800E-04,7.551000E-04,1.687800E-03,&
     & 5.275600E-03,2.743500E-02,7.816500E-02,1.126300E-01,1.600400E-01,&
     & 2.103800E-01,4.535172E-01,1.126800E-01,2.807800E-01,4.236200E-01,&
     & 6.295700E-01,1.099600E+00,1.912700E+00,4.050100E+00,1.180200E+01,&
     & 3.934800E+01,8.228000E+01,1.235400E+02,1.914000E+02,2.561000E+02,&
     & 3.185481E+02,9.917000E-02,2.466700E-01,3.709000E-01,5.513600E-01,&
     & 9.631200E-01,1.674700E+00,3.545200E+00,1.032800E+01,3.443100E+01,&
     & 7.199600E+01,1.081000E+02,1.674700E+02,2.240900E+02,2.787207E+02,&
     & 8.558400E-02,2.125800E-01,3.182200E-01,4.730800E-01,8.267400E-01,&
     & 1.436700E+00,3.040000E+00,8.853800E+00,2.951400E+01,6.171000E+01,&
     & 9.265200E+01,1.435600E+02,1.920700E+02,2.389140E+02,7.186700E-02,&
     & 1.783100E-01,2.658500E-01,3.947500E-01,6.902600E-01,1.198500E+00,&
     & 2.535400E+00,7.379600E+00,2.459600E+01,5.142500E+01,7.721300E+01,&
     & 1.196300E+02,1.600700E+02,1.990841E+02,5.799700E-02,1.437600E-01,&
     & 2.135900E-01,3.167600E-01,5.538500E-01,9.601700E-01,2.031000E+00,&
     & 5.905500E+00,1.967900E+01,4.114100E+01,6.176900E+01,9.570900E+01,&
     & 1.280500E+02,1.592737E+02,4.401900E-02,1.088700E-01,1.613300E-01,&
     & 2.390600E-01,4.173400E-01,7.220200E-01,1.526900E+00,4.431200E+00,&
     & 1.476100E+01,3.085500E+01,4.633000E+01,7.177700E+01,9.603900E+01,&
     & 1.194541E+02,2.995100E-02,7.355300E-02,1.087000E-01,1.614700E-01,&
     & 2.809300E-01,4.843800E-01,1.022600E+00,2.958000E+00,9.844200E+00,&
     & 2.057000E+01,3.088600E+01,4.785300E+01,6.402500E+01,7.963374E+01,&
     & 1.571400E-02,3.775200E-02,5.544400E-02,8.322500E-02,1.443700E-01,&
     & 2.480700E-01,5.168100E-01,1.489200E+00,4.926700E+00,1.028500E+01,&
     & 1.544300E+01,2.392600E+01,3.201600E+01,3.981820E+01,4.758700E-05,&
     & 7.232400E-05,1.429400E-04,2.597000E-04,5.428100E-04,1.022800E-03,&
     & 2.270300E-03,7.203100E-03,3.694900E-02,1.093400E-01,1.568200E-01,&
     & 2.219000E-01,2.919300E-01,6.623699E-01,1.244300E-01,2.928100E-01,&
     & 4.235600E-01,6.409100E-01,1.127000E+00,1.945800E+00,4.017200E+00,&
     & 1.177100E+01,3.959400E+01,8.311500E+01,1.252600E+02,1.889900E+02,&
     & 2.460200E+02,3.006987E+02,1.096100E-01,2.575200E-01,3.709200E-01,&
     & 5.614700E-01,9.875800E-01,1.704100E+00,3.517000E+00,1.030100E+01,&
     & 3.464600E+01,7.272200E+01,1.096000E+02,1.653700E+02,2.152700E+02,&
     & 2.631262E+02,9.468600E-02,2.220200E-01,3.186000E-01,4.819600E-01,&
     & 8.481400E-01,1.462200E+00,3.016300E+00,8.831000E+00,2.969800E+01,&
     & 6.233600E+01,9.394300E+01,1.417400E+02,1.845100E+02,2.255334E+02,&
     & 7.952400E-02,1.862200E-01,2.665600E-01,4.026500E-01,7.087700E-01,&
     & 1.220200E+00,2.516300E+00,7.361200E+00,2.475100E+01,5.194700E+01,&
     & 7.828400E+01,1.181000E+02,1.537600E+02,1.879401E+02,6.421600E-02,&
     & 1.500800E-01,2.145700E-01,3.237000E-01,5.691000E-01,9.782600E-01,&
     & 2.016600E+00,5.891700E+00,1.980300E+01,4.155800E+01,6.262900E+01,&
     & 9.449300E+01,1.230000E+02,1.503464E+02,4.882500E-02,1.135600E-01,&
     & 1.621700E-01,2.451500E-01,4.293700E-01,7.369400E-01,1.516800E+00,&
     & 4.422400E+00,1.485500E+01,3.116700E+01,4.697500E+01,7.086700E+01,&
     & 9.225300E+01,1.127644E+02,3.330700E-02,7.669300E-02,1.092800E-01,&
     & 1.663800E-01,2.896800E-01,4.964400E-01,1.015300E+00,2.956800E+00,&
     & 9.907900E+00,2.077800E+01,3.131600E+01,4.724600E+01,6.150300E+01,&
     & 7.517672E+01,1.758600E-02,3.933900E-02,5.585800E-02,8.625500E-02,&
     & 1.494800E-01,2.563400E-01,5.169500E-01,1.492700E+00,4.960300E+00,&
     & 1.039000E+01,1.565700E+01,2.362200E+01,3.075200E+01,3.758979E+01/
      data   absa(:,261:280) /                                          &
     & 5.473400E-05,9.183100E-05,1.848700E-04,3.513900E-04,7.169200E-04,&
     & 1.341300E-03,2.963400E-03,9.539800E-03,4.844200E-02,1.459500E-01,&
     & 2.120700E-01,2.957100E-01,3.873500E-01,9.502821E-01,1.360800E-01,&
     & 3.022100E-01,4.273200E-01,6.538800E-01,1.154900E+00,1.981900E+00,&
     & 4.004700E+00,1.171700E+01,3.977000E+01,8.381900E+01,1.266400E+02,&
     & 1.856600E+02,2.369800E+02,2.836729E+02,1.200300E-01,2.659800E-01,&
     & 3.744400E-01,5.730700E-01,1.012500E+00,1.736000E+00,3.505900E+00,&
     & 1.025400E+01,3.480100E+01,7.334900E+01,1.108100E+02,1.624500E+02,&
     & 2.073700E+02,2.482166E+02,1.037200E-01,2.292900E-01,3.221300E-01,&
     & 4.922300E-01,8.702200E-01,1.489900E+00,3.008100E+00,8.791200E+00,&
     & 2.983200E+01,6.286700E+01,9.497600E+01,1.392500E+02,1.777500E+02,&
     & 2.127647E+02,8.715500E-02,1.923100E-01,2.699200E-01,4.119100E-01,&
     & 7.276400E-01,1.244000E+00,2.509900E+00,7.329200E+00,2.486200E+01,&
     & 5.239100E+01,7.914900E+01,1.160300E+02,1.481100E+02,1.772943E+02,&
     & 7.046600E-02,1.549000E-01,2.174200E-01,3.320500E-01,5.847800E-01,&
     & 9.988300E-01,2.012000E+00,5.867200E+00,1.989300E+01,4.191300E+01,&
     & 6.332100E+01,9.283400E+01,1.184900E+02,1.418396E+02,5.366000E-02,&
     & 1.171700E-01,1.643300E-01,2.523700E-01,4.417000E-01,7.544200E-01,&
     & 1.512800E+00,4.408000E+00,1.492400E+01,3.143400E+01,4.749000E+01,&
     & 6.962300E+01,8.886600E+01,1.063832E+02,3.671600E-02,7.907200E-02,&
     & 1.108400E-01,1.717100E-01,2.990700E-01,5.098100E-01,1.014900E+00,&
     & 2.950400E+00,9.954400E+00,2.095700E+01,3.165800E+01,4.641500E+01,&
     & 5.924800E+01,7.092294E+01,1.949000E-02,4.061400E-02,5.675600E-02,&
     & 8.944800E-02,1.547700E-01,2.652400E-01,5.219400E-01,1.494200E+00,&
     & 4.987100E+00,1.047900E+01,1.583100E+01,2.320900E+01,2.962200E+01,&
     & 3.546207E+01,6.453200E-05,1.167000E-04,2.336700E-04,4.553100E-04,&
     & 9.273500E-04,1.713000E-03,3.774800E-03,1.226400E-02,6.216900E-02,&
     & 1.880600E-01,2.772400E-01,3.827400E-01,5.056700E-01,1.318886E+00,&
     & 1.339300E-01,3.947100E-01,7.220100E-01,1.045700E+00,1.790200E+00,&
     & 3.195600E+00,7.145400E+00,2.120100E+01,7.923000E+01,1.699600E+02,&
     & 2.324900E+02,3.841700E+02,5.653100E+02,7.436985E+02,1.174300E-01,&
     & 3.457600E-01,6.318500E-01,9.151900E-01,1.566600E+00,2.796400E+00,&
     & 6.252600E+00,1.855200E+01,6.932600E+01,1.487100E+02,2.034100E+02,&
     & 3.361300E+02,4.946500E+02,6.507150E+02,1.009100E-01,2.968700E-01,&
     & 5.416800E-01,7.846000E-01,1.343200E+00,2.397300E+00,5.359700E+00,&
     & 1.590200E+01,5.942400E+01,1.274700E+02,1.743500E+02,2.881100E+02,&
     & 4.239600E+02,5.577414E+02,8.436600E-02,2.479700E-01,4.514800E-01,&
     & 6.540100E-01,1.119800E+00,1.998300E+00,4.466900E+00,1.325300E+01,&
     & 4.952000E+01,1.062200E+02,1.452900E+02,2.400900E+02,3.533100E+02,&
     & 4.647961E+02,6.779600E-02,1.990900E-01,3.613100E-01,5.234900E-01,&
     & 8.963000E-01,1.599400E+00,3.574400E+00,1.060400E+01,3.961700E+01,&
     & 8.497700E+01,1.162400E+02,1.920500E+02,2.826700E+02,3.718531E+02,&
     & 5.119100E-02,1.501600E-01,2.712300E-01,3.929200E-01,6.729100E-01,&
     & 1.200500E+00,2.681600E+00,7.954600E+00,2.971300E+01,6.373400E+01,&
     & 8.717800E+01,1.440500E+02,2.119800E+02,2.788695E+02,3.448700E-02,&
     & 1.011200E-01,1.813100E-01,2.623000E-01,4.493900E-01,8.014000E-01,&
     & 1.789100E+00,5.304900E+00,1.981000E+01,4.249000E+01,5.811700E+01,&
     & 9.603700E+01,1.413200E+02,1.859189E+02,1.764700E-02,5.171900E-02,&
     & 9.134700E-02,1.322000E-01,2.259400E-01,4.020400E-01,8.972400E-01,&
     & 2.655400E+00,9.906300E+00,2.124600E+01,2.905900E+01,4.802300E+01,&
     & 7.066500E+01,9.296676E+01,2.625800E-05,4.528000E-05,6.105100E-05,&
     & 1.003200E-04,1.778800E-04,3.473900E-04,7.500500E-04,2.516300E-03,&
     & 1.433300E-02,4.258800E-02,6.030800E-02,9.033500E-02,1.323600E-01,&
     & 2.624546E-01,1.538500E-01,4.266000E-01,7.129500E-01,1.050000E+00,&
     & 1.825300E+00,3.231900E+00,7.066200E+00,2.125800E+01,8.005300E+01,&
     & 1.724300E+02,2.379600E+02,3.825300E+02,5.447700E+02,7.007833E+02/
      data   absa(:,281:300) /                                          &
     & 1.349600E-01,3.739100E-01,6.239100E-01,9.190600E-01,1.597700E+00,&
     & 2.828700E+00,6.183300E+00,1.860200E+01,7.004700E+01,1.508800E+02,&
     & 2.082000E+02,3.347300E+02,4.766300E+02,6.132008E+02,1.160300E-01,&
     & 3.211800E-01,5.348700E-01,7.880700E-01,1.370100E+00,2.425400E+00,&
     & 5.300600E+00,1.594500E+01,6.004100E+01,1.293200E+02,1.784600E+02,&
     & 2.869000E+02,4.085400E+02,5.256030E+02,9.708100E-02,2.685300E-01,&
     & 4.458500E-01,6.569900E-01,1.142400E+00,2.021900E+00,4.417700E+00,&
     & 1.328800E+01,5.003400E+01,1.077600E+02,1.487100E+02,2.390800E+02,&
     & 3.404500E+02,4.380005E+02,7.807900E-02,2.157700E-01,3.569400E-01,&
     & 5.259900E-01,9.147600E-01,1.618600E+00,3.535600E+00,1.063200E+01,&
     & 4.002900E+01,8.621100E+01,1.189700E+02,1.912800E+02,2.723600E+02,&
     & 3.504058E+02,5.898100E-02,1.629700E-01,2.682400E-01,3.949200E-01,&
     & 6.870900E-01,1.215000E+00,2.653400E+00,7.975400E+00,3.002300E+01,&
     & 6.466000E+01,8.923100E+01,1.434500E+02,2.042600E+02,2.628036E+02,&
     & 3.976300E-02,1.098600E-01,1.796100E-01,2.641000E-01,4.593600E-01,&
     & 8.113800E-01,1.771500E+00,5.319600E+00,2.001800E+01,4.310600E+01,&
     & 5.948800E+01,9.563200E+01,1.361800E+02,1.752078E+02,2.038700E-02,&
     & 5.614500E-02,9.087600E-02,1.335800E-01,2.320700E-01,4.076700E-01,&
     & 8.900700E-01,2.663100E+00,1.001100E+01,2.155300E+01,2.974500E+01,&
     & 4.781600E+01,6.808900E+01,8.760320E+01,3.208900E-05,5.445900E-05,&
     & 8.266200E-05,1.389900E-04,2.600700E-04,4.976700E-04,1.098400E-03,&
     & 3.616600E-03,2.047400E-02,6.285100E-02,9.020800E-02,1.355700E-01,&
     & 1.922400E-01,3.954950E-01,1.736200E-01,4.530100E-01,7.070400E-01,&
     & 1.059800E+00,1.866100E+00,3.287000E+00,7.009100E+00,2.127100E+01,&
     & 8.074700E+01,1.745700E+02,2.422600E+02,3.794900E+02,5.255300E+02,&
     & 6.598178E+02,1.523700E-01,3.972300E-01,6.188200E-01,9.277400E-01,&
     & 1.633500E+00,2.877300E+00,6.133700E+00,1.861400E+01,7.065400E+01,&
     & 1.527400E+02,2.119700E+02,3.320400E+02,4.598600E+02,5.773513E+02,&
     & 1.310700E-01,3.414900E-01,5.306100E-01,7.956500E-01,1.401000E+00,&
     & 2.467300E+00,5.258600E+00,1.595700E+01,6.056200E+01,1.309200E+02,&
     & 1.817000E+02,2.846000E+02,3.941600E+02,4.948776E+02,1.097500E-01,&
     & 2.856800E-01,4.425200E-01,6.634900E-01,1.168500E+00,2.057300E+00,&
     & 4.383600E+00,1.329800E+01,5.047000E+01,1.091000E+02,1.514100E+02,&
     & 2.371900E+02,3.284800E+02,4.123952E+02,8.829900E-02,2.297500E-01,&
     & 3.546300E-01,5.313000E-01,9.360100E-01,1.647100E+00,3.508500E+00,&
     & 1.064000E+01,4.037800E+01,8.728300E+01,1.211300E+02,1.897500E+02,&
     & 2.627700E+02,3.298992E+02,6.673000E-02,1.735900E-01,2.668100E-01,&
     & 3.993600E-01,7.035900E-01,1.236700E+00,2.633900E+00,7.982500E+00,&
     & 3.028600E+01,6.545900E+01,9.084300E+01,1.423000E+02,1.970600E+02,&
     & 2.474197E+02,4.502300E-02,1.169500E-01,1.790800E-01,2.678200E-01,&
     & 4.711800E-01,8.264800E-01,1.759600E+00,5.324400E+00,2.019300E+01,&
     & 4.364100E+01,6.056800E+01,9.487200E+01,1.313800E+02,1.649617E+02,&
     & 2.316100E-02,5.958300E-02,9.092600E-02,1.362000E-01,2.391100E-01,&
     & 4.169900E-01,8.847000E-01,2.668300E+00,1.010100E+01,2.182100E+01,&
     & 3.028100E+01,4.743800E+01,6.569300E+01,8.248019E+01,4.006700E-05,&
     & 6.481900E-05,1.079600E-04,1.844400E-04,3.657900E-04,6.888300E-04,&
     & 1.542700E-03,5.033900E-03,2.809800E-02,8.870400E-02,1.292700E-01,&
     & 1.947600E-01,2.700700E-01,5.831826E-01,1.932500E-01,4.746700E-01,&
     & 7.065700E-01,1.074300E+00,1.913100E+00,3.353600E+00,6.996700E+00,&
     & 2.121300E+01,8.130300E+01,1.763600E+02,2.454400E+02,3.746500E+02,&
     & 5.073600E+02,6.223524E+02,1.697100E-01,4.164900E-01,6.184100E-01,&
     & 9.405900E-01,1.675100E+00,2.935700E+00,6.122900E+00,1.856400E+01,&
     & 7.114200E+01,1.543200E+02,2.147700E+02,3.278300E+02,4.439500E+02,&
     & 5.445488E+02,1.460900E-01,3.582000E-01,5.303900E-01,8.068500E-01,&
     & 1.436800E+00,2.517800E+00,5.249900E+00,1.591300E+01,6.098000E+01,&
     & 1.322700E+02,1.840900E+02,2.809900E+02,3.805000E+02,4.667700E+02/
      data   absa(:,301:320) /                                          &
     & 1.223800E-01,2.997300E-01,4.427800E-01,6.731100E-01,1.198900E+00,&
     & 2.099700E+00,4.376700E+00,1.326200E+01,5.081900E+01,1.102300E+02,&
     & 1.534100E+02,2.341600E+02,3.170900E+02,3.889934E+02,9.850900E-02,&
     & 2.410900E-01,3.551300E-01,5.394500E-01,9.609500E-01,1.681600E+00,&
     & 3.503700E+00,1.061200E+01,4.065800E+01,8.818300E+01,1.227200E+02,&
     & 1.873200E+02,2.536700E+02,3.111779E+02,7.448100E-02,1.820800E-01,&
     & 2.676900E-01,4.062100E-01,7.229900E-01,1.263300E+00,2.631400E+00,&
     & 7.961900E+00,3.049600E+01,6.613800E+01,9.204400E+01,1.405000E+02,&
     & 1.902600E+02,2.333923E+02,5.033400E-02,1.225100E-01,1.799500E-01,&
     & 2.733100E-01,4.850300E-01,8.455000E-01,1.758900E+00,5.312200E+00,&
     & 2.033400E+01,4.409000E+01,6.136100E+01,9.367000E+01,1.268400E+02,&
     & 1.555936E+02,2.599500E-02,6.238000E-02,9.130500E-02,1.399500E-01,&
     & 2.470600E-01,4.291500E-01,8.846400E-01,2.667200E+00,1.017300E+01,&
     & 2.204600E+01,3.068200E+01,4.683100E+01,6.342100E+01,7.779415E+01,&
     & 4.663000E-05,7.866000E-05,1.392000E-04,2.465700E-04,4.900900E-04,&
     & 9.207500E-04,2.081400E-03,6.776800E-03,3.743900E-02,1.196600E-01,&
     & 1.787800E-01,2.669400E-01,3.685300E-01,8.404440E-01,2.130300E-01,&
     & 4.919900E-01,7.131000E-01,1.099600E+00,1.961800E+00,3.424700E+00,&
     & 7.026200E+00,2.108900E+01,8.168000E+01,1.776400E+02,2.476400E+02,&
     & 3.693100E+02,4.896600E+02,5.882991E+02,1.871700E-01,4.319200E-01,&
     & 6.243000E-01,9.628900E-01,1.718200E+00,2.998300E+00,6.149500E+00,&
     & 1.845500E+01,7.147200E+01,1.554400E+02,2.166800E+02,3.231300E+02,&
     & 4.284600E+02,5.147347E+02,1.612600E-01,3.714400E-01,5.360000E-01,&
     & 8.260800E-01,1.474500E+00,2.571800E+00,5.273300E+00,1.582000E+01,&
     & 6.126500E+01,1.332300E+02,1.857300E+02,2.769600E+02,3.672700E+02,&
     & 4.412044E+02,1.351100E-01,3.109000E-01,4.478200E-01,6.895300E-01,&
     & 1.231000E+00,2.145100E+00,4.396900E+00,1.318600E+01,5.105700E+01,&
     & 1.110200E+02,1.547700E+02,2.308000E+02,3.060500E+02,3.676627E+02,&
     & 1.087900E-01,2.500000E-01,3.597600E-01,5.534200E-01,9.873900E-01,&
     & 1.718500E+00,3.520800E+00,1.055200E+01,4.084700E+01,8.881600E+01,&
     & 1.238100E+02,1.846400E+02,2.448400E+02,2.941364E+02,8.231900E-02,&
     & 1.886500E-01,2.715800E-01,4.173800E-01,7.436400E-01,1.292400E+00,&
     & 2.645100E+00,7.917800E+00,3.063800E+01,6.661300E+01,9.286600E+01,&
     & 1.384900E+02,1.836400E+02,2.205984E+02,5.572000E-02,1.268600E-01,&
     & 1.826100E-01,2.818200E-01,4.995100E-01,8.674500E-01,1.767200E+00,&
     & 5.287300E+00,2.043100E+01,4.441000E+01,6.190700E+01,9.231700E+01,&
     & 1.224200E+02,1.470774E+02,2.890000E-02,6.456300E-02,9.281400E-02,&
     & 1.448500E-01,2.554300E-01,4.426600E-01,8.923400E-01,2.659300E+00,&
     & 1.022300E+01,2.220600E+01,3.095600E+01,4.616000E+01,6.120800E+01,&
     & 7.354090E+01,5.587400E-05,9.418400E-05,1.757200E-04,3.243100E-04,&
     & 6.441700E-04,1.199400E-03,2.706700E-03,8.841300E-03,4.871800E-02,&
     & 1.560000E-01,2.382400E-01,3.521300E-01,4.851600E-01,1.184363E+00,&
     & 2.408500E-01,7.459800E-01,1.434400E+00,2.107100E+00,3.622200E+00,&
     & 6.552200E+00,1.469100E+01,4.518000E+01,1.914000E+02,4.353100E+02,&
     & 5.742800E+02,9.081000E+02,1.386500E+03,1.849450E+03,2.109300E-01,&
     & 6.530000E-01,1.255100E+00,1.843800E+00,3.169700E+00,5.733300E+00,&
     & 1.285600E+01,3.953500E+01,1.674700E+02,3.809000E+02,5.024900E+02,&
     & 7.945500E+02,1.213200E+03,1.618230E+03,1.810200E-01,5.600900E-01,&
     & 1.075900E+00,1.580400E+00,2.717500E+00,4.915400E+00,1.101900E+01,&
     & 3.388700E+01,1.435500E+02,3.264700E+02,4.307000E+02,6.810700E+02,&
     & 1.039900E+03,1.387173E+03,1.510700E-01,4.671800E-01,8.966700E-01,&
     & 1.317300E+00,2.264700E+00,4.095800E+00,9.183200E+00,2.823900E+01,&
     & 1.196200E+02,2.720700E+02,3.589300E+02,5.675500E+02,8.665600E+02,&
     & 1.155930E+03,1.211200E-01,3.743300E-01,7.173500E-01,1.054000E+00,&
     & 1.812200E+00,3.277300E+00,7.347200E+00,2.259100E+01,9.570100E+01,&
     & 2.176600E+02,2.871400E+02,4.540300E+02,6.932300E+02,9.247458E+02/
      data   absa(:,321:340) /                                          &
     & 9.113700E-02,2.814200E-01,5.382100E-01,7.907100E-01,1.359500E+00,&
     & 2.458600E+00,5.511200E+00,1.694400E+01,7.177500E+01,1.632500E+02,&
     & 2.153600E+02,3.405300E+02,5.199500E+02,6.935749E+02,6.111200E-02,&
     & 1.884800E-01,3.589900E-01,5.274900E-01,9.070300E-01,1.639900E+00,&
     & 3.675200E+00,1.129800E+01,4.785000E+01,1.088300E+02,1.435700E+02,&
     & 2.270100E+02,3.466300E+02,4.623736E+02,3.096400E-02,9.540300E-02,&
     & 1.801100E-01,2.641600E-01,4.543600E-01,8.212800E-01,1.839200E+00,&
     & 5.651700E+00,2.392700E+01,5.441200E+01,7.178600E+01,1.135200E+02,&
     & 1.733200E+02,2.311765E+02,2.670400E-05,4.917600E-05,7.574800E-05,&
     & 1.108500E-04,1.770000E-04,2.500000E-04,5.046600E-04,1.371500E-03,&
     & 1.013700E-02,3.263400E-02,4.722700E-02,7.156400E-02,1.134200E-01,&
     & 2.308007E-01,2.804000E-01,8.143400E-01,1.419100E+00,2.114200E+00,&
     & 3.698900E+00,6.653400E+00,1.456100E+01,4.529000E+01,1.935300E+02,&
     & 4.409800E+02,5.849900E+02,9.060500E+02,1.341800E+03,1.745568E+03,&
     & 2.456300E-01,7.130100E-01,1.241900E+00,1.850100E+00,3.236700E+00,&
     & 5.822400E+00,1.274100E+01,3.962700E+01,1.693400E+02,3.858500E+02,&
     & 5.119000E+02,7.927500E+02,1.174000E+03,1.527429E+03,2.108200E-01,&
     & 6.117300E-01,1.064500E+00,1.586100E+00,2.774700E+00,4.990900E+00,&
     & 1.092200E+01,3.396900E+01,1.451500E+02,3.307400E+02,4.387800E+02,&
     & 6.795600E+02,1.006300E+03,1.309138E+03,1.759800E-01,5.104400E-01,&
     & 8.871300E-01,1.321900E+00,2.312900E+00,4.159800E+00,9.101800E+00,&
     & 2.830800E+01,1.209600E+02,2.756200E+02,3.656400E+02,5.662800E+02,&
     & 8.385800E+02,1.090980E+03,1.411400E-01,4.091700E-01,7.097900E-01,&
     & 1.057800E+00,1.850900E+00,3.328400E+00,7.282400E+00,2.264700E+01,&
     & 9.676900E+01,2.205000E+02,2.925200E+02,4.530200E+02,6.708400E+02,&
     & 8.727866E+02,1.062700E-01,3.078800E-01,5.326800E-01,7.937900E-01,&
     & 1.388800E+00,2.497500E+00,5.463100E+00,1.698700E+01,7.257700E+01,&
     & 1.653600E+02,2.193900E+02,3.397800E+02,5.031200E+02,6.546210E+02,&
     & 7.131300E-02,2.065300E-01,3.555700E-01,5.297100E-01,9.268900E-01,&
     & 1.666700E+00,3.643400E+00,1.132700E+01,4.838500E+01,1.102500E+02,&
     & 1.462600E+02,2.265200E+02,3.354400E+02,4.363888E+02,3.615900E-02,&
     & 1.047700E-01,1.786700E-01,2.658500E-01,4.648700E-01,8.348600E-01,&
     & 1.824700E+00,5.666000E+00,2.419500E+01,5.512300E+01,7.313000E+01,&
     & 1.132500E+02,1.677100E+02,2.181960E+02,3.446300E-05,6.146800E-05,&
     & 9.992100E-05,1.481000E-04,2.239600E-04,3.593300E-04,7.010800E-04,&
     & 2.084500E-03,1.496000E-02,4.978800E-02,7.217100E-02,1.108600E-01,&
     & 1.715300E-01,3.485839E-01,3.198600E-01,8.726800E-01,1.408600E+00,&
     & 2.131800E+00,3.790000E+00,6.787100E+00,1.451700E+01,4.526100E+01,&
     & 1.952800E+02,4.465000E+02,5.929100E+02,9.009300E+02,1.298200E+03,&
     & 1.648497E+03,2.802400E-01,7.644000E-01,1.232700E+00,1.865600E+00,&
     & 3.316800E+00,5.939600E+00,1.270200E+01,3.960500E+01,1.708600E+02,&
     & 3.906900E+02,5.187900E+02,7.883200E+02,1.136000E+03,1.442507E+03,&
     & 2.405800E-01,6.560400E-01,1.056600E+00,1.599500E+00,2.843400E+00,&
     & 5.091900E+00,1.088900E+01,3.394800E+01,1.464600E+02,3.349000E+02,&
     & 4.447000E+02,6.756900E+02,9.736200E+02,1.236319E+03,2.009100E-01,&
     & 5.475900E-01,8.806500E-01,1.333300E+00,2.370200E+00,4.244300E+00,&
     & 9.075100E+00,2.829000E+01,1.220500E+02,2.790600E+02,3.705800E+02,&
     & 5.630600E+02,8.113800E+02,1.030403E+03,1.611900E-01,4.392000E-01,&
     & 7.047800E-01,1.067100E+00,1.897200E+00,3.396800E+00,7.260900E+00,&
     & 2.263300E+01,9.764200E+01,2.232500E+02,2.964500E+02,4.504600E+02,&
     & 6.491200E+02,8.242587E+02,1.214300E-01,3.306500E-01,5.292000E-01,&
     & 8.009400E-01,1.424000E+00,2.549200E+00,5.447400E+00,1.697700E+01,&
     & 7.323100E+01,1.674400E+02,2.223500E+02,3.378300E+02,4.868300E+02,&
     & 6.182067E+02,8.150400E-02,2.220000E-01,3.536400E-01,5.347500E-01,&
     & 9.508500E-01,1.701200E+00,3.633800E+00,1.132000E+01,4.882400E+01,&
     & 1.116200E+02,1.482200E+02,2.252100E+02,3.245600E+02,4.121351E+02/
      data   absa(:,341:360) /                                          &
     & 4.137700E-02,1.126900E-01,1.781300E-01,2.691800E-01,4.779700E-01,&
     & 8.528300E-01,1.821500E+00,5.663700E+00,2.441600E+01,5.581600E+01,&
     & 7.411400E+01,1.126200E+02,1.622900E+02,2.060769E+02,4.288500E-05,&
     & 7.590200E-05,1.223600E-04,1.950100E-04,2.741700E-04,4.938700E-04,&
     & 9.513400E-04,3.205700E-03,2.088300E-02,7.209400E-02,1.053600E-01,&
     & 1.646300E-01,2.464800E-01,5.181139E-01,3.591000E-01,9.202500E-01,&
     & 1.408700E+00,2.155500E+00,3.890800E+00,6.931700E+00,1.459200E+01,&
     & 4.512600E+01,1.967200E+02,4.510800E+02,5.981600E+02,8.936300E+02,&
     & 1.255400E+03,1.557021E+03,3.146800E-01,8.061900E-01,1.232700E+00,&
     & 1.886500E+00,3.405400E+00,6.066200E+00,1.276800E+01,3.948600E+01,&
     & 1.721300E+02,3.947000E+02,5.234100E+02,7.819700E+02,1.098600E+03,&
     & 1.362349E+03,2.702600E-01,6.920800E-01,1.056800E+00,1.617500E+00,&
     & 2.919800E+00,5.200900E+00,1.094500E+01,3.384800E+01,1.475400E+02,&
     & 3.383100E+02,4.486200E+02,6.702700E+02,9.415500E+02,1.167758E+03,&
     & 2.257800E-01,5.779400E-01,8.810600E-01,1.348600E+00,2.434300E+00,&
     & 4.335700E+00,9.122300E+00,2.820500E+01,1.229500E+02,2.819400E+02,&
     & 3.738600E+02,5.585000E+02,7.847000E+02,9.729988E+02,1.812600E-01,&
     & 4.636300E-01,7.055300E-01,1.079500E+00,1.948800E+00,3.470500E+00,&
     & 7.299400E+00,2.256700E+01,9.836100E+01,2.255500E+02,2.990800E+02,&
     & 4.468100E+02,6.277600E+02,7.784520E+02,1.365800E-01,3.492800E-01,&
     & 5.299800E-01,8.105900E-01,1.463400E+00,2.604800E+00,5.477400E+00,&
     & 1.692800E+01,7.377300E+01,1.691500E+02,2.243100E+02,3.351300E+02,&
     & 4.708100E+02,5.838706E+02,9.173400E-02,2.345500E-01,3.546000E-01,&
     & 5.420500E-01,9.780500E-01,1.738900E+00,3.655200E+00,1.128800E+01,&
     & 4.918600E+01,1.127700E+02,1.495400E+02,2.234200E+02,3.138800E+02,&
     & 3.892360E+02,4.664100E-02,1.187600E-01,1.791900E-01,2.738600E-01,&
     & 4.929600E-01,8.733400E-01,1.833400E+00,5.649300E+00,2.459800E+01,&
     & 5.638700E+01,7.477300E+01,1.117000E+02,1.569400E+02,1.946293E+02,&
     & 5.150800E-05,9.246600E-05,1.541400E-04,2.422400E-04,3.487500E-04,&
     & 6.475600E-04,1.292300E-03,4.585300E-03,2.826700E-02,9.890100E-02,&
     & 1.483300E-01,2.314500E-01,3.445600E-01,7.527670E-01,3.988100E-01,&
     & 9.589200E-01,1.421700E+00,2.206200E+00,3.985600E+00,7.093500E+00,&
     & 1.478000E+01,4.486500E+01,1.976300E+02,4.544200E+02,6.014400E+02,&
     & 8.817400E+02,1.217300E+03,1.474905E+03,3.495800E-01,8.402500E-01,&
     & 1.244400E+00,1.931100E+00,3.488600E+00,6.208100E+00,1.293300E+01,&
     & 3.925900E+01,1.729300E+02,3.976100E+02,5.262700E+02,7.714800E+02,&
     & 1.065000E+03,1.290470E+03,3.003500E-01,7.213600E-01,1.067200E+00,&
     & 1.656000E+00,2.991600E+00,5.323000E+00,1.108600E+01,3.365100E+01,&
     & 1.482400E+02,3.408100E+02,4.510900E+02,6.612900E+02,9.128900E+02,&
     & 1.106205E+03,2.510700E-01,6.024500E-01,8.902500E-01,1.380700E+00,&
     & 2.494700E+00,4.438000E+00,9.240900E+00,2.804600E+01,1.235200E+02,&
     & 2.840000E+02,3.759000E+02,5.511000E+02,7.606900E+02,9.217888E+02,&
     & 2.016300E-01,4.834400E-01,7.132700E-01,1.105600E+00,1.997800E+00,&
     & 3.552400E+00,7.395200E+00,2.243800E+01,9.882000E+01,2.272100E+02,&
     & 3.007000E+02,4.408500E+02,6.086000E+02,7.374203E+02,1.519800E-01,&
     & 3.642000E-01,5.362700E-01,8.308700E-01,1.501200E+00,2.667100E+00,&
     & 5.549800E+00,1.683200E+01,7.412000E+01,1.704000E+02,2.255400E+02,&
     & 3.306400E+02,4.564500E+02,5.530764E+02,1.021200E-01,2.443100E-01,&
     & 3.596500E-01,5.562600E-01,1.004400E+00,1.781500E+00,3.704800E+00,&
     & 1.122600E+01,4.941700E+01,1.136000E+02,1.503600E+02,2.204500E+02,&
     & 3.042800E+02,3.686886E+02,5.203400E-02,1.235300E-01,1.820200E-01,&
     & 2.821400E-01,5.075800E-01,8.976200E-01,1.857800E+00,5.623300E+00,&
     & 2.471600E+01,5.679800E+01,7.518100E+01,1.102100E+02,1.521500E+02,&
     & 1.843615E+02,5.987200E-05,1.118600E-04,1.911500E-04,2.855800E-04,&
     & 4.593400E-04,8.219500E-04,1.735900E-03,6.224300E-03,3.732400E-02,&
     & 1.303800E-01,1.998100E-01,3.142900E-01,4.632000E-01,1.069258E+00/
      data   absa(:,361:380) /                                          &
     & 8.125100E-01,2.645700E+00,5.365600E+00,7.997200E+00,1.379400E+01,&
     & 2.544400E+01,5.688500E+01,1.798200E+02,8.569600E+02,2.114700E+03,&
     & 2.751400E+03,4.057500E+03,6.428700E+03,8.740273E+03,7.111300E-01,&
     & 2.315200E+00,4.694900E+00,6.997900E+00,1.207000E+01,2.226500E+01,&
     & 4.977600E+01,1.573400E+02,7.498600E+02,1.850400E+03,2.407300E+03,&
     & 3.550200E+03,5.625400E+03,7.650325E+03,6.097800E-01,1.984600E+00,&
     & 4.024400E+00,5.997900E+00,1.034600E+01,1.908400E+01,4.266500E+01,&
     & 1.348700E+02,6.427200E+02,1.586000E+03,2.063500E+03,3.043100E+03,&
     & 4.822000E+03,6.557438E+03,5.083400E-01,1.654100E+00,3.353600E+00,&
     & 4.998600E+00,8.622400E+00,1.590400E+01,3.555400E+01,1.123900E+02,&
     & 5.356100E+02,1.321700E+03,1.719600E+03,2.535800E+03,4.018400E+03,&
     & 5.464605E+03,4.069200E-01,1.323600E+00,2.682900E+00,3.998700E+00,&
     & 6.898300E+00,1.272300E+01,2.844400E+01,8.991200E+01,4.284900E+02,&
     & 1.057400E+03,1.375700E+03,2.028600E+03,3.214600E+03,4.372174E+03,&
     & 3.054900E-01,9.931700E-01,2.012400E+00,2.999400E+00,5.173800E+00,&
     & 9.542800E+00,2.133200E+01,6.743400E+01,3.213700E+02,7.930400E+02,&
     & 1.031800E+03,1.521500E+03,2.410800E+03,3.278724E+03,2.040100E-01,&
     & 6.627600E-01,1.341800E+00,1.999900E+00,3.449700E+00,6.362200E+00,&
     & 1.422400E+01,4.495700E+01,2.142500E+02,5.286700E+02,6.878800E+02,&
     & 1.014300E+03,1.607200E+03,2.185881E+03,1.024700E-01,3.324000E-01,&
     & 6.712100E-01,1.000200E+00,1.725600E+00,3.182000E+00,7.112600E+00,&
     & 2.248100E+01,1.071200E+02,2.643500E+02,3.439300E+02,5.072000E+02,&
     & 8.036600E+02,1.092984E+03,4.206000E-05,8.989200E-05,1.293800E-04,&
     & 1.866800E-04,2.331700E-04,4.017800E-04,6.260900E-04,1.310600E-03,&
     & 4.971000E-03,1.942400E-02,3.310700E-02,5.560300E-02,9.343500E-02,&
     & 2.033926E-01,9.602400E-01,2.918600E+00,5.324900E+00,8.012800E+00,&
     & 1.409300E+01,2.590700E+01,5.658000E+01,1.799600E+02,8.666100E+02,&
     & 2.144200E+03,2.797300E+03,4.057500E+03,6.243300E+03,8.269555E+03,&
     & 8.403900E-01,2.554100E+00,4.659300E+00,7.011400E+00,1.233200E+01,&
     & 2.266800E+01,4.950900E+01,1.574600E+02,7.582700E+02,1.876200E+03,&
     & 2.447600E+03,3.550300E+03,5.462700E+03,7.235788E+03,7.206000E-01,&
     & 2.189600E+00,3.993800E+00,6.009700E+00,1.057100E+01,1.943200E+01,&
     & 4.243600E+01,1.349700E+02,6.499600E+02,1.608200E+03,2.097900E+03,&
     & 3.043100E+03,4.682400E+03,6.202104E+03,6.007900E-01,1.825200E+00,&
     & 3.328400E+00,5.008500E+00,8.809000E+00,1.619400E+01,3.536300E+01,&
     & 1.124700E+02,5.416400E+02,1.340100E+03,1.748200E+03,2.535900E+03,&
     & 3.901800E+03,5.168614E+03,4.809500E-01,1.460700E+00,2.662800E+00,&
     & 4.007000E+00,7.047800E+00,1.295600E+01,2.829100E+01,8.997600E+01,&
     & 4.333100E+02,1.072100E+03,1.398600E+03,2.028600E+03,3.121500E+03,&
     & 4.134890E+03,3.610600E-01,1.096300E+00,1.997200E+00,3.005600E+00,&
     & 5.286400E+00,9.717700E+00,2.121900E+01,6.748800E+01,3.249800E+02,&
     & 8.040800E+02,1.049000E+03,1.521600E+03,2.341100E+03,3.101096E+03,&
     & 2.412000E-01,7.319000E-01,1.331700E+00,2.004200E+00,3.525000E+00,&
     & 6.479400E+00,1.414700E+01,4.499200E+01,2.166600E+02,5.360800E+02,&
     & 6.993200E+02,1.014300E+03,1.560800E+03,2.067424E+03,1.212300E-01,&
     & 3.675100E-01,6.662300E-01,1.002700E+00,1.763600E+00,3.241600E+00,&
     & 7.075100E+00,2.249800E+01,1.083300E+02,2.680300E+02,3.496600E+02,&
     & 5.071500E+02,7.803200E+02,1.033705E+03,5.736300E-05,1.091400E-04,&
     & 1.624800E-04,2.515000E-04,2.955000E-04,4.982000E-04,8.017700E-04,&
     & 1.640400E-03,7.732400E-03,3.686500E-02,5.699800E-02,8.838100E-02,&
     & 1.468100E-01,3.092440E-01,1.108800E+00,3.158700E+00,5.284200E+00,&
     & 8.080500E+00,1.446400E+01,2.649100E+01,5.673200E+01,1.796500E+02,&
     & 8.747200E+02,2.168500E+03,2.826500E+03,4.049000E+03,6.061200E+03,&
     & 7.826527E+03,9.705600E-01,2.764300E+00,4.623800E+00,7.070200E+00,&
     & 1.265800E+01,2.318100E+01,4.963700E+01,1.571900E+02,7.653700E+02,&
     & 1.897600E+03,2.473100E+03,3.542500E+03,5.303400E+03,6.848214E+03/
      data   absa(:,381:400) /                                          &
     & 8.322200E-01,2.370000E+00,3.963300E+00,6.060700E+00,1.084800E+01,&
     & 1.987000E+01,4.254800E+01,1.347300E+02,6.560200E+02,1.626400E+03,&
     & 2.119700E+03,3.036500E+03,4.545500E+03,5.869674E+03,6.939300E-01,&
     & 1.975900E+00,3.302900E+00,5.050900E+00,9.041500E+00,1.655900E+01,&
     & 3.545800E+01,1.122800E+02,5.466900E+02,1.355300E+03,1.766400E+03,&
     & 2.530300E+03,3.788300E+03,4.891861E+03,5.555500E-01,1.581600E+00,&
     & 2.642600E+00,4.041200E+00,7.233700E+00,1.324900E+01,2.836600E+01,&
     & 8.982100E+01,4.373500E+02,1.084200E+03,1.413100E+03,2.024300E+03,&
     & 3.030500E+03,3.913115E+03,4.172000E-01,1.187300E+00,1.982200E+00,&
     & 3.031900E+00,5.426400E+00,9.939200E+00,2.127600E+01,6.737000E+01,&
     & 3.280100E+02,8.131700E+02,1.059900E+03,1.518300E+03,2.272800E+03,&
     & 2.934912E+03,2.787500E-01,7.930100E-01,1.321900E+00,2.021900E+00,&
     & 3.618400E+00,6.627400E+00,1.418400E+01,4.491400E+01,2.186800E+02,&
     & 5.421300E+02,7.066200E+02,1.012200E+03,1.515300E+03,1.956538E+03,&
     & 1.402100E-01,3.986900E-01,6.617400E-01,1.011900E+00,1.810700E+00,&
     & 3.316300E+00,7.094900E+00,2.246100E+01,1.093500E+02,2.710700E+02,&
     & 3.533000E+02,5.061100E+02,7.575600E+02,9.782607E+02,7.411300E-05,&
     & 1.262400E-04,2.150500E-04,3.039600E-04,3.863900E-04,5.867500E-04,&
     & 1.022000E-03,2.026800E-03,1.230200E-02,5.568400E-02,8.590100E-02,&
     & 1.346200E-01,2.181900E-01,4.632045E-01,1.256800E+00,3.355600E+00,&
     & 5.290900E+00,8.174300E+00,1.485500E+01,2.710000E+01,5.746800E+01,&
     & 1.788800E+02,8.812800E+02,2.188600E+03,2.838800E+03,4.016300E+03,&
     & 5.897700E+03,7.420673E+03,1.100100E+00,2.937000E+00,4.629700E+00,&
     & 7.153300E+00,1.299900E+01,2.371400E+01,5.028600E+01,1.565300E+02,&
     & 7.711300E+02,1.915100E+03,2.484100E+03,3.514100E+03,5.160400E+03,&
     & 6.493029E+03,9.434200E-01,2.518300E+00,3.968500E+00,6.131500E+00,&
     & 1.114300E+01,2.032600E+01,4.310100E+01,1.341600E+02,6.609500E+02,&
     & 1.641500E+03,2.129100E+03,3.012200E+03,4.423100E+03,5.565762E+03,&
     & 7.866500E-01,2.099600E+00,3.307400E+00,5.110800E+00,9.286200E+00,&
     & 1.694100E+01,3.592000E+01,1.118100E+02,5.508100E+02,1.368000E+03,&
     & 1.774300E+03,2.510000E+03,3.686100E+03,4.637936E+03,6.298500E-01,&
     & 1.680800E+00,2.646100E+00,4.089200E+00,7.430600E+00,1.355500E+01,&
     & 2.873600E+01,8.944300E+01,4.406400E+02,1.094300E+03,1.419400E+03,&
     & 2.008200E+03,2.948700E+03,3.710387E+03,4.731100E-01,1.262200E+00,&
     & 1.985000E+00,3.067800E+00,5.573700E+00,1.016800E+01,2.155300E+01,&
     & 6.708800E+01,3.304800E+02,8.207700E+02,1.064600E+03,1.506100E+03,&
     & 2.211700E+03,2.782750E+03,3.163000E-01,8.433900E-01,1.324300E+00,&
     & 2.046200E+00,3.717300E+00,6.781300E+00,1.437100E+01,4.472700E+01,&
     & 2.203300E+02,5.472000E+02,7.097400E+02,1.004100E+03,1.474400E+03,&
     & 1.855242E+03,1.591500E-01,4.243600E-01,6.634400E-01,1.024700E+00,&
     & 1.861400E+00,3.394300E+00,7.189200E+00,2.236700E+01,1.101700E+02,&
     & 2.736000E+02,3.548400E+02,5.020200E+02,7.372000E+02,9.276105E+02,&
     & 9.286200E-05,1.559600E-04,2.532300E-04,3.532100E-04,5.078600E-04,&
     & 7.084100E-04,1.238700E-03,2.682400E-03,1.820500E-02,7.813500E-02,&
     & 1.223300E-01,1.941800E-01,3.139400E-01,6.785539E-01,1.406200E+00,&
     & 3.517700E+00,5.332800E+00,8.340900E+00,1.521000E+01,2.776500E+01,&
     & 5.863500E+01,1.780100E+02,8.859400E+02,2.203500E+03,2.837300E+03,&
     & 3.973800E+03,5.729300E+03,7.063556E+03,1.230900E+00,3.078800E+00,&
     & 4.666500E+00,7.298800E+00,1.331100E+01,2.429700E+01,5.130600E+01,&
     & 1.557600E+02,7.751800E+02,1.928100E+03,2.482800E+03,3.476800E+03,&
     & 5.013100E+03,6.180678E+03,1.055700E+00,2.640100E+00,4.000300E+00,&
     & 6.256700E+00,1.141000E+01,2.082700E+01,4.397700E+01,1.335100E+02,&
     & 6.644800E+02,1.652600E+03,2.128000E+03,2.980100E+03,4.296900E+03,&
     & 5.297765E+03,8.803900E-01,2.201300E+00,3.334200E+00,5.214600E+00,&
     & 9.509700E+00,1.735800E+01,3.664800E+01,1.112600E+02,5.537200E+02,&
     & 1.377200E+03,1.773400E+03,2.483500E+03,3.580700E+03,4.414755E+03/
      data   absa(:,401:420) /                                          &
     & 7.051300E-01,1.762500E+00,2.668200E+00,4.172800E+00,7.609100E+00,&
     & 1.388900E+01,2.932100E+01,8.901400E+01,4.429800E+02,1.101800E+03,&
     & 1.418700E+03,1.986800E+03,2.864600E+03,3.532011E+03,5.297700E-01,&
     & 1.323400E+00,2.002100E+00,3.130600E+00,5.708700E+00,1.042000E+01,&
     & 2.199200E+01,6.676200E+01,3.322300E+02,8.263400E+02,1.064000E+03,&
     & 1.490000E+03,2.148400E+03,2.648869E+03,3.543200E-01,8.844500E-01,&
     & 1.336100E+00,2.088500E+00,3.808700E+00,6.949900E+00,1.466500E+01,&
     & 4.451200E+01,2.215000E+02,5.509300E+02,7.093300E+02,9.933800E+02,&
     & 1.432300E+03,1.765913E+03,1.783900E-01,4.452800E-01,6.699800E-01,&
     & 1.047100E+00,1.908700E+00,3.479400E+00,7.337800E+00,2.226100E+01,&
     & 1.107600E+02,2.754600E+02,3.546700E+02,4.966800E+02,7.161700E+02,&
     & 8.829978E+02,1.095400E-04,1.936900E-04,2.872400E-04,4.419800E-04,&
     & 5.898200E-04,8.542400E-04,1.550100E-03,3.296100E-03,2.585300E-02,&
     & 1.055800E-01,1.664200E-01,2.700100E-01,4.308300E-01,9.737057E-01,&
     & 3.086800E+00,1.050100E+01,2.233800E+01,3.377100E+01,5.849600E+01,&
     & 1.102300E+02,2.448700E+02,7.918600E+02,4.211000E+03,1.134000E+04,&
     & 1.479600E+04,2.078200E+04,3.320000E+04,4.618280E+04,2.701000E+00,&
     & 9.188400E+00,1.954500E+01,2.954800E+01,5.118000E+01,9.643200E+01,&
     & 2.142400E+02,6.928500E+02,3.684700E+03,9.922500E+03,1.294700E+04,&
     & 1.818400E+04,2.905000E+04,4.041044E+04,2.315400E+00,7.876300E+00,&
     & 1.675300E+01,2.532800E+01,4.386700E+01,8.266400E+01,1.836400E+02,&
     & 5.938700E+02,3.158200E+03,8.505300E+03,1.109700E+04,1.558600E+04,&
     & 2.489900E+04,3.463382E+04,1.929600E+00,6.563700E+00,1.396100E+01,&
     & 2.110500E+01,3.655600E+01,6.889800E+01,1.530400E+02,4.948500E+02,&
     & 2.631900E+03,7.088200E+03,9.247600E+03,1.298900E+04,2.074900E+04,&
     & 2.886365E+04,1.544000E+00,5.250900E+00,1.117000E+01,1.688600E+01,&
     & 2.924700E+01,5.511400E+01,1.224300E+02,3.958700E+02,2.105500E+03,&
     & 5.670000E+03,7.398200E+03,1.039100E+04,1.660000E+04,2.309228E+04,&
     & 1.158300E+00,3.938700E+00,8.376700E+00,1.266500E+01,2.193500E+01,&
     & 4.133900E+01,9.182500E+01,2.969200E+02,1.579200E+03,4.252400E+03,&
     & 5.548900E+03,7.793100E+03,1.245000E+04,1.731871E+04,7.725700E-01,&
     & 2.626000E+00,5.584900E+00,8.442700E+00,1.462300E+01,2.755500E+01,&
     & 6.121400E+01,1.979500E+02,1.052700E+03,2.835000E+03,3.699200E+03,&
     & 5.195600E+03,8.299800E+03,1.154518E+04,3.868200E-01,1.313700E+00,&
     & 2.792500E+00,4.221600E+00,7.312300E+00,1.377800E+01,3.060600E+01,&
     & 9.898000E+01,5.263700E+02,1.417500E+03,1.849600E+03,2.597700E+03,&
     & 4.150100E+03,5.772500E+03,7.965000E-05,1.795100E-04,2.712300E-04,&
     & 4.320000E-04,5.640300E-04,8.153700E-04,1.735400E-03,2.643400E-03,&
     & 5.023500E-03,1.159100E-02,1.733500E-02,1.507600E-02,1.303500E-02,&
     & 9.015104E-02,3.699200E+00,1.169400E+01,2.224700E+01,3.381000E+01,&
     & 5.978600E+01,1.124700E+02,2.449000E+02,7.915600E+02,4.257800E+03,&
     & 1.148300E+04,1.497500E+04,2.084700E+04,3.237900E+04,4.381314E+04,&
     & 3.237100E+00,1.023300E+01,1.946700E+01,2.958700E+01,5.231700E+01,&
     & 9.842700E+01,2.143100E+02,6.926000E+02,3.725600E+03,1.004800E+04,&
     & 1.310300E+04,1.824200E+04,2.833100E+04,3.833909E+04,2.774900E+00,&
     & 8.771400E+00,1.668600E+01,2.535800E+01,4.484000E+01,8.434600E+01,&
     & 1.836900E+02,5.937000E+02,3.193400E+03,8.612700E+03,1.123100E+04,&
     & 1.563600E+04,2.428600E+04,3.285937E+04,2.312600E+00,7.309500E+00,&
     & 1.390500E+01,2.113100E+01,3.736900E+01,7.030000E+01,1.530900E+02,&
     & 4.947600E+02,2.661300E+03,7.177100E+03,9.358500E+03,1.303000E+04,&
     & 2.023600E+04,2.738122E+04,1.850400E+00,5.847700E+00,1.112400E+01,&
     & 1.690500E+01,2.989500E+01,5.623600E+01,1.224700E+02,3.958000E+02,&
     & 2.128900E+03,5.741900E+03,7.487100E+03,1.042400E+04,1.618900E+04,&
     & 2.190723E+04,1.388300E+00,4.386300E+00,8.343100E+00,1.268000E+01,&
     & 2.242300E+01,4.218000E+01,9.185100E+01,2.968500E+02,1.596700E+03,&
     & 4.306600E+03,5.615500E+03,7.818000E+03,1.214200E+04,1.642933E+04/
      data   absa(:,421:440) /                                          &
     & 9.259500E-01,2.924900E+00,5.562300E+00,8.453400E+00,1.494700E+01,&
     & 2.811800E+01,6.123000E+01,1.978900E+02,1.064500E+03,2.870900E+03,&
     & 3.743500E+03,5.212000E+03,8.094600E+03,1.095379E+04,4.636100E-01,&
     & 1.463600E+00,2.781700E+00,4.227400E+00,7.474900E+00,1.406100E+01,&
     & 3.061900E+01,9.895600E+01,5.322400E+02,1.435400E+03,1.871700E+03,&
     & 2.606100E+03,4.047400E+03,5.476443E+03,1.131500E-04,2.188000E-04,&
     & 3.307600E-04,5.439300E-04,6.968500E-04,9.931000E-04,1.774800E-03,&
     & 3.668900E-03,7.395200E-03,1.258800E-02,3.122600E-02,3.928300E-02,&
     & 6.401400E-02,1.842410E-01,4.323900E+00,1.277100E+01,2.207900E+01,&
     & 3.414400E+01,6.136600E+01,1.151400E+02,2.475500E+02,7.889700E+02,&
     & 4.297600E+03,1.161000E+04,1.507400E+04,2.077600E+04,3.156600E+04,&
     & 4.171536E+04,3.783800E+00,1.117500E+01,1.931900E+01,2.987600E+01,&
     & 5.369200E+01,1.007600E+02,2.166100E+02,6.903700E+02,3.760400E+03,&
     & 1.015900E+04,1.318900E+04,1.817900E+04,2.762100E+04,3.650178E+04,&
     & 3.243600E+00,9.578700E+00,1.656000E+01,2.560900E+01,4.602200E+01,&
     & 8.635800E+01,1.856800E+02,5.917300E+02,3.223200E+03,8.707100E+03,&
     & 1.130500E+04,1.558200E+04,2.367400E+04,3.128713E+04,2.703400E+00,&
     & 7.983200E+00,1.380000E+01,2.134000E+01,3.835300E+01,7.197100E+01,&
     & 1.547200E+02,4.930900E+02,2.686000E+03,7.255900E+03,9.421000E+03,&
     & 1.298500E+04,1.973000E+04,2.607184E+04,2.163000E+00,6.386700E+00,&
     & 1.104000E+01,1.707300E+01,3.068200E+01,5.757600E+01,1.237800E+02,&
     & 3.945000E+02,2.148800E+03,5.804800E+03,7.537000E+03,1.038700E+04,&
     & 1.578400E+04,2.085876E+04,1.622800E+00,4.791000E+00,8.280100E+00,&
     & 1.280500E+01,2.301200E+01,4.318300E+01,9.283400E+01,2.958900E+02,&
     & 1.611600E+03,4.353200E+03,5.652800E+03,7.790500E+03,1.183700E+04,&
     & 1.564433E+04,1.082400E+00,3.195200E+00,5.520500E+00,8.537500E+00,&
     & 1.534400E+01,2.878900E+01,6.188900E+01,1.972500E+02,1.074400E+03,&
     & 2.902300E+03,3.768500E+03,5.193700E+03,7.891900E+03,1.042938E+04,&
     & 5.420400E-01,1.599300E+00,2.760700E+00,4.269700E+00,7.672900E+00,&
     & 1.439600E+01,3.094500E+01,9.863500E+01,5.372000E+02,1.451100E+03,&
     & 1.884200E+03,2.596800E+03,3.946100E+03,5.214564E+03,1.441900E-04,&
     & 2.550400E-04,4.223500E-04,6.472600E-04,8.666100E-04,1.183100E-03,&
     & 1.960700E-03,4.121400E-03,1.025500E-02,2.553800E-02,4.322800E-02,&
     & 5.367800E-02,1.089700E-01,4.040818E-01,4.948300E+00,1.366100E+01,&
     & 2.213300E+01,3.457700E+01,6.300200E+01,1.180200E+02,2.529300E+02,&
     & 7.851800E+02,4.327900E+03,1.170200E+04,1.510900E+04,2.063500E+04,&
     & 3.072800E+04,3.986372E+04,4.330200E+00,1.195400E+01,1.936600E+01,&
     & 3.025500E+01,5.512800E+01,1.032700E+02,2.213200E+02,6.870300E+02,&
     & 3.786900E+03,1.023900E+04,1.322000E+04,1.805500E+04,2.688800E+04,&
     & 3.488042E+04,3.712100E+00,1.024700E+01,1.660000E+01,2.593400E+01,&
     & 4.725400E+01,8.851000E+01,1.897000E+02,5.888900E+02,3.246000E+03,&
     & 8.776600E+03,1.133100E+04,1.547600E+04,2.304800E+04,2.989884E+04,&
     & 3.093700E+00,8.540300E+00,1.383300E+01,2.161300E+01,3.937700E+01,&
     & 7.376500E+01,1.580700E+02,4.907300E+02,2.704900E+03,7.313500E+03,&
     & 9.442400E+03,1.289700E+04,1.920500E+04,2.491432E+04,2.475400E+00,&
     & 6.833100E+00,1.106700E+01,1.729100E+01,3.150500E+01,5.901600E+01,&
     & 1.264700E+02,3.925800E+02,2.164000E+03,5.851100E+03,7.554200E+03,&
     & 1.031700E+04,1.536400E+04,1.993178E+04,1.857200E+00,5.126000E+00,&
     & 8.300500E+00,1.296900E+01,2.363000E+01,4.426300E+01,9.485200E+01,&
     & 2.944400E+02,1.623000E+03,4.388400E+03,5.665900E+03,7.737900E+03,&
     & 1.152300E+04,1.494887E+04,1.238900E+00,3.419100E+00,5.534300E+00,&
     & 8.647100E+00,1.575300E+01,2.951100E+01,6.323800E+01,1.963100E+02,&
     & 1.082000E+03,2.925500E+03,3.777300E+03,5.158400E+03,7.682000E+03,&
     & 9.965979E+03,6.206200E-01,1.712100E+00,2.768000E+00,4.325100E+00,&
     & 7.878000E+00,1.475900E+01,3.162000E+01,9.814900E+01,5.409900E+02,&
     & 1.462800E+03,1.888600E+03,2.579300E+03,3.840900E+03,4.982958E+03/
      data   absa(:,441:460) /                                          &
     & 1.775200E-04,3.155600E-04,4.862800E-04,7.996700E-04,1.040300E-03,&
     & 1.386800E-03,2.352300E-03,4.653300E-03,1.215400E-02,4.527500E-02,&
     & 5.668500E-02,8.486900E-02,2.534200E-01,6.341348E-01,5.574500E+00,&
     & 1.440300E+01,2.233700E+01,3.527900E+01,6.449300E+01,1.213000E+02,&
     & 2.594000E+02,7.827100E+02,4.349600E+03,1.173700E+04,1.508200E+04,&
     & 2.046800E+04,2.982400E+04,3.826958E+04,4.878000E+00,1.260300E+01,&
     & 1.954500E+01,3.086900E+01,5.643600E+01,1.061400E+02,2.269900E+02,&
     & 6.849000E+02,3.806000E+03,1.027000E+04,1.319600E+04,1.791000E+04,&
     & 2.609800E+04,3.348651E+04,4.181600E+00,1.080400E+01,1.675400E+01,&
     & 2.645900E+01,4.837400E+01,9.097800E+01,1.945600E+02,5.870700E+02,&
     & 3.262200E+03,8.803100E+03,1.131100E+04,1.535200E+04,2.236900E+04,&
     & 2.870302E+04,3.485500E+00,9.004100E+00,1.396200E+01,2.205000E+01,&
     & 4.031000E+01,7.581500E+01,1.621300E+02,4.892200E+02,2.718600E+03,&
     & 7.335800E+03,9.425700E+03,1.279300E+04,1.864100E+04,2.391846E+04,&
     & 2.789000E+00,7.204600E+00,1.117100E+01,1.764200E+01,3.225300E+01,&
     & 6.065700E+01,1.297100E+02,3.913700E+02,2.174800E+03,5.868800E+03,&
     & 7.540500E+03,1.023500E+04,1.491300E+04,1.913412E+04,2.092600E+00,&
     & 5.404700E+00,8.378800E+00,1.323200E+01,2.418900E+01,4.549300E+01,&
     & 9.728200E+01,2.935400E+02,1.631100E+03,4.401400E+03,5.655500E+03,&
     & 7.676100E+03,1.118500E+04,1.435107E+04,1.396200E+00,3.605000E+00,&
     & 5.587300E+00,8.823300E+00,1.612700E+01,3.033300E+01,6.485600E+01,&
     & 1.956800E+02,1.087400E+03,2.934400E+03,3.770400E+03,5.117400E+03,&
     & 7.456300E+03,9.567374E+03,6.996300E-01,1.805500E+00,2.795600E+00,&
     & 4.413900E+00,8.066800E+00,1.517200E+01,3.243100E+01,9.785100E+01,&
     & 5.437200E+02,1.467000E+03,1.885200E+03,2.558500E+03,3.728200E+03,&
     & 4.783622E+03,2.144900E-04,3.509500E-04,6.063600E-04,8.861300E-04,&
     & 1.236100E-03,1.707000E-03,2.735400E-03,5.311400E-03,1.471900E-02,&
     & 5.819200E-02,8.631100E-02,1.784000E-01,3.986500E-01,9.152563E-01,&
     & 4.473100E+00,1.530500E+01,3.237200E+01,4.937900E+01,8.718200E+01,&
     & 1.669000E+02,3.689900E+02,1.202300E+03,7.117300E+03,2.090300E+04,&
     & 2.788900E+04,3.808600E+04,5.899700E+04,8.384557E+04,3.913800E+00,&
     & 1.339100E+01,2.832400E+01,4.321000E+01,7.628700E+01,1.460300E+02,&
     & 3.228800E+02,1.052100E+03,6.227700E+03,1.829100E+04,2.440200E+04,&
     & 3.332700E+04,5.162600E+04,7.336768E+04,3.354900E+00,1.147900E+01,&
     & 2.427900E+01,3.703500E+01,6.539400E+01,1.251600E+02,2.767700E+02,&
     & 9.017300E+02,5.338000E+03,1.567800E+04,2.091600E+04,2.856300E+04,&
     & 4.424600E+04,6.288212E+04,2.796000E+00,9.565400E+00,2.023200E+01,&
     & 3.086500E+01,5.449300E+01,1.043100E+02,2.306300E+02,7.514400E+02,&
     & 4.448200E+03,1.306500E+04,1.743000E+04,2.380400E+04,3.687600E+04,&
     & 5.240418E+04,2.237100E+00,7.652700E+00,1.618600E+01,2.469200E+01,&
     & 4.359400E+01,8.344200E+01,1.845200E+02,6.011600E+02,3.558600E+03,&
     & 1.045100E+04,1.394400E+04,1.904200E+04,2.949800E+04,4.192392E+04,&
     & 1.678100E+00,5.739900E+00,1.214000E+01,1.851900E+01,3.269600E+01,&
     & 6.258300E+01,1.383700E+02,4.509100E+02,2.669000E+03,7.838900E+03,&
     & 1.045800E+04,1.428200E+04,2.212400E+04,3.144199E+04,1.119100E+00,&
     & 3.826900E+00,8.092900E+00,1.234600E+01,2.179800E+01,4.172200E+01,&
     & 9.225500E+01,3.005800E+02,1.779300E+03,5.226100E+03,6.972000E+03,&
     & 9.521700E+03,1.475000E+04,2.096337E+04,5.601300E-01,1.913900E+00,&
     & 4.046900E+00,6.173400E+00,1.090000E+01,2.086200E+01,4.612500E+01,&
     & 1.502900E+02,8.896700E+02,2.612900E+03,3.486000E+03,4.760700E+03,&
     & 7.374900E+03,1.048253E+04,1.173900E-04,2.526300E-04,3.865900E-04,&
     & 5.953100E-04,7.436200E-04,1.572700E-03,2.126500E-03,2.858500E-03,&
     & 4.795000E-03,7.188600E-03,1.143200E-02,3.553500E-02,3.485300E-05,&
     & 2.116760E-05,5.367300E+00,1.705300E+01,3.222500E+01,4.966400E+01,&
     & 8.933600E+01,1.708600E+02,3.733500E+02,1.198700E+03,7.186600E+03,&
     & 2.109500E+04,2.811600E+04,3.816700E+04,5.760100E+04,8.024322E+04/
      data   absa(:,461:480) /                                          &
     & 4.696700E+00,1.492100E+01,2.819700E+01,4.345500E+01,7.817200E+01,&
     & 1.494900E+02,3.267000E+02,1.048900E+03,6.288100E+03,1.845900E+04,&
     & 2.460200E+04,3.339500E+04,5.040300E+04,7.021096E+04,4.026000E+00,&
     & 1.279000E+01,2.416900E+01,3.724700E+01,6.700200E+01,1.281400E+02,&
     & 2.800200E+02,8.990600E+02,5.390000E+03,1.582100E+04,2.108700E+04,&
     & 2.862400E+04,4.320300E+04,6.018559E+04,3.355200E+00,1.065800E+01,&
     & 2.014100E+01,3.104000E+01,5.583600E+01,1.067800E+02,2.333400E+02,&
     & 7.491900E+02,4.491700E+03,1.318400E+04,1.757300E+04,2.385300E+04,&
     & 3.600200E+04,5.015082E+04,2.684700E+00,8.527200E+00,1.611300E+01,&
     & 2.483300E+01,4.466800E+01,8.542400E+01,1.866900E+02,5.993800E+02,&
     & 3.593300E+03,1.054800E+04,1.405800E+04,1.908300E+04,2.880200E+04,&
     & 4.012018E+04,2.013800E+00,6.395400E+00,1.208500E+01,1.862500E+01,&
     & 3.350200E+01,6.406700E+01,1.400200E+02,4.495100E+02,2.695000E+03,&
     & 7.910900E+03,1.054300E+04,1.431200E+04,2.160100E+04,3.009028E+04,&
     & 1.343100E+00,4.264600E+00,8.056800E+00,1.241700E+01,2.233500E+01,&
     & 4.271800E+01,9.334100E+01,2.996900E+02,1.796700E+03,5.273600E+03,&
     & 7.029200E+03,9.541400E+03,1.440000E+04,2.006036E+04,6.722400E-01,&
     & 2.133400E+00,4.028400E+00,6.209200E+00,1.116800E+01,2.136000E+01,&
     & 4.667400E+01,1.498400E+02,8.983600E+02,2.636800E+03,3.514400E+03,&
     & 4.770700E+03,7.200400E+03,1.003025E+04,1.427200E-04,3.267100E-04,&
     & 4.683700E-04,7.391100E-04,9.070200E-04,1.623400E-03,3.208000E-03,&
     & 4.238100E-03,1.038100E-02,6.046000E-03,1.107500E-02,2.033600E-02,&
     & 3.914900E-02,7.496377E-02,6.280500E+00,1.859700E+01,3.208900E+01,&
     & 5.035100E+01,9.158100E+01,1.751900E+02,3.823300E+02,1.193800E+03,&
     & 7.242000E+03,2.121000E+04,2.822400E+04,3.809500E+04,5.618400E+04,&
     & 7.706309E+04,5.495400E+00,1.627300E+01,2.807800E+01,4.405600E+01,&
     & 8.013100E+01,1.532900E+02,3.345300E+02,1.044600E+03,6.336300E+03,&
     & 1.855900E+04,2.469500E+04,3.333300E+04,4.916200E+04,6.743261E+04,&
     & 4.710900E+00,1.394900E+01,2.406800E+01,3.776200E+01,6.868800E+01,&
     & 1.313900E+02,2.867400E+02,8.953900E+02,5.431300E+03,1.590800E+04,&
     & 2.116600E+04,2.857100E+04,4.213600E+04,5.780101E+04,3.926000E+00,&
     & 1.162500E+01,2.005700E+01,3.147000E+01,5.723700E+01,1.094900E+02,&
     & 2.389600E+02,7.461100E+02,4.526200E+03,1.325600E+04,1.764000E+04,&
     & 2.380900E+04,3.511700E+04,4.816525E+04,3.141200E+00,9.300700E+00,&
     & 1.604600E+01,2.517500E+01,4.579200E+01,8.758900E+01,1.911600E+02,&
     & 5.969400E+02,3.620900E+03,1.060500E+04,1.411200E+04,1.904800E+04,&
     & 2.809200E+04,3.853436E+04,2.356300E+00,6.975900E+00,1.203500E+01,&
     & 1.888200E+01,3.434500E+01,6.569800E+01,1.433700E+02,4.476800E+02,&
     & 2.715600E+03,7.953600E+03,1.058300E+04,1.428500E+04,2.106800E+04,&
     & 2.890274E+04,1.571600E+00,4.652000E+00,8.023200E+00,1.258900E+01,&
     & 2.289600E+01,4.379900E+01,9.557700E+01,2.984700E+02,1.810400E+03,&
     & 5.302700E+03,7.056000E+03,9.523500E+03,1.404600E+04,1.926702E+04,&
     & 7.866300E-01,2.327700E+00,4.012100E+00,6.295400E+00,1.144900E+01,&
     & 2.190300E+01,4.779400E+01,1.492300E+02,9.052000E+02,2.651100E+03,&
     & 3.527600E+03,4.761700E+03,7.022600E+03,9.632714E+03,1.873100E-04,&
     & 3.961800E-04,5.667600E-04,9.053500E-04,1.080900E-03,1.788400E-03,&
     & 3.491000E-03,6.177600E-03,1.119200E-02,2.626200E-02,4.654700E-02,&
     & 7.305800E-02,4.174500E-02,2.080545E-01,7.194100E+00,1.989400E+01,&
     & 3.228100E+01,5.131000E+01,9.383900E+01,1.801600E+02,3.929900E+02,&
     & 1.191900E+03,7.281800E+03,2.126000E+04,2.821700E+04,3.784000E+04,&
     & 5.463900E+04,7.444578E+04,6.295100E+00,1.740900E+01,2.824600E+01,&
     & 4.489900E+01,8.210700E+01,1.576200E+02,3.438300E+02,1.042900E+03,&
     & 6.371500E+03,1.860300E+04,2.469000E+04,3.311000E+04,4.780700E+04,&
     & 6.513670E+04,5.396300E+00,1.492200E+01,2.421200E+01,3.848400E+01,&
     & 7.038300E+01,1.351000E+02,2.947200E+02,8.939600E+02,5.461300E+03,&
     & 1.594500E+04,2.116200E+04,2.838000E+04,4.097900E+04,5.583042E+04/
      data   absa(:,481:500) /                                          &
     & 4.497300E+00,1.243600E+01,2.017600E+01,3.207100E+01,5.865800E+01,&
     & 1.125900E+02,2.456100E+02,7.449800E+02,4.551100E+03,1.328700E+04,&
     & 1.763600E+04,2.365100E+04,3.414900E+04,4.652685E+04,3.598400E+00,&
     & 9.949700E+00,1.614100E+01,2.565700E+01,4.692100E+01,9.007600E+01,&
     & 1.964800E+02,5.959700E+02,3.640900E+03,1.063000E+04,1.410800E+04,&
     & 1.892100E+04,2.731900E+04,3.722148E+04,2.699300E+00,7.463200E+00,&
     & 1.210600E+01,1.924400E+01,3.519300E+01,6.755700E+01,1.473600E+02,&
     & 4.469800E+02,2.730700E+03,7.972600E+03,1.058100E+04,1.419100E+04,&
     & 2.048900E+04,2.791709E+04,1.800500E+00,4.977100E+00,8.071600E+00,&
     & 1.283100E+01,2.346200E+01,4.503900E+01,9.824200E+01,2.979700E+02,&
     & 1.820500E+03,5.314900E+03,7.054000E+03,9.460300E+03,1.365900E+04,&
     & 1.861097E+04,9.013800E-01,2.490700E+00,4.037000E+00,6.417100E+00,&
     & 1.173200E+01,2.252400E+01,4.912000E+01,1.490000E+02,9.102500E+02,&
     & 2.657500E+03,3.527200E+03,4.730200E+03,6.830300E+03,9.304823E+03,&
     & 2.242900E-04,4.602900E-04,7.303100E-04,1.030000E-03,1.323500E-03,&
     & 2.121500E-03,3.820800E-03,6.812400E-03,1.514500E-02,3.182400E-02,&
     & 6.248800E-02,9.234200E-02,1.439700E-01,4.691556E-01,8.108400E+00,&
     & 2.095700E+01,3.273600E+01,5.269100E+01,9.595800E+01,1.851800E+02,&
     & 4.048300E+02,1.194300E+03,7.307800E+03,2.122100E+04,2.812600E+04,&
     & 3.746600E+04,5.301700E+04,7.225993E+04,7.095200E+00,1.833700E+01,&
     & 2.864600E+01,4.610500E+01,8.396700E+01,1.620300E+02,3.542300E+02,&
     & 1.045000E+03,6.394400E+03,1.856900E+04,2.460900E+04,3.278200E+04,&
     & 4.638900E+04,6.322884E+04,6.082200E+00,1.571800E+01,2.455300E+01,&
     & 3.951900E+01,7.197000E+01,1.388800E+02,3.036300E+02,8.956700E+02,&
     & 5.480800E+03,1.591500E+04,2.109300E+04,2.809800E+04,3.976300E+04,&
     & 5.419715E+04,5.069200E+00,1.309900E+01,2.046200E+01,3.293300E+01,&
     & 5.997300E+01,1.157300E+02,2.530100E+02,7.464600E+02,4.567500E+03,&
     & 1.326300E+04,1.757800E+04,2.341600E+04,3.313700E+04,4.516299E+04,&
     & 4.056000E+00,1.048000E+01,1.637000E+01,2.634800E+01,4.798200E+01,&
     & 9.259100E+01,2.024200E+02,5.971600E+02,3.654000E+03,1.061100E+04,&
     & 1.406300E+04,1.873200E+04,2.650900E+04,3.613179E+04,3.042800E+00,&
     & 7.861100E+00,1.227800E+01,1.976300E+01,3.598700E+01,6.944900E+01,&
     & 1.518200E+02,4.478600E+02,2.740400E+03,7.958000E+03,1.054700E+04,&
     & 1.404900E+04,1.988100E+04,2.709802E+04,2.029700E+00,5.242700E+00,&
     & 8.186400E+00,1.317600E+01,2.399400E+01,4.630200E+01,1.012100E+02,&
     & 2.985700E+02,1.827000E+03,5.305300E+03,7.031100E+03,9.365900E+03,&
     & 1.325500E+04,1.806652E+04,1.016300E+00,2.623800E+00,4.094900E+00,&
     & 6.591800E+00,1.199800E+01,2.315700E+01,5.060900E+01,1.492900E+02,&
     & 9.135100E+02,2.652500E+03,3.515500E+03,4.683100E+03,6.626900E+03,&
     & 9.032605E+03,2.658800E-04,5.100000E-04,8.351600E-04,1.305600E-03,&
     & 1.545800E-03,2.481300E-03,4.212300E-03,7.233000E-03,1.939100E-02,&
     & 4.283100E-02,7.505100E-02,1.138700E-01,2.277200E-01,9.168453E-01,&
     & 4.832400E+00,1.659500E+01,3.488200E+01,5.368200E+01,9.668000E+01,&
     & 1.870700E+02,4.193700E+02,1.346800E+03,8.776800E+03,2.800500E+04,&
     & 3.880800E+04,5.306800E+04,7.797100E+04,1.152439E+05,4.228500E+00,&
     & 1.452100E+01,3.052200E+01,4.697100E+01,8.459700E+01,1.636800E+02,&
     & 3.669500E+02,1.178400E+03,7.679700E+03,2.450600E+04,3.395800E+04,&
     & 4.643400E+04,6.822600E+04,1.008442E+05,3.624400E+00,1.244600E+01,&
     & 2.616200E+01,4.026000E+01,7.251600E+01,1.403000E+02,3.145200E+02,&
     & 1.010100E+03,6.582600E+03,2.100300E+04,2.910600E+04,3.980100E+04,&
     & 5.847500E+04,8.643783E+04,3.020500E+00,1.037200E+01,2.180200E+01,&
     & 3.355200E+01,6.043000E+01,1.169200E+02,2.621100E+02,8.417000E+02,&
     & 5.485300E+03,1.750400E+04,2.425500E+04,3.316700E+04,4.873200E+04,&
     & 7.202664E+04,2.416700E+00,8.297500E+00,1.744100E+01,2.684200E+01,&
     & 4.834700E+01,9.354100E+01,2.096900E+02,6.733400E+02,4.388400E+03,&
     & 1.400300E+04,1.940300E+04,2.653300E+04,3.898500E+04,5.762147E+04/
      data   absa(:,501:520) /                                          &
     & 1.813000E+00,6.223400E+00,1.308100E+01,2.013100E+01,3.625700E+01,&
     & 7.015300E+01,1.572600E+02,5.050300E+02,3.291200E+03,1.050200E+04,&
     & 1.455200E+04,1.990100E+04,2.923800E+04,4.321563E+04,1.209100E+00,&
     & 4.149200E+00,8.720800E+00,1.342000E+01,2.417200E+01,4.676600E+01,&
     & 1.048500E+02,3.366800E+02,2.194200E+03,7.001800E+03,9.702000E+03,&
     & 1.326600E+04,1.949100E+04,2.881157E+04,6.050900E-01,2.074900E+00,&
     & 4.360700E+00,6.710700E+00,1.208700E+01,2.338400E+01,5.242300E+01,&
     & 1.683400E+02,1.097000E+03,3.500700E+03,4.851000E+03,6.633400E+03,&
     & 9.745800E+03,1.440606E+04,1.222800E-04,2.872100E-04,4.185300E-04,&
     & 5.961800E-04,8.879200E-04,1.977000E-03,2.278400E-03,3.218000E-03,&
     & 4.562500E-03,1.928200E-02,3.087900E-04,5.363100E-05,2.621100E-05,&
     & 2.159733E-05,5.800700E+00,1.848700E+01,3.474400E+01,5.420900E+01,&
     & 9.903900E+01,1.918300E+02,4.295600E+02,1.341700E+03,8.850700E+03,&
     & 2.817800E+04,3.896400E+04,5.291200E+04,7.635800E+04,1.114146E+05,&
     & 5.076100E+00,1.617800E+01,3.040000E+01,4.743300E+01,8.666200E+01,&
     & 1.678800E+02,3.758600E+02,1.174000E+03,7.744200E+03,2.465600E+04,&
     & 3.409300E+04,4.629600E+04,6.681200E+04,9.748920E+04,4.351200E+00,&
     & 1.386600E+01,2.605800E+01,4.065700E+01,7.428400E+01,1.438900E+02,&
     & 3.221600E+02,1.006200E+03,6.637800E+03,2.113500E+04,2.922200E+04,&
     & 3.968400E+04,5.726500E+04,8.355543E+04,3.626400E+00,1.155600E+01,&
     & 2.171500E+01,3.387900E+01,6.190300E+01,1.199000E+02,2.684800E+02,&
     & 8.385500E+02,5.531600E+03,1.761100E+04,2.435100E+04,3.306700E+04,&
     & 4.772100E+04,6.963505E+04,2.901200E+00,9.244400E+00,1.737200E+01,&
     & 2.710400E+01,4.952200E+01,9.593200E+01,2.147800E+02,6.708200E+02,&
     & 4.425100E+03,1.409000E+04,1.948200E+04,2.645500E+04,3.818000E+04,&
     & 5.570785E+04,2.176300E+00,6.933900E+00,1.302900E+01,2.032900E+01,&
     & 3.714400E+01,7.194900E+01,1.610800E+02,5.031400E+02,3.318900E+03,&
     & 1.056700E+04,1.461200E+04,1.984100E+04,2.863100E+04,4.177910E+04,&
     & 1.451500E+00,4.623100E+00,8.686200E+00,1.355300E+01,2.476200E+01,&
     & 4.796600E+01,1.073900E+02,3.354100E+02,2.212600E+03,7.044500E+03,&
     & 9.741100E+03,1.322800E+04,1.908800E+04,2.785113E+04,7.265100E-01,&
     & 2.312600E+00,4.343500E+00,6.777200E+00,1.238200E+01,2.398500E+01,&
     & 5.369700E+01,1.677200E+02,1.106300E+03,3.522100E+03,4.870300E+03,&
     & 6.613600E+03,9.544900E+03,1.392618E+04,1.618300E-04,3.521000E-04,&
     & 5.163500E-04,7.664900E-04,1.034800E-03,2.104300E-03,3.593800E-03,&
     & 4.684600E-03,8.787700E-03,8.638200E-03,1.384000E-02,3.304500E-02,&
     & 1.665800E-02,3.312186E-02,6.795500E+00,2.015700E+01,3.469400E+01,&
     & 5.519100E+01,1.015200E+02,1.971000E+02,4.422200E+02,1.340900E+03,&
     & 8.902000E+03,2.820500E+04,3.893500E+04,5.274200E+04,7.459800E+04,&
     & 1.081668E+05,5.946300E+00,1.763800E+01,3.035600E+01,4.829300E+01,&
     & 8.883400E+01,1.724600E+02,3.869300E+02,1.173400E+03,7.789100E+03,&
     & 2.468000E+04,3.406700E+04,4.615000E+04,6.527200E+04,9.464739E+04,&
     & 5.097200E+00,1.511900E+01,2.602000E+01,4.139500E+01,7.615000E+01,&
     & 1.478400E+02,3.316400E+02,1.005800E+03,6.676500E+03,2.115300E+04,&
     & 2.919800E+04,3.955600E+04,5.594900E+04,8.112235E+04,4.248100E+00,&
     & 1.260000E+01,2.168300E+01,3.449500E+01,6.345000E+01,1.232000E+02,&
     & 2.763800E+02,8.381400E+02,5.563800E+03,1.762800E+04,2.433300E+04,&
     & 3.296300E+04,4.662300E+04,6.760627E+04,3.398900E+00,1.008000E+01,&
     & 1.734700E+01,2.759700E+01,5.076500E+01,9.855200E+01,2.210900E+02,&
     & 6.704800E+02,4.451200E+03,1.410300E+04,1.946600E+04,2.637200E+04,&
     & 3.730000E+04,5.408265E+04,2.549800E+00,7.560700E+00,1.301000E+01,&
     & 2.069700E+01,3.807100E+01,7.391700E+01,1.658200E+02,5.028700E+02,&
     & 3.338300E+03,1.057700E+04,1.460000E+04,1.977900E+04,2.797600E+04,&
     & 4.056190E+04,1.700500E+00,5.041400E+00,8.673700E+00,1.379900E+01,&
     & 2.538300E+01,4.927800E+01,1.105500E+02,3.352400E+02,2.225600E+03,&
     & 7.051200E+03,9.733300E+03,1.318600E+04,1.865000E+04,2.703967E+04/
      data   absa(:,521:540) /                                          &
     & 8.510900E-01,2.522300E+00,4.337400E+00,6.900900E+00,1.269200E+01,&
     & 2.464400E+01,5.527700E+01,1.676300E+02,1.112800E+03,3.525600E+03,&
     & 4.866700E+03,6.592500E+03,9.325000E+03,1.352100E+04,1.962200E-04,&
     & 4.424800E-04,5.825800E-04,9.657000E-04,1.273400E-03,2.228900E-03,&
     & 4.403700E-03,6.560600E-03,1.520900E-02,2.977300E-02,2.130600E-02,&
     & 2.403800E-02,6.147200E-02,1.231998E-01,7.787100E+00,2.156800E+01,&
     & 3.499900E+01,5.660600E+01,1.038900E+02,2.026500E+02,4.562400E+02,&
     & 1.347100E+03,8.930500E+03,2.817000E+04,3.883100E+04,5.232900E+04,&
     & 7.268300E+04,1.055210E+05,6.814100E+00,1.887200E+01,3.062500E+01,&
     & 4.953000E+01,9.090200E+01,1.773100E+02,3.992100E+02,1.178700E+03,&
     & 7.814400E+03,2.464800E+04,3.397900E+04,4.578800E+04,6.360000E+04,&
     & 9.232861E+04,5.841200E+00,1.617600E+01,2.624900E+01,4.245500E+01,&
     & 7.791200E+01,1.519800E+02,3.422000E+02,1.010300E+03,6.698100E+03,&
     & 2.112600E+04,2.912300E+04,3.924800E+04,5.451300E+04,7.914128E+04,&
     & 4.868000E+00,1.348000E+01,2.187600E+01,3.538200E+01,6.493500E+01,&
     & 1.266600E+02,2.851700E+02,8.419200E+02,5.581700E+03,1.760600E+04,&
     & 2.427000E+04,3.270700E+04,4.542900E+04,6.594808E+04,3.894900E+00,&
     & 1.078500E+01,1.750100E+01,2.830600E+01,5.194600E+01,1.013300E+02,&
     & 2.281200E+02,6.735400E+02,4.465300E+03,1.408400E+04,1.941700E+04,&
     & 2.616500E+04,3.634300E+04,5.276038E+04,2.921800E+00,8.089700E+00,&
     & 1.312600E+01,2.123000E+01,3.896000E+01,7.599700E+01,1.710900E+02,&
     & 5.051500E+02,3.348900E+03,1.056300E+04,1.456200E+04,1.962300E+04,&
     & 2.725600E+04,3.955348E+04,1.948700E+00,5.394500E+00,8.751300E+00,&
     & 1.415400E+01,2.597300E+01,5.066500E+01,1.140600E+02,3.367700E+02,&
     & 2.232600E+03,7.042100E+03,9.707700E+03,1.308200E+04,1.817100E+04,&
     & 2.637999E+04,9.755400E-01,2.699300E+00,4.376800E+00,7.079400E+00,&
     & 1.298900E+01,2.533800E+01,5.703500E+01,1.683900E+02,1.116300E+03,&
     & 3.521100E+03,4.853800E+03,6.541000E+03,9.085200E+03,1.318948E+04,&
     & 2.452700E-04,5.024400E-04,7.254500E-04,1.150300E-03,1.546100E-03,&
     & 2.507000E-03,4.526600E-03,8.693600E-03,1.779500E-02,3.972000E-02,&
     & 6.597300E-02,8.803300E-02,8.702000E-02,3.258791E-01,8.773100E+00,&
     & 2.267100E+01,3.565800E+01,5.860400E+01,1.061400E+02,2.083000E+02,&
     & 4.701300E+02,1.361500E+03,8.944200E+03,2.804700E+04,3.854900E+04,&
     & 5.170200E+04,7.074900E+04,1.034289E+05,7.677000E+00,1.983800E+01,&
     & 3.120100E+01,5.127900E+01,9.287200E+01,1.822700E+02,4.113600E+02,&
     & 1.191300E+03,7.826200E+03,2.454000E+04,3.372800E+04,4.523700E+04,&
     & 6.190100E+04,9.050297E+04,6.580500E+00,1.700400E+01,2.674400E+01,&
     & 4.395600E+01,7.961600E+01,1.562300E+02,3.525900E+02,1.021100E+03,&
     & 6.707900E+03,2.103400E+04,2.890900E+04,3.877200E+04,5.305900E+04,&
     & 7.757218E+04,5.484300E+00,1.417000E+01,2.228800E+01,3.663100E+01,&
     & 6.634300E+01,1.301900E+02,2.938400E+02,8.509300E+02,5.590100E+03,&
     & 1.752900E+04,2.409100E+04,3.231100E+04,4.422100E+04,6.464784E+04,&
     & 4.388300E+00,1.133700E+01,1.783100E+01,2.930600E+01,5.307600E+01,&
     & 1.041600E+02,2.350600E+02,6.807200E+02,4.472000E+03,1.402300E+04,&
     & 1.927300E+04,2.584800E+04,3.537500E+04,5.171704E+04,3.292100E+00,&
     & 8.504200E+00,1.337400E+01,2.198200E+01,3.980700E+01,7.812000E+01,&
     & 1.763000E+02,5.105600E+02,3.353900E+03,1.051700E+04,1.445500E+04,&
     & 1.938600E+04,2.652900E+04,3.878540E+04,2.195900E+00,5.671100E+00,&
     & 8.916500E+00,1.465700E+01,2.653800E+01,5.208600E+01,1.175400E+02,&
     & 3.403500E+02,2.236000E+03,7.011500E+03,9.635800E+03,1.292500E+04,&
     & 1.768700E+04,2.585730E+04,1.099400E+00,2.838100E+00,4.459300E+00,&
     & 7.332100E+00,1.327100E+01,2.604700E+01,5.876500E+01,1.701800E+02,&
     & 1.118000E+03,3.505800E+03,4.818200E+03,6.462300E+03,8.843800E+03,&
     & 1.292782E+04,2.942100E-04,5.556700E-04,9.395000E-04,1.303700E-03,&
     & 1.786300E-03,2.942600E-03,5.154500E-03,9.291800E-03,2.147400E-02,&
     & 4.179400E-02,7.995900E-02,1.052800E-01,2.213500E-01,7.334687E-01/
      data   absa(:,541:560) /                                          &
     & 4.193600E+00,1.445100E+01,3.016800E+01,4.689700E+01,8.592400E+01,&
     & 1.676800E+02,3.857300E+02,1.209600E+03,8.528400E+03,2.953300E+04,&
     & 4.248600E+04,5.918100E+04,8.438900E+04,1.295418E+05,3.669500E+00,&
     & 1.264400E+01,2.639900E+01,4.103600E+01,7.519000E+01,1.467200E+02,&
     & 3.375300E+02,1.058400E+03,7.462200E+03,2.584100E+04,3.717500E+04,&
     & 5.178400E+04,7.384100E+04,1.133434E+05,3.145600E+00,1.083800E+01,&
     & 2.262700E+01,3.517300E+01,6.444600E+01,1.257600E+02,2.893200E+02,&
     & 9.071700E+02,6.396200E+03,2.215000E+04,3.186400E+04,4.438500E+04,&
     & 6.329200E+04,9.715731E+04,2.621700E+00,9.032100E+00,1.885500E+01,&
     & 2.931100E+01,5.370500E+01,1.048000E+02,2.411000E+02,7.559900E+02,&
     & 5.330200E+03,1.845700E+04,2.655200E+04,3.698600E+04,5.274100E+04,&
     & 8.095976E+04,2.097600E+00,7.225900E+00,1.508500E+01,2.344900E+01,&
     & 4.296400E+01,8.383600E+01,1.928700E+02,6.047800E+02,4.264300E+03,&
     & 1.476600E+04,2.124200E+04,2.959000E+04,4.219300E+04,6.476339E+04,&
     & 1.573500E+00,5.419700E+00,1.131400E+01,1.758600E+01,3.222200E+01,&
     & 6.287400E+01,1.446500E+02,4.535900E+02,3.198100E+03,1.107500E+04,&
     & 1.593200E+04,2.219200E+04,3.164600E+04,4.857752E+04,1.049500E+00,&
     & 3.613300E+00,7.542500E+00,1.172400E+01,2.148200E+01,4.191800E+01,&
     & 9.643500E+01,3.024000E+02,2.132100E+03,7.383300E+03,1.062100E+04,&
     & 1.479500E+04,2.109700E+04,3.238293E+04,5.252700E-01,1.807000E+00,&
     & 3.771500E+00,5.862600E+00,1.074200E+01,2.096000E+01,4.822000E+01,&
     & 1.511900E+02,1.066000E+03,3.691700E+03,5.310600E+03,7.397600E+03,&
     & 1.054800E+04,1.619077E+04,1.180800E-04,2.793200E-04,4.152400E-04,&
     & 5.340400E-04,9.365000E-04,1.990000E-03,2.412700E-03,3.144700E-03,&
     & 6.430400E-03,1.509800E-03,2.405300E-04,6.347200E-05,3.597700E-05,&
     & 2.086530E-05,5.039800E+00,1.609700E+01,3.008200E+01,4.751000E+01,&
     & 8.801100E+01,1.722500E+02,3.971300E+02,1.209500E+03,8.579500E+03,&
     & 2.955800E+04,4.253600E+04,5.904200E+04,8.281000E+04,1.263573E+05,&
     & 4.410100E+00,1.408500E+01,2.632100E+01,4.156900E+01,7.700900E+01,&
     & 1.507200E+02,3.474800E+02,1.058300E+03,7.507200E+03,2.586500E+04,&
     & 3.722100E+04,5.166100E+04,7.246200E+04,1.105595E+05,3.780400E+00,&
     & 1.207300E+01,2.256200E+01,3.563100E+01,6.601000E+01,1.291900E+02,&
     & 2.978400E+02,9.071100E+02,6.434800E+03,2.216900E+04,3.190300E+04,&
     & 4.428200E+04,6.210700E+04,9.476038E+04,3.150600E+00,1.006100E+01,&
     & 1.880000E+01,2.969500E+01,5.501200E+01,1.076700E+02,2.482100E+02,&
     & 7.559700E+02,5.362300E+03,1.847500E+04,2.658500E+04,3.690100E+04,&
     & 5.175500E+04,7.897079E+04,2.520900E+00,8.048900E+00,1.504000E+01,&
     & 2.375600E+01,4.400900E+01,8.613200E+01,1.985600E+02,6.047400E+02,&
     & 4.290000E+03,1.477900E+04,2.126800E+04,2.952100E+04,4.140400E+04,&
     & 6.317707E+04,1.891200E+00,6.037200E+00,1.128000E+01,1.781700E+01,&
     & 3.300800E+01,6.460100E+01,1.489300E+02,4.535500E+02,3.217300E+03,&
     & 1.108500E+04,1.595100E+04,2.214100E+04,3.105500E+04,4.738077E+04,&
     & 1.261400E+00,4.025300E+00,7.520300E+00,1.187800E+01,2.200400E+01,&
     & 4.306400E+01,9.928200E+01,3.023800E+02,2.144900E+03,7.390000E+03,&
     & 1.063400E+04,1.476000E+04,2.070300E+04,3.158630E+04,6.313600E-01,&
     & 2.013700E+00,3.760400E+00,5.939600E+00,1.100300E+01,2.153400E+01,&
     & 4.964100E+01,1.511900E+02,1.072500E+03,3.694900E+03,5.316900E+03,&
     & 7.380200E+03,1.035100E+04,1.579428E+04,1.551900E-04,3.279900E-04,&
     & 5.189700E-04,7.058500E-04,1.045300E-03,2.211500E-03,3.870600E-03,&
     & 4.916300E-03,8.802200E-03,1.253300E-02,2.360400E-02,8.209300E-03,&
     & 2.820100E-02,1.144104E-02,5.903000E+00,1.756400E+01,3.009800E+01,&
     & 4.859900E+01,9.016500E+01,1.771000E+02,4.102900E+02,1.216100E+03,&
     & 8.610100E+03,2.954000E+04,4.234200E+04,5.866100E+04,8.117500E+04,&
     & 1.238301E+05,5.165500E+00,1.536900E+01,2.633600E+01,4.252500E+01,&
     & 7.889300E+01,1.549700E+02,3.590000E+02,1.064100E+03,7.533800E+03,&
     & 2.584400E+04,3.704700E+04,5.132800E+04,7.102800E+04,1.083537E+05/
      data   absa(:,561:580) /                                          &
     & 4.427800E+00,1.317300E+01,2.257400E+01,3.645000E+01,6.762300E+01,&
     & 1.328300E+02,3.077100E+02,9.120800E+02,6.457500E+03,2.215500E+04,&
     & 3.175700E+04,4.399700E+04,6.087800E+04,9.287449E+04,3.690300E+00,&
     & 1.097800E+01,1.881200E+01,3.037500E+01,5.635000E+01,1.106900E+02,&
     & 2.564400E+02,7.600600E+02,5.381300E+03,1.846300E+04,2.646700E+04,&
     & 3.666300E+04,5.073300E+04,7.739524E+04,2.952700E+00,8.782600E+00,&
     & 1.504900E+01,2.429900E+01,4.508000E+01,8.854900E+01,2.051400E+02,&
     & 6.080400E+02,4.305000E+03,1.476900E+04,2.117200E+04,2.933100E+04,&
     & 4.058500E+04,6.191586E+04,2.215200E+00,6.587600E+00,1.128700E+01,&
     & 1.822600E+01,3.381100E+01,6.641300E+01,1.538600E+02,4.560300E+02,&
     & 3.228800E+03,1.107700E+04,1.587900E+04,2.199800E+04,3.044000E+04,&
     & 4.643573E+04,1.477400E+00,4.392500E+00,7.525300E+00,1.215200E+01,&
     & 2.254200E+01,4.428100E+01,1.025700E+02,3.040100E+02,2.152500E+03,&
     & 7.385100E+03,1.058500E+04,1.466500E+04,2.029300E+04,3.095930E+04,&
     & 7.395000E-01,2.197500E+00,3.763400E+00,6.077400E+00,1.127300E+01,&
     & 2.214400E+01,5.128800E+01,1.520100E+02,1.076300E+03,3.692400E+03,&
     & 5.292500E+03,7.332400E+03,1.014700E+04,1.547888E+04,1.928300E-04,&
     & 4.078000E-04,6.349000E-04,8.659900E-04,1.263200E-03,2.408700E-03,&
     & 4.769500E-03,6.886500E-03,1.702500E-02,1.741000E-02,1.501800E-02,&
     & 2.984300E-02,3.814000E-02,1.142958E-01,6.759800E+00,1.877100E+01,&
     & 3.048800E+01,5.012200E+01,9.229400E+01,1.820100E+02,4.234400E+02,&
     & 1.232800E+03,8.626700E+03,2.933800E+04,4.204800E+04,5.814500E+04,&
     & 7.940900E+04,1.217975E+05,5.915100E+00,1.642600E+01,2.667700E+01,&
     & 4.385600E+01,8.075900E+01,1.592600E+02,3.705000E+02,1.078700E+03,&
     & 7.548100E+03,2.567000E+04,3.679200E+04,5.087400E+04,6.947600E+04,&
     & 1.065747E+05,5.070600E+00,1.407900E+01,2.286700E+01,3.759100E+01,&
     & 6.921800E+01,1.365100E+02,3.175600E+02,9.245800E+02,6.470100E+03,&
     & 2.200400E+04,3.153700E+04,4.360800E+04,5.955400E+04,9.135255E+04,&
     & 4.226000E+00,1.173300E+01,1.905600E+01,3.132800E+01,5.768300E+01,&
     & 1.137600E+02,2.646300E+02,7.705000E+02,5.391600E+03,1.833600E+04,&
     & 2.628100E+04,3.634200E+04,4.962600E+04,7.611850E+04,3.381500E+00,&
     & 9.386800E+00,1.524500E+01,2.506300E+01,4.614600E+01,9.100700E+01,&
     & 2.117000E+02,6.163700E+02,4.313200E+03,1.466900E+04,2.102400E+04,&
     & 2.907200E+04,3.970000E+04,6.089966E+04,2.536800E+00,7.040900E+00,&
     & 1.143400E+01,1.879800E+01,3.460900E+01,6.825700E+01,1.587800E+02,&
     & 4.623000E+02,3.235100E+03,1.100200E+04,1.576700E+04,2.180400E+04,&
     & 2.977700E+04,4.567310E+04,1.691900E+00,4.695400E+00,7.623300E+00,&
     & 1.253400E+01,2.307500E+01,4.551200E+01,1.058600E+02,3.081900E+02,&
     & 2.156700E+03,7.334600E+03,1.051200E+04,1.453600E+04,1.985000E+04,&
     & 3.044945E+04,8.470600E-01,2.349500E+00,3.812200E+00,6.269700E+00,&
     & 1.153900E+01,2.275800E+01,5.293200E+01,1.541000E+02,1.078300E+03,&
     & 3.667100E+03,5.256000E+03,7.267800E+03,9.925400E+03,1.522396E+04,&
     & 2.347900E-04,5.023000E-04,7.330400E-04,1.005300E-03,1.590100E-03,&
     & 2.687200E-03,4.970600E-03,9.461300E-03,2.022300E-02,4.500900E-02,&
     & 5.380700E-02,5.782100E-02,1.057300E-01,2.666732E-01,7.616000E+00,&
     & 1.969400E+01,3.113900E+01,5.221500E+01,9.451500E+01,1.870300E+02,&
     & 4.361500E+02,1.260100E+03,8.622900E+03,2.907300E+04,4.166200E+04,&
     & 5.744700E+04,7.767000E+04,1.199791E+05,6.664500E+00,1.723200E+01,&
     & 2.724700E+01,4.568900E+01,8.269900E+01,1.636600E+02,3.816500E+02,&
     & 1.102600E+03,7.545100E+03,2.544000E+04,3.645700E+04,5.026600E+04,&
     & 6.795900E+04,1.049819E+05,5.713000E+00,1.477100E+01,2.335500E+01,&
     & 3.916400E+01,7.089100E+01,1.402900E+02,3.271300E+02,9.450500E+02,&
     & 6.466900E+03,2.180600E+04,3.124800E+04,4.308600E+04,5.825100E+04,&
     & 8.997914E+04,4.761500E+00,1.231000E+01,1.946300E+01,3.263800E+01,&
     & 5.907500E+01,1.169000E+02,2.726000E+02,7.875500E+02,5.389200E+03,&
     & 1.817100E+04,2.604000E+04,3.590500E+04,4.854500E+04,7.498823E+04/
      data   absa(:,581:585) /                                          &
     & 3.810000E+00,9.848900E+00,1.557000E+01,2.611100E+01,4.726000E+01,&
     & 9.352900E+01,2.180800E+02,6.300400E+02,4.311400E+03,1.453700E+04,&
     & 2.083300E+04,2.872200E+04,3.883600E+04,5.999383E+04,2.858300E+00,&
     & 7.387500E+00,1.167800E+01,1.958600E+01,3.544500E+01,7.014400E+01,&
     & 1.635600E+02,4.725400E+02,3.233500E+03,1.090300E+04,1.562300E+04,&
     & 2.154200E+04,2.912700E+04,4.499500E+04,1.906600E+00,4.926400E+00,&
     & 7.785900E+00,1.306000E+01,2.363100E+01,4.676900E+01,1.090400E+02,&
     & 3.150100E+02,2.155800E+03,7.268400E+03,1.041600E+04,1.436100E+04,&
     & 1.941700E+04,2.999583E+04,9.547200E-01,2.465600E+00,3.894000E+00,&
     & 6.533400E+00,1.181800E+01,2.339000E+01,5.452300E+01,1.575100E+02,&
     & 1.077900E+03,3.634400E+03,5.208200E+03,7.180800E+03,9.708100E+03,&
     & 1.499734E+04,2.903400E-04,5.510200E-04,8.657300E-04,1.231300E-03,&
     & 1.928300E-03,2.943000E-03,5.661700E-03,1.028300E-02,2.384100E-02,&
     & 5.072500E-02,6.831800E-02,1.151000E-01,2.232200E-01,6.194796E-01/

! --- the array absb(NG04,1175) = kb(NG04,5,5,13:59) contains absorption
!     coefs at the NG04=14 g-intervals for a range of pressure levels <
!     ~100mb, temperatures, and ratios of h2o to co2. the first index in
!     the array, js, runs from 1 to 5, and corresponds to different gas
!     amount ratios, as expressed through the binary species parameter
!     eta, defined as eta = gas1/(gas1+rat*gas2), where rat is the ratio
!     of the reference mls column amount value of gas1 to that of gas2.
!     the second index, jt, which runs from 1 to 5, corresponds to
!     different temperatures.  more specifically, jt = 1-5 means that
!     the data are for the corresponding temperature of tref-30, tref-15,
!     tref, tref+15, and tref+30, respectively.  the third index, jp,
!     runs from 13 to 59 and refers to the reference pressure level (e.g.
!     jp = 13 is for a pressure of 95.5835 mb). the fourth index, ig,
!     goes from 1 to NG04=14, and tells us which g-interval the absorption
!     coefficients are for.

      data   absb(:,  1: 20) /                                          &
     & 1.928300E+01,6.652900E+01,1.388600E+02,2.158600E+02,3.954900E+02,&
     & 7.718000E+02,1.775500E+03,5.567400E+03,3.925500E+04,1.359400E+05,&
     & 1.955600E+05,2.724000E+05,3.884300E+05,5.962588E+05,1.453300E+01,&
     & 4.998500E+01,1.042400E+02,1.619900E+02,2.967200E+02,5.789600E+02,&
     & 1.331700E+03,4.175700E+03,2.944100E+04,1.019500E+05,1.466700E+05,&
     & 2.043000E+05,2.913200E+05,4.471985E+05,9.776500E+00,3.344600E+01,&
     & 6.961800E+01,1.081100E+02,1.979400E+02,3.861100E+02,8.879600E+02,&
     & 2.783900E+03,1.962800E+04,6.796900E+04,9.778000E+04,1.362000E+05,&
     & 1.942200E+05,2.981309E+05,4.998600E+00,1.692300E+01,3.499800E+01,&
     & 5.424500E+01,9.916000E+01,1.932700E+02,4.442100E+02,1.392200E+03,&
     & 9.814100E+03,3.398500E+04,4.889000E+04,6.810100E+04,9.710900E+04,&
     & 1.490676E+05,1.256200E-02,3.591400E-02,6.890800E-02,1.210500E-01,&
     & 2.110100E-01,3.628900E-01,6.597200E-01,1.182700E+00,2.165000E+00,&
     & 3.362700E+00,3.829300E+00,4.416100E+00,5.411100E+00,7.238214E+00,&
     & 2.318700E+01,7.409500E+01,1.384700E+02,2.186900E+02,4.051000E+02,&
     & 7.928500E+02,1.827900E+03,5.567200E+03,3.949000E+04,1.360500E+05,&
     & 1.957900E+05,2.717600E+05,3.811600E+05,5.815845E+05,1.746100E+01,&
     & 5.566100E+01,1.039400E+02,1.641000E+02,3.039300E+02,5.947400E+02,&
     & 1.371000E+03,4.175500E+03,2.961800E+04,1.020400E+05,1.468400E+05,&
     & 2.038200E+05,2.858700E+05,4.361926E+05,1.173400E+01,3.722600E+01,&
     & 6.942300E+01,1.095200E+02,2.027500E+02,3.966400E+02,9.141800E+02,&
     & 2.783800E+03,1.974500E+04,6.802600E+04,9.789400E+04,1.358800E+05,&
     & 1.905800E+05,2.907938E+05,5.986000E+00,1.880400E+01,3.490500E+01,&
     & 5.494000E+01,1.015700E+02,1.985300E+02,4.573100E+02,1.392200E+03,&
     & 9.873000E+03,3.401300E+04,4.894700E+04,6.794200E+04,9.529100E+04,&
     & 1.454015E+05,1.462200E-02,3.995800E-02,7.358400E-02,1.261800E-01,&
     & 2.180500E-01,3.729800E-01,6.617300E-01,1.178000E+00,2.132100E+00,&
     & 3.252800E+00,3.647700E+00,4.284000E+00,5.102100E+00,6.980493E+00,&
     & 2.716900E+01,8.084000E+01,1.385400E+02,2.237000E+02,4.150200E+02,&
     & 8.151800E+02,1.888500E+03,5.597400E+03,3.963100E+04,1.359700E+05,&
     & 1.948900E+05,2.700100E+05,3.736400E+05,5.699718E+05,2.044700E+01,&
     & 6.072000E+01,1.040000E+02,1.678600E+02,3.113600E+02,6.114900E+02,&
     & 1.416500E+03,4.198100E+03,2.972300E+04,1.019800E+05,1.461700E+05,&
     & 2.025100E+05,2.802300E+05,4.274793E+05,1.372400E+01,4.059800E+01,&
     & 6.946100E+01,1.120200E+02,2.077000E+02,4.078000E+02,9.444600E+02,&
     & 2.798900E+03,1.981600E+04,6.798400E+04,9.744700E+04,1.350100E+05,&
     & 1.868200E+05,2.849894E+05,6.989700E+00,2.048400E+01,3.492400E+01,&
     & 5.619000E+01,1.040500E+02,2.041100E+02,4.724400E+02,1.399700E+03,&
     & 9.908100E+03,3.399200E+04,4.872400E+04,6.750300E+04,9.341000E+04,&
     & 1.424925E+05,1.675500E-02,4.388100E-02,7.813700E-02,1.311800E-01,&
     & 2.240600E-01,3.812100E-01,6.657700E-01,1.171400E+00,2.080300E+00,&
     & 3.181400E+00,3.624000E+00,4.117300E+00,4.897400E+00,6.466703E+00,&
     & 3.111400E+01,8.639600E+01,1.403400E+02,2.307000E+02,4.248100E+02,&
     & 8.377600E+02,1.949000E+03,5.674300E+03,3.970700E+04,1.350400E+05,&
     & 1.935400E+05,2.676300E+05,3.655100E+05,5.605972E+05,2.340500E+01,&
     & 6.488800E+01,1.053400E+02,1.731200E+02,3.187100E+02,6.284200E+02,&
     & 1.461900E+03,4.255800E+03,2.978100E+04,1.012800E+05,1.451500E+05,&
     & 2.007300E+05,2.741300E+05,4.204469E+05,1.569500E+01,4.337800E+01,&
     & 7.035400E+01,1.155300E+02,2.126100E+02,4.190800E+02,9.747200E+02,&
     & 2.837400E+03,1.985400E+04,6.752000E+04,9.677000E+04,1.338200E+05,&
     & 1.827600E+05,2.803036E+05,7.980300E+00,2.186700E+01,3.536800E+01,&
     & 5.794700E+01,1.065100E+02,2.097400E+02,4.875700E+02,1.418900E+03,&
     & 9.927200E+03,3.376000E+04,4.838500E+04,6.690900E+04,9.137800E+04,&
     & 1.401529E+05,1.893200E-02,4.756300E-02,8.283500E-02,1.363000E-01,&
     & 2.293400E-01,3.873400E-01,6.709000E-01,1.161200E+00,2.058700E+00,&
     & 3.051500E+00,3.425300E+00,3.933600E+00,4.493400E+00,5.940876E+00/
      data   absb(:, 21: 40) /                                          &
     & 3.505600E+01,9.064200E+01,1.433300E+02,2.403400E+02,4.350400E+02,&
     & 8.608700E+02,2.007500E+03,5.799900E+03,3.969000E+04,1.338200E+05,&
     & 1.917600E+05,2.644200E+05,3.575000E+05,5.522459E+05,2.636000E+01,&
     & 6.807300E+01,1.075900E+02,1.803400E+02,3.263800E+02,6.457500E+02,&
     & 1.505800E+03,4.350000E+03,2.976800E+04,1.003700E+05,1.438200E+05,&
     & 1.983100E+05,2.681300E+05,4.141815E+05,1.766400E+01,4.550300E+01,&
     & 7.185300E+01,1.203500E+02,2.177200E+02,4.306300E+02,1.004000E+03,&
     & 2.900200E+03,1.984500E+04,6.691000E+04,9.588200E+04,1.322100E+05,&
     & 1.787500E+05,2.761244E+05,8.965900E+00,2.293100E+01,3.611600E+01,&
     & 6.035200E+01,1.090700E+02,2.155100E+02,5.022000E+02,1.450300E+03,&
     & 9.922900E+03,3.345600E+04,4.794200E+04,6.610500E+04,8.937700E+04,&
     & 1.380644E+05,2.107100E-02,5.118800E-02,8.750000E-02,1.408000E-01,&
     & 2.345300E-01,3.923000E-01,6.719300E-01,1.156600E+00,2.035100E+00,&
     & 3.030300E+00,3.396500E+00,3.696100E+00,3.977300E+00,4.929203E+00,&
     & 1.018000E+01,3.498700E+01,7.176500E+01,1.126300E+02,2.097900E+02,&
     & 4.139500E+02,9.759400E+02,3.007200E+03,2.239100E+04,8.367200E+04,&
     & 1.253200E+05,1.811300E+05,2.552500E+05,4.044888E+05,7.705200E+00,&
     & 2.632700E+01,5.391800E+01,8.456700E+01,1.574300E+02,3.105600E+02,&
     & 7.320600E+02,2.255500E+03,1.679300E+04,6.275400E+04,9.399000E+04,&
     & 1.358500E+05,1.914300E+05,3.033643E+05,5.217500E+00,1.767800E+01,&
     & 3.607300E+01,5.650200E+01,1.050800E+02,2.071800E+02,4.881900E+02,&
     & 1.503800E+03,1.119600E+04,4.183600E+04,6.266000E+04,9.056500E+04,&
     & 1.276200E+05,2.022396E+05,2.705900E+00,9.044400E+00,1.822800E+01,&
     & 2.844400E+01,5.273600E+01,1.038000E+02,2.443200E+02,7.521100E+02,&
     & 5.598100E+03,2.091800E+04,3.133000E+04,4.528300E+04,6.381100E+04,&
     & 1.011223E+05,1.072500E-02,3.102500E-02,5.986700E-02,1.063800E-01,&
     & 1.884200E-01,3.338100E-01,6.312100E-01,1.187300E+00,2.295800E+00,&
     & 3.622000E+00,4.213200E+00,4.845400E+00,5.807100E+00,8.025787E+00,&
     & 1.221600E+01,3.893400E+01,7.156700E+01,1.146500E+02,2.150200E+02,&
     & 4.253900E+02,1.008700E+03,3.026000E+03,2.248300E+04,8.335500E+04,&
     & 1.249000E+05,1.803000E+05,2.509600E+05,3.983428E+05,9.233200E+00,&
     & 2.928800E+01,5.377100E+01,8.607200E+01,1.613600E+02,3.191500E+02,&
     & 7.566100E+02,2.269600E+03,1.686200E+04,6.251600E+04,9.367500E+04,&
     & 1.352300E+05,1.882200E+05,2.987573E+05,6.242000E+00,1.964800E+01,&
     & 3.597700E+01,5.750000E+01,1.077000E+02,2.129000E+02,5.045500E+02,&
     & 1.513200E+03,1.124100E+04,4.167700E+04,6.245000E+04,9.015000E+04,&
     & 1.254800E+05,1.991675E+05,3.223500E+00,1.002300E+01,1.818300E+01,&
     & 2.894100E+01,5.404600E+01,1.066600E+02,2.524900E+02,7.568300E+02,&
     & 5.620900E+03,2.083900E+04,3.122500E+04,4.507500E+04,6.274000E+04,&
     & 9.958385E+04,1.247200E-02,3.445900E-02,6.394700E-02,1.110800E-01,&
     & 1.948600E-01,3.416900E-01,6.350200E-01,1.177800E+00,2.264600E+00,&
     & 3.545400E+00,4.091400E+00,4.687300E+00,5.610200E+00,7.782940E+00,&
     & 1.425800E+01,4.239900E+01,7.190200E+01,1.179600E+02,2.203000E+02,&
     & 4.372300E+02,1.041500E+03,3.073900E+03,2.251700E+04,8.292400E+04,&
     & 1.240000E+05,1.785600E+05,2.468500E+05,3.934487E+05,1.076400E+01,&
     & 3.188800E+01,5.402100E+01,8.856000E+01,1.653200E+02,3.280300E+02,&
     & 7.812400E+02,2.305500E+03,1.688800E+04,6.219300E+04,9.300300E+04,&
     & 1.339200E+05,1.851400E+05,2.950900E+05,7.267300E+00,2.137600E+01,&
     & 3.614100E+01,5.916100E+01,1.103400E+02,2.188200E+02,5.209600E+02,&
     & 1.537100E+03,1.125900E+04,4.146200E+04,6.200100E+04,8.927900E+04,&
     & 1.234300E+05,1.967230E+05,3.743400E+00,1.088100E+01,1.826600E+01,&
     & 2.976800E+01,5.536500E+01,1.096200E+02,2.606900E+02,7.688000E+02,&
     & 5.629600E+03,2.073100E+04,3.100100E+04,4.464000E+04,6.171300E+04,&
     & 9.836265E+04,1.427100E-02,3.778600E-02,6.816000E-02,1.155000E-01,&
     & 2.005000E-01,3.494700E-01,6.371000E-01,1.175900E+00,2.216400E+00,&
     & 3.432800E+00,4.012600E+00,4.621000E+00,5.404800E+00,7.328372E+00/
      data   absb(:, 41: 60) /                                          &
     & 1.629700E+01,4.514100E+01,7.310100E+01,1.224800E+02,2.260000E+02,&
     & 4.492700E+02,1.074400E+03,3.153400E+03,2.251100E+04,8.218900E+04,&
     & 1.226200E+05,1.766100E+05,2.425300E+05,3.892921E+05,1.229200E+01,&
     & 3.394600E+01,5.491900E+01,9.195000E+01,1.696000E+02,3.370500E+02,&
     & 8.058900E+02,2.365100E+03,1.688300E+04,6.164100E+04,9.196300E+04,&
     & 1.324600E+05,1.819000E+05,2.919673E+05,8.286700E+00,2.274900E+01,&
     & 3.673900E+01,6.142100E+01,1.132000E+02,2.248300E+02,5.373900E+02,&
     & 1.576900E+03,1.125600E+04,4.109400E+04,6.130900E+04,8.830300E+04,&
     & 1.212600E+05,1.946425E+05,4.259700E+00,1.155900E+01,1.856900E+01,&
     & 3.089600E+01,5.680200E+01,1.126100E+02,2.689000E+02,7.886800E+02,&
     & 5.628100E+03,2.054700E+04,3.065400E+04,4.415200E+04,6.063200E+04,&
     & 9.732266E+04,1.603500E-02,4.103700E-02,7.213800E-02,1.202100E-01,&
     & 2.056200E-01,3.556700E-01,6.400400E-01,1.168600E+00,2.169200E+00,&
     & 3.392200E+00,3.828800E+00,4.450600E+00,5.255700E+00,6.923169E+00,&
     & 1.833700E+01,4.719300E+01,7.481300E+01,1.281600E+02,2.327200E+02,&
     & 4.619500E+02,1.105400E+03,3.260100E+03,2.247000E+04,8.120500E+04,&
     & 1.209900E+05,1.741400E+05,2.384500E+05,3.853827E+05,1.382200E+01,&
     & 3.548500E+01,5.620200E+01,9.621100E+01,1.746400E+02,3.465600E+02,&
     & 8.291300E+02,2.445100E+03,1.685300E+04,6.090400E+04,9.074500E+04,&
     & 1.306000E+05,1.788400E+05,2.890368E+05,9.306100E+00,2.377500E+01,&
     & 3.759300E+01,6.426000E+01,1.165700E+02,2.311700E+02,5.528800E+02,&
     & 1.630200E+03,1.123500E+04,4.060200E+04,6.049600E+04,8.706900E+04,&
     & 1.192200E+05,1.926913E+05,4.774200E+00,1.207100E+01,1.899200E+01,&
     & 3.231200E+01,5.848800E+01,1.157800E+02,2.766400E+02,8.153600E+02,&
     & 5.617800E+03,2.030100E+04,3.024800E+04,4.353500E+04,5.961200E+04,&
     & 9.634478E+04,1.777700E-02,4.397000E-02,7.629900E-02,1.248500E-01,&
     & 2.102400E-01,3.606500E-01,6.412200E-01,1.158800E+00,2.148800E+00,&
     & 3.242500E+00,3.649400E+00,4.323100E+00,4.904400E+00,6.348546E+00,&
     & 5.484300E+00,1.879700E+01,3.776200E+01,5.985400E+01,1.129900E+02,&
     & 2.258500E+02,5.447800E+02,1.668100E+03,1.280600E+04,5.115000E+04,&
     & 8.014600E+04,1.208500E+05,1.726200E+05,2.845387E+05,4.181400E+00,&
     & 1.418600E+01,2.841800E+01,4.498400E+01,8.484200E+01,1.694900E+02,&
     & 4.087000E+02,1.251200E+03,9.604600E+03,3.836300E+04,6.011000E+04,&
     & 9.063500E+04,1.294700E+05,2.134083E+05,2.858300E+00,9.590500E+00,&
     & 1.907300E+01,3.011900E+01,5.669200E+01,1.131300E+02,2.726200E+02,&
     & 8.342800E+02,6.403300E+03,2.557600E+04,4.007400E+04,6.042400E+04,&
     & 8.631300E+04,1.422709E+05,1.512200E+00,4.991600E+00,9.732300E+00,&
     & 1.527400E+01,2.854400E+01,5.677000E+01,1.365400E+02,4.173700E+02,&
     & 3.201900E+03,1.278800E+04,2.003700E+04,3.021300E+04,4.315700E+04,&
     & 7.113734E+04,9.171200E-03,2.674100E-02,5.193700E-02,9.288700E-02,&
     & 1.670600E-01,3.035600E-01,5.952300E-01,1.179600E+00,2.425100E+00,&
     & 3.914500E+00,4.602500E+00,5.347600E+00,6.339700E+00,8.949960E+00,&
     & 6.550900E+00,2.089700E+01,3.772500E+01,6.127100E+01,1.159400E+02,&
     & 2.320100E+02,5.630500E+02,1.695900E+03,1.282800E+04,5.087500E+04,&
     & 7.936500E+04,1.198700E+05,1.702900E+05,2.824115E+05,4.983900E+00,&
     & 1.576100E+01,2.839000E+01,4.604500E+01,8.705000E+01,1.741100E+02,&
     & 4.224000E+02,1.272000E+03,9.620900E+03,3.815700E+04,5.952400E+04,&
     & 8.990300E+04,1.277200E+05,2.118092E+05,3.398100E+00,1.063600E+01,&
     & 1.905700E+01,3.082300E+01,5.816300E+01,1.162100E+02,2.817500E+02,&
     & 8.481800E+02,6.414200E+03,2.543800E+04,3.968300E+04,5.993600E+04,&
     & 8.514600E+04,1.412073E+05,1.787800E+00,5.507500E+00,9.730300E+00,&
     & 1.561900E+01,2.928100E+01,5.831100E+01,1.411000E+02,4.243200E+02,&
     & 3.207300E+03,1.271900E+04,1.984200E+04,2.996900E+04,4.257400E+04,&
     & 7.060574E+04,1.065400E-02,2.965800E-02,5.559100E-02,9.712900E-02,&
     & 1.728500E-01,3.109100E-01,6.000300E-01,1.171200E+00,2.396000E+00,&
     & 3.815200E+00,4.501100E+00,5.228500E+00,6.155900E+00,8.672581E+00/
      data   absb(:, 61: 80) /                                          &
     & 7.617200E+00,2.267500E+01,3.804800E+01,6.341200E+01,1.191200E+02,&
     & 2.383900E+02,5.812300E+02,1.743800E+03,1.282600E+04,5.040700E+04,&
     & 7.843700E+04,1.186300E+05,1.677800E+05,2.805805E+05,5.783600E+00,&
     & 1.709300E+01,2.863400E+01,4.765200E+01,8.943900E+01,1.788900E+02,&
     & 4.360300E+02,1.308000E+03,9.619500E+03,3.780600E+04,5.882800E+04,&
     & 8.897600E+04,1.258300E+05,2.104353E+05,3.937100E+00,1.151800E+01,&
     & 1.922100E+01,3.189400E+01,5.975700E+01,1.193900E+02,2.908300E+02,&
     & 8.721400E+02,6.413200E+03,2.520400E+04,3.921900E+04,5.931800E+04,&
     & 8.389100E+04,1.402902E+05,2.062000E+00,5.942400E+00,9.822400E+00,&
     & 1.614400E+01,3.008100E+01,5.989900E+01,1.456300E+02,4.363100E+02,&
     & 3.206900E+03,1.260200E+04,1.961000E+04,2.966000E+04,4.194600E+04,&
     & 7.014730E+04,1.210900E-02,3.247500E-02,5.926300E-02,1.015300E-01,&
     & 1.781600E-01,3.181000E-01,6.018100E-01,1.163000E+00,2.358800E+00,&
     & 3.773300E+00,4.399500E+00,5.091800E+00,5.927500E+00,8.322405E+00,&
     & 8.691900E+00,2.404000E+01,3.878400E+01,6.623400E+01,1.227400E+02,&
     & 2.450200E+02,5.988200E+02,1.805700E+03,1.281800E+04,4.969300E+04,&
     & 7.747100E+04,1.168600E+05,1.656400E+05,2.786715E+05,6.588600E+00,&
     & 1.812100E+01,2.918200E+01,4.976700E+01,9.215900E+01,1.838600E+02,&
     & 4.492200E+02,1.354400E+03,9.613900E+03,3.727000E+04,5.810400E+04,&
     & 8.764900E+04,1.242300E+05,2.090033E+05,4.477600E+00,1.220000E+01,&
     & 1.958500E+01,3.330200E+01,6.157500E+01,1.227000E+02,2.996200E+02,&
     & 9.031100E+02,6.409500E+03,2.484700E+04,3.873600E+04,5.843300E+04,&
     & 8.282400E+04,1.393395E+05,2.337200E+00,6.277300E+00,1.001000E+01,&
     & 1.684200E+01,3.099700E+01,6.154400E+01,1.500200E+02,4.518000E+02,&
     & 3.205000E+03,1.242400E+04,1.936900E+04,2.921700E+04,4.141300E+04,&
     & 6.967070E+04,1.358500E-02,3.515900E-02,6.288300E-02,1.058500E-01,&
     & 1.830600E-01,3.239100E-01,6.032000E-01,1.158400E+00,2.310600E+00,&
     & 3.671700E+00,4.308700E+00,4.990300E+00,5.814200E+00,7.861660E+00,&
     & 9.777000E+00,2.503800E+01,3.980400E+01,6.939200E+01,1.271100E+02,&
     & 2.528900E+02,6.153000E+02,1.872900E+03,1.280800E+04,4.898700E+04,&
     & 7.616700E+04,1.148500E+05,1.636300E+05,2.767524E+05,7.402700E+00,&
     & 1.887000E+01,2.994500E+01,5.213300E+01,9.543400E+01,1.897700E+02,&
     & 4.615800E+02,1.404800E+03,9.606300E+03,3.674000E+04,5.712600E+04,&
     & 8.613900E+04,1.227300E+05,2.075661E+05,5.023100E+00,1.270000E+01,&
     & 2.008900E+01,3.487600E+01,6.376000E+01,1.266400E+02,3.078500E+02,&
     & 9.367100E+02,6.404400E+03,2.449400E+04,3.808400E+04,5.742700E+04,&
     & 8.181900E+04,1.383775E+05,2.613600E+00,6.527000E+00,1.026000E+01,&
     & 1.762500E+01,3.208900E+01,6.352000E+01,1.541300E+02,4.686000E+02,&
     & 3.202500E+03,1.224700E+04,1.904300E+04,2.871400E+04,4.091000E+04,&
     & 6.918991E+04,1.500800E-02,3.763500E-02,6.632600E-02,1.102500E-01,&
     & 1.879300E-01,3.285000E-01,6.049200E-01,1.149000E+00,2.272200E+00,&
     & 3.564700E+00,4.165700E+00,4.785600E+00,5.646600E+00,7.480202E+00,&
     & 3.514300E+00,1.206200E+01,2.366700E+01,3.789800E+01,7.234200E+01,&
     & 1.463500E+02,3.599300E+02,1.112700E+03,8.596700E+03,3.653500E+04,&
     & 5.941200E+04,9.437100E+04,1.394500E+05,2.416643E+05,2.700400E+00,&
     & 9.137400E+00,1.784500E+01,2.852100E+01,5.435300E+01,1.098600E+02,&
     & 2.700600E+02,8.346300E+02,6.447600E+03,2.740100E+04,4.455900E+04,&
     & 7.077900E+04,1.045900E+05,1.811533E+05,1.863200E+00,6.226000E+00,&
     & 1.202400E+01,1.915100E+01,3.636500E+01,7.337200E+01,1.802000E+02,&
     & 5.565700E+02,4.298600E+03,1.826800E+04,2.970600E+04,4.718600E+04,&
     & 6.972400E+04,1.208333E+05,1.000500E+00,3.277800E+00,6.215000E+00,&
     & 9.824600E+00,1.838800E+01,3.689000E+01,9.033200E+01,2.785100E+02,&
     & 2.149600E+03,9.134100E+03,1.485400E+04,2.359300E+04,3.486300E+04,&
     & 6.041815E+04,7.854900E-03,2.301000E-02,4.496100E-02,8.072000E-02,&
     & 1.472100E-01,2.734400E-01,5.549300E-01,1.154400E+00,2.547600E+00,&
     & 4.254200E+00,4.987900E+00,5.919300E+00,7.072500E+00,9.995624E+00/
      data   absb(:, 81:100) /                                          &
     & 4.178200E+00,1.336800E+01,2.371000E+01,3.902400E+01,7.431000E+01,&
     & 1.503100E+02,3.721500E+02,1.145200E+03,8.598700E+03,3.615100E+04,&
     & 5.873700E+04,9.323700E+04,1.379900E+05,2.408642E+05,3.201000E+00,&
     & 1.011400E+01,1.788100E+01,2.936100E+01,5.582700E+01,1.128300E+02,&
     & 2.792200E+02,8.590200E+02,6.449200E+03,2.711400E+04,4.405300E+04,&
     & 6.992800E+04,1.034900E+05,1.806502E+05,2.200800E+00,6.873100E+00,&
     & 1.205300E+01,1.970600E+01,3.734800E+01,7.535600E+01,1.862900E+02,&
     & 5.728400E+02,4.299600E+03,1.807600E+04,2.936900E+04,4.661900E+04,&
     & 6.899600E+04,1.204358E+05,1.175400E+00,3.595500E+00,6.241300E+00,&
     & 1.008800E+01,1.888300E+01,3.788100E+01,9.337200E+01,2.866500E+02,&
     & 2.150100E+03,9.038300E+03,1.468500E+04,2.331000E+04,3.449900E+04,&
     & 6.021795E+04,9.059600E-03,2.551500E-02,4.822700E-02,8.482100E-02,&
     & 1.524100E-01,2.809200E-01,5.585100E-01,1.148900E+00,2.520400E+00,&
     & 4.166600E+00,4.895200E+00,5.777800E+00,6.903900E+00,9.690014E+00,&
     & 4.846100E+00,1.443200E+01,2.398300E+01,4.063000E+01,7.665100E+01,&
     & 1.544400E+02,3.839400E+02,1.185900E+03,8.599900E+03,3.566600E+04,&
     & 5.791300E+04,9.186800E+04,1.366700E+05,2.398944E+05,3.703600E+00,&
     & 1.091100E+01,1.808500E+01,3.056500E+01,5.758800E+01,1.159200E+02,&
     & 2.880600E+02,8.895800E+02,6.450000E+03,2.675000E+04,4.343500E+04,&
     & 6.890100E+04,1.025000E+05,1.799234E+05,2.539500E+00,7.400500E+00,&
     & 1.219300E+01,2.050500E+01,3.852800E+01,7.740700E+01,1.921800E+02,&
     & 5.932100E+02,4.300200E+03,1.783300E+04,2.895700E+04,4.593500E+04,&
     & 6.833600E+04,1.199505E+05,1.349900E+00,3.852300E+00,6.326300E+00,&
     & 1.047200E+01,1.947800E+01,3.890000E+01,9.630800E+01,2.968500E+02,&
     & 2.150400E+03,8.916900E+03,1.447900E+04,2.296800E+04,3.416900E+04,&
     & 5.997526E+04,1.029100E-02,2.787300E-02,5.141800E-02,8.905600E-02,&
     & 1.573900E-01,2.878100E-01,5.603500E-01,1.142300E+00,2.487800E+00,&
     & 4.106300E+00,4.793100E+00,5.621400E+00,6.652600E+00,9.386062E+00,&
     & 5.524100E+00,1.521000E+01,2.454100E+01,4.255900E+01,7.941700E+01,&
     & 1.592200E+02,3.951800E+02,1.231400E+03,8.604300E+03,3.513300E+04,&
     & 5.691200E+04,9.037200E+04,1.353200E+05,2.387935E+05,4.212500E+00,&
     & 1.149800E+01,1.849900E+01,3.201100E+01,5.966500E+01,1.195100E+02,&
     & 2.964900E+02,9.237000E+02,6.453400E+03,2.635000E+04,4.268400E+04,&
     & 6.778000E+04,1.014900E+05,1.790903E+05,2.883300E+00,7.787800E+00,&
     & 1.246800E+01,2.146700E+01,3.991400E+01,7.979700E+01,1.977900E+02,&
     & 6.159600E+02,4.302400E+03,1.756700E+04,2.845600E+04,4.518700E+04,&
     & 6.765900E+04,1.193967E+05,1.526600E+00,4.042700E+00,6.470800E+00,&
     & 1.094300E+01,2.017400E+01,4.009100E+01,9.910600E+01,3.082200E+02,&
     & 2.151500E+03,8.783800E+03,1.422900E+04,2.259400E+04,3.383000E+04,&
     & 5.969941E+04,1.150000E-02,3.009600E-02,5.458700E-02,9.318600E-02,&
     & 1.623700E-01,2.933200E-01,5.626700E-01,1.138000E+00,2.439700E+00,&
     & 4.030900E+00,4.705800E+00,5.510300E+00,6.550600E+00,8.885744E+00,&
     & 6.209500E+00,1.579500E+01,2.524700E+01,4.456400E+01,8.250900E+01,&
     & 1.654800E+02,4.056400E+02,1.279300E+03,8.617600E+03,3.452600E+04,&
     & 5.585800E+04,8.869900E+04,1.340100E+05,2.373299E+05,4.727000E+00,&
     & 1.193800E+01,1.902600E+01,3.351300E+01,6.198400E+01,1.242000E+02,&
     & 3.043300E+02,9.596300E+02,6.463400E+03,2.589400E+04,4.189400E+04,&
     & 6.652500E+04,1.005100E+05,1.779956E+05,3.229700E+00,8.081000E+00,&
     & 1.281500E+01,2.246500E+01,4.146200E+01,8.293000E+01,2.030200E+02,&
     & 6.399100E+02,4.309100E+03,1.726300E+04,2.792900E+04,4.435000E+04,&
     & 6.700800E+04,1.186684E+05,1.703500E+00,4.189700E+00,6.645700E+00,&
     & 1.143200E+01,2.094700E+01,4.166100E+01,1.017100E+02,3.202000E+02,&
     & 2.154800E+03,8.631800E+03,1.396500E+04,2.217600E+04,3.350500E+04,&
     & 5.933359E+04,1.266900E-02,3.212300E-02,5.757800E-02,9.717100E-02,&
     & 1.672900E-01,2.980800E-01,5.647600E-01,1.130700E+00,2.400800E+00,&
     & 3.897800E+00,4.565400E+00,5.347200E+00,6.394600E+00,8.490191E+00/
      data   absb(:,101:120) /                                          &
     & 2.331700E+00,8.034300E+00,1.541100E+01,2.492500E+01,4.791200E+01,&
     & 9.814200E+01,2.459500E+02,7.766100E+02,5.928400E+03,2.641400E+04,&
     & 4.473900E+04,7.473700E+04,1.172800E+05,2.141518E+05,1.808200E+00,&
     & 6.120200E+00,1.165400E+01,1.879200E+01,3.603200E+01,7.370500E+01,&
     & 1.845800E+02,5.825800E+02,4.446400E+03,1.981100E+04,3.355400E+04,&
     & 5.605300E+04,8.796200E+04,1.606154E+05,1.260600E+00,4.205700E+00,&
     & 7.902900E+00,1.267400E+01,2.415600E+01,4.926800E+01,1.232000E+02,&
     & 3.885400E+02,2.964500E+03,1.320700E+04,2.237000E+04,3.736900E+04,&
     & 5.864200E+04,1.070759E+05,6.845100E-01,2.241600E+00,4.129000E+00,&
     & 6.628700E+00,1.231200E+01,2.484000E+01,6.183800E+01,1.945000E+02,&
     & 1.482500E+03,6.603900E+03,1.118500E+04,1.868500E+04,2.932200E+04,&
     & 5.353855E+04,6.663800E-03,1.972200E-02,3.876100E-02,6.997400E-02,&
     & 1.286700E-01,2.442900E-01,5.090500E-01,1.116200E+00,2.654400E+00,&
     & 4.645400E+00,5.425800E+00,6.529600E+00,7.974300E+00,1.122477E+01,&
     & 2.762500E+00,8.855000E+00,1.548300E+01,2.581400E+01,4.939600E+01,&
     & 1.007600E+02,2.541300E+02,8.041500E+02,5.932700E+03,2.606800E+04,&
     & 4.404000E+04,7.367800E+04,1.163500E+05,2.138798E+05,2.133900E+00,&
     & 6.733500E+00,1.171200E+01,1.945400E+01,3.714500E+01,7.566800E+01,&
     & 1.907000E+02,6.032300E+02,4.449700E+03,1.955100E+04,3.303000E+04,&
     & 5.525900E+04,8.726600E+04,1.604089E+05,1.481600E+00,4.611200E+00,&
     & 7.948400E+00,1.310800E+01,2.489800E+01,5.057600E+01,1.272800E+02,&
     & 4.023100E+02,2.966600E+03,1.303400E+04,2.202000E+04,3.684000E+04,&
     & 5.817800E+04,1.069424E+05,7.999400E-01,2.439900E+00,4.165600E+00,&
     & 6.832500E+00,1.268300E+01,2.549300E+01,6.386800E+01,2.013900E+02,&
     & 1.483600E+03,6.517400E+03,1.101100E+04,1.842000E+04,2.909000E+04,&
     & 5.347171E+04,7.683900E-03,2.183300E-02,4.156400E-02,7.390700E-02,&
     & 1.334500E-01,2.518400E-01,5.118500E-01,1.113000E+00,2.630000E+00,&
     & 4.563300E+00,5.331600E+00,6.389900E+00,7.787300E+00,1.089701E+01,&
     & 3.198000E+00,9.502800E+00,1.571500E+01,2.698000E+01,5.121100E+01,&
     & 1.037800E+02,2.618700E+02,8.355400E+02,5.941100E+03,2.568900E+04,&
     & 4.327800E+04,7.246300E+04,1.153400E+05,2.134450E+05,2.463200E+00,&
     & 7.217600E+00,1.188500E+01,2.033000E+01,3.850900E+01,7.792600E+01,&
     & 1.965100E+02,6.267700E+02,4.456000E+03,1.926700E+04,3.245900E+04,&
     & 5.434700E+04,8.650400E+04,1.600874E+05,1.704300E+00,4.929000E+00,&
     & 8.071300E+00,1.368700E+01,2.581200E+01,5.207300E+01,1.311500E+02,&
     & 4.180100E+02,2.970800E+03,1.284500E+04,2.163900E+04,3.623200E+04,&
     & 5.767000E+04,1.067246E+05,9.167100E-01,2.591800E+00,4.245100E+00,&
     & 7.110000E+00,1.313900E+01,2.623500E+01,6.579500E+01,2.092400E+02,&
     & 1.485700E+03,6.422500E+03,1.082000E+04,1.811600E+04,2.883500E+04,&
     & 5.336320E+04,8.713400E-03,2.377100E-02,4.436900E-02,7.782100E-02,&
     & 1.383300E-01,2.582100E-01,5.147400E-01,1.109300E+00,2.599300E+00,&
     & 4.482600E+00,5.225800E+00,6.223400E+00,7.544900E+00,1.057279E+01,&
     & 3.643700E+00,9.968100E+00,1.610900E+01,2.828700E+01,5.324300E+01,&
     & 1.076800E+02,2.692100E+02,8.678700E+02,5.963400E+03,2.520900E+04,&
     & 4.248400E+04,7.117800E+04,1.143200E+05,2.126002E+05,2.799500E+00,&
     & 7.566500E+00,1.217700E+01,2.130700E+01,4.003600E+01,8.084900E+01,&
     & 2.020100E+02,6.510200E+02,4.472700E+03,1.890700E+04,3.186300E+04,&
     & 5.338300E+04,8.573800E+04,1.594510E+05,1.931900E+00,5.159200E+00,&
     & 8.266300E+00,1.433400E+01,2.683000E+01,5.402400E+01,1.348100E+02,&
     & 4.341800E+02,2.982000E+03,1.260500E+04,2.124200E+04,3.558900E+04,&
     & 5.715900E+04,1.063002E+05,1.034900E+00,2.705400E+00,4.353400E+00,&
     & 7.417600E+00,1.364900E+01,2.721100E+01,6.761500E+01,2.173300E+02,&
     & 1.491200E+03,6.302700E+03,1.062200E+04,1.779500E+04,2.858000E+04,&
     & 5.315164E+04,9.701100E-03,2.558700E-02,4.710000E-02,8.156500E-02,&
     & 1.434500E-01,2.633900E-01,5.186500E-01,1.105700E+00,2.555300E+00,&
     & 4.388900E+00,5.130600E+00,6.126200E+00,7.389400E+00,1.007808E+01/
      data   absb(:,121:140) /                                          &
     & 4.094400E+00,1.034100E+01,1.661100E+01,2.963500E+01,5.535900E+01,&
     & 1.126700E+02,2.768800E+02,9.003900E+02,6.003200E+03,2.466100E+04,&
     & 4.161000E+04,6.984600E+04,1.131200E+05,2.114781E+05,3.138800E+00,&
     & 7.846400E+00,1.255100E+01,2.231800E+01,4.162100E+01,8.459900E+01,&
     & 2.077600E+02,6.754100E+02,4.502500E+03,1.849600E+04,3.120800E+04,&
     & 5.238500E+04,8.483800E+04,1.586110E+05,2.160800E+00,5.346400E+00,&
     & 8.512500E+00,1.500500E+01,2.788700E+01,5.652600E+01,1.386500E+02,&
     & 4.504300E+02,3.001800E+03,1.233100E+04,2.080500E+04,3.492300E+04,&
     & 5.655900E+04,1.057398E+05,1.153500E+00,2.799800E+00,4.482500E+00,&
     & 7.740200E+00,1.417400E+01,2.846200E+01,6.953100E+01,2.254500E+02,&
     & 1.501200E+03,6.165800E+03,1.040300E+04,1.746200E+04,2.828000E+04,&
     & 5.287057E+04,1.062100E-02,2.726200E-02,4.959400E-02,8.522200E-02,&
     & 1.483900E-01,2.684100E-01,5.217000E-01,1.099400E+00,2.516700E+00,&
     & 4.258900E+00,4.961100E+00,6.003800E+00,7.224300E+00,9.659371E+00,&
     & 1.586200E+00,5.478400E+00,1.032500E+01,1.683300E+01,3.251700E+01,&
     & 6.732900E+01,1.716400E+02,5.559300E+02,4.169600E+03,1.920800E+04,&
     & 3.380800E+04,5.956100E+04,1.002000E+05,1.954333E+05,1.243600E+00,&
     & 4.206300E+00,7.839000E+00,1.272600E+01,2.448600E+01,5.059400E+01,&
     & 1.288400E+02,4.170600E+02,3.127400E+03,1.440600E+04,2.535600E+04,&
     & 4.467100E+04,7.514800E+04,1.465750E+05,8.748900E-01,2.911800E+00,&
     & 5.361200E+00,8.653300E+00,1.646400E+01,3.386200E+01,8.605000E+01,&
     & 2.781900E+02,2.085100E+03,9.604400E+03,1.690400E+04,2.978100E+04,&
     & 5.009900E+04,9.771736E+04,4.798600E-01,1.570700E+00,2.829400E+00,&
     & 4.613200E+00,8.525500E+00,1.716200E+01,4.326600E+01,1.393300E+02,&
     & 1.042800E+03,4.802500E+03,8.452600E+03,1.489100E+04,2.505000E+04,&
     & 4.885899E+04,5.635600E-03,1.684300E-02,3.318600E-02,6.056800E-02,&
     & 1.117500E-01,2.167700E-01,4.605500E-01,1.065300E+00,2.738600E+00,&
     & 5.034200E+00,5.958800E+00,7.210600E+00,8.980300E+00,1.267723E+01,&
     & 1.874400E+00,6.000300E+00,1.039800E+01,1.751500E+01,3.370200E+01,&
     & 6.922400E+01,1.771300E+02,5.773100E+02,4.179600E+03,1.892700E+04,&
     & 3.320500E+04,5.857300E+04,9.942300E+04,1.954504E+05,1.462300E+00,&
     & 4.594900E+00,7.898400E+00,1.323400E+01,2.537600E+01,5.200900E+01,&
     & 1.329600E+02,4.330900E+02,3.134800E+03,1.419500E+04,2.490400E+04,&
     & 4.393000E+04,7.456700E+04,1.465908E+05,1.024200E+00,3.167100E+00,&
     & 5.411100E+00,8.983500E+00,1.705600E+01,3.480300E+01,8.879100E+01,&
     & 2.888800E+02,2.090100E+03,9.463600E+03,1.660300E+04,2.928700E+04,&
     & 4.971200E+04,9.772430E+04,5.587400E-01,1.695000E+00,2.867500E+00,&
     & 4.778100E+00,8.810500E+00,1.762700E+01,4.462800E+01,1.446700E+02,&
     & 1.045300E+03,4.732000E+03,8.301900E+03,1.464400E+04,2.485600E+04,&
     & 4.886345E+04,6.491800E-03,1.856800E-02,3.562500E-02,6.413700E-02,&
     & 1.164700E-01,2.237600E-01,4.640500E-01,1.063700E+00,2.718400E+00,&
     & 4.945300E+00,5.855300E+00,7.077200E+00,8.755100E+00,1.233269E+01,&
     & 2.167100E+00,6.404400E+00,1.057100E+01,1.835900E+01,3.505500E+01,&
     & 7.167100E+01,1.823300E+02,5.996200E+02,4.202800E+03,1.857500E+04,&
     & 3.258700E+04,5.751400E+04,9.863500E+04,1.950472E+05,1.684500E+00,&
     & 4.895500E+00,8.029700E+00,1.386600E+01,2.639200E+01,5.384200E+01,&
     & 1.368600E+02,4.498300E+02,3.152200E+03,1.393100E+04,2.444000E+04,&
     & 4.313600E+04,7.397700E+04,1.462864E+05,1.176300E+00,3.361700E+00,&
     & 5.510200E+00,9.394700E+00,1.773600E+01,3.601900E+01,9.138400E+01,&
     & 3.000500E+02,2.101700E+03,9.287500E+03,1.629400E+04,2.875700E+04,&
     & 4.931800E+04,9.752388E+04,6.390500E-01,1.786600E+00,2.933200E+00,&
     & 4.979500E+00,9.146300E+00,1.822300E+01,4.591600E+01,1.502600E+02,&
     & 1.051100E+03,4.644000E+03,8.147300E+03,1.437900E+04,2.466000E+04,&
     & 4.876339E+04,7.334000E-03,2.017000E-02,3.804200E-02,6.756400E-02,&
     & 1.213600E-01,2.298100E-01,4.682500E-01,1.062500E+00,2.688800E+00,&
     & 4.856500E+00,5.740700E+00,6.906700E+00,8.504900E+00,1.198446E+01/
      data   absb(:,141:160) /                                          &
     & 2.466600E+00,6.700000E+00,1.085400E+01,1.926900E+01,3.646600E+01,&
     & 7.492200E+01,1.876500E+02,6.221300E+02,4.242900E+03,1.815100E+04,&
     & 3.189000E+04,5.647400E+04,9.767900E+04,1.943640E+05,1.911700E+00,&
     & 5.116300E+00,8.239500E+00,1.454500E+01,2.745200E+01,5.628300E+01,&
     & 1.408400E+02,4.667200E+02,3.182300E+03,1.361400E+04,2.391700E+04,&
     & 4.235600E+04,7.326000E+04,1.457747E+05,1.331100E+00,3.508700E+00,&
     & 5.652800E+00,9.836500E+00,1.844600E+01,3.764800E+01,9.403200E+01,&
     & 3.113000E+02,2.121700E+03,9.076000E+03,1.594500E+04,2.823800E+04,&
     & 4.884000E+04,9.718198E+04,7.200800E-01,1.860000E+00,3.014000E+00,&
     & 5.190900E+00,9.500800E+00,1.903600E+01,4.722900E+01,1.558900E+02,&
     & 1.061100E+03,4.538300E+03,7.972900E+03,1.411900E+04,2.442100E+04,&
     & 4.859164E+04,8.131200E-03,2.165800E-02,4.032700E-02,7.094100E-02,&
     & 1.262700E-01,2.351600E-01,4.732900E-01,1.059500E+00,2.649100E+00,&
     & 4.761600E+00,5.639600E+00,6.794200E+00,8.308300E+00,1.148729E+01,&
     & 2.771300E+00,6.946700E+00,1.122100E+01,2.018600E+01,3.795500E+01,&
     & 7.860900E+01,1.940500E+02,6.447000E+02,4.297300E+03,1.771500E+04,&
     & 3.115700E+04,5.540300E+04,9.661600E+04,1.932412E+05,2.141800E+00,&
     & 5.301700E+00,8.511100E+00,1.523300E+01,2.856900E+01,5.904800E+01,&
     & 1.456400E+02,4.836400E+02,3.223100E+03,1.328700E+04,2.336800E+04,&
     & 4.155200E+04,7.246200E+04,1.449335E+05,1.486900E+00,3.633900E+00,&
     & 5.833300E+00,1.029100E+01,1.918900E+01,3.949300E+01,9.722700E+01,&
     & 3.225800E+02,2.148900E+03,8.857900E+03,1.557900E+04,2.770200E+04,&
     & 4.830800E+04,9.662259E+04,8.012200E-01,1.924500E+00,3.112400E+00,&
     & 5.411500E+00,9.861900E+00,1.995600E+01,4.882400E+01,1.615200E+02,&
     & 1.074700E+03,4.429200E+03,7.789700E+03,1.385100E+04,2.415500E+04,&
     & 4.831177E+04,8.852500E-03,2.299200E-02,4.241400E-02,7.416000E-02,&
     & 1.310100E-01,2.405500E-01,4.770500E-01,1.055200E+00,2.612400E+00,&
     & 4.638100E+00,5.468500E+00,6.647700E+00,8.125300E+00,1.104807E+01,&
     & 1.061000E+00,3.660700E+00,6.820800E+00,1.120000E+01,2.172700E+01,&
     & 4.535100E+01,1.172500E+02,3.905900E+02,2.875300E+03,1.356100E+04,&
     & 2.464100E+04,4.568900E+04,8.312400E+04,1.754605E+05,8.436000E-01,&
     & 2.839700E+00,5.215300E+00,8.506200E+00,1.639300E+01,3.411100E+01,&
     & 8.804800E+01,2.930600E+02,2.156600E+03,1.017100E+04,1.848100E+04,&
     & 3.426700E+04,6.234300E+04,1.315920E+05,5.980500E-01,1.983200E+00,&
     & 3.595700E+00,5.867000E+00,1.108600E+01,2.287900E+01,5.885300E+01,&
     & 1.955200E+02,1.437900E+03,6.780800E+03,1.232100E+04,2.284500E+04,&
     & 4.156200E+04,8.773007E+04,3.317200E-01,1.081000E+00,1.922700E+00,&
     & 3.183200E+00,5.876100E+00,1.174800E+01,2.967400E+01,9.799200E+01,&
     & 7.192200E+02,3.390600E+03,6.160800E+03,1.142300E+04,2.078200E+04,&
     & 4.386634E+04,4.749000E-03,1.429400E-02,2.826100E-02,5.217400E-02,&
     & 9.681900E-02,1.906800E-01,4.124700E-01,1.002500E+00,2.796900E+00,&
     & 5.404500E+00,6.563400E+00,7.975000E+00,1.003600E+01,1.441316E+01,&
     & 1.251200E+00,3.988800E+00,6.875100E+00,1.170300E+01,2.261700E+01,&
     & 4.678800E+01,1.208600E+02,4.054400E+02,2.895300E+03,1.330500E+04,&
     & 2.416800E+04,4.487600E+04,8.243400E+04,1.754731E+05,9.888200E-01,&
     & 3.082500E+00,5.262100E+00,8.880500E+00,1.706200E+01,3.518000E+01,&
     & 9.075900E+01,3.042000E+02,2.171600E+03,9.979000E+03,1.812600E+04,&
     & 3.365700E+04,6.182600E+04,1.316030E+05,6.981100E-01,2.142200E+00,&
     & 3.637900E+00,6.109200E+00,1.153000E+01,2.358700E+01,6.065600E+01,&
     & 2.029500E+02,1.447900E+03,6.652800E+03,1.208400E+04,2.243800E+04,&
     & 4.121700E+04,8.773706E+04,3.852100E-01,1.156400E+00,1.956000E+00,&
     & 3.312100E+00,6.089600E+00,1.208600E+01,3.056600E+01,1.017200E+02,&
     & 7.242200E+02,3.326700E+03,6.042400E+03,1.122000E+04,2.060900E+04,&
     & 4.386930E+04,5.453800E-03,1.570000E-02,3.038300E-02,5.528000E-02,&
     & 1.014400E-01,1.972700E-01,4.166100E-01,1.001900E+00,2.781700E+00,&
     & 5.311400E+00,6.459300E+00,7.827800E+00,9.788200E+00,1.404327E+01/
      data   absb(:,161:180) /                                          &
     & 1.445100E+00,4.240300E+00,7.000600E+00,1.228900E+01,2.354300E+01,&
     & 4.881900E+01,1.244000E+02,4.205600E+02,2.930200E+03,1.300100E+04,&
     & 2.364600E+04,4.404000E+04,8.169200E+04,1.751367E+05,1.137000E+00,&
     & 3.267800E+00,5.358800E+00,9.315300E+00,1.776000E+01,3.670400E+01,&
     & 9.340300E+01,3.155400E+02,2.197800E+03,9.750700E+03,1.773500E+04,&
     & 3.303000E+04,6.126900E+04,1.313511E+05,8.005600E-01,2.260400E+00,&
     & 3.714500E+00,6.389700E+00,1.199800E+01,2.459600E+01,6.241300E+01,&
     & 2.105200E+02,1.465400E+03,6.500600E+03,1.182300E+04,2.202100E+04,&
     & 4.084700E+04,8.756954E+04,4.395900E-01,1.212900E+00,2.005400E+00,&
     & 3.452000E+00,6.326000E+00,1.257100E+01,3.143800E+01,1.055000E+02,&
     & 7.329500E+02,3.250600E+03,5.912000E+03,1.101100E+04,2.042400E+04,&
     & 4.378467E+04,6.129100E-03,1.702600E-02,3.239400E-02,5.829800E-02,&
     & 1.060500E-01,2.032200E-01,4.221300E-01,1.002500E+00,2.754800E+00,&
     & 5.225000E+00,6.329200E+00,7.623700E+00,9.550500E+00,1.366435E+01,&
     & 1.643700E+00,4.430400E+00,7.201600E+00,1.287900E+01,2.451200E+01,&
     & 5.124300E+01,1.286400E+02,4.357600E+02,2.978200E+03,1.268700E+04,&
     & 2.307700E+04,4.322700E+04,8.082100E+04,1.744126E+05,1.288300E+00,&
     & 3.410500E+00,5.506900E+00,9.754900E+00,1.848800E+01,3.852300E+01,&
     & 9.658700E+01,3.269300E+02,2.233800E+03,9.515500E+03,1.730800E+04,&
     & 3.242000E+04,6.061600E+04,1.308047E+05,9.043700E-01,2.356200E+00,&
     & 3.818000E+00,6.672700E+00,1.248300E+01,2.581000E+01,6.453200E+01,&
     & 2.181100E+02,1.489400E+03,6.343800E+03,1.153900E+04,2.161400E+04,&
     & 4.041100E+04,8.720562E+04,4.944400E-01,1.261100E+00,2.064900E+00,&
     & 3.595100E+00,6.565300E+00,1.316500E+01,3.248900E+01,1.093000E+02,&
     & 7.449400E+02,3.172200E+03,5.769700E+03,1.080700E+04,2.020600E+04,&
     & 4.360316E+04,6.763500E-03,1.822300E-02,3.429300E-02,6.123000E-02,&
     & 1.105500E-01,2.089500E-01,4.277900E-01,1.001200E+00,2.718900E+00,&
     & 5.140700E+00,6.203400E+00,7.507000E+00,9.299500E+00,1.316453E+01,&
     & 1.846700E+00,4.589200E+00,7.466200E+00,1.350900E+01,2.554800E+01,&
     & 5.375900E+01,1.339600E+02,4.512600E+02,3.036000E+03,1.239400E+04,&
     & 2.248900E+04,4.237400E+04,7.984400E+04,1.732079E+05,1.442500E+00,&
     & 3.530500E+00,5.701800E+00,1.022800E+01,1.926500E+01,4.041100E+01,&
     & 1.005700E+02,3.385600E+02,2.277100E+03,9.296000E+03,1.686700E+04,&
     & 3.178100E+04,5.988300E+04,1.299958E+05,1.009900E+00,2.437600E+00,&
     & 3.951800E+00,6.979700E+00,1.299800E+01,2.707100E+01,6.718100E+01,&
     & 2.258600E+02,1.518300E+03,6.197500E+03,1.124500E+04,2.118700E+04,&
     & 3.992200E+04,8.666332E+04,5.492900E-01,1.305200E+00,2.140300E+00,&
     & 3.746100E+00,6.817000E+00,1.378400E+01,3.380700E+01,1.131700E+02,&
     & 7.593900E+02,3.099100E+03,5.622600E+03,1.059400E+04,1.996200E+04,&
     & 4.333246E+04,7.335300E-03,1.925000E-02,3.604700E-02,6.398700E-02,&
     & 1.147800E-01,2.146800E-01,4.326000E-01,9.989900E-01,2.682900E+00,&
     & 5.025100E+00,6.036900E+00,7.343000E+00,9.120400E+00,1.267393E+01,&
     & 7.713300E-01,2.648400E+00,4.879400E+00,8.101700E+00,1.575600E+01,&
     & 3.305000E+01,8.646800E+01,2.961700E+02,2.151700E+03,1.019500E+04,&
     & 1.910600E+04,3.724600E+04,7.343400E+04,1.701204E+05,6.203200E-01,&
     & 2.072500E+00,3.761600E+00,6.194000E+00,1.191600E+01,2.488500E+01,&
     & 6.496400E+01,2.222400E+02,1.613900E+03,7.646600E+03,1.433000E+04,&
     & 2.793500E+04,5.507600E+04,1.275961E+05,4.419700E-01,1.457600E+00,&
     & 2.609900E+00,4.322300E+00,8.138300E+00,1.674100E+01,4.346700E+01,&
     & 1.483100E+02,1.076100E+03,5.097900E+03,9.553300E+03,1.862300E+04,&
     & 3.671700E+04,8.506308E+04,2.470700E-01,7.988700E-01,1.408200E+00,&
     & 2.377300E+00,4.391400E+00,8.770000E+00,2.201700E+01,7.439200E+01,&
     & 5.383300E+02,2.549200E+03,4.777000E+03,9.312200E+03,1.835900E+04,&
     & 4.253129E+04,4.003200E-03,1.209500E-02,2.401000E-02,4.472500E-02,&
     & 8.385300E-02,1.669500E-01,3.658200E-01,9.305900E-01,2.825100E+00,&
     & 5.765200E+00,7.164600E+00,8.815300E+00,1.117300E+01,1.644298E+01/
      data   absb(:,181:200) /                                          &
     & 9.074300E-01,2.872300E+00,4.922200E+00,8.481600E+00,1.643100E+01,&
     & 3.434600E+01,8.902400E+01,3.071600E+02,2.181400E+03,9.963100E+03,&
     & 1.868200E+04,3.655000E+04,7.278100E+04,1.700431E+05,7.250300E-01,&
     & 2.237700E+00,3.800800E+00,6.473500E+00,1.242500E+01,2.585000E+01,&
     & 6.687900E+01,2.304900E+02,1.636200E+03,7.472500E+03,1.401100E+04,&
     & 2.741300E+04,5.458600E+04,1.275343E+05,5.146600E-01,1.563800E+00,&
     & 2.647100E+00,4.509100E+00,8.472400E+00,1.737500E+01,4.473800E+01,&
     & 1.538200E+02,1.091000E+03,4.981800E+03,9.341100E+03,1.827600E+04,&
     & 3.639100E+04,8.502364E+04,2.862200E-01,8.485000E-01,1.436400E+00,&
     & 2.477500E+00,4.562400E+00,9.066600E+00,2.263600E+01,7.715400E+01,&
     & 5.457500E+02,2.491200E+03,4.670900E+03,9.138300E+03,1.819600E+04,&
     & 4.251256E+04,4.571500E-03,1.325800E-02,2.579500E-02,4.740800E-02,&
     & 8.810300E-02,1.732100E-01,3.713100E-01,9.321900E-01,2.812200E+00,&
     & 5.680400E+00,7.040900E+00,8.653200E+00,1.091900E+01,1.602255E+01,&
     & 1.047000E+00,3.043200E+00,5.024100E+00,8.897000E+00,1.712100E+01,&
     & 3.603100E+01,9.194300E+01,3.181600E+02,2.224100E+03,9.729300E+03,&
     & 1.822400E+04,3.584000E+04,7.207300E+04,1.695578E+05,8.326700E-01,&
     & 2.362000E+00,3.881100E+00,6.779300E+00,1.294500E+01,2.711400E+01,&
     & 6.906400E+01,2.387400E+02,1.668200E+03,7.297100E+03,1.366800E+04,&
     & 2.688000E+04,5.405500E+04,1.271669E+05,5.891800E-01,1.643300E+00,&
     & 2.710600E+00,4.707900E+00,8.817900E+00,1.821300E+01,4.618800E+01,&
     & 1.593200E+02,1.112300E+03,4.864900E+03,9.112500E+03,1.792000E+04,&
     & 3.603700E+04,8.477821E+04,3.260300E-01,8.874900E-01,1.475800E+00,&
     & 2.579100E+00,4.742800E+00,9.466000E+00,2.334700E+01,7.990800E+01,&
     & 5.564300E+02,2.432800E+03,4.556600E+03,8.960700E+03,1.801900E+04,&
     & 4.238946E+04,5.112500E-03,1.432300E-02,2.748700E-02,5.002700E-02,&
     & 9.225200E-02,1.792900E-01,3.776600E-01,9.337000E-01,2.789300E+00,&
     & 5.609200E+00,6.886900E+00,8.439100E+00,1.067600E+01,1.559296E+01,&
     & 1.190000E+00,3.176600E+00,5.182200E+00,9.325200E+00,1.784800E+01,&
     & 3.786600E+01,9.573700E+01,3.295200E+02,2.275800E+03,9.522700E+03,&
     & 1.773400E+04,3.514900E+04,7.122600E+04,1.687030E+05,9.422600E-01,&
     & 2.462800E+00,3.998300E+00,7.095800E+00,1.349200E+01,2.849100E+01,&
     & 7.190600E+01,2.472600E+02,1.706900E+03,7.142100E+03,1.330000E+04,&
     & 2.636200E+04,5.341900E+04,1.265260E+05,6.648100E-01,1.711300E+00,&
     & 2.794200E+00,4.913700E+00,9.177900E+00,1.913000E+01,4.808000E+01,&
     & 1.650000E+02,1.138100E+03,4.761600E+03,8.867100E+03,1.757500E+04,&
     & 3.561300E+04,8.435362E+04,3.660300E-01,9.223300E-01,1.525200E+00,&
     & 2.685600E+00,4.926400E+00,9.904500E+00,2.428300E+01,8.274100E+01,&
     & 5.693300E+02,2.381100E+03,4.433900E+03,8.787800E+03,1.780700E+04,&
     & 4.217720E+04,5.614500E-03,1.525100E-02,2.907800E-02,5.253900E-02,&
     & 9.622800E-02,1.851500E-01,3.841300E-01,9.343500E-01,2.757200E+00,&
     & 5.528500E+00,6.755700E+00,8.299500E+00,1.040600E+01,1.504732E+01,&
     & 1.336200E+00,3.289600E+00,5.393800E+00,9.805700E+00,1.860600E+01,&
     & 3.971300E+01,1.003200E+02,3.415000E+02,2.333800E+03,9.362500E+03,&
     & 1.724100E+04,3.440500E+04,7.032600E+04,1.674777E+05,1.053900E+00,&
     & 2.549000E+00,4.154300E+00,7.454600E+00,1.406000E+01,2.987600E+01,&
     & 7.534200E+01,2.562500E+02,1.750500E+03,7.022000E+03,1.293100E+04,&
     & 2.580400E+04,5.274500E+04,1.256081E+05,7.413000E-01,1.771000E+00,&
     & 2.903600E+00,5.145600E+00,9.552800E+00,2.005200E+01,5.036200E+01,&
     & 1.709900E+02,1.167200E+03,4.681600E+03,8.621100E+03,1.720300E+04,&
     & 3.516400E+04,8.373974E+04,4.058200E-01,9.555100E-01,1.587200E+00,&
     & 2.802700E+00,5.113400E+00,1.035000E+01,2.541000E+01,8.574100E+01,&
     & 5.838400E+02,2.341100E+03,4.310900E+03,8.601800E+03,1.758200E+04,&
     & 4.187076E+04,6.069900E-03,1.604000E-02,3.045700E-02,5.491000E-02,&
     & 9.999300E-02,1.906600E-01,3.904800E-01,9.347400E-01,2.724500E+00,&
     & 5.399500E+00,6.602700E+00,8.116700E+00,1.020500E+01,1.448882E+01/
      data   absb(:,201:220) /                                          &
     & 5.786600E-01,1.973700E+00,3.597600E+00,6.050100E+00,1.178700E+01,&
     & 2.484400E+01,6.558000E+01,2.304200E+02,1.670000E+03,7.788500E+03,&
     & 1.503900E+04,3.070900E+04,6.568400E+04,1.692828E+05,4.698600E-01,&
     & 1.558900E+00,2.795700E+00,4.668800E+00,8.945900E+00,1.873100E+01,&
     & 4.930000E+01,1.729300E+02,1.252600E+03,5.841500E+03,1.128000E+04,&
     & 2.303200E+04,4.926300E+04,1.269615E+05,3.362100E-01,1.100500E+00,&
     & 1.952500E+00,3.288400E+00,6.183600E+00,1.267300E+01,3.303000E+01,&
     & 1.154400E+02,8.352600E+02,3.894500E+03,7.520000E+03,1.535500E+04,&
     & 3.284300E+04,8.464186E+04,1.891700E-01,6.056400E-01,1.060200E+00,&
     & 1.825400E+00,3.386100E+00,6.785100E+00,1.689600E+01,5.796500E+01,&
     & 4.179000E+02,1.947500E+03,3.760400E+03,7.678000E+03,1.642200E+04,&
     & 4.232135E+04,3.362100E-03,1.020200E-02,2.031000E-02,3.813600E-02,&
     & 7.235300E-02,1.455300E-01,3.224800E-01,8.523500E-01,2.818800E+00,&
     & 6.128000E+00,7.717000E+00,9.737200E+00,1.243700E+01,1.874440E+01,&
     & 6.795000E-01,2.132400E+00,3.635600E+00,6.335700E+00,1.230300E+01,&
     & 2.601200E+01,6.767900E+01,2.388000E+02,1.705800E+03,7.609200E+03,&
     & 1.466000E+04,3.010800E+04,6.506000E+04,1.690035E+05,5.481100E-01,&
     & 1.674300E+00,2.832100E+00,4.877900E+00,9.335400E+00,1.960000E+01,&
     & 5.087000E+01,1.792200E+02,1.279500E+03,5.707100E+03,1.099500E+04,&
     & 2.258100E+04,4.879500E+04,1.267556E+05,3.907200E-01,1.173600E+00,&
     & 1.986700E+00,3.431200E+00,6.440100E+00,1.323900E+01,3.407200E+01,&
     & 1.196400E+02,8.531800E+02,3.804900E+03,7.330600E+03,1.505500E+04,&
     & 3.253100E+04,8.450183E+04,2.187700E-01,6.400400E-01,1.084600E+00,&
     & 1.901100E+00,3.525400E+00,7.055700E+00,1.738600E+01,6.007000E+01,&
     & 4.268600E+02,1.902700E+03,3.665700E+03,7.527700E+03,1.626600E+04,&
     & 4.225244E+04,3.818300E-03,1.114600E-02,2.180300E-02,4.044100E-02,&
     & 7.608400E-02,1.518000E-01,3.290200E-01,8.559900E-01,2.808700E+00,&
     & 6.046700E+00,7.583500E+00,9.564500E+00,1.217500E+01,1.825761E+01,&
     & 7.832600E-01,2.254300E+00,3.722200E+00,6.644900E+00,1.282600E+01,&
     & 2.734700E+01,7.035300E+01,2.472100E+02,1.751000E+03,7.465800E+03,&
     & 1.425300E+04,2.950900E+04,6.434700E+04,1.683454E+05,6.286900E-01,&
     & 1.763000E+00,2.901100E+00,5.102900E+00,9.729200E+00,2.060200E+01,&
     & 5.287200E+01,1.855300E+02,1.313400E+03,5.599500E+03,1.069000E+04,&
     & 2.213200E+04,4.826100E+04,1.262584E+05,4.465800E-01,1.231300E+00,&
     & 2.040100E+00,3.579200E+00,6.703400E+00,1.390000E+01,3.539800E+01,&
     & 1.238500E+02,8.757800E+02,3.733200E+03,7.127000E+03,1.475500E+04,&
     & 3.217400E+04,8.417128E+04,2.487300E-01,6.686500E-01,1.117500E+00,&
     & 1.978500E+00,3.668100E+00,7.374300E+00,1.802200E+01,6.217700E+01,&
     & 4.381600E+02,1.866900E+03,3.563900E+03,7.378000E+03,1.608800E+04,&
     & 4.208664E+04,4.251200E-03,1.198100E-02,2.322700E-02,4.266000E-02,&
     & 7.975000E-02,1.576700E-01,3.361700E-01,8.593800E-01,2.789900E+00,&
     & 5.978200E+00,7.441300E+00,9.326700E+00,1.191300E+01,1.775259E+01,&
     & 8.893300E-01,2.350800E+00,3.849700E+00,6.976200E+00,1.336700E+01,&
     & 2.873400E+01,7.371000E+01,2.562200E+02,1.802900E+03,7.364700E+03,&
     & 1.384800E+04,2.889200E+04,6.355100E+04,1.672821E+05,7.106300E-01,&
     & 1.836000E+00,2.997200E+00,5.345500E+00,1.013600E+01,2.164300E+01,&
     & 5.538400E+01,1.922900E+02,1.352300E+03,5.523700E+03,1.038700E+04,&
     & 2.167000E+04,4.766400E+04,1.254600E+05,5.033400E-01,1.280900E+00,&
     & 2.109800E+00,3.740400E+00,6.971400E+00,1.458600E+01,3.706700E+01,&
     & 1.283500E+02,9.017300E+02,3.682600E+03,6.924600E+03,1.444700E+04,&
     & 3.177600E+04,8.363833E+04,2.787200E-01,6.949700E-01,1.159300E+00,&
     & 2.061700E+00,3.811100E+00,7.703700E+00,1.883300E+01,6.442600E+01,&
     & 4.511300E+02,1.841600E+03,3.462700E+03,7.223800E+03,1.588900E+04,&
     & 4.182035E+04,4.653200E-03,1.268600E-02,2.450500E-02,4.482300E-02,&
     & 8.323300E-02,1.631900E-01,3.433700E-01,8.624100E-01,2.763200E+00,&
     & 5.891100E+00,7.321400E+00,9.169000E+00,1.160200E+01,1.713632E+01/
      data   absb(:,221:240) /                                          &
     & 9.979000E-01,2.431200E+00,4.021400E+00,7.352800E+00,1.395700E+01,&
     & 3.013700E+01,7.737800E+01,2.665300E+02,1.860100E+03,7.292800E+03,&
     & 1.347400E+04,2.824100E+04,6.269900E+04,1.658546E+05,7.939700E-01,&
     & 1.898600E+00,3.125500E+00,5.623500E+00,1.057800E+01,2.269600E+01,&
     & 5.812900E+01,2.000200E+02,1.395200E+03,5.469800E+03,1.010600E+04,&
     & 2.118100E+04,4.702500E+04,1.243937E+05,5.601300E-01,1.325800E+00,&
     & 2.200400E+00,3.922800E+00,7.261300E+00,1.528400E+01,3.888700E+01,&
     & 1.335100E+02,9.303200E+02,3.646700E+03,6.737400E+03,1.412100E+04,&
     & 3.135000E+04,8.292850E+04,3.084100E-01,7.201000E-01,1.211100E+00,&
     & 2.156900E+00,3.958900E+00,8.040500E+00,1.971800E+01,6.700900E+01,&
     & 4.654200E+02,1.823700E+03,3.369100E+03,7.060700E+03,1.567600E+04,&
     & 4.146462E+04,5.018900E-03,1.329100E-02,2.555000E-02,4.687200E-02,&
     & 8.647800E-02,1.683100E-01,3.509100E-01,8.667000E-01,2.732800E+00,&
     & 5.766000E+00,7.172100E+00,8.967100E+00,1.136600E+01,1.650164E+01,&
     & 4.503500E-01,1.515600E+00,2.720300E+00,4.640400E+00,9.071800E+00,&
     & 1.924400E+01,5.099000E+01,1.834600E+02,1.340300E+03,6.047200E+03,&
     & 1.192800E+04,2.548400E+04,5.899200E+04,1.714894E+05,3.683800E-01,&
     & 1.206400E+00,2.131400E+00,3.618200E+00,6.924200E+00,1.453200E+01,&
     & 3.836000E+01,1.377100E+02,1.005400E+03,4.535500E+03,8.945900E+03,&
     & 1.911300E+04,4.424400E+04,1.286136E+05,2.644900E-01,8.527600E-01,&
     & 1.496400E+00,2.569200E+00,4.836100E+00,9.929800E+00,2.574700E+01,&
     & 9.196200E+01,6.704300E+02,3.023900E+03,5.964200E+03,1.274200E+04,&
     & 2.949700E+04,8.574398E+04,1.496100E-01,4.703700E-01,8.178200E-01,&
     & 1.432200E+00,2.678100E+00,5.412500E+00,1.339000E+01,4.624700E+01,&
     & 3.354900E+02,1.512200E+03,2.982500E+03,6.371700E+03,1.474900E+04,&
     & 4.287257E+04,2.837100E-03,8.625600E-03,1.720500E-02,3.249500E-02,&
     & 6.230700E-02,1.270300E-01,2.835500E-01,7.717500E-01,2.777800E+00,&
     & 6.438900E+00,8.253600E+00,1.068100E+01,1.381700E+01,2.126596E+01,&
     & 5.271000E-01,1.629900E+00,2.758400E+00,4.864700E+00,9.461600E+00,&
     & 2.022400E+01,5.293700E+01,1.899600E+02,1.379200E+03,5.945700E+03,&
     & 1.158800E+04,2.496400E+04,5.837700E+04,1.709686E+05,4.285400E-01,&
     & 1.288000E+00,2.168200E+00,3.782000E+00,7.218000E+00,1.526300E+01,&
     & 3.981300E+01,1.425900E+02,1.034500E+03,4.459400E+03,8.691400E+03,&
     & 1.872300E+04,4.378300E+04,1.282260E+05,3.064100E-01,9.043900E-01,&
     & 1.528700E+00,2.680600E+00,5.037000E+00,1.040200E+01,2.670600E+01,&
     & 9.522200E+01,6.898500E+02,2.973100E+03,5.794600E+03,1.248300E+04,&
     & 2.918900E+04,8.548358E+04,1.724800E-01,4.950700E-01,8.396300E-01,&
     & 1.490600E+00,2.791200E+00,5.651500E+00,1.382700E+01,4.788000E+01,&
     & 3.452000E+02,1.486800E+03,2.897700E+03,6.241700E+03,1.459500E+04,&
     & 4.274228E+04,3.203300E-03,9.365900E-03,1.845800E-02,3.444100E-02,&
     & 6.557700E-02,1.328700E-01,2.908400E-01,7.775700E-01,2.771500E+00,&
     & 6.353400E+00,8.135300E+00,1.049700E+01,1.352200E+01,2.068179E+01,&
     & 6.062100E-01,1.716700E+00,2.835400E+00,5.107600E+00,9.859800E+00,&
     & 2.127800E+01,5.547200E+01,1.968500E+02,1.424800E+03,5.884300E+03,&
     & 1.126100E+04,2.442300E+04,5.772600E+04,1.700004E+05,4.902700E-01,&
     & 1.352100E+00,2.229600E+00,3.957700E+00,7.516900E+00,1.605300E+01,&
     & 4.171200E+01,1.477500E+02,1.068800E+03,4.413300E+03,8.446200E+03,&
     & 1.831700E+04,4.329500E+04,1.274976E+05,3.493100E-01,9.470100E-01,&
     & 1.574900E+00,2.798900E+00,5.239900E+00,1.091500E+01,2.796500E+01,&
     & 9.866500E+01,7.126900E+02,2.942400E+03,5.631100E+03,1.221200E+04,&
     & 2.886300E+04,8.499949E+04,1.954600E-01,5.166300E-01,8.685000E-01,&
     & 1.552900E+00,2.906500E+00,5.905800E+00,1.441700E+01,4.959900E+01,&
     & 3.566100E+02,1.471500E+03,2.815900E+03,6.106400E+03,1.443200E+04,&
     & 4.250040E+04,3.550700E-03,1.000400E-02,1.959800E-02,3.634900E-02,&
     & 6.875500E-02,1.381500E-01,2.986300E-01,7.836900E-01,2.755900E+00,&
     & 6.304300E+00,8.004600E+00,1.023400E+01,1.321700E+01,2.008264E+01/
      data   absb(:,241:260) /                                          &
     & 6.868700E-01,1.787600E+00,2.941500E+00,5.376700E+00,1.028500E+01,&
     & 2.235900E+01,5.829500E+01,2.048100E+02,1.474900E+03,5.854300E+03,&
     & 1.098100E+04,2.386900E+04,5.700300E+04,1.686559E+05,5.530200E-01,&
     & 1.405900E+00,2.311100E+00,4.154700E+00,7.835500E+00,1.686400E+01,&
     & 4.382200E+01,1.537300E+02,1.106300E+03,4.390900E+03,8.236200E+03,&
     & 1.790200E+04,4.275300E+04,1.264964E+05,3.926800E-01,9.842100E-01,&
     & 1.634600E+00,2.931600E+00,5.453100E+00,1.144300E+01,2.936200E+01,&
     & 1.026500E+02,7.377000E+02,2.927400E+03,5.491100E+03,1.193500E+04,&
     & 2.850200E+04,8.433153E+04,2.183600E-01,5.369000E-01,9.042600E-01,&
     & 1.622600E+00,3.021300E+00,6.167600E+00,1.507900E+01,5.159100E+01,&
     & 3.691100E+02,1.464000E+03,2.745900E+03,5.967800E+03,1.425200E+04,&
     & 4.216543E+04,3.872100E-03,1.054100E-02,2.055900E-02,3.820000E-02,&
     & 7.173200E-02,1.431500E-01,3.066800E-01,7.905200E-01,2.731600E+00,&
     & 6.230900E+00,7.886800E+00,1.005900E+01,1.286400E+01,1.937180E+01,&
     & 7.698600E-01,1.848200E+00,3.086700E+00,5.676300E+00,1.077400E+01,&
     & 2.344800E+01,6.121500E+01,2.143800E+02,1.522300E+03,5.890600E+03,&
     & 1.076700E+04,2.328600E+04,5.624200E+04,1.669355E+05,6.167600E-01,&
     & 1.454000E+00,2.421200E+00,4.374700E+00,8.199400E+00,1.768300E+01,&
     & 4.600500E+01,1.609100E+02,1.141800E+03,4.418100E+03,8.075600E+03,&
     & 1.746500E+04,4.218200E+04,1.252034E+05,4.361900E-01,1.019000E+00,&
     & 1.713400E+00,3.078900E+00,5.692400E+00,1.198000E+01,3.080700E+01,&
     & 1.074500E+02,7.613800E+02,2.945600E+03,5.384000E+03,1.164300E+04,&
     & 2.812100E+04,8.346827E+04,2.410500E-01,5.566700E-01,9.496000E-01,&
     & 1.701200E+00,3.145400E+00,6.431600E+00,1.576600E+01,5.398900E+01,&
     & 3.809400E+02,1.473200E+03,2.692400E+03,5.822100E+03,1.406100E+04,&
     & 4.173482E+04,4.164400E-03,1.101200E-02,2.131100E-02,3.981400E-02,&
     & 7.454400E-02,1.478000E-01,3.150100E-01,7.986500E-01,2.708800E+00,&
     & 6.099300E+00,7.710300E+00,9.831500E+00,1.258100E+01,1.864904E+01,&
     & 3.528800E-01,1.170100E+00,2.069500E+00,3.579500E+00,7.016200E+00,&
     & 1.500300E+01,3.992800E+01,1.461900E+02,1.089100E+03,4.751200E+03,&
     & 9.373800E+03,2.091800E+04,5.223400E+04,1.733540E+05,2.905900E-01,&
     & 9.373500E-01,1.636900E+00,2.821100E+00,5.399800E+00,1.136100E+01,&
     & 3.006400E+01,1.097600E+02,8.169800E+02,3.563500E+03,7.030500E+03,&
     & 1.568800E+04,3.917600E+04,1.300137E+05,2.092900E-01,6.634400E-01,&
     & 1.153200E+00,2.015300E+00,3.809800E+00,7.863100E+00,2.025100E+01,&
     & 7.333300E+01,5.448400E+02,2.375800E+03,4.687300E+03,1.045900E+04,&
     & 2.611800E+04,8.667577E+04,1.189600E-01,3.667200E-01,6.348500E-01,&
     & 1.126300E+00,2.126200E+00,4.354400E+00,1.075300E+01,3.700900E+01,&
     & 2.727000E+02,1.188200E+03,2.344100E+03,5.230200E+03,1.305900E+04,&
     & 4.333858E+04,2.387800E-03,7.258500E-03,1.454400E-02,2.757100E-02,&
     & 5.339700E-02,1.105300E-01,2.487500E-01,6.926900E-01,2.704100E+00,&
     & 6.688800E+00,8.795700E+00,1.161400E+01,1.530100E+01,2.400513E+01,&
     & 4.116500E-01,1.252600E+00,2.108000E+00,3.757700E+00,7.311800E+00,&
     & 1.578800E+01,4.178300E+01,1.514600E+02,1.128300E+03,4.715100E+03,&
     & 9.112000E+03,2.045100E+04,5.171900E+04,1.724991E+05,3.370300E-01,&
     & 9.956000E-01,1.673000E+00,2.951300E+00,5.623100E+00,1.194600E+01,&
     & 3.145000E+01,1.137100E+02,8.463700E+02,3.536500E+03,6.834200E+03,&
     & 1.533900E+04,3.878900E+04,1.293753E+05,2.416900E-01,7.006600E-01,&
     & 1.183300E+00,2.103500E+00,3.966500E+00,8.243400E+00,2.116000E+01,&
     & 7.596900E+01,5.644300E+02,2.357800E+03,4.556400E+03,1.022600E+04,&
     & 2.586000E+04,8.624945E+04,1.366800E-01,3.849700E-01,6.542300E-01,&
     & 1.173200E+00,2.216100E+00,4.554100E+00,1.117300E+01,3.831200E+01,&
     & 2.824900E+02,1.179200E+03,2.278600E+03,5.113500E+03,1.293100E+04,&
     & 4.312605E+04,2.683000E-03,7.829800E-03,1.555700E-02,2.922200E-02,&
     & 5.622100E-02,1.156400E-01,2.566200E-01,7.005800E-01,2.702700E+00,&
     & 6.628900E+00,8.675000E+00,1.141700E+01,1.494300E+01,2.331847E+01/
      data   absb(:,261:280) /                                          &
     & 4.721000E-01,1.315700E+00,2.174500E+00,3.953000E+00,7.625700E+00,&
     & 1.660900E+01,4.395400E+01,1.575200E+02,1.170400E+03,4.715300E+03,&
     & 8.911900E+03,1.996900E+04,5.114400E+04,1.712511E+05,3.844700E-01,&
     & 1.042900E+00,1.726200E+00,3.093600E+00,5.858200E+00,1.256000E+01,&
     & 3.307200E+01,1.182600E+02,8.779100E+02,3.536600E+03,6.684200E+03,&
     & 1.497700E+04,3.835800E+04,1.284368E+05,2.747800E-01,7.324700E-01,&
     & 1.223300E+00,2.201600E+00,4.130100E+00,8.638700E+00,2.222700E+01,&
     & 7.900400E+01,5.854500E+02,2.357900E+03,4.456400E+03,9.984800E+03,&
     & 2.557200E+04,8.562486E+04,1.543500E-01,4.015500E-01,6.794700E-01,&
     & 1.225400E+00,2.309000E+00,4.760300E+00,1.167000E+01,3.981200E+01,&
     & 2.930000E+02,1.179200E+03,2.228600E+03,4.992800E+03,1.278700E+04,&
     & 4.281261E+04,2.961600E-03,8.320600E-03,1.641900E-02,3.087400E-02,&
     & 5.890200E-02,1.203400E-01,2.650500E-01,7.099700E-01,2.690700E+00,&
     & 6.588800E+00,8.566700E+00,1.112500E+01,1.458500E+01,2.261280E+01,&
     & 5.341200E-01,1.368500E+00,2.264700E+00,4.170100E+00,7.974000E+00,&
     & 1.744400E+01,4.623900E+01,1.649800E+02,1.211300E+03,4.775700E+03,&
     & 8.769800E+03,1.948100E+04,5.053000E+04,1.695957E+05,4.329400E-01,&
     & 1.083500E+00,1.797000E+00,3.252400E+00,6.118100E+00,1.318400E+01,&
     & 3.477900E+01,1.238600E+02,9.086200E+02,3.582000E+03,6.577600E+03,&
     & 1.461100E+04,3.789800E+04,1.271955E+05,3.081800E-01,7.611400E-01,&
     & 1.275200E+00,2.309700E+00,4.306000E+00,9.042900E+00,2.335000E+01,&
     & 8.274200E+01,6.059200E+02,2.388200E+03,4.385300E+03,9.740700E+03,&
     & 2.526600E+04,8.479585E+04,1.720300E-01,4.171700E-01,7.108900E-01,&
     & 1.283800E+00,2.403300E+00,4.969100E+00,1.219500E+01,4.166900E+01,&
     & 3.032200E+02,1.194400E+03,2.193100E+03,4.870800E+03,1.263300E+04,&
     & 4.239890E+04,3.219600E-03,8.738300E-03,1.712000E-02,3.233900E-02,&
     & 6.150700E-02,1.247900E-01,2.735100E-01,7.208200E-01,2.673000E+00,&
     & 6.510300E+00,8.443700E+00,1.094200E+01,1.417000E+01,2.178111E+01,&
     & 5.975800E-01,1.414600E+00,2.382300E+00,4.412100E+00,8.385200E+00,&
     & 1.831800E+01,4.855500E+01,1.738200E+02,1.250700E+03,4.878400E+03,&
     & 8.706400E+03,1.899800E+04,4.985400E+04,1.675632E+05,4.816200E-01,&
     & 1.120700E+00,1.887900E+00,3.431100E+00,6.421900E+00,1.384000E+01,&
     & 3.650900E+01,1.304900E+02,9.381600E+02,3.659000E+03,6.530000E+03,&
     & 1.424900E+04,3.739100E+04,1.256738E+05,3.414700E-01,7.881800E-01,&
     & 1.341200E+00,2.431800E+00,4.508300E+00,9.468700E+00,2.448900E+01,&
     & 8.717500E+01,6.256000E+02,2.439600E+03,4.353600E+03,9.499400E+03,&
     & 2.492800E+04,8.378177E+04,1.892500E-01,4.330100E-01,7.490300E-01,&
     & 1.349000E+00,2.510000E+00,5.186900E+00,1.272500E+01,4.388100E+01,&
     & 3.130500E+02,1.220100E+03,2.177200E+03,4.750100E+03,1.246400E+04,&
     & 4.189166E+04,3.451700E-03,9.103600E-03,1.767400E-02,3.349800E-02,&
     & 6.398300E-02,1.289400E-01,2.819100E-01,7.324700E-01,2.659400E+00,&
     & 6.375000E+00,8.249900E+00,1.069900E+01,1.382200E+01,2.094921E+01,&
     & 2.755400E-01,8.994900E-01,1.569700E+00,2.749900E+00,5.394500E+00,&
     & 1.164200E+01,3.119800E+01,1.154600E+02,8.858100E+02,3.766400E+03,&
     & 7.281800E+03,1.682800E+04,4.523100E+04,1.728329E+05,2.284700E-01,&
     & 7.246200E-01,1.253100E+00,2.192900E+00,4.195900E+00,8.864600E+00,&
     & 2.351800E+01,8.671300E+01,6.645000E+02,2.824900E+03,5.461500E+03,&
     & 1.262100E+04,3.392300E+04,1.296241E+05,1.650900E-01,5.135700E-01,&
     & 8.863700E-01,1.571600E+00,2.988700E+00,6.218000E+00,1.596200E+01,&
     & 5.797500E+01,4.431800E+02,1.883500E+03,3.641300E+03,8.414500E+03,&
     & 2.261600E+04,8.641575E+04,9.430500E-02,2.847000E-01,4.913900E-01,&
     & 8.820800E-01,1.676400E+00,3.489000E+00,8.666600E+00,2.948400E+01,&
     & 2.218800E+02,9.419900E+02,1.821100E+03,4.207800E+03,1.130900E+04,&
     & 4.320929E+04,2.005800E-03,6.078900E-03,1.225700E-02,2.332800E-02,&
     & 4.556200E-02,9.564200E-02,2.181200E-01,6.173600E-01,2.602300E+00,&
     & 6.893900E+00,9.304700E+00,1.252200E+01,1.682900E+01,2.695087E+01/
      data   absb(:,281:300) /                                          &
     & 3.203800E-01,9.586700E-01,1.605500E+00,2.891200E+00,5.626300E+00,&
     & 1.225000E+01,3.283600E+01,1.199700E+02,9.204000E+02,3.783300E+03,&
     & 7.139800E+03,1.641500E+04,4.480700E+04,1.716772E+05,2.641100E-01,&
     & 7.663900E-01,1.286400E+00,2.296100E+00,4.372300E+00,9.314300E+00,&
     & 2.474200E+01,9.009600E+01,6.904400E+02,2.837600E+03,5.355100E+03,&
     & 1.231100E+04,3.360600E+04,1.287607E+05,1.900300E-01,5.406300E-01,&
     & 9.133200E-01,1.642200E+00,3.115300E+00,6.516400E+00,1.675200E+01,&
     & 6.022900E+01,4.604700E+02,1.891900E+03,3.570300E+03,8.207900E+03,&
     & 2.240400E+04,8.584068E+04,1.079300E-01,2.982900E-01,5.086600E-01,&
     & 9.205200E-01,1.749100E+00,3.652500E+00,9.041200E+00,3.057400E+01,&
     & 2.305200E+02,9.462600E+02,1.785600E+03,4.104400E+03,1.120300E+04,&
     & 4.292095E+04,2.244000E-03,6.521800E-03,1.303100E-02,2.474700E-02,&
     & 4.795300E-02,1.000700E-01,2.264200E-01,6.282200E-01,2.606000E+00,&
     & 6.856000E+00,9.184400E+00,1.229900E+01,1.643400E+01,2.611934E+01,&
     & 3.664400E-01,1.004200E+00,1.663100E+00,3.048900E+00,5.880300E+00,&
     & 1.287800E+01,3.458600E+01,1.256000E+02,9.549600E+02,3.852400E+03,&
     & 7.055100E+03,1.600500E+04,4.431900E+04,1.701511E+05,3.004900E-01,&
     & 8.011400E-01,1.332900E+00,2.412700E+00,4.563200E+00,9.780000E+00,&
     & 2.604700E+01,9.432400E+01,7.163500E+02,2.889500E+03,5.291600E+03,&
     & 1.200400E+04,3.324000E+04,1.276136E+05,2.154300E-01,5.643600E-01,&
     & 9.483400E-01,1.723100E+00,3.250500E+00,6.820700E+00,1.759700E+01,&
     & 6.305100E+01,4.777500E+02,1.926500E+03,3.528000E+03,8.002700E+03,&
     & 2.216000E+04,8.507632E+04,1.214800E-01,3.110000E-01,5.308600E-01,&
     & 9.642600E-01,1.823600E+00,3.818400E+00,9.444500E+00,3.194600E+01,&
     & 2.391400E+02,9.636100E+02,1.764400E+03,4.001800E+03,1.108100E+04,&
     & 4.253922E+04,2.468800E-03,6.902900E-03,1.367000E-02,2.606700E-02,&
     & 5.027200E-02,1.042300E-01,2.347500E-01,6.411800E-01,2.600500E+00,&
     & 6.823300E+00,9.090600E+00,1.200400E+01,1.598100E+01,2.527485E+01,&
     & 4.139400E-01,1.043100E+00,1.737400E+00,3.223100E+00,6.174000E+00,&
     & 1.353400E+01,3.638800E+01,1.325100E+02,9.877600E+02,3.950300E+03,&
     & 7.056100E+03,1.563200E+04,4.381300E+04,1.682021E+05,3.376100E-01,&
     & 8.317900E-01,1.392300E+00,2.541200E+00,4.782000E+00,1.026700E+01,&
     & 2.739000E+01,9.951500E+01,7.409400E+02,2.962900E+03,5.292300E+03,&
     & 1.172400E+04,3.286000E+04,1.261522E+05,2.410000E-01,5.861900E-01,&
     & 9.924500E-01,1.812000E+00,3.400800E+00,7.138700E+00,1.847000E+01,&
     & 6.651700E+01,4.941300E+02,1.975500E+03,3.528400E+03,7.816400E+03,&
     & 2.190700E+04,8.410195E+04,1.350000E-01,3.229900E-01,5.576400E-01,&
     & 1.012800E+00,1.904800E+00,3.989300E+00,9.856700E+00,3.364600E+01,&
     & 2.473300E+02,9.881100E+02,1.764600E+03,3.908600E+03,1.095400E+04,&
     & 4.205185E+04,2.675400E-03,7.229500E-03,1.419400E-02,2.712400E-02,&
     & 5.256100E-02,1.081800E-01,2.428900E-01,6.558300E-01,2.592200E+00,&
     & 6.736400E+00,8.963900E+00,1.179600E+01,1.551900E+01,2.430186E+01,&
     & 4.620500E-01,1.079000E+00,1.832700E+00,3.414900E+00,6.513600E+00,&
     & 1.425500E+01,3.823700E+01,1.403900E+02,1.019600E+03,4.050000E+03,&
     & 7.120000E+03,1.535000E+04,4.322900E+04,1.659319E+05,3.745900E-01,&
     & 8.613800E-01,1.467100E+00,2.684400E+00,5.030300E+00,1.080600E+01,&
     & 2.877200E+01,1.054200E+02,7.647900E+02,3.037700E+03,5.340200E+03,&
     & 1.151300E+04,3.242200E+04,1.244465E+05,2.662600E-01,6.079100E-01,&
     & 1.046700E+00,1.911500E+00,3.567900E+00,7.490500E+00,1.937000E+01,&
     & 7.046700E+01,5.100100E+02,2.025400E+03,3.560400E+03,7.675500E+03,&
     & 2.161500E+04,8.296483E+04,1.479800E-01,3.358800E-01,5.889000E-01,&
     & 1.066300E+00,1.995200E+00,4.173700E+00,1.028100E+01,3.560000E+01,&
     & 2.552500E+02,1.013000E+03,1.780600E+03,3.838100E+03,1.080800E+04,&
     & 4.148329E+04,2.859700E-03,7.512000E-03,1.461100E-02,2.790600E-02,&
     & 5.458000E-02,1.119000E-01,2.509600E-01,6.704500E-01,2.591400E+00,&
     & 6.586100E+00,8.759700E+00,1.153200E+01,1.511800E+01,2.331223E+01/
      data   absb(:,301:320) /                                          &
     & 2.183100E-01,7.011200E-01,1.208600E+00,2.143200E+00,4.205000E+00,&
     & 9.147500E+00,2.476500E+01,9.233500E+01,7.303500E+02,3.070500E+03,&
     & 5.782900E+03,1.351700E+04,3.908400E+04,1.730172E+05,1.821100E-01,&
     & 5.671500E-01,9.730900E-01,1.727700E+00,3.309100E+00,7.024100E+00,&
     & 1.870100E+01,6.936600E+01,5.479000E+02,2.303000E+03,4.337400E+03,&
     & 1.013800E+04,2.931400E+04,1.297666E+05,1.319700E-01,4.023300E-01,&
     & 6.915500E-01,1.239300E+00,2.372400E+00,4.988000E+00,1.283900E+01,&
     & 4.642800E+01,3.654500E+02,1.535600E+03,2.891800E+03,6.759000E+03,&
     & 1.954300E+04,8.651054E+04,7.567200E-02,2.236900E-01,3.856800E-01,&
     & 6.991200E-01,1.335900E+00,2.823400E+00,7.104400E+00,2.392100E+01,&
     & 1.830200E+02,7.680800E+02,1.446300E+03,3.380000E+03,9.771900E+03,&
     & 4.325572E+04,1.684800E-03,5.076300E-03,1.028100E-02,1.970700E-02,&
     & 3.873400E-02,8.235300E-02,1.911800E-01,5.485700E-01,2.480600E+00,&
     & 7.035200E+00,9.753100E+00,1.337800E+01,1.839700E+01,3.001425E+01,&
     & 2.530000E-01,7.435000E-01,1.242000E+00,2.258000E+00,4.393500E+00,&
     & 9.619400E+00,2.611700E+01,9.653300E+01,7.593200E+02,3.136800E+03,&
     & 5.741600E+03,1.317600E+04,3.873400E+04,1.715897E+05,2.097700E-01,&
     & 5.976400E-01,1.003500E+00,1.812400E+00,3.453700E+00,7.370500E+00,&
     & 1.970800E+01,7.251800E+01,5.696300E+02,2.352700E+03,4.306400E+03,&
     & 9.882600E+03,2.905000E+04,1.286892E+05,1.513900E-01,4.225000E-01,&
     & 7.152800E-01,1.298300E+00,2.478300E+00,5.223600E+00,1.348100E+01,&
     & 4.852400E+01,3.799300E+02,1.568700E+03,2.871200E+03,6.588700E+03,&
     & 1.936700E+04,8.579213E+04,8.622900E-02,2.340400E-01,4.010900E-01,&
     & 7.318600E-01,1.395500E+00,2.955600E+00,7.424800E+00,2.491100E+01,&
     & 1.902500E+02,7.847200E+02,1.436000E+03,3.294800E+03,9.684200E+03,&
     & 4.289694E+04,1.877000E-03,5.422200E-03,1.085700E-02,2.086200E-02,&
     & 4.078500E-02,8.620800E-02,1.992300E-01,5.630100E-01,2.489500E+00,&
     & 7.031000E+00,9.633300E+00,1.315000E+01,1.793000E+01,2.900805E+01,&
     & 2.886100E-01,7.771000E-01,1.290600E+00,2.386200E+00,4.609000E+00,&
     & 1.011800E+01,2.751800E+01,1.018600E+02,7.866500E+02,3.229900E+03,&
     & 5.770300E+03,1.290000E+04,3.835900E+04,1.697255E+05,2.380900E-01,&
     & 6.234900E-01,1.043300E+00,1.909000E+00,3.616900E+00,7.735600E+00,&
     & 2.074900E+01,7.652100E+01,5.901200E+02,2.422600E+03,4.327900E+03,&
     & 9.675300E+03,2.877000E+04,1.272966E+05,1.710900E-01,4.404800E-01,&
     & 7.456600E-01,1.365700E+00,2.594400E+00,5.468400E+00,1.414500E+01,&
     & 5.119100E+01,3.935900E+02,1.615300E+03,2.885500E+03,6.450500E+03,&
     & 1.918000E+04,8.486501E+04,9.677800E-02,2.436900E-01,4.204200E-01,&
     & 7.685600E-01,1.460000E+00,3.092200E+00,7.754500E+00,2.618800E+01,&
     & 1.970700E+02,8.080300E+02,1.443200E+03,3.225700E+03,9.590700E+03,&
     & 4.243258E+04,2.056700E-03,5.719500E-03,1.133900E-02,2.183400E-02,&
     & 4.281700E-02,8.988200E-02,2.070400E-01,5.792500E-01,2.492100E+00,&
     & 7.007400E+00,9.557500E+00,1.285800E+01,1.738700E+01,2.798092E+01,&
     & 3.255900E-01,8.061900E-01,1.353300E+00,2.526800E+00,4.857100E+00,&
     & 1.066200E+01,2.894800E+01,1.080800E+02,8.132800E+02,3.329100E+03,&
     & 5.852800E+03,1.271900E+04,3.793000E+04,1.675289E+05,2.668600E-01,&
     & 6.473700E-01,1.094100E+00,2.014900E+00,3.801200E+00,8.137100E+00,&
     & 2.181400E+01,8.119300E+01,6.100700E+02,2.497000E+03,4.389800E+03,&
     & 9.539200E+03,2.844800E+04,1.256466E+05,1.909600E-01,4.575300E-01,&
     & 7.833900E-01,1.440300E+00,2.722700E+00,5.735700E+00,1.482500E+01,&
     & 5.431500E+01,4.068800E+02,1.664900E+03,2.926800E+03,6.359700E+03,&
     & 1.896500E+04,8.376531E+04,1.071900E-01,2.533400E-01,4.430800E-01,&
     & 8.096800E-01,1.530400E+00,3.238200E+00,8.089200E+00,2.769300E+01,&
     & 2.037000E+02,8.328200E+02,1.463800E+03,3.180300E+03,9.483200E+03,&
     & 4.188274E+04,2.223000E-03,5.974400E-03,1.173700E-02,2.256700E-02,&
     & 4.465800E-02,9.340700E-02,2.147500E-01,5.961500E-01,2.496900E+00,&
     & 6.913800E+00,9.432000E+00,1.262800E+01,1.687300E+01,2.681908E+01/
      data   absb(:,321:340) /                                          &
     & 3.621700E-01,8.353100E-01,1.431500E+00,2.678200E+00,5.137900E+00,&
     & 1.127900E+01,3.045900E+01,1.147500E+02,8.395600E+02,3.433400E+03,&
     & 5.994600E+03,1.262300E+04,3.746700E+04,1.649730E+05,2.951100E-01,&
     & 6.714700E-01,1.156300E+00,2.129000E+00,4.007100E+00,8.594700E+00,&
     & 2.294300E+01,8.619500E+01,6.297900E+02,2.575300E+03,4.496100E+03,&
     & 9.467200E+03,2.810000E+04,1.237305E+05,2.101300E-01,4.754500E-01,&
     & 8.286800E-01,1.519600E+00,2.865800E+00,6.037700E+00,1.555100E+01,&
     & 5.765200E+01,4.200100E+02,1.717100E+03,2.997700E+03,6.311700E+03,&
     & 1.873400E+04,8.248801E+04,1.170700E-01,2.639100E-01,4.685500E-01,&
     & 8.534400E-01,1.609100E+00,3.401500E+00,8.440900E+00,2.931800E+01,&
     & 2.102500E+02,8.588900E+02,1.499300E+03,3.156200E+03,9.367500E+03,&
     & 4.124329E+04,2.367800E-03,6.195100E-03,1.205400E-02,2.312000E-02,&
     & 4.610600E-02,9.677000E-02,2.224000E-01,6.128900E-01,2.508500E+00,&
     & 6.783600E+00,9.204800E+00,1.234200E+01,1.640000E+01,2.566566E+01,&
     & 1.763900E-01,5.560500E-01,9.486700E-01,1.702100E+00,3.339300E+00,&
     & 7.311200E+00,1.999700E+01,7.530900E+01,6.110000E+02,2.597300E+03,&
     & 4.754700E+03,1.091700E+04,3.389000E+04,1.745835E+05,1.478600E-01,&
     & 4.511800E-01,7.698700E-01,1.384400E+00,2.659000E+00,5.672500E+00,&
     & 1.514500E+01,5.659900E+01,4.583800E+02,1.948100E+03,3.566200E+03,&
     & 8.187700E+03,2.541800E+04,1.309421E+05,1.073500E-01,3.203900E-01,&
     & 5.492900E-01,9.941000E-01,1.912600E+00,4.068900E+00,1.054100E+01,&
     & 3.796300E+01,3.057700E+02,1.299000E+03,2.377700E+03,5.458800E+03,&
     & 1.694600E+04,8.729517E+04,6.168000E-02,1.785500E-01,3.078800E-01,&
     & 5.635800E-01,1.081200E+00,2.312300E+00,5.920300E+00,1.991100E+01,&
     & 1.531900E+02,6.498600E+02,1.189200E+03,2.729900E+03,8.473400E+03,&
     & 4.364732E+04,1.416700E-03,4.234600E-03,8.582700E-03,1.661000E-02,&
     & 3.287200E-02,7.064000E-02,1.673400E-01,4.883200E-01,2.344200E+00,&
     & 7.130100E+00,1.012700E+01,1.421300E+01,1.992000E+01,3.309137E+01,&
     & 2.037300E-01,5.868300E-01,9.795700E-01,1.796700E+00,3.499800E+00,&
     & 7.695000E+00,2.109800E+01,7.940200E+01,6.340600E+02,2.680900E+03,&
     & 4.796900E+03,1.071100E+04,3.362100E+04,1.728587E+05,1.697200E-01,&
     & 4.739200E-01,7.972100E-01,1.455800E+00,2.784000E+00,5.953500E+00,&
     & 1.595800E+01,5.967200E+01,4.756800E+02,2.010900E+03,3.597900E+03,&
     & 8.033200E+03,2.521600E+04,1.296409E+05,1.227100E-01,3.356600E-01,&
     & 5.705000E-01,1.044600E+00,2.004200E+00,4.263400E+00,1.106000E+01,&
     & 3.999500E+01,3.173000E+02,1.340800E+03,2.398900E+03,5.355700E+03,&
     & 1.681100E+04,8.642927E+04,7.000800E-02,1.864700E-01,3.218900E-01,&
     & 5.916300E-01,1.132200E+00,2.422700E+00,6.192900E+00,2.086300E+01,&
     & 1.589300E+02,6.707800E+02,1.199900E+03,2.678300E+03,8.406000E+03,&
     & 4.321446E+04,1.571200E-03,4.504200E-03,9.022500E-03,1.747800E-02,&
     & 3.465500E-02,7.401000E-02,1.747100E-01,5.053100E-01,2.361800E+00,&
     & 7.154600E+00,1.001400E+01,1.397900E+01,1.938200E+01,3.186726E+01,&
     & 2.318900E-01,6.122900E-01,1.020900E+00,1.902900E+00,3.683900E+00,&
     & 8.106600E+00,2.223800E+01,8.436500E+01,6.565800E+02,2.774800E+03,&
     & 4.891600E+03,1.060200E+04,3.333200E+04,1.707162E+05,1.921800E-01,&
     & 4.938000E-01,8.319800E-01,1.536600E+00,2.924400E+00,6.253800E+00,&
     & 1.680200E+01,6.340300E+01,4.925500E+02,2.081300E+03,3.668900E+03,&
     & 7.951400E+03,2.499900E+04,1.280361E+05,1.383000E-01,3.497200E-01,&
     & 5.969900E-01,1.101500E+00,2.104400E+00,4.471900E+00,1.159400E+01,&
     & 4.247200E+01,3.285400E+02,1.387800E+03,2.446200E+03,5.301200E+03,&
     & 1.666700E+04,8.535819E+04,7.835100E-02,1.940400E-01,3.386200E-01,&
     & 6.231400E-01,1.189200E+00,2.538700E+00,6.472700E+00,2.202900E+01,&
     & 1.645500E+02,6.942600E+02,1.223500E+03,2.651000E+03,8.333800E+03,&
     & 4.267873E+04,1.715500E-03,4.738200E-03,9.390800E-03,1.816800E-02,&
     & 3.628900E-02,7.727100E-02,1.819600E-01,5.235700E-01,2.377000E+00,&
     & 7.135900E+00,9.956700E+00,1.367700E+01,1.874000E+01,3.063213E+01/
      data   absb(:,341:360) /                                          &
     & 2.609600E-01,6.348800E-01,1.074200E+00,2.016700E+00,3.897100E+00,&
     & 8.579400E+00,2.340700E+01,8.975100E+01,6.791500E+02,2.865600E+03,&
     & 5.033900E+03,1.060400E+04,3.300200E+04,1.682255E+05,2.147800E-01,&
     & 5.128100E-01,8.756100E-01,1.624000E+00,3.083400E+00,6.601400E+00,&
     & 1.766800E+01,6.744700E+01,5.094800E+02,2.149400E+03,3.775600E+03,&
     & 7.953500E+03,2.475200E+04,1.261718E+05,1.538800E-01,3.634300E-01,&
     & 6.295100E-01,1.163300E+00,2.216500E+00,4.708600E+00,1.214100E+01,&
     & 4.516900E+01,3.398100E+02,1.433200E+03,2.517400E+03,5.302600E+03,&
     & 1.650100E+04,8.411344E+04,8.643700E-02,2.020600E-01,3.577600E-01,&
     & 6.575800E-01,1.251400E+00,2.668600E+00,6.759600E+00,2.330700E+01,&
     & 1.701600E+02,7.169400E+02,1.259100E+03,2.651700E+03,8.251200E+03,&
     & 4.205733E+04,1.848200E-03,4.937300E-03,9.695200E-03,1.869500E-02,&
     & 3.761400E-02,8.045000E-02,1.892100E-01,5.416500E-01,2.396400E+00,&
     & 7.038800E+00,9.843000E+00,1.341000E+01,1.817600E+01,2.926215E+01,&
     & 2.892100E-01,6.588600E-01,1.141000E+00,2.138600E+00,4.126600E+00,&
     & 9.109900E+00,2.469800E+01,9.543200E+01,7.024700E+02,2.955400E+03,&
     & 5.188100E+03,1.073000E+04,3.265600E+04,1.653893E+05,2.365800E-01,&
     & 5.329800E-01,9.290700E-01,1.716900E+00,3.254200E+00,6.990900E+00,&
     & 1.862900E+01,7.170800E+01,5.269600E+02,2.216700E+03,3.891300E+03,&
     & 8.047700E+03,2.449200E+04,1.240450E+05,1.686400E-01,3.784700E-01,&
     & 6.683700E-01,1.228400E+00,2.337900E+00,4.973500E+00,1.274900E+01,&
     & 4.800500E+01,3.514600E+02,1.478000E+03,2.594400E+03,5.365400E+03,&
     & 1.632800E+04,8.269665E+04,9.401600E-02,2.109200E-01,3.790700E-01,&
     & 6.940000E-01,1.319900E+00,2.815800E+00,7.065400E+00,2.465700E+01,&
     & 1.759800E+02,7.393600E+02,1.297600E+03,2.683100E+03,8.164600E+03,&
     & 4.134806E+04,1.962800E-03,5.111200E-03,9.934500E-03,1.909600E-02,&
     & 3.853500E-02,8.338000E-02,1.964800E-01,5.601800E-01,2.422200E+00,&
     & 6.930900E+00,9.587900E+00,1.309900E+01,1.762000E+01,2.792595E+01,&
     & 1.481600E-01,4.576600E-01,7.755800E-01,1.405700E+00,2.758700E+00,&
     & 6.074400E+00,1.675600E+01,6.403600E+01,5.284400E+02,2.304000E+03,&
     & 4.143400E+03,9.174900E+03,3.016600E+04,1.815038E+05,1.244600E-01,&
     & 3.719400E-01,6.332400E-01,1.150000E+00,2.218600E+00,4.760600E+00,&
     & 1.274500E+01,4.814700E+01,3.964600E+02,1.728200E+03,3.107800E+03,&
     & 6.881400E+03,2.262400E+04,1.361281E+05,9.038100E-02,2.641800E-01,&
     & 4.527900E-01,8.266300E-01,1.597100E+00,3.436800E+00,8.978000E+00,&
     & 3.240500E+01,2.644900E+02,1.152400E+03,2.072100E+03,4.587900E+03,&
     & 1.508300E+04,9.075321E+04,5.188400E-02,1.472800E-01,2.546800E-01,&
     & 4.700900E-01,9.046700E-01,1.953400E+00,5.090600E+00,1.731000E+01,&
     & 1.325900E+02,5.765700E+02,1.036500E+03,2.294400E+03,7.542300E+03,&
     & 4.537669E+04,1.190500E-03,3.526600E-03,7.141400E-03,1.392500E-02,&
     & 2.786300E-02,6.040400E-02,1.459600E-01,4.358400E-01,2.203200E+00,&
     & 7.180500E+00,1.043800E+01,1.500000E+01,2.137600E+01,3.608948E+01,&
     & 1.705200E-01,4.811600E-01,8.037400E-01,1.487900E+00,2.901200E+00,&
     & 6.401000E+00,1.768200E+01,6.809800E+01,5.478900E+02,2.393800E+03,&
     & 4.244900E+03,9.115700E+03,2.999600E+04,1.793961E+05,1.424300E-01,&
     & 3.897100E-01,6.579300E-01,1.213200E+00,2.331700E+00,4.999600E+00,&
     & 1.342200E+01,5.119800E+01,4.110500E+02,1.795600E+03,3.183900E+03,&
     & 6.837000E+03,2.249700E+04,1.345471E+05,1.029700E-01,2.762700E-01,&
     & 4.721900E-01,8.712800E-01,1.679300E+00,3.606400E+00,9.416700E+00,&
     & 3.440600E+01,2.742100E+02,1.197300E+03,2.122900E+03,4.558300E+03,&
     & 1.499800E+04,8.969795E+04,5.870800E-02,1.535900E-01,2.674600E-01,&
     & 4.947600E-01,9.514800E-01,2.049500E+00,5.332000E+00,1.825000E+01,&
     & 1.374200E+02,5.990200E+02,1.061900E+03,2.279600E+03,7.499800E+03,&
     & 4.484959E+04,1.315300E-03,3.738800E-03,7.483200E-03,1.455200E-02,&
     & 2.931000E-02,6.339100E-02,1.526300E-01,4.542000E-01,2.233100E+00,&
     & 7.226500E+00,1.037500E+01,1.470600E+01,2.076300E+01,3.462244E+01/
      data   absb(:,361:380) /                                          &
     & 1.936900E-01,5.014100E-01,8.400200E-01,1.576900E+00,3.065300E+00,&
     & 6.771200E+00,1.863900E+01,7.262300E+01,5.677800E+02,2.477600E+03,&
     & 4.381400E+03,9.187300E+03,2.978700E+04,1.769085E+05,1.608500E-01,&
     & 4.059200E-01,6.887400E-01,1.282100E+00,2.457700E+00,5.271300E+00,&
     & 1.412300E+01,5.460200E+01,4.259500E+02,1.858400E+03,3.286300E+03,&
     & 6.890700E+03,2.234100E+04,1.326828E+05,1.157500E-01,2.877900E-01,&
     & 4.956700E-01,9.203600E-01,1.769400E+00,3.797900E+00,9.865300E+00,&
     & 3.665600E+01,2.841400E+02,1.239200E+03,2.191100E+03,4.594100E+03,&
     & 1.489400E+04,8.845432E+04,6.549300E-02,1.598900E-01,2.820300E-01,&
     & 5.222900E-01,1.002600E+00,2.155600E+00,5.581400E+00,1.930300E+01,&
     & 1.423600E+02,6.199600E+02,1.096000E+03,2.297500E+03,7.447600E+03,&
     & 4.422865E+04,1.430900E-03,3.922000E-03,7.767400E-03,1.505900E-02,&
     & 3.050000E-02,6.629300E-02,1.594600E-01,4.732600E-01,2.262300E+00,&
     & 7.216000E+00,1.031400E+01,1.443100E+01,2.001500E+01,3.316024E+01,&
     & 2.172900E-01,5.199800E-01,8.879800E-01,1.673400E+00,3.249100E+00,&
     & 7.198600E+00,1.967200E+01,7.744300E+01,5.885000E+02,2.559200E+03,&
     & 4.534400E+03,9.384000E+03,2.958100E+04,1.740465E+05,1.792300E-01,&
     & 4.217100E-01,7.282700E-01,1.357600E+00,2.596800E+00,5.584600E+00,&
     & 1.488400E+01,5.821700E+01,4.414900E+02,1.919600E+03,3.401000E+03,&
     & 7.038200E+03,2.218600E+04,1.305382E+05,1.283400E-01,2.994000E-01,&
     & 5.248300E-01,9.738800E-01,1.869600E+00,4.015300E+00,1.034900E+01,&
     & 3.905000E+01,2.944900E+02,1.279900E+03,2.267600E+03,4.692400E+03,&
     & 1.479100E+04,8.702669E+04,7.195100E-02,1.668000E-01,2.986600E-01,&
     & 5.522400E-01,1.059300E+00,2.277200E+00,5.843300E+00,2.042600E+01,&
     & 1.475100E+02,6.403100E+02,1.134200E+03,2.346700E+03,7.396200E+03,&
     & 4.351327E+04,1.537000E-03,4.080300E-03,7.999300E-03,1.544800E-02,&
     & 3.138900E-02,6.900700E-02,1.664100E-01,4.923900E-01,2.300900E+00,&
     & 7.101900E+00,1.017800E+01,1.413700E+01,1.940700E+01,3.155098E+01,&
     & 2.399400E-01,5.404900E-01,9.467000E-01,1.776100E+00,3.444300E+00,&
     & 7.675500E+00,2.085300E+01,8.232100E+01,6.109000E+02,2.634400E+03,&
     & 4.703500E+03,9.648800E+03,2.940600E+04,1.708871E+05,1.966300E-01,&
     & 4.392600E-01,7.758500E-01,1.436400E+00,2.743200E+00,5.935700E+00,&
     & 1.575900E+01,6.187500E+01,4.582900E+02,1.976000E+03,3.527800E+03,&
     & 7.236800E+03,2.205500E+04,1.281690E+05,1.401500E-01,3.124100E-01,&
     & 5.589000E-01,1.029700E+00,1.975200E+00,4.258500E+00,1.090200E+01,&
     & 4.147600E+01,3.056700E+02,1.317600E+03,2.352100E+03,4.824900E+03,&
     & 1.470300E+04,8.544478E+04,7.796800E-02,1.744500E-01,3.172200E-01,&
     & 5.835100E-01,1.120400E+00,2.412700E+00,6.133300E+00,2.155700E+01,&
     & 1.530900E+02,6.591400E+02,1.176400E+03,2.412900E+03,7.352200E+03,&
     & 4.272319E+04,1.626500E-03,4.217100E-03,8.181000E-03,1.574100E-02,&
     & 3.199400E-02,7.124700E-02,1.734500E-01,5.119200E-01,2.338200E+00,&
     & 7.053300E+00,9.918400E+00,1.377500E+01,1.877000E+01,3.001058E+01,&
     & 1.278600E-01,3.865600E-01,6.524700E-01,1.194400E+00,2.346100E+00,&
     & 5.186600E+00,1.440500E+01,5.623400E+01,4.682600E+02,2.101600E+03,&
     & 3.771200E+03,8.030700E+03,2.732600E+04,1.923375E+05,1.074300E-01,&
     & 3.144000E-01,5.350500E-01,9.809200E-01,1.901900E+00,4.103300E+00,&
     & 1.101600E+01,4.229900E+01,3.513300E+02,1.576400E+03,2.828700E+03,&
     & 6.023200E+03,2.049500E+04,1.442542E+05,7.794700E-02,2.232200E-01,&
     & 3.830900E-01,7.055500E-01,1.368400E+00,2.972400E+00,7.839500E+00,&
     & 2.859700E+01,2.344000E+02,1.051200E+03,1.886100E+03,4.015800E+03,&
     & 1.366400E+04,9.617023E+04,4.462400E-02,1.243100E-01,2.160600E-01,&
     & 4.014800E-01,7.760100E-01,1.687800E+00,4.469100E+00,1.553100E+01,&
     & 1.176300E+02,5.259700E+02,9.435100E+02,2.008300E+03,6.832400E+03,&
     & 4.808475E+04,1.000100E-03,2.934100E-03,5.931300E-03,1.160700E-02,&
     & 2.353400E-02,5.157100E-02,1.269000E-01,3.895800E-01,2.068000E+00,&
     & 7.194300E+00,1.068800E+01,1.571100E+01,2.273200E+01,3.891888E+01/
      data   absb(:,381:400) /                                          &
     & 1.466800E-01,4.053900E-01,6.780500E-01,1.266900E+00,2.476000E+00,&
     & 5.486100E+00,1.520600E+01,6.008800E+01,4.859000E+02,2.183200E+03,&
     & 3.903200E+03,8.144600E+03,2.723600E+04,1.898437E+05,1.226200E-01,&
     & 3.288800E-01,5.576500E-01,1.037700E+00,2.005900E+00,4.323900E+00,&
     & 1.159400E+01,4.519900E+01,3.645400E+02,1.637600E+03,2.927600E+03,&
     & 6.108700E+03,2.042800E+04,1.423802E+05,8.853300E-02,2.332100E-01,&
     & 4.008800E-01,7.457700E-01,1.443900E+00,3.130500E+00,8.223600E+00,&
     & 3.048600E+01,2.432100E+02,1.092000E+03,1.952000E+03,4.072700E+03,&
     & 1.361900E+04,9.492047E+04,5.035000E-02,1.295200E-01,2.276300E-01,&
     & 4.238600E-01,8.194400E-01,1.776500E+00,4.690700E+00,1.643000E+01,&
     & 1.219700E+02,5.463700E+02,9.764400E+02,2.036800E+03,6.810000E+03,&
     & 4.746040E+04,1.100700E-03,3.100800E-03,6.196400E-03,1.207300E-02,&
     & 2.461100E-02,5.421900E-02,1.331000E-01,4.086500E-01,2.110000E+00,&
     & 7.256200E+00,1.067900E+01,1.538400E+01,2.204100E+01,3.718710E+01,&
     & 1.662400E-01,4.220800E-01,7.113800E-01,1.343400E+00,2.623500E+00,&
     & 5.832000E+00,1.605500E+01,6.420600E+01,5.044500E+02,2.262600E+03,&
     & 4.057100E+03,8.378400E+03,2.717400E+04,1.869241E+05,1.380900E-01,&
     & 3.425600E-01,5.860200E-01,1.098200E+00,2.120900E+00,4.579500E+00,&
     & 1.221000E+01,4.829200E+01,3.784600E+02,1.697100E+03,3.043000E+03,&
     & 6.284100E+03,2.038100E+04,1.401947E+05,9.925900E-02,2.429100E-01,&
     & 4.223400E-01,7.891600E-01,1.526800E+00,3.313000E+00,8.624800E+00,&
     & 3.251500E+01,2.524700E+02,1.131600E+03,2.028900E+03,4.189700E+03,&
     & 1.358800E+04,9.346337E+04,5.594900E-02,1.350500E-01,2.405100E-01,&
     & 4.481900E-01,8.668700E-01,1.878200E+00,4.920000E+00,1.738500E+01,&
     & 1.265500E+02,5.661800E+02,1.014800E+03,2.095300E+03,6.794500E+03,&
     & 4.673177E+04,1.193600E-03,3.245600E-03,6.417000E-03,1.245400E-02,&
     & 2.543400E-02,5.669000E-02,1.396000E-01,4.280000E-01,2.156700E+00,&
     & 7.235600E+00,1.062300E+01,1.512300E+01,2.117000E+01,3.549151E+01,&
     & 1.858200E-01,4.378800E-01,7.556500E-01,1.427600E+00,2.783600E+00,&
     & 6.224700E+00,1.703000E+01,6.849600E+01,5.247400E+02,2.336700E+03,&
     & 4.227200E+03,8.664800E+03,2.719100E+04,1.836680E+05,1.533600E-01,&
     & 3.561800E-01,6.227100E-01,1.164200E+00,2.244100E+00,4.868600E+00,&
     & 1.292400E+01,5.151000E+01,3.936700E+02,1.752700E+03,3.170600E+03,&
     & 6.498900E+03,2.039400E+04,1.377534E+05,1.096400E-01,2.531100E-01,&
     & 4.491300E-01,8.360500E-01,1.616000E+00,3.518800E+00,9.082300E+00,&
     & 3.463000E+01,2.626000E+02,1.168700E+03,2.113900E+03,4.332900E+03,&
     & 1.359600E+04,9.183671E+04,6.125100E-02,1.410800E-01,2.553100E-01,&
     & 4.746300E-01,9.184900E-01,1.994000E+00,5.174700E+00,1.836800E+01,&
     & 1.315900E+02,5.847000E+02,1.057300E+03,2.166900E+03,6.798500E+03,&
     & 4.591844E+04,1.277400E-03,3.370700E-03,6.595600E-03,1.274700E-02,&
     & 2.604400E-02,5.875000E-02,1.462900E-01,4.478500E-01,2.209800E+00,&
     & 7.167200E+00,1.045400E+01,1.479100E+01,2.053300E+01,3.362173E+01,&
     & 2.044700E-01,4.559900E-01,8.081000E-01,1.517400E+00,2.956200E+00,&
     & 6.655800E+00,1.815200E+01,7.293300E+01,5.472000E+02,2.405200E+03,&
     & 4.403100E+03,9.006500E+03,2.730600E+04,1.800376E+05,1.676000E-01,&
     & 3.719700E-01,6.653600E-01,1.234000E+00,2.375300E+00,5.187100E+00,&
     & 1.375200E+01,5.483100E+01,4.105100E+02,1.804100E+03,3.302500E+03,&
     & 6.755100E+03,2.048000E+04,1.350287E+05,1.192900E-01,2.647500E-01,&
     & 4.793100E-01,8.857200E-01,1.712000E+00,3.744600E+00,9.612300E+00,&
     & 3.681400E+01,2.738200E+02,1.203000E+03,2.201800E+03,4.503700E+03,&
     & 1.365400E+04,9.002022E+04,6.612700E-02,1.478400E-01,2.718600E-01,&
     & 5.024200E-01,9.738900E-01,2.121400E+00,5.465300E+00,1.937400E+01,&
     & 1.371700E+02,6.018600E+02,1.101200E+03,2.252300E+03,6.827300E+03,&
     & 4.501046E+04,1.348100E-03,3.477800E-03,6.735600E-03,1.296200E-02,&
     & 2.644900E-02,6.024300E-02,1.530600E-01,4.683000E-01,2.262000E+00,&
     & 7.180600E+00,1.016800E+01,1.434300E+01,1.980300E+01,3.190050E+01/
      data   absb(:,401:420) /                                          &
     & 1.172300E-01,3.466300E-01,5.835900E-01,1.079600E+00,2.122900E+00,&
     & 4.714200E+00,1.314900E+01,5.252200E+01,4.407200E+02,2.021300E+03,&
     & 3.687900E+03,7.647100E+03,2.610700E+04,2.148846E+05,9.820300E-02,&
     & 2.814700E-01,4.792200E-01,8.873800E-01,1.728100E+00,3.752400E+00,&
     & 1.009900E+01,3.952400E+01,3.306700E+02,1.516200E+03,2.766100E+03,&
     & 5.735600E+03,1.958000E+04,1.611622E+05,7.100600E-02,1.993500E-01,&
     & 3.429900E-01,6.372900E-01,1.241100E+00,2.716200E+00,7.231200E+00,&
     & 2.682500E+01,2.206300E+02,1.011000E+03,1.844400E+03,3.824000E+03,&
     & 1.305400E+04,1.074417E+05,4.041300E-02,1.105300E-01,1.933000E-01,&
     & 3.614000E-01,7.025800E-01,1.536500E+00,4.126900E+00,1.472100E+01,&
     & 1.108200E+02,5.059200E+02,9.226000E+02,1.912400E+03,6.527600E+03,&
     & 5.372171E+04,8.408200E-04,2.440700E-03,4.922200E-03,9.646900E-03,&
     & 1.976700E-02,4.403900E-02,1.101600E-01,3.492400E-01,1.941900E+00,&
     & 7.182600E+00,1.091400E+01,1.634100E+01,2.395200E+01,4.148452E+01,&
     & 1.341000E-01,3.628800E-01,6.083600E-01,1.146200E+00,2.248300E+00,&
     & 5.009000E+00,1.389200E+01,5.633000E+01,4.582100E+02,2.102500E+03,&
     & 3.844000E+03,7.907100E+03,2.617800E+04,2.118226E+05,1.118100E-01,&
     & 2.941600E-01,5.010500E-01,9.401200E-01,1.828600E+00,3.972300E+00,&
     & 1.063300E+01,4.238700E+01,3.437800E+02,1.577100E+03,2.883200E+03,&
     & 5.930600E+03,1.963400E+04,1.588672E+05,8.044400E-02,2.082500E-01,&
     & 3.599200E-01,6.748100E-01,1.314200E+00,2.875400E+00,7.591600E+00,&
     & 2.868300E+01,2.293600E+02,1.051600E+03,1.922400E+03,3.954000E+03,&
     & 1.309000E+04,1.059115E+05,4.546200E-02,1.152500E-01,2.040200E-01,&
     & 3.824100E-01,7.443800E-01,1.625800E+00,4.339100E+00,1.561800E+01,&
     & 1.151100E+02,5.261800E+02,9.615700E+02,1.977500E+03,6.545300E+03,&
     & 5.295610E+04,9.220100E-04,2.572600E-03,5.127900E-03,1.000600E-02,&
     & 2.052600E-02,4.627700E-02,1.161400E-01,3.682200E-01,1.999800E+00,&
     & 7.244900E+00,1.094500E+01,1.601300E+01,2.312800E+01,3.948797E+01,&
     & 1.515900E-01,3.773800E-01,6.416900E-01,1.216600E+00,2.386700E+00,&
     & 5.348000E+00,1.473500E+01,6.027100E+01,4.772900E+02,2.181700E+03,&
     & 4.013400E+03,8.229200E+03,2.637300E+04,2.082939E+05,1.255600E-01,&
     & 3.063600E-01,5.292900E-01,9.967600E-01,1.937600E+00,4.223600E+00,&
     & 1.124200E+01,4.534300E+01,3.580800E+02,1.636500E+03,3.010200E+03,&
     & 6.172100E+03,1.978000E+04,1.562241E+05,8.994300E-02,2.169600E-01,&
     & 3.809600E-01,7.154900E-01,1.393200E+00,3.056500E+00,7.995800E+00,&
     & 3.060600E+01,2.388900E+02,1.091200E+03,2.007000E+03,4.115100E+03,&
     & 1.318700E+04,1.041496E+05,5.034200E-02,1.203400E-01,2.161300E-01,&
     & 4.053400E-01,7.899000E-01,1.728600E+00,4.571800E+00,1.653100E+01,&
     & 1.198000E+02,5.459600E+02,1.003800E+03,2.058000E+03,6.594100E+03,&
     & 5.207491E+04,9.965200E-04,2.687600E-03,5.298900E-03,1.029100E-02,&
     & 2.112100E-02,4.815600E-02,1.223700E-01,3.878400E-01,2.067100E+00,&
     & 7.220000E+00,1.085300E+01,1.573200E+01,2.227600E+01,3.744912E+01,&
     & 1.687800E-01,3.920800E-01,6.841800E-01,1.295000E+00,2.537000E+00,&
     & 5.729200E+00,1.571700E+01,6.438900E+01,4.988200E+02,2.255600E+03,&
     & 4.190900E+03,8.624000E+03,2.667400E+04,2.043685E+05,1.389200E-01,&
     & 3.191100E-01,5.647900E-01,1.058000E+00,2.054400E+00,4.507400E+00,&
     & 1.195700E+01,4.843100E+01,3.742200E+02,1.691900E+03,3.143300E+03,&
     & 6.468200E+03,2.000600E+04,1.532757E+05,9.899100E-02,2.264800E-01,&
     & 4.065900E-01,7.591300E-01,1.478200E+00,3.262200E+00,8.460900E+00,&
     & 3.262300E+01,2.496400E+02,1.128200E+03,2.095700E+03,4.312500E+03,&
     & 1.333800E+04,1.021834E+05,5.494500E-02,1.258900E-01,2.301000E-01,&
     & 4.298900E-01,8.393600E-01,1.844200E+00,4.836600E+00,1.746800E+01,&
     & 1.251200E+02,5.644700E+02,1.048100E+03,2.156700E+03,6.669300E+03,&
     & 5.109277E+04,1.062400E-03,2.788100E-03,5.437600E-03,1.051200E-02,&
     & 2.154000E-02,4.956000E-02,1.287800E-01,4.081400E-01,2.134100E+00,&
     & 7.259100E+00,1.057800E+01,1.537200E+01,2.152600E+01,3.540818E+01/
      data   absb(:,421:440) /                                          &
     & 1.850600E-01,4.088600E-01,7.338800E-01,1.379600E+00,2.700500E+00,&
     & 6.132900E+00,1.685000E+01,6.866900E+01,5.233100E+02,2.324600E+03,&
     & 4.372600E+03,9.059800E+03,2.707000E+04,2.000922E+05,1.513300E-01,&
     & 3.338900E-01,6.048700E-01,1.124600E+00,2.180800E+00,4.805800E+00,&
     & 1.279000E+01,5.163300E+01,3.925900E+02,1.743600E+03,3.279600E+03,&
     & 6.795100E+03,2.030300E+04,1.500652E+05,1.073300E-01,2.374000E-01,&
     & 4.348700E-01,8.067000E-01,1.570900E+00,3.477100E+00,8.999100E+00,&
     & 3.471300E+01,2.618800E+02,1.162600E+03,2.186600E+03,4.530400E+03,&
     & 1.353500E+04,1.000447E+05,5.913000E-02,1.322000E-01,2.455400E-01,&
     & 4.563800E-01,8.925100E-01,1.968700E+00,5.136600E+00,1.842200E+01,&
     & 1.312100E+02,5.816700E+02,1.093600E+03,2.265700E+03,6.768100E+03,&
     & 5.002226E+04,1.118600E-03,2.869800E-03,5.545900E-03,1.067800E-02,&
     & 2.182600E-02,5.048700E-02,1.350400E-01,4.295300E-01,2.197900E+00,&
     & 7.291200E+00,1.040300E+01,1.476700E+01,2.070300E+01,3.351680E+01,&
     & 1.101700E-01,3.185900E-01,5.355900E-01,1.000900E+00,1.973100E+00,&
     & 4.403800E+00,1.231400E+01,5.033500E+01,4.255600E+02,1.989100E+03,&
     & 3.719200E+03,7.632300E+03,2.556500E+04,2.445740E+05,9.191500E-02,&
     & 2.580700E-01,4.398700E-01,8.225400E-01,1.609800E+00,3.521100E+00,&
     & 9.494500E+00,3.789600E+01,3.193000E+02,1.492000E+03,2.789600E+03,&
     & 5.724500E+03,1.917400E+04,1.834291E+05,6.615800E-02,1.822600E-01,&
     & 3.144600E-01,5.893400E-01,1.153400E+00,2.544700E+00,6.824300E+00,&
     & 2.581000E+01,2.130500E+02,9.948900E+02,1.860000E+03,3.816600E+03,&
     & 1.278300E+04,1.222858E+05,3.738500E-02,1.005200E-01,1.768100E-01,&
     & 3.327100E-01,6.509700E-01,1.433600E+00,3.890300E+00,1.427100E+01,&
     & 1.071100E+02,4.978300E+02,9.303500E+02,1.908800E+03,6.392100E+03,&
     & 6.114326E+04,7.071600E-04,2.028600E-03,4.081200E-03,8.005800E-03,&
     & 1.649800E-02,3.752800E-02,9.572100E-02,3.134700E-01,1.830900E+00,&
     & 7.169600E+00,1.114100E+01,1.683200E+01,2.501500E+01,4.373864E+01,&
     & 1.257100E-01,3.330000E-01,5.609200E-01,1.063100E+00,2.095800E+00,&
     & 4.699600E+00,1.305400E+01,5.410000E+01,4.440700E+02,2.070400E+03,&
     & 3.894400E+03,7.985600E+03,2.592400E+04,2.407870E+05,1.043800E-01,&
     & 2.696000E-01,4.619500E-01,8.725600E-01,1.708800E+00,3.744100E+00,&
     & 1.002400E+01,4.071900E+01,3.331700E+02,1.553000E+03,2.921000E+03,&
     & 5.989400E+03,1.944300E+04,1.805880E+05,7.479100E-02,1.903800E-01,&
     & 3.312300E-01,6.253300E-01,1.225700E+00,2.706700E+00,7.188700E+00,&
     & 2.763300E+01,2.222900E+02,1.035500E+03,1.947500E+03,3.993300E+03,&
     & 1.296200E+04,1.203926E+05,4.193700E-02,1.049300E-01,1.869900E-01,&
     & 3.530500E-01,6.920800E-01,1.525700E+00,4.105400E+00,1.516500E+01,&
     & 1.116100E+02,5.181200E+02,9.741100E+02,1.997200E+03,6.481800E+03,&
     & 6.019817E+04,7.722200E-04,2.134500E-03,4.241000E-03,8.280000E-03,&
     & 1.705400E-02,3.926200E-02,1.014200E-01,3.323400E-01,1.910100E+00,&
     & 7.199600E+00,1.113900E+01,1.659200E+01,2.402600E+01,4.148204E+01,&
     & 1.416500E-01,3.460800E-01,5.946700E-01,1.130800E+00,2.228500E+00,&
     & 5.039600E+00,1.392100E+01,5.797500E+01,4.650500E+02,2.148600E+03,&
     & 4.075300E+03,8.425600E+03,2.642500E+04,2.364889E+05,1.168800E-01,&
     & 2.807900E-01,4.906100E-01,9.271000E-01,1.813900E+00,3.998300E+00,&
     & 1.065000E+01,4.362500E+01,3.489000E+02,1.611700E+03,3.056600E+03,&
     & 6.319500E+03,1.981900E+04,1.773677E+05,8.336100E-02,1.984900E-01,&
     & 3.523400E-01,6.642000E-01,1.302200E+00,2.892100E+00,7.609300E+00,&
     & 2.951100E+01,2.327600E+02,1.074700E+03,2.037900E+03,4.213300E+03,&
     & 1.321300E+04,1.182430E+05,4.629500E-02,1.096800E-01,1.988000E-01,&
     & 3.748100E-01,7.364200E-01,1.630800E+00,4.351700E+00,1.606000E+01,&
     & 1.167600E+02,5.377300E+02,1.019200E+03,2.107200E+03,6.607000E+03,&
     & 5.912333E+04,8.320500E-04,2.226400E-03,4.375600E-03,8.496300E-03,&
     & 1.748200E-02,4.057300E-02,1.073900E-01,3.521700E-01,1.991400E+00,&
     & 7.256400E+00,1.097000E+01,1.626000E+01,2.323800E+01,3.910442E+01/
      data   absb(:,441:460) /                                          &
     & 1.570900E-01,3.600200E-01,6.362000E-01,1.206300E+00,2.372900E+00,&
     & 5.408900E+00,1.494400E+01,6.205700E+01,4.890800E+02,2.224300E+03,&
     & 4.262100E+03,8.902700E+03,2.708100E+04,2.317475E+05,1.288200E-01,&
     & 2.930300E-01,5.252900E-01,9.861700E-01,1.928000E+00,4.274400E+00,&
     & 1.139300E+01,4.668100E+01,3.669200E+02,1.668400E+03,3.196700E+03,&
     & 6.677200E+03,2.031100E+04,1.738111E+05,9.141200E-02,2.076000E-01,&
     & 3.769200E-01,7.064600E-01,1.386100E+00,3.094200E+00,8.101000E+00,&
     & 3.149000E+01,2.447700E+02,1.112500E+03,2.131300E+03,4.451800E+03,&
     & 1.354100E+04,1.158751E+05,5.035800E-02,1.149500E-01,2.121800E-01,&
     & 3.983300E-01,7.851800E-01,1.746700E+00,4.634400E+00,1.697900E+01,&
     & 1.227000E+02,5.566000E+02,1.066000E+03,2.226400E+03,6.771000E+03,&
     & 5.793681E+04,8.842200E-04,2.305200E-03,4.482000E-03,8.667800E-03,&
     & 1.779000E-02,4.147500E-02,1.132800E-01,3.732400E-01,2.070900E+00,&
     & 7.349100E+00,1.073600E+01,1.576700E+01,2.236900E+01,3.691518E+01,&
     & 1.716100E-01,3.761600E-01,6.841600E-01,1.287200E+00,2.535300E+00,&
     & 5.802600E+00,1.610400E+01,6.642900E+01,5.166000E+02,2.296900E+03,&
     & 4.454400E+03,9.413800E+03,2.786000E+04,2.265926E+05,1.398900E-01,&
     & 3.071800E-01,5.639000E-01,1.050700E+00,2.054600E+00,4.565500E+00,&
     & 1.224500E+01,4.995100E+01,3.875600E+02,1.722800E+03,3.341000E+03,&
     & 7.060600E+03,2.089600E+04,1.699410E+05,9.879800E-02,2.180200E-01,&
     & 4.042000E-01,7.530100E-01,1.478500E+00,3.305800E+00,8.656500E+00,&
     & 3.361600E+01,2.585300E+02,1.148800E+03,2.227500E+03,4.707300E+03,&
     & 1.393100E+04,1.132961E+05,5.406000E-02,1.208600E-01,2.269200E-01,&
     & 4.243300E-01,8.376700E-01,1.869300E+00,4.950100E+00,1.794700E+01,&
     & 1.295400E+02,5.747100E+02,1.114100E+03,2.354100E+03,6.965800E+03,&
     & 5.664831E+04,9.282900E-04,2.370300E-03,4.563700E-03,8.793900E-03,&
     & 1.798900E-02,4.208400E-02,1.187700E-01,3.952000E-01,2.148000E+00,&
     & 7.395000E+00,1.066300E+01,1.514000E+01,2.126300E+01,3.485642E+01,&
     & 1.089400E-01,3.080400E-01,5.181600E-01,9.766000E-01,1.934000E+00,&
     & 4.340600E+00,1.215700E+01,5.073600E+01,4.335700E+02,2.060000E+03,&
     & 3.949400E+03,8.145900E+03,2.651900E+04,2.911667E+05,9.033800E-02,&
     & 2.485400E-01,4.246400E-01,8.008400E-01,1.577200E+00,3.475600E+00,&
     & 9.387800E+00,3.820400E+01,3.253000E+02,1.545200E+03,2.962200E+03,&
     & 6.109700E+03,1.989000E+04,2.183726E+05,6.463600E-02,1.748800E-01,&
     & 3.026100E-01,5.717700E-01,1.126400E+00,2.504300E+00,6.754800E+00,&
     & 2.605700E+01,2.170400E+02,1.030300E+03,1.975000E+03,4.073500E+03,&
     & 1.326000E+04,1.455836E+05,3.617500E-02,9.577100E-02,1.692200E-01,&
     & 3.207000E-01,6.318200E-01,1.402900E+00,3.838100E+00,1.444400E+01,&
     & 1.091300E+02,5.155200E+02,9.878600E+02,2.037300E+03,6.630600E+03,&
     & 7.279032E+04,5.948900E-04,1.687900E-03,3.382500E-03,6.638200E-03,&
     & 1.373100E-02,3.183700E-02,8.334500E-02,2.819900E-01,1.745800E+00,&
     & 7.089100E+00,1.130900E+01,1.733400E+01,2.582900E+01,4.562854E+01,&
     & 1.239900E-01,3.214800E-01,5.453600E-01,1.037400E+00,2.057400E+00,&
     & 4.653000E+00,1.295500E+01,5.460700E+01,4.547800E+02,2.144200E+03,&
     & 4.149700E+03,8.624300E+03,2.726600E+04,2.862964E+05,1.023000E-01,&
     & 2.595400E-01,4.481400E-01,8.501400E-01,1.677300E+00,3.711600E+00,&
     & 9.959400E+00,4.110500E+01,3.412000E+02,1.608300E+03,3.112400E+03,&
     & 6.468500E+03,2.045000E+04,2.147207E+05,7.290000E-02,1.826100E-01,&
     & 3.201300E-01,6.073400E-01,1.199500E+00,2.676600E+00,7.149800E+00,&
     & 2.792200E+01,2.276400E+02,1.072500E+03,2.075100E+03,4.312700E+03,&
     & 1.363400E+04,1.431479E+05,4.046500E-02,1.000700E-01,1.794500E-01,&
     & 3.406900E-01,6.735800E-01,1.501400E+00,4.072800E+00,1.535800E+01,&
     & 1.143000E+02,5.366100E+02,1.037800E+03,2.156900E+03,6.817300E+03,&
     & 7.157560E+04,6.475300E-04,1.772400E-03,3.508400E-03,6.845600E-03,&
     & 1.415200E-02,3.306300E-02,8.877100E-02,3.009400E-01,1.839300E+00,&
     & 7.194000E+00,1.123300E+01,1.706400E+01,2.491700E+01,4.298598E+01/
      data   absb(:,461:480) /                                          &
     & 1.392000E-01,3.341800E-01,5.807900E-01,1.107500E+00,2.191400E+00,&
     & 5.002500E+00,1.391100E+01,5.868100E+01,4.794000E+02,2.226700E+03,&
     & 4.356400E+03,9.151800E+03,2.822900E+04,2.808694E+05,1.141900E-01,&
     & 2.704700E-01,4.782200E-01,9.058100E-01,1.784800E+00,3.975400E+00,&
     & 1.064900E+01,4.415500E+01,3.596600E+02,1.670200E+03,3.267400E+03,&
     & 6.864200E+03,2.117200E+04,2.106548E+05,8.098000E-02,1.906400E-01,&
     & 3.420300E-01,6.468100E-01,1.278100E+00,2.871600E+00,7.617400E+00,&
     & 2.988700E+01,2.399300E+02,1.113700E+03,2.178500E+03,4.576400E+03,&
     & 1.411500E+04,1.404359E+05,4.455200E-02,1.047200E-01,1.914500E-01,&
     & 3.626100E-01,7.191500E-01,1.613000E+00,4.345200E+00,1.629500E+01,&
     & 1.203500E+02,5.572000E+02,1.089500E+03,2.288700E+03,7.057900E+03,&
     & 7.021962E+04,6.950700E-04,1.846100E-03,3.613300E-03,7.012700E-03,&
     & 1.446600E-02,3.394800E-02,9.425000E-02,3.213000E-01,1.933300E+00,&
     & 7.351900E+00,1.103100E+01,1.660900E+01,2.402900E+01,4.044976E+01,&
     & 1.537300E-01,3.481600E-01,6.236000E-01,1.183400E+00,2.340600E+00,&
     & 5.378500E+00,1.501700E+01,6.306800E+01,5.080400E+02,2.306900E+03,&
     & 4.567700E+03,9.735600E+03,2.935300E+04,2.749117E+05,1.253700E-01,&
     & 2.828200E-01,5.135500E-01,9.664400E-01,1.902500E+00,4.256200E+00,&
     & 1.145600E+01,4.743600E+01,3.811500E+02,1.730300E+03,3.425900E+03,&
     & 7.301900E+03,2.201500E+04,2.061839E+05,8.847900E-02,1.997600E-01,&
     & 3.668500E-01,6.903900E-01,1.364800E+00,3.077400E+00,8.153200E+00,&
     & 3.200800E+01,2.542500E+02,1.153800E+03,2.284100E+03,4.868300E+03,&
     & 1.467700E+04,1.374563E+05,4.831700E-02,1.099000E-01,2.049500E-01,&
     & 3.867500E-01,7.692500E-01,1.731900E+00,4.655100E+00,1.727900E+01,&
     & 1.274400E+02,5.772100E+02,1.142300E+03,2.434600E+03,7.339000E+03,&
     & 6.872685E+04,7.366100E-04,1.908200E-03,3.696400E-03,7.146900E-03,&
     & 1.468700E-02,3.457000E-02,9.940600E-02,3.430000E-01,2.023400E+00,&
     & 7.478300E+00,1.101800E+01,1.584800E+01,2.298900E+01,3.811205E+01,&
     & 1.673500E-01,3.645100E-01,6.713600E-01,1.266000E+00,2.510700E+00,&
     & 5.788900E+00,1.626600E+01,6.787300E+01,5.403300E+02,2.395100E+03,&
     & 4.782300E+03,1.036500E+04,3.059000E+04,2.684968E+05,1.357700E-01,&
     & 2.970600E-01,5.524200E-01,1.032600E+00,2.035400E+00,4.559500E+00,&
     & 1.237300E+01,5.103100E+01,4.053600E+02,1.796500E+03,3.586900E+03,&
     & 7.773600E+03,2.294300E+04,2.013752E+05,9.538000E-02,2.101900E-01,&
     & 3.943300E-01,7.382500E-01,1.461200E+00,3.298900E+00,8.755200E+00,&
     & 3.434400E+01,2.703900E+02,1.197800E+03,2.391500E+03,5.182700E+03,&
     & 1.529500E+04,1.342511E+05,5.177000E-02,1.157200E-01,2.196800E-01,&
     & 4.133400E-01,8.239700E-01,1.859800E+00,5.000400E+00,1.834000E+01,&
     & 1.354800E+02,5.992200E+02,1.196000E+03,2.591800E+03,7.648100E+03,&
     & 6.712441E+04,7.710400E-04,1.957800E-03,3.763200E-03,7.236700E-03,&
     & 1.484300E-02,3.498600E-02,1.040100E-01,3.658200E-01,2.115000E+00,&
     & 7.497800E+00,1.092200E+01,1.537600E+01,2.163800E+01,3.587297E+01,&
     & 1.090000E-01,3.013400E-01,5.083600E-01,9.642200E-01,1.920400E+00,&
     & 4.339600E+00,1.218900E+01,5.181600E+01,4.489700E+02,2.160700E+03,&
     & 4.239800E+03,8.908300E+03,2.818800E+04,3.490327E+05,8.982700E-02,&
     & 2.422200E-01,4.156500E-01,7.887800E-01,1.565400E+00,3.476900E+00,&
     & 9.419000E+00,3.901900E+01,3.368500E+02,1.620700E+03,3.180000E+03,&
     & 6.681500E+03,2.114100E+04,2.617762E+05,6.390300E-02,1.698200E-01,&
     & 2.951300E-01,5.613200E-01,1.114800E+00,2.499200E+00,6.777500E+00,&
     & 2.662700E+01,2.247400E+02,1.080700E+03,2.120200E+03,4.454700E+03,&
     & 1.409500E+04,1.745167E+05,3.541000E-02,9.239100E-02,1.640100E-01,&
     & 3.128000E-01,6.214700E-01,1.393300E+00,3.839800E+00,1.477000E+01,&
     & 1.129800E+02,5.407300E+02,1.060400E+03,2.227900E+03,7.047800E+03,&
     & 8.726001E+04,5.004300E-04,1.404500E-03,2.802300E-03,5.495800E-03,&
     & 1.141100E-02,2.682700E-02,7.278000E-02,2.544900E-01,1.678700E+00,&
     & 7.092100E+00,1.139500E+01,1.773000E+01,2.646800E+01,4.714399E+01/
      data   absb(:,481:500) /                                          &
     & 1.237300E-01,3.141300E-01,5.375500E-01,1.026800E+00,2.045500E+00,&
     & 4.671400E+00,1.308400E+01,5.591400E+01,4.741900E+02,2.249900E+03,&
     & 4.475900E+03,9.497900E+03,2.947900E+04,3.428043E+05,1.014400E-01,&
     & 2.528800E-01,4.408100E-01,8.396400E-01,1.667200E+00,3.728600E+00,&
     & 1.006200E+01,4.208800E+01,3.557600E+02,1.687600E+03,3.357100E+03,&
     & 7.123700E+03,2.211000E+04,2.571099E+05,7.188000E-02,1.773200E-01,&
     & 3.137300E-01,5.976700E-01,1.189500E+00,2.684400E+00,7.222900E+00,&
     & 2.859700E+01,2.373400E+02,1.125300E+03,2.238200E+03,4.749500E+03,&
     & 1.474000E+04,1.714063E+05,3.950600E-02,9.660000E-02,1.745800E-01,&
     & 3.329500E-01,6.643100E-01,1.499700E+00,4.102000E+00,1.573500E+01,&
     & 1.191500E+02,5.630200E+02,1.119400E+03,2.375300E+03,7.370500E+03,&
     & 8.570184E+04,5.426900E-04,1.471900E-03,2.903100E-03,5.657400E-03,&
     & 1.172300E-02,2.768500E-02,7.776100E-02,2.737900E-01,1.785900E+00,&
     & 7.285300E+00,1.128200E+01,1.733100E+01,2.564100E+01,4.415534E+01,&
     & 1.382900E-01,3.267700E-01,5.751800E-01,1.099300E+00,2.183900E+00,&
     & 5.031200E+00,1.413900E+01,6.029200E+01,5.037900E+02,2.338900E+03,&
     & 4.716100E+03,1.014700E+04,3.099800E+04,3.359362E+05,1.127800E-01,&
     & 2.638600E-01,4.726000E-01,8.972900E-01,1.778500E+00,4.000200E+00,&
     & 1.082700E+01,4.536100E+01,3.779600E+02,1.754300E+03,3.537200E+03,&
     & 7.610800E+03,2.324900E+04,2.519529E+05,7.952800E-02,1.854500E-01,&
     & 3.364700E-01,6.387000E-01,1.271100E+00,2.885500E+00,7.743700E+00,&
     & 3.070000E+01,2.521300E+02,1.169800E+03,2.358300E+03,5.074200E+03,&
     & 1.550000E+04,1.679692E+05,4.336700E-02,1.012300E-01,1.868500E-01,&
     & 3.555600E-01,7.118000E-01,1.615600E+00,4.405600E+00,1.673600E+01,&
     & 1.264400E+02,5.852300E+02,1.179500E+03,2.537600E+03,7.750300E+03,&
     & 8.398513E+04,5.808000E-04,1.530900E-03,2.984100E-03,5.790800E-03,&
     & 1.195300E-02,2.830300E-02,8.254100E-02,2.948000E-01,1.889900E+00,&
     & 7.463700E+00,1.128600E+01,1.658900E+01,2.464600E+01,4.149324E+01,&
     & 1.521300E-01,3.410400E-01,6.191700E-01,1.176900E+00,2.342400E+00,&
     & 5.425600E+00,1.534700E+01,6.511000E+01,5.379500E+02,2.434500E+03,&
     & 4.960300E+03,1.086700E+04,3.267700E+04,3.284443E+05,1.234000E-01,&
     & 2.764600E-01,5.086300E-01,9.596000E-01,1.903800E+00,4.294600E+00,&
     & 1.171000E+01,4.896500E+01,4.035700E+02,1.826100E+03,3.720400E+03,&
     & 8.150700E+03,2.450800E+04,2.463388E+05,8.661100E-02,1.946600E-01,&
     & 3.618800E-01,6.836500E-01,1.362900E+00,3.101000E+00,8.333300E+00,&
     & 3.303000E+01,2.692100E+02,1.217600E+03,2.480500E+03,5.434100E+03,&
     & 1.633900E+04,1.642246E+05,4.690800E-02,1.063700E-01,2.006000E-01,&
     & 3.805600E-01,7.641900E-01,1.739900E+00,4.748100E+00,1.781200E+01,&
     & 1.349200E+02,6.090800E+02,1.240600E+03,2.717500E+03,8.170000E+03,&
     & 8.211417E+04,6.129700E-04,1.579600E-03,3.052300E-03,5.889200E-03,&
     & 1.212500E-02,2.874800E-02,8.690500E-02,3.171700E-01,1.996800E+00,&
     & 7.530000E+00,1.126700E+01,1.615600E+01,2.308300E+01,3.901510E+01,&
     & 1.651300E-01,3.578200E-01,6.673700E-01,1.261800E+00,2.521600E+00,&
     & 5.866500E+00,1.668700E+01,7.047700E+01,5.755600E+02,2.553400E+03,&
     & 5.210300E+03,1.164600E+04,3.445600E+04,3.204643E+05,1.333400E-01,&
     & 2.910500E-01,5.479900E-01,1.028300E+00,2.043500E+00,4.621200E+00,&
     & 1.269200E+01,5.298100E+01,4.317900E+02,1.915200E+03,3.907900E+03,&
     & 8.735000E+03,2.584200E+04,2.403464E+05,9.318800E-02,2.052900E-01,&
     & 3.895400E-01,7.335100E-01,1.464300E+00,3.339300E+00,8.980900E+00,&
     & 3.564000E+01,2.880200E+02,1.276900E+03,2.605500E+03,5.823600E+03,&
     & 1.722800E+04,1.602335E+05,5.019100E-02,1.122200E-01,2.154300E-01,&
     & 4.080800E-01,8.223200E-01,1.876700E+00,5.120600E+00,1.899900E+01,&
     & 1.442900E+02,6.387200E+02,1.303100E+03,2.912200E+03,8.614600E+03,&
     & 8.011674E+04,6.406700E-04,1.619900E-03,3.103200E-03,5.956300E-03,&
     & 1.224000E-02,2.906400E-02,9.056400E-02,3.410100E-01,2.097700E+00,&
     & 7.583600E+00,1.117700E+01,1.584800E+01,2.188800E+01,3.604490E+01/
      data   absb(:,501:520) /                                          &
     & 1.110500E-01,3.000700E-01,5.090700E-01,9.704400E-01,1.942300E+00,&
     & 4.433200E+00,1.250400E+01,5.392700E+01,4.761300E+02,2.314700E+03,&
     & 4.640400E+03,9.997900E+03,3.103800E+04,4.242460E+05,9.091900E-02,&
     & 2.403600E-01,4.151300E-01,7.917500E-01,1.582300E+00,3.548900E+00,&
     & 9.658100E+00,4.060600E+01,3.572100E+02,1.736200E+03,3.480400E+03,&
     & 7.498700E+03,2.327800E+04,3.181854E+05,6.430100E-02,1.678900E-01,&
     & 2.936500E-01,5.614800E-01,1.123600E+00,2.545200E+00,6.942900E+00,&
     & 2.769500E+01,2.383100E+02,1.157700E+03,2.320500E+03,4.999500E+03,&
     & 1.551900E+04,2.121230E+05,3.527700E-02,9.074900E-02,1.620500E-01,&
     & 3.107100E-01,6.228000E-01,1.412100E+00,3.922000E+00,1.534100E+01,&
     & 1.197400E+02,5.792200E+02,1.160500E+03,2.500300E+03,7.760200E+03,&
     & 1.060617E+05,4.205500E-04,1.169200E-03,2.323300E-03,4.547900E-03,&
     & 9.466700E-03,2.249600E-02,6.364300E-02,2.309300E-01,1.631300E+00,&
     & 7.142200E+00,1.143300E+01,1.798900E+01,2.720800E+01,4.804419E+01,&
     & 1.256200E-01,3.125700E-01,5.409500E-01,1.037700E+00,2.072800E+00,&
     & 4.782300E+00,1.352300E+01,5.839500E+01,5.072700E+02,2.411400E+03,&
     & 4.920000E+03,1.074300E+04,3.299900E+04,4.156962E+05,1.023500E-01,&
     & 2.509300E-01,4.424300E-01,8.460900E-01,1.688400E+00,3.814900E+00,&
     & 1.039300E+01,4.394700E+01,3.805600E+02,1.808700E+03,3.690100E+03,&
     & 8.057800E+03,2.474900E+04,3.121955E+05,7.209600E-02,1.754000E-01,&
     & 3.136300E-01,5.998900E-01,1.201800E+00,2.742900E+00,7.453200E+00,&
     & 2.983600E+01,2.538700E+02,1.206000E+03,2.460300E+03,5.372200E+03,&
     & 1.650000E+04,2.081322E+05,3.924500E-02,9.497000E-02,1.731500E-01,&
     & 3.316900E-01,6.677800E-01,1.526600E+00,4.221800E+00,1.638300E+01,&
     & 1.273900E+02,6.033500E+02,1.230400E+03,2.686600E+03,8.250500E+03,&
     & 1.040681E+05,4.547400E-04,1.223100E-03,2.401700E-03,4.677000E-03,&
     & 9.699100E-03,2.311100E-02,6.803700E-02,2.507300E-01,1.748600E+00,&
     & 7.379800E+00,1.146800E+01,1.736500E+01,2.614500E+01,4.502426E+01,&
     & 1.398100E-01,3.255100E-01,5.809900E-01,1.112700E+00,2.222200E+00,&
     & 5.164700E+00,1.470100E+01,6.325400E+01,5.436300E+02,2.514200E+03,&
     & 5.207600E+03,1.156800E+04,3.522800E+04,4.074401E+05,1.133400E-01,&
     & 2.622400E-01,4.761700E-01,9.061200E-01,1.807900E+00,4.102900E+00,&
     & 1.125100E+01,4.757800E+01,4.078300E+02,1.885800E+03,3.905900E+03,&
     & 8.676100E+03,2.642100E+04,3.055801E+05,7.947300E-02,1.837300E-01,&
     & 3.374200E-01,6.430900E-01,1.289200E+00,2.954800E+00,8.037400E+00,&
     & 3.217200E+01,2.720500E+02,1.257400E+03,2.604100E+03,5.784400E+03,&
     & 1.761400E+04,2.037201E+05,4.294900E-02,9.963500E-02,1.859500E-01,&
     & 3.555600E-01,7.181800E-01,1.648300E+00,4.563500E+00,1.748500E+01,&
     & 1.363900E+02,6.290000E+02,1.302400E+03,2.892600E+03,8.807700E+03,&
     & 1.018600E+05,4.846100E-04,1.270300E-03,2.467600E-03,4.778500E-03,&
     & 9.880700E-03,2.357300E-02,7.205100E-02,2.722900E-01,1.869500E+00,&
     & 7.499000E+00,1.154100E+01,1.690100E+01,2.454400E+01,4.223679E+01,&
     & 1.532600E-01,3.404300E-01,6.264800E-01,1.194100E+00,2.392800E+00,&
     & 5.591700E+00,1.603500E+01,6.873200E+01,5.842100E+02,2.643600E+03,&
     & 5.498600E+03,1.246600E+04,3.760000E+04,3.979873E+05,1.236300E-01,&
     & 2.753500E-01,5.132800E-01,9.720500E-01,1.943000E+00,4.420800E+00,&
     & 1.222700E+01,5.167800E+01,4.382800E+02,1.982900E+03,4.124100E+03,&
     & 9.349700E+03,2.820000E+04,2.984929E+05,8.630300E-02,1.932500E-01,&
     & 3.637500E-01,6.906200E-01,1.388000E+00,3.188400E+00,8.687900E+00,&
     & 3.482700E+01,2.923400E+02,1.322100E+03,2.749600E+03,6.233400E+03,&
     & 1.880000E+04,1.989955E+05,4.636000E-02,1.048600E-01,2.000900E-01,&
     & 3.819100E-01,7.744400E-01,1.783000E+00,4.941000E+00,1.870700E+01,&
     & 1.464800E+02,6.612900E+02,1.375100E+03,3.117100E+03,9.400700E+03,&
     & 9.949685E+04,5.101400E-04,1.310300E-03,2.519600E-03,4.853000E-03,&
     & 1.001300E-02,2.390400E-02,7.552000E-02,2.956200E-01,1.983500E+00,&
     & 7.601800E+00,1.151900E+01,1.659200E+01,2.315900E+01,3.911846E+01/
      data   absb(:,521:540) /                                          &
     & 1.658700E-01,3.581400E-01,6.764600E-01,1.282700E+00,2.587300E+00,&
     & 6.074300E+00,1.749800E+01,7.499300E+01,6.274200E+02,2.816600E+03,&
     & 5.804500E+03,1.344100E+04,4.007300E+04,3.879009E+05,1.333100E-01,&
     & 2.906600E-01,5.539400E-01,1.044000E+00,2.093500E+00,4.778800E+00,&
     & 1.330100E+01,5.636600E+01,4.706800E+02,2.112500E+03,4.353500E+03,&
     & 1.008100E+04,3.005500E+04,2.909281E+05,9.270400E-02,2.043200E-01,&
     & 3.921800E-01,7.428700E-01,1.497500E+00,3.447400E+00,9.394600E+00,&
     & 3.788500E+01,3.139400E+02,1.408500E+03,2.902600E+03,6.720800E+03,&
     & 2.003700E+04,1.939483E+05,4.956100E-02,1.108600E-01,2.153300E-01,&
     & 4.107200E-01,8.371700E-01,1.932100E+00,5.347000E+00,2.010500E+01,&
     & 1.572500E+02,7.044700E+02,1.451600E+03,3.360800E+03,1.001900E+04,&
     & 9.697492E+04,5.325200E-04,1.341300E-03,2.560900E-03,4.902200E-03,&
     & 1.009300E-02,2.413400E-02,7.834300E-02,3.205800E-01,2.093800E+00,&
     & 7.646800E+00,1.139800E+01,1.616000E+01,2.238700E+01,3.571117E+01,&
     & 1.098000E-01,2.909200E-01,4.970400E-01,9.521600E-01,1.912700E+00,&
     & 4.412500E+00,1.254400E+01,5.472500E+01,4.947900E+02,2.421000E+03,&
     & 4.957700E+03,1.100500E+04,3.385800E+04,5.014502E+05,8.945400E-02,&
     & 2.325700E-01,4.048000E-01,7.759600E-01,1.558800E+00,3.535600E+00,&
     & 9.693200E+00,4.120700E+01,3.712000E+02,1.815900E+03,3.718400E+03,&
     & 8.254300E+03,2.539400E+04,3.760867E+05,6.296700E-02,1.620000E-01,&
     & 2.855500E-01,5.488600E-01,1.105300E+00,2.533500E+00,6.970900E+00,&
     & 2.811100E+01,2.476400E+02,1.210800E+03,2.479100E+03,5.503200E+03,&
     & 1.693000E+04,2.507245E+05,3.426400E-02,8.711400E-02,1.567300E-01,&
     & 3.019000E-01,6.104800E-01,1.402300E+00,3.932400E+00,1.558200E+01,&
     & 1.243900E+02,6.057700E+02,1.239900E+03,2.752100E+03,8.465300E+03,&
     & 1.253616E+05,3.517900E-04,9.710400E-04,1.922500E-03,3.760200E-03,&
     & 7.830900E-03,1.878700E-02,5.549500E-02,2.103000E-01,1.595100E+00,&
     & 7.208300E+00,1.158200E+01,1.809400E+01,2.762500E+01,4.886793E+01,&
     & 1.237400E-01,3.030100E-01,5.306900E-01,1.021400E+00,2.047300E+00,&
     & 4.772400E+00,1.365200E+01,5.948200E+01,5.320900E+02,2.528400E+03,&
     & 5.277100E+03,1.192500E+04,3.656600E+04,4.915535E+05,1.003700E-01,&
     & 2.428600E-01,4.336400E-01,8.316800E-01,1.668700E+00,3.810300E+00,&
     & 1.049500E+01,4.476100E+01,3.991800E+02,1.896500E+03,3.958000E+03,&
     & 8.943600E+03,2.742500E+04,3.686639E+05,7.036300E-02,1.693900E-01,&
     & 3.064300E-01,5.883600E-01,1.186200E+00,2.737400E+00,7.528800E+00,&
     & 3.038400E+01,2.662800E+02,1.264500E+03,2.638900E+03,5.962700E+03,&
     & 1.828400E+04,2.457715E+05,3.800400E-02,9.125600E-02,1.680700E-01,&
     & 3.235400E-01,6.569800E-01,1.519500E+00,4.261300E+00,1.668200E+01,&
     & 1.335900E+02,6.325500E+02,1.319800E+03,2.981800E+03,9.142200E+03,&
     & 1.228872E+05,3.795500E-04,1.014600E-03,1.984700E-03,3.861200E-03,&
     & 8.016800E-03,1.923900E-02,5.920700E-02,2.304600E-01,1.725800E+00,&
     & 7.418000E+00,1.170800E+01,1.750300E+01,2.624300E+01,4.573891E+01,&
     & 1.372500E-01,3.160000E-01,5.715100E-01,1.097600E+00,2.205000E+00,&
     & 5.172100E+00,1.493100E+01,6.481600E+01,5.746300E+02,2.659100E+03,&
     & 5.610900E+03,1.292900E+04,3.955500E+04,4.807260E+05,1.108000E-01,&
     & 2.543100E-01,4.677600E-01,8.932100E-01,1.794700E+00,4.111200E+00,&
     & 1.142800E+01,4.874700E+01,4.310900E+02,1.994400E+03,4.208300E+03,&
     & 9.697000E+03,2.966600E+04,3.605454E+05,7.734000E-02,1.777300E-01,&
     & 3.304600E-01,6.326100E-01,1.278500E+00,2.958400E+00,8.166500E+00,&
     & 3.294900E+01,2.875500E+02,1.329800E+03,2.805800E+03,6.465000E+03,&
     & 1.977800E+04,2.403626E+05,4.149400E-02,9.586300E-02,1.810100E-01,&
     & 3.479700E-01,7.097700E-01,1.647500E+00,4.632800E+00,1.788700E+01,&
     & 1.441300E+02,6.651600E+02,1.403200E+03,3.232900E+03,9.889300E+03,&
     & 1.201813E+05,4.029200E-04,1.053200E-03,2.037000E-03,3.939800E-03,&
     & 8.157100E-03,1.959000E-02,6.244900E-02,2.528800E-01,1.854600E+00,&
     & 7.541800E+00,1.177000E+01,1.725800E+01,2.443000E+01,4.266757E+01/
      data   absb(:,541:560) /                                          &
     & 1.500500E-01,3.311600E-01,6.171100E-01,1.180200E+00,2.384400E+00,&
     & 5.624400E+00,1.634200E+01,7.097000E+01,6.205200E+02,2.835900E+03,&
     & 5.958800E+03,1.401300E+04,4.270400E+04,4.691285E+05,1.205800E-01,&
     & 2.675600E-01,5.051000E-01,9.605900E-01,1.936600E+00,4.449200E+00,&
     & 1.246000E+01,5.335200E+01,4.655100E+02,2.127000E+03,4.469300E+03,&
     & 1.051000E+04,3.202800E+04,3.518432E+05,8.380300E-02,1.873200E-01,&
     & 3.568600E-01,6.815300E-01,1.381800E+00,3.206900E+00,8.856700E+00,&
     & 3.593500E+01,3.105000E+02,1.418200E+03,2.979800E+03,7.006700E+03,&
     & 2.135200E+04,2.345639E+05,4.472200E-02,1.010600E-01,1.950800E-01,&
     & 3.751700E-01,7.687200E-01,1.790300E+00,5.036700E+00,1.926300E+01,&
     & 1.555600E+02,7.092800E+02,1.490200E+03,3.503700E+03,1.067700E+04,&
     & 1.172811E+05,4.238800E-04,1.084000E-03,2.080100E-03,3.996100E-03,&
     & 8.258800E-03,1.984300E-02,6.514400E-02,2.772000E-01,1.977000E+00,&
     & 7.693100E+00,1.162900E+01,1.696400E+01,2.367900E+01,3.873764E+01,&
     & 1.619000E-01,3.494400E-01,6.674600E-01,1.270000E+00,2.587800E+00,&
     & 6.138400E+00,1.792600E+01,7.800000E+01,6.689200E+02,3.068000E+03,&
     & 6.330000E+03,1.520400E+04,4.589400E+04,4.568603E+05,1.297100E-01,&
     & 2.833600E-01,5.458500E-01,1.034000E+00,2.094500E+00,4.829200E+00,&
     & 1.362300E+01,5.862200E+01,5.018000E+02,2.301100E+03,4.747700E+03,&
     & 1.140300E+04,3.442000E+04,3.426441E+05,8.984400E-02,1.986200E-01,&
     & 3.855000E-01,7.346200E-01,1.497700E+00,3.483400E+00,9.616600E+00,&
     & 3.938400E+01,3.346900E+02,1.534200E+03,3.165400E+03,7.602200E+03,&
     & 2.294700E+04,2.284316E+05,4.776500E-02,1.071000E-01,2.104500E-01,&
     & 4.043600E-01,8.352400E-01,1.949200E+00,5.469400E+00,2.085300E+01,&
     & 1.676200E+02,7.673000E+02,1.583000E+03,3.801500E+03,1.147400E+04,&
     & 1.142142E+05,4.417500E-04,1.107600E-03,2.114400E-03,4.032100E-03,&
     & 8.310200E-03,2.003600E-02,6.746900E-02,3.031400E-01,2.091700E+00,&
     & 7.781100E+00,1.152000E+01,1.650600E+01,2.277300E+01,3.525820E+01,&
     & 1.073300E-01,2.813300E-01,4.838600E-01,9.310900E-01,1.876200E+00,&
     & 4.371700E+00,1.255000E+01,5.534100E+01,5.147400E+02,2.536300E+03,&
     & 5.290900E+03,1.213500E+04,3.731200E+04,5.929269E+05,8.709100E-02,&
     & 2.244800E-01,3.936200E-01,7.580700E-01,1.529800E+00,3.507300E+00,&
     & 9.703700E+00,4.167000E+01,3.861700E+02,1.902400E+03,3.968300E+03,&
     & 9.101600E+03,2.798400E+04,4.446947E+05,6.105600E-02,1.559800E-01,&
     & 2.768900E-01,5.348500E-01,1.083300E+00,2.511900E+00,6.983300E+00,&
     & 2.843200E+01,2.576200E+02,1.268500E+03,2.645800E+03,6.068000E+03,&
     & 1.865700E+04,2.964600E+05,3.299400E-02,8.347000E-02,1.511600E-01,&
     & 2.925800E-01,5.962400E-01,1.387100E+00,3.935800E+00,1.576600E+01,&
     & 1.293900E+02,6.345600E+02,1.323200E+03,3.034500E+03,9.328800E+03,&
     & 1.482327E+05,2.923000E-04,8.032600E-04,1.584700E-03,3.099000E-03,&
     & 6.464500E-03,1.562200E-02,4.796000E-02,1.910500E-01,1.562000E+00,&
     & 7.230900E+00,1.174100E+01,1.823200E+01,2.794200E+01,4.973884E+01,&
     & 1.207400E-01,2.931500E-01,5.183200E-01,1.001400E+00,2.016100E+00,&
     & 4.743100E+00,1.374200E+01,6.047500E+01,5.584700E+02,2.663400E+03,&
     & 5.654800E+03,1.324400E+04,4.088100E+04,5.808503E+05,9.756100E-02,&
     & 2.346100E-01,4.232300E-01,8.146300E-01,1.644000E+00,3.791100E+00,&
     & 1.056900E+01,4.550400E+01,4.189700E+02,1.997700E+03,4.241300E+03,&
     & 9.933100E+03,3.066100E+04,4.356315E+05,6.811700E-02,1.632700E-01,&
     & 2.982200E-01,5.751000E-01,1.167300E+00,2.721600E+00,7.585400E+00,&
     & 3.088700E+01,2.794800E+02,1.332000E+03,2.827700E+03,6.622300E+03,&
     & 2.044100E+04,2.904207E+05,3.655000E-02,8.751800E-02,1.626300E-01,&
     & 3.147000E-01,6.444800E-01,1.507600E+00,4.290400E+00,1.695200E+01,&
     & 1.401900E+02,6.663100E+02,1.414200E+03,3.311600E+03,1.022100E+04,&
     & 1.452105E+05,3.143400E-04,8.394800E-04,1.636200E-03,3.179400E-03,&
     & 6.614400E-03,1.597500E-02,5.102300E-02,2.116700E-01,1.702200E+00,&
     & 7.439300E+00,1.190300E+01,1.790800E+01,2.610600E+01,4.643947E+01/
      data   absb(:,561:580) /                                          &
     & 1.336900E-01,3.060600E-01,5.592900E-01,1.077900E+00,2.179600E+00,&
     & 5.159600E+00,1.509300E+01,6.635100E+01,6.070900E+02,2.834500E+03,&
     & 6.042000E+03,1.445700E+04,4.473800E+04,5.677494E+05,1.075500E-01,&
     & 2.460200E-01,4.572100E-01,8.770300E-01,1.775000E+00,4.104700E+00,&
     & 1.155500E+01,4.989500E+01,4.554400E+02,2.126000E+03,4.531700E+03,&
     & 1.084300E+04,3.355400E+04,4.258089E+05,7.476800E-02,1.715200E-01,&
     & 3.221900E-01,6.201700E-01,1.263200E+00,2.953500E+00,8.262100E+00,&
     & 3.371100E+01,3.037900E+02,1.417500E+03,3.021400E+03,7.228800E+03,&
     & 2.236900E+04,2.838667E+05,3.987300E-02,9.201800E-02,1.755000E-01,&
     & 3.396500E-01,6.990900E-01,1.641900E+00,4.687800E+00,1.827700E+01,&
     & 1.522600E+02,7.089700E+02,1.511000E+03,3.614800E+03,1.118500E+04,&
     & 1.419351E+05,3.336300E-04,8.695300E-04,1.679500E-03,3.241400E-03,&
     & 6.727600E-03,1.625200E-02,5.362400E-02,2.346100E-01,1.836500E+00,&
     & 7.656900E+00,1.186600E+01,1.765900E+01,2.508000E+01,4.235772E+01,&
     & 1.458800E-01,3.213500E-01,6.048200E-01,1.161100E+00,2.366800E+00,&
     & 5.636500E+00,1.659100E+01,7.322200E+01,6.585200E+02,3.067400E+03,&
     & 6.460100E+03,1.577600E+04,4.875400E+04,5.536806E+05,1.168900E-01,&
     & 2.593700E-01,4.946300E-01,9.454200E-01,1.922700E+00,4.461200E+00,&
     & 1.265000E+01,5.504000E+01,4.940100E+02,2.300700E+03,4.845300E+03,&
     & 1.183300E+04,3.656600E+04,4.152585E+05,8.095000E-02,1.811200E-01,&
     & 3.485200E-01,6.699300E-01,1.371000E+00,3.214100E+00,8.995000E+00,&
     & 3.705700E+01,3.295000E+02,1.533900E+03,3.230400E+03,7.888600E+03,&
     & 2.437700E+04,2.768386E+05,4.295800E-02,9.717400E-02,1.894900E-01,&
     & 3.672300E-01,7.609000E-01,1.791800E+00,5.115100E+00,1.982800E+01,&
     & 1.650600E+02,7.671600E+02,1.615600E+03,3.944700E+03,1.218900E+04,&
     & 1.384193E+05,3.506200E-04,8.933000E-04,1.715600E-03,3.286600E-03,&
     & 6.802200E-03,1.646100E-02,5.590000E-02,2.596400E-01,1.966300E+00,&
     & 7.780100E+00,1.180300E+01,1.730500E+01,2.417900E+01,3.841954E+01,&
     & 1.570700E-01,3.399600E-01,6.551200E-01,1.252400E+00,2.575700E+00,&
     & 6.177400E+00,1.830400E+01,8.093600E+01,7.128200E+02,3.357300E+03,&
     & 6.926800E+03,1.721800E+04,5.276200E+04,5.388803E+05,1.255200E-01,&
     & 2.754800E-01,5.353400E-01,1.019900E+00,2.086300E+00,4.860900E+00,&
     & 1.390700E+01,6.082400E+01,5.347300E+02,2.518100E+03,5.195300E+03,&
     & 1.291400E+04,3.957200E+04,4.041652E+05,8.666800E-02,1.925600E-01,&
     & 3.772900E-01,7.238800E-01,1.491500E+00,3.504800E+00,9.814800E+00,&
     & 4.084800E+01,3.566400E+02,1.678800E+03,3.463700E+03,8.609400E+03,&
     & 2.638100E+04,2.694409E+05,4.584700E-02,1.032400E-01,2.048700E-01,&
     & 3.969900E-01,8.302900E-01,1.958900E+00,5.581200E+00,2.158300E+01,&
     & 1.786000E+02,8.396300E+02,1.732200E+03,4.305100E+03,1.319100E+04,&
     & 1.347196E+05,3.647900E-04,9.132600E-04,1.741000E-03,3.319000E-03,&
     & 6.846800E-03,1.659900E-02,5.798800E-02,2.862900E-01,2.087600E+00,&
     & 7.856100E+00,1.165200E+01,1.688900E+01,2.322400E+01,3.487006E+01,&
     & 1.028900E-01,2.692700E-01,4.655300E-01,8.990700E-01,1.817700E+00,&
     & 4.273600E+00,1.239700E+01,5.526000E+01,5.304000E+02,2.645100E+03,&
     & 5.588400E+03,1.324700E+04,4.099900E+04,6.968193E+05,8.324100E-02,&
     & 2.145000E-01,3.783600E-01,7.317000E-01,1.483300E+00,3.435400E+00,&
     & 9.597600E+00,4.161000E+01,3.979200E+02,1.984000E+03,4.191500E+03,&
     & 9.935600E+03,3.074900E+04,5.226188E+05,5.815900E-02,1.487100E-01,&
     & 2.654800E-01,5.151600E-01,1.049200E+00,2.458500E+00,6.913800E+00,&
     & 2.841500E+01,2.654500E+02,1.322900E+03,2.794500E+03,6.624000E+03,&
     & 2.050000E+04,3.484104E+05,3.125300E-02,7.922800E-02,1.442100E-01,&
     & 2.805300E-01,5.756700E-01,1.354800E+00,3.894900E+00,1.577900E+01,&
     & 1.333200E+02,6.617500E+02,1.397600E+03,3.312500E+03,1.025000E+04,&
     & 1.742073E+05,2.406900E-04,6.604400E-04,1.302400E-03,2.545400E-03,&
     & 5.325400E-03,1.293600E-02,4.104800E-02,1.725500E-01,1.522900E+00,&
     & 7.239500E+00,1.187800E+01,1.848800E+01,2.821300E+01,5.071007E+01/
      data   absb(:,581:600) /                                          &
     & 1.157100E-01,2.807200E-01,4.995300E-01,9.690400E-01,1.960500E+00,&
     & 4.649600E+00,1.365500E+01,6.068700E+01,5.800200E+02,2.797600E+03,&
     & 6.001800E+03,1.456000E+04,4.549300E+04,6.823980E+05,9.325300E-02,&
     & 2.243400E-01,4.077300E-01,7.881100E-01,1.600100E+00,3.723400E+00,&
     & 1.051300E+01,4.566100E+01,4.351300E+02,2.098300E+03,4.501500E+03,&
     & 1.092000E+04,3.412000E+04,5.117954E+05,6.489500E-02,1.557700E-01,&
     & 2.865700E-01,5.554100E-01,1.134900E+00,2.672400E+00,7.555300E+00,&
     & 3.100300E+01,2.902600E+02,1.399100E+03,3.001200E+03,7.280200E+03,&
     & 2.274700E+04,3.411955E+05,3.464100E-02,8.311400E-02,1.555200E-01,&
     & 3.026000E-01,6.247700E-01,1.478300E+00,4.270400E+00,1.703400E+01,&
     & 1.455900E+02,6.998100E+02,1.501000E+03,3.640500E+03,1.137400E+04,&
     & 1.705978E+05,2.586800E-04,6.901900E-04,1.344900E-03,2.611600E-03,&
     & 5.446400E-03,1.322800E-02,4.357400E-02,1.934300E-01,1.669800E+00,&
     & 7.481300E+00,1.204900E+01,1.827000E+01,2.651600E+01,4.688385E+01,&
     & 1.281500E-01,2.932900E-01,5.398000E-01,1.045400E+00,2.126900E+00,&
     & 5.076900E+00,1.505600E+01,6.709500E+01,6.342200E+02,3.012500E+03,&
     & 6.451700E+03,1.601600E+04,5.030200E+04,6.667522E+05,1.028400E-01,&
     & 2.354600E-01,4.410900E-01,8.507400E-01,1.734300E+00,4.046000E+00,&
     & 1.153500E+01,5.045100E+01,4.757800E+02,2.259500E+03,4.838900E+03,&
     & 1.201200E+04,3.772600E+04,5.000540E+05,7.127700E-02,1.637900E-01,&
     & 3.101500E-01,6.007700E-01,1.233200E+00,2.911100E+00,8.257700E+00,&
     & 3.408900E+01,3.173600E+02,1.506500E+03,3.226200E+03,8.008500E+03,&
     & 2.515100E+04,3.333673E+05,3.782400E-02,8.744500E-02,1.681400E-01,&
     & 3.278000E-01,6.806200E-01,1.616300E+00,4.686300E+00,1.848600E+01,&
     & 1.590400E+02,7.534600E+02,1.613500E+03,4.004600E+03,1.257600E+04,&
     & 1.666860E+05,2.744900E-04,7.147100E-04,1.381300E-03,2.663900E-03,&
     & 5.540700E-03,1.346200E-02,4.576700E-02,2.166600E-01,1.811200E+00,&
     & 7.730900E+00,1.195100E+01,1.806300E+01,2.569000E+01,4.241960E+01,&
     & 1.397400E-01,3.084300E-01,5.846100E-01,1.127500E+00,2.318200E+00,&
     & 5.570800E+00,1.662100E+01,7.459300E+01,6.915400E+02,3.297900E+03,&
     & 6.951500E+03,1.760200E+04,5.525700E+04,6.500306E+05,1.117400E-01,&
     & 2.487200E-01,4.779300E-01,9.187600E-01,1.884900E+00,4.415500E+00,&
     & 1.267800E+01,5.607000E+01,5.187700E+02,2.473600E+03,5.213800E+03,&
     & 1.320200E+04,4.144300E+04,4.875326E+05,7.716800E-02,1.732600E-01,&
     & 3.360300E-01,6.504100E-01,1.343500E+00,3.181300E+00,9.022000E+00,&
     & 3.775000E+01,3.460100E+02,1.649200E+03,3.476100E+03,8.801200E+03,&
     & 2.762900E+04,3.250222E+05,4.076600E-02,9.249800E-02,1.818700E-01,&
     & 3.553300E-01,7.441600E-01,1.771600E+00,5.130900E+00,2.019300E+01,&
     & 1.733100E+02,8.247900E+02,1.738400E+03,4.401000E+03,1.381500E+04,&
     & 1.625112E+05,2.884900E-04,7.350600E-04,1.410500E-03,2.701700E-03,&
     & 5.601900E-03,1.363700E-02,4.777800E-02,2.421000E-01,1.947000E+00,&
     & 7.873500E+00,1.193800E+01,1.755300E+01,2.481900E+01,3.841294E+01,&
     & 1.503300E-01,3.268500E-01,6.340100E-01,1.218800E+00,2.529100E+00,&
     & 6.133800E+00,1.845400E+01,8.291200E+01,7.525900E+02,3.647500E+03,&
     & 7.528900E+03,1.932800E+04,6.017500E+04,6.324772E+05,1.199000E-01,&
     & 2.647000E-01,5.180400E-01,9.933700E-01,2.051300E+00,4.831100E+00,&
     & 1.402400E+01,6.230500E+01,5.645600E+02,2.735700E+03,5.646900E+03,&
     & 1.449600E+04,4.513100E+04,4.743649E+05,8.257600E-02,1.845900E-01,&
     & 3.644700E-01,7.044600E-01,1.466300E+00,3.482200E+00,9.903600E+00,&
     & 4.183600E+01,3.765300E+02,1.823900E+03,3.764800E+03,9.664100E+03,&
     & 3.008800E+04,3.162420E+05,4.349600E-02,9.847600E-02,1.970200E-01,&
     & 3.852600E-01,8.150900E-01,1.944500E+00,5.629100E+00,2.209300E+01,&
     & 1.885400E+02,9.121800E+02,1.882700E+03,4.832400E+03,1.504400E+04,&
     & 1.581224E+05,2.998300E-04,7.512100E-04,1.432900E-03,2.729800E-03,&
     & 5.640800E-03,1.375300E-02,4.968300E-02,2.693900E-01,2.078600E+00,&
     & 7.902700E+00,1.189200E+01,1.704800E+01,2.383700E+01,3.470394E+01/
      data   absb(:,601:620) /                                          &
     & 9.434000E-02,2.496500E-01,4.324700E-01,8.374800E-01,1.699700E+00,&
     & 4.023400E+00,1.179300E+01,5.313600E+01,5.276100E+02,2.681900E+03,&
     & 5.711400E+03,1.395200E+04,4.359700E+04,7.993756E+05,7.622600E-02,&
     & 1.986500E-01,3.513600E-01,6.820800E-01,1.389400E+00,3.247300E+00,&
     & 9.160400E+00,4.002400E+01,3.958300E+02,2.011600E+03,4.283800E+03,&
     & 1.046400E+04,3.269800E+04,5.995278E+05,5.314000E-02,1.374900E-01,&
     & 2.460300E-01,4.795800E-01,9.819000E-01,2.323200E+00,6.614600E+00,&
     & 2.740300E+01,2.640500E+02,1.341300E+03,2.856100E+03,6.976500E+03,&
     & 2.179900E+04,3.996772E+05,2.845600E-02,7.298300E-02,1.331300E-01,&
     & 2.602600E-01,5.374800E-01,1.278800E+00,3.723400E+00,1.529500E+01,&
     & 1.326900E+02,6.709600E+02,1.428400E+03,3.488700E+03,1.090000E+04,&
     & 1.998417E+05,1.955900E-04,5.391400E-04,1.064400E-03,2.081900E-03,&
     & 4.366600E-03,1.067100E-02,3.470700E-02,1.537400E-01,1.466900E+00,&
     & 7.201700E+00,1.198300E+01,1.880100E+01,2.867800E+01,5.201936E+01,&
     & 1.063400E-01,2.604200E-01,4.640900E-01,9.043700E-01,1.837800E+00,&
     & 4.389200E+00,1.304100E+01,5.870000E+01,5.810700E+02,2.858300E+03,&
     & 6.162900E+03,1.545700E+04,4.896300E+04,7.828679E+05,8.561200E-02,&
     & 2.078900E-01,3.789300E-01,7.361900E-01,1.503000E+00,3.529000E+00,&
     & 1.007000E+01,4.417300E+01,4.359300E+02,2.143900E+03,4.622400E+03,&
     & 1.159300E+04,3.672300E+04,5.871606E+05,5.945200E-02,1.440700E-01,&
     & 2.658800E-01,5.182200E-01,1.065400E+00,2.532400E+00,7.260400E+00,&
     & 3.004800E+01,2.907900E+02,1.429400E+03,3.081800E+03,7.728700E+03,&
     & 2.448200E+04,3.914392E+05,3.163000E-02,7.657500E-02,1.437800E-01,&
     & 2.814400E-01,5.854000E-01,1.399800E+00,4.104600E+00,1.658800E+01,&
     & 1.459000E+02,7.149500E+02,1.541300E+03,3.864800E+03,1.224100E+04,&
     & 1.957157E+05,2.105900E-04,5.637200E-04,1.101100E-03,2.138300E-03,&
     & 4.469100E-03,1.092400E-02,3.686400E-02,1.743000E-01,1.620000E+00,&
     & 7.500300E+00,1.210500E+01,1.863700E+01,2.707900E+01,4.789538E+01,&
     & 1.180300E-01,2.721700E-01,5.019300E-01,9.772400E-01,1.999400E+00,&
     & 4.809000E+00,1.443900E+01,6.537000E+01,6.393600E+02,3.104200E+03,&
     & 6.666800E+03,1.714100E+04,5.465500E+04,7.650154E+05,9.464100E-02,&
     & 2.183300E-01,4.104000E-01,7.964500E-01,1.634100E+00,3.847700E+00,&
     & 1.108800E+01,4.915800E+01,4.796400E+02,2.328300E+03,5.000300E+03,&
     & 1.285600E+04,4.099100E+04,5.737660E+05,6.546900E-02,1.515700E-01,&
     & 2.881400E-01,5.619600E-01,1.161700E+00,2.768800E+00,7.965900E+00,&
     & 3.325700E+01,3.199300E+02,1.552300E+03,3.333800E+03,8.570700E+03,&
     & 2.732800E+04,3.825043E+05,3.463100E-02,8.059300E-02,1.556800E-01,&
     & 3.057400E-01,6.401900E-01,1.537000E+00,4.524400E+00,1.811000E+01,&
     & 1.603600E+02,7.764000E+02,1.667300E+03,4.285700E+03,1.366400E+04,&
     & 1.912549E+05,2.238100E-04,5.844800E-04,1.131300E-03,2.183500E-03,&
     & 4.548100E-03,1.112200E-02,3.879500E-02,1.974400E-01,1.768700E+00,&
     & 7.764600E+00,1.206300E+01,1.842000E+01,2.627400E+01,4.317529E+01,&
     & 1.289300E-01,2.863300E-01,5.442300E-01,1.056000E+00,2.186000E+00,&
     & 5.298200E+00,1.602500E+01,7.307900E+01,7.014900E+02,3.427200E+03,&
     & 7.244100E+03,1.898500E+04,6.050600E+04,7.458400E+05,1.030200E-01,&
     & 2.307600E-01,4.453800E-01,8.619800E-01,1.782600E+00,4.214300E+00,&
     & 1.224500E+01,5.493400E+01,5.262300E+02,2.570500E+03,5.433300E+03,&
     & 1.423900E+04,4.538000E+04,5.593831E+05,7.101900E-02,1.604300E-01,&
     & 3.127500E-01,6.098600E-01,1.270700E+00,3.037400E+00,8.744200E+00,&
     & 3.701700E+01,3.509800E+02,1.713800E+03,3.622400E+03,9.492800E+03,&
     & 3.025300E+04,3.729174E+05,3.740000E-02,8.531000E-02,1.687000E-01,&
     & 3.324600E-01,7.028300E-01,1.691500E+00,4.977300E+00,1.987600E+01,&
     & 1.758100E+02,8.571400E+02,1.811500E+03,4.746700E+03,1.512700E+04,&
     & 1.864548E+05,2.354900E-04,6.021600E-04,1.156300E-03,2.216700E-03,&
     & 4.605600E-03,1.127500E-02,4.061300E-02,2.229900E-01,1.910400E+00,&
     & 7.923300E+00,1.210300E+01,1.780500E+01,2.550400E+01,3.898378E+01/
      data   absb(:,621:640) /                                          &
     & 1.388200E-01,3.035600E-01,5.912500E-01,1.143500E+00,2.391400E+00,&
     & 5.859900E+00,1.788200E+01,8.172900E+01,7.680100E+02,3.822500E+03,&
     & 7.925600E+03,2.096600E+04,6.635300E+04,7.256894E+05,1.106600E-01,&
     & 2.458200E-01,4.835900E-01,9.339900E-01,1.945600E+00,4.630800E+00,&
     & 1.360500E+01,6.141700E+01,5.761200E+02,2.867000E+03,5.944300E+03,&
     & 1.572400E+04,4.976500E+04,5.442715E+05,7.607400E-02,1.711000E-01,&
     & 3.398200E-01,6.621800E-01,1.391100E+00,3.339900E+00,9.642000E+00,&
     & 4.125800E+01,3.842400E+02,1.911500E+03,3.963100E+03,1.048300E+04,&
     & 3.317700E+04,3.628420E+05,3.994400E-02,9.092900E-02,1.831000E-01,&
     & 3.614800E-01,7.727000E-01,1.865200E+00,5.488000E+00,2.185200E+01,&
     & 1.924000E+02,9.559600E+02,1.981900E+03,5.241900E+03,1.658900E+04,&
     & 1.814265E+05,2.450500E-04,6.161500E-04,1.176200E-03,2.242300E-03,&
     & 4.641600E-03,1.138200E-02,4.233900E-02,2.507400E-01,2.049200E+00,&
     & 7.945600E+00,1.205200E+01,1.734300E+01,2.438500E+01,3.525441E+01,&
     & 8.766600E-02,2.348500E-01,4.075200E-01,7.916400E-01,1.612300E+00,&
     & 3.840500E+00,1.138300E+01,5.188900E+01,5.332000E+02,2.766900E+03,&
     & 5.945700E+03,1.493600E+04,4.729600E+04,9.294947E+05,7.072400E-02,&
     & 1.866100E-01,3.308400E-01,6.448900E-01,1.319300E+00,3.109400E+00,&
     & 8.866600E+00,3.909400E+01,4.000200E+02,2.075300E+03,4.459500E+03,&
     & 1.120200E+04,3.547200E+04,6.971012E+05,4.918900E-02,1.289100E-01,&
     & 2.311600E-01,4.527500E-01,9.313900E-01,2.223200E+00,6.413400E+00,&
     & 2.681900E+01,2.668600E+02,1.383700E+03,2.973200E+03,7.468400E+03,&
     & 2.364800E+04,4.647394E+05,2.624400E-02,6.817800E-02,1.245700E-01,&
     & 2.448100E-01,5.084900E-01,1.222300E+00,3.607200E+00,1.501700E+01,&
     & 1.341400E+02,6.921700E+02,1.487000E+03,3.734600E+03,1.182500E+04,&
     & 2.323693E+05,1.588100E-04,4.397000E-04,8.698500E-04,1.703300E-03,&
     & 3.578400E-03,8.801100E-03,2.929800E-02,1.371100E-01,1.415000E+00,&
     & 7.172400E+00,1.204000E+01,1.906700E+01,2.911400E+01,5.327618E+01,&
     & 9.907500E-02,2.451500E-01,4.373400E-01,8.563100E-01,1.747900E+00,&
     & 4.202600E+00,1.264300E+01,5.766500E+01,5.914800E+02,2.977200E+03,&
     & 6.440400E+03,1.669300E+04,5.369100E+04,9.104591E+05,7.966600E-02,&
     & 1.954300E-01,3.570100E-01,6.973500E-01,1.431600E+00,3.389400E+00,&
     & 9.785900E+00,4.339700E+01,4.437300E+02,2.233000E+03,4.830500E+03,&
     & 1.252000E+04,4.026900E+04,6.828400E+05,5.520800E-02,1.351500E-01,&
     & 2.500600E-01,4.902500E-01,1.013900E+00,2.431700E+00,7.069900E+00,&
     & 2.956100E+01,2.959900E+02,1.488800E+03,3.220600E+03,8.346700E+03,&
     & 2.684600E+04,4.552163E+05,2.927000E-02,7.154600E-02,1.347200E-01,&
     & 2.653700E-01,5.558000E-01,1.342900E+00,3.997200E+00,1.636800E+01,&
     & 1.485400E+02,7.446700E+02,1.610700E+03,4.173700E+03,1.342300E+04,&
     & 2.276076E+05,1.713500E-04,4.605200E-04,9.001100E-04,1.752000E-03,&
     & 3.667000E-03,9.020400E-03,3.114800E-02,1.573400E-01,1.573800E+00,&
     & 7.538200E+00,1.213500E+01,1.896800E+01,2.773000E+01,4.865706E+01,&
     & 1.102200E-01,2.562900E-01,4.734200E-01,9.268100E-01,1.907400E+00,&
     & 4.622300E+00,1.405600E+01,6.466800E+01,6.550500E+02,3.263000E+03,&
     & 7.010300E+03,1.866700E+04,6.044800E+04,8.896968E+05,8.829400E-02,&
     & 2.053300E-01,3.871700E-01,7.560500E-01,1.561500E+00,3.709400E+00,&
     & 1.081400E+01,4.863100E+01,4.914100E+02,2.447300E+03,5.257900E+03,&
     & 1.400000E+04,4.533600E+04,6.672784E+05,6.096100E-02,1.422500E-01,&
     & 2.713700E-01,5.329400E-01,1.109200E+00,2.668800E+00,7.786200E+00,&
     & 3.293300E+01,3.277800E+02,1.631700E+03,3.505500E+03,9.333700E+03,&
     & 3.022400E+04,4.448404E+05,3.214000E-02,7.533000E-02,1.461100E-01,&
     & 2.891100E-01,6.101500E-01,1.480500E+00,4.422900E+00,1.798100E+01,&
     & 1.643000E+02,8.160900E+02,1.753100E+03,4.667200E+03,1.511300E+04,&
     & 2.224241E+05,1.824800E-04,4.781100E-04,9.269900E-04,1.789300E-03,&
     & 3.737100E-03,9.188900E-03,3.286700E-02,1.802800E-01,1.728900E+00,&
     & 7.785700E+00,1.220100E+01,1.866700E+01,2.699500E+01,4.373266E+01/
      data   absb(:,641:660) /                                          &
     & 1.206300E-01,2.697100E-01,5.139800E-01,1.003200E+00,2.091100E+00,&
     & 5.113500E+00,1.568600E+01,7.278500E+01,7.234500E+02,3.629200E+03,&
     & 7.688300E+03,2.083800E+04,6.740800E+04,8.674770E+05,9.631000E-02,&
     & 2.171500E-01,4.208000E-01,8.198600E-01,1.708900E+00,4.078600E+00,&
     & 1.200200E+01,5.471300E+01,5.427000E+02,2.722000E+03,5.766400E+03,&
     & 1.562800E+04,5.055600E+04,6.505937E+05,6.627000E-02,1.506500E-01,&
     & 2.950700E-01,5.795900E-01,1.217600E+00,2.940000E+00,8.591500E+00,&
     & 3.688700E+01,3.619700E+02,1.814900E+03,3.844400E+03,1.041900E+04,&
     & 3.370400E+04,4.337412E+05,3.478600E-02,7.978800E-02,1.586200E-01,&
     & 3.152100E-01,6.725600E-01,1.636600E+00,4.893500E+00,1.984600E+01,&
     & 1.813100E+02,9.076900E+02,1.922500E+03,5.209800E+03,1.685200E+04,&
     & 2.168685E+05,1.922800E-04,4.933000E-04,9.479500E-04,1.819700E-03,&
     & 3.786900E-03,9.326600E-03,3.451700E-02,2.060100E-01,1.875900E+00,&
     & 7.964900E+00,1.226400E+01,1.809000E+01,2.616400E+01,3.937976E+01,&
     & 1.300200E-01,2.860500E-01,5.592600E-01,1.088500E+00,2.294800E+00,&
     & 5.681200E+00,1.759500E+01,8.184600E+01,7.974000E+02,4.074300E+03,&
     & 8.500300E+03,2.315200E+04,7.436100E+04,8.440839E+05,1.035500E-01,&
     & 2.315100E-01,4.576900E-01,8.904700E-01,1.871200E+00,4.499700E+00,&
     & 1.340000E+01,6.150400E+01,5.981600E+02,3.055900E+03,6.375400E+03,&
     & 1.736400E+04,5.577100E+04,6.330593E+05,7.105800E-02,1.608300E-01,&
     & 3.212300E-01,6.310200E-01,1.337900E+00,3.245700E+00,9.517900E+00,&
     & 4.132800E+01,3.989400E+02,2.037400E+03,4.250400E+03,1.157600E+04,&
     & 3.718100E+04,4.220384E+05,3.718800E-02,8.513300E-02,1.725200E-01,&
     & 3.437900E-01,7.423600E-01,1.812500E+00,5.420800E+00,2.192100E+01,&
     & 1.997500E+02,1.019000E+03,2.125500E+03,5.788300E+03,1.859100E+04,&
     & 2.110223E+05,2.002800E-04,5.054700E-04,9.653900E-04,1.843200E-03,&
     & 3.818000E-03,9.432700E-03,3.606700E-02,2.341500E-01,2.022100E+00,&
     & 7.977100E+00,1.221400E+01,1.763400E+01,2.502500E+01,3.554525E+01,&
     & 8.331900E-02,2.260200E-01,3.928600E-01,7.656100E-01,1.565300E+00,&
     & 3.751300E+00,1.125400E+01,5.194600E+01,5.526800E+02,2.926800E+03,&
     & 6.357400E+03,1.641100E+04,5.278700E+04,1.104282E+06,6.708300E-02,&
     & 1.792700E-01,3.185300E-01,6.233700E-01,1.280900E+00,3.042900E+00,&
     & 8.778500E+00,3.914100E+01,4.146300E+02,2.195300E+03,4.768300E+03,&
     & 1.230900E+04,3.959100E+04,8.282233E+05,4.654000E-02,1.235800E-01,&
     & 2.220400E-01,4.368500E-01,9.030600E-01,2.173500E+00,6.353200E+00,&
     & 2.687400E+01,2.766000E+02,1.463700E+03,3.179200E+03,8.206200E+03,&
     & 2.639400E+04,5.521541E+05,2.473200E-02,6.510300E-02,1.191000E-01,&
     & 2.353100E-01,4.915200E-01,1.192700E+00,3.569800E+00,1.505600E+01,&
     & 1.390500E+02,7.321300E+02,1.590000E+03,4.103500E+03,1.319800E+04,&
     & 2.760771E+05,1.290300E-04,3.589300E-04,7.102700E-04,1.395100E-03,&
     & 2.933900E-03,7.268100E-03,2.470300E-02,1.225400E-01,1.368300E+00,&
     & 7.169100E+00,1.205800E+01,1.936200E+01,2.954300E+01,5.426368E+01,&
     & 9.440900E-02,2.361100E-01,4.216800E-01,8.295900E-01,1.701100E+00,&
     & 4.118500E+00,1.254600E+01,5.811500E+01,6.173700E+02,3.183200E+03,&
     & 6.917200E+03,1.852000E+04,6.048100E+04,1.081833E+06,7.578800E-02,&
     & 1.878900E-01,3.439200E-01,6.754400E-01,1.393900E+00,3.327200E+00,&
     & 9.723800E+00,4.373500E+01,4.631600E+02,2.387500E+03,5.188200E+03,&
     & 1.389000E+04,4.536200E+04,8.113840E+05,5.240100E-02,1.296500E-01,&
     & 2.404000E-01,4.741100E-01,9.860500E-01,2.385300E+00,7.031900E+00,&
     & 2.980300E+01,3.089500E+02,1.591900E+03,3.459100E+03,9.260300E+03,&
     & 3.024200E+04,5.409316E+05,2.767900E-02,6.834700E-02,1.289900E-01,&
     & 2.557200E-01,5.390300E-01,1.315600E+00,3.972500E+00,1.650700E+01,&
     & 1.550400E+02,7.961900E+02,1.729900E+03,4.630500E+03,1.512100E+04,&
     & 2.704640E+05,1.395800E-04,3.762600E-04,7.360600E-04,1.436200E-03,&
     & 3.011000E-03,7.451700E-03,2.632800E-02,1.424100E-01,1.532000E+00,&
     & 7.553600E+00,1.222100E+01,1.925600E+01,2.839800E+01,4.917822E+01/
      data   absb(:,661:680) /                                          &
     & 1.053000E-01,2.469300E-01,4.568500E-01,8.995500E-01,1.862500E+00,&
     & 4.548000E+00,1.401000E+01,6.563800E+01,6.882100E+02,3.525100E+03,&
     & 7.576800E+03,2.087800E+04,6.864400E+04,1.057272E+06,8.422500E-02,&
     & 1.975100E-01,3.734400E-01,7.338600E-01,1.525700E+00,3.655400E+00,&
     & 1.078900E+01,4.936100E+01,5.162800E+02,2.644000E+03,5.682800E+03,&
     & 1.565900E+04,5.148300E+04,7.929744E+05,5.802700E-02,1.365300E-01,&
     & 2.612900E-01,5.166400E-01,1.082700E+00,2.628500E+00,7.776400E+00,&
     & 3.343200E+01,3.443600E+02,1.762800E+03,3.788800E+03,1.043900E+04,&
     & 3.432300E+04,5.286484E+05,3.048600E-02,7.199400E-02,1.401400E-01,&
     & 2.794100E-01,5.941600E-01,1.456400E+00,4.415200E+00,1.825200E+01,&
     & 1.726000E+02,8.816800E+02,1.894800E+03,5.220000E+03,1.716200E+04,&
     & 2.643207E+05,1.489400E-04,3.911200E-04,7.595600E-04,1.468100E-03,&
     & 3.072000E-03,7.601300E-03,2.785400E-02,1.653500E-01,1.692000E+00,&
     & 7.808900E+00,1.238500E+01,1.884200E+01,2.768600E+01,4.412788E+01,&
     & 1.154400E-01,2.599800E-01,4.966700E-01,9.753300E-01,2.048000E+00,&
     & 5.052200E+00,1.571400E+01,7.428100E+01,7.655500E+02,3.950400E+03,&
     & 8.385200E+03,2.348100E+04,7.702400E+04,1.031081E+06,9.206100E-02,&
     & 2.090300E-01,4.065200E-01,7.974500E-01,1.674900E+00,4.035100E+00,&
     & 1.203100E+01,5.583500E+01,5.742900E+02,2.962900E+03,6.289100E+03,&
     & 1.761100E+04,5.776800E+04,7.733087E+05,6.322600E-02,1.447000E-01,&
     & 2.846200E-01,5.631900E-01,1.192700E+00,2.907400E+00,8.619000E+00,&
     & 3.764400E+01,3.830200E+02,1.975500E+03,4.193000E+03,1.174100E+04,&
     & 3.851300E+04,5.155491E+05,3.307100E-02,7.631600E-02,1.524500E-01,&
     & 3.054700E-01,6.576300E-01,1.616700E+00,4.907000E+00,2.024600E+01,&
     & 1.918400E+02,9.880400E+02,2.096800E+03,5.870900E+03,1.925700E+04,&
     & 2.577745E+05,1.571300E-04,4.043100E-04,7.777000E-04,1.495200E-03,&
     & 3.117600E-03,7.718500E-03,2.932500E-02,1.911400E-01,1.846800E+00,&
     & 7.978600E+00,1.241700E+01,1.842700E+01,2.662700E+01,3.973342E+01,&
     & 1.245700E-01,2.757700E-01,5.413300E-01,1.060600E+00,2.254500E+00,&
     & 5.641100E+00,1.775200E+01,8.411700E+01,8.496500E+02,4.459800E+03,&
     & 9.374400E+03,2.625800E+04,8.540400E+04,1.003376E+06,9.910200E-02,&
     & 2.229700E-01,4.429600E-01,8.682900E-01,1.840300E+00,4.472100E+00,&
     & 1.352500E+01,6.320500E+01,6.373600E+02,3.345000E+03,7.031000E+03,&
     & 1.969300E+04,6.405300E+04,7.525372E+05,6.787900E-02,1.545800E-01,&
     & 3.104500E-01,6.148700E-01,1.315000E+00,3.225000E+00,9.612400E+00,&
     & 4.246500E+01,4.250800E+02,2.230200E+03,4.687500E+03,1.312900E+04,&
     & 4.270300E+04,5.009958E+05,3.540000E-02,8.150000E-02,1.661900E-01,&
     & 3.342400E-01,7.285400E-01,1.799200E+00,5.471800E+00,2.250700E+01,&
     & 2.128200E+02,1.115400E+03,2.344100E+03,6.564900E+03,2.135200E+04,&
     & 2.508512E+05,1.637200E-04,4.152000E-04,7.933400E-04,1.516300E-03,&
     & 3.142400E-03,7.824500E-03,3.078800E-02,2.195400E-01,1.996900E+00,&
     & 8.007300E+00,1.240000E+01,1.800500E+01,2.549900E+01,3.567608E+01,&
     & 7.338200E-02,2.034700E-01,3.535500E-01,6.904200E-01,1.416100E+00,&
     & 3.410000E+00,1.034300E+01,4.837200E+01,5.331100E+02,2.887400E+03,&
     & 6.354400E+03,1.677900E+04,5.478700E+04,1.233797E+06,5.909100E-02,&
     & 1.612800E-01,2.866900E-01,5.631400E-01,1.161800E+00,2.780600E+00,&
     & 8.114900E+00,3.647600E+01,3.999600E+02,2.165700E+03,4.766000E+03,&
     & 1.258400E+04,4.109000E+04,9.253331E+05,4.094900E-02,1.110700E-01,&
     & 1.995600E-01,3.943900E-01,8.188300E-01,1.985600E+00,5.888000E+00,&
     & 2.516700E+01,2.668200E+02,1.443900E+03,3.177600E+03,8.389800E+03,&
     & 2.739400E+04,6.168986E+05,2.172000E-02,5.837300E-02,1.067300E-01,&
     & 2.120200E-01,4.450600E-01,1.089600E+00,3.307700E+00,1.420000E+01,&
     & 1.342800E+02,7.222100E+02,1.589300E+03,4.195200E+03,1.369700E+04,&
     & 3.084413E+05,1.036900E-04,2.908800E-04,5.772100E-04,1.136700E-03,&
     & 2.396100E-03,5.976800E-03,2.066200E-02,1.078600E-01,1.306900E+00,&
     & 7.074600E+00,1.203400E+01,1.957300E+01,3.018300E+01,5.580120E+01/
      data   absb(:,681:700) /                                          &
     & 8.349200E-02,2.127500E-01,3.790700E-01,7.488800E-01,1.542200E+00,&
     & 3.754100E+00,1.158100E+01,5.443500E+01,5.997900E+02,3.172400E+03,&
     & 6.954700E+03,1.911800E+04,6.332300E+04,1.209233E+06,6.705400E-02,&
     & 1.692100E-01,3.094400E-01,6.110800E-01,1.267500E+00,3.050500E+00,&
     & 9.021500E+00,4.098500E+01,4.499700E+02,2.379400E+03,5.216200E+03,&
     & 1.433900E+04,4.749200E+04,9.069151E+05,4.631700E-02,1.165900E-01,&
     & 2.160800E-01,4.287800E-01,8.966100E-01,2.186800E+00,6.547700E+00,&
     & 2.803500E+01,3.001600E+02,1.586400E+03,3.477700E+03,9.559300E+03,&
     & 3.166200E+04,6.046112E+05,2.442200E-02,6.129600E-02,1.156900E-01,&
     & 2.308500E-01,4.896100E-01,1.206700E+00,3.700800E+00,1.564400E+01,&
     & 1.507200E+02,7.934600E+02,1.739300E+03,4.780000E+03,1.583100E+04,&
     & 3.023003E+05,1.125800E-04,3.055000E-04,5.993300E-04,1.172100E-03,&
     & 2.463400E-03,6.134800E-03,2.208400E-02,1.271300E-01,1.475300E+00,&
     & 7.483100E+00,1.225200E+01,1.949600E+01,2.896100E+01,5.057620E+01,&
     & 9.350200E-02,2.224800E-01,4.107500E-01,8.136200E-01,1.692900E+00,&
     & 4.160000E+00,1.298600E+01,6.181400E+01,6.734300E+02,3.546500E+03,&
     & 7.653800E+03,2.174700E+04,7.246300E+04,1.182375E+06,7.484500E-02,&
     & 1.778700E-01,3.363500E-01,6.653900E-01,1.391400E+00,3.363600E+00,&
     & 1.004400E+01,4.649800E+01,5.051900E+02,2.660000E+03,5.740500E+03,&
     & 1.631000E+04,5.434800E+04,8.867806E+05,5.151400E-02,1.227900E-01,&
     & 2.351400E-01,4.683200E-01,9.876200E-01,2.419400E+00,7.271000E+00,&
     & 3.158200E+01,3.369700E+02,1.773500E+03,3.827200E+03,1.087400E+04,&
     & 3.623200E+04,5.911823E+05,2.702100E-02,6.456200E-02,1.258700E-01,&
     & 2.528700E-01,5.417800E-01,1.341500E+00,4.132200E+00,1.737100E+01,&
     & 1.689600E+02,8.870300E+02,1.914000E+03,5.437200E+03,1.811600E+04,&
     & 2.955920E+05,1.204900E-04,3.183000E-04,6.194300E-04,1.199800E-03,&
     & 2.518200E-03,6.267600E-03,2.343100E-02,1.495700E-01,1.640600E+00,&
     & 7.769200E+00,1.246100E+01,1.907800E+01,2.829500E+01,4.529510E+01,&
     & 1.028900E-01,2.341900E-01,4.470700E-01,8.837300E-01,1.867100E+00,&
     & 4.640400E+00,1.463800E+01,7.045500E+01,7.547200E+02,4.004400E+03,&
     & 8.537300E+03,2.464100E+04,8.186700E+04,1.153467E+06,8.211500E-02,&
     & 1.882400E-01,3.666800E-01,7.247900E-01,1.532700E+00,3.727800E+00,&
     & 1.124700E+01,5.296600E+01,5.661500E+02,3.003500E+03,6.403100E+03,&
     & 1.848100E+04,6.140000E+04,8.651133E+05,5.633900E-02,1.301300E-01,&
     & 2.565800E-01,5.118800E-01,1.091800E+00,2.688000E+00,8.099300E+00,&
     & 3.577700E+01,3.776000E+02,2.002500E+03,4.268900E+03,1.232100E+04,&
     & 4.093300E+04,5.767298E+05,2.941900E-02,6.843400E-02,1.371700E-01,&
     & 2.773000E-01,6.019600E-01,1.496300E+00,4.619600E+00,1.937300E+01,&
     & 1.891600E+02,1.001600E+03,2.134800E+03,6.160500E+03,2.046700E+04,&
     & 2.883666E+05,1.274400E-04,3.297500E-04,6.352600E-04,1.224200E-03,&
     & 2.559500E-03,6.371300E-03,2.477600E-02,1.750700E-01,1.799900E+00,&
     & 7.963200E+00,1.253300E+01,1.868000E+01,2.718400E+01,4.076718E+01,&
     & 1.113200E-01,2.482400E-01,4.880300E-01,9.625400E-01,2.061000E+00,&
     & 5.203500E+00,1.662500E+01,8.031400E+01,8.437900E+02,4.545400E+03,&
     & 9.638800E+03,2.774100E+04,9.132500E+04,1.122900E+06,8.860400E-02,&
     & 2.008100E-01,4.002500E-01,7.907000E-01,1.690000E+00,4.147600E+00,&
     & 1.270000E+01,6.035200E+01,6.329600E+02,3.409200E+03,7.229200E+03,&
     & 2.080600E+04,6.849400E+04,8.421782E+05,6.062900E-02,1.390300E-01,&
     & 2.803900E-01,5.601500E-01,1.208400E+00,2.994800E+00,9.074000E+00,&
     & 4.059800E+01,4.221400E+02,2.273000E+03,4.819600E+03,1.387100E+04,&
     & 4.566300E+04,5.614498E+05,3.155900E-02,7.309800E-02,1.498100E-01,&
     & 3.043000E-01,6.696100E-01,1.673000E+00,5.178700E+00,2.164300E+01,&
     & 2.113600E+02,1.136800E+03,2.410100E+03,6.935600E+03,2.283200E+04,&
     & 2.807214E+05,1.331700E-04,3.391300E-04,6.490500E-04,1.243400E-03,&
     & 2.583100E-03,6.466700E-03,2.610300E-02,2.033900E-01,1.955800E+00,&
     & 8.008100E+00,1.252600E+01,1.830500E+01,2.598800E+01,3.659318E+01/
      data   absb(:,701:720) /                                          &
     & 6.428900E-02,1.825800E-01,3.172200E-01,6.203200E-01,1.276500E+00,&
     & 3.089100E+00,9.468300E+00,4.486300E+01,5.126000E+02,2.840600E+03,&
     & 6.352100E+03,1.710800E+04,5.676400E+04,1.374655E+06,5.178300E-02,&
     & 1.447000E-01,2.572100E-01,5.068800E-01,1.050000E+00,2.532300E+00,&
     & 7.475700E+00,3.386500E+01,3.845800E+02,2.130600E+03,4.764300E+03,&
     & 1.283100E+04,4.257300E+04,1.030995E+06,3.585100E-02,9.953500E-02,&
     & 1.787800E-01,3.548200E-01,7.397700E-01,1.807600E+00,5.437800E+00,&
     & 2.349400E+01,2.565800E+02,1.420500E+03,3.176500E+03,8.554300E+03,&
     & 2.838300E+04,6.873292E+05,1.898300E-02,5.220200E-02,9.535200E-02,&
     & 1.904000E-01,4.015800E-01,9.919900E-01,3.054000E+00,1.334700E+01,&
     & 1.292800E+02,7.105000E+02,1.588700E+03,4.277500E+03,1.419200E+04,&
     & 3.436689E+05,8.320500E-05,2.353500E-04,4.683000E-04,9.254600E-04,&
     & 1.955800E-03,4.910600E-03,1.724300E-02,9.462200E-02,1.245900E+00,&
     & 6.960000E+00,1.199500E+01,1.975200E+01,3.079100E+01,5.738682E+01,&
     & 7.348600E-02,1.911300E-01,3.398400E-01,6.739300E-01,1.393400E+00,&
     & 3.410000E+00,1.064500E+01,5.083800E+01,5.813100E+02,3.148400E+03,&
     & 6.992000E+03,1.969600E+04,6.613000E+04,1.347929E+06,5.904700E-02,&
     & 1.519700E-01,2.776200E-01,5.511800E-01,1.148600E+00,2.786600E+00,&
     & 8.340000E+00,3.830100E+01,4.361100E+02,2.361400E+03,5.244200E+03,&
     & 1.477200E+04,4.959800E+04,1.010941E+06,4.075600E-02,1.045800E-01,&
     & 1.936600E-01,3.866000E-01,8.125200E-01,1.997200E+00,6.074300E+00,&
     & 2.631400E+01,2.909300E+02,1.574400E+03,3.496400E+03,9.848300E+03,&
     & 3.306600E+04,6.739830E+05,2.145600E-02,5.484400E-02,1.034900E-01,&
     & 2.077900E-01,4.432000E-01,1.102700E+00,3.433400E+00,1.479300E+01,&
     & 1.462100E+02,7.874700E+02,1.748600E+03,4.924500E+03,1.653300E+04,&
     & 3.369897E+05,9.060100E-05,2.477300E-04,4.876300E-04,9.554900E-04,&
     & 2.015900E-03,5.045900E-03,1.848700E-02,1.132000E-01,1.417900E+00,&
     & 7.395400E+00,1.228000E+01,1.966500E+01,2.953800E+01,5.204388E+01,&
     & 8.265700E-02,1.999500E-01,3.680100E-01,7.332900E-01,1.532900E+00,&
     & 3.791300E+00,1.199600E+01,5.806100E+01,6.574100E+02,3.557600E+03,&
     & 7.737500E+03,2.260300E+04,7.624300E+04,1.318632E+06,6.621100E-02,&
     & 1.597700E-01,3.019500E-01,6.011400E-01,1.264400E+00,3.083300E+00,&
     & 9.325000E+00,4.369200E+01,4.931800E+02,2.668400E+03,5.803300E+03,&
     & 1.695300E+04,5.718300E+04,9.889807E+05,4.553900E-02,1.101500E-01,&
     & 2.109200E-01,4.230200E-01,8.977400E-01,2.218500E+00,6.779400