      SUBROUTINE W3FA03(PRESS,HEIGHT,TEMP,THETA)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    W3FA03      COMPUTE STANDARD HEIGHT, TEMP, AND POT TEMP
C   PRGMMR: KEYSER           ORG: W/NMC22    DATE: 92-06-29
C
C ABSTRACT: COMPUTES THE STANDARD HEIGHT, TEMPERATURE, AND POTENTIAL
C   TEMPERATURE GIVEN THE PRESSURE IN MILLIBARS ( > 8.68 MB ).  FOR
C   HEIGHT AND TEMPERATURE THE RESULTS DUPLICATE THE VALUES IN THE
C   U.S. STANDARD ATMOSPHERE (L962), WHICH IS THE ICAO STANDARD
C   ATMOSPHERE TO 54.7487 MB (20 KM) AND THE PROPOSED EXTENSION TO
C   8.68 MB (32 KM).  FOR POTENTIAL TEMPERATURE A VALUE OF  2/7  IS
C   USED FOR  RD/CP.
C
C PROGRAM HISTORY LOG:
C   74-06-01  J. MCDONELL W345     -- ORIGINAL AUTHOR
C   84-06-01  R.E.JONES W342       -- CHANGE TO IBM VS FORTRAN
C   92-06-29  D. A. KEYSER W/NMC22 -- CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:    CALL W3FA03(PRESS,HEIGHT,TEMP,THETA)
C   INPUT ARGUMENT LIST:
C     PRESS    - PRESSURE IN MILLIBARS
C
C   OUTPUT ARGUMENT LIST:
C     HEIGHT   - HEIGHT IN METERS
C     TEMP     - TEMPERATURE IN DEGREES KELVIN
C     THETA    - POTENTIAL TEMPERATURE IN DEGREES KELVIN
C
C   SUBPROGRAMS CALLED:
C     LIBRARY:
C       CRAY     - ALOG
C
C
C REMARKS: NOT VALID FOR PRESSURES LESS THAN 8.68 MILLIBARS, DECLARE
C   ALL PARAMETERS AS TYPE REAL.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
      REAL  M0
C
      SAVE
C
      DATA  G/9.80665/,RSTAR/8314.32/,M0/28.9644/,PISO/54.7487/,
     $ ZISO/20000./,SALP/-.0010/,PZERO/1013.25/,T0/288.15/,ALP/.0065/,
     $ PTROP/226.321/,TSTR/216.65/
C
      ROVCP = 2.0/7.0
      R     = RSTAR/M0
      ROVG  = R/G
      FKT   = ROVG * TSTR
      AR    = ALP  * ROVG
      PP0   = PZERO**AR
      IF(PRESS.LT.PISO)   GO TO 100
      IF(PRESS.GT.PTROP)  GO TO 200
C
C     COMPUTE ISOTHERMAL CASES
C
      HEIGHT = 11000.0 + (FKT * ALOG(PTROP/PRESS))
      TEMP = TSTR
      GO TO 300
C
C     COMPUTE LAPSE RATE = -.0010 CASES
C
 100  CONTINUE
      AR     = SALP * ROVG
      PP0    = PISO**AR
      HEIGHT = ((TSTR/(PP0 * SALP )) * (PP0-(PRESS ** AR))) + ZISO
      TEMP   = TSTR - ((HEIGHT - ZISO) * SALP)
      GO TO 300
C
 200  CONTINUE
      HEIGHT = (T0/(PP0 * ALP)) * (PP0 - (PRESS ** AR))
      TEMP   = T0 - (HEIGHT * ALP)
C
 300  CONTINUE
      THETA  = TEMP * ((1000./PRESS)**ROVCP)
      RETURN
      END
