!-----------------------------------------------------------------------
      MODULE MODULE_H_TO_V
!-----------------------------------------------------------------------
!
!***  MOVE DATA RESIDING ON B-GRID H POINTS TO V POINTS.
!
!-----------------------------------------------------------------------
!
      USE MODULE_KINDS
      USE MODULE_MY_DOMAIN_SPECS
!
!-----------------------------------------------------------------------
!
      IMPLICIT NONE
!
!-----------------------------------------------------------------------
!
      PRIVATE
!
      PUBLIC :: H_TO_V,H_TO_V_TEND
!
!-----------------------------------------------------------------------
!
      INTERFACE H_TO_V
        MODULE PROCEDURE H_TO_V_2D
        MODULE PROCEDURE H_TO_V_3D
      END INTERFACE
!
      INTERFACE H_TO_V_TEND
        MODULE PROCEDURE H_TO_V_TEND_2D
        MODULE PROCEDURE H_TO_V_TEND_3D
      END INTERFACE
!
!-----------------------------------------------------------------------
!
      CONTAINS
!
!-----------------------------------------------------------------------
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!-----------------------------------------------------------------------
!
      SUBROUTINE H_TO_V_2D(ARRAY_H,ARRAY_V)
!
!-----------------------------------------------------------------------
!
!***  MOVE A 2-D ARRAY FROM H POINTS TO V POINTS.
!
!-----------------------------------------------------------------------
!***  ARGUMENT VARIABLES
!-----------------------------------------------------------------------
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME),INTENT(IN) ::  ARRAY_H
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME),INTENT(OUT) :: ARRAY_V
!
!-----------------------------------------------------------------------
!***  LOCAL VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT) :: I,J
!
!-----------------------------------------------------------------------
!***********************************************************************
!-----------------------------------------------------------------------
!
!$omp parallel do                                                       &
!$omp& private(i,j)
      DO J=JTS,JTE_B1			
      DO I=ITS,ITE_B1			
        ARRAY_V(I,J)=(ARRAY_H(I,J  )+ARRAY_H(I+1,J  )                   &
                     +ARRAY_H(I,J+1)+ARRAY_H(I+1,J+1))*0.25
      ENDDO
      ENDDO
!-----------------------------------------------------------------------
!
      END SUBROUTINE H_TO_V_2D
!
!-----------------------------------------------------------------------
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!--------------------------------------------------------------------
!
      SUBROUTINE H_TO_V_3D(ARRAY_H,ARRAY_V,LM)
!
!-----------------------------------------------------------------------
!
!***  MOVE A 3-D ARRAY FROM H POINTS TO V POINTS.
!
!-----------------------------------------------------------------------
!***  ARGUMENT VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT),INTENT(IN) :: LM
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME,1:LM),INTENT(IN) ::     &
                                                                 ARRAY_H
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME,1:LM),INTENT(OUT) ::    &
                                                                 ARRAY_V
!
!-----------------------------------------------------------------------
!***  LOCAL VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT) :: I,J,K
!
!-----------------------------------------------------------------------
!***********************************************************************
!-----------------------------------------------------------------------
!
!$omp parallel do                                                       &
!$omp& private(i,j,k)
      DO K=1,LM
      DO J=JTS,JTE_B1			
      DO I=ITS,ITE_B1			
        ARRAY_V(I,J,K)=(ARRAY_H(I,J  ,K)+ARRAY_H(I+1,J  ,K)             &
                       +ARRAY_H(I,J+1,K)+ARRAY_H(I+1,J+1,K))*0.25
      ENDDO
      ENDDO
      ENDDO
!-----------------------------------------------------------------------
!
      END SUBROUTINE H_TO_V_3D
!
!-----------------------------------------------------------------------
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!--------------------------------------------------------------------
!
      SUBROUTINE H_TO_V_TEND_2D(TEND,DT,NSTEPS,ARRAY_V)
!
!-----------------------------------------------------------------------
!
!***  UPDATE 2-D V POINT ARRAYS WITH TENDENCIES ON H POINTS.
!
!-----------------------------------------------------------------------
!***  ARGUMENT VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT),INTENT(IN) :: NSTEPS
!
      REAL(KIND=KFPT),INTENT(IN)    :: DT
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME),INTENT(IN)    ::  TEND
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME),INTENT(INOUT) :: ARRAY_V
!
!-----------------------------------------------------------------------
!***  LOCAL VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT) :: I,J
!
      REAL(KIND=KFPT) :: DELTA_T
!
!-----------------------------------------------------------------------
!***********************************************************************
!-----------------------------------------------------------------------
!
      DELTA_T=DT*NSTEPS
!
!$omp parallel do                                                       &
!$omp& private(i,j)
      DO J=JTS,JTE_B1			
      DO I=ITS,ITE_B1			
        ARRAY_V(I,J)= ARRAY_V(I,J)+                                     &
                      0.25*(TEND(I,J  )+TEND(I+1,J  )                   &
                           +TEND(I,J+1)+TEND(I+1,J+1))*DELTA_T
      ENDDO
      ENDDO
!-----------------------------------------------------------------------
!
      END SUBROUTINE H_TO_V_TEND_2D
!
!-----------------------------------------------------------------------
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!--------------------------------------------------------------------
!
      SUBROUTINE H_TO_V_TEND_3D(TEND,DT,NSTEPS,LM,ARRAY_V)
!
!-----------------------------------------------------------------------
!
!***  UPDATE 3-D V POINT ARRAYS WITH TENDENCIES ON H POINTS.
!***  THE 3-D TEND ARRAY IS I,K,J WHERE K IS RECKONED POSITIVE UPWARD.
!
!-----------------------------------------------------------------------
!***  ARGUMENT VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT) :: LM,NSTEPS
!
      REAL(KIND=KFPT)    :: DT 
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME,1:LM),INTENT(IN) :: TEND
!
      REAL(KIND=KFPT),DIMENSION(IMS:IME,JMS:JME,1:LM),INTENT(INOUT) ::  &
                                                                 ARRAY_V
!
!-----------------------------------------------------------------------
!***  LOCAL VARIABLES
!-----------------------------------------------------------------------
!
      INTEGER(KIND=KINT) :: I,J,K
!
      REAL(KIND=KFPT)    :: DELTA_T
!
!-----------------------------------------------------------------------
!***********************************************************************
!-----------------------------------------------------------------------
!
      DELTA_T=DT*NSTEPS
!
!$omp parallel do                                                       &
!$omp& private(i,j,k)
      DO K=1,LM
      DO J=JTS,JTE_B1
        DO I=ITS,ITE_B1
          ARRAY_V(I,J,K)=ARRAY_V(I,J,K)+                                &
                         0.25*(TEND(I,J,K  )+TEND(I+1,J,K  )            &
                              +TEND(I,J+1,K)+TEND(I+1,J+1,K))*DELTA_T
        ENDDO
      ENDDO
      ENDDO
!-----------------------------------------------------------------------
!
      END SUBROUTINE H_TO_V_TEND_3D
!
!-----------------------------------------------------------------------
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
!--------------------------------------------------------------------
!
      END MODULE MODULE_H_TO_V
!
!-----------------------------------------------------------------------
