
###############################################################################
#
# Export variables to the default values
#  - first common variables, then model specific ones
#  - different machines, different defaults:
#
###############################################################################

if [ $MACHINE_ID = wcoss ]; then

  TASKS_dflt=32  ; TPN_dflt=16 ; INPES_dflt=05 ; JNPES_dflt=06 ; WTPG_dflt=2
  TASKS_thrd=16  ; TPN_thrd=08 ; INPES_thrd=03 ; JNPES_thrd=05 ; WTPG_thrd=1
  TASKS_nest=96  ; TPN_nest=16 ; INPES_nest=02 ; JNPES_nest=02 ; WTPG_nest=1
  TASKS_fltr=64  ; TPN_fltr=16 ; INPES_fltr=02 ; JNPES_fltr=02 ; WTPG_fltr=1
  TASKS_mvg1=96  ; TPN_mvg1=16 ; INPES_mvg1=05 ; JNPES_mvg1=07 ; WTPG_mvg1=1
  TASKS_mvg2=96  ; TPN_mvg2=16 ; INPES_mvg2=05 ; JNPES_mvg2=18 ; WTPG_mvg2=2
  export TPN=16

elif [ $MACHINE_ID = wcoss_cray ]; then

  TASKS_dflt=48  ; TPN_dflt=24 ; INPES_dflt=05 ; JNPES_dflt=09 ; WTPG_dflt=3
  TASKS_thrd=48  ; TPN_thrd=12 ; INPES_thrd=05 ; JNPES_thrd=09 ; WTPG_thrd=3
  TASKS_nest=96  ; TPN_nest=24 ; INPES_nest=02 ; JNPES_nest=02 ; WTPG_nest=1
  TASKS_fltr=72  ; TPN_fltr=24 ; INPES_fltr=03 ; JNPES_fltr=04 ; WTPG_fltr=1
  TASKS_mvg1=96  ; TPN_mvg1=24 ; INPES_mvg1=05 ; JNPES_mvg1=07 ; WTPG_mvg1=1
  TASKS_mvg2=96  ; TPN_mvg2=24 ; INPES_mvg2=05 ; JNPES_mvg2=18 ; WTPG_mvg2=2
  export TPN=24

elif [ $MACHINE_ID = theia ]; then

  TASKS_dflt=48  ; TPN_dflt=24 ; INPES_dflt=05 ; JNPES_dflt=09 ; WTPG_dflt=3
  TASKS_thrd=24  ; TPN_thrd=12 ; INPES_thrd=04 ; JNPES_thrd=05 ; WTPG_thrd=4
  TASKS_nest=96  ; TPN_nest=24 ; INPES_nest=02 ; JNPES_nest=02 ; WTPG_nest=1
  TASKS_fltr=72  ; TPN_fltr=24 ; INPES_fltr=03 ; JNPES_fltr=04 ; WTPG_fltr=1
  TASKS_mvg1=96  ; TPN_mvg1=24 ; INPES_mvg1=05 ; JNPES_mvg1=07 ; WTPG_mvg1=1
  TASKS_mvg2=96  ; TPN_mvg2=24 ; INPES_mvg2=05 ; JNPES_mvg2=18 ; WTPG_mvg2=2
  export TPN=24

fi

export_common ()
{
export THRD=1
export WTPG=$WTPG_dflt
export WLCLK=15
export GEFS_ENSEMBLE=0
export GEN_ENSEMBLE=0
export WRITE_DOPOST=.false.
export POST_GRIBVERSION='grib1'
}

export_nmm ()
{
export_common
export INPES=$INPES_dflt ; export JNPES=$JNPES_dflt ; export WTPG=$WTPG_dflt
export TASKS=$TASKS_dflt ; export TPN=$TPN_dflt
export GBRG=reg          ; export NEMSI=false       ; export RSTRT=false
export AFFN=core         ; export NODE=1
export NCHILD=0          ; export MODE=1-way        ; export WGT=0.0
export FCSTL=48
export PCPFLG=false      ; export WPREC=false
export TS=false
export RADTN=rrtm        ; export CONVC=bmj         ; export TURBL=myj
export NP3D=3            ; export CLDFRACTION=default
export SFC_LAYER=myj     ; export LAND_SURFACE=noah
export MICRO=fer_hires   ; export gfsP=false        ; export SPEC_ADV=false
}

export_nems ()
{
:
}
