#!/bin/bash
set -eu

source rt_utils.sh
source atparse.bash

mkdir -p ${RUNDIR}
cd $RUNDIR

###############################################################################
# Make configure and run files
###############################################################################

cp ${PATHRT}/$NMMBX                      NMMB.x
cp ${PATHRT}/modules.nmmb_${COMPILE_NR}  modules.nmmb

wrtdopost="${WRITE_DOPOST}"
postgrbvs="${POST_GRIBVERSION}"
SRCD="${PATHTR}"
RUND="${RUNDIR}"

atparse < ${PATHRT}/nmm_conf/nmm_${GBRG}_run.IN > nmm_run

atparse < ${PATHRT}/nmm_conf/nmm_${GBRG}_conf.IN > configure_file_01

if [[ ${GBRG} = nests ]]; then
  atparse < ${PATHRT}/nmm_conf/nmm_nests_conf_02.IN > configure_file_02
  atparse < ${PATHRT}/nmm_conf/nmm_nests_conf_03.IN > configure_file_03
  atparse < ${PATHRT}/nmm_conf/nmm_nests_conf_04.IN > configure_file_04
fi

if [[ ${GBRG} = mnests ]]; then
  rm -f configure_file_02 configure_file_03 configure_file_04
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_conf_02.IN > configure_file_02
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_conf_03.IN > configure_file_03
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_conf_04.IN > configure_file_04
fi

if [[ ${MODE} = 2-way ]]; then
  rm -f configure_file_02 configure_file_03 configure_file_04
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_2way_conf_02.IN > configure_file_02
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_2way_conf_03.IN > configure_file_03
  atparse < ${PATHRT}/nmm_conf/nmm_mnests_2way_conf_04.IN > configure_file_04
fi

if [[ ${GBRG} = fltr ]]; then
  rm -f configure_file_02 configure_file_03 configure_file_04
  cp ${PATHRT}/nmm_conf/nmm_fltr_conf_02 configure_file_02
  cp ${PATHRT}/nmm_conf/nmm_fltr_conf_03 configure_file_03
fi

if [[ ${GBRG} = fltr_zombie ]]; then
  rm -f configure_file_02 configure_file_03 configure_file_04
  cp ${PATHRT}/nmm_conf/nmm_fltr_conf_02 configure_file_02
  cp ${PATHRT}/nmm_conf/nmm_fltr_zombie_conf_03 configure_file_03
fi

source ./nmm_run

if [[ $SCHEDULER = 'moab' ]]; then
  atparse < $PATHRT/nmm_conf/nmm_msub.IN > job_card
elif [[ $SCHEDULER = 'pbs' ]]; then
  NODES=$(( TASKS / TPN ))
  atparse < $PATHRT/nmm_conf/nmm_qsub.IN > job_card
elif [[ $SCHEDULER = 'lsf' ]]; then
  atparse < $PATHRT/nmm_conf/nmm_bsub.IN > job_card
fi

################################################################################
# Submit test
################################################################################

if [[ $ROCOTO = 'false' ]]; then
  submit_and_wait job_card
else
  chmod u+x job_card
  ./job_card
fi

check_results

################################################################################
# End test
################################################################################

exit 0
