      subroutine set_eta ( km,ptop,ak,bk )
      implicit none
      integer k, km
      real ak(km+1),bk(km+1)
      real ptop                      ! model top (Pa)

      real a20(21), b20(21)
      real a26(27), b26(27)
      real a32(33), b32(33)
      real a42(43), b42(43)
      real a44(45), b44(45)
      real a55(56), b55(56)
      real a72(73), b72(73)
      real a91(92), b91(92)
      real a137(138), b137(138)

      data a20 /  &
       737.44866,         320.17959,         186.17679,   &
       135.92544,          96.25746,          87.67601,   &
        61.47969,          66.97722,          42.58292,   &
        56.11863,          30.33517,          49.84043,   &
        21.48820,          46.05084,          14.61322,   &
        43.75791,           8.98483,          42.43210,   &
         4.19583,          41.76551,           0.00000 /

      data b20 / &
        0.00000,           0.05000,           0.10000,   &
        0.15000,           0.20000,           0.25000,   &
        0.30000,           0.35000,           0.40000,   &
        0.45000,           0.50000,           0.55000,   &
        0.60000,           0.65000,           0.70000,   &
        0.75000,           0.80000,           0.85000,   &
        0.90000,           0.95000,           1.00000 /

! CAM4 26-Levels
! --------------
      data a26 / 219.4067,   489.5209,  988.2418,  1805.201,            &
                 2983.724,   4462.334,  6160.587,  7851.243,  7731.271, &
                 7590.131,   7424.086,  7228.744,  6998.933,  6728.574, &
                 6410.509,   6036.322,  5596.111,  5078.225,  4468.960, &
                 3752.191,   2908.949,  2084.739,  1334.443,  708.4990, &
                 252.1360,   0.000000,  0.000000 /

      data b26 / 0.0000000,     0.0000000,     0.0000000,     0.0000000,     0.0000000,     &
                 0.0000000,     0.0000000,     0.0000000,     1.5053090E-02, 3.2762282E-02, &
                 5.3596221E-02, 7.8106269E-02, 0.1069411,     0.1408637,     0.1807720,     &
                 0.2277220,     0.2829562,     0.3479364,     0.4243822,     0.5143168,     &
                 0.6201202,     0.7235355,     0.8176768,     0.8962153,     0.9534761,     &
                 0.9851122,      1.000000 /


      data a32/40.00000,   100.00000,     200.00000,   &
              370.00000,   630.00000,	 1000.00000,   &
             1510.00000,  2160.00000,	 2900.00000,   &
             3680.00000,  4535.00000,	 5505.00000,   &
             6607.26750,  7851.22980,	 9236.56610,   &
            10866.34270, 12783.70000,	15039.30000,   &
            17693.00000, 20119.20876,	21686.49129,   &
            22436.28749, 22388.46844,	21541.75227,   &
            19873.78342, 17340.31831,	13874.44006,   &
            10167.16551,  6609.84274,	 3546.59643,   &
             1270.49390,     0.00000,	    0.00000  /

	data b32/0.00000,    0.00000,      0.00000,   &
                 0.00000,    0.00000,	   0.00000,   &
                 0.00000,    0.00000,	   0.00000,   &
                 0.00000,    0.00000,	   0.00000,   &
                 0.00000,    0.00000,	   0.00000,   &
                 0.00000,    0.00000,	   0.00000,   &
                 0.00000,    0.00696,	   0.02801,   &
                 0.06372,    0.11503,	   0.18330,   &
                 0.27033,    0.37844,	   0.51046,   &
                 0.64271,    0.76492,	   0.86783,   &
                 0.94329,    0.98511,	   1.00000   /


      data a55/ 1.00000,       2.00000,       3.27000,   &
                4.75850,       6.60000,       8.93450,   &
               11.97030,      15.94950,      21.13490,   &
               27.85260,      36.50410,      47.58060,   &
               61.67790,      79.51340,     101.94420,   &
              130.05080,     165.07920,     208.49720,   &
              262.02120,     327.64330,     407.65670,   &
              504.68050,     621.68000,     761.98390,   &
              929.29430,    1127.68880,    1364.33920,   &
             1645.70720,    1979.15540,    2373.03610,   &
             2836.78160,    3380.99550,    4017.54170,   &
             4764.39320,    5638.79380,    6660.33770,   &
             7851.22980,    9236.56610,   10866.34270,   &
            12783.70000,   15039.30000,   17693.00000,   &
            20119.20876,   21686.49129,   22436.28749,   &
            22388.46844,   21541.75227,   19873.78342,   &
            17340.31831,   13874.44006,   10167.16551,   &
             6609.84274,    3546.59643,    1270.49390,   &
                0.00000,       0.00000   /

      data b55 / 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00000,       0.00000,       0.00000,   &
                 0.00696,       0.02801,       0.06372,   &
                 0.11503,       0.18330,       0.27033,   &
                 0.37844,       0.51046,       0.64271,   &
                 0.76492,       0.86783,       0.94329,   &
                 0.98511,       1.00000  /

! 42-Level
! --------
!       100.0000,        500.0000,       1500.0000,       3000.0000,       4500.0000, &
!      6000.0000,       7500.0000,       9200.0000,       11000.000,       13000.000, &
!      15000.000,       17500.000,       20119.201,       21686.501,       22436.301, &

      data a42 / &
        500.0000,        700.0000,       1050.0000,       1550.0000,       2350.0000, &
        3450.000,       4850.0000,       6550.0000,       8550.0000,       10950.000, &
        13750.00,       17200.000,       20119.201,       21686.501,       22436.301, &
       22389.800,       21877.598,       21214.998,       20325.898,       19309.696, &
       18161.897,       16960.896,       15625.996,       14290.995,       12869.594, &
       11895.862,       10918.171,       9936.5219,       8909.9925,       7883.4220, &
       7062.1982,       6436.2637,       5805.3211,       5169.6110,       4533.9010, &
       3898.2009,       3257.0809,       2609.2006,       1961.3106,       1313.4804, &
       659.37527,       4.8048257,       0.0000000 / 

      data b42 / &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,   8.1754130e-09,    0.0069600246,     0.028010041,     0.063720063, &
      0.11360208,      0.15622409,      0.20035011,      0.24674112,      0.29440312, &
      0.34338113,      0.39289115,      0.44374018,      0.49459020,      0.54630418, &
      0.58104151,      0.61581843,      0.65063492,      0.68589990,      0.72116594, &
      0.74937819,      0.77063753,      0.79194696,      0.81330397,      0.83466097, &
      0.85601798,      0.87742898,      0.89890800,      0.92038701,      0.94186501, &
      0.96340602,      0.98495195,       1.0000000 / 

! 72-Level (prior to 5/11/2005)
! -----------------------------
#if 0
      data a72 / &
         1.00000,     2.00000,     3.27000,     4.75850,     6.60000,     8.93450,   &
         11.9703,     15.9495,     21.1349,     27.8526,     36.5041,     47.5806,   &
         61.6779,     79.5134,     101.944,     130.051,     165.079,     208.497,   &
         262.021,     327.643,     407.657,     504.680,     621.680,     761.984,   &
         929.294,     1127.69,     1364.34,     1645.71,     1979.16,     2373.04,   &
         2836.78,     3381.00,     4017.54,     4764.39,     5638.79,     6660.34,   &
         7851.23,     9236.57,     10866.3,     12783.7,     15039.3,     17693.0,   &
         20119.2,     21686.5,     22436.3,     22389.8,     21877.6,     21215.0,   &
         20325.9,     19309.7,     18161.9,     16960.9,     15626.0,     14291.0,   &
         12869.6,     11409.0,     9936.52,     8909.99,     7883.42,     6856.90,   &
         5805.32,     5169.61,     4533.90,     3898.20,     3257.08,     2609.20,   &
         1961.31,     1313.48,     659.375,     332.086,     4.80469,     0.00000,   &
         0.00000 /

      data b72 / &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000,   &
        0.00696000,   0.0280100,   0.0637200,   0.113602,    0.156224,    0.200350,   &
         0.246741,    0.294403,    0.343381,    0.392891,    0.443740,    0.494590,   &
         0.546304,    0.598410,    0.650635,    0.685900,    0.721166,    0.756431,   &
         0.791947,    0.813304,    0.834661,    0.856018,    0.877429,    0.898908,   &
         0.920387,    0.941865,    0.963406,    0.974179,    0.984952,    0.992500,   &
         1.00000 /
#endif

! 72-Level (as of 5/11/2005)
! --------------------------
#if 1
      data a72 / &
       1.0000000,       2.0000002,       3.2700005,       4.7585009,       6.6000011, &
       8.9345014,       11.970302,       15.949503,       21.134903,       27.852606, &
       36.504108,       47.580610,       61.677911,       79.513413,       101.94402, &
       130.05102,       165.07903,       208.49704,       262.02105,       327.64307, &
       407.65710,       504.68010,       621.68012,       761.98417,       929.29420, &
       1127.6902,       1364.3402,       1645.7103,       1979.1604,       2373.0405, &
       2836.7806,       3381.0007,       4017.5409,       4764.3911,       5638.7912, &
       6660.3412,       7851.2316,       9236.5722,       10866.302,       12783.703, &
       15039.303,       17693.003,       20119.201,       21686.501,       22436.301, &
       22389.800,       21877.598,       21214.998,       20325.898,       19309.696, &
       18161.897,       16960.896,       15625.996,       14290.995,       12869.594, &
       11895.862,       10918.171,       9936.5219,       8909.9925,       7883.4220, &
       7062.1982,       6436.2637,       5805.3211,       5169.6110,       4533.9010, &
       3898.2009,       3257.0809,       2609.2006,       1961.3106,       1313.4804, &
       659.37527,       4.8048257,       0.0000000 / 

      data b72 / &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,   8.1754130e-09,    0.0069600246,     0.028010041,     0.063720063, &
      0.11360208,      0.15622409,      0.20035011,      0.24674112,      0.29440312, &
      0.34338113,      0.39289115,      0.44374018,      0.49459020,      0.54630418, &
      0.58104151,      0.61581843,      0.65063492,      0.68589990,      0.72116594, &
      0.74937819,      0.77063753,      0.79194696,      0.81330397,      0.83466097, &
      0.85601798,      0.87742898,      0.89890800,      0.92038701,      0.94186501, &
      0.96340602,      0.98495195,       1.0000000 / 
#endif

! 72-Level (as of 3/28/2007) Thin Layer Values
! --------------------------------------------
#if 0
      data a72 / &
       1.0000000,       2.0000002,       3.2700005,       4.7585009,       6.6000011, &
       8.9345014,       11.970302,       15.949503,       21.134903,       27.852606, &
       36.504108,       47.580610,       61.677911,       79.513413,       101.94402, &
       130.05102,       165.07903,       208.49704,       262.02105,       327.64307, &
       407.65710,       504.68010,       621.68012,       761.98417,       929.29420, &
       1127.6902,       1364.3402,       1645.7103,       1979.1604,       2373.0405, &
       2836.7806,       3381.0007,       4017.5409,       4764.3911,       5638.7912, &
       6660.3412,       7851.2316,       9236.5722,       10866.302,       12783.703, &
       15039.303,       17693.0,  20172.2,  21733.4,  22432.1,  22390.9,  21806.1,  21020.7,    &
       20020.2,  18903.0,  17708.5,  16469.8,  15196.1,  13955.8,  12715.6,  11513.2,  10378.1, &
       9286.23,  8250.31,  7287.11,  6379.95,  5522.36,  4715.73,  3957.50,  3236.60,  2549.27, &
       1904.52,  1307.47,  761.539,  282.945,  3.90625,  1.61719,  0.00000 /

      data b72 / &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
       0.0000000,     8.17541e-09,      0.00767142,       0.0302422,       0.0681799, &
       0.112411 ,       0.160985 ,       0.210491,        0.261081,        0.311757,  &
       0.362072, 0.411599,  0.460114, 0.506786, 0.551798, &
       0.594652, 0.634973,  0.672975, 0.708562, 0.741651, 0.772540, 0.801453, 0.828552, &
       0.854026, 0.878108,  0.900895, 0.922270, 0.942063, 0.960042, 0.975797, 0.987755, &
       0.994941, 1.000000 /
#endif

! 91-Level from ECMWF (7/8/08)
! ----------------------------
      data a91 /        &
             1.000000,  & 
             2.000040,  &
             3.980832,  &
             7.387186,  &
            12.908319,  &
            21.413612,  &
            33.952858,  &
            51.746601,  &
            76.167656,  &
           108.715561,  &
           150.986023,  &
           204.637451,  &
           271.356506,  &
           352.824493,  &
           450.685791,  &
           566.519226,  &
           701.813354,  &
           857.945801,  &
          1036.166504,  &
          1237.585449,  &
          1463.163940,  &
          1713.709595,  &
          1989.874390,  &
          2292.155518,  &
          2620.898438,  &
          2976.302246,  &
          3358.425781,  &
          3767.196045,  &
          4202.416504,  &
          4663.776367,  &
          5150.859863,  &
          5663.156250,  &
          6199.839355,  &
          6759.727051,  &
          7341.469727,  &
          7942.926270,  &
          8564.624023,  &
          9208.305664,  &
          9873.560547,  &
         10558.881836,  &
         11262.484375,  &
         11982.662109,  &
         12713.897461,  &
         13453.225586,  &
         14192.009766,  &
         14922.685547,  &
         15638.053711,  &
         16329.560547,  &
         16990.623047,  &
         17613.281250,  &
         18191.029297,  &
         18716.968750,  &
         19184.544922,  &
         19587.513672,  &
         19919.796875,  &
         20175.394531,  &
         20348.916016,  &
         20434.158203,  &
         20426.218750,  &
         20319.011719,  &
         20107.031250,  &
         19785.357422,  &
         19348.775391,  &
         18798.822266,  &
         18141.296875,  &
         17385.595703,  &
         16544.585938,  &
         15633.566406,  &
         14665.645508,  &
         13653.219727,  &
         12608.383789,  &
         11543.166992,  &
         10471.310547,  &
          9405.222656,  &
          8356.252930,  &
          7335.164551,  &
          6353.920898,  &
          5422.802734,  &
          4550.215820,  &
          3743.464355,  &
          3010.146973,  &
          2356.202637,  &
          1784.854614,  &
          1297.656128,  &
           895.193542,  &
           576.314148,  &
           336.772369,  &
           162.043427,  &
            54.208336,  &
             6.575628,  &
             0.003160,  &
             0.000000   /

      data b91 /        &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000000,  &
             0.000014,  &
             0.000055,  &
             0.000131,  &
             0.000279,  &
             0.000548,  &
             0.001000,  &
             0.001701,  &
             0.002765,  &
             0.004267,  &
             0.006322,  &
             0.009035,  &
             0.012508,  &
             0.016860,  &
             0.022189,  &
             0.028610,  &
             0.036227,  &
             0.045146,  &
             0.055474,  &
             0.067316,  &
             0.080777,  &
             0.095964,  &
             0.112979,  &
             0.131935,  &
             0.152934,  &
             0.176091,  &
             0.201520,  &
             0.229315,  &
             0.259554,  &
             0.291993,  &
             0.326329,  &
             0.362203,  &
             0.399205,  &
             0.436906,  &
             0.475016,  &
             0.513280,  &
             0.551458,  &
             0.589317,  &
             0.626559,  &
             0.662934,  &
             0.698224,  &
             0.732224,  &
             0.764679,  &
             0.795385,  &
             0.824185,  &
             0.850950,  &
             0.875518,  &
             0.897767,  &
             0.917651,  &
             0.935157,  &
             0.950274,  &
             0.963007,  &
             0.973466,  &
             0.982238,  &
             0.989153,  &
             0.994204,  &
             0.997630,  &
             1.000000   /

! ECMWF 91-Levels reduced to 44
! -----------------------------
      data a44 / 2.000040 ,     12.90832 ,     33.95286 ,     76.16766 ,     150.9860   ,      &
                 271.3565 ,     450.6858 ,     701.8134 ,     1036.167 ,     1463.164   ,      &
                 1989.874 ,     2620.898 ,     3358.426 ,     4202.417 ,     5150.860   ,      &
                 6199.839 ,     7341.470 ,     8564.624 ,     9873.561 ,     11262.48   ,      &
                 12713.90 ,     14192.01 ,     15638.05 ,     16990.62 ,     18191.03   ,      &
                 19184.54 ,     19919.80 ,     20348.92 ,     20426.22 ,     20107.03   ,      &
                 19348.78 ,     18141.30 ,     16544.59 ,     14665.65 ,     12608.38   ,      &
                 10471.31 ,     8356.253 ,     6353.921 ,     4550.216 ,     3010.147   ,      &
                 1784.855 ,     895.1935 ,     336.7724 ,     54.20834 ,     0.0000000E+00 /
 
      data b44 / 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 5.5000000E-05, 2.7900000E-04, 1.0000000E-03 ,   &
                 2.7650001E-03, 6.3220002E-03, 1.2508000E-02, 2.2189001E-02, 3.6226999E-02 ,   &
                 5.5473998E-02, 8.0776997E-02, 0.1129790    , 0.1529340    , 0.2015200     ,   &
                 0.2595540    , 0.3263290    , 0.3992050    , 0.4750160    , 0.5514580     ,   &
                 0.6265590    , 0.6982240    , 0.7646790    , 0.8241850    , 0.8755180     ,   &
                 0.9176510    , 0.9502740    , 0.9734660    , 0.9891530    , 1.000000      /


! ECMWF 137-Levels
! --------------
       data a137 &
         /1.000000, 2.000365, 3.102241, 4.666084, 6.827977, 9.746966, 13.605424, 18.608931, 24.985718, 32.985710,  &
          42.879242, 54.955463, 69.520576, 86.895882, 107.415741, 131.425507, 159.279404, 191.338562, 227.968948, 269.539581,  &
          316.420746, 368.982361, 427.592499, 492.616028, 564.413452, 643.339905, 729.744141, 823.967834, 926.344910, 1037.20117,  &
          1156.853638, 1285.610352, 1423.770142, 1571.622925, 1729.448975, 1897.519287, 2076.095947, 2265.431641, 2465.770508, 2677.348145,  &
          2900.391357, 3135.119385, 3381.743652, 3640.468262, 3911.490479, 4194.930664, 4490.817383, 4799.149414, 5119.895020, 5452.990723,  &
          5798.344727, 6156.074219, 6526.946777, 6911.870605, 7311.869141, 7727.412109, 8159.354004, 8608.525391, 9076.400391, 9562.682617,  &
          10065.978516, 10584.631836, 11116.662109, 11660.067383, 12211.547852, 12766.873047, 13324.668945, 13881.331055, 14432.139648, 14975.615234,  &
          15508.256836, 16026.115234, 16527.322266, 17008.789062, 17467.613281, 17901.621094, 18308.433594, 18685.718750, 19031.289062, 19343.511719,  &
          19620.042969, 19859.390625, 20059.931641, 20219.664062, 20337.863281, 20412.308594, 20442.078125, 20425.718750, 20361.816406, 20249.511719,  &
          20087.085938, 19874.025391, 19608.572266, 19290.226562, 18917.460938, 18489.707031, 18006.925781, 17471.839844, 16888.687500, 16262.046875,  &
          15596.695312, 14898.453125, 14173.324219, 13427.769531, 12668.257812, 11901.339844, 11133.304688, 10370.175781, 9617.515625, 8880.453125,  &
          8163.375000, 7470.343750, 6804.421875, 6168.531250, 5564.382812, 4993.796875, 4457.375000, 3955.960938, 3489.234375, 3057.265625,  &
          2659.140625, 2294.242188, 1961.500000, 1659.476562, 1387.546875, 1143.250000, 926.507812, 734.992188, 568.062500, 424.414062,  &
          302.476562, 202.484375, 122.101562, 62.781250, 22.835938, 3.757813, 0.000000, 0.000000/

       data b137 &
         /0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000007, 0.000024, 0.000059, 0.000112, 0.000199,  &
          0.000340, 0.000562, 0.000890, 0.001353, 0.001992, 0.002857, 0.003971, 0.005378, 0.007133, 0.009261,  &
          0.011806, 0.014816, 0.018318, 0.022355, 0.026964, 0.032176, 0.038026, 0.044548, 0.051773, 0.059728,  &
          0.068448, 0.077958, 0.088286, 0.099462, 0.111505, 0.124448, 0.138313, 0.153125, 0.168910, 0.185689,  &
          0.203491, 0.222333, 0.242244, 0.263242, 0.285354, 0.308598, 0.332939, 0.358254, 0.384363, 0.411125,  &
          0.438391, 0.466003, 0.493800, 0.521619, 0.549301, 0.576692, 0.603648, 0.630036, 0.655736, 0.680643,  &
          0.704669, 0.727739, 0.749797, 0.770798, 0.790717, 0.809536, 0.827256, 0.843881, 0.859432, 0.873929,  &
          0.887408, 0.899900, 0.911448, 0.922096, 0.931881, 0.940860, 0.949064, 0.956550, 0.963352, 0.969513,  &
          0.975078, 0.980072, 0.984542, 0.988500, 0.991984, 0.995003, 0.997630, 1.000000/


      if( km.ne.137 .and. &
          km.ne.91  .and. &
          km.ne.72  .and. &
          km.ne.55  .and. &
          km.ne.42  .and. &
          km.ne.44  .and. &
          km.ne.32  .and. &
          km.ne.26  .and. &
          km.ne.20 ) then
          print *, km,' levels not supported'
          print *, 'Supported levels are: 137, 91,72,70,55,44,42,32,26,20'
          stop
      endif

      if( km.eq.137 ) then
          do k=1,km+1
            ak(k) = a137(k)
            bk(k) = b137(k)
          enddo
      endif

      if( km.eq.91 ) then
          do k=1,km+1
            ak(k) = a91(k)
            bk(k) = b91(k)
          enddo
      endif

      if( km.eq.72 ) then
          do k=1,km+1
            ak(k) = a72(k)
            bk(k) = b72(k)
          enddo
      endif

      if( km.eq.55 ) then
          do k=1,km+1
            ak(k) = a55(k)
            bk(k) = b55(k)
          enddo
      endif

      if( km.eq.44 ) then
          do k=1,km+1
            ak(k) = a44(k)
            bk(k) = b44(k)
          enddo
      endif

      if( km.eq.42 ) then
          do k=1,km+1
            ak(k) = a42(k)
            bk(k) = b42(k)
          enddo
      endif

      if( km.eq.32 ) then
          do k=1,km+1
            ak(k) = a32(k)
            bk(k) = b32(k)
          enddo
      endif

      if( km.eq.26 ) then
          do k=1,km+1
            ak(k) = a26(k)
            bk(k) = b26(k)
          enddo
      endif

      if( km.eq.20 ) then
          do k=1,km+1
            ak(k) = a20(k)
            bk(k) = b20(k)
          enddo
      endif

          ptop = ak(1)

      return
      end
