	INTEGER FUNCTION ISETPRM ( CPRMNM, IPVAL )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    ISETPRM
C   PRGMMR: ATOR             ORG: NP12       DATE: 2014-12-04
C
C ABSTRACT:  THIS FUNCTION SHOULD ONLY BE CALLED IF DYNAMIC MEMORY
C   ALLOCATION IS BEING USED.  IT SETS A SPECIFIED PARAMETER TO A
C   SPECIFIED VALUE FOR LATER USE IN DYNAMICALLY SIZING ONE OR MORE
C   INTERNAL ARRAYS.  THE LIST OF PARAMETERS THAT CAN BE DYNAMICALLY
C   SIZED IS GIVEN BELOW, AND A SEPARATE CALL TO THIS FUNCTION MUST
C   BE MADE FOR EACH SUCH PARAMETER THAT IS DESIRED TO BE CHANGED
C   FROM ITS DEFAULT VALUE.  IF THIS FUNCTION IS NOT CALLED FOR A
C   PARTICULAR PARAMETER, THE DEFAULT VALUE IS OBTAINED FROM THE
C   CORRESPONDING MODULE FILE FOR THAT PARAMETER.
C
C   NOTE THAT ALL CALLS TO THIS FUNCTION MUST BE MADE PRIOR TO THE
C   FIRST CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE OPENBF.
C
C PROGRAM HISTORY LOG:
C 2014-12-04  J. ATOR    -- ORIGINAL AUTHOR
C 2016-05-24  J. ATOR    -- ADD MXNRV, MXBTM, MXBTMSE, MXTCO
C 2017-04-03  J. ATOR    -- ADD MXTAMC
C 2017-05-22  J. ATOR    -- ADD MXRST
C 2017-10-17  J. ATOR    -- ADD MXMTBF
C
C USAGE:    ISETPRM ( CPRMNM, IPVAL )
C   INPUT ARGUMENT LIST:
C     CPRMNM   - CHARACTER*(*): PARAMETER TO BE CHANGED FROM ITS
C                DEFAULT VALUE:
C                  'MXMSGL' = MAXIMUM LENGTH (IN BYTES) OF A BUFR
C                             MESSAGE
C                  'MAXSS'  = MAXIMUM NUMBER OF DATA VALUES IN AN
C                             UNCOMPRESSED BUFR SUBSET
C                  'MXCDV'  = MAXIMUM NUMBER OF DATA VALUES THAT CAN BE
C                             WRITTEN INTO A COMPRESSED BUFR SUBSET
C                  'MXLCC'  = MAXIMUM LENGTH (IN BYTES) OF A CHARACTER
C                             STRING THAT CAN BE WRITTEN INTO A
C                             COMPRESSED BUFR SUBSET
C                  'MXCSB'  = MAXIMUM NUMBER OF SUBSETS THAT CAN BE
C                             WRITTEN INTO A COMPRESSED BUFR MESSAGE
C                  'NFILES' = MAXIMUM NUMBER OF BUFR FILES THAT CAN BE
C                             ACCESSED FOR READING OR WRITING AT ANY
C                             ONE TIME
C                  'MAXTBA' = MAXIMUM NUMBER OF ENTRIES IN INTERNAL BUFR
C                             TABLE A PER BUFR FILE
C                  'MAXTBB' = MAXIMUM NUMBER OF ENTRIES IN INTERNAL BUFR
C                             TABLE B PER BUFR FILE
C                  'MAXTBD' = MAXIMUM NUMBER OF ENTRIES IN INTERNAL BUFR
C                             TABLE D PER BUFR FILE
C                  'MAXMEM' = MAXIMUM NUMBER OF BYTES THAT CAN BE USED
C                             TO STORE BUFR MESSAGES IN INTERNAL MEMORY
C                  'MAXMSG' = MAXIMUM NUMBER OF BUFR MESSAGES THAT CAN
C                             BE STORED IN INTERNAL MEMORY
C                  'MXDXTS' = MAXIMUM NUMBER OF DICTIONARY TABLES THAT
C                             CAN BE STORED FOR USE WITH BUFR MESSAGES
C                             IN INTERNAL MEMORY
C                  'MXMTBB' = MAXIMUM NUMBER OF MASTER TABLE B ENTRIES
C                  'MXMTBD' = MAXIMUM NUMBER OF MASTER TABLE D ENTRIES
C                  'MXMTBF' = MAXIMUM NUMBER OF MASTER CODE/FLAG ENTRIES
C                  'MAXCD'  = MAXIMUM NUMBER OF CHILD DESCRIPTORS IN A
C                             TABLE D DESCRIPTOR SEQUENCE DEFINITION
C                  'MAXJL'  = MAXIMUM NUMBER OF ENTRIES IN THE INTERNAL
C                             JUMP/LINK TABLE
C                  'MXS01V' = MAXIMUM NUMBER OF DEFAULT SECTION 0 OR
C                             SECTION 1 VALUES THAT CAN BE OVERWRITTEN
C                             WITHIN AN OUTPUT BUFR MESSAGE
C                  'MXBTM'  = MAXIMUM NUMBER OF BITMAPS THAT CAN BE
C			      STORED INTERNALLY FOR A BUFR SUBSET
C                 'MXBTMSE' = MAXIMUM NUMBER OF ENTRIES THAT CAN BE
C			      SET WITHIN A BITMAP
C                  'MXTAMC' = MAXIMUM NUMBER OF TABLE A MNEMONICS IN THE
C                             INTERNAL JUMP/LINK TABLE WHICH CONTAIN AT
C                             LEAST ONE TABLE C OPERATOR WITH X>=21 IN
C                             THEIR SUBSET DEFINITION
C                  'MXTCO'  = MAXIMUM NUMBER OF TABLE C OPERATORS (WITH
C                             X>=21) IN THE SUBSET DEFINITION OF A
C                             TABLE A MNEMONIC
C                  'MXNRV'  = MAXIMUM NUMBER OF 2-03 REFERENCE VALUES
C			      IN THE INTERNAL JUMP/LINK TABLE
C                  'MXRST'  = MAXIMUM NUMBER OF LONG CHARACTER STRINGS
C			      THAT CAN BE READ FROM A COMPRESSED SUBSET
C      IPVAL   - INTEGER: VALUE ASSOCIATED WITH CPRMNM
C
C   OUTPUT ARGUMENT LIST:
C     ISETPRM  - INTEGER: RETURN CODE:
C                   0 = NORMAL RETURN
C                  -1 = UNKNOWN CPRNMN, OR DYNAMIC ALLOCATION NOT IN
C                       EFFECT FOR THIS BUILD
C
C REMARKS:
C    THIS ROUTINE CALLS:        ERRWRT
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	USE MODV_MAXSS
	USE MODV_NFILES
	USE MODV_MXMSGL
	USE MODV_MXDXTS
	USE MODV_MAXMSG
	USE MODV_MAXMEM
	USE MODV_MAXTBA
	USE MODV_MAXTBB
	USE MODV_MAXTBD
	USE MODV_MAXJL
	USE MODV_MXCDV
	USE MODV_MXLCC
	USE MODV_MXCSB
	USE MODV_MXMTBB
	USE MODV_MXMTBD
	USE MODV_MXMTBF
	USE MODV_MAXCD
	USE MODV_MXS01V
	USE MODV_MXBTM
	USE MODV_MXBTMSE
	USE MODV_MXTAMC
	USE MODV_MXTCO
	USE MODV_MXNRV
	USE MODV_MXRST

	INCLUDE	'bufrlib.prm'

	CHARACTER*(*)	CPRMNM
	CHARACTER*128	ERRSTR

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

#ifdef DYNAMIC_ALLOCATION
	ISETPRM = 0
	IF ( CPRMNM .EQ. 'MAXSS' ) THEN
	    MAXSS = IPVAL
	ELSE IF ( CPRMNM .EQ. 'NFILES' ) THEN
	    NFILES = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXMSGL' ) THEN
	    MXMSGL = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXDXTS' ) THEN
	    MXDXTS = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXMSG' ) THEN
	    MAXMSG = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXMEM' ) THEN
	    MAXMEM = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXTBA' ) THEN
	    MAXTBA = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXTBB' ) THEN
	    MAXTBB = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXTBD' ) THEN
	    MAXTBD = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXJL' ) THEN
	    MAXJL = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXCDV' ) THEN
	    MXCDV = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXLCC' ) THEN
	    MXLCC = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXCSB' ) THEN
	    MXCSB = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXMTBB' ) THEN
	    MXMTBB = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXMTBD' ) THEN
	    MXMTBD = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXMTBF' ) THEN
	    MXMTBF = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MAXCD' ) THEN
	    MAXCD = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXS01V' ) THEN
	    MXS01V = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXBTM' ) THEN
	    MXBTM = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXBTMSE' ) THEN
	    MXBTMSE = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXTAMC' ) THEN
	    MXTAMC = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXTCO' ) THEN
	    MXTCO = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXNRV' ) THEN
	    MXNRV = IPVAL
	ELSE IF ( CPRMNM .EQ. 'MXRST' ) THEN
	    MXRST = IPVAL
	ELSE
	    ISETPRM = -1
	    CALL ERRWRT('++++++++++++++++++WARNING+++++++++++++++++++')
	    ERRSTR = 'BUFRLIB: ISETPRM - UNKNOWN INPUT PARAMETER '//
     .		CPRMNM // ' -- NO ACTION WAS TAKEN'
	    CALL ERRWRT(ERRSTR)
	    CALL ERRWRT('++++++++++++++++++WARNING+++++++++++++++++++')
	ENDIF
#else
	ISETPRM = -1
	CALL ERRWRT('++++++++++++++++++++WARNING+++++++++++++++++++++')
	ERRSTR = 'BUFRLIB: ISETPRM - DYNAMIC MEMORY ALLOCATION IS '//
     .		'NOT SUPPORTED FOR THIS BUILD OF BUFRLIB'
	CALL ERRWRT(ERRSTR)
	CALL ERRWRT('++++++++++++++++++++WARNING+++++++++++++++++++++')
#endif

	RETURN
	END
