      SUBROUTINE PKVS01(S01MNEM,IVAL)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    PKVS01
C   PRGMMR: ATOR            ORG: NP12       DATE: 2005-11-29
C
C ABSTRACT:  THIS SUBROUTINE IS USED TO SPECIFY A VALUE TO BE WRITTEN
C   INTO A SPECIFIED LOCATION WITHIN SECTION 0 OR SECTION 1 OF ALL BUFR
C   MESSAGES THAT WILL BE OUTPUT BY FUTURE CALLS TO ANY OF THE BUFR
C   ARCHIVE LIBRARY SUBROUTINES WHICH CREATE SUCH MESSAGES (E.G. WRITCP,
C   WRITSB, COPYMG, WRITSA, ETC.).  IT WILL WORK ON ANY MESSAGE ENCODED
C   USING BUFR EDITION 2, 3 OR 4, AND IT CAN BE CALLED AT ANY TIME,
C   INCLUDING BEFORE THE FIRST CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE
C   OPENBF IF IT IS DESIRED FOR THE NEW VALUE TO ALSO BE INCLUDED IN ANY
C   DX DICTIONARY TABLE MESSAGES THAT WILL BE OUTPUT BY BUFR ARCHIVE
C   LIBRARY SUBROUTINE WRITDX.  IN ANY CASE, THE LOCATION WITHIN WHICH
C   TO STORE THE VALUE IS SPECIFIED VIA THE MNEMONIC S01MNEM, AS
C   EXPLAINED IN FURTHER DETAIL BELOW.  IF MULTIPLE VALUES ARE DESIRED
C   TO BE CHANGED WITHIN SECTION 0 OR SECTION 1 OF FUTURE OUTPUT
C   MESSAGES, THEN EACH SUCH VALUE (AND CORRESPONDING LOCATION)
C   SHOULD BE SPECIFIED USING A SEPARATE CALL TO THIS SUBROUTINE.
C   NOTE THAT EACH CALL TO THIS SUBROUTINE WITH A PARTICULAR LOCATION
C   SPECIFICATION WILL OVERRIDE THE EFFECT OF ANY PREVIOUS CALL WITH
C   THAT SAME SPECIFICATION (OR, IN THE CASE OF THE FIRST CALL WITH A
C   PARTICULAR LOCATION SPECIFICATION, IT WILL OVERRIDE THE DEFAULT
C   SECTION 0 OR SECTION 1 VALUE FOR THE CORRESPONDING LOCATION!).
C
C PROGRAM HISTORY LOG:
C 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
C 2006-04-14  D. KEYSER  -- UPDATED DOCBLOCK
C 2015-03-03  J. ATOR    -- USE MODULE MODA_S01CM
C
C USAGE:    CALL PKVS01(S01MNEM,IVAL)
C   INPUT ARGUMENT LIST:
C     S01MNEM  - CHARACTER*(*): MNEMONIC SPECIFYING LOCATION WHERE IVAL
C                IS TO BE STORED WITHIN SECTION 0 OR SECTION 1 OF ALL
C                FUTURE OUTPUT BUFR MESSAGES:
C                  'BEN'   = BUFR EDITION NUMBER
C                  'BMT'   = BUFR MASTER TABLE 
C                  'OGCE'  = ORIGINATING CENTER
C                  'GSES'  = ORIGINATING SUBCENTER
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 3 OR 4 MESSAGES!)
C                  'USN'   = UPDATE SEQUENCE NUMBER 
C                  'MTYP'  = DATA CATEGORY
C                  'MSBTI' = DATA SUBCATEGORY (INTERNATIONAL)
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 4 MESSAGES!)
C                  'MSBT'  = DATA SUBCATEGORY (LOCAL)
C                  'MTV'   = VERSION NUMBER OF MASTER TABLE
C                  'MTVL'  = VERSION NUMBER OF LOCAL TABLES
C                  'YCEN'  = YEAR OF CENTURY (1-100)
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 2 AND 3 MESSAGES!)
C                  'CENT'  = CENTURY (I.E., 20 FOR YEARS 1901-2000,
C                                           21 FOR YEARS 2001-2100)
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 2 AND 3 MESSAGES!)
C                  'YEAR'  = YEAR (4-DIGIT)
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 4 MESSAGES!)
C                  'MNTH'  = MONTH
C                  'DAYS'  = DAY
C                  'HOUR'  = HOUR
C                  'MINU'  = MINUTE
C                  'SECO'  = SECOND
C                              (NOTE: THIS VALUE WILL BE STORED ONLY IN
C                                     BUFR EDITION 4 MESSAGES!)
C     IVAL     - INTEGER: NEW VALUE FOR LOCATION POINTED TO BY S01MNEM
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     OPENBF
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      USE MODA_S01CM

      INCLUDE 'bufrlib.prm'

      CHARACTER*(*) S01MNEM

      CHARACTER*128 BORT_STR

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

#ifdef DYNAMIC_ALLOCATION

C     CONFIRM THAT THE ARRAYS NEEDED BY THIS SUBROUTINE HAVE ALREADY
C     BEEN ALLOCATED (AND IF NOT, GO AHEAD AND ALLOCATE THEM NOW), SINCE
C     IT'S POSSIBLE FOR THIS SUBROUTINE TO BE CALLED BEFORE THE FIRST
C     CALL TO SUBROUTINE OPENBF.

      IF ( ( .NOT. ALLOCATED(CMNEM) ) .OR.
     .     ( .NOT. ALLOCATED(IVMNEM) ) )  THEN
        CALL OPENBF(0,'FIRST',0)
      ENDIF
#endif

C     IF AN IVAL HAS ALREADY BEEN ASSIGNED FOR THIS PARTICULAR S01MNEM,
C     THEN OVERWRITE THAT ENTRY IN COMMON /S01CM/ USING THE NEW IVAL.

      IF(NS01V.GT.0) THEN
        DO I=1,NS01V
          IF(S01MNEM.EQ.CMNEM(I)) THEN
            IVMNEM(I) = IVAL
            RETURN
          ENDIF
        ENDDO
      ENDIF

C     OTHERWISE, USE THE NEXT AVAILABLE UNUSED ENTRY IN COMMON /S01CM/.

      IF(NS01V.GE.MXS01V) GOTO 900

      NS01V = NS01V + 1
      CMNEM(NS01V) = S01MNEM
      IVMNEM(NS01V) = IVAL

C  EXITS
C  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PKVS01 - CANNOT OVERWRITE MORE THAN '//
     . '",I2," DIFFERENT LOCATIONS WITHIN SECTION 0 OR SECTION 1")')
     . MXS01V
      CALL BORT(BORT_STR)
      END
