	SUBROUTINE GETTAGPR ( LUNIT, TAGCH, NTAGCH, TAGPR, IRET )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    GETTAGPR
C   PRGMMR: J. ATOR          ORG: NP12       DATE: 2012-09-12
C
C ABSTRACT:  GIVEN A MNEMONIC CORRESPONDING TO A CHILD DESCRIPTOR
C   WITHIN A PARENT SEQUENCE, THIS SUBROUTINE RETURNS THE MNEMONIC
C   CORRESPONDING TO THE PARENT SEQUENCE.  A SUBSET DEFINITION MUST
C   ALREADY BE IN SCOPE, EITHER VIA A PREVIOUS CALL TO BUFR ARCHIVE
C   LIBRARY SUBROUTINE READSB OR EQUIVALENT (FOR INPUT FILES) OR TO
C   SUBROUTINE OPENMB OR EQUIVALENT (FOR OUTPUT FILES).  IF THERE IS
C   MORE THAN ONE OCCURRENCE OF THE CHILD DESCRIPTOR WITHIN THE
C   OVERALL SUBSET DEFINITION, THIS SUBROUTINE WILL RETURN THE PARENT
C   MNEMONIC CORRESPONDING TO THE (NTAGCH)th OCCURRENCE OF THE CHILD,
C   COUNTING FROM THE BEGINNING OF THE OVERALL SUBSET DEFINITION.
C
C PROGRAM HISTORY LOG:
C 2012-09-12  J. ATOR    -- ORIGINAL AUTHOR
C 2014-10-02  J. ATOR    -- MODIFIED TO USE FSTAG
C 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C
C USAGE:    CALL GETTAGPR (LUNIT, TAGCH, NTAGCH, TAGPR, IRET)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C     TAGCH    - CHARACTER*(*): MNEMONIC CORRESPONDING TO CHILD
C                DESCRIPTOR
C     NTAGCH   - INTEGER: ORDINAL OCCURRENCE OF TAGCH FOR WHICH
C                TAGPR IS TO BE RETURNED, COUNTING FROM THE
C                BEGINNING OF THE OVERALL SUBSET DEFINITION
C
C   OUTPUT ARGUMENT LIST:
C     TAGPR    - CHARACTER*(*): MNEMONIC CORRESPONDING TO PARENT
C                SEQUENCE DESCRIPTOR
C     IRET     - INTEGER: RETURN CODE
C                   0 = NORMAL RETURN
C                  -1 = PARENT MNEMONIC COULD NOT BE FOUND, OR SOME
C                       OTHER ERROR OCCURRED
C
C REMARKS:
C    THIS ROUTINE CALLS:        FSTAG    STATUS
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	USE MODA_USRINT
	USE MODA_MSGCWD
	USE MODA_TABLES

	INCLUDE 'bufrlib.prm'

	CHARACTER*(*) TAGCH, TAGPR

C----------------------------------------------------------------------
C----------------------------------------------------------------------

	IRET = -1

C	Get LUN from LUNIT.

	CALL STATUS( LUNIT, LUN, IL, IM )
	IF ( IL .EQ. 0 ) RETURN
	IF ( INODE(LUN) .NE. INV(1,LUN) ) RETURN

C	Get TAGPR from the (NTAGCH)th occurrence of TAGCH.

	CALL FSTAG( LUN, TAGCH, NTAGCH, 1, NCH, IRET )
	IF ( IRET .NE. 0 ) RETURN

	TAGPR = TAG(JMPB(INV(NCH,LUN)))

	RETURN
	END
