      SUBROUTINE CODFLG(CF)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    CODFLG
C   PRGMMR: ATOR            ORG: NP12       DATE: 2017-10-13
C
C ABSTRACT: THIS SUBROUTINE IS USED TO SPECIFY WHETHER OR NOT CODE
C   AND FLAG TABLE INFORMATION SHOULD BE INCLUDED WHEN READING IN
C   BUFR MASTER TABLE INFORMATION DURING ALL FUTURE INTERNAL CALLS
C   TO BUFR ARCHIVE LIBRARY FUNCTION IREADMT.  THIS SUBROUTINE CAN BE
C   CALLED AT ANY TIME AFTER THE FIRST CALL TO BUFR ARCHIVE LIBRARY
C   SUBROUTINE OPENBF, AND THE POSSIBLE VALUES FOR CF ARE 'N' (= 'NO',
C   WHICH IS THE DEFAULT) AND 'Y' (= 'YES').
C
C PROGRAM HISTORY LOG:
C 2017-10-13  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    CALL CODFLG (CF)
C   INPUT ARGUMENT LIST:
C     CF       - CHARACTER*1: FLAG INDICATING WHETHER CODE AND FLAG 
C                TABLE INFORMATION SHOULD BE INCLUDED WHEN READING IN
C                BUFR MASTER TABLE INFORMATION DURING FUTURE INTERNAL
C                CALLS TO FUNCTION IREADMT:
C                       'N' = 'NO' (THE DEFAULT)
C                       'Y' = 'YES'
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     CAPIT
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /TABLEF/ CDMF

      CHARACTER*128 BORT_STR
      CHARACTER*1   CDMF, CF

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      CALL CAPIT(CF)
      IF(CF.NE.'Y'.AND. CF.NE.'N') GOTO 900
      CDMF = CF 

C  EXITS
C  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: CODFLG - INPUT ARGUMENT IS ",A1,'//
     . '", IT MUST BE EITHER Y OR N")') CF
      CALL BORT(BORT_STR)
      END
