	REAL*8 FUNCTION GETVALNB ( LUNIT, TAGPV, NTAGPV, TAGNB, NTAGNB )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    GETVALNB
C   PRGMMR: J. ATOR          ORG: NP12       DATE: 2012-09-12
C
C ABSTRACT:  THIS FUNCTION SHOULD ONLY BE CALLED WHEN A BUFR FILE IS
C   OPENED FOR INPUT, AND A SUBSET DEFINITION MUST ALREADY BE IN SCOPE
C   VIA A PREVIOUS CALL TO BUFR ARCHIVE LIBRARY SUBROUTINE READSB OR
C   EQUIVALENT.  THE FUNCTION WILL FIRST SEARCH FOR THE (NTAGPV)th
C   OCCURRENCE OF MNEMONIC TAGPV WITHIN THE OVERALL SUBSET DEFINITION,
C   COUNTING FROM THE BEGINNING OF THE SUBSET.  IF FOUND, IT WILL THEN
C   SEARCH FORWARD (IF NTAGNB IS POSITIVE) OR BACKWARD (IF NTAGNB IS
C   NEGATIVE) FROM THAT POINT WITHIN THE SUBSET FOR THE (NTAGNB)th
C   OCCURRENCE OF MNEMONIC TAGNB AND RETURN THE VALUE CORRESPONDING
C   TO THAT MNEMONIC. 
C
C PROGRAM HISTORY LOG:
C 2012-09-12  J. ATOR    -- ORIGINAL AUTHOR
C 2014-10-02  J. ATOR    -- MODIFIED TO USE FSTAG
C 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C
C USAGE:    CALL GETVALNB (LUNIT, TAGPV, NTAGPV, TAGNB, NTAGNB)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C     TAGPV    - CHARACTER*(*): PIVOT MNEMONIC; THE FUNCTION WILL
C                FIRST SEARCH FOR the (NTAGPV)th OCCURRENCE OF THIS
C                MNEMONIC, COUNTING FROM THE BEGINNING OF THE OVERALL
C                SUBSET DEFINITION
C     NTAGPV   - INTEGER: ORDINAL OCCURRENCE OF TAGPV TO SEARCH FOR
C     TAGNB    - CHARACTER*(*): NEARBY MNEMONIC; ASSUMING TAGPV IS
C                SUCCESSFULLY FOUND, THE FUNCTION WILL THEN SEARCH
C                NEARBY FOR THE (NTAGNB)th OCCURRENCE OF TAGNB AND
C                RETURN THE CORRESPONDING VALUE
C     NTAGNB   - INTEGER: ORDINAL OCCURRENCE OF TAGNB TO SEARCH FOR,
C                COUNTING FROM THE LOCATION OF TAGPV WITHIN THE OVERALL
C                SUBSET DEFINITION.  IF NTAGNB IS POSITIVE, THE FUNCTION
C                WILL SEARCH IN A FORWARD DIRECTION FROM THE LOCATION OF
C                TAGPV, OR IF NTAGNB IS NEGATIVE IT WILL INSTEAD SEARCH
C                IN A BACKWARDS DIRECTION.
C
C   OUTPUT ARGUMENT LIST:
C     GETVALNB - REAL*8: VALUE CORRESPONDING TO (NTAGNB)th OCCURRENCE
C                OF TAGNB.  IF FOR ANY REASON THIS VALUE CANNOT BE
C                LOCATED, THEN THE BUFR ARCHIVE LIBRARY MISSING VALUE
C                BMISS WILL BE RETURNED.
C
C REMARKS:
C    THIS ROUTINE CALLS:        FSTAG    STATUS
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	USE MODA_USRINT
	USE MODA_MSGCWD
	USE MODA_TABLES

	INCLUDE 'bufrlib.prm'

	CHARACTER*(*) TAGPV, TAGNB

C----------------------------------------------------------------------
C----------------------------------------------------------------------

	GETVALNB = BMISS

C	Get LUN from LUNIT.

	CALL STATUS (LUNIT, LUN, IL, IM )
	IF ( IL .GE. 0 ) RETURN
	IF ( INODE(LUN) .NE. INV(1,LUN) ) RETURN

C	Starting from the beginning of the subset, locate the (NTAGPV)th
C	occurrence of TAGPV.

	CALL FSTAG( LUN, TAGPV, NTAGPV, 1, NPV, IRET )
	IF ( IRET .NE. 0 ) RETURN

C	Now, starting from the (NTAGPV)th occurrence of TAGPV, search
C	forward or backward for the (NTAGNB)th occurrence of TAGNB.

	CALL FSTAG( LUN, TAGNB, NTAGNB, NPV, NNB, IRET )
	IF ( IRET .NE. 0 ) RETURN

	GETVALNB = VAL(NNB,LUN)
	    
	RETURN
	END
