      FUNCTION IUPVS01(LUNIT,S01MNEM)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    IUPVS01
C   PRGMMR: ATOR             ORG: NP12       DATE: 2005-11-29
C
C ABSTRACT: THIS FUNCTION UNPACKS AND RETURNS A SPECIFIED INTEGER VALUE
C   FROM SECTION 0 OR SECTION 1 OF THE LAST BUFR MESSAGE THAT WAS READ
C   FROM LOGICAL UNIT NUMBER LUNIT VIA BUFR ARCHIVE LIBRARY SUBROUTINE
C   READMG, READERME OR EQUIVALENT.  IT WILL WORK ON ANY MESSAGE ENCODED
C   USING BUFR EDITION 2, 3 OR 4, AND THE VALUE TO BE UNPACKED IS
C   SPECIFIED VIA THE MNEMONIC S01MNEM (SEE THE DOCBLOCK OF BUFR ARCHIVE
C   LIBRARY FUNCTION IUPBS01 FOR A LISTING OF POSSIBLE VALUES FOR
C   S01MNEM).  NOTE THAT THIS FUNCTION IS SIMILAR TO BUFR ARCHIVE
C   LIBRARY FUNCTION IUPBS01 EXCEPT THAT IT OPERATES ON A BUFR MESSAGE
C   THAT HAS ALREADY BEEN READ INTO THE INTERNAL BUFR ARCHIVE LIBRARY
C   ARRAYS (VIA A PREVIOUS CALL TO READMG, READERME, ETC.) RATHER THAN
C   ON A BUFR MESSAGE PASSED DIRECTLY INTO THE FUNCTION VIA A MEMORY
C   ARRAY.
C
C PROGRAM HISTORY LOG:
C 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
C 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C
C USAGE:    IUPVS01 (LUNIT, S01MNEM)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C     S01MNEM  - CHARACTER*(*): MNEMONIC SPECIFYING VALUE TO BE
C                UNPACKED FROM SECTION 0 OR SECTION 1 OF BUFR MESSAGE
C                  (SEE DOCBLOCK OF FUNCTION IUPBS01 FOR LISTING OF
C                  POSSIBLE VALUES)
C
C   OUTPUT ARGUMENT LIST:
C     IUPVS01   - INTEGER: UNPACKED INTEGER VALUE
C                  -1 = THE INPUT S01MNEM MNEMONIC WAS INVALID
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     IUPBS01  STATUS
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      USE MODA_BITBUF

      INCLUDE 'bufrlib.prm'

      CHARACTER*(*)   S01MNEM

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  CHECK THE FILE STATUS
C  ---------------------

      CALL STATUS(LUNIT,LUN,ILST,IMST)
      IF(ILST.EQ.0) GOTO 900
      IF(ILST.GT.0) GOTO 901
      IF(IMST.EQ.0) GOTO 902

C  UNPACK THE REQUESTED VALUE
C  --------------------------

      IUPVS01 = IUPBS01(MBAY(1,LUN),S01MNEM)

C  EXITS
C  -----

      RETURN
900   CALL BORT('BUFRLIB: IUPVS01 - INPUT BUFR FILE IS CLOSED, IT '//
     . 'MUST BE OPEN FOR INPUT')
901   CALL BORT('BUFRLIB: IUPVS01 - INPUT BUFR FILE IS OPEN FOR '//
     . 'OUTPUT, IT MUST BE OPEN FOR INPUT')
902   CALL BORT('BUFRLIB: IUPVS01 - A MESSAGE MUST BE OPEN IN INPUT '//
     . 'BUFR FILE, NONE ARE')
      END
