	SUBROUTINE RDMTBB ( LUNSTB, LUNLTB, MXMTBB,
     .			    IMT, IMTV, IOGCE, ILTV,
     .			    NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
     .			    CMUNIT, CMMNEM, CMDSC, CMELEM )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    RDMTBB
C   PRGMMR: ATOR            ORG: NP12       DATE: 2007-01-19
C
C ABSTRACT:  THIS SUBROUTINE READS MASTER TABLE B INFORMATION FROM TWO
C   SEPARATE (I.E. ONE STANDARD AND ONE LOCAL) ASCII FILES AND THEN
C   MERGES IT INTO A UNIFIED SET OF MASTER TABLE B ARRAYS FOR OUTPUT.
C   EACH OF THE TWO INPUT FILES MUST ALREADY BE INDIVIDUALLY SORTED IN
C   ASCENDING ORDER WITH RESPECT TO THE FXY NUMBERS.
C
C PROGRAM HISTORY LOG:
C 2007-01-19  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    CALL RDMTBB ( LUNSTB, LUNLTB, MXMTBB, IMT, IMTV, IOGCE,
C                         ILTV, NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
C                         CMUNIT, CMMNEM, CMDSC, CMELEM )
C   INPUT ARGUMENT LIST:
C     LUNSTB   - INTEGER: FORTRAN LOGICAL UNIT NUMBER OF ASCII FILE
C                CONTAINING STANDARD TABLE B INFORMATION
C     LUNLTB   - INTEGER: FORTRAN LOGICAL UNIT NUMBER OF ASCII FILE
C                CONTAINING LOCAL TABLE B INFORMATION
C     MXMTBB   - INTEGER: MAXIMUM NUMBER OF ENTRIES TO BE STORED IN
C                MERGED MASTER TABLE B ARRAYS; THIS SHOULD BE THE SAME
C                NUMBER AS WAS USED TO DIMENSION THE OUTPUT ARRAYS IN
C                THE CALLING PROGRAM, AND IT IS USED BY THIS SUBROUTINE
C                TO ENSURE THAT IT DOESN'T OVERFLOW THESE ARRAYS
C
C   OUTPUT ARGUMENT LIST:
C     IMT      - INTEGER: MASTER TABLE, READ FROM EACH ASCII FILE
C                (NOTE: THESE VALUES MUST BE THE SAME IN EACH FILE!)
C     IMTV     - INTEGER: VERSION NUMBER OF MASTER TABLE, READ FROM
C                STANDARD ASCII FILE
C     IOGCE    - INTEGER: ORIGINATING CENTER, READ FROM LOCAL ASCII FILE
C     ILTV     - INTEGER: VERSION NUMBER OF LOCAL TABLE, READ FROM
C                LOCAL ASCII FILE
C     NMTBB    - INTEGER: NUMBER OF ENTRIES IN MERGED MASTER TABLE B
C                ARRAYS
C     IMFXYN(*)- INTEGER: MERGED ARRAY CONTAINING BIT-WISE
C                REPRESENTATIONS OF FXY NUMBERS
C     CMSCL(*) - CHARACTER*4: MERGED ARRAY CONTAINING SCALE FACTORS
C     CMSREF(*)- CHARACTER*12: MERGED ARRAY CONTAINING REFERENCE VALUES
C     CMBW(*)  - CHARACTER*4: MERGED ARRAY CONTAINING BIT WIDTHS
C     CMUNIT(*)- CHARACTER*14: MERGED ARRAY CONTAINING UNITS
C     CMMNEM(*)- CHARACTER*8: MERGED ARRAY CONTAINING MNEMONICS
C     CMDSC(*) - CHARACTER*4: MERGED ARRAY CONTAINING DESCRIPTOR CODES 
C     CMELEM(*)- CHARACTER*120: MERGED ARRAY CONTAINING ELEMENT NAMES 
C
C REMARKS:
C    THIS ROUTINE CALLS:        ADN30    BORT     GETNTBE  GETTBH
C                               SNTBBE   WRDLEN
C    THIS ROUTINE IS CALLED BY: IREADMT
C                               Not normally called by any application
C                               programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	CHARACTER*200	STLINE, LTLINE
	CHARACTER*128	BORT_STR
	CHARACTER*120	CMELEM(*)
	CHARACTER*14	CMUNIT(*)
	CHARACTER*12	CMSREF(*)
	CHARACTER*8	CMMNEM(*)
	CHARACTER*6	CMATCH, ADN30
	CHARACTER*4	CMSCL(*), CMBW(*), CMDSC(*)

	INTEGER		IMFXYN(*)

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C	Call WRDLEN to initialize some important information about the
C	local machine, just in case it hasn't already been called.

	CALL WRDLEN

C	Read and parse the header lines of both files.

	CALL GETTBH ( LUNSTB, LUNLTB, 'B', IMT, IMTV, IOGCE, ILTV )
	
C	Read through the remainder of both files, merging the
C	contents into a unified set of master Table B arrays.

	NMTBB = 0
	CALL GETNTBE ( LUNSTB, ISFXYN, STLINE, IERS )
	CALL GETNTBE ( LUNLTB, ILFXYN, LTLINE, IERL )
	DO WHILE ( ( IERS .EQ. 0 ) .OR. ( IERL .EQ. 0 ) )
	  IF ( ( IERS .EQ. 0 ) .AND. ( IERL .EQ. 0 ) ) THEN
	    IF ( ISFXYN .EQ. ILFXYN ) THEN
	      CMATCH = ADN30 ( ISFXYN, 6 )
	      GOTO 900
	    ELSE IF ( ISFXYN .LT. ILFXYN ) THEN
	      CALL SNTBBE ( ISFXYN, STLINE, MXMTBB,
     .			    NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
     .			    CMUNIT, CMMNEM, CMDSC, CMELEM )
	      CALL GETNTBE ( LUNSTB, ISFXYN, STLINE, IERS )
	    ELSE
	      CALL SNTBBE ( ILFXYN, LTLINE, MXMTBB,
     .			    NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
     .			    CMUNIT, CMMNEM, CMDSC, CMELEM )
	      CALL GETNTBE ( LUNLTB, ILFXYN, LTLINE, IERL )
	    ENDIF
	  ELSE IF ( IERS .EQ. 0 ) THEN
	    CALL SNTBBE ( ISFXYN, STLINE, MXMTBB,
     .			  NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
     .			  CMUNIT, CMMNEM, CMDSC, CMELEM )
	    CALL GETNTBE ( LUNSTB, ISFXYN, STLINE, IERS )
	  ELSE IF ( IERL .EQ. 0 ) THEN
	    CALL SNTBBE ( ILFXYN, LTLINE, MXMTBB,
     .			  NMTBB, IMFXYN, CMSCL, CMSREF, CMBW,
     .			  CMUNIT, CMMNEM, CMDSC, CMELEM )
	    CALL GETNTBE ( LUNLTB, ILFXYN, LTLINE, IERL )
	  ENDIF
	ENDDO

	RETURN
 900	WRITE(BORT_STR,'("BUFRLIB: RDMTBB - STANDARD AND LOCAL'//
     . ' TABLE B FILES BOTH CONTAIN SAME FXY NUMBER: ",5A)')
     .	 CMATCH(1:1), '-', CMATCH(2:3), '-', CMATCH(4:6)	
	CALL BORT(BORT_STR)
	END
