      SUBROUTINE UFBMNS(IREP,SUBSET,IDATE)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    UFBMNS
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE READS A PARTICULAR SUBSET INTO INTERNAL
C   SUBSET ARRAYS FROM A COLLECTION OF BUFR MESSAGES IN INTERNAL MEMORY
C   BASED ON THE SUBSET NUMBER RELATIVE TO THE TOTAL NUMBER OF SUBSETS
C   IN THE COLLECTION.  THE SUBROUTINE DOES NOT RETURN ANY INFORMATION
C   ABOUT WHICH MESSAGE NUMBER CONTAINED THE DESIRED SUBSET.  IF THE
C   REQUESTED SUBSET IS LARGER THAN THE TOTAL NUMBER OF SUBSETS IN
C   MEMORY, THEN AN APPROPRIATE CALL IS MADE TO BUFR ARCHIVE LIBRARY
C   SUBROUTINE BORT.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 1999-11-18  J. WOOLLEN -- THE MAXIMUM NUMBER OF BYTES REQUIRED TO
C                           STORE ALL MESSAGES INTERNALLY WAS INCREASED 
C                           FROM 4 MBYTES TO 8 MBYTES
C 2001-08-15  D. KEYSER  -- PARAMETER MAXMEM (THE MAXIMUM NUMBER OF
C                           BYTES REQUIRED TO STORE ALL MESSAGES
C                           INTERNALLY) WAS INCREASED FROM 8 MBYTES TO
C                           16 MBYTES
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- PARAMETER MAXMSG (THE MAXIMUM NUMBER OF
C                           BUFR MESSAGES WHICH CAN BE STORED
C                           INTERNALLY) INCREASED FROM 50000 TO 200000;
C                           UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C 2004-11-15  D. KEYSER  -- PARAMETER MAXMEM (THE MAXIMUM NUMBER OF
C                           BYTES REQUIRED TO STORE ALL MESSAGES
C                           INTERNALLY) WAS INCREASED FROM 16 MBYTES TO
C                           50 MBYTES
C 2009-03-23  J. ATOR    -- USE IREADMM INSTEAD OF RDMEMM;
C                           SIMPLIFY LOGIC
C 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C
C USAGE:    CALL UFBMNS (IREP, SUBSET, IDATE)
C   INPUT ARGUMENT LIST:
C     IREP     - INTEGER: POINTER TO SUBSET NUMBER TO READ IN
C                COLLECTION OF MESSAGES
C
C   OUTPUT ARGUMENT LIST:
C     SUBSET   - CHARACTER*8: TABLE A MNEMONIC FOR BUFR MESSAGE
C                CONTAINING SUBSET
C     IDATE    - INTEGER: DATE-TIME FROM SECTION 1 OF BUFR MESSAGE
C                CONTAINING SUBSET, IN FORMAT OF EITHER YYMMDDHH OR
C                YYYYMMDDHH, DEPENDING ON DATELEN() VALUE
C
C REMARKS:
C    NOTE THAT UFBMEM IS CALLED PRIOR TO THIS TO STORE THE BUFR
C    MESSAGES INTO INTERNAL MEMORY.
C
C    THIS ROUTINE CALLS:        BORT     IREADMM  NMSUB    RDMEMS
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      USE MODA_MSGMEM

      INCLUDE 'bufrlib.prm'

      CHARACTER*128 BORT_STR
      CHARACTER*8   SUBSET

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      JREP = 0
      IMSG = 1

C  READ SUBSET #ISUB FROM MEMORY MESSAGE #IMSG
C  -------------------------------------------

      DO WHILE(IREADMM(IMSG,SUBSET,IDATE).EQ.0)
        IF(JREP+NMSUB(MUNIT).GE.IREP) THEN
           CALL RDMEMS(IREP-JREP,IRET)
           GOTO 100
        ENDIF
        JREP = JREP+NMSUB(MUNIT)
      ENDDO
      GOTO 900

C  EXITS
C  -----

100   RETURN
900   WRITE(BORT_STR,'("BUFRLIB: UFBMNS - REQ. SUBSET NO. TO READ IN '//
     . '(",I5,") EXCEEDS TOTAL NO. OF SUBSETS IN THE COLLECTION OF '//
     . 'MEMORY MESSAGES (",I5,")")') IREP,JREP
      CALL BORT(BORT_STR)
      END
