C> @file
C> @brief Check whether a BUFR message contains DX BUFR tables
C> information

C> This function determines whether a given BUFR message contains
C> DX BUFR tables information that was generated by the BUFRLIB
C> software.
C>
C> @author J. Ator
C> @date 2009-03-23
C>
C> @param[in] MESG     -- integer(*): BUFR message
C> @returns idxmsg     -- integer: Flag indicating whether MESG
C>                        contains DX BUFR tables information:
C>                          - 0 = No
C>                          - 1 = Yes
C>
C> <b>Program history log:</b>
C> | Date | Programmer | Comments |
C> | -----|------------|----------|
C> | 2009-03-23 | J. Ator | Original author |
C>
	FUNCTION IDXMSG( MESG )

	DIMENSION MESG(*)

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C	Note that the following test relies upon logic within subroutine
C	DXMINI which zeroes out the Section 1 date of all DX dictionary 
C	messages.

	IF ( (IUPBS01(MESG,'MTYP').EQ.11) .AND.
     .       (IUPBS01(MESG,'MNTH').EQ.0) .AND.
     .       (IUPBS01(MESG,'DAYS').EQ.0) .AND.
     .       (IUPBS01(MESG,'HOUR').EQ.0) ) THEN
	   IDXMSG = 1
	ELSE
	   IDXMSG = 0
	END IF

	RETURN
	END
