C> @file
C> @author WOOLLEN @date 1994-01-06
      
C> THIS SUBROUTINE FIRST PACKS THE VALUE FOR THE NUMBER OF
C>   BITS BEING "PADDED" (WE'LL GET TO THAT LATER), STARTING WITH BIT
C>   IBIT+1 AND USING EIGHT BITS IN THE PACKED ARRAY IBAY (WHICH
C>   REPRESENTS A SUBSET PACKED INTO IBIT BITS).  THEN, STARTING WITH
C>   IBIT+9, IT PACKS ZEROES (I.E., "PADS") TO THE SPECIFIED BIT
C>   BOUNDARY (IPADB).  (NOTE: IT'S THE NUMBER OF BITS PADDED HERE THAT
C>   WAS PACKED IN BITS IBIT+1 THROUGH IBIT+8 - THIS IS ACTUALLY A
C>   DELAYED REPLICATION FACTOR).  IPADB MUST BE A MULTIPLE OF EIGHT AND
C>   REPRESENTS THE BIT BOUNDARY ON WHICH THE PACKED SUBSET IN IBAY
C>   SHOULD END AFTER PADDING.  FOR EXAMPLE, IF IPABD IS "8", THEN THE
C>   NUMBER OF BITS IN IBAY ACTUALLY CONSUMED BY PACKED DATA (INCLUDING
C>   THE PADDING) WILL BE A MULTIPLE OF EIGHT.  IF IPADB IS "16", IT
C>   WILL BE A MULTIPLE OF SIXTEEN.  IN EITHER (OR ANY) CASE, THIS
C>   ENSURES THAT THE PACKED SUBSET WILL ALWAYS END ON A FULL BYTE
C>   BOUNDARY.
C>
C> PROGRAM HISTORY LOG:
C> 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C> 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C>                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C>                           ROUTINE "BORT"
C> 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C>                           INTERDEPENDENCIES
C> 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C>                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C>                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C>                           TERMINATES ABNORMALLY
C>
C> USAGE:    CALL PAD (IBAY, IBIT, IBYT, IPADB)
C>   INPUT ARGUMENT LIST:
C>     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY NOT YET PADDED
C>     IBIT     - INTEGER: BIT POINTER WITHIN IBAY TO START PADDING FROM
C>     IPADB    - INTEGER: BIT BOUNDARY TO PAD TO (MUST BE A MULTIPLE OF
C>                8)
C>
C>   OUTPUT ARGUMENT LIST:
C>     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY NOW PADDED
C>     IBIT     - INTEGER: NUMBER OF BITS WITHIN IBAY CONTAINING PACKED
C>                DATA (INCLUDING PADDING, MUST BE A MULTIPLE OF 8)
C>     IBYT     - INTEGER: NUMBER OF BYTES WITHIN IBAY CONTAINING PACKED
C>                DATA (INCLUDING PADDING) (I.E., IBIT/8)
C>
C> REMARKS:
C>    THIS ROUTINE CALLS:        BORT     PKB
C>    THIS ROUTINE IS CALLED BY: MSGUPD
C>                               Normally not called by any application
C>                               programs.
C>
      SUBROUTINE PAD(IBAY,IBIT,IBYT,IPADB)



      CHARACTER*128 BORT_STR
      DIMENSION     IBAY(*)

C----------------------------------------------------------------------
C----------------------------------------------------------------------

C  PAD THE SUBSET TO AN IPADB BIT BOUNDARY
C  ----------------------------------------

      IPAD = IPADB - MOD(IBIT+8,IPADB)
c  .... First pack the # of bits being padded (this is a delayed
c  .... replication factor)
      CALL PKB(IPAD,8,IBAY,IBIT)
c  .... Now pad with zeroes to the byte boundary
      CALL PKB(0,IPAD,IBAY,IBIT)
      IBYT = IBIT/8

      IF(MOD(IBIT,IPADB).NE.0) GOTO 900
      IF(MOD(IBIT,8    ).NE.0) GOTO 901

C  EXITS
C  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PAD - THE INPUT BIT BOUNDARY TO PAD '//
     . 'TO (",I8,") IS NOT A MULTIPLE OF 8")') IPADB
      CALL BORT(BORT_STR)
901   WRITE(BORT_STR,'("BUFRLIB: PAD - THE NUMBER OF BITS IN A PACKED'//
     . ' SUBSET AFTER PADDING (",I8,") IS NOT A MULTIPLE OF 8")') IBIT
      CALL BORT(BORT_STR)
      END
