C> @file
C> @author WOOLLEN @date 1994-01-06
      
C> THIS SUBROUTINE SEARCHES CONSECUTIVE SUBSET BUFFER SEGMENTS
C>   FOR AN ELEMENT IDENTIFIED IN THE USER STRING AS A CONDITIONAL NODE
C>   (I.E. AN ELEMENT WHICH MUST MEET A CONDITION IN ORDER TO BE READ
C>   FROM OR WRITTEN TO A DATA SUBSET).  IF A CONDITIONAL ELEMENT IS
C>   FOUND AND IT CONFORMS TO THE CONDITION, THEN THE INTERNAL SUBSET
C>   BUFFER INDICES OF THE "WINDOW" (SEE BELOW REMARKS) ARE RETURNED TO
C>   THE CALLER FOR PROCESSING.
C> 
C>   THE FOUR CONDITIONS WHICH CAN BE EXERCISED ARE:
C>   '<' - LESS THAN
C>   '>' - GREATER THAN
C>   '=' - EQUAL 
C>   '!' - NOT EQUAL
C>
C>   EACH CONDITION IN A STRING IS APPLIED TO ONE ELEMENT, AND ALL
C>   CONDITIONS ARE 'AND'ED TO EVALUATE AN OUTCOME. FOR EXAMPLE, IF THE
C>   CONDITION STRING IS: "POB<500 TOB>30 TQM<4" THEN THE ONLY LEVELS OF
C>   DATA READ OR WRITTEN ARE THOSE WITH PRESSURE LT 500 MB, TEMPERATURE
C>   GT 30 DEG, AND TEMPERATURE QUALITY MARK < 4.
C>
C> PROGRAM HISTORY LOG:
C> 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C> 1998-07-08  J. WOOLLEN -- IMPROVED MACHINE PORTABILITY
C> 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
C>                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
C>                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
C>                           BUFR FILES UNDER THE MPI)
C> 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C>                           INTERDEPENDENCIES
C> 2003-11-04  D. KEYSER  -- MAXJL (MAXIMUM NUMBER OF JUMP/LINK ENTRIES)
C>                           INCREASED FROM 15000 TO 16000 (WAS IN
C>                           VERIFICATION VERSION); UNIFIED/PORTABLE FOR
C>                           WRF; ADDED DOCUMENTATION (INCLUDING
C>                           HISTORY) 
C> 2010-04-27  J. WOOLLEN -- CORRECT LOGICAL FLAW AND ADD DOCUMENTATION
C> 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C>
C> USAGE:    CALL CONWIN (LUN, INC1, INC2)
C>   INPUT ARGUMENT LIST:
C>     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
C>     INC1     - INTEGER: SUBSET BUFFER START INDEX 
C>     INC2     - INTEGER: SUBSET BUFFER ENDING INDEX
C>
C>   OUTPUT ARGUMENT LIST:
C>     INC1     - INTEGER: SUBSET BUFFER START INDEX 
C>     INC2     - INTEGER: SUBSET BUFFER ENDING INDEX 
C>
C> REMARKS:
C>
C>    SEE THE DOCBLOCK IN BUFR ARCHIVE LIBRARY SUBROUTINE GETWIN FOR AN
C>    EXPLANATION OF "WINDOWS" WITHIN THE CONTEXT OF A BUFR DATA SUBSET.
C>	
C>    FUNCTION CONWIN WORKS WITH FUNCTION INVCON TO IDENTIFY SUBSET
C>    BUFFER SEGMENTS WHICH CONFORM TO THE SET OF CONDITIONS.  
C>
C>    THIS ROUTINE CALLS:        GETWIN   INVCON
C>    THIS ROUTINE IS CALLED BY: UFBEVN   UFBIN3   UFBRW
C>                               Normally not called by any application
C>                               programs.
C>
      SUBROUTINE CONWIN(LUN,INC1,INC2)

      USE MODA_USRINT

      COMMON /USRSTR/ NNOD,NCON,NODS(20),NODC(10),IVLS(10),KONS(10)

C----------------------------------------------------------------------
C----------------------------------------------------------------------

C  SPECIAL CASE
C  ------------

      IF(NCON.EQ.0) THEN
c  .... There are no condition nodes in the string
         INC1 = 1
         INC2 = NVAL(LUN)
         GOTO 100
      ENDIF

C  EVALUATE CONDITIONS TO SEE IF ANY MORE CASES
C  --------------------------------------------

15    CALL GETWIN(NODC(1),LUN,INC1,INC2)
      IF(INC1.GT.0) THEN
         DO NC=1,NCON
           ICON = INVCON(NC,LUN,INC1,INC2)
           IF(ICON.EQ.0) GOTO 15
         ENDDO
      ENDIF

C  EXIT
C  ----

100   RETURN
      END
