C> @file
C> @brief Specify location for logging of error and diagnostic
C> messages.

C> This subroutine allows the user to specify a custom location for
C> the logging of error and diagnostic messages generated by the
C> BUFRLIB software.
C>
C> <p>By default, all such messages are printed to standard output.
C> However, if a user would like to direct such messages elsewhere,
C> this can be done by providing an inline version of this subroutine,
C> using the same calling sequence shown below, in order to override
C> the default version of this subroutine contained within the BUFRLIB
C> distribution package. The user does not need to explicitly call
C> this subroutine from within the application code, since the BUFRLIB
C> software automatically issues an internal call to errwrt when needed.
C> Instead, the user simply needs to define his or her own version of
C> this subroutine with the same name and calling sequence and include
C> it within the compilation, and then the input string STR can be
C> logged or handled in any way of the user's choosing.
C>
C> @author J. Ator
C> @date 2009-04-21
C>
C> @param[in] STR  -- character*(*): Error message or other diagnostic
C>                    to be printed to standard output (default) or
C>                    to another location (if specified via an inline
C>                    replacement version of this subroutine)
C>
C> @remarks
C> - The amount and types of diagnostic messages generated for
C> logging can be controlled via a separate call to subroutine
C> openbf() with IO = 'QUIET'.
C>
C> <b>Program history log:</b>
C> | Date | Programmer | Comments |
C> | -----|------------|----------|
C> | 2009-04-21 | J. Ator    | Original author |
C> | 2012-11-15 | D. Keyser  | Use formatted print |
C>
      SUBROUTINE ERRWRT(STR)

      CHARACTER*(*) STR

      PRINT'(1X,A)',STR

      RETURN
      END
