C> @file
C> @author WOOLLEN @date 1994-01-06
      
C> THIS SUBROUTINE UNPACKS AND RETURNS A CHARACTER STRING OF
C>   LENGTH NCHR CONTAINED WITHIN NCHR BYTES OF IBAY, STARTING WITH BIT
C>   (IBIT+1).  ON OUTPUT, IBIT IS UPDATED TO POINT TO THE LAST BIT THAT
C>   WAS UNPACKED.  NOTE THAT THE STRING TO BE UNPACKED DOES NOT
C>   NECESSARILY NEED TO BE ALIGNED ON A BYTE BOUNDARY WITHIN IBAY.
C>
C> PROGRAM HISTORY LOG:
C> 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C> 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
C> 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C>                           INTERDEPENDENCIES
C> 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
C>                           DOCUMENTATION
C> 2009-03-23  J. ATOR    -- TREAT NULL CHARACTERS AS BLANKS;
C>                           PREVENT OVERFLOW OF CHR
C> 2014-11-19  J. ATOR    -- ADD CNVNULL ARGUMENT
C>
C> USAGE:    CALL UPC (CHR, NCHR, IBAY, IBIT, CNVNULL)
C>   INPUT ARGUMENT LIST:
C>     NCHR     - INTEGER: NUMBER OF BYTES OF IBAY WITHIN WHICH TO
C>                UNPACK CHR (I,E, THE NUMBER OF CHARACTERS IN CHR)
C>     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING PACKED
C>                CHR
C>     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING BIT AFTER
C>                WHICH TO START UNPACKING
C>     CNVNULL  - LOGICAL: .TRUE. IF NULL CHARACTERS SHOULD BE
C>                CONVERTED TO BLANKS
C>
C>   OUTPUT ARGUMENT LIST:
C>     CHR      - CHARACTER*(*): UNPACKED CHARACTER STRING OF LENGTH
C>                NCHR
C>     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING LAST BIT
C>                THAT WAS UNPACKED
C>
C> REMARKS:
C>    THIS SUBROUTINE IS THE INVERSE OF BUFR ARCHIVE LIBRARY ROUTINE
C>    PKC.
C>
C>    THIS ROUTINE CALLS:        IPKM     IUPM     UPB
C>    THIS ROUTINE IS CALLED BY: RDCMPS   RDTREE   READLC   STBFDX
C>                               STNDRD   UFBGET   UFBTAB   UFBTAM
C>                               WRCMPS   
C>                               Normally not called by any application
C>                               programs.
C>
      SUBROUTINE UPC(CHR,NCHR,IBAY,IBIT,CNVNULL)



      COMMON /CHARAC/ IASCII,IATOE(0:255),IETOA(0:255)
      COMMON /HRDWRD/ NBYTW,NBITW,IORD(8)

      CHARACTER*(*) CHR
      CHARACTER*8   CVAL
      DIMENSION     IBAY(*),IVAL(2)
      EQUIVALENCE   (CVAL,IVAL)

      LOGICAL CNVNULL

C----------------------------------------------------------------------
C----------------------------------------------------------------------

      LB = IORD(NBYTW)
      CVAL = ' '

      NUMCHR = MIN(NCHR,LEN(CHR))
      DO I=1,NUMCHR
        CALL UPB(IVAL(1),8,IBAY,IBIT)
        IF((IVAL(1).EQ.0).AND.(CNVNULL)) THEN
          CHR(I:I) = ' '
        ELSE 
          CHR(I:I) = CVAL(LB:LB)
        ENDIF
        IF(IASCII.EQ.0) CALL IPKM(CHR(I:I),1,IATOE(IUPM(CHR(I:I),8)))
      ENDDO

      RETURN
      END
