       LOGICAL FUNCTION IW3MAT(L1, L2, N)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C FUNCTION: IW3MAT           TEST FOR MATCH TWO INTEGER ARRAYS
C   AUTHOR: STACKPOLE. J.D.  ORG: W342       DATE: 86-01-13
C
C ABSTACT: TEST N WORDS STARTING AT L1, L2 FOR EQUALITY, RETURN .TRUE.
C     IF ALL EQUAL; OTHERWISE .FALSE.
C
C PROGRAM HISTORY LOG:
C   86-01-13  J.D.STACKPOLE
C   90-03-15  R.E.JONES       CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:  II = IW3MAT(L1,L2,N)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     L1     ARG LIST  INTEGER ARRAY TO MATCH WITH L2
C     L2     ARG LIST  INTEGER ARRAY TO MATCH WITH L1
C     N      ARG LIST  NUMBER OF INTEGER WORDS TO TEST FOR MATCH
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     IW3MAT FUNCTION  LOGICAL .TRUE. IF L1 AND L2 MATCH ON ALL WORDS,
C                      LOGICAL .FALSE. IF NOT MATCH ON ANY WORD
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/864, CRAY Y-MP EL@/256
C
C$$$
C
       INTEGER L1(*)
       INTEGER L2(*)
C
          IW3MAT = .TRUE.
          DO 10 I = 1,N
            IF (L1(I).NE.L2(I))  GO TO 20
   10     CONTINUE
          RETURN
C
   20     CONTINUE
          IW3MAT = .FALSE.
          RETURN
          END
