      SUBROUTINE W3AI19(LINE, L, NBLK, N, NEXT)
C$$$  SUBPROGRAM DOCUMENTATION  BLOCK
C                .      .    .                                       .   
C SUBPROGRAM:    W3AI19      LINE BLOCKER SUBROUTINE
C   PRGMMR: BOB HOLLERN        ORG: NCO/NP12      DATE: 97-04-15
C
C ABSTRACT: FILLS A RECORD BLOCK WITH LOGICAL RECORDS OR LINES
C   OF INFORMATION.
C
C PROGRAM HISTORY LOG:
C   74-02-01  BOB ALLARD, AUTHOR
C   90-09-15  R.E.JONES   CONVERT FROM IBM370 ASSEMBLER TO MICROSOFT
C                         FORTRAN 5.0 
C   90-10-07  R.E.JONES   CONVERT TO SUN FORTRAN 1.3    
C   91-07-20  R.E.JONES   CONVERT TO SiliconGraphics 3.3 FORTRAN 77   
C   93-03-29  R.E.JONES   ADD SAVE STATEMENT
C   94-04-22  R.E.JONES   ADD XMOVEX AND XSTORE TO MOVE AND
C                         STORE CHARACTER DATA FASTER ON THE CRAY
C   97-04-15  Bob Hollern CORRECTED THE PROBLEM OF INIIALIZING NBLK
C                         TO @'S INSTEAD OF BLANKS
C
C USAGE: CALL W3AI19 (LINE, L, NBLK, N, NEXT)
C   INPUT ARGUMENT LIST:
C     LINE       - ARRAY ADDRESS OF LOGICAL RECORD TO BE BLOCKED
C     L          - NUMBER OF CHARACTERS IN LINE TO BE BLOCKED
C     N          - MAXIMUM CHARACTER SIZE OF NBLK
C     NEXT       - FLAG, INITIALIZED TO 0
C
C   OUTPUT ARGUMENT LIST:
C     NBLK       - BLOCK FILLED WITH LOGICAL RECORDS
C     NEXT       - CHARACTER COUNT, ERROR INDICATOR
C
C   EXIT STATES:
C     NEXT = -1  LINE WILL NOT FIT INTO REMAINDER OF BLOCK;
C                OTHERWISE, NEXT IS SET TO (NEXT + L)
C     NEXT = -2  N IS ZERO OR LESS
C     NEXT = -3  L IS ZERO OR LESS
C
C   EXTERNAL REFERENCES: XMOVEX XSTORE
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916-128, CRAY Y-MP8/864, CRAY Y-MP EL2/256
C
C$$$
C
C METHOD:
C
C     THE USER MUST SET NEXT = 0 EACH TIME NBLK IS TO BE FILLED WITH
C LOGICAL RECORDS.
C
C     W3AI19 WILL THEN MOVE THE LINE OF INFORMATION INTO NBLK, STORE
C BLANK CHARACTERS IN THE REMAINDER OF THE BLOCK, AND SET NEXT = NEXT
C + L.
C
C     EACH TIME W3AI19 IS ENTERED, ONE LINE IS BLOCKED AND NEXT INCRE-
C MENTED UNTIL A LINE WILL NOT FIT THE REMAINDER OF THE BLOCK.  THEN
C W3AI19 WILL SET NEXT = -1 AS A FLAG FOR THE USER TO DISPOSE OF THE
C BLOCK.  THE USER SHOULD BE AWARE THAT THE LAST LOGICAL RECORD WAS NOT
C BLOCKED.
C
         INTEGER       L
         INTEGER       N
         INTEGER       NEXT
         INTEGER(8)       WBLANK
C
         CHARACTER * 1 LINE(*)
         CHARACTER * 1 NBLK(*)
         CHARACTER * 1 BLANK
C
         SAVE
C
         DATA  WBLANK/Z'2020202020202020'/
C   
C TEST VALUE OF NEXT.
C
         IF (NEXT.LT.0) THEN 
           RETURN
C
C TEST N FOR ZERO OR LESS       
C
         ELSE IF (N.LE.0) THEN
           NEXT = -2
           RETURN
C
C TEST L FOR ZERO OR LESS       
C
         ELSE IF (L.LE.0) THEN
           NEXT = -3
           RETURN
C
C TEST TO SEE IF LINE WILL FIT IN BLOCK.
C        
         ELSE IF ((L + NEXT).GT.N) THEN
           NEXT = -1
           RETURN
C
C FILL BLOCK WITH BLANK CHARACTERS IF NEXT EQUAL ZERO.
C BLANK IS EBCDIC BLANK, 40 HEX, OR 64 DECIMAL
C
         ELSE IF (NEXT.EQ.0) THEN
           CALL W3FI01(LW)
           IWORDS = N / LW
           CALL XSTORE(NBLK,WBLANK,IWORDS)
           IF (MOD(N,LW).NE.0) THEN
             NWORDS = IWORDS * LW
             IBYTES = N - NWORDS
             DO I = 1,IBYTES
               NBLK(NWORDS+I) = CHAR(32)
             END DO
           END IF
         END IF 
C
C MOVE LINE INTO BLOCK.
C
C        DO 20 I = 1,L
C          NBLK(I + NEXT) = LINE(I)
C20      CONTINUE
         CALL XMOVEX(NBLK(NEXT+1),LINE,L)
C
C ADJUST VALUE OF NEXT.
C
        NEXT = NEXT + L
C
        RETURN           
C
        END
