       SUBROUTINE W3FC06(DIR,SPD,U,V)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FC06         WIND DIR AND SPD TO EARTH U,V COMPONENTS
C   AUTHOR: STACKPOLE        ORG: W324       DATE: 81-12-30
C
C ABSTRACT: GIVEN THE WIND DIRECTION AND SPEED,
C   COMPUTE EARTH-ORIENTED (TRUE) WIND COMPONENTS.
C   INPUT DIRECTION AT THE POLE POINT
C   MUST BE CONSISTENT WITH WMO CONVENTIONS, AND OUTPUT COMPONENTS
C   WILL FOLLOW THOSE CONVENTIONS.
C   (SEE OFFICE NOTE 241 FOR WMO DEFINITION.)
C
C PROGRAM HISTORY LOG:
C   81-12-30  J.STACKPOLE
C   91-03-06  R.E.JONES    CHANGE TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FC06 (DIR, SPD, U, V)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     DIR  -  REAL*4  -  WIND DIRECTION, DEGREES
C     SPD  -  REAL*4  -  WIND SPEED, ANY UNITS
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     U    -  REAL*4  -  EARTH-ORIENTED U-COMPONENT
C     V    -  REAL*4  -  EARTH-ORIENTED V-COMPONENT
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     SIN COS                                                 SYSTEM
C
C WARNING: THIS CODE WILL NOT VECTORIZE ON CRAY, YOU COULD
C          PUT THE FOUR LINES IN YOUR CODE WITH A COUPLE OF
C          DO LOOPS.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916-128, Y-MP8/864, Y-MP EL92/256
C
C$$$
C
         XSPD = -SPD
         DIRL = 0.0174533 * DIR
         U    = XSPD * SIN(DIRL)
         V    = XSPD * COS(DIRL)
C
      RETURN
      END
